
#declare StoneH = seed(234);
#declare StoneW = seed(432);
#declare pigTex = seed(1111);

#macro seedStonesHhWwDT(H,h,W,w,D,T)

#declare StoneHeightMax = H;
#declare StoneWidthMax  = W;
#declare StoneHeightMin = h;
#declare StoneWidthMin  = w;
#declare StoneDepth  = D;  
#declare StoneTex = T

#end
    
    
#macro DrawStone(CurrentHeight,MaxHeight)

#declare H = StoneHeightMin + rand(StoneH)*(StoneHeightMax - StoneHeightMin);  
#declare W = StoneWidthMin  + rand(StoneW)*(StoneWidthMax  - StoneWidthMin);

#if (CurrentHeight + H > MaxHeight)
  #declare H = MaxHeight - CurrentHeight;
#end

object
{
  superellipsoid{<0.25,0.25>}
  translate<1,1,1>
  scale<W/2,H/2,StoneDepth/2>   
  #declare XX = 1000*rand(pigTex);
  translate XX*x                        
  texture{StoneTex}
  translate -XX*x
  translate CurrentHeight*y              
  #declare CurrentHeight = CurrentHeight + H;      
}

#end 

#macro WallUpTo(topH)

#declare CurrentHeight = 0;
union
{
  #while (CurrentHeight < topH) 
    DrawStone(CurrentHeight, topH)
  #end
}
#end                                        

#declare windowH = 90;
#declare windowW = 20;
#declare slitW   = 1.3;
#declare holeR   = 2;     
#declare slitR = 1
#declare dentH = 10;
#declare dentW = 6;

#macro windowDiff()
object
{
  superellipsoid{<0.1,0.25>}
  translate<1,1,0>
  scale <windowW/2-.2, windowH/2-.3, 200>
}
#end

#macro window()
object
{
  difference
  {
    object
    {
      superellipsoid{<0.1,0.25>}
      translate<1,1,1>
      scale <windowW/2, windowH/2, 10> 
    }
    union
    {
      box{ < (windowW - slitW)/2, dentH, -40> < (windowW + slitW)/2, windowH - dentH, 40> }
      cylinder{ < windowW/2, dentH, 0> < windowW/2, windowH - dentH, 0>, 2*slitR }
      cylinder{  < windowW/2, dentH, -40> < windowW/2, dentH, 40> holeR }      
      sphere{  < windowW/2, dentH, 0> 2*holeR }      
      sphere{  < windowW/2, windowH - dentH, 0> 2*holeR }      
      cylinder{  < windowW/2, windowH - dentH, -40> < windowW/2, windowH - dentH, 40> holeR }
      box{ < dentW,(windowH - slitW)/2 , -40> < windowW -dentW, (windowH + slitW)/2, 40> }
      cylinder{  < dentW, windowH/2, 0> < windowW-dentW, windowH/2, 0> 2*slitR }      
      cylinder{  <dentW,windowH/2 ,-40>  <dentW,windowH/2 , 40> holeR }      
      cylinder{  <windowW-dentW,windowH/2 ,-40>  <windowW-dentW,windowH/2 , 40> holeR }      
      sphere{  < dentW, windowH/2, 0> 2*holeR }      
      sphere{  < windowW-dentW, windowH/2, 0> 2*holeR }      
    }
  } 
  texture{StoneTex}
}
#end  