//Ruin.inc by Johnny Yip  Sept-Oct 2001
//Ruin.inc contains all the "destroyed" elements
//Light posts, telephone posts, rock-like stuff, things that stick out

#include "texture.inc"

//----------- Light post variables ----------------//
#declare LP_Height = 20;
#declare LP_Radius = 0.4;
#declare LP_Cone_H = 1;
#declare LP_Cone_R = 0.2;
#declare LP_rod_R = LP_Cone_R;
#declare LP_rod_up = 1;
#declare LP_rod_out = 1.2; 
#declare LP_break_1 = <0,LP_Height+LP_Cone_H+LP_rod_up-0.3,LP_rod_out>;  //first break point in the rod
#declare LP_rod_out2 = LP_break_1 + <0.7,-0.5,0.8>;
#declare LP_rod_out3 = LP_rod_out2 + <0.2,0.2,1>;
#declare confid = 2;    //for the light holder ~ for the intersection stuff
#declare LH_Scale = 0.7;        //light holder scale
#declare LC_Scale = 0.55;        //light cover scale

#declare light_holder = difference {
    intersection {
       sphere { <confid,0,0>, 3 }
       sphere { <-confid,0,0>, 3 }
       sphere { <0,0,confid>, 3 }
       sphere { <0,0,-confid>, 3 }
       scale <1,0.6,1.5>
    }       
    box {<10,0,10>,<-10,-10,-10> }
    box {<10,5,10>,<-10,1,-10> }
    material { MIron_Bar }
}

#declare light_post = union {
  union {
  //Main Pole
  cylinder { <0,0,0>, <0,LP_Height,0>, LP_Radius }
  //Connector
  cone { <0,LP_Height,0>, LP_Radius <0,LP_Height+LP_Cone_H,0>, LP_Cone_R }
  //stick
  union {
    cylinder { <0,LP_Height+LP_Cone_H,0,>,<0,LP_Height+LP_Cone_H+LP_rod_up,0>, LP_rod_R}
    sphere { <0,LP_Height+LP_Cone_H+LP_rod_up,0>, LP_rod_R }
    cylinder { <0,LP_Height+LP_Cone_H+LP_rod_up,0>, LP_break_1, LP_rod_R}
    sphere { LP_break_1, LP_rod_R }
    cylinder { LP_break_1, LP_rod_out2, LP_rod_R}
    sphere { LP_rod_out2, LP_rod_R }
    cylinder { LP_rod_out2, LP_rod_out3, LP_rod_R}
    sphere { LP_rod_out3, LP_rod_R }
  }
  material { MIron_Bar }
  }
  //Light h0lder
  object { light_holder
    scale LH_Scale
    rotate <60,120,40>
    rotate <0,90,0>
    translate <0.4,-0.2,0.7>                 //obj's center
    translate LP_rod_out3
  }
  //Light cover
  object { light_holder
    scale LC_Scale
    rotate 180*z                                  //Opposite to light holder
    rotate <60,120,40>
    rotate <0,90,0>
    translate <0.4,-0.2,0.7>                 //obj's center
    translate LP_rod_out3
  }
}

//--------------------- Telephone posts ----------------------//
//Variables
#declare TP_height = 12;
#declare TP_radius = 0.5;
#declare TP_Hanger_L = 5.5;               //length
#declare TP_Hanger_R = 0.3;             //Radius
#declare TP_Hanger_Y = TP_height-3;
#declare TP_WireBox = 0.7;                //Radius
#declare TP_WB_H = 1.5;                 //Height
#declare TTP = texture { pigment { color rgb 1 }}

#declare Sus_Radius = 0.2;
#declare Sus_Radius2 = 0.1;

#declare Suspender = union {
  torus { Sus_Radius, Sus_Radius2 translate (1*Sus_Radius2)*y}
  torus { Sus_Radius, Sus_Radius2 translate (3*Sus_Radius2)*y}
  torus { Sus_Radius, Sus_Radius2 translate (5*Sus_Radius2)*y}
  torus { Sus_Radius, Sus_Radius2 translate (7*Sus_Radius2)*y}
  material { MIron_Bar }
}

#declare telephone_post = union {
  //Main Pole
  cylinder { <0,0,0>, <0,TP_height,0>, TP_radius }
  //Hangers
  cylinder { <(TP_Hanger_L/2)-0.5,TP_Hanger_Y,TP_radius+TP_Hanger_R>, 
             <-TP_Hanger_L/2,TP_Hanger_Y,TP_radius+TP_Hanger_R>, TP_Hanger_R }
  //This one is broken
  cylinder { <(TP_Hanger_L/2),TP_Hanger_Y,-TP_radius-TP_Hanger_R>,
             <-(TP_Hanger_L/2)+1.3,TP_Hanger_Y,-TP_radius-TP_Hanger_R>, TP_Hanger_R }
  //Wire Box
  cylinder { <0,TP_Hanger_Y+1,0>, <0,TP_Hanger_Y+1+TP_WB_H,0>, TP_WireBox }
  //Wire suspenders
  object { Suspender translate <(TP_Hanger_L/2)-1,TP_Hanger_Y+TP_Hanger_R,-TP_radius-TP_Hanger_R>}
  object { Suspender translate <(TP_Hanger_L/2)-1,TP_Hanger_Y+TP_Hanger_R,+TP_radius+TP_Hanger_R>}
  object { Suspender translate <-(TP_Hanger_L/2)+1,TP_Hanger_Y+TP_Hanger_R,TP_radius+TP_Hanger_R>}
  material { MIron_Bar }
}

#declare Break_Pt = 5;
#declare Separation = 1;

#declare Damaged_TPost = union {
  object { telephone_post rotate <40,0,0> translate <0,0,TP_radius+Separation>}
  cylinder { <0,0,0>, <0,Break_Pt,0>, TP_radius material { MIron_Bar }}
}

//-------------------- Iron Bars ========================//
//base bar variables
#declare Bar_Width = 0.6;
#declare Iron_Thickness = 0.12;
#declare Bar_Depth = 0.4;
//#declare TIron_Bar = texture { pigment { color rgb <1,0,0> }}

//Basic bar form
#declare Base_Iron_Bar = union {
  //center bar
  box { <Bar_Width/2,0,Iron_Thickness/2>, <-Bar_Width/2,1,-Iron_Thickness/2> }
  //Side bars
  box { <Bar_Width/2,0,Bar_Depth/2>, <(Bar_Width/2)-Iron_Thickness,1,-Bar_Depth/2> }
  box { <-Bar_Width/2,0,Bar_Depth/2>, <(-Bar_Width/2)+Iron_Thickness,1,-Bar_Depth/2> }    
  material { MIron_Bar }
}

#declare Iron_Bar1 = object {
  Base_Iron_Bar
  scale <1,5,1>
}

#declare Wire_Rad = 0.07;
//Array of points
#declare vertnum = 6;
#declare A_W_Pt = array[vertnum] {<0,6,0>, <1,7,0>, <1,9,-1>, <-0.6,10,0>, <-1.5,9.7,0.4>, <-1,9,-0.8>}

#declare Wiring = union {
  #local i = 0;
  #while (i < (vertnum-1))
    cylinder { A_W_Pt[i], A_W_Pt[i+1], Wire_Rad }
    sphere { A_W_Pt[i+1], Wire_Rad }
    #declare i = i + 1;
  #end
  texture { T_Wire }
}

#declare Iron_Bar2 = union {
  object { Base_Iron_Bar scale <1,8,1> }
  object { Base_Iron_Bar scale <1,8,1> rotate <0,90,15> translate <1,-1,-(Bar_Depth/2)-(Bar_Width/2)>}
  object { Wiring translate -6*y rotate 20*x translate <0.3,6,0>}
}


//---------------------- WIRES -----------------------//
#declare Wire_Radius = 0.07;
//Array of points
#declare vertnum = 6;
#declare A_Wire_Pt = array[vertnum] {<0,0,0>, <2,5,-0.5>, <3.2,7,1>, <4,7,1.6>, <3,6,1.8>, <3.5,4.5,0.7>}

#declare Wire1 = union {
  #local i = 0;
  #while (i < (vertnum-1))
    cylinder { A_Wire_Pt[i], A_Wire_Pt[i+1], Wire_Radius }
    sphere { A_Wire_Pt[i+1], Wire_Radius }
    #declare i = i + 1;
  #end
  texture { T_Wire }
}

#declare SS_Radius = 0.1;
#declare SS_P1 = <0,0,0>;
#declare SS_P2 = <1,0,0>;
#declare SS_P3 = <1.8,0.5,0>;
#declare SS_P4 = <2.4,0.3,0.5>;                           
                           
#declare Steel_Support = union {
  cylinder { SS_P1, SS_P2, SS_Radius }
  sphere { SS_P2, SS_Radius }
  cylinder { SS_P2, SS_P3, SS_Radius }
  sphere { SS_P3, SS_Radius }
  cylinder { SS_P3, SS_P4, SS_Radius }
  sphere { SS_P4, SS_Radius }
  texture { T_Wire }
}

#declare Steel_Support2 = cylinder {
  SS_P1, SS_P2, SS_Radius
  texture { T_Wire }
}

#declare Steel_Support3 = union {
  cylinder { SS_P1, SS_P2, SS_Radius }
  sphere { SS_P2, SS_Radius }
  cylinder { SS_P2, SS_P3, SS_Radius }
  texture { T_Wire }
}

//----------------------- Other Posts -----------------//
//Concrete Ruins
#declare Concrete1 = height_field {
    tga "rock3.tga"
    water_level 0.05
    smooth
    material { T_Ruin }
    translate <-0.5,-0.5,-0.5>  
    scale <60,60,60>
    rotate <20,30,40>   // get it into position
}

#declare Concrete2 = height_field {
    tga "rock3.tga"
    water_level 0.05
    smooth
    material { T_Ruin }
    translate <-0.5,-0.5,-0.5>  
    scale <60,90,50>
    rotate <0,45,-30>   // get it into position
    rotate 180*y
}

#declare Ruin1 = height_field {
    tga "ruin1.tga"
    water_level 0.05
    smooth
    material { T_Ruin }
    translate <-0.5,-0.5,-0.5>  
    scale <30,80,30>
    rotate <20,-40,0>   // get it into position
    //rotate 180*y
}

#declare Ruin2 = height_field {
    tga "ruin2.tga"
    water_level 0.05
    smooth
    material { T_Ruin }
    translate <-0.5,-0.5,-0.5>  
    scale <50,30,30>
    rotate <20,0,0>   // get it into position
    //rotate 180*y
}

//Water Blobs (when water hit the concrete piece)
#declare Water_Radius = 0.5;

#declare Water_Blob = blob {
   threshold 0.65
   sphere { <0,0,0>, Water_Radius, 1 }
   sphere { <0.4,0.1,0>, Water_Radius, 1 }
   sphere { <0.6,0.18,0.2>, Water_Radius, 1 scale 1.3}
   sphere { <0.63,0.05,-0.3>, Water_Radius, 1 scale 1.2}
   sphere { <1.4,0.1,0>, Water_Radius, 1 }
   sphere { <1.6,0.0,-0.2>, Water_Radius, 1 }
   sphere { <1.8,0.25,-0.0>, Water_Radius, 1 }
   sphere { <1.9,0.05,0>, Water_Radius, 1 }
   sphere { <-0.4,-0.2,-0.2>, Water_Radius, 1 }
   sphere { <-0.6,0.1,-0.25>, Water_Radius, 1 }
   sphere { <-0.8,0.15,0.0>, Water_Radius, 1 }
   sphere { <-1.0,0,-0.1>, Water_Radius, 1 }
   texture { TWater_Blob }
}
