//Include file for most of the textures / materials used in the scene
//texture.inc by Johnny Yip  Sept-Oct 2001
#version unofficial MegaPov 0.5;

//-------------- Texture for the ruin pieces-----------------//
#declare T_RockBase = texture {
  pigment { color rgb <200/255, 196/255, 186/255> }  //225, 220, 190 or 255, 196, 89 or 236, 168, 20
  normal {
    crackle 1
    turbulence 0.3
    lambda 3                   
    scale <0.6,0.4,0.6>
  }
  finish { 
    ambient 0.4
    diffuse 0.5
    specular 0.03
    roughness 0.05
    crand 0.3
  }
}

#declare T_WetRock = texture {
  pigment { color rgb <84/255, 68/255, 63/255> * 1.2 }   //84, 68, 43 or 63, 60, 50
  normal { 
    bumps 0.7
    turbulence 0.3
    scale <0.5,0.5,0.5>
  }
  finish {
    ambient 0.2
    diffuse 0.7
    specular 0.8
    roughness 0.05
    reflection 0.2
    brilliance 4
    crand 0.2
    irid { 0.2
      thickness 0.5
      turbulence 0.2
    }
  }
}

#declare T_Ruin = material {
    texture { 
      gradient y
      turbulence 0.3
      texture_map {
        [0.0 T_WetRock]
        [0.3 T_WetRock]
        [0.4 T_RockBase]
        [1.0 T_RockBase]
      }
      translate 0.15*y
    }
    interior{
      ior 1.5
//      fade_distance 5
//      fade_power 1
      caustics 1
    }
}

//----------------------- Textures for metal materials -------------//
#declare F_NormMetal = finish {
  ambient 0.2
  diffuse 0.6
  specular 1
  roughness 0.1
  brilliance 5
  metallic
}

#declare T_Rust = texture {
  pigment {
    gradient y
    turbulence 0.1
    color_map {
      [0.0 rgbt <186/255,122/255,0,0.2>]
      [0.05 rgbt <186/255,122/255,0,0.5>]
      [0.3 rgbt 1]
      [1.0 rgbt 1]
    }
  }
  scale <1,2,1>
  translate -0.04*y
}

#declare TIron_Bar = texture {
  pigment { 
    gradient y
    octaves 6
    turbulence 1
    frequency 2
    phase 0.2
    color_map {
      [0.0 rgb <150/255,150/255,150/255>] //57.118.165
      [0.5 rgb <90/255,90/255,90/255>]
      [1.0 rgb <50/255,50/255,50/255>]
    }
    scale <1,5,1>
  }
  normal {
    gradient y
    normal_map {
      [0.0 bumps 0.3 scale 0.1]
      [0.2 wrinkles 0.2 scale 0.1]
      [0.7 bumps 0.1 scale 0.1]
      [1.0 bumps 0.05 scale 0.1]
    }
    scale <1,1.69,1>
  }
  finish { F_NormMetal }
}

#declare MIron_Bar = material {
  texture { TIron_Bar }
  texture { T_Rust }
}

#declare T_Wire = texture { 
  pigment {
    bozo
    turbulence 1.5
    frequency 15
    color_map {
      [0.0 rgb <171/255, 161/255, 146/255>]
      [0.1 rgb <171/255, 161/255, 146/255>]
      [0.15 rgb <160/255, 79/255, 0>]
      [0.3 rgb 0.8]
      [1.0 rgb 0.8]
    }
  }
  finish {
    ambient 0.2
    diffuse 0.5
    specular 0.7
    roughness 0.001
    brilliance 2
    metallic
  }
}

//---------------- Water texture------------------//
#declare TWater = texture {
    pigment { color rgb 1 }
    normal {
      waves
      //ramp_wave            //non, ramp_wave
      turbulence 0.2         //0.3, 1
      frequency 8        //10, 1
      scale <30,1,3>
    }
    normal {
      granite
      turbulence 0.3             
      frequency 2.2
      scale 10
    }
    finish { 
        ambient 0.05
        diffuse 0.1
        specular 0.5   //0.4, 0.38
        roughness 0.06   //0.06
        reflection 0.5      //0.7, 0.6
        metallic
        brilliance 0.2
    }
}

#declare TWater_Blob = texture {
    pigment { color rgb 1 }
    normal {
      bumps
      //bump_size
      //ramp_wave            //non, ramp_wave
      turbulence 0.3         //0.3, 1
      frequency 8        //10, 1
      scale <1,7,1>
    }
    normal {
      granite
      turbulence 0.3             
      frequency 2.2
      scale 1
    }
    finish { 
        ambient 0.5
        diffuse 0.3
        specular 0.05   //0.4, 0.38
        roughness 0.05   //0.06
        reflection 0.15      //0.7, 0.6
        //brilliance 0.1
    }
}

