//water.pov by Johnny Yip  Sept-Oct 2001
//This is the scene with water and ruin pieces
//The rendered image will be used as the texture map for the main scene

#version unofficial MegaPov 0.5;

#include "ruin.inc"
#include "smoke.inc"

/*global_settings {
  assumed_gamma 2.2
  hf_gray_16
}*/

//For the water surface
#declare water_surface = box { <-500,-100,-500>, <500,-100.2,500>
  texture { TWater }
  hollow
}

//Bird eye view (final)
camera {
  location <3,100,-10>         //for smoke
  right <320/200,0,0>
  up <0,200/200,0>  
  look_at <-3,0,0>
}

sky_sphere {
  pigment {
    image_map {
      tga "sky2.tga"
      map_type 0
      interpolate 2
    }
    rotate <50,20,60>   //60,20,60
  }
}

//These light sources have to match the ones in the main scene
light_source { <0,200,10>, <0.5,0.5,0.5> jitter}
light_source { <300,1000,200>, <0.5,0.5,0.5> jitter}

//Not in use
#macro colourFilter (_r, _g, _b)
  plane {y, 90 pigment { color rgbf <_r/255,_g/255,_b/255,1> }}
#end

//colourFilter(100,100,100)

object { water_surface }

//---------------- The following section is for testing mode only --------------//
/*
camera {
  location <0,50,0>// 3d
//  location <0,30,0>     //top
  look_at <0,0,0>
}

//Temporary lights for testing
light_source { <200,100,-100>, 1 jitter}
light_source { <-100,100,100>, 1 jitter}

plane { y, -1 pigment { color rgb 1 }}//checker color rgb 1, color rgb 0 scale 10}}

background { color rgb 1 }
*/
//----------------------- End of test mode =-------------------------/

//-------------All the objects in the scene goes here
//Posts and Stuff
object { telephone_post scale 3 rotate <40,0,-20> translate <-10,-100,-50>}
object { Damaged_TPost scale 2.6 rotate <0,-70,0> translate <58,-100,20>}
object { light_post scale 3 rotate <0,180,15> translate -100*y}         //@ center
object { light_post scale 3 rotate 180*y translate <-75,-130,80>}       //all the way at the top
object { light_post scale 3 rotate <-30,180,0> translate <10,-120,-90>}       //all the way at the bottom
object { light_post scale 3 rotate <20,0,60> translate <120,-115,130>}       //top right corner

//Iron Bar and Steel Structures
object { Wire1 scale 7 rotate <0,-30,0> translate <-36,-100,-60>}       //Left
object { Wire1 scale 5 rotate <0,70,0> translate <65,-100,35>}          //Right
object { Wire1 scale 6 rotate <0,70,0> translate <-100,-100,-40>}          //Most left

object { Iron_Bar1 scale <5,10,5> translate <-48,-100,-56>}               //beside a rock to the leeft
object { Iron_Bar1 scale 5 rotate <60,-50,0> translate <40,-100,-5>}      //near center
object { Iron_Bar1 scale 7 translate <70,-110,0>}      //right
object { Iron_Bar1 scale 7 rotate <20,0,50> translate <100,-110,60>}      //most right
object { Iron_Bar2 scale 5 rotate 45*y translate <30,-100,60>}
object { Iron_Bar2 scale 5 rotate 45*y translate <-50,-120,60>}

//Steel Supports
object { Steel_Support scale 15 rotate 180*y translate <0,-101,70>}     //huge

object { Steel_Support scale 5 rotate <0,150,0> translate <18,-70,17>}
object { Steel_Support2 scale <15,5,5> rotate <0,170,0> translate <13,-65,19>}
object { Steel_Support3 scale 5 rotate <0,150,0> translate <12,-64,18>}

//Concrete Objects
object { Ruin1 translate <-40,-85,-40>}
object { Concrete1 translate <60,-95,-45>}
object { Concrete2 translate <20,-80,30>}
object { Concrete2 scale <1,1.2,0.8> rotate <0,140,30> translate <95,-90,110>}
object { Concrete2 scale 0.8 rotate <0,-40,0> translate <70,-90,135>}
object { Ruin2 translate <-20,-100,120> }

//object { Concrete2 scale <1,1.2,0.8> rotate <0,140,30> translate <100,-90,95>}
//object { Concrete2 scale 0.8 rotate <0,-40,0> translate <75,-90,120>}

//Light fog
object { MediumSmoke translate <-40,30,15>}
//The water "splash"
object {Water_Blob scale <16,8,8> rotate -95*y translate <42,-98,22>}
//------------ End of objects- ---------------------
