/******************************/
/* (c) Martin Depardieu, 2001 */
/* martin.depardieu@fnac.net  */
/* http://pov.martin.free.fr/ */
/******************************/

#include "colors.inc"     
#include "textures.inc"
#include "skies.inc"

#declare bunker =
difference  {
        superellipsoid {
                <.1, .1>
                scale <2, .75, 1>
        }  
        
        superellipsoid {
                <.1, .1>
                scale <2, .75, 1>*.9
        }  
        
        box {
                <-1.75, .25, 0>
                <1.75, .6, -2>
        } 
        
        texture {
                pigment {
                        bozo
                        color_map {
                                [0 rgb .25]
                                [1 rgb .5]
                        }        
                }        
                
                normal {
                        bumps 1
                        scale .5
                }        
        }
}  

#declare mittrailleuse =
union {  
        difference {
                superellipsoid {
                        <.1, .1>
                        scale <1, 1, 2>
                }  
                
                box {
                        <0, .25, 1.5>
                        <-2, .75, -.75>
                } 
        } 
        
        union { 
                difference {
                        cylinder {
                                <0, .5, 0>
                                <0, .5, -10>
                                .25
                        }
                        
                        cylinder {
                                <0, .5, 1>
                                <0, .5, -11>
                                .2
                        }
                        
                        texture {
                                bozo
                                texture_map {
                                        [0 pigment { Black }]
                                        [1 Copper_Metal]
                                }        
                        }
                }
                
                difference {
                        cylinder {
                                <0, .5, 0>
                                <0, .5, -7.5>
                                .4
                        }
                        
                        cylinder {
                                <0, .5, 1>
                                <0, .5, -10>
                                .3
                        } 
                        
                        union {
                                #declare compteur = 0;
                                #while (compteur < 10)
                                        #declare compteur_deux = 0;
                                        #while (compteur_deux < 10)
                                                cylinder {
                                                        <0, 0, 0>
                                                        <0, 5, 0>
                                                        .1
                                                        translate compteur/2*z
                                                        rotate compteur_deux*36*z
                                                }
                                                
                                                #declare compteur_deux = compteur_deux + 1;
                                                #end
                                        
                                        #declare compteur = compteur + 1;
                                #end 
                                
                                translate -7*z
                        }
                } 
                 
                cylinder {
                        <0, 0, 0>
                        <0, 0, -5>
                        .3
                } 
                
                texture {
                        bozo
                        texture_map {
                                [0 Chrome_Metal]
                                [1 Gold_Metal]
                        }        
                } 
        } 
        
        union {
                cylinder {
                        <-.5, -.75, 0>
                        <-.5, -.75, 3>
                        .15
                }
                
                cylinder {
                        <-.5, .75, 0>
                        <-.5, .75, 3>
                        .15
                } 
                
                cylinder {
                        <-.5, -.9, 3>
                        <-.5, .9, 3>
                        .2
                }
                
                cylinder {
                        <.5, -.75, 0>
                        <.5, -.75, 3>
                        .15
                }
                
                cylinder {
                        <.5, .75, 0>
                        <.5, .75, 3>
                        .15
                } 
                
                cylinder {
                        <.5, -.9, 3>
                        <.5, .9, 3>
                        .2
                } 
                
                texture {
                        pigment {
                                rgb .5
                        }
                        
                        finish {
                                phong .5
                        }
                }                               
        } 
        
        union {
                cylinder {
                        <0, 1, 0>
                        <0, 1.5, 0>
                        .1
                } 
                
                torus {
                        .5
                        .1
                        rotate 90*x
                        translate 2*y
                }
                
                cylinder {
                        <-.5, 2, 0>
                        <.5, 2, 0>
                        .1
                } 
                
                cylinder {
                        <0, 1.5, 0>
                        <0, 2.5, 0>
                        .1
                } 
                
                translate <0, -.5, -9>               
        }  
        
        union {
                cylinder {
                        <0, 0, 1>
                        <0, 1.5, 1>
                        .1
                }
                
                sphere {
                        <0, 1.5, 1>
                        .15
                }
        }
        
        cylinder {
                <0, 0, 0>
                <0, -5, 0>
                .25
                texture {
                        pigment {
                                rgb .5
                        }
                        
                        finish {
                                phong .5
                        }
                }
        }                                                                           
        
        texture {
                bozo
                texture_map {
                        [0 Chrome_Metal]
                        [1 Copper_Metal]
                }        
        }                        
}  

#declare barbele =
union { 
        torus {
                .01
                .01
                rotate 90*z
        }
        
        cylinder {
                <0, .01, 0>
                <0, .01, -.05>
                .01
        }
        
        cone {
                <0, .01, -.05>, .01
                <0, .01, -.1>, 0 
        }        
        
        cylinder {
                <0, -.01, 0>
                <0, -.01, .05>
                .01
        }
        
        cone {
                <0, -.01, .05>, .01
                <0, -.01, .10>, 0 
        } 
}

#declare anneau =
union {
        #declare demi_anneau_1 =
        union {
                intersection {
                        torus {
                                1
                                .01
                                rotate 90*x
                        }
                        
                        box {
                                <-10, -10, -10>
                                <0, 10, 10>
                        }
                }
                
                union {
                        #declare compteur = 0;
                        #while (compteur < 16)
                                object {
                                        barbele 
                                        translate 1*y         
                                        rotate compteur*10*y
                                        rotate compteur*10*z
                                }
                                
                                #declare compteur = compteur + 1;
                        #end
                        
                        rotate 5*z
                }                        
                
                rotate 30*x
        } 
        
        #declare demi_anneau_2 =
        object {
                demi_anneau_1
                rotate 180*y
        }        
        
        object {
                demi_anneau_1
        }
        
        object {
                demi_anneau_2
                translate -1*z
        } 
        
        texture {
                bozo
                texture_map {
                        [0 Chrome_Metal]
                        [0.75 Copper_Metal]
                        [0.9 pigment { rgb .5 }]   
                        [1 pigment { Black }]
                }        
        } 
}

#macro barbeles (nombre_d_anneau)
        #declare compteur = 0;
        #while (compteur < nombre_d_anneau)
                object {
                        anneau
                        translate -2*compteur*z
                } 
                
                #declare compteur = compteur + 1;
        #end        
#end

#declare fils =
union {
        cylinder {
                <-10, 0, 0>
                <10, 0, 0>
                .01
        }
        
        union {
                #declare compteur = 0;
                #while (compteur < 100)
                        object {
                                barbele
                                translate compteur/5*x
                                rotate compteur*3.6*x 
                        }
                        
                        #declare compteur = compteur + 1;
                #end
                
                translate -10*x
        }               
                                
        texture {
                bozo
                texture_map {
                        [0 Chrome_Metal]
                        [0.75 Copper_Metal]
                        [0.9 pigment { rgb .5 }]   
                        [1 pigment { Black }]
                }        
        } 
}

#macro fils_barbeles(nombre_de_fils)  
        #declare compteur = 0;
        #while (compteur < nombre_de_fils)
                object {
                        fils
                        translate 20*compteur*x
                }
                
                #declare compteur = compteur + 1;
        #end
#end

#declare poteau =
difference {
        box {
                <-1, 1, -1>
                <1, 7.5, 1>
        } 
        
        box {
                <-1, -1, -1>
                <1, 7.5, 1> 
                rotate -2.5*x
                translate -1.25*z
        }
        
        box {
                <-1, -1, -1>
                <1, 7.5, 1> 
                rotate 2.5*x
                translate 1.25*z
        } 
        
        box {
                <-1, -1, -1>
                <1, 7.5, 1> 
                rotate 2.5*z
                translate -1.25*x
        }     
        
        box {
                <-1, -1, -1>
                <1, 7.5, 1>
                rotate -2.5*z
                translate 1.25*x
        }          
        
        texture {
                pigment {
                        bozo
                        color_map {
                                [0 rgb <255, 128, 0>/255]
                                [1 rgb <128, 64, 0>/255]
                        }        
                }
        }
        
        normal {
                bumps 1
        }                                
}

#declare bouteille =
union { 
        difference {
                sor {
                        11,
                        <0, 0>,
                        <3.5, 0>,
                        <3.5, 5>,
                        <3, 8>,
                        <3.5, 15>,
                        <1.5, 20>,
                        <1.5, 21>,
                        <2, 21.5>,
                        <1.75, 21.75>,
                        <1.5, 22>,
                        <0, 22>
                }  
                
                sor {
                        11,
                        <0, 0>,
                        <3.5, 0>,
                        <3.5, 5>,
                        <3, 8>,
                        <3.5, 15>,
                        <1, 20>,
                        <1, 21>,
                        <2, 21.5>,
                        <1.75, 21.75>,
                        <1.5, 22>,
                        <0, 22>
                        
                        scale .95
                        translate 1*y
                }
                
                cylinder {
                        <0, 5, 0>
                        <0, 25, 0>
                        1
                }        
        }       
                
        sor {
                4,
                <3.5, 3>,
                <3, 8>,
                <3.5, 12>,
                <3.5, 12>
                texture {
                        pigment {
                                image_map {
                                        tga "cocucolu"
                                } 
                                
                                scale 10
                                translate -4.1*y       
                        } 
                        
                        finish {
                                phong 1
                        }        
                }                
        }        
        
        texture {
                Glass      
        }
        
        scale .5
} 

#declare canon_fusil =
union {
        difference {
                cylinder {
                        <0, 0, 0>
                        <0, 0, 10>
                        .2
                }
                
                cylinder {
                        <0, 0, -1>
                        <0, 0, 11>
                        .15
                }
                
                texture {
                        bozo
                        texture_map {
                                [0 Chrome_Metal]
                                [1 Gold_Metal]
                        }        
                }
        }  
        
        cylinder {
                <0, -.25, 0>
                <0, -.25, 7.5>
                .35
        }   
        
        sphere {
                <0, -.25, 7.5>
                .35
        }   
        
        box {
                <-.05, 0, 9>
                <.05, .5, 9.5>
                texture {
                        bozo
                        texture_map {
                                [0 Chrome_Metal]
                                [1 Gold_Metal]
                        }        
                }
        }                  
        
        texture {   
                pigment{
                        DMFWood4
                }
        }
} 

#declare piaf =
union {
        sphere {
                <0, 0, -.25>
                1
                scale <.5, .5, 2>
        } 
        
        box {
                <-.1, 0, -.75>
                <.1, 2.5, .5>
                rotate 30*z
        } 
        
        box {
                <-.1, 0, -.75>
                <.1, 2.5, .5>
                rotate -30*z
        }
        
        triangle {
                <0, 2.5, -.75>
                <0, 5, -.5>
                <0, 2.5, .5>
                translate -2.5*y
                rotate 45*z
                translate 2.5*y
                rotate 30*z
        } 
        
        triangle {
                <0, 2.5, -.75>
                <0, 5, -.5>
                <0, 2.5, .5>
                translate -2.5*y
                rotate -45*z 
                translate 2.5*y
                rotate -30*z
        } 
        
        cylinder { 
                <0, 0, -2>
                <0, .5, -2.5>
                .2
        } 
        
        sphere {
                <0, 1.5, -1.75>
                .5
                scale <.5, .5, 1.5>
        } 
        
        triangle {
                <-.25, 0, 0> 
                <0, 3, 0>
                <.25, 0, 0>
                rotate -90*x
                scale 2
                translate <0, 0, 3>
        }                              
                              
        texture {
                pigment {
                        rgb .5
                }
        }
}

#declare lune =
sphere {
        <0, 0, 0>
        5
        texture {
                pigment {
                        leopard
                        color_map {
                                [0 rgb .75*5]
                                [1 rgb .25*5]
                        }
                }
        }
}