/******************************/
/* (c) Martin Depardieu, 2001 */
/* martin.depardieu@fnac.net  */
/* http://pov.martin.free.fr/ */
/******************************/

#include "war.inc"
  
global_settings {
        radiosity {
                count 500
        }
}                  
   
camera {
        location <-200, 60, -100>
        look_at <-200, 75, 0>
}

light_source {
        <0, 0, 0>
        color rgb <.8, .8, 1>
        area_light
        <-.25, 0, -.25> <.25, 0, .25>
        5, 5              
        adaptive 0          
        jitter  
        rotate -20*x
        rotate -45*y            
        translate <-100, 200, -200>   
}

sky_sphere {
        S_Cloud1
}          

object {  
        height_field {
                tga "Heightfield.tga"
                smooth
        }
        
        scale <100, 7.5, 100>*10
        translate <-50, -2.5, -50>*10
        
        texture {
                pigment {
                        bozo
                        color_map {
                                [0 rgb <.25, 1, .25>*.75] 
                                [.1 rgb <255, 128, 0>/255]
                                [1 rgb <128, 64, 0>/255]
                        }        
                }  
                
                scale 50
        }
        
        normal {
                bumps 1
                scale 10
        }                        
}  

object {  
        height_field {
                tga "Heightfield.tga"
                smooth
        }
        
        scale <100, 7.5, 200>*10
        translate <-50, -2.5, -50>*10
        
        texture {
                pigment {
                        bozo
                        color_map {
                                [0 rgb <.25, 1, .25>*.75] 
                                [.1 rgb <255, 128, 0>/255]
                                [1 rgb <128, 64, 0>/255]
                        }        
                }  
                
                scale 50
        }
        
        normal {
                bumps 1
                scale 10
        } 
        
        rotate 7.5*x
        translate <285, 0, 1000>                       
} 
            
fog {
        color rgbft .5
        distance 200
        turbulence .5  
}  
 
union {
        object {
                bunker
                scale 100
                translate <-410, 50, 500>
        }
        
        object {
                mittrailleuse
                scale 10
                rotate -30*y
                translate <-300, 90, 450>
        } 
        
        object {
                mittrailleuse
                scale 10
                rotate 35*y
                translate <-450, 90, 450>
        }
}                
  
union {
        union {
                barbeles (100)      
                scale 20
                rotate 90*y
                translate <0, 50, 10>
        }  
        
        union {
                barbeles (100)      
                scale 20
                rotate 85*y
                translate <21, 55, 7.5>
        }
        
        union {
                barbeles (100)      
                scale 20
                rotate 95*y
                translate <-10, 60, 5>
        }         
}
  
union { 
        union { 
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 50, 500>
                }
                
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 60, 500>
                } 
                
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 70, 500>
                }  
                
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 80, 500>
                }  
                
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 90, 500>
                }  
                
                union {
                        fils_barbeles(12) 
                        scale 20
                        translate <0, 100, 500>
                }
        }        
          
        union { 
                #declare compteur = 0;
                #while (compteur < 20)
                        object {
                                poteau 
                                scale <8, 11, 8>
                                translate <compteur*100, 25, 500>
                        }   
                        
                        #declare compteur = compteur + 1;
                #end 
                
                translate -200*x       
        }  
        
        translate <-40, 50, 225> 
}        
  
object {
        bouteille
        scale 2 
        rotate -30*z
        rotate -10*y
        translate <-170, 35, -10>
}  

object {
        canon_fusil
        scale 10
        rotate -30*x
        rotate -30*y   
        translate <-125, 7.5, 100>
}          
   
union {
        object {
                piaf
                scale 10
                translate <-300, 300, 500>
        } 
        
        object {
                piaf
                scale 10
                translate <-350, 250, 500>
        }
        
        object {
                piaf
                scale 10
                translate <-325, 350, 500>
        } 
        
        translate <-100, 50, 0>
}                                  
   
object {
        lune
        scale 25
        translate <750, 1250, 2000>
}           