#version unofficial megapov 0.7;

#include "cross.inc"
#include "text.inc"

#declare CROSS_FINAL=0;
#declare LIGHT_FINAL=0;
#declare TEXT_FINAL=1;

#declare stone_int=
interior {
  ior 20
  fade_power 2
  fade_distance .02
  media {
    scattering{ 
      1, rgb 3
    }
    method 3
  }
}

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
}

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgb <.3,1,.3>*.5
    }
    finish {
      reflection 0
    }
  }
}

difference {
  object {
    crossmarker
    rotate <-90, 0, 0>
  }
  /*
  text {
    ttf "/usr/local/share/fonts/truetype/timesbd.ttf",
      "QUENTIN ROOSEVELT", 1, 0
    align_center
    scale <.15, .15, .2>
    translate <0,0,-.6>
    translate <0,2.3,0>
  }
  */

#if(TEXT_FINAL)
  union {
    object {
      line[1][0]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.32,0>
    }
    object {
      line[1][1]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.24,0>
    }
    object {
      line[1][2]
      scale .08
      translate <0, 0, -.5001>
      translate <0,2.14,0>
    }
  }
#end

  texture {
    pigment {
      granite
      scale <1,4,1>
      rotate <0,0,-40>
      color_map {
#if (CROSS_FINAL)
  #local filt=.5;
  #local dimm=1;
#else
  #local filt=0;
  #local dimm=.7;
#end
	[0, rgbf <.7, .8, .8, filt>*dimm]
	[.5, rgbf <1, 1, .8, filt>*dimm]
	[1, rgbf <1, 1, 1, filt>*dimm]
      }
    }
    finish {
      reflection 0
    }
    normal {
      granite
      scale .05
      bump_size .05
    }
  }
  hollow
#if (CROSS_FINAL)
  interior {
    stone_int
  }
#end



  rotate <0, -35, 0>
}

  light_source {
    <-30, 30, -30>
    color rgb <1, 1, .8>*2
#if (LIGHT_FINAL)
    area_light <0,0,-1>, <0,1,0>, 4, 4
#end
  }

camera
{
  location <0, 5, -50>
  look_at  <0, 2, 0>
  angle 3
}

