#version unofficial megapov 0.7;

#declare CROSS_FINAL=0;
#declare LIGHT_FINAL=0;
#declare TEXT_FINAL=0;

#declare SUNSET_FINAL=0;
#declare SKY_FINAL=0;

#declare GRASS_FINAL=0;

#declare TREE_FINAL=0;

#declare BRIGHT_SHINY_WATER=0;

// Sampling media in the radiosity calculations is *really slow*.  To get
// a "good enough" effect, we can save the radiosity with the fake 2D sky,
// then reuse it with the real one instead of sampling radiosity again.
#declare REUSE_RAD=0;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 1
//    normal on
//    media on

#if (REUSE_RAD)
    load_file "normandy2.rad"
    always_sample no
#else
//    save_file "normandy2.rad"
#end
  }
  max_trace_level 6
}

// Fake blue light, because I couldn't get the radiosity to work out
// quite the way I wanted
light_source {
  <0, 300, -600>
  color rgb <.1,.1,.3>*1.5
  shadowless
}

// Povray's mod is BROKEN!
#macro modulus (num, lim)
  #while (num < 0)
    #local num=num+lim;
  #end
  #while (num >= lim)
    #local num=num-lim;
  #end
  num
#end

#include "cross-final.inc"
#include "sky-final.inc"
#include "tree-final.inc"
#if (GRASS_FINAL)
  #include "grass-customized.inc"
#end

#include "concrete.inc"

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
#if (GRASS_FINAL)
      color rgb <.3,.2,0>
#else
      color rgb <.3,1,.3>*.5
#end
    }
    finish {
      reflection 0
    }
  }
}

#local GR=seed(2);
#local xi=-8*20;
#while (xi<200)
  #local zi=0;
  #while (zi<300)

    // Put text only on the close ones - it's unreadable farther
    #if ((zi<=20) & (xi < 50) )
      #local tn=modulus((xi/8)+(zi/5),5);
      #local shape=0; // can't engrave stars of david
    #else
      #local tn=-1;
      #local shape=(rand(GR) > .9);
    #end

    // and put in a few manual stars of david in prominent locations
    #if ((xi=16) & (zi=30))
      #local shape=1;
    #end

    // Skip a couple of rows to leave space for the walk
    // also skip inside the reflectin gpool
    #if (((zi < 15) | (zi > 25)) & !((xi<0)&(zi<=20+20)))
      makecross(<xi+rand(GR)/4,-rand(GR)/6,zi>,
	<0, -5+10*rand(GR), 0>, tn, shape)
    #end

    #local zi=zi+10;
  #end
  #local xi=xi+8;
#end

// Now put in the concrete blocks.  The gap is from z=10 to z=30
#local blockh=2/12;
#local xi=-1*3;
#while (xi <= 120)
  block(2.9,2.8,<xi,blockh,17>,concrete)
  block(2.9,2.8,<xi,blockh,20>,concrete)
  block(2.9,2.8,<xi,blockh,23>,concrete)
  #local xi=xi+3;
#end
// and some around the pool
#local zi=20-5*3;
#while (zi <= 20+5*3)
  block(2.9,2.8,<-2*3,blockh,zi>,concrete)
  #local zi=zi+3;
#end
// and one in the corner
  block(2.9,2.8,<-3*3,blockh,20+5*3>,concrete)

// reflecting pool:
difference {
  box { <-100, -1, 20-4*3-1.5>, <-2*3-1.5, 1, 20+4*3+1.5> }
  box { <-100, .3, 20-4*3-1>, <-2*3-1.5-1, 1.5, 20+4*3+1>}

  texture { concrete }
//  texture { pigment { color rgb <1,0,0>} }
}

// and water in it:
box {
  <-100, 0, 20-4*3-1>, <-2*3-1.5-1, .7, 20+4*3+1>
  texture {
    pigment {
      color rgbt <1,1,1,1>
    }
    finish {
      reflection_type 1
      reflection_min .1
#if (BRIGHT_SHINY_WATER)
      reflection_max 2
#else
      reflection_max 1
#end
      reflection_falloff 2
    }
    normal {
      ripples
      scale 4
      turbulence .5
      slope_map {
	[0, <0,0>]
	[.5, <1,0>]
	[1, <0,0>]
      }
    }
  }
  interior {
    fade_distance 1
    fade_power 1000
    ior 1.3
  }
}


// the grass:

#if (GRASS_FINAL)
  #local xdim=8;
  #local zdim=10;
  #declare gp=grasspatch_mowed(xdim,zdim)
  #local xi=-80;
  #while (xi<80)
    #local zi=-20;
    #while (zi<500)
      object {
	gp
	translate <xi,0,zi>
      }
      #local zi=zi+zdim;
    #end
    #local xi=xi+xdim;
  #end
#end

// The trees:
#local mx=-500;
#while (mx < 700)
  #local mz=500;
  #while (mz<1500)
    object {
      #if (rand(GR) < .5)
	talltree[rand(GR)*numtalltree]
      #else
	shorttree[rand(GR)*numshorttree]
      #end
      rotate <0,360*rand(GR),0>
      pigment {
	color rgb <.3, .2, 0>
      }
/*
#if (rand(GR) > .9)
      scale 3
#else
      scale 2
#end
*/
      translate <mx+50*rand(GR), 0, mz+50*rand(GR)>
    }
    #local mz=mz+60;
  #end
  #local mx=mx+40;
#end

// Now lights for the non-sky:
#declare L2 = <-3000, 600, -500>;
#declare L2size = 300;
light_source {
  L2-<L2size/2, 0, L2size/2>
  color rgb <1, 1, .6>*2
#if (LIGHT_FINAL)
  area_light <L2size, 0, 0>, <0, 0, L2size>, 8, 8
#end
  adaptive 0
}
// and we need something to block that light from the clouds
box {
  L2-<L2size, -.01, L2size>,
  L2+<L2size, 1, L2size>
}

fog {
  fog_type 2
  fog_offset 3
  fog_alt 3
  distance 100
//  color rgb <.08,.05,.1>
//  color rgb <.05,.04,.06>
  color rgbt <.08,.07,.09,.1>
}

/*
plane {
  <0,1,0>, 100
  hollow
  pigment {color transmit 1}
  interior {
    media {
      scattering {
	4, rgb <1,1,1>/1000
      }
      method 2
    }
  }
}
*/

camera
{
  up <0,1,0>
  right <2,0,0>
  location <-2.8, 2.8, -2>
//  location <-2.8, 8, -2>
  look_at  <10, 2.8, 40>
//  look_at  <10, 0, 0>
//  angle 30
}

// vi:sts=2
