#version unofficial megapov 0.7;

/*
#declare SKY_FINAL=0;
#declare SUNSET=1;
*/

// These are the clouds already out of the sun - they're just dark
plane {
  < 0, -1, 0>, -2001
  hollow
  texture {
    pigment {
      spotted
      scale 2000
      turbulence .6
      omega .7
      pigment_map{
	[0 rgb <.1 .1 .6>]
	[.4 rgb <.1 .1 .6>]
	[1 rgb <.3 .3 .5>]
      }
    }
    finish {
      ambient 3
      diffuse 0
    }
  }
  no_shadow
}

#if (SUNSET_FINAL=1)
intersection {
  plane { < 0, -1, 0>, -1000}
  plane { < 0, 1, 0>, 2000}

  hollow
  texture {
    pigment {
      color rgbf <1, 1, 1, 1>
    }
  }

  interior {
    media {
      scattering {
      // If you make this too low, you won't get the desired
      // effect of back layers of clouds being darker.  However, if you
      // make it too *high*, you have the problem of unacceptable graininess.
      // try 300 to 1000 as the divisor
	2 rgb <1, 1, 1>/500
      }
#if (SKY_FINAL)
	method 3
	samples 5,20
/*
	method 3
	samples 5

	aa_level 3
	aa_threshold .3
*/
#else
	method 1
#end
      density {
	spotted
	turbulence .3
	omega .7
	scale 500
	density_map {
	  // Due to the "noise bug fix", these values are slightly
	  // different in the unofficial version.  Use .6 and .8 in the
	  // official version to get about the same result.
	  [0, rgb 0]
	  [.55, rgb 0]
	  [.75, rgb .6]
	  [1, rgb .6]
	}
      }
    }
  }
}
#else
plane {
  < 0, -1, 0>, -1500
  clipped_by
  {
    plane { <0, 0, -1>, 0 }
  }
  hollow
  texture {
    pigment {
      spotted
      turbulence .3
      omega .7
      scale 500
      color_map {
	[0, rgbt <0,0,0,1>]
	[.35, rgbt <0,0,0,1>]
	[.55, rgbt <.6,.6,.6,.5>]
	[1, rgbt <.6,.6,.6,0>]
      }
    }
  }
}
#end

//fake light, sky only
light_source {
  <3000, 1000, -20>
  color rgb <1, 1, 1>*.2
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, 1, 0>, 0 }
  }
  texture {
    pigment {
      color rgb 0
    }
  }
  hollow
  translate <3000, 1000, -20>
}

#declare L1 = <-3000, 610, -500>;

// sun - sky only, because we need an area light for the ground
light_source {
  L1
#if (SUNSET_FINAL)
  color rgb <1, 1, 1>*2
#else
  color rgb <1, 1, 1>*15
#end
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, 1, 0>, 0 }
  }
  texture {
    pigment {
//      color rgbf <1,1,0,1>
      color rgbf <0,0,0,1>
    }
  }
  hollow
  translate L1
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, -1, 0>, 0 }
  }
  texture {
    pigment {
      radial
      color_map {
	[0 rgbf <1 1 0 1>]
	[.5 rgbf <1 1 0 1>]
	[.5 rgbf <1 1 0 1>]
	// Adjust these to shift the yellow/red line
	[.71 rgbf <1 1 0 1>]
	[.91 rgbf <1 0 0 1>]
	[1 rgbf <1 0 0 1>]
      }
    }
  }
  hollow
  translate L1
}
