#version unofficial megapov 0.7;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
}

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgb <0, .4, .2>
    }
    finish {
      reflection 0
    }
  }
}

#declare TREE_FINAL=1;

#include "tree-final.inc"

#declare FAR=1;

#if (FAR)
  #local GR=seed(5);
  #local mx=-300;
  #while (mx < 300)
    #local mz=180;
    #while (mz < 800)
      object {
	#if (rand(GR)< .5)
	  talltree[rand(GR)*numtalltree]
	#else
	  shorttree[rand(GR)*numshorttree]
	#end
	rotate <0, 360*rand(GR), 0>
	pigment {
	  color rgb <.3 .2 0>
	}
	translate <mx+50*rand(GR), 0, mz+50*rand(GR)>
      }
      #local mz=mz+30;
    #end
    #local mx=mx+20;
  #end

#else

  object {
    talltree[0]
    pigment {
      color rgb <.3 .2 0>
    }
    scale .3
    translate <15, 0, 0>
  }

  object {
    shorttree[0]
    pigment {
      color rgb <.3 .2 0>
    }
    scale .3
  }

  object {
    talltree[1]
    pigment {
      color rgb <.3 .2 0>
    }
    scale .3
    translate <-15, 0, 0>
  }

#end

light_source {
  <-300, 300, -300>
  color rgb <1, 1, .8>*2
}

camera
{
  location <0, 8, -30>
  look_at  <0, 8, 0>
//  angle 2
}

