// master passion and warfare pov file
// Persistence of Vision Ray Tracer Scene Description File
// File: master.pov
// Vers: 3.1
// Desc: Passion and Warfare for warfare round of IRTC
// Date: October 2001
// Auth: James Taylor
// Email james@jamestaylor.fsworld.co.uk

#declare brain_on = 1;
#declare fire_on = 1;

#declare fourthird = 4.0/3.0;

// default settings used as template from a Moray -> POV file
// hence the odd camera and up definition.

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }   
}     

background { color <0.000,0.000,0.000> }

#declare cube_pos = 3.0;

camera {  //  Camera StdCam
  location  <      0.000,      -12,       2.0> 
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      3.5/2,       0.000,       0.000>
}
       
       
//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  //translate  <0.0, -20.0, 20.0> 
  translate <10,-10,10>
}  

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <cube_pos, 2, -.5>
} 

light_source
{
        0*x
        color rgb<1,1,1>
        translate <cube_pos,0,-2.5>
}

light_source
{       0*x
        color rgb<1,1,1>
        translate <cube_pos/2,0,-.5>
        }



//
// ********  MATERIALS  *******
//

#include "c:\my documents\war\materials.inc"


//
// ********  REFERENCED OBJECTS  *******
//
#include "c:\my documents\war\heart.inc" 

#if (brain_on = 1)
        #include "c:\my documents\war\brain.inc"  
#end

#if (fire_on = 1)
        #include "c:\my documents\war\fake_the_fire.inc"
#end
                
//
// ********  OBJECTS  *******
//  

//-----------------------------------------
// write include file for bubbles
//----------------------------------------
#declare bubble = object {
        sphere { <0,0,0>, 0.5 scale <1,2,1> material {Water} } 
        }
        
#declare N = 500;               //Number of bubbles
#declare size = 0.03;             //bubble size 
#declare size_turb = 0.03;       //buble size turbulence
#declare cube_size = 1.95;

#declare i = 1;
#declare R = seed(2342);
#declare R1 = seed(34234) ;


#if (size_turb > size) 
        #declare size_turn = size;
#end 

#fopen bub_file "bubble.inc" write

#write (bub_file,"//bubble include file",
                "\n#declare bubbles = object { union {")
 #while (i <= N)  
        #declare x1 = rand(R);
        #declare y1 = rand(R);
        #declare z1 = rand(R);  
        #declare s = rand(R1);
        
        #declare s = size - (s * size_turb);         
        
        #write (bub_file,"\nobject { bubble", 
                " scale ",<s,s,s>, 
                " translate", cube_size*<x1,y1,z1>, 
                " translate", cube_size*<-0.5,-0.5,-0.5> ,"}")
        
        #declare i = i + 1;  
 #end 
#write (bub_file,"\n} }") 
#fclose bub_file
//---------------------------------------fire
#if (fire_on = 1)
        object {fire rotate <90,-90,0> translate <1.8,0,0> scale <1,1,1,> no_shadow } 
#end

//---------------------------------------heart          
object { heart material {
                 red_heart 
                 //Nice_wood
                }
                 }
//-----------------------------barb_wire
#declare barb =      // one barb sticking up
  cone {
    <0.0, 0, 0>, 0.05    // Center and radius of one end
    <0.0, 0.3, 0 >, 0.0    // Center and radius of other end
  }


#declare link =         //steel cable
  union {
    cylinder {
      <0,0,0>,
      <1,0,0>, 0.05
      pigment { colour rgb <0.4,0.4,0.4> }
      normal {                                    //fake the twisted wire
        spiral1 6
        scallop_wave
        rotate y*90
        scale <0.5,1,1>
      }
    }
    object { barb rotate z*35 }
    object { barb rotate z*35 rotate x*180 }
    object { barb rotate z*-35 rotate x*90 }
    object { barb rotate z*-35 rotate x*270 }

    sphere { <0,0,0>,0.05 }
    sphere { <1,0,0>,0.05 }
    cone {
      <0.0, 0, 0>, 0.05    // Center and radius of one end
      <0.0, 0.3, 0 >, 0.0    // Center and radius of other end
    }

    pigment { colour rgb <0.4,0.4,0.4> }


    finish {
      phong 0.9
      phong_size 60
      metallic
    }

  }  
  
#declare link_length = 0.3;             //float, the link scaling factor, default=0.1
#declare link_rotation = 90;             //float, the degrees to rotate each link, default=90
#declare link_error = 0.01;              //float, error allowed in itteration, default=0.01
#declare chain_start = <-1.5,0,0 >;      //vector, one anchor point, default=<-1,1,0>
#declare chain_end = <1.5,0,0>;          //vector, the other anchor point, default=<1,1,0>
#declare chain_scale = 1;                 //float, controls the chain tension default=1
#declare chain_debug = 0;                 //boolean, turns on/off endpoint markers, default=off
#declare chain_type =  1;                 //int, 1=parabola or 2=catenary, default 1 *for now     


#declare wire = object {union {#include "chain11.inc" } no_shadow}    


object {wire rotate <180,0,0> }
object {wire rotate <0,0,0> } 

object {wire rotate <180,10,0> translate <-0.25,0.25,0> }
object {wire rotate <0,10,0> translate <-0.25,0.25,0> }

object {wire rotate <180,-25,0> }
object {wire rotate <0,-25,0> }   

object {wire rotate <180,15,0> translate <0,0,-0.5> scale 0.8}
object {wire rotate <0,15,0> translate <0,0,-0.5> scale 0.8}

//-------------------------------------------------ice cube

#include "bubble.inc"
#include "ice_cube.inc"   
#declare ice_cube = object { 
difference {
  object {ice}
  object {bubbles}

 }
}
  
//#declare j = 1.01;

object {ice_cube translate <cube_pos,0,-.5> material {Water} scale 4.0/3.0
        //bounded_by { box { <-j,-j,-j>,<j,j,j> translate <cube_pos,0,-0.5>} }
        }       
//------------------------------------brain 
#if (brain_on = 1)
#declare brain = object {
        union  {
        object{ P_cereb }
        object{ P_corpus }
        object{ P_frontal }
        object{ P_occipit }
        object{ P_pariet }
        object{ P_pitua }
        object{ P_stem }
        object{ P_temp }  
        } 
        } 
        
object {brain   
        //scale 0.25*fourthird; 
        scale 1.0/3.0
        rotate <0.870386, 4.92385, -79.962593>
        translate  -0.4*z 
        translate <cube_pos*fourthird,0,-.5>
        material {brainy_pink}  } 
#end

  



