// Reticulating splines...                                                      
#macro flag(rotation, xloc, yloc, zloc)
union {
    bicubic_patch {                            
        type 1
        u_steps 2
        v_steps 2
        flatness 0.01
        <0, 0.336,  0.0>, <0.18,  0.300, -0.0>, <0.30, 0.250, -0.1>,  <0.34, 0.200,  -0.3>, 
        <0, 0.224, -0.1>, <0.20,  0.224,  0.0>, <0.39, 0.200, -0.0>,  <0.44, 0.150,  -0.1>,
        <0, 0.112, -0.1>, <0.22,  0.112, -0.1>, <0.40, 0.100,  0.0>,  <0.55, 0.070, -0.0>,
        <0, 0.000,  0.0>, <0.22,  0.000, -0.1>, <0.43, -0.050, -0.1>,  <0.58, -0.150,  0.0>
        texture {     
            // Ugh - how to get this to map onto a bent flag shape?
            pigment {
                image_map {
                    gif "USFlag640.gif" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                    map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                    interpolate 1     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                    //once           // for no repetitive tiling
                } // image_map
                  
                scale <0.64, 0.336, 1.0>  
            } // pigment 
        } // texture                      
    }
    cylinder {
        <0,  -0.620, 0>,
        <0,   0.336, 0>,
        0.01
        texture { pigment { rgb <0.5, 1.0, 0.5> } }
    }             
    cylinder {
        <0, 0.336, 0>,
        <0, 0.350, 0>,
        0.03
        texture { pigment { rgb <0.5, 1.0, 0.5> } } 
    }
    cone { 
        <0, 0.350, 0>, 
        0.03, 
        <0, 0.400, 0>, 
        0.0 
        texture { pigment { rgb <0.5, 1.0, 0.5> } } 
    }          
    rotate <0, 0, rotation>
    translate <xloc + 0, yloc + 0.6, zloc + 0>
    
}
#end

/* This is something of an improvement w.r.t droopiness:
        <0, 0.336,  0.0>, <0.18,  0.300, -0.0>, <0.30, 0.250, -0.1>,  <0.34, 0.200,  -0.3>, 
        <0, 0.224, -0.1>, <0.20,  0.224,  0.0>, <0.39, 0.200, -0.0>,  <0.44, 0.150,  -0.1>,
        <0, 0.112, -0.1>, <0.22,  0.112, -0.1>, <0.40, 0.112,  0.0>,  <0.55, 0.100, -0.0>,
        <0, 0.000,  0.0>, <0.22,  0.000, -0.1>, <0.43, 0.000, -0.1>,  <0.64, 0.000,  0.0>
*/
