// Persistence of Vision Ray Tracer Scene Description File
// File: gplane.pov
// Vers: 3.1
// Desc: Experimenting with grass-colored planes.
// Date: 
// Auth: Martin Presler-Marshall


/**********************************************************************
 * Includes
 *
 **********************************************************************/
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "woods.inc"   

/**********************************************************************
 * Textures
 *
 **********************************************************************/
#declare T_Concrete =
texture {
    pigment {
        quilted
        turbulence 0.5
        frequency 6
        scale 0.25
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.75, 0.75, 0.75, 0.0> ]
            [0.10 color rgbf <0.90, 0.90, 0.90, 0.0> ]
            [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
        }
    } 
    normal {  
        bumps 0.15 
        scale 0.01
    }
}                    

// Colors for the grass texture
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted = pigment {
    spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0   color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen = pigment{Green2*1.3}
#declare txtGrass = texture {                  
    pigment {
        gradient y
        turbulence 0.2
            pigment_map {                                
                [0.0 pigEarth]
                [0.3 pigGreen]
                [0.9 pigSpotted]
                [1.0 pigEarth]
            }
        }
        finish { 
            ambient 0.01 
            diffuse 0.7 
            specular 0.2 
            roughness 0.015
        }
        scale <0.001,1,0.001> // Why is this scaled so small? Try it with a bigger scale. 
} 


/**********************************************************************
 * Camera
 *
 **********************************************************************/
// set viewer's position in the scene
camera {
    location  <0.0,  3.0, -10.0> // position of camera <X Y Z>
    look_at   <0.0,  1.0,  0.0> // point center of view at this point <X Y Z>
}

/**********************************************************************
 * Lights
 *
 **********************************************************************/
light_source {
  <10, 40, -10>               // Position
  color rgb <2, 2, 2>  // light's color
  area_light
  <4, 0, 0> <0, 4, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light        
  circular
  parallel
}


// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane {
    <0, 1, 0>, // <X Y Z> unit surface normal, vector points "away from surface"
    0.0 // distance from the origin in the direction of the surface normal
    //texture {txtGrass scale 1000}
    texture { pigment { rgb <0.3, 1.0, 0.6>}}
}    

// flat circular FINITE (no CSG) shape, center hole cutout is optional
disc {
  <0, 8, 0>  // center position
  <0, 1, 0>, // normal vector
  5.0,       // outer radius
  0.0        // optional hole radius    
    texture {
        pigment {
            bozo
            turbulence 2.0 
            octaves 6
            omega 0.7
            lambda 2.0
            color_map {
                [0.0 0.1 color rgb <0.60, 0.60, 0.60> color rgb <0.55, 0.60, 0.55>]
                [0.1 0.3 color rgb <0.55, 0.60, 0.55> color rgb <0.50, 0.50, 0.50>]
                [0.3 0.4 color rgb <0.50, 0.50, 0.50>      color rgbt <1, 1, 1, 1>]
                [0.4 1.0 color rgbt <1, 1, 1, 1>      color rgbt <1, 1, 1, 1>]

            }                                                                       
            scale 5.0
        }        
    }
}
               
/*
plane {
    <0.1, 1.0, 0.0>,
    8.0
    //texture { pigment { rgbt <0.4, 0.4, 1.0, 0.5>}}
    texture {
        pigment {
            bozo
            turbulence 2.0 
            octaves 6
            omega 0.7
            lambda 2.0
            color_map {
                [0.0 0.1 color rgb <0.60, 0.60, 0.60> color rgb <0.55, 0.60, 0.55>]
                [0.1 0.3 color rgb <0.55, 0.60, 0.55> color rgb <0.50, 0.50, 0.50>]
                [0.3 0.4 color rgb <0.50, 0.50, 0.50>      color rgbt <1, 1, 1, 1>]
                [0.4 1.0 color rgbt <1, 1, 1, 1>      color rgbt <1, 1, 1, 1>]

            }                                                                       
            scale 5.0
        }        
    }             
    hollow
    
}
 */       
