// Persistence of Vision Ray Tracer Scene Description File
// File: tombs.pov
// Vers: 3.1
// Desc: Let this be your last battlefield...
// Date: 
// Auth: Martin Presler-Marshall
// To do:
// 1) Get some real names  
// 2) Shadow from trees
// 3) Get camera and look_at set correctly.
// 4) Put in fewer leaves of grass, and put a flat textured plane under them all.
//    That gives a "row" effect to the grass. Can I randomize the centerpoints of the grass 
//    blobs in a "prarie"?
// 5) How about creating several grass patches, and randomly selecting one each time a patch
//    of grass is called for?



/**********************************************************************
 * Includes
 *
 **********************************************************************/
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones.inc"
#include "woods.inc"   
#include "tombdef.pov"
#include "flagdef.pov"
#include "shapes.inc"

// Configuration; turn off certain features for better appearance.
#declare LabelTombs    = true; 
#declare IncludeTombs  = true;   
#declare TexturedEarth = true;               

/**********************************************************************
 * Textures
 *
 **********************************************************************/
#declare T_Concrete =
texture {
    pigment {
        quilted
        turbulence 0.5
        frequency 6
        scale 0.25
        rotate <0, -45, 30>
        color_map {
            [0.02 color rgbf <0.75, 0.75, 0.75, 0.0> ]
            [0.10 color rgbf <0.90, 0.90, 0.90, 0.0> ]
            [1.00 color rgbf <0.85, 0.85, 0.85, 0.0> ]
        }
    } 
    normal {  
        bumps 0.15 
        scale 0.01
    }
}                    

// Colors for the grass texture
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
#declare Green1=rgb<0.4,1,0.3>*0.4;
#declare Green2=rgb<60,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted = pigment {
    spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0   color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen = pigment{Green2*1.3}
#declare txtGrass = texture {                  
    pigment {
        gradient y
        turbulence 0.2
            pigment_map {                                
                [0.0 pigEarth]
                [0.3 pigGreen]
                [0.9 pigSpotted]
                [1.0 pigEarth]
            }
        }
        finish { 
            ambient 0.01 
            diffuse 0.7 
            specular 0.2 
            roughness 0.015
        }
        scale <0.001,1,0.001> 
} 


/**********************************************************************
 * Camera
 *
 **********************************************************************/
// set viewer's position in the scene
camera {
    location  <0.0,  2.0, -4.0> // position of camera <X Y Z>
    look_at   <0.0,  1.0,  0.0> // point center of view at this point <X Y Z>
}

/**********************************************************************
 * Lights
 *
 **********************************************************************/
// The sun
light_source {
  <100, 200, -150>               // Position
  color rgb <2, 2, 2>  // light's color
  area_light
  <5, 0, 0> <0, 5, 0> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light        
  circular
  parallel
}       


/**********************************************************************
 * The ground. This is put even if there's grass, as there's got to be 
 * something under the grass, right?
 *
 **********************************************************************/
plane {
    <0, 1, 0>, 
    0.0 
    texture { pigment { Green}}
}

        
                       
#declare RowOffsetX = 4;                       
#declare RowOffsetZ = 8;              

#declare StartX = 0;
#declare StartY = 0;
#declare StartZ = 0;

// First row                                                         
    Headstone(1, 0.2,               0, 0, (RowOffsetZ * 0), "Pvt. Alan Greinwald", "3rd Armored Inf. Div.", "1979 - 2001", T_Muslim)
/*
    difference {
        cylinder {
            <0, 0, 0>
            <0, 0, -Standout>
            0.25
        }
        cylinder { 
            <0.125, 0, 0.001>
            <0.125, 0, -(Standout + 0.001)>
            0.25
        }
        translate <StartX, StartY + HeadstoneHeight + 0.05, StartZ>
        texture { pigment { Blue}}
    }
 */
/*
    polygon {
        3,
        <-0.10, 0.05>, <0.00, 0.25>, <0.10, 0.05> //, <-0.10, 0.05>
        texture { pigment { Red}}
    }                                                           
    polygon {
        3,
        <-0.07, 0.07>, <0.00, 0.22>, <0.07, 0.07> //, <-0.07, 0.08>
        texture { pigment { Blue}}
    }
*/
/*    
    difference {        
    polygon {
        4,
        <-0.10, 0.20>, <0.00, 0.00>, <0.10, 0.20>, <-0.10, 0.20>
    }                                                           
    polygon {
        4,
        <-0.07, 0.17>, <0.03, 0.03>, <0.07, 0.17>, <-0.07, 0.17>
    }
    }        
  */
    //texture { T_Concrete}       
    //scale 2.5
//} 
 

