
#local RenderThisFile = 0; // change to 1 to test render this file only


// POV-Ray Object File - Building 1
// created 8-Oct-01
// last update 30-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "Building1.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "PackardCar2.inc", "BattleDebris.inc"
//
// Objects:
// SBuilding1 // simple version
// Building1 // detailed version
// Building1Group
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
 

#if (RenderThisFile = 1)
	#version 3.5; // uncomment for testing only
	#include "GIncludeRH.inc" // uncomment for testing only
	#include "Shapes.inc" // uncomment for testing only
	#declare HeadlampOn = 0; // uncomment for testing only
//	#include "PackardCar2.inc" // uncomment for testing only
	#include "BattleDebris.inc" // uncomment for testing only
#end

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare StuccoTex =
	texture {
		pigment { rgb<1,1,1> }
		normal { granite 0.3 scale <2.2,2.2,2.4> turbulence 0.1 }
		finish { ambient .1 }
	}
#declare ChimneyTex =
	texture {
		pigment { rgb<1,1,1> }
		normal { bumps 0.2 scale 1.0 turbulence 0.1 }
		finish { ambient .1 }
	}

#declare BrickWallTex =
	texture {
		pigment {
			brick
			rgb<.8,.2,.2>
			rgb<.4,.4,.4>
			brick_size <12,4,4>
			mortar 0.4
			rotate x*90 // align to wall
			translate <0,1,0>
		}
	}

#declare WoodTex =
	texture {
		pigment {
			rgb<0.427,0.306,0.161>
		}
		normal { bumps .08 scale .5 }
		finish { ambient .1 diffuse .45 specular .11 roughness .108 }
	}

#declare WhitePaint =
	texture {
		pigment {
			rgb<1,1,1>
		}
//		normal { bumps .08 scale 5 }
		finish { ambient .1 diffuse .45 specular .68 roughness .067 }
	}

#declare WhiteConcrete =
	texture {
		pigment {
			rgb<.835,.841,.827>
		}
		normal { bumps .28 scale 0.25 }
		finish { ambient .1 diffuse .70 specular .23 roughness .167 }
	}

#declare DarkTex = // for building interior
	texture {
		pigment {
			rgb<0.057,0.036,0.036>
		}
		finish { ambient .05 diffuse .35 specular .11 roughness .108 }
	}

#declare GarageInteriorTex =
	texture {
		pigment {
			rgb<.364,.385,.316>*0.41
		}
		normal { bumps .28 scale 0.25 }
		finish { ambient .05 diffuse .50 specular .23 roughness .167 }
	}

#declare GarageStuffTex =
	texture {
		pigment {
			cells
			color_map {
				[ 0.3 rgb <0.431,0.353,0.306> ]
				[ 0.3 rgb <0.131,0.153,0.106> ]
				[ 0.6 rgb <0.131,0.153,0.106> ]
				[ 0.6 rgb <0.831,0.853,0.806> ]
			}
			scale <12,8,6>
		}
		normal { bumps .13 scale 0.25 }
		finish { ambient .05 diffuse .50 specular .33 roughness .084 }
	}

#declare GarageRoofTex =
	texture {
		pigment {
			rgb<.341,.341,.341>
		}
		normal { bumps .08 scale 5 }
		finish { ambient .10 diffuse .45 specular .03 roughness .272 }
	}
#declare BSoffitTex =
	texture {
		pigment { rgb<.571,.561,.501> }
		normal { bumps 0.1 scale <22,12,4> turbulence 0.1 }
		finish { ambient .10 diffuse .45 specular .03 roughness .272 }
	}
#declare BRoofTex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.00 rgb<0.204,0.459,0.357>*0.04 ]
				[ 0.05 rgb<0.204,0.459,0.357>*0.20 ]
			}
			scale 5
		}
		normal { bumps 0.3 scale .22 turbulence 0.1 }
		finish { ambient .10 diffuse .45 specular .03 roughness .272 }
	}
#declare BurnTex =
	texture {
		pigment {
			onion
			color_map {
				[ 0.2 rgb<.071,.061,.001> ]
				[ 0.8 rgb<.571,.561,.501> ]
			}
			scale 12*Feet
		}
	}


//===============================================
//             Macros
//===============================================

#macro SWall(Length) // simple wall
	union {
		box { <0,0,0>,<Length,12,3*Feet> }
		box { <0,-6,-6>,<Length,6,6>
			rotate x*45
			translate <0,0,3*Feet>
		}
		texture {
			pigment { color rgb<.2,.2,.2> }
			finish { specular 0.3 diffuse 0.7 }
		}
	} // end union
#end


//===============================================
//             Objects
//===============================================


#declare SBuilding1 = // simple version
	union {
		box {
			<0,0,0>,<30*Feet,40*Feet,20*Feet>
		}
		box { // roof
			<-1.5*Feet,0,0>,<31.5*Feet,26*Feet,8>
			rotate x*20
			translate <0,0,20*Feet>
		}
		texture {
			pigment { color rgb<.2,.2,.2> }
			finish { specular 0.3 diffuse 0.7 }
		}
	} // end union

//--------------- Garage ---------------------

#declare GD = 1.8; // gutter diameter
#declare GGutter =
	union {
		difference {
			cylinder { // main gutter
				<0,0,0>,<20*Feet+11,0,0>,GD
			}
			cylinder { // interior
				<.5,0,0>,<20*Feet+11-0.5,0,0>,GD-0.2
			}
			box { // cut off top
				<-1,-3,0>,<22*Feet,3,5>
			}
			translate <0,-12-2,9*Feet+3>
		} // end difference
		sphere_sweep {
			catmull_rom_spline
			6,
			<0,0,12>, GD
			<0,0,0>, GD
			<0,0,-6>, GD
			<0,12,-10>, GD
			<0,12,-14>, GD
			<0,12,-24>, GD
			translate <19*Feet,-12-2,9*Feet+3>
		}
		cylinder { // downspout
			<0,0,0>,<0,0,9*Feet+3-12>,GD
			translate <19*Feet,-2,0>
		}
		cylinder { // downspout base
			<0,0,0>,<0,0,2*Feet>,GD*1.6
			translate <19*Feet,-2,0>
		}
		texture { pigment { rgb<.423,.423,.493> } }
	} // end union

#declare GarageShape =
	union {
		difference {
			difference {
				box { // main building
					<0,0,0>,<20*Feet,20*Feet,9*Feet>
				}
				height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
					png "Damage.png" // small low hole
					water_level .01
					translate <-0.5,0,-0.5> // center on Y
					scale <2*Feet,1,2*Feet>
					translate <13.6*Feet,-.2,18>
//					texture { WhitePaint }
				}
				height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
					png "Damage.png" // above door
					smooth
					water_level .01
					translate <-0.5,0,-0.5> // center on Y
					rotate y*70
					scale <3.2*Feet,3,3.2*Feet>
					translate <11.0*Feet,-.2,7.2*Feet>
//					texture { WhitePaint }
				}
				height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
					png "Damage.png" // far right
					water_level .01
					translate <-0.5,0,-0.5> // center on Y
					rotate y*140
					scale <2*Feet,3,3*Feet>
					translate <20.0*Feet,-.2,55>
//					texture { WhitePaint }
				}
			} // end difference
			box { // interior
				<8,8,-1>,<20*Feet-8,20*Feet-8,9*Feet-8>
				texture { GarageInteriorTex }
			}
			box { // garage door hole
				<0,-1,-1>,<9*Feet,10,7*Feet>
				translate <2*Feet,0,0>
			}
			box { // garage door molding
				<-1,-1,-1>,<9*Feet+1,10,7*Feet+1>
				translate <2*Feet,4.5,0>
			}
			box { // door hole
				<0,-1,-1>,<3*Feet,10,7.5*Feet>
				translate <14*Feet,0,0>
			}
		} // end difference
		box { // roof
			<-12,-12,0>,<20*Feet+12,20*Feet+12,6>
			translate <0,0,9*Feet>
			texture { GarageRoofTex }
		}
		box { // floor
			<0,0,-8>,<20*Feet,20*Feet,0>
		}
		difference {
			box { // walk-in door
				<0,0,0>,<3*Feet,1.4,7*Feet>
//				translate <14*Feet,4.5,0>
			}
			height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
				png "Damage.png"
				water_level .01
				translate <-0.5,0,-0.5> // center on Y
				scale <2*Feet,14,2*Feet>
				translate <1.6*Feet,-0.4,68>
//				texture { WhitePaint }
			}
			rotate <-28,0,32>
			translate <14*Feet,0,0>
		} // end difference
		box { // open overhead door
			<0,0,0>,<9*Feet,1.4,2*Feet>
			rotate <-82,30,0>
			translate <2*Feet,4.5,5.5*Feet>
			texture { pigment { rgb<.65,.65,.65> } }
		}
		texture { WhiteConcrete }
	} // end union

#declare GarageStuff =
	union {
		cylinder { <0,0,0>,<0,0,24>,9 translate <17,4*Feet,0> } // trash can
		sphere { <0,0,0>,9 scale <1,1,.2> translate <17,4*Feet,24> } // lid
		box { <0,0,0>,<10,14*Feet,0.75> translate <8,8,5.2*Feet> } // shelf
		box { <0,0,0>,<16,14,10> rotate z*18 translate <8,0,5.2*Feet> } // shelf item
		cylinder { <0,0,0>,<0,0,8>,2.6 translate <12,3*Feet,5.2*Feet> } // shelf item
		cylinder { <0,0,0>,<0,0,8>,2.6 translate <12,3*Feet+8,5.2*Feet> } // shelf item
		box { <0,0,0>,<16,14,10> rotate z*18 translate <8,6*Feet,5.2*Feet> } // shelf item
		box { <0,-24,0>,<2.4*Feet,0,6.0*Feet> translate <18,20*Feet-10,0> } // back cabinet
		texture { GarageStuffTex }
	}

#declare FilledGarage =
	union {
//		object { PackardCar rotate z*-90 translate <7*Feet,13*Feet,0> }
		object { GarageStuff }
		object { GarageShape }
		object { GGutter translate <0,0,0> }
	} // end union


//--------------- Building 1 ---------------------

#declare BrickWall =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "BrickHole3.png"
		water_level .01
		scale <1,-1,1> // extrude into -Y
		scale <15*Feet,1*Feet,15*Feet> // scale it up
		texture { BrickWallTex }
//texture { pigment { rgb<1,1,1> } } // test
	}
#declare StuccoWall =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Stucco.png"
		water_level .01
		scale <1,-1,1> // extrude into -Y
		scale <30*Feet,0.5,30*Feet> // scale it up
		texture { StuccoTex }
	}

#declare MainWall =
	union {
	difference {
		union {
			object { StuccoWall }
			object { BrickWall translate <19*Feet,13,9*Feet> }
		} // end union
	} // end difference
	box { // chimney
		<-20,0,0>,<20,10,30*Feet>
		translate <15*Feet,-8,0>
		texture { StuccoTex }
	}
	} // end union

#declare MBulletHoleGroup =
	union {
		object { BulletHole() scale 12 translate <23*Feet,-0.3,12*Feet> } // big damage
		object { BulletHole() scale 4 translate <14*Feet,-8.3,19*Feet> } // chimney
		#declare RS = seed(1130);
		#declare MaxBullets = 16; // big holes
		#declare TB = 0;
		#while (TB < MaxBullets)
			object { BulletHole()
			scale 4
			translate <29*Feet-rand(RS)*1*Feet-TB*1*Feet,-0.3,5*Feet+rand(RS)*1.3*Feet+TB*1*Feet> }
			#declare TB = TB + 1;
		#end
		#declare MaxBullets = 18; // small holes
		#declare TB = 0;
		#while (TB < MaxBullets)
			object { BulletHole()
			scale 2
			translate <26*Feet-rand(RS)*.31*Feet*TB,-0.3,2*Feet+TB*4+rand(RS)*.5*Feet*TB> }
			#declare TB = TB + 1;
		#end
		#declare MaxBullets = 20; // garage 1
		#declare TB = 0;
		#while (TB < MaxBullets)
			object { BulletHole()
			scale 2
			translate <28*Feet+20*Feet-rand(RS)*.55*Feet*TB,24*Feet-0.3,0.5*Feet+TB*2.4+rand(RS)*.3*Feet> }
			#declare TB = TB + 1;
		#end
		#declare MaxBullets = 13; // garage 2
		#declare TB = 0;
		#while (TB < MaxBullets)
			object { BulletHole()
			scale 2.3
			translate <22*Feet+20*Feet+rand(RS)*.75*Feet*TB,24*Feet-0.3,5.5*Feet+TB*1.0+rand(RS)*.3*Feet> }
			#declare TB = TB + 1;
		#end
	}

#declare BackWindowHole =
	box {
		<-20,-16,0>,<20,16,42>
		texture { StuccoTex }
	}
#declare BackWindow =
	union {
		box { // top
			<-8,-16,-1.4>,<0,16,0>
			translate <0,0,42>
		}
		box { // sill
			<-8,-16,0>,<3,16,1.5>
			translate <0,0,0>
		}
		texture { WoodTex }
	} // end union
#declare BackDoorHole =
	box {
		<-15,-16,0>,<15,16,6.7*Feet>
		texture { StuccoTex }
	}
#declare BackDoor =
	union {
		box { // top frame
			<-12,-15,0>,<1,15,1.25>
			translate <0,0,6.7*Feet-1.25>
			texture { WoodTex }
		}
		box { // doorstep
			<-12,-25,-12>,<28,25,0>
			texture { WhiteConcrete }
		}
		box { // overhead
			<-12,-25,0>,<18,25,5>
			translate <0,0,7.2*Feet>
			texture { WoodTex }
		}
		box { // door
			<-2,-15,0>,<0,15,6.7*Feet>
			translate <-3,0,0>
			texture { WhitePaint }
		}
		cylinder { <0,0,0>,<1,0,0>,0.2 translate <-3,11,36> texture { WoodTex } } // knob
		sphere { <0,0,0>,1.2 scale <.6,1,1> translate <-3+1,11,36> texture { WoodTex } } // knob
	} // end union

#declare RightSideWall =
	union {
		object { BrickWall rotate z*-90 translate <0*Feet,13*Feet,9*Feet> }
		difference {
			box { // base
				<-12,0,0>,<0,40*Feet,9*Feet>
				translate <0,0,0>
				texture { BrickWallTex }
			}
			object { BackDoorHole translate <0,9*Feet,0> }
		} // end difference
		difference {
			box { // end
				<-12,12*Feet,0>,<0,40*Feet,24*Feet>
				translate <0,0,0>
				texture { BrickWallTex }
			}
			object { BackWindowHole translate <0,18*Feet,17*Feet> }
			object { BackWindowHole translate <0,28*Feet,17*Feet> }
		} // end difference
		object { BackWindow translate <0,18*Feet,17*Feet> }
		object { BackWindow translate <0,28*Feet,17*Feet> }
		object { BackDoor translate <0,9*Feet,0> }
		translate <-4,0,0>
	} // end union
#declare LeftSideWall =
	box {
		<0,6,0>,<12,40*Feet,19*Feet>
		texture { BrickWallTex }
	}

#declare FarEndWall =
	union {
		box { <0,0,0>,<29*Feet,8,19*Feet> }
		box { <-32*Feet/2,0,-20*Feet>,<0,8,0> rotate y*-35 translate <29*Feet/2,0,29*Feet> }
		box { <0,0,-20*Feet>,<32*Feet/2,8,0> rotate y*35 translate <29*Feet/2,0,29*Feet> }
		texture { DarkTex }
	} // end union

#declare FloorHole =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Damage.png"
		water_level .01
		translate <-0.5,0,-0.5> // center on Y
		texture { WhitePaint }
		rotate <-75,0,65>
		scale 10*Feet
	}
#declare SecondFloor =
	difference {
		box {
			<0,0,-12>,<28.5*Feet,40*Feet,0>
		}
		box { // kill the white end
			<28.4*Feet,20,-13>,<28.6*Feet,40*Feet,1>
			texture { BrickWallTex }
		}
		object { FloorHole translate <29*Feet,4*Feet,0> }
		texture { WhiteConcrete }
	} // end difference


//--------------- Roof ---------------------

#declare LeftRoof =
	union {
		box {
			<-18*Feet-16,-6,0>,<0,40*Feet+6,8>
			texture { BSoffitTex }
		}
		box {
			<-18*Feet-16.8,-7,7.9>,<0,40*Feet+7,8.5>
			texture { BRoofTex }
		}
	}
#declare RightRoof =

	difference {
	union {
		difference {
			box {
				<0,-6,0>,<18*Feet+16,40*Feet+6,8>
			}
			box { // cutout all but perimeter
				<2,-6+2,-1>,<18*Feet+16-2,40*Feet+6-2,9>
			}
			texture { BSoffitTex }
		} // end difference
		box {
			<0,-7,7.9>,<18*Feet+17,40*Feet+7,8.5>
			texture { BRoofTex }
		}
	} // end union
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "Building1RoofDamage.png"
			water_level .01
			scale <1,-1,1> // extrude into -Y
			rotate x*-90
			scale <16*Feet,18*Feet,3*Feet>
			translate <4*Feet,-18,-4>
		}
	texture { BRoofTex }
	} // end difference

#declare SplinterBox =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "Damage.png"
		water_level .01
		translate <-0.5,0,-0.5> // center on Y
//		texture { WhitePaint }
	}
#declare RightRoofDamage =
	union {
		difference {
			box { <-40,0,-14>,<28,2,-2> rotate <0,0,0> translate <0,6,0> }
			object { SplinterBox scale 20 rotate <0,0,90> translate <28,2,-7> rotate <0,0,0> translate <0,6,0> }
		}
		difference {
			box { <0,0,-14>,<48,2,-2> rotate <-12,8,0> translate <0,6+16*1,0> }
			object { SplinterBox scale 20 rotate <0,220,90> translate <48,2,-7> rotate <-12,8,0> translate <0,6+16*1,0> }
		}
		box { <0,0,-14>,<28,2,-2> rotate <0,14,8> translate <2,6+16*2,0> }
		box { <0,0,-14>,<48,2,-2> rotate <6,14,-5> translate <5,6+16*3,0> }
		difference {
			box { <0,0,-14>,<78,2,-2> rotate <6,18,-5> translate <10,6+16*4,0> }
			object { SplinterBox scale 20 rotate <0,70,90> translate <78,2,-7> rotate <6,18,-5> translate <10,6+16*4,0> }
		}
		box { <0,0,-14>,<45,2,-2> rotate <6,24,-5> translate <10,6+16*5,0> }
		box { <-115,0,-14>,<0,2,-2> rotate <-3,-84,25> translate <6.0*Feet,16+16*6,-12> }
		box { <0,0,-14>,<90,2,-2> rotate <0,0,0> translate <0,6+16*7,0> }
		texture { BurnTex translate <8*Feet,0,0> }
	}

//===============================================
//             Assemblies
//===============================================

#declare Building1 =
	union {
		object { MainWall }
		object { MBulletHoleGroup }
		object { FarEndWall translate <0,40*Feet,0> }
		object { RightSideWall scale <1,1,0.8> translate <29.5*Feet,1.0*Feet,0> }
		object { LeftSideWall translate <0,0,0> }
		object { LeftRoof rotate y*-35 translate <15*Feet,0,29*Feet> }
		object { RightRoof rotate y*35 translate <15*Feet,0,29*Feet> }
		object { RightRoofDamage translate <10*Feet,0,0> rotate y*35 translate <15*Feet,0,29*Feet> }
		object { SecondFloor translate <0,0,12*Feet> }
	} // end union

#declare Building1Group =
	union {
		object { Building1 }
		object { Building1BricksPile translate <30*Feet,0,1.5*Feet> }
		object { BeamGroup translate <30*Feet,0,1.5*Feet> }
		object { FilledGarage translate <30*Feet,24*Feet,0> }
	} // end union

//===============================================
//             For Testing Only
//===============================================


#if (RenderThisFile = 1)

#include "GIncludeRH.inc"
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <1, -48*Feet, 15*Feet>
		look_at <7*Feet,0,6*Feet>
	}


light_source
{ <40*Feet,-55*Feet,60*Feet>, 2
  spotlight point_at <0,0,12*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-55*Feet,10*Feet>, <1.13,0.93,.76>
  spotlight point_at <0,0,12*Feet> radius 15 falloff 26
}
background { color rgb <0.46, 0.55, 0.73> }
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }
//object { BrickWall rotate z*0 translate <0,0,0> }
object { Building1Group rotate z*-30 translate <-23*Feet,10*Feet,0> }

#end
