
// POV-Ray Object File - Landscape Terrain
// created 28-Sep-01
// last update 30-Oct-01
// 2001 Glenn McCarter
//
// This file does not render.  #include "Landscape.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Distant Mountains
// RoadTerrain
// GraveTerrain
// CloseTerrain
// TreeLine
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================


#declare DirtTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 rgb <0.318,0.278,0.235> ]
				[ 0.5 rgb <0.318,0.278,0.235>*.4 ]
				[ 1.0 rgb <0.318,0.278,0.235> ]
			}
			scale 20
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness 0.11 }
	}

#declare SnowTex =
	texture {
		pigment { rgb<1,1,1>*.5 }
		finish { ambient .1 specular .8 roughness .082 }
	}

#declare SnowflakeTex =
	texture {
		pigment { rgb<.871,.931,1>*1.0 }
		finish { ambient 3 specular .98 roughness .040 }
	}

#declare DarkWaterTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 rgb <0.005,0.003,0.007> ]
				[ 0.5 rgb <0.005,0.03,0.007>*.4 ]
				[ 1.0 rgb <0.005,0.003,0.007> ]
			}
			scale 30
		}
		normal {
			granite 0.1
			scale 30
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.9 roughness 0.005 reflection 0.28 }
	}

#declare WaterPuddleTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.0 rgb <0.005,0.003,0.007> ]
				[ 0.5 rgb <0.005,0.03,0.007>*.4 ]
				[ 1.0 rgb <0.005,0.003,0.007> ]
			}
			scale 30
		}
		normal {
			bumps 0.08
			scale 8
			turbulence 0.2
		}
		finish { ambient 0.1 diffuse 0.6 specular 0.9 roughness 0.005 reflection 0.58 }
	}

#declare AATex =
	texture {
		pigment {
			gradient x
			color_map {
				[ 0.8 rgb <0.95,0.93,0.27> ]
				[ 0.8 rgb <0.015,0.03,0.007>*0.4 ]
			}
			scale <4*Feet,1,1>
		}
		finish { ambient 10 }
	}

#declare HoleTex = pigment { rgb<1,1,.8> }
#declare RadialFlameTex =
	pigment {
		radial
		frequency 12
		color_map {
			[ 0.1 rgb<1,1,0.25> ] // hot
			[ 0.5 rgbt<1,0.7,.03,1> ] // flame
			[ 0.9 rgb<0,0,0> ] // smoke
		}
		turbulence 0.3
	}
#declare ClearTex = pigment { rgbt<1,1,1,1> }
#declare BurstTex =
	texture {
		pigment {
			spherical
			pigment_map {
				[ 0.20 ClearTex ] // outside
				[ 0.70 RadialFlameTex ]
				[ 0.80 HoleTex ] // center of sphere 

			}
			turbulence 0.02
			scale 1
		}
		finish { ambient 10 }
	}



//===============================================
//             Objects
//===============================================

//#declare DMX = 2.4*Miles;
//#declare DMY = 2.4*Miles;
/*
#declare DistantMountains =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "MountainLoRes.png"
		water_level .001
		scale <1,-1,1> // extrude temporarily into -Y
		rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
		scale <DMX,DMY,2000*Feet> // scale it up
//scale 0.3
//		scale <24*Feet,24*Feet,2*Feet> // scale it up (small test)
		texture { DirtTex }
	}
*/

#declare RiTH = -20;
#declare RiverTerrain =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "RiverTerrain.png"
			water_level .08
			scale <1,-1,1> // extrude temporarily into -Y
			rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
			scale <1000*Feet,1000*Feet,3*Feet> // scale it up
 			translate <0,0,RiTH> // set ground level
			texture { SnowTex }
		}
		box { // water
			<0,0,-4>,<1000*Feet,1000*Feet,0.1>
			translate <0,0,RiTH>
			texture { DarkWaterTex }
		}
	} // end union

#declare BTH = -20;
#declare BuildingTerrain =
//	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "BuildingTerrain.png"
			water_level .08
			scale <1,-1,1> // extrude temporarily into -Y
			rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
			scale <200*Feet,200*Feet,8*Feet> // scale it up
 			translate <0,0,BTH> // set ground level
			texture { SnowTex }
		}
/*
		box { // water
			<0,0,-4>,<1000*Feet,1000*Feet,0.1>
			translate <0,0,BTH>
			texture { DarkWaterTex }
		}
*/
//	} // end union

#declare RTH = -3;
#declare RoadTerrain =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "RoadTerrain.png"
			water_level .01
			scale <1,-1,1> // extrude temporarily into -Y
			rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
			scale <100*Feet,100*Feet,1*Feet> // scale it up
 			translate <0,0,RTH> // set ground level
			texture { SnowTex }
		}
		box { // water
			<0,0,-4>,<100*Feet,80*Feet,RTH+1>
			texture { WaterPuddleTex }
		}
	} // end union


#declare GraveTerrain =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "GraveTerrain.png"
		water_level .01
		texture {
			material_map {
				png "GraveTerrainMaterialMap.png"
				texture { // dirt texture
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "GraveTerrainColorMap.png"
					once
				}
//				rotate <90,0,0> // orient to height_field
			}
			finish { ambient .1 specular 0.18 roughness 0.182 }
			}// end index 1

				texture { // snow texture
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "GraveTerrainColorMap.png"
					once
				}

			}
			finish { ambient 2 specular 0.8 roughness 0.082 }
			}// end index 2


			} // end material map
			rotate <90,0,0> // orient to height_field

/*
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "GraveTerrainColorMap.png"
					once
				}
				rotate <90,0,0> // orient to height_field
//				translate <1,1,0> // puts upper left at <1,0,0>
			}
			finish { ambient .2 specular 0.8 roughness 0.082 }
*/
		} // end texture
		scale <1,-1,1> // extrude temporarily into -Y
		rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
//		scale <30*Feet,30*Feet,3*Feet> // scale it up // old
		scale <23*Feet,23*Feet,3*Feet> // scale it up
//		scale <4.0*Feet,4.0*Feet/1.3333,10> // scale it up (small test)
//		texture { DirtTex }
	}


#declare CloseTerrain =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "CloseTerrain.png"
		water_level .01
		scale <1,-1,1> // extrude temporarily into -Y
		rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
		scale <8*Feet,8*Feet,0.4*Feet> // scale it up
		texture { SnowTex }
	}

//---------------------- Trees -----------------------
#declare TreeLine =
	box {
		<0,0,0>,<1,1,1>
		hollow
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "TreeLine.png"
					once
				}
				rotate <90,0,0> // project from -Y
			}
		}
		scale <60*Feet*2000/100,1,60*Feet> // match image aspect ratio
	}

#declare TreeMapleS = // silhouette maple; centered on X, faces Y, grows into Z
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "TreeMapleS.png"
					once

				}
				rotate x*90

			}
		}
		scale <20*Feet,0.1,44*Feet>
		translate <-10*Feet,0,-10>
	}

#declare TreeMaple3S = // silhouette maple; centered on X, faces Y, grows into Z
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "TreeMaple3S.png"
					once

				}
				rotate x*90

			}
		}
		scale <20*Feet,0.1,44*Feet>
		translate <-10*Feet,0,-10>
	}

#declare TreeMaple4S = // silhouette maple; centered on X, faces Y, grows into Z
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "TreeMaple4S.png"
					once

				}
				rotate x*90

			}
		}
		scale <20*Feet,0.1,44*Feet>
		translate <-10*Feet,0,-10>
	}


//----------------- Distant Items --------------------

#declare DistantBuilding =
	union {
		difference {
			box {
				<0,0,0>,<38*Feet,20*Feet,20*Feet>
			}
			box { // half roof
				<-1,-1,0>,<38*Feet+1,30*Feet,20*Feet>
				rotate x*45
				translate <0,0,10*Feet>
			}
			box { // half roof
				<-1,1,0>,<38*Feet+1,-30*Feet,20*Feet>
				rotate x*-45
				translate <0,30*Feet,10*Feet>
			}
		} // end difference
		texture { pigment { rgb<.02,.02,.02> } }
	} // end union

#declare DistantBuildingGroup =
	union {
		object { DistantBuilding }
		object { DistantBuilding translate <50*Feet,40*Feet,0> }
		object { DistantBuilding rotate z*80 translate <120*Feet,0,0> }
		object { DistantBuilding scale 0.7 translate <210*Feet,-80*Feet,0> }
	}

#declare RP = 280*Feet; // Right Position
#declare DistantWarfare =
	union {
		sphere_sweep { // anti-aircraft fire
			catmull_rom_spline
			5,
			<-40*Feet,0,0>,4 // first one isn't visible
			<80*Feet,0,0>,4
			<120*Feet,0,20*Feet>,4
			<260*Feet,0,0>,4
			<340*Feet,0,-40*Feet>,4 // last one isn't visible
			texture { AATex }
			rotate <0,-40,50>
			translate <RP+340*Feet,200*Feet,0>
		}
		sphere_sweep { // low anti-aircraft fire
			catmull_rom_spline
			5,
			<-40*Feet,0,0>,4 // first one isn't visible
			<0,0,0>,6
			<30*Feet,0,2*Feet>,4
			<120*Feet,0,0>,4
			<160*Feet,0,-10*Feet>,4 // last one isn't visible
			texture { AATex }
			rotate <0,-40,120>
			translate <RP+500*Feet,200*Feet,0>
		}
		sphere_sweep { // high anti-aircraft fire
			catmull_rom_spline
			5,
			<-40*Feet,0,0>,4 // first one isn't visible
			<160*Feet,0,0>,6
			<200*Feet,0,-14*Feet>,4
			<240*Feet,0,0>,4
			<260*Feet,0,10*Feet>,4 // last one isn't visible
			texture { AATex }
			rotate <0,-40,110>
			translate <RP+500*Feet,200*Feet,0>
		}
		cylinder { // machine gun tracer fire
			<0,0,0>,<130*Feet,0,0>,3
			texture { AATex }
			rotate <0.6,0,-30>
			translate <100*Feet,-30*Feet,8*Feet-10>
		}
		cylinder { // machine gun tracer fire
			<0,0,0>,<100*Feet,0,0>,2.3
			texture { AATex }
			rotate <0,-2.3,130>
			translate <160*Feet,-130*Feet,8*Feet+10>
		}
		cylinder { // left burst
			<0,0,0>,<0,1,0>,8*Feet
			texture { BurstTex scale 8*Feet }
			translate <40*Feet,-80*Feet,0>
		}
		cylinder { // big burst
			<0,0,0>,<0,1,0>,20*Feet
			texture { BurstTex scale 23*Feet }
			translate <120*Feet,-20*Feet,7*Feet>
		}
		cylinder { // right burst
			<0,0,0>,<0,1,0>,6*Feet
			texture { BurstTex scale 6*Feet }
			translate <220*Feet,-60*Feet,10>
		}
//		sphere { <0,0,0>,40*Feet texture { AATex } } // test
	} // end union


//----------------- Snowing ---------------------

#declare RS = seed(95891);
#declare SFSeed =
	union {
		triangle { <-0.4,-0.3,0>,<0.4,-0.3,0>,<0,1.0.0> }
	} // end union
#macro Snowflake()
	#local SXtrans = x*rand(RS)*.1;
	union {
		#local SSide = 0;
		#local Rots = rand(RS)*360;
		#while (SSide < 6 )
			object { SFSeed scale 0.2
				rotate Rots
				translate SXtrans
				rotate <0,0,SSide*360/6>
			}
			#declare SSide = SSide + 1;
		#end
		scale 0.2
		rotate <rand(RS)*360,rand(RS)*360,rand(RS)*360>
		texture { SnowflakeTex }
	} // end union
#end

#declare SnowFlurries =
	union {
		#declare MaxFlakes = 600;
		#declare FN = 1;
		#while ( FN < MaxFlakes )
			object { Snowflake()
				translate <0,14+rand(RS)*4.0*Feet,0>
				rotate z*(-30+rand(RS)*60)
				rotate y*rand(RS)*360
			}
			#declare FN = FN + 1;
		#end
	} // end union


//===============================================
//             Object Placement
//===============================================

//object { RiverTerrain rotate <0,0,0> translate <-380*Feet,70*Feet,HH-8> }
//object { RiverTerrain rotate <0,0,0> translate <-100*Feet,1000*Feet,HH-8> } // under distant buildings

//object { BuildingTerrain rotate <0,0,0> translate <-133*Feet,45*Feet,HH> }
//object { TreeMaple3S scale <.71,1,.87> rotate <0,0,-30> translate <-40*Feet,120*Feet,24> } // tall shadow on building
//object { TreeMapleS scale <-.31,1,.21> rotate <0,0,-30> translate <-42*Feet,120*Feet,40> } // short shadow on building
//object { TreeMapleS scale <1,1,.8> rotate <0,0,20> translate <-59*Feet,220*Feet,HH-12> } // left of building
//object { TreeMaple4S scale <-1,1,.7> rotate <0,0,20> translate <28*Feet,220*Feet,HH-6*Feet> } // right of building
//object { RoadTerrain rotate <0,0,0> translate <-40*Feet,30*Feet,HH-8> }
//object { GraveTerrain rotate <5,6,-20> translate <-16*Feet,9*Feet,-3.0*Feet+MH> }

//object { TreeLine translate <30*Feet,1200*Feet,-8*Feet> }
//object { DistantBuildingGroup translate <160*Feet,1100*Feet,HH> }


//object { SnowFlurries rotate <-7,0,-12> translate <-11,-24,CH+20>+<-2,-6,0> } // camera position


// TESTING ONLY
//object { CloseTerrain rotate <0,0,-3> translate <-48,-40,MH> }
//object { GraveTerrain rotate <-4,0,-20> translate <-20*Feet,7*Feet,-2.0*Feet+MH> }
//object { GraveTerrain rotate <5,0,-20> translate <-20*Feet,4*Feet,-4.0*Feet+MH> } // test
//object { RiverTerrain scale .01 rotate x*90 translate <-1*Feet,20*Feet,-10*Feet> } // test