
// POV-Ray Object File - Military Flashlight
// created 2-Oct-01
// last update 21-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "MilFlashlight.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// 
// MilitaryFlashlight
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// L-shape, body in -Z, shines into +X

//#include "GIncludeRH.inc" // uncomment for testing only
//#include "Shapes.inc" // uncomment for testing only
//#include "Rifle.inc" // uncomment for testing only
//#declare GS = 1; // uncomment for testing only 
//#include "GRuler.inc" // for testing only

//===============================================
//             Includes
//===============================================



//===============================================
//             Variables
//===============================================

#declare Fdia = 0.72; // handle diameter

//===============================================
//             Textures
//===============================================

#declare FlashLightSwitchCol = rgb<.080,.067,.065>;

#declare FlashLightTex =
	texture {
		pigment { rgb<0.41,0.47,0.43> }
		finish { specular 0.3 diffuse 0.38 }
	}


//===============================================
//             Objects
//===============================================

#declare FBase =
	union {
		cylinder { // connector pivot
			<0,0,-1.6>,<0,0,1>,Fdia-0.14
		}
		cylinder { // ribbed area
			<0,0,-1.6>,<0,0,0>,Fdia+0.01
		}
		cylinder { // big end
			<0,0,-1.6>,<0,0,-0.68>,Fdia+0.13
		}
		#declare FBN = 0;
		#while ( FBN < 360 )
			cylinder { // rib
				<0,0,-1.6>,<0,0,-0.2>,0.13
				translate <Fdia+0.1-0.15,0,0>
				rotate <0,0,FBN*360/12>
			}
			sphere { // rib end
				<0,0,-0.2>,0.13
				translate <Fdia+0.1-0.15,0,0>
				rotate <0,0,FBN*360/12>
			}
			#declare FBN = FBN + 1;
		#end
	} // end union

#declare FSwitchGroup =
	union {
		box { // switch
			<-0.18,0,0>,<0.18,0.4,1.6>
			translate <0,0.7,-3>
			texture {
				pigment { FlashLightSwitchCol }
			}
		}
		object { RoundedBox(0.3)
			scale <.08,0.7,1.8>
			translate <0.22,Fdia-0.05,-2.2>
		}
		object { RoundedBox(0.3)
			scale <.08,0.7,1.8>
			translate <-0.22,Fdia-0.05,-2.2>
		}
	} // end union

#declare FHandleGroup =
	union {
		object { FSwitchGroup }
		difference {
			cylinder { // handle
				<0,0,-6>,<0,0,Fdia>,Fdia
			}
			box { // cutoff top end
				<-2,-2,0>,<2,2,4>
				rotate y*45
			}
		} // end difference
		torus { // base end
			Fdia,0.13
			rotate x*90
			translate <0,0,-6>
		}
		#declare FN = 0;
		#while ( FN < 360 )
			cylinder {
				<0,0,-6>,<0,0,-1.6>,0.13
				translate <Fdia-.05,0,0>
				rotate <0,0,FN*360/12>
			}
			#declare FN = FN + 1;
		#end
		difference {
			cylinder { // top front handle
				<-Fdia,0,0>,<0.75,0,0>,Fdia
			}
			box { // cutoff back end
				<-2,-2,-4>,<2,2,0>
				rotate y*45
			}
		} // end difference
	} // end union


#declare FLightGroup =
	union {
		difference {
			cylinder { // focus ring
				<0.72,0,0>,<2.0,0,0>,1
			}
			cylinder { // focus ring hole
				<0.8,0,0>,<3.0,0,0>,0.8
			}
		} // end difference
		torus { // front end
			0.9,0.1
			rotate z*90
			translate <2,0,0>
		}
		difference { // reflector
			cylinder {
				<-0.1,0,0>,<1,0,0>0.8
			}
			object { Paraboloid_X scale 0.5 }
			texture {
				pigment { rgb<.91,.91,1> }
				finish { reflection 0.82 }
			}
			translate <1,0,0>
		} // end difference
		light_source { 
			<1.1,0,0>
//			color rgb <0.829,0.883,0.931>*6 // too white
			color rgb <0.829,0.883,0.745>*7 // just right?
//			color rgb <0.829,0.883,0.631>*7 // too yellow
			spotlight
			point_at <100,0,0>
			radius 25
			falloff 39
			tightness 3
		}
		cylinder { // glass lens
			<-0.08,0,0>,<0,0,0>,0.85
			texture {
				pigment {
					onion
					color_map {
						[ 0.0 rgbt<1,1,1,1> ]
						[ 0.4 rgbt<1,1,1,1> ]
						[ 0.6 rgbt<1,1,.58,0.74> ]
						[ 0.8 rgbt<1,1,.58,0.74> ]
						[ 0.83 rgbt<1,1,1,1> ]
					}
					scale .6
				}
				normal { bumps 0.2 scale 0.4 } // waviness
				finish { specular 0.96 roughness 0.005 }
			}
			translate <2,0,0>
		}
	} // end union


#declare MilitaryFlashLight = // L-shape, body in -Z, shines into +X
	union {
		object { FBase translate <0,0,-6.3> }
		object { FHandleGroup }
		object { FLightGroup }
		texture { FlashLightTex } // body texture
	} // end union

