
#local RenderThisFile = 0; // change to 1 to test render this file only

// POV-Ray Object File - A highly damaged "Deuce and a half" military truck
// created 5-Oct-01
// last update 27-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "BurntTruck.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "MilitaryTruckRails.pov", "MilitaryTruckRails.pov"
//#include "GIncludeRH.inc" // uncomment for testing only
//
// Objects:
// STruck // simple version
// BurntTruck // detailed version
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Truck origin is at ground level at front bumper
// Truck faces -X


#if (RenderThisFile = 1)
	#include "GIncludeRH.inc" // uncomment for testing only
#end

//===============================================
//             Includes
//===============================================

#include "MilitaryTruckRails.pov"
#include "MilitaryTruckcab.pov"


//===============================================
//             Variables
//===============================================

#declare RS = seed(17393); // random seed

//===============================================
//             Textures
//===============================================


#declare TruckCamoTex =
	texture {
		pigment {
			crackle solid
			scale 12
			turbulence 0.5
	    color_map {
				[ 0.0 rgb<0.01,0.11,0.01> ]
				[ 1.0 rgb<0.86,0.92,0.82> ]
			}
			scale 1/(24*Feet) // to match later burnt tex
		}
//		normal { bumps .08 scale 5 }
		finish { ambient .10 diffuse .45 specular .08 roughness .167 }
	}
#declare CharredTruckTex =
	texture {
//		pigment { color rgb<.012,.012,.012> } // black
		pigment { color rgb<.072,.072,.072> } // very dark grey
//		pigment { color rgb<.12,.12,.12> } // dark grey
		normal { bumps .8 scale 2.0}
		finish { phong .3 phong_size 18 }
	}
#declare BurntTruckCamoTex =
	texture {
		gradient x
		texture_map {
			[ 0.0 CharredTruckTex ]
			[ 0.4 CharredTruckTex ]
			[ 0.6 TruckCamoTex ]
		}
		turbulence 0.08
		scale 25*Feet
		translate <-1*Feet,0,0>
	}


#declare TireTex =
	texture {
//		pigment { color rgb<.2,.2,.2> } // can be too grey
		pigment { color rgb<.12,.12,.12> } // more dark grey
		normal { bumps .1 scale .03}
		finish { phong .1 phong_size 12 }
	}
#declare CharredTireTex =
	texture {
//		pigment { color rgb<.3,.3,1> } // test
		pigment { color rgb<.12,.12,.12> } // more dark grey
//		normal { bumps .8 scale .33}
		finish { phong .01 phong_size 12 }
	}

#declare UnderCarriageTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.2 rgb<.120,.120,.120> ]
				[ 0.5 rgb<0.180,0.106,0.071> ]
				[ 1.0 rgb<.120,.120,.120> ]
			}
			turbulence 0.165
			scale 4
		}
		normal { bumps .44 scale .13}
		finish { phong .08 phong_size 12 }
	}


//===============================================
//             Macros
//===============================================

#macro BurntTire()
#local RadiusVal   = 0.6; // (0 < RadiusVal) outer sphere of influence on other components
#local StrengthVal = 1.0; // (+ or -) strength of component's radiating density
	blob {
	// threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
		threshold 0.6
		#declare BumpMax = 36;
		#declare BumpN = 0;
		#while ( BumpN < BumpMax )

			sphere { // outer
//				<0,0,0>, RadiusVal*.5, StrengthVal
				<0,0,0>, RadiusVal*.7, StrengthVal
				translate <0.65,rand(RS)*(0.1)+.2,0>
				rotate y*rand(RS)*20*(BumpN/BumpMax)*360
				scale <1,.6,1>
			}

			sphere { // inner
				<0,0,0>, RadiusVal*.5, StrengthVal
				translate <0.65,rand(RS)*.1,0>
				rotate y*rand(RS)*20*(BumpN/BumpMax)*360
			}

			sphere { // middle
				<0,0,0>, RadiusVal*.5, StrengthVal
				translate <0.85,rand(RS)*.1,0>
				rotate y*rand(RS)*20*(BumpN/BumpMax)*360
			}

			sphere { // flat tire
				<0,0,0>, RadiusVal*.5, StrengthVal
				translate <0.75,rand(RS)*.2,0>
				rotate y*((BumpN/BumpMax*90)+40+rand(RS)*10) // rand(RS)*10
			}
			#declare BumpN = BumpN +1;
		#end
		scale 20*Inches
		translate <0,3,20>
		texture { CharredTireTex }
	}
#end

//===============================================
//             Objects
//===============================================

//------------- Tires and Wheels ---------------

#declare STire = // simple version
	torus {
		15,6
		texture { TireTex }
	}
#declare SWheelHub = // simple version
	difference {
		cylinder {
			<0,-5,0>,<0,5,0>,10
		}
		cylinder {
			<0,-8,0>,<0,-2,0>,9
		}
		translate <0,6,20>
		texture { TruckCamoTex }
	} // end difference
#declare SWheel = // left side, upright on ground, origin at exposed face
	union {
		object { STire translate <0,6,20> }
		object { SWheelHub translate <0,6,20> }
	} // end union

#declare TRearWheelHub = // left side rear wheel, upright on ground, origin at exposed face
	union {
		difference {
			lathe {
			cubic_spline 
			34,
			<-1, 9.5>,<0.0,9.5>,<3.5,9.5>,<4.0,9.5>, // face
			<4.5,9.0>,<5.0,8.5>,<6.7,7.7>,<8.0,7.0>,
			<8.5,7.0>,<9.3,7.0>,<9.5,7.3>,<9.75,7.5>, // rim
			<9.9,7.3>,<9.9,7.0>,<9.5,6.5>,<9.0,6.5>,<8.5,6.0>, // top rim
			<8.5,1.5>,<9.0,1.0>,<9.5,1.0>,<9.9,0.5>,<9.8,0.25>, // rear rim
			<9.5,0.25>,<9.25,0.5>,<8.5,0.5>,<8.0,1.0>,
			<8.0,6.0>,<8.0,6.5>,<7.5,6.7>,<4.5,8.0>,
			<4.0,8.5>,<3.5,9.0>,<0.0,9.0>,<-1 ,9.0>
			}
			#declare HC = 0; // Hole Count
			#while ( HC < 6 )
				cylinder {
					<0,6,0>,<0,10,0>,1.9
					scale <.7,1,1>
					translate <6.0,0,0>
					rotate y*HC*360/6
				}
				#declare HC = HC + 1;
			#end
		} // end difference
		cylinder { // axle
			<0,2.0,0>,<0,9,0>,2.0
		}
		cylinder { // rear axle
			<0,2.7,0>,<0,9,0>,2.6
		}
		sphere { // rear axle
			<0,3.3,0>,2.1
		}
		#declare BC = 0; // Bolt Count
		#while ( BC < 10 ) // bolts
			cylinder {
				<0,0,0>,<0,2,0>,0.33
				translate <2.2,2.2,0>
				rotate y*BC*360/10
			}
			#declare BC = BC + 1;
		#end
//		translate <0,0,20>
//		texture { TruckCamoTex scale 18*Feet }
	} // end union

#declare TFrontWheelHub = // left side front wheel, upright on ground, origin at exposed face
	union {
		object { TRearWheelHub rotate z*180 translate <0,9,0> }
		cylinder { // front axle
			<0,-3.0,0>,<0,3,0>,2.0
		}
		sphere { // axle end
			<0,-2.2,0>,2.0
		}
		#declare BC = 0; // Bolt Count
		#while ( BC < 6 ) // bolts
			cylinder {
				<0,-2.4,0>,<0,2,0>,0.33
				translate <3.2,0,0>
				rotate y*BC*360/6
			}
			#declare BC = BC + 1;
		#end
//		texture { BurntTruckCamoTex }
	} // end union



//------------- Truck ---------------

#declare TruckRails =
	object { TruckRailShape
		scale <1.7,-1.7,1.7>
		rotate <-90,0,180>
	}
#declare SideSupport =
	box {
		<0,0,2.5>,<2.5,2.5,15.5>
	}
#declare SideR = // RH side
	union {
		box { // lower rail
			<0,0,0>,<12*Feet,2.5,2.5>
		}
		box { // upper rail
			<0,0,0>,<12*Feet,2.5,2.5>
			translate <0,0,15.5>
		}
		box { // inside panel
			<0,0,0>,<12*Feet,0.25,18>
		}
		object { SideSupport }
		object { SideSupport translate <3*Feet,0,0> }
		object { SideSupport translate <6*Feet,0,0> }
		object { SideSupport translate <9*Feet,0,0> }
		object { SideSupport translate <12*Feet-2.5,0,0> }
	} // end union
#declare SideL =
	object { SideR scale <1,-1,1> }
#declare TailGate =
	union {
		box { // main
			<0,-3*Feet,0>,<0.4,3*Feet,17>
		}
		box { // top rail
			<-1,-3*Feet,16>,<2,3*Feet,18>
		}
		box { <0,-1,0>,<0.6,1,17> translate <0,0,0> }
		box { <0,-1,0>,<0.6,1,17> translate <0,-1.5*Feet,0> }
		box { <0,-1,0>,<0.6,1,17> translate <0, 1.5*Feet,0> }
		cylinder { <0,-1,0>,<0,1,0>,0.3 translate <1,0,0> }
		cylinder { <0,-1,0>,<0,1,0>,0.3 translate <1,-1.5*Feet,0> }
		cylinder { <0,-1,0>,<0,1,0>,0.3 translate <1, 1.5*Feet,0> }
	} // end union
#declare RearBedSupport =
	prism {
		linear_sweep
		linear_spline
		0, // sweep the following shape along Y from here ...
		1, // ... up through here
		7, // the number of points making up the shape
		<-3*Feet,0>,<3*Feet,0>,<3*Feet,-5>,<1.5*Feet,-10>,<-1.5*Feet,-10>,<-3*Feet,-5>,<-3*Feet,0>
		rotate <0,0,-90>
		scale <-4,1,1>
	}
#declare TBed =
	union {
		object { TruckRails translate <12*Feet,3*Feet,0> }
		box { // base
			<0,-3*Feet,0>,<12*Feet-0.4,3*Feet,2>
		}
		box { // front end
			<0,-3*Feet,0>,<0.4,3*Feet,20>
			translate <1,0,0>
		}
		object { SideL translate <0,-3*Feet,0> }
		object { SideR translate <0,3*Feet,0> }
		object { RearBedSupport translate <11.8*Feet,0,2.6> }
		object { TailGate translate <12.0*Feet,0,0> }
		translate <9*Feet,0,48> 
		texture { BurntTruckCamoTex }
	} // end union

#declare TSCab = // simple version
	union {
		object { RoundedBox(0.2) scale <50,60,60> translate <6.8*Feet,0,30+30> } // upper cab
		object { RoundedHalfBox(0.3) scale <80,50,40> translate <3.5*Feet,0,20+24> } // hood
		object { RoundedBox(0.4) scale <28,16,16,> translate <9*Feet,-30,16+16> } // gas tank LH
		texture { BurntTruckCamoTex }
	} // end union

#declare TSCF = 18; // truck cab scaling factor
#declare TCab =
	union {
		object { TRoof scale <-TSCF,TSCF,TSCF> rotate <90,0,0> translate <0,0,0> }
		object { TRadiator scale <-TSCF,TSCF,TSCF> rotate <90,0,0> translate <0,0,0> }
		object { TCowlFloor scale <-TSCF,TSCF,TSCF> rotate <90,0,0> translate <0,0,0> }
		cylinder { <0,0,0>,<0,0,38>,1.1 rotate <5,20,0> translate <-3.4*Feet,-2.6*Feet,50> }
		cylinder { <0,0,0>,<0,0,30>,2.1 rotate <35,10,0> translate <-3.0*Feet,-2.6*Feet,50> }
		box { <0,0,0>,<30,1.2,28> rotate <0,8,0> translate <-3.4*Feet,-3.3*Feet,40> }
		translate <9*Feet,0,0>
		texture { BurntTruckCamoTex }
//texture { WhitePaint } // test
	} // end union

#declare TFrame =
	union {
		box { // frame rail
			<6,-3.2,0>,<21*Feet,3.2,8>
			translate <0,13,32>
		}
		box { // frame rail
			<6,-3.2,0>,<21*Feet,3.2,8>
			translate <0,-13,32>
		}
		box { // front bumper
			<0,-3*Feet,0>,<1,3*Feet,8>
			translate <0,0,33>
		}
		texture { BurntTruckCamoTex }
	} // end union


#declare DifferentialGroup =
	union {
		#declare RadiusVal   = 1.0; // (0 < RadiusVal) outer sphere of influence on other components
		#declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density
		blob { // front rear axle
		// threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
			threshold 0.6
			sphere { < 0.000,  0,    0>, RadiusVal, StrengthVal }
			cylinder { <0,-3.0,0>,<0,3.0,0>, RadiusVal*0.6, StrengthVal }
			// [sturm]
			scale 10
			translate <0,0,20>
		}
		cylinder { // brake drum
			<0,-4,0>,<0,0,0>,6
			translate <0,20,20>
		}
		cylinder { // brake drum
			<0,0,0>,<0,4,0>,6
			translate <0,-20,20>
		}
		cylinder { // spring & shock
			<0,0,0>,<0,0,13>,3
			translate <0,13,23>
		}
		cylinder { // spring & shock
			<0,0,0>,<0,0,13>,3
			translate <0,-13,23>
		}
	} // end union

#declare TRearUnderCarriage =
	union {
		object { DifferentialGroup translate <14*Feet,0,0> }
		object { DifferentialGroup translate <18*Feet,0,0> }
		union {
			cylinder { // front driveshaft
				<0,0,0>,<4*Feet,0,0>,2.85
			}
			cylinder { // link
				<4*Feet,0,0>,<4.4*Feet,0,0>,1.85
			}
			rotate y*3
			translate <6*Feet,0,28>
		} // end union
		cylinder { // rear driveshaft
			<0,0,0>,<7*Feet,0,0>,2.85
			rotate y*6
			translate <10.5*Feet,0,24>
		}
		texture { UnderCarriageTex }
	} // end union


//===============================================
//             Assemblies
//===============================================

#declare AllWheels =
	union {
		object { BurntTire() rotate z*-10 translate <28,-34,0> } // left front
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> rotate z*-10 translate <28,-34,20> texture { BurntTruckCamoTex }} // left front
		object { BurntTire() scale <1,-1,1> rotate <12,0,-18> translate <28,38,-2> } // right front
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> scale <1,-1,1> rotate <12,0,-18> translate <28,38,20> texture { BurntTruckCamoTex }} // right front
 
		object { BurntTire() translate <14*Feet,-40,0> } // left rear outer
		object { BurntTire() translate <14*Feet,-30,0> } // left rear inner
		object { BurntTire() translate <18*Feet,-40,0> } // left rear back outer
		object { BurntTire() translate <18*Feet,-30,0> } // left rear back inner
		object { TRearWheelHub rotate <0,rand(RS)*180,0> translate <14*Feet,-40,20> texture { BurntTruckCamoTex }} // left rear outer
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> translate <14*Feet,-30,20> texture { BurntTruckCamoTex }} // left rear inner
		object { TRearWheelHub rotate <0,rand(RS)*180,0> translate <18*Feet,-40,20> texture { BurntTruckCamoTex }} // left rear back outer
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> translate <18*Feet,-30,20> texture { BurntTruckCamoTex }} // left rear back inner
 
		object { BurntTire() scale <1,-1,1> translate <14*Feet,40,0> } // right rear outer
		object { BurntTire() scale <1,-1,1> translate <14*Feet,30,0> } // right rear inner
		object { BurntTire() scale <1,-1,1> translate <18*Feet,40,0> } // right rear back outer
		object { BurntTire() scale <1,-1,1> translate <18*Feet,30,0> } // right rear back inner
		object { TRearWheelHub rotate <0,rand(RS)*180,0> scale <1,-1,1> translate <14*Feet,40,20> texture { BurntTruckCamoTex }} // right rear outer
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> scale <1,-1,1> translate <14*Feet,30,20> texture { BurntTruckCamoTex }} // right rear inner
		object { TRearWheelHub rotate <0,rand(RS)*180,0> scale <1,-1,1> translate <18*Feet,40,20> texture { BurntTruckCamoTex }} // right rear back outer
		object { TFrontWheelHub rotate <0,rand(RS)*180,0> scale <1,-1,1> translate <18*Feet,30,20> texture { BurntTruckCamoTex }} // right rear back inner
	} // end union

#declare BurntTruck =
	union {
		object { TBed }
	object { TCab rotate x*4 }
		object { TFrame }
		object { TRearUnderCarriage }
		object { AllWheels }
	}

//===============================================
//             For Testing Only
//===============================================

#if (RenderThisFile = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1, -37*Feet, 8*Feet>
		look_at <4*Feet,-4*Feet,30>
	}


light_source
{ <40*Feet,-35*Feet,40*Feet>, 2
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-35*Feet,10*Feet>, <1.13,0.93,.76>
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }
object { BurntTruck rotate z*-140 translate <10*Feet,0,0> } // side 3/4 view
//object { BurntTruck rotate z*14 translate <-6*Feet,-15*Feet,0> } // test
//object { BurntTruck rotate z*-108 translate <7*Feet,0,0> } // rear view

#end
