
#local RenderThisFile = 0; // change to 1 to test render this file only

// POV-Ray Object File - M1 Garand Rifle
// created 5-Oct-01
// last update 29-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "Rifle.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "RifleSlings.pov"
//
// Objects:
// SM1Rifle // simple version
// M1Rifle // detailed version
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Rifle origin is at end of stock, with trigger towards -Z
// Rifle shoots into +X

#if (RenderThisFile = 1)
	#include "GIncludeRH.inc" // uncomment for testing only
#end



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare StockTex =
	texture {
		pigment { color rgb <0.337,0.216,0.169> }
		finish { ambient 0.05 diffuse 0.4 specular 0.4 roughness 0.080 }
	}

#declare GunMetalTex =
	texture {
		pigment { rgb <0.121,0.125,0.157> }
		finish { ambient 0.05 specular 0.78 roughness 0.020 metallic reflection 0.18 }
	}

#declare SlingTex =
	texture {
		pigment { color rgb <0.541,0.537,0.404> }
		finish { ambient 0.05 diffuse 0.4 specular 0.08 roughness 0.138 }
	}

//===============================================
//             Objects
//===============================================


#include "RifleSlings.pov"


#declare SM1Rifle = // shoots into +X, trigger into -Z
	union {
		cone { // stock
			<0,0,0>,2.6,<16,0,0>,1
			scale <1,0.2,1>
			rotate y*-10
			translate <0,0,-4>
		}
		cylinder { // stock front
			<0,0,0>,<20,0,0>,0.8
			scale <1,0.8,1>
			translate <12,0,-1>
		}
		cylinder { // barrel
			<0,0,0>,<25,0,0>,0.40
			translate <15,0,0>
		}
		difference {
			cylinder { // trigger guard
				<0,-0.1,0>,<0,0.1,0>,1.4
				scale <1,1,0.7>
			}
			cylinder {
				<0,-0.2,0>,<0,0.2,0>,1.2
				scale <1,1,0.7>
			}
			translate <17,0,-2>
		} // end difference
//		box { // clip
//			<0,-0.3,-3.0>,<1.6,0.3,0>
//			translate <20,0,-1.5>
//		}
		texture {
			pigment { color rgb<.221,.229,.222> }
		}
	} // end union


#declare SSF = 34; // stock scale factor
#declare M1Rifle = // shoots into +X, trigger into -Z
	union {
		
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "RifleHF.png"
			water_level .1
			scale <SSF,-0.6,SSF/3>
			translate <0,0.05,-8.4>			
			texture { StockTex }
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "RifleHF.png"
			water_level .1
			scale <SSF, 0.6,SSF/3>
			translate <0,-0.05,-8.4>			
			texture { StockTex }
		}
		cone { // stock front
			<0,0,0>,0.8,<7,0,0>,0.7
			scale <1,.7,1>
			translate <28,0,-0.2>
			texture { StockTex }
		}
		cylinder { // stock middle
			<0,0,0>,<7.8,0,0>,0.8
			scale <1,.7,1>
			translate <20,0,-0.2>
			texture { StockTex }
		}
/*
		cone { // stock
			<0,0,0>,2.6,<16,0,0>,1
			scale <1,0.2,1>
			rotate y*-10
			translate <0,0,-4>
		}
		cylinder { // stock front
			<0,0,0>,<20,0,0>,0.8
			scale <1,0.8,1>
			translate <12,0,-1>
		}
*/
		cylinder { // barrel
			<1,0,0>,<25,0,0>,0.30
			translate <15,0,0>
		}
		cylinder { // under barrel
			<1,0,0>,<24.5,0,0>,0.22
			translate <15,0,-0.6>
		}
		cylinder { // back barrel
			<0,0,0>,<16,0,0>,0.5
			translate <15,0,0>
		}
		cylinder { // end clip
			<0,0,0>,<0.8,0,0>,0.38
			translate <38.4,0,0>
		}
		cylinder { // end clip
			<0,0,0>,<0.8,0,0>,0.28
			translate <38.4,0,-0.6>
		}
		cylinder { // end clip middle
			<0,0,0>,<0.8,0,0>,0.18
			translate <38.4,0,-0.3>
		}
		object { RoundedBox2(0.7,0.2,1,0.13)
			translate <38.4,-0.1,-0.1>
		}

		cylinder { // bolt
			<0,-0.8,0>,<0,0.8,0>,0.35
			translate <16,0,0.4>
		}
		cylinder { // back screw
			<0,-0.6,0>,<0,0.6,0>,0.25
			translate <15.6,0,0.1>
		}
		object { RoundedBox2(1.6,1.4,0.8,0.15)
			translate <16,-0.7,-0.2>
		}
		object { RoundedBox2(9,1.4,0.5,0.15)
			translate <16,-0.7,-0.2>
		}

		difference {
			cylinder { // trigger guard
				<0,-0.1,0>,<0,0.1,0>,1.1
				scale <1,1,0.7>
			}
			cylinder {
				<0,-0.2,0>,<0,0.2,0>,0.9
				scale <1,1,0.7>
			}
			translate <15.5,0,-2.6>
		} // end difference
		sphere_sweep { // trigger
			catmull_rom_spline
			5,
			< 0.40,0, 0.5>,.125
			< 0.00,0, 0.0>,0.125
			<-0.25,0,-0.3>,0.085
			<-0.25,0,-0.8>,0.055
			< 0.15,0,-1.2>,0.055
			translate <15.5,0,-2.2>
		}
		box { // safety
			<0,-0.1,1>,<0.4,0.1,-0.7>
			translate <15.5+1.1,0,-2.2>
		}
		torus { // rear sling thing
			0.8,0.07
			scale <0.5,1,1>*1.4
			rotate <90,45,0>
			translate <4.5,0,-6.5>
		}
		torus { // front sling thing
			0.8,0.07
			scale <0.5,1,1>*1.4
			rotate <90,-45,0>
			translate <30.0,0,-1.5>
		}
		texture { GunMetalTex }
	} // end union

#declare M1RifleSlack =
	union {
		object { M1Rifle }
		object { SlackSling rotate y*-11 translate <4,0,-6.6>}
	} // end union

#declare M1RifleShoulder =
	union {
		object { M1Rifle }
		object { ShoulderSling rotate <60,-11,0> translate <4,0,-6.6>}
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderThisFile = 1)

#include "GIncludeRH.inc"
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <24, -5*Feet, 2*Feet>
		look_at <24,0,-10>
	}


light_source
{ <40*Feet,-35*Feet,40*Feet>, 2
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-35*Feet,10*Feet>, <1.13,0.93,.76>
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }


//object { TestSphere scale 20 translate <0,0,20> }
object { M1RifleShoulder rotate <0,0,-70> translate <0,0,9> }

#end
