
// Glenn's POV-Ray Scene File - Warfare
// created 26-Sep-01
// last update 30-Oct-01
// copyright 2001 Glenn McCarter (gmccarter@hotmail.com)
//
// This scene uses RH coordinate system: +Y is into the scene, +X to the right, Z = up.

                  
#version 3.5;
global_settings {
	adc_bailout 0.003922
//	ambient_light <1.0,1.0,1.0> // default
//	ambient_light <0.1,0.1,0.1>
	ambient_light <0.05,0.05,0.05> // render
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
//	post_process { focal_blur { 25, 200, 6, 3} }

   // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
/*
  radiosity{
    pretrace_start 0.08
    pretrace_end   0.04
    count 35             // CHANGE range from 20 to 150
    nearest_count 5      // CHANGE range from 3 to 10
    error_bound 1.8      // CHANGE - range from 1 to 3
    recursion_limit 3    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this
    
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
   // end radiosity section
*/
}


//===============================================
//             Scene Switches
//===============================================

#declare HeadlampOn = 0; // leave this off
#declare GoodSmoke = 0; // turn on to slow down rendering

//===============================================
//             Variables
//===============================================

// Scene origin (Z=0) is near the camera.

#declare CH = 11*12; // camera height
#declare HH = 0; // horizon height, buildings
#declare MH = CH-30; // medium zone height - grave area

#declare GS = .8; // global scene color saturation

#macro DS(FullColor) // Drop the Saturation of a Color based on global scene saturation
	#local HSVCol = CRGB2HSV(FullColor);
	#local HSVCol = rgb<HSVCol.red,HSVCol.green*GS,HSVCol.blue>;
   #local H = (HSVCol.red);
   #local S = (HSVCol.green);
   #local V = (HSVCol.blue);
   #local SatRGB = CH2RGB(H);
   #local RGB = ( ((1-S)*<1,1,1> + S*SatRGB) * V );
   color <RGB.red,RGB.green,RGB.blue,(HSVCol.filter),(HSVCol.transmit)>
	//#debug concat("NewRed is:",str(FullColor.red,0,3),"\n")
	//#debug concat("NewGreen is:",str(FullColor.green,0,3),"\n")
	//#debug concat("NewBlue is:",str(FullColor.blue,0,3),"\n")
#end


//===============================================
//             Includes
//===============================================

#include "Colors.inc"
#include "Shapes.inc"
#include "GIncludeRH.inc" // Glenn's standard includes
#include "Landscape.inc"
#include "Rifle.inc"
#include "SmallItems.inc"
#include "MilitaryTruck.inc"
#include "PackardCar2.inc"
#include "BattleDebris.inc"
#include "Building1.inc"
#include "Bridge.inc"
#include "SmokeFire.inc"

//#include "GRuler.inc" // for testing only

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <16/9, 0.0,  0.0>  // aspect ratio
//		right     <1.8, 0.0,  0.0>  // aspect ratio
		angle 55
	location <-11,-28,CH+20> // RENDER
	look_at <-6,0,CH+16>
/*	 // Focal Blur section: uncomment to enable focal blur
		blur_samples 100
		variance 1/10000
		aperture 0.5    //lower value = wider range in focus
		focal_point <0,0,0>
*/	 // end focal blur
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <1.333,     0.0,  0.0>
		angle 55
//	location <-11,-24,CH+20>
//	look_at <-6,0,CH+15>
	location <20*Feet,64*Feet,CH-20> // bridge
	look_at <50*Feet,102*Feet,HH-6> // bridge
	location <20*Feet,14*Feet,100*Feet> // building landscape
	look_at <10*Feet,130*Feet,0> //
	}


camera {
//	Special_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================


//===============================================
//             Lighting
//===============================================

#declare SoldierLightL =
	light_source { 
		<-18*Feet,36*Feet,CH+2*Feet> // test
		color rgb <0.820,0.863,0.631>*0.413
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <-5*Feet,21*Feet,MH+2.3*Feet> // rifle
		radius 5
		falloff 15
		tightness 3
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<1,1,.1> } finish {ambient 20} } } }
	}
//object { SoldierLightL }

#declare BootLight = // bring out treads
	light_source { 
		<-28*Feet,24*Feet,CH+8*Feet>
		color rgb <0.827,0.748,0.622>*0.3
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <-6.8*Feet,16*Feet,CH-4*Feet> // soldier boot
		radius 3
		falloff 8
		tightness 3
	}
//object { SoldierLightL }

#declare SoldierLightR = // intensify moon effect
	light_source { 
		<16*Feet,60*Feet,CH+7*Feet>
		color rgb <0.320,0.363,0.731>*0.9
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <-2.5*Feet,16.0*Feet,4*Feet+MH>
		radius 4
		falloff 10
		tightness 3
	}
//object { SoldierLightR }

#declare DarkLightR = // knocks down brightness of grave snowfield on RH side
	light_source { 
		<24*Feet,-20*Feet,CH+3*Feet>
		color rgb <0.64,0.63,0.54>*(-2.0)
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <10.0*Feet,26.0*Feet,0*Feet+MH>
		radius 4
		falloff 15
		tightness 3
	}
//object { SoldierLightR }

#declare LeftBuildingLight =
	light_source { 
//		<6*Feet,60*Feet,CH-7*Feet>
		<-70*Feet,80*Feet,CH+7*Feet>
		color rgb <0.820,0.863,0.631>*1.5 // ok
		area_light
		<24,0,0>,<0,0,24>,3,3
		circular
		orient
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <-24*Feet,135*Feet,CH-8*Feet>
		radius 4
		falloff 19
		tightness 3
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<.1,.6,1.1> } finish {ambient 20}} } }
	}
//object { BuildingLight }
//object { sphere{<0,0,0>,4*Feet texture{pigment{rgb<1,1,0>}}}translate <-24*Feet,135*Feet,CH-8*Feet>} // pointing test

#declare BlueLight = // for building left snow
	light_source { 
		<-16*Feet,40*Feet,CH+12*Feet>
		color rgb <0.621,0.643,0.731>*3.1 // perfect
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <-20*Feet,80*Feet,0>
		radius 4
		falloff 20
		tightness 3
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<1,1,.1> } finish {ambient 20} } } }
	}

#declare TruckBridgeLight =
	light_source { 
		<100*Feet,60*Feet,CH-7*Feet>
		color rgb <0.820,0.863,0.731>*1
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <50*Feet,90*Feet,CH-3*Feet>
		radius 44
		falloff 75
		tightness 3
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<.1,.6,1.1> } finish {ambient 20}} } }
	}
//object { TruckBridgeLight }

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.431>*2.3
	}
/*
object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*55 // towards right
  rotate z*60 // towards front
}
*/
#declare Moon =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.731>*.1
//		color rgb <0.680,0.663,0.531>*4.1
		area_light
		<0.4*Miles,0,0>,<0,0,0.4*Miles>,3,3
		circular
	}

object { Moon
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate x*-65 // towards North horizon
  rotate z*-20 // towards East
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.046, 0.045, 0.053> } // deep blue grey

sky_sphere { // dusky moody smoke
	pigment {
		gradient z
		color_map {
			[ 0.00 color rgb <0.070,0.068,0.036>*.2 ] // below ground level
			[ 0.05 color rgb <0.070,0.067,0.054>*.2 ] // horizon
			[ 0.07 color rgb <0.030,0.039,0.044>*.2 ] // cloud line
			[ 0.30 color rgb <0.006,0.008,0.012>*.2 ] // to vertical
			[ 0.995 color rgb <0.006,0.008,0.012>*.2 ] // to vertical
			[ 1.00 color rgb <0.070,0.068,0.036>*.2 ] // fuzzy mountains
		}
		turbulence 0.183
		omega 0.5		
		rotate y*-2
	}
}




//===============================================
//             Objects
//===============================================

// Soldier Pose
#declare Pose = 1;
#declare HPan     = 3;   // head, positive = towards his left
#declare HTiltFwd = 22;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 30;   // twists the hand, positive = palms up
#declare REAng    = 76;  // elbow
#declare RAFwd    = 43;   // total arm
#declare RARot    = 20;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = -3;    // claps hands
#declare RKnee    = 120;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 120;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 20;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LEAng    = 36;   // elbow
#declare LAFwd    = 12;   // total arm
#declare LARot    = 18;   // claps hands
#declare LAOut    = 70;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = -20;  // claps hands
#declare LKnee    = 124;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 45;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle
#include "Soldier.inc"



#declare STree = // simple tree, for testing
	union {
		sphere {
			<0,0,0>,16*Feet
			scale <.7,.7,1>
			translate <0,0,30*Feet>
		}
		cylinder {
			<0,0,0>,<0,0,20*Feet>,14
		}
		texture { pigment { color rgb<0.40,0.43,0.41> } }
	} // end union


#include "GMapleTree.inc"
#include "TOMTREE.inc"
#declare LargeMaple = object { TREE	rotate x*90 } // 1-inch tall
#include "GMapleTree3.inc"
#include "TOMTREE.inc"
#declare LargeMaple3 = object { TREE	rotate x*90 } // 1-inch tall


#include "Logo.inc"
object { Povray_Logo
	texture { // icy
		pigment { rgbt<.71,.71,1.0,0.76> }
		finish { ambient 0.5 specular 12.0 roughness 0.018 }
	}
	rotate <90,0,20> scale 4
	translate <-58,12.4*Feet,MH-15.8>
}

//===============================================
//             Object Placement
//===============================================


// LIGHT GROUPS

light_group {
	object { SoldierLightL }
	object { SoldierLightR }
	object { BootLight }
	object { DarkLightR }
	object { Soldier rotate y*-17 rotate z*(180+56) translate <-2.5*Feet,16.0*Feet,2.2*Feet+MH> }
	object { MilShovel rotate <0,12,48> translate <-14,16.8*Feet,MH-4> }
	object { RifleGroup rotate <0,1,160> translate <-5.2*Feet,21.4*Feet,MH+2> }
	object { GraveTerrain rotate <5,6,-20> translate <-16*Feet,9*Feet,-3.0*Feet+MH> }
	global_lights on
}

light_group {
	object { LeftBuildingLight }
	object { BlueLight }
	object { TruckBridgeLight }
	object { BuildingTerrain rotate <0,0,0> translate <-133*Feet,45*Feet,HH> }
	object { Building1Group rotate z*-15 translate <-34*Feet,135*Feet,HH> }
	object { LargeMaple scale 42*Feet rotate z*130 translate <41*Feet,118*Feet,HH> } // right center
	global_lights on
}

light_group {
	object { TruckBridgeLight }
	object { BurntTruck rotate <-8,-1.6,-160> translate <36*Feet,96*Feet,HH-19> }
	object { SmokeGroup translate <35*Feet,96*Feet,HH+22> }
	object { Bridge rotate z*36 translate <50*Feet,103*Feet,HH-9> }
	global_lights on
}

object { FieldTableGroup rotate z*30 translate <6,0,CH+6> } // this is a light group

// Following objects are only lit by the moon!
object { RiverTerrain rotate <0,0,0> translate <-380*Feet,70*Feet,HH-8> }
object { RiverTerrain rotate <0,0,0> translate <-100*Feet,1000*Feet,HH-8> } // under distant buildings
object { TreeMapleS scale <.71,1,.87> rotate <0,0,-30> translate <-40*Feet,120*Feet,24> } // tall shadow on building
object { TreeMaple3S scale <-.31,1,.21> rotate <0,0,-30> translate <-42*Feet,120*Feet,40> } // short shadow on building
object { TreeMapleS scale <1,1,.8> rotate <0,0,20> translate <-59*Feet,220*Feet,HH-12> } // left of building
object { TreeMaple4S scale <-1,1,.7> rotate <0,0,20> translate <28*Feet,220*Feet,HH-6*Feet> } // right of building
object { RoadTerrain rotate <0,0,0> translate <-40*Feet,30*Feet,HH-8> }
object { DistantWarfare translate <100*Feet,1200*Feet,0*Feet> }
object { FarSmoke translate <300*Feet,1200*Feet,0> }
object { TreeLine translate <30*Feet,1200*Feet,-8*Feet> }
object { DistantBuildingGroup translate <160*Feet,1100*Feet,HH> }
object { LargeMaple scale 44*Feet rotate z*-110 translate <-43*Feet,180*Feet,HH> } // far left
object { LargeMaple3 scale 52*Feet rotate z*-60 translate <12*Feet,190*Feet,HH-6*Feet> } // behind garage




