//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 10 materials and 46 primitives.
//
//  This file was generated for POV-Ray V3.1 by 
//  Txemi Jendrix
//  tji@euskalnet.net
//  http://www.geocities.com/txemijendrix
//  with
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 10/28/2001    (28.10.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/
#version unofficial MegaPOV 0.7;

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.
Comment merged from misil.mdl:
This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Render
  location  <     19.294,     -18.310,      14.782>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.52576,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         34.22415    // Vertical      22.816
  look_at   <     -1.143,      -5.904,       0.731>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <     -2.709,     -29.773,       7.832>
  sky       <    0.34406,    -0.06313,     0.93682> // Use right handed-system (rotated by 21.30 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34049,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         21.80250    // Vertical      16.352
  look_at   <      0.746,      -3.330,       0.227>
}

*/

/*
camera {  //  Camera StdCam_toma
  location  <    -12.194,     -13.992,       4.986>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35359,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         36.17474    // Vertical      27.131
  look_at   <     -3.387,      -4.708,       1.043>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  40.0
  fade_power 2.0
  translate  <21.30714, -19.084969, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "tomahawk2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare cuerpotimon = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.1, 1.5>
    translate  1.5*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.05, 1.3>
    translate  1.35*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.5>
    rotate 15.0*y
    translate  <1.0, 0.0, 3.5>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.2, 0.5>
    rotate -15.0*y
    translate  <-1.0, 0.0, 3.5>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 1.5>
    rotate -5.0*y
    translate  <2.25, 0.0, 1.5>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 1.5>
    rotate 5.0*y
    translate  <-2.25, 0.0, 1.5>
  }
  scale <1.2, 1.0, 1.2>
}
#declare timon01 = union {
  object { cuerpotimon }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.05, 0.5>
    rotate -20.0*y
    translate  <-2.5, 0.0, 2.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.22>
    rotate -90.0*x
    translate  <-1.6, -0.11, 2.35>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.05, 0.5>
    rotate 20.0*y
    translate  <2.5, 0.0, 2.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.22>
    rotate -90.0*x
    translate  <1.6, -0.11, 2.35>
  }
}
#declare timonup01 = difference {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.05, 0.8>
    translate  21.0*z
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.1, 0.8>
    rotate -35.0*y
    translate  <-1.2, 0.0, 22.2>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 0.1, 0.8>
    rotate 35.0*y
    translate  <1.2, 0.0, 22.2>
  }
  material {
    rojo_txt
  }
}
#declare ala1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002647, -7.997276, 2.347038>, <0.002221, -7.459407, 2.577418>, <-0.002647, -6.654130, 2.592470>, <-0.002647, -6.077232, 2.690406>, 
      <0.494721, -7.997276, 2.372138>, <0.499589, -7.459407, 2.602518>, <0.494721, -6.654130, 2.617571>, <0.494721, -6.077232, 2.715506>, 
      <0.171581, -7.997276, 1.947663>, <0.222818, -7.423548, 1.949126>, <0.171544, -6.653246, 2.047889>, <0.171544, -6.077232, 2.047889>, 
      <0.171684, -7.997276, 1.765544>, <0.222922, -7.423548, 1.767007>, <0.171684, -6.653246, 1.765544>, <0.171684, -6.077232, 1.765544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225175, -7.997276, 1.765909>, <-0.278737, -7.423761, 1.767467>, <-0.225175, -6.653246, 1.765909>, <-0.225175, -6.077232, 1.765909>, 
      <-0.225281, -7.997276, 1.952592>, <-0.278843, -7.423761, 1.954150>, <-0.225316, -6.653246, 2.051179>, <-0.225316, -6.077232, 2.051179>, 
      <-0.440009, -7.997276, 2.324965>, <-0.435141, -7.459407, 2.555346>, <-0.440009, -6.654130, 2.570398>, <-0.440009, -6.077232, 2.668334>, 
      <-0.002647, -7.997276, 2.347038>, <0.002221, -7.459407, 2.577418>, <-0.002647, -6.654130, 2.592470>, <-0.002647, -6.077232, 2.690406>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002647, -6.077232, 2.690406>, <-0.002647, -5.440505, 2.798498>, <-0.002647, -4.590574, 2.937174>, <-0.002647, -3.952002, 3.033774>, 
      <0.494721, -6.077232, 2.715506>, <0.494721, -5.440505, 2.823599>, <0.494721, -4.590574, 2.962275>, <0.494721, -3.952002, 3.058875>, 
      <0.171544, -6.077232, 2.047889>, <0.171544, -5.439663, 2.047889>, <0.171516, -4.589571, 2.149591>, <0.171516, -3.952002, 2.149591>, 
      <0.171684, -6.077232, 1.765544>, <0.171684, -5.439663, 1.765544>, <0.171684, -4.589571, 1.765544>, <0.171684, -3.952002, 1.765544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225175, -6.077232, 1.765909>, <-0.225175, -5.439663, 1.765909>, <-0.225175, -4.589571, 1.765909>, <-0.225175, -3.952002, 1.765909>, 
      <-0.225316, -6.077232, 2.051179>, <-0.225316, -5.439663, 2.051179>, <-0.225344, -4.589571, 2.152082>, <-0.225344, -3.952002, 2.152082>, 
      <-0.440009, -6.077232, 2.668334>, <-0.440009, -5.440505, 2.776426>, <-0.440009, -4.590574, 2.915102>, <-0.440009, -3.952002, 3.011702>, 
      <-0.002647, -6.077232, 2.690406>, <-0.002647, -5.440505, 2.798498>, <-0.002647, -4.590574, 2.937174>, <-0.002647, -3.952002, 3.033774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001324, -6.077232, 0.013482>, <-0.001324, -6.653246, 0.013482>, <0.023762, -6.926558, -0.011579>, <-0.001324, -7.997276, 0.013482>, 
      <-0.192474, -6.077232, 0.937480>, <-0.192474, -6.653246, 0.937480>, <-0.167388, -6.926558, 0.912419>, <-0.192474, -7.997276, 0.937480>, 
      <-0.224913, -6.077232, 1.235909>, <-0.224913, -6.653246, 1.235909>, <-0.278436, -7.423761, 1.237467>, <-0.224874, -7.997276, 1.235909>, 
      <-0.225175, -6.077232, 1.765909>, <-0.225175, -6.653246, 1.765909>, <-0.278737, -7.423761, 1.767467>, <-0.225175, -7.997276, 1.765909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171684, -6.077232, 1.765544>, <0.171684, -6.653246, 1.765544>, <0.222922, -7.423548, 1.767007>, <0.171684, -7.997276, 1.765544>, 
      <0.171945, -6.077232, 1.237370>, <0.171945, -6.653246, 1.237370>, <0.223221, -7.423548, 1.238832>, <0.171984, -7.997276, 1.237370>, 
      <0.199298, -6.077232, 0.963649>, <0.199298, -6.653246, 0.963649>, <0.224384, -6.926558, 0.938589>, <0.199298, -7.997276, 0.963649>, 
      <-0.001324, -6.077232, 0.013482>, <-0.001324, -6.653246, 0.013482>, <0.023762, -6.926558, -0.011579>, <-0.001324, -7.997276, 0.013482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002647, -3.952002, 3.033774>, <-0.002647, -3.364797, 3.122603>, <-0.002647, -2.581075, 3.236758>, <-0.002647, -1.991535, 3.308469>, 
      <0.494721, -3.952002, 3.058875>, <0.494721, -3.364797, 3.147704>, <0.494721, -2.581075, 3.261858>, <0.494721, -1.991535, 3.333569>, 
      <0.171516, -3.952002, 2.149591>, <0.171516, -3.363862, 2.149591>, <0.171497, -2.579675, 2.231367>, <0.171497, -1.991535, 2.231367>, 
      <0.171684, -3.952002, 1.765544>, <0.171684, -3.363862, 1.765544>, <0.171684, -2.579675, 1.765544>, <0.171684, -1.991535, 1.765544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225175, -3.952002, 1.765909>, <-0.225175, -3.363862, 1.765909>, <-0.225175, -2.579675, 1.765909>, <-0.225175, -1.991535, 1.765909>, 
      <-0.225344, -3.952002, 2.152082>, <-0.225344, -3.363862, 2.152082>, <-0.225363, -2.579675, 2.233467>, <-0.225363, -1.991535, 2.233467>, 
      <-0.440009, -3.952002, 3.011702>, <-0.440009, -3.364797, 3.100531>, <-0.440009, -2.581075, 3.214686>, <-0.440009, -1.991535, 3.286396>, 
      <-0.002647, -3.952002, 3.033774>, <-0.002647, -3.364797, 3.122603>, <-0.002647, -2.581075, 3.236758>, <-0.002647, -1.991535, 3.308469>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001324, -3.952002, 0.013482>, <-0.001324, -4.589571, 0.013482>, <-0.001324, -5.439663, 0.013482>, <-0.001324, -6.077232, 0.013482>, 
      <-0.192474, -3.952002, 0.937480>, <-0.192474, -4.589571, 0.937480>, <-0.192474, -5.439663, 0.937480>, <-0.192474, -6.077232, 0.937480>, 
      <-0.224942, -3.952002, 1.235909>, <-0.224942, -4.589571, 1.235909>, <-0.224913, -5.439663, 1.235909>, <-0.224913, -6.077232, 1.235909>, 
      <-0.225175, -3.952002, 1.765909>, <-0.225175, -4.589571, 1.765909>, <-0.225175, -5.439663, 1.765909>, <-0.225175, -6.077232, 1.765909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171684, -3.952002, 1.765544>, <0.171684, -4.589571, 1.765544>, <0.171684, -5.439663, 1.765544>, <0.171684, -6.077232, 1.765544>, 
      <0.171916, -3.952002, 1.237370>, <0.171916, -4.589571, 1.237370>, <0.171945, -5.439663, 1.237370>, <0.171945, -6.077232, 1.237370>, 
      <0.199298, -3.952002, 0.963649>, <0.199298, -4.589571, 0.963649>, <0.199298, -5.439663, 0.963649>, <0.199298, -6.077232, 0.963649>, 
      <-0.001324, -3.952002, 0.013482>, <-0.001324, -4.589571, 0.013482>, <-0.001324, -5.439663, 0.013482>, <-0.001324, -6.077232, 0.013482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002647, -1.991535, 3.308469>, <-0.002647, -1.395281, 3.380996>, <-0.002647, -0.597461, 3.452683>, <-0.002647, 0.000000, 3.514490>, 
      <0.494721, -1.991535, 3.333569>, <0.494721, -1.395281, 3.406096>, <0.494721, -0.597461, 3.477784>, <0.494721, 0.000000, 3.539590>, 
      <0.171497, -1.991535, 2.231367>, <0.171497, -1.394075, 2.231367>, <0.171485, -0.597461, 2.292828>, <0.171485, 0.000000, 2.292828>, 
      <0.171684, -1.991535, 1.765544>, <0.171684, -1.394075, 1.765544>, <0.171684, -0.597461, 1.765544>, <0.171684, 0.000000, 1.765544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225175, -1.991535, 1.765909>, <-0.225175, -1.394075, 1.765909>, <-0.225175, -0.597461, 1.765909>, <-0.225175, 0.000000, 1.765909>, 
      <-0.225363, -1.991535, 2.233467>, <-0.225363, -1.394075, 2.233467>, <-0.225375, -0.597461, 2.294714>, <-0.225375, 0.000000, 2.294714>, 
      <-0.440009, -1.991535, 3.286396>, <-0.440009, -1.395281, 3.358924>, <-0.440009, -0.597461, 3.430611>, <-0.440009, 0.000000, 3.492417>, 
      <-0.002647, -1.991535, 3.308469>, <-0.002647, -1.395281, 3.380996>, <-0.002647, -0.597461, 3.452683>, <-0.002647, 0.000000, 3.514490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001324, -1.991535, 0.013482>, <-0.001324, -2.579675, 0.013482>, <-0.001324, -3.363862, 0.013482>, <-0.001324, -3.952002, 0.013482>, 
      <-0.192474, -1.991535, 0.937480>, <-0.192474, -2.579675, 0.937480>, <-0.192474, -3.363862, 0.937480>, <-0.192474, -3.952002, 0.937480>, 
      <-0.224962, -1.991535, 1.235909>, <-0.224962, -2.579675, 1.235909>, <-0.224942, -3.363862, 1.235909>, <-0.224942, -3.952002, 1.235909>, 
      <-0.225175, -1.991535, 1.765909>, <-0.225175, -2.579675, 1.765909>, <-0.225175, -3.363862, 1.765909>, <-0.225175, -3.952002, 1.765909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171684, -1.991535, 1.765544>, <0.171684, -2.579675, 1.765544>, <0.171684, -3.363862, 1.765544>, <0.171684, -3.952002, 1.765544>, 
      <0.171896, -1.991535, 1.237370>, <0.171896, -2.579675, 1.237370>, <0.171916, -3.363862, 1.237370>, <0.171916, -3.952002, 1.237370>, 
      <0.199298, -1.991535, 0.963649>, <0.199298, -2.579675, 0.963649>, <0.199298, -3.363862, 0.963649>, <0.199298, -3.952002, 0.963649>, 
      <-0.001324, -1.991535, 0.013482>, <-0.001324, -2.579675, 0.013482>, <-0.001324, -3.363862, 0.013482>, <-0.001324, -3.952002, 0.013482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001324, 0.000000, 0.013482>, <-0.001324, -0.597461, 0.013482>, <-0.001324, -1.394075, 0.013482>, <-0.001324, -1.991535, 0.013482>, 
      <-0.192474, 0.000000, 0.937480>, <-0.192474, -0.597461, 0.937480>, <-0.192474, -1.394075, 0.937480>, <-0.192474, -1.991535, 0.937480>, 
      <-0.224974, 0.000000, 1.235909>, <-0.224974, -0.597461, 1.235909>, <-0.224962, -1.394075, 1.235909>, <-0.224962, -1.991535, 1.235909>, 
      <-0.225175, 0.000000, 1.765909>, <-0.225175, -0.597461, 1.765909>, <-0.225175, -1.394075, 1.765909>, <-0.225175, -1.991535, 1.765909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171684, 0.000000, 1.765544>, <0.171684, -0.597461, 1.765544>, <0.171684, -1.394075, 1.765544>, <0.171684, -1.991535, 1.765544>, 
      <0.171884, 0.000000, 1.237370>, <0.171884, -0.597461, 1.237370>, <0.171896, -1.394075, 1.237370>, <0.171896, -1.991535, 1.237370>, 
      <0.199298, 0.000000, 0.963649>, <0.199298, -0.597461, 0.963649>, <0.199298, -1.394075, 0.963649>, <0.199298, -1.991535, 0.963649>, 
      <-0.001324, 0.000000, 0.013482>, <-0.001324, -0.597461, 0.013482>, <-0.001324, -1.394075, 0.013482>, <-0.001324, -1.991535, 0.013482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002647, -7.997276, 2.347038>, <-0.002647, -7.997276, 2.347038>, <-0.002647, -7.997276, 2.347038>, <-0.002647, -7.997276, 2.347038>, 
      <0.494721, -7.997276, 2.372138>, <0.493126, -8.173541, 2.296641>, <0.493126, -8.173541, 2.296641>, <-0.004243, -8.173541, 2.271540>, 
      <0.171581, -7.997276, 1.947663>, <0.163090, -8.092356, 1.947421>, <0.073042, -8.249435, 1.951680>, <-0.022416, -8.249435, 1.951768>, 
      <0.171684, -7.997276, 1.765544>, <0.163193, -8.092356, 1.765302>, <0.073151, -8.249435, 1.759921>, <-0.022307, -8.249435, 1.760008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225175, -7.997276, 1.765909>, <-0.225175, -7.997276, 1.765909>, <-0.225175, -7.997276, 1.765909>, <-0.225175, -7.997276, 1.765909>, 
      <-0.225281, -7.997276, 1.952592>, <-0.216251, -8.093962, 1.952330>, <-0.216251, -8.093962, 1.952330>, <-0.216145, -8.093962, 1.765646>, 
      <-0.440009, -7.997276, 2.324965>, <-0.441605, -8.173541, 2.249468>, <-0.119523, -8.249435, 1.951857>, <-0.119414, -8.249435, 1.760098>, 
      <-0.002647, -7.997276, 2.347038>, <-0.004243, -8.173541, 2.271540>, <-0.022416, -8.249435, 1.951768>, <-0.022307, -8.249435, 1.760008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001324, -7.997276, 0.013482>, <-0.001324, -7.997276, 0.013482>, <-0.001324, -7.997276, 0.013482>, <-0.001324, -7.997276, 0.013482>, 
      <-0.192474, -7.997276, 0.937480>, <-0.284053, -8.223184, 1.806599>, <-0.284053, -8.223184, 1.806599>, <-0.092902, -8.223184, 0.882602>, 
      <-0.224874, -7.997276, 1.235909>, <-0.215844, -8.093962, 1.235647>, <-0.119113, -8.249435, 1.230670>, <-0.022007, -8.249435, 1.230580>, 
      <-0.225175, -7.997276, 1.765909>, <-0.216145, -8.093962, 1.765646>, <-0.119414, -8.249435, 1.760098>, <-0.022307, -8.249435, 1.760008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171684, -7.997276, 1.765544>, <0.171684, -7.997276, 1.765544>, <0.171684, -7.997276, 1.765544>, <0.171684, -7.997276, 1.765544>, 
      <0.171984, -7.997276, 1.237370>, <0.163493, -8.092356, 1.237127>, <0.163493, -8.092356, 1.237127>, <0.163193, -8.092356, 1.765302>, 
      <0.199298, -7.997276, 0.963649>, <0.107719, -8.223184, 1.832769>, <0.073451, -8.249435, 1.230493>, <0.073151, -8.249435, 1.759921>, 
      <-0.001324, -7.997276, 0.013482>, <-0.092902, -8.223184, 0.882602>, <-0.022007, -8.249435, 1.230580>, <-0.022307, -8.249435, 1.760008>
    }
  }
  scale <0.1, 0.3, 0.3>
  rotate -90.0*z
  translate  <-0.220469, 0.0, 5.511733>
}
#declare timon1 = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.005, 0.5>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.2, 0.5>
    rotate -30.0*y
    translate  <-1.05, 0.0, 0.75>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.2, 0.5>
    rotate 30.0*y
    translate  <1.05, 0.0, 0.75>
  }
  material {
    rojo_txt
  }
}




//
// ********  OBJECTS  *******
//

#version unofficial megapov 0.7;
	glow
	{
		type 1
		size 1.000
		radius 0.000
		warp {turbulence   1}
		location <-156.399,52.629,-68.782>
		color rgb <1.000,0.800,0.000>
	}

#include "skelton1.pov";

#declare misilbody = union {
  cone { // Cone001
    <0,0,0>, 0.775, <0,0,1>, 1.0
    scale <1.0, 1.0, 14.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <1.0, 1.0, 6.0>
    translate  14.0*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.5>
    translate  19.75*z
  }
  cone { // Cone002
    <0,0,0>, 0.25, <0,0,1>, 0.05
    scale <1.0, 1.0, 0.75>
    translate  22.25*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    translate  23.0*z
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      rojo_txt
    }
    scale 0.25
    translate  23.25*z
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      rojo_txt
    }
    scale <0.15, 0.15, 0.5>
    translate  23.5*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      rojo_txt
    }
    scale <0.15, 0.15, 0.225>
    translate  24.0*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      rojo_txt
    }
    scale <0.3, 0.3, 0.45>
    translate  19.75*z
  }
  material {
    blanco_txt
  }
  scale <1.5, 1.5, 1.0>
}
#declare Paveway_ = union {
  object { misilbody }
  object { timon01 }
  object { // timon02 -> timon01
    timon01
    rotate -90.0*z
  }
  object { timonup01 }
  object { // timonup02 -> timonup01
    timonup01
    rotate -90.0*z
  }
  cone { // Cone003
    <0,0,0>, 1.175, <0,0,1>, 1.275
    scale <1.0, 1.0, 3.7>
    translate  -0.05*z
  }
  cone { // llama1
    <0,0,0>, 0.0, <0,0,1>, 0.5181
    material {
      llama_txt_1
    }
    hollow
    scale <2.0, 2.0, 15.0>
    translate  -15.0*z
  }
  material {
    cuerpo_txt_1
  }
  hollow
  scale 0.4
  rotate -91.0*x
  translate  <-3.719396, -8.167187, -2.26>
}
#declare DeathPave = union {
  object { MeshObj1 }
  object { Paveway_ }
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.325893, -1.268428, 4.081470>, <-1.409533, -1.287560, 4.080414>, <-1.481550, -1.422346, 4.072980>, <-1.481550, -1.508023, 4.068253>, 
      <-1.000892, -1.327157, 3.860188>, <-1.084532, -1.346289, 3.859133>, <-1.108146, -1.422346, 3.848784>, <-1.108146, -1.508023, 3.844058>, 
      <-0.425612, -1.431113, 3.928280>, <-0.428121, -1.431687, 3.928249>, <-0.475577, -1.505452, 3.924180>, <-0.475577, -1.508023, 3.924038>, 
      <-0.039777, -1.500835, 3.862628>, <-0.042286, -1.501409, 3.862596>, <-0.044447, -1.505452, 3.862373>, <-0.044447, -1.508023, 3.862232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.524015, -1.232627, 4.873191>, <-1.620153, -1.254617, 4.871978>, <-1.702930, -1.409544, 4.863432>, <-1.702930, -1.508023, 4.858000>, 
      <-1.470059, -1.242377, 4.634328>, <-1.566197, -1.264368, 4.633114>, <-1.642586, -1.409544, 4.624890>, <-1.642586, -1.508023, 4.619458>, 
      <-1.526249, -1.232223, 4.217884>, <-1.609889, -1.251355, 4.216829>, <-1.692503, -1.422346, 4.199638>, <-1.692503, -1.508023, 4.194912>, 
      <-1.325893, -1.268428, 4.081470>, <-1.409533, -1.287560, 4.080414>, <-1.481550, -1.422346, 4.072980>, <-1.481550, -1.508023, 4.068253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.621292, -1.215048, 5.389214>, <-1.723567, -1.238442, 5.387923>, <-1.811628, -1.403258, 5.378832>, <-1.811628, -1.508023, 5.373052>, 
      <-1.538798, -1.235381, 5.256451>, <-1.641073, -1.258776, 5.255161>, <-1.721185, -1.403258, 5.249377>, <-1.721185, -1.508023, 5.243598>, 
      <-1.558717, -1.226356, 5.026818>, <-1.654855, -1.248347, 5.025605>, <-1.741660, -1.409544, 5.016529>, <-1.741660, -1.508023, 5.011096>, 
      <-1.524015, -1.232627, 4.873191>, <-1.620153, -1.254617, 4.871978>, <-1.702930, -1.409544, 4.863432>, <-1.702930, -1.508023, 4.858000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.781640, -1.169128, 5.287801>, <-1.897900, -1.197121, 5.286334>, <-1.990800, -1.388595, 5.276301>, <-1.990800, -1.508023, 5.270042>, 
      <-1.752774, -1.176516, 5.338215>, <-1.869034, -1.204509, 5.336748>, <-1.957520, -1.388595, 5.328615>, <-1.957520, -1.508023, 5.322356>, 
      <-1.651941, -1.207494, 5.438538>, <-1.754216, -1.230888, 5.437248>, <-1.847137, -1.403258, 5.429658>, <-1.847137, -1.508023, 5.423879>, 
      <-1.621292, -1.215048, 5.389214>, <-1.723567, -1.238442, 5.387923>, <-1.811628, -1.403258, 5.378832>, <-1.811628, -1.508023, 5.373052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.155007, 4.979510>, <-1.976979, -1.184167, 4.977982>, <-2.073750, -1.383619, 4.967530>, <-2.073750, -1.508023, 4.961010>, 
      <-1.833604, -1.159244, 5.071997>, <-1.954709, -1.188403, 5.070469>, <-2.048865, -1.383619, 5.060240>, <-2.048865, -1.508023, 5.053720>, 
      <-1.828578, -1.157114, 5.205824>, <-1.944838, -1.185107, 5.204356>, <-2.042323, -1.388595, 5.195309>, <-2.042323, -1.508023, 5.189050>, 
      <-1.781640, -1.169128, 5.287801>, <-1.897900, -1.197121, 5.286334>, <-1.990800, -1.388595, 5.276301>, <-1.990800, -1.508023, 5.270042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.481550, -1.508023, 4.068253>, <-1.481550, -1.593700, 4.063527>, <-1.409533, -1.728486, 4.056090>, <-1.325893, -1.747618, 4.055035>, 
      <-1.108146, -1.508023, 3.844058>, <-1.108146, -1.593700, 3.839332>, <-1.082576, -1.669403, 3.839995>, <-0.998935, -1.688535, 3.838940>, 
      <-0.475577, -1.508023, 3.924038>, <-0.475577, -1.510593, 3.923896>, <-0.428121, -1.584359, 3.919826>, <-0.425612, -1.584933, 3.919795>, 
      <-0.044447, -1.508023, 3.862232>, <-0.044447, -1.510593, 3.862090>, <-0.042286, -1.514636, 3.861866>, <-0.039777, -1.515211, 3.861835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.702930, -1.508023, 4.858000>, <-1.702930, -1.606502, 4.852567>, <-1.620153, -1.761428, 4.844020>, <-1.524015, -1.783419, 4.842806>, 
      <-1.642586, -1.508023, 4.619458>, <-1.642586, -1.606502, 4.614025>, <-1.566219, -1.751682, 4.606329>, <-1.470081, -1.773673, 4.605116>, 
      <-1.692503, -1.508023, 4.194912>, <-1.692503, -1.593700, 4.190185>, <-1.610757, -1.764848, 4.189084>, <-1.527117, -1.783980, 4.188029>, 
      <-1.481550, -1.508023, 4.068253>, <-1.481550, -1.593700, 4.063527>, <-1.409533, -1.728486, 4.056090>, <-1.325893, -1.747618, 4.055035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.811628, -1.508023, 5.373052>, <-1.811628, -1.612788, 5.367273>, <-1.723567, -1.777603, 5.358180>, <-1.621292, -1.800998, 5.356889>, 
      <-1.721185, -1.508023, 5.243598>, <-1.721185, -1.612788, 5.237818>, <-1.640645, -1.757165, 5.226381>, <-1.538370, -1.780559, 5.225090>, 
      <-1.741660, -1.508023, 5.011096>, <-1.741660, -1.606502, 5.005664>, <-1.654878, -1.767703, 4.997054>, <-1.558739, -1.789694, 4.995841>, 
      <-1.702930, -1.508023, 4.858000>, <-1.702930, -1.606502, 4.852567>, <-1.620153, -1.761428, 4.844020>, <-1.524015, -1.783419, 4.842806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.990800, -1.508023, 5.270042>, <-1.990800, -1.627451, 5.263783>, <-1.897900, -1.818925, 5.253748>, <-1.781640, -1.846918, 5.252280>, 
      <-1.957520, -1.508023, 5.322356>, <-1.957520, -1.627451, 5.316097>, <-1.869031, -1.811536, 5.304744>, <-1.752771, -1.839529, 5.303276>, 
      <-1.847137, -1.508023, 5.423879>, <-1.847137, -1.612788, 5.418100>, <-1.754753, -1.785290, 5.407748>, <-1.652479, -1.808684, 5.406458>, 
      <-1.811628, -1.508023, 5.373052>, <-1.811628, -1.612788, 5.367273>, <-1.723567, -1.777603, 5.358180>, <-1.621292, -1.800998, 5.356889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.632427, 4.954491>, <-1.976979, -1.831879, 4.944037>, <-1.855875, -1.861038, 4.942509>, 
      <-2.048865, -1.508023, 5.053720>, <-2.048865, -1.632427, 5.047200>, <-1.954709, -1.827643, 5.036968>, <-1.833604, -1.856802, 5.035440>, 
      <-2.042323, -1.508023, 5.189050>, <-2.042323, -1.627451, 5.182791>, <-1.944654, -1.830891, 5.171158>, <-1.828394, -1.858884, 5.169691>, 
      <-1.990800, -1.508023, 5.270042>, <-1.990800, -1.627451, 5.263783>, <-1.897900, -1.818925, 5.253748>, <-1.781640, -1.846918, 5.252280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.325893, -1.747618, 4.055035>, <-0.937080, -1.836555, 4.050128>, <-0.398885, -1.846912, 4.049557>, <0.000000, -1.846912, 4.049557>, 
      <-0.998935, -1.688535, 3.838940>, <-0.610122, -1.777472, 3.834033>, <-0.398885, -1.805718, 3.943702>, <0.000000, -1.805718, 3.943702>, 
      <-0.425612, -1.584933, 3.919795>, <-0.413947, -1.587601, 3.919648>, <-0.011967, -1.616806, 3.918036>, <0.000000, -1.616806, 3.918036>, 
      <-0.039777, -1.515211, 3.861835>, <-0.028112, -1.517879, 3.861688>, <-0.011967, -1.518189, 3.861670>, <0.000000, -1.518189, 3.861670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.524015, -1.783419, 4.842806>, <-1.077103, -1.885646, 4.837167>, <-0.458489, -1.897550, 4.836511>, <0.000000, -1.897550, 4.836511>, 
      <-1.470081, -1.773673, 4.605116>, <-1.023170, -1.875899, 4.599476>, <-0.458489, -1.883840, 4.600334>, <0.000000, -1.883840, 4.600334>, 
      <-1.527117, -1.783980, 4.188029>, <-1.138304, -1.872917, 4.183122>, <-0.398885, -1.932708, 4.270026>, <0.000000, -1.932708, 4.270026>, 
      <-1.325893, -1.747618, 4.055035>, <-0.937080, -1.836555, 4.050128>, <-0.398885, -1.846912, 4.049557>, <0.000000, -1.846912, 4.049557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.621292, -1.800998, 5.356889>, <-1.145855, -1.909749, 5.350890>, <-0.487754, -1.922414, 5.350192>, <0.000000, -1.922414, 5.350192>, 
      <-1.538370, -1.780559, 5.225090>, <-1.062932, -1.889310, 5.219091>, <-0.487754, -1.889277, 5.199508>, <0.000000, -1.889277, 5.199508>, 
      <-1.558739, -1.789694, 4.995841>, <-1.111828, -1.891920, 4.990202>, <-0.458489, -1.906492, 4.990536>, <0.000000, -1.906492, 4.990536>, 
      <-1.524015, -1.783419, 4.842806>, <-1.077103, -1.885646, 4.837167>, <-0.458489, -1.897550, 4.836511>, <0.000000, -1.897550, 4.836511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.781640, -1.846918, 5.252280>, <-1.260421, -1.972416, 5.245703>, <-0.536155, -1.987365, 5.244920>, <0.000000, -1.987365, 5.244920>, 
      <-1.752771, -1.839529, 5.303276>, <-1.231552, -1.965027, 5.296700>, <-0.536155, -1.979931, 5.281277>, <0.000000, -1.979931, 5.281277>, 
      <-1.652479, -1.808684, 5.406458>, <-1.177041, -1.917436, 5.400458>, <-0.487754, -1.930384, 5.386434>, <0.000000, -1.930384, 5.386434>, 
      <-1.621292, -1.800998, 5.356889>, <-1.145855, -1.909749, 5.350890>, <-0.487754, -1.922414, 5.350192>, <0.000000, -1.922414, 5.350192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.861038, 4.942509>, <-1.312939, -1.991766, 4.935658>, <-0.558495, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, 
      <-1.833604, -1.856802, 5.035440>, <-1.290669, -1.987530, 5.028589>, <-0.558495, -2.001346, 5.027866>, <0.000000, -2.001346, 5.027866>, 
      <-1.828394, -1.858884, 5.169691>, <-1.307176, -1.984383, 5.163114>, <-0.536155, -2.006038, 5.153594>, <0.000000, -2.006038, 5.153594>, 
      <-1.781640, -1.846918, 5.252280>, <-1.260421, -1.972416, 5.245703>, <-0.536155, -1.987365, 5.244920>, <0.000000, -1.987365, 5.244920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.846912, 4.049557>, <0.398885, -1.846912, 4.049557>, <0.937080, -1.836555, 4.050128>, <1.325893, -1.747618, 4.055035>, 
      <0.000000, -1.805718, 3.943702>, <0.398885, -1.805718, 3.943702>, <0.610122, -1.777472, 3.834033>, <0.998935, -1.688535, 3.838940>, 
      <0.000000, -1.616806, 3.918036>, <0.011967, -1.616806, 3.918036>, <0.413947, -1.587601, 3.919648>, <0.425612, -1.584933, 3.919795>, 
      <0.000000, -1.518189, 3.861670>, <0.011967, -1.518189, 3.861670>, <0.028112, -1.517879, 3.861688>, <0.039777, -1.515211, 3.861835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.897550, 4.836511>, <0.458489, -1.897550, 4.836511>, <1.077103, -1.885646, 4.837167>, <1.524015, -1.783419, 4.842806>, 
      <0.000000, -1.883840, 4.600334>, <0.458489, -1.883840, 4.600334>, <1.023170, -1.875899, 4.599476>, <1.470081, -1.773673, 4.605116>, 
      <0.000000, -1.932708, 4.270026>, <0.398885, -1.932708, 4.270026>, <1.138304, -1.872917, 4.183122>, <1.527117, -1.783980, 4.188029>, 
      <0.000000, -1.846912, 4.049557>, <0.398885, -1.846912, 4.049557>, <0.937080, -1.836555, 4.050128>, <1.325893, -1.747618, 4.055035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.922414, 5.350192>, <0.487754, -1.922414, 5.350192>, <1.145855, -1.909749, 5.350890>, <1.621292, -1.800998, 5.356889>, 
      <0.000000, -1.889277, 5.199508>, <0.487754, -1.889277, 5.199508>, <1.062932, -1.889310, 5.219091>, <1.538370, -1.780559, 5.225090>, 
      <0.000000, -1.906492, 4.990536>, <0.458489, -1.906492, 4.990536>, <1.111828, -1.891920, 4.990202>, <1.558739, -1.789694, 4.995841>, 
      <0.000000, -1.897550, 4.836511>, <0.458489, -1.897550, 4.836511>, <1.077103, -1.885646, 4.837167>, <1.524015, -1.783419, 4.842806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.987365, 5.244920>, <0.536155, -1.987365, 5.244920>, <1.260421, -1.972416, 5.245703>, <1.781640, -1.846918, 5.252280>, 
      <0.000000, -1.979931, 5.281277>, <0.536155, -1.979931, 5.281277>, <1.231552, -1.965027, 5.296700>, <1.752771, -1.839529, 5.303276>, 
      <0.000000, -1.930384, 5.386434>, <0.487754, -1.930384, 5.386434>, <1.177041, -1.917436, 5.400458>, <1.652479, -1.808684, 5.406458>, 
      <0.000000, -1.922414, 5.350192>, <0.487754, -1.922414, 5.350192>, <1.145855, -1.909749, 5.350890>, <1.621292, -1.800998, 5.356889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.007337, 4.934842>, <0.558495, -2.007337, 4.934842>, <1.312939, -1.991766, 4.935658>, <1.855875, -1.861038, 4.942509>, 
      <0.000000, -2.001346, 5.027866>, <0.558495, -2.001346, 5.027866>, <1.290669, -1.987530, 5.028589>, <1.833604, -1.856802, 5.035440>, 
      <0.000000, -2.006038, 5.153594>, <0.536155, -2.006038, 5.153594>, <1.307176, -1.984383, 5.163114>, <1.828394, -1.858884, 5.169691>, 
      <0.000000, -1.987365, 5.244920>, <0.536155, -1.987365, 5.244920>, <1.260421, -1.972416, 5.245703>, <1.781640, -1.846918, 5.252280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.325893, -1.747618, 4.055035>, <1.409533, -1.728486, 4.056090>, <1.481550, -1.593700, 4.063527>, <1.481550, -1.508023, 4.068253>, 
      <0.998935, -1.688535, 3.838940>, <1.082576, -1.669403, 3.839995>, <1.108146, -1.593700, 3.839332>, <1.108146, -1.508023, 3.844058>, 
      <0.425612, -1.584933, 3.919795>, <0.428121, -1.584359, 3.919826>, <0.475577, -1.510593, 3.923896>, <0.475577, -1.508023, 3.924038>, 
      <0.039777, -1.515211, 3.861835>, <0.042286, -1.514636, 3.861866>, <0.044447, -1.510593, 3.862090>, <0.044447, -1.508023, 3.862232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.524015, -1.783419, 4.842806>, <1.620153, -1.761428, 4.844020>, <1.702930, -1.606502, 4.852567>, <1.702930, -1.508023, 4.858000>, 
      <1.470081, -1.773673, 4.605116>, <1.566219, -1.751682, 4.606329>, <1.642586, -1.606502, 4.614025>, <1.642586, -1.508023, 4.619458>, 
      <1.527117, -1.783980, 4.188029>, <1.610757, -1.764848, 4.189084>, <1.692503, -1.593700, 4.190185>, <1.692503, -1.508023, 4.194912>, 
      <1.325893, -1.747618, 4.055035>, <1.409533, -1.728486, 4.056090>, <1.481550, -1.593700, 4.063527>, <1.481550, -1.508023, 4.068253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621292, -1.800998, 5.356889>, <1.723567, -1.777603, 5.358180>, <1.811628, -1.612788, 5.367273>, <1.811628, -1.508023, 5.373052>, 
      <1.538370, -1.780559, 5.225090>, <1.640645, -1.757165, 5.226381>, <1.721185, -1.612788, 5.237818>, <1.721185, -1.508023, 5.243598>, 
      <1.558739, -1.789694, 4.995841>, <1.654878, -1.767703, 4.997054>, <1.741660, -1.606502, 5.005664>, <1.741660, -1.508023, 5.011096>, 
      <1.524015, -1.783419, 4.842806>, <1.620153, -1.761428, 4.844020>, <1.702930, -1.606502, 4.852567>, <1.702930, -1.508023, 4.858000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781640, -1.846918, 5.252280>, <1.897900, -1.818925, 5.253748>, <1.990800, -1.627451, 5.263783>, <1.990800, -1.508023, 5.270042>, 
      <1.752771, -1.839529, 5.303276>, <1.869031, -1.811536, 5.304744>, <1.957520, -1.627451, 5.316097>, <1.957520, -1.508023, 5.322356>, 
      <1.652479, -1.808684, 5.406458>, <1.754753, -1.785290, 5.407748>, <1.847137, -1.612788, 5.418100>, <1.847137, -1.508023, 5.423879>, 
      <1.621292, -1.800998, 5.356889>, <1.723567, -1.777603, 5.358180>, <1.811628, -1.612788, 5.367273>, <1.811628, -1.508023, 5.373052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.861038, 4.942509>, <1.976979, -1.831879, 4.944037>, <2.073750, -1.632427, 4.954491>, <2.073750, -1.508023, 4.961010>, 
      <1.833604, -1.856802, 5.035440>, <1.954709, -1.827643, 5.036968>, <2.048865, -1.632427, 5.047200>, <2.048865, -1.508023, 5.053720>, 
      <1.828394, -1.858884, 5.169691>, <1.944654, -1.830891, 5.171158>, <2.042323, -1.627451, 5.182791>, <2.042323, -1.508023, 5.189050>, 
      <1.781640, -1.846918, 5.252280>, <1.897900, -1.818925, 5.253748>, <1.990800, -1.627451, 5.263783>, <1.990800, -1.508023, 5.270042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.481550, -1.508023, 4.068253>, <1.481550, -1.422346, 4.072980>, <1.409533, -1.287560, 4.080414>, <1.325893, -1.268428, 4.081470>, 
      <1.108146, -1.508023, 3.844058>, <1.108146, -1.422346, 3.848784>, <1.084532, -1.346289, 3.859133>, <1.000892, -1.327157, 3.860188>, 
      <0.475577, -1.508023, 3.924038>, <0.475577, -1.505452, 3.924180>, <0.428121, -1.431687, 3.928249>, <0.425612, -1.431113, 3.928280>, 
      <0.044447, -1.508023, 3.862232>, <0.044447, -1.505452, 3.862373>, <0.042286, -1.501409, 3.862596>, <0.039777, -1.500835, 3.862628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.702930, -1.508023, 4.858000>, <1.702930, -1.409544, 4.863432>, <1.620153, -1.254617, 4.871978>, <1.524015, -1.232627, 4.873191>, 
      <1.642586, -1.508023, 4.619458>, <1.642586, -1.409544, 4.624890>, <1.566197, -1.264368, 4.633114>, <1.470059, -1.242377, 4.634328>, 
      <1.692503, -1.508023, 4.194912>, <1.692503, -1.422346, 4.199638>, <1.609889, -1.251355, 4.216829>, <1.526249, -1.232223, 4.217884>, 
      <1.481550, -1.508023, 4.068253>, <1.481550, -1.422346, 4.072980>, <1.409533, -1.287560, 4.080414>, <1.325893, -1.268428, 4.081470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.811628, -1.508023, 5.373052>, <1.811628, -1.403258, 5.378832>, <1.723567, -1.238442, 5.387923>, <1.621292, -1.215048, 5.389214>, 
      <1.721185, -1.508023, 5.243598>, <1.721185, -1.403258, 5.249377>, <1.641073, -1.258776, 5.255161>, <1.538798, -1.235381, 5.256451>, 
      <1.741660, -1.508023, 5.011096>, <1.741660, -1.409544, 5.016529>, <1.654855, -1.248347, 5.025605>, <1.558717, -1.226356, 5.026818>, 
      <1.702930, -1.508023, 4.858000>, <1.702930, -1.409544, 4.863432>, <1.620153, -1.254617, 4.871978>, <1.524015, -1.232627, 4.873191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.990800, -1.508023, 5.270042>, <1.990800, -1.388595, 5.276301>, <1.897900, -1.197121, 5.286334>, <1.781640, -1.169128, 5.287801>, 
      <1.957520, -1.508023, 5.322356>, <1.957520, -1.388595, 5.328615>, <1.869034, -1.204509, 5.336748>, <1.752774, -1.176516, 5.338215>, 
      <1.847137, -1.508023, 5.423879>, <1.847137, -1.403258, 5.429658>, <1.754216, -1.230888, 5.437248>, <1.651941, -1.207494, 5.438538>, 
      <1.811628, -1.508023, 5.373052>, <1.811628, -1.403258, 5.378832>, <1.723567, -1.238442, 5.387923>, <1.621292, -1.215048, 5.389214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -1.508023, 4.961010>, <2.073750, -1.383619, 4.967530>, <1.976979, -1.184167, 4.977982>, <1.855875, -1.155007, 4.979510>, 
      <2.048865, -1.508023, 5.053720>, <2.048865, -1.383619, 5.060240>, <1.954709, -1.188403, 5.070469>, <1.833604, -1.159244, 5.071997>, 
      <2.042323, -1.508023, 5.189050>, <2.042323, -1.388595, 5.195309>, <1.944838, -1.185107, 5.204356>, <1.828578, -1.157114, 5.205824>, 
      <1.990800, -1.508023, 5.270042>, <1.990800, -1.388595, 5.276301>, <1.897900, -1.197121, 5.286334>, <1.781640, -1.169128, 5.287801>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.325893, -1.268428, 4.081470>, <0.937080, -1.179491, 4.086376>, <0.398885, -1.169134, 4.086948>, <0.000000, -1.169134, 4.086948>, 
      <1.000892, -1.327157, 3.860188>, <0.612079, -1.238220, 3.865095>, <0.398885, -1.210861, 3.975116>, <0.000000, -1.210861, 3.975116>, 
      <0.425612, -1.431113, 3.928280>, <0.413947, -1.428445, 3.928428>, <0.011967, -1.399239, 3.930039>, <0.000000, -1.399239, 3.930039>, 
      <0.039777, -1.500835, 3.862628>, <0.028112, -1.498167, 3.862775>, <0.011967, -1.497856, 3.862792>, <0.000000, -1.497856, 3.862792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.524015, -1.232627, 4.873191>, <1.077103, -1.130400, 4.878830>, <0.458489, -1.118495, 4.879488>, <0.000000, -1.118495, 4.879488>, 
      <1.470059, -1.242377, 4.634328>, <1.023148, -1.140150, 4.639966>, <0.458489, -1.132214, 4.641636>, <0.000000, -1.132214, 4.641636>, 
      <1.526249, -1.232223, 4.217884>, <1.137436, -1.143286, 4.222791>, <0.398885, -1.085845, 4.310162>, <0.000000, -1.085845, 4.310162>, 
      <1.325893, -1.268428, 4.081470>, <0.937080, -1.179491, 4.086376>, <0.398885, -1.169134, 4.086948>, <0.000000, -1.169134, 4.086948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621292, -1.215048, 5.389214>, <1.145855, -1.106297, 5.395213>, <0.487754, -1.093632, 5.395912>, <0.000000, -1.093632, 5.395912>, 
      <1.538798, -1.235381, 5.256451>, <1.063360, -1.126630, 5.262450>, <0.487754, -1.126389, 5.244304>, <0.000000, -1.126389, 5.244304>, 
      <1.558717, -1.226356, 5.026818>, <1.111805, -1.124130, 5.032457>, <0.458489, -1.109563, 5.034337>, <0.000000, -1.109563, 5.034337>, 
      <1.524015, -1.232627, 4.873191>, <1.077103, -1.130400, 4.878830>, <0.458489, -1.118495, 4.879488>, <0.000000, -1.118495, 4.879488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.781640, -1.169128, 5.287801>, <1.260421, -1.043630, 5.294378>, <0.536155, -1.028681, 5.295162>, <0.000000, -1.028681, 5.295162>, 
      <1.752774, -1.176516, 5.338215>, <1.231556, -1.051018, 5.344792>, <0.536155, -1.035996, 5.330371>, <0.000000, -1.035996, 5.330371>, 
      <1.651941, -1.207494, 5.438538>, <1.176504, -1.098743, 5.444538>, <0.487754, -1.086037, 5.431062>, <0.000000, -1.086037, 5.431062>, 
      <1.621292, -1.215048, 5.389214>, <1.145855, -1.106297, 5.395213>, <0.487754, -1.093632, 5.395912>, <0.000000, -1.093632, 5.395912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.155007, 4.979510>, <1.312939, -1.024280, 4.986360>, <0.558495, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, 
      <1.833604, -1.159244, 5.071997>, <1.290669, -1.028516, 5.078848>, <0.558495, -1.014700, 5.079573>, <0.000000, -1.014700, 5.079573>, 
      <1.828578, -1.157114, 5.205824>, <1.307359, -1.031616, 5.212400>, <0.536155, -1.009845, 5.204509>, <0.000000, -1.009845, 5.204509>, 
      <1.781640, -1.169128, 5.287801>, <1.260421, -1.043630, 5.294378>, <0.536155, -1.028681, 5.295162>, <0.000000, -1.028681, 5.295162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.169134, 4.086948>, <-0.398885, -1.169134, 4.086948>, <-0.937080, -1.179491, 4.086376>, <-1.325893, -1.268428, 4.081470>, 
      <0.000000, -1.210861, 3.975116>, <-0.398885, -1.210861, 3.975116>, <-0.612079, -1.238220, 3.865095>, <-1.000892, -1.327157, 3.860188>, 
      <0.000000, -1.399239, 3.930039>, <-0.011967, -1.399239, 3.930039>, <-0.413947, -1.428445, 3.928428>, <-0.425612, -1.431113, 3.928280>, 
      <0.000000, -1.497856, 3.862792>, <-0.011967, -1.497856, 3.862792>, <-0.028112, -1.498167, 3.862775>, <-0.039777, -1.500835, 3.862628>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.118495, 4.879488>, <-0.458489, -1.118495, 4.879488>, <-1.077103, -1.130400, 4.878830>, <-1.524015, -1.232627, 4.873191>, 
      <0.000000, -1.132214, 4.641636>, <-0.458489, -1.132214, 4.641636>, <-1.023148, -1.140150, 4.639966>, <-1.470059, -1.242377, 4.634328>, 
      <0.000000, -1.085845, 4.310162>, <-0.398885, -1.085845, 4.310162>, <-1.137436, -1.143286, 4.222791>, <-1.526249, -1.232223, 4.217884>, 
      <0.000000, -1.169134, 4.086948>, <-0.398885, -1.169134, 4.086948>, <-0.937080, -1.179491, 4.086376>, <-1.325893, -1.268428, 4.081470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.093632, 5.395912>, <-0.487754, -1.093632, 5.395912>, <-1.145855, -1.106297, 5.395213>, <-1.621292, -1.215048, 5.389214>, 
      <0.000000, -1.126389, 5.244304>, <-0.487754, -1.126389, 5.244304>, <-1.063360, -1.126630, 5.262450>, <-1.538798, -1.235381, 5.256451>, 
      <0.000000, -1.109563, 5.034337>, <-0.458489, -1.109563, 5.034337>, <-1.111805, -1.124130, 5.032457>, <-1.558717, -1.226356, 5.026818>, 
      <0.000000, -1.118495, 4.879488>, <-0.458489, -1.118495, 4.879488>, <-1.077103, -1.130400, 4.878830>, <-1.524015, -1.232627, 4.873191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.028681, 5.295162>, <-0.536155, -1.028681, 5.295162>, <-1.260421, -1.043630, 5.294378>, <-1.781640, -1.169128, 5.287801>, 
      <0.000000, -1.035996, 5.330371>, <-0.536155, -1.035996, 5.330371>, <-1.231556, -1.051018, 5.344792>, <-1.752774, -1.176516, 5.338215>, 
      <0.000000, -1.086037, 5.431062>, <-0.487754, -1.086037, 5.431062>, <-1.176504, -1.098743, 5.444538>, <-1.651941, -1.207494, 5.438538>, 
      <0.000000, -1.093632, 5.395912>, <-0.487754, -1.093632, 5.395912>, <-1.145855, -1.106297, 5.395213>, <-1.621292, -1.215048, 5.389214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.008708, 4.987177>, <-0.558495, -1.008708, 4.987177>, <-1.312939, -1.024280, 4.986360>, <-1.855875, -1.155007, 4.979510>, 
      <0.000000, -1.014700, 5.079573>, <-0.558495, -1.014700, 5.079573>, <-1.290669, -1.028516, 5.078848>, <-1.833604, -1.159244, 5.071997>, 
      <0.000000, -1.009845, 5.204509>, <-0.536155, -1.009845, 5.204509>, <-1.307359, -1.031616, 5.212400>, <-1.828578, -1.157114, 5.205824>, 
      <0.000000, -1.028681, 5.295162>, <-0.536155, -1.028681, 5.295162>, <-1.260421, -1.043630, 5.294378>, <-1.781640, -1.169128, 5.287801>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>, 
      <-1.312939, -1.024280, 4.986360>, <-1.312939, -1.024280, 4.986360>, <-1.312939, -1.024280, 4.986360>, <-1.312939, -1.024280, 4.986360>, 
      <-0.558495, -1.008708, 4.987177>, <-0.558495, -1.008708, 4.987177>, <-0.558495, -1.008708, 4.987177>, <-0.558495, -1.008708, 4.987177>, 
      <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>, 
      <-2.073750, -1.383619, 4.967530>, <-2.073750, -1.383619, 4.967530>, <-2.073750, -1.383619, 4.967530>, <-2.073750, -1.383619, 4.967530>, 
      <-1.976979, -1.184167, 4.977982>, <-1.976979, -1.184167, 4.977982>, <-1.976979, -1.184167, 4.977982>, <-1.976979, -1.184167, 4.977982>, 
      <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>, <-1.855875, -1.155007, 4.979510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>, 
      <-1.976979, -1.831879, 4.944037>, <-1.976979, -1.831879, 4.944037>, <-1.976979, -1.831879, 4.944037>, <-1.976979, -1.831879, 4.944037>, 
      <-2.073750, -1.632427, 4.954491>, <-2.073750, -1.632427, 4.954491>, <-2.073750, -1.632427, 4.954491>, <-2.073750, -1.632427, 4.954491>, 
      <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.508023, 4.961010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, 
      <-0.558495, -2.007337, 4.934842>, <-0.558495, -2.007337, 4.934842>, <-0.558495, -2.007337, 4.934842>, <-0.558495, -2.007337, 4.934842>, 
      <-1.312939, -1.991766, 4.935658>, <-1.312939, -1.991766, 4.935658>, <-1.312939, -1.991766, 4.935658>, <-1.312939, -1.991766, 4.935658>, 
      <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>, <-1.855875, -1.861038, 4.942509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>, 
      <1.312939, -1.991766, 4.935658>, <1.312939, -1.991766, 4.935658>, <1.312939, -1.991766, 4.935658>, <1.312939, -1.991766, 4.935658>, 
      <0.558495, -2.007337, 4.934842>, <0.558495, -2.007337, 4.934842>, <0.558495, -2.007337, 4.934842>, <0.558495, -2.007337, 4.934842>, 
      <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>, 
      <2.073750, -1.632427, 4.954491>, <2.073750, -1.632427, 4.954491>, <2.073750, -1.632427, 4.954491>, <2.073750, -1.632427, 4.954491>, 
      <1.976979, -1.831879, 4.944037>, <1.976979, -1.831879, 4.944037>, <1.976979, -1.831879, 4.944037>, <1.976979, -1.831879, 4.944037>, 
      <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>, <1.855875, -1.861038, 4.942509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>, 
      <1.976979, -1.184167, 4.977982>, <1.976979, -1.184167, 4.977982>, <1.976979, -1.184167, 4.977982>, <1.976979, -1.184167, 4.977982>, 
      <2.073750, -1.383619, 4.967530>, <2.073750, -1.383619, 4.967530>, <2.073750, -1.383619, 4.967530>, <2.073750, -1.383619, 4.967530>, 
      <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>, <2.073750, -1.508023, 4.961010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>, 
      <0.558495, -1.008708, 4.987177>, <0.558495, -1.008708, 4.987177>, <0.558495, -1.008708, 4.987177>, <0.558495, -1.008708, 4.987177>, 
      <1.312939, -1.024280, 4.986360>, <1.312939, -1.024280, 4.986360>, <1.312939, -1.024280, 4.986360>, <1.312939, -1.024280, 4.986360>, 
      <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>, <1.855875, -1.155007, 4.979510>
    }
  }
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.102893, 3.985107>, <-1.976979, -1.132052, 3.983579>, <-2.073750, -1.331504, 3.973126>, <-2.073750, -1.455908, 3.966607>, 
      <-1.855875, -1.234454, 4.253307>, <-1.976979, -1.263613, 4.251779>, <-2.073750, -1.386185, 4.266810>, <-2.073750, -1.510589, 4.260290>, 
      <-1.855875, -1.139373, 4.681189>, <-1.976979, -1.168532, 4.679661>, <-2.073750, -1.367984, 4.669209>, <-2.073750, -1.492388, 4.662689>, 
      <-1.855875, -1.155007, 4.979510>, <-1.976979, -1.184167, 4.977982>, <-2.073750, -1.383619, 4.967530>, <-2.073750, -1.508023, 4.961010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -0.244414, 3.123176>, <-2.105174, -0.369027, 3.101399>, <-2.073750, -0.863296, 3.025544>, <-2.073750, -1.138243, 2.974982>, 
      <-1.855875, -0.431607, 3.436466>, <-2.105174, -0.556221, 3.414689>, <-2.073750, -0.946651, 3.326596>, <-2.073750, -1.221599, 3.276035>, 
      <-1.855875, -0.942166, 3.657450>, <-1.976979, -0.971326, 3.655922>, <-2.073750, -1.274325, 3.666025>, <-2.073750, -1.398729, 3.659505>, 
      <-1.855875, -1.102893, 3.985107>, <-1.976979, -1.132052, 3.983579>, <-2.073750, -1.331504, 3.973126>, <-2.073750, -1.455908, 3.966607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -0.028139, 2.186386>, <-2.105174, -0.152752, 2.164609>, <-2.073750, -0.647021, 2.088754>, <-2.073750, -0.921968, 2.038193>, 
      <-1.855875, -0.093021, 2.467423>, <-2.105174, -0.217635, 2.445646>, <-2.073750, -0.711903, 2.369791>, <-2.073750, -0.986851, 2.319229>, 
      <-1.855875, -0.096471, 2.875578>, <-2.105174, -0.221085, 2.853801>, <-2.073750, -0.786331, 2.747573>, <-2.073750, -1.061278, 2.697011>, 
      <-1.855875, -0.244414, 3.123176>, <-2.105174, -0.369027, 3.101399>, <-2.073750, -0.863296, 3.025544>, <-2.073750, -1.138243, 2.974982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, 0.211309, 1.149227>, <-2.105174, 0.086695, 1.127450>, <-2.073750, -0.407574, 1.051595>, <-2.073750, -0.682521, 1.001033>, 
      <-1.855875, 0.139474, 1.460375>, <-2.105174, 0.014861, 1.438597>, <-2.073750, -0.479408, 1.362743>, <-2.073750, -0.754355, 1.312181>, 
      <-1.855875, 0.043695, 1.875238>, <-2.105174, -0.080918, 1.853461>, <-2.073750, -0.575187, 1.777606>, <-2.073750, -0.850134, 1.727045>, 
      <-1.855875, -0.028139, 2.186386>, <-2.105174, -0.152752, 2.164609>, <-2.073750, -0.647021, 2.088754>, <-2.073750, -0.921968, 2.038193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145129, 0.337581, -0.510580>, <-0.164625, 0.327836, -0.512283>, <-0.162167, 0.289185, -0.518215>, <-0.162167, 0.267684, -0.522168>, 
      <-0.357701, 0.367293, -0.456334>, <-0.377197, 0.357548, -0.458037>, <-0.399695, 0.216517, -0.480943>, <-0.399695, 0.195016, -0.484897>, 
      <-0.650019, 0.425903, -0.415845>, <-0.764696, 0.368581, -0.425862>, <-0.728501, 0.238482, -0.443825>, <-0.728501, 0.112007, -0.467084>, 
      <-0.853703, 0.436619, -0.329762>, <-0.968380, 0.379297, -0.339779>, <-0.953925, 0.151934, -0.374672>, <-0.953925, 0.025458, -0.397931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -1.455908, 3.966607>, <-2.073750, -1.580312, 3.960087>, <-1.976979, -1.779765, 3.949634>, <-1.855875, -1.808924, 3.948106>, 
      <-2.073750, -1.510589, 4.260290>, <-2.073750, -1.634993, 4.253771>, <-1.976979, -1.834059, 4.243389>, <-1.855875, -1.863219, 4.241861>, 
      <-2.073750, -1.492388, 4.662689>, <-2.073750, -1.616793, 4.656170>, <-1.976979, -1.816245, 4.645716>, <-1.855875, -1.845404, 4.644188>, 
      <-2.073750, -1.508023, 4.961010>, <-2.073750, -1.632427, 4.954491>, <-1.976979, -1.831879, 4.944037>, <-1.855875, -1.861038, 4.942509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -1.138243, 2.974982>, <-2.073750, -1.260763, 2.952451>, <-1.976979, -1.454232, 2.902030>, <-1.855875, -1.482683, 2.895462>, 
      <-2.073750, -1.221599, 3.276035>, <-2.073750, -1.344119, 3.253504>, <-1.976979, -1.541213, 3.220995>, <-1.855875, -1.569664, 3.214427>, 
      <-2.073750, -1.398729, 3.659505>, <-2.073750, -1.523133, 3.652986>, <-1.976979, -1.719675, 3.624529>, <-1.855875, -1.748835, 3.623000>, 
      <-2.073750, -1.455908, 3.966607>, <-2.073750, -1.580312, 3.960087>, <-1.976979, -1.779765, 3.949634>, <-1.855875, -1.808924, 3.948106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -0.921968, 2.038193>, <-2.073750, -1.044488, 2.015661>, <-1.976979, -1.237957, 1.965241>, <-1.855875, -1.266408, 1.958672>, 
      <-2.073750, -0.986851, 2.319229>, <-2.073750, -1.109371, 2.296698>, <-1.976979, -1.302839, 2.246278>, <-1.855875, -1.331290, 2.239709>, 
      <-2.073750, -1.061278, 2.697011>, <-2.073750, -1.183799, 2.674480>, <-1.976979, -1.378349, 2.623762>, <-1.855875, -1.406800, 2.617194>, 
      <-2.073750, -1.138243, 2.974982>, <-2.073750, -1.260763, 2.952451>, <-1.976979, -1.454232, 2.902030>, <-1.855875, -1.482683, 2.895462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -0.682521, 1.001033>, <-2.073750, -0.805041, 0.978502>, <-1.976979, -0.998510, 0.928081>, <-1.855875, -1.026961, 0.921513>, 
      <-2.073750, -0.754355, 1.312181>, <-2.073750, -0.876875, 1.289649>, <-1.976979, -1.070344, 1.239229>, <-1.855875, -1.098795, 1.232660>, 
      <-2.073750, -0.850134, 1.727045>, <-2.073750, -0.972654, 1.704514>, <-1.976979, -1.166123, 1.654093>, <-1.855875, -1.194574, 1.647525>, 
      <-2.073750, -0.921968, 2.038193>, <-2.073750, -1.044488, 2.015661>, <-1.976979, -1.237957, 1.965241>, <-1.855875, -1.266408, 1.958672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.162167, 0.267684, -0.522168>, <-0.162167, 0.258103, -0.523930>, <-0.154600, 0.242973, -0.527873>, <-0.145129, 0.240748, -0.528387>, 
      <-0.399695, 0.195016, -0.484897>, <-0.399695, 0.185435, -0.486659>, <-0.367172, 0.130853, -0.499710>, <-0.357701, 0.128629, -0.500224>, 
      <-0.728501, 0.112007, -0.467084>, <-0.728501, 0.055647, -0.477448>, <-0.709678, 0.002859, -0.491395>, <-0.653970, -0.010228, -0.494416>, 
      <-0.953925, 0.025458, -0.397931>, <-0.953925, -0.030902, -0.408295>, <-0.909411, -0.119897, -0.431489>, <-0.853703, -0.132985, -0.434510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.808924, 3.948106>, <-1.312939, -1.939651, 3.941255>, <-0.558495, -1.955223, 3.940438>, <0.000000, -1.955223, 3.940438>, 
      <-1.855875, -1.863219, 4.241861>, <-1.312939, -1.993946, 4.235010>, <-0.558495, -2.009364, 4.234222>, <0.000000, -2.009364, 4.234222>, 
      <-1.855875, -1.845404, 4.644188>, <-1.312939, -1.976131, 4.637337>, <-0.558495, -1.991703, 4.636521>, <0.000000, -1.991703, 4.636521>, 
      <-1.855875, -1.861038, 4.942509>, <-1.312939, -1.991766, 4.935658>, <-0.558495, -2.007337, 4.934842>, <0.000000, -2.007337, 4.934842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.482683, 2.895462>, <-1.312939, -1.610235, 2.866014>, <-0.558495, -1.625428, 2.862507>, <0.000000, -1.625428, 2.862507>, 
      <-1.855875, -1.569664, 3.214427>, <-1.312939, -1.697216, 3.184979>, <-0.558495, -1.713895, 3.188906>, <0.000000, -1.713895, 3.188906>, 
      <-1.855875, -1.748835, 3.623000>, <-1.312939, -1.879562, 3.616149>, <-0.558495, -1.893933, 3.607863>, <0.000000, -1.893933, 3.607863>, 
      <-1.855875, -1.808924, 3.948106>, <-1.312939, -1.939651, 3.941255>, <-0.558495, -1.955223, 3.940438>, <0.000000, -1.955223, 3.940438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.266408, 1.958672>, <-1.312939, -1.393960, 1.929225>, <-0.558495, -1.409153, 1.925717>, <0.000000, -1.409153, 1.925717>, 
      <-1.855875, -1.331290, 2.239709>, <-1.312939, -1.458842, 2.210262>, <-0.558495, -1.474036, 2.206754>, <0.000000, -1.474036, 2.206754>, 
      <-1.855875, -1.406800, 2.617194>, <-1.312939, -1.534351, 2.587746>, <-0.558495, -1.549975, 2.584121>, <0.000000, -1.549975, 2.584121>, 
      <-1.855875, -1.482683, 2.895462>, <-1.312939, -1.610235, 2.866014>, <-0.558495, -1.625428, 2.862507>, <0.000000, -1.625428, 2.862507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.026961, 0.921513>, <-1.312939, -1.154513, 0.892065>, <-0.558495, -1.169706, 0.888557>, <0.000000, -1.169706, 0.888557>, 
      <-1.855875, -1.098795, 1.232660>, <-1.312939, -1.226347, 1.203213>, <-0.558495, -1.241540, 1.199705>, <0.000000, -1.241540, 1.199705>, 
      <-1.855875, -1.194574, 1.647525>, <-1.312939, -1.322126, 1.618077>, <-0.558495, -1.337319, 1.614569>, <0.000000, -1.337319, 1.614569>, 
      <-1.855875, -1.266408, 1.958672>, <-1.312939, -1.393960, 1.929225>, <-0.558495, -1.409153, 1.925717>, <0.000000, -1.409153, 1.925717>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145129, 0.240748, -0.528387>, <-0.102672, 0.230774, -0.530690>, <-0.043674, 0.229586, -0.530964>, <0.000000, 0.229586, -0.530964>, 
      <-0.357701, 0.128629, -0.500224>, <-0.315244, 0.118654, -0.502527>, <-0.043674, 0.101116, -0.506576>, <0.000000, 0.101116, -0.506576>, 
      <-0.653970, -0.010228, -0.494416>, <-0.404220, -0.068902, -0.507962>, <-0.256908, -0.077575, -0.499073>, <0.000000, -0.077575, -0.499073>, 
      <-0.853703, -0.132985, -0.434510>, <-0.603952, -0.191658, -0.448056>, <-0.256908, -0.198647, -0.449670>, <0.000000, -0.198647, -0.449670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.955223, 3.940438>, <0.558495, -1.955223, 3.940438>, <1.312939, -1.939651, 3.941255>, <1.855875, -1.808924, 3.948106>, 
      <0.000000, -2.009364, 4.234222>, <0.558495, -2.009364, 4.234222>, <1.312939, -1.993946, 4.235010>, <1.855875, -1.863219, 4.241861>, 
      <0.000000, -1.991703, 4.636521>, <0.558495, -1.991703, 4.636521>, <1.312939, -1.976131, 4.637337>, <1.855875, -1.845404, 4.644188>, 
      <0.000000, -2.007337, 4.934842>, <0.558495, -2.007337, 4.934842>, <1.312939, -1.991766, 4.935658>, <1.855875, -1.861038, 4.942509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.625428, 2.862507>, <0.558495, -1.625428, 2.862507>, <1.312939, -1.610235, 2.866014>, <1.855875, -1.482683, 2.895462>, 
      <0.000000, -1.713895, 3.188906>, <0.558495, -1.713895, 3.188906>, <1.312939, -1.697216, 3.184979>, <1.855875, -1.569664, 3.214427>, 
      <0.000000, -1.893933, 3.607863>, <0.558495, -1.893933, 3.607863>, <1.312939, -1.879562, 3.616149>, <1.855875, -1.748835, 3.623000>, 
      <0.000000, -1.955223, 3.940438>, <0.558495, -1.955223, 3.940438>, <1.312939, -1.939651, 3.941255>, <1.855875, -1.808924, 3.948106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.409153, 1.925717>, <0.558495, -1.409153, 1.925717>, <1.312939, -1.393960, 1.929225>, <1.855875, -1.266408, 1.958672>, 
      <0.000000, -1.474036, 2.206754>, <0.558495, -1.474036, 2.206754>, <1.312939, -1.458842, 2.210262>, <1.855875, -1.331290, 2.239709>, 
      <0.000000, -1.549975, 2.584121>, <0.558495, -1.549975, 2.584121>, <1.312939, -1.534351, 2.587746>, <1.855875, -1.406800, 2.617194>, 
      <0.000000, -1.625428, 2.862507>, <0.558495, -1.625428, 2.862507>, <1.312939, -1.610235, 2.866014>, <1.855875, -1.482683, 2.895462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.169706, 0.888557>, <0.558495, -1.169706, 0.888557>, <1.312939, -1.154513, 0.892065>, <1.855875, -1.026961, 0.921513>, 
      <0.000000, -1.241540, 1.199705>, <0.558495, -1.241540, 1.199705>, <1.312939, -1.226347, 1.203213>, <1.855875, -1.098795, 1.232660>, 
      <0.000000, -1.337319, 1.614569>, <0.558495, -1.337319, 1.614569>, <1.312939, -1.322126, 1.618077>, <1.855875, -1.194574, 1.647525>, 
      <0.000000, -1.409153, 1.925717>, <0.558495, -1.409153, 1.925717>, <1.312939, -1.393960, 1.929225>, <1.855875, -1.266408, 1.958672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.229586, -0.530964>, <0.043674, 0.229586, -0.530964>, <0.102672, 0.230774, -0.530690>, <0.145129, 0.240748, -0.528387>, 
      <0.000000, 0.101116, -0.506576>, <0.043674, 0.101116, -0.506576>, <0.315244, 0.118654, -0.502527>, <0.357701, 0.128629, -0.500224>, 
      <0.000000, -0.077575, -0.499073>, <0.256908, -0.077575, -0.499073>, <0.404220, -0.068902, -0.507962>, <0.653970, -0.010228, -0.494416>, 
      <0.000000, -0.198647, -0.449670>, <0.256908, -0.198647, -0.449670>, <0.603952, -0.191658, -0.448056>, <0.853703, -0.132985, -0.434510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.808924, 3.948106>, <1.976979, -1.779765, 3.949634>, <2.073750, -1.580312, 3.960087>, <2.073750, -1.455908, 3.966607>, 
      <1.855875, -1.863219, 4.241861>, <1.976979, -1.834059, 4.243389>, <2.073750, -1.634993, 4.253771>, <2.073750, -1.510589, 4.260290>, 
      <1.855875, -1.845404, 4.644188>, <1.976979, -1.816245, 4.645716>, <2.073750, -1.616793, 4.656170>, <2.073750, -1.492388, 4.662689>, 
      <1.855875, -1.861038, 4.942509>, <1.976979, -1.831879, 4.944037>, <2.073750, -1.632427, 4.954491>, <2.073750, -1.508023, 4.961010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.482683, 2.895462>, <1.976979, -1.454232, 2.902030>, <2.073750, -1.260763, 2.952451>, <2.073750, -1.138243, 2.974982>, 
      <1.855875, -1.569664, 3.214427>, <1.976979, -1.541213, 3.220995>, <2.073750, -1.344119, 3.253504>, <2.073750, -1.221599, 3.276035>, 
      <1.855875, -1.748835, 3.623000>, <1.976979, -1.719675, 3.624529>, <2.073750, -1.523133, 3.652986>, <2.073750, -1.398729, 3.659505>, 
      <1.855875, -1.808924, 3.948106>, <1.976979, -1.779765, 3.949634>, <2.073750, -1.580312, 3.960087>, <2.073750, -1.455908, 3.966607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.266408, 1.958672>, <1.976979, -1.237957, 1.965241>, <2.073750, -1.044488, 2.015661>, <2.073750, -0.921968, 2.038193>, 
      <1.855875, -1.331290, 2.239709>, <1.976979, -1.302839, 2.246278>, <2.073750, -1.109371, 2.296698>, <2.073750, -0.986851, 2.319229>, 
      <1.855875, -1.406800, 2.617194>, <1.976979, -1.378349, 2.623762>, <2.073750, -1.183799, 2.674480>, <2.073750, -1.061278, 2.697011>, 
      <1.855875, -1.482683, 2.895462>, <1.976979, -1.454232, 2.902030>, <2.073750, -1.260763, 2.952451>, <2.073750, -1.138243, 2.974982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.026961, 0.921513>, <1.976979, -0.998510, 0.928081>, <2.073750, -0.805041, 0.978502>, <2.073750, -0.682521, 1.001033>, 
      <1.855875, -1.098795, 1.232660>, <1.976979, -1.070344, 1.239229>, <2.073750, -0.876875, 1.289649>, <2.073750, -0.754355, 1.312181>, 
      <1.855875, -1.194574, 1.647525>, <1.976979, -1.166123, 1.654093>, <2.073750, -0.972654, 1.704514>, <2.073750, -0.850134, 1.727045>, 
      <1.855875, -1.266408, 1.958672>, <1.976979, -1.237957, 1.965241>, <2.073750, -1.044488, 2.015661>, <2.073750, -0.921968, 2.038193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145129, 0.240748, -0.528387>, <0.154600, 0.242973, -0.527873>, <0.162167, 0.258103, -0.523930>, <0.162167, 0.267684, -0.522168>, 
      <0.357701, 0.128629, -0.500224>, <0.367172, 0.130853, -0.499710>, <0.399695, 0.185435, -0.486659>, <0.399695, 0.195016, -0.484897>, 
      <0.653970, -0.010228, -0.494416>, <0.709678, 0.002859, -0.491395>, <0.728501, 0.055647, -0.477448>, <0.728501, 0.112007, -0.467084>, 
      <0.853703, -0.132985, -0.434510>, <0.909411, -0.119897, -0.431489>, <0.953925, -0.030902, -0.408295>, <0.953925, 0.025458, -0.397931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -1.455908, 3.966607>, <2.073750, -1.331504, 3.973126>, <1.976979, -1.132052, 3.983579>, <1.855875, -1.102893, 3.985107>, 
      <2.073750, -1.510589, 4.260290>, <2.073750, -1.386185, 4.266810>, <1.976979, -1.263613, 4.251779>, <1.855875, -1.234454, 4.253307>, 
      <2.073750, -1.492388, 4.662689>, <2.073750, -1.367984, 4.669209>, <1.976979, -1.168532, 4.679661>, <1.855875, -1.139373, 4.681189>, 
      <2.073750, -1.508023, 4.961010>, <2.073750, -1.383619, 4.967530>, <1.976979, -1.184167, 4.977982>, <1.855875, -1.155007, 4.979510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -1.138243, 2.974982>, <2.073750, -0.863296, 3.025544>, <2.105174, -0.369027, 3.101399>, <1.855875, -0.244414, 3.123176>, 
      <2.073750, -1.221599, 3.276035>, <2.073750, -0.946651, 3.326596>, <2.105174, -0.556221, 3.414688>, <1.855875, -0.431607, 3.436466>, 
      <2.073750, -1.398729, 3.659505>, <2.073750, -1.274325, 3.666025>, <1.976979, -0.971326, 3.655922>, <1.855875, -0.942166, 3.657450>, 
      <2.073750, -1.455908, 3.966607>, <2.073750, -1.331504, 3.973126>, <1.976979, -1.132052, 3.983579>, <1.855875, -1.102893, 3.985107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -0.921968, 2.038193>, <2.073750, -0.647021, 2.088754>, <2.105174, -0.152752, 2.164609>, <1.855875, -0.028139, 2.186386>, 
      <2.073750, -0.986851, 2.319229>, <2.073750, -0.711903, 2.369791>, <2.105174, -0.217635, 2.445646>, <1.855875, -0.093021, 2.467423>, 
      <2.073750, -1.061278, 2.697011>, <2.073750, -0.786331, 2.747573>, <2.105174, -0.221085, 2.853801>, <1.855875, -0.096471, 2.875578>, 
      <2.073750, -1.138243, 2.974982>, <2.073750, -0.863296, 3.025544>, <2.105174, -0.369027, 3.101399>, <1.855875, -0.244414, 3.123176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -0.682521, 1.001033>, <2.073750, -0.407574, 1.051595>, <2.105174, 0.086695, 1.127450>, <1.855875, 0.211309, 1.149227>, 
      <2.073750, -0.754355, 1.312181>, <2.073750, -0.479408, 1.362743>, <2.105174, 0.014861, 1.438597>, <1.855875, 0.139474, 1.460375>, 
      <2.073750, -0.850134, 1.727045>, <2.073750, -0.575187, 1.777606>, <2.105174, -0.080918, 1.853461>, <1.855875, 0.043695, 1.875238>, 
      <2.073750, -0.921968, 2.038193>, <2.073750, -0.647021, 2.088754>, <2.105174, -0.152752, 2.164609>, <1.855875, -0.028139, 2.186386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.162167, 0.267684, -0.522168>, <0.162167, 0.289185, -0.518215>, <0.164625, 0.327836, -0.512283>, <0.145129, 0.337581, -0.510580>, 
      <0.399695, 0.195016, -0.484897>, <0.399695, 0.216517, -0.480943>, <0.377197, 0.357548, -0.458037>, <0.357701, 0.367293, -0.456334>, 
      <0.728501, 0.112007, -0.467084>, <0.728501, 0.238482, -0.443825>, <0.764696, 0.368581, -0.425862>, <0.650019, 0.425903, -0.415845>, 
      <0.953925, 0.025458, -0.397931>, <0.953925, 0.151934, -0.374672>, <0.968380, 0.379297, -0.339779>, <0.853703, 0.436619, -0.329762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.102893, 3.985107>, <1.312939, -0.972166, 3.991958>, <0.558495, -0.956593, 3.992776>, <0.000000, -0.956593, 3.992776>, 
      <1.855875, -1.234454, 4.253307>, <1.312939, -1.103727, 4.260158>, <0.558495, -1.089197, 4.260462>, <0.000000, -1.089197, 4.260462>, 
      <1.855875, -1.139373, 4.681189>, <1.312939, -1.008646, 4.688040>, <0.558495, -0.993074, 4.688857>, <0.000000, -0.993074, 4.688857>, 
      <1.855875, -1.155007, 4.979510>, <1.312939, -1.024280, 4.986360>, <0.558495, -1.008708, 4.987177>, <0.000000, -1.008708, 4.987177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -0.244414, 3.123176>, <1.357832, 0.004536, 3.166682>, <0.558495, -0.101668, 3.156131>, <0.000000, -0.101668, 3.156131>, 
      <1.855875, -0.431607, 3.436466>, <1.357832, -0.182658, 3.479972>, <0.558495, -0.287207, 3.463302>, <0.000000, -0.287207, 3.463302>, 
      <1.855875, -0.942166, 3.657450>, <1.312939, -0.811439, 3.664301>, <0.558495, -0.797301, 3.671210>, <0.000000, -0.797301, 3.671210>, 
      <1.855875, -1.102893, 3.985107>, <1.312939, -0.972166, 3.991958>, <0.558495, -0.956593, 3.992776>, <0.000000, -0.956593, 3.992776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -0.028139, 2.186386>, <1.357832, 0.220811, 2.229892>, <0.558495, 0.114607, 2.219342>, <0.000000, 0.114607, 2.219342>, 
      <1.855875, -0.093021, 2.467423>, <1.357832, 0.155929, 2.510929>, <0.558495, 0.049724, 2.500379>, <0.000000, 0.049724, 2.500379>, 
      <1.855875, -0.096471, 2.875578>, <1.357832, 0.152478, 2.919084>, <0.558495, 0.047458, 2.909245>, <0.000000, 0.047458, 2.909245>, 
      <1.855875, -0.244414, 3.123176>, <1.357832, 0.004536, 3.166682>, <0.558495, -0.101668, 3.156131>, <0.000000, -0.101668, 3.156131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, 0.211309, 1.149227>, <1.357832, 0.460258, 1.192733>, <0.558495, 0.354054, 1.182182>, <0.000000, 0.354054, 1.182182>, 
      <1.855875, 0.139474, 1.460375>, <1.357832, 0.388424, 1.503881>, <0.558495, 0.282220, 1.493330>, <0.000000, 0.282220, 1.493330>, 
      <1.855875, 0.043695, 1.875238>, <1.357832, 0.292645, 1.918744>, <0.558495, 0.186441, 1.908194>, <0.000000, 0.186441, 1.908194>, 
      <1.855875, -0.028139, 2.186386>, <1.357832, 0.220811, 2.229892>, <0.558495, 0.114607, 2.219342>, <0.000000, 0.114607, 2.219342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.145129, 0.337581, -0.510580>, <0.106182, 0.357049, -0.507177>, <0.043674, 0.348744, -0.508003>, <0.000000, 0.348744, -0.508003>, 
      <0.357701, 0.367293, -0.456334>, <0.318754, 0.386760, -0.452932>, <0.043674, 0.394805, -0.449983>, <0.000000, 0.394805, -0.449983>, 
      <0.650019, 0.425903, -0.415845>, <0.420919, 0.540420, -0.395832>, <0.256908, 0.481379, -0.385673>, <0.000000, 0.481379, -0.385673>, 
      <0.853703, 0.436619, -0.329762>, <0.624602, 0.551136, -0.309749>, <0.256908, 0.502282, -0.314602>, <0.000000, 0.502282, -0.314602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.956593, 3.992776>, <-0.558495, -0.956593, 3.992776>, <-1.312939, -0.972166, 3.991958>, <-1.855875, -1.102893, 3.985107>, 
      <0.000000, -1.089197, 4.260462>, <-0.558495, -1.089197, 4.260462>, <-1.312939, -1.103727, 4.260158>, <-1.855875, -1.234454, 4.253307>, 
      <0.000000, -0.993074, 4.688857>, <-0.558495, -0.993074, 4.688857>, <-1.312939, -1.008646, 4.688040>, <-1.855875, -1.139373, 4.681189>, 
      <0.000000, -1.008708, 4.987177>, <-0.558495, -1.008708, 4.987177>, <-1.312939, -1.024280, 4.986360>, <-1.855875, -1.155007, 4.979510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.101668, 3.156131>, <-0.558495, -0.101668, 3.156131>, <-1.357832, 0.004536, 3.166682>, <-1.855875, -0.244414, 3.123176>, 
      <0.000000, -0.287207, 3.463302>, <-0.558495, -0.287207, 3.463302>, <-1.357832, -0.182658, 3.479972>, <-1.855875, -0.431607, 3.436466>, 
      <0.000000, -0.797301, 3.671210>, <-0.558495, -0.797301, 3.671210>, <-1.312939, -0.811439, 3.664301>, <-1.855875, -0.942166, 3.657450>, 
      <0.000000, -0.956593, 3.992776>, <-0.558495, -0.956593, 3.992776>, <-1.312939, -0.972166, 3.991958>, <-1.855875, -1.102893, 3.985107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.114607, 2.219342>, <-0.558495, 0.114607, 2.219342>, <-1.357832, 0.220811, 2.229892>, <-1.855875, -0.028139, 2.186386>, 
      <0.000000, 0.049724, 2.500379>, <-0.558495, 0.049724, 2.500379>, <-1.357832, 0.155929, 2.510929>, <-1.855875, -0.093021, 2.467423>, 
      <0.000000, 0.047458, 2.909245>, <-0.558495, 0.047458, 2.909245>, <-1.357832, 0.152478, 2.919084>, <-1.855875, -0.096471, 2.875578>, 
      <0.000000, -0.101668, 3.156131>, <-0.558495, -0.101668, 3.156131>, <-1.357832, 0.004536, 3.166682>, <-1.855875, -0.244414, 3.123176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.354054, 1.182182>, <-0.558495, 0.354054, 1.182182>, <-1.357832, 0.460258, 1.192733>, <-1.855875, 0.211309, 1.149227>, 
      <0.000000, 0.282220, 1.493330>, <-0.558495, 0.282220, 1.493330>, <-1.357832, 0.388424, 1.503881>, <-1.855875, 0.139474, 1.460375>, 
      <0.000000, 0.186441, 1.908194>, <-0.558495, 0.186441, 1.908194>, <-1.357832, 0.292645, 1.918744>, <-1.855875, 0.043695, 1.875238>, 
      <0.000000, 0.114607, 2.219342>, <-0.558495, 0.114607, 2.219342>, <-1.357832, 0.220811, 2.229892>, <-1.855875, -0.028139, 2.186386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.348744, -0.508003>, <-0.043674, 0.348744, -0.508003>, <-0.106182, 0.357049, -0.507177>, <-0.145129, 0.337581, -0.510580>, 
      <0.000000, 0.394805, -0.449983>, <-0.043674, 0.394805, -0.449983>, <-0.318754, 0.386760, -0.452932>, <-0.357701, 0.367293, -0.456334>, 
      <0.000000, 0.481379, -0.385673>, <-0.256908, 0.481379, -0.385673>, <-0.420919, 0.540420, -0.395832>, <-0.650019, 0.425903, -0.415845>, 
      <0.000000, 0.502282, -0.314602>, <-0.256908, 0.502282, -0.314602>, <-0.624602, 0.551136, -0.309749>, <-0.853703, 0.436619, -0.329762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, 0.211309, 1.149227>, <-1.855875, 0.276191, 0.868190>, <-2.016399, 0.391494, 0.449336>, <-1.855875, 0.427584, 0.212437>, 
      <-1.357832, 0.460258, 1.192733>, <-1.357832, 0.525141, 0.911696>, <-1.518356, 0.640444, 0.492842>, <-1.357832, 0.676533, 0.255943>, 
      <-0.558495, 0.354054, 1.182182>, <-0.558495, 0.418936, 0.901145>, <-0.558495, 0.541904, 0.532418>, <-0.558495, 0.570329, 0.245393>, 
      <0.000000, 0.354054, 1.182182>, <0.000000, 0.418936, 0.901145>, <0.000000, 0.541904, 0.532418>, <0.000000, 0.570329, 0.245393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -0.682521, 1.001033>, <-2.073750, -0.617639, 0.719996>, <-2.241385, -0.572229, 0.273665>, <-2.073750, -0.466246, 0.064243>, 
      <-2.073750, -0.407574, 1.051595>, <-2.073750, -0.342691, 0.770558>, <-2.241385, -0.297281, 0.324227>, <-2.073750, -0.191299, 0.114805>, 
      <-2.105174, 0.086695, 1.127450>, <-2.105174, 0.151578, 0.846413>, <-2.265698, 0.266881, 0.427559>, <-2.105174, 0.302970, 0.190660>, 
      <-1.855875, 0.211309, 1.149227>, <-1.855875, 0.276191, 0.868190>, <-2.016399, 0.391494, 0.449336>, <-1.855875, 0.427584, 0.212437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -1.026961, 0.921513>, <-1.855875, -0.962078, 0.640476>, <-2.007333, -0.945792, 0.189658>, <-1.855875, -0.810686, -0.015277>, 
      <-1.976979, -0.998510, 0.928081>, <-1.976979, -0.933627, 0.647044>, <-2.128437, -0.917341, 0.196227>, <-1.976979, -0.782235, -0.008708>, 
      <-2.073750, -0.805041, 0.978502>, <-2.073750, -0.740159, 0.697465>, <-2.241385, -0.694749, 0.251134>, <-2.073750, -0.588766, 0.041712>, 
      <-2.073750, -0.682521, 1.001033>, <-2.073750, -0.617639, 0.719996>, <-2.241385, -0.572229, 0.273665>, <-2.073750, -0.466246, 0.064243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -1.169706, 0.888557>, <0.000000, -1.104824, 0.607520>, <0.000000, -1.122826, 0.185213>, <0.000000, -0.953431, -0.048232>, 
      <-0.558495, -1.169706, 0.888557>, <-0.558495, -1.104824, 0.607520>, <-0.558495, -1.122826, 0.185213>, <-0.558495, -0.953431, -0.048232>, 
      <-1.312939, -1.154513, 0.892065>, <-1.312939, -1.089630, 0.611028>, <-1.464397, -1.073344, 0.160211>, <-1.312939, -0.938238, -0.044725>, 
      <-1.855875, -1.026961, 0.921513>, <-1.855875, -0.962078, 0.640476>, <-2.007333, -0.945792, 0.189658>, <-1.855875, -0.810686, -0.015277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -1.026961, 0.921513>, <1.855875, -0.962078, 0.640476>, <2.007333, -0.945792, 0.189658>, <1.855875, -0.810686, -0.015277>, 
      <1.312939, -1.154513, 0.892065>, <1.312939, -1.089630, 0.611028>, <1.464397, -1.073344, 0.160211>, <1.312939, -0.938238, -0.044725>, 
      <0.558495, -1.169706, 0.888557>, <0.558495, -1.104824, 0.607520>, <0.558495, -1.122826, 0.185213>, <0.558495, -0.953431, -0.048232>, 
      <0.000000, -1.169706, 0.888557>, <0.000000, -1.104824, 0.607520>, <0.000000, -1.122826, 0.185213>, <0.000000, -0.953431, -0.048232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -0.682521, 1.001033>, <2.073750, -0.617639, 0.719996>, <2.241385, -0.572229, 0.273665>, <2.073750, -0.466246, 0.064243>, 
      <2.073750, -0.805041, 0.978502>, <2.073750, -0.740159, 0.697465>, <2.241385, -0.694749, 0.251134>, <2.073750, -0.588766, 0.041712>, 
      <1.976979, -0.998510, 0.928081>, <1.976979, -0.933627, 0.647044>, <2.128437, -0.917341, 0.196227>, <1.976979, -0.782235, -0.008708>, 
      <1.855875, -1.026961, 0.921513>, <1.855875, -0.962078, 0.640476>, <2.007333, -0.945792, 0.189658>, <1.855875, -0.810686, -0.015277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, 0.211309, 1.149227>, <1.855875, 0.276191, 0.868190>, <2.016399, 0.391494, 0.449336>, <1.855875, 0.427584, 0.212437>, 
      <2.105174, 0.086695, 1.127450>, <2.105174, 0.151578, 0.846413>, <2.265698, 0.266881, 0.427559>, <2.105174, 0.302970, 0.190660>, 
      <2.073750, -0.407574, 1.051595>, <2.073750, -0.342691, 0.770558>, <2.241385, -0.297281, 0.324227>, <2.073750, -0.191299, 0.114805>, 
      <2.073750, -0.682521, 1.001033>, <2.073750, -0.617639, 0.719996>, <2.241385, -0.572229, 0.273665>, <2.073750, -0.466246, 0.064243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.354054, 1.182182>, <0.000000, 0.418936, 0.901145>, <0.000000, 0.541904, 0.532418>, <0.000000, 0.570329, 0.245393>, 
      <0.558495, 0.354054, 1.182182>, <0.558495, 0.418936, 0.901145>, <0.558495, 0.541904, 0.532418>, <0.558495, 0.570329, 0.245393>, 
      <1.357832, 0.460258, 1.192733>, <1.357832, 0.525141, 0.911696>, <1.518356, 0.640444, 0.492842>, <1.357832, 0.676533, 0.255943>, 
      <1.855875, 0.211309, 1.149227>, <1.855875, 0.276191, 0.868190>, <2.016399, 0.391494, 0.449336>, <1.855875, 0.427584, 0.212437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, 0.427584, 0.212437>, <-1.665623, 0.470356, -0.068333>, <-1.168210, 0.453166, -0.196840>, <-0.853703, 0.436619, -0.329762>, 
      <-1.357832, 0.676533, 0.255943>, <-1.167580, 0.719306, -0.024827>, <-0.939110, 0.567682, -0.176828>, <-0.624602, 0.551136, -0.309749>, 
      <-0.558495, 0.570329, 0.245393>, <-0.558495, 0.587006, 0.076982>, <-0.256908, 0.550034, -0.152245>, <-0.256908, 0.502282, -0.314602>, 
      <0.000000, 0.570329, 0.245393>, <0.000000, 0.587006, 0.076982>, <0.000000, 0.550034, -0.152245>, <0.000000, 0.502282, -0.314602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.073750, -0.466246, 0.064243>, <-1.845785, -0.322122, -0.220546>, <-1.305943, -0.109696, -0.289943>, <-0.953925, 0.025458, -0.397931>, 
      <-2.073750, -0.191299, 0.114805>, <-1.845785, -0.047174, -0.169984>, <-1.305943, 0.016780, -0.266684>, <-0.953925, 0.151934, -0.374672>, 
      <-2.105174, 0.302970, 0.190660>, <-1.914922, 0.345743, -0.090110>, <-1.282888, 0.395844, -0.206858>, <-0.968380, 0.379297, -0.339779>, 
      <-1.855875, 0.427584, 0.212437>, <-1.665623, 0.470356, -0.068333>, <-1.168210, 0.453166, -0.196840>, <-0.853703, 0.436619, -0.329762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.855875, -0.810686, -0.015277>, <-1.654171, -0.630759, -0.288199>, <-1.170764, -0.327852, -0.339413>, <-0.853703, -0.132985, -0.434510>, 
      <-1.976979, -0.782235, -0.008708>, <-1.775276, -0.602308, -0.281630>, <-1.226472, -0.314765, -0.336391>, <-0.909411, -0.119897, -0.431489>, 
      <-2.073750, -0.588766, 0.041712>, <-1.845785, -0.444642, -0.243077>, <-1.305943, -0.166055, -0.300307>, <-0.953925, -0.030902, -0.408295>, 
      <-2.073750, -0.466246, 0.064243>, <-1.845785, -0.322122, -0.220546>, <-1.305943, -0.109696, -0.289943>, <-0.953925, 0.025458, -0.397931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.953431, -0.048232>, <0.000000, -0.802806, -0.255810>, <0.000000, -0.436108, -0.352773>, <0.000000, -0.198647, -0.449670>, 
      <-0.558495, -0.953431, -0.048232>, <-0.558495, -0.802806, -0.255810>, <-0.256908, -0.436108, -0.352773>, <-0.256908, -0.198647, -0.449670>, 
      <-1.312939, -0.938238, -0.044725>, <-1.111235, -0.758310, -0.317647>, <-0.921013, -0.386526, -0.352959>, <-0.603952, -0.191658, -0.448056>, 
      <-1.855875, -0.810686, -0.015277>, <-1.654171, -0.630759, -0.288199>, <-1.170764, -0.327852, -0.339413>, <-0.853703, -0.132985, -0.434510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, -0.810686, -0.015277>, <1.654171, -0.630759, -0.288199>, <1.170764, -0.327852, -0.339413>, <0.853703, -0.132985, -0.434510>, 
      <1.312939, -0.938238, -0.044725>, <1.111235, -0.758310, -0.317647>, <0.921013, -0.386526, -0.352959>, <0.603952, -0.191658, -0.448056>, 
      <0.558495, -0.953431, -0.048232>, <0.558495, -0.802806, -0.255810>, <0.256908, -0.436108, -0.352773>, <0.256908, -0.198647, -0.449670>, 
      <0.000000, -0.953431, -0.048232>, <0.000000, -0.802806, -0.255810>, <0.000000, -0.436108, -0.352773>, <0.000000, -0.198647, -0.449670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.073750, -0.466246, 0.064243>, <1.845785, -0.322122, -0.220546>, <1.305943, -0.109696, -0.289943>, <0.953925, 0.025458, -0.397931>, 
      <2.073750, -0.588766, 0.041712>, <1.845785, -0.444642, -0.243077>, <1.305943, -0.166055, -0.300307>, <0.953925, -0.030902, -0.408295>, 
      <1.976979, -0.782235, -0.008708>, <1.775276, -0.602308, -0.281630>, <1.226472, -0.314765, -0.336391>, <0.909411, -0.119897, -0.431489>, 
      <1.855875, -0.810686, -0.015277>, <1.654171, -0.630759, -0.288199>, <1.170764, -0.327852, -0.339413>, <0.853703, -0.132985, -0.434510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.855875, 0.427584, 0.212437>, <1.665623, 0.470356, -0.068333>, <1.168210, 0.453166, -0.196840>, <0.853703, 0.436619, -0.329762>, 
      <2.105174, 0.302970, 0.190660>, <1.914922, 0.345743, -0.090110>, <1.282888, 0.395844, -0.206858>, <0.968380, 0.379297, -0.339779>, 
      <2.073750, -0.191299, 0.114805>, <1.845785, -0.047174, -0.169984>, <1.305943, 0.016780, -0.266684>, <0.953925, 0.151934, -0.374672>, 
      <2.073750, -0.466246, 0.064243>, <1.845785, -0.322122, -0.220546>, <1.305943, -0.109696, -0.289943>, <0.953925, 0.025458, -0.397931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.570329, 0.245393>, <0.000000, 0.587006, 0.076982>, <0.000000, 0.550034, -0.152245>, <0.000000, 0.502282, -0.314602>, 
      <0.558495, 0.570329, 0.245393>, <0.558495, 0.587006, 0.076982>, <0.256908, 0.550034, -0.152245>, <0.256908, 0.502282, -0.314602>, 
      <1.357832, 0.676533, 0.255943>, <1.167580, 0.719306, -0.024827>, <0.939110, 0.567682, -0.176828>, <0.624602, 0.551136, -0.309749>, 
      <1.855875, 0.427584, 0.212437>, <1.665623, 0.470356, -0.068333>, <1.168210, 0.453166, -0.196840>, <0.853703, 0.436619, -0.329762>
    }
  }
}
#declare turbina = union {
  object { sPatchObj }
  object { sPatchObj3 }
  material {
    rojo_txt
  }
  scale <0.1, 0.2, 0.2>
  translate  <0.0, -0.33, 1.836681>
}
#declare tomahawk = union {
  object { turbina }
  object { ala1 }
  cylinder { // tirante2
    <0,0,1>, <0,0,0>, 1 
    material {
      cuerpo_txt_1
    }
    scale <0.52, 0.52, 0.1>
    translate  3.7*z
  }
  cylinder { // tirante1
    <0,0,1>, <0,0,0>, 1 
    material {
      cuerpo_txt_1
    }
    scale <0.52, 0.52, 0.1>
    translate  7.4*z
  }
  cylinder { // cuerpo
    <0,0,1>, <0,0,0>, 1 
    scale <0.5181, 0.5181, 11.12>
  }
  sphere { // cabeza
    <0,0,0>,1
    material {
      blanco_txt
    }
    scale <0.5181, 0.5181, 0.7>
    translate  11.12*z
  }
  cone { // propulsor
    <0,0,0>, 0.3, <0,0,1>, 0.5181
    material {
      cuerpo_txt_1
    }
    scale <1.0, 1.0, 0.69>
    translate  -0.69*z
  }
  object { timon1 }
  object { // timon2 -> timon1
    timon1
    rotate -90.0*z
  }
  object { // ala2 -> ala1
    ala1
    rotate 180.0*z
  }
  cone { // llama
    <0,0,0>, 0.0, <0,0,1>, 0.5181
    material {
      llama_txt_1
    }
    hollow
    scale <0.6, 0.6, 5.0>
    translate  -5.699874*z
  }
  material {
    cuerpo_txt
  }
  hollow
  rotate 90.0*x
}
#declare DeathTom = union {
  object { MeshObj2 }
  object { tomahawk }
}
union { // Group001
  object { DeathPave }
  object { DeathTom }
  scale <-1.0, 1.0, 1.0>
  rotate 25.362164*z
  translate  <-6.950699, -0.134965, 0.0>
}


#declare debug_progress         = false;
#declare city_block_count     = <4.000,4.000,0>;
#declare buildings_per_block  = <4.000,4.000,0>;
#declare street_width         = 10.000;
#declare pavement_width       = 4.000;
#declare building_width       = 25.000;
#declare building_gap         = 2.000;
#declare city_tileable           = false;
#declare city_seed      = 0.000;
#declare min_building_height         = 12.500;
#declare max_building_height         = 50.000;
#declare building_height_falloff     = 2.000;
#declare building_height_turb        = 0.500;
#declare pavement_height             = 0.150;
#declare traffic_spacing             = 10.000;
#declare traffic_lanes               = 1.000;
#declare traffic_width               = 3.000;
#declare city_night       = true;
#declare windows_lit         = 0.330;
#declare windows_blend          = 0.250;
#declare city_right_hand_drive         = false;
#declare max_building_types         = 100.000;
#declare city_transform = transform {rotate <90-0.000,0.000,-53.527> scale <-1*0.500,0.500,0.500> translate <-196.570,97.319,-100.305>}
#include "City.inc"




#version unofficial megapov 0.7;
	glow
	{
		type 2
		size 1.000
		radius 0.000
		warp {turbulence   1}
		location <-156.399,54.670,-68.782>
		color rgb <1.000,0.000,0.000>
	}


