/*
 *  "War Games"
 *
 *  Created for the IRTC Stills topic "Warfare"
 *	
 *	Copyright 2001 Mark Wagner
 */

#version 3.5;
global_settings{
    assumed_gamma 1
}

#declare included = true;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare cm = 1/2.54;   /* 1 POV unit = 1 inch */
#include "units.inc"    /* www.geocities.com/Rengaw03/Pov-Ray.html */

#include "warunits.inc" /* The game counters */
#include "warmacros.inc"    /* Macros to place the game counters */

#declare RotSeed = seed(98746052);
#declare Seed2 = seed(896438);

/* The mapboard */
#declare MapBoard = intersection{
    height_field{
        tga "map2.tga"
        smooth
        translate <-.5,0,-.5>
        scale <10,1,10>*feet
    }
    box{<-4.99,0,-4.99>*feet,<4.99,2,4.99>*feet} 
    texture{
        pigment{rgb <0,.5,0>}
    }
    texture{
        pigment{
            image_map{ tga "road overlay.tga"}
            rotate x*90
            translate <-.5,0,-.5>
            rotate y*-90
            scale <-1,1,1>*10*feet
        }
    }
}

/* Table */
union{
    box{
        <-5,0,-5>*feet,<5,-.1,5>*feet
        pigment{rgb <0,1,0>}
    }
    box{
        <-5,0,-5>*feet,<5,.1,5>*feet
        pigment{rgb <0,.5,1>}
    }
    #macro FrameSide()
    difference{
        union{
            box{<-5.1,0,5>*feet,<5.1,1,5.1>*feet}
            cylinder{<-5.1,1,5.05>*feet,<5.1,1,5.05>*feet,.05*feet}
            box{<-5.6,.75,5.1>*feet,<5.6,.85,5.6>*feet texture{DMFDarkOak rotate y*90 rotate x*(3+(6*rand(Seed2))) scale 5*inch finish{ambient .1 diffuse .4 specular 1 roughness .02}}}
        }
        box{<0,-.01,0>*feet,<.2,1.5,.2>*feet rotate y*135 translate <5.1,0,5.1>*feet  }
        box{<0,-.01,0>*feet,<.2,1.5,.2>*feet rotate y*135 translate <-5.1,0,5.1>*feet }
        texture{DMFDarkOak rotate x*(83+(6*rand(Seed2))) scale 5*inch finish{ambient .1 diffuse .4 specular 1 roughness .02}}
    }
    #end
    union{
        object{FrameSide()}
        object{FrameSide() rotate y*90}
        object{FrameSide() rotate y*180}
        object{FrameSide() rotate y*270}
    }

    object{MapBoard}
}

/* Game counters */
#declare DispSeed = seed(587.436);
Object(RedFlag, <-.75,0,2.25>*feet,rand(RotSeed), true)
/* Red defensive forces */
#declare Counter = 0;
#while(Counter < 30)
    Object(RedInfantry, vrotate(<0,0,0.75+(rand(DispSeed)*.2-.1)>*feet, y*(Counter*(180/25)))+<-.75,0,2.25>*feet, (Counter*(180/25)), false)
    #declare Counter = Counter + 1;
#end

/* Red reinforcements */
Object(T80,<-4.7,0,2.35>*feet,100, true)
Object(T80,<-4.2,0,2.10>*feet,120, true)
Object(T80,<-3.7,0,1.75>*feet,120, true)
Object(T80,<-3.2,0,1.50>*feet,110, true)

Object(T80,<-4.7,0,-1.62>*feet,90, true)
Object(T80,<-4.2,0,-1.60>*feet,80, true)

/* Blue attacking forces */
Object(M1A2, <4.55,0,1.35>*feet, -87, true)
Object(M1A2, <4.05,0,1.65>*feet, -78, true)
Object(M1A2, <3.55,0,1.85>*feet, -78, true)

Object(BlueInfantry, <2.53,0,-0.86>*feet, -90, false)
Object(BlueInfantry, <2.42,0,-0.69>*feet, -90, false)
Object(BlueInfantry, <2.41,0,-0.52>*feet, -90, false)
Object(BlueInfantry, <2.38,0,-0.35>*feet, -90, false)
Object(BlueInfantry, <2.28,0,-0.18>*feet, -90, false)

Object(BlueInfantry, <2.20,0,0.00>*feet, -90, false)
Object(BlueInfantry, <2.25,0,0.22>*feet, -90, false)
Object(BlueInfantry, <2.20,0,0.38>*feet, -90, false)
Object(BlueInfantry, <2.15,0,0.60>*feet, -90, false)
Object(BlueInfantry, <2.10,0,0.75>*feet, -90, false)

Object(BlueInfantry, <2.10,0,0.75>*feet, -90, false)
Object(BlueInfantry, <2.15,0,0.93>*feet, -90, false)
Object(BlueInfantry, <2.05,0,1.08>*feet, -90, false)
Object(BlueInfantry, <2.10,0,1.25>*feet, -90, false)
Object(BlueInfantry, <2.13,0,1.40>*feet, -90, false)

Object(BlueInfantry, <2.18,0,1.50>*feet, -90, false)
Object(BlueInfantry, <2.22,0,1.62>*feet, -90, false)
Object(BlueInfantry, <2.16,0,1.75>*feet, -90, false)
Object(BlueInfantry, <2.17,0,1.91>*feet, -90, false)
//Object(BlueInfantry, <2.14,0,2.10>*feet, -90, false)

Object(Humvee, <2.80,0,-.30>*feet, -90, true)
Object(Humvee, <2.60,0,0.30>*feet, -90, true)
Object(Humvee, <2.50,0,1.00>*feet, -90, true)
Object(Humvee, <2.80,0,1.60>*feet, -90, true)

/* Game counters lined up on near side of table.  Scaled up to show detail */
object{Humvee scale 1.6 rotate y*-85 translate <5.5,.85,4.3>*feet }
object{Humvee scale 1.6 rotate y*-92 translate <5.5,.85,4.6>*feet   }
object{Humvee scale 1.6 rotate y*-87 translate <5.5,.85,4.9>*feet   }
object{M1A2 scale 1.5 rotate y*-10 translate <5.4,.85,3.8>*feet}
#declare Counter = 0;
#while(Counter < 20)
    object{BlueInfantry scale 2 rotate y*(60*rand(DispSeed)-30) translate <5.3+(rand(DispSeed)*.05-.025),.85,-2.5+(Counter*.3)>*feet}
    object{BlueInfantry scale 2 rotate y*(60*rand(DispSeed)-30) translate <5.5+(rand(DispSeed)*.05-.025),.85,-2.5+(Counter*.3)>*feet}
    #declare Counter = Counter + 1;
#end
//object{BlueInfantry scale 2 translate <5.4,.85,3.0>*feet}

object{T80 scale 1.7 rotate y*135 translate <4.8,.85,5.4>*feet}
#declare Counter = 0;
#while(Counter < 10)
    object{RedInfantry scale 2 rotate y*90+(60*rand(DispSeed)-30) translate <4.2-(Counter*.3),.85,5.3+(rand(DispSeed)*.05-.025)>*feet}
    object{RedInfantry scale 2 rotate y*90+(60*rand(DispSeed)-30) translate <4.2-(Counter*.3),.85,5.5+(rand(DispSeed)*.05-.025)>*feet}
    #declare Counter = Counter + 1;
#end

/* Players */

#undef BM_Hand_R_Object
#include "officer1.inc"
#include "bmdefs.inc"
#include "bm_pose.inc"
#include "bmpeople.inc"
#declare BM_Gender = Male;
#declare MIL_Officer = true;
#declare MIL_Rifle = false;
#declare MIL_Sidearm = false;
#include "military.cdf"
Blob_Man(Male, 7*feet)
object{BlobMan rotate y*-90 transform BMO_Foot_R translate <-6.8,-2.8,0>*feet}

#declare BM_PoseNo = 1;
Blob_Man(Male, 7*feet)
object{BlobMan rotate y*-110 transform BMO_Foot_R translate <-6.8,-2.8,-3.8>*feet}

#declare BM_PoseNo = -1;
#include "officer2.inc"
Blob_Man(Male, 7*feet)
object{BlobMan rotate y*180 transform BMO_Foot_R translate <-3.3,-2.8,-6.5>*feet}



/* Background: Walls, posters, furniture, etc */
// Walls, ceiling
box{<-15,-3,-15>*feet, <20,7,20>*feet pigment{rgb 1} hollow}

/* Camera, lights, etc. */

#declare MainView = camera{
    location <12,6,6>*feet
    look_at <0,0,0>*feet
    angle 40
}

// +w800 +h800
#declare TopView = camera{
    orthographic
    location y*6*feet
    direction -y
    up    x*15*feet
    right z*15*feet
}

camera{MainView}

light_source{<0,6.5,10>*feet, 1}