#ifndef(included)
    camera {
        location <200,100,-200>
        look_at 0
    }
    
    global_settings{assumed_gamma 1}
    
    plane{y, -36 pigment{checker rgb 1 rgb .5 scale 20}}
    
    light_source {<0, 0, -546.000000>, rgb 1}
    light_source {<0, 546.000000, 0>, rgb 1}
    light_source {<546.000000, 0, 0>, rgb 1}
#end

#declare Camoflage = texture{ // Medium green base
    pigment{rgb <0,0.20,0>}
    finish{ambient 0}
}
texture{ // Dark green splotches
    pigment{
        bozo
        color_map{
            [0.25 rgb  <0,.15,0>]
            [0.45 rgbt <0,.15.0,1>]            
        }
    }
    finish{ambient 0.02}
}
texture{ // Olive green splotches
    pigment{
        bozo
        color_map{
            [0.25 rgb  <0.3,0.3,0.18>^(1.8)]
            [0.35 rgbt <0.3,0.3,0.06,1>^(1.8)]            
        }
    }
    finish{ambient 0.02}
    translate <23,4,27>
}
texture{ // Tan splotches
    pigment{
        bozo
        color_map{
            [0.25 rgb  <0.3,0.3,0.1>]
            [0.35 rgbt <0.3,0.3,0.1,1>]            
        }
    }
    finish{ambient 0.02}
    translate <49,23,9>
};

#local CAMO_SCALE = 10;

#declare DarkCamo = texture{pigment{rgb <0,.15,0>}}
#declare Glass = texture{pigment{rgbt <1,1,1,.9>}}
#declare Rubber = texture{pigment{rgb 0}}

// Object converted to POVRay V3.0 by Crossroads 3D
#declare _body_all = texture {Camoflage scale CAMO_SCALE}
#declare _all_inside = texture {pigment{rgb <1,1,0>}}
#declare _all = texture {Camoflage scale CAMO_SCALE}
#declare _all_headlgts = texture {pigment{rgb <0,1,1>}}
#declare _all_windows = texture {Glass}
#declare _all_hubs = texture {DarkCamo}
#declare _all_wheels = texture {Rubber}
#declare _all_tailgate = texture {DarkCamo}


// This object has the following minimum and maximum values:
// xmin=-43.750000, xmax=43.750000
// ymin=-35.966673, ymax=35.966673
// zmin=-95.500000, zmax=91.500000

#declare HumveeModel = object {
  union {
    // _body_all
    mesh {
      triangle {
        <43.000000, -12.033327, -5.000000>,
        <43.000000, 14.066671, -5.000000>,
        < 43.000000, 14.066671, -2.000000>
      }
      triangle {
        <42.959068, 15.942305, -5.000000>,
        <43.000000, 14.066671, -2.000000>,
        < 43.000000, 14.066671, -5.000000>
      }
      triangle {
        <43.000000, 7.767363, -2.000000>,
        <43.000000, -12.033327, -5.000000>,
        < 43.000000, 14.066671, -2.000000>
      }
      triangle {
        <42.959068, 15.942305, -2.000000>,
        <43.000000, 14.066671, -2.000000>,
        < 42.959068, 15.942305, -5.000000>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -12.033327, -25.019699>,
        < 43.000000, -12.033327, -5.000000>
      }
      triangle {
        <43.000000, -12.033327, 6.000000>,
        <43.000000, -20.033327, -30.116203>,
        < 43.000000, -12.033327, -5.000000>
      }
      triangle {
        <43.000000, 7.767363, -2.000000>,
        <43.000000, -12.033327, 6.000000>,
        < 43.000000, -12.033327, -5.000000>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -11.828297, -26.819199>,
        < 43.000000, -12.033327, -25.019699>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -11.223686, -28.526604>,
        < 43.000000, -11.828297, -26.819199>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -10.250477, -30.054298>,
        < 43.000000, -11.223686, -28.526604>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -8.958576, -31.323799>,
        < 43.000000, -10.250477, -30.054298>
      }
      triangle {
        <43.000000, -19.828297, -31.915802>,
        <43.000000, -7.414278, -32.270103>,
        < 43.000000, -8.958576, -31.323799>
      }
      triangle {
        <43.000000, -20.033327, -30.116203>,
        <43.000000, -19.828297, -31.915802>,
        < 43.000000, -8.958576, -31.323799>
      }
      triangle {
        <43.000000, -15.414278, -37.366699>,
        <43.000000, 10.566671, -40.654800>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <43.000000, -16.958576, -36.420303>,
        <43.000000, -15.414278, -37.366699>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <43.000000, -18.250477, -35.150803>,
        <43.000000, -16.958576, -36.420303>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <43.000000, -19.223686, -33.623199>,
        <43.000000, -18.250477, -35.150803>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <43.000000, -19.828297, -31.915802>,
        <43.000000, -19.223686, -33.623199>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <43.000000, 1.833552, -72.124695>,
        <43.000000, 10.566671, -89.500000>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 1.966673, -70.978699>,
        <43.000000, 1.833552, -72.124695>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 1.966673, -48.656906>,
        <43.000000, 1.966673, -70.978699>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 1.838514, -47.532104>,
        <43.000000, 1.966673, -48.656906>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 1.460634, -46.464996>,
        <43.000000, 1.838514, -47.532104>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 0.852411, -45.510300>,
        <43.000000, 1.460634, -46.464996>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 0.045012, -44.716904>,
        <43.000000, 0.852411, -45.510300>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, -0.920236, -44.125397>,
        <43.000000, 0.045012, -44.716904>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, -15.414278, -37.366699>,
        <43.000000, -0.920236, -44.125397>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <43.000000, 1.441343, -73.209595>,
        <43.000000, -6.033327, -89.500000>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <43.000000, 1.833552, -72.124695>,
        <43.000000, 1.441343, -73.209595>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <43.000000, 0.810911, -74.175797>,
        <43.000000, -6.033327, -80.995697>,
        < 43.000000, -6.033327, -89.500000>
      }
      triangle {
        <43.000000, 1.441343, -73.209595>,
        <43.000000, 0.810911, -74.175797>,
        < 43.000000, -6.033327, -89.500000>
      }
      triangle {
        <43.000000, -0.024248, -74.971802>,
        <43.000000, -5.891848, -80.085297>,
        < 43.000000, -6.033327, -80.995697>
      }
      triangle {
        <43.000000, 0.810911, -74.175797>,
        <43.000000, -0.024248, -74.971802>,
        < 43.000000, -6.033327, -80.995697>
      }
      triangle {
        <43.000000, -0.024248, -74.971802>,
        <43.000000, -5.480707, -79.260696>,
        < 43.000000, -5.891848, -80.085297>
      }
      triangle {
        <43.000000, -0.024248, -74.971802>,
        <43.000000, -4.838777, -78.599792>,
        < 43.000000, -5.480707, -79.260696>
      }
      triangle {
        <43.000000, -12.033327, 30.500000>,
        <43.000000, -20.033327, 45.500000>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <43.000000, -12.033327, 6.000000>,
        <43.000000, -12.033327, 30.500000>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <43.000000, 11.267313, 55.500000>,
        <43.000000, -0.033327, 56.134190>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <43.000000, 12.460924, 55.500000>,
        <43.000000, 11.267313, 55.500000>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <43.000000, 13.280882, 44.509762>,
        <43.000000, 12.460924, 55.500000>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <43.000000, -12.033327, 30.500000>,
        <43.000000, 13.280882, 44.509762>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <43.000000, 11.267313, 55.500000>,
        <43.000000, 0.442461, 56.411018>,
        < 43.000000, -0.033327, 56.134190>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 0.895712, 56.729870>,
        < 43.000000, 0.442461, 56.411018>
      }
      triangle {
        <43.000000, 11.267313, 55.500000>,
        <43.000000, 10.625933, 62.588591>,
        < 43.000000, 0.442461, 56.411018>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 1.311014, 57.092030>,
        < 43.000000, 0.895712, 56.729870>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 1.672941, 57.498779>,
        < 43.000000, 1.311014, 57.092030>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 1.969862, 57.949940>,
        < 43.000000, 1.672941, 57.498779>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.208574, 58.438068>,
        < 43.000000, 1.969862, 57.949940>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.401781, 58.953430>,
        < 43.000000, 2.208574, 58.438068>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.562124, 59.486271>,
        < 43.000000, 2.401781, 58.953430>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.702204, 60.026920>,
        < 43.000000, 2.562124, 59.486271>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.830172, 60.569189>,
        < 43.000000, 2.702204, 60.026920>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 2.947134, 61.112431>,
        < 43.000000, 2.830172, 60.569189>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 3.053583, 61.656490>,
        < 43.000000, 2.947134, 61.112431>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 3.149992, 62.201229>,
        < 43.000000, 3.053583, 61.656490>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 3.236872, 62.746481>,
        < 43.000000, 3.149992, 62.201229>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.314684, 63.292089>,
        < 43.000000, 3.236872, 62.746481>
      }
      triangle {
        <43.000000, 10.625933, 62.588591>,
        <43.000000, 9.770002, 69.664591>,
        < 43.000000, 3.236872, 62.746481>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.383925, 63.837919>,
        < 43.000000, 3.314684, 63.292089>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.445063, 64.383801>,
        < 43.000000, 3.383925, 63.837919>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.498613, 64.929600>,
        < 43.000000, 3.445063, 64.383801>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.545035, 65.475149>,
        < 43.000000, 3.498613, 64.929600>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.584833, 66.020300>,
        < 43.000000, 3.545035, 65.475149>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.618471, 66.564899>,
        < 43.000000, 3.584833, 66.020300>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.646452, 67.108810>,
        < 43.000000, 3.618471, 66.564899>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.669252, 67.651850>,
        < 43.000000, 3.646452, 67.108810>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.687365, 68.193899>,
        < 43.000000, 3.669252, 67.651850>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.701262, 68.734779>,
        < 43.000000, 3.687365, 68.193899>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.711443, 69.274361>,
        < 43.000000, 3.701262, 68.734779>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 3.718382, 69.812469>,
        < 43.000000, 3.711443, 69.274361>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.722574, 70.348961>,
        < 43.000000, 3.718382, 69.812469>
      }
      triangle {
        <43.000000, 9.770002, 69.664591>,
        <43.000000, 8.643702, 76.703710>,
        < 43.000000, 3.718382, 69.812469>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.724432, 70.883739>,
        < 43.000000, 3.722574, 70.348961>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.723662, 71.417231>,
        < 43.000000, 3.724432, 70.883739>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.719603, 71.950150>,
        < 43.000000, 3.723662, 71.417231>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.711554, 72.483210>,
        < 43.000000, 3.719603, 71.950150>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.698855, 73.017130>,
        < 43.000000, 3.711554, 72.483210>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.680803, 73.552650>,
        < 43.000000, 3.698855, 73.017130>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.656733, 74.090460>,
        < 43.000000, 3.680803, 73.552650>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.625944, 74.631310>,
        < 43.000000, 3.656733, 74.090460>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.587774, 75.175910>,
        < 43.000000, 3.625944, 74.631310>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.541521, 75.724980>,
        < 43.000000, 3.587774, 75.175910>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.486525, 76.279230>,
        < 43.000000, 3.541521, 75.724980>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 3.422083, 76.839400>,
        < 43.000000, 3.486525, 76.279230>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 3.347525, 77.406200>,
        < 43.000000, 3.422083, 76.839400>
      }
      triangle {
        <43.000000, 8.643702, 76.703710>,
        <43.000000, 7.156504, 83.663294>,
        < 43.000000, 3.422083, 76.839400>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 3.262163, 77.980340>,
        < 43.000000, 3.347525, 77.406200>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 3.164793, 78.561080>,
        < 43.000000, 3.262163, 77.980340>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 3.053042, 79.144340>,
        < 43.000000, 3.164793, 78.561080>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 2.924383, 79.725560>,
        < 43.000000, 3.053042, 79.144340>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 2.776262, 80.300230>,
        < 43.000000, 2.924383, 79.725560>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 2.606154, 80.863780>,
        < 43.000000, 2.776262, 80.300230>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 2.411512, 81.411689>,
        < 43.000000, 2.606154, 80.863780>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 2.189802, 81.939413>,
        < 43.000000, 2.411512, 81.411689>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 1.938501, 82.442412>,
        < 43.000000, 2.189802, 81.939413>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 1.655054, 82.916145>,
        < 43.000000, 1.938501, 82.442412>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 1.336931, 83.356071>,
        < 43.000000, 1.655054, 82.916145>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 0.981592, 83.757650>,
        < 43.000000, 1.336931, 83.356071>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, 0.586504, 84.116342>,
        < 43.000000, 0.981592, 83.757650>
      }
      triangle {
        <43.000000, 7.156504, 83.663294>,
        <43.000000, 5.216673, 90.500000>,
        < 43.000000, 0.981592, 83.757650>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, 0.149122, 84.427606>,
        < 43.000000, 0.586504, 84.116342>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -0.332968, 84.687035>,
        < 43.000000, 0.149122, 84.427606>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -0.854288, 84.899877>,
        < 43.000000, -0.332968, 84.687035>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -1.396017, 85.087590>,
        < 43.000000, -0.854288, 84.899877>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -1.938085, 85.273198>,
        < 43.000000, -1.396017, 85.087590>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -2.460398, 85.479724>,
        < 43.000000, -1.938085, 85.273198>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -2.942865, 85.730193>,
        < 43.000000, -2.460398, 85.479724>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -3.365415, 86.047628>,
        < 43.000000, -2.942865, 85.730193>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -3.707956, 86.455088>,
        < 43.000000, -3.365415, 86.047628>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -3.944555, 86.955949>,
        < 43.000000, -3.707956, 86.455088>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -4.033327, 87.500000>,
        < 43.000000, -3.944555, 86.955949>
      }
      triangle {
        <43.000000, 5.216673, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < 43.000000, -4.033327, 87.500000>
      }
      triangle {
        <43.000000, -12.033327, 30.500000>,
        <43.000000, 13.566671, 33.500000>,
        < 43.000000, 13.280882, 44.509762>
      }
      triangle {
        <43.000000, -12.033327, 30.500000>,
        <43.000000, 14.066671, 33.500000>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <43.000000, -12.033327, 30.500000>,
        <43.000000, 14.066671, 30.500000>,
        < 43.000000, 14.066671, 33.500000>
      }
      triangle {
        <42.959068, 15.942305, 30.500000>,
        <43.000000, 14.066671, 33.500000>,
        < 43.000000, 14.066671, 30.500000>
      }
      triangle {
        <42.959068, 15.942305, 33.500000>,
        <43.000000, 14.066671, 33.500000>,
        < 42.959068, 15.942305, 30.500000>
      }
      triangle {
        <42.959068, 15.942305, 33.500000>,
        <42.959068, 15.942305, 30.500000>,
        < 42.836369, 17.814371, 30.500000>
      }
      triangle {
        <42.836369, 17.814371, 33.500000>,
        <42.836369, 17.814371, 30.500000>,
        < 41.647572, 31.402456, 30.500000>
      }
      triangle {
        <42.959068, 15.942305, 33.500000>,
        <42.836369, 17.814371, 30.500000>,
        < 42.836369, 17.814371, 33.500000>
      }
      triangle {
        <42.836369, 17.814371, 33.500000>,
        <41.647572, 31.402456, 30.500000>,
        < 41.647572, 31.402456, 33.500000>
      }
      triangle {
        <1.500000, 16.066671, 33.500000>,
        <1.500000, 16.066671, 30.500000>,
        < 1.500000, 33.966673, 30.500000>
      }
      triangle {
        <1.500000, 16.066671, 33.500000>,
        <1.500000, 33.966673, 30.500000>,
        < 1.500000, 33.966673, 33.500000>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-40.951191, 16.066671, 30.500000>,
        < -40.905151, 16.853853, 30.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-40.905151, 16.853853, 30.500000>,
        < -40.843979, 17.640062, 30.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-40.951191, 16.066671, 33.500000>,
        < -40.905151, 16.853853, 30.500000>
      }
      triangle {
        <-40.843979, 17.640062, 33.500000>,
        <-40.843979, 17.640062, 30.500000>,
        < -39.655182, 31.228140, 30.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-40.843979, 17.640062, 30.500000>,
        < -40.843979, 17.640062, 33.500000>
      }
      triangle {
        <-40.843979, 17.640062, 33.500000>,
        <-39.655182, 31.228140, 30.500000>,
        < -39.655182, 31.228140, 33.500000>
      }
      triangle {
        <42.959068, 15.942305, -2.000000>,
        <42.959068, 15.942305, -5.000000>,
        < 42.836369, 17.814371, -5.000000>
      }
      triangle {
        <42.836369, 17.814371, -2.000000>,
        <42.836369, 17.814371, -5.000000>,
        < 41.647572, 31.402456, -5.000000>
      }
      triangle {
        <42.959068, 15.942305, -2.000000>,
        <42.836369, 17.814371, -5.000000>,
        < 42.836369, 17.814371, -2.000000>
      }
      triangle {
        <42.836369, 17.814371, -2.000000>,
        <41.647572, 31.402456, -5.000000>,
        < 41.647572, 31.402456, -2.000000>
      }
      triangle {
        <43.500000, 14.066671, 31.625000>,
        <43.000000, 14.066671, 31.625000>,
        < 43.000000, -11.533327, 31.625000>
      }
      triangle {
        <43.458599, 15.964113, 31.521900>,
        <42.959068, 15.942312, 31.521900>,
        < 43.000000, 14.066671, 31.625000>
      }
      triangle {
        <43.458599, 15.964113, 31.521900>,
        <43.000000, 14.066671, 31.625000>,
        < 43.500000, 14.066671, 31.625000>
      }
      triangle {
        <43.500000, -11.533327, 31.625000>,
        <43.000000, -11.533327, 31.625000>,
        < 43.000000, -12.032938, 31.491249>
      }
      triangle {
        <43.500000, -11.533327, 31.625000>,
        <43.500000, 14.066671, 31.625000>,
        < 43.000000, -11.533327, 31.625000>
      }
      triangle {
        <43.500000, -12.032938, 31.491249>,
        <43.000000, -12.032938, 31.491249>,
        < 43.000000, -12.399576, 31.124611>
      }
      triangle {
        <43.500000, -12.032938, 31.491249>,
        <43.500000, -11.533327, 31.625000>,
        < 43.000000, -12.032938, 31.491249>
      }
      triangle {
        <43.500000, -12.399576, 31.124611>,
        <43.000000, -12.399576, 31.124611>,
        < 43.000000, -12.533327, 30.625000>
      }
      triangle {
        <43.500000, -12.032938, 31.491249>,
        <43.000000, -12.399576, 31.124611>,
        < 43.500000, -12.399576, 31.124611>
      }
      triangle {
        <43.500000, -12.533327, 30.625000>,
        <43.000000, -12.533327, 30.625000>,
        < 43.000000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, -12.399576, 31.124611>,
        <43.000000, -12.533327, 30.625000>,
        < 43.500000, -12.533327, 30.625000>
      }
      triangle {
        <43.500000, -12.533327, -2.125000>,
        <43.000000, -12.533327, -2.125000>,
        < 43.000000, -12.399576, -2.624611>
      }
      triangle {
        <43.500000, -12.533327, -2.125000>,
        <43.500000, -12.533327, 30.625000>,
        < 43.000000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, -12.399576, -2.624611>,
        <43.000000, -12.399576, -2.624611>,
        < 43.000000, -12.032938, -2.991249>
      }
      triangle {
        <43.500000, -12.399576, -2.624611>,
        <43.500000, -12.533327, -2.125000>,
        < 43.000000, -12.399576, -2.624611>
      }
      triangle {
        <43.500000, -12.032938, -2.991249>,
        <43.000000, -12.032938, -2.991249>,
        < 43.000000, -11.533327, -3.125000>
      }
      triangle {
        <43.500000, -12.399576, -2.624611>,
        <43.000000, -12.032938, -2.991249>,
        < 43.500000, -12.032938, -2.991249>
      }
      triangle {
        <43.500000, -11.533327, -3.125000>,
        <43.000000, -11.533327, -3.125000>,
        < 43.000000, 7.466673, -3.125000>
      }
      triangle {
        <43.500000, -12.032938, -2.991249>,
        <43.000000, -11.533327, -3.125000>,
        < 43.500000, -11.533327, -3.125000>
      }
      triangle {
        <43.500000, 7.466673, -3.125000>,
        <43.000000, 7.466673, -3.125000>,
        < 43.000000, 14.066671, -3.125000>
      }
      triangle {
        <43.500000, 7.466673, -3.125000>,
        <43.500000, -11.533327, -3.125000>,
        < 43.000000, 7.466673, -3.125000>
      }
      triangle {
        <43.500000, 14.066671, -3.125000>,
        <43.000000, 14.066671, -3.125000>,
        < 42.959068, 15.942312, -3.021896>
      }
      triangle {
        <43.500000, 14.066671, -3.125000>,
        <43.500000, 7.466673, -3.125000>,
        < 43.000000, 14.066671, -3.125000>
      }
      triangle {
        <43.334469, 17.857943, 31.418999>,
        <42.836369, 17.814371, 31.418999>,
        < 42.959068, 15.942312, 31.521900>
      }
      triangle {
        <42.153099, 31.361044, 30.676762>,
        <41.654999, 31.317465, 30.676762>,
        < 42.836369, 17.814371, 31.418999>
      }
      triangle {
        <42.153099, 31.361044, 30.676762>,
        <42.836369, 17.814371, 31.418999>,
        < 43.334469, 17.857943, 31.418999>
      }
      triangle {
        <43.458599, 15.964113, 31.521900>,
        <43.334469, 17.857943, 31.418999>,
        < 42.959068, 15.942312, 31.521900>
      }
      triangle {
        <43.458599, 15.964113, -3.021896>,
        <42.959068, 15.942312, -3.021896>,
        < 42.836369, 17.814371, -2.918999>
      }
      triangle {
        <43.458599, 15.964113, -3.021896>,
        <43.500000, 14.066671, -3.125000>,
        < 42.959068, 15.942312, -3.021896>
      }
      triangle {
        <42.153099, 31.361044, -2.176758>,
        <42.836369, 17.814371, -2.918999>,
        < 41.654999, 31.317465, -2.176758>
      }
      triangle {
        <43.334469, 17.857943, -2.918999>,
        <43.458599, 15.964113, -3.021896>,
        < 42.836369, 17.814371, -2.918999>
      }
      triangle {
        <42.153099, 31.361044, -2.176758>,
        <43.334469, 17.857943, -2.918999>,
        < 42.836369, 17.814371, -2.918999>
      }
      triangle {
        <42.153099, 31.361044, -2.176758>,
        <41.654999, 31.317465, -2.176758>,
        < 41.613499, 31.791884, -2.025688>
      }
      triangle {
        <42.111599, 31.835463, -2.025688>,
        <41.613499, 31.791884, -2.025688>,
        < 41.583488, 32.134855, -1.662041>
      }
      triangle {
        <42.111599, 31.835463, -2.025688>,
        <42.153099, 31.361044, -2.176758>,
        < 41.613499, 31.791884, -2.025688>
      }
      triangle {
        <42.081589, 32.178434, -1.662041>,
        <41.583488, 32.134855, -1.662041>,
        < 41.572609, 32.259192, -1.178261>
      }
      triangle {
        <42.111599, 31.835463, -2.025688>,
        <41.583488, 32.134855, -1.662041>,
        < 42.081589, 32.178434, -1.662041>
      }
      triangle {
        <42.070709, 32.302771, -1.178261>,
        <41.572609, 32.259192, -1.178261>,
        < 41.572609, 32.259192, 29.678261>
      }
      triangle {
        <42.081589, 32.178434, -1.662041>,
        <41.572609, 32.259192, -1.178261>,
        < 42.070709, 32.302771, -1.178261>
      }
      triangle {
        <42.070709, 32.302771, 29.678261>,
        <41.572609, 32.259192, 29.678261>,
        < 41.583488, 32.134855, 30.162041>
      }
      triangle {
        <42.070709, 32.302771, 29.678261>,
        <42.070709, 32.302771, -1.178261>,
        < 41.572609, 32.259192, 29.678261>
      }
      triangle {
        <42.111599, 31.835463, 30.525688>,
        <41.583488, 32.134855, 30.162041>,
        < 41.613499, 31.791884, 30.525688>
      }
      triangle {
        <42.081589, 32.178434, 30.162041>,
        <42.070709, 32.302771, 29.678261>,
        < 41.583488, 32.134855, 30.162041>
      }
      triangle {
        <42.081589, 32.178434, 30.162041>,
        <41.583488, 32.134855, 30.162041>,
        < 42.111599, 31.835463, 30.525688>
      }
      triangle {
        <42.111599, 31.835463, 30.525688>,
        <41.613499, 31.791884, 30.525688>,
        < 41.654999, 31.317465, 30.676762>
      }
      triangle {
        <42.111599, 31.835463, 30.525688>,
        <41.654999, 31.317465, 30.676762>,
        < 42.153099, 31.361044, 30.676762>
      }
      triangle {
        <43.750000, 25.966673, 4.625000>,
        <43.250000, 25.966673, 4.625000>,
        < 43.250000, 11.966673, 4.625000>
      }
      triangle {
        <43.750000, 25.966673, 24.625000>,
        <43.250000, 25.966673, 24.625000>,
        < 43.250000, 25.966673, 4.625000>
      }
      triangle {
        <43.750000, 25.966673, 4.625000>,
        <43.750000, 25.966673, 24.625000>,
        < 43.250000, 25.966673, 4.625000>
      }
      triangle {
        <43.750000, 11.966673, 4.625000>,
        <43.250000, 11.966673, 4.625000>,
        < 43.250000, 11.966673, 24.625000>
      }
      triangle {
        <43.750000, 11.966673, 4.625000>,
        <43.750000, 25.966673, 4.625000>,
        < 43.250000, 11.966673, 4.625000>
      }
      triangle {
        <43.750000, 11.966673, 24.625000>,
        <43.250000, 11.966673, 24.625000>,
        < 43.250000, 25.966673, 24.625000>
      }
      triangle {
        <43.750000, 11.966673, 24.625000>,
        <43.750000, 11.966673, 4.625000>,
        < 43.250000, 11.966673, 24.625000>
      }
      triangle {
        <43.750000, 11.966673, 24.625000>,
        <43.250000, 25.966673, 24.625000>,
        < 43.750000, 25.966673, 24.625000>
      }
      triangle {
        <43.500000, -12.032938, 31.491249>,
        <43.500000, 14.066671, 31.625000>,
        < 43.500000, -11.533327, 31.625000>
      }
      triangle {
        <43.500000, 9.466673, 27.125000>,
        <43.500000, 14.066671, 31.625000>,
        < 43.500000, -12.533327, 30.625000>
      }
      triangle {
        <43.500000, -12.399576, 31.124611>,
        <43.500000, -12.533327, 30.625000>,
        < 43.500000, 14.066671, 31.625000>
      }
      triangle {
        <43.458599, 15.964113, 27.125000>,
        <43.458599, 15.964113, 31.521900>,
        < 43.500000, 14.066671, 31.625000>
      }
      triangle {
        <43.500000, 9.466673, 27.125000>,
        <43.500000, 14.066671, 27.125000>,
        < 43.500000, 14.066671, 31.625000>
      }
      triangle {
        <43.458599, 15.964113, 27.125000>,
        <43.500000, 14.066671, 31.625000>,
        < 43.500000, 14.066671, 27.125000>
      }
      triangle {
        <43.500000, -12.032938, 31.491249>,
        <43.500000, -12.399576, 31.124611>,
        < 43.500000, 14.066671, 31.625000>
      }
      triangle {
        <43.500000, 9.466673, 27.125000>,
        <43.500000, -12.533327, 30.625000>,
        < 43.500000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, 9.466673, 2.125000>,
        <43.500000, 9.466673, 27.125000>,
        < 43.500000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, 14.066671, 2.125000>,
        <43.500000, 9.466673, 2.125000>,
        < 43.500000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, -12.399576, -2.624611>,
        <43.500000, 14.066671, 2.125000>,
        < 43.500000, -12.533327, -2.125000>
      }
      triangle {
        <43.500000, 14.066671, 2.125000>,
        <43.500000, -11.533327, -3.125000>,
        < 43.500000, 7.466673, -3.125000>
      }
      triangle {
        <43.500000, -12.032938, -2.991249>,
        <43.500000, -11.533327, -3.125000>,
        < 43.500000, 14.066671, 2.125000>
      }
      triangle {
        <43.500000, 14.066671, 2.125000>,
        <43.500000, 7.466673, -3.125000>,
        < 43.500000, 14.066671, -3.125000>
      }
      triangle {
        <43.500000, 14.066671, 2.125000>,
        <43.500000, 14.066671, -3.125000>,
        < 43.458599, 15.964113, -3.021896>
      }
      triangle {
        <43.458599, 15.964113, 2.125000>,
        <43.458599, 15.964113, -3.021896>,
        < 43.334469, 17.857943, -2.918999>
      }
      triangle {
        <43.458599, 15.964113, 2.125000>,
        <43.500000, 14.066671, 2.125000>,
        < 43.458599, 15.964113, -3.021896>
      }
      triangle {
        <42.111599, 31.835463, -2.025688>,
        <43.334469, 17.857943, -2.918999>,
        < 42.153099, 31.361044, -2.176758>
      }
      triangle {
        <42.406330, 28.466673, 2.125000>,
        <43.334469, 17.857943, -2.918999>,
        < 42.070709, 32.302771, -1.178261>
      }
      triangle {
        <42.081589, 32.178434, -1.662041>,
        <42.070709, 32.302771, -1.178261>,
        < 43.334469, 17.857943, -2.918999>
      }
      triangle {
        <43.334469, 17.857943, 2.125000>,
        <43.458599, 15.964113, 2.125000>,
        < 43.334469, 17.857943, -2.918999>
      }
      triangle {
        <42.406330, 28.466673, 2.125000>,
        <43.334469, 17.857943, 2.125000>,
        < 43.334469, 17.857943, -2.918999>
      }
      triangle {
        <42.111599, 31.835463, -2.025688>,
        <42.081589, 32.178434, -1.662041>,
        < 43.334469, 17.857943, -2.918999>
      }
      triangle {
        <43.334469, 17.857943, 27.125000>,
        <43.334469, 17.857943, 31.418999>,
        < 43.458599, 15.964113, 31.521900>
      }
      triangle {
        <43.334469, 17.857943, 27.125000>,
        <42.153099, 31.361044, 30.676762>,
        < 43.334469, 17.857943, 31.418999>
      }
      triangle {
        <43.458599, 15.964113, 27.125000>,
        <43.334469, 17.857943, 27.125000>,
        < 43.458599, 15.964113, 31.521900>
      }
      triangle {
        <42.406330, 28.466673, 2.125000>,
        <42.070709, 32.302771, -1.178261>,
        < 42.070709, 32.302771, 29.678261>
      }
      triangle {
        <42.406330, 28.466673, 27.125000>,
        <42.070709, 32.302771, 29.678261>,
        < 43.334469, 17.857943, 27.125000>
      }
      triangle {
        <42.081589, 32.178434, 30.162041>,
        <43.334469, 17.857943, 27.125000>,
        < 42.070709, 32.302771, 29.678261>
      }
      triangle {
        <42.406330, 28.466673, 27.125000>,
        <42.406330, 28.466673, 2.125000>,
        < 42.070709, 32.302771, 29.678261>
      }
      triangle {
        <42.111599, 31.835463, 30.525688>,
        <42.153099, 31.361044, 30.676762>,
        < 43.334469, 17.857943, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.750000, 25.966673, 24.625000>,
        < 43.750000, 25.966673, 4.625000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.750000, 11.966673, 24.625000>,
        < 43.750000, 25.966673, 24.625000>
      }
      triangle {
        <43.750000, 9.466673, 2.125000>,
        <43.750000, 25.966673, 4.625000>,
        < 43.750000, 11.966673, 4.625000>
      }
      triangle {
        <43.750000, 28.466673, 2.125000>,
        <43.750000, 25.966673, 4.625000>,
        < 43.750000, 9.466673, 2.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.750000, 25.966673, 4.625000>,
        < 43.750000, 28.466673, 2.125000>
      }
      triangle {
        <43.750000, 9.466673, 2.125000>,
        <43.750000, 11.966673, 4.625000>,
        < 43.750000, 11.966673, 24.625000>
      }
      triangle {
        <43.750000, 9.466673, 27.125000>,
        <43.750000, 9.466673, 2.125000>,
        < 43.750000, 11.966673, 24.625000>
      }
      triangle {
        <43.750000, 9.466673, 27.125000>,
        <43.750000, 11.966673, 24.625000>,
        < 43.750000, 28.466673, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.500000, 14.066671, 27.125000>,
        < 43.500000, 9.466673, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.458599, 15.964113, 27.125000>,
        < 43.500000, 14.066671, 27.125000>
      }
      triangle {
        <43.750000, 9.466673, 27.125000>,
        <43.500000, 9.466673, 27.125000>,
        < 43.500000, 9.466673, 2.125000>
      }
      triangle {
        <43.750000, 9.466673, 27.125000>,
        <43.750000, 28.466673, 27.125000>,
        < 43.500000, 9.466673, 27.125000>
      }
      triangle {
        <43.750000, 9.466673, 2.125000>,
        <43.500000, 9.466673, 2.125000>,
        < 43.500000, 14.066671, 2.125000>
      }
      triangle {
        <43.750000, 9.466673, 27.125000>,
        <43.500000, 9.466673, 2.125000>,
        < 43.750000, 9.466673, 2.125000>
      }
      triangle {
        <43.500000, -12.399576, -2.624611>,
        <43.500000, -12.032938, -2.991249>,
        < 43.500000, 14.066671, 2.125000>
      }
      triangle {
        <43.750000, 9.466673, 2.125000>,
        <43.500000, 14.066671, 2.125000>,
        < 43.458599, 15.964113, 2.125000>
      }
      triangle {
        <43.750000, 28.466673, 2.125000>,
        <43.458599, 15.964113, 2.125000>,
        < 43.334469, 17.857943, 2.125000>
      }
      triangle {
        <43.750000, 28.466673, 2.125000>,
        <43.750000, 9.466673, 2.125000>,
        < 43.458599, 15.964113, 2.125000>
      }
      triangle {
        <43.750000, 28.466673, 2.125000>,
        <43.334469, 17.857943, 2.125000>,
        < 42.406330, 28.466673, 2.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.334469, 17.857943, 27.125000>,
        < 43.458599, 15.964113, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <42.406330, 28.466673, 27.125000>,
        < 43.334469, 17.857943, 27.125000>
      }
      triangle {
        <42.081589, 32.178434, 30.162041>,
        <42.111599, 31.835463, 30.525688>,
        < 43.334469, 17.857943, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 2.125000>,
        <42.406330, 28.466673, 2.125000>,
        < 42.406330, 28.466673, 27.125000>
      }
      triangle {
        <43.750000, 28.466673, 27.125000>,
        <43.750000, 28.466673, 2.125000>,
        < 42.406330, 28.466673, 27.125000>
      }
      triangle {
        <43.500000, 14.066671, -3.875000>,
        <43.000000, 14.066671, -3.875000>,
        < 43.000000, -11.533327, -3.875000>
      }
      triangle {
        <43.458599, 15.964113, -3.978104>,
        <42.959068, 15.942312, -3.978104>,
        < 43.000000, 14.066671, -3.875000>
      }
      triangle {
        <43.458599, 15.964113, -3.978104>,
        <43.000000, 14.066671, -3.875000>,
        < 43.500000, 14.066671, -3.875000>
      }
      triangle {
        <43.500000, -11.533327, -3.875000>,
        <43.000000, -11.533327, -3.875000>,
        < 43.000000, -12.032947, -4.008759>
      }
      triangle {
        <43.500000, -11.533327, -3.875000>,
        <43.500000, 14.066671, -3.875000>,
        < 43.000000, -11.533327, -3.875000>
      }
      triangle {
        <43.500000, -12.032947, -4.008759>,
        <43.000000, -12.032947, -4.008759>,
        < 43.000000, -12.399567, -4.375381>
      }
      triangle {
        <43.500000, -12.032947, -4.008759>,
        <43.500000, -11.533327, -3.875000>,
        < 43.000000, -12.032947, -4.008759>
      }
      triangle {
        <43.500000, -12.399567, -4.375381>,
        <43.000000, -12.399567, -4.375381>,
        < 43.000000, -12.533327, -4.875000>
      }
      triangle {
        <43.500000, -12.032947, -4.008759>,
        <43.000000, -12.399567, -4.375381>,
        < 43.500000, -12.399567, -4.375381>
      }
      triangle {
        <43.500000, -12.533327, -4.875000>,
        <43.000000, -12.533327, -4.875000>,
        < 43.000000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, -12.399567, -4.375381>,
        <43.000000, -12.533327, -4.875000>,
        < 43.500000, -12.533327, -4.875000>
      }
      triangle {
        <43.500000, -12.533327, -28.984299>,
        <43.000000, -12.533327, -28.984299>,
        < 43.000000, -12.324497, -30.084000>
      }
      triangle {
        <43.500000, -12.533327, -28.984299>,
        <43.500000, -12.533327, -4.875000>,
        < 43.000000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, -12.324497, -30.084000>,
        <43.000000, -12.324497, -30.084000>,
        < 43.000000, -11.729677, -31.027901>
      }
      triangle {
        <43.500000, -12.324497, -30.084000>,
        <43.500000, -12.533327, -28.984299>,
        < 43.000000, -12.324497, -30.084000>
      }
      triangle {
        <43.500000, -11.729677, -31.027901>,
        <43.000000, -11.729677, -31.027901>,
        < 43.000000, -10.827698, -31.690697>
      }
      triangle {
        <43.500000, -12.324497, -30.084000>,
        <43.000000, -11.729677, -31.027901>,
        < 43.500000, -11.729677, -31.027901>
      }
      triangle {
        <43.500000, -10.827698, -31.690697>,
        <43.000000, -10.827698, -31.690697>,
        < 43.000000, 10.466673, -41.875000>
      }
      triangle {
        <43.500000, -11.729677, -31.027901>,
        <43.000000, -10.827698, -31.690697>,
        < 43.500000, -10.827698, -31.690697>
      }
      triangle {
        <43.500000, 10.466673, -41.875000>,
        <43.000000, 10.466673, -41.875000>,
        < 43.000000, 14.066671, -39.727493>
      }
      triangle {
        <43.500000, 10.466673, -41.875000>,
        <43.500000, -10.827698, -31.690697>,
        < 43.000000, 10.466673, -41.875000>
      }
      triangle {
        <43.500000, 14.066671, -39.727493>,
        <43.000000, 14.066671, -39.727493>,
        < 42.959061, 15.942541, -38.608505>
      }
      triangle {
        <43.500000, 14.066671, -39.727493>,
        <43.500000, 10.466673, -41.875000>,
        < 43.000000, 14.066671, -39.727493>
      }
      triangle {
        <43.334469, 17.857943, -4.081001>,
        <42.836369, 17.814371, -4.081001>,
        < 42.959068, 15.942312, -3.978104>
      }
      triangle {
        <42.153099, 31.361044, -4.823242>,
        <41.654999, 31.317465, -4.823242>,
        < 42.836369, 17.814371, -4.081001>
      }
      triangle {
        <42.153099, 31.361044, -4.823242>,
        <42.836369, 17.814371, -4.081001>,
        < 43.334469, 17.857943, -4.081001>
      }
      triangle {
        <43.458599, 15.964113, -3.978104>,
        <43.334469, 17.857943, -4.081001>,
        < 42.959068, 15.942312, -3.978104>
      }
      triangle {
        <43.458591, 15.964354, -38.608505>,
        <42.959061, 15.942541, -38.608505>,
        < 42.836369, 17.814371, -37.491798>
      }
      triangle {
        <43.458591, 15.964354, -38.608505>,
        <43.500000, 14.066671, -39.727493>,
        < 42.959061, 15.942541, -38.608505>
      }
      triangle {
        <43.334469, 17.857943, -37.491798>,
        <42.836369, 17.814371, -37.491798>,
        < 41.700508, 30.797377, -29.747002>
      }
      triangle {
        <43.334469, 17.857943, -37.491798>,
        <43.458591, 15.964354, -38.608505>,
        < 42.836369, 17.814371, -37.491798>
      }
      triangle {
        <42.198601, 30.840956, -29.747002>,
        <41.700508, 30.797377, -29.747002>,
        < 41.632591, 31.573713, -29.079903>
      }
      triangle {
        <42.198601, 30.840956, -29.747002>,
        <43.334469, 17.857943, -37.491798>,
        < 41.700508, 30.797377, -29.747002>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <41.632591, 31.573713, -29.079903>,
        < 41.587898, 32.084463, -28.178802>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <42.198601, 30.840956, -29.747002>,
        < 41.632591, 31.573713, -29.079903>
      }
      triangle {
        <42.085999, 32.128035, -28.178802>,
        <41.587898, 32.084463, -28.178802>,
        < 41.572609, 32.259192, -27.167999>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <41.587898, 32.084463, -28.178802>,
        < 42.085999, 32.128035, -28.178802>
      }
      triangle {
        <42.070709, 32.302771, -27.167999>,
        <41.572609, 32.259192, -27.167999>,
        < 41.572609, 32.259192, -5.821739>
      }
      triangle {
        <42.085999, 32.128035, -28.178802>,
        <41.572609, 32.259192, -27.167999>,
        < 42.070709, 32.302771, -27.167999>
      }
      triangle {
        <42.070709, 32.302771, -5.821739>,
        <41.572609, 32.259192, -5.821739>,
        < 41.583488, 32.134855, -5.337959>
      }
      triangle {
        <42.070709, 32.302771, -5.821739>,
        <42.070709, 32.302771, -27.167999>,
        < 41.572609, 32.259192, -5.821739>
      }
      triangle {
        <42.111599, 31.835463, -4.974312>,
        <41.583488, 32.134855, -5.337959>,
        < 41.613499, 31.791884, -4.974312>
      }
      triangle {
        <42.081589, 32.178434, -5.337959>,
        <42.070709, 32.302771, -5.821739>,
        < 41.583488, 32.134855, -5.337959>
      }
      triangle {
        <42.081589, 32.178434, -5.337959>,
        <41.583488, 32.134855, -5.337959>,
        < 42.111599, 31.835463, -4.974312>
      }
      triangle {
        <42.111599, 31.835463, -4.974312>,
        <41.613499, 31.791884, -4.974312>,
        < 41.654999, 31.317465, -4.823242>
      }
      triangle {
        <42.111599, 31.835463, -4.974312>,
        <41.654999, 31.317465, -4.823242>,
        < 42.153099, 31.361044, -4.823242>
      }
      triangle {
        <43.750000, 25.966673, -25.875000>,
        <43.250000, 25.966673, -25.875000>,
        < 43.250000, 11.966673, -25.875000>
      }
      triangle {
        <43.750000, 25.966673, -9.875000>,
        <43.250000, 25.966673, -9.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      triangle {
        <43.750000, 25.966673, -25.875000>,
        <43.750000, 25.966673, -9.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      triangle {
        <43.750000, 11.966673, -25.875000>,
        <43.250000, 11.966673, -25.875000>,
        < 43.250000, 11.966673, -9.875000>
      }
      triangle {
        <43.750000, 11.966673, -25.875000>,
        <43.750000, 25.966673, -25.875000>,
        < 43.250000, 11.966673, -25.875000>
      }
      triangle {
        <43.750000, 11.966673, -9.875000>,
        <43.250000, 11.966673, -9.875000>,
        < 43.250000, 25.966673, -9.875000>
      }
      triangle {
        <43.750000, 11.966673, -9.875000>,
        <43.750000, 11.966673, -25.875000>,
        < 43.250000, 11.966673, -9.875000>
      }
      triangle {
        <43.750000, 11.966673, -9.875000>,
        <43.250000, 25.966673, -9.875000>,
        < 43.750000, 25.966673, -9.875000>
      }
      triangle {
        <43.500000, -12.032947, -4.008759>,
        <43.500000, 14.066671, -3.875000>,
        < 43.500000, -11.533327, -3.875000>
      }
      triangle {
        <43.500000, 9.466673, -7.375000>,
        <43.500000, 14.066671, -3.875000>,
        < 43.500000, -12.533327, -4.875000>
      }
      triangle {
        <43.500000, -12.399567, -4.375381>,
        <43.500000, -12.533327, -4.875000>,
        < 43.500000, 14.066671, -3.875000>
      }
      triangle {
        <43.458599, 15.964113, -7.375000>,
        <43.458599, 15.964113, -3.978104>,
        < 43.500000, 14.066671, -3.875000>
      }
      triangle {
        <43.500000, 9.466673, -7.375000>,
        <43.500000, 14.066671, -7.375000>,
        < 43.500000, 14.066671, -3.875000>
      }
      triangle {
        <43.458599, 15.964113, -7.375000>,
        <43.500000, 14.066671, -3.875000>,
        < 43.500000, 14.066671, -7.375000>
      }
      triangle {
        <43.500000, -12.032947, -4.008759>,
        <43.500000, -12.399567, -4.375381>,
        < 43.500000, 14.066671, -3.875000>
      }
      triangle {
        <43.500000, 9.466673, -7.375000>,
        <43.500000, -12.533327, -4.875000>,
        < 43.500000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, 9.466673, -28.375000>,
        <43.500000, 9.466673, -7.375000>,
        < 43.500000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, 14.066671, -28.375000>,
        <43.500000, 9.466673, -28.375000>,
        < 43.500000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, -12.324497, -30.084000>,
        <43.500000, 14.066671, -28.375000>,
        < 43.500000, -12.533327, -28.984299>
      }
      triangle {
        <43.500000, 14.066671, -39.727493>,
        <43.500000, -10.827698, -31.690697>,
        < 43.500000, 10.466673, -41.875000>
      }
      triangle {
        <43.500000, 14.066671, -28.375000>,
        <43.500000, -10.827698, -31.690697>,
        < 43.500000, 14.066671, -39.727493>
      }
      triangle {
        <43.500000, -11.729677, -31.027901>,
        <43.500000, -10.827698, -31.690697>,
        < 43.500000, 14.066671, -28.375000>
      }
      triangle {
        <43.500000, 14.066671, -28.375000>,
        <43.500000, 14.066671, -39.727493>,
        < 43.458591, 15.964354, -38.608505>
      }
      triangle {
        <43.458599, 15.964113, -28.375000>,
        <43.458591, 15.964354, -38.608505>,
        < 43.334469, 17.857943, -37.491798>
      }
      triangle {
        <43.458599, 15.964113, -28.375000>,
        <43.500000, 14.066671, -28.375000>,
        < 43.458591, 15.964354, -38.608505>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <43.334469, 17.857943, -37.491798>,
        < 42.198601, 30.840956, -29.747002>
      }
      triangle {
        <43.334469, 17.857943, -28.375000>,
        <43.458599, 15.964113, -28.375000>,
        < 43.334469, 17.857943, -37.491798>
      }
      triangle {
        <42.406330, 28.466673, -28.375000>,
        <43.334469, 17.857943, -28.375000>,
        < 43.334469, 17.857943, -37.491798>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <42.406330, 28.466673, -28.375000>,
        < 43.334469, 17.857943, -37.491798>
      }
      triangle {
        <43.334469, 17.857943, -7.375000>,
        <43.334469, 17.857943, -4.081001>,
        < 43.458599, 15.964113, -3.978104>
      }
      triangle {
        <43.334469, 17.857943, -7.375000>,
        <42.153099, 31.361044, -4.823242>,
        < 43.334469, 17.857943, -4.081001>
      }
      triangle {
        <43.458599, 15.964113, -7.375000>,
        <43.334469, 17.857943, -7.375000>,
        < 43.458599, 15.964113, -3.978104>
      }
      triangle {
        <42.406330, 28.466673, -7.375000>,
        <42.070709, 32.302771, -27.167999>,
        < 42.070709, 32.302771, -5.821739>
      }
      triangle {
        <42.406330, 28.466673, -7.375000>,
        <42.406330, 28.466673, -28.375000>,
        < 42.070709, 32.302771, -27.167999>
      }
      triangle {
        <42.085999, 32.128035, -28.178802>,
        <42.070709, 32.302771, -27.167999>,
        < 42.406330, 28.466673, -28.375000>
      }
      triangle {
        <42.406330, 28.466673, -7.375000>,
        <42.070709, 32.302771, -5.821739>,
        < 43.334469, 17.857943, -7.375000>
      }
      triangle {
        <42.081589, 32.178434, -5.337959>,
        <43.334469, 17.857943, -7.375000>,
        < 42.070709, 32.302771, -5.821739>
      }
      triangle {
        <42.111599, 31.835463, -4.974312>,
        <42.153099, 31.361044, -4.823242>,
        < 43.334469, 17.857943, -7.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.750000, 25.966673, -9.875000>,
        < 43.750000, 25.966673, -25.875000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.750000, 11.966673, -9.875000>,
        < 43.750000, 25.966673, -9.875000>
      }
      triangle {
        <43.750000, 9.466673, -28.375000>,
        <43.750000, 25.966673, -25.875000>,
        < 43.750000, 11.966673, -25.875000>
      }
      triangle {
        <43.750000, 28.466673, -28.375000>,
        <43.750000, 25.966673, -25.875000>,
        < 43.750000, 9.466673, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.750000, 25.966673, -25.875000>,
        < 43.750000, 28.466673, -28.375000>
      }
      triangle {
        <43.750000, 9.466673, -28.375000>,
        <43.750000, 11.966673, -25.875000>,
        < 43.750000, 11.966673, -9.875000>
      }
      triangle {
        <43.750000, 9.466673, -7.375000>,
        <43.750000, 9.466673, -28.375000>,
        < 43.750000, 11.966673, -9.875000>
      }
      triangle {
        <43.750000, 9.466673, -7.375000>,
        <43.750000, 11.966673, -9.875000>,
        < 43.750000, 28.466673, -7.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.500000, 14.066671, -7.375000>,
        < 43.500000, 9.466673, -7.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.458599, 15.964113, -7.375000>,
        < 43.500000, 14.066671, -7.375000>
      }
      triangle {
        <43.750000, 9.466673, -7.375000>,
        <43.500000, 9.466673, -7.375000>,
        < 43.500000, 9.466673, -28.375000>
      }
      triangle {
        <43.750000, 9.466673, -7.375000>,
        <43.750000, 28.466673, -7.375000>,
        < 43.500000, 9.466673, -7.375000>
      }
      triangle {
        <43.750000, 9.466673, -28.375000>,
        <43.500000, 9.466673, -28.375000>,
        < 43.500000, 14.066671, -28.375000>
      }
      triangle {
        <43.750000, 9.466673, -7.375000>,
        <43.500000, 9.466673, -28.375000>,
        < 43.750000, 9.466673, -28.375000>
      }
      triangle {
        <43.500000, -12.324497, -30.084000>,
        <43.500000, -11.729677, -31.027901>,
        < 43.500000, 14.066671, -28.375000>
      }
      triangle {
        <43.750000, 9.466673, -28.375000>,
        <43.500000, 14.066671, -28.375000>,
        < 43.458599, 15.964113, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -28.375000>,
        <43.458599, 15.964113, -28.375000>,
        < 43.334469, 17.857943, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -28.375000>,
        <43.750000, 9.466673, -28.375000>,
        < 43.458599, 15.964113, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -28.375000>,
        <43.334469, 17.857943, -28.375000>,
        < 42.406330, 28.466673, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.334469, 17.857943, -7.375000>,
        < 43.458599, 15.964113, -7.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <42.406330, 28.466673, -7.375000>,
        < 43.334469, 17.857943, -7.375000>
      }
      triangle {
        <42.081589, 32.178434, -5.337959>,
        <42.111599, 31.835463, -4.974312>,
        < 43.334469, 17.857943, -7.375000>
      }
      triangle {
        <43.750000, 28.466673, -28.375000>,
        <42.406330, 28.466673, -28.375000>,
        < 42.406330, 28.466673, -7.375000>
      }
      triangle {
        <42.130680, 31.617293, -29.079903>,
        <42.085999, 32.128035, -28.178802>,
        < 42.406330, 28.466673, -28.375000>
      }
      triangle {
        <43.750000, 28.466673, -7.375000>,
        <43.750000, 28.466673, -28.375000>,
        < 42.406330, 28.466673, -7.375000>
      }
      triangle {
        <-42.771210, 18.559141, -84.164307>,
        <-42.836369, 17.814371, -85.084198>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-42.924881, 16.607233, -86.184097>,
        <-42.836369, 17.814371, -36.470299>,
        < -42.836369, 17.814371, -85.084198>
      }
      triangle {
        <-42.726780, 19.067064, -83.094604>,
        <-42.771210, 18.559141, -84.164307>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-41.647572, 31.402456, -46.434601>,
        <-42.726780, 19.067064, -83.094604>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-41.866291, 28.902456, -30.068604>,
        <-41.647572, 31.402456, -46.434601>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-42.934818, 16.433352, -86.349396>,
        <-42.959049, 15.942862, -37.550903>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-42.924881, 16.607233, -86.184097>,
        <-42.934818, 16.433352, -86.349396>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-41.662430, 31.232596, -27.030701>,
        <-41.647572, 31.402456, -25.738503>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-41.706059, 30.733870, -28.236298>,
        <-41.662430, 31.232596, -27.030701>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-41.775581, 29.939253, -29.272797>,
        <-41.706059, 30.733870, -28.236298>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-41.866291, 28.902456, -30.068604>,
        <-41.775581, 29.939253, -29.272797>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-43.000000, 14.066671, -89.500000>,
        <-43.000000, 10.566671, -40.654800>,
        < -43.000000, 14.066671, -38.634094>
      }
      triangle {
        <-42.959049, 15.942862, -37.550903>,
        <-43.000000, 14.066671, -89.500000>,
        < -43.000000, 14.066671, -38.634094>
      }
      triangle {
        <-43.000000, 14.066671, -89.500000>,
        <-43.000000, 10.566671, -89.500000>,
        < -43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-42.985279, 15.191603, -87.741699>,
        <-43.000000, 14.066671, -89.500000>,
        < -42.959049, 15.942862, -37.550903>
      }
      triangle {
        <-42.976501, 15.488012, -87.360901>,
        <-42.985279, 15.191603, -87.741699>,
        < -42.959049, 15.942862, -37.550903>
      }
      triangle {
        <-42.934818, 16.433352, -86.349396>,
        <-42.976501, 15.488012, -87.360901>,
        < -42.959049, 15.942862, -37.550903>
      }
      texture{_body_all}
    }
    // _all_inside
    mesh {
      triangle {
        <42.959068, 15.942305, -2.000000>,
        <43.000000, 7.767363, -2.000000>,
        < 43.000000, 14.066671, -2.000000>
      }
      triangle {
        <40.000000, -12.033327, -5.000000>,
        <43.000000, 14.066671, -5.000000>,
        < 43.000000, -12.033327, -5.000000>
      }
      triangle {
        <42.959068, 15.942305, -5.000000>,
        <43.000000, 14.066671, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <40.000000, -12.033327, -5.000000>,
        <43.000000, -12.033327, -5.000000>,
        < 43.000000, -12.033327, -25.019699>
      }
      triangle {
        <21.000000, -12.033327, -25.019699>,
        <43.000000, -12.033327, -25.019699>,
        < 43.000000, -11.828297, -26.819199>
      }
      triangle {
        <21.000000, -12.033327, -25.019699>,
        <21.000000, -12.033327, 30.500000>,
        < 43.000000, -12.033327, -25.019699>
      }
      triangle {
        <40.000000, -12.033327, -5.000000>,
        <43.000000, -12.033327, -25.019699>,
        < 21.000000, -12.033327, 30.500000>
      }
      triangle {
        <21.000000, -11.828287, -26.819298>,
        <43.000000, -11.828297, -26.819199>,
        < 43.000000, -11.223686, -28.526604>
      }
      triangle {
        <21.000000, -12.033327, -25.019699>,
        <43.000000, -11.828297, -26.819199>,
        < 21.000000, -11.828287, -26.819298>
      }
      triangle {
        <21.000000, -11.223677, -28.526604>,
        <43.000000, -11.223686, -28.526604>,
        < 43.000000, -10.250477, -30.054298>
      }
      triangle {
        <21.000000, -11.828287, -26.819298>,
        <43.000000, -11.223686, -28.526604>,
        < 21.000000, -11.223677, -28.526604>
      }
      triangle {
        <21.000000, -10.250498, -30.054199>,
        <43.000000, -10.250477, -30.054298>,
        < 43.000000, -8.958576, -31.323799>
      }
      triangle {
        <21.000000, -11.223677, -28.526604>,
        <43.000000, -10.250477, -30.054298>,
        < 21.000000, -10.250498, -30.054199>
      }
      triangle {
        <21.000000, -8.958616, -31.323799>,
        <43.000000, -8.958576, -31.323799>,
        < 43.000000, -7.414278, -32.270103>
      }
      triangle {
        <21.000000, -10.250498, -30.054199>,
        <43.000000, -8.958576, -31.323799>,
        < 21.000000, -8.958616, -31.323799>
      }
      triangle {
        <26.000000, 10.566671, -40.654800>,
        <43.000000, -7.414278, -32.270103>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <26.000000, -3.033327, -34.313004>,
        <43.000000, -7.414278, -32.270103>,
        < 26.000000, 10.566671, -40.654800>
      }
      triangle {
        <21.000000, -3.033327, -34.313004>,
        <43.000000, -7.414278, -32.270103>,
        < 26.000000, -3.033327, -34.313004>
      }
      triangle {
        <21.000000, -7.414278, -32.270103>,
        <43.000000, -7.414278, -32.270103>,
        < 21.000000, -3.033327, -34.313004>
      }
      triangle {
        <21.000000, -8.958616, -31.323799>,
        <43.000000, -7.414278, -32.270103>,
        < 21.000000, -7.414278, -32.270103>
      }
      triangle {
        <26.000000, 10.566671, -89.500000>,
        <43.000000, 10.566671, -40.654800>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <26.000000, 10.566671, -40.654800>,
        <43.000000, 10.566671, -40.654800>,
        < 26.000000, 10.566671, -89.500000>
      }
      triangle {
        <21.000000, -12.033327, 30.500000>,
        <43.000000, 14.066671, 30.500000>,
        < 43.000000, -12.033327, 30.500000>
      }
      triangle {
        <21.000000, -12.033327, 30.500000>,
        <42.959068, 15.942305, 30.500000>,
        < 43.000000, 14.066671, 30.500000>
      }
      triangle {
        <21.000000, -12.033327, 30.500000>,
        <43.000000, -12.033327, 30.500000>,
        < 43.000000, -12.033327, 6.000000>
      }
      triangle {
        <40.000000, -12.033327, 6.000000>,
        <43.000000, -12.033327, 6.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <40.000000, -12.033327, 6.000000>,
        <21.000000, -12.033327, 30.500000>,
        < 43.000000, -12.033327, 6.000000>
      }
      triangle {
        <40.000000, 7.767363, -2.000000>,
        <40.000000, -12.033327, 6.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <40.000000, 14.066671, -2.000000>,
        <40.000000, 7.767363, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <40.635159, 33.576841, -2.000000>,
        <40.000000, 14.066671, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <41.153290, 32.526182, -2.000000>,
        <40.635159, 33.576841, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <41.398521, 31.380659, -2.000000>,
        <41.153290, 32.526182, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <41.647572, 31.402456, -2.000000>,
        <41.398521, 31.380659, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <42.836369, 17.814371, -2.000000>,
        <41.647572, 31.402456, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <42.959068, 15.942305, -2.000000>,
        <42.836369, 17.814371, -2.000000>,
        < 43.000000, 7.767363, -2.000000>
      }
      triangle {
        <-42.959068, 15.942305, -5.000000>,
        <-43.000000, -12.033327, -5.000000>,
        < -43.000000, 14.066671, -5.000000>
      }
      triangle {
        <-40.000000, 7.767363, -2.000000>,
        <-43.000000, 14.066671, -2.000000>,
        < -43.000000, 7.767363, -2.000000>
      }
      triangle {
        <-42.959068, 15.942305, -2.000000>,
        <-43.000000, 14.066671, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-40.000000, 7.767363, -2.000000>,
        <-43.000000, 7.767363, -2.000000>,
        < -43.000000, -12.033327, 6.000000>
      }
      triangle {
        <-40.000000, -12.033327, 6.000000>,
        <-43.000000, -12.033327, 6.000000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-40.000000, 7.767363, -2.000000>,
        <-43.000000, -12.033327, 6.000000>,
        < -40.000000, -12.033327, 6.000000>
      }
      triangle {
        <-42.959068, 15.942305, 30.500000>,
        <-43.000000, -12.033327, 30.500000>,
        < -43.000000, 14.066671, 30.500000>
      }
      triangle {
        <-41.647572, 31.402456, 30.500000>,
        <-41.389408, 32.608305, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-40.951191, 16.066671, 30.500000>,
        <-43.000000, -12.033327, 30.500000>,
        < -41.389408, 32.608305, 30.500000>
      }
      triangle {
        <-42.836369, 17.814371, 30.500000>,
        <-41.647572, 31.402456, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-42.959068, 15.942305, 30.500000>,
        <-42.836369, 17.814371, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-21.000000, -3.033327, 30.500000>,
        <-21.000000, -12.033327, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-21.000000, -12.033327, -25.019699>,
        <-43.000000, -12.033327, 30.500000>,
        < -21.000000, -12.033327, 30.500000>
      }
      triangle {
        <-40.951191, 16.066671, 30.500000>,
        <-21.000000, -3.033327, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-40.000000, -12.033327, 6.000000>,
        <-43.000000, -12.033327, 30.500000>,
        < -21.000000, -12.033327, -25.019699>
      }
      triangle {
        <-26.000000, 10.566671, -40.654800>,
        <-43.000000, 10.566671, -89.500000>,
        < -43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-26.000000, 10.566671, -40.654800>,
        <-26.000000, 10.566671, -89.500000>,
        < -43.000000, 10.566671, -89.500000>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-43.000000, 10.566671, -40.654800>,
        < -43.000000, -7.414278, -32.270103>
      }
      triangle {
        <-26.000000, 10.566671, -40.654800>,
        <-43.000000, 10.566671, -40.654800>,
        < -26.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-26.000000, -3.033327, -34.313004>,
        < -43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-43.000000, -7.414278, -32.270103>,
        < -43.000000, -8.945476, -31.334000>
      }
      triangle {
        <-21.000000, -8.945476, -31.334000>,
        <-43.000000, -8.945476, -31.334000>,
        < -43.000000, -10.245277, -30.060699>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-43.000000, -8.945476, -31.334000>,
        < -21.000000, -8.945476, -31.334000>
      }
      triangle {
        <-21.000000, -10.245277, -30.060699>,
        <-43.000000, -10.245277, -30.060699>,
        < -43.000000, -11.227297, -28.519203>
      }
      triangle {
        <-21.000000, -8.945476, -31.334000>,
        <-43.000000, -10.245277, -30.060699>,
        < -21.000000, -10.245277, -30.060699>
      }
      triangle {
        <-21.000000, -11.227297, -28.519203>,
        <-43.000000, -11.227297, -28.519203>,
        < -43.000000, -11.832006, -26.803001>
      }
      triangle {
        <-21.000000, -10.245277, -30.060699>,
        <-43.000000, -11.227297, -28.519203>,
        < -21.000000, -11.227297, -28.519203>
      }
      triangle {
        <-21.000000, -11.832006, -26.803001>,
        <-43.000000, -11.832006, -26.803001>,
        < -43.000000, -12.033327, -25.019699>
      }
      triangle {
        <-21.000000, -11.227297, -28.519203>,
        <-43.000000, -11.832006, -26.803001>,
        < -21.000000, -11.832006, -26.803001>
      }
      triangle {
        <-21.000000, -12.033327, -25.019699>,
        <-43.000000, -12.033327, -25.019699>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-21.000000, -11.832006, -26.803001>,
        <-43.000000, -12.033327, -25.019699>,
        < -21.000000, -12.033327, -25.019699>
      }
      triangle {
        <-40.000000, -12.033327, -5.000000>,
        <-21.000000, -12.033327, -25.019699>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-40.000000, 14.066671, -5.000000>,
        <-40.000000, -12.033327, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-40.635159, 33.576841, -5.000000>,
        <-40.000000, 14.066671, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-41.153290, 32.526182, -5.000000>,
        <-40.635159, 33.576841, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-41.398521, 31.380659, -5.000000>,
        <-41.153290, 32.526182, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-41.647572, 31.402456, -5.000000>,
        <-41.398521, 31.380659, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-42.836369, 17.814371, -5.000000>,
        <-41.647572, 31.402456, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <-42.959068, 15.942305, -5.000000>,
        <-42.836369, 17.814371, -5.000000>,
        < -43.000000, -12.033327, -5.000000>
      }
      triangle {
        <26.000000, -3.033327, -34.313004>,
        <26.000000, 10.566671, -89.500000>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <26.000000, -3.033327, -34.313004>,
        <26.000000, 10.566671, -40.654800>,
        < 26.000000, 10.566671, -89.500000>
      }
      triangle {
        <-26.000000, -3.033327, -34.313004>,
        <26.000000, -3.033327, -89.500000>,
        < -26.000000, -3.033327, -89.500000>
      }
      triangle {
        <21.000000, -3.033327, -34.313004>,
        <26.000000, -3.033327, -34.313004>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <-21.000000, -3.033327, -34.313004>,
        <21.000000, -3.033327, -34.313004>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <-26.000000, -3.033327, -34.313004>,
        <-21.000000, -3.033327, -34.313004>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <-26.000000, 10.566671, -40.654800>,
        <-26.000000, -3.033327, -89.500000>,
        < -26.000000, 10.566671, -89.500000>
      }
      triangle {
        <-26.000000, 10.566671, -40.654800>,
        <-26.000000, -3.033327, -34.313004>,
        < -26.000000, -3.033327, -89.500000>
      }
      triangle {
        <21.000000, -12.033327, 30.500000>,
        <42.836369, 17.814371, 30.500000>,
        < 42.959068, 15.942305, 30.500000>
      }
      triangle {
        <40.951191, 16.066671, 30.500000>,
        <41.647572, 31.402456, 30.500000>,
        < 42.836369, 17.814371, 30.500000>
      }
      triangle {
        <40.951191, 16.066671, 30.500000>,
        <42.836369, 17.814371, 30.500000>,
        < 21.000000, -12.033327, 30.500000>
      }
      triangle {
        <40.951191, 16.066671, 30.500000>,
        <41.389408, 32.608305, 30.500000>,
        < 41.647572, 31.402456, 30.500000>
      }
      triangle {
        <40.905151, 16.853853, 30.500000>,
        <40.844009, 33.714254, 30.500000>,
        < 41.389408, 32.608305, 30.500000>
      }
      triangle {
        <40.905151, 16.853853, 30.500000>,
        <41.389408, 32.608305, 30.500000>,
        < 40.951191, 16.066671, 30.500000>
      }
      triangle {
        <40.843979, 17.640062, 30.500000>,
        <40.044540, 34.653051, 30.500000>,
        < 40.844009, 33.714254, 30.500000>
      }
      triangle {
        <40.905151, 16.853853, 30.500000>,
        <40.843979, 17.640062, 30.500000>,
        < 40.844009, 33.714254, 30.500000>
      }
      triangle {
        <39.448151, 32.090490, 30.500000>,
        <39.039631, 35.367651, 30.500000>,
        < 40.044540, 34.653051, 30.500000>
      }
      triangle {
        <39.655182, 31.228140, 30.500000>,
        <39.448151, 32.090490, 30.500000>,
        < 40.044540, 34.653051, 30.500000>
      }
      triangle {
        <40.843979, 17.640062, 30.500000>,
        <39.655182, 31.228140, 30.500000>,
        < 40.044540, 34.653051, 30.500000>
      }
      triangle {
        <38.344170, 33.453779, 30.500000>,
        <37.890362, 35.814596, 30.500000>,
        < 39.039631, 35.367651, 30.500000>
      }
      triangle {
        <38.998032, 32.854635, 30.500000>,
        <38.344170, 33.453779, 30.500000>,
        < 39.039631, 35.367651, 30.500000>
      }
      triangle {
        <39.448151, 32.090490, 30.500000>,
        <38.998032, 32.854635, 30.500000>,
        < 39.039631, 35.367651, 30.500000>
      }
      triangle {
        <37.543709, 33.835585, 30.500000>,
        <36.666599, 35.966673, 30.500000>,
        < 37.890362, 35.814596, 30.500000>
      }
      triangle {
        <38.344170, 33.453779, 30.500000>,
        <37.543709, 33.835585, 30.500000>,
        < 37.890362, 35.814596, 30.500000>
      }
      triangle {
        <-36.666599, 33.966673, 30.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <36.666599, 33.966673, 30.500000>,
        <1.500000, 33.966673, 30.500000>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <-1.500000, 33.966673, 30.500000>,
        <36.666599, 35.966673, 30.500000>,
        < 1.500000, 33.966673, 30.500000>
      }
      triangle {
        <37.543709, 33.835585, 30.500000>,
        <36.666599, 33.966673, 30.500000>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <-36.666599, 33.966673, 30.500000>,
        <36.666599, 35.966673, 30.500000>,
        < -1.500000, 33.966673, 30.500000>
      }
      triangle {
        <-37.543709, 33.835585, 30.500000>,
        <-37.890362, 35.814596, 30.500000>,
        < -36.666599, 35.966673, 30.500000>
      }
      triangle {
        <-36.666599, 33.966673, 30.500000>,
        <-37.543709, 33.835585, 30.500000>,
        < -36.666599, 35.966673, 30.500000>
      }
      triangle {
        <-38.998032, 32.854635, 30.500000>,
        <-39.039631, 35.367651, 30.500000>,
        < -37.890362, 35.814596, 30.500000>
      }
      triangle {
        <-38.344170, 33.453779, 30.500000>,
        <-38.998032, 32.854635, 30.500000>,
        < -37.890362, 35.814596, 30.500000>
      }
      triangle {
        <-37.543709, 33.835585, 30.500000>,
        <-38.344170, 33.453779, 30.500000>,
        < -37.890362, 35.814596, 30.500000>
      }
      triangle {
        <-39.655182, 31.228140, 30.500000>,
        <-40.044540, 34.653051, 30.500000>,
        < -39.039631, 35.367651, 30.500000>
      }
      triangle {
        <-39.448151, 32.090490, 30.500000>,
        <-39.655182, 31.228140, 30.500000>,
        < -39.039631, 35.367651, 30.500000>
      }
      triangle {
        <-38.998032, 32.854635, 30.500000>,
        <-39.448151, 32.090490, 30.500000>,
        < -39.039631, 35.367651, 30.500000>
      }
      triangle {
        <-40.843979, 17.640062, 30.500000>,
        <-40.844009, 33.714254, 30.500000>,
        < -40.044540, 34.653051, 30.500000>
      }
      triangle {
        <-39.655182, 31.228140, 30.500000>,
        <-40.843979, 17.640062, 30.500000>,
        < -40.044540, 34.653051, 30.500000>
      }
      triangle {
        <-40.951191, 16.066671, 30.500000>,
        <-41.389408, 32.608305, 30.500000>,
        < -40.844009, 33.714254, 30.500000>
      }
      triangle {
        <-40.905151, 16.853853, 30.500000>,
        <-40.951191, 16.066671, 30.500000>,
        < -40.844009, 33.714254, 30.500000>
      }
      triangle {
        <-40.843979, 17.640062, 30.500000>,
        <-40.905151, 16.853853, 30.500000>,
        < -40.844009, 33.714254, 30.500000>
      }
      triangle {
        <-21.000000, -3.033327, -34.313004>,
        <-21.000000, -12.033327, 30.500000>,
        < -21.000000, -3.033327, 30.500000>
      }
      triangle {
        <-21.000000, -12.033327, -25.019699>,
        <-21.000000, -12.033327, 30.500000>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <1.500000, 16.066671, 30.500000>,
        <21.000000, -3.033327, 30.500000>,
        < -21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -3.033327, -34.313004>,
        <-21.000000, -3.033327, 30.500000>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <-1.500000, 16.066671, 30.500000>,
        <1.500000, 16.066671, 30.500000>,
        < -21.000000, -3.033327, 30.500000>
      }
      triangle {
        <-40.951191, 16.066671, 30.500000>,
        <-1.500000, 16.066671, 30.500000>,
        < -21.000000, -3.033327, 30.500000>
      }
      triangle {
        <-21.000000, -3.033327, -34.313004>,
        <-21.000000, -3.033327, 30.500000>,
        < 21.000000, -3.033327, -34.313004>
      }
      triangle {
        <40.951191, 16.066671, 30.500000>,
        <21.000000, -12.033327, 30.500000>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -12.033327, -25.019699>,
        <21.000000, -3.033327, 30.500000>,
        < 21.000000, -12.033327, 30.500000>
      }
      triangle {
        <1.500000, 16.066671, 30.500000>,
        <40.951191, 16.066671, 30.500000>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -7.414278, -32.270103>,
        <21.000000, -3.033327, -34.313004>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -8.958616, -31.323799>,
        <21.000000, -7.414278, -32.270103>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -10.250498, -30.054199>,
        <21.000000, -8.958616, -31.323799>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -11.223677, -28.526604>,
        <21.000000, -10.250498, -30.054199>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -11.828287, -26.819298>,
        <21.000000, -11.223677, -28.526604>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <21.000000, -12.033327, -25.019699>,
        <21.000000, -11.828287, -26.819298>,
        < 21.000000, -3.033327, 30.500000>
      }
      triangle {
        <40.000000, -12.033327, 6.000000>,
        <40.000000, -12.033327, -5.000000>,
        < 21.000000, -12.033327, 30.500000>
      }
      triangle {
        <-1.500000, 16.066671, 30.500000>,
        <1.500000, 33.966673, 30.500000>,
        < 1.500000, 16.066671, 30.500000>
      }
      triangle {
        <1.500000, 33.966673, 33.500000>,
        <1.500000, 33.966673, 30.500000>,
        < 36.666599, 33.966673, 30.500000>
      }
      triangle {
        <-1.500000, 16.066671, 30.500000>,
        <-1.500000, 33.966673, 30.500000>,
        < 1.500000, 33.966673, 30.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <36.666599, 33.966673, 30.500000>,
        < 37.543709, 33.835585, 30.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <1.500000, 33.966673, 33.500000>,
        < 36.666599, 33.966673, 30.500000>
      }
      triangle {
        <37.543709, 33.835585, 33.500000>,
        <37.543709, 33.835585, 30.500000>,
        < 38.344170, 33.453779, 30.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <37.543709, 33.835585, 30.500000>,
        < 37.543709, 33.835585, 33.500000>
      }
      triangle {
        <38.344170, 33.453779, 33.500000>,
        <38.344170, 33.453779, 30.500000>,
        < 38.998032, 32.854635, 30.500000>
      }
      triangle {
        <37.543709, 33.835585, 33.500000>,
        <38.344170, 33.453779, 30.500000>,
        < 38.344170, 33.453779, 33.500000>
      }
      triangle {
        <38.998032, 32.854635, 33.500000>,
        <38.998032, 32.854635, 30.500000>,
        < 39.448151, 32.090490, 30.500000>
      }
      triangle {
        <38.344170, 33.453779, 33.500000>,
        <38.998032, 32.854635, 30.500000>,
        < 38.998032, 32.854635, 33.500000>
      }
      triangle {
        <39.448151, 32.090490, 33.500000>,
        <39.448151, 32.090490, 30.500000>,
        < 39.655182, 31.228140, 30.500000>
      }
      triangle {
        <38.998032, 32.854635, 33.500000>,
        <39.448151, 32.090490, 30.500000>,
        < 39.448151, 32.090490, 33.500000>
      }
      triangle {
        <39.448151, 32.090490, 33.500000>,
        <39.655182, 31.228140, 30.500000>,
        < 39.655182, 31.228140, 33.500000>
      }
      triangle {
        <-36.666599, 33.966673, 33.500000>,
        <-36.666599, 33.966673, 30.500000>,
        < -1.500000, 33.966673, 30.500000>
      }
      triangle {
        <-36.666599, 33.966673, 33.500000>,
        <-1.500000, 33.966673, 30.500000>,
        < -1.500000, 33.966673, 33.500000>
      }
      triangle {
        <-39.655182, 31.228140, 33.500000>,
        <-39.655182, 31.228140, 30.500000>,
        < -39.448151, 32.090490, 30.500000>
      }
      triangle {
        <-39.448151, 32.090490, 33.500000>,
        <-39.448151, 32.090490, 30.500000>,
        < -38.998032, 32.854635, 30.500000>
      }
      triangle {
        <-39.655182, 31.228140, 33.500000>,
        <-39.448151, 32.090490, 30.500000>,
        < -39.448151, 32.090490, 33.500000>
      }
      triangle {
        <-38.998032, 32.854635, 33.500000>,
        <-38.998032, 32.854635, 30.500000>,
        < -38.344170, 33.453779, 30.500000>
      }
      triangle {
        <-39.448151, 32.090490, 33.500000>,
        <-38.998032, 32.854635, 30.500000>,
        < -38.998032, 32.854635, 33.500000>
      }
      triangle {
        <-38.344170, 33.453779, 33.500000>,
        <-38.344170, 33.453779, 30.500000>,
        < -37.543709, 33.835585, 30.500000>
      }
      triangle {
        <-38.998032, 32.854635, 33.500000>,
        <-38.344170, 33.453779, 30.500000>,
        < -38.344170, 33.453779, 33.500000>
      }
      triangle {
        <-37.543709, 33.835585, 33.500000>,
        <-37.543709, 33.835585, 30.500000>,
        < -36.666599, 33.966673, 30.500000>
      }
      triangle {
        <-38.344170, 33.453779, 33.500000>,
        <-37.543709, 33.835585, 30.500000>,
        < -37.543709, 33.835585, 33.500000>
      }
      triangle {
        <-37.543709, 33.835585, 33.500000>,
        <-36.666599, 33.966673, 30.500000>,
        < -36.666599, 33.966673, 33.500000>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-21.000000, -3.033327, -34.313004>,
        < -26.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -11.832006, -26.803001>,
        <-21.000000, -12.033327, -25.019699>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -11.227297, -28.519203>,
        <-21.000000, -11.832006, -26.803001>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -10.245277, -30.060699>,
        <-21.000000, -11.227297, -28.519203>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -8.945476, -31.334000>,
        <-21.000000, -10.245277, -30.060699>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <-21.000000, -7.414278, -32.270103>,
        <-21.000000, -8.945476, -31.334000>,
        < -21.000000, -3.033327, -34.313004>
      }
      triangle {
        <-40.000000, -12.033327, -5.000000>,
        <-40.000000, -12.033327, 6.000000>,
        < -21.000000, -12.033327, -25.019699>
      }
      triangle {
        <-40.000000, 14.066671, -5.000000>,
        <-40.000000, -12.033327, 6.000000>,
        < -40.000000, -12.033327, -5.000000>
      }
      triangle {
        <-40.000000, 14.066671, -5.000000>,
        <-40.000000, 7.767363, -2.000000>,
        < -40.000000, -12.033327, 6.000000>
      }
      triangle {
        <40.000000, 7.767363, -2.000000>,
        <40.000000, -12.033327, -5.000000>,
        < 40.000000, -12.033327, 6.000000>
      }
      triangle {
        <42.836369, 17.814371, -5.000000>,
        <42.959068, 15.942305, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <41.647572, 31.402456, -5.000000>,
        <42.836369, 17.814371, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <41.398521, 31.380659, -5.000000>,
        <41.647572, 31.402456, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <41.153290, 32.526182, -5.000000>,
        <41.398521, 31.380659, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <40.635159, 33.576841, -5.000000>,
        <41.153290, 32.526182, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <40.000000, 14.066671, -5.000000>,
        <40.635159, 33.576841, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <40.000000, 14.066671, -2.000000>,
        <40.000000, 14.066671, -5.000000>,
        < 40.000000, -12.033327, -5.000000>
      }
      triangle {
        <40.000000, 14.066671, -2.000000>,
        <40.000000, -12.033327, -5.000000>,
        < 40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-40.000000, 14.066671, -5.000000>,
        <-40.000000, 14.066671, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-40.635159, 33.576841, -2.000000>,
        <-40.000000, 7.767363, -2.000000>,
        < -40.000000, 14.066671, -2.000000>
      }
      triangle {
        <-42.836369, 17.814371, -2.000000>,
        <-42.959068, 15.942305, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-41.647572, 31.402456, -2.000000>,
        <-42.836369, 17.814371, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-41.398521, 31.380659, -2.000000>,
        <-41.647572, 31.402456, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-41.153290, 32.526182, -2.000000>,
        <-41.398521, 31.380659, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-40.635159, 33.576841, -2.000000>,
        <-41.153290, 32.526182, -2.000000>,
        < -40.000000, 7.767363, -2.000000>
      }
      triangle {
        <-39.961929, 15.811453, -5.000000>,
        <-40.000000, 14.066671, -2.000000>,
        < -40.000000, 14.066671, -5.000000>
      }
      triangle {
        <-39.961929, 15.811453, -2.000000>,
        <-40.000000, 14.066671, -2.000000>,
        < -39.961929, 15.811453, -5.000000>
      }
      triangle {
        <-40.635159, 33.576841, -2.000000>,
        <-40.000000, 14.066671, -2.000000>,
        < -39.961929, 15.811453, -2.000000>
      }
      triangle {
        <-40.635159, 33.576841, -5.000000>,
        <-39.875648, 34.468741, -5.000000>,
        < -40.000000, 14.066671, -5.000000>
      }
      triangle {
        <-39.961929, 15.811453, -5.000000>,
        <-40.000000, 14.066671, -5.000000>,
        < -39.875648, 34.468741, -5.000000>
      }
      triangle {
        <41.398521, 31.380659, -2.000000>,
        <41.647572, 31.402456, -5.000000>,
        < 41.398521, 31.380659, -5.000000>
      }
      triangle {
        <41.647572, 31.402456, -2.000000>,
        <41.647572, 31.402456, -5.000000>,
        < 41.398521, 31.380659, -2.000000>
      }
      triangle {
        <41.398521, 31.380659, -2.000000>,
        <41.398521, 31.380659, -5.000000>,
        < 41.153290, 32.526182, -5.000000>
      }
      triangle {
        <41.153290, 32.526182, -2.000000>,
        <41.153290, 32.526182, -5.000000>,
        < 40.635159, 33.576841, -5.000000>
      }
      triangle {
        <41.398521, 31.380659, -2.000000>,
        <41.153290, 32.526182, -5.000000>,
        < 41.153290, 32.526182, -2.000000>
      }
      triangle {
        <39.961929, 15.811453, -5.000000>,
        <39.875648, 34.468741, -5.000000>,
        < 40.635159, 33.576841, -5.000000>
      }
      triangle {
        <40.635159, 33.576841, -2.000000>,
        <40.635159, 33.576841, -5.000000>,
        < 39.875648, 34.468741, -5.000000>
      }
      triangle {
        <40.000000, 14.066671, -5.000000>,
        <39.961929, 15.811453, -5.000000>,
        < 40.635159, 33.576841, -5.000000>
      }
      triangle {
        <41.153290, 32.526182, -2.000000>,
        <40.635159, 33.576841, -5.000000>,
        < 40.635159, 33.576841, -2.000000>
      }
      triangle {
        <39.847790, 17.552904, -5.000000>,
        <38.920952, 35.147635, -5.000000>,
        < 39.875648, 34.468741, -5.000000>
      }
      triangle {
        <39.875648, 34.468741, -2.000000>,
        <39.875648, 34.468741, -5.000000>,
        < 38.920952, 35.147635, -5.000000>
      }
      triangle {
        <39.961929, 15.811453, -5.000000>,
        <39.847790, 17.552904, -5.000000>,
        < 39.875648, 34.468741, -5.000000>
      }
      triangle {
        <40.635159, 33.576841, -2.000000>,
        <39.875648, 34.468741, -5.000000>,
        < 39.875648, 34.468741, -2.000000>
      }
      triangle {
        <38.220909, 32.225271, -5.000000>,
        <37.829128, 35.572210, -5.000000>,
        < 38.920952, 35.147635, -5.000000>
      }
      triangle {
        <38.920952, 35.147635, -2.000000>,
        <38.920952, 35.147635, -5.000000>,
        < 37.829128, 35.572210, -5.000000>
      }
      triangle {
        <38.520950, 31.715902, -5.000000>,
        <38.220909, 32.225271, -5.000000>,
        < 38.920952, 35.147635, -5.000000>
      }
      triangle {
        <38.658981, 31.140982, -5.000000>,
        <38.520950, 31.715902, -5.000000>,
        < 38.920952, 35.147635, -5.000000>
      }
      triangle {
        <39.847790, 17.552904, -5.000000>,
        <38.658981, 31.140982, -5.000000>,
        < 38.920952, 35.147635, -5.000000>
      }
      triangle {
        <39.875648, 34.468741, -2.000000>,
        <38.920952, 35.147635, -5.000000>,
        < 38.920952, 35.147635, -2.000000>
      }
      triangle {
        <37.251362, 32.879271, -5.000000>,
        <36.666599, 35.716673, -5.000000>,
        < 37.829128, 35.572210, -5.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <37.829128, 35.572210, -5.000000>,
        < 36.666599, 35.716673, -5.000000>
      }
      triangle {
        <37.784939, 32.624769, -5.000000>,
        <37.251362, 32.879271, -5.000000>,
        < 37.829128, 35.572210, -5.000000>
      }
      triangle {
        <38.220909, 32.225271, -5.000000>,
        <37.784939, 32.624769, -5.000000>,
        < 37.829128, 35.572210, -5.000000>
      }
      triangle {
        <38.920952, 35.147635, -2.000000>,
        <37.829128, 35.572210, -5.000000>,
        < 37.829128, 35.572210, -2.000000>
      }
      triangle {
        <-36.666599, 32.966673, -5.000000>,
        <-36.666599, 35.716673, -5.000000>,
        < 36.666599, 35.716673, -5.000000>
      }
      triangle {
        <36.666599, 35.716673, -2.000000>,
        <36.666599, 35.716673, -5.000000>,
        < -36.666599, 35.716673, -5.000000>
      }
      triangle {
        <36.666599, 32.966673, -5.000000>,
        <-36.666599, 32.966673, -5.000000>,
        < 36.666599, 35.716673, -5.000000>
      }
      triangle {
        <37.251362, 32.879271, -5.000000>,
        <36.666599, 32.966673, -5.000000>,
        < 36.666599, 35.716673, -5.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <36.666599, 35.716673, -5.000000>,
        < 36.666599, 35.716673, -2.000000>
      }
      triangle {
        <-37.784939, 32.624769, -5.000000>,
        <-37.829128, 35.572210, -5.000000>,
        < -36.666599, 35.716673, -5.000000>
      }
      triangle {
        <-36.666599, 35.716673, -2.000000>,
        <-36.666599, 35.716673, -5.000000>,
        < -37.829128, 35.572210, -5.000000>
      }
      triangle {
        <-37.251362, 32.879271, -5.000000>,
        <-37.784939, 32.624769, -5.000000>,
        < -36.666599, 35.716673, -5.000000>
      }
      triangle {
        <-36.666599, 32.966673, -5.000000>,
        <-37.251362, 32.879271, -5.000000>,
        < -36.666599, 35.716673, -5.000000>
      }
      triangle {
        <36.666599, 35.716673, -2.000000>,
        <-36.666599, 35.716673, -5.000000>,
        < -36.666599, 35.716673, -2.000000>
      }
      triangle {
        <-38.658981, 31.140982, -5.000000>,
        <-38.920952, 35.147635, -5.000000>,
        < -37.829128, 35.572210, -5.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-37.829128, 35.572210, -5.000000>,
        < -38.920952, 35.147635, -5.000000>
      }
      triangle {
        <-38.520950, 31.715902, -5.000000>,
        <-38.658981, 31.140982, -5.000000>,
        < -37.829128, 35.572210, -5.000000>
      }
      triangle {
        <-38.220909, 32.225271, -5.000000>,
        <-38.520950, 31.715902, -5.000000>,
        < -37.829128, 35.572210, -5.000000>
      }
      triangle {
        <-37.784939, 32.624769, -5.000000>,
        <-38.220909, 32.225271, -5.000000>,
        < -37.829128, 35.572210, -5.000000>
      }
      triangle {
        <-36.666599, 35.716673, -2.000000>,
        <-37.829128, 35.572210, -5.000000>,
        < -37.829128, 35.572210, -2.000000>
      }
      triangle {
        <-39.847790, 17.552904, -5.000000>,
        <-39.875648, 34.468741, -5.000000>,
        < -38.920952, 35.147635, -5.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-38.920952, 35.147635, -5.000000>,
        < -39.875648, 34.468741, -5.000000>
      }
      triangle {
        <-38.658981, 31.140982, -5.000000>,
        <-39.847790, 17.552904, -5.000000>,
        < -38.920952, 35.147635, -5.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-38.920952, 35.147635, -5.000000>,
        < -38.920952, 35.147635, -2.000000>
      }
      triangle {
        <-39.875648, 34.468741, -2.000000>,
        <-39.875648, 34.468741, -5.000000>,
        < -40.635159, 33.576841, -5.000000>
      }
      triangle {
        <-39.847790, 17.552904, -5.000000>,
        <-39.961929, 15.811453, -5.000000>,
        < -39.875648, 34.468741, -5.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-39.875648, 34.468741, -5.000000>,
        < -39.875648, 34.468741, -2.000000>
      }
      triangle {
        <-40.635159, 33.576841, -2.000000>,
        <-40.635159, 33.576841, -5.000000>,
        < -41.153290, 32.526182, -5.000000>
      }
      triangle {
        <-39.875648, 34.468741, -2.000000>,
        <-40.635159, 33.576841, -5.000000>,
        < -40.635159, 33.576841, -2.000000>
      }
      triangle {
        <-41.153290, 32.526182, -2.000000>,
        <-41.153290, 32.526182, -5.000000>,
        < -41.398521, 31.380659, -5.000000>
      }
      triangle {
        <-40.635159, 33.576841, -2.000000>,
        <-41.153290, 32.526182, -5.000000>,
        < -41.153290, 32.526182, -2.000000>
      }
      triangle {
        <-41.647572, 31.402456, -2.000000>,
        <-41.398521, 31.380659, -5.000000>,
        < -41.647572, 31.402456, -5.000000>
      }
      triangle {
        <-41.398521, 31.380659, -2.000000>,
        <-41.398521, 31.380659, -5.000000>,
        < -41.647572, 31.402456, -2.000000>
      }
      triangle {
        <-41.153290, 32.526182, -2.000000>,
        <-41.398521, 31.380659, -5.000000>,
        < -41.398521, 31.380659, -2.000000>
      }
      triangle {
        <-39.961929, 15.811453, -2.000000>,
        <-39.961929, 15.811453, -5.000000>,
        < -39.847790, 17.552904, -5.000000>
      }
      triangle {
        <-39.847790, 17.552904, -2.000000>,
        <-39.847790, 17.552904, -5.000000>,
        < -38.658981, 31.140982, -5.000000>
      }
      triangle {
        <-39.961929, 15.811453, -2.000000>,
        <-39.847790, 17.552904, -5.000000>,
        < -39.847790, 17.552904, -2.000000>
      }
      triangle {
        <-38.658981, 31.140982, -2.000000>,
        <-38.658981, 31.140982, -5.000000>,
        < -38.520950, 31.715902, -5.000000>
      }
      triangle {
        <-39.847790, 17.552904, -2.000000>,
        <-38.658981, 31.140982, -5.000000>,
        < -38.658981, 31.140982, -2.000000>
      }
      triangle {
        <-38.520950, 31.715902, -2.000000>,
        <-38.520950, 31.715902, -5.000000>,
        < -38.220909, 32.225271, -5.000000>
      }
      triangle {
        <-38.658981, 31.140982, -2.000000>,
        <-38.520950, 31.715902, -5.000000>,
        < -38.520950, 31.715902, -2.000000>
      }
      triangle {
        <-38.220909, 32.225271, -2.000000>,
        <-38.220909, 32.225271, -5.000000>,
        < -37.784939, 32.624769, -5.000000>
      }
      triangle {
        <-38.520950, 31.715902, -2.000000>,
        <-38.220909, 32.225271, -5.000000>,
        < -38.220909, 32.225271, -2.000000>
      }
      triangle {
        <-37.784939, 32.624769, -2.000000>,
        <-37.784939, 32.624769, -5.000000>,
        < -37.251362, 32.879271, -5.000000>
      }
      triangle {
        <-38.220909, 32.225271, -2.000000>,
        <-37.784939, 32.624769, -5.000000>,
        < -37.784939, 32.624769, -2.000000>
      }
      triangle {
        <-37.251362, 32.879271, -2.000000>,
        <-37.251362, 32.879271, -5.000000>,
        < -36.666599, 32.966673, -5.000000>
      }
      triangle {
        <-37.784939, 32.624769, -2.000000>,
        <-37.251362, 32.879271, -5.000000>,
        < -37.251362, 32.879271, -2.000000>
      }
      triangle {
        <-36.666599, 32.966673, -2.000000>,
        <-36.666599, 32.966673, -5.000000>,
        < 36.666599, 32.966673, -5.000000>
      }
      triangle {
        <-37.251362, 32.879271, -2.000000>,
        <-36.666599, 32.966673, -5.000000>,
        < -36.666599, 32.966673, -2.000000>
      }
      triangle {
        <36.666599, 32.966673, -2.000000>,
        <36.666599, 32.966673, -5.000000>,
        < 37.251362, 32.879271, -5.000000>
      }
      triangle {
        <-36.666599, 32.966673, -2.000000>,
        <36.666599, 32.966673, -5.000000>,
        < 36.666599, 32.966673, -2.000000>
      }
      triangle {
        <37.251362, 32.879271, -2.000000>,
        <37.251362, 32.879271, -5.000000>,
        < 37.784939, 32.624769, -5.000000>
      }
      triangle {
        <36.666599, 32.966673, -2.000000>,
        <37.251362, 32.879271, -5.000000>,
        < 37.251362, 32.879271, -2.000000>
      }
      triangle {
        <37.784939, 32.624769, -2.000000>,
        <37.784939, 32.624769, -5.000000>,
        < 38.220909, 32.225271, -5.000000>
      }
      triangle {
        <37.251362, 32.879271, -2.000000>,
        <37.784939, 32.624769, -5.000000>,
        < 37.784939, 32.624769, -2.000000>
      }
      triangle {
        <38.220909, 32.225271, -2.000000>,
        <38.220909, 32.225271, -5.000000>,
        < 38.520950, 31.715902, -5.000000>
      }
      triangle {
        <37.784939, 32.624769, -2.000000>,
        <38.220909, 32.225271, -5.000000>,
        < 38.220909, 32.225271, -2.000000>
      }
      triangle {
        <38.520950, 31.715902, -2.000000>,
        <38.520950, 31.715902, -5.000000>,
        < 38.658981, 31.140982, -5.000000>
      }
      triangle {
        <38.220909, 32.225271, -2.000000>,
        <38.520950, 31.715902, -5.000000>,
        < 38.520950, 31.715902, -2.000000>
      }
      triangle {
        <38.658981, 31.140982, -2.000000>,
        <38.658981, 31.140982, -5.000000>,
        < 39.847790, 17.552904, -5.000000>
      }
      triangle {
        <38.520950, 31.715902, -2.000000>,
        <38.658981, 31.140982, -5.000000>,
        < 38.658981, 31.140982, -2.000000>
      }
      triangle {
        <39.847790, 17.552904, -2.000000>,
        <39.847790, 17.552904, -5.000000>,
        < 39.961929, 15.811453, -5.000000>
      }
      triangle {
        <38.658981, 31.140982, -2.000000>,
        <39.847790, 17.552904, -5.000000>,
        < 39.847790, 17.552904, -2.000000>
      }
      triangle {
        <39.961929, 15.811453, -2.000000>,
        <39.961929, 15.811453, -5.000000>,
        < 40.000000, 14.066671, -5.000000>
      }
      triangle {
        <39.847790, 17.552904, -2.000000>,
        <39.961929, 15.811453, -5.000000>,
        < 39.961929, 15.811453, -2.000000>
      }
      triangle {
        <39.961929, 15.811453, -2.000000>,
        <40.000000, 14.066671, -5.000000>,
        < 40.000000, 14.066671, -2.000000>
      }
      triangle {
        <39.875648, 34.468741, -2.000000>,
        <39.961929, 15.811453, -2.000000>,
        < 40.000000, 14.066671, -2.000000>
      }
      triangle {
        <40.635159, 33.576841, -2.000000>,
        <39.875648, 34.468741, -2.000000>,
        < 40.000000, 14.066671, -2.000000>
      }
      triangle {
        <39.875648, 34.468741, -2.000000>,
        <39.847790, 17.552904, -2.000000>,
        < 39.961929, 15.811453, -2.000000>
      }
      triangle {
        <38.920952, 35.147635, -2.000000>,
        <38.658981, 31.140982, -2.000000>,
        < 39.847790, 17.552904, -2.000000>
      }
      triangle {
        <39.875648, 34.468741, -2.000000>,
        <38.920952, 35.147635, -2.000000>,
        < 39.847790, 17.552904, -2.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <38.520950, 31.715902, -2.000000>,
        < 38.658981, 31.140982, -2.000000>
      }
      triangle {
        <38.920952, 35.147635, -2.000000>,
        <37.829128, 35.572210, -2.000000>,
        < 38.658981, 31.140982, -2.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <38.220909, 32.225271, -2.000000>,
        < 38.520950, 31.715902, -2.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <37.784939, 32.624769, -2.000000>,
        < 38.220909, 32.225271, -2.000000>
      }
      triangle {
        <36.666599, 35.716673, -2.000000>,
        <37.251362, 32.879271, -2.000000>,
        < 37.784939, 32.624769, -2.000000>
      }
      triangle {
        <37.829128, 35.572210, -2.000000>,
        <36.666599, 35.716673, -2.000000>,
        < 37.784939, 32.624769, -2.000000>
      }
      triangle {
        <36.666599, 35.716673, -2.000000>,
        <36.666599, 32.966673, -2.000000>,
        < 37.251362, 32.879271, -2.000000>
      }
      triangle {
        <-36.666599, 35.716673, -2.000000>,
        <-36.666599, 32.966673, -2.000000>,
        < 36.666599, 32.966673, -2.000000>
      }
      triangle {
        <36.666599, 35.716673, -2.000000>,
        <-36.666599, 35.716673, -2.000000>,
        < 36.666599, 32.966673, -2.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-37.251362, 32.879271, -2.000000>,
        < -36.666599, 32.966673, -2.000000>
      }
      triangle {
        <-36.666599, 35.716673, -2.000000>,
        <-37.829128, 35.572210, -2.000000>,
        < -36.666599, 32.966673, -2.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-37.784939, 32.624769, -2.000000>,
        < -37.251362, 32.879271, -2.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-38.220909, 32.225271, -2.000000>,
        < -37.784939, 32.624769, -2.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-38.520950, 31.715902, -2.000000>,
        < -38.220909, 32.225271, -2.000000>
      }
      triangle {
        <-37.829128, 35.572210, -2.000000>,
        <-38.920952, 35.147635, -2.000000>,
        < -38.220909, 32.225271, -2.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-38.658981, 31.140982, -2.000000>,
        < -38.520950, 31.715902, -2.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-39.847790, 17.552904, -2.000000>,
        < -38.658981, 31.140982, -2.000000>
      }
      triangle {
        <-39.875648, 34.468741, -2.000000>,
        <-39.961929, 15.811453, -2.000000>,
        < -39.847790, 17.552904, -2.000000>
      }
      triangle {
        <-38.920952, 35.147635, -2.000000>,
        <-39.875648, 34.468741, -2.000000>,
        < -39.847790, 17.552904, -2.000000>
      }
      triangle {
        <-39.875648, 34.468741, -2.000000>,
        <-40.635159, 33.576841, -2.000000>,
        < -39.961929, 15.811453, -2.000000>
      }
      triangle {
        <-43.000000, 7.466673, -3.125000>,
        <-43.000000, 14.066671, -3.125000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-42.959068, 15.942312, -3.021896>,
        <-43.000000, 14.066671, 2.625000>,
        < -43.000000, 14.066671, -3.125000>
      }
      triangle {
        <-43.000000, -11.533327, -3.125000>,
        <-43.000000, 7.466673, -3.125000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.000000, -12.032938, -2.991249>,
        <-43.000000, -11.533327, -3.125000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.000000, -12.399576, -2.624611>,
        <-43.000000, -12.032938, -2.991249>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.000000, -12.533327, -2.125000>,
        <-43.000000, -12.399576, -2.624611>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.000000, 9.966673, 2.625000>,
        <-43.000000, -12.533327, -2.125000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.250000, 9.966673, 2.625000>,
        <-43.000000, 9.966673, 2.625000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-42.959068, 15.942312, -3.021896>,
        <-42.959068, 15.942305, 2.625000>,
        < -43.000000, 14.066671, 2.625000>
      }
      triangle {
        <-43.250000, 9.966673, 2.625000>,
        <-43.000000, 14.066671, 2.625000>,
        < -42.959068, 15.942305, 2.625000>
      }
      triangle {
        <-43.000000, 9.966673, 26.625000>,
        <-43.000000, -12.533327, 30.625000>,
        < -43.000000, -12.533327, -2.125000>
      }
      triangle {
        <-43.000000, 9.966673, 2.625000>,
        <-43.000000, 9.966673, 26.625000>,
        < -43.000000, -12.533327, -2.125000>
      }
      triangle {
        <-43.000000, 14.066671, 31.625000>,
        <-43.000000, -12.399576, 31.124611>,
        < -43.000000, -12.533327, 30.625000>
      }
      triangle {
        <-43.000000, 9.966673, 26.625000>,
        <-43.000000, 14.066671, 31.625000>,
        < -43.000000, -12.533327, 30.625000>
      }
      triangle {
        <-43.000000, 14.066671, 31.625000>,
        <-43.000000, -12.032938, 31.491249>,
        < -43.000000, -12.399576, 31.124611>
      }
      triangle {
        <-43.000000, 14.066671, 31.625000>,
        <-43.000000, -11.533327, 31.625000>,
        < -43.000000, -12.032938, 31.491249>
      }
      triangle {
        <-43.000000, 9.966673, 26.625000>,
        <-43.000000, 14.066671, 26.625000>,
        < -43.000000, 14.066671, 31.625000>
      }
      triangle {
        <-42.959068, 15.942305, 26.625000>,
        <-43.000000, 14.066671, 31.625000>,
        < -43.000000, 14.066671, 26.625000>
      }
      triangle {
        <-42.959068, 15.942305, 26.625000>,
        <-42.959068, 15.942312, 31.521900>,
        < -43.000000, 14.066671, 31.625000>
      }
      triangle {
        <-43.250000, 27.966673, 26.625000>,
        <-43.000000, 14.066671, 26.625000>,
        < -43.000000, 9.966673, 26.625000>
      }
      triangle {
        <-43.250000, 27.966673, 26.625000>,
        <-42.959068, 15.942305, 26.625000>,
        < -43.000000, 14.066671, 26.625000>
      }
      triangle {
        <-43.250000, 9.966673, 26.625000>,
        <-43.000000, 9.966673, 26.625000>,
        < -43.000000, 9.966673, 2.625000>
      }
      triangle {
        <-43.250000, 9.966673, 26.625000>,
        <-43.250000, 27.966673, 26.625000>,
        < -43.000000, 9.966673, 26.625000>
      }
      triangle {
        <-43.250000, 9.966673, 26.625000>,
        <-43.000000, 9.966673, 2.625000>,
        < -43.250000, 9.966673, 2.625000>
      }
      triangle {
        <-42.836369, 17.814371, -2.918999>,
        <-42.836369, 17.814371, 2.625000>,
        < -42.959068, 15.942305, 2.625000>
      }
      triangle {
        <-43.250000, 27.966673, 2.625000>,
        <-42.959068, 15.942305, 2.625000>,
        < -42.836369, 17.814371, 2.625000>
      }
      triangle {
        <-42.959068, 15.942312, -3.021896>,
        <-42.836369, 17.814371, -2.918999>,
        < -42.959068, 15.942305, 2.625000>
      }
      triangle {
        <-43.250000, 27.966673, 2.625000>,
        <-43.250000, 9.966673, 2.625000>,
        < -42.959068, 15.942305, 2.625000>
      }
      triangle {
        <-41.948158, 27.966673, 2.625000>,
        <-42.836369, 17.814371, 2.625000>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-43.250000, 27.966673, 2.625000>,
        <-42.836369, 17.814371, 2.625000>,
        < -41.948158, 27.966673, 2.625000>
      }
      triangle {
        <-41.572609, 32.259192, -1.178261>,
        <-41.948158, 27.966673, 2.625000>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-41.583488, 32.134855, -1.662041>,
        <-41.572609, 32.259192, -1.178261>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-41.613499, 31.791884, -2.025688>,
        <-41.583488, 32.134855, -1.662041>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-41.654999, 31.317465, -2.176758>,
        <-41.613499, 31.791884, -2.025688>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-42.836369, 17.814371, 26.625000>,
        <-42.836369, 17.814371, 31.418999>,
        < -42.959068, 15.942312, 31.521900>
      }
      triangle {
        <-42.959068, 15.942305, 26.625000>,
        <-42.836369, 17.814371, 26.625000>,
        < -42.959068, 15.942312, 31.521900>
      }
      triangle {
        <-41.654999, 31.317465, 30.676762>,
        <-42.836369, 17.814371, 31.418999>,
        < -42.836369, 17.814371, 26.625000>
      }
      triangle {
        <-43.250000, 27.966673, 26.625000>,
        <-42.836369, 17.814371, 26.625000>,
        < -42.959068, 15.942305, 26.625000>
      }
      triangle {
        <-41.572609, 32.259192, 29.678261>,
        <-42.836369, 17.814371, 26.625000>,
        < -41.948158, 27.966673, 26.625000>
      }
      triangle {
        <-43.250000, 27.966673, 26.625000>,
        <-41.948158, 27.966673, 26.625000>,
        < -42.836369, 17.814371, 26.625000>
      }
      triangle {
        <-41.613499, 31.791884, 30.525688>,
        <-41.654999, 31.317465, 30.676762>,
        < -42.836369, 17.814371, 26.625000>
      }
      triangle {
        <-41.583488, 32.134855, 30.162041>,
        <-41.613499, 31.791884, 30.525688>,
        < -42.836369, 17.814371, 26.625000>
      }
      triangle {
        <-41.572609, 32.259192, 29.678261>,
        <-41.583488, 32.134855, 30.162041>,
        < -42.836369, 17.814371, 26.625000>
      }
      triangle {
        <-41.572609, 32.259192, 29.678261>,
        <-41.948158, 27.966673, 26.625000>,
        < -41.948158, 27.966673, 2.625000>
      }
      triangle {
        <-43.250000, 27.966673, 2.625000>,
        <-41.948158, 27.966673, 2.625000>,
        < -41.948158, 27.966673, 26.625000>
      }
      triangle {
        <-41.572609, 32.259192, -1.178261>,
        <-41.572609, 32.259192, 29.678261>,
        < -41.948158, 27.966673, 2.625000>
      }
      triangle {
        <-43.250000, 27.966673, 26.625000>,
        <-43.250000, 27.966673, 2.625000>,
        < -41.948158, 27.966673, 26.625000>
      }
      triangle {
        <-43.250000, 25.966673, 4.625000>,
        <-43.250000, 9.966673, 2.625000>,
        < -43.250000, 27.966673, 2.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.250000, 9.966673, 26.625000>,
        < -43.250000, 9.966673, 2.625000>
      }
      triangle {
        <-43.250000, 11.966673, 4.625000>,
        <-43.250000, 9.966673, 2.625000>,
        < -43.250000, 25.966673, 4.625000>
      }
      triangle {
        <-43.250000, 11.966673, 4.625000>,
        <-43.250000, 11.966673, 24.625000>,
        < -43.250000, 9.966673, 2.625000>
      }
      triangle {
        <-43.250000, 25.966673, 4.625000>,
        <-43.250000, 27.966673, 2.625000>,
        < -43.250000, 27.966673, 26.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.250000, 27.966673, 26.625000>,
        < -43.250000, 9.966673, 26.625000>
      }
      triangle {
        <-43.250000, 25.966673, 24.625000>,
        <-43.250000, 25.966673, 4.625000>,
        < -43.250000, 27.966673, 26.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.250000, 25.966673, 24.625000>,
        < -43.250000, 27.966673, 26.625000>
      }
      triangle {
        <-43.000000, -10.827698, -31.690697>,
        <-43.000000, 14.066671, -39.727493>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-42.959061, 15.942541, -38.608505>,
        <-43.000000, 14.066671, -27.875000>,
        < -43.000000, 14.066671, -39.727493>
      }
      triangle {
        <-43.000000, -11.729677, -31.027901>,
        <-43.000000, -10.827698, -31.690697>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-43.000000, -12.324497, -30.084000>,
        <-43.000000, -11.729677, -31.027901>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-43.000000, -12.533327, -28.984299>,
        <-43.000000, -12.324497, -30.084000>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-43.000000, 9.966673, -27.875000>,
        <-43.000000, -12.533327, -28.984299>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-43.250000, 9.966673, -27.875000>,
        <-43.000000, 9.966673, -27.875000>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-42.959061, 15.942541, -38.608505>,
        <-42.959068, 15.942305, -27.875000>,
        < -43.000000, 14.066671, -27.875000>
      }
      triangle {
        <-43.250000, 9.966673, -27.875000>,
        <-43.000000, 14.066671, -27.875000>,
        < -42.959068, 15.942305, -27.875000>
      }
      triangle {
        <-43.000000, -10.827698, -31.690697>,
        <-43.000000, 10.466673, -41.875000>,
        < -43.000000, 14.066671, -39.727493>
      }
      triangle {
        <-43.000000, 9.966673, -7.875000>,
        <-43.000000, -12.533327, -4.875000>,
        < -43.000000, -12.533327, -28.984299>
      }
      triangle {
        <-43.000000, 9.966673, -27.875000>,
        <-43.000000, 9.966673, -7.875000>,
        < -43.000000, -12.533327, -28.984299>
      }
      triangle {
        <-43.000000, 14.066671, -3.875000>,
        <-43.000000, -12.399567, -4.375381>,
        < -43.000000, -12.533327, -4.875000>
      }
      triangle {
        <-43.000000, 9.966673, -7.875000>,
        <-43.000000, 14.066671, -3.875000>,
        < -43.000000, -12.533327, -4.875000>
      }
      triangle {
        <-43.000000, 14.066671, -3.875000>,
        <-43.000000, -12.032947, -4.008759>,
        < -43.000000, -12.399567, -4.375381>
      }
      triangle {
        <-43.000000, 14.066671, -3.875000>,
        <-43.000000, -11.533327, -3.875000>,
        < -43.000000, -12.032947, -4.008759>
      }
      triangle {
        <-43.000000, 9.966673, -7.875000>,
        <-43.000000, 14.066671, -7.875000>,
        < -43.000000, 14.066671, -3.875000>
      }
      triangle {
        <-42.959068, 15.942305, -7.875000>,
        <-43.000000, 14.066671, -3.875000>,
        < -43.000000, 14.066671, -7.875000>
      }
      triangle {
        <-42.959068, 15.942305, -7.875000>,
        <-42.959068, 15.942312, -3.978104>,
        < -43.000000, 14.066671, -3.875000>
      }
      triangle {
        <-43.250000, 27.966673, -7.875000>,
        <-43.000000, 14.066671, -7.875000>,
        < -43.000000, 9.966673, -7.875000>
      }
      triangle {
        <-43.250000, 27.966673, -7.875000>,
        <-42.959068, 15.942305, -7.875000>,
        < -43.000000, 14.066671, -7.875000>
      }
      triangle {
        <-43.250000, 9.966673, -7.875000>,
        <-43.000000, 9.966673, -7.875000>,
        < -43.000000, 9.966673, -27.875000>
      }
      triangle {
        <-43.250000, 9.966673, -7.875000>,
        <-43.250000, 27.966673, -7.875000>,
        < -43.000000, 9.966673, -7.875000>
      }
      triangle {
        <-43.250000, 9.966673, -7.875000>,
        <-43.000000, 9.966673, -27.875000>,
        < -43.250000, 9.966673, -27.875000>
      }
      triangle {
        <-42.836369, 17.814371, -37.491798>,
        <-42.836369, 17.814371, -27.875000>,
        < -42.959068, 15.942305, -27.875000>
      }
      triangle {
        <-43.250000, 27.966673, -27.875000>,
        <-42.959068, 15.942305, -27.875000>,
        < -42.836369, 17.814371, -27.875000>
      }
      triangle {
        <-42.959061, 15.942541, -38.608505>,
        <-42.836369, 17.814371, -37.491798>,
        < -42.959068, 15.942305, -27.875000>
      }
      triangle {
        <-43.250000, 27.966673, -27.875000>,
        <-43.250000, 9.966673, -27.875000>,
        < -42.959068, 15.942305, -27.875000>
      }
      triangle {
        <-41.948158, 27.966673, -27.875000>,
        <-42.836369, 17.814371, -27.875000>,
        < -42.836369, 17.814371, -37.491798>
      }
      triangle {
        <-43.250000, 27.966673, -27.875000>,
        <-42.836369, 17.814371, -27.875000>,
        < -41.948158, 27.966673, -27.875000>
      }
      triangle {
        <-41.587898, 32.084463, -28.178802>,
        <-41.948158, 27.966673, -27.875000>,
        < -42.836369, 17.814371, -37.491798>
      }
      triangle {
        <-41.632591, 31.573713, -29.079903>,
        <-41.587898, 32.084463, -28.178802>,
        < -42.836369, 17.814371, -37.491798>
      }
      triangle {
        <-41.700508, 30.797377, -29.747002>,
        <-41.632591, 31.573713, -29.079903>,
        < -42.836369, 17.814371, -37.491798>
      }
      triangle {
        <-42.836369, 17.814371, -7.875000>,
        <-42.836369, 17.814371, -4.081001>,
        < -42.959068, 15.942312, -3.978104>
      }
      triangle {
        <-42.959068, 15.942305, -7.875000>,
        <-42.836369, 17.814371, -7.875000>,
        < -42.959068, 15.942312, -3.978104>
      }
      triangle {
        <-41.654999, 31.317465, -4.823242>,
        <-42.836369, 17.814371, -4.081001>,
        < -42.836369, 17.814371, -7.875000>
      }
      triangle {
        <-43.250000, 27.966673, -7.875000>,
        <-42.836369, 17.814371, -7.875000>,
        < -42.959068, 15.942305, -7.875000>
      }
      triangle {
        <-41.572609, 32.259192, -5.821739>,
        <-42.836369, 17.814371, -7.875000>,
        < -41.948158, 27.966673, -7.875000>
      }
      triangle {
        <-43.250000, 27.966673, -7.875000>,
        <-41.948158, 27.966673, -7.875000>,
        < -42.836369, 17.814371, -7.875000>
      }
      triangle {
        <-41.613499, 31.791884, -4.974312>,
        <-41.654999, 31.317465, -4.823242>,
        < -42.836369, 17.814371, -7.875000>
      }
      triangle {
        <-41.583488, 32.134855, -5.337959>,
        <-41.613499, 31.791884, -4.974312>,
        < -42.836369, 17.814371, -7.875000>
      }
      triangle {
        <-41.572609, 32.259192, -5.821739>,
        <-41.583488, 32.134855, -5.337959>,
        < -42.836369, 17.814371, -7.875000>
      }
      triangle {
        <-41.572609, 32.259192, -27.167999>,
        <-41.948158, 27.966673, -7.875000>,
        < -41.948158, 27.966673, -27.875000>
      }
      triangle {
        <-43.250000, 27.966673, -27.875000>,
        <-41.948158, 27.966673, -27.875000>,
        < -41.948158, 27.966673, -7.875000>
      }
      triangle {
        <-41.587898, 32.084463, -28.178802>,
        <-41.572609, 32.259192, -27.167999>,
        < -41.948158, 27.966673, -27.875000>
      }
      triangle {
        <-41.572609, 32.259192, -27.167999>,
        <-41.572609, 32.259192, -5.821739>,
        < -41.948158, 27.966673, -7.875000>
      }
      triangle {
        <-43.250000, 27.966673, -7.875000>,
        <-43.250000, 27.966673, -27.875000>,
        < -41.948158, 27.966673, -7.875000>
      }
      triangle {
        <-43.250000, 25.966673, -25.875000>,
        <-43.250000, 9.966673, -27.875000>,
        < -43.250000, 27.966673, -27.875000>
      }
      triangle {
        <-43.250000, 11.966673, -9.875000>,
        <-43.250000, 9.966673, -7.875000>,
        < -43.250000, 9.966673, -27.875000>
      }
      triangle {
        <-43.250000, 11.966673, -25.875000>,
        <-43.250000, 9.966673, -27.875000>,
        < -43.250000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 11.966673, -25.875000>,
        <-43.250000, 11.966673, -9.875000>,
        < -43.250000, 9.966673, -27.875000>
      }
      triangle {
        <-43.250000, 25.966673, -25.875000>,
        <-43.250000, 27.966673, -27.875000>,
        < -43.250000, 27.966673, -7.875000>
      }
      triangle {
        <-43.250000, 11.966673, -9.875000>,
        <-43.250000, 27.966673, -7.875000>,
        < -43.250000, 9.966673, -7.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.250000, 25.966673, -25.875000>,
        < -43.250000, 27.966673, -7.875000>
      }
      triangle {
        <-43.250000, 11.966673, -9.875000>,
        <-43.250000, 25.966673, -9.875000>,
        < -43.250000, 27.966673, -7.875000>
      }
      triangle {
        <43.000000, 14.066671, -3.125000>,
        <43.000000, 9.966673, 2.625000>,
        < 43.000000, 14.066671, 2.625000>
      }
      triangle {
        <43.250000, 27.966673, 2.625000>,
        <43.000000, 14.066671, 2.625000>,
        < 43.000000, 9.966673, 2.625000>
      }
      triangle {
        <42.959068, 15.942305, 2.625000>,
        <43.000000, 14.066671, -3.125000>,
        < 43.000000, 14.066671, 2.625000>
      }
      triangle {
        <43.250000, 27.966673, 2.625000>,
        <42.959068, 15.942305, 2.625000>,
        < 43.000000, 14.066671, 2.625000>
      }
      triangle {
        <43.000000, -12.533327, 30.625000>,
        <43.000000, 9.966673, 26.625000>,
        < 43.000000, 9.966673, 2.625000>
      }
      triangle {
        <43.250000, 9.966673, 2.625000>,
        <43.000000, 9.966673, 2.625000>,
        < 43.000000, 9.966673, 26.625000>
      }
      triangle {
        <43.000000, -12.533327, -2.125000>,
        <43.000000, -12.533327, 30.625000>,
        < 43.000000, 9.966673, 2.625000>
      }
      triangle {
        <43.000000, 14.066671, -3.125000>,
        <43.000000, -12.533327, -2.125000>,
        < 43.000000, 9.966673, 2.625000>
      }
      triangle {
        <43.250000, 9.966673, 2.625000>,
        <43.250000, 27.966673, 2.625000>,
        < 43.000000, 9.966673, 2.625000>
      }
      triangle {
        <43.000000, -12.533327, 30.625000>,
        <43.000000, 14.066671, 26.625000>,
        < 43.000000, 9.966673, 26.625000>
      }
      triangle {
        <43.250000, 9.966673, 26.625000>,
        <43.000000, 9.966673, 26.625000>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <43.250000, 9.966673, 26.625000>,
        <43.250000, 9.966673, 2.625000>,
        < 43.000000, 9.966673, 26.625000>
      }
      triangle {
        <43.000000, -11.533327, 31.625000>,
        <43.000000, 14.066671, 31.625000>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <42.959068, 15.942312, 31.521900>,
        <43.000000, 14.066671, 26.625000>,
        < 43.000000, 14.066671, 31.625000>
      }
      triangle {
        <43.000000, -12.032938, 31.491249>,
        <43.000000, -11.533327, 31.625000>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <43.000000, -12.399576, 31.124611>,
        <43.000000, -12.032938, 31.491249>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <43.000000, -12.533327, 30.625000>,
        <43.000000, -12.399576, 31.124611>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <42.959068, 15.942312, 31.521900>,
        <42.959068, 15.942305, 26.625000>,
        < 43.000000, 14.066671, 26.625000>
      }
      triangle {
        <43.250000, 9.966673, 26.625000>,
        <43.000000, 14.066671, 26.625000>,
        < 42.959068, 15.942305, 26.625000>
      }
      triangle {
        <43.000000, 14.066671, -3.125000>,
        <43.000000, -12.399576, -2.624611>,
        < 43.000000, -12.533327, -2.125000>
      }
      triangle {
        <43.000000, 14.066671, -3.125000>,
        <43.000000, -12.032938, -2.991249>,
        < 43.000000, -12.399576, -2.624611>
      }
      triangle {
        <43.000000, 7.466673, -3.125000>,
        <43.000000, -11.533327, -3.125000>,
        < 43.000000, -12.032938, -2.991249>
      }
      triangle {
        <43.000000, 14.066671, -3.125000>,
        <43.000000, 7.466673, -3.125000>,
        < 43.000000, -12.032938, -2.991249>
      }
      triangle {
        <42.959068, 15.942305, 2.625000>,
        <42.959068, 15.942312, -3.021896>,
        < 43.000000, 14.066671, -3.125000>
      }
      triangle {
        <42.836369, 17.814371, 31.418999>,
        <42.836369, 17.814371, 26.625000>,
        < 42.959068, 15.942305, 26.625000>
      }
      triangle {
        <43.250000, 27.966673, 26.625000>,
        <42.959068, 15.942305, 26.625000>,
        < 42.836369, 17.814371, 26.625000>
      }
      triangle {
        <42.959068, 15.942312, 31.521900>,
        <42.836369, 17.814371, 31.418999>,
        < 42.959068, 15.942305, 26.625000>
      }
      triangle {
        <43.250000, 9.966673, 26.625000>,
        <42.959068, 15.942305, 26.625000>,
        < 43.250000, 27.966673, 26.625000>
      }
      triangle {
        <41.948158, 27.966673, 26.625000>,
        <42.836369, 17.814371, 26.625000>,
        < 42.836369, 17.814371, 31.418999>
      }
      triangle {
        <43.250000, 27.966673, 26.625000>,
        <42.836369, 17.814371, 26.625000>,
        < 41.948158, 27.966673, 26.625000>
      }
      triangle {
        <41.583488, 32.134855, 30.162041>,
        <41.572609, 32.259192, 29.678261>,
        < 42.836369, 17.814371, 31.418999>
      }
      triangle {
        <41.948158, 27.966673, 26.625000>,
        <42.836369, 17.814371, 31.418999>,
        < 41.572609, 32.259192, 29.678261>
      }
      triangle {
        <41.613499, 31.791884, 30.525688>,
        <41.583488, 32.134855, 30.162041>,
        < 42.836369, 17.814371, 31.418999>
      }
      triangle {
        <41.654999, 31.317465, 30.676762>,
        <41.613499, 31.791884, 30.525688>,
        < 42.836369, 17.814371, 31.418999>
      }
      triangle {
        <42.836369, 17.814371, 2.625000>,
        <42.836369, 17.814371, -2.918999>,
        < 42.959068, 15.942312, -3.021896>
      }
      triangle {
        <42.959068, 15.942305, 2.625000>,
        <42.836369, 17.814371, 2.625000>,
        < 42.959068, 15.942312, -3.021896>
      }
      triangle {
        <41.654999, 31.317465, -2.176758>,
        <42.836369, 17.814371, -2.918999>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <43.250000, 27.966673, 2.625000>,
        <42.836369, 17.814371, 2.625000>,
        < 42.959068, 15.942305, 2.625000>
      }
      triangle {
        <41.613499, 31.791884, -2.025688>,
        <41.654999, 31.317465, -2.176758>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <41.583488, 32.134855, -1.662041>,
        <41.613499, 31.791884, -2.025688>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <41.572609, 32.259192, -1.178261>,
        <41.583488, 32.134855, -1.662041>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <41.948158, 27.966673, 2.625000>,
        <41.572609, 32.259192, -1.178261>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <43.250000, 27.966673, 2.625000>,
        <41.948158, 27.966673, 2.625000>,
        < 42.836369, 17.814371, 2.625000>
      }
      triangle {
        <41.948158, 27.966673, 26.625000>,
        <41.572609, 32.259192, 29.678261>,
        < 41.572609, 32.259192, -1.178261>
      }
      triangle {
        <41.948158, 27.966673, 2.625000>,
        <41.948158, 27.966673, 26.625000>,
        < 41.572609, 32.259192, -1.178261>
      }
      triangle {
        <43.250000, 27.966673, 26.625000>,
        <41.948158, 27.966673, 26.625000>,
        < 41.948158, 27.966673, 2.625000>
      }
      triangle {
        <43.250000, 27.966673, 26.625000>,
        <41.948158, 27.966673, 2.625000>,
        < 43.250000, 27.966673, 2.625000>
      }
      triangle {
        <43.250000, 11.966673, 4.625000>,
        <43.250000, 27.966673, 2.625000>,
        < 43.250000, 9.966673, 2.625000>
      }
      triangle {
        <43.250000, 25.966673, 24.625000>,
        <43.250000, 27.966673, 26.625000>,
        < 43.250000, 27.966673, 2.625000>
      }
      triangle {
        <43.250000, 11.966673, 4.625000>,
        <43.250000, 25.966673, 4.625000>,
        < 43.250000, 27.966673, 2.625000>
      }
      triangle {
        <43.250000, 25.966673, 24.625000>,
        <43.250000, 27.966673, 2.625000>,
        < 43.250000, 25.966673, 4.625000>
      }
      triangle {
        <43.250000, 11.966673, 4.625000>,
        <43.250000, 9.966673, 2.625000>,
        < 43.250000, 9.966673, 26.625000>
      }
      triangle {
        <43.250000, 25.966673, 24.625000>,
        <43.250000, 9.966673, 26.625000>,
        < 43.250000, 27.966673, 26.625000>
      }
      triangle {
        <43.250000, 11.966673, 24.625000>,
        <43.250000, 11.966673, 4.625000>,
        < 43.250000, 9.966673, 26.625000>
      }
      triangle {
        <43.250000, 25.966673, 24.625000>,
        <43.250000, 11.966673, 24.625000>,
        < 43.250000, 9.966673, 26.625000>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, 9.966673, -27.875000>,
        < 43.000000, 14.066671, -27.875000>
      }
      triangle {
        <43.250000, 27.966673, -27.875000>,
        <43.000000, 14.066671, -27.875000>,
        < 43.000000, 9.966673, -27.875000>
      }
      triangle {
        <42.959068, 15.942305, -27.875000>,
        <43.000000, 14.066671, -39.727493>,
        < 43.000000, 14.066671, -27.875000>
      }
      triangle {
        <43.250000, 27.966673, -27.875000>,
        <42.959068, 15.942305, -27.875000>,
        < 43.000000, 14.066671, -27.875000>
      }
      triangle {
        <43.000000, -12.533327, -4.875000>,
        <43.000000, 9.966673, -7.875000>,
        < 43.000000, 9.966673, -27.875000>
      }
      triangle {
        <43.250000, 9.966673, -27.875000>,
        <43.000000, 9.966673, -27.875000>,
        < 43.000000, 9.966673, -7.875000>
      }
      triangle {
        <43.000000, -12.533327, -28.984299>,
        <43.000000, -12.533327, -4.875000>,
        < 43.000000, 9.966673, -27.875000>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, -12.533327, -28.984299>,
        < 43.000000, 9.966673, -27.875000>
      }
      triangle {
        <43.250000, 9.966673, -27.875000>,
        <43.250000, 27.966673, -27.875000>,
        < 43.000000, 9.966673, -27.875000>
      }
      triangle {
        <43.000000, -12.533327, -4.875000>,
        <43.000000, 14.066671, -7.875000>,
        < 43.000000, 9.966673, -7.875000>
      }
      triangle {
        <43.250000, 9.966673, -7.875000>,
        <43.000000, 9.966673, -7.875000>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <43.250000, 9.966673, -7.875000>,
        <43.250000, 9.966673, -27.875000>,
        < 43.000000, 9.966673, -7.875000>
      }
      triangle {
        <43.000000, -11.533327, -3.875000>,
        <43.000000, 14.066671, -3.875000>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <42.959068, 15.942312, -3.978104>,
        <43.000000, 14.066671, -7.875000>,
        < 43.000000, 14.066671, -3.875000>
      }
      triangle {
        <43.000000, -12.032947, -4.008759>,
        <43.000000, -11.533327, -3.875000>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <43.000000, -12.399567, -4.375381>,
        <43.000000, -12.032947, -4.008759>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <43.000000, -12.533327, -4.875000>,
        <43.000000, -12.399567, -4.375381>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <42.959068, 15.942312, -3.978104>,
        <42.959068, 15.942305, -7.875000>,
        < 43.000000, 14.066671, -7.875000>
      }
      triangle {
        <43.250000, 9.966673, -7.875000>,
        <43.000000, 14.066671, -7.875000>,
        < 42.959068, 15.942305, -7.875000>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, -12.324497, -30.084000>,
        < 43.000000, -12.533327, -28.984299>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, -11.729677, -31.027901>,
        < 43.000000, -12.324497, -30.084000>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, -10.827698, -31.690697>,
        < 43.000000, -11.729677, -31.027901>
      }
      triangle {
        <43.000000, 14.066671, -39.727493>,
        <43.000000, 10.466673, -41.875000>,
        < 43.000000, -10.827698, -31.690697>
      }
      triangle {
        <42.959068, 15.942305, -27.875000>,
        <42.959061, 15.942541, -38.608505>,
        < 43.000000, 14.066671, -39.727493>
      }
      triangle {
        <42.836369, 17.814371, -4.081001>,
        <42.836369, 17.814371, -7.875000>,
        < 42.959068, 15.942305, -7.875000>
      }
      triangle {
        <43.250000, 27.966673, -7.875000>,
        <42.959068, 15.942305, -7.875000>,
        < 42.836369, 17.814371, -7.875000>
      }
      triangle {
        <42.959068, 15.942312, -3.978104>,
        <42.836369, 17.814371, -4.081001>,
        < 42.959068, 15.942305, -7.875000>
      }
      triangle {
        <43.250000, 9.966673, -7.875000>,
        <42.959068, 15.942305, -7.875000>,
        < 43.250000, 27.966673, -7.875000>
      }
      triangle {
        <41.948158, 27.966673, -7.875000>,
        <42.836369, 17.814371, -7.875000>,
        < 42.836369, 17.814371, -4.081001>
      }
      triangle {
        <43.250000, 27.966673, -7.875000>,
        <42.836369, 17.814371, -7.875000>,
        < 41.948158, 27.966673, -7.875000>
      }
      triangle {
        <41.583488, 32.134855, -5.337959>,
        <41.572609, 32.259192, -5.821739>,
        < 42.836369, 17.814371, -4.081001>
      }
      triangle {
        <41.948158, 27.966673, -7.875000>,
        <42.836369, 17.814371, -4.081001>,
        < 41.572609, 32.259192, -5.821739>
      }
      triangle {
        <41.613499, 31.791884, -4.974312>,
        <41.583488, 32.134855, -5.337959>,
        < 42.836369, 17.814371, -4.081001>
      }
      triangle {
        <41.654999, 31.317465, -4.823242>,
        <41.613499, 31.791884, -4.974312>,
        < 42.836369, 17.814371, -4.081001>
      }
      triangle {
        <42.836369, 17.814371, -27.875000>,
        <42.836369, 17.814371, -37.491798>,
        < 42.959061, 15.942541, -38.608505>
      }
      triangle {
        <42.959068, 15.942305, -27.875000>,
        <42.836369, 17.814371, -27.875000>,
        < 42.959061, 15.942541, -38.608505>
      }
      triangle {
        <41.700508, 30.797377, -29.747002>,
        <42.836369, 17.814371, -37.491798>,
        < 42.836369, 17.814371, -27.875000>
      }
      triangle {
        <43.250000, 27.966673, -27.875000>,
        <42.836369, 17.814371, -27.875000>,
        < 42.959068, 15.942305, -27.875000>
      }
      triangle {
        <41.632591, 31.573713, -29.079903>,
        <41.700508, 30.797377, -29.747002>,
        < 42.836369, 17.814371, -27.875000>
      }
      triangle {
        <41.587898, 32.084463, -28.178802>,
        <41.632591, 31.573713, -29.079903>,
        < 42.836369, 17.814371, -27.875000>
      }
      triangle {
        <41.948158, 27.966673, -27.875000>,
        <41.587898, 32.084463, -28.178802>,
        < 42.836369, 17.814371, -27.875000>
      }
      triangle {
        <43.250000, 27.966673, -27.875000>,
        <41.948158, 27.966673, -27.875000>,
        < 42.836369, 17.814371, -27.875000>
      }
      triangle {
        <41.948158, 27.966673, -27.875000>,
        <41.572609, 32.259192, -27.167999>,
        < 41.587898, 32.084463, -28.178802>
      }
      triangle {
        <41.948158, 27.966673, -7.875000>,
        <41.572609, 32.259192, -5.821739>,
        < 41.572609, 32.259192, -27.167999>
      }
      triangle {
        <41.948158, 27.966673, -27.875000>,
        <41.948158, 27.966673, -7.875000>,
        < 41.572609, 32.259192, -27.167999>
      }
      triangle {
        <43.250000, 27.966673, -7.875000>,
        <41.948158, 27.966673, -7.875000>,
        < 41.948158, 27.966673, -27.875000>
      }
      triangle {
        <43.250000, 27.966673, -7.875000>,
        <41.948158, 27.966673, -27.875000>,
        < 43.250000, 27.966673, -27.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.250000, 27.966673, -27.875000>,
        < 43.250000, 9.966673, -27.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.250000, 27.966673, -7.875000>,
        < 43.250000, 27.966673, -27.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.250000, 25.966673, -25.875000>,
        < 43.250000, 27.966673, -27.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.250000, 27.966673, -27.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.250000, 9.966673, -27.875000>,
        < 43.250000, 9.966673, -7.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.250000, 9.966673, -7.875000>,
        < 43.250000, 27.966673, -7.875000>
      }
      triangle {
        <43.250000, 11.966673, -9.875000>,
        <43.250000, 11.966673, -25.875000>,
        < 43.250000, 9.966673, -7.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.250000, 11.966673, -9.875000>,
        < 43.250000, 9.966673, -7.875000>
      }
      triangle {
        <-42.587318, 17.792582, -36.482903>,
        <-41.866291, 28.902456, -30.068604>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-42.750000, 10.566671, -40.654800>,
        <-42.836369, 17.814371, -36.470299>,
        < -42.959049, 15.942862, -37.550903>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.587318, 17.792582, -36.482903>,
        < -42.836369, 17.814371, -36.470299>
      }
      triangle {
        <-42.750000, 14.066671, -38.634094>,
        <-42.836369, 17.814371, -36.470299>,
        < -42.750000, 10.566671, -40.654800>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.836369, 17.814371, -36.470299>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-41.396561, 31.402456, -25.738503>,
        <-41.647572, 31.402456, -25.738503>,
        < -41.662430, 31.232596, -27.030701>
      }
      triangle {
        <-41.396561, 31.402456, -25.738503>,
        <-41.647572, 31.402456, 30.500000>,
        < -41.647572, 31.402456, -25.738503>
      }
      triangle {
        <-41.420380, 31.130812, -27.364098>,
        <-41.662430, 31.232596, -27.030701>,
        < -41.706059, 30.733870, -28.236298>
      }
      triangle {
        <-41.398521, 31.380659, -26.204803>,
        <-41.662430, 31.232596, -27.030701>,
        < -41.420380, 31.130812, -27.364098>
      }
      triangle {
        <-41.397060, 31.397001, -25.971802>,
        <-41.662430, 31.232596, -27.030701>,
        < -41.398521, 31.380659, -26.204803>
      }
      triangle {
        <-41.396561, 31.402456, -25.738503>,
        <-41.662430, 31.232596, -27.030701>,
        < -41.397060, 31.397001, -25.971802>
      }
      triangle {
        <-41.465740, 30.612333, -28.436096>,
        <-41.706059, 30.733870, -28.236298>,
        < -41.775581, 29.939253, -29.272797>
      }
      triangle {
        <-41.420380, 31.130812, -27.364098>,
        <-41.706059, 30.733870, -28.236298>,
        < -41.465740, 30.612333, -28.436096>
      }
      triangle {
        <-41.532070, 29.854170, -29.355904>,
        <-41.775581, 29.939253, -29.272797>,
        < -41.866291, 28.902456, -30.068604>
      }
      triangle {
        <-41.465740, 30.612333, -28.436096>,
        <-41.775581, 29.939253, -29.272797>,
        < -41.532070, 29.854170, -29.355904>
      }
      triangle {
        <-41.615341, 28.902456, -30.068604>,
        <-41.866291, 28.902456, -30.068604>,
        < -42.587318, 17.792582, -36.482903>
      }
      triangle {
        <-41.532070, 29.854170, -29.355904>,
        <-41.866291, 28.902456, -30.068604>,
        < -41.615341, 28.902456, -30.068604>
      }
      triangle {
        <-36.666599, 35.716673, 30.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < -38.128471, 35.748182, 30.500000>
      }
      triangle {
        <36.666599, 35.716673, 30.500000>,
        <36.666599, 35.966673, 30.500000>,
        < -36.666599, 35.966673, 30.500000>
      }
      triangle {
        <36.666599, 35.716673, 30.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < -36.666599, 35.716673, 30.500000>
      }
      triangle {
        <-39.314800, 34.909956, 30.500000>,
        <-38.128471, 35.748182, 30.500000>,
        < -39.462521, 35.111883, 30.500000>
      }
      triangle {
        <-38.048988, 35.511061, 30.500000>,
        <-38.128471, 35.748182, 30.500000>,
        < -39.314800, 34.909956, 30.500000>
      }
      triangle {
        <-36.666599, 35.716673, 30.500000>,
        <-38.128471, 35.748182, 30.500000>,
        < -38.048988, 35.511061, 30.500000>
      }
      triangle {
        <-40.350281, 33.965490, 30.500000>,
        <-39.462521, 35.111883, 30.500000>,
        < -40.552349, 34.113241, 30.500000>
      }
      triangle {
        <-39.314800, 34.909956, 30.500000>,
        <-39.462521, 35.111883, 30.500000>,
        < -40.350281, 33.965490, 30.500000>
      }
      triangle {
        <-41.064980, 32.760176, 30.500000>,
        <-40.552349, 34.113241, 30.500000>,
        < -41.302502, 32.839720, 30.500000>
      }
      triangle {
        <-40.350281, 33.965490, 30.500000>,
        <-40.552349, 34.113241, 30.500000>,
        < -41.064980, 32.760176, 30.500000>
      }
      triangle {
        <-41.396561, 31.402456, 30.500000>,
        <-41.302502, 32.839720, 30.500000>,
        < -41.647572, 31.402456, 30.500000>
      }
      triangle {
        <-41.064980, 32.760176, 30.500000>,
        <-41.302502, 32.839720, 30.500000>,
        < -41.396561, 31.402456, 30.500000>
      }
      triangle {
        <-41.396561, 31.402456, 30.500000>,
        <-41.647572, 31.402456, 30.500000>,
        < -41.396561, 31.402456, -25.738503>
      }
      triangle {
        <38.048988, 35.511061, 30.500000>,
        <38.128471, 35.748182, 30.500000>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <38.048988, 35.511061, 30.500000>,
        <36.666599, 35.966673, 30.500000>,
        < 36.666599, 35.716673, 30.500000>
      }
      triangle {
        <41.396561, 31.402456, 30.500000>,
        <41.647572, 31.402456, -25.738503>,
        < 41.647572, 31.402456, 30.500000>
      }
      triangle {
        <41.398521, 31.380659, -26.204803>,
        <41.662430, 31.232596, -27.030701>,
        < 41.647572, 31.402456, -25.738503>
      }
      triangle {
        <41.396561, 31.402456, -25.738503>,
        <41.647572, 31.402456, -25.738503>,
        < 41.396561, 31.402456, 30.500000>
      }
      triangle {
        <41.397060, 31.397001, -25.971802>,
        <41.647572, 31.402456, -25.738503>,
        < 41.396561, 31.402456, -25.738503>
      }
      triangle {
        <41.398521, 31.380659, -26.204803>,
        <41.647572, 31.402456, -25.738503>,
        < 41.397060, 31.397001, -25.971802>
      }
      triangle {
        <41.396561, 31.402456, 30.500000>,
        <41.647572, 31.402456, 30.500000>,
        < 41.302502, 32.839720, 30.500000>
      }
      triangle {
        <41.064980, 32.760176, 30.500000>,
        <41.302502, 32.839720, 30.500000>,
        < 40.552349, 34.113241, 30.500000>
      }
      triangle {
        <41.396561, 31.402456, 30.500000>,
        <41.302502, 32.839720, 30.500000>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <40.350281, 33.965490, 30.500000>,
        <40.552349, 34.113241, 30.500000>,
        < 39.462521, 35.111883, 30.500000>
      }
      triangle {
        <41.064980, 32.760176, 30.500000>,
        <40.552349, 34.113241, 30.500000>,
        < 40.350281, 33.965490, 30.500000>
      }
      triangle {
        <39.314800, 34.909956, 30.500000>,
        <39.462521, 35.111883, 30.500000>,
        < 38.128471, 35.748182, 30.500000>
      }
      triangle {
        <40.350281, 33.965490, 30.500000>,
        <39.462521, 35.111883, 30.500000>,
        < 39.314800, 34.909956, 30.500000>
      }
      triangle {
        <39.314800, 34.909956, 30.500000>,
        <38.128471, 35.748182, 30.500000>,
        < 38.048988, 35.511061, 30.500000>
      }
      triangle {
        <42.836369, 17.814371, -36.470299>,
        <41.866291, 28.902456, -30.068604>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <43.000000, 10.566671, -40.654800>,
        <42.959049, 15.942862, -37.550903>,
        < 42.836369, 17.814371, -36.470299>
      }
      triangle {
        <42.750000, 14.066671, -38.634094>,
        <43.000000, 10.566671, -40.654800>,
        < 42.836369, 17.814371, -36.470299>
      }
      triangle {
        <42.750000, 14.066671, -38.634094>,
        <42.836369, 17.814371, -36.470299>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <41.615341, 28.902456, -30.068604>,
        <41.866291, 28.902456, -30.068604>,
        < 41.775581, 29.939253, -29.272797>
      }
      triangle {
        <42.587318, 17.792582, -36.482903>,
        <41.866291, 28.902456, -30.068604>,
        < 41.615341, 28.902456, -30.068604>
      }
      triangle {
        <42.587318, 17.792582, -36.482903>,
        <42.709290, 15.931952, -37.557205>,
        < 42.836369, 17.814371, -36.470299>
      }
      triangle {
        <41.465740, 30.612333, -28.436096>,
        <41.775581, 29.939253, -29.272797>,
        < 41.706059, 30.733870, -28.236298>
      }
      triangle {
        <41.532070, 29.854170, -29.355904>,
        <41.775581, 29.939253, -29.272797>,
        < 41.465740, 30.612333, -28.436096>
      }
      triangle {
        <41.615341, 28.902456, -30.068604>,
        <41.775581, 29.939253, -29.272797>,
        < 41.532070, 29.854170, -29.355904>
      }
      triangle {
        <41.420380, 31.130812, -27.364098>,
        <41.706059, 30.733870, -28.236298>,
        < 41.662430, 31.232596, -27.030701>
      }
      triangle {
        <41.465740, 30.612333, -28.436096>,
        <41.706059, 30.733870, -28.236298>,
        < 41.420380, 31.130812, -27.364098>
      }
      triangle {
        <41.420380, 31.130812, -27.364098>,
        <41.662430, 31.232596, -27.030701>,
        < 41.398521, 31.380659, -26.204803>
      }
      triangle {
        <43.000000, 10.566671, -40.654800>,
        <43.000000, 14.066671, -38.634094>,
        < 42.959049, 15.942862, -37.550903>
      }
      triangle {
        <42.750000, 10.566671, -40.654800>,
        <43.000000, 10.566671, -89.500000>,
        < 43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-42.750000, 10.566671, -89.250000>,
        <-43.000000, 10.566671, -89.500000>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <42.750000, 10.566671, -89.250000>,
        <43.000000, 10.566671, -89.500000>,
        < 42.750000, 10.566671, -40.654800>
      }
      triangle {
        <-42.750000, 10.566671, -89.250000>,
        <43.000000, 10.566671, -89.500000>,
        < 42.750000, 10.566671, -89.250000>
      }
      triangle {
        <42.750000, 10.566671, -40.654800>,
        <43.000000, 10.566671, -40.654800>,
        < 42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.750000, 10.566671, -40.654800>,
        <-43.000000, 14.066671, -38.634094>,
        < -43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-42.750000, 10.566671, -40.654800>,
        <-42.959049, 15.942862, -37.550903>,
        < -43.000000, 14.066671, -38.634094>
      }
      triangle {
        <-42.750000, 10.566671, -89.250000>,
        <-43.000000, 10.566671, -40.654800>,
        < -43.000000, 10.566671, -89.500000>
      }
      triangle {
        <-42.750000, 10.566671, -89.250000>,
        <-42.750000, 10.566671, -40.654800>,
        < -43.000000, 10.566671, -40.654800>
      }
      triangle {
        <-41.398521, 31.380659, -46.434601>,
        <-41.615341, 28.902456, -30.068604>,
        < -42.587318, 17.792582, -36.482903>
      }
      triangle {
        <-42.587318, 17.792582, -85.084198>,
        <-41.398521, 31.380659, -46.434601>,
        < -42.587318, 17.792582, -36.482903>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.587318, 17.792582, -85.084198>,
        < -42.587318, 17.792582, -36.482903>
      }
      triangle {
        <-41.398521, 31.380659, -46.434601>,
        <-41.532070, 29.854170, -29.355904>,
        < -41.615341, 28.902456, -30.068604>
      }
      triangle {
        <-41.398521, 31.380659, -46.434601>,
        <-41.465740, 30.612333, -28.436096>,
        < -41.532070, 29.854170, -29.355904>
      }
      triangle {
        <-41.398521, 31.380659, -46.434601>,
        <-41.420380, 31.130812, -27.364098>,
        < -41.465740, 30.612333, -28.436096>
      }
      triangle {
        <-41.398521, 31.380659, -46.434601>,
        <-41.398521, 31.380659, -26.204803>,
        < -41.420380, 31.130812, -27.364098>
      }
      triangle {
        <-41.238281, 32.255934, -45.098297>,
        <-41.398521, 31.380659, -26.204803>,
        < -41.398521, 31.380659, -46.434601>
      }
      triangle {
        <-41.238281, 32.255934, -45.098297>,
        <-41.397060, 31.397001, -25.971802>,
        < -41.398521, 31.380659, -26.204803>
      }
      triangle {
        <-42.587318, 17.792582, -85.084198>,
        <-42.477730, 19.045275, -83.094604>,
        < -41.398521, 31.380659, -46.434601>
      }
      triangle {
        <-42.290699, 19.795843, -83.352600>,
        <-41.398521, 31.380659, -46.434601>,
        < -42.477730, 19.045275, -83.094604>
      }
      triangle {
        <-40.960999, 32.855795, -45.593002>,
        <-41.238281, 32.255934, -45.098297>,
        < -41.398521, 31.380659, -46.434601>
      }
      triangle {
        <-41.211529, 32.131155, -46.692703>,
        <-41.398521, 31.380659, -46.434601>,
        < -42.290699, 19.795843, -83.352600>
      }
      triangle {
        <-41.095310, 32.515272, -46.147095>,
        <-41.398521, 31.380659, -46.434601>,
        < -41.211529, 32.131155, -46.692703>
      }
      triangle {
        <-41.095310, 32.515272, -46.147095>,
        <-40.960999, 32.855795, -45.593002>,
        < -41.398521, 31.380659, -46.434601>
      }
      triangle {
        <-42.587318, 17.792582, -85.084198>,
        <-42.522160, 18.537352, -84.164307>,
        < -42.477730, 19.045275, -83.094604>
      }
      triangle {
        <-42.290699, 19.795843, -83.352600>,
        <-42.477730, 19.045275, -83.094604>,
        < -42.522160, 18.537352, -84.164307>
      }
      triangle {
        <-42.413738, 18.348742, -85.671600>,
        <-42.522160, 18.537352, -84.164307>,
        < -42.587318, 17.792582, -85.084198>
      }
      triangle {
        <-42.340542, 19.209684, -84.597702>,
        <-42.522160, 18.537352, -84.164307>,
        < -42.413738, 18.348742, -85.671600>
      }
      triangle {
        <-42.340542, 19.209684, -84.597702>,
        <-42.290699, 19.795843, -83.352600>,
        < -42.522160, 18.537352, -84.164307>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.628300, 17.290133, -85.540695>,
        < -42.587318, 17.792582, -85.084198>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.587318, 17.792582, -85.084198>,
        < -42.628300, 17.290133, -85.540695>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.413738, 18.348742, -85.671600>,
        < -42.587318, 17.792582, -85.084198>
      }
      triangle {
        <-41.238281, 32.255934, -45.098297>,
        <-41.396561, 31.402456, -25.738503>,
        < -41.397060, 31.397001, -25.971802>
      }
      triangle {
        <-41.238281, 32.255934, -45.098297>,
        <-41.396561, 31.402456, 30.500000>,
        < -41.396561, 31.402456, -25.738503>
      }
      triangle {
        <-41.096352, 32.681242, -44.330902>,
        <-41.064980, 32.760176, 30.500000>,
        < -41.396561, 31.402456, 30.500000>
      }
      triangle {
        <-41.238281, 32.255934, -45.098297>,
        <-41.096352, 32.681242, -44.330902>,
        < -41.396561, 31.402456, 30.500000>
      }
      triangle {
        <-40.495499, 33.777723, -42.595901>,
        <-40.350281, 33.965490, 30.500000>,
        < -41.064980, 32.760176, 30.500000>
      }
      triangle {
        <-40.921200, 33.078756, -43.632599>,
        <-40.495499, 33.777723, -42.595901>,
        < -41.064980, 32.760176, 30.500000>
      }
      triangle {
        <-41.096352, 32.681242, -44.330902>,
        <-40.921200, 33.078756, -43.632599>,
        < -41.064980, 32.760176, 30.500000>
      }
      triangle {
        <-39.948559, 34.400511, -41.891800>,
        <-39.314800, 34.909956, 30.500000>,
        < -40.350281, 33.965490, 30.500000>
      }
      triangle {
        <-40.495499, 33.777723, -42.595901>,
        <-39.948559, 34.400511, -41.891800>,
        < -40.350281, 33.965490, 30.500000>
      }
      triangle {
        <-38.374550, 35.398985, -41.059204>,
        <-38.048988, 35.511061, 30.500000>,
        < -39.314800, 34.909956, 30.500000>
      }
      triangle {
        <-39.239799, 34.959303, -41.390900>,
        <-38.374550, 35.398985, -41.059204>,
        < -39.314800, 34.909956, 30.500000>
      }
      triangle {
        <-39.948559, 34.400511, -41.891800>,
        <-39.239799, 34.959303, -41.390900>,
        < -39.314800, 34.909956, 30.500000>
      }
      triangle {
        <-36.666599, 35.716673, -40.845093>,
        <-36.666599, 35.716673, 30.500000>,
        < -38.048988, 35.511061, 30.500000>
      }
      triangle {
        <-37.460480, 35.649862, -40.888596>,
        <-36.666599, 35.716673, -40.845093>,
        < -38.048988, 35.511061, 30.500000>
      }
      triangle {
        <-38.374550, 35.398985, -41.059204>,
        <-37.460480, 35.649862, -40.888596>,
        < -38.048988, 35.511061, 30.500000>
      }
      triangle {
        <36.666599, 35.716673, -40.845093>,
        <-36.666599, 35.716673, 30.500000>,
        < -36.666599, 35.716673, -40.845093>
      }
      triangle {
        <36.666599, 35.716673, -40.845093>,
        <36.666599, 35.716673, 30.500000>,
        < -36.666599, 35.716673, 30.500000>
      }
      triangle {
        <-36.666599, 35.667395, -41.451004>,
        <-36.666599, 35.716673, -40.845093>,
        < -37.460480, 35.649862, -40.888596>
      }
      triangle {
        <-36.666599, 35.667395, -41.451004>,
        <36.666599, 35.716673, -40.845093>,
        < -36.666599, 35.716673, -40.845093>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-37.460480, 35.649862, -40.888596>,
        < -38.374550, 35.398985, -41.059204>
      }
      triangle {
        <-36.666599, 35.551855, -41.944595>,
        <-36.666599, 35.667395, -41.451004>,
        < -37.460480, 35.649862, -40.888596>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-36.666599, 35.551855, -41.944595>,
        < -37.460480, 35.649862, -40.888596>
      }
      triangle {
        <-37.995159, 35.443602, -41.849701>,
        <-38.374550, 35.398985, -41.059204>,
        < -39.239799, 34.959303, -41.390900>
      }
      triangle {
        <-37.995159, 35.443602, -41.849701>,
        <-37.188789, 35.569906, -41.821396>,
        < -38.374550, 35.398985, -41.059204>
      }
      triangle {
        <-38.740471, 35.166403, -42.094498>,
        <-39.239799, 34.959303, -41.390900>,
        < -39.948559, 34.400511, -41.891800>
      }
      triangle {
        <-38.740471, 35.166403, -42.094498>,
        <-37.995159, 35.443602, -41.849701>,
        < -39.239799, 34.959303, -41.390900>
      }
      triangle {
        <-39.335781, 34.822065, -42.468094>,
        <-39.948559, 34.400511, -41.891800>,
        < -40.495499, 33.777723, -42.595901>
      }
      triangle {
        <-39.335781, 34.822065, -42.468094>,
        <-38.740471, 35.166403, -42.094498>,
        < -39.948559, 34.400511, -41.891800>
      }
      triangle {
        <-40.140991, 34.119543, -43.416199>,
        <-40.495499, 33.777723, -42.595901>,
        < -40.921200, 33.078756, -43.632599>
      }
      triangle {
        <-39.792389, 34.464705, -42.918701>,
        <-39.335781, 34.822065, -42.468094>,
        < -40.495499, 33.777723, -42.595901>
      }
      triangle {
        <-40.140991, 34.119543, -43.416199>,
        <-39.792389, 34.464705, -42.918701>,
        < -40.495499, 33.777723, -42.595901>
      }
      triangle {
        <-40.627831, 33.480597, -44.484802>,
        <-40.921200, 33.078756, -43.632599>,
        < -41.096352, 32.681242, -44.330902>
      }
      triangle {
        <-40.411491, 33.792975, -43.942093>,
        <-40.140991, 34.119543, -43.416199>,
        < -40.921200, 33.078756, -43.632599>
      }
      triangle {
        <-40.627831, 33.480597, -44.484802>,
        <-40.411491, 33.792975, -43.942093>,
        < -40.921200, 33.078756, -43.632599>
      }
      triangle {
        <-40.807220, 33.172522, -45.036896>,
        <-41.096352, 32.681242, -44.330902>,
        < -41.238281, 32.255934, -45.098297>
      }
      triangle {
        <-40.807220, 33.172522, -45.036896>,
        <-40.627831, 33.480597, -44.484802>,
        < -41.096352, 32.681242, -44.330902>
      }
      triangle {
        <-40.960999, 32.855795, -45.593002>,
        <-40.807220, 33.172522, -45.036896>,
        < -41.238281, 32.255934, -45.098297>
      }
      triangle {
        <37.461578, 35.649672, -40.888702>,
        <36.666599, 35.716673, 30.500000>,
        < 36.666599, 35.716673, -40.845093>
      }
      triangle {
        <37.461578, 35.649672, -40.888702>,
        <38.048988, 35.511061, 30.500000>,
        < 36.666599, 35.716673, 30.500000>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <37.461578, 35.649672, -40.888702>,
        < 36.666599, 35.716673, -40.845093>
      }
      triangle {
        <36.666599, 35.667395, -41.451004>,
        <36.666599, 35.716673, -40.845093>,
        < -36.666599, 35.667395, -41.451004>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <36.666599, 35.716673, -40.845093>,
        < 36.666599, 35.667395, -41.451004>
      }
      triangle {
        <39.242649, 34.957472, -41.392303>,
        <39.314800, 34.909956, 30.500000>,
        < 38.048988, 35.511061, 30.500000>
      }
      triangle {
        <38.376789, 35.398123, -41.059799>,
        <39.242649, 34.957472, -41.392303>,
        < 38.048988, 35.511061, 30.500000>
      }
      triangle {
        <37.461578, 35.649672, -40.888702>,
        <38.376789, 35.398123, -41.059799>,
        < 38.048988, 35.511061, 30.500000>
      }
      triangle {
        <39.951591, 34.397612, -41.894608>,
        <40.350281, 33.965490, 30.500000>,
        < 39.314800, 34.909956, 30.500000>
      }
      triangle {
        <39.242649, 34.957472, -41.392303>,
        <39.951591, 34.397612, -41.894608>,
        < 39.314800, 34.909956, 30.500000>
      }
      triangle {
        <40.924110, 33.072882, -43.642395>,
        <41.064980, 32.760176, 30.500000>,
        < 40.350281, 33.965490, 30.500000>
      }
      triangle {
        <40.498310, 33.773893, -42.600800>,
        <40.924110, 33.072882, -43.642395>,
        < 40.350281, 33.965490, 30.500000>
      }
      triangle {
        <39.951591, 34.397612, -41.894608>,
        <40.498310, 33.773893, -42.600800>,
        < 40.350281, 33.965490, 30.500000>
      }
      triangle {
        <41.396561, 31.402456, -25.738503>,
        <41.396561, 31.402456, 30.500000>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <41.340740, 31.812155, -45.834000>,
        <41.396561, 31.402456, -25.738503>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <41.239250, 32.252493, -45.104401>,
        <41.340740, 31.812155, -45.834000>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <41.098431, 32.675863, -44.340698>,
        <41.239250, 32.252493, -45.104401>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <40.924110, 33.072882, -43.642395>,
        <41.098431, 32.675863, -44.340698>,
        < 41.064980, 32.760176, 30.500000>
      }
      triangle {
        <41.398521, 31.380659, -46.434601>,
        <41.397060, 31.397001, -25.971802>,
        < 41.396561, 31.402456, -25.738503>
      }
      triangle {
        <41.340740, 31.812155, -45.834000>,
        <41.398521, 31.380659, -46.434601>,
        < 41.396561, 31.402456, -25.738503>
      }
      triangle {
        <41.398521, 31.380659, -46.434601>,
        <41.398521, 31.380659, -26.204803>,
        < 41.397060, 31.397001, -25.971802>
      }
      triangle {
        <41.420380, 31.130812, -27.364098>,
        <41.398521, 31.380659, -26.204803>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <41.211529, 32.131155, -46.692703>,
        <41.398521, 31.380659, -46.434601>,
        < 41.340740, 31.812155, -45.834000>
      }
      triangle {
        <41.465740, 30.612333, -28.436096>,
        <41.420380, 31.130812, -27.364098>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <41.532070, 29.854170, -29.355904>,
        <41.465740, 30.612333, -28.436096>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <41.615341, 28.902456, -30.068604>,
        <41.532070, 29.854170, -29.355904>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <42.587318, 17.792582, -36.482903>,
        <41.615341, 28.902456, -30.068604>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <42.477730, 19.045275, -83.094604>,
        <42.587318, 17.792582, -36.482903>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <41.211529, 32.131155, -46.692703>,
        <42.477730, 19.045275, -83.094604>,
        < 41.398521, 31.380659, -46.434601>
      }
      triangle {
        <40.960999, 32.855795, -45.593002>,
        <41.340740, 31.812155, -45.834000>,
        < 41.239250, 32.252493, -45.104401>
      }
      triangle {
        <41.095310, 32.515272, -46.147095>,
        <41.211529, 32.131155, -46.692703>,
        < 41.340740, 31.812155, -45.834000>
      }
      triangle {
        <40.960999, 32.855795, -45.593002>,
        <41.095310, 32.515272, -46.147095>,
        < 41.340740, 31.812155, -45.834000>
      }
      triangle {
        <40.807220, 33.172522, -45.036896>,
        <41.239250, 32.252493, -45.104401>,
        < 41.098431, 32.675863, -44.340698>
      }
      triangle {
        <40.807220, 33.172522, -45.036896>,
        <40.960999, 32.855795, -45.593002>,
        < 41.239250, 32.252493, -45.104401>
      }
      triangle {
        <40.627831, 33.480597, -44.484802>,
        <41.098431, 32.675863, -44.340698>,
        < 40.924110, 33.072882, -43.642395>
      }
      triangle {
        <40.627831, 33.480597, -44.484802>,
        <40.807220, 33.172522, -45.036896>,
        < 41.098431, 32.675863, -44.340698>
      }
      triangle {
        <40.411491, 33.792975, -43.942093>,
        <40.924110, 33.072882, -43.642395>,
        < 40.498310, 33.773893, -42.600800>
      }
      triangle {
        <40.411491, 33.792975, -43.942093>,
        <40.627831, 33.480597, -44.484802>,
        < 40.924110, 33.072882, -43.642395>
      }
      triangle {
        <39.792389, 34.464705, -42.918701>,
        <40.498310, 33.773893, -42.600800>,
        < 39.951591, 34.397612, -41.894608>
      }
      triangle {
        <40.140991, 34.119543, -43.416199>,
        <40.411491, 33.792975, -43.942093>,
        < 40.498310, 33.773893, -42.600800>
      }
      triangle {
        <39.792389, 34.464705, -42.918701>,
        <40.140991, 34.119543, -43.416199>,
        < 40.498310, 33.773893, -42.600800>
      }
      triangle {
        <38.740471, 35.166403, -42.094498>,
        <39.951591, 34.397612, -41.894608>,
        < 39.242649, 34.957472, -41.392303>
      }
      triangle {
        <39.335781, 34.822065, -42.468094>,
        <39.792389, 34.464705, -42.918701>,
        < 39.951591, 34.397612, -41.894608>
      }
      triangle {
        <38.740471, 35.166403, -42.094498>,
        <39.335781, 34.822065, -42.468094>,
        < 39.951591, 34.397612, -41.894608>
      }
      triangle {
        <37.995159, 35.443602, -41.849701>,
        <39.242649, 34.957472, -41.392303>,
        < 38.376789, 35.398123, -41.059799>
      }
      triangle {
        <37.995159, 35.443602, -41.849701>,
        <38.740471, 35.166403, -42.094498>,
        < 39.242649, 34.957472, -41.392303>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <38.376789, 35.398123, -41.059799>,
        < 37.461578, 35.649672, -40.888702>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <37.995159, 35.443602, -41.849701>,
        < 38.376789, 35.398123, -41.059799>
      }
      triangle {
        <42.522160, 18.537352, -84.164307>,
        <42.587318, 17.792582, -85.084198>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <42.652531, 16.951902, -85.849594>,
        <42.587318, 17.792582, -36.482903>,
        < 42.587318, 17.792582, -85.084198>
      }
      triangle {
        <42.477730, 19.045275, -83.094604>,
        <42.522160, 18.537352, -84.164307>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <42.697739, 16.179804, -86.585999>,
        <42.709290, 15.931952, -37.557205>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <42.681938, 16.477934, -86.293198>,
        <42.697739, 16.179804, -86.585999>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <42.652531, 16.951902, -85.849594>,
        <42.681938, 16.477934, -86.293198>,
        < 42.587318, 17.792582, -36.482903>
      }
      triangle {
        <42.413738, 18.348742, -85.671600>,
        <42.587318, 17.792582, -85.084198>,
        < 42.522160, 18.537352, -84.164307>
      }
      triangle {
        <42.413738, 18.348742, -85.671600>,
        <42.652531, 16.951902, -85.849594>,
        < 42.587318, 17.792582, -85.084198>
      }
      triangle {
        <42.340542, 19.209684, -84.597702>,
        <42.522160, 18.537352, -84.164307>,
        < 42.477730, 19.045275, -83.094604>
      }
      triangle {
        <42.413738, 18.348742, -85.671600>,
        <42.522160, 18.537352, -84.164307>,
        < 42.340542, 19.209684, -84.597702>
      }
      triangle {
        <42.290699, 19.795843, -83.352600>,
        <42.477730, 19.045275, -83.094604>,
        < 41.211529, 32.131155, -46.692703>
      }
      triangle {
        <42.340542, 19.209684, -84.597702>,
        <42.477730, 19.045275, -83.094604>,
        < 42.290699, 19.795843, -83.352600>
      }
      triangle {
        <42.750000, 14.066671, -89.250000>,
        <42.750000, 14.066671, -38.634094>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.749939, 14.141573, -89.249603>,
        <42.750000, 14.066671, -89.250000>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.749741, 14.214892, -89.248596>,
        <42.749939, 14.141573, -89.249603>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.748638, 14.407381, -88.926102>,
        <42.749741, 14.214892, -89.248596>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.746819, 14.588114, -88.630707>,
        <42.748638, 14.407381, -88.926102>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.744450, 14.755694, -88.366196>,
        <42.746819, 14.588114, -88.630707>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.741600, 14.913874, -88.126602>,
        <42.744450, 14.755694, -88.366196>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.732689, 15.283201, -87.610596>,
        <42.741600, 14.913874, -88.126602>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.725380, 15.517252, -87.315201>,
        <42.732689, 15.283201, -87.610596>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.697739, 16.179804, -86.585999>,
        <42.725380, 15.517252, -87.315201>,
        < 42.709290, 15.931952, -37.557205>
      }
      triangle {
        <42.750000, 10.566671, -40.654800>,
        <42.750000, 14.066671, -38.634094>,
        < 42.750000, 14.066671, -89.250000>
      }
      triangle {
        <-42.750000, 14.066671, -89.250000>,
        <42.750000, 14.066671, -89.250000>,
        < 42.749939, 14.141573, -89.249603>
      }
      triangle {
        <42.750000, 10.566671, -89.250000>,
        <42.750000, 10.566671, -40.654800>,
        < 42.750000, 14.066671, -89.250000>
      }
      triangle {
        <-42.750000, 14.066671, -89.250000>,
        <42.750000, 10.566671, -89.250000>,
        < 42.750000, 14.066671, -89.250000>
      }
      triangle {
        <-42.749939, 14.140944, -89.249603>,
        <42.749939, 14.141573, -89.249603>,
        < 42.749741, 14.214892, -89.248596>
      }
      triangle {
        <-42.749939, 14.140944, -89.249603>,
        <-42.750000, 14.066671, -89.250000>,
        < 42.749939, 14.141573, -89.249603>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <42.749741, 14.214892, -89.248596>,
        < 42.748638, 14.407381, -88.926102>
      }
      triangle {
        <-42.749939, 14.140944, -89.249603>,
        <42.749741, 14.214892, -89.248596>,
        < -42.749741, 14.215212, -89.248596>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.749741, 14.215212, -89.248596>,
        < 42.749741, 14.214892, -89.248596>
      }
      triangle {
        <42.655918, 15.369772, -88.072693>,
        <42.748638, 14.407381, -88.926102>,
        < 42.746819, 14.588114, -88.630707>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <42.748638, 14.407381, -88.926102>,
        < 41.205471, 15.527811, -89.110992>
      }
      triangle {
        <41.675850, 15.526724, -89.035599>,
        <41.205471, 15.527811, -89.110992>,
        < 42.748638, 14.407381, -88.926102>
      }
      triangle {
        <42.100498, 15.497732, -88.821594>,
        <41.675850, 15.526724, -89.035599>,
        < 42.748638, 14.407381, -88.926102>
      }
      triangle {
        <42.438141, 15.443663, -88.489899>,
        <42.100498, 15.497732, -88.821594>,
        < 42.748638, 14.407381, -88.926102>
      }
      triangle {
        <42.655918, 15.369772, -88.072693>,
        <42.438141, 15.443663, -88.489899>,
        < 42.748638, 14.407381, -88.926102>
      }
      triangle {
        <42.655918, 15.369772, -88.072693>,
        <42.746819, 14.588114, -88.630707>,
        < 42.744450, 14.755694, -88.366196>
      }
      triangle {
        <42.732689, 15.283201, -87.610596>,
        <42.744450, 14.755694, -88.366196>,
        < 42.741600, 14.913874, -88.126602>
      }
      triangle {
        <42.655918, 15.369772, -88.072693>,
        <42.744450, 14.755694, -88.366196>,
        < 42.732689, 15.283201, -87.610596>
      }
      triangle {
        <42.697739, 16.179804, -86.585999>,
        <42.732689, 15.283201, -87.610596>,
        < 42.725380, 15.517252, -87.315201>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.732689, 15.283201, -87.610596>,
        < 42.697739, 16.179804, -86.585999>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.655918, 15.369772, -88.072693>,
        < 42.732689, 15.283201, -87.610596>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.697739, 16.179804, -86.585999>,
        < 42.681938, 16.477934, -86.293198>
      }
      triangle {
        <42.413738, 18.348742, -85.671600>,
        <42.681938, 16.477934, -86.293198>,
        < 42.652531, 16.951902, -85.849594>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.681938, 16.477934, -86.293198>,
        < 42.413738, 18.348742, -85.671600>
      }
      triangle {
        <-42.750000, 14.066671, -89.250000>,
        <-42.750000, 10.566671, -89.250000>,
        < 42.750000, 10.566671, -89.250000>
      }
      triangle {
        <-42.750000, 14.066671, -38.634094>,
        <-42.750000, 10.566671, -40.654800>,
        < -42.750000, 10.566671, -89.250000>
      }
      triangle {
        <-42.750000, 14.066671, -89.250000>,
        <-42.750000, 14.066671, -38.634094>,
        < -42.750000, 10.566671, -89.250000>
      }
      triangle {
        <-42.749939, 14.140944, -89.249603>,
        <-42.750000, 14.066671, -38.634094>,
        < -42.750000, 14.066671, -89.250000>
      }
      triangle {
        <-42.729851, 15.379042, -87.486801>,
        <-42.712811, 15.849463, -86.932693>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.750000, 14.066671, -38.634094>,
        < -42.712811, 15.849463, -86.932693>
      }
      triangle {
        <-42.732719, 15.282133, -87.612000>,
        <-42.729851, 15.379042, -87.486801>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.742668, 14.858275, -88.209595>,
        <-42.732719, 15.282133, -87.612000>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.749741, 14.215212, -89.248596>,
        <-42.742668, 14.858275, -88.209595>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.749939, 14.140944, -89.249603>,
        <-42.749741, 14.215212, -89.248596>,
        < -42.750000, 14.066671, -38.634094>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.662922, 16.793963, -85.995499>,
        < -42.628300, 17.290133, -85.540695>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.628300, 17.290133, -85.540695>,
        < -42.662922, 16.793963, -85.995499>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.682018, 16.476652, -86.294403>,
        < -42.662922, 16.793963, -85.995499>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.662922, 16.793963, -85.995499>,
        < -42.682018, 16.476652, -86.294403>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.690868, 16.314371, -86.451996>,
        < -42.682018, 16.476652, -86.294403>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.682018, 16.476652, -86.294403>,
        < -42.690868, 16.314371, -86.451996>
      }
      triangle {
        <-42.732719, 15.282133, -87.612000>,
        <-42.690868, 16.314371, -86.451996>,
        < -42.712811, 15.849463, -86.932693>
      }
      triangle {
        <-42.709290, 15.931952, -37.557205>,
        <-42.712811, 15.849463, -86.932693>,
        < -42.690868, 16.314371, -86.451996>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.690868, 16.314371, -86.451996>,
        < -42.732719, 15.282133, -87.612000>
      }
      triangle {
        <-42.732719, 15.282133, -87.612000>,
        <-42.712811, 15.849463, -86.932693>,
        < -42.729851, 15.379042, -87.486801>
      }
      triangle {
        <-42.749741, 14.215212, -89.248596>,
        <-42.732719, 15.282133, -87.612000>,
        < -42.742668, 14.858275, -88.209595>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.732719, 15.282133, -87.612000>,
        < -42.749741, 14.215212, -89.248596>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.586349, 16.738192, -86.857697>,
        < -42.732719, 15.282133, -87.612000>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.749741, 14.215212, -89.248596>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.749741, 14.215212, -89.248596>,
        < -42.664108, 14.257853, -89.247604>
      }
      triangle {
        <-42.481392, 14.386362, -89.243393>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.574032, 14.316591, -89.246002>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.574032, 14.316591, -89.246002>,
        < -42.664108, 14.257853, -89.247604>
      }
      triangle {
        <-42.393848, 14.446043, -89.240707>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.481392, 14.386362, -89.243393>
      }
      triangle {
        <-41.600399, 15.527254, -89.058502>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.393848, 14.446043, -89.240707>
      }
      triangle {
        <-41.967388, 15.508795, -88.907806>,
        <-42.664108, 14.257853, -89.247604>,
        < -41.600399, 15.527254, -89.058502>
      }
      triangle {
        <-42.282902, 15.472044, -88.669403>,
        <-42.664108, 14.257853, -89.247604>,
        < -41.967388, 15.508795, -88.907806>
      }
      triangle {
        <-42.525570, 15.419504, -88.359406>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.282902, 15.472044, -88.669403>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.664108, 14.257853, -89.247604>,
        < -42.525570, 15.419504, -88.359406>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.481392, 14.386362, -89.243393>,
        < -42.574032, 14.316591, -89.246002>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.393848, 14.446043, -89.240707>,
        < -42.481392, 14.386362, -89.243393>
      }
      triangle {
        <-41.206772, 15.526182, -89.111298>,
        <-42.393848, 14.446043, -89.240707>,
        < -42.073589, 14.679583, -89.225693>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-42.073589, 14.679583, -89.225693>,
        < -42.393848, 14.446043, -89.240707>
      }
      triangle {
        <-41.600399, 15.527254, -89.058502>,
        <-42.393848, 14.446043, -89.240707>,
        < -41.206772, 15.526182, -89.111298>
      }
      triangle {
        <-41.542290, 15.149775, -89.173904>,
        <-42.073589, 14.679583, -89.225693>,
        < -41.792240, 14.913141, -89.203598>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-41.792240, 14.913141, -89.203598>,
        < -42.073589, 14.679583, -89.225693>
      }
      triangle {
        <-41.317749, 15.392794, -89.135696>,
        <-42.073589, 14.679583, -89.225693>,
        < -41.542290, 15.149775, -89.173904>
      }
      triangle {
        <-41.206772, 15.526182, -89.111298>,
        <-42.073589, 14.679583, -89.225693>,
        < -41.317749, 15.392794, -89.135696>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <-41.542290, 15.149775, -89.173904>,
        < -41.792240, 14.913141, -89.203598>
      }
      triangle {
        <41.205471, 15.527811, -89.110992>,
        <-41.317749, 15.392794, -89.135696>,
        < -41.542290, 15.149775, -89.173904>
      }
      triangle {
        <41.584679, 15.107374, -89.179794>,
        <41.205471, 15.527811, -89.110992>,
        < -41.542290, 15.149775, -89.173904>
      }
      triangle {
        <41.205471, 15.527811, -89.110992>,
        <-41.206772, 15.526182, -89.111298>,
        < -41.317749, 15.392794, -89.135696>
      }
      triangle {
        <-40.927971, 15.910685, -89.027405>,
        <-41.206772, 15.526182, -89.111298>,
        < -41.114101, 15.645434, -89.087494>
      }
      triangle {
        <41.205471, 15.527811, -89.110992>,
        <-41.114101, 15.645434, -89.087494>,
        < -41.206772, 15.526182, -89.111298>
      }
      triangle {
        <-40.757252, 16.190783, -88.953201>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.927971, 15.910685, -89.027405>
      }
      triangle {
        <-40.601349, 16.486101, -88.862701>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.757252, 16.190783, -88.953201>
      }
      triangle {
        <-40.459709, 16.796633, -88.753296>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.601349, 16.486101, -88.862701>
      }
      triangle {
        <-40.332169, 17.121172, -88.622696>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.459709, 16.796633, -88.753296>
      }
      triangle {
        <-40.241470, 17.385695, -88.503296>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.332169, 17.121172, -88.622696>
      }
      triangle {
        <-41.600399, 15.527254, -89.058502>,
        <-41.206772, 15.526182, -89.111298>,
        < -40.241470, 17.385695, -88.503296>
      }
      triangle {
        <40.905670, 15.945074, -89.018906>,
        <-40.927971, 15.910685, -89.027405>,
        < -41.114101, 15.645434, -89.087494>
      }
      triangle {
        <41.205471, 15.527811, -89.110992>,
        <40.905670, 15.945074, -89.018906>,
        < -41.114101, 15.645434, -89.087494>
      }
      triangle {
        <40.905670, 15.945074, -89.018906>,
        <-40.757252, 16.190783, -88.953201>,
        < -40.927971, 15.910685, -89.027405>
      }
      triangle {
        <40.467960, 16.777243, -88.760498>,
        <-40.601349, 16.486101, -88.862701>,
        < -40.757252, 16.190783, -88.953201>
      }
      triangle {
        <40.905670, 15.945074, -89.018906>,
        <40.467960, 16.777243, -88.760498>,
        < -40.757252, 16.190783, -88.953201>
      }
      triangle {
        <40.467960, 16.777243, -88.760498>,
        <-40.459709, 16.796633, -88.753296>,
        < -40.601349, 16.486101, -88.862701>
      }
      triangle {
        <40.240780, 17.387842, -88.502304>,
        <-40.332169, 17.121172, -88.622696>,
        < -40.459709, 16.796633, -88.753296>
      }
      triangle {
        <40.467960, 16.777243, -88.760498>,
        <40.240780, 17.387842, -88.502304>,
        < -40.459709, 16.796633, -88.753296>
      }
      triangle {
        <40.240780, 17.387842, -88.502304>,
        <-40.241470, 17.385695, -88.503296>,
        < -40.332169, 17.121172, -88.622696>
      }
      triangle {
        <-40.120029, 17.800161, -88.291397>,
        <-40.241470, 17.385695, -88.503296>,
        < -40.218899, 17.456854, -88.469193>
      }
      triangle {
        <40.240780, 17.387842, -88.502304>,
        <-40.218899, 17.456854, -88.469193>,
        < -40.241470, 17.385695, -88.503296>
      }
      triangle {
        <-40.035770, 18.146692, -88.089096>,
        <-40.241470, 17.385695, -88.503296>,
        < -40.120029, 17.800161, -88.291397>
      }
      triangle {
        <-39.966381, 18.491293, -87.862793>,
        <-40.241470, 17.385695, -88.503296>,
        < -40.035770, 18.146692, -88.089096>
      }
      triangle {
        <-39.912010, 18.828814, -87.614304>,
        <-40.241470, 17.385695, -88.503296>,
        < -39.966381, 18.491293, -87.862793>
      }
      triangle {
        <-39.872631, 19.154764, -87.345795>,
        <-40.241470, 17.385695, -88.503296>,
        < -39.912010, 18.828814, -87.614304>
      }
      triangle {
        <-39.847790, 19.470331, -87.055405>,
        <-40.241470, 17.385695, -88.503296>,
        < -39.872631, 19.154764, -87.345795>
      }
      triangle {
        <-40.863819, 17.379805, -88.416702>,
        <-40.241470, 17.385695, -88.503296>,
        < -39.847790, 19.470331, -87.055405>
      }
      triangle {
        <-41.600399, 15.527254, -89.058502>,
        <-40.241470, 17.385695, -88.503296>,
        < -40.863819, 17.379805, -88.416702>
      }
      triangle {
        <40.161499, 17.649313, -88.372192>,
        <-40.120029, 17.800161, -88.291397>,
        < -40.218899, 17.456854, -88.469193>
      }
      triangle {
        <40.240780, 17.387842, -88.502304>,
        <40.161499, 17.649313, -88.372192>,
        < -40.218899, 17.456854, -88.469193>
      }
      triangle {
        <39.953381, 18.564875, -87.811005>,
        <-40.035770, 18.146692, -88.089096>,
        < -40.120029, 17.800161, -88.291397>
      }
      triangle {
        <40.161499, 17.649313, -88.372192>,
        <39.953381, 18.564875, -87.811005>,
        < -40.120029, 17.800161, -88.291397>
      }
      triangle {
        <39.953381, 18.564875, -87.811005>,
        <-39.966381, 18.491293, -87.862793>,
        < -40.035770, 18.146692, -88.089096>
      }
      triangle {
        <39.953381, 18.564875, -87.811005>,
        <-39.912010, 18.828814, -87.614304>,
        < -39.966381, 18.491293, -87.862793>
      }
      triangle {
        <39.847790, 19.470331, -87.055405>,
        <-39.872631, 19.154764, -87.345795>,
        < -39.912010, 18.828814, -87.614304>
      }
      triangle {
        <39.953381, 18.564875, -87.811005>,
        <39.847790, 19.470331, -87.055405>,
        < -39.912010, 18.828814, -87.614304>
      }
      triangle {
        <39.847790, 19.470331, -87.055405>,
        <-39.847790, 19.470331, -87.055405>,
        < -39.872631, 19.154764, -87.345795>
      }
      triangle {
        <39.847790, 19.470331, -87.055405>,
        <-39.782631, 20.624731, -85.629700>,
        < -39.847790, 19.470331, -87.055405>
      }
      triangle {
        <-40.664108, 19.420252, -86.930496>,
        <-39.847790, 19.470331, -87.055405>,
        < -39.782631, 20.624731, -85.629700>
      }
      triangle {
        <-40.863819, 17.379805, -88.416702>,
        <-39.847790, 19.470331, -87.055405>,
        < -40.664108, 19.420252, -86.930496>
      }
      triangle {
        <39.738190, 21.412005, -83.971603>,
        <-39.738190, 21.412005, -83.971603>,
        < -39.782631, 20.624731, -85.629700>
      }
      triangle {
        <-40.592838, 20.541334, -85.532501>,
        <-39.782631, 20.624731, -85.629700>,
        < -39.738190, 21.412005, -83.971603>
      }
      triangle {
        <39.782631, 20.624731, -85.629700>,
        <39.738190, 21.412005, -83.971603>,
        < -39.782631, 20.624731, -85.629700>
      }
      triangle {
        <39.847790, 19.470331, -87.055405>,
        <39.782631, 20.624731, -85.629700>,
        < -39.782631, 20.624731, -85.629700>
      }
      triangle {
        <-40.592838, 20.541334, -85.532501>,
        <-40.664108, 19.420252, -86.930496>,
        < -39.782631, 20.624731, -85.629700>
      }
      triangle {
        <-38.658981, 33.747397, -47.311600>,
        <-39.738190, 21.412005, -83.971603>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-39.462769, 33.640631, -47.252106>,
        <-39.738190, 21.412005, -83.971603>,
        < -38.658981, 33.747397, -47.311600>
      }
      triangle {
        <-40.592838, 20.541334, -85.532501>,
        <-39.738190, 21.412005, -83.971603>,
        < -40.544300, 21.304594, -83.911697>
      }
      triangle {
        <-39.462769, 33.640631, -47.252106>,
        <-40.544300, 21.304594, -83.911697>,
        < -39.738190, 21.412005, -83.971603>
      }
      triangle {
        <40.544300, 21.304594, -83.911697>,
        <39.738190, 21.412005, -83.971603>,
        < 39.782631, 20.624731, -85.629700>
      }
      triangle {
        <-38.588161, 34.005011, -46.546005>,
        <-38.658981, 33.747397, -47.311600>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-38.409840, 34.308310, -45.644608>,
        <-38.588161, 34.005011, -46.546005>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-38.249039, 34.511252, -45.041504>,
        <-38.409840, 34.308310, -45.644608>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-38.173119, 34.596907, -44.787003>,
        <-38.249039, 34.511252, -45.041504>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.947891, 34.826925, -44.103302>,
        <-38.173119, 34.596907, -44.787003>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.753231, 35.003264, -43.579300>,
        <-37.947891, 34.826925, -44.103302>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.640228, 35.096754, -43.301407>,
        <-37.753231, 35.003264, -43.579300>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.582611, 35.141729, -43.167694>,
        <-37.640228, 35.096754, -43.301407>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.426300, 35.253653, -42.835098>,
        <-37.582611, 35.141729, -43.167694>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.278870, 35.344107, -42.566299>,
        <-37.426300, 35.253653, -42.835098>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.195278, 35.387991, -42.435898>,
        <-37.278870, 35.344107, -42.566299>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.137630, 35.414869, -42.356003>,
        <-37.195278, 35.387991, -42.435898>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-37.002399, 35.466566, -42.202393>,
        <-37.137630, 35.414869, -42.356003>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-36.876308, 35.499594, -42.104202>,
        <-37.002399, 35.466566, -42.202393>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-36.763279, 35.516340, -42.054398>,
        <-36.876308, 35.499594, -42.104202>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <-36.666599, 35.520865, -42.041000>,
        <-36.763279, 35.516340, -42.054398>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <36.666599, 35.520865, -42.041000>,
        <-36.666599, 35.520865, -42.041000>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <36.772259, 35.515463, -42.057007>,
        <36.666599, 35.520865, -42.041000>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <36.896851, 35.495230, -42.117203>,
        <36.772259, 35.515463, -42.057007>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.036041, 35.455244, -42.235992>,
        <36.896851, 35.495230, -42.117203>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.184910, 35.393034, -42.420898>,
        <37.036041, 35.455244, -42.235992>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.195278, 35.387991, -42.435898>,
        <37.184910, 35.393034, -42.420898>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.340420, 35.308272, -42.672806>,
        <37.195278, 35.387991, -42.435898>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.504379, 35.199659, -42.995605>,
        <37.340420, 35.308272, -42.672806>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.640240, 35.096747, -43.301407>,
        <37.504379, 35.199659, -42.995605>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.681431, 35.063452, -43.400406>,
        <37.640240, 35.096747, -43.301407>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <37.881920, 34.888853, -43.919296>,
        <37.681431, 35.063452, -43.400406>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <38.116940, 34.657232, -44.607605>,
        <37.881920, 34.888853, -43.919296>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <38.249050, 34.511236, -45.041504>,
        <38.116940, 34.657232, -44.607605>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <38.374641, 34.356123, -45.502502>,
        <38.249050, 34.511236, -45.041504>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <38.577621, 34.028395, -46.476501>,
        <38.374641, 34.356123, -45.502502>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <38.658981, 33.747397, -47.311600>,
        <38.577621, 34.028395, -46.476501>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <40.544300, 21.304594, -83.911697>,
        <38.658981, 33.747397, -47.311600>,
        < 39.738190, 21.412005, -83.971603>
      }
      triangle {
        <40.664108, 19.420252, -86.930496>,
        <39.782631, 20.624731, -85.629700>,
        < 39.847790, 19.470331, -87.055405>
      }
      triangle {
        <40.592838, 20.541334, -85.532501>,
        <40.544300, 21.304594, -83.911697>,
        < 39.782631, 20.624731, -85.629700>
      }
      triangle {
        <40.664108, 19.420252, -86.930496>,
        <40.592838, 20.541334, -85.532501>,
        < 39.782631, 20.624731, -85.629700>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <39.847790, 19.470331, -87.055405>,
        < 39.953381, 18.564875, -87.811005>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <40.664108, 19.420252, -86.930496>,
        < 39.847790, 19.470331, -87.055405>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <39.953381, 18.564875, -87.811005>,
        < 40.161499, 17.649313, -88.372192>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <40.161499, 17.649313, -88.372192>,
        < 40.240780, 17.387842, -88.502304>
      }
      triangle {
        <41.675850, 15.526724, -89.035599>,
        <40.240780, 17.387842, -88.502304>,
        < 40.467960, 16.777243, -88.760498>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <40.240780, 17.387842, -88.502304>,
        < 41.675850, 15.526724, -89.035599>
      }
      triangle {
        <41.675850, 15.526724, -89.035599>,
        <40.467960, 16.777243, -88.760498>,
        < 40.905670, 15.945074, -89.018906>
      }
      triangle {
        <41.675850, 15.526724, -89.035599>,
        <40.905670, 15.945074, -89.018906>,
        < 41.205471, 15.527811, -89.110992>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-38.658981, 33.747397, -47.311600>,
        < -38.588161, 34.005011, -46.546005>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-39.462769, 33.640631, -47.252106>,
        < -38.658981, 33.747397, -47.311600>
      }
      triangle {
        <-39.032871, 34.027960, -46.353897>,
        <-38.588161, 34.005011, -46.546005>,
        < -38.409840, 34.308310, -45.644608>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-38.588161, 34.005011, -46.546005>,
        < -39.032871, 34.027960, -46.353897>
      }
      triangle {
        <-38.534821, 34.362204, -45.470001>,
        <-38.409840, 34.308310, -45.644608>,
        < -38.249039, 34.511252, -45.041504>
      }
      triangle {
        <-38.794449, 34.200850, -45.908493>,
        <-38.409840, 34.308310, -45.644608>,
        < -38.534821, 34.362204, -45.470001>
      }
      triangle {
        <-39.032871, 34.027960, -46.353897>,
        <-38.409840, 34.308310, -45.644608>,
        < -38.794449, 34.200850, -45.908493>
      }
      triangle {
        <-39.242931, 34.338385, -45.072693>,
        <-38.249039, 34.511252, -45.041504>,
        < -38.173119, 34.596907, -44.787003>
      }
      triangle {
        <-38.534821, 34.362204, -45.470001>,
        <-38.249039, 34.511252, -45.041504>,
        < -39.242931, 34.338385, -45.072693>
      }
      triangle {
        <-38.931068, 34.558813, -44.583099>,
        <-38.173119, 34.596907, -44.787003>,
        < -37.947891, 34.826925, -44.103302>
      }
      triangle {
        <-39.242931, 34.338385, -45.072693>,
        <-38.173119, 34.596907, -44.787003>,
        < -38.931068, 34.558813, -44.583099>
      }
      triangle {
        <-38.143341, 34.951803, -43.680695>,
        <-37.947891, 34.826925, -44.103302>,
        < -37.753231, 35.003264, -43.579300>
      }
      triangle {
        <-38.569279, 34.766226, -44.115005>,
        <-37.947891, 34.826925, -44.103302>,
        < -38.143341, 34.951803, -43.680695>
      }
      triangle {
        <-38.931068, 34.558813, -44.583099>,
        <-37.947891, 34.826925, -44.103302>,
        < -38.569279, 34.766226, -44.115005>
      }
      triangle {
        <-38.143341, 34.951803, -43.680695>,
        <-37.753231, 35.003264, -43.579300>,
        < -37.640228, 35.096754, -43.301407>
      }
      triangle {
        <-38.502369, 35.090513, -42.912903>,
        <-37.640228, 35.096754, -43.301407>,
        < -37.582611, 35.141729, -43.167694>
      }
      triangle {
        <-38.999889, 34.837530, -43.321198>,
        <-37.640228, 35.096754, -43.301407>,
        < -38.502369, 35.090513, -42.912903>
      }
      triangle {
        <-38.143341, 34.951803, -43.680695>,
        <-37.640228, 35.096754, -43.301407>,
        < -38.999889, 34.837530, -43.321198>
      }
      triangle {
        <-38.502369, 35.090513, -42.912903>,
        <-37.582611, 35.141729, -43.167694>,
        < -37.426300, 35.253653, -42.835098>
      }
      triangle {
        <-37.894371, 35.293081, -42.595505>,
        <-37.426300, 35.253653, -42.835098>,
        < -37.278870, 35.344107, -42.566299>
      }
      triangle {
        <-38.502369, 35.090513, -42.912903>,
        <-37.426300, 35.253653, -42.835098>,
        < -37.894371, 35.293081, -42.595505>
      }
      triangle {
        <-37.894371, 35.293081, -42.595505>,
        <-37.278870, 35.344107, -42.566299>,
        < -37.195278, 35.387991, -42.435898>
      }
      triangle {
        <-37.995159, 35.443602, -41.849701>,
        <-37.195278, 35.387991, -42.435898>,
        < -37.137630, 35.414869, -42.356003>
      }
      triangle {
        <-38.740471, 35.166403, -42.094498>,
        <-37.195278, 35.387991, -42.435898>,
        < -37.995159, 35.443602, -41.849701>
      }
      triangle {
        <-37.894371, 35.293081, -42.595505>,
        <-37.195278, 35.387991, -42.435898>,
        < -38.740471, 35.166403, -42.094498>
      }
      triangle {
        <-37.995159, 35.443602, -41.849701>,
        <-37.137630, 35.414869, -42.356003>,
        < -37.002399, 35.466566, -42.202393>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-37.002399, 35.466566, -42.202393>,
        < -36.876308, 35.499594, -42.104202>
      }
      triangle {
        <-37.995159, 35.443602, -41.849701>,
        <-37.002399, 35.466566, -42.202393>,
        < -37.188789, 35.569906, -41.821396>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-36.876308, 35.499594, -42.104202>,
        < -36.763279, 35.516340, -42.054398>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-36.763279, 35.516340, -42.054398>,
        < -36.666599, 35.520865, -42.041000>
      }
      triangle {
        <36.666599, 35.551855, -41.944595>,
        <-36.666599, 35.520865, -42.041000>,
        < 36.666599, 35.520865, -42.041000>
      }
      triangle {
        <-37.188789, 35.569906, -41.821396>,
        <-36.666599, 35.520865, -42.041000>,
        < -36.666599, 35.551855, -41.944595>
      }
      triangle {
        <36.666599, 35.551855, -41.944595>,
        <-36.666599, 35.551855, -41.944595>,
        < -36.666599, 35.520865, -42.041000>
      }
      triangle {
        <36.666599, 35.551855, -41.944595>,
        <36.666599, 35.520865, -42.041000>,
        < 36.772259, 35.515463, -42.057007>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <36.772259, 35.515463, -42.057007>,
        < 36.896851, 35.495230, -42.117203>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <36.666599, 35.551855, -41.944595>,
        < 36.772259, 35.515463, -42.057007>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <36.896851, 35.495230, -42.117203>,
        < 37.036041, 35.455244, -42.235992>
      }
      triangle {
        <37.995159, 35.443602, -41.849701>,
        <37.036041, 35.455244, -42.235992>,
        < 37.184910, 35.393034, -42.420898>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <37.036041, 35.455244, -42.235992>,
        < 37.995159, 35.443602, -41.849701>
      }
      triangle {
        <37.995159, 35.443602, -41.849701>,
        <37.184910, 35.393034, -42.420898>,
        < 37.195278, 35.387991, -42.435898>
      }
      triangle {
        <37.894371, 35.293081, -42.595505>,
        <37.195278, 35.387991, -42.435898>,
        < 37.340420, 35.308272, -42.672806>
      }
      triangle {
        <37.995159, 35.443602, -41.849701>,
        <37.195278, 35.387991, -42.435898>,
        < 38.740471, 35.166403, -42.094498>
      }
      triangle {
        <37.894371, 35.293081, -42.595505>,
        <38.740471, 35.166403, -42.094498>,
        < 37.195278, 35.387991, -42.435898>
      }
      triangle {
        <37.894371, 35.293081, -42.595505>,
        <37.340420, 35.308272, -42.672806>,
        < 37.504379, 35.199659, -42.995605>
      }
      triangle {
        <38.502380, 35.090513, -42.912903>,
        <37.504379, 35.199659, -42.995605>,
        < 37.640240, 35.096747, -43.301407>
      }
      triangle {
        <38.502380, 35.090513, -42.912903>,
        <37.894371, 35.293081, -42.595505>,
        < 37.504379, 35.199659, -42.995605>
      }
      triangle {
        <38.143341, 34.951803, -43.680801>,
        <37.640240, 35.096747, -43.301407>,
        < 37.681431, 35.063452, -43.400406>
      }
      triangle {
        <38.999889, 34.837530, -43.321198>,
        <37.640240, 35.096747, -43.301407>,
        < 38.143341, 34.951803, -43.680801>
      }
      triangle {
        <38.999889, 34.837530, -43.321198>,
        <38.502380, 35.090513, -42.912903>,
        < 37.640240, 35.096747, -43.301407>
      }
      triangle {
        <38.143341, 34.951803, -43.680801>,
        <37.681431, 35.063452, -43.400406>,
        < 37.881920, 34.888853, -43.919296>
      }
      triangle {
        <38.569290, 34.766226, -44.115005>,
        <37.881920, 34.888853, -43.919296>,
        < 38.116940, 34.657232, -44.607605>
      }
      triangle {
        <38.569290, 34.766226, -44.115005>,
        <38.143341, 34.951803, -43.680801>,
        < 37.881920, 34.888853, -43.919296>
      }
      triangle {
        <38.931068, 34.558813, -44.583099>,
        <38.116940, 34.657232, -44.607605>,
        < 38.249050, 34.511236, -45.041504>
      }
      triangle {
        <38.931068, 34.558813, -44.583099>,
        <38.569290, 34.766226, -44.115005>,
        < 38.116940, 34.657232, -44.607605>
      }
      triangle {
        <38.534821, 34.362196, -45.470001>,
        <38.249050, 34.511236, -45.041504>,
        < 38.374641, 34.356123, -45.502502>
      }
      triangle {
        <39.242931, 34.338385, -45.072693>,
        <38.249050, 34.511236, -45.041504>,
        < 38.534821, 34.362196, -45.470001>
      }
      triangle {
        <39.242931, 34.338385, -45.072693>,
        <38.931068, 34.558813, -44.583099>,
        < 38.249050, 34.511236, -45.041504>
      }
      triangle {
        <38.794441, 34.200834, -45.908600>,
        <38.374641, 34.356123, -45.502502>,
        < 38.577621, 34.028395, -46.476501>
      }
      triangle {
        <38.794441, 34.200834, -45.908600>,
        <38.534821, 34.362196, -45.470001>,
        < 38.374641, 34.356123, -45.502502>
      }
      triangle {
        <39.254211, 33.842390, -46.803101>,
        <38.577621, 34.028395, -46.476501>,
        < 38.658981, 33.747397, -47.311600>
      }
      triangle {
        <39.032860, 34.027952, -46.353897>,
        <38.794441, 34.200834, -45.908600>,
        < 38.577621, 34.028395, -46.476501>
      }
      triangle {
        <39.254211, 33.842390, -46.803101>,
        <39.032860, 34.027952, -46.353897>,
        < 38.577621, 34.028395, -46.476501>
      }
      triangle {
        <39.462769, 33.640631, -47.252106>,
        <39.254211, 33.842390, -46.803101>,
        < 38.658981, 33.747397, -47.311600>
      }
      triangle {
        <40.544300, 21.304594, -83.911697>,
        <39.462769, 33.640631, -47.252106>,
        < 38.658981, 33.747397, -47.311600>
      }
      triangle {
        <-42.335739, 16.973353, -87.383804>,
        <-42.007900, 18.832884, -86.205795>,
        < -42.413738, 18.348742, -85.671600>
      }
      triangle {
        <-41.931339, 19.800875, -84.992493>,
        <-42.413738, 18.348742, -85.671600>,
        < -42.007900, 18.832884, -86.205795>
      }
      triangle {
        <-42.586349, 16.738192, -86.857697>,
        <-42.335739, 16.973353, -87.383804>,
        < -42.413738, 18.348742, -85.671600>
      }
      triangle {
        <-42.340542, 19.209684, -84.597702>,
        <-42.413738, 18.348742, -85.671600>,
        < -41.931339, 19.800875, -84.992493>
      }
      triangle {
        <-41.946732, 17.166582, -87.837799>,
        <-41.406551, 19.201162, -86.638504>,
        < -42.007900, 18.832884, -86.205795>
      }
      triangle {
        <-41.330971, 20.258322, -85.313705>,
        <-42.007900, 18.832884, -86.205795>,
        < -41.406551, 19.201162, -86.638504>
      }
      triangle {
        <-42.335739, 16.973353, -87.383804>,
        <-41.946732, 17.166582, -87.837799>,
        < -42.007900, 18.832884, -86.205795>
      }
      triangle {
        <-41.931339, 19.800875, -84.992493>,
        <-42.007900, 18.832884, -86.205795>,
        < -41.330971, 20.258322, -85.313705>
      }
      triangle {
        <-41.445042, 17.305124, -88.189896>,
        <-40.664108, 19.420252, -86.930496>,
        < -41.406551, 19.201162, -86.638504>
      }
      triangle {
        <-40.592838, 20.541334, -85.532501>,
        <-41.406551, 19.201162, -86.638504>,
        < -40.664108, 19.420252, -86.930496>
      }
      triangle {
        <-41.946732, 17.166582, -87.837799>,
        <-41.445042, 17.305124, -88.189896>,
        < -41.406551, 19.201162, -86.638504>
      }
      triangle {
        <-41.330971, 20.258322, -85.313705>,
        <-41.406551, 19.201162, -86.638504>,
        < -40.592838, 20.541334, -85.532501>
      }
      triangle {
        <-41.445042, 17.305124, -88.189896>,
        <-40.863819, 17.379805, -88.416702>,
        < -40.664108, 19.420252, -86.930496>
      }
      triangle {
        <-41.967388, 15.508795, -88.907806>,
        <-40.863819, 17.379805, -88.416702>,
        < -41.445042, 17.305124, -88.189896>
      }
      triangle {
        <-41.967388, 15.508795, -88.907806>,
        <-41.600399, 15.527254, -89.058502>,
        < -40.863819, 17.379805, -88.416702>
      }
      triangle {
        <-42.282902, 15.472044, -88.669403>,
        <-41.445042, 17.305124, -88.189896>,
        < -41.946732, 17.166582, -87.837799>
      }
      triangle {
        <-42.282902, 15.472044, -88.669403>,
        <-41.967388, 15.508795, -88.907806>,
        < -41.445042, 17.305124, -88.189896>
      }
      triangle {
        <-42.525570, 15.419504, -88.359406>,
        <-41.946732, 17.166582, -87.837799>,
        < -42.335739, 16.973353, -87.383804>
      }
      triangle {
        <-42.525570, 15.419504, -88.359406>,
        <-42.282902, 15.472044, -88.669403>,
        < -41.946732, 17.166582, -87.837799>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.335739, 16.973353, -87.383804>,
        < -42.586349, 16.738192, -86.857697>
      }
      triangle {
        <-42.678970, 15.354723, -87.998795>,
        <-42.525570, 15.419504, -88.359406>,
        < -42.335739, 16.973353, -87.383804>
      }
      triangle {
        <-42.340542, 19.209684, -84.597702>,
        <-41.879238, 20.459353, -83.587997>,
        < -42.290699, 19.795843, -83.352600>
      }
      triangle {
        <-41.211529, 32.131155, -46.692703>,
        <-42.290699, 19.795843, -83.352600>,
        < -41.879238, 20.459353, -83.587997>
      }
      triangle {
        <-41.931339, 19.800875, -84.992493>,
        <-41.279530, 20.977453, -83.779999>,
        < -41.879238, 20.459353, -83.587997>
      }
      triangle {
        <-40.799568, 32.795294, -46.928299>,
        <-41.879238, 20.459353, -83.587997>,
        < -41.279530, 20.977453, -83.779999>
      }
      triangle {
        <-42.340542, 19.209684, -84.597702>,
        <-41.931339, 19.800875, -84.992493>,
        < -41.879238, 20.459353, -83.587997>
      }
      triangle {
        <-40.799568, 32.795294, -46.928299>,
        <-41.211529, 32.131155, -46.692703>,
        < -41.879238, 20.459353, -83.587997>
      }
      triangle {
        <-41.330971, 20.258322, -85.313705>,
        <-40.544300, 21.304594, -83.911697>,
        < -41.279530, 20.977453, -83.779999>
      }
      triangle {
        <-40.199009, 33.313673, -47.120407>,
        <-41.279530, 20.977453, -83.779999>,
        < -40.544300, 21.304594, -83.911697>
      }
      triangle {
        <-41.931339, 19.800875, -84.992493>,
        <-41.330971, 20.258322, -85.313705>,
        < -41.279530, 20.977453, -83.779999>
      }
      triangle {
        <-40.199009, 33.313673, -47.120407>,
        <-40.799568, 32.795294, -46.928299>,
        < -41.279530, 20.977453, -83.779999>
      }
      triangle {
        <-41.330971, 20.258322, -85.313705>,
        <-40.592838, 20.541334, -85.532501>,
        < -40.544300, 21.304594, -83.911697>
      }
      triangle {
        <-39.462769, 33.640631, -47.252106>,
        <-40.199009, 33.313673, -47.120407>,
        < -40.544300, 21.304594, -83.911697>
      }
      triangle {
        <-40.628700, 33.140272, -46.395798>,
        <-41.211529, 32.131155, -46.692703>,
        < -40.799568, 32.795294, -46.928299>
      }
      triangle {
        <-40.628700, 33.140272, -46.395798>,
        <-41.095310, 32.515272, -46.147095>,
        < -41.211529, 32.131155, -46.692703>
      }
      triangle {
        <-39.988411, 33.602324, -46.605301>,
        <-40.799568, 32.795294, -46.928299>,
        < -40.199009, 33.313673, -47.120407>
      }
      triangle {
        <-39.988411, 33.602324, -46.605301>,
        <-40.628700, 33.140272, -46.395798>,
        < -40.799568, 32.795294, -46.928299>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-40.199009, 33.313673, -47.120407>,
        < -39.462769, 33.640631, -47.252106>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-39.988411, 33.602324, -46.605301>,
        < -40.199009, 33.313673, -47.120407>
      }
      triangle {
        <36.666599, 35.667395, -41.451004>,
        <-36.666599, 35.667395, -41.451004>,
        < -36.666599, 35.551855, -41.944595>
      }
      triangle {
        <36.666599, 35.551855, -41.944595>,
        <36.666599, 35.667395, -41.451004>,
        < -36.666599, 35.551855, -41.944595>
      }
      triangle {
        <-37.894371, 35.293081, -42.595505>,
        <-38.740471, 35.166403, -42.094498>,
        < -39.335781, 34.822065, -42.468094>
      }
      triangle {
        <-38.502369, 35.090513, -42.912903>,
        <-39.335781, 34.822065, -42.468094>,
        < -39.792389, 34.464705, -42.918701>
      }
      triangle {
        <-38.502369, 35.090513, -42.912903>,
        <-37.894371, 35.293081, -42.595505>,
        < -39.335781, 34.822065, -42.468094>
      }
      triangle {
        <-38.999889, 34.837530, -43.321198>,
        <-39.792389, 34.464705, -42.918701>,
        < -40.140991, 34.119543, -43.416199>
      }
      triangle {
        <-38.999889, 34.837530, -43.321198>,
        <-38.502369, 35.090513, -42.912903>,
        < -39.792389, 34.464705, -42.918701>
      }
      triangle {
        <-39.401550, 34.566450, -43.783905>,
        <-40.140991, 34.119543, -43.416199>,
        < -40.411491, 33.792975, -43.942093>
      }
      triangle {
        <-39.401550, 34.566450, -43.783905>,
        <-38.999889, 34.837530, -43.321198>,
        < -40.140991, 34.119543, -43.416199>
      }
      triangle {
        <-39.728882, 34.291777, -44.279495>,
        <-40.411491, 33.792975, -43.942093>,
        < -40.627831, 33.480597, -44.484802>
      }
      triangle {
        <-39.728882, 34.291777, -44.279495>,
        <-39.401550, 34.566450, -43.783905>,
        < -40.411491, 33.792975, -43.942093>
      }
      triangle {
        <-40.001732, 34.016844, -44.795395>,
        <-40.627831, 33.480597, -44.484802>,
        < -40.807220, 33.172522, -45.036896>
      }
      triangle {
        <-40.001732, 34.016844, -44.795395>,
        <-39.728882, 34.291777, -44.279495>,
        < -40.627831, 33.480597, -44.484802>
      }
      triangle {
        <-40.235729, 33.738554, -45.323700>,
        <-40.807220, 33.172522, -45.036896>,
        < -40.960999, 32.855795, -45.593002>
      }
      triangle {
        <-40.235729, 33.738554, -45.323700>,
        <-40.001732, 34.016844, -44.795395>,
        < -40.807220, 33.172522, -45.036896>
      }
      triangle {
        <-40.442230, 33.449720, -45.858994>,
        <-40.960999, 32.855795, -45.593002>,
        < -41.095310, 32.515272, -46.147095>
      }
      triangle {
        <-40.442230, 33.449720, -45.858994>,
        <-40.235729, 33.738554, -45.323700>,
        < -40.960999, 32.855795, -45.593002>
      }
      triangle {
        <-40.628700, 33.140272, -46.395798>,
        <-40.442230, 33.449720, -45.858994>,
        < -41.095310, 32.515272, -46.147095>
      }
      triangle {
        <-38.143341, 34.951803, -43.680695>,
        <-38.999889, 34.837530, -43.321198>,
        < -39.401550, 34.566450, -43.783905>
      }
      triangle {
        <-38.569279, 34.766226, -44.115005>,
        <-39.401550, 34.566450, -43.783905>,
        < -39.728882, 34.291777, -44.279495>
      }
      triangle {
        <-38.569279, 34.766226, -44.115005>,
        <-38.143341, 34.951803, -43.680695>,
        < -39.401550, 34.566450, -43.783905>
      }
      triangle {
        <-38.931068, 34.558813, -44.583099>,
        <-39.728882, 34.291777, -44.279495>,
        < -40.001732, 34.016844, -44.795395>
      }
      triangle {
        <-38.931068, 34.558813, -44.583099>,
        <-38.569279, 34.766226, -44.115005>,
        < -39.728882, 34.291777, -44.279495>
      }
      triangle {
        <-39.242931, 34.338385, -45.072693>,
        <-40.001732, 34.016844, -44.795395>,
        < -40.235729, 33.738554, -45.323700>
      }
      triangle {
        <-39.242931, 34.338385, -45.072693>,
        <-38.931068, 34.558813, -44.583099>,
        < -40.001732, 34.016844, -44.795395>
      }
      triangle {
        <-39.517059, 34.107290, -45.576294>,
        <-40.235729, 33.738554, -45.323700>,
        < -40.442230, 33.449720, -45.858994>
      }
      triangle {
        <-39.517059, 34.107290, -45.576294>,
        <-39.242931, 34.338385, -45.072693>,
        < -40.235729, 33.738554, -45.323700>
      }
      triangle {
        <-39.763161, 33.863646, -46.088806>,
        <-40.442230, 33.449720, -45.858994>,
        < -40.628700, 33.140272, -46.395798>
      }
      triangle {
        <-39.763161, 33.863646, -46.088806>,
        <-39.517059, 34.107290, -45.576294>,
        < -40.442230, 33.449720, -45.858994>
      }
      triangle {
        <-39.988411, 33.602324, -46.605301>,
        <-39.763161, 33.863646, -46.088806>,
        < -40.628700, 33.140272, -46.395798>
      }
      triangle {
        <-38.534821, 34.362204, -45.470001>,
        <-39.242931, 34.338385, -45.072693>,
        < -39.517059, 34.107290, -45.576294>
      }
      triangle {
        <-38.794449, 34.200850, -45.908493>,
        <-39.517059, 34.107290, -45.576294>,
        < -39.763161, 33.863646, -46.088806>
      }
      triangle {
        <-38.794449, 34.200850, -45.908493>,
        <-38.534821, 34.362204, -45.470001>,
        < -39.517059, 34.107290, -45.576294>
      }
      triangle {
        <-39.032871, 34.027960, -46.353897>,
        <-39.763161, 33.863646, -46.088806>,
        < -39.988411, 33.602324, -46.605301>
      }
      triangle {
        <-39.032871, 34.027960, -46.353897>,
        <-38.794449, 34.200850, -45.908493>,
        < -39.763161, 33.863646, -46.088806>
      }
      triangle {
        <-39.254230, 33.842390, -46.803101>,
        <-39.032871, 34.027960, -46.353897>,
        < -39.988411, 33.602324, -46.605301>
      }
      triangle {
        <37.188789, 35.569906, -41.821396>,
        <36.666599, 35.667395, -41.451004>,
        < 36.666599, 35.551855, -41.944595>
      }
      triangle {
        <40.799568, 32.795294, -46.928299>,
        <41.211529, 32.131155, -46.692703>,
        < 41.095310, 32.515272, -46.147095>
      }
      triangle {
        <42.290699, 19.795843, -83.352600>,
        <41.211529, 32.131155, -46.692703>,
        < 40.799568, 32.795294, -46.928299>
      }
      triangle {
        <40.442230, 33.449720, -45.858994>,
        <41.095310, 32.515272, -46.147095>,
        < 40.960999, 32.855795, -45.593002>
      }
      triangle {
        <40.628712, 33.140265, -46.395798>,
        <41.095310, 32.515272, -46.147095>,
        < 40.442230, 33.449720, -45.858994>
      }
      triangle {
        <40.799568, 32.795294, -46.928299>,
        <41.095310, 32.515272, -46.147095>,
        < 40.628712, 33.140265, -46.395798>
      }
      triangle {
        <40.235729, 33.738554, -45.323700>,
        <40.960999, 32.855795, -45.593002>,
        < 40.807220, 33.172522, -45.036896>
      }
      triangle {
        <40.442230, 33.449720, -45.858994>,
        <40.960999, 32.855795, -45.593002>,
        < 40.235729, 33.738554, -45.323700>
      }
      triangle {
        <40.001732, 34.016844, -44.795395>,
        <40.807220, 33.172522, -45.036896>,
        < 40.627831, 33.480597, -44.484802>
      }
      triangle {
        <40.235729, 33.738554, -45.323700>,
        <40.807220, 33.172522, -45.036896>,
        < 40.001732, 34.016844, -44.795395>
      }
      triangle {
        <39.728889, 34.291777, -44.279495>,
        <40.627831, 33.480597, -44.484802>,
        < 40.411491, 33.792975, -43.942093>
      }
      triangle {
        <40.001732, 34.016844, -44.795395>,
        <40.627831, 33.480597, -44.484802>,
        < 39.728889, 34.291777, -44.279495>
      }
      triangle {
        <39.401562, 34.566450, -43.783905>,
        <40.411491, 33.792975, -43.942093>,
        < 40.140991, 34.119543, -43.416199>
      }
      triangle {
        <39.728889, 34.291777, -44.279495>,
        <40.411491, 33.792975, -43.942093>,
        < 39.401562, 34.566450, -43.783905>
      }
      triangle {
        <38.999889, 34.837530, -43.321198>,
        <40.140991, 34.119543, -43.416199>,
        < 39.792389, 34.464705, -42.918701>
      }
      triangle {
        <39.401562, 34.566450, -43.783905>,
        <40.140991, 34.119543, -43.416199>,
        < 38.999889, 34.837530, -43.321198>
      }
      triangle {
        <38.502380, 35.090513, -42.912903>,
        <39.792389, 34.464705, -42.918701>,
        < 39.335781, 34.822065, -42.468094>
      }
      triangle {
        <38.999889, 34.837530, -43.321198>,
        <39.792389, 34.464705, -42.918701>,
        < 38.502380, 35.090513, -42.912903>
      }
      triangle {
        <37.894371, 35.293081, -42.595505>,
        <39.335781, 34.822065, -42.468094>,
        < 38.740471, 35.166403, -42.094498>
      }
      triangle {
        <38.502380, 35.090513, -42.912903>,
        <39.335781, 34.822065, -42.468094>,
        < 37.894371, 35.293081, -42.595505>
      }
      triangle {
        <39.517059, 34.107290, -45.576294>,
        <38.534821, 34.362196, -45.470001>,
        < 38.794441, 34.200834, -45.908600>
      }
      triangle {
        <39.517059, 34.107290, -45.576294>,
        <39.242931, 34.338385, -45.072693>,
        < 38.534821, 34.362196, -45.470001>
      }
      triangle {
        <39.763149, 33.863646, -46.088806>,
        <38.794441, 34.200834, -45.908600>,
        < 39.032860, 34.027952, -46.353897>
      }
      triangle {
        <39.763149, 33.863646, -46.088806>,
        <39.517059, 34.107290, -45.576294>,
        < 38.794441, 34.200834, -45.908600>
      }
      triangle {
        <39.988411, 33.602324, -46.605301>,
        <39.032860, 34.027952, -46.353897>,
        < 39.254211, 33.842390, -46.803101>
      }
      triangle {
        <39.988411, 33.602324, -46.605301>,
        <39.763149, 33.863646, -46.088806>,
        < 39.032860, 34.027952, -46.353897>
      }
      triangle {
        <39.988411, 33.602324, -46.605301>,
        <39.254211, 33.842390, -46.803101>,
        < 39.462769, 33.640631, -47.252106>
      }
      triangle {
        <40.199009, 33.313673, -47.120407>,
        <39.988411, 33.602324, -46.605301>,
        < 39.462769, 33.640631, -47.252106>
      }
      triangle {
        <40.544300, 21.304594, -83.911697>,
        <40.199009, 33.313673, -47.120407>,
        < 39.462769, 33.640631, -47.252106>
      }
      triangle {
        <39.401562, 34.566450, -43.783905>,
        <38.143341, 34.951803, -43.680801>,
        < 38.569290, 34.766226, -44.115005>
      }
      triangle {
        <39.401562, 34.566450, -43.783905>,
        <38.999889, 34.837530, -43.321198>,
        < 38.143341, 34.951803, -43.680801>
      }
      triangle {
        <39.728889, 34.291777, -44.279495>,
        <38.569290, 34.766226, -44.115005>,
        < 38.931068, 34.558813, -44.583099>
      }
      triangle {
        <39.728889, 34.291777, -44.279495>,
        <39.401562, 34.566450, -43.783905>,
        < 38.569290, 34.766226, -44.115005>
      }
      triangle {
        <40.001732, 34.016844, -44.795395>,
        <38.931068, 34.558813, -44.583099>,
        < 39.242931, 34.338385, -45.072693>
      }
      triangle {
        <40.001732, 34.016844, -44.795395>,
        <39.728889, 34.291777, -44.279495>,
        < 38.931068, 34.558813, -44.583099>
      }
      triangle {
        <40.235729, 33.738554, -45.323700>,
        <39.242931, 34.338385, -45.072693>,
        < 39.517059, 34.107290, -45.576294>
      }
      triangle {
        <40.235729, 33.738554, -45.323700>,
        <40.001732, 34.016844, -44.795395>,
        < 39.242931, 34.338385, -45.072693>
      }
      triangle {
        <40.442230, 33.449720, -45.858994>,
        <39.517059, 34.107290, -45.576294>,
        < 39.763149, 33.863646, -46.088806>
      }
      triangle {
        <40.442230, 33.449720, -45.858994>,
        <40.235729, 33.738554, -45.323700>,
        < 39.517059, 34.107290, -45.576294>
      }
      triangle {
        <40.628712, 33.140265, -46.395798>,
        <39.763149, 33.863646, -46.088806>,
        < 39.988411, 33.602324, -46.605301>
      }
      triangle {
        <40.628712, 33.140265, -46.395798>,
        <40.442230, 33.449720, -45.858994>,
        < 39.763149, 33.863646, -46.088806>
      }
      triangle {
        <40.628712, 33.140265, -46.395798>,
        <39.988411, 33.602324, -46.605301>,
        < 40.199009, 33.313673, -47.120407>
      }
      triangle {
        <40.799568, 32.795294, -46.928299>,
        <40.628712, 33.140265, -46.395798>,
        < 40.199009, 33.313673, -47.120407>
      }
      triangle {
        <41.279530, 20.977453, -83.779999>,
        <40.799568, 32.795294, -46.928299>,
        < 40.199009, 33.313673, -47.120407>
      }
      triangle {
        <40.544300, 21.304594, -83.911697>,
        <41.279530, 20.977453, -83.779999>,
        < 40.199009, 33.313673, -47.120407>
      }
      triangle {
        <41.879238, 20.459353, -83.587997>,
        <42.290699, 19.795843, -83.352600>,
        < 40.799568, 32.795294, -46.928299>
      }
      triangle {
        <41.279530, 20.977453, -83.779999>,
        <41.879238, 20.459353, -83.587997>,
        < 40.799568, 32.795294, -46.928299>
      }
      triangle {
        <41.931339, 19.800875, -84.992493>,
        <42.290699, 19.795843, -83.352600>,
        < 41.879238, 20.459353, -83.587997>
      }
      triangle {
        <41.931339, 19.800875, -84.992493>,
        <42.340542, 19.209684, -84.597702>,
        < 42.290699, 19.795843, -83.352600>
      }
      triangle {
        <41.330971, 20.258322, -85.313705>,
        <41.879238, 20.459353, -83.587997>,
        < 41.279530, 20.977453, -83.779999>
      }
      triangle {
        <41.330971, 20.258322, -85.313705>,
        <41.931339, 19.800875, -84.992493>,
        < 41.879238, 20.459353, -83.587997>
      }
      triangle {
        <40.592838, 20.541334, -85.532501>,
        <41.279530, 20.977453, -83.779999>,
        < 40.544300, 21.304594, -83.911697>
      }
      triangle {
        <40.592838, 20.541334, -85.532501>,
        <41.330971, 20.258322, -85.313705>,
        < 41.279530, 20.977453, -83.779999>
      }
      triangle {
        <42.007900, 18.832884, -86.205795>,
        <42.340542, 19.209684, -84.597702>,
        < 41.931339, 19.800875, -84.992493>
      }
      triangle {
        <42.007900, 18.832884, -86.205795>,
        <42.413738, 18.348742, -85.671600>,
        < 42.340542, 19.209684, -84.597702>
      }
      triangle {
        <41.406551, 19.201162, -86.638504>,
        <41.931339, 19.800875, -84.992493>,
        < 41.330971, 20.258322, -85.313705>
      }
      triangle {
        <41.406551, 19.201162, -86.638504>,
        <42.007900, 18.832884, -86.205795>,
        < 41.931339, 19.800875, -84.992493>
      }
      triangle {
        <40.664108, 19.420252, -86.930496>,
        <41.330971, 20.258322, -85.313705>,
        < 40.592838, 20.541334, -85.532501>
      }
      triangle {
        <40.664108, 19.420252, -86.930496>,
        <41.406551, 19.201162, -86.638504>,
        < 41.330971, 20.258322, -85.313705>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.413738, 18.348742, -85.671600>,
        < 42.007900, 18.832884, -86.205795>
      }
      triangle {
        <42.195271, 17.058283, -87.574707>,
        <42.007900, 18.832884, -86.205795>,
        < 41.406551, 19.201162, -86.638504>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.007900, 18.832884, -86.205795>,
        < 42.195271, 17.058283, -87.574707>
      }
      triangle {
        <41.656910, 17.258944, -88.061905>,
        <41.406551, 19.201162, -86.638504>,
        < 40.664108, 19.420252, -86.930496>
      }
      triangle {
        <42.195271, 17.058283, -87.574707>,
        <41.406551, 19.201162, -86.638504>,
        < 41.656910, 17.258944, -88.061905>
      }
      triangle {
        <41.656910, 17.258944, -88.061905>,
        <40.664108, 19.420252, -86.930496>,
        < 40.984119, 17.372381, -88.381195>
      }
      triangle {
        <40.984119, 17.372381, -88.381195>,
        <41.675850, 15.526724, -89.035599>,
        < 42.100498, 15.497732, -88.821594>
      }
      triangle {
        <41.656910, 17.258944, -88.061905>,
        <42.100498, 15.497732, -88.821594>,
        < 42.438141, 15.443663, -88.489899>
      }
      triangle {
        <41.656910, 17.258944, -88.061905>,
        <40.984119, 17.372381, -88.381195>,
        < 42.100498, 15.497732, -88.821594>
      }
      triangle {
        <42.195271, 17.058283, -87.574707>,
        <42.438141, 15.443663, -88.489899>,
        < 42.655918, 15.369772, -88.072693>
      }
      triangle {
        <42.195271, 17.058283, -87.574707>,
        <41.656910, 17.258944, -88.061905>,
        < 42.438141, 15.443663, -88.489899>
      }
      triangle {
        <42.548119, 16.789442, -86.965805>,
        <42.195271, 17.058283, -87.574707>,
        < 42.655918, 15.369772, -88.072693>
      }
      texture{_all_inside}
    }
    // _all
    mesh {
      triangle {
        <26.625000, -6.033327, -89.500000>,
        <43.000000, 10.566671, -89.500000>,
        < 43.000000, -6.033327, -89.500000>
      }
      triangle {
        <26.000000, -3.033327, -89.500000>,
        <26.000000, 10.566671, -89.500000>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -89.500000>,
        <26.000000, -3.033327, -89.500000>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <43.000000, -6.033327, -89.500000>,
        < 43.000000, -6.033327, -80.995697>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <26.625000, -6.033327, -89.500000>,
        < 43.000000, -6.033327, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <43.000000, -6.033327, -80.995697>,
        < 43.000000, -5.891848, -80.085297>
      }
      triangle {
        <26.625000, -5.891836, -80.085297>,
        <43.000000, -5.891848, -80.085297>,
        < 43.000000, -5.480707, -79.260696>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <43.000000, -5.891848, -80.085297>,
        < 26.625000, -5.891836, -80.085297>
      }
      triangle {
        <26.625000, -5.480726, -79.260696>,
        <43.000000, -5.480707, -79.260696>,
        < 43.000000, -4.838777, -78.599792>
      }
      triangle {
        <26.625000, -5.891836, -80.085297>,
        <43.000000, -5.480707, -79.260696>,
        < 26.625000, -5.480726, -79.260696>
      }
      triangle {
        <26.625000, -0.024248, -74.971802>,
        <43.000000, -4.838777, -78.599792>,
        < 43.000000, -0.024248, -74.971802>
      }
      triangle {
        <26.625000, -4.838777, -78.599792>,
        <43.000000, -4.838777, -78.599792>,
        < 26.625000, -0.024248, -74.971802>
      }
      triangle {
        <26.625000, -5.480726, -79.260696>,
        <43.000000, -4.838777, -78.599792>,
        < 26.625000, -4.838777, -78.599792>
      }
      triangle {
        <26.625000, -0.024248, -74.971802>,
        <43.000000, -0.024248, -74.971802>,
        < 43.000000, 0.810911, -74.175797>
      }
      triangle {
        <26.625000, 0.810873, -74.175797>,
        <43.000000, 0.810911, -74.175797>,
        < 43.000000, 1.441343, -73.209595>
      }
      triangle {
        <26.625000, -0.024248, -74.971802>,
        <43.000000, 0.810911, -74.175797>,
        < 26.625000, 0.810873, -74.175797>
      }
      triangle {
        <26.625000, 1.441343, -73.209595>,
        <43.000000, 1.441343, -73.209595>,
        < 43.000000, 1.833552, -72.124695>
      }
      triangle {
        <26.625000, 0.810873, -74.175797>,
        <43.000000, 1.441343, -73.209595>,
        < 26.625000, 1.441343, -73.209595>
      }
      triangle {
        <26.625000, 1.833563, -72.124695>,
        <43.000000, 1.833552, -72.124695>,
        < 43.000000, 1.966673, -70.978699>
      }
      triangle {
        <26.625000, 1.441343, -73.209595>,
        <43.000000, 1.833552, -72.124695>,
        < 26.625000, 1.833563, -72.124695>
      }
      triangle {
        <26.625000, 1.966673, -70.978699>,
        <43.000000, 1.966673, -70.978699>,
        < 43.000000, 1.966673, -48.656906>
      }
      triangle {
        <26.625000, 1.833563, -72.124695>,
        <43.000000, 1.966673, -70.978699>,
        < 26.625000, 1.966673, -70.978699>
      }
      triangle {
        <26.625000, 1.966673, -48.656906>,
        <43.000000, 1.966673, -48.656906>,
        < 43.000000, 1.838514, -47.532104>
      }
      triangle {
        <26.625000, 1.966673, -70.978699>,
        <43.000000, 1.966673, -48.656906>,
        < 26.625000, 1.966673, -48.656906>
      }
      triangle {
        <26.625000, 1.838514, -47.532104>,
        <43.000000, 1.838514, -47.532104>,
        < 43.000000, 1.460634, -46.464996>
      }
      triangle {
        <26.625000, 1.966673, -48.656906>,
        <43.000000, 1.838514, -47.532104>,
        < 26.625000, 1.838514, -47.532104>
      }
      triangle {
        <26.625000, 1.460665, -46.465103>,
        <43.000000, 1.460634, -46.464996>,
        < 43.000000, 0.852411, -45.510300>
      }
      triangle {
        <26.625000, 1.838514, -47.532104>,
        <43.000000, 1.460634, -46.464996>,
        < 26.625000, 1.460665, -46.465103>
      }
      triangle {
        <26.625000, 0.852362, -45.510300>,
        <43.000000, 0.852411, -45.510300>,
        < 43.000000, 0.045012, -44.716904>
      }
      triangle {
        <26.625000, 1.460665, -46.465103>,
        <43.000000, 0.852411, -45.510300>,
        < 26.625000, 0.852362, -45.510300>
      }
      triangle {
        <26.625000, 0.044993, -44.716904>,
        <43.000000, 0.045012, -44.716904>,
        < 43.000000, -0.920236, -44.125397>
      }
      triangle {
        <26.625000, 0.852362, -45.510300>,
        <43.000000, 0.045012, -44.716904>,
        < 26.625000, 0.044993, -44.716904>
      }
      triangle {
        <26.625000, -13.087498, -38.451706>,
        <43.000000, -0.920236, -44.125397>,
        < 43.000000, -15.414278, -37.366699>
      }
      triangle {
        <26.625000, -13.087498, -38.451706>,
        <26.625000, -0.920236, -44.125397>,
        < 43.000000, -0.920236, -44.125397>
      }
      triangle {
        <26.625000, 0.044993, -44.716904>,
        <43.000000, -0.920236, -44.125397>,
        < 26.625000, -0.920236, -44.125397>
      }
      triangle {
        <-43.000000, -16.945476, -36.430603>,
        <43.000000, -15.414278, -37.366699>,
        < 43.000000, -16.958576, -36.420303>
      }
      triangle {
        <-43.000000, -15.414278, -37.366699>,
        <43.000000, -15.414278, -37.366699>,
        < -43.000000, -16.945476, -36.430603>
      }
      triangle {
        <26.625000, -13.087498, -38.451706>,
        <43.000000, -15.414278, -37.366699>,
        < -43.000000, -15.414278, -37.366699>
      }
      triangle {
        <-43.000000, -18.245277, -35.157204>,
        <43.000000, -16.958576, -36.420303>,
        < 43.000000, -18.250477, -35.150803>
      }
      triangle {
        <-43.000000, -16.945476, -36.430603>,
        <43.000000, -16.958576, -36.420303>,
        < -43.000000, -18.245277, -35.157204>
      }
      triangle {
        <-43.000000, -18.245277, -35.157204>,
        <43.000000, -18.250477, -35.150803>,
        < 43.000000, -19.223686, -33.623199>
      }
      triangle {
        <-43.000000, -19.227297, -33.615799>,
        <43.000000, -19.223686, -33.623199>,
        < 43.000000, -19.828297, -31.915802>
      }
      triangle {
        <-43.000000, -18.245277, -35.157204>,
        <43.000000, -19.223686, -33.623199>,
        < -43.000000, -19.227297, -33.615799>
      }
      triangle {
        <-43.000000, -19.832006, -31.899597>,
        <43.000000, -19.828297, -31.915802>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -19.227297, -33.615799>,
        <43.000000, -19.828297, -31.915802>,
        < -43.000000, -19.832006, -31.899597>
      }
      triangle {
        <17.500000, -20.033327, 45.500000>,
        <43.000000, -20.033327, -30.116203>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <-43.000000, -20.033327, -30.116203>,
        <43.000000, -20.033327, -30.116203>,
        < -43.000000, -20.033327, 45.500000>
      }
      triangle {
        <-17.500000, -20.033327, 45.500000>,
        <-43.000000, -20.033327, 45.500000>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -19.832006, -31.899597>,
        <43.000000, -20.033327, -30.116203>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-17.500000, -20.033327, 48.500000>,
        <-17.500000, -20.033327, 45.500000>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <17.500000, -20.033327, 45.500000>,
        <-17.500000, -20.033327, 48.500000>,
        < 43.000000, -20.033327, -30.116203>
      }
      triangle {
        <17.500000, -0.033327, 56.134190>,
        <43.000000, -20.033327, 45.500000>,
        < 43.000000, -0.033327, 56.134190>
      }
      triangle {
        <17.500000, -0.033327, 56.134190>,
        <17.500000, -20.033327, 45.500000>,
        < 43.000000, -20.033327, 45.500000>
      }
      triangle {
        <17.500000, -0.033327, 56.134190>,
        <43.000000, -0.033327, 56.134190>,
        < 43.000000, 0.442461, 56.411018>
      }
      triangle {
        <17.500000, 0.457281, 56.420490>,
        <43.000000, 0.442461, 56.411018>,
        < 43.000000, 0.895712, 56.729870>
      }
      triangle {
        <17.500000, 0.457281, 56.420490>,
        <17.500000, -0.033327, 56.134190>,
        < 43.000000, 0.442461, 56.411018>
      }
      triangle {
        <17.500000, 0.923372, 56.751560>,
        <43.000000, 0.895712, 56.729870>,
        < 43.000000, 1.311014, 57.092030>
      }
      triangle {
        <17.500000, 0.923372, 56.751560>,
        <17.500000, 0.457281, 56.420490>,
        < 43.000000, 0.895712, 56.729870>
      }
      triangle {
        <17.500000, 1.348032, 57.128819>,
        <43.000000, 1.311014, 57.092030>,
        < 43.000000, 1.672941, 57.498779>
      }
      triangle {
        <17.500000, 1.348032, 57.128819>,
        <17.500000, 0.923372, 56.751560>,
        < 43.000000, 1.311014, 57.092030>
      }
      triangle {
        <17.500000, 1.714312, 57.553692>,
        <43.000000, 1.672941, 57.498779>,
        < 43.000000, 1.969862, 57.949940>
      }
      triangle {
        <17.500000, 1.714312, 57.553692>,
        <17.500000, 1.348032, 57.128819>,
        < 43.000000, 1.672941, 57.498779>
      }
      triangle {
        <17.500000, 2.011313, 58.025211>,
        <43.000000, 1.969862, 57.949940>,
        < 43.000000, 2.208574, 58.438068>
      }
      triangle {
        <17.500000, 2.011313, 58.025211>,
        <17.500000, 1.714312, 57.553692>,
        < 43.000000, 1.969862, 57.949940>
      }
      triangle {
        <17.500000, 2.248514, 58.534430>,
        <43.000000, 2.208574, 58.438068>,
        < 43.000000, 2.401781, 58.953430>
      }
      triangle {
        <17.500000, 2.248514, 58.534430>,
        <17.500000, 2.011313, 58.025211>,
        < 43.000000, 2.208574, 58.438068>
      }
      triangle {
        <17.500000, 2.439814, 59.070660>,
        <43.000000, 2.401781, 58.953430>,
        < 43.000000, 2.562124, 59.486271>
      }
      triangle {
        <17.500000, 2.439814, 59.070660>,
        <17.500000, 2.248514, 58.534430>,
        < 43.000000, 2.401781, 58.953430>
      }
      triangle {
        <17.500000, 2.599135, 59.623211>,
        <43.000000, 2.562124, 59.486271>,
        < 43.000000, 2.702204, 60.026920>
      }
      triangle {
        <17.500000, 2.599135, 59.623211>,
        <17.500000, 2.439814, 59.070660>,
        < 43.000000, 2.562124, 59.486271>
      }
      triangle {
        <17.500000, 2.739912, 60.181740>,
        <43.000000, 2.702204, 60.026920>,
        < 43.000000, 2.830172, 60.569189>
      }
      triangle {
        <17.500000, 2.739912, 60.181740>,
        <17.500000, 2.599135, 59.623211>,
        < 43.000000, 2.702204, 60.026920>
      }
      triangle {
        <17.500000, 2.868471, 60.741550>,
        <43.000000, 2.830172, 60.569189>,
        < 43.000000, 2.947134, 61.112431>
      }
      triangle {
        <17.500000, 2.868471, 60.741550>,
        <17.500000, 2.739912, 60.181740>,
        < 43.000000, 2.830172, 60.569189>
      }
      triangle {
        <17.500000, 2.985472, 61.302330>,
        <43.000000, 2.947134, 61.112431>,
        < 43.000000, 3.053583, 61.656490>
      }
      triangle {
        <17.500000, 2.985472, 61.302330>,
        <17.500000, 2.868471, 60.741550>,
        < 43.000000, 2.947134, 61.112431>
      }
      triangle {
        <17.500000, 3.091463, 61.863939>,
        <43.000000, 3.053583, 61.656490>,
        < 43.000000, 3.149992, 62.201229>
      }
      triangle {
        <17.500000, 3.091463, 61.863939>,
        <17.500000, 2.985472, 61.302330>,
        < 43.000000, 3.053583, 61.656490>
      }
      triangle {
        <17.500000, 3.186983, 62.426201>,
        <43.000000, 3.149992, 62.201229>,
        < 43.000000, 3.236872, 62.746481>
      }
      triangle {
        <17.500000, 3.186983, 62.426201>,
        <17.500000, 3.091463, 61.863939>,
        < 43.000000, 3.149992, 62.201229>
      }
      triangle {
        <17.500000, 3.272543, 62.988939>,
        <43.000000, 3.236872, 62.746481>,
        < 43.000000, 3.314684, 63.292089>
      }
      triangle {
        <17.500000, 3.272543, 62.988939>,
        <17.500000, 3.186983, 62.426201>,
        < 43.000000, 3.236872, 62.746481>
      }
      triangle {
        <17.500000, 3.348692, 63.551991>,
        <43.000000, 3.314684, 63.292089>,
        < 43.000000, 3.383925, 63.837919>
      }
      triangle {
        <17.500000, 3.348692, 63.551991>,
        <17.500000, 3.272543, 62.988939>,
        < 43.000000, 3.314684, 63.292089>
      }
      triangle {
        <17.500000, 3.415964, 64.115200>,
        <43.000000, 3.383925, 63.837919>,
        < 43.000000, 3.445063, 64.383801>
      }
      triangle {
        <17.500000, 3.415964, 64.115200>,
        <17.500000, 3.348692, 63.551991>,
        < 43.000000, 3.383925, 63.837919>
      }
      triangle {
        <17.500000, 3.474875, 64.678379>,
        <43.000000, 3.445063, 64.383801>,
        < 43.000000, 3.498613, 64.929600>
      }
      triangle {
        <17.500000, 3.474875, 64.678379>,
        <17.500000, 3.415964, 64.115200>,
        < 43.000000, 3.445063, 64.383801>
      }
      triangle {
        <17.500000, 3.525984, 65.241381>,
        <43.000000, 3.498613, 64.929600>,
        < 43.000000, 3.545035, 65.475149>
      }
      triangle {
        <17.500000, 3.525984, 65.241381>,
        <17.500000, 3.474875, 64.678379>,
        < 43.000000, 3.498613, 64.929600>
      }
      triangle {
        <17.500000, 3.569803, 65.804029>,
        <43.000000, 3.545035, 65.475149>,
        < 43.000000, 3.584833, 66.020300>
      }
      triangle {
        <17.500000, 3.569803, 65.804029>,
        <17.500000, 3.525984, 65.241381>,
        < 43.000000, 3.545035, 65.475149>
      }
      triangle {
        <17.500000, 3.606875, 66.366150>,
        <43.000000, 3.584833, 66.020300>,
        < 43.000000, 3.618471, 66.564899>
      }
      triangle {
        <17.500000, 3.606875, 66.366150>,
        <17.500000, 3.569803, 65.804029>,
        < 43.000000, 3.584833, 66.020300>
      }
      triangle {
        <17.500000, 3.637724, 66.927589>,
        <43.000000, 3.618471, 66.564899>,
        < 43.000000, 3.646452, 67.108810>
      }
      triangle {
        <17.500000, 3.637724, 66.927589>,
        <17.500000, 3.606875, 66.366150>,
        < 43.000000, 3.618471, 66.564899>
      }
      triangle {
        <17.500000, 3.662893, 67.488180>,
        <43.000000, 3.646452, 67.108810>,
        < 43.000000, 3.669252, 67.651850>
      }
      triangle {
        <17.500000, 3.662893, 67.488180>,
        <17.500000, 3.637724, 66.927589>,
        < 43.000000, 3.646452, 67.108810>
      }
      triangle {
        <17.500000, 3.682913, 68.047741>,
        <43.000000, 3.669252, 67.651850>,
        < 43.000000, 3.687365, 68.193899>
      }
      triangle {
        <17.500000, 3.682913, 68.047741>,
        <17.500000, 3.662893, 67.488180>,
        < 43.000000, 3.669252, 67.651850>
      }
      triangle {
        <17.500000, 3.698313, 68.606110>,
        <43.000000, 3.687365, 68.193899>,
        < 43.000000, 3.701262, 68.734779>
      }
      triangle {
        <17.500000, 3.698313, 68.606110>,
        <17.500000, 3.682913, 68.047741>,
        < 43.000000, 3.687365, 68.193899>
      }
      triangle {
        <17.500000, 3.709623, 69.163130>,
        <43.000000, 3.701262, 68.734779>,
        < 43.000000, 3.711443, 69.274361>
      }
      triangle {
        <17.500000, 3.709623, 69.163130>,
        <17.500000, 3.698313, 68.606110>,
        < 43.000000, 3.701262, 68.734779>
      }
      triangle {
        <17.500000, 3.717383, 69.718620>,
        <43.000000, 3.711443, 69.274361>,
        < 43.000000, 3.718382, 69.812469>
      }
      triangle {
        <17.500000, 3.717383, 69.718620>,
        <17.500000, 3.709623, 69.163130>,
        < 43.000000, 3.711443, 69.274361>
      }
      triangle {
        <17.500000, 3.722124, 70.272421>,
        <43.000000, 3.718382, 69.812469>,
        < 43.000000, 3.722574, 70.348961>
      }
      triangle {
        <17.500000, 3.722124, 70.272421>,
        <17.500000, 3.717383, 69.718620>,
        < 43.000000, 3.718382, 69.812469>
      }
      triangle {
        <17.500000, 3.724344, 70.824400>,
        <43.000000, 3.722574, 70.348961>,
        < 43.000000, 3.724432, 70.883739>
      }
      triangle {
        <17.500000, 3.724344, 70.824400>,
        <17.500000, 3.722124, 70.272421>,
        < 43.000000, 3.722574, 70.348961>
      }
      triangle {
        <17.500000, 3.723833, 71.374920>,
        <43.000000, 3.724432, 70.883739>,
        < 43.000000, 3.723662, 71.417231>
      }
      triangle {
        <17.500000, 3.723833, 71.374920>,
        <17.500000, 3.724344, 70.824400>,
        < 43.000000, 3.724432, 70.883739>
      }
      triangle {
        <17.500000, 3.719881, 71.924770>,
        <43.000000, 3.723662, 71.417231>,
        < 43.000000, 3.719603, 71.950150>
      }
      triangle {
        <17.500000, 3.719881, 71.924770>,
        <17.500000, 3.723833, 71.374920>,
        < 43.000000, 3.723662, 71.417231>
      }
      triangle {
        <17.500000, 3.711722, 72.474739>,
        <43.000000, 3.719603, 71.950150>,
        < 43.000000, 3.711554, 72.483210>
      }
      triangle {
        <17.500000, 3.711722, 72.474739>,
        <17.500000, 3.719881, 71.924770>,
        < 43.000000, 3.719603, 71.950150>
      }
      triangle {
        <17.500000, 3.711722, 72.474739>,
        <43.000000, 3.711554, 72.483210>,
        < 43.000000, 3.698855, 73.017130>
      }
      triangle {
        <17.500000, 3.698614, 73.025620>,
        <43.000000, 3.698855, 73.017130>,
        < 43.000000, 3.680803, 73.552650>
      }
      triangle {
        <17.500000, 3.698614, 73.025620>,
        <17.500000, 3.711722, 72.474739>,
        < 43.000000, 3.698855, 73.017130>
      }
      triangle {
        <17.500000, 3.679804, 73.578199>,
        <43.000000, 3.680803, 73.552650>,
        < 43.000000, 3.656733, 74.090460>
      }
      triangle {
        <17.500000, 3.679804, 73.578199>,
        <17.500000, 3.698614, 73.025620>,
        < 43.000000, 3.680803, 73.552650>
      }
      triangle {
        <17.500000, 3.654543, 74.133270>,
        <43.000000, 3.656733, 74.090460>,
        < 43.000000, 3.625944, 74.631310>
      }
      triangle {
        <17.500000, 3.654543, 74.133270>,
        <17.500000, 3.679804, 73.578199>,
        < 43.000000, 3.656733, 74.090460>
      }
      triangle {
        <17.500000, 3.622084, 74.691630>,
        <43.000000, 3.625944, 74.631310>,
        < 43.000000, 3.587774, 75.175910>
      }
      triangle {
        <17.500000, 3.622084, 74.691630>,
        <17.500000, 3.654543, 74.133270>,
        < 43.000000, 3.625944, 74.631310>
      }
      triangle {
        <17.500000, 3.581675, 75.254060>,
        <43.000000, 3.587774, 75.175910>,
        < 43.000000, 3.541521, 75.724980>
      }
      triangle {
        <17.500000, 3.581675, 75.254060>,
        <17.500000, 3.622084, 74.691630>,
        < 43.000000, 3.587774, 75.175910>
      }
      triangle {
        <17.500000, 3.532572, 75.821360>,
        <43.000000, 3.541521, 75.724980>,
        < 43.000000, 3.486525, 76.279230>
      }
      triangle {
        <17.500000, 3.532572, 75.821360>,
        <17.500000, 3.581675, 75.254060>,
        < 43.000000, 3.541521, 75.724980>
      }
      triangle {
        <17.500000, 3.474024, 76.394310>,
        <43.000000, 3.486525, 76.279230>,
        < 43.000000, 3.422083, 76.839400>
      }
      triangle {
        <17.500000, 3.474024, 76.394310>,
        <17.500000, 3.532572, 75.821360>,
        < 43.000000, 3.486525, 76.279230>
      }
      triangle {
        <17.500000, 3.405272, 76.973720>,
        <43.000000, 3.422083, 76.839400>,
        < 43.000000, 3.347525, 77.406200>
      }
      triangle {
        <17.500000, 3.405272, 76.973720>,
        <17.500000, 3.474024, 76.394310>,
        < 43.000000, 3.422083, 76.839400>
      }
      triangle {
        <17.500000, 3.325583, 77.560370>,
        <43.000000, 3.347525, 77.406200>,
        < 43.000000, 3.262163, 77.980340>
      }
      triangle {
        <17.500000, 3.325583, 77.560370>,
        <17.500000, 3.405272, 76.973720>,
        < 43.000000, 3.347525, 77.406200>
      }
      triangle {
        <17.500000, 3.234163, 78.154950>,
        <43.000000, 3.262163, 77.980340>,
        < 43.000000, 3.164793, 78.561080>
      }
      triangle {
        <17.500000, 3.234163, 78.154950>,
        <17.500000, 3.325583, 77.560370>,
        < 43.000000, 3.262163, 77.980340>
      }
      triangle {
        <17.500000, 3.129263, 78.755440>,
        <43.000000, 3.164793, 78.561080>,
        < 43.000000, 3.053042, 79.144340>
      }
      triangle {
        <17.500000, 3.129263, 78.755440>,
        <17.500000, 3.234163, 78.154950>,
        < 43.000000, 3.164793, 78.561080>
      }
      triangle {
        <17.500000, 3.008162, 79.357000>,
        <43.000000, 3.053042, 79.144340>,
        < 43.000000, 2.924383, 79.725560>
      }
      triangle {
        <17.500000, 3.008162, 79.357000>,
        <17.500000, 3.129263, 78.755440>,
        < 43.000000, 3.053042, 79.144340>
      }
      triangle {
        <17.500000, 2.868075, 79.954640>,
        <43.000000, 2.924383, 79.725560>,
        < 43.000000, 2.776262, 80.300230>
      }
      triangle {
        <17.500000, 2.868075, 79.954640>,
        <17.500000, 3.008162, 79.357000>,
        < 43.000000, 2.924383, 79.725560>
      }
      triangle {
        <17.500000, 2.706202, 80.543374>,
        <43.000000, 2.776262, 80.300230>,
        < 43.000000, 2.606154, 80.863780>
      }
      triangle {
        <17.500000, 2.706202, 80.543374>,
        <17.500000, 2.868075, 79.954640>,
        < 43.000000, 2.776262, 80.300230>
      }
      triangle {
        <17.500000, 2.519755, 81.118214>,
        <43.000000, 2.606154, 80.863780>,
        < 43.000000, 2.411512, 81.411689>
      }
      triangle {
        <17.500000, 2.519755, 81.118214>,
        <17.500000, 2.706202, 80.543374>,
        < 43.000000, 2.606154, 80.863780>
      }
      triangle {
        <17.500000, 2.305964, 81.674171>,
        <43.000000, 2.411512, 81.411689>,
        < 43.000000, 2.189802, 81.939413>
      }
      triangle {
        <17.500000, 2.305964, 81.674171>,
        <17.500000, 2.519755, 81.118214>,
        < 43.000000, 2.411512, 81.411689>
      }
      triangle {
        <17.500000, 2.062021, 82.206259>,
        <43.000000, 2.189802, 81.939413>,
        < 43.000000, 1.938501, 82.442412>
      }
      triangle {
        <17.500000, 2.062021, 82.206259>,
        <17.500000, 2.305964, 81.674171>,
        < 43.000000, 2.189802, 81.939413>
      }
      triangle {
        <17.500000, 1.785154, 82.709499>,
        <43.000000, 1.938501, 82.442412>,
        < 43.000000, 1.655054, 82.916145>
      }
      triangle {
        <17.500000, 1.785154, 82.709499>,
        <17.500000, 2.062021, 82.206259>,
        < 43.000000, 1.938501, 82.442412>
      }
      triangle {
        <17.500000, 1.472582, 83.178902>,
        <43.000000, 1.655054, 82.916145>,
        < 43.000000, 1.336931, 83.356071>
      }
      triangle {
        <17.500000, 1.472582, 83.178902>,
        <17.500000, 1.785154, 82.709499>,
        < 43.000000, 1.655054, 82.916145>
      }
      triangle {
        <17.500000, 1.121504, 83.609479>,
        <43.000000, 1.336931, 83.356071>,
        < 43.000000, 0.981592, 83.757650>
      }
      triangle {
        <17.500000, 1.121504, 83.609479>,
        <17.500000, 1.472582, 83.178902>,
        < 43.000000, 1.336931, 83.356071>
      }
      triangle {
        <17.500000, 0.729143, 83.996241>,
        <43.000000, 0.981592, 83.757650>,
        < 43.000000, 0.586504, 84.116342>
      }
      triangle {
        <17.500000, 0.729143, 83.996241>,
        <17.500000, 1.121504, 83.609479>,
        < 43.000000, 0.981592, 83.757650>
      }
      triangle {
        <17.500000, 0.292704, 84.334203>,
        <43.000000, 0.586504, 84.116342>,
        < 43.000000, 0.149122, 84.427606>
      }
      triangle {
        <17.500000, 0.292704, 84.334203>,
        <17.500000, 0.729143, 83.996241>,
        < 43.000000, 0.586504, 84.116342>
      }
      triangle {
        <17.500000, -0.190588, 84.618377>,
        <43.000000, 0.149122, 84.427606>,
        < 43.000000, -0.332968, 84.687035>
      }
      triangle {
        <17.500000, -0.190588, 84.618377>,
        <17.500000, 0.292704, 84.334203>,
        < 43.000000, 0.149122, 84.427606>
      }
      triangle {
        <17.500000, -0.719168, 84.849106>,
        <43.000000, -0.332968, 84.687035>,
        < 43.000000, -0.854288, 84.899877>
      }
      triangle {
        <17.500000, -0.719168, 84.849106>,
        <17.500000, -0.190588, 84.618377>,
        < 43.000000, -0.332968, 84.687035>
      }
      triangle {
        <17.500000, -1.274916, 85.046847>,
        <43.000000, -0.854288, 84.899877>,
        < 43.000000, -1.396017, 85.087590>
      }
      triangle {
        <17.500000, -1.274916, 85.046847>,
        <17.500000, -0.719168, 84.849106>,
        < 43.000000, -0.854288, 84.899877>
      }
      triangle {
        <17.500000, -1.835768, 85.236915>,
        <43.000000, -1.396017, 85.087590>,
        < 43.000000, -1.938085, 85.273198>
      }
      triangle {
        <17.500000, -1.835768, 85.236915>,
        <17.500000, -1.274916, 85.046847>,
        < 43.000000, -1.396017, 85.087590>
      }
      triangle {
        <17.500000, -2.379637, 85.444604>,
        <43.000000, -1.938085, 85.273198>,
        < 43.000000, -2.460398, 85.479724>
      }
      triangle {
        <17.500000, -2.379637, 85.444604>,
        <17.500000, -1.835768, 85.236915>,
        < 43.000000, -1.938085, 85.273198>
      }
      triangle {
        <17.500000, -2.884497, 85.695171>,
        <43.000000, -2.460398, 85.479724>,
        < 43.000000, -2.942865, 85.730193>
      }
      triangle {
        <17.500000, -2.884497, 85.695171>,
        <17.500000, -2.379637, 85.444604>,
        < 43.000000, -2.460398, 85.479724>
      }
      triangle {
        <17.500000, -3.328287, 86.013895>,
        <43.000000, -2.942865, 85.730193>,
        < 43.000000, -3.365415, 86.047628>
      }
      triangle {
        <17.500000, -3.328287, 86.013895>,
        <17.500000, -2.884497, 85.695171>,
        < 43.000000, -2.942865, 85.730193>
      }
      triangle {
        <17.500000, -3.688978, 86.426142>,
        <43.000000, -3.365415, 86.047628>,
        < 43.000000, -3.707956, 86.455088>
      }
      triangle {
        <17.500000, -3.688978, 86.426142>,
        <17.500000, -3.328287, 86.013895>,
        < 43.000000, -3.365415, 86.047628>
      }
      triangle {
        <17.500000, -3.939089, 86.939077>,
        <43.000000, -3.707956, 86.455088>,
        < 43.000000, -3.944555, 86.955949>
      }
      triangle {
        <17.500000, -3.939089, 86.939077>,
        <17.500000, -3.688978, 86.426142>,
        < 43.000000, -3.707956, 86.455088>
      }
      triangle {
        <17.500000, -3.939089, 86.939077>,
        <43.000000, -3.944555, 86.955949>,
        < 43.000000, -4.033327, 87.500000>
      }
      triangle {
        <17.500000, -4.033327, 89.500000>,
        <43.000000, -4.033327, 87.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <17.500000, -4.033327, 89.500000>,
        <17.500000, -4.033327, 87.500000>,
        < 43.000000, -4.033327, 87.500000>
      }
      triangle {
        <17.500000, -3.939089, 86.939077>,
        <43.000000, -4.033327, 87.500000>,
        < 17.500000, -4.033327, 87.500000>
      }
      triangle {
        <27.000000, 5.216673, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < 43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-25.000000, -3.408327, 90.500000>,
        <-43.000000, -4.033327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <17.500000, -4.033327, 89.500000>,
        <43.000000, -4.033327, 90.500000>,
        < -43.000000, -4.033327, 90.500000>
      }
      triangle {
        <27.000000, 5.216673, 90.500000>,
        <26.516411, 5.466673, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <26.375000, 3.966673, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < 26.516411, 5.466673, 90.500000>
      }
      triangle {
        <-4.739519, -3.010527, 90.500000>,
        <-5.260481, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-9.739519, -3.010527, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < -5.260481, -3.010527, 90.500000>
      }
      triangle {
        <-0.260481, -3.010527, 90.500000>,
        <-4.739519, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <0.260481, -3.010527, 90.500000>,
        <-0.260481, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <0.260481, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-9.739519, -3.010527, 90.500000>,
        <-10.260480, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-14.739520, -3.010527, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < -10.260480, -3.010527, 90.500000>
      }
      triangle {
        <-14.739520, -3.010527, 90.500000>,
        <-15.260480, -3.010527, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-18.191790, -3.145716, 90.500000>,
        <43.000000, -4.033327, 90.500000>,
        < -15.260480, -3.010527, 90.500000>
      }
      triangle {
        <-19.000000, -3.408327, 90.500000>,
        <-25.000000, -3.408327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-18.575069, -3.341017, 90.500000>,
        <-19.000000, -3.408327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-18.191790, -3.145716, 90.500000>,
        <-18.575069, -3.341017, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <25.000000, -3.408327, 90.500000>,
        <19.000000, -3.408327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <25.424931, -3.341017, 90.500000>,
        <25.000000, -3.408327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <25.808210, -3.145716, 90.500000>,
        <25.424931, -3.341017, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <26.112391, -2.841535, 90.500000>,
        <25.808210, -3.145716, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <26.307690, -2.458258, 90.500000>,
        <26.112391, -2.841535, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <26.375000, -2.033327, 90.500000>,
        <26.307690, -2.458258, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <26.375000, 3.966673, 90.500000>,
        <26.375000, -2.033327, 90.500000>,
        < 43.000000, -4.033327, 90.500000>
      }
      triangle {
        <27.000000, 5.216673, 90.500000>,
        <43.000000, 5.216673, 90.500000>,
        < 43.000000, 7.156504, 83.663294>
      }
      triangle {
        <28.635189, 7.150034, 83.689576>,
        <43.000000, 7.156504, 83.663294>,
        < 43.000000, 8.643702, 76.703710>
      }
      triangle {
        <27.187210, 5.948801, 88.137509>,
        <27.000000, 5.216673, 90.500000>,
        < 43.000000, 7.156504, 83.663294>
      }
      triangle {
        <27.736410, 6.591734, 85.857808>,
        <43.000000, 7.156504, 83.663294>,
        < 28.635189, 7.150034, 83.689576>
      }
      triangle {
        <27.187210, 5.948801, 88.137509>,
        <43.000000, 7.156504, 83.663294>,
        < 27.736410, 6.591734, 85.857808>
      }
      triangle {
        <32.643002, 8.802813, 75.824640>,
        <43.000000, 8.643702, 76.703710>,
        < 43.000000, 9.770002, 69.664591>
      }
      triangle {
        <28.635189, 7.150034, 83.689576>,
        <43.000000, 8.643702, 76.703710>,
        < 32.643002, 8.802813, 75.824640>
      }
      triangle {
        <37.394619, 10.181414, 66.500019>,
        <43.000000, 9.770002, 69.664591>,
        < 43.000000, 10.625933, 62.588591>
      }
      triangle {
        <32.643002, 8.802813, 75.824640>,
        <43.000000, 9.770002, 69.664591>,
        < 37.394619, 10.181414, 66.500019>
      }
      triangle {
        <37.394619, 10.181414, 66.500019>,
        <43.000000, 10.625933, 62.588591>,
        < 43.000000, 11.267313, 55.500000>
      }
      triangle {
        <37.106319, 11.081194, 67.065781>,
        <43.000000, 11.267313, 55.500000>,
        < 43.000000, 12.460924, 55.500000>
      }
      triangle {
        <37.394619, 10.181414, 66.500019>,
        <43.000000, 11.267313, 55.500000>,
        < 37.106319, 11.081194, 67.065781>
      }
      triangle {
        <25.143909, 13.250513, 45.084080>,
        <43.000000, 12.460924, 55.500000>,
        < 43.000000, 13.280882, 44.509762>
      }
      triangle {
        <25.320721, 12.247774, 57.602242>,
        <43.000000, 12.460924, 55.500000>,
        < 25.143909, 13.250513, 45.084080>
      }
      triangle {
        <37.106319, 11.081194, 67.065781>,
        <43.000000, 12.460924, 55.500000>,
        < 25.320721, 12.247774, 57.602242>
      }
      triangle {
        <25.143909, 13.250513, 45.084080>,
        <43.000000, 13.280882, 44.509762>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <42.959068, 15.942305, 33.500000>,
        <43.000000, 13.566671, 33.500000>,
        < 43.000000, 14.066671, 33.500000>
      }
      triangle {
        <25.143909, 13.250513, 45.084080>,
        <43.000000, 13.566671, 33.500000>,
        < 25.088160, 13.566671, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <25.088160, 13.566671, 33.500000>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <41.647572, 31.402456, 33.500000>,
        <41.389408, 32.608305, 33.500000>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <43.000000, 13.566671, 33.500000>,
        < 41.389408, 32.608305, 33.500000>
      }
      triangle {
        <42.836369, 17.814371, 33.500000>,
        <41.647572, 31.402456, 33.500000>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <42.959068, 15.942305, 33.500000>,
        <42.836369, 17.814371, 33.500000>,
        < 43.000000, 13.566671, 33.500000>
      }
      triangle {
        <-43.000000, 7.767363, -2.000000>,
        <-43.000000, 14.066671, -2.000000>,
        < -43.000000, 14.066671, -5.000000>
      }
      triangle {
        <-42.959068, 15.942305, -2.000000>,
        <-43.000000, 14.066671, -5.000000>,
        < -43.000000, 14.066671, -2.000000>
      }
      triangle {
        <-43.000000, -12.033327, 6.000000>,
        <-43.000000, 7.767363, -2.000000>,
        < -43.000000, 14.066671, -5.000000>
      }
      triangle {
        <-43.000000, -12.033327, -5.000000>,
        <-43.000000, -12.033327, 6.000000>,
        < -43.000000, 14.066671, -5.000000>
      }
      triangle {
        <-42.959068, 15.942305, -2.000000>,
        <-42.959068, 15.942305, -5.000000>,
        < -43.000000, 14.066671, -5.000000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, -12.033327, 30.500000>,
        < -43.000000, -12.033327, 6.000000>
      }
      triangle {
        <-43.000000, -12.033327, -5.000000>,
        <-43.000000, -20.033327, 45.500000>,
        < -43.000000, -12.033327, 6.000000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, 14.066671, 30.500000>,
        < -43.000000, -12.033327, 30.500000>
      }
      triangle {
        <-43.000000, 13.566671, 33.500000>,
        <-43.000000, 14.066671, 33.500000>,
        < -43.000000, 14.066671, 30.500000>
      }
      triangle {
        <-42.959068, 15.942305, 33.500000>,
        <-43.000000, 14.066671, 30.500000>,
        < -43.000000, 14.066671, 33.500000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, 13.566671, 33.500000>,
        < -43.000000, 14.066671, 30.500000>
      }
      triangle {
        <-42.959068, 15.942305, 33.500000>,
        <-42.959068, 15.942305, 30.500000>,
        < -43.000000, 14.066671, 30.500000>
      }
      triangle {
        <-25.088160, 13.566671, 33.500000>,
        <-43.000000, 14.066671, 33.500000>,
        < -43.000000, 13.566671, 33.500000>
      }
      triangle {
        <-42.959068, 15.942305, 33.500000>,
        <-43.000000, 14.066671, 33.500000>,
        < -25.088160, 13.566671, 33.500000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, 13.280882, 44.509762>,
        < -43.000000, 13.566671, 33.500000>
      }
      triangle {
        <-25.088160, 13.566671, 33.500000>,
        <-43.000000, 13.566671, 33.500000>,
        < -43.000000, 13.280882, 44.509762>
      }
      triangle {
        <-43.000000, 11.267313, 55.500000>,
        <-43.000000, 12.460924, 55.500000>,
        < -43.000000, 13.280882, 44.509762>
      }
      triangle {
        <-25.143909, 13.250513, 45.084080>,
        <-43.000000, 13.280882, 44.509762>,
        < -43.000000, 12.460924, 55.500000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, 11.267313, 55.500000>,
        < -43.000000, 13.280882, 44.509762>
      }
      triangle {
        <-25.088160, 13.566671, 33.500000>,
        <-43.000000, 13.280882, 44.509762>,
        < -25.143909, 13.250513, 45.084080>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-43.000000, 12.460924, 55.500000>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-25.143909, 13.250513, 45.084080>,
        <-43.000000, 12.460924, 55.500000>,
        < -25.320721, 12.247774, 57.602242>
      }
      triangle {
        <-37.106319, 11.081194, 67.065781>,
        <-25.320721, 12.247774, 57.602242>,
        < -43.000000, 12.460924, 55.500000>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-37.106319, 11.081194, 67.065781>,
        < -43.000000, 12.460924, 55.500000>
      }
      triangle {
        <-43.000000, 3.149992, 62.201229>,
        <-43.000000, 10.625933, 62.588591>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-43.000000, 11.267313, 55.500000>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.053583, 61.656490>,
        <-43.000000, 3.149992, 62.201229>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.947134, 61.112431>,
        <-43.000000, 3.053583, 61.656490>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.830172, 60.569189>,
        <-43.000000, 2.947134, 61.112431>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.702204, 60.026920>,
        <-43.000000, 2.830172, 60.569189>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.562124, 59.486271>,
        <-43.000000, 2.702204, 60.026920>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.401781, 58.953430>,
        <-43.000000, 2.562124, 59.486271>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 2.208574, 58.438068>,
        <-43.000000, 2.401781, 58.953430>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 1.969862, 57.949940>,
        <-43.000000, 2.208574, 58.438068>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 1.672941, 57.498779>,
        <-43.000000, 1.969862, 57.949940>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 1.311014, 57.092030>,
        <-43.000000, 1.672941, 57.498779>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 0.895712, 56.729870>,
        <-43.000000, 1.311014, 57.092030>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 0.442461, 56.411018>,
        <-43.000000, 0.895712, 56.729870>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, -0.033327, 56.134190>,
        <-43.000000, 0.442461, 56.411018>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, -20.033327, 45.500000>,
        <-43.000000, -0.033327, 56.134190>,
        < -43.000000, 11.267313, 55.500000>
      }
      triangle {
        <-43.000000, 3.711443, 69.274361>,
        <-43.000000, 9.770002, 69.664591>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-43.000000, 10.625933, 62.588591>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.701262, 68.734779>,
        <-43.000000, 3.711443, 69.274361>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.687365, 68.193899>,
        <-43.000000, 3.701262, 68.734779>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.669252, 67.651850>,
        <-43.000000, 3.687365, 68.193899>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.646452, 67.108810>,
        <-43.000000, 3.669252, 67.651850>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.618471, 66.564899>,
        <-43.000000, 3.646452, 67.108810>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.584833, 66.020300>,
        <-43.000000, 3.618471, 66.564899>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.545035, 65.475149>,
        <-43.000000, 3.584833, 66.020300>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.498613, 64.929600>,
        <-43.000000, 3.545035, 65.475149>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.445063, 64.383801>,
        <-43.000000, 3.498613, 64.929600>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.383925, 63.837919>,
        <-43.000000, 3.445063, 64.383801>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.314684, 63.292089>,
        <-43.000000, 3.383925, 63.837919>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.236872, 62.746481>,
        <-43.000000, 3.314684, 63.292089>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.149992, 62.201229>,
        <-43.000000, 3.236872, 62.746481>,
        < -43.000000, 10.625933, 62.588591>
      }
      triangle {
        <-43.000000, 3.486525, 76.279230>,
        <-43.000000, 8.643702, 76.703710>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-32.643002, 8.802813, 75.824640>,
        <-43.000000, 9.770002, 69.664591>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.541521, 75.724980>,
        <-43.000000, 3.486525, 76.279230>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.587774, 75.175910>,
        <-43.000000, 3.541521, 75.724980>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.625944, 74.631310>,
        <-43.000000, 3.587774, 75.175910>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.656733, 74.090460>,
        <-43.000000, 3.625944, 74.631310>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.680803, 73.552650>,
        <-43.000000, 3.656733, 74.090460>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.698855, 73.017130>,
        <-43.000000, 3.680803, 73.552650>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.711554, 72.483210>,
        <-43.000000, 3.698855, 73.017130>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.719603, 71.950150>,
        <-43.000000, 3.711554, 72.483210>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.723662, 71.417231>,
        <-43.000000, 3.719603, 71.950150>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.724432, 70.883739>,
        <-43.000000, 3.723662, 71.417231>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.722574, 70.348961>,
        <-43.000000, 3.724432, 70.883739>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.718382, 69.812469>,
        <-43.000000, 3.722574, 70.348961>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-43.000000, 3.711443, 69.274361>,
        <-43.000000, 3.718382, 69.812469>,
        < -43.000000, 9.770002, 69.664591>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-43.000000, 9.770002, 69.664591>,
        < -32.643002, 8.802813, 75.824640>
      }
      triangle {
        <-43.000000, 1.336931, 83.356071>,
        <-43.000000, 7.156504, 83.663294>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-32.643002, 8.802813, 75.824640>,
        <-43.000000, 8.643702, 76.703710>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, 1.655054, 82.916145>,
        <-43.000000, 1.336931, 83.356071>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 1.938501, 82.442412>,
        <-43.000000, 1.655054, 82.916145>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 2.189802, 81.939413>,
        <-43.000000, 1.938501, 82.442412>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 2.411512, 81.411689>,
        <-43.000000, 2.189802, 81.939413>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 2.606154, 80.863780>,
        <-43.000000, 2.411512, 81.411689>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 2.776262, 80.300230>,
        <-43.000000, 2.606154, 80.863780>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 2.924383, 79.725560>,
        <-43.000000, 2.776262, 80.300230>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.053042, 79.144340>,
        <-43.000000, 2.924383, 79.725560>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.164793, 78.561080>,
        <-43.000000, 3.053042, 79.144340>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.262163, 77.980340>,
        <-43.000000, 3.164793, 78.561080>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.347525, 77.406200>,
        <-43.000000, 3.262163, 77.980340>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.422083, 76.839400>,
        <-43.000000, 3.347525, 77.406200>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, 3.486525, 76.279230>,
        <-43.000000, 3.422083, 76.839400>,
        < -43.000000, 8.643702, 76.703710>
      }
      triangle {
        <-43.000000, -4.033327, 90.500000>,
        <-43.000000, 5.216673, 90.500000>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-28.635189, 7.150034, 83.689576>,
        <-43.000000, 7.156504, 83.663294>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-43.000000, -4.033327, 87.500000>,
        <-43.000000, -4.033327, 90.500000>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -3.944555, 86.955949>,
        <-43.000000, -4.033327, 87.500000>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -3.707956, 86.455088>,
        <-43.000000, -3.944555, 86.955949>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -3.365415, 86.047628>,
        <-43.000000, -3.707956, 86.455088>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -2.942865, 85.730193>,
        <-43.000000, -3.365415, 86.047628>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -2.460398, 85.479724>,
        <-43.000000, -2.942865, 85.730193>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -1.938085, 85.273198>,
        <-43.000000, -2.460398, 85.479724>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -1.396017, 85.087590>,
        <-43.000000, -1.938085, 85.273198>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -0.854288, 84.899877>,
        <-43.000000, -1.396017, 85.087590>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, -0.332968, 84.687035>,
        <-43.000000, -0.854288, 84.899877>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, 0.149122, 84.427606>,
        <-43.000000, -0.332968, 84.687035>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, 0.586504, 84.116342>,
        <-43.000000, 0.149122, 84.427606>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, 0.981592, 83.757650>,
        <-43.000000, 0.586504, 84.116342>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-43.000000, 1.336931, 83.356071>,
        <-43.000000, 0.981592, 83.757650>,
        < -43.000000, 7.156504, 83.663294>
      }
      triangle {
        <-32.643002, 8.802813, 75.824640>,
        <-43.000000, 7.156504, 83.663294>,
        < -28.635189, 7.150034, 83.689576>
      }
      triangle {
        <-25.424931, -3.341017, 90.500000>,
        <-43.000000, 5.216673, 90.500000>,
        < -43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-26.375000, -2.033327, 90.500000>,
        <-27.000000, 5.216673, 90.500000>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-27.187210, 5.948801, 88.137509>,
        <-43.000000, 5.216673, 90.500000>,
        < -27.000000, 5.216673, 90.500000>
      }
      triangle {
        <-26.307690, -2.458258, 90.500000>,
        <-26.375000, -2.033327, 90.500000>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-26.112391, -2.841535, 90.500000>,
        <-26.307690, -2.458258, 90.500000>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-25.808210, -3.145716, 90.500000>,
        <-26.112391, -2.841535, 90.500000>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-25.424931, -3.341017, 90.500000>,
        <-25.808210, -3.145716, 90.500000>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-27.736410, 6.591734, 85.857808>,
        <-28.635189, 7.150034, 83.689576>,
        < -43.000000, 5.216673, 90.500000>
      }
      triangle {
        <-27.736410, 6.591734, 85.857808>,
        <-43.000000, 5.216673, 90.500000>,
        < -27.187210, 5.948801, 88.137509>
      }
      triangle {
        <-17.500000, -4.033327, 87.500000>,
        <-43.000000, -4.033327, 90.500000>,
        < -43.000000, -4.033327, 87.500000>
      }
      triangle {
        <-25.000000, -3.408327, 90.500000>,
        <-25.424931, -3.341017, 90.500000>,
        < -43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-17.500000, -4.033327, 89.500000>,
        <17.500000, -4.033327, 89.500000>,
        < -43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-17.500000, -4.033327, 87.500000>,
        <-17.500000, -4.033327, 89.500000>,
        < -43.000000, -4.033327, 90.500000>
      }
      triangle {
        <-17.500000, -4.033327, 87.500000>,
        <-43.000000, -4.033327, 87.500000>,
        < -43.000000, -3.944555, 86.955949>
      }
      triangle {
        <-17.500000, -3.939089, 86.939077>,
        <-43.000000, -3.944555, 86.955949>,
        < -43.000000, -3.707956, 86.455088>
      }
      triangle {
        <-17.500000, -3.939089, 86.939077>,
        <-17.500000, -4.033327, 87.500000>,
        < -43.000000, -3.944555, 86.955949>
      }
      triangle {
        <-17.500000, -3.688978, 86.426142>,
        <-43.000000, -3.707956, 86.455088>,
        < -43.000000, -3.365415, 86.047628>
      }
      triangle {
        <-17.500000, -3.688978, 86.426142>,
        <-17.500000, -3.939089, 86.939077>,
        < -43.000000, -3.707956, 86.455088>
      }
      triangle {
        <-17.500000, -3.328287, 86.013895>,
        <-43.000000, -3.365415, 86.047628>,
        < -43.000000, -2.942865, 85.730193>
      }
      triangle {
        <-17.500000, -3.328287, 86.013895>,
        <-17.500000, -3.688978, 86.426142>,
        < -43.000000, -3.365415, 86.047628>
      }
      triangle {
        <-17.500000, -2.884497, 85.695171>,
        <-43.000000, -2.942865, 85.730193>,
        < -43.000000, -2.460398, 85.479724>
      }
      triangle {
        <-17.500000, -2.884497, 85.695171>,
        <-17.500000, -3.328287, 86.013895>,
        < -43.000000, -2.942865, 85.730193>
      }
      triangle {
        <-17.500000, -2.379637, 85.444604>,
        <-43.000000, -2.460398, 85.479724>,
        < -43.000000, -1.938085, 85.273198>
      }
      triangle {
        <-17.500000, -2.379637, 85.444604>,
        <-17.500000, -2.884497, 85.695171>,
        < -43.000000, -2.460398, 85.479724>
      }
      triangle {
        <-17.500000, -1.835768, 85.236915>,
        <-43.000000, -1.938085, 85.273198>,
        < -43.000000, -1.396017, 85.087590>
      }
      triangle {
        <-17.500000, -1.835768, 85.236915>,
        <-17.500000, -2.379637, 85.444604>,
        < -43.000000, -1.938085, 85.273198>
      }
      triangle {
        <-17.500000, -1.274916, 85.046847>,
        <-43.000000, -1.396017, 85.087590>,
        < -43.000000, -0.854288, 84.899877>
      }
      triangle {
        <-17.500000, -1.274916, 85.046847>,
        <-17.500000, -1.835768, 85.236915>,
        < -43.000000, -1.396017, 85.087590>
      }
      triangle {
        <-17.500000, -0.719168, 84.849106>,
        <-43.000000, -0.854288, 84.899877>,
        < -43.000000, -0.332968, 84.687035>
      }
      triangle {
        <-17.500000, -0.719168, 84.849106>,
        <-17.500000, -1.274916, 85.046847>,
        < -43.000000, -0.854288, 84.899877>
      }
      triangle {
        <-17.500000, -0.190588, 84.618377>,
        <-43.000000, -0.332968, 84.687035>,
        < -43.000000, 0.149122, 84.427606>
      }
      triangle {
        <-17.500000, -0.190588, 84.618377>,
        <-17.500000, -0.719168, 84.849106>,
        < -43.000000, -0.332968, 84.687035>
      }
      triangle {
        <-17.500000, 0.292704, 84.334203>,
        <-43.000000, 0.149122, 84.427606>,
        < -43.000000, 0.586504, 84.116342>
      }
      triangle {
        <-17.500000, 0.292704, 84.334203>,
        <-17.500000, -0.190588, 84.618377>,
        < -43.000000, 0.149122, 84.427606>
      }
      triangle {
        <-17.500000, 0.729143, 83.996241>,
        <-43.000000, 0.586504, 84.116342>,
        < -43.000000, 0.981592, 83.757650>
      }
      triangle {
        <-17.500000, 0.729143, 83.996241>,
        <-17.500000, 0.292704, 84.334203>,
        < -43.000000, 0.586504, 84.116342>
      }
      triangle {
        <-17.500000, 1.121504, 83.609479>,
        <-43.000000, 0.981592, 83.757650>,
        < -43.000000, 1.336931, 83.356071>
      }
      triangle {
        <-17.500000, 1.121504, 83.609479>,
        <-17.500000, 0.729143, 83.996241>,
        < -43.000000, 0.981592, 83.757650>
      }
      triangle {
        <-17.500000, 1.472582, 83.178902>,
        <-43.000000, 1.336931, 83.356071>,
        < -43.000000, 1.655054, 82.916145>
      }
      triangle {
        <-17.500000, 1.472582, 83.178902>,
        <-17.500000, 1.121504, 83.609479>,
        < -43.000000, 1.336931, 83.356071>
      }
      triangle {
        <-17.500000, 1.785154, 82.709499>,
        <-43.000000, 1.655054, 82.916145>,
        < -43.000000, 1.938501, 82.442412>
      }
      triangle {
        <-17.500000, 1.785154, 82.709499>,
        <-17.500000, 1.472582, 83.178902>,
        < -43.000000, 1.655054, 82.916145>
      }
      triangle {
        <-17.500000, 2.062021, 82.206259>,
        <-43.000000, 1.938501, 82.442412>,
        < -43.000000, 2.189802, 81.939413>
      }
      triangle {
        <-17.500000, 2.062021, 82.206259>,
        <-17.500000, 1.785154, 82.709499>,
        < -43.000000, 1.938501, 82.442412>
      }
      triangle {
        <-17.500000, 2.305964, 81.674171>,
        <-43.000000, 2.189802, 81.939413>,
        < -43.000000, 2.411512, 81.411689>
      }
      triangle {
        <-17.500000, 2.305964, 81.674171>,
        <-17.500000, 2.062021, 82.206259>,
        < -43.000000, 2.189802, 81.939413>
      }
      triangle {
        <-17.500000, 2.519755, 81.118214>,
        <-43.000000, 2.411512, 81.411689>,
        < -43.000000, 2.606154, 80.863780>
      }
      triangle {
        <-17.500000, 2.519755, 81.118214>,
        <-17.500000, 2.305964, 81.674171>,
        < -43.000000, 2.411512, 81.411689>
      }
      triangle {
        <-17.500000, 2.706202, 80.543374>,
        <-43.000000, 2.606154, 80.863780>,
        < -43.000000, 2.776262, 80.300230>
      }
      triangle {
        <-17.500000, 2.706202, 80.543374>,
        <-17.500000, 2.519755, 81.118214>,
        < -43.000000, 2.606154, 80.863780>
      }
      triangle {
        <-17.500000, 2.868075, 79.954640>,
        <-43.000000, 2.776262, 80.300230>,
        < -43.000000, 2.924383, 79.725560>
      }
      triangle {
        <-17.500000, 2.868075, 79.954640>,
        <-17.500000, 2.706202, 80.543374>,
        < -43.000000, 2.776262, 80.300230>
      }
      triangle {
        <-17.500000, 3.008162, 79.357000>,
        <-43.000000, 2.924383, 79.725560>,
        < -43.000000, 3.053042, 79.144340>
      }
      triangle {
        <-17.500000, 3.008162, 79.357000>,
        <-17.500000, 2.868075, 79.954640>,
        < -43.000000, 2.924383, 79.725560>
      }
      triangle {
        <-17.500000, 3.129263, 78.755440>,
        <-43.000000, 3.053042, 79.144340>,
        < -43.000000, 3.164793, 78.561080>
      }
      triangle {
        <-17.500000, 3.129263, 78.755440>,
        <-17.500000, 3.008162, 79.357000>,
        < -43.000000, 3.053042, 79.144340>
      }
      triangle {
        <-17.500000, 3.234163, 78.154950>,
        <-43.000000, 3.164793, 78.561080>,
        < -43.000000, 3.262163, 77.980340>
      }
      triangle {
        <-17.500000, 3.234163, 78.154950>,
        <-17.500000, 3.129263, 78.755440>,
        < -43.000000, 3.164793, 78.561080>
      }
      triangle {
        <-17.500000, 3.325583, 77.560370>,
        <-43.000000, 3.262163, 77.980340>,
        < -43.000000, 3.347525, 77.406200>
      }
      triangle {
        <-17.500000, 3.325583, 77.560370>,
        <-17.500000, 3.234163, 78.154950>,
        < -43.000000, 3.262163, 77.980340>
      }
      triangle {
        <-17.500000, 3.405272, 76.973720>,
        <-43.000000, 3.347525, 77.406200>,
        < -43.000000, 3.422083, 76.839400>
      }
      triangle {
        <-17.500000, 3.405272, 76.973720>,
        <-17.500000, 3.325583, 77.560370>,
        < -43.000000, 3.347525, 77.406200>
      }
      triangle {
        <-17.500000, 3.474024, 76.394310>,
        <-43.000000, 3.422083, 76.839400>,
        < -43.000000, 3.486525, 76.279230>
      }
      triangle {
        <-17.500000, 3.474024, 76.394310>,
        <-17.500000, 3.405272, 76.973720>,
        < -43.000000, 3.422083, 76.839400>
      }
      triangle {
        <-17.500000, 3.532572, 75.821360>,
        <-43.000000, 3.486525, 76.279230>,
        < -43.000000, 3.541521, 75.724980>
      }
      triangle {
        <-17.500000, 3.532572, 75.821360>,
        <-17.500000, 3.474024, 76.394310>,
        < -43.000000, 3.486525, 76.279230>
      }
      triangle {
        <-17.500000, 3.581675, 75.254060>,
        <-43.000000, 3.541521, 75.724980>,
        < -43.000000, 3.587774, 75.175910>
      }
      triangle {
        <-17.500000, 3.581675, 75.254060>,
        <-17.500000, 3.532572, 75.821360>,
        < -43.000000, 3.541521, 75.724980>
      }
      triangle {
        <-17.500000, 3.622084, 74.691630>,
        <-43.000000, 3.587774, 75.175910>,
        < -43.000000, 3.625944, 74.631310>
      }
      triangle {
        <-17.500000, 3.622084, 74.691630>,
        <-17.500000, 3.581675, 75.254060>,
        < -43.000000, 3.587774, 75.175910>
      }
      triangle {
        <-17.500000, 3.654543, 74.133270>,
        <-43.000000, 3.625944, 74.631310>,
        < -43.000000, 3.656733, 74.090460>
      }
      triangle {
        <-17.500000, 3.654543, 74.133270>,
        <-17.500000, 3.622084, 74.691630>,
        < -43.000000, 3.625944, 74.631310>
      }
      triangle {
        <-17.500000, 3.679804, 73.578199>,
        <-43.000000, 3.656733, 74.090460>,
        < -43.000000, 3.680803, 73.552650>
      }
      triangle {
        <-17.500000, 3.679804, 73.578199>,
        <-17.500000, 3.654543, 74.133270>,
        < -43.000000, 3.656733, 74.090460>
      }
      triangle {
        <-17.500000, 3.698614, 73.025620>,
        <-43.000000, 3.680803, 73.552650>,
        < -43.000000, 3.698855, 73.017130>
      }
      triangle {
        <-17.500000, 3.698614, 73.025620>,
        <-17.500000, 3.679804, 73.578199>,
        < -43.000000, 3.680803, 73.552650>
      }
      triangle {
        <-17.500000, 3.698614, 73.025620>,
        <-43.000000, 3.698855, 73.017130>,
        < -43.000000, 3.711554, 72.483210>
      }
      triangle {
        <-17.500000, 3.711722, 72.474739>,
        <-43.000000, 3.711554, 72.483210>,
        < -43.000000, 3.719603, 71.950150>
      }
      triangle {
        <-17.500000, 3.711722, 72.474739>,
        <-17.500000, 3.698614, 73.025620>,
        < -43.000000, 3.711554, 72.483210>
      }
      triangle {
        <-17.500000, 3.719881, 71.924770>,
        <-43.000000, 3.719603, 71.950150>,
        < -43.000000, 3.723662, 71.417231>
      }
      triangle {
        <-17.500000, 3.719881, 71.924770>,
        <-17.500000, 3.711722, 72.474739>,
        < -43.000000, 3.719603, 71.950150>
      }
      triangle {
        <-17.500000, 3.723833, 71.374920>,
        <-43.000000, 3.723662, 71.417231>,
        < -43.000000, 3.724432, 70.883739>
      }
      triangle {
        <-17.500000, 3.723833, 71.374920>,
        <-17.500000, 3.719881, 71.924770>,
        < -43.000000, 3.723662, 71.417231>
      }
      triangle {
        <-17.500000, 3.724344, 70.824400>,
        <-43.000000, 3.724432, 70.883739>,
        < -43.000000, 3.722574, 70.348961>
      }
      triangle {
        <-17.500000, 3.724344, 70.824400>,
        <-17.500000, 3.723833, 71.374920>,
        < -43.000000, 3.724432, 70.883739>
      }
      triangle {
        <-17.500000, 3.722124, 70.272421>,
        <-43.000000, 3.722574, 70.348961>,
        < -43.000000, 3.718382, 69.812469>
      }
      triangle {
        <-17.500000, 3.722124, 70.272421>,
        <-17.500000, 3.724344, 70.824400>,
        < -43.000000, 3.722574, 70.348961>
      }
      triangle {
        <-17.500000, 3.717383, 69.718620>,
        <-43.000000, 3.718382, 69.812469>,
        < -43.000000, 3.711443, 69.274361>
      }
      triangle {
        <-17.500000, 3.717383, 69.718620>,
        <-17.500000, 3.722124, 70.272421>,
        < -43.000000, 3.718382, 69.812469>
      }
      triangle {
        <-17.500000, 3.709623, 69.163130>,
        <-43.000000, 3.711443, 69.274361>,
        < -43.000000, 3.701262, 68.734779>
      }
      triangle {
        <-17.500000, 3.709623, 69.163130>,
        <-17.500000, 3.717383, 69.718620>,
        < -43.000000, 3.711443, 69.274361>
      }
      triangle {
        <-17.500000, 3.698313, 68.606110>,
        <-43.000000, 3.701262, 68.734779>,
        < -43.000000, 3.687365, 68.193899>
      }
      triangle {
        <-17.500000, 3.698313, 68.606110>,
        <-17.500000, 3.709623, 69.163130>,
        < -43.000000, 3.701262, 68.734779>
      }
      triangle {
        <-17.500000, 3.682913, 68.047741>,
        <-43.000000, 3.687365, 68.193899>,
        < -43.000000, 3.669252, 67.651850>
      }
      triangle {
        <-17.500000, 3.682913, 68.047741>,
        <-17.500000, 3.698313, 68.606110>,
        < -43.000000, 3.687365, 68.193899>
      }
      triangle {
        <-17.500000, 3.662893, 67.488180>,
        <-43.000000, 3.669252, 67.651850>,
        < -43.000000, 3.646452, 67.108810>
      }
      triangle {
        <-17.500000, 3.662893, 67.488180>,
        <-17.500000, 3.682913, 68.047741>,
        < -43.000000, 3.669252, 67.651850>
      }
      triangle {
        <-17.500000, 3.637724, 66.927589>,
        <-43.000000, 3.646452, 67.108810>,
        < -43.000000, 3.618471, 66.564899>
      }
      triangle {
        <-17.500000, 3.637724, 66.927589>,
        <-17.500000, 3.662893, 67.488180>,
        < -43.000000, 3.646452, 67.108810>
      }
      triangle {
        <-17.500000, 3.606875, 66.366150>,
        <-43.000000, 3.618471, 66.564899>,
        < -43.000000, 3.584833, 66.020300>
      }
      triangle {
        <-17.500000, 3.606875, 66.366150>,
        <-17.500000, 3.637724, 66.927589>,
        < -43.000000, 3.618471, 66.564899>
      }
      triangle {
        <-17.500000, 3.569803, 65.804029>,
        <-43.000000, 3.584833, 66.020300>,
        < -43.000000, 3.545035, 65.475149>
      }
      triangle {
        <-17.500000, 3.569803, 65.804029>,
        <-17.500000, 3.606875, 66.366150>,
        < -43.000000, 3.584833, 66.020300>
      }
      triangle {
        <-17.500000, 3.525984, 65.241381>,
        <-43.000000, 3.545035, 65.475149>,
        < -43.000000, 3.498613, 64.929600>
      }
      triangle {
        <-17.500000, 3.525984, 65.241381>,
        <-17.500000, 3.569803, 65.804029>,
        < -43.000000, 3.545035, 65.475149>
      }
      triangle {
        <-17.500000, 3.474875, 64.678379>,
        <-43.000000, 3.498613, 64.929600>,
        < -43.000000, 3.445063, 64.383801>
      }
      triangle {
        <-17.500000, 3.474875, 64.678379>,
        <-17.500000, 3.525984, 65.241381>,
        < -43.000000, 3.498613, 64.929600>
      }
      triangle {
        <-17.500000, 3.415964, 64.115200>,
        <-43.000000, 3.445063, 64.383801>,
        < -43.000000, 3.383925, 63.837919>
      }
      triangle {
        <-17.500000, 3.415964, 64.115200>,
        <-17.500000, 3.474875, 64.678379>,
        < -43.000000, 3.445063, 64.383801>
      }
      triangle {
        <-17.500000, 3.348692, 63.551991>,
        <-43.000000, 3.383925, 63.837919>,
        < -43.000000, 3.314684, 63.292089>
      }
      triangle {
        <-17.500000, 3.348692, 63.551991>,
        <-17.500000, 3.415964, 64.115200>,
        < -43.000000, 3.383925, 63.837919>
      }
      triangle {
        <-17.500000, 3.272543, 62.988939>,
        <-43.000000, 3.314684, 63.292089>,
        < -43.000000, 3.236872, 62.746481>
      }
      triangle {
        <-17.500000, 3.272543, 62.988939>,
        <-17.500000, 3.348692, 63.551991>,
        < -43.000000, 3.314684, 63.292089>
      }
      triangle {
        <-17.500000, 3.186983, 62.426201>,
        <-43.000000, 3.236872, 62.746481>,
        < -43.000000, 3.149992, 62.201229>
      }
      triangle {
        <-17.500000, 3.186983, 62.426201>,
        <-17.500000, 3.272543, 62.988939>,
        < -43.000000, 3.236872, 62.746481>
      }
      triangle {
        <-17.500000, 3.091463, 61.863939>,
        <-43.000000, 3.149992, 62.201229>,
        < -43.000000, 3.053583, 61.656490>
      }
      triangle {
        <-17.500000, 3.091463, 61.863939>,
        <-17.500000, 3.186983, 62.426201>,
        < -43.000000, 3.149992, 62.201229>
      }
      triangle {
        <-17.500000, 2.985472, 61.302330>,
        <-43.000000, 3.053583, 61.656490>,
        < -43.000000, 2.947134, 61.112431>
      }
      triangle {
        <-17.500000, 2.985472, 61.302330>,
        <-17.500000, 3.091463, 61.863939>,
        < -43.000000, 3.053583, 61.656490>
      }
      triangle {
        <-17.500000, 2.868471, 60.741550>,
        <-43.000000, 2.947134, 61.112431>,
        < -43.000000, 2.830172, 60.569189>
      }
      triangle {
        <-17.500000, 2.868471, 60.741550>,
        <-17.500000, 2.985472, 61.302330>,
        < -43.000000, 2.947134, 61.112431>
      }
      triangle {
        <-17.500000, 2.739912, 60.181740>,
        <-43.000000, 2.830172, 60.569189>,
        < -43.000000, 2.702204, 60.026920>
      }
      triangle {
        <-17.500000, 2.739912, 60.181740>,
        <-17.500000, 2.868471, 60.741550>,
        < -43.000000, 2.830172, 60.569189>
      }
      triangle {
        <-17.500000, 2.599135, 59.623211>,
        <-43.000000, 2.702204, 60.026920>,
        < -43.000000, 2.562124, 59.486271>
      }
      triangle {
        <-17.500000, 2.599135, 59.623211>,
        <-17.500000, 2.739912, 60.181740>,
        < -43.000000, 2.702204, 60.026920>
      }
      triangle {
        <-17.500000, 2.439814, 59.070660>,
        <-43.000000, 2.562124, 59.486271>,
        < -43.000000, 2.401781, 58.953430>
      }
      triangle {
        <-17.500000, 2.439814, 59.070660>,
        <-17.500000, 2.599135, 59.623211>,
        < -43.000000, 2.562124, 59.486271>
      }
      triangle {
        <-17.500000, 2.248514, 58.534430>,
        <-43.000000, 2.401781, 58.953430>,
        < -43.000000, 2.208574, 58.438068>
      }
      triangle {
        <-17.500000, 2.248514, 58.534430>,
        <-17.500000, 2.439814, 59.070660>,
        < -43.000000, 2.401781, 58.953430>
      }
      triangle {
        <-17.500000, 2.011313, 58.025211>,
        <-43.000000, 2.208574, 58.438068>,
        < -43.000000, 1.969862, 57.949940>
      }
      triangle {
        <-17.500000, 2.011313, 58.025211>,
        <-17.500000, 2.248514, 58.534430>,
        < -43.000000, 2.208574, 58.438068>
      }
      triangle {
        <-17.500000, 1.714312, 57.553692>,
        <-43.000000, 1.969862, 57.949940>,
        < -43.000000, 1.672941, 57.498779>
      }
      triangle {
        <-17.500000, 1.714312, 57.553692>,
        <-17.500000, 2.011313, 58.025211>,
        < -43.000000, 1.969862, 57.949940>
      }
      triangle {
        <-17.500000, 1.348032, 57.128819>,
        <-43.000000, 1.672941, 57.498779>,
        < -43.000000, 1.311014, 57.092030>
      }
      triangle {
        <-17.500000, 1.348032, 57.128819>,
        <-17.500000, 1.714312, 57.553692>,
        < -43.000000, 1.672941, 57.498779>
      }
      triangle {
        <-17.500000, 0.923372, 56.751560>,
        <-43.000000, 1.311014, 57.092030>,
        < -43.000000, 0.895712, 56.729870>
      }
      triangle {
        <-17.500000, 0.923372, 56.751560>,
        <-17.500000, 1.348032, 57.128819>,
        < -43.000000, 1.311014, 57.092030>
      }
      triangle {
        <-17.500000, 0.457281, 56.420490>,
        <-43.000000, 0.895712, 56.729870>,
        < -43.000000, 0.442461, 56.411018>
      }
      triangle {
        <-17.500000, 0.457281, 56.420490>,
        <-17.500000, 0.923372, 56.751560>,
        < -43.000000, 0.895712, 56.729870>
      }
      triangle {
        <-17.500000, 0.457281, 56.420490>,
        <-43.000000, 0.442461, 56.411018>,
        < -43.000000, -0.033327, 56.134190>
      }
      triangle {
        <-17.500000, -20.033327, 45.500000>,
        <-43.000000, -0.033327, 56.134190>,
        < -43.000000, -20.033327, 45.500000>
      }
      triangle {
        <-17.500000, -0.033327, 56.134190>,
        <-43.000000, -0.033327, 56.134190>,
        < -17.500000, -20.033327, 45.500000>
      }
      triangle {
        <-17.500000, -0.033327, 56.134190>,
        <-17.500000, 0.457281, 56.420490>,
        < -43.000000, -0.033327, 56.134190>
      }
      triangle {
        <-43.000000, -20.033327, -30.116203>,
        <-43.000000, -20.033327, 45.500000>,
        < -43.000000, -12.033327, -25.019699>
      }
      triangle {
        <-43.000000, -12.033327, -25.019699>,
        <-43.000000, -11.832006, -26.803001>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -12.033327, -5.000000>,
        <-43.000000, -12.033327, -25.019699>,
        < -43.000000, -20.033327, 45.500000>
      }
      triangle {
        <-43.000000, -8.945476, -31.334000>,
        <-43.000000, -19.832006, -31.899597>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -10.245277, -30.060699>,
        <-43.000000, -8.945476, -31.334000>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -11.227297, -28.519203>,
        <-43.000000, -10.245277, -30.060699>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -11.832006, -26.803001>,
        <-43.000000, -11.227297, -28.519203>,
        < -43.000000, -20.033327, -30.116203>
      }
      triangle {
        <-43.000000, -7.414278, -32.270103>,
        <-43.000000, -19.227297, -33.615799>,
        < -43.000000, -19.832006, -31.899597>
      }
      triangle {
        <-43.000000, -8.945476, -31.334000>,
        <-43.000000, -7.414278, -32.270103>,
        < -43.000000, -19.832006, -31.899597>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, -18.245277, -35.157204>,
        < -43.000000, -19.227297, -33.615799>
      }
      triangle {
        <-43.000000, -7.414278, -32.270103>,
        <-43.000000, 10.566671, -40.654800>,
        < -43.000000, -19.227297, -33.615799>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, -16.945476, -36.430603>,
        < -43.000000, -18.245277, -35.157204>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, -15.414278, -37.366699>,
        < -43.000000, -16.945476, -36.430603>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, -0.920236, -44.125397>,
        < -43.000000, -15.414278, -37.366699>
      }
      triangle {
        <-26.625000, -0.920236, -44.125397>,
        <-43.000000, -15.414278, -37.366699>,
        < -43.000000, -0.920236, -44.125397>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-43.000000, -15.414278, -37.366699>,
        < -26.625000, -0.920236, -44.125397>
      }
      triangle {
        <26.625000, -13.087498, -38.451706>,
        <-43.000000, -15.414278, -37.366699>,
        < -26.625000, -13.087498, -38.451706>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, 0.036844, -44.710495>,
        < -43.000000, -0.920236, -44.125397>
      }
      triangle {
        <-26.625000, -0.920236, -44.125397>,
        <-43.000000, -0.920236, -44.125397>,
        < -43.000000, 0.036844, -44.710495>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, 0.849173, -45.506302>,
        < -43.000000, 0.036844, -44.710495>
      }
      triangle {
        <-26.625000, 0.036844, -44.710495>,
        <-43.000000, 0.036844, -44.710495>,
        < -43.000000, 0.849173, -45.506302>
      }
      triangle {
        <-26.625000, -0.920236, -44.125397>,
        <-43.000000, 0.036844, -44.710495>,
        < -26.625000, 0.036844, -44.710495>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, 1.462881, -46.469696>,
        < -43.000000, 0.849173, -45.506302>
      }
      triangle {
        <-26.625000, 0.849173, -45.506302>,
        <-43.000000, 0.849173, -45.506302>,
        < -43.000000, 1.462881, -46.469696>
      }
      triangle {
        <-26.625000, 0.036844, -44.710495>,
        <-43.000000, 0.849173, -45.506302>,
        < -26.625000, 0.849173, -45.506302>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, 1.840841, -47.542206>,
        < -43.000000, 1.462881, -46.469696>
      }
      triangle {
        <-26.625000, 1.462881, -46.469696>,
        <-43.000000, 1.462881, -46.469696>,
        < -43.000000, 1.840841, -47.542206>
      }
      triangle {
        <-26.625000, 0.849173, -45.506302>,
        <-43.000000, 1.462881, -46.469696>,
        < -26.625000, 1.462881, -46.469696>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, 1.966673, -48.656906>,
        < -43.000000, 1.840841, -47.542206>
      }
      triangle {
        <-26.625000, 1.840841, -47.542206>,
        <-43.000000, 1.840841, -47.542206>,
        < -43.000000, 1.966673, -48.656906>
      }
      triangle {
        <-43.000000, 10.566671, -40.654800>,
        <-43.000000, 10.566671, -89.500000>,
        < -43.000000, 1.840841, -47.542206>
      }
      triangle {
        <-26.625000, 1.462881, -46.469696>,
        <-43.000000, 1.840841, -47.542206>,
        < -26.625000, 1.840841, -47.542206>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, 1.966673, -70.978699>,
        < -43.000000, 1.966673, -48.656906>
      }
      triangle {
        <-26.625000, 1.966673, -48.656906>,
        <-43.000000, 1.966673, -48.656906>,
        < -43.000000, 1.966673, -70.978699>
      }
      triangle {
        <-26.625000, 1.840841, -47.542206>,
        <-43.000000, 1.966673, -48.656906>,
        < -26.625000, 1.966673, -48.656906>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, 1.834833, -72.119293>,
        < -43.000000, 1.966673, -70.978699>
      }
      triangle {
        <-26.625000, 1.966673, -70.978699>,
        <-43.000000, 1.966673, -70.978699>,
        < -43.000000, 1.834833, -72.119293>
      }
      triangle {
        <-26.625000, 1.966673, -48.656906>,
        <-43.000000, 1.966673, -70.978699>,
        < -26.625000, 1.966673, -70.978699>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, 1.441332, -73.209595>,
        < -43.000000, 1.834833, -72.119293>
      }
      triangle {
        <-26.625000, 1.834833, -72.119293>,
        <-43.000000, 1.834833, -72.119293>,
        < -43.000000, 1.441332, -73.209595>
      }
      triangle {
        <-26.625000, 1.966673, -70.978699>,
        <-43.000000, 1.834833, -72.119293>,
        < -26.625000, 1.834833, -72.119293>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, 0.807333, -74.180099>,
        < -43.000000, 1.441332, -73.209595>
      }
      triangle {
        <-26.625000, 1.441332, -73.209595>,
        <-43.000000, 1.441332, -73.209595>,
        < -43.000000, 0.807333, -74.180099>
      }
      triangle {
        <-26.625000, 1.834833, -72.119293>,
        <-43.000000, 1.441332, -73.209595>,
        < -26.625000, 1.441332, -73.209595>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -0.024248, -74.971802>,
        < -43.000000, 0.807333, -74.180099>
      }
      triangle {
        <-26.625000, 0.807333, -74.180099>,
        <-43.000000, 0.807333, -74.180099>,
        < -43.000000, -0.024248, -74.971802>
      }
      triangle {
        <-26.625000, 1.441332, -73.209595>,
        <-43.000000, 0.807333, -74.180099>,
        < -26.625000, 0.807333, -74.180099>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -4.838777, -78.599792>,
        < -43.000000, -0.024248, -74.971802>
      }
      triangle {
        <-26.625000, -4.838777, -78.599792>,
        <-43.000000, -0.024248, -74.971802>,
        < -43.000000, -4.838777, -78.599792>
      }
      triangle {
        <-26.625000, -0.024248, -74.971802>,
        <-43.000000, -0.024248, -74.971802>,
        < -26.625000, -4.838777, -78.599792>
      }
      triangle {
        <-26.625000, 0.807333, -74.180099>,
        <-43.000000, -0.024248, -74.971802>,
        < -26.625000, -0.024248, -74.971802>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -5.479168, -79.258606>,
        < -43.000000, -4.838777, -78.599792>
      }
      triangle {
        <-26.625000, -4.838777, -78.599792>,
        <-43.000000, -4.838777, -78.599792>,
        < -43.000000, -5.479168, -79.258606>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -5.892647, -80.087906>,
        < -43.000000, -5.479168, -79.258606>
      }
      triangle {
        <-26.625000, -5.479168, -79.258606>,
        <-43.000000, -5.479168, -79.258606>,
        < -43.000000, -5.892647, -80.087906>
      }
      triangle {
        <-26.625000, -4.838777, -78.599792>,
        <-43.000000, -5.479168, -79.258606>,
        < -26.625000, -5.479168, -79.258606>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -6.033327, -80.995697>,
        < -43.000000, -5.892647, -80.087906>
      }
      triangle {
        <-26.625000, -5.892647, -80.087906>,
        <-43.000000, -5.892647, -80.087906>,
        < -43.000000, -6.033327, -80.995697>
      }
      triangle {
        <-26.625000, -5.479168, -79.258606>,
        <-43.000000, -5.892647, -80.087906>,
        < -26.625000, -5.892647, -80.087906>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <-43.000000, -6.033327, -89.500000>,
        < -43.000000, -6.033327, -80.995697>
      }
      triangle {
        <-26.625000, -6.033327, -89.500000>,
        <-43.000000, -6.033327, -80.995697>,
        < -43.000000, -6.033327, -89.500000>
      }
      triangle {
        <-26.625000, -6.033327, -80.995697>,
        <-43.000000, -6.033327, -80.995697>,
        < -26.625000, -6.033327, -89.500000>
      }
      triangle {
        <-26.625000, -5.892647, -80.087906>,
        <-43.000000, -6.033327, -80.995697>,
        < -26.625000, -6.033327, -80.995697>
      }
      triangle {
        <-26.000000, 10.566671, -89.500000>,
        <-43.000000, -6.033327, -89.500000>,
        < -43.000000, 10.566671, -89.500000>
      }
      triangle {
        <-26.625000, -6.033327, -89.500000>,
        <-43.000000, -6.033327, -89.500000>,
        < -26.000000, 10.566671, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -89.500000>,
        <-26.000000, -3.033327, -89.500000>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -89.500000>,
        <-26.625000, -8.033327, -89.500000>,
        < 26.000000, -3.033327, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -89.500000>,
        <-26.000000, 10.566671, -89.500000>,
        < -26.000000, -3.033327, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -89.500000>,
        <-26.625000, -6.033327, -89.500000>,
        < -26.000000, 10.566671, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -6.033327, -89.500000>,
        < -26.625000, -8.033327, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -6.033327, -80.995697>,
        < -26.625000, -6.033327, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -89.500000>,
        <26.625000, -8.033327, -89.500000>,
        < -26.625000, -8.033327, -89.500000>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -8.033327, -89.500000>,
        < 26.625000, -8.033327, -89.500000>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <26.625000, -8.033327, -89.500000>,
        < 26.625000, -6.033327, -89.500000>
      }
      triangle {
        <-15.000000, -8.033327, -79.500000>,
        <-26.625000, -8.033327, -79.500000>,
        < 26.625000, -8.033327, -89.500000>
      }
      triangle {
        <26.625000, -5.891836, -80.085297>,
        <26.625000, -8.033327, -79.500000>,
        < 26.625000, -8.033327, -89.500000>
      }
      triangle {
        <15.000000, -8.033327, -79.500000>,
        <26.625000, -8.033327, -89.500000>,
        < 26.625000, -8.033327, -79.500000>
      }
      triangle {
        <26.625000, -6.033327, -80.995697>,
        <26.625000, -5.891836, -80.085297>,
        < 26.625000, -8.033327, -89.500000>
      }
      triangle {
        <15.000000, -8.033327, -79.500000>,
        <-15.000000, -8.033327, -79.500000>,
        < 26.625000, -8.033327, -89.500000>
      }
      triangle {
        <-17.500000, -0.033327, 56.134190>,
        <-17.500000, -20.033327, 45.500000>,
        < -17.500000, -20.033327, 48.500000>
      }
      triangle {
        <17.500000, -20.033327, 45.500000>,
        <17.500000, -20.033327, 48.500000>,
        < -17.500000, -20.033327, 48.500000>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, -20.033327, 48.500000>,
        < 17.500000, -20.033327, 48.500000>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, -0.033327, 56.134190>,
        < -17.500000, -20.033327, 48.500000>
      }
      triangle {
        <17.500000, -0.033327, 56.134190>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, -20.033327, 45.500000>
      }
      triangle {
        <17.500000, 0.457281, 56.420490>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, -0.033327, 56.134190>
      }
      triangle {
        <17.500000, 0.923372, 56.751560>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 0.457281, 56.420490>
      }
      triangle {
        <17.500000, 1.348032, 57.128819>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 0.923372, 56.751560>
      }
      triangle {
        <17.500000, 1.714312, 57.553692>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 1.348032, 57.128819>
      }
      triangle {
        <17.500000, 2.011313, 58.025211>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 1.714312, 57.553692>
      }
      triangle {
        <17.500000, 2.248514, 58.534430>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 2.011313, 58.025211>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, 2.248514, 58.534430>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <17.500000, -20.033327, 48.500000>,
        < 17.500000, -14.033327, 58.892300>
      }
      triangle {
        <-26.375000, -2.033327, 90.500000>,
        <-27.000000, 5.466673, 90.500000>,
        < -27.000000, 5.216673, 90.500000>
      }
      triangle {
        <-27.186171, 6.362764, 88.144046>,
        <-27.000000, 5.216673, 90.500000>,
        < -27.000000, 5.466673, 90.500000>
      }
      triangle {
        <-27.187210, 5.948801, 88.137509>,
        <-27.000000, 5.216673, 90.500000>,
        < -27.186171, 6.362764, 88.144046>
      }
      triangle {
        <-26.375000, -2.033327, 90.500000>,
        <-26.516411, 5.466673, 90.500000>,
        < -27.000000, 5.466673, 90.500000>
      }
      triangle {
        <-26.175980, 7.397352, 85.011883>,
        <-27.000000, 5.466673, 90.500000>,
        < -26.516411, 5.466673, 90.500000>
      }
      triangle {
        <-27.186171, 6.362764, 88.144046>,
        <-27.000000, 5.466673, 90.500000>,
        < -26.175980, 7.397352, 85.011883>
      }
      triangle {
        <-26.375000, -2.033327, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < -26.516411, 5.466673, 90.500000>
      }
      triangle {
        <-26.217510, 7.161814, 87.210244>,
        <-26.516411, 5.466673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-26.175980, 7.397352, 85.011883>,
        <-26.516411, 5.466673, 90.500000>,
        < -26.217510, 7.161814, 87.210244>
      }
      triangle {
        <25.000000, 5.341673, 90.500000>,
        <26.428249, 5.966673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.217510, 7.161852, 87.209713>,
        <-26.428249, 5.966673, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-5.260481, 4.943873, 90.500000>,
        <-4.739519, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-0.750021, 4.765692, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < -4.739519, 4.943873, 90.500000>
      }
      triangle {
        <-5.750020, 4.765692, 90.500000>,
        <-5.260481, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-9.739519, 4.943873, 90.500000>,
        <-5.750020, 4.765692, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-0.260481, 4.943873, 90.500000>,
        <0.260481, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <4.739519, 4.943873, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < 0.260481, 4.943873, 90.500000>
      }
      triangle {
        <-0.750021, 4.765692, 90.500000>,
        <-0.260481, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-10.260480, 4.943873, 90.500000>,
        <-9.739519, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-10.750020, 4.765692, 90.500000>,
        <-10.260480, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-19.000000, 5.341673, 90.500000>,
        <-10.750020, 4.765692, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <9.739519, 4.943873, 90.500000>,
        <10.260480, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <14.739520, 4.943873, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < 10.260480, 4.943873, 90.500000>
      }
      triangle {
        <5.260481, 4.943873, 90.500000>,
        <9.739519, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <4.739519, 4.943873, 90.500000>,
        <5.260481, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <14.739520, 4.943873, 90.500000>,
        <15.260480, 4.943873, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <18.191790, 5.079062, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < 15.260480, 4.943873, 90.500000>
      }
      triangle {
        <-25.424931, 5.274363, 90.500000>,
        <-25.000000, 5.341673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-19.000000, 5.341673, 90.500000>,
        <-26.428249, 5.966673, 90.500000>,
        < -25.000000, 5.341673, 90.500000>
      }
      triangle {
        <-25.808210, 5.079062, 90.500000>,
        <-25.424931, 5.274363, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-26.112391, 4.774881, 90.500000>,
        <-25.808210, 5.079062, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-26.307690, 4.391604, 90.500000>,
        <-26.112391, 4.774881, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-26.375000, 3.966673, 90.500000>,
        <-26.307690, 4.391604, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <-26.375000, -2.033327, 90.500000>,
        <-26.375000, 3.966673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <19.000000, 5.341673, 90.500000>,
        <25.000000, 5.341673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <18.575069, 5.274363, 90.500000>,
        <19.000000, 5.341673, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <18.191790, 5.079062, 90.500000>,
        <18.575069, 5.274363, 90.500000>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.217510, 7.161852, 87.209713>,
        <-26.217510, 7.161814, 87.210244>,
        < -26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.375000, 3.966673, 90.500000>,
        <26.516411, 5.466673, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.175980, 7.397352, 85.011883>,
        <26.428249, 5.966673, 90.500000>,
        < 26.516411, 5.466673, 90.500000>
      }
      triangle {
        <26.307690, 4.391604, 90.500000>,
        <26.375000, 3.966673, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.112391, 4.774881, 90.500000>,
        <26.307690, 4.391604, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <25.808210, 5.079062, 90.500000>,
        <26.112391, 4.774881, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <25.424931, 5.274363, 90.500000>,
        <25.808210, 5.079062, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <25.000000, 5.341673, 90.500000>,
        <25.424931, 5.274363, 90.500000>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <26.175980, 7.397352, 85.011883>,
        <26.217510, 7.161852, 87.209713>,
        < 26.428249, 5.966673, 90.500000>
      }
      triangle {
        <27.000000, 5.216673, 90.500000>,
        <27.000000, 5.466673, 90.500000>,
        < 26.516411, 5.466673, 90.500000>
      }
      triangle {
        <27.186171, 6.362764, 88.144046>,
        <26.516411, 5.466673, 90.500000>,
        < 27.000000, 5.466673, 90.500000>
      }
      triangle {
        <27.741039, 7.138804, 85.843600>,
        <26.175980, 7.397352, 85.011883>,
        < 26.516411, 5.466673, 90.500000>
      }
      triangle {
        <27.186171, 6.362764, 88.144046>,
        <27.741039, 7.138804, 85.843600>,
        < 26.516411, 5.466673, 90.500000>
      }
      triangle {
        <27.187210, 5.948801, 88.137509>,
        <27.000000, 5.466673, 90.500000>,
        < 27.000000, 5.216673, 90.500000>
      }
      triangle {
        <27.187210, 5.948801, 88.137509>,
        <27.186171, 6.362764, 88.144046>,
        < 27.000000, 5.466673, 90.500000>
      }
      triangle {
        <-8.590453, 3.979673, 90.500000>,
        <-6.500000, -1.533327, 90.500000>,
        < -6.500000, 3.466673, 90.500000>
      }
      triangle {
        <-6.500000, 3.466673, 89.500000>,
        <-6.500000, 3.466673, 90.500000>,
        < -6.500000, -1.533327, 90.500000>
      }
      triangle {
        <-9.249980, 4.765692, 90.500000>,
        <-6.500000, 3.466673, 90.500000>,
        < -6.409547, 3.979673, 90.500000>
      }
      triangle {
        <-6.409539, 3.979704, 89.500000>,
        <-6.409547, 3.979673, 90.500000>,
        < -6.500000, 3.466673, 90.500000>
      }
      triangle {
        <-8.850914, 4.430822, 90.500000>,
        <-8.590453, 3.979673, 90.500000>,
        < -6.500000, 3.466673, 90.500000>
      }
      triangle {
        <-9.249980, 4.765692, 90.500000>,
        <-8.850914, 4.430822, 90.500000>,
        < -6.500000, 3.466673, 90.500000>
      }
      triangle {
        <-6.409539, 3.979704, 89.500000>,
        <-6.500000, 3.466673, 90.500000>,
        < -6.500000, 3.466673, 89.500000>
      }
      triangle {
        <-8.500000, 3.466673, 90.500000>,
        <-6.409547, -2.046327, 90.500000>,
        < -6.500000, -1.533327, 90.500000>
      }
      triangle {
        <-6.500000, -1.533327, 89.500000>,
        <-6.500000, -1.533327, 90.500000>,
        < -6.409547, -2.046327, 90.500000>
      }
      triangle {
        <-8.590453, 3.979673, 90.500000>,
        <-8.500000, 3.466673, 90.500000>,
        < -6.500000, -1.533327, 90.500000>
      }
      triangle {
        <-6.500000, -1.533327, 89.500000>,
        <-6.500000, 3.466673, 89.500000>,
        < -6.500000, -1.533327, 90.500000>
      }
      triangle {
        <-8.500000, -1.533327, 90.500000>,
        <-6.149086, -2.497476, 90.500000>,
        < -6.409547, -2.046327, 90.500000>
      }
      triangle {
        <-6.149067, -2.497507, 89.500000>,
        <-6.409547, -2.046327, 90.500000>,
        < -6.149086, -2.497476, 90.500000>
      }
      triangle {
        <-8.500000, -1.533327, 90.500000>,
        <-6.409547, -2.046327, 90.500000>,
        < -8.500000, 3.466673, 90.500000>
      }
      triangle {
        <-6.409539, -2.046358, 89.500000>,
        <-6.409547, -2.046327, 90.500000>,
        < -6.149067, -2.497507, 89.500000>
      }
      triangle {
        <-6.500000, -1.533327, 89.500000>,
        <-6.409547, -2.046327, 90.500000>,
        < -6.409539, -2.046358, 89.500000>
      }
      triangle {
        <-8.500000, -1.533327, 90.500000>,
        <-5.750020, -2.832346, 90.500000>,
        < -6.149086, -2.497476, 90.500000>
      }
      triangle {
        <-5.750000, -2.832369, 89.500000>,
        <-6.149086, -2.497476, 90.500000>,
        < -5.750020, -2.832346, 90.500000>
      }
      triangle {
        <-6.149067, -2.497507, 89.500000>,
        <-6.149086, -2.497476, 90.500000>,
        < -5.750000, -2.832369, 89.500000>
      }
      triangle {
        <-8.590453, -2.046327, 90.500000>,
        <-5.260481, -3.010527, 90.500000>,
        < -5.750020, -2.832346, 90.500000>
      }
      triangle {
        <-5.750000, -2.832369, 89.500000>,
        <-5.750020, -2.832346, 90.500000>,
        < -5.260481, -3.010527, 90.500000>
      }
      triangle {
        <-8.500000, -1.533327, 90.500000>,
        <-8.590453, -2.046327, 90.500000>,
        < -5.750020, -2.832346, 90.500000>
      }
      triangle {
        <-5.260472, -3.010538, 89.500000>,
        <-5.260481, -3.010527, 90.500000>,
        < -4.739519, -3.010527, 90.500000>
      }
      triangle {
        <-9.249980, -2.832346, 90.500000>,
        <-9.739519, -3.010527, 90.500000>,
        < -5.260481, -3.010527, 90.500000>
      }
      triangle {
        <-8.850914, -2.497476, 90.500000>,
        <-9.249980, -2.832346, 90.500000>,
        < -5.260481, -3.010527, 90.500000>
      }
      triangle {
        <-8.590453, -2.046327, 90.500000>,
        <-8.850914, -2.497476, 90.500000>,
        < -5.260481, -3.010527, 90.500000>
      }
      triangle {
        <-5.750000, -2.832369, 89.500000>,
        <-5.260481, -3.010527, 90.500000>,
        < -5.260472, -3.010538, 89.500000>
      }
      triangle {
        <-0.260481, -3.010527, 90.500000>,
        <-4.249980, -2.832346, 90.500000>,
        < -4.739519, -3.010527, 90.500000>
      }
      triangle {
        <-4.739528, -3.010538, 89.500000>,
        <-4.739519, -3.010527, 90.500000>,
        < -4.249980, -2.832346, 90.500000>
      }
      triangle {
        <-5.260472, -3.010538, 89.500000>,
        <-4.739519, -3.010527, 90.500000>,
        < -4.739528, -3.010538, 89.500000>
      }
      triangle {
        <-0.260481, -3.010527, 90.500000>,
        <-3.850914, -2.497476, 90.500000>,
        < -4.249980, -2.832346, 90.500000>
      }
      triangle {
        <-4.250000, -2.832369, 89.500000>,
        <-4.249980, -2.832346, 90.500000>,
        < -3.850914, -2.497476, 90.500000>
      }
      triangle {
        <-4.739528, -3.010538, 89.500000>,
        <-4.249980, -2.832346, 90.500000>,
        < -4.250000, -2.832369, 89.500000>
      }
      triangle {
        <-0.260481, -3.010527, 90.500000>,
        <-3.590453, -2.046327, 90.500000>,
        < -3.850914, -2.497476, 90.500000>
      }
      triangle {
        <-3.850933, -2.497507, 89.500000>,
        <-3.850914, -2.497476, 90.500000>,
        < -3.590453, -2.046327, 90.500000>
      }
      triangle {
        <-4.250000, -2.832369, 89.500000>,
        <-3.850914, -2.497476, 90.500000>,
        < -3.850933, -2.497507, 89.500000>
      }
      triangle {
        <-0.750021, -2.832346, 90.500000>,
        <-3.500000, -1.533327, 90.500000>,
        < -3.590453, -2.046327, 90.500000>
      }
      triangle {
        <-3.590461, -2.046358, 89.500000>,
        <-3.590453, -2.046327, 90.500000>,
        < -3.500000, -1.533327, 90.500000>
      }
      triangle {
        <-0.260481, -3.010527, 90.500000>,
        <-0.750021, -2.832346, 90.500000>,
        < -3.590453, -2.046327, 90.500000>
      }
      triangle {
        <-3.850933, -2.497507, 89.500000>,
        <-3.590453, -2.046327, 90.500000>,
        < -3.590461, -2.046358, 89.500000>
      }
      triangle {
        <-1.409547, -2.046327, 90.500000>,
        <-3.500000, 3.466673, 90.500000>,
        < -3.500000, -1.533327, 90.500000>
      }
      triangle {
        <-3.500000, -1.533327, 89.500000>,
        <-3.500000, -1.533327, 90.500000>,
        < -3.500000, 3.466673, 90.500000>
      }
      triangle {
        <-1.149086, -2.497476, 90.500000>,
        <-1.409547, -2.046327, 90.500000>,
        < -3.500000, -1.533327, 90.500000>
      }
      triangle {
        <-0.750021, -2.832346, 90.500000>,
        <-1.149086, -2.497476, 90.500000>,
        < -3.500000, -1.533327, 90.500000>
      }
      triangle {
        <-3.590461, -2.046358, 89.500000>,
        <-3.500000, -1.533327, 90.500000>,
        < -3.500000, -1.533327, 89.500000>
      }
      triangle {
        <-1.500000, -1.533327, 90.500000>,
        <-3.590453, 3.979673, 90.500000>,
        < -3.500000, 3.466673, 90.500000>
      }
      triangle {
        <-3.500000, 3.466673, 89.500000>,
        <-3.500000, 3.466673, 90.500000>,
        < -3.590453, 3.979673, 90.500000>
      }
      triangle {
        <-1.409547, -2.046327, 90.500000>,
        <-1.500000, -1.533327, 90.500000>,
        < -3.500000, 3.466673, 90.500000>
      }
      triangle {
        <-3.500000, -1.533327, 89.500000>,
        <-3.500000, 3.466673, 90.500000>,
        < -3.500000, 3.466673, 89.500000>
      }
      triangle {
        <-1.500000, 3.466673, 90.500000>,
        <-3.850914, 4.430822, 90.500000>,
        < -3.590453, 3.979673, 90.500000>
      }
      triangle {
        <-3.590461, 3.979704, 89.500000>,
        <-3.590453, 3.979673, 90.500000>,
        < -3.850914, 4.430822, 90.500000>
      }
      triangle {
        <-1.500000, -1.533327, 90.500000>,
        <-1.500000, 3.466673, 90.500000>,
        < -3.590453, 3.979673, 90.500000>
      }
      triangle {
        <-3.500000, 3.466673, 89.500000>,
        <-3.590453, 3.979673, 90.500000>,
        < -3.590461, 3.979704, 89.500000>
      }
      triangle {
        <-1.500000, 3.466673, 90.500000>,
        <-4.249980, 4.765692, 90.500000>,
        < -3.850914, 4.430822, 90.500000>
      }
      triangle {
        <-3.850933, 4.430853, 89.500000>,
        <-3.850914, 4.430822, 90.500000>,
        < -4.249980, 4.765692, 90.500000>
      }
      triangle {
        <-3.590461, 3.979704, 89.500000>,
        <-3.850914, 4.430822, 90.500000>,
        < -3.850933, 4.430853, 89.500000>
      }
      triangle {
        <-1.409547, 3.979673, 90.500000>,
        <-4.739519, 4.943873, 90.500000>,
        < -4.249980, 4.765692, 90.500000>
      }
      triangle {
        <-4.250000, 4.765715, 89.500000>,
        <-4.249980, 4.765692, 90.500000>,
        < -4.739519, 4.943873, 90.500000>
      }
      triangle {
        <-1.500000, 3.466673, 90.500000>,
        <-1.409547, 3.979673, 90.500000>,
        < -4.249980, 4.765692, 90.500000>
      }
      triangle {
        <-3.850933, 4.430853, 89.500000>,
        <-4.249980, 4.765692, 90.500000>,
        < -4.250000, 4.765715, 89.500000>
      }
      triangle {
        <-4.739528, 4.943884, 89.500000>,
        <-4.739519, 4.943873, 90.500000>,
        < -5.260481, 4.943873, 90.500000>
      }
      triangle {
        <-1.149086, 4.430822, 90.500000>,
        <-0.750021, 4.765692, 90.500000>,
        < -4.739519, 4.943873, 90.500000>
      }
      triangle {
        <-1.409547, 3.979673, 90.500000>,
        <-1.149086, 4.430822, 90.500000>,
        < -4.739519, 4.943873, 90.500000>
      }
      triangle {
        <-4.250000, 4.765715, 89.500000>,
        <-4.739519, 4.943873, 90.500000>,
        < -4.739528, 4.943884, 89.500000>
      }
      triangle {
        <-5.260472, 4.943884, 89.500000>,
        <-5.260481, 4.943873, 90.500000>,
        < -5.750020, 4.765692, 90.500000>
      }
      triangle {
        <-4.739528, 4.943884, 89.500000>,
        <-5.260481, 4.943873, 90.500000>,
        < -5.260472, 4.943884, 89.500000>
      }
      triangle {
        <-9.739519, 4.943873, 90.500000>,
        <-6.149086, 4.430822, 90.500000>,
        < -5.750020, 4.765692, 90.500000>
      }
      triangle {
        <-5.750000, 4.765715, 89.500000>,
        <-5.750020, 4.765692, 90.500000>,
        < -6.149086, 4.430822, 90.500000>
      }
      triangle {
        <-5.260472, 4.943884, 89.500000>,
        <-5.750020, 4.765692, 90.500000>,
        < -5.750000, 4.765715, 89.500000>
      }
      triangle {
        <-9.739519, 4.943873, 90.500000>,
        <-6.409547, 3.979673, 90.500000>,
        < -6.149086, 4.430822, 90.500000>
      }
      triangle {
        <-6.149067, 4.430853, 89.500000>,
        <-6.149086, 4.430822, 90.500000>,
        < -6.409547, 3.979673, 90.500000>
      }
      triangle {
        <-5.750000, 4.765715, 89.500000>,
        <-6.149086, 4.430822, 90.500000>,
        < -6.149067, 4.430853, 89.500000>
      }
      triangle {
        <-9.739519, 4.943873, 90.500000>,
        <-9.249980, 4.765692, 90.500000>,
        < -6.409547, 3.979673, 90.500000>
      }
      triangle {
        <-6.149067, 4.430853, 89.500000>,
        <-6.409547, 3.979673, 90.500000>,
        < -6.409539, 3.979704, 89.500000>
      }
      triangle {
        <3.500000, -1.533327, 90.500000>,
        <1.409547, 3.979673, 90.500000>,
        < 1.500000, 3.466673, 90.500000>
      }
      triangle {
        <1.500000, 3.466673, 89.500000>,
        <1.500000, 3.466673, 90.500000>,
        < 1.409547, 3.979673, 90.500000>
      }
      triangle {
        <3.590453, -2.046327, 90.500000>,
        <1.500000, 3.466673, 90.500000>,
        < 1.500000, -1.533327, 90.500000>
      }
      triangle {
        <1.500000, -1.533327, 89.500000>,
        <1.500000, -1.533327, 90.500000>,
        < 1.500000, 3.466673, 90.500000>
      }
      triangle {
        <3.590453, -2.046327, 90.500000>,
        <3.500000, -1.533327, 90.500000>,
        < 1.500000, 3.466673, 90.500000>
      }
      triangle {
        <1.500000, -1.533327, 89.500000>,
        <1.500000, 3.466673, 90.500000>,
        < 1.500000, 3.466673, 89.500000>
      }
      triangle {
        <3.500000, 3.466673, 90.500000>,
        <1.149086, 4.430822, 90.500000>,
        < 1.409547, 3.979673, 90.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.409547, 3.979673, 90.500000>,
        < 1.149086, 4.430822, 90.500000>
      }
      triangle {
        <3.500000, -1.533327, 90.500000>,
        <3.500000, 3.466673, 90.500000>,
        < 1.409547, 3.979673, 90.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.500000, 3.466673, 89.500000>,
        < 1.409547, 3.979673, 90.500000>
      }
      triangle {
        <3.500000, 3.466673, 90.500000>,
        <0.750021, 4.765692, 90.500000>,
        < 1.149086, 4.430822, 90.500000>
      }
      triangle {
        <1.149067, 4.430853, 89.500000>,
        <1.149086, 4.430822, 90.500000>,
        < 0.750021, 4.765692, 90.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.149086, 4.430822, 90.500000>,
        < 1.149067, 4.430853, 89.500000>
      }
      triangle {
        <3.590453, 3.979673, 90.500000>,
        <0.260481, 4.943873, 90.500000>,
        < 0.750021, 4.765692, 90.500000>
      }
      triangle {
        <0.750000, 4.765715, 89.500000>,
        <0.750021, 4.765692, 90.500000>,
        < 0.260481, 4.943873, 90.500000>
      }
      triangle {
        <3.590453, 3.979673, 90.500000>,
        <0.750021, 4.765692, 90.500000>,
        < 3.500000, 3.466673, 90.500000>
      }
      triangle {
        <1.149067, 4.430853, 89.500000>,
        <0.750021, 4.765692, 90.500000>,
        < 0.750000, 4.765715, 89.500000>
      }
      triangle {
        <0.260472, 4.943884, 89.500000>,
        <0.260481, 4.943873, 90.500000>,
        < -0.260481, 4.943873, 90.500000>
      }
      triangle {
        <4.249980, 4.765692, 90.500000>,
        <4.739519, 4.943873, 90.500000>,
        < 0.260481, 4.943873, 90.500000>
      }
      triangle {
        <3.850914, 4.430822, 90.500000>,
        <4.249980, 4.765692, 90.500000>,
        < 0.260481, 4.943873, 90.500000>
      }
      triangle {
        <3.590453, 3.979673, 90.500000>,
        <3.850914, 4.430822, 90.500000>,
        < 0.260481, 4.943873, 90.500000>
      }
      triangle {
        <0.750000, 4.765715, 89.500000>,
        <0.260481, 4.943873, 90.500000>,
        < 0.260472, 4.943884, 89.500000>
      }
      triangle {
        <-0.260472, 4.943884, 89.500000>,
        <-0.260481, 4.943873, 90.500000>,
        < -0.750021, 4.765692, 90.500000>
      }
      triangle {
        <0.260472, 4.943884, 89.500000>,
        <-0.260481, 4.943873, 90.500000>,
        < -0.260472, 4.943884, 89.500000>
      }
      triangle {
        <-0.750000, 4.765715, 89.500000>,
        <-0.750021, 4.765692, 90.500000>,
        < -1.149086, 4.430822, 90.500000>
      }
      triangle {
        <-0.260472, 4.943884, 89.500000>,
        <-0.750021, 4.765692, 90.500000>,
        < -0.750000, 4.765715, 89.500000>
      }
      triangle {
        <-1.149067, 4.430853, 89.500000>,
        <-1.149086, 4.430822, 90.500000>,
        < -1.409547, 3.979673, 90.500000>
      }
      triangle {
        <-0.750000, 4.765715, 89.500000>,
        <-1.149086, 4.430822, 90.500000>,
        < -1.149067, 4.430853, 89.500000>
      }
      triangle {
        <-1.409539, 3.979704, 89.500000>,
        <-1.409547, 3.979673, 90.500000>,
        < -1.500000, 3.466673, 90.500000>
      }
      triangle {
        <-1.149067, 4.430853, 89.500000>,
        <-1.409547, 3.979673, 90.500000>,
        < -1.409539, 3.979704, 89.500000>
      }
      triangle {
        <-1.500000, 3.466673, 89.500000>,
        <-1.500000, 3.466673, 90.500000>,
        < -1.500000, -1.533327, 90.500000>
      }
      triangle {
        <-1.409539, 3.979704, 89.500000>,
        <-1.500000, 3.466673, 90.500000>,
        < -1.500000, 3.466673, 89.500000>
      }
      triangle {
        <-1.500000, -1.533327, 89.500000>,
        <-1.500000, -1.533327, 90.500000>,
        < -1.409547, -2.046327, 90.500000>
      }
      triangle {
        <-1.500000, 3.466673, 89.500000>,
        <-1.500000, -1.533327, 90.500000>,
        < -1.500000, -1.533327, 89.500000>
      }
      triangle {
        <-1.149067, -2.497507, 89.500000>,
        <-1.409547, -2.046327, 90.500000>,
        < -1.149086, -2.497476, 90.500000>
      }
      triangle {
        <-1.409539, -2.046358, 89.500000>,
        <-1.409547, -2.046327, 90.500000>,
        < -1.149067, -2.497507, 89.500000>
      }
      triangle {
        <-1.500000, -1.533327, 89.500000>,
        <-1.409547, -2.046327, 90.500000>,
        < -1.409539, -2.046358, 89.500000>
      }
      triangle {
        <-0.750000, -2.832369, 89.500000>,
        <-1.149086, -2.497476, 90.500000>,
        < -0.750021, -2.832346, 90.500000>
      }
      triangle {
        <-1.149067, -2.497507, 89.500000>,
        <-1.149086, -2.497476, 90.500000>,
        < -0.750000, -2.832369, 89.500000>
      }
      triangle {
        <-0.750000, -2.832369, 89.500000>,
        <-0.750021, -2.832346, 90.500000>,
        < -0.260481, -3.010527, 90.500000>
      }
      triangle {
        <-0.260472, -3.010538, 89.500000>,
        <-0.260481, -3.010527, 90.500000>,
        < 0.260481, -3.010527, 90.500000>
      }
      triangle {
        <-0.750000, -2.832369, 89.500000>,
        <-0.260481, -3.010527, 90.500000>,
        < -0.260472, -3.010538, 89.500000>
      }
      triangle {
        <4.739519, -3.010527, 90.500000>,
        <0.750021, -2.832346, 90.500000>,
        < 0.260481, -3.010527, 90.500000>
      }
      triangle {
        <0.260472, -3.010538, 89.500000>,
        <0.260481, -3.010527, 90.500000>,
        < 0.750021, -2.832346, 90.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <4.739519, -3.010527, 90.500000>,
        < 0.260481, -3.010527, 90.500000>
      }
      triangle {
        <-0.260472, -3.010538, 89.500000>,
        <0.260481, -3.010527, 90.500000>,
        < 0.260472, -3.010538, 89.500000>
      }
      triangle {
        <4.739519, -3.010527, 90.500000>,
        <1.149086, -2.497476, 90.500000>,
        < 0.750021, -2.832346, 90.500000>
      }
      triangle {
        <0.750000, -2.832369, 89.500000>,
        <0.750021, -2.832346, 90.500000>,
        < 1.149086, -2.497476, 90.500000>
      }
      triangle {
        <0.260472, -3.010538, 89.500000>,
        <0.750021, -2.832346, 90.500000>,
        < 0.750000, -2.832369, 89.500000>
      }
      triangle {
        <4.739519, -3.010527, 90.500000>,
        <1.409547, -2.046327, 90.500000>,
        < 1.149086, -2.497476, 90.500000>
      }
      triangle {
        <1.149067, -2.497507, 89.500000>,
        <1.149086, -2.497476, 90.500000>,
        < 1.409547, -2.046327, 90.500000>
      }
      triangle {
        <0.750000, -2.832369, 89.500000>,
        <1.149086, -2.497476, 90.500000>,
        < 1.149067, -2.497507, 89.500000>
      }
      triangle {
        <4.249980, -2.832346, 90.500000>,
        <1.500000, -1.533327, 90.500000>,
        < 1.409547, -2.046327, 90.500000>
      }
      triangle {
        <1.409539, -2.046358, 89.500000>,
        <1.409547, -2.046327, 90.500000>,
        < 1.500000, -1.533327, 90.500000>
      }
      triangle {
        <4.739519, -3.010527, 90.500000>,
        <4.249980, -2.832346, 90.500000>,
        < 1.409547, -2.046327, 90.500000>
      }
      triangle {
        <1.149067, -2.497507, 89.500000>,
        <1.409547, -2.046327, 90.500000>,
        < 1.409539, -2.046358, 89.500000>
      }
      triangle {
        <3.850914, -2.497476, 90.500000>,
        <3.590453, -2.046327, 90.500000>,
        < 1.500000, -1.533327, 90.500000>
      }
      triangle {
        <4.249980, -2.832346, 90.500000>,
        <3.850914, -2.497476, 90.500000>,
        < 1.500000, -1.533327, 90.500000>
      }
      triangle {
        <1.409539, -2.046358, 89.500000>,
        <1.500000, -1.533327, 90.500000>,
        < 1.500000, -1.533327, 89.500000>
      }
      triangle {
        <-8.500000, 3.466673, 89.500000>,
        <-8.500000, 3.466673, 90.500000>,
        < -8.590453, 3.979673, 90.500000>
      }
      triangle {
        <-8.500000, -1.533327, 89.500000>,
        <-8.500000, -1.533327, 90.500000>,
        < -8.500000, 3.466673, 90.500000>
      }
      triangle {
        <-8.500000, -1.533327, 89.500000>,
        <-8.500000, 3.466673, 90.500000>,
        < -8.500000, 3.466673, 89.500000>
      }
      triangle {
        <-8.850933, 4.430853, 89.500000>,
        <-8.590453, 3.979673, 90.500000>,
        < -8.850914, 4.430822, 90.500000>
      }
      triangle {
        <-8.590461, 3.979704, 89.500000>,
        <-8.500000, 3.466673, 89.500000>,
        < -8.590453, 3.979673, 90.500000>
      }
      triangle {
        <-8.590461, 3.979704, 89.500000>,
        <-8.590453, 3.979673, 90.500000>,
        < -8.850933, 4.430853, 89.500000>
      }
      triangle {
        <-8.850933, 4.430853, 89.500000>,
        <-8.850914, 4.430822, 90.500000>,
        < -9.249980, 4.765692, 90.500000>
      }
      triangle {
        <-9.250000, 4.765715, 89.500000>,
        <-9.249980, 4.765692, 90.500000>,
        < -9.739519, 4.943873, 90.500000>
      }
      triangle {
        <-8.850933, 4.430853, 89.500000>,
        <-9.249980, 4.765692, 90.500000>,
        < -9.250000, 4.765715, 89.500000>
      }
      triangle {
        <-9.739528, 4.943884, 89.500000>,
        <-9.739519, 4.943873, 90.500000>,
        < -10.260480, 4.943873, 90.500000>
      }
      triangle {
        <-9.250000, 4.765715, 89.500000>,
        <-9.739519, 4.943873, 90.500000>,
        < -9.739528, 4.943884, 89.500000>
      }
      triangle {
        <-10.260470, 4.943884, 89.500000>,
        <-10.260480, 4.943873, 90.500000>,
        < -10.750020, 4.765692, 90.500000>
      }
      triangle {
        <-9.739528, 4.943884, 89.500000>,
        <-10.260480, 4.943873, 90.500000>,
        < -10.260470, 4.943884, 89.500000>
      }
      triangle {
        <-14.739520, 4.943873, 90.500000>,
        <-11.149090, 4.430822, 90.500000>,
        < -10.750020, 4.765692, 90.500000>
      }
      triangle {
        <-10.750000, 4.765715, 89.500000>,
        <-10.750020, 4.765692, 90.500000>,
        < -11.149090, 4.430822, 90.500000>
      }
      triangle {
        <-19.000000, 5.341673, 90.500000>,
        <-14.739520, 4.943873, 90.500000>,
        < -10.750020, 4.765692, 90.500000>
      }
      triangle {
        <-10.260470, 4.943884, 89.500000>,
        <-10.750020, 4.765692, 90.500000>,
        < -10.750000, 4.765715, 89.500000>
      }
      triangle {
        <-14.739520, 4.943873, 90.500000>,
        <-11.409550, 3.979673, 90.500000>,
        < -11.149090, 4.430822, 90.500000>
      }
      triangle {
        <-11.149070, 4.430853, 89.500000>,
        <-11.149090, 4.430822, 90.500000>,
        < -11.409550, 3.979673, 90.500000>
      }
      triangle {
        <-10.750000, 4.765715, 89.500000>,
        <-11.149090, 4.430822, 90.500000>,
        < -11.149070, 4.430853, 89.500000>
      }
      triangle {
        <-14.249980, 4.765692, 90.500000>,
        <-11.500000, 3.466673, 90.500000>,
        < -11.409550, 3.979673, 90.500000>
      }
      triangle {
        <-11.409540, 3.979704, 89.500000>,
        <-11.409550, 3.979673, 90.500000>,
        < -11.500000, 3.466673, 90.500000>
      }
      triangle {
        <-14.739520, 4.943873, 90.500000>,
        <-14.249980, 4.765692, 90.500000>,
        < -11.409550, 3.979673, 90.500000>
      }
      triangle {
        <-11.149070, 4.430853, 89.500000>,
        <-11.409550, 3.979673, 90.500000>,
        < -11.409540, 3.979704, 89.500000>
      }
      triangle {
        <-13.590450, 3.979673, 90.500000>,
        <-11.500000, -1.533327, 90.500000>,
        < -11.500000, 3.466673, 90.500000>
      }
      triangle {
        <-11.500000, 3.466673, 89.500000>,
        <-11.500000, 3.466673, 90.500000>,
        < -11.500000, -1.533327, 90.500000>
      }
      triangle {
        <-13.850910, 4.430822, 90.500000>,
        <-13.590450, 3.979673, 90.500000>,
        < -11.500000, 3.466673, 90.500000>
      }
      triangle {
        <-14.249980, 4.765692, 90.500000>,
        <-13.850910, 4.430822, 90.500000>,
        < -11.500000, 3.466673, 90.500000>
      }
      triangle {
        <-11.409540, 3.979704, 89.500000>,
        <-11.500000, 3.466673, 90.500000>,
        < -11.500000, 3.466673, 89.500000>
      }
      triangle {
        <-13.500000, 3.466673, 90.500000>,
        <-11.409550, -2.046327, 90.500000>,
        < -11.500000, -1.533327, 90.500000>
      }
      triangle {
        <-11.500000, -1.533327, 89.500000>,
        <-11.500000, -1.533327, 90.500000>,
        < -11.409550, -2.046327, 90.500000>
      }
      triangle {
        <-13.590450, 3.979673, 90.500000>,
        <-13.500000, 3.466673, 90.500000>,
        < -11.500000, -1.533327, 90.500000>
      }
      triangle {
        <-11.500000, 3.466673, 89.500000>,
        <-11.500000, -1.533327, 90.500000>,
        < -11.500000, -1.533327, 89.500000>
      }
      triangle {
        <-13.500000, -1.533327, 90.500000>,
        <-11.149090, -2.497476, 90.500000>,
        < -11.409550, -2.046327, 90.500000>
      }
      triangle {
        <-11.149070, -2.497507, 89.500000>,
        <-11.409550, -2.046327, 90.500000>,
        < -11.149090, -2.497476, 90.500000>
      }
      triangle {
        <-13.500000, 3.466673, 90.500000>,
        <-13.500000, -1.533327, 90.500000>,
        < -11.409550, -2.046327, 90.500000>
      }
      triangle {
        <-11.409540, -2.046358, 89.500000>,
        <-11.409550, -2.046327, 90.500000>,
        < -11.149070, -2.497507, 89.500000>
      }
      triangle {
        <-11.500000, -1.533327, 89.500000>,
        <-11.409550, -2.046327, 90.500000>,
        < -11.409540, -2.046358, 89.500000>
      }
      triangle {
        <-13.500000, -1.533327, 90.500000>,
        <-10.750020, -2.832346, 90.500000>,
        < -11.149090, -2.497476, 90.500000>
      }
      triangle {
        <-11.149070, -2.497507, 89.500000>,
        <-11.149090, -2.497476, 90.500000>,
        < -10.750020, -2.832346, 90.500000>
      }
      triangle {
        <-13.590450, -2.046327, 90.500000>,
        <-10.260480, -3.010527, 90.500000>,
        < -10.750020, -2.832346, 90.500000>
      }
      triangle {
        <-10.750000, -2.832369, 89.500000>,
        <-10.750020, -2.832346, 90.500000>,
        < -10.260480, -3.010527, 90.500000>
      }
      triangle {
        <-13.500000, -1.533327, 90.500000>,
        <-13.590450, -2.046327, 90.500000>,
        < -10.750020, -2.832346, 90.500000>
      }
      triangle {
        <-11.149070, -2.497507, 89.500000>,
        <-10.750020, -2.832346, 90.500000>,
        < -10.750000, -2.832369, 89.500000>
      }
      triangle {
        <-9.739528, -3.010538, 89.500000>,
        <-10.260480, -3.010527, 90.500000>,
        < -9.739519, -3.010527, 90.500000>
      }
      triangle {
        <-14.249980, -2.832346, 90.500000>,
        <-14.739520, -3.010527, 90.500000>,
        < -10.260480, -3.010527, 90.500000>
      }
      triangle {
        <-13.850910, -2.497476, 90.500000>,
        <-14.249980, -2.832346, 90.500000>,
        < -10.260480, -3.010527, 90.500000>
      }
      triangle {
        <-13.590450, -2.046327, 90.500000>,
        <-13.850910, -2.497476, 90.500000>,
        < -10.260480, -3.010527, 90.500000>
      }
      triangle {
        <-10.260470, -3.010538, 89.500000>,
        <-10.260480, -3.010527, 90.500000>,
        < -9.739528, -3.010538, 89.500000>
      }
      triangle {
        <-10.750000, -2.832369, 89.500000>,
        <-10.260480, -3.010527, 90.500000>,
        < -10.260470, -3.010538, 89.500000>
      }
      triangle {
        <-9.739528, -3.010538, 89.500000>,
        <-9.739519, -3.010527, 90.500000>,
        < -9.249980, -2.832346, 90.500000>
      }
      triangle {
        <-9.250000, -2.832369, 89.500000>,
        <-9.249980, -2.832346, 90.500000>,
        < -8.850914, -2.497476, 90.500000>
      }
      triangle {
        <-9.739528, -3.010538, 89.500000>,
        <-9.249980, -2.832346, 90.500000>,
        < -9.250000, -2.832369, 89.500000>
      }
      triangle {
        <-8.850933, -2.497507, 89.500000>,
        <-8.850914, -2.497476, 90.500000>,
        < -8.590453, -2.046327, 90.500000>
      }
      triangle {
        <-9.250000, -2.832369, 89.500000>,
        <-8.850914, -2.497476, 90.500000>,
        < -8.850933, -2.497507, 89.500000>
      }
      triangle {
        <-8.590461, -2.046358, 89.500000>,
        <-8.590453, -2.046327, 90.500000>,
        < -8.500000, -1.533327, 90.500000>
      }
      triangle {
        <-8.850933, -2.497507, 89.500000>,
        <-8.590453, -2.046327, 90.500000>,
        < -8.590461, -2.046358, 89.500000>
      }
      triangle {
        <-8.590461, -2.046358, 89.500000>,
        <-8.500000, -1.533327, 90.500000>,
        < -8.500000, -1.533327, 89.500000>
      }
      triangle {
        <-17.692310, 4.391604, 90.500000>,
        <-16.500000, -1.533327, 90.500000>,
        < -16.500000, 3.466673, 90.500000>
      }
      triangle {
        <-16.500000, 3.466673, 89.500000>,
        <-16.500000, 3.466673, 90.500000>,
        < -16.500000, -1.533327, 90.500000>
      }
      triangle {
        <-18.191790, 5.079062, 90.500000>,
        <-16.500000, 3.466673, 90.500000>,
        < -16.409550, 3.979673, 90.500000>
      }
      triangle {
        <-16.409540, 3.979704, 89.500000>,
        <-16.409550, 3.979673, 90.500000>,
        < -16.500000, 3.466673, 90.500000>
      }
      triangle {
        <-17.887609, 4.774881, 90.500000>,
        <-17.692310, 4.391604, 90.500000>,
        < -16.500000, 3.466673, 90.500000>
      }
      triangle {
        <-18.191790, 5.079062, 90.500000>,
        <-17.887609, 4.774881, 90.500000>,
        < -16.500000, 3.466673, 90.500000>
      }
      triangle {
        <-16.409540, 3.979704, 89.500000>,
        <-16.500000, 3.466673, 90.500000>,
        < -16.500000, 3.466673, 89.500000>
      }
      triangle {
        <-17.625000, 3.966673, 90.500000>,
        <-16.409550, -2.046327, 90.500000>,
        < -16.500000, -1.533327, 90.500000>
      }
      triangle {
        <-16.500000, -1.533327, 89.500000>,
        <-16.500000, -1.533327, 90.500000>,
        < -16.409550, -2.046327, 90.500000>
      }
      triangle {
        <-17.692310, 4.391604, 90.500000>,
        <-17.625000, 3.966673, 90.500000>,
        < -16.500000, -1.533327, 90.500000>
      }
      triangle {
        <-16.500000, -1.533327, 89.500000>,
        <-16.500000, 3.466673, 89.500000>,
        < -16.500000, -1.533327, 90.500000>
      }
      triangle {
        <-17.625000, -2.033327, 90.500000>,
        <-16.149090, -2.497476, 90.500000>,
        < -16.409550, -2.046327, 90.500000>
      }
      triangle {
        <-16.409540, -2.046358, 89.500000>,
        <-16.409550, -2.046327, 90.500000>,
        < -16.149090, -2.497476, 90.500000>
      }
      triangle {
        <-17.625000, 3.966673, 90.500000>,
        <-17.625000, -2.033327, 90.500000>,
        < -16.409550, -2.046327, 90.500000>
      }
      triangle {
        <-16.500000, -1.533327, 89.500000>,
        <-16.409550, -2.046327, 90.500000>,
        < -16.409540, -2.046358, 89.500000>
      }
      triangle {
        <-17.625000, -2.033327, 90.500000>,
        <-15.750020, -2.832346, 90.500000>,
        < -16.149090, -2.497476, 90.500000>
      }
      triangle {
        <-16.149071, -2.497507, 89.500000>,
        <-16.149090, -2.497476, 90.500000>,
        < -15.750020, -2.832346, 90.500000>
      }
      triangle {
        <-16.409540, -2.046358, 89.500000>,
        <-16.149090, -2.497476, 90.500000>,
        < -16.149071, -2.497507, 89.500000>
      }
      triangle {
        <-17.692310, -2.458258, 90.500000>,
        <-15.260480, -3.010527, 90.500000>,
        < -15.750020, -2.832346, 90.500000>
      }
      triangle {
        <-15.750000, -2.832369, 89.500000>,
        <-15.750020, -2.832346, 90.500000>,
        < -15.260480, -3.010527, 90.500000>
      }
      triangle {
        <-17.625000, -2.033327, 90.500000>,
        <-17.692310, -2.458258, 90.500000>,
        < -15.750020, -2.832346, 90.500000>
      }
      triangle {
        <-16.149071, -2.497507, 89.500000>,
        <-15.750020, -2.832346, 90.500000>,
        < -15.750000, -2.832369, 89.500000>
      }
      triangle {
        <-15.260470, -3.010538, 89.500000>,
        <-15.260480, -3.010527, 90.500000>,
        < -14.739520, -3.010527, 90.500000>
      }
      triangle {
        <-17.887609, -2.841535, 90.500000>,
        <-18.191790, -3.145716, 90.500000>,
        < -15.260480, -3.010527, 90.500000>
      }
      triangle {
        <-17.692310, -2.458258, 90.500000>,
        <-17.887609, -2.841535, 90.500000>,
        < -15.260480, -3.010527, 90.500000>
      }
      triangle {
        <-15.750000, -2.832369, 89.500000>,
        <-15.260480, -3.010527, 90.500000>,
        < -15.260470, -3.010538, 89.500000>
      }
      triangle {
        <-14.739530, -3.010538, 89.500000>,
        <-14.739520, -3.010527, 90.500000>,
        < -14.249980, -2.832346, 90.500000>
      }
      triangle {
        <-15.260470, -3.010538, 89.500000>,
        <-14.739520, -3.010527, 90.500000>,
        < -14.739530, -3.010538, 89.500000>
      }
      triangle {
        <-14.250000, -2.832369, 89.500000>,
        <-14.249980, -2.832346, 90.500000>,
        < -13.850910, -2.497476, 90.500000>
      }
      triangle {
        <-14.739530, -3.010538, 89.500000>,
        <-14.249980, -2.832346, 90.500000>,
        < -14.250000, -2.832369, 89.500000>
      }
      triangle {
        <-13.850930, -2.497507, 89.500000>,
        <-13.850910, -2.497476, 90.500000>,
        < -13.590450, -2.046327, 90.500000>
      }
      triangle {
        <-14.250000, -2.832369, 89.500000>,
        <-13.850910, -2.497476, 90.500000>,
        < -13.850930, -2.497507, 89.500000>
      }
      triangle {
        <-13.590460, -2.046358, 89.500000>,
        <-13.590450, -2.046327, 90.500000>,
        < -13.500000, -1.533327, 90.500000>
      }
      triangle {
        <-13.850930, -2.497507, 89.500000>,
        <-13.590450, -2.046327, 90.500000>,
        < -13.590460, -2.046358, 89.500000>
      }
      triangle {
        <-13.500000, -1.533327, 89.500000>,
        <-13.500000, -1.533327, 90.500000>,
        < -13.500000, 3.466673, 90.500000>
      }
      triangle {
        <-13.590460, -2.046358, 89.500000>,
        <-13.500000, -1.533327, 90.500000>,
        < -13.500000, -1.533327, 89.500000>
      }
      triangle {
        <-13.500000, 3.466673, 89.500000>,
        <-13.500000, 3.466673, 90.500000>,
        < -13.590450, 3.979673, 90.500000>
      }
      triangle {
        <-13.500000, -1.533327, 89.500000>,
        <-13.500000, 3.466673, 90.500000>,
        < -13.500000, 3.466673, 89.500000>
      }
      triangle {
        <-13.590460, 3.979704, 89.500000>,
        <-13.590450, 3.979673, 90.500000>,
        < -13.850910, 4.430822, 90.500000>
      }
      triangle {
        <-13.500000, 3.466673, 89.500000>,
        <-13.590450, 3.979673, 90.500000>,
        < -13.590460, 3.979704, 89.500000>
      }
      triangle {
        <-13.850930, 4.430853, 89.500000>,
        <-13.850910, 4.430822, 90.500000>,
        < -14.249980, 4.765692, 90.500000>
      }
      triangle {
        <-13.590460, 3.979704, 89.500000>,
        <-13.850910, 4.430822, 90.500000>,
        < -13.850930, 4.430853, 89.500000>
      }
      triangle {
        <-14.250000, 4.765715, 89.500000>,
        <-14.249980, 4.765692, 90.500000>,
        < -14.739520, 4.943873, 90.500000>
      }
      triangle {
        <-13.850930, 4.430853, 89.500000>,
        <-14.249980, 4.765692, 90.500000>,
        < -14.250000, 4.765715, 89.500000>
      }
      triangle {
        <-19.000000, 5.341673, 90.500000>,
        <-15.260480, 4.943873, 90.500000>,
        < -14.739520, 4.943873, 90.500000>
      }
      triangle {
        <-14.739530, 4.943884, 89.500000>,
        <-14.739520, 4.943873, 90.500000>,
        < -15.260480, 4.943873, 90.500000>
      }
      triangle {
        <-14.250000, 4.765715, 89.500000>,
        <-14.739520, 4.943873, 90.500000>,
        < -14.739530, 4.943884, 89.500000>
      }
      triangle {
        <-18.575069, 5.274363, 90.500000>,
        <-15.750020, 4.765692, 90.500000>,
        < -15.260480, 4.943873, 90.500000>
      }
      triangle {
        <-15.260470, 4.943884, 89.500000>,
        <-15.260480, 4.943873, 90.500000>,
        < -15.750020, 4.765692, 90.500000>
      }
      triangle {
        <-19.000000, 5.341673, 90.500000>,
        <-18.575069, 5.274363, 90.500000>,
        < -15.260480, 4.943873, 90.500000>
      }
      triangle {
        <-14.739530, 4.943884, 89.500000>,
        <-15.260480, 4.943873, 90.500000>,
        < -15.260470, 4.943884, 89.500000>
      }
      triangle {
        <-18.575069, 5.274363, 90.500000>,
        <-16.149090, 4.430822, 90.500000>,
        < -15.750020, 4.765692, 90.500000>
      }
      triangle {
        <-15.750000, 4.765715, 89.500000>,
        <-15.750020, 4.765692, 90.500000>,
        < -16.149090, 4.430822, 90.500000>
      }
      triangle {
        <-15.260470, 4.943884, 89.500000>,
        <-15.750020, 4.765692, 90.500000>,
        < -15.750000, 4.765715, 89.500000>
      }
      triangle {
        <-18.191790, 5.079062, 90.500000>,
        <-16.409550, 3.979673, 90.500000>,
        < -16.149090, 4.430822, 90.500000>
      }
      triangle {
        <-16.149071, 4.430853, 89.500000>,
        <-16.149090, 4.430822, 90.500000>,
        < -16.409550, 3.979673, 90.500000>
      }
      triangle {
        <-18.575069, 5.274363, 90.500000>,
        <-18.191790, 5.079062, 90.500000>,
        < -16.149090, 4.430822, 90.500000>
      }
      triangle {
        <-15.750000, 4.765715, 89.500000>,
        <-16.149090, 4.430822, 90.500000>,
        < -16.149071, 4.430853, 89.500000>
      }
      triangle {
        <-16.149071, 4.430853, 89.500000>,
        <-16.409550, 3.979673, 90.500000>,
        < -16.409540, 3.979704, 89.500000>
      }
      triangle {
        <13.500000, -1.533327, 90.500000>,
        <11.409550, 3.979673, 90.500000>,
        < 11.500000, 3.466673, 90.500000>
      }
      triangle {
        <11.500000, 3.466673, 89.500000>,
        <11.500000, 3.466673, 90.500000>,
        < 11.409550, 3.979673, 90.500000>
      }
      triangle {
        <13.590450, -2.046327, 90.500000>,
        <11.500000, 3.466673, 90.500000>,
        < 11.500000, -1.533327, 90.500000>
      }
      triangle {
        <11.500000, -1.533327, 89.500000>,
        <11.500000, -1.533327, 90.500000>,
        < 11.500000, 3.466673, 90.500000>
      }
      triangle {
        <13.590450, -2.046327, 90.500000>,
        <13.500000, -1.533327, 90.500000>,
        < 11.500000, 3.466673, 90.500000>
      }
      triangle {
        <11.500000, -1.533327, 89.500000>,
        <11.500000, 3.466673, 90.500000>,
        < 11.500000, 3.466673, 89.500000>
      }
      triangle {
        <13.500000, 3.466673, 90.500000>,
        <11.149090, 4.430822, 90.500000>,
        < 11.409550, 3.979673, 90.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.409550, 3.979673, 90.500000>,
        < 11.149090, 4.430822, 90.500000>
      }
      triangle {
        <13.500000, -1.533327, 90.500000>,
        <13.500000, 3.466673, 90.500000>,
        < 11.409550, 3.979673, 90.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.500000, 3.466673, 89.500000>,
        < 11.409550, 3.979673, 90.500000>
      }
      triangle {
        <13.500000, 3.466673, 90.500000>,
        <10.750020, 4.765692, 90.500000>,
        < 11.149090, 4.430822, 90.500000>
      }
      triangle {
        <10.750000, 4.765715, 89.500000>,
        <11.149090, 4.430822, 90.500000>,
        < 10.750020, 4.765692, 90.500000>
      }
      triangle {
        <11.149070, 4.430853, 89.500000>,
        <11.149090, 4.430822, 90.500000>,
        < 10.750000, 4.765715, 89.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.149090, 4.430822, 90.500000>,
        < 11.149070, 4.430853, 89.500000>
      }
      triangle {
        <13.590450, 3.979673, 90.500000>,
        <10.260480, 4.943873, 90.500000>,
        < 10.750020, 4.765692, 90.500000>
      }
      triangle {
        <10.750000, 4.765715, 89.500000>,
        <10.750020, 4.765692, 90.500000>,
        < 10.260480, 4.943873, 90.500000>
      }
      triangle {
        <13.590450, 3.979673, 90.500000>,
        <10.750020, 4.765692, 90.500000>,
        < 13.500000, 3.466673, 90.500000>
      }
      triangle {
        <10.260470, 4.943884, 89.500000>,
        <10.260480, 4.943873, 90.500000>,
        < 9.739519, 4.943873, 90.500000>
      }
      triangle {
        <14.249980, 4.765692, 90.500000>,
        <14.739520, 4.943873, 90.500000>,
        < 10.260480, 4.943873, 90.500000>
      }
      triangle {
        <13.850910, 4.430822, 90.500000>,
        <14.249980, 4.765692, 90.500000>,
        < 10.260480, 4.943873, 90.500000>
      }
      triangle {
        <13.590450, 3.979673, 90.500000>,
        <13.850910, 4.430822, 90.500000>,
        < 10.260480, 4.943873, 90.500000>
      }
      triangle {
        <10.750000, 4.765715, 89.500000>,
        <10.260480, 4.943873, 90.500000>,
        < 10.260470, 4.943884, 89.500000>
      }
      triangle {
        <5.260481, 4.943873, 90.500000>,
        <9.249980, 4.765692, 90.500000>,
        < 9.739519, 4.943873, 90.500000>
      }
      triangle {
        <9.739528, 4.943884, 89.500000>,
        <9.739519, 4.943873, 90.500000>,
        < 9.249980, 4.765692, 90.500000>
      }
      triangle {
        <10.260470, 4.943884, 89.500000>,
        <9.739519, 4.943873, 90.500000>,
        < 9.739528, 4.943884, 89.500000>
      }
      triangle {
        <5.260481, 4.943873, 90.500000>,
        <8.850914, 4.430822, 90.500000>,
        < 9.249980, 4.765692, 90.500000>
      }
      triangle {
        <9.250000, 4.765715, 89.500000>,
        <9.249980, 4.765692, 90.500000>,
        < 8.850914, 4.430822, 90.500000>
      }
      triangle {
        <9.739528, 4.943884, 89.500000>,
        <9.249980, 4.765692, 90.500000>,
        < 9.250000, 4.765715, 89.500000>
      }
      triangle {
        <5.260481, 4.943873, 90.500000>,
        <8.590453, 3.979673, 90.500000>,
        < 8.850914, 4.430822, 90.500000>
      }
      triangle {
        <8.850933, 4.430853, 89.500000>,
        <8.850914, 4.430822, 90.500000>,
        < 8.590453, 3.979673, 90.500000>
      }
      triangle {
        <9.250000, 4.765715, 89.500000>,
        <8.850914, 4.430822, 90.500000>,
        < 8.850933, 4.430853, 89.500000>
      }
      triangle {
        <5.750020, 4.765692, 90.500000>,
        <8.500000, 3.466673, 90.500000>,
        < 8.590453, 3.979673, 90.500000>
      }
      triangle {
        <8.590461, 3.979704, 89.500000>,
        <8.590453, 3.979673, 90.500000>,
        < 8.500000, 3.466673, 90.500000>
      }
      triangle {
        <5.260481, 4.943873, 90.500000>,
        <5.750020, 4.765692, 90.500000>,
        < 8.590453, 3.979673, 90.500000>
      }
      triangle {
        <8.850933, 4.430853, 89.500000>,
        <8.590453, 3.979673, 90.500000>,
        < 8.590461, 3.979704, 89.500000>
      }
      triangle {
        <6.409547, 3.979673, 90.500000>,
        <8.500000, -1.533327, 90.500000>,
        < 8.500000, 3.466673, 90.500000>
      }
      triangle {
        <8.500000, 3.466673, 89.500000>,
        <8.500000, 3.466673, 90.500000>,
        < 8.500000, -1.533327, 90.500000>
      }
      triangle {
        <6.149086, 4.430822, 90.500000>,
        <6.409547, 3.979673, 90.500000>,
        < 8.500000, 3.466673, 90.500000>
      }
      triangle {
        <5.750020, 4.765692, 90.500000>,
        <6.149086, 4.430822, 90.500000>,
        < 8.500000, 3.466673, 90.500000>
      }
      triangle {
        <8.590461, 3.979704, 89.500000>,
        <8.500000, 3.466673, 90.500000>,
        < 8.500000, 3.466673, 89.500000>
      }
      triangle {
        <6.500000, 3.466673, 90.500000>,
        <8.590453, -2.046327, 90.500000>,
        < 8.500000, -1.533327, 90.500000>
      }
      triangle {
        <8.500000, -1.533327, 89.500000>,
        <8.500000, -1.533327, 90.500000>,
        < 8.590453, -2.046327, 90.500000>
      }
      triangle {
        <6.409547, 3.979673, 90.500000>,
        <6.500000, 3.466673, 90.500000>,
        < 8.500000, -1.533327, 90.500000>
      }
      triangle {
        <8.500000, 3.466673, 89.500000>,
        <8.500000, -1.533327, 90.500000>,
        < 8.500000, -1.533327, 89.500000>
      }
      triangle {
        <6.500000, -1.533327, 90.500000>,
        <8.850914, -2.497476, 90.500000>,
        < 8.590453, -2.046327, 90.500000>
      }
      triangle {
        <8.590461, -2.046358, 89.500000>,
        <8.590453, -2.046327, 90.500000>,
        < 8.850914, -2.497476, 90.500000>
      }
      triangle {
        <6.500000, 3.466673, 90.500000>,
        <6.500000, -1.533327, 90.500000>,
        < 8.590453, -2.046327, 90.500000>
      }
      triangle {
        <8.500000, -1.533327, 89.500000>,
        <8.590453, -2.046327, 90.500000>,
        < 8.590461, -2.046358, 89.500000>
      }
      triangle {
        <6.500000, -1.533327, 90.500000>,
        <9.249980, -2.832346, 90.500000>,
        < 8.850914, -2.497476, 90.500000>
      }
      triangle {
        <8.850933, -2.497507, 89.500000>,
        <8.850914, -2.497476, 90.500000>,
        < 9.249980, -2.832346, 90.500000>
      }
      triangle {
        <8.590461, -2.046358, 89.500000>,
        <8.850914, -2.497476, 90.500000>,
        < 8.850933, -2.497507, 89.500000>
      }
      triangle {
        <6.409547, -2.046327, 90.500000>,
        <9.739519, -3.010527, 90.500000>,
        < 9.249980, -2.832346, 90.500000>
      }
      triangle {
        <9.250000, -2.832369, 89.500000>,
        <9.249980, -2.832346, 90.500000>,
        < 9.739519, -3.010527, 90.500000>
      }
      triangle {
        <6.500000, -1.533327, 90.500000>,
        <6.409547, -2.046327, 90.500000>,
        < 9.249980, -2.832346, 90.500000>
      }
      triangle {
        <8.850933, -2.497507, 89.500000>,
        <9.249980, -2.832346, 90.500000>,
        < 9.250000, -2.832369, 89.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <10.260480, -3.010527, 90.500000>,
        < 9.739519, -3.010527, 90.500000>
      }
      triangle {
        <9.739528, -3.010538, 89.500000>,
        <9.739519, -3.010527, 90.500000>,
        < 10.260480, -3.010527, 90.500000>
      }
      triangle {
        <5.750020, -2.832346, 90.500000>,
        <5.260481, -3.010527, 90.500000>,
        < 9.739519, -3.010527, 90.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <9.739519, -3.010527, 90.500000>,
        < 5.260481, -3.010527, 90.500000>
      }
      triangle {
        <6.149086, -2.497476, 90.500000>,
        <5.750020, -2.832346, 90.500000>,
        < 9.739519, -3.010527, 90.500000>
      }
      triangle {
        <6.409547, -2.046327, 90.500000>,
        <6.149086, -2.497476, 90.500000>,
        < 9.739519, -3.010527, 90.500000>
      }
      triangle {
        <9.250000, -2.832369, 89.500000>,
        <9.739519, -3.010527, 90.500000>,
        < 9.739528, -3.010538, 89.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <10.750020, -2.832346, 90.500000>,
        < 10.260480, -3.010527, 90.500000>
      }
      triangle {
        <10.260470, -3.010538, 89.500000>,
        <10.260480, -3.010527, 90.500000>,
        < 10.750020, -2.832346, 90.500000>
      }
      triangle {
        <9.739528, -3.010538, 89.500000>,
        <10.260480, -3.010527, 90.500000>,
        < 10.260470, -3.010538, 89.500000>
      }
      triangle {
        <14.739520, -3.010527, 90.500000>,
        <11.149090, -2.497476, 90.500000>,
        < 10.750020, -2.832346, 90.500000>
      }
      triangle {
        <10.750000, -2.832369, 89.500000>,
        <10.750020, -2.832346, 90.500000>,
        < 11.149090, -2.497476, 90.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <14.739520, -3.010527, 90.500000>,
        < 10.750020, -2.832346, 90.500000>
      }
      triangle {
        <10.260470, -3.010538, 89.500000>,
        <10.750020, -2.832346, 90.500000>,
        < 10.750000, -2.832369, 89.500000>
      }
      triangle {
        <14.739520, -3.010527, 90.500000>,
        <11.409550, -2.046327, 90.500000>,
        < 11.149090, -2.497476, 90.500000>
      }
      triangle {
        <11.149070, -2.497507, 89.500000>,
        <11.149090, -2.497476, 90.500000>,
        < 11.409550, -2.046327, 90.500000>
      }
      triangle {
        <10.750000, -2.832369, 89.500000>,
        <11.149090, -2.497476, 90.500000>,
        < 11.149070, -2.497507, 89.500000>
      }
      triangle {
        <14.249980, -2.832346, 90.500000>,
        <11.500000, -1.533327, 90.500000>,
        < 11.409550, -2.046327, 90.500000>
      }
      triangle {
        <11.409540, -2.046358, 89.500000>,
        <11.409550, -2.046327, 90.500000>,
        < 11.500000, -1.533327, 90.500000>
      }
      triangle {
        <14.739520, -3.010527, 90.500000>,
        <14.249980, -2.832346, 90.500000>,
        < 11.409550, -2.046327, 90.500000>
      }
      triangle {
        <11.149070, -2.497507, 89.500000>,
        <11.409550, -2.046327, 90.500000>,
        < 11.409540, -2.046358, 89.500000>
      }
      triangle {
        <13.850910, -2.497476, 90.500000>,
        <13.590450, -2.046327, 90.500000>,
        < 11.500000, -1.533327, 90.500000>
      }
      triangle {
        <14.249980, -2.832346, 90.500000>,
        <13.850910, -2.497476, 90.500000>,
        < 11.500000, -1.533327, 90.500000>
      }
      triangle {
        <11.409540, -2.046358, 89.500000>,
        <11.500000, -1.533327, 90.500000>,
        < 11.500000, -1.533327, 89.500000>
      }
      triangle {
        <3.500000, 3.466673, 89.500000>,
        <3.500000, 3.466673, 90.500000>,
        < 3.500000, -1.533327, 90.500000>
      }
      triangle {
        <3.590461, 3.979704, 89.500000>,
        <3.590453, 3.979673, 90.500000>,
        < 3.500000, 3.466673, 90.500000>
      }
      triangle {
        <3.590461, 3.979704, 89.500000>,
        <3.500000, 3.466673, 90.500000>,
        < 3.500000, 3.466673, 89.500000>
      }
      triangle {
        <3.500000, -1.533327, 89.500000>,
        <3.500000, -1.533327, 90.500000>,
        < 3.590453, -2.046327, 90.500000>
      }
      triangle {
        <3.500000, -1.533327, 89.500000>,
        <3.500000, 3.466673, 89.500000>,
        < 3.500000, -1.533327, 90.500000>
      }
      triangle {
        <3.590461, -2.046358, 89.500000>,
        <3.590453, -2.046327, 90.500000>,
        < 3.850914, -2.497476, 90.500000>
      }
      triangle {
        <3.500000, -1.533327, 89.500000>,
        <3.590453, -2.046327, 90.500000>,
        < 3.590461, -2.046358, 89.500000>
      }
      triangle {
        <3.850933, -2.497507, 89.500000>,
        <3.850914, -2.497476, 90.500000>,
        < 4.249980, -2.832346, 90.500000>
      }
      triangle {
        <3.590461, -2.046358, 89.500000>,
        <3.850914, -2.497476, 90.500000>,
        < 3.850933, -2.497507, 89.500000>
      }
      triangle {
        <4.250000, -2.832369, 89.500000>,
        <4.249980, -2.832346, 90.500000>,
        < 4.739519, -3.010527, 90.500000>
      }
      triangle {
        <3.850933, -2.497507, 89.500000>,
        <4.249980, -2.832346, 90.500000>,
        < 4.250000, -2.832369, 89.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <5.260481, -3.010527, 90.500000>,
        < 4.739519, -3.010527, 90.500000>
      }
      triangle {
        <4.739528, -3.010538, 89.500000>,
        <4.739519, -3.010527, 90.500000>,
        < 5.260481, -3.010527, 90.500000>
      }
      triangle {
        <4.250000, -2.832369, 89.500000>,
        <4.739519, -3.010527, 90.500000>,
        < 4.739528, -3.010538, 89.500000>
      }
      triangle {
        <5.260472, -3.010538, 89.500000>,
        <5.260481, -3.010527, 90.500000>,
        < 5.750020, -2.832346, 90.500000>
      }
      triangle {
        <4.739528, -3.010538, 89.500000>,
        <5.260481, -3.010527, 90.500000>,
        < 5.260472, -3.010538, 89.500000>
      }
      triangle {
        <5.750000, -2.832369, 89.500000>,
        <5.750020, -2.832346, 90.500000>,
        < 6.149086, -2.497476, 90.500000>
      }
      triangle {
        <5.260472, -3.010538, 89.500000>,
        <5.750020, -2.832346, 90.500000>,
        < 5.750000, -2.832369, 89.500000>
      }
      triangle {
        <6.149067, -2.497507, 89.500000>,
        <6.149086, -2.497476, 90.500000>,
        < 6.409547, -2.046327, 90.500000>
      }
      triangle {
        <5.750000, -2.832369, 89.500000>,
        <6.149086, -2.497476, 90.500000>,
        < 6.149067, -2.497507, 89.500000>
      }
      triangle {
        <6.409539, -2.046358, 89.500000>,
        <6.409547, -2.046327, 90.500000>,
        < 6.500000, -1.533327, 90.500000>
      }
      triangle {
        <6.149067, -2.497507, 89.500000>,
        <6.409547, -2.046327, 90.500000>,
        < 6.409539, -2.046358, 89.500000>
      }
      triangle {
        <6.500000, -1.533327, 89.500000>,
        <6.500000, -1.533327, 90.500000>,
        < 6.500000, 3.466673, 90.500000>
      }
      triangle {
        <6.409539, -2.046358, 89.500000>,
        <6.500000, -1.533327, 90.500000>,
        < 6.500000, -1.533327, 89.500000>
      }
      triangle {
        <6.500000, 3.466673, 89.500000>,
        <6.500000, 3.466673, 90.500000>,
        < 6.409547, 3.979673, 90.500000>
      }
      triangle {
        <6.500000, -1.533327, 89.500000>,
        <6.500000, 3.466673, 90.500000>,
        < 6.500000, 3.466673, 89.500000>
      }
      triangle {
        <6.409539, 3.979704, 89.500000>,
        <6.409547, 3.979673, 90.500000>,
        < 6.149086, 4.430822, 90.500000>
      }
      triangle {
        <6.500000, 3.466673, 89.500000>,
        <6.409547, 3.979673, 90.500000>,
        < 6.409539, 3.979704, 89.500000>
      }
      triangle {
        <5.750000, 4.765715, 89.500000>,
        <6.149086, 4.430822, 90.500000>,
        < 5.750020, 4.765692, 90.500000>
      }
      triangle {
        <6.149067, 4.430853, 89.500000>,
        <6.149086, 4.430822, 90.500000>,
        < 5.750000, 4.765715, 89.500000>
      }
      triangle {
        <6.409539, 3.979704, 89.500000>,
        <6.149086, 4.430822, 90.500000>,
        < 6.149067, 4.430853, 89.500000>
      }
      triangle {
        <5.260472, 4.943884, 89.500000>,
        <5.750020, 4.765692, 90.500000>,
        < 5.260481, 4.943873, 90.500000>
      }
      triangle {
        <5.750000, 4.765715, 89.500000>,
        <5.750020, 4.765692, 90.500000>,
        < 5.260472, 4.943884, 89.500000>
      }
      triangle {
        <5.260472, 4.943884, 89.500000>,
        <5.260481, 4.943873, 90.500000>,
        < 4.739519, 4.943873, 90.500000>
      }
      triangle {
        <4.739528, 4.943884, 89.500000>,
        <4.739519, 4.943873, 90.500000>,
        < 4.249980, 4.765692, 90.500000>
      }
      triangle {
        <5.260472, 4.943884, 89.500000>,
        <4.739519, 4.943873, 90.500000>,
        < 4.739528, 4.943884, 89.500000>
      }
      triangle {
        <4.250000, 4.765715, 89.500000>,
        <4.249980, 4.765692, 90.500000>,
        < 3.850914, 4.430822, 90.500000>
      }
      triangle {
        <4.739528, 4.943884, 89.500000>,
        <4.249980, 4.765692, 90.500000>,
        < 4.250000, 4.765715, 89.500000>
      }
      triangle {
        <3.590461, 3.979704, 89.500000>,
        <3.850914, 4.430822, 90.500000>,
        < 3.590453, 3.979673, 90.500000>
      }
      triangle {
        <3.850933, 4.430853, 89.500000>,
        <3.850914, 4.430822, 90.500000>,
        < 3.590461, 3.979704, 89.500000>
      }
      triangle {
        <4.250000, 4.765715, 89.500000>,
        <3.850914, 4.430822, 90.500000>,
        < 3.850933, 4.430853, 89.500000>
      }
      triangle {
        <13.500000, 3.466673, 89.500000>,
        <13.500000, 3.466673, 90.500000>,
        < 13.500000, -1.533327, 90.500000>
      }
      triangle {
        <13.590460, 3.979704, 89.500000>,
        <13.590450, 3.979673, 90.500000>,
        < 13.500000, 3.466673, 90.500000>
      }
      triangle {
        <13.590460, 3.979704, 89.500000>,
        <13.500000, 3.466673, 90.500000>,
        < 13.500000, 3.466673, 89.500000>
      }
      triangle {
        <13.500000, -1.533327, 89.500000>,
        <13.500000, -1.533327, 90.500000>,
        < 13.590450, -2.046327, 90.500000>
      }
      triangle {
        <13.500000, -1.533327, 89.500000>,
        <13.500000, 3.466673, 89.500000>,
        < 13.500000, -1.533327, 90.500000>
      }
      triangle {
        <13.590460, -2.046358, 89.500000>,
        <13.590450, -2.046327, 90.500000>,
        < 13.850910, -2.497476, 90.500000>
      }
      triangle {
        <13.500000, -1.533327, 89.500000>,
        <13.590450, -2.046327, 90.500000>,
        < 13.590460, -2.046358, 89.500000>
      }
      triangle {
        <14.250000, -2.832369, 89.500000>,
        <13.850910, -2.497476, 90.500000>,
        < 14.249980, -2.832346, 90.500000>
      }
      triangle {
        <13.850930, -2.497507, 89.500000>,
        <13.850910, -2.497476, 90.500000>,
        < 14.250000, -2.832369, 89.500000>
      }
      triangle {
        <13.590460, -2.046358, 89.500000>,
        <13.850910, -2.497476, 90.500000>,
        < 13.850930, -2.497507, 89.500000>
      }
      triangle {
        <14.739530, -3.010538, 89.500000>,
        <14.249980, -2.832346, 90.500000>,
        < 14.739520, -3.010527, 90.500000>
      }
      triangle {
        <14.250000, -2.832369, 89.500000>,
        <14.249980, -2.832346, 90.500000>,
        < 14.739530, -3.010538, 89.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <15.260480, -3.010527, 90.500000>,
        < 14.739520, -3.010527, 90.500000>
      }
      triangle {
        <15.260470, -3.010538, 89.500000>,
        <14.739520, -3.010527, 90.500000>,
        < 15.260480, -3.010527, 90.500000>
      }
      triangle {
        <14.739530, -3.010538, 89.500000>,
        <14.739520, -3.010527, 90.500000>,
        < 15.260470, -3.010538, 89.500000>
      }
      triangle {
        <18.575069, -3.341017, 90.500000>,
        <15.750020, -2.832346, 90.500000>,
        < 15.260480, -3.010527, 90.500000>
      }
      triangle {
        <15.260470, -3.010538, 89.500000>,
        <15.260480, -3.010527, 90.500000>,
        < 15.750020, -2.832346, 90.500000>
      }
      triangle {
        <19.000000, -3.408327, 90.500000>,
        <18.575069, -3.341017, 90.500000>,
        < 15.260480, -3.010527, 90.500000>
      }
      triangle {
        <18.575069, -3.341017, 90.500000>,
        <16.149090, -2.497476, 90.500000>,
        < 15.750020, -2.832346, 90.500000>
      }
      triangle {
        <15.750000, -2.832369, 89.500000>,
        <15.750020, -2.832346, 90.500000>,
        < 16.149090, -2.497476, 90.500000>
      }
      triangle {
        <15.260470, -3.010538, 89.500000>,
        <15.750020, -2.832346, 90.500000>,
        < 15.750000, -2.832369, 89.500000>
      }
      triangle {
        <18.191790, -3.145716, 90.500000>,
        <16.409550, -2.046327, 90.500000>,
        < 16.149090, -2.497476, 90.500000>
      }
      triangle {
        <16.149071, -2.497507, 89.500000>,
        <16.149090, -2.497476, 90.500000>,
        < 16.409550, -2.046327, 90.500000>
      }
      triangle {
        <18.575069, -3.341017, 90.500000>,
        <18.191790, -3.145716, 90.500000>,
        < 16.149090, -2.497476, 90.500000>
      }
      triangle {
        <15.750000, -2.832369, 89.500000>,
        <16.149090, -2.497476, 90.500000>,
        < 16.149071, -2.497507, 89.500000>
      }
      triangle {
        <18.191790, -3.145716, 90.500000>,
        <16.500000, -1.533327, 90.500000>,
        < 16.409550, -2.046327, 90.500000>
      }
      triangle {
        <16.409540, -2.046358, 89.500000>,
        <16.409550, -2.046327, 90.500000>,
        < 16.500000, -1.533327, 90.500000>
      }
      triangle {
        <16.149071, -2.497507, 89.500000>,
        <16.409550, -2.046327, 90.500000>,
        < 16.409540, -2.046358, 89.500000>
      }
      triangle {
        <17.692310, -2.458258, 90.500000>,
        <16.500000, 3.466673, 90.500000>,
        < 16.500000, -1.533327, 90.500000>
      }
      triangle {
        <16.500000, -1.533327, 89.500000>,
        <16.500000, -1.533327, 90.500000>,
        < 16.500000, 3.466673, 90.500000>
      }
      triangle {
        <17.887609, -2.841535, 90.500000>,
        <17.692310, -2.458258, 90.500000>,
        < 16.500000, -1.533327, 90.500000>
      }
      triangle {
        <18.191790, -3.145716, 90.500000>,
        <17.887609, -2.841535, 90.500000>,
        < 16.500000, -1.533327, 90.500000>
      }
      triangle {
        <16.409540, -2.046358, 89.500000>,
        <16.500000, -1.533327, 90.500000>,
        < 16.500000, -1.533327, 89.500000>
      }
      triangle {
        <17.625000, -2.033327, 90.500000>,
        <16.409550, 3.979673, 90.500000>,
        < 16.500000, 3.466673, 90.500000>
      }
      triangle {
        <16.500000, 3.466673, 89.500000>,
        <16.500000, 3.466673, 90.500000>,
        < 16.409550, 3.979673, 90.500000>
      }
      triangle {
        <17.692310, -2.458258, 90.500000>,
        <17.625000, -2.033327, 90.500000>,
        < 16.500000, 3.466673, 90.500000>
      }
      triangle {
        <16.500000, -1.533327, 89.500000>,
        <16.500000, 3.466673, 90.500000>,
        < 16.500000, 3.466673, 89.500000>
      }
      triangle {
        <17.625000, 3.966673, 90.500000>,
        <16.149090, 4.430822, 90.500000>,
        < 16.409550, 3.979673, 90.500000>
      }
      triangle {
        <16.409540, 3.979704, 89.500000>,
        <16.409550, 3.979673, 90.500000>,
        < 16.149090, 4.430822, 90.500000>
      }
      triangle {
        <17.625000, -2.033327, 90.500000>,
        <17.625000, 3.966673, 90.500000>,
        < 16.409550, 3.979673, 90.500000>
      }
      triangle {
        <16.500000, 3.466673, 89.500000>,
        <16.409550, 3.979673, 90.500000>,
        < 16.409540, 3.979704, 89.500000>
      }
      triangle {
        <17.625000, 3.966673, 90.500000>,
        <15.750020, 4.765692, 90.500000>,
        < 16.149090, 4.430822, 90.500000>
      }
      triangle {
        <15.750000, 4.765715, 89.500000>,
        <16.149090, 4.430822, 90.500000>,
        < 15.750020, 4.765692, 90.500000>
      }
      triangle {
        <16.149071, 4.430853, 89.500000>,
        <16.149090, 4.430822, 90.500000>,
        < 15.750000, 4.765715, 89.500000>
      }
      triangle {
        <16.409540, 3.979704, 89.500000>,
        <16.149090, 4.430822, 90.500000>,
        < 16.149071, 4.430853, 89.500000>
      }
      triangle {
        <17.692310, 4.391604, 90.500000>,
        <15.260480, 4.943873, 90.500000>,
        < 15.750020, 4.765692, 90.500000>
      }
      triangle {
        <15.260470, 4.943884, 89.500000>,
        <15.750020, 4.765692, 90.500000>,
        < 15.260480, 4.943873, 90.500000>
      }
      triangle {
        <17.692310, 4.391604, 90.500000>,
        <15.750020, 4.765692, 90.500000>,
        < 17.625000, 3.966673, 90.500000>
      }
      triangle {
        <15.750000, 4.765715, 89.500000>,
        <15.750020, 4.765692, 90.500000>,
        < 15.260470, 4.943884, 89.500000>
      }
      triangle {
        <15.260470, 4.943884, 89.500000>,
        <15.260480, 4.943873, 90.500000>,
        < 14.739520, 4.943873, 90.500000>
      }
      triangle {
        <17.887609, 4.774881, 90.500000>,
        <18.191790, 5.079062, 90.500000>,
        < 15.260480, 4.943873, 90.500000>
      }
      triangle {
        <17.692310, 4.391604, 90.500000>,
        <17.887609, 4.774881, 90.500000>,
        < 15.260480, 4.943873, 90.500000>
      }
      triangle {
        <14.739530, 4.943884, 89.500000>,
        <14.739520, 4.943873, 90.500000>,
        < 14.249980, 4.765692, 90.500000>
      }
      triangle {
        <15.260470, 4.943884, 89.500000>,
        <14.739520, 4.943873, 90.500000>,
        < 14.739530, 4.943884, 89.500000>
      }
      triangle {
        <14.250000, 4.765715, 89.500000>,
        <14.249980, 4.765692, 90.500000>,
        < 13.850910, 4.430822, 90.500000>
      }
      triangle {
        <14.739530, 4.943884, 89.500000>,
        <14.249980, 4.765692, 90.500000>,
        < 14.250000, 4.765715, 89.500000>
      }
      triangle {
        <13.850930, 4.430853, 89.500000>,
        <13.850910, 4.430822, 90.500000>,
        < 13.590450, 3.979673, 90.500000>
      }
      triangle {
        <14.250000, 4.765715, 89.500000>,
        <13.850910, 4.430822, 90.500000>,
        < 13.850930, 4.430853, 89.500000>
      }
      triangle {
        <13.850930, 4.430853, 89.500000>,
        <13.590450, 3.979673, 90.500000>,
        < 13.590460, 3.979704, 89.500000>
      }
      triangle {
        <-25.000000, 5.154173, 90.449760>,
        <-25.000000, 5.341673, 90.500000>,
        < -25.424931, 5.274363, 90.500000>
      }
      triangle {
        <-25.000000, 5.154173, 90.449760>,
        <-19.000000, 5.341673, 90.500000>,
        < -25.000000, 5.341673, 90.500000>
      }
      triangle {
        <-25.366961, 5.096052, 90.449760>,
        <-25.424931, 5.274363, 90.500000>,
        < -25.808210, 5.079062, 90.500000>
      }
      triangle {
        <-25.366961, 5.096052, 90.449760>,
        <-25.000000, 5.154173, 90.449760>,
        < -25.424931, 5.274363, 90.500000>
      }
      triangle {
        <-25.697990, 4.927382, 90.449760>,
        <-25.808210, 5.079062, 90.500000>,
        < -26.112391, 4.774881, 90.500000>
      }
      triangle {
        <-25.697990, 4.927382, 90.449760>,
        <-25.366961, 5.096052, 90.449760>,
        < -25.808210, 5.079062, 90.500000>
      }
      triangle {
        <-25.960711, 4.664663, 90.449760>,
        <-26.112391, 4.774881, 90.500000>,
        < -26.307690, 4.391604, 90.500000>
      }
      triangle {
        <-25.960711, 4.664663, 90.449760>,
        <-25.697990, 4.927382, 90.449760>,
        < -26.112391, 4.774881, 90.500000>
      }
      triangle {
        <-26.129379, 4.333632, 90.449760>,
        <-26.307690, 4.391604, 90.500000>,
        < -26.375000, 3.966673, 90.500000>
      }
      triangle {
        <-26.129379, 4.333632, 90.449760>,
        <-25.960711, 4.664663, 90.449760>,
        < -26.307690, 4.391604, 90.500000>
      }
      triangle {
        <-26.187500, -2.033327, 90.449760>,
        <-26.375000, 3.966673, 90.500000>,
        < -26.375000, -2.033327, 90.500000>
      }
      triangle {
        <-26.187500, 3.966673, 90.449760>,
        <-26.129379, 4.333632, 90.449760>,
        < -26.375000, 3.966673, 90.500000>
      }
      triangle {
        <-26.187500, -2.033327, 90.449760>,
        <-26.187500, 3.966673, 90.449760>,
        < -26.375000, 3.966673, 90.500000>
      }
      triangle {
        <-26.187500, -2.033327, 90.449760>,
        <-26.375000, -2.033327, 90.500000>,
        < -26.307690, -2.458258, 90.500000>
      }
      triangle {
        <-26.129379, -2.400286, 90.449760>,
        <-26.307690, -2.458258, 90.500000>,
        < -26.112391, -2.841535, 90.500000>
      }
      triangle {
        <-26.129379, -2.400286, 90.449760>,
        <-26.187500, -2.033327, 90.449760>,
        < -26.307690, -2.458258, 90.500000>
      }
      triangle {
        <-25.960711, -2.731317, 90.449760>,
        <-26.112391, -2.841535, 90.500000>,
        < -25.808210, -3.145716, 90.500000>
      }
      triangle {
        <-25.960711, -2.731317, 90.449760>,
        <-26.129379, -2.400286, 90.449760>,
        < -26.112391, -2.841535, 90.500000>
      }
      triangle {
        <-25.697990, -2.994036, 90.449760>,
        <-25.808210, -3.145716, 90.500000>,
        < -25.424931, -3.341017, 90.500000>
      }
      triangle {
        <-25.697990, -2.994036, 90.449760>,
        <-25.960711, -2.731317, 90.449760>,
        < -25.808210, -3.145716, 90.500000>
      }
      triangle {
        <-25.366961, -3.162706, 90.449760>,
        <-25.424931, -3.341017, 90.500000>,
        < -25.000000, -3.408327, 90.500000>
      }
      triangle {
        <-25.366961, -3.162706, 90.449760>,
        <-25.697990, -2.994036, 90.449760>,
        < -25.424931, -3.341017, 90.500000>
      }
      triangle {
        <-19.000000, -3.220827, 90.449760>,
        <-25.000000, -3.408327, 90.500000>,
        < -19.000000, -3.408327, 90.500000>
      }
      triangle {
        <-25.000000, -3.220827, 90.449760>,
        <-25.366961, -3.162706, 90.449760>,
        < -25.000000, -3.408327, 90.500000>
      }
      triangle {
        <-19.000000, -3.220827, 90.449760>,
        <-25.000000, -3.220827, 90.449760>,
        < -25.000000, -3.408327, 90.500000>
      }
      triangle {
        <-19.000000, -3.220827, 90.449760>,
        <-19.000000, -3.408327, 90.500000>,
        < -18.575069, -3.341017, 90.500000>
      }
      triangle {
        <-18.406250, -3.061739, 90.449760>,
        <-18.575069, -3.341017, 90.500000>,
        < -18.191790, -3.145716, 90.500000>
      }
      triangle {
        <-18.692650, -3.180368, 90.449760>,
        <-19.000000, -3.220827, 90.449760>,
        < -18.575069, -3.341017, 90.500000>
      }
      triangle {
        <-18.406250, -3.061739, 90.449760>,
        <-18.692650, -3.180368, 90.449760>,
        < -18.575069, -3.341017, 90.500000>
      }
      triangle {
        <-18.160311, -2.873018, 90.449760>,
        <-18.191790, -3.145716, 90.500000>,
        < -17.887609, -2.841535, 90.500000>
      }
      triangle {
        <-18.160311, -2.873018, 90.449760>,
        <-18.406250, -3.061739, 90.449760>,
        < -18.191790, -3.145716, 90.500000>
      }
      triangle {
        <-17.971590, -2.627077, 90.449760>,
        <-17.887609, -2.841535, 90.500000>,
        < -17.692310, -2.458258, 90.500000>
      }
      triangle {
        <-17.971590, -2.627077, 90.449760>,
        <-18.160311, -2.873018, 90.449760>,
        < -17.887609, -2.841535, 90.500000>
      }
      triangle {
        <-17.852961, -2.340677, 90.449760>,
        <-17.692310, -2.458258, 90.500000>,
        < -17.625000, -2.033327, 90.500000>
      }
      triangle {
        <-17.852961, -2.340677, 90.449760>,
        <-17.971590, -2.627077, 90.449760>,
        < -17.692310, -2.458258, 90.500000>
      }
      triangle {
        <-17.812500, 3.966673, 90.449760>,
        <-17.625000, -2.033327, 90.500000>,
        < -17.625000, 3.966673, 90.500000>
      }
      triangle {
        <-17.812500, 3.966673, 90.449760>,
        <-17.812500, -2.033327, 90.449760>,
        < -17.625000, -2.033327, 90.500000>
      }
      triangle {
        <-17.852961, -2.340677, 90.449760>,
        <-17.625000, -2.033327, 90.500000>,
        < -17.812500, -2.033327, 90.449760>
      }
      triangle {
        <-17.812500, 3.966673, 90.449760>,
        <-17.625000, 3.966673, 90.500000>,
        < -17.692310, 4.391604, 90.500000>
      }
      triangle {
        <-17.870621, 4.333632, 90.449760>,
        <-17.692310, 4.391604, 90.500000>,
        < -17.887609, 4.774881, 90.500000>
      }
      triangle {
        <-17.870621, 4.333632, 90.449760>,
        <-17.812500, 3.966673, 90.449760>,
        < -17.692310, 4.391604, 90.500000>
      }
      triangle {
        <-18.039289, 4.664663, 90.449760>,
        <-17.887609, 4.774881, 90.500000>,
        < -18.191790, 5.079062, 90.500000>
      }
      triangle {
        <-18.039289, 4.664663, 90.449760>,
        <-17.870621, 4.333632, 90.449760>,
        < -17.887609, 4.774881, 90.500000>
      }
      triangle {
        <-18.302010, 4.927382, 90.449760>,
        <-18.191790, 5.079062, 90.500000>,
        < -18.575069, 5.274363, 90.500000>
      }
      triangle {
        <-18.302010, 4.927382, 90.449760>,
        <-18.039289, 4.664663, 90.449760>,
        < -18.191790, 5.079062, 90.500000>
      }
      triangle {
        <-18.633039, 5.096052, 90.449760>,
        <-18.575069, 5.274363, 90.500000>,
        < -19.000000, 5.341673, 90.500000>
      }
      triangle {
        <-18.633039, 5.096052, 90.449760>,
        <-18.302010, 4.927382, 90.449760>,
        < -18.575069, 5.274363, 90.500000>
      }
      triangle {
        <-19.000000, 5.154173, 90.449760>,
        <-18.633039, 5.096052, 90.449760>,
        < -19.000000, 5.341673, 90.500000>
      }
      triangle {
        <-25.000000, 5.154173, 90.449760>,
        <-19.000000, 5.154173, 90.449760>,
        < -19.000000, 5.341673, 90.500000>
      }
      triangle {
        <17.812500, -2.033327, 90.449760>,
        <17.625000, 3.966673, 90.500000>,
        < 17.625000, -2.033327, 90.500000>
      }
      triangle {
        <17.870621, 4.333632, 90.449760>,
        <17.692310, 4.391604, 90.500000>,
        < 17.625000, 3.966673, 90.500000>
      }
      triangle {
        <17.812500, 3.966673, 90.449760>,
        <17.870621, 4.333632, 90.449760>,
        < 17.625000, 3.966673, 90.500000>
      }
      triangle {
        <17.812500, -2.033327, 90.449760>,
        <17.812500, 3.966673, 90.449760>,
        < 17.625000, 3.966673, 90.500000>
      }
      triangle {
        <17.812500, -2.033327, 90.449760>,
        <17.625000, -2.033327, 90.500000>,
        < 17.692310, -2.458258, 90.500000>
      }
      triangle {
        <17.870621, -2.400286, 90.449760>,
        <17.692310, -2.458258, 90.500000>,
        < 17.887609, -2.841535, 90.500000>
      }
      triangle {
        <17.870621, -2.400286, 90.449760>,
        <17.812500, -2.033327, 90.449760>,
        < 17.692310, -2.458258, 90.500000>
      }
      triangle {
        <18.039289, -2.731317, 90.449760>,
        <17.887609, -2.841535, 90.500000>,
        < 18.191790, -3.145716, 90.500000>
      }
      triangle {
        <18.039289, -2.731317, 90.449760>,
        <17.870621, -2.400286, 90.449760>,
        < 17.887609, -2.841535, 90.500000>
      }
      triangle {
        <18.302010, -2.994036, 90.449760>,
        <18.191790, -3.145716, 90.500000>,
        < 18.575069, -3.341017, 90.500000>
      }
      triangle {
        <18.302010, -2.994036, 90.449760>,
        <18.039289, -2.731317, 90.449760>,
        < 18.191790, -3.145716, 90.500000>
      }
      triangle {
        <18.633039, -3.162706, 90.449760>,
        <18.575069, -3.341017, 90.500000>,
        < 19.000000, -3.408327, 90.500000>
      }
      triangle {
        <18.633039, -3.162706, 90.449760>,
        <18.302010, -2.994036, 90.449760>,
        < 18.575069, -3.341017, 90.500000>
      }
      triangle {
        <25.000000, -3.220827, 90.449760>,
        <19.000000, -3.408327, 90.500000>,
        < 25.000000, -3.408327, 90.500000>
      }
      triangle {
        <19.000000, -3.220827, 90.449760>,
        <18.633039, -3.162706, 90.449760>,
        < 19.000000, -3.408327, 90.500000>
      }
      triangle {
        <25.000000, -3.220827, 90.449760>,
        <19.000000, -3.220827, 90.449760>,
        < 19.000000, -3.408327, 90.500000>
      }
      triangle {
        <25.000000, -3.220827, 90.449760>,
        <25.000000, -3.408327, 90.500000>,
        < 25.424931, -3.341017, 90.500000>
      }
      triangle {
        <25.593750, -3.061739, 90.449760>,
        <25.424931, -3.341017, 90.500000>,
        < 25.808210, -3.145716, 90.500000>
      }
      triangle {
        <25.307350, -3.180368, 90.449760>,
        <25.000000, -3.220827, 90.449760>,
        < 25.424931, -3.341017, 90.500000>
      }
      triangle {
        <25.593750, -3.061739, 90.449760>,
        <25.307350, -3.180368, 90.449760>,
        < 25.424931, -3.341017, 90.500000>
      }
      triangle {
        <25.839689, -2.873018, 90.449760>,
        <25.808210, -3.145716, 90.500000>,
        < 26.112391, -2.841535, 90.500000>
      }
      triangle {
        <25.839689, -2.873018, 90.449760>,
        <25.593750, -3.061739, 90.449760>,
        < 25.808210, -3.145716, 90.500000>
      }
      triangle {
        <26.028410, -2.627077, 90.449760>,
        <26.112391, -2.841535, 90.500000>,
        < 26.307690, -2.458258, 90.500000>
      }
      triangle {
        <26.028410, -2.627077, 90.449760>,
        <25.839689, -2.873018, 90.449760>,
        < 26.112391, -2.841535, 90.500000>
      }
      triangle {
        <26.147039, -2.340677, 90.449760>,
        <26.307690, -2.458258, 90.500000>,
        < 26.375000, -2.033327, 90.500000>
      }
      triangle {
        <26.147039, -2.340677, 90.449760>,
        <26.028410, -2.627077, 90.449760>,
        < 26.307690, -2.458258, 90.500000>
      }
      triangle {
        <26.187500, 3.966673, 90.449760>,
        <26.375000, -2.033327, 90.500000>,
        < 26.375000, 3.966673, 90.500000>
      }
      triangle {
        <26.187500, 3.966673, 90.449760>,
        <26.187500, -2.033327, 90.449760>,
        < 26.375000, -2.033327, 90.500000>
      }
      triangle {
        <26.147039, -2.340677, 90.449760>,
        <26.375000, -2.033327, 90.500000>,
        < 26.187500, -2.033327, 90.449760>
      }
      triangle {
        <26.187500, 3.966673, 90.449760>,
        <26.375000, 3.966673, 90.500000>,
        < 26.307690, 4.391604, 90.500000>
      }
      triangle {
        <26.129379, 4.333632, 90.449760>,
        <26.307690, 4.391604, 90.500000>,
        < 26.112391, 4.774881, 90.500000>
      }
      triangle {
        <26.129379, 4.333632, 90.449760>,
        <26.187500, 3.966673, 90.449760>,
        < 26.307690, 4.391604, 90.500000>
      }
      triangle {
        <25.960711, 4.664663, 90.449760>,
        <26.112391, 4.774881, 90.500000>,
        < 25.808210, 5.079062, 90.500000>
      }
      triangle {
        <25.960711, 4.664663, 90.449760>,
        <26.129379, 4.333632, 90.449760>,
        < 26.112391, 4.774881, 90.500000>
      }
      triangle {
        <25.697990, 4.927382, 90.449760>,
        <25.808210, 5.079062, 90.500000>,
        < 25.424931, 5.274363, 90.500000>
      }
      triangle {
        <25.697990, 4.927382, 90.449760>,
        <25.960711, 4.664663, 90.449760>,
        < 25.808210, 5.079062, 90.500000>
      }
      triangle {
        <25.366961, 5.096052, 90.449760>,
        <25.424931, 5.274363, 90.500000>,
        < 25.000000, 5.341673, 90.500000>
      }
      triangle {
        <25.366961, 5.096052, 90.449760>,
        <25.697990, 4.927382, 90.449760>,
        < 25.424931, 5.274363, 90.500000>
      }
      triangle {
        <19.000000, 5.154173, 90.449760>,
        <25.000000, 5.341673, 90.500000>,
        < 19.000000, 5.341673, 90.500000>
      }
      triangle {
        <25.000000, 5.154173, 90.449760>,
        <25.366961, 5.096052, 90.449760>,
        < 25.000000, 5.341673, 90.500000>
      }
      triangle {
        <19.000000, 5.154173, 90.449760>,
        <25.000000, 5.154173, 90.449760>,
        < 25.000000, 5.341673, 90.500000>
      }
      triangle {
        <19.000000, 5.154173, 90.449760>,
        <19.000000, 5.341673, 90.500000>,
        < 18.575069, 5.274363, 90.500000>
      }
      triangle {
        <18.633039, 5.096052, 90.449760>,
        <18.575069, 5.274363, 90.500000>,
        < 18.191790, 5.079062, 90.500000>
      }
      triangle {
        <18.633039, 5.096052, 90.449760>,
        <19.000000, 5.154173, 90.449760>,
        < 18.575069, 5.274363, 90.500000>
      }
      triangle {
        <18.302010, 4.927382, 90.449760>,
        <18.191790, 5.079062, 90.500000>,
        < 17.887609, 4.774881, 90.500000>
      }
      triangle {
        <18.302010, 4.927382, 90.449760>,
        <18.633039, 5.096052, 90.449760>,
        < 18.191790, 5.079062, 90.500000>
      }
      triangle {
        <18.039289, 4.664663, 90.449760>,
        <17.887609, 4.774881, 90.500000>,
        < 17.692310, 4.391604, 90.500000>
      }
      triangle {
        <18.039289, 4.664663, 90.449760>,
        <18.302010, 4.927382, 90.449760>,
        < 17.887609, 4.774881, 90.500000>
      }
      triangle {
        <17.870621, 4.333632, 90.449760>,
        <18.039289, 4.664663, 90.449760>,
        < 17.692310, 4.391604, 90.500000>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -4.033327, 87.500000>,
        < 17.500000, -4.033327, 89.500000>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -3.939089, 86.939077>,
        < 17.500000, -4.033327, 87.500000>
      }
      triangle {
        <17.500000, -5.033327, 89.500000>,
        <17.500000, -4.033327, 89.500000>,
        < -17.500000, -4.033327, 89.500000>
      }
      triangle {
        <17.500000, -5.033327, 89.500000>,
        <17.500000, -14.033327, 80.892305>,
        < 17.500000, -4.033327, 89.500000>
      }
      triangle {
        <-17.500000, -5.033327, 89.500000>,
        <-17.500000, -4.033327, 89.500000>,
        < -17.500000, -4.033327, 87.500000>
      }
      triangle {
        <-17.500000, -5.033327, 89.500000>,
        <17.500000, -5.033327, 89.500000>,
        < -17.500000, -4.033327, 89.500000>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -4.033327, 87.500000>,
        < -17.500000, -3.939089, 86.939077>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -5.033327, 89.500000>,
        < -17.500000, -4.033327, 87.500000>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.248514, 58.534430>,
        < 17.500000, 2.439814, 59.070660>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.439814, 59.070660>,
        < 17.500000, 2.599135, 59.623211>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.599135, 59.623211>,
        < 17.500000, 2.739912, 60.181740>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.739912, 60.181740>,
        < 17.500000, 2.868471, 60.741550>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.868471, 60.741550>,
        < 17.500000, 2.985472, 61.302330>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 2.985472, 61.302330>,
        < 17.500000, 3.091463, 61.863939>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.091463, 61.863939>,
        < 17.500000, 3.186983, 62.426201>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.186983, 62.426201>,
        < 17.500000, 3.272543, 62.988939>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.272543, 62.988939>,
        < 17.500000, 3.348692, 63.551991>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.348692, 63.551991>,
        < 17.500000, 3.415964, 64.115200>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.415964, 64.115200>,
        < 17.500000, 3.474875, 64.678379>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.474875, 64.678379>,
        < 17.500000, 3.525984, 65.241381>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.525984, 65.241381>,
        < 17.500000, 3.569803, 65.804029>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.569803, 65.804029>,
        < 17.500000, 3.606875, 66.366150>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.606875, 66.366150>,
        < 17.500000, 3.637724, 66.927589>
      }
      triangle {
        <17.500000, -14.033327, 58.892300>,
        <17.500000, 3.637724, 66.927589>,
        < 17.500000, 3.662893, 67.488180>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.662893, 67.488180>,
        < 17.500000, 3.682913, 68.047741>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, -14.033327, 58.892300>,
        < 17.500000, 3.662893, 67.488180>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.682913, 68.047741>,
        < 17.500000, 3.698313, 68.606110>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.698313, 68.606110>,
        < 17.500000, 3.709623, 69.163130>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.709623, 69.163130>,
        < 17.500000, 3.717383, 69.718620>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.717383, 69.718620>,
        < 17.500000, 3.722124, 70.272421>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.722124, 70.272421>,
        < 17.500000, 3.724344, 70.824400>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.724344, 70.824400>,
        < 17.500000, 3.723833, 71.374920>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.723833, 71.374920>,
        < 17.500000, 3.719881, 71.924770>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, 3.719881, 71.924770>,
        < 17.500000, 3.711722, 72.474739>
      }
      triangle {
        <17.500000, -10.033327, 73.000000>,
        <17.500000, 3.711722, 72.474739>,
        < 17.500000, 3.698614, 73.025620>
      }
      triangle {
        <17.500000, -10.033327, 73.000000>,
        <17.500000, -10.033327, 68.000000>,
        < 17.500000, 3.711722, 72.474739>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.698614, 73.025620>,
        < 17.500000, 3.679804, 73.578199>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, -10.033327, 73.000000>,
        < 17.500000, 3.698614, 73.025620>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.679804, 73.578199>,
        < 17.500000, 3.654543, 74.133270>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.654543, 74.133270>,
        < 17.500000, 3.622084, 74.691630>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.622084, 74.691630>,
        < 17.500000, 3.581675, 75.254060>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.581675, 75.254060>,
        < 17.500000, 3.532572, 75.821360>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.532572, 75.821360>,
        < 17.500000, 3.474024, 76.394310>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.474024, 76.394310>,
        < 17.500000, 3.405272, 76.973720>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.405272, 76.973720>,
        < 17.500000, 3.325583, 77.560370>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.325583, 77.560370>,
        < 17.500000, 3.234163, 78.154950>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.234163, 78.154950>,
        < 17.500000, 3.129263, 78.755440>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.129263, 78.755440>,
        < 17.500000, 3.008162, 79.357000>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 3.008162, 79.357000>,
        < 17.500000, 2.868075, 79.954640>
      }
      triangle {
        <17.500000, -14.033327, 73.000000>,
        <17.500000, 2.868075, 79.954640>,
        < 17.500000, 2.706202, 80.543374>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 2.706202, 80.543374>,
        < 17.500000, 2.519755, 81.118214>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -14.033327, 73.000000>,
        < 17.500000, 2.706202, 80.543374>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 2.519755, 81.118214>,
        < 17.500000, 2.305964, 81.674171>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 2.305964, 81.674171>,
        < 17.500000, 2.062021, 82.206259>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 2.062021, 82.206259>,
        < 17.500000, 1.785154, 82.709499>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 1.785154, 82.709499>,
        < 17.500000, 1.472582, 83.178902>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 1.472582, 83.178902>,
        < 17.500000, 1.121504, 83.609479>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 1.121504, 83.609479>,
        < 17.500000, 0.729143, 83.996241>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 0.729143, 83.996241>,
        < 17.500000, 0.292704, 84.334203>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, 0.292704, 84.334203>,
        < 17.500000, -0.190588, 84.618377>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -0.190588, 84.618377>,
        < 17.500000, -0.719168, 84.849106>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -0.719168, 84.849106>,
        < 17.500000, -1.274916, 85.046847>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -1.274916, 85.046847>,
        < 17.500000, -1.835768, 85.236915>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -1.835768, 85.236915>,
        < 17.500000, -2.379637, 85.444604>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -2.379637, 85.444604>,
        < 17.500000, -2.884497, 85.695171>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -2.884497, 85.695171>,
        < 17.500000, -3.328287, 86.013895>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -3.328287, 86.013895>,
        < 17.500000, -3.688978, 86.426142>
      }
      triangle {
        <17.500000, -14.033327, 80.892305>,
        <17.500000, -3.688978, 86.426142>,
        < 17.500000, -3.939089, 86.939077>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -3.939089, 86.939077>,
        < -17.500000, -3.688978, 86.426142>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -3.688978, 86.426142>,
        < -17.500000, -3.328287, 86.013895>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -3.328287, 86.013895>,
        < -17.500000, -2.884497, 85.695171>
      }
      triangle {
        <-17.500000, 1.121504, 83.609479>,
        <-17.500000, -2.884497, 85.695171>,
        < -17.500000, -2.379637, 85.444604>
      }
      triangle {
        <-17.500000, 1.472582, 83.178902>,
        <-17.500000, -2.884497, 85.695171>,
        < -17.500000, 1.121504, 83.609479>
      }
      triangle {
        <-17.500000, 1.785154, 82.709499>,
        <-17.500000, -2.884497, 85.695171>,
        < -17.500000, 1.472582, 83.178902>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, -2.884497, 85.695171>,
        < -17.500000, 1.785154, 82.709499>
      }
      triangle {
        <-17.500000, 0.292704, 84.334203>,
        <-17.500000, -2.379637, 85.444604>,
        < -17.500000, -1.835768, 85.236915>
      }
      triangle {
        <-17.500000, 0.729143, 83.996241>,
        <-17.500000, -2.379637, 85.444604>,
        < -17.500000, 0.292704, 84.334203>
      }
      triangle {
        <-17.500000, 1.121504, 83.609479>,
        <-17.500000, -2.379637, 85.444604>,
        < -17.500000, 0.729143, 83.996241>
      }
      triangle {
        <-17.500000, -0.719168, 84.849106>,
        <-17.500000, -1.835768, 85.236915>,
        < -17.500000, -1.274916, 85.046847>
      }
      triangle {
        <-17.500000, -0.190588, 84.618377>,
        <-17.500000, -1.835768, 85.236915>,
        < -17.500000, -0.719168, 84.849106>
      }
      triangle {
        <-17.500000, 0.292704, 84.334203>,
        <-17.500000, -1.835768, 85.236915>,
        < -17.500000, -0.190588, 84.618377>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, 1.785154, 82.709499>,
        < -17.500000, 2.062021, 82.206259>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, 2.062021, 82.206259>,
        < -17.500000, 2.305964, 81.674171>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <-17.500000, 2.305964, 81.674171>,
        < -17.500000, 2.519755, 81.118214>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 2.519755, 81.118214>,
        < -17.500000, 2.706202, 80.543374>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, -9.063667, 89.500000>,
        < -17.500000, 2.519755, 81.118214>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 2.706202, 80.543374>,
        < -17.500000, 2.868075, 79.954640>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 2.868075, 79.954640>,
        < -17.500000, 3.008162, 79.357000>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.008162, 79.357000>,
        < -17.500000, 3.129263, 78.755440>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.129263, 78.755440>,
        < -17.500000, 3.234163, 78.154950>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.234163, 78.154950>,
        < -17.500000, 3.325583, 77.560370>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.325583, 77.560370>,
        < -17.500000, 3.405272, 76.973720>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.405272, 76.973720>,
        < -17.500000, 3.474024, 76.394310>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.474024, 76.394310>,
        < -17.500000, 3.532572, 75.821360>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.532572, 75.821360>,
        < -17.500000, 3.581675, 75.254060>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.581675, 75.254060>,
        < -17.500000, 3.622084, 74.691630>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.622084, 74.691630>,
        < -17.500000, 3.654543, 74.133270>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.654543, 74.133270>,
        < -17.500000, 3.679804, 73.578199>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <-17.500000, 3.679804, 73.578199>,
        < -17.500000, 3.698614, 73.025620>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.698614, 73.025620>,
        < -17.500000, 3.711722, 72.474739>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, -14.033327, 80.892305>,
        < -17.500000, 3.698614, 73.025620>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.711722, 72.474739>,
        < -17.500000, 3.719881, 71.924770>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.719881, 71.924770>,
        < -17.500000, 3.723833, 71.374920>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.723833, 71.374920>,
        < -17.500000, 3.724344, 70.824400>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.724344, 70.824400>,
        < -17.500000, 3.722124, 70.272421>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.722124, 70.272421>,
        < -17.500000, 3.717383, 69.718620>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.717383, 69.718620>,
        < -17.500000, 3.709623, 69.163130>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.709623, 69.163130>,
        < -17.500000, 3.698313, 68.606110>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, 3.698313, 68.606110>,
        < -17.500000, 3.682913, 68.047741>
      }
      triangle {
        <-17.500000, -10.033327, 68.000000>,
        <-17.500000, 3.682913, 68.047741>,
        < -17.500000, 3.662893, 67.488180>
      }
      triangle {
        <-17.500000, -10.033327, 68.000000>,
        <-17.500000, -10.033327, 73.000000>,
        < -17.500000, 3.682913, 68.047741>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.662893, 67.488180>,
        < -17.500000, 3.637724, 66.927589>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, -10.033327, 68.000000>,
        < -17.500000, 3.662893, 67.488180>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.637724, 66.927589>,
        < -17.500000, 3.606875, 66.366150>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.606875, 66.366150>,
        < -17.500000, 3.569803, 65.804029>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.569803, 65.804029>,
        < -17.500000, 3.525984, 65.241381>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.525984, 65.241381>,
        < -17.500000, 3.474875, 64.678379>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.474875, 64.678379>,
        < -17.500000, 3.415964, 64.115200>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.415964, 64.115200>,
        < -17.500000, 3.348692, 63.551991>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.348692, 63.551991>,
        < -17.500000, 3.272543, 62.988939>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.272543, 62.988939>,
        < -17.500000, 3.186983, 62.426201>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.186983, 62.426201>,
        < -17.500000, 3.091463, 61.863939>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 3.091463, 61.863939>,
        < -17.500000, 2.985472, 61.302330>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 2.985472, 61.302330>,
        < -17.500000, 2.868471, 60.741550>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 2.868471, 60.741550>,
        < -17.500000, 2.739912, 60.181740>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 2.739912, 60.181740>,
        < -17.500000, 2.599135, 59.623211>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <-17.500000, 2.599135, 59.623211>,
        < -17.500000, 2.439814, 59.070660>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 2.439814, 59.070660>,
        < -17.500000, 2.248514, 58.534430>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, -14.033327, 68.000000>,
        < -17.500000, 2.439814, 59.070660>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 2.248514, 58.534430>,
        < -17.500000, 2.011313, 58.025211>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 2.011313, 58.025211>,
        < -17.500000, 1.714312, 57.553692>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 1.714312, 57.553692>,
        < -17.500000, 1.348032, 57.128819>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 1.348032, 57.128819>,
        < -17.500000, 0.923372, 56.751560>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 0.923372, 56.751560>,
        < -17.500000, 0.457281, 56.420490>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <-17.500000, 0.457281, 56.420490>,
        < -17.500000, -0.033327, 56.134190>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -5.892647, -80.087906>,
        < -26.625000, -6.033327, -80.995697>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -5.479168, -79.258606>,
        < -26.625000, -5.892647, -80.087906>
      }
      triangle {
        <-26.625000, -3.533327, -75.000000>,
        <-26.625000, -4.838777, -78.599792>,
        < -26.625000, -5.479168, -79.258606>
      }
      triangle {
        <-26.625000, -8.033327, -79.500000>,
        <-26.625000, -3.533327, -75.000000>,
        < -26.625000, -5.479168, -79.258606>
      }
      triangle {
        <-26.625000, -3.533327, -75.000000>,
        <-26.625000, -0.024248, -74.971802>,
        < -26.625000, -4.838777, -78.599792>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, 0.807333, -74.180099>,
        < -26.625000, -0.024248, -74.971802>
      }
      triangle {
        <-26.625000, -3.533327, -75.000000>,
        <-26.625000, -3.533327, -55.000000>,
        < -26.625000, -0.024248, -74.971802>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, 1.441332, -73.209595>,
        < -26.625000, 0.807333, -74.180099>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, 1.834833, -72.119293>,
        < -26.625000, 1.441332, -73.209595>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, 1.966673, -70.978699>,
        < -26.625000, 1.834833, -72.119293>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, 1.966673, -48.656906>,
        < -26.625000, 1.966673, -70.978699>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-26.625000, 1.840841, -47.542206>,
        < -26.625000, 1.966673, -48.656906>
      }
      triangle {
        <-26.625000, -3.533327, -55.000000>,
        <-26.625000, -13.087498, -38.451706>,
        < -26.625000, 1.966673, -48.656906>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-26.625000, 1.462881, -46.469696>,
        < -26.625000, 1.840841, -47.542206>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-26.625000, 0.849173, -45.506302>,
        < -26.625000, 1.462881, -46.469696>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-26.625000, 0.036844, -44.710495>,
        < -26.625000, 0.849173, -45.506302>
      }
      triangle {
        <-26.625000, -13.087498, -38.451706>,
        <-26.625000, -0.920236, -44.125397>,
        < -26.625000, 0.036844, -44.710495>
      }
      triangle {
        <-15.000000, -3.533327, -55.000000>,
        <-26.625000, -13.087498, -38.451706>,
        < -26.625000, -3.533327, -55.000000>
      }
      triangle {
        <15.000000, -11.533327, -41.143600>,
        <26.625000, -13.087498, -38.451706>,
        < -26.625000, -13.087498, -38.451706>
      }
      triangle {
        <-15.000000, -11.533327, -41.143600>,
        <15.000000, -11.533327, -41.143600>,
        < -26.625000, -13.087498, -38.451706>
      }
      triangle {
        <-15.000000, -3.533327, -55.000000>,
        <-15.000000, -11.533327, -41.143600>,
        < -26.625000, -13.087498, -38.451706>
      }
      triangle {
        <-15.000000, -3.533327, -75.000000>,
        <-26.625000, -3.533327, -55.000000>,
        < -26.625000, -3.533327, -75.000000>
      }
      triangle {
        <-15.000000, -3.533327, -75.000000>,
        <-15.000000, -3.533327, -55.000000>,
        < -26.625000, -3.533327, -55.000000>
      }
      triangle {
        <-15.000000, -8.033327, -79.500000>,
        <-26.625000, -3.533327, -75.000000>,
        < -26.625000, -8.033327, -79.500000>
      }
      triangle {
        <-15.000000, -8.033327, -79.500000>,
        <-15.000000, -3.533327, -75.000000>,
        < -26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, -3.533327, -55.000000>,
        <26.625000, -0.920236, -44.125397>,
        < 26.625000, -13.087498, -38.451706>
      }
      triangle {
        <26.625000, 0.044993, -44.716904>,
        <26.625000, -0.920236, -44.125397>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <15.000000, -11.533327, -41.143600>,
        <26.625000, -3.533327, -55.000000>,
        < 26.625000, -13.087498, -38.451706>
      }
      triangle {
        <26.625000, -4.838777, -78.599792>,
        <26.625000, -3.533327, -75.000000>,
        < 26.625000, -8.033327, -79.500000>
      }
      triangle {
        <15.000000, -3.533327, -75.000000>,
        <26.625000, -8.033327, -79.500000>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, -5.480726, -79.260696>,
        <26.625000, -4.838777, -78.599792>,
        < 26.625000, -8.033327, -79.500000>
      }
      triangle {
        <26.625000, -5.891836, -80.085297>,
        <26.625000, -5.480726, -79.260696>,
        < 26.625000, -8.033327, -79.500000>
      }
      triangle {
        <15.000000, -8.033327, -79.500000>,
        <26.625000, -8.033327, -79.500000>,
        < 15.000000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, 1.966673, -70.978699>,
        <26.625000, -3.533327, -55.000000>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <15.000000, -3.533327, -55.000000>,
        <26.625000, -3.533327, -75.000000>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 1.833563, -72.124695>,
        <26.625000, 1.966673, -70.978699>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, 1.441343, -73.209595>,
        <26.625000, 1.833563, -72.124695>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, 0.810873, -74.175797>,
        <26.625000, 1.441343, -73.209595>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, -0.024248, -74.971802>,
        <26.625000, 0.810873, -74.175797>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <26.625000, -4.838777, -78.599792>,
        <26.625000, -0.024248, -74.971802>,
        < 26.625000, -3.533327, -75.000000>
      }
      triangle {
        <15.000000, -3.533327, -75.000000>,
        <26.625000, -3.533327, -75.000000>,
        < 15.000000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 0.852362, -45.510300>,
        <26.625000, 0.044993, -44.716904>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 1.460665, -46.465103>,
        <26.625000, 0.852362, -45.510300>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 1.838514, -47.532104>,
        <26.625000, 1.460665, -46.465103>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 1.966673, -48.656906>,
        <26.625000, 1.838514, -47.532104>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <26.625000, 1.966673, -70.978699>,
        <26.625000, 1.966673, -48.656906>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <15.000000, -11.533327, -41.143600>,
        <15.000000, -3.533327, -55.000000>,
        < 26.625000, -3.533327, -55.000000>
      }
      triangle {
        <41.647572, 31.402456, 33.500000>,
        <41.647572, 31.402456, 30.500000>,
        < 41.389408, 32.608305, 30.500000>
      }
      triangle {
        <41.389408, 32.608305, 33.500000>,
        <41.389408, 32.608305, 30.500000>,
        < 40.844009, 33.714254, 30.500000>
      }
      triangle {
        <41.647572, 31.402456, 33.500000>,
        <41.389408, 32.608305, 30.500000>,
        < 41.389408, 32.608305, 33.500000>
      }
      triangle {
        <40.844009, 33.714254, 33.500000>,
        <40.844009, 33.714254, 30.500000>,
        < 40.044540, 34.653051, 30.500000>
      }
      triangle {
        <41.389408, 32.608305, 33.500000>,
        <40.844009, 33.714254, 30.500000>,
        < 40.844009, 33.714254, 33.500000>
      }
      triangle {
        <40.044540, 34.653051, 33.500000>,
        <40.044540, 34.653051, 30.500000>,
        < 39.039631, 35.367651, 30.500000>
      }
      triangle {
        <40.844009, 33.714254, 33.500000>,
        <40.044540, 34.653051, 30.500000>,
        < 40.044540, 34.653051, 33.500000>
      }
      triangle {
        <39.039631, 35.367651, 33.500000>,
        <39.039631, 35.367651, 30.500000>,
        < 37.890362, 35.814596, 30.500000>
      }
      triangle {
        <40.044540, 34.653051, 33.500000>,
        <39.039631, 35.367651, 30.500000>,
        < 39.039631, 35.367651, 33.500000>
      }
      triangle {
        <37.890362, 35.814596, 33.500000>,
        <37.890362, 35.814596, 30.500000>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <39.039631, 35.367651, 33.500000>,
        <37.890362, 35.814596, 30.500000>,
        < 37.890362, 35.814596, 33.500000>
      }
      triangle {
        <36.666599, 35.966673, 33.500000>,
        <36.666599, 35.966673, 30.500000>,
        < -36.666599, 35.966673, 30.500000>
      }
      triangle {
        <37.890362, 35.814596, 33.500000>,
        <36.666599, 35.966673, 30.500000>,
        < 36.666599, 35.966673, 33.500000>
      }
      triangle {
        <-36.666599, 35.966673, 33.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < -37.890362, 35.814596, 30.500000>
      }
      triangle {
        <36.666599, 35.966673, 33.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < -36.666599, 35.966673, 33.500000>
      }
      triangle {
        <-37.890362, 35.814596, 33.500000>,
        <-37.890362, 35.814596, 30.500000>,
        < -39.039631, 35.367651, 30.500000>
      }
      triangle {
        <-36.666599, 35.966673, 33.500000>,
        <-37.890362, 35.814596, 30.500000>,
        < -37.890362, 35.814596, 33.500000>
      }
      triangle {
        <-39.039631, 35.367651, 33.500000>,
        <-39.039631, 35.367651, 30.500000>,
        < -40.044540, 34.653051, 30.500000>
      }
      triangle {
        <-37.890362, 35.814596, 33.500000>,
        <-39.039631, 35.367651, 30.500000>,
        < -39.039631, 35.367651, 33.500000>
      }
      triangle {
        <-40.044540, 34.653051, 33.500000>,
        <-40.044540, 34.653051, 30.500000>,
        < -40.844009, 33.714254, 30.500000>
      }
      triangle {
        <-39.039631, 35.367651, 33.500000>,
        <-40.044540, 34.653051, 30.500000>,
        < -40.044540, 34.653051, 33.500000>
      }
      triangle {
        <-40.844009, 33.714254, 33.500000>,
        <-40.844009, 33.714254, 30.500000>,
        < -41.389408, 32.608305, 30.500000>
      }
      triangle {
        <-40.044540, 34.653051, 33.500000>,
        <-40.844009, 33.714254, 30.500000>,
        < -40.844009, 33.714254, 33.500000>
      }
      triangle {
        <-41.389408, 32.608305, 33.500000>,
        <-41.389408, 32.608305, 30.500000>,
        < -41.647572, 31.402456, 30.500000>
      }
      triangle {
        <-40.844009, 33.714254, 33.500000>,
        <-41.389408, 32.608305, 30.500000>,
        < -41.389408, 32.608305, 33.500000>
      }
      triangle {
        <-41.647572, 31.402456, 33.500000>,
        <-41.647572, 31.402456, 30.500000>,
        < -42.836369, 17.814371, 30.500000>
      }
      triangle {
        <-41.389408, 32.608305, 33.500000>,
        <-41.647572, 31.402456, 30.500000>,
        < -41.647572, 31.402456, 33.500000>
      }
      triangle {
        <-42.836369, 17.814371, 33.500000>,
        <-42.836369, 17.814371, 30.500000>,
        < -42.959068, 15.942305, 30.500000>
      }
      triangle {
        <-41.647572, 31.402456, 33.500000>,
        <-42.836369, 17.814371, 30.500000>,
        < -42.836369, 17.814371, 33.500000>
      }
      triangle {
        <-42.836369, 17.814371, 33.500000>,
        <-42.959068, 15.942305, 30.500000>,
        < -42.959068, 15.942305, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <40.951191, 16.066671, 30.500000>,
        < 1.500000, 16.066671, 30.500000>
      }
      triangle {
        <40.905151, 16.853853, 33.500000>,
        <40.905151, 16.853853, 30.500000>,
        < 40.951191, 16.066671, 30.500000>
      }
      triangle {
        <40.905151, 16.853853, 33.500000>,
        <40.951191, 16.066671, 30.500000>,
        < 40.951191, 16.066671, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <1.500000, 16.066671, 30.500000>,
        < 1.500000, 16.066671, 33.500000>
      }
      triangle {
        <39.655182, 31.228140, 33.500000>,
        <39.655182, 31.228140, 30.500000>,
        < 40.843979, 17.640062, 30.500000>
      }
      triangle {
        <40.843979, 17.640062, 33.500000>,
        <40.843979, 17.640062, 30.500000>,
        < 40.905151, 16.853853, 30.500000>
      }
      triangle {
        <39.655182, 31.228140, 33.500000>,
        <40.843979, 17.640062, 30.500000>,
        < 40.843979, 17.640062, 33.500000>
      }
      triangle {
        <40.843979, 17.640062, 33.500000>,
        <40.905151, 16.853853, 30.500000>,
        < 40.905151, 16.853853, 33.500000>
      }
      triangle {
        <-1.500000, 33.966673, 33.500000>,
        <-1.500000, 33.966673, 30.500000>,
        < -1.500000, 16.066671, 30.500000>
      }
      triangle {
        <-1.500000, 16.066671, 33.500000>,
        <-1.500000, 16.066671, 30.500000>,
        < -40.951191, 16.066671, 30.500000>
      }
      triangle {
        <-1.500000, 33.966673, 33.500000>,
        <-1.500000, 16.066671, 30.500000>,
        < -1.500000, 16.066671, 33.500000>
      }
      triangle {
        <-1.500000, 16.066671, 33.500000>,
        <-40.951191, 16.066671, 30.500000>,
        < -40.951191, 16.066671, 33.500000>
      }
      triangle {
        <-41.647572, 31.402456, -2.000000>,
        <-41.647572, 31.402456, -5.000000>,
        < -42.836369, 17.814371, -5.000000>
      }
      triangle {
        <-42.836369, 17.814371, -2.000000>,
        <-42.836369, 17.814371, -5.000000>,
        < -42.959068, 15.942305, -5.000000>
      }
      triangle {
        <-41.647572, 31.402456, -2.000000>,
        <-42.836369, 17.814371, -5.000000>,
        < -42.836369, 17.814371, -2.000000>
      }
      triangle {
        <-42.836369, 17.814371, -2.000000>,
        <-42.959068, 15.942305, -5.000000>,
        < -42.959068, 15.942305, -2.000000>
      }
      triangle {
        <15.000000, -11.533327, -57.000000>,
        <15.000000, -3.533327, -55.000000>,
        < 15.000000, -11.533327, -41.143600>
      }
      triangle {
        <15.000000, -10.033327, -62.000000>,
        <15.000000, -3.533327, -75.000000>,
        < 15.000000, -3.533327, -55.000000>
      }
      triangle {
        <15.000000, -10.033327, -57.000000>,
        <15.000000, -10.033327, -62.000000>,
        < 15.000000, -3.533327, -55.000000>
      }
      triangle {
        <15.000000, -11.533327, -57.000000>,
        <15.000000, -10.033327, -57.000000>,
        < 15.000000, -3.533327, -55.000000>
      }
      triangle {
        <-15.000000, -11.533327, -57.000000>,
        <15.000000, -11.533327, -41.143600>,
        < -15.000000, -11.533327, -41.143600>
      }
      triangle {
        <-15.000000, -11.533327, -57.000000>,
        <15.000000, -11.533327, -57.000000>,
        < 15.000000, -11.533327, -41.143600>
      }
      triangle {
        <-15.000000, -10.033327, -57.000000>,
        <-15.000000, -11.533327, -41.143600>,
        < -15.000000, -3.533327, -55.000000>
      }
      triangle {
        <-15.000000, -10.033327, -57.000000>,
        <-15.000000, -11.533327, -57.000000>,
        < -15.000000, -11.533327, -41.143600>
      }
      triangle {
        <-15.000000, -10.033327, -57.000000>,
        <-15.000000, -3.533327, -55.000000>,
        < -15.000000, -3.533327, -75.000000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <-15.000000, -3.533327, -75.000000>,
        < -15.000000, -8.033327, -79.500000>
      }
      triangle {
        <-15.000000, -10.033327, -62.000000>,
        <-15.000000, -10.033327, -57.000000>,
        < -15.000000, -3.533327, -75.000000>
      }
      triangle {
        <-15.000000, -11.533327, -62.000000>,
        <-15.000000, -10.033327, -62.000000>,
        < -15.000000, -3.533327, -75.000000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <-15.000000, -11.533327, -62.000000>,
        < -15.000000, -3.533327, -75.000000>
      }
      triangle {
        <15.000000, -11.533327, -76.000000>,
        <15.000000, -8.033327, -79.500000>,
        < 15.000000, -3.533327, -75.000000>
      }
      triangle {
        <15.000000, -10.033327, -62.000000>,
        <15.000000, -11.533327, -76.000000>,
        < 15.000000, -3.533327, -75.000000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <-15.000000, -8.033327, -79.500000>,
        < 15.000000, -8.033327, -79.500000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <15.000000, -8.033327, -79.500000>,
        < 15.000000, -11.533327, -76.000000>
      }
      triangle {
        <15.000000, -10.033327, -62.000000>,
        <15.000000, -11.533327, -62.000000>,
        < 15.000000, -11.533327, -76.000000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <15.000000, -11.533327, -76.000000>,
        < 15.000000, -11.533327, -62.000000>
      }
      triangle {
        <17.500000, -10.033327, -62.000000>,
        <15.000000, -11.533327, -62.000000>,
        < 15.000000, -10.033327, -62.000000>
      }
      triangle {
        <-15.000000, -11.533327, -76.000000>,
        <15.000000, -11.533327, -62.000000>,
        < -15.000000, -11.533327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -62.000000>,
        <-15.000000, -11.533327, -62.000000>,
        < 15.000000, -11.533327, -62.000000>
      }
      triangle {
        <17.500000, -15.033327, -62.000000>,
        <-17.500000, -15.033327, -62.000000>,
        < 15.000000, -11.533327, -62.000000>
      }
      triangle {
        <17.500000, -10.033327, -62.000000>,
        <17.500000, -15.033327, -62.000000>,
        < 15.000000, -11.533327, -62.000000>
      }
      triangle {
        <17.500000, -10.033327, -57.000000>,
        <15.000000, -10.033327, -62.000000>,
        < 15.000000, -10.033327, -57.000000>
      }
      triangle {
        <17.500000, -10.033327, -57.000000>,
        <17.500000, -10.033327, -62.000000>,
        < 15.000000, -10.033327, -62.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <15.000000, -10.033327, -57.000000>,
        < 15.000000, -11.533327, -57.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <17.500000, -10.033327, -57.000000>,
        < 15.000000, -10.033327, -57.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <15.000000, -11.533327, -57.000000>,
        < -15.000000, -11.533327, -57.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-15.000000, -11.533327, -57.000000>,
        < -15.000000, -10.033327, -57.000000>
      }
      triangle {
        <-17.500000, -15.033327, -57.000000>,
        <17.500000, -15.033327, -57.000000>,
        < -15.000000, -11.533327, -57.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-17.500000, -15.033327, -57.000000>,
        < -15.000000, -11.533327, -57.000000>
      }
      triangle {
        <-17.500000, -10.033327, -62.000000>,
        <-15.000000, -10.033327, -57.000000>,
        < -15.000000, -10.033327, -62.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-15.000000, -10.033327, -57.000000>,
        < -17.500000, -10.033327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -62.000000>,
        <-15.000000, -10.033327, -62.000000>,
        < -15.000000, -11.533327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -62.000000>,
        <-17.500000, -10.033327, -62.000000>,
        < -15.000000, -10.033327, -62.000000>
      }
      triangle {
        <26.217510, 7.161852, 87.209713>,
        <-25.963739, 8.601011, 82.978781>,
        < -26.217510, 7.161814, 87.210244>
      }
      triangle {
        <-26.175980, 7.397352, 85.011883>,
        <-26.217510, 7.161814, 87.210244>,
        < -25.963739, 8.601011, 82.978781>
      }
      triangle {
        <25.963730, 8.601084, 82.978374>,
        <-25.694941, 10.125483, 77.498460>,
        < -25.963739, 8.601011, 82.978781>
      }
      triangle {
        <-25.859819, 9.190374, 78.039990>,
        <-25.963739, 8.601011, 82.978781>,
        < -25.694941, 10.125483, 77.498460>
      }
      triangle {
        <26.217510, 7.161852, 87.209713>,
        <25.963730, 8.601084, 82.978374>,
        < -25.963739, 8.601011, 82.978781>
      }
      triangle {
        <-25.859819, 9.190374, 78.039990>,
        <-26.175980, 7.397352, 85.011883>,
        < -25.963739, 8.601011, 82.978781>
      }
      triangle {
        <25.694851, 10.125975, 77.498470>,
        <-25.432470, 11.614035, 70.447670>,
        < -25.694941, 10.125483, 77.498460>
      }
      triangle {
        <-25.859819, 9.190374, 78.039990>,
        <-25.694941, 10.125483, 77.498460>,
        < -25.432470, 11.614035, 70.447670>
      }
      triangle {
        <25.963730, 8.601084, 82.978374>,
        <25.694851, 10.125975, 77.498470>,
        < -25.694941, 10.125483, 77.498460>
      }
      triangle {
        <25.203810, 12.910814, 61.233820>,
        <-25.203819, 12.910772, 61.232540>,
        < -25.432470, 11.614035, 70.447670>
      }
      triangle {
        <-25.573629, 10.813475, 68.923201>,
        <-25.432470, 11.614035, 70.447670>,
        < -25.203819, 12.910772, 61.232540>
      }
      triangle {
        <25.432560, 11.613482, 70.446520>,
        <25.203810, 12.910814, 61.233820>,
        < -25.432470, 11.614035, 70.447670>
      }
      triangle {
        <25.694851, 10.125975, 77.498470>,
        <25.432560, 11.613482, 70.446520>,
        < -25.432470, 11.614035, 70.447670>
      }
      triangle {
        <-25.573629, 10.813475, 68.923201>,
        <-25.859819, 9.190374, 78.039990>,
        < -25.432470, 11.614035, 70.447670>
      }
      triangle {
        <25.049160, 13.787882, 49.168991>,
        <-25.049170, 13.787813, 49.167358>,
        < -25.203819, 12.910772, 61.232540>
      }
      triangle {
        <-25.320721, 12.247774, 57.602242>,
        <-25.203819, 12.910772, 61.232540>,
        < -25.049170, 13.787813, 49.167358>
      }
      triangle {
        <25.203810, 12.910814, 61.233820>,
        <25.049160, 13.787882, 49.168991>,
        < -25.203819, 12.910772, 61.232540>
      }
      triangle {
        <-25.320721, 12.247774, 57.602242>,
        <-25.573629, 10.813475, 68.923201>,
        < -25.203819, 12.910772, 61.232540>
      }
      triangle {
        <25.000000, 14.066671, 33.500000>,
        <-25.000000, 14.066671, 33.500000>,
        < -25.049170, 13.787813, 49.167358>
      }
      triangle {
        <-25.143909, 13.250513, 45.084080>,
        <-25.049170, 13.787813, 49.167358>,
        < -25.000000, 14.066671, 33.500000>
      }
      triangle {
        <25.049160, 13.787882, 49.168991>,
        <25.000000, 14.066671, 33.500000>,
        < -25.049170, 13.787813, 49.167358>
      }
      triangle {
        <-25.143909, 13.250513, 45.084080>,
        <-25.320721, 12.247774, 57.602242>,
        < -25.049170, 13.787813, 49.167358>
      }
      triangle {
        <-1.500000, 16.066671, 33.500000>,
        <-25.000000, 14.066671, 33.500000>,
        < 25.000000, 14.066671, 33.500000>
      }
      triangle {
        <-25.088160, 13.566671, 33.500000>,
        <-25.143909, 13.250513, 45.084080>,
        < -25.000000, 14.066671, 33.500000>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-25.088160, 13.566671, 33.500000>,
        < -25.000000, 14.066671, 33.500000>
      }
      triangle {
        <-1.500000, 16.066671, 33.500000>,
        <-40.951191, 16.066671, 33.500000>,
        < -25.000000, 14.066671, 33.500000>
      }
      triangle {
        <25.088160, 13.566671, 33.500000>,
        <25.000000, 14.066671, 33.500000>,
        < 25.049160, 13.787882, 49.168991>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <25.000000, 14.066671, 33.500000>,
        < 25.088160, 13.566671, 33.500000>
      }
      triangle {
        <1.500000, 16.066671, 33.500000>,
        <-1.500000, 16.066671, 33.500000>,
        < 25.000000, 14.066671, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <1.500000, 16.066671, 33.500000>,
        < 25.000000, 14.066671, 33.500000>
      }
      triangle {
        <25.320721, 12.247774, 57.602242>,
        <25.049160, 13.787882, 49.168991>,
        < 25.203810, 12.910814, 61.233820>
      }
      triangle {
        <25.143909, 13.250513, 45.084080>,
        <25.088160, 13.566671, 33.500000>,
        < 25.049160, 13.787882, 49.168991>
      }
      triangle {
        <25.320721, 12.247774, 57.602242>,
        <25.143909, 13.250513, 45.084080>,
        < 25.049160, 13.787882, 49.168991>
      }
      triangle {
        <25.573629, 10.813475, 68.923201>,
        <25.203810, 12.910814, 61.233820>,
        < 25.432560, 11.613482, 70.446520>
      }
      triangle {
        <25.573629, 10.813475, 68.923201>,
        <25.320721, 12.247774, 57.602242>,
        < 25.203810, 12.910814, 61.233820>
      }
      triangle {
        <25.573629, 10.813475, 68.923201>,
        <25.432560, 11.613482, 70.446520>,
        < 25.694851, 10.125975, 77.498470>
      }
      triangle {
        <25.859819, 9.190374, 78.039990>,
        <25.694851, 10.125975, 77.498470>,
        < 25.963730, 8.601084, 82.978374>
      }
      triangle {
        <25.859819, 9.190374, 78.039990>,
        <25.573629, 10.813475, 68.923201>,
        < 25.694851, 10.125975, 77.498470>
      }
      triangle {
        <26.175980, 7.397352, 85.011883>,
        <25.963730, 8.601084, 82.978374>,
        < 26.217510, 7.161852, 87.209713>
      }
      triangle {
        <26.175980, 7.397352, 85.011883>,
        <25.859819, 9.190374, 78.039990>,
        < 25.963730, 8.601084, 82.978374>
      }
      triangle {
        <-28.635189, 7.787272, 83.689576>,
        <-26.175980, 7.397352, 85.011883>,
        < -25.859819, 9.190374, 78.039990>
      }
      triangle {
        <-27.741039, 7.138804, 85.843600>,
        <-27.186171, 6.362764, 88.144046>,
        < -26.175980, 7.397352, 85.011883>
      }
      triangle {
        <-28.635189, 7.787272, 83.689576>,
        <-27.741039, 7.138804, 85.843600>,
        < -26.175980, 7.397352, 85.011883>
      }
      triangle {
        <-32.383751, 9.544813, 76.333390>,
        <-25.859819, 9.190374, 78.039990>,
        < -25.573629, 10.813475, 68.923201>
      }
      triangle {
        <-32.383751, 9.544813, 76.333390>,
        <-28.635189, 7.787272, 83.689576>,
        < -25.859819, 9.190374, 78.039990>
      }
      triangle {
        <-37.106319, 11.081194, 67.065781>,
        <-25.573629, 10.813475, 68.923201>,
        < -25.320721, 12.247774, 57.602242>
      }
      triangle {
        <-37.106319, 11.081194, 67.065781>,
        <-32.383751, 9.544813, 76.333390>,
        < -25.573629, 10.813475, 68.923201>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-42.959068, 15.942305, 33.500000>,
        < -25.088160, 13.566671, 33.500000>
      }
      triangle {
        <37.106319, 11.081194, 67.065781>,
        <25.320721, 12.247774, 57.602242>,
        < 25.573629, 10.813475, 68.923201>
      }
      triangle {
        <32.383751, 9.544813, 76.333390>,
        <25.573629, 10.813475, 68.923201>,
        < 25.859819, 9.190374, 78.039990>
      }
      triangle {
        <32.383751, 9.544813, 76.333390>,
        <37.106319, 11.081194, 67.065781>,
        < 25.573629, 10.813475, 68.923201>
      }
      triangle {
        <28.635189, 7.787272, 83.689576>,
        <25.859819, 9.190374, 78.039990>,
        < 26.175980, 7.397352, 85.011883>
      }
      triangle {
        <28.635189, 7.787272, 83.689576>,
        <32.383751, 9.544813, 76.333390>,
        < 25.859819, 9.190374, 78.039990>
      }
      triangle {
        <27.741039, 7.138804, 85.843600>,
        <28.635189, 7.787272, 83.689576>,
        < 26.175980, 7.397352, 85.011883>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-42.836369, 17.814371, 33.500000>,
        < -42.959068, 15.942305, 33.500000>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-41.647572, 31.402456, 33.500000>,
        < -42.836369, 17.814371, 33.500000>
      }
      triangle {
        <-40.951191, 16.066671, 33.500000>,
        <-41.389408, 32.608305, 33.500000>,
        < -41.647572, 31.402456, 33.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-40.844009, 33.714254, 33.500000>,
        < -41.389408, 32.608305, 33.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-41.389408, 32.608305, 33.500000>,
        < -40.951191, 16.066671, 33.500000>
      }
      triangle {
        <-40.843979, 17.640062, 33.500000>,
        <-40.044540, 34.653051, 33.500000>,
        < -40.844009, 33.714254, 33.500000>
      }
      triangle {
        <-40.905151, 16.853853, 33.500000>,
        <-40.843979, 17.640062, 33.500000>,
        < -40.844009, 33.714254, 33.500000>
      }
      triangle {
        <-39.448151, 32.090490, 33.500000>,
        <-39.039631, 35.367651, 33.500000>,
        < -40.044540, 34.653051, 33.500000>
      }
      triangle {
        <-39.655182, 31.228140, 33.500000>,
        <-39.448151, 32.090490, 33.500000>,
        < -40.044540, 34.653051, 33.500000>
      }
      triangle {
        <-40.843979, 17.640062, 33.500000>,
        <-39.655182, 31.228140, 33.500000>,
        < -40.044540, 34.653051, 33.500000>
      }
      triangle {
        <-38.344170, 33.453779, 33.500000>,
        <-37.890362, 35.814596, 33.500000>,
        < -39.039631, 35.367651, 33.500000>
      }
      triangle {
        <-38.998032, 32.854635, 33.500000>,
        <-38.344170, 33.453779, 33.500000>,
        < -39.039631, 35.367651, 33.500000>
      }
      triangle {
        <-39.448151, 32.090490, 33.500000>,
        <-38.998032, 32.854635, 33.500000>,
        < -39.039631, 35.367651, 33.500000>
      }
      triangle {
        <-37.543709, 33.835585, 33.500000>,
        <-36.666599, 35.966673, 33.500000>,
        < -37.890362, 35.814596, 33.500000>
      }
      triangle {
        <-38.344170, 33.453779, 33.500000>,
        <-37.543709, 33.835585, 33.500000>,
        < -37.890362, 35.814596, 33.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <36.666599, 35.966673, 33.500000>,
        < -36.666599, 35.966673, 33.500000>
      }
      triangle {
        <-36.666599, 33.966673, 33.500000>,
        <-1.500000, 33.966673, 33.500000>,
        < -36.666599, 35.966673, 33.500000>
      }
      triangle {
        <1.500000, 33.966673, 33.500000>,
        <-36.666599, 35.966673, 33.500000>,
        < -1.500000, 33.966673, 33.500000>
      }
      triangle {
        <-37.543709, 33.835585, 33.500000>,
        <-36.666599, 33.966673, 33.500000>,
        < -36.666599, 35.966673, 33.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <-36.666599, 35.966673, 33.500000>,
        < 1.500000, 33.966673, 33.500000>
      }
      triangle {
        <37.543709, 33.835585, 33.500000>,
        <37.890362, 35.814596, 33.500000>,
        < 36.666599, 35.966673, 33.500000>
      }
      triangle {
        <36.666599, 33.966673, 33.500000>,
        <37.543709, 33.835585, 33.500000>,
        < 36.666599, 35.966673, 33.500000>
      }
      triangle {
        <38.998032, 32.854635, 33.500000>,
        <39.039631, 35.367651, 33.500000>,
        < 37.890362, 35.814596, 33.500000>
      }
      triangle {
        <38.344170, 33.453779, 33.500000>,
        <38.998032, 32.854635, 33.500000>,
        < 37.890362, 35.814596, 33.500000>
      }
      triangle {
        <37.543709, 33.835585, 33.500000>,
        <38.344170, 33.453779, 33.500000>,
        < 37.890362, 35.814596, 33.500000>
      }
      triangle {
        <39.655182, 31.228140, 33.500000>,
        <40.044540, 34.653051, 33.500000>,
        < 39.039631, 35.367651, 33.500000>
      }
      triangle {
        <39.448151, 32.090490, 33.500000>,
        <39.655182, 31.228140, 33.500000>,
        < 39.039631, 35.367651, 33.500000>
      }
      triangle {
        <38.998032, 32.854635, 33.500000>,
        <39.448151, 32.090490, 33.500000>,
        < 39.039631, 35.367651, 33.500000>
      }
      triangle {
        <40.843979, 17.640062, 33.500000>,
        <40.844009, 33.714254, 33.500000>,
        < 40.044540, 34.653051, 33.500000>
      }
      triangle {
        <39.655182, 31.228140, 33.500000>,
        <40.843979, 17.640062, 33.500000>,
        < 40.044540, 34.653051, 33.500000>
      }
      triangle {
        <40.951191, 16.066671, 33.500000>,
        <41.389408, 32.608305, 33.500000>,
        < 40.844009, 33.714254, 33.500000>
      }
      triangle {
        <40.905151, 16.853853, 33.500000>,
        <40.951191, 16.066671, 33.500000>,
        < 40.844009, 33.714254, 33.500000>
      }
      triangle {
        <40.843979, 17.640062, 33.500000>,
        <40.905151, 16.853853, 33.500000>,
        < 40.844009, 33.714254, 33.500000>
      }
      triangle {
        <1.500000, 16.066671, 33.500000>,
        <-1.500000, 33.966673, 33.500000>,
        < -1.500000, 16.066671, 33.500000>
      }
      triangle {
        <1.500000, 16.066671, 33.500000>,
        <1.500000, 33.966673, 33.500000>,
        < -1.500000, 33.966673, 33.500000>
      }
      triangle {
        <32.643002, 8.802813, 75.824640>,
        <37.106319, 11.081194, 67.065781>,
        < 32.383751, 9.544813, 76.333390>
      }
      triangle {
        <32.643002, 8.802813, 75.824640>,
        <37.394619, 10.181414, 66.500019>,
        < 37.106319, 11.081194, 67.065781>
      }
      triangle {
        <32.643002, 8.802813, 75.824640>,
        <32.383751, 9.544813, 76.333390>,
        < 28.635189, 7.787272, 83.689576>
      }
      triangle {
        <28.635189, 7.150034, 83.689576>,
        <28.635189, 7.787272, 83.689576>,
        < 27.741039, 7.138804, 85.843600>
      }
      triangle {
        <28.635189, 7.150034, 83.689576>,
        <32.643002, 8.802813, 75.824640>,
        < 28.635189, 7.787272, 83.689576>
      }
      triangle {
        <27.736410, 6.591734, 85.857808>,
        <27.741039, 7.138804, 85.843600>,
        < 27.186171, 6.362764, 88.144046>
      }
      triangle {
        <27.736410, 6.591734, 85.857808>,
        <28.635189, 7.150034, 83.689576>,
        < 27.741039, 7.138804, 85.843600>
      }
      triangle {
        <27.187210, 5.948801, 88.137509>,
        <27.736410, 6.591734, 85.857808>,
        < 27.186171, 6.362764, 88.144046>
      }
      triangle {
        <-27.187210, 5.948801, 88.137509>,
        <-27.186171, 6.362764, 88.144046>,
        < -27.741039, 7.138804, 85.843600>
      }
      triangle {
        <-27.736410, 6.591734, 85.857808>,
        <-27.741039, 7.138804, 85.843600>,
        < -28.635189, 7.787272, 83.689576>
      }
      triangle {
        <-27.736410, 6.591734, 85.857808>,
        <-27.187210, 5.948801, 88.137509>,
        < -27.741039, 7.138804, 85.843600>
      }
      triangle {
        <-28.635189, 7.150034, 83.689576>,
        <-28.635189, 7.787272, 83.689576>,
        < -32.383751, 9.544813, 76.333390>
      }
      triangle {
        <-27.736410, 6.591734, 85.857808>,
        <-28.635189, 7.787272, 83.689576>,
        < -28.635189, 7.150034, 83.689576>
      }
      triangle {
        <-32.643002, 8.802813, 75.824640>,
        <-32.383751, 9.544813, 76.333390>,
        < -37.106319, 11.081194, 67.065781>
      }
      triangle {
        <-32.643002, 8.802813, 75.824640>,
        <-28.635189, 7.150034, 83.689576>,
        < -32.383751, 9.544813, 76.333390>
      }
      triangle {
        <-37.394619, 10.181414, 66.500019>,
        <-32.643002, 8.802813, 75.824640>,
        < -37.106319, 11.081194, 67.065781>
      }
      triangle {
        <17.500000, -10.033327, 68.000000>,
        <17.500000, -14.033327, 68.000000>,
        < 17.500000, -14.033327, 58.892300>
      }
      triangle {
        <-17.500000, -14.033327, 68.000000>,
        <17.500000, -14.033327, 58.892300>,
        < 17.500000, -14.033327, 68.000000>
      }
      triangle {
        <-17.500000, -14.033327, 58.892300>,
        <17.500000, -14.033327, 58.892300>,
        < -17.500000, -14.033327, 68.000000>
      }
      triangle {
        <40.000000, -15.533327, 68.000000>,
        <17.500000, -14.033327, 68.000000>,
        < 17.500000, -10.033327, 68.000000>
      }
      triangle {
        <-17.500000, -15.033327, 68.000000>,
        <-17.500000, -14.033327, 68.000000>,
        < 17.500000, -14.033327, 68.000000>
      }
      triangle {
        <17.500000, -15.033327, 68.000000>,
        <-17.500000, -15.033327, 68.000000>,
        < 17.500000, -14.033327, 68.000000>
      }
      triangle {
        <40.000000, -15.533327, 68.000000>,
        <17.500000, -15.033327, 68.000000>,
        < 17.500000, -14.033327, 68.000000>
      }
      triangle {
        <40.000000, -15.533327, 73.000000>,
        <17.500000, -10.033327, 68.000000>,
        < 17.500000, -10.033327, 73.000000>
      }
      triangle {
        <40.000000, -15.533327, 73.000000>,
        <40.000000, -15.533327, 68.000000>,
        < 17.500000, -10.033327, 68.000000>
      }
      triangle {
        <40.000000, -20.533327, 73.000000>,
        <17.500000, -10.033327, 73.000000>,
        < 17.500000, -14.033327, 73.000000>
      }
      triangle {
        <40.000000, -20.533327, 73.000000>,
        <40.000000, -15.533327, 73.000000>,
        < 17.500000, -10.033327, 73.000000>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <17.500000, -14.033327, 73.000000>,
        < 17.500000, -14.033327, 80.892305>
      }
      triangle {
        <-17.500000, -14.033327, 73.000000>,
        <17.500000, -14.033327, 73.000000>,
        < -17.500000, -14.033327, 80.892305>
      }
      triangle {
        <17.500000, -15.033327, 73.000000>,
        <17.500000, -14.033327, 73.000000>,
        < -17.500000, -14.033327, 73.000000>
      }
      triangle {
        <17.500000, -15.033327, 73.000000>,
        <40.000000, -20.533327, 73.000000>,
        < 17.500000, -14.033327, 73.000000>
      }
      triangle {
        <17.500000, -5.033327, 89.500000>,
        <17.500000, -9.063667, 89.500000>,
        < 17.500000, -14.033327, 80.892305>
      }
      triangle {
        <-17.500000, -9.063667, 89.500000>,
        <17.500000, -14.033327, 80.892305>,
        < 17.500000, -9.063667, 89.500000>
      }
      triangle {
        <-17.500000, -14.033327, 80.892305>,
        <17.500000, -14.033327, 80.892305>,
        < -17.500000, -9.063667, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 89.500000>,
        <17.500000, -9.063667, 89.500000>,
        < 17.500000, -5.033327, 89.500000>
      }
      triangle {
        <-22.088240, -13.033327, 89.500000>,
        <-17.500000, -9.063667, 89.500000>,
        < 17.500000, -9.063667, 89.500000>
      }
      triangle {
        <22.088240, -13.033327, 89.500000>,
        <-22.088240, -13.033327, 89.500000>,
        < 17.500000, -9.063667, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 89.500000>,
        <22.088240, -13.033327, 89.500000>,
        < 17.500000, -9.063667, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 90.750000>,
        <17.500000, -5.033327, 89.500000>,
        < -17.500000, -5.033327, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 90.750000>,
        <25.000000, -5.033327, 89.500000>,
        < 17.500000, -5.033327, 89.500000>
      }
      triangle {
        <-22.088240, -13.033327, 89.500000>,
        <-17.500000, -5.033327, 89.500000>,
        < -17.500000, -9.063667, 89.500000>
      }
      triangle {
        <-22.088240, -13.033327, 89.500000>,
        <-25.000000, -5.033327, 89.500000>,
        < -17.500000, -5.033327, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 90.750000>,
        <-17.500000, -5.033327, 89.500000>,
        < -25.000000, -5.033327, 89.500000>
      }
      triangle {
        <-17.500000, -10.033327, 73.000000>,
        <-17.500000, -14.033327, 73.000000>,
        < -17.500000, -14.033327, 80.892305>
      }
      triangle {
        <-40.000000, -15.533327, 73.000000>,
        <-17.500000, -14.033327, 73.000000>,
        < -17.500000, -10.033327, 73.000000>
      }
      triangle {
        <-17.500000, -15.033327, 73.000000>,
        <17.500000, -15.033327, 73.000000>,
        < -17.500000, -14.033327, 73.000000>
      }
      triangle {
        <-40.000000, -15.533327, 73.000000>,
        <-17.500000, -15.033327, 73.000000>,
        < -17.500000, -14.033327, 73.000000>
      }
      triangle {
        <-40.000000, -15.533327, 68.000000>,
        <-17.500000, -10.033327, 73.000000>,
        < -17.500000, -10.033327, 68.000000>
      }
      triangle {
        <-40.000000, -15.533327, 73.000000>,
        <-17.500000, -10.033327, 73.000000>,
        < -40.000000, -15.533327, 68.000000>
      }
      triangle {
        <-40.000000, -20.533327, 68.000000>,
        <-17.500000, -10.033327, 68.000000>,
        < -17.500000, -14.033327, 68.000000>
      }
      triangle {
        <-40.000000, -20.533327, 68.000000>,
        <-40.000000, -15.533327, 68.000000>,
        < -17.500000, -10.033327, 68.000000>
      }
      triangle {
        <-17.500000, -15.033327, 68.000000>,
        <-40.000000, -20.533327, 68.000000>,
        < -17.500000, -14.033327, 68.000000>
      }
      triangle {
        <-25.000000, -5.033327, 90.750000>,
        <-25.000000, -5.033327, 89.500000>,
        < -22.088240, -13.033327, 89.500000>
      }
      triangle {
        <25.000000, -5.033327, 90.750000>,
        <-25.000000, -5.033327, 89.500000>,
        < -25.000000, -5.033327, 90.750000>
      }
      triangle {
        <-22.088240, -13.033327, 90.750000>,
        <-22.088240, -13.033327, 89.500000>,
        < 22.088240, -13.033327, 89.500000>
      }
      triangle {
        <-22.107580, -12.980186, 91.027285>,
        <-22.088240, -13.033327, 89.500000>,
        < -22.088240, -13.033327, 90.750000>
      }
      triangle {
        <-22.164431, -12.823976, 91.269802>,
        <-22.088240, -13.033327, 89.500000>,
        < -22.107580, -12.980186, 91.027285>
      }
      triangle {
        <-22.253260, -12.579946, 91.438852>,
        <-22.088240, -13.033327, 89.500000>,
        < -22.164431, -12.823976, 91.269802>
      }
      triangle {
        <-22.361219, -12.283327, 91.500000>,
        <-22.088240, -13.033327, 89.500000>,
        < -22.253260, -12.579946, 91.438852>
      }
      triangle {
        <-24.727020, -5.783327, 91.500000>,
        <-22.088240, -13.033327, 89.500000>,
        < -22.361219, -12.283327, 91.500000>
      }
      triangle {
        <-24.834980, -5.486708, 91.438852>,
        <-22.088240, -13.033327, 89.500000>,
        < -24.727020, -5.783327, 91.500000>
      }
      triangle {
        <-24.923800, -5.242678, 91.269802>,
        <-22.088240, -13.033327, 89.500000>,
        < -24.834980, -5.486708, 91.438852>
      }
      triangle {
        <-24.980659, -5.086468, 91.027285>,
        <-22.088240, -13.033327, 89.500000>,
        < -24.923800, -5.242678, 91.269802>
      }
      triangle {
        <-25.000000, -5.033327, 90.750000>,
        <-22.088240, -13.033327, 89.500000>,
        < -24.980659, -5.086468, 91.027285>
      }
      triangle {
        <22.088240, -13.033327, 90.750000>,
        <22.088240, -13.033327, 89.500000>,
        < 25.000000, -5.033327, 89.500000>
      }
      triangle {
        <22.088240, -13.033327, 90.750000>,
        <-22.088240, -13.033327, 90.750000>,
        < 22.088240, -13.033327, 89.500000>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <22.088240, -13.033327, 90.750000>,
        < 25.000000, -5.033327, 89.500000>
      }
      triangle {
        <22.253260, -12.579946, 91.438852>,
        <25.000000, -5.033327, 89.500000>,
        < 22.361219, -12.283327, 91.500000>
      }
      triangle {
        <24.727020, -5.783327, 91.500000>,
        <22.361219, -12.283327, 91.500000>,
        < 25.000000, -5.033327, 89.500000>
      }
      triangle {
        <22.164431, -12.823976, 91.269802>,
        <25.000000, -5.033327, 89.500000>,
        < 22.253260, -12.579946, 91.438852>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <25.000000, -5.033327, 89.500000>,
        < 22.164431, -12.823976, 91.269802>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <24.727020, -5.783327, 91.500000>,
        < 25.000000, -5.033327, 89.500000>
      }
      triangle {
        <24.980659, -5.086468, 91.027285>,
        <25.000000, -5.033327, 89.500000>,
        < 25.000000, -5.033327, 90.750000>
      }
      triangle {
        <24.923800, -5.242678, 91.269802>,
        <25.000000, -5.033327, 89.500000>,
        < 24.980659, -5.086468, 91.027285>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <25.000000, -5.033327, 89.500000>,
        < 24.923800, -5.242678, 91.269802>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <-22.088240, -13.033327, 90.750000>,
        < 22.088240, -13.033327, 90.750000>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <-22.107580, -12.980186, 91.027285>,
        < -22.088240, -13.033327, 90.750000>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <-22.164431, -12.823976, 91.269802>,
        < -22.107580, -12.980186, 91.027285>
      }
      triangle {
        <22.164431, -12.823976, 91.269802>,
        <-22.253260, -12.579946, 91.438852>,
        < -22.164431, -12.823976, 91.269802>
      }
      triangle {
        <22.107580, -12.980186, 91.027285>,
        <22.164431, -12.823976, 91.269802>,
        < -22.164431, -12.823976, 91.269802>
      }
      triangle {
        <22.361219, -12.283327, 91.500000>,
        <-22.361219, -12.283327, 91.500000>,
        < -22.253260, -12.579946, 91.438852>
      }
      triangle {
        <22.253260, -12.579946, 91.438852>,
        <22.361219, -12.283327, 91.500000>,
        < -22.253260, -12.579946, 91.438852>
      }
      triangle {
        <22.164431, -12.823976, 91.269802>,
        <22.253260, -12.579946, 91.438852>,
        < -22.253260, -12.579946, 91.438852>
      }
      triangle {
        <-24.727020, -5.783327, 91.500000>,
        <-22.361219, -12.283327, 91.500000>,
        < 22.361219, -12.283327, 91.500000>
      }
      triangle {
        <24.727020, -5.783327, 91.500000>,
        <-24.727020, -5.783327, 91.500000>,
        < 22.361219, -12.283327, 91.500000>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <-24.727020, -5.783327, 91.500000>,
        < 24.727020, -5.783327, 91.500000>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <-24.834980, -5.486708, 91.438852>,
        < -24.727020, -5.783327, 91.500000>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <-24.923800, -5.242678, 91.269802>,
        < -24.834980, -5.486708, 91.438852>
      }
      triangle {
        <24.923800, -5.242678, 91.269802>,
        <-24.980659, -5.086468, 91.027285>,
        < -24.923800, -5.242678, 91.269802>
      }
      triangle {
        <24.834980, -5.486708, 91.438852>,
        <24.923800, -5.242678, 91.269802>,
        < -24.923800, -5.242678, 91.269802>
      }
      triangle {
        <25.000000, -5.033327, 90.750000>,
        <-25.000000, -5.033327, 90.750000>,
        < -24.980659, -5.086468, 91.027285>
      }
      triangle {
        <24.980659, -5.086468, 91.027285>,
        <25.000000, -5.033327, 90.750000>,
        < -24.980659, -5.086468, 91.027285>
      }
      triangle {
        <24.923800, -5.242678, 91.269802>,
        <24.980659, -5.086468, 91.027285>,
        < -24.980659, -5.086468, 91.027285>
      }
      triangle {
        <-6.409539, -2.046358, 89.500000>,
        <-6.409539, 3.979704, 89.500000>,
        < -6.500000, 3.466673, 89.500000>
      }
      triangle {
        <-6.500000, -1.533327, 89.500000>,
        <-6.409539, -2.046358, 89.500000>,
        < -6.500000, 3.466673, 89.500000>
      }
      triangle {
        <-6.409539, -2.046358, 89.500000>,
        <-6.149067, 4.430853, 89.500000>,
        < -6.409539, 3.979704, 89.500000>
      }
      triangle {
        <-5.750000, -2.832369, 89.500000>,
        <-5.750000, 4.765715, 89.500000>,
        < -6.149067, 4.430853, 89.500000>
      }
      triangle {
        <-6.149067, -2.497507, 89.500000>,
        <-5.750000, -2.832369, 89.500000>,
        < -6.149067, 4.430853, 89.500000>
      }
      triangle {
        <-6.409539, -2.046358, 89.500000>,
        <-6.149067, -2.497507, 89.500000>,
        < -6.149067, 4.430853, 89.500000>
      }
      triangle {
        <-5.260472, -3.010538, 89.500000>,
        <-5.260472, 4.943884, 89.500000>,
        < -5.750000, 4.765715, 89.500000>
      }
      triangle {
        <-5.750000, -2.832369, 89.500000>,
        <-5.260472, -3.010538, 89.500000>,
        < -5.750000, 4.765715, 89.500000>
      }
      triangle {
        <-5.260472, -3.010538, 89.500000>,
        <-4.739528, 4.943884, 89.500000>,
        < -5.260472, 4.943884, 89.500000>
      }
      triangle {
        <-4.250000, -2.832369, 89.500000>,
        <-4.250000, 4.765715, 89.500000>,
        < -4.739528, 4.943884, 89.500000>
      }
      triangle {
        <-4.739528, -3.010538, 89.500000>,
        <-4.250000, -2.832369, 89.500000>,
        < -4.739528, 4.943884, 89.500000>
      }
      triangle {
        <-5.260472, -3.010538, 89.500000>,
        <-4.739528, -3.010538, 89.500000>,
        < -4.739528, 4.943884, 89.500000>
      }
      triangle {
        <-3.850933, -2.497507, 89.500000>,
        <-3.850933, 4.430853, 89.500000>,
        < -4.250000, 4.765715, 89.500000>
      }
      triangle {
        <-4.250000, -2.832369, 89.500000>,
        <-3.850933, -2.497507, 89.500000>,
        < -4.250000, 4.765715, 89.500000>
      }
      triangle {
        <-3.590461, -2.046358, 89.500000>,
        <-3.590461, 3.979704, 89.500000>,
        < -3.850933, 4.430853, 89.500000>
      }
      triangle {
        <-3.850933, -2.497507, 89.500000>,
        <-3.590461, -2.046358, 89.500000>,
        < -3.850933, 4.430853, 89.500000>
      }
      triangle {
        <-3.500000, -1.533327, 89.500000>,
        <-3.500000, 3.466673, 89.500000>,
        < -3.590461, 3.979704, 89.500000>
      }
      triangle {
        <-3.590461, -2.046358, 89.500000>,
        <-3.500000, -1.533327, 89.500000>,
        < -3.590461, 3.979704, 89.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.500000, -1.533327, 89.500000>,
        < 1.500000, 3.466673, 89.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.409539, -2.046358, 89.500000>,
        < 1.500000, -1.533327, 89.500000>
      }
      triangle {
        <1.149067, 4.430853, 89.500000>,
        <1.149067, -2.497507, 89.500000>,
        < 1.409539, -2.046358, 89.500000>
      }
      triangle {
        <1.409539, 3.979704, 89.500000>,
        <1.149067, 4.430853, 89.500000>,
        < 1.409539, -2.046358, 89.500000>
      }
      triangle {
        <0.750000, 4.765715, 89.500000>,
        <0.750000, -2.832369, 89.500000>,
        < 1.149067, -2.497507, 89.500000>
      }
      triangle {
        <1.149067, 4.430853, 89.500000>,
        <0.750000, 4.765715, 89.500000>,
        < 1.149067, -2.497507, 89.500000>
      }
      triangle {
        <0.260472, 4.943884, 89.500000>,
        <0.260472, -3.010538, 89.500000>,
        < 0.750000, -2.832369, 89.500000>
      }
      triangle {
        <0.750000, 4.765715, 89.500000>,
        <0.260472, 4.943884, 89.500000>,
        < 0.750000, -2.832369, 89.500000>
      }
      triangle {
        <-0.260472, 4.943884, 89.500000>,
        <-0.260472, -3.010538, 89.500000>,
        < 0.260472, -3.010538, 89.500000>
      }
      triangle {
        <0.260472, 4.943884, 89.500000>,
        <-0.260472, 4.943884, 89.500000>,
        < 0.260472, -3.010538, 89.500000>
      }
      triangle {
        <-0.750000, 4.765715, 89.500000>,
        <-0.750000, -2.832369, 89.500000>,
        < -0.260472, -3.010538, 89.500000>
      }
      triangle {
        <-0.260472, 4.943884, 89.500000>,
        <-0.750000, 4.765715, 89.500000>,
        < -0.260472, -3.010538, 89.500000>
      }
      triangle {
        <-1.149067, 4.430853, 89.500000>,
        <-1.149067, -2.497507, 89.500000>,
        < -0.750000, -2.832369, 89.500000>
      }
      triangle {
        <-0.750000, 4.765715, 89.500000>,
        <-1.149067, 4.430853, 89.500000>,
        < -0.750000, -2.832369, 89.500000>
      }
      triangle {
        <-1.409539, 3.979704, 89.500000>,
        <-1.409539, -2.046358, 89.500000>,
        < -1.149067, -2.497507, 89.500000>
      }
      triangle {
        <-1.149067, 4.430853, 89.500000>,
        <-1.409539, 3.979704, 89.500000>,
        < -1.149067, -2.497507, 89.500000>
      }
      triangle {
        <-1.500000, 3.466673, 89.500000>,
        <-1.500000, -1.533327, 89.500000>,
        < -1.409539, -2.046358, 89.500000>
      }
      triangle {
        <-1.409539, 3.979704, 89.500000>,
        <-1.500000, 3.466673, 89.500000>,
        < -1.409539, -2.046358, 89.500000>
      }
      triangle {
        <-8.590461, 3.979704, 89.500000>,
        <-8.500000, -1.533327, 89.500000>,
        < -8.500000, 3.466673, 89.500000>
      }
      triangle {
        <-8.590461, 3.979704, 89.500000>,
        <-8.590461, -2.046358, 89.500000>,
        < -8.500000, -1.533327, 89.500000>
      }
      triangle {
        <-8.850933, 4.430853, 89.500000>,
        <-8.850933, -2.497507, 89.500000>,
        < -8.590461, -2.046358, 89.500000>
      }
      triangle {
        <-8.590461, 3.979704, 89.500000>,
        <-8.850933, 4.430853, 89.500000>,
        < -8.590461, -2.046358, 89.500000>
      }
      triangle {
        <-9.250000, 4.765715, 89.500000>,
        <-9.250000, -2.832369, 89.500000>,
        < -8.850933, -2.497507, 89.500000>
      }
      triangle {
        <-8.850933, 4.430853, 89.500000>,
        <-9.250000, 4.765715, 89.500000>,
        < -8.850933, -2.497507, 89.500000>
      }
      triangle {
        <-9.739528, 4.943884, 89.500000>,
        <-9.739528, -3.010538, 89.500000>,
        < -9.250000, -2.832369, 89.500000>
      }
      triangle {
        <-9.250000, 4.765715, 89.500000>,
        <-9.739528, 4.943884, 89.500000>,
        < -9.250000, -2.832369, 89.500000>
      }
      triangle {
        <-10.260470, 4.943884, 89.500000>,
        <-10.260470, -3.010538, 89.500000>,
        < -9.739528, -3.010538, 89.500000>
      }
      triangle {
        <-9.739528, 4.943884, 89.500000>,
        <-10.260470, 4.943884, 89.500000>,
        < -9.739528, -3.010538, 89.500000>
      }
      triangle {
        <-10.750000, 4.765715, 89.500000>,
        <-10.750000, -2.832369, 89.500000>,
        < -10.260470, -3.010538, 89.500000>
      }
      triangle {
        <-10.260470, 4.943884, 89.500000>,
        <-10.750000, 4.765715, 89.500000>,
        < -10.260470, -3.010538, 89.500000>
      }
      triangle {
        <-11.149070, 4.430853, 89.500000>,
        <-11.149070, -2.497507, 89.500000>,
        < -10.750000, -2.832369, 89.500000>
      }
      triangle {
        <-10.750000, 4.765715, 89.500000>,
        <-11.149070, 4.430853, 89.500000>,
        < -10.750000, -2.832369, 89.500000>
      }
      triangle {
        <-11.409540, 3.979704, 89.500000>,
        <-11.409540, -2.046358, 89.500000>,
        < -11.149070, -2.497507, 89.500000>
      }
      triangle {
        <-11.149070, 4.430853, 89.500000>,
        <-11.409540, 3.979704, 89.500000>,
        < -11.149070, -2.497507, 89.500000>
      }
      triangle {
        <-11.500000, 3.466673, 89.500000>,
        <-11.500000, -1.533327, 89.500000>,
        < -11.409540, -2.046358, 89.500000>
      }
      triangle {
        <-11.409540, 3.979704, 89.500000>,
        <-11.500000, 3.466673, 89.500000>,
        < -11.409540, -2.046358, 89.500000>
      }
      triangle {
        <-16.409540, -2.046358, 89.500000>,
        <-16.409540, 3.979704, 89.500000>,
        < -16.500000, 3.466673, 89.500000>
      }
      triangle {
        <-16.500000, -1.533327, 89.500000>,
        <-16.409540, -2.046358, 89.500000>,
        < -16.500000, 3.466673, 89.500000>
      }
      triangle {
        <-16.149071, -2.497507, 89.500000>,
        <-16.149071, 4.430853, 89.500000>,
        < -16.409540, 3.979704, 89.500000>
      }
      triangle {
        <-16.409540, -2.046358, 89.500000>,
        <-16.149071, -2.497507, 89.500000>,
        < -16.409540, 3.979704, 89.500000>
      }
      triangle {
        <-15.750000, -2.832369, 89.500000>,
        <-15.750000, 4.765715, 89.500000>,
        < -16.149071, 4.430853, 89.500000>
      }
      triangle {
        <-16.149071, -2.497507, 89.500000>,
        <-15.750000, -2.832369, 89.500000>,
        < -16.149071, 4.430853, 89.500000>
      }
      triangle {
        <-15.260470, -3.010538, 89.500000>,
        <-15.260470, 4.943884, 89.500000>,
        < -15.750000, 4.765715, 89.500000>
      }
      triangle {
        <-15.750000, -2.832369, 89.500000>,
        <-15.260470, -3.010538, 89.500000>,
        < -15.750000, 4.765715, 89.500000>
      }
      triangle {
        <-14.739530, -3.010538, 89.500000>,
        <-14.739530, 4.943884, 89.500000>,
        < -15.260470, 4.943884, 89.500000>
      }
      triangle {
        <-15.260470, -3.010538, 89.500000>,
        <-14.739530, -3.010538, 89.500000>,
        < -15.260470, 4.943884, 89.500000>
      }
      triangle {
        <-14.250000, -2.832369, 89.500000>,
        <-14.250000, 4.765715, 89.500000>,
        < -14.739530, 4.943884, 89.500000>
      }
      triangle {
        <-14.739530, -3.010538, 89.500000>,
        <-14.250000, -2.832369, 89.500000>,
        < -14.739530, 4.943884, 89.500000>
      }
      triangle {
        <-13.850930, -2.497507, 89.500000>,
        <-13.850930, 4.430853, 89.500000>,
        < -14.250000, 4.765715, 89.500000>
      }
      triangle {
        <-14.250000, -2.832369, 89.500000>,
        <-13.850930, -2.497507, 89.500000>,
        < -14.250000, 4.765715, 89.500000>
      }
      triangle {
        <-13.590460, -2.046358, 89.500000>,
        <-13.590460, 3.979704, 89.500000>,
        < -13.850930, 4.430853, 89.500000>
      }
      triangle {
        <-13.850930, -2.497507, 89.500000>,
        <-13.590460, -2.046358, 89.500000>,
        < -13.850930, 4.430853, 89.500000>
      }
      triangle {
        <-13.500000, -1.533327, 89.500000>,
        <-13.500000, 3.466673, 89.500000>,
        < -13.590460, 3.979704, 89.500000>
      }
      triangle {
        <-13.590460, -2.046358, 89.500000>,
        <-13.500000, -1.533327, 89.500000>,
        < -13.590460, 3.979704, 89.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.500000, -1.533327, 89.500000>,
        < 11.500000, 3.466673, 89.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.409540, -2.046358, 89.500000>,
        < 11.500000, -1.533327, 89.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.149070, -2.497507, 89.500000>,
        < 11.409540, -2.046358, 89.500000>
      }
      triangle {
        <10.750000, 4.765715, 89.500000>,
        <10.750000, -2.832369, 89.500000>,
        < 11.149070, -2.497507, 89.500000>
      }
      triangle {
        <11.149070, 4.430853, 89.500000>,
        <10.750000, 4.765715, 89.500000>,
        < 11.149070, -2.497507, 89.500000>
      }
      triangle {
        <11.409540, 3.979704, 89.500000>,
        <11.149070, 4.430853, 89.500000>,
        < 11.149070, -2.497507, 89.500000>
      }
      triangle {
        <10.260470, 4.943884, 89.500000>,
        <10.260470, -3.010538, 89.500000>,
        < 10.750000, -2.832369, 89.500000>
      }
      triangle {
        <10.750000, 4.765715, 89.500000>,
        <10.260470, 4.943884, 89.500000>,
        < 10.750000, -2.832369, 89.500000>
      }
      triangle {
        <10.260470, 4.943884, 89.500000>,
        <9.739528, -3.010538, 89.500000>,
        < 10.260470, -3.010538, 89.500000>
      }
      triangle {
        <9.250000, 4.765715, 89.500000>,
        <9.250000, -2.832369, 89.500000>,
        < 9.739528, -3.010538, 89.500000>
      }
      triangle {
        <9.739528, 4.943884, 89.500000>,
        <9.250000, 4.765715, 89.500000>,
        < 9.739528, -3.010538, 89.500000>
      }
      triangle {
        <10.260470, 4.943884, 89.500000>,
        <9.739528, 4.943884, 89.500000>,
        < 9.739528, -3.010538, 89.500000>
      }
      triangle {
        <8.850933, 4.430853, 89.500000>,
        <8.850933, -2.497507, 89.500000>,
        < 9.250000, -2.832369, 89.500000>
      }
      triangle {
        <9.250000, 4.765715, 89.500000>,
        <8.850933, 4.430853, 89.500000>,
        < 9.250000, -2.832369, 89.500000>
      }
      triangle {
        <8.850933, 4.430853, 89.500000>,
        <8.590461, -2.046358, 89.500000>,
        < 8.850933, -2.497507, 89.500000>
      }
      triangle {
        <8.500000, 3.466673, 89.500000>,
        <8.500000, -1.533327, 89.500000>,
        < 8.590461, -2.046358, 89.500000>
      }
      triangle {
        <8.590461, 3.979704, 89.500000>,
        <8.500000, 3.466673, 89.500000>,
        < 8.590461, -2.046358, 89.500000>
      }
      triangle {
        <8.850933, 4.430853, 89.500000>,
        <8.590461, 3.979704, 89.500000>,
        < 8.590461, -2.046358, 89.500000>
      }
      triangle {
        <3.590461, -2.046358, 89.500000>,
        <3.590461, 3.979704, 89.500000>,
        < 3.500000, 3.466673, 89.500000>
      }
      triangle {
        <3.500000, -1.533327, 89.500000>,
        <3.590461, -2.046358, 89.500000>,
        < 3.500000, 3.466673, 89.500000>
      }
      triangle {
        <3.590461, -2.046358, 89.500000>,
        <3.850933, 4.430853, 89.500000>,
        < 3.590461, 3.979704, 89.500000>
      }
      triangle {
        <4.250000, -2.832369, 89.500000>,
        <4.250000, 4.765715, 89.500000>,
        < 3.850933, 4.430853, 89.500000>
      }
      triangle {
        <3.850933, -2.497507, 89.500000>,
        <4.250000, -2.832369, 89.500000>,
        < 3.850933, 4.430853, 89.500000>
      }
      triangle {
        <3.590461, -2.046358, 89.500000>,
        <3.850933, -2.497507, 89.500000>,
        < 3.850933, 4.430853, 89.500000>
      }
      triangle {
        <4.739528, -3.010538, 89.500000>,
        <4.739528, 4.943884, 89.500000>,
        < 4.250000, 4.765715, 89.500000>
      }
      triangle {
        <4.250000, -2.832369, 89.500000>,
        <4.739528, -3.010538, 89.500000>,
        < 4.250000, 4.765715, 89.500000>
      }
      triangle {
        <5.260472, -3.010538, 89.500000>,
        <5.260472, 4.943884, 89.500000>,
        < 4.739528, 4.943884, 89.500000>
      }
      triangle {
        <4.739528, -3.010538, 89.500000>,
        <5.260472, -3.010538, 89.500000>,
        < 4.739528, 4.943884, 89.500000>
      }
      triangle {
        <5.750000, -2.832369, 89.500000>,
        <5.750000, 4.765715, 89.500000>,
        < 5.260472, 4.943884, 89.500000>
      }
      triangle {
        <5.260472, -3.010538, 89.500000>,
        <5.750000, -2.832369, 89.500000>,
        < 5.260472, 4.943884, 89.500000>
      }
      triangle {
        <6.149067, -2.497507, 89.500000>,
        <6.149067, 4.430853, 89.500000>,
        < 5.750000, 4.765715, 89.500000>
      }
      triangle {
        <5.750000, -2.832369, 89.500000>,
        <6.149067, -2.497507, 89.500000>,
        < 5.750000, 4.765715, 89.500000>
      }
      triangle {
        <6.409539, -2.046358, 89.500000>,
        <6.409539, 3.979704, 89.500000>,
        < 6.149067, 4.430853, 89.500000>
      }
      triangle {
        <6.149067, -2.497507, 89.500000>,
        <6.409539, -2.046358, 89.500000>,
        < 6.149067, 4.430853, 89.500000>
      }
      triangle {
        <6.500000, -1.533327, 89.500000>,
        <6.500000, 3.466673, 89.500000>,
        < 6.409539, 3.979704, 89.500000>
      }
      triangle {
        <6.409539, -2.046358, 89.500000>,
        <6.500000, -1.533327, 89.500000>,
        < 6.409539, 3.979704, 89.500000>
      }
      triangle {
        <13.590460, -2.046358, 89.500000>,
        <13.590460, 3.979704, 89.500000>,
        < 13.500000, 3.466673, 89.500000>
      }
      triangle {
        <13.500000, -1.533327, 89.500000>,
        <13.590460, -2.046358, 89.500000>,
        < 13.500000, 3.466673, 89.500000>
      }
      triangle {
        <13.850930, -2.497507, 89.500000>,
        <13.850930, 4.430853, 89.500000>,
        < 13.590460, 3.979704, 89.500000>
      }
      triangle {
        <13.590460, -2.046358, 89.500000>,
        <13.850930, -2.497507, 89.500000>,
        < 13.590460, 3.979704, 89.500000>
      }
      triangle {
        <14.250000, -2.832369, 89.500000>,
        <14.250000, 4.765715, 89.500000>,
        < 13.850930, 4.430853, 89.500000>
      }
      triangle {
        <13.850930, -2.497507, 89.500000>,
        <14.250000, -2.832369, 89.500000>,
        < 13.850930, 4.430853, 89.500000>
      }
      triangle {
        <14.739530, -3.010538, 89.500000>,
        <14.739530, 4.943884, 89.500000>,
        < 14.250000, 4.765715, 89.500000>
      }
      triangle {
        <14.250000, -2.832369, 89.500000>,
        <14.739530, -3.010538, 89.500000>,
        < 14.250000, 4.765715, 89.500000>
      }
      triangle {
        <15.260470, -3.010538, 89.500000>,
        <15.260470, 4.943884, 89.500000>,
        < 14.739530, 4.943884, 89.500000>
      }
      triangle {
        <14.739530, -3.010538, 89.500000>,
        <15.260470, -3.010538, 89.500000>,
        < 14.739530, 4.943884, 89.500000>
      }
      triangle {
        <15.750000, -2.832369, 89.500000>,
        <15.750000, 4.765715, 89.500000>,
        < 15.260470, 4.943884, 89.500000>
      }
      triangle {
        <15.260470, -3.010538, 89.500000>,
        <15.750000, -2.832369, 89.500000>,
        < 15.260470, 4.943884, 89.500000>
      }
      triangle {
        <16.149071, -2.497507, 89.500000>,
        <16.149071, 4.430853, 89.500000>,
        < 15.750000, 4.765715, 89.500000>
      }
      triangle {
        <15.750000, -2.832369, 89.500000>,
        <16.149071, -2.497507, 89.500000>,
        < 15.750000, 4.765715, 89.500000>
      }
      triangle {
        <16.409540, -2.046358, 89.500000>,
        <16.409540, 3.979704, 89.500000>,
        < 16.149071, 4.430853, 89.500000>
      }
      triangle {
        <16.149071, -2.497507, 89.500000>,
        <16.409540, -2.046358, 89.500000>,
        < 16.149071, 4.430853, 89.500000>
      }
      triangle {
        <16.500000, -1.533327, 89.500000>,
        <16.500000, 3.466673, 89.500000>,
        < 16.409540, 3.979704, 89.500000>
      }
      triangle {
        <16.409540, -2.046358, 89.500000>,
        <16.500000, -1.533327, 89.500000>,
        < 16.409540, 3.979704, 89.500000>
      }
      triangle {
        <-40.000000, -20.533327, 73.000000>,
        <-40.000000, -15.533327, 68.000000>,
        < -40.000000, -20.533327, 68.000000>
      }
      triangle {
        <-40.000000, -15.533327, 73.000000>,
        <-40.000000, -15.533327, 68.000000>,
        < -40.000000, -20.533327, 73.000000>
      }
      triangle {
        <-40.000000, -20.533327, 73.000000>,
        <-40.000000, -20.533327, 68.000000>,
        < -17.500000, -15.033327, 68.000000>
      }
      triangle {
        <-17.500000, -15.033327, 73.000000>,
        <-17.500000, -15.033327, 68.000000>,
        < 17.500000, -15.033327, 68.000000>
      }
      triangle {
        <-40.000000, -20.533327, 73.000000>,
        <-17.500000, -15.033327, 68.000000>,
        < -17.500000, -15.033327, 73.000000>
      }
      triangle {
        <40.000000, -15.533327, 68.000000>,
        <40.000000, -20.533327, 68.000000>,
        < 17.500000, -15.033327, 68.000000>
      }
      triangle {
        <17.500000, -15.033327, 73.000000>,
        <17.500000, -15.033327, 68.000000>,
        < 40.000000, -20.533327, 68.000000>
      }
      triangle {
        <-17.500000, -15.033327, 73.000000>,
        <17.500000, -15.033327, 68.000000>,
        < 17.500000, -15.033327, 73.000000>
      }
      triangle {
        <40.000000, -15.533327, 73.000000>,
        <40.000000, -20.533327, 68.000000>,
        < 40.000000, -15.533327, 68.000000>
      }
      triangle {
        <40.000000, -20.533327, 73.000000>,
        <40.000000, -20.533327, 68.000000>,
        < 40.000000, -15.533327, 73.000000>
      }
      triangle {
        <17.500000, -15.033327, 73.000000>,
        <40.000000, -20.533327, 68.000000>,
        < 40.000000, -20.533327, 73.000000>
      }
      triangle {
        <-40.000000, -15.533327, 73.000000>,
        <-40.000000, -20.533327, 73.000000>,
        < -17.500000, -15.033327, 73.000000>
      }
      triangle {
        <-40.000000, -20.533327, -62.000000>,
        <-40.000000, -15.533327, -62.000000>,
        < -17.500000, -10.033327, -62.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-17.500000, -10.033327, -62.000000>,
        < -40.000000, -15.533327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -62.000000>,
        <-40.000000, -20.533327, -62.000000>,
        < -17.500000, -10.033327, -62.000000>
      }
      triangle {
        <-40.000000, -20.533327, -57.000000>,
        <-40.000000, -15.533327, -62.000000>,
        < -40.000000, -20.533327, -62.000000>
      }
      triangle {
        <-40.000000, -15.533327, -57.000000>,
        <-40.000000, -15.533327, -62.000000>,
        < -40.000000, -20.533327, -57.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-40.000000, -15.533327, -62.000000>,
        < -40.000000, -15.533327, -57.000000>
      }
      triangle {
        <-40.000000, -20.533327, -57.000000>,
        <-40.000000, -20.533327, -62.000000>,
        < -17.500000, -15.033327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -57.000000>,
        <-17.500000, -15.033327, -62.000000>,
        < 17.500000, -15.033327, -62.000000>
      }
      triangle {
        <-40.000000, -20.533327, -57.000000>,
        <-17.500000, -15.033327, -62.000000>,
        < -17.500000, -15.033327, -57.000000>
      }
      triangle {
        <40.000000, -15.533327, -62.000000>,
        <40.000000, -20.533327, -62.000000>,
        < 17.500000, -15.033327, -62.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <17.500000, -15.033327, -62.000000>,
        < 40.000000, -20.533327, -62.000000>
      }
      triangle {
        <17.500000, -10.033327, -62.000000>,
        <40.000000, -15.533327, -62.000000>,
        < 17.500000, -15.033327, -62.000000>
      }
      triangle {
        <-17.500000, -15.033327, -57.000000>,
        <17.500000, -15.033327, -62.000000>,
        < 17.500000, -15.033327, -57.000000>
      }
      triangle {
        <40.000000, -15.533327, -57.000000>,
        <40.000000, -20.533327, -62.000000>,
        < 40.000000, -15.533327, -62.000000>
      }
      triangle {
        <40.000000, -20.533327, -57.000000>,
        <40.000000, -20.533327, -62.000000>,
        < 40.000000, -15.533327, -57.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <40.000000, -20.533327, -62.000000>,
        < 40.000000, -20.533327, -57.000000>
      }
      triangle {
        <40.000000, -15.533327, -57.000000>,
        <40.000000, -15.533327, -62.000000>,
        < 17.500000, -10.033327, -62.000000>
      }
      triangle {
        <40.000000, -15.533327, -57.000000>,
        <17.500000, -10.033327, -62.000000>,
        < 17.500000, -10.033327, -57.000000>
      }
      triangle {
        <40.000000, -20.533327, -57.000000>,
        <40.000000, -15.533327, -57.000000>,
        < 17.500000, -10.033327, -57.000000>
      }
      triangle {
        <17.500000, -15.033327, -57.000000>,
        <40.000000, -20.533327, -57.000000>,
        < 17.500000, -10.033327, -57.000000>
      }
      triangle {
        <-40.000000, -15.533327, -57.000000>,
        <-40.000000, -20.533327, -57.000000>,
        < -17.500000, -15.033327, -57.000000>
      }
      triangle {
        <-17.500000, -10.033327, -57.000000>,
        <-40.000000, -15.533327, -57.000000>,
        < -17.500000, -15.033327, -57.000000>
      }
      triangle {
        <-19.000000, -3.033327, 88.500000>,
        <-19.000000, 4.966673, 88.500000>,
        < -25.000000, 4.966673, 88.500000>
      }
      triangle {
        <-25.000000, 4.966673, 90.125000>,
        <-25.000000, 4.966673, 88.500000>,
        < -19.000000, 4.966673, 88.500000>
      }
      triangle {
        <-25.000000, -3.033327, 88.500000>,
        <-19.000000, -3.033327, 88.500000>,
        < -25.000000, 4.966673, 88.500000>
      }
      triangle {
        <-25.382681, 4.890555, 88.500000>,
        <-25.000000, -3.033327, 88.500000>,
        < -25.000000, 4.966673, 88.500000>
      }
      triangle {
        <-25.382681, 4.890555, 90.125000>,
        <-25.382681, 4.890555, 88.500000>,
        < -25.000000, 4.966673, 88.500000>
      }
      triangle {
        <-25.000000, 4.966673, 90.125000>,
        <-25.382681, 4.890555, 90.125000>,
        < -25.000000, 4.966673, 88.500000>
      }
      triangle {
        <-18.617319, -2.957209, 88.500000>,
        <-18.617319, 4.890555, 88.500000>,
        < -19.000000, 4.966673, 88.500000>
      }
      triangle {
        <-19.000000, 4.966673, 90.125000>,
        <-19.000000, 4.966673, 88.500000>,
        < -18.617319, 4.890555, 88.500000>
      }
      triangle {
        <-19.000000, -3.033327, 88.500000>,
        <-18.617319, -2.957209, 88.500000>,
        < -19.000000, 4.966673, 88.500000>
      }
      triangle {
        <-19.000000, 4.966673, 90.125000>,
        <-25.000000, 4.966673, 90.125000>,
        < -19.000000, 4.966673, 88.500000>
      }
      triangle {
        <-18.292891, -2.740438, 88.500000>,
        <-18.292891, 4.673784, 88.500000>,
        < -18.617319, 4.890555, 88.500000>
      }
      triangle {
        <-18.617319, 4.890555, 90.125000>,
        <-18.617319, 4.890555, 88.500000>,
        < -18.292891, 4.673784, 88.500000>
      }
      triangle {
        <-18.617319, -2.957209, 88.500000>,
        <-18.292891, -2.740438, 88.500000>,
        < -18.617319, 4.890555, 88.500000>
      }
      triangle {
        <-18.617319, 4.890555, 90.125000>,
        <-19.000000, 4.966673, 90.125000>,
        < -18.617319, 4.890555, 88.500000>
      }
      triangle {
        <-18.076120, -2.416006, 88.500000>,
        <-18.076120, 4.349352, 88.500000>,
        < -18.292891, 4.673784, 88.500000>
      }
      triangle {
        <-18.292891, 4.673784, 90.125000>,
        <-18.292891, 4.673784, 88.500000>,
        < -18.076120, 4.349352, 88.500000>
      }
      triangle {
        <-18.292891, -2.740438, 88.500000>,
        <-18.076120, -2.416006, 88.500000>,
        < -18.292891, 4.673784, 88.500000>
      }
      triangle {
        <-18.292891, 4.673784, 90.125000>,
        <-18.617319, 4.890555, 90.125000>,
        < -18.292891, 4.673784, 88.500000>
      }
      triangle {
        <-18.000000, -2.033327, 88.500000>,
        <-18.000000, 3.966673, 88.500000>,
        < -18.076120, 4.349352, 88.500000>
      }
      triangle {
        <-18.076120, 4.349352, 90.125000>,
        <-18.076120, 4.349352, 88.500000>,
        < -18.000000, 3.966673, 88.500000>
      }
      triangle {
        <-18.076120, -2.416006, 88.500000>,
        <-18.000000, -2.033327, 88.500000>,
        < -18.076120, 4.349352, 88.500000>
      }
      triangle {
        <-18.076120, 4.349352, 90.125000>,
        <-18.292891, 4.673784, 90.125000>,
        < -18.076120, 4.349352, 88.500000>
      }
      triangle {
        <-18.000000, 3.966673, 90.125000>,
        <-18.000000, 3.966673, 88.500000>,
        < -18.000000, -2.033327, 88.500000>
      }
      triangle {
        <-18.076120, 4.349352, 90.125000>,
        <-18.000000, 3.966673, 88.500000>,
        < -18.000000, 3.966673, 90.125000>
      }
      triangle {
        <-18.000000, -2.033327, 90.125000>,
        <-18.000000, -2.033327, 88.500000>,
        < -18.076120, -2.416006, 88.500000>
      }
      triangle {
        <-18.000000, 3.966673, 90.125000>,
        <-18.000000, -2.033327, 88.500000>,
        < -18.000000, -2.033327, 90.125000>
      }
      triangle {
        <-18.076120, -2.416006, 90.125000>,
        <-18.076120, -2.416006, 88.500000>,
        < -18.292891, -2.740438, 88.500000>
      }
      triangle {
        <-18.076120, -2.416006, 90.125000>,
        <-18.000000, -2.033327, 90.125000>,
        < -18.076120, -2.416006, 88.500000>
      }
      triangle {
        <-18.292891, -2.740438, 90.125000>,
        <-18.292891, -2.740438, 88.500000>,
        < -18.617319, -2.957209, 88.500000>
      }
      triangle {
        <-18.292891, -2.740438, 90.125000>,
        <-18.076120, -2.416006, 90.125000>,
        < -18.292891, -2.740438, 88.500000>
      }
      triangle {
        <-18.617319, -2.957209, 90.125000>,
        <-18.617319, -2.957209, 88.500000>,
        < -19.000000, -3.033327, 88.500000>
      }
      triangle {
        <-18.617319, -2.957209, 90.125000>,
        <-18.292891, -2.740438, 90.125000>,
        < -18.617319, -2.957209, 88.500000>
      }
      triangle {
        <-19.000000, -3.033327, 90.125000>,
        <-19.000000, -3.033327, 88.500000>,
        < -25.000000, -3.033327, 88.500000>
      }
      triangle {
        <-18.617319, -2.957209, 90.125000>,
        <-19.000000, -3.033327, 88.500000>,
        < -19.000000, -3.033327, 90.125000>
      }
      triangle {
        <-25.382681, 4.890555, 88.500000>,
        <-25.382681, -2.957209, 88.500000>,
        < -25.000000, -3.033327, 88.500000>
      }
      triangle {
        <-25.000000, -3.033327, 90.125000>,
        <-25.000000, -3.033327, 88.500000>,
        < -25.382681, -2.957209, 88.500000>
      }
      triangle {
        <-19.000000, -3.033327, 90.125000>,
        <-25.000000, -3.033327, 88.500000>,
        < -25.000000, -3.033327, 90.125000>
      }
      triangle {
        <-25.707109, 4.673784, 88.500000>,
        <-25.707109, -2.740438, 88.500000>,
        < -25.382681, -2.957209, 88.500000>
      }
      triangle {
        <-25.382681, -2.957209, 90.125000>,
        <-25.382681, -2.957209, 88.500000>,
        < -25.707109, -2.740438, 88.500000>
      }
      triangle {
        <-25.382681, 4.890555, 88.500000>,
        <-25.707109, 4.673784, 88.500000>,
        < -25.382681, -2.957209, 88.500000>
      }
      triangle {
        <-25.382681, -2.957209, 90.125000>,
        <-25.000000, -3.033327, 90.125000>,
        < -25.382681, -2.957209, 88.500000>
      }
      triangle {
        <-25.923880, 4.349352, 88.500000>,
        <-25.923880, -2.416006, 88.500000>,
        < -25.707109, -2.740438, 88.500000>
      }
      triangle {
        <-25.923880, -2.416006, 90.125000>,
        <-25.707109, -2.740438, 88.500000>,
        < -25.923880, -2.416006, 88.500000>
      }
      triangle {
        <-25.707109, 4.673784, 88.500000>,
        <-25.923880, 4.349352, 88.500000>,
        < -25.707109, -2.740438, 88.500000>
      }
      triangle {
        <-25.707109, -2.740438, 90.125000>,
        <-25.382681, -2.957209, 90.125000>,
        < -25.707109, -2.740438, 88.500000>
      }
      triangle {
        <-25.923880, -2.416006, 90.125000>,
        <-25.707109, -2.740438, 90.125000>,
        < -25.707109, -2.740438, 88.500000>
      }
      triangle {
        <-26.000000, 3.966673, 88.500000>,
        <-26.000000, -2.033327, 88.500000>,
        < -25.923880, -2.416006, 88.500000>
      }
      triangle {
        <-25.923880, -2.416006, 90.125000>,
        <-25.923880, -2.416006, 88.500000>,
        < -26.000000, -2.033327, 88.500000>
      }
      triangle {
        <-25.923880, 4.349352, 88.500000>,
        <-26.000000, 3.966673, 88.500000>,
        < -25.923880, -2.416006, 88.500000>
      }
      triangle {
        <-26.000000, -2.033327, 90.125000>,
        <-26.000000, -2.033327, 88.500000>,
        < -26.000000, 3.966673, 88.500000>
      }
      triangle {
        <-25.923880, -2.416006, 90.125000>,
        <-26.000000, -2.033327, 88.500000>,
        < -26.000000, -2.033327, 90.125000>
      }
      triangle {
        <-26.000000, 3.966673, 90.125000>,
        <-26.000000, 3.966673, 88.500000>,
        < -25.923880, 4.349352, 88.500000>
      }
      triangle {
        <-26.000000, -2.033327, 90.125000>,
        <-26.000000, 3.966673, 88.500000>,
        < -26.000000, 3.966673, 90.125000>
      }
      triangle {
        <-25.923880, 4.349352, 90.125000>,
        <-25.923880, 4.349352, 88.500000>,
        < -25.707109, 4.673784, 88.500000>
      }
      triangle {
        <-25.923880, 4.349352, 90.125000>,
        <-26.000000, 3.966673, 90.125000>,
        < -25.923880, 4.349352, 88.500000>
      }
      triangle {
        <-25.707109, 4.673784, 90.125000>,
        <-25.707109, 4.673784, 88.500000>,
        < -25.382681, 4.890555, 88.500000>
      }
      triangle {
        <-25.707109, 4.673784, 90.125000>,
        <-25.923880, 4.349352, 90.125000>,
        < -25.707109, 4.673784, 88.500000>
      }
      triangle {
        <-25.382681, 4.890555, 90.125000>,
        <-25.707109, 4.673784, 90.125000>,
        < -25.382681, 4.890555, 88.500000>
      }
      triangle {
        <18.076120, -2.416006, 88.500000>,
        <18.076120, 4.349352, 88.500000>,
        < 18.000000, 3.966673, 88.500000>
      }
      triangle {
        <18.000000, 3.966673, 90.125000>,
        <18.000000, 3.966673, 88.500000>,
        < 18.076120, 4.349352, 88.500000>
      }
      triangle {
        <18.000000, -2.033327, 88.500000>,
        <18.076120, -2.416006, 88.500000>,
        < 18.000000, 3.966673, 88.500000>
      }
      triangle {
        <18.000000, -2.033327, 90.125000>,
        <18.000000, -2.033327, 88.500000>,
        < 18.000000, 3.966673, 88.500000>
      }
      triangle {
        <18.000000, 3.966673, 90.125000>,
        <18.000000, -2.033327, 90.125000>,
        < 18.000000, 3.966673, 88.500000>
      }
      triangle {
        <18.292891, -2.740438, 88.500000>,
        <18.292891, 4.673784, 88.500000>,
        < 18.076120, 4.349352, 88.500000>
      }
      triangle {
        <18.076120, 4.349352, 90.125000>,
        <18.076120, 4.349352, 88.500000>,
        < 18.292891, 4.673784, 88.500000>
      }
      triangle {
        <18.076120, -2.416006, 88.500000>,
        <18.292891, -2.740438, 88.500000>,
        < 18.076120, 4.349352, 88.500000>
      }
      triangle {
        <18.076120, 4.349352, 90.125000>,
        <18.000000, 3.966673, 90.125000>,
        < 18.076120, 4.349352, 88.500000>
      }
      triangle {
        <18.617319, -2.957209, 88.500000>,
        <18.617319, 4.890555, 88.500000>,
        < 18.292891, 4.673784, 88.500000>
      }
      triangle {
        <18.292891, 4.673784, 90.125000>,
        <18.292891, 4.673784, 88.500000>,
        < 18.617319, 4.890555, 88.500000>
      }
      triangle {
        <18.292891, -2.740438, 88.500000>,
        <18.617319, -2.957209, 88.500000>,
        < 18.292891, 4.673784, 88.500000>
      }
      triangle {
        <18.292891, 4.673784, 90.125000>,
        <18.076120, 4.349352, 90.125000>,
        < 18.292891, 4.673784, 88.500000>
      }
      triangle {
        <19.000000, -3.033327, 88.500000>,
        <19.000000, 4.966673, 88.500000>,
        < 18.617319, 4.890555, 88.500000>
      }
      triangle {
        <18.617319, 4.890555, 90.125000>,
        <18.617319, 4.890555, 88.500000>,
        < 19.000000, 4.966673, 88.500000>
      }
      triangle {
        <18.617319, -2.957209, 88.500000>,
        <19.000000, -3.033327, 88.500000>,
        < 18.617319, 4.890555, 88.500000>
      }
      triangle {
        <18.617319, 4.890555, 90.125000>,
        <18.292891, 4.673784, 90.125000>,
        < 18.617319, 4.890555, 88.500000>
      }
      triangle {
        <25.000000, -3.033327, 88.500000>,
        <25.000000, 4.966673, 88.500000>,
        < 19.000000, 4.966673, 88.500000>
      }
      triangle {
        <19.000000, 4.966673, 90.125000>,
        <19.000000, 4.966673, 88.500000>,
        < 25.000000, 4.966673, 88.500000>
      }
      triangle {
        <19.000000, -3.033327, 88.500000>,
        <25.000000, -3.033327, 88.500000>,
        < 19.000000, 4.966673, 88.500000>
      }
      triangle {
        <18.617319, 4.890555, 90.125000>,
        <19.000000, 4.966673, 88.500000>,
        < 19.000000, 4.966673, 90.125000>
      }
      triangle {
        <25.382681, -2.957209, 88.500000>,
        <25.382681, 4.890555, 88.500000>,
        < 25.000000, 4.966673, 88.500000>
      }
      triangle {
        <25.000000, 4.966673, 90.125000>,
        <25.000000, 4.966673, 88.500000>,
        < 25.382681, 4.890555, 88.500000>
      }
      triangle {
        <25.000000, -3.033327, 88.500000>,
        <25.382681, -2.957209, 88.500000>,
        < 25.000000, 4.966673, 88.500000>
      }
      triangle {
        <19.000000, 4.966673, 90.125000>,
        <25.000000, 4.966673, 88.500000>,
        < 25.000000, 4.966673, 90.125000>
      }
      triangle {
        <25.707109, -2.740438, 88.500000>,
        <25.707109, 4.673784, 88.500000>,
        < 25.382681, 4.890555, 88.500000>
      }
      triangle {
        <25.382681, 4.890555, 90.125000>,
        <25.382681, 4.890555, 88.500000>,
        < 25.707109, 4.673784, 88.500000>
      }
      triangle {
        <25.382681, -2.957209, 88.500000>,
        <25.707109, -2.740438, 88.500000>,
        < 25.382681, 4.890555, 88.500000>
      }
      triangle {
        <25.382681, 4.890555, 90.125000>,
        <25.000000, 4.966673, 90.125000>,
        < 25.382681, 4.890555, 88.500000>
      }
      triangle {
        <25.923880, -2.416006, 88.500000>,
        <25.923880, 4.349352, 88.500000>,
        < 25.707109, 4.673784, 88.500000>
      }
      triangle {
        <25.707109, 4.673784, 90.125000>,
        <25.707109, 4.673784, 88.500000>,
        < 25.923880, 4.349352, 88.500000>
      }
      triangle {
        <25.707109, -2.740438, 88.500000>,
        <25.923880, -2.416006, 88.500000>,
        < 25.707109, 4.673784, 88.500000>
      }
      triangle {
        <25.707109, 4.673784, 90.125000>,
        <25.382681, 4.890555, 90.125000>,
        < 25.707109, 4.673784, 88.500000>
      }
      triangle {
        <26.000000, -2.033327, 88.500000>,
        <26.000000, 3.966673, 88.500000>,
        < 25.923880, 4.349352, 88.500000>
      }
      triangle {
        <25.923880, 4.349352, 90.125000>,
        <25.923880, 4.349352, 88.500000>,
        < 26.000000, 3.966673, 88.500000>
      }
      triangle {
        <25.923880, -2.416006, 88.500000>,
        <26.000000, -2.033327, 88.500000>,
        < 25.923880, 4.349352, 88.500000>
      }
      triangle {
        <25.923880, 4.349352, 90.125000>,
        <25.707109, 4.673784, 90.125000>,
        < 25.923880, 4.349352, 88.500000>
      }
      triangle {
        <26.000000, 3.966673, 90.125000>,
        <26.000000, 3.966673, 88.500000>,
        < 26.000000, -2.033327, 88.500000>
      }
      triangle {
        <25.923880, 4.349352, 90.125000>,
        <26.000000, 3.966673, 88.500000>,
        < 26.000000, 3.966673, 90.125000>
      }
      triangle {
        <26.000000, -2.033327, 90.125000>,
        <26.000000, -2.033327, 88.500000>,
        < 25.923880, -2.416006, 88.500000>
      }
      triangle {
        <26.000000, 3.966673, 90.125000>,
        <26.000000, -2.033327, 88.500000>,
        < 26.000000, -2.033327, 90.125000>
      }
      triangle {
        <25.923880, -2.416006, 90.125000>,
        <25.923880, -2.416006, 88.500000>,
        < 25.707109, -2.740438, 88.500000>
      }
      triangle {
        <25.923880, -2.416006, 90.125000>,
        <26.000000, -2.033327, 90.125000>,
        < 25.923880, -2.416006, 88.500000>
      }
      triangle {
        <25.707109, -2.740438, 90.125000>,
        <25.707109, -2.740438, 88.500000>,
        < 25.382681, -2.957209, 88.500000>
      }
      triangle {
        <25.707109, -2.740438, 90.125000>,
        <25.923880, -2.416006, 90.125000>,
        < 25.707109, -2.740438, 88.500000>
      }
      triangle {
        <25.382681, -2.957209, 90.125000>,
        <25.382681, -2.957209, 88.500000>,
        < 25.000000, -3.033327, 88.500000>
      }
      triangle {
        <25.382681, -2.957209, 90.125000>,
        <25.707109, -2.740438, 90.125000>,
        < 25.382681, -2.957209, 88.500000>
      }
      triangle {
        <25.000000, -3.033327, 90.125000>,
        <25.000000, -3.033327, 88.500000>,
        < 19.000000, -3.033327, 88.500000>
      }
      triangle {
        <25.382681, -2.957209, 90.125000>,
        <25.000000, -3.033327, 88.500000>,
        < 25.000000, -3.033327, 90.125000>
      }
      triangle {
        <19.000000, -3.033327, 90.125000>,
        <19.000000, -3.033327, 88.500000>,
        < 18.617319, -2.957209, 88.500000>
      }
      triangle {
        <25.000000, -3.033327, 90.125000>,
        <19.000000, -3.033327, 88.500000>,
        < 19.000000, -3.033327, 90.125000>
      }
      triangle {
        <18.617319, -2.957209, 90.125000>,
        <18.617319, -2.957209, 88.500000>,
        < 18.292891, -2.740438, 88.500000>
      }
      triangle {
        <18.617319, -2.957209, 90.125000>,
        <19.000000, -3.033327, 90.125000>,
        < 18.617319, -2.957209, 88.500000>
      }
      triangle {
        <18.292891, -2.740438, 90.125000>,
        <18.292891, -2.740438, 88.500000>,
        < 18.076120, -2.416006, 88.500000>
      }
      triangle {
        <18.292891, -2.740438, 90.125000>,
        <18.617319, -2.957209, 90.125000>,
        < 18.292891, -2.740438, 88.500000>
      }
      triangle {
        <18.076120, -2.416006, 90.125000>,
        <18.076120, -2.416006, 88.500000>,
        < 18.000000, -2.033327, 88.500000>
      }
      triangle {
        <18.076120, -2.416006, 90.125000>,
        <18.292891, -2.740438, 90.125000>,
        < 18.076120, -2.416006, 88.500000>
      }
      triangle {
        <18.076120, -2.416006, 90.125000>,
        <18.000000, -2.033327, 88.500000>,
        < 18.000000, -2.033327, 90.125000>
      }
      triangle {
        <-26.050140, 3.966673, 90.312330>,
        <-26.000000, 3.966673, 90.125000>,
        < -25.923880, 4.349352, 90.125000>
      }
      triangle {
        <-26.050140, 3.966673, 90.312330>,
        <-26.000000, -2.033327, 90.125000>,
        < -26.000000, 3.966673, 90.125000>
      }
      triangle {
        <-25.849581, 4.583933, 90.312330>,
        <-25.923880, 4.349352, 90.125000>,
        < -25.707109, 4.673784, 90.125000>
      }
      triangle {
        <-25.998739, 4.291182, 90.312330>,
        <-26.050140, 3.966673, 90.312330>,
        < -25.923880, 4.349352, 90.125000>
      }
      triangle {
        <-25.849581, 4.583933, 90.312330>,
        <-25.998739, 4.291182, 90.312330>,
        < -25.923880, 4.349352, 90.125000>
      }
      triangle {
        <-25.617260, 4.816252, 90.312330>,
        <-25.707109, 4.673784, 90.125000>,
        < -25.382681, 4.890555, 90.125000>
      }
      triangle {
        <-25.617260, 4.816252, 90.312330>,
        <-25.849581, 4.583933, 90.312330>,
        < -25.707109, 4.673784, 90.125000>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.382681, 4.890555, 90.125000>,
        < -25.000000, 4.966673, 90.125000>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.617260, 4.816252, 90.312330>,
        < -25.382681, 4.890555, 90.125000>
      }
      triangle {
        <-19.000000, 5.016813, 90.312330>,
        <-25.000000, 4.966673, 90.125000>,
        < -19.000000, 4.966673, 90.125000>
      }
      triangle {
        <-25.000000, 5.016813, 90.312330>,
        <-25.000000, 4.966673, 90.125000>,
        < -19.000000, 5.016813, 90.312330>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.000000, 4.966673, 90.125000>,
        < -25.000000, 5.016813, 90.312330>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-25.923880, -2.416006, 90.125000>,
        < -26.000000, -2.033327, 90.125000>
      }
      triangle {
        <-26.050140, -2.033327, 90.312330>,
        <-26.000000, -2.033327, 90.125000>,
        < -26.050140, 3.966673, 90.312330>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-26.000000, -2.033327, 90.125000>,
        < -26.050140, -2.033327, 90.312330>
      }
      triangle {
        <-25.000000, -3.083467, 90.312330>,
        <-25.000000, -3.033327, 90.125000>,
        < -25.382681, -2.957209, 90.125000>
      }
      triangle {
        <-25.000000, -3.083467, 90.312330>,
        <-19.000000, -3.033327, 90.125000>,
        < -25.000000, -3.033327, 90.125000>
      }
      triangle {
        <-25.525070, -2.942778, 90.312330>,
        <-25.382681, -2.957209, 90.125000>,
        < -25.707109, -2.740438, 90.125000>
      }
      triangle {
        <-25.271799, -3.047686, 90.312330>,
        <-25.000000, -3.083467, 90.312330>,
        < -25.382681, -2.957209, 90.125000>
      }
      triangle {
        <-25.525070, -2.942778, 90.312330>,
        <-25.271799, -3.047686, 90.312330>,
        < -25.382681, -2.957209, 90.125000>
      }
      triangle {
        <-25.742559, -2.775888, 90.312330>,
        <-25.707109, -2.740438, 90.125000>,
        < -25.923880, -2.416006, 90.125000>
      }
      triangle {
        <-25.742559, -2.775888, 90.312330>,
        <-25.525070, -2.942778, 90.312330>,
        < -25.707109, -2.740438, 90.125000>
      }
      triangle {
        <-25.909451, -2.558397, 90.312330>,
        <-25.742559, -2.775888, 90.312330>,
        < -25.923880, -2.416006, 90.125000>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-25.909451, -2.558397, 90.312330>,
        < -25.923880, -2.416006, 90.125000>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-18.617319, -2.957209, 90.125000>,
        < -19.000000, -3.033327, 90.125000>
      }
      triangle {
        <-19.000000, -3.083467, 90.312330>,
        <-19.000000, -3.033327, 90.125000>,
        < -25.000000, -3.083467, 90.312330>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-19.000000, -3.033327, 90.125000>,
        < -19.000000, -3.083467, 90.312330>
      }
      triangle {
        <-17.949860, -2.033327, 90.312330>,
        <-18.000000, -2.033327, 90.125000>,
        < -18.076120, -2.416006, 90.125000>
      }
      triangle {
        <-17.949860, -2.033327, 90.312330>,
        <-18.000000, 3.966673, 90.125000>,
        < -18.000000, -2.033327, 90.125000>
      }
      triangle {
        <-18.150419, -2.650587, 90.312330>,
        <-18.076120, -2.416006, 90.125000>,
        < -18.292891, -2.740438, 90.125000>
      }
      triangle {
        <-18.001261, -2.357836, 90.312330>,
        <-17.949860, -2.033327, 90.312330>,
        < -18.076120, -2.416006, 90.125000>
      }
      triangle {
        <-18.150419, -2.650587, 90.312330>,
        <-18.001261, -2.357836, 90.312330>,
        < -18.076120, -2.416006, 90.125000>
      }
      triangle {
        <-18.382740, -2.882906, 90.312330>,
        <-18.292891, -2.740438, 90.125000>,
        < -18.617319, -2.957209, 90.125000>
      }
      triangle {
        <-18.382740, -2.882906, 90.312330>,
        <-18.150419, -2.650587, 90.312330>,
        < -18.292891, -2.740438, 90.125000>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-18.382740, -2.882906, 90.312330>,
        < -18.617319, -2.957209, 90.125000>
      }
      triangle {
        <-18.001261, 4.291182, 90.312330>,
        <-18.076120, 4.349352, 90.125000>,
        < -18.000000, 3.966673, 90.125000>
      }
      triangle {
        <-17.949860, 3.966673, 90.312330>,
        <-18.000000, 3.966673, 90.125000>,
        < -17.949860, -2.033327, 90.312330>
      }
      triangle {
        <-18.001261, 4.291182, 90.312330>,
        <-18.000000, 3.966673, 90.125000>,
        < -17.949860, 3.966673, 90.312330>
      }
      triangle {
        <-19.000000, 5.016813, 90.312330>,
        <-19.000000, 4.966673, 90.125000>,
        < -18.617319, 4.890555, 90.125000>
      }
      triangle {
        <-18.382740, 4.816252, 90.312330>,
        <-18.617319, 4.890555, 90.125000>,
        < -18.292891, 4.673784, 90.125000>
      }
      triangle {
        <-18.675489, 4.965414, 90.312330>,
        <-19.000000, 5.016813, 90.312330>,
        < -18.617319, 4.890555, 90.125000>
      }
      triangle {
        <-18.382740, 4.816252, 90.312330>,
        <-18.675489, 4.965414, 90.312330>,
        < -18.617319, 4.890555, 90.125000>
      }
      triangle {
        <-18.150419, 4.583933, 90.312330>,
        <-18.292891, 4.673784, 90.125000>,
        < -18.076120, 4.349352, 90.125000>
      }
      triangle {
        <-18.150419, 4.583933, 90.312330>,
        <-18.382740, 4.816252, 90.312330>,
        < -18.292891, 4.673784, 90.125000>
      }
      triangle {
        <-18.001261, 4.291182, 90.312330>,
        <-18.150419, 4.583933, 90.312330>,
        < -18.076120, 4.349352, 90.125000>
      }
      triangle {
        <17.949860, 3.966673, 90.312330>,
        <18.000000, -2.033327, 90.125000>,
        < 18.000000, 3.966673, 90.125000>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <18.076120, -2.416006, 90.125000>,
        < 18.000000, -2.033327, 90.125000>
      }
      triangle {
        <17.949860, -2.033327, 90.312330>,
        <18.000000, -2.033327, 90.125000>,
        < 17.949860, 3.966673, 90.312330>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <18.000000, -2.033327, 90.125000>,
        < 17.949860, -2.033327, 90.312330>
      }
      triangle {
        <17.949860, 3.966673, 90.312330>,
        <18.000000, 3.966673, 90.125000>,
        < 18.076120, 4.349352, 90.125000>
      }
      triangle {
        <19.000000, -3.083467, 90.312330>,
        <19.000000, -3.033327, 90.125000>,
        < 18.617319, -2.957209, 90.125000>
      }
      triangle {
        <19.000000, -3.083467, 90.312330>,
        <25.000000, -3.033327, 90.125000>,
        < 19.000000, -3.033327, 90.125000>
      }
      triangle {
        <18.474930, -2.942778, 90.312330>,
        <18.617319, -2.957209, 90.125000>,
        < 18.292891, -2.740438, 90.125000>
      }
      triangle {
        <18.728201, -3.047686, 90.312330>,
        <19.000000, -3.083467, 90.312330>,
        < 18.617319, -2.957209, 90.125000>
      }
      triangle {
        <18.474930, -2.942778, 90.312330>,
        <18.728201, -3.047686, 90.312330>,
        < 18.617319, -2.957209, 90.125000>
      }
      triangle {
        <18.257441, -2.775888, 90.312330>,
        <18.292891, -2.740438, 90.125000>,
        < 18.076120, -2.416006, 90.125000>
      }
      triangle {
        <18.257441, -2.775888, 90.312330>,
        <18.474930, -2.942778, 90.312330>,
        < 18.292891, -2.740438, 90.125000>
      }
      triangle {
        <18.090549, -2.558397, 90.312330>,
        <18.257441, -2.775888, 90.312330>,
        < 18.076120, -2.416006, 90.125000>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <18.090549, -2.558397, 90.312330>,
        < 18.076120, -2.416006, 90.125000>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.382681, -2.957209, 90.125000>,
        < 25.000000, -3.033327, 90.125000>
      }
      triangle {
        <25.000000, -3.083467, 90.312330>,
        <25.000000, -3.033327, 90.125000>,
        < 19.000000, -3.083467, 90.312330>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.000000, -3.033327, 90.125000>,
        < 25.000000, -3.083467, 90.312330>
      }
      triangle {
        <26.050140, -2.033327, 90.312330>,
        <26.000000, -2.033327, 90.125000>,
        < 25.923880, -2.416006, 90.125000>
      }
      triangle {
        <26.050140, -2.033327, 90.312330>,
        <26.000000, 3.966673, 90.125000>,
        < 26.000000, -2.033327, 90.125000>
      }
      triangle {
        <25.849581, -2.650587, 90.312330>,
        <25.923880, -2.416006, 90.125000>,
        < 25.707109, -2.740438, 90.125000>
      }
      triangle {
        <25.998739, -2.357836, 90.312330>,
        <26.050140, -2.033327, 90.312330>,
        < 25.923880, -2.416006, 90.125000>
      }
      triangle {
        <25.849581, -2.650587, 90.312330>,
        <25.998739, -2.357836, 90.312330>,
        < 25.923880, -2.416006, 90.125000>
      }
      triangle {
        <25.617260, -2.882906, 90.312330>,
        <25.707109, -2.740438, 90.125000>,
        < 25.382681, -2.957209, 90.125000>
      }
      triangle {
        <25.617260, -2.882906, 90.312330>,
        <25.849581, -2.650587, 90.312330>,
        < 25.707109, -2.740438, 90.125000>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.617260, -2.882906, 90.312330>,
        < 25.382681, -2.957209, 90.125000>
      }
      triangle {
        <25.998739, 4.291182, 90.312330>,
        <25.923880, 4.349352, 90.125000>,
        < 26.000000, 3.966673, 90.125000>
      }
      triangle {
        <26.050140, 3.966673, 90.312330>,
        <26.000000, 3.966673, 90.125000>,
        < 26.050140, -2.033327, 90.312330>
      }
      triangle {
        <25.998739, 4.291182, 90.312330>,
        <26.000000, 3.966673, 90.125000>,
        < 26.050140, 3.966673, 90.312330>
      }
      triangle {
        <25.000000, 5.016813, 90.312330>,
        <25.000000, 4.966673, 90.125000>,
        < 25.382681, 4.890555, 90.125000>
      }
      triangle {
        <25.000000, 5.016813, 90.312330>,
        <19.000000, 4.966673, 90.125000>,
        < 25.000000, 4.966673, 90.125000>
      }
      triangle {
        <25.617260, 4.816252, 90.312330>,
        <25.382681, 4.890555, 90.125000>,
        < 25.707109, 4.673784, 90.125000>
      }
      triangle {
        <25.324511, 4.965414, 90.312330>,
        <25.000000, 5.016813, 90.312330>,
        < 25.382681, 4.890555, 90.125000>
      }
      triangle {
        <25.617260, 4.816252, 90.312330>,
        <25.324511, 4.965414, 90.312330>,
        < 25.382681, 4.890555, 90.125000>
      }
      triangle {
        <25.849581, 4.583933, 90.312330>,
        <25.707109, 4.673784, 90.125000>,
        < 25.923880, 4.349352, 90.125000>
      }
      triangle {
        <25.849581, 4.583933, 90.312330>,
        <25.617260, 4.816252, 90.312330>,
        < 25.707109, 4.673784, 90.125000>
      }
      triangle {
        <25.998739, 4.291182, 90.312330>,
        <25.849581, 4.583933, 90.312330>,
        < 25.923880, 4.349352, 90.125000>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <18.617319, 4.890555, 90.125000>,
        < 19.000000, 4.966673, 90.125000>
      }
      triangle {
        <19.000000, 5.016813, 90.312330>,
        <19.000000, 4.966673, 90.125000>,
        < 25.000000, 5.016813, 90.312330>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <19.000000, 4.966673, 90.125000>,
        < 19.000000, 5.016813, 90.312330>
      }
      triangle {
        <18.150419, 4.583933, 90.312330>,
        <18.076120, 4.349352, 90.125000>,
        < 18.292891, 4.673784, 90.125000>
      }
      triangle {
        <18.001261, 4.291182, 90.312330>,
        <17.949860, 3.966673, 90.312330>,
        < 18.076120, 4.349352, 90.125000>
      }
      triangle {
        <18.150419, 4.583933, 90.312330>,
        <18.001261, 4.291182, 90.312330>,
        < 18.076120, 4.349352, 90.125000>
      }
      triangle {
        <18.382740, 4.816252, 90.312330>,
        <18.292891, 4.673784, 90.125000>,
        < 18.617319, 4.890555, 90.125000>
      }
      triangle {
        <18.382740, 4.816252, 90.312330>,
        <18.150419, 4.583933, 90.312330>,
        < 18.292891, 4.673784, 90.125000>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <18.382740, 4.816252, 90.312330>,
        < 18.617319, 4.890555, 90.125000>
      }
      triangle {
        <-17.949860, 3.966673, 90.312330>,
        <-17.949860, -2.033327, 90.312330>,
        < -17.812500, -2.033327, 90.449760>
      }
      triangle {
        <-17.852961, -2.340677, 90.449760>,
        <-17.812500, -2.033327, 90.449760>,
        < -17.949860, -2.033327, 90.312330>
      }
      triangle {
        <-17.812500, 3.966673, 90.449760>,
        <-17.949860, 3.966673, 90.312330>,
        < -17.812500, -2.033327, 90.449760>
      }
      triangle {
        <-18.001261, -2.357836, 90.312330>,
        <-17.852961, -2.340677, 90.449760>,
        < -17.949860, -2.033327, 90.312330>
      }
      triangle {
        <-17.870621, 4.333632, 90.449760>,
        <-17.949860, 3.966673, 90.312330>,
        < -17.812500, 3.966673, 90.449760>
      }
      triangle {
        <-18.001261, 4.291182, 90.312330>,
        <-17.949860, 3.966673, 90.312330>,
        < -17.870621, 4.333632, 90.449760>
      }
      triangle {
        <-18.150419, 4.583933, 90.312330>,
        <-17.870621, 4.333632, 90.449760>,
        < -18.039289, 4.664663, 90.449760>
      }
      triangle {
        <-18.001261, 4.291182, 90.312330>,
        <-17.870621, 4.333632, 90.449760>,
        < -18.150419, 4.583933, 90.312330>
      }
      triangle {
        <-18.382740, 4.816252, 90.312330>,
        <-18.039289, 4.664663, 90.449760>,
        < -18.302010, 4.927382, 90.449760>
      }
      triangle {
        <-18.150419, 4.583933, 90.312330>,
        <-18.039289, 4.664663, 90.449760>,
        < -18.382740, 4.816252, 90.312330>
      }
      triangle {
        <-18.675489, 4.965414, 90.312330>,
        <-18.302010, 4.927382, 90.449760>,
        < -18.633039, 5.096052, 90.449760>
      }
      triangle {
        <-18.382740, 4.816252, 90.312330>,
        <-18.302010, 4.927382, 90.449760>,
        < -18.675489, 4.965414, 90.312330>
      }
      triangle {
        <-19.000000, 5.016813, 90.312330>,
        <-18.633039, 5.096052, 90.449760>,
        < -19.000000, 5.154173, 90.449760>
      }
      triangle {
        <-18.675489, 4.965414, 90.312330>,
        <-18.633039, 5.096052, 90.449760>,
        < -19.000000, 5.016813, 90.312330>
      }
      triangle {
        <-25.000000, 5.016813, 90.312330>,
        <-19.000000, 5.016813, 90.312330>,
        < -19.000000, 5.154173, 90.449760>
      }
      triangle {
        <-25.000000, 5.154173, 90.449760>,
        <-25.000000, 5.016813, 90.312330>,
        < -19.000000, 5.154173, 90.449760>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.000000, 5.016813, 90.312330>,
        < -25.000000, 5.154173, 90.449760>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.000000, 5.154173, 90.449760>,
        < -25.366961, 5.096052, 90.449760>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.366961, 5.096052, 90.449760>,
        < -25.697990, 4.927382, 90.449760>
      }
      triangle {
        <-25.617260, 4.816252, 90.312330>,
        <-25.697990, 4.927382, 90.449760>,
        < -25.960711, 4.664663, 90.449760>
      }
      triangle {
        <-25.324511, 4.965414, 90.312330>,
        <-25.697990, 4.927382, 90.449760>,
        < -25.617260, 4.816252, 90.312330>
      }
      triangle {
        <-25.998739, 4.291182, 90.312330>,
        <-25.960711, 4.664663, 90.449760>,
        < -26.129379, 4.333632, 90.449760>
      }
      triangle {
        <-25.849581, 4.583933, 90.312330>,
        <-25.960711, 4.664663, 90.449760>,
        < -25.998739, 4.291182, 90.312330>
      }
      triangle {
        <-25.617260, 4.816252, 90.312330>,
        <-25.960711, 4.664663, 90.449760>,
        < -25.849581, 4.583933, 90.312330>
      }
      triangle {
        <-26.050140, 3.966673, 90.312330>,
        <-26.129379, 4.333632, 90.449760>,
        < -26.187500, 3.966673, 90.449760>
      }
      triangle {
        <-25.998739, 4.291182, 90.312330>,
        <-26.129379, 4.333632, 90.449760>,
        < -26.050140, 3.966673, 90.312330>
      }
      triangle {
        <-26.050140, -2.033327, 90.312330>,
        <-26.050140, 3.966673, 90.312330>,
        < -26.187500, 3.966673, 90.449760>
      }
      triangle {
        <-26.187500, -2.033327, 90.449760>,
        <-26.050140, -2.033327, 90.312330>,
        < -26.187500, 3.966673, 90.449760>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-26.050140, -2.033327, 90.312330>,
        < -26.187500, -2.033327, 90.449760>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-26.187500, -2.033327, 90.449760>,
        < -26.129379, -2.400286, 90.449760>
      }
      triangle {
        <-25.909451, -2.558397, 90.312330>,
        <-26.129379, -2.400286, 90.449760>,
        < -25.960711, -2.731317, 90.449760>
      }
      triangle {
        <-26.014360, -2.305128, 90.312330>,
        <-26.129379, -2.400286, 90.449760>,
        < -25.909451, -2.558397, 90.312330>
      }
      triangle {
        <-25.742559, -2.775888, 90.312330>,
        <-25.960711, -2.731317, 90.449760>,
        < -25.697990, -2.994036, 90.449760>
      }
      triangle {
        <-25.909451, -2.558397, 90.312330>,
        <-25.960711, -2.731317, 90.449760>,
        < -25.742559, -2.775888, 90.312330>
      }
      triangle {
        <-25.525070, -2.942778, 90.312330>,
        <-25.697990, -2.994036, 90.449760>,
        < -25.366961, -3.162706, 90.449760>
      }
      triangle {
        <-25.742559, -2.775888, 90.312330>,
        <-25.697990, -2.994036, 90.449760>,
        < -25.525070, -2.942778, 90.312330>
      }
      triangle {
        <-25.271799, -3.047686, 90.312330>,
        <-25.366961, -3.162706, 90.449760>,
        < -25.000000, -3.220827, 90.449760>
      }
      triangle {
        <-25.525070, -2.942778, 90.312330>,
        <-25.366961, -3.162706, 90.449760>,
        < -25.271799, -3.047686, 90.312330>
      }
      triangle {
        <-25.271799, -3.047686, 90.312330>,
        <-25.000000, -3.220827, 90.449760>,
        < -25.000000, -3.083467, 90.312330>
      }
      triangle {
        <-19.000000, -3.083467, 90.312330>,
        <-25.000000, -3.083467, 90.312330>,
        < -25.000000, -3.220827, 90.449760>
      }
      triangle {
        <-19.000000, -3.220827, 90.449760>,
        <-19.000000, -3.083467, 90.312330>,
        < -25.000000, -3.220827, 90.449760>
      }
      triangle {
        <-18.692650, -3.180368, 90.449760>,
        <-19.000000, -3.083467, 90.312330>,
        < -19.000000, -3.220827, 90.449760>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-19.000000, -3.083467, 90.312330>,
        < -18.692650, -3.180368, 90.449760>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-18.692650, -3.180368, 90.449760>,
        < -18.406250, -3.061739, 90.449760>
      }
      triangle {
        <-18.382740, -2.882906, 90.312330>,
        <-18.406250, -3.061739, 90.449760>,
        < -18.160311, -2.873018, 90.449760>
      }
      triangle {
        <-18.675489, -3.032068, 90.312330>,
        <-18.406250, -3.061739, 90.449760>,
        < -18.382740, -2.882906, 90.312330>
      }
      triangle {
        <-18.150419, -2.650587, 90.312330>,
        <-18.160311, -2.873018, 90.449760>,
        < -17.971590, -2.627077, 90.449760>
      }
      triangle {
        <-18.382740, -2.882906, 90.312330>,
        <-18.160311, -2.873018, 90.449760>,
        < -18.150419, -2.650587, 90.312330>
      }
      triangle {
        <-18.001261, -2.357836, 90.312330>,
        <-17.971590, -2.627077, 90.449760>,
        < -17.852961, -2.340677, 90.449760>
      }
      triangle {
        <-18.150419, -2.650587, 90.312330>,
        <-17.971590, -2.627077, 90.449760>,
        < -18.001261, -2.357836, 90.312330>
      }
      triangle {
        <26.050140, 3.966673, 90.312330>,
        <26.050140, -2.033327, 90.312330>,
        < 26.187500, -2.033327, 90.449760>
      }
      triangle {
        <26.147039, -2.340677, 90.449760>,
        <26.187500, -2.033327, 90.449760>,
        < 26.050140, -2.033327, 90.312330>
      }
      triangle {
        <26.187500, 3.966673, 90.449760>,
        <26.050140, 3.966673, 90.312330>,
        < 26.187500, -2.033327, 90.449760>
      }
      triangle {
        <25.998739, -2.357836, 90.312330>,
        <26.147039, -2.340677, 90.449760>,
        < 26.050140, -2.033327, 90.312330>
      }
      triangle {
        <26.129379, 4.333632, 90.449760>,
        <26.050140, 3.966673, 90.312330>,
        < 26.187500, 3.966673, 90.449760>
      }
      triangle {
        <25.998739, 4.291182, 90.312330>,
        <26.050140, 3.966673, 90.312330>,
        < 26.129379, 4.333632, 90.449760>
      }
      triangle {
        <25.849581, 4.583933, 90.312330>,
        <26.129379, 4.333632, 90.449760>,
        < 25.960711, 4.664663, 90.449760>
      }
      triangle {
        <25.998739, 4.291182, 90.312330>,
        <26.129379, 4.333632, 90.449760>,
        < 25.849581, 4.583933, 90.312330>
      }
      triangle {
        <25.617260, 4.816252, 90.312330>,
        <25.960711, 4.664663, 90.449760>,
        < 25.697990, 4.927382, 90.449760>
      }
      triangle {
        <25.849581, 4.583933, 90.312330>,
        <25.960711, 4.664663, 90.449760>,
        < 25.617260, 4.816252, 90.312330>
      }
      triangle {
        <25.324511, 4.965414, 90.312330>,
        <25.697990, 4.927382, 90.449760>,
        < 25.366961, 5.096052, 90.449760>
      }
      triangle {
        <25.617260, 4.816252, 90.312330>,
        <25.697990, 4.927382, 90.449760>,
        < 25.324511, 4.965414, 90.312330>
      }
      triangle {
        <25.000000, 5.016813, 90.312330>,
        <25.366961, 5.096052, 90.449760>,
        < 25.000000, 5.154173, 90.449760>
      }
      triangle {
        <25.324511, 4.965414, 90.312330>,
        <25.366961, 5.096052, 90.449760>,
        < 25.000000, 5.016813, 90.312330>
      }
      triangle {
        <19.000000, 5.016813, 90.312330>,
        <25.000000, 5.016813, 90.312330>,
        < 25.000000, 5.154173, 90.449760>
      }
      triangle {
        <19.000000, 5.154173, 90.449760>,
        <19.000000, 5.016813, 90.312330>,
        < 25.000000, 5.154173, 90.449760>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <19.000000, 5.016813, 90.312330>,
        < 19.000000, 5.154173, 90.449760>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <19.000000, 5.154173, 90.449760>,
        < 18.633039, 5.096052, 90.449760>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <18.633039, 5.096052, 90.449760>,
        < 18.302010, 4.927382, 90.449760>
      }
      triangle {
        <18.382740, 4.816252, 90.312330>,
        <18.302010, 4.927382, 90.449760>,
        < 18.039289, 4.664663, 90.449760>
      }
      triangle {
        <18.675489, 4.965414, 90.312330>,
        <18.302010, 4.927382, 90.449760>,
        < 18.382740, 4.816252, 90.312330>
      }
      triangle {
        <18.001261, 4.291182, 90.312330>,
        <18.039289, 4.664663, 90.449760>,
        < 17.870621, 4.333632, 90.449760>
      }
      triangle {
        <18.150419, 4.583933, 90.312330>,
        <18.039289, 4.664663, 90.449760>,
        < 18.001261, 4.291182, 90.312330>
      }
      triangle {
        <18.382740, 4.816252, 90.312330>,
        <18.039289, 4.664663, 90.449760>,
        < 18.150419, 4.583933, 90.312330>
      }
      triangle {
        <17.949860, 3.966673, 90.312330>,
        <17.870621, 4.333632, 90.449760>,
        < 17.812500, 3.966673, 90.449760>
      }
      triangle {
        <18.001261, 4.291182, 90.312330>,
        <17.870621, 4.333632, 90.449760>,
        < 17.949860, 3.966673, 90.312330>
      }
      triangle {
        <17.949860, -2.033327, 90.312330>,
        <17.949860, 3.966673, 90.312330>,
        < 17.812500, 3.966673, 90.449760>
      }
      triangle {
        <17.812500, -2.033327, 90.449760>,
        <17.949860, -2.033327, 90.312330>,
        < 17.812500, 3.966673, 90.449760>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <17.949860, -2.033327, 90.312330>,
        < 17.812500, -2.033327, 90.449760>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <17.812500, -2.033327, 90.449760>,
        < 17.870621, -2.400286, 90.449760>
      }
      triangle {
        <18.090549, -2.558397, 90.312330>,
        <17.870621, -2.400286, 90.449760>,
        < 18.039289, -2.731317, 90.449760>
      }
      triangle {
        <17.985640, -2.305128, 90.312330>,
        <17.870621, -2.400286, 90.449760>,
        < 18.090549, -2.558397, 90.312330>
      }
      triangle {
        <18.257441, -2.775888, 90.312330>,
        <18.039289, -2.731317, 90.449760>,
        < 18.302010, -2.994036, 90.449760>
      }
      triangle {
        <18.090549, -2.558397, 90.312330>,
        <18.039289, -2.731317, 90.449760>,
        < 18.257441, -2.775888, 90.312330>
      }
      triangle {
        <18.474930, -2.942778, 90.312330>,
        <18.302010, -2.994036, 90.449760>,
        < 18.633039, -3.162706, 90.449760>
      }
      triangle {
        <18.257441, -2.775888, 90.312330>,
        <18.302010, -2.994036, 90.449760>,
        < 18.474930, -2.942778, 90.312330>
      }
      triangle {
        <18.728201, -3.047686, 90.312330>,
        <18.633039, -3.162706, 90.449760>,
        < 19.000000, -3.220827, 90.449760>
      }
      triangle {
        <18.474930, -2.942778, 90.312330>,
        <18.633039, -3.162706, 90.449760>,
        < 18.728201, -3.047686, 90.312330>
      }
      triangle {
        <18.728201, -3.047686, 90.312330>,
        <19.000000, -3.220827, 90.449760>,
        < 19.000000, -3.083467, 90.312330>
      }
      triangle {
        <25.000000, -3.083467, 90.312330>,
        <19.000000, -3.083467, 90.312330>,
        < 19.000000, -3.220827, 90.449760>
      }
      triangle {
        <25.000000, -3.220827, 90.449760>,
        <25.000000, -3.083467, 90.312330>,
        < 19.000000, -3.220827, 90.449760>
      }
      triangle {
        <25.307350, -3.180368, 90.449760>,
        <25.000000, -3.083467, 90.312330>,
        < 25.000000, -3.220827, 90.449760>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.000000, -3.083467, 90.312330>,
        < 25.307350, -3.180368, 90.449760>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.307350, -3.180368, 90.449760>,
        < 25.593750, -3.061739, 90.449760>
      }
      triangle {
        <25.617260, -2.882906, 90.312330>,
        <25.593750, -3.061739, 90.449760>,
        < 25.839689, -2.873018, 90.449760>
      }
      triangle {
        <25.324511, -3.032068, 90.312330>,
        <25.593750, -3.061739, 90.449760>,
        < 25.617260, -2.882906, 90.312330>
      }
      triangle {
        <25.849581, -2.650587, 90.312330>,
        <25.839689, -2.873018, 90.449760>,
        < 26.028410, -2.627077, 90.449760>
      }
      triangle {
        <25.617260, -2.882906, 90.312330>,
        <25.839689, -2.873018, 90.449760>,
        < 25.849581, -2.650587, 90.312330>
      }
      triangle {
        <25.998739, -2.357836, 90.312330>,
        <26.028410, -2.627077, 90.449760>,
        < 26.147039, -2.340677, 90.449760>
      }
      triangle {
        <25.849581, -2.650587, 90.312330>,
        <26.028410, -2.627077, 90.449760>,
        < 25.998739, -2.357836, 90.312330>
      }
      triangle {
        <-43.500000, 14.066671, -3.125000>,
        <-43.000000, 14.066671, -3.125000>,
        < -43.000000, 7.466673, -3.125000>
      }
      triangle {
        <-43.458599, 15.964113, -3.021896>,
        <-42.959068, 15.942312, -3.021896>,
        < -43.000000, 14.066671, -3.125000>
      }
      triangle {
        <-43.458599, 15.964113, -3.021896>,
        <-43.000000, 14.066671, -3.125000>,
        < -43.500000, 14.066671, -3.125000>
      }
      triangle {
        <-43.500000, 7.466673, -3.125000>,
        <-43.000000, 7.466673, -3.125000>,
        < -43.000000, -11.533327, -3.125000>
      }
      triangle {
        <-43.500000, 14.066671, -3.125000>,
        <-43.000000, 7.466673, -3.125000>,
        < -43.500000, 7.466673, -3.125000>
      }
      triangle {
        <-43.500000, -11.533327, -3.125000>,
        <-43.000000, -11.533327, -3.125000>,
        < -43.000000, -12.032938, -2.991249>
      }
      triangle {
        <-43.500000, -11.533327, -3.125000>,
        <-43.500000, 7.466673, -3.125000>,
        < -43.000000, -11.533327, -3.125000>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.000000, -12.032938, -2.991249>,
        < -43.000000, -12.399576, -2.624611>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.500000, -11.533327, -3.125000>,
        < -43.000000, -12.032938, -2.991249>
      }
      triangle {
        <-43.500000, -12.399576, -2.624611>,
        <-43.000000, -12.399576, -2.624611>,
        < -43.000000, -12.533327, -2.125000>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.000000, -12.399576, -2.624611>,
        < -43.500000, -12.399576, -2.624611>
      }
      triangle {
        <-43.500000, -12.533327, -2.125000>,
        <-43.000000, -12.533327, -2.125000>,
        < -43.000000, -12.533327, 30.625000>
      }
      triangle {
        <-43.500000, -12.399576, -2.624611>,
        <-43.000000, -12.533327, -2.125000>,
        < -43.500000, -12.533327, -2.125000>
      }
      triangle {
        <-43.500000, -12.533327, 30.625000>,
        <-43.000000, -12.533327, 30.625000>,
        < -43.000000, -12.399576, 31.124611>
      }
      triangle {
        <-43.500000, -12.533327, 30.625000>,
        <-43.500000, -12.533327, -2.125000>,
        < -43.000000, -12.533327, 30.625000>
      }
      triangle {
        <-43.500000, -12.399576, 31.124611>,
        <-43.000000, -12.399576, 31.124611>,
        < -43.000000, -12.032938, 31.491249>
      }
      triangle {
        <-43.500000, -12.399576, 31.124611>,
        <-43.500000, -12.533327, 30.625000>,
        < -43.000000, -12.399576, 31.124611>
      }
      triangle {
        <-43.500000, -12.032938, 31.491249>,
        <-43.000000, -12.032938, 31.491249>,
        < -43.000000, -11.533327, 31.625000>
      }
      triangle {
        <-43.500000, -12.399576, 31.124611>,
        <-43.000000, -12.032938, 31.491249>,
        < -43.500000, -12.032938, 31.491249>
      }
      triangle {
        <-43.500000, -11.533327, 31.625000>,
        <-43.000000, -11.533327, 31.625000>,
        < -43.000000, 14.066671, 31.625000>
      }
      triangle {
        <-43.500000, -12.032938, 31.491249>,
        <-43.000000, -11.533327, 31.625000>,
        < -43.500000, -11.533327, 31.625000>
      }
      triangle {
        <-43.500000, 14.066671, 31.625000>,
        <-43.000000, 14.066671, 31.625000>,
        < -42.959068, 15.942312, 31.521900>
      }
      triangle {
        <-43.500000, 14.066671, 31.625000>,
        <-43.500000, -11.533327, 31.625000>,
        < -43.000000, 14.066671, 31.625000>
      }
      triangle {
        <-43.334469, 17.857943, -2.918999>,
        <-42.836369, 17.814371, -2.918999>,
        < -42.959068, 15.942312, -3.021896>
      }
      triangle {
        <-42.153099, 31.361044, -2.176758>,
        <-41.654999, 31.317465, -2.176758>,
        < -42.836369, 17.814371, -2.918999>
      }
      triangle {
        <-42.153099, 31.361044, -2.176758>,
        <-42.836369, 17.814371, -2.918999>,
        < -43.334469, 17.857943, -2.918999>
      }
      triangle {
        <-43.458599, 15.964113, -3.021896>,
        <-43.334469, 17.857943, -2.918999>,
        < -42.959068, 15.942312, -3.021896>
      }
      triangle {
        <-43.458599, 15.964113, 31.521900>,
        <-42.959068, 15.942312, 31.521900>,
        < -42.836369, 17.814371, 31.418999>
      }
      triangle {
        <-43.458599, 15.964113, 31.521900>,
        <-43.500000, 14.066671, 31.625000>,
        < -42.959068, 15.942312, 31.521900>
      }
      triangle {
        <-43.334469, 17.857943, 31.418999>,
        <-42.836369, 17.814371, 31.418999>,
        < -41.654999, 31.317465, 30.676762>
      }
      triangle {
        <-43.334469, 17.857943, 31.418999>,
        <-43.458599, 15.964113, 31.521900>,
        < -42.836369, 17.814371, 31.418999>
      }
      triangle {
        <-42.153099, 31.361044, 30.676762>,
        <-41.654999, 31.317465, 30.676762>,
        < -41.613499, 31.791884, 30.525688>
      }
      triangle {
        <-42.153099, 31.361044, 30.676762>,
        <-43.334469, 17.857943, 31.418999>,
        < -41.654999, 31.317465, 30.676762>
      }
      triangle {
        <-42.111599, 31.835463, 30.525688>,
        <-41.613499, 31.791884, 30.525688>,
        < -41.583488, 32.134855, 30.162041>
      }
      triangle {
        <-42.111599, 31.835463, 30.525688>,
        <-42.153099, 31.361044, 30.676762>,
        < -41.613499, 31.791884, 30.525688>
      }
      triangle {
        <-42.081589, 32.178434, 30.162041>,
        <-41.583488, 32.134855, 30.162041>,
        < -41.572609, 32.259192, 29.678261>
      }
      triangle {
        <-42.111599, 31.835463, 30.525688>,
        <-41.583488, 32.134855, 30.162041>,
        < -42.081589, 32.178434, 30.162041>
      }
      triangle {
        <-42.070709, 32.302771, 29.678261>,
        <-41.572609, 32.259192, 29.678261>,
        < -41.572609, 32.259192, -1.178261>
      }
      triangle {
        <-42.081589, 32.178434, 30.162041>,
        <-41.572609, 32.259192, 29.678261>,
        < -42.070709, 32.302771, 29.678261>
      }
      triangle {
        <-42.070709, 32.302771, -1.178261>,
        <-41.572609, 32.259192, -1.178261>,
        < -41.583488, 32.134855, -1.662041>
      }
      triangle {
        <-42.070709, 32.302771, -1.178261>,
        <-42.070709, 32.302771, 29.678261>,
        < -41.572609, 32.259192, -1.178261>
      }
      triangle {
        <-42.111599, 31.835463, -2.025688>,
        <-41.583488, 32.134855, -1.662041>,
        < -41.613499, 31.791884, -2.025688>
      }
      triangle {
        <-42.081589, 32.178434, -1.662041>,
        <-42.070709, 32.302771, -1.178261>,
        < -41.583488, 32.134855, -1.662041>
      }
      triangle {
        <-42.081589, 32.178434, -1.662041>,
        <-41.583488, 32.134855, -1.662041>,
        < -42.111599, 31.835463, -2.025688>
      }
      triangle {
        <-42.111599, 31.835463, -2.025688>,
        <-41.613499, 31.791884, -2.025688>,
        < -41.654999, 31.317465, -2.176758>
      }
      triangle {
        <-42.111599, 31.835463, -2.025688>,
        <-41.654999, 31.317465, -2.176758>,
        < -42.153099, 31.361044, -2.176758>
      }
      triangle {
        <-43.750000, 25.966673, 4.625000>,
        <-43.250000, 25.966673, 4.625000>,
        < -43.250000, 25.966673, 24.625000>
      }
      triangle {
        <-43.750000, 11.966673, 4.625000>,
        <-43.250000, 11.966673, 4.625000>,
        < -43.250000, 25.966673, 4.625000>
      }
      triangle {
        <-43.750000, 11.966673, 4.625000>,
        <-43.250000, 25.966673, 4.625000>,
        < -43.750000, 25.966673, 4.625000>
      }
      triangle {
        <-43.750000, 25.966673, 24.625000>,
        <-43.250000, 25.966673, 24.625000>,
        < -43.250000, 11.966673, 24.625000>
      }
      triangle {
        <-43.750000, 25.966673, 24.625000>,
        <-43.750000, 25.966673, 4.625000>,
        < -43.250000, 25.966673, 24.625000>
      }
      triangle {
        <-43.750000, 11.966673, 24.625000>,
        <-43.250000, 11.966673, 24.625000>,
        < -43.250000, 11.966673, 4.625000>
      }
      triangle {
        <-43.750000, 11.966673, 24.625000>,
        <-43.750000, 25.966673, 24.625000>,
        < -43.250000, 11.966673, 24.625000>
      }
      triangle {
        <-43.750000, 11.966673, 24.625000>,
        <-43.250000, 11.966673, 4.625000>,
        < -43.750000, 11.966673, 4.625000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, -11.533327, 31.625000>,
        < -43.500000, 14.066671, 31.625000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, -12.032938, 31.491249>,
        < -43.500000, -11.533327, 31.625000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, 14.066671, 31.625000>,
        < -43.458599, 15.964113, 31.521900>
      }
      triangle {
        <-43.500000, 9.466673, 2.125000>,
        <-43.500000, -12.533327, -2.125000>,
        < -43.500000, -12.533327, 30.625000>
      }
      triangle {
        <-43.500000, -12.399576, -2.624611>,
        <-43.500000, -12.533327, -2.125000>,
        < -43.500000, 14.066671, -3.125000>
      }
      triangle {
        <-43.500000, 9.466673, 2.125000>,
        <-43.500000, 14.066671, -3.125000>,
        < -43.500000, -12.533327, -2.125000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, -12.533327, 30.625000>,
        < -43.500000, -12.399576, 31.124611>
      }
      triangle {
        <-43.500000, 9.466673, 27.125000>,
        <-43.500000, 9.466673, 2.125000>,
        < -43.500000, -12.533327, 30.625000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, 9.466673, 27.125000>,
        < -43.500000, -12.533327, 30.625000>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.500000, 7.466673, -3.125000>,
        < -43.500000, -11.533327, -3.125000>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.500000, 14.066671, -3.125000>,
        < -43.500000, 7.466673, -3.125000>
      }
      triangle {
        <-43.458599, 15.964113, 2.125000>,
        <-43.458599, 15.964113, -3.021896>,
        < -43.500000, 14.066671, -3.125000>
      }
      triangle {
        <-43.500000, -12.032938, -2.991249>,
        <-43.500000, -12.399576, -2.624611>,
        < -43.500000, 14.066671, -3.125000>
      }
      triangle {
        <-43.500000, 9.466673, 2.125000>,
        <-43.500000, 14.066671, 2.125000>,
        < -43.500000, 14.066671, -3.125000>
      }
      triangle {
        <-43.458599, 15.964113, 2.125000>,
        <-43.500000, 14.066671, -3.125000>,
        < -43.500000, 14.066671, 2.125000>
      }
      triangle {
        <-43.334469, 17.857943, 2.125000>,
        <-43.334469, 17.857943, -2.918999>,
        < -43.458599, 15.964113, -3.021896>
      }
      triangle {
        <-43.334469, 17.857943, 2.125000>,
        <-42.153099, 31.361044, -2.176758>,
        < -43.334469, 17.857943, -2.918999>
      }
      triangle {
        <-43.458599, 15.964113, 2.125000>,
        <-43.334469, 17.857943, 2.125000>,
        < -43.458599, 15.964113, -3.021896>
      }
      triangle {
        <-43.458599, 15.964113, 27.125000>,
        <-43.458599, 15.964113, 31.521900>,
        < -43.334469, 17.857943, 31.418999>
      }
      triangle {
        <-43.458599, 15.964113, 27.125000>,
        <-43.500000, 14.066671, 27.125000>,
        < -43.458599, 15.964113, 31.521900>
      }
      triangle {
        <-42.081589, 32.178434, 30.162041>,
        <-42.070709, 32.302771, 29.678261>,
        < -43.334469, 17.857943, 31.418999>
      }
      triangle {
        <-42.406330, 28.466673, 27.125000>,
        <-43.334469, 17.857943, 31.418999>,
        < -42.070709, 32.302771, 29.678261>
      }
      triangle {
        <-42.111599, 31.835463, 30.525688>,
        <-43.334469, 17.857943, 31.418999>,
        < -42.153099, 31.361044, 30.676762>
      }
      triangle {
        <-43.334469, 17.857943, 27.125000>,
        <-43.458599, 15.964113, 27.125000>,
        < -43.334469, 17.857943, 31.418999>
      }
      triangle {
        <-42.406330, 28.466673, 27.125000>,
        <-43.334469, 17.857943, 27.125000>,
        < -43.334469, 17.857943, 31.418999>
      }
      triangle {
        <-42.111599, 31.835463, 30.525688>,
        <-42.081589, 32.178434, 30.162041>,
        < -43.334469, 17.857943, 31.418999>
      }
      triangle {
        <-42.111599, 31.835463, -2.025688>,
        <-42.153099, 31.361044, -2.176758>,
        < -43.334469, 17.857943, 2.125000>
      }
      triangle {
        <-42.406330, 28.466673, 27.125000>,
        <-42.070709, 32.302771, 29.678261>,
        < -42.070709, 32.302771, -1.178261>
      }
      triangle {
        <-42.081589, 32.178434, -1.662041>,
        <-43.334469, 17.857943, 2.125000>,
        < -42.070709, 32.302771, -1.178261>
      }
      triangle {
        <-42.406330, 28.466673, 2.125000>,
        <-42.070709, 32.302771, -1.178261>,
        < -43.334469, 17.857943, 2.125000>
      }
      triangle {
        <-42.406330, 28.466673, 2.125000>,
        <-42.406330, 28.466673, 27.125000>,
        < -42.070709, 32.302771, -1.178261>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-43.750000, 25.966673, 4.625000>,
        < -43.750000, 25.966673, 24.625000>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-43.750000, 11.966673, 4.625000>,
        < -43.750000, 25.966673, 4.625000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.750000, 25.966673, 24.625000>,
        < -43.750000, 11.966673, 24.625000>
      }
      triangle {
        <-43.750000, 28.466673, 27.125000>,
        <-43.750000, 28.466673, 2.125000>,
        < -43.750000, 25.966673, 24.625000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.750000, 28.466673, 27.125000>,
        < -43.750000, 25.966673, 24.625000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.750000, 11.966673, 24.625000>,
        < -43.750000, 11.966673, 4.625000>
      }
      triangle {
        <-43.750000, 9.466673, 2.125000>,
        <-43.750000, 11.966673, 4.625000>,
        < -43.750000, 28.466673, 2.125000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.750000, 11.966673, 4.625000>,
        < -43.750000, 9.466673, 2.125000>
      }
      triangle {
        <-43.500000, 14.066671, 27.125000>,
        <-43.500000, -12.399576, 31.124611>,
        < -43.500000, -12.032938, 31.491249>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-43.500000, 14.066671, 2.125000>,
        < -43.500000, 9.466673, 2.125000>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-43.458599, 15.964113, 2.125000>,
        < -43.500000, 14.066671, 2.125000>
      }
      triangle {
        <-43.750000, 9.466673, 2.125000>,
        <-43.500000, 9.466673, 2.125000>,
        < -43.500000, 9.466673, 27.125000>
      }
      triangle {
        <-43.750000, 9.466673, 2.125000>,
        <-43.750000, 28.466673, 2.125000>,
        < -43.500000, 9.466673, 2.125000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.500000, 9.466673, 27.125000>,
        < -43.500000, 14.066671, 27.125000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.750000, 9.466673, 2.125000>,
        < -43.500000, 9.466673, 27.125000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.500000, 14.066671, 27.125000>,
        < -43.458599, 15.964113, 27.125000>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-43.334469, 17.857943, 2.125000>,
        < -43.458599, 15.964113, 2.125000>
      }
      triangle {
        <-42.081589, 32.178434, -1.662041>,
        <-42.111599, 31.835463, -2.025688>,
        < -43.334469, 17.857943, 2.125000>
      }
      triangle {
        <-43.750000, 28.466673, 2.125000>,
        <-42.406330, 28.466673, 2.125000>,
        < -43.334469, 17.857943, 2.125000>
      }
      triangle {
        <-43.750000, 28.466673, 27.125000>,
        <-43.458599, 15.964113, 27.125000>,
        < -43.334469, 17.857943, 27.125000>
      }
      triangle {
        <-43.750000, 9.466673, 27.125000>,
        <-43.458599, 15.964113, 27.125000>,
        < -43.750000, 28.466673, 27.125000>
      }
      triangle {
        <-43.750000, 28.466673, 27.125000>,
        <-43.334469, 17.857943, 27.125000>,
        < -42.406330, 28.466673, 27.125000>
      }
      triangle {
        <-43.750000, 28.466673, 27.125000>,
        <-42.406330, 28.466673, 27.125000>,
        < -42.406330, 28.466673, 2.125000>
      }
      triangle {
        <-43.750000, 28.466673, 27.125000>,
        <-42.406330, 28.466673, 2.125000>,
        < -43.750000, 28.466673, 2.125000>
      }
      triangle {
        <-43.500000, 14.066671, -39.727493>,
        <-43.000000, 14.066671, -39.727493>,
        < -43.000000, 10.466673, -41.875000>
      }
      triangle {
        <-43.458591, 15.964354, -38.608505>,
        <-42.959061, 15.942541, -38.608505>,
        < -43.000000, 14.066671, -39.727493>
      }
      triangle {
        <-43.458591, 15.964354, -38.608505>,
        <-43.000000, 14.066671, -39.727493>,
        < -43.500000, 14.066671, -39.727493>
      }
      triangle {
        <-43.500000, 10.466673, -41.875000>,
        <-43.000000, 10.466673, -41.875000>,
        < -43.000000, -10.827698, -31.690697>
      }
      triangle {
        <-43.500000, 14.066671, -39.727493>,
        <-43.000000, 10.466673, -41.875000>,
        < -43.500000, 10.466673, -41.875000>
      }
      triangle {
        <-43.500000, -10.827698, -31.690697>,
        <-43.000000, -10.827698, -31.690697>,
        < -43.000000, -11.729677, -31.027901>
      }
      triangle {
        <-43.500000, -10.827698, -31.690697>,
        <-43.500000, 10.466673, -41.875000>,
        < -43.000000, -10.827698, -31.690697>
      }
      triangle {
        <-43.500000, -11.729677, -31.027901>,
        <-43.000000, -11.729677, -31.027901>,
        < -43.000000, -12.324497, -30.084000>
      }
      triangle {
        <-43.500000, -11.729677, -31.027901>,
        <-43.500000, -10.827698, -31.690697>,
        < -43.000000, -11.729677, -31.027901>
      }
      triangle {
        <-43.500000, -12.324497, -30.084000>,
        <-43.000000, -12.324497, -30.084000>,
        < -43.000000, -12.533327, -28.984299>
      }
      triangle {
        <-43.500000, -11.729677, -31.027901>,
        <-43.000000, -12.324497, -30.084000>,
        < -43.500000, -12.324497, -30.084000>
      }
      triangle {
        <-43.500000, -12.533327, -28.984299>,
        <-43.000000, -12.533327, -28.984299>,
        < -43.000000, -12.533327, -4.875000>
      }
      triangle {
        <-43.500000, -12.324497, -30.084000>,
        <-43.000000, -12.533327, -28.984299>,
        < -43.500000, -12.533327, -28.984299>
      }
      triangle {
        <-43.500000, -12.533327, -4.875000>,
        <-43.000000, -12.533327, -4.875000>,
        < -43.000000, -12.399567, -4.375381>
      }
      triangle {
        <-43.500000, -12.533327, -4.875000>,
        <-43.500000, -12.533327, -28.984299>,
        < -43.000000, -12.533327, -4.875000>
      }
      triangle {
        <-43.500000, -12.399567, -4.375381>,
        <-43.000000, -12.399567, -4.375381>,
        < -43.000000, -12.032947, -4.008759>
      }
      triangle {
        <-43.500000, -12.399567, -4.375381>,
        <-43.500000, -12.533327, -4.875000>,
        < -43.000000, -12.399567, -4.375381>
      }
      triangle {
        <-43.500000, -12.032947, -4.008759>,
        <-43.000000, -12.032947, -4.008759>,
        < -43.000000, -11.533327, -3.875000>
      }
      triangle {
        <-43.500000, -12.399567, -4.375381>,
        <-43.000000, -12.032947, -4.008759>,
        < -43.500000, -12.032947, -4.008759>
      }
      triangle {
        <-43.500000, -11.533327, -3.875000>,
        <-43.000000, -11.533327, -3.875000>,
        < -43.000000, 14.066671, -3.875000>
      }
      triangle {
        <-43.500000, -12.032947, -4.008759>,
        <-43.000000, -11.533327, -3.875000>,
        < -43.500000, -11.533327, -3.875000>
      }
      triangle {
        <-43.500000, 14.066671, -3.875000>,
        <-43.000000, 14.066671, -3.875000>,
        < -42.959068, 15.942312, -3.978104>
      }
      triangle {
        <-43.500000, 14.066671, -3.875000>,
        <-43.500000, -11.533327, -3.875000>,
        < -43.000000, 14.066671, -3.875000>
      }
      triangle {
        <-43.334469, 17.857943, -37.491798>,
        <-42.836369, 17.814371, -37.491798>,
        < -42.959061, 15.942541, -38.608505>
      }
      triangle {
        <-42.198601, 30.840956, -29.747002>,
        <-41.700508, 30.797377, -29.747002>,
        < -42.836369, 17.814371, -37.491798>
      }
      triangle {
        <-42.198601, 30.840956, -29.747002>,
        <-42.836369, 17.814371, -37.491798>,
        < -43.334469, 17.857943, -37.491798>
      }
      triangle {
        <-43.458591, 15.964354, -38.608505>,
        <-43.334469, 17.857943, -37.491798>,
        < -42.959061, 15.942541, -38.608505>
      }
      triangle {
        <-43.458599, 15.964113, -3.978104>,
        <-42.959068, 15.942312, -3.978104>,
        < -42.836369, 17.814371, -4.081001>
      }
      triangle {
        <-43.458599, 15.964113, -3.978104>,
        <-43.500000, 14.066671, -3.875000>,
        < -42.959068, 15.942312, -3.978104>
      }
      triangle {
        <-42.153099, 31.361044, -4.823242>,
        <-42.836369, 17.814371, -4.081001>,
        < -41.654999, 31.317465, -4.823242>
      }
      triangle {
        <-43.334469, 17.857943, -4.081001>,
        <-43.458599, 15.964113, -3.978104>,
        < -42.836369, 17.814371, -4.081001>
      }
      triangle {
        <-42.153099, 31.361044, -4.823242>,
        <-43.334469, 17.857943, -4.081001>,
        < -42.836369, 17.814371, -4.081001>
      }
      triangle {
        <-42.153099, 31.361044, -4.823242>,
        <-41.654999, 31.317465, -4.823242>,
        < -41.613499, 31.791884, -4.974312>
      }
      triangle {
        <-42.111599, 31.835463, -4.974312>,
        <-41.613499, 31.791884, -4.974312>,
        < -41.583488, 32.134855, -5.337959>
      }
      triangle {
        <-42.111599, 31.835463, -4.974312>,
        <-42.153099, 31.361044, -4.823242>,
        < -41.613499, 31.791884, -4.974312>
      }
      triangle {
        <-42.081589, 32.178434, -5.337959>,
        <-41.583488, 32.134855, -5.337959>,
        < -41.572609, 32.259192, -5.821739>
      }
      triangle {
        <-42.111599, 31.835463, -4.974312>,
        <-41.583488, 32.134855, -5.337959>,
        < -42.081589, 32.178434, -5.337959>
      }
      triangle {
        <-42.070709, 32.302771, -5.821739>,
        <-41.572609, 32.259192, -5.821739>,
        < -41.572609, 32.259192, -27.167999>
      }
      triangle {
        <-42.081589, 32.178434, -5.337959>,
        <-41.572609, 32.259192, -5.821739>,
        < -42.070709, 32.302771, -5.821739>
      }
      triangle {
        <-42.070709, 32.302771, -27.167999>,
        <-41.572609, 32.259192, -27.167999>,
        < -41.587898, 32.084463, -28.178802>
      }
      triangle {
        <-42.070709, 32.302771, -27.167999>,
        <-42.070709, 32.302771, -5.821739>,
        < -41.572609, 32.259192, -27.167999>
      }
      triangle {
        <-42.130680, 31.617293, -29.079903>,
        <-41.587898, 32.084463, -28.178802>,
        < -41.632591, 31.573713, -29.079903>
      }
      triangle {
        <-42.085999, 32.128035, -28.178802>,
        <-42.070709, 32.302771, -27.167999>,
        < -41.587898, 32.084463, -28.178802>
      }
      triangle {
        <-42.085999, 32.128035, -28.178802>,
        <-41.587898, 32.084463, -28.178802>,
        < -42.130680, 31.617293, -29.079903>
      }
      triangle {
        <-42.198601, 30.840956, -29.747002>,
        <-41.632591, 31.573713, -29.079903>,
        < -41.700508, 30.797377, -29.747002>
      }
      triangle {
        <-42.130680, 31.617293, -29.079903>,
        <-41.632591, 31.573713, -29.079903>,
        < -42.198601, 30.840956, -29.747002>
      }
      triangle {
        <-43.750000, 25.966673, -25.875000>,
        <-43.250000, 25.966673, -25.875000>,
        < -43.250000, 25.966673, -9.875000>
      }
      triangle {
        <-43.750000, 11.966673, -25.875000>,
        <-43.250000, 11.966673, -25.875000>,
        < -43.250000, 25.966673, -25.875000>
      }
      triangle {
        <-43.750000, 11.966673, -25.875000>,
        <-43.250000, 25.966673, -25.875000>,
        < -43.750000, 25.966673, -25.875000>
      }
      triangle {
        <-43.750000, 25.966673, -9.875000>,
        <-43.250000, 25.966673, -9.875000>,
        < -43.250000, 11.966673, -9.875000>
      }
      triangle {
        <-43.750000, 25.966673, -9.875000>,
        <-43.750000, 25.966673, -25.875000>,
        < -43.250000, 25.966673, -9.875000>
      }
      triangle {
        <-43.750000, 11.966673, -9.875000>,
        <-43.250000, 11.966673, -9.875000>,
        < -43.250000, 11.966673, -25.875000>
      }
      triangle {
        <-43.750000, 11.966673, -9.875000>,
        <-43.750000, 25.966673, -9.875000>,
        < -43.250000, 11.966673, -9.875000>
      }
      triangle {
        <-43.750000, 11.966673, -9.875000>,
        <-43.250000, 11.966673, -25.875000>,
        < -43.750000, 11.966673, -25.875000>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, -11.533327, -3.875000>,
        < -43.500000, 14.066671, -3.875000>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, -12.032947, -4.008759>,
        < -43.500000, -11.533327, -3.875000>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, 14.066671, -3.875000>,
        < -43.458599, 15.964113, -3.978104>
      }
      triangle {
        <-43.500000, 9.466673, -28.375000>,
        <-43.500000, -12.533327, -28.984299>,
        < -43.500000, -12.533327, -4.875000>
      }
      triangle {
        <-43.500000, -12.324497, -30.084000>,
        <-43.500000, -12.533327, -28.984299>,
        < -43.500000, 14.066671, -39.727493>
      }
      triangle {
        <-43.500000, 9.466673, -28.375000>,
        <-43.500000, 14.066671, -39.727493>,
        < -43.500000, -12.533327, -28.984299>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, -12.533327, -4.875000>,
        < -43.500000, -12.399567, -4.375381>
      }
      triangle {
        <-43.500000, 9.466673, -7.375000>,
        <-43.500000, 9.466673, -28.375000>,
        < -43.500000, -12.533327, -4.875000>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, 9.466673, -7.375000>,
        < -43.500000, -12.533327, -4.875000>
      }
      triangle {
        <-43.500000, 14.066671, -39.727493>,
        <-43.500000, 10.466673, -41.875000>,
        < -43.500000, -10.827698, -31.690697>
      }
      triangle {
        <-43.500000, -11.729677, -31.027901>,
        <-43.500000, 14.066671, -39.727493>,
        < -43.500000, -10.827698, -31.690697>
      }
      triangle {
        <-43.458599, 15.964113, -28.375000>,
        <-43.458591, 15.964354, -38.608505>,
        < -43.500000, 14.066671, -39.727493>
      }
      triangle {
        <-43.500000, -11.729677, -31.027901>,
        <-43.500000, -12.324497, -30.084000>,
        < -43.500000, 14.066671, -39.727493>
      }
      triangle {
        <-43.500000, 9.466673, -28.375000>,
        <-43.500000, 14.066671, -28.375000>,
        < -43.500000, 14.066671, -39.727493>
      }
      triangle {
        <-43.458599, 15.964113, -28.375000>,
        <-43.500000, 14.066671, -39.727493>,
        < -43.500000, 14.066671, -28.375000>
      }
      triangle {
        <-43.334469, 17.857943, -28.375000>,
        <-43.334469, 17.857943, -37.491798>,
        < -43.458591, 15.964354, -38.608505>
      }
      triangle {
        <-43.334469, 17.857943, -28.375000>,
        <-42.198601, 30.840956, -29.747002>,
        < -43.334469, 17.857943, -37.491798>
      }
      triangle {
        <-43.458599, 15.964113, -28.375000>,
        <-43.334469, 17.857943, -28.375000>,
        < -43.458591, 15.964354, -38.608505>
      }
      triangle {
        <-43.458599, 15.964113, -7.375000>,
        <-43.458599, 15.964113, -3.978104>,
        < -43.334469, 17.857943, -4.081001>
      }
      triangle {
        <-43.458599, 15.964113, -7.375000>,
        <-43.500000, 14.066671, -7.375000>,
        < -43.458599, 15.964113, -3.978104>
      }
      triangle {
        <-42.081589, 32.178434, -5.337959>,
        <-42.070709, 32.302771, -5.821739>,
        < -43.334469, 17.857943, -4.081001>
      }
      triangle {
        <-42.406330, 28.466673, -7.375000>,
        <-43.334469, 17.857943, -4.081001>,
        < -42.070709, 32.302771, -5.821739>
      }
      triangle {
        <-42.111599, 31.835463, -4.974312>,
        <-43.334469, 17.857943, -4.081001>,
        < -42.153099, 31.361044, -4.823242>
      }
      triangle {
        <-43.334469, 17.857943, -7.375000>,
        <-43.458599, 15.964113, -7.375000>,
        < -43.334469, 17.857943, -4.081001>
      }
      triangle {
        <-42.406330, 28.466673, -7.375000>,
        <-43.334469, 17.857943, -7.375000>,
        < -43.334469, 17.857943, -4.081001>
      }
      triangle {
        <-42.111599, 31.835463, -4.974312>,
        <-42.081589, 32.178434, -5.337959>,
        < -43.334469, 17.857943, -4.081001>
      }
      triangle {
        <-42.130680, 31.617293, -29.079903>,
        <-42.198601, 30.840956, -29.747002>,
        < -43.334469, 17.857943, -28.375000>
      }
      triangle {
        <-42.406330, 28.466673, -7.375000>,
        <-42.070709, 32.302771, -5.821739>,
        < -42.070709, 32.302771, -27.167999>
      }
      triangle {
        <-42.406330, 28.466673, -7.375000>,
        <-42.070709, 32.302771, -27.167999>,
        < -42.085999, 32.128035, -28.178802>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-43.750000, 25.966673, -25.875000>,
        < -43.750000, 25.966673, -9.875000>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-43.750000, 11.966673, -25.875000>,
        < -43.750000, 25.966673, -25.875000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.750000, 25.966673, -9.875000>,
        < -43.750000, 11.966673, -9.875000>
      }
      triangle {
        <-43.750000, 28.466673, -7.375000>,
        <-43.750000, 28.466673, -28.375000>,
        < -43.750000, 25.966673, -9.875000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.750000, 28.466673, -7.375000>,
        < -43.750000, 25.966673, -9.875000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.750000, 11.966673, -9.875000>,
        < -43.750000, 11.966673, -25.875000>
      }
      triangle {
        <-43.750000, 9.466673, -28.375000>,
        <-43.750000, 11.966673, -25.875000>,
        < -43.750000, 28.466673, -28.375000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.750000, 11.966673, -25.875000>,
        < -43.750000, 9.466673, -28.375000>
      }
      triangle {
        <-43.500000, 14.066671, -7.375000>,
        <-43.500000, -12.399567, -4.375381>,
        < -43.500000, -12.032947, -4.008759>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-43.500000, 14.066671, -28.375000>,
        < -43.500000, 9.466673, -28.375000>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-43.458599, 15.964113, -28.375000>,
        < -43.500000, 14.066671, -28.375000>
      }
      triangle {
        <-43.750000, 9.466673, -28.375000>,
        <-43.500000, 9.466673, -28.375000>,
        < -43.500000, 9.466673, -7.375000>
      }
      triangle {
        <-43.750000, 9.466673, -28.375000>,
        <-43.750000, 28.466673, -28.375000>,
        < -43.500000, 9.466673, -28.375000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.500000, 9.466673, -7.375000>,
        < -43.500000, 14.066671, -7.375000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.750000, 9.466673, -28.375000>,
        < -43.500000, 9.466673, -7.375000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.500000, 14.066671, -7.375000>,
        < -43.458599, 15.964113, -7.375000>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-43.334469, 17.857943, -28.375000>,
        < -43.458599, 15.964113, -28.375000>
      }
      triangle {
        <-42.406330, 28.466673, -28.375000>,
        <-42.130680, 31.617293, -29.079903>,
        < -43.334469, 17.857943, -28.375000>
      }
      triangle {
        <-43.750000, 28.466673, -28.375000>,
        <-42.406330, 28.466673, -28.375000>,
        < -43.334469, 17.857943, -28.375000>
      }
      triangle {
        <-43.750000, 28.466673, -7.375000>,
        <-43.458599, 15.964113, -7.375000>,
        < -43.334469, 17.857943, -7.375000>
      }
      triangle {
        <-43.750000, 9.466673, -7.375000>,
        <-43.458599, 15.964113, -7.375000>,
        < -43.750000, 28.466673, -7.375000>
      }
      triangle {
        <-43.750000, 28.466673, -7.375000>,
        <-43.334469, 17.857943, -7.375000>,
        < -42.406330, 28.466673, -7.375000>
      }
      triangle {
        <-42.406330, 28.466673, -28.375000>,
        <-42.085999, 32.128035, -28.178802>,
        < -42.130680, 31.617293, -29.079903>
      }
      triangle {
        <-42.406330, 28.466673, -28.375000>,
        <-42.406330, 28.466673, -7.375000>,
        < -42.085999, 32.128035, -28.178802>
      }
      triangle {
        <-43.750000, 28.466673, -7.375000>,
        <-42.406330, 28.466673, -7.375000>,
        < -42.406330, 28.466673, -28.375000>
      }
      triangle {
        <-43.750000, 28.466673, -7.375000>,
        <-42.406330, 28.466673, -28.375000>,
        < -43.750000, 28.466673, -28.375000>
      }
      triangle {
        <-42.573078, 19.292593, -84.637100>,
        <-42.836369, 17.814371, -85.084198>,
        < -42.771210, 18.559141, -84.164307>
      }
      triangle {
        <-42.646999, 18.421091, -85.725006>,
        <-42.924881, 16.607233, -86.184097>,
        < -42.836369, 17.814371, -85.084198>
      }
      triangle {
        <-42.573078, 19.292593, -84.637100>,
        <-42.646999, 18.421091, -85.725006>,
        < -42.836369, 17.814371, -85.084198>
      }
      triangle {
        <-42.522751, 19.885874, -83.376099>,
        <-42.771210, 18.559141, -84.164307>,
        < -42.726780, 19.067064, -83.094604>
      }
      triangle {
        <-42.522751, 19.885874, -83.376099>,
        <-42.573078, 19.292593, -84.637100>,
        < -42.771210, 18.559141, -84.164307>
      }
      triangle {
        <-41.443539, 32.221266, -46.716095>,
        <-42.726780, 19.067064, -83.094604>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-41.443539, 32.221266, -46.716095>,
        <-42.522751, 19.885874, -83.376099>,
        < -42.726780, 19.067064, -83.094604>
      }
      triangle {
        <-41.302502, 32.839720, 30.500000>,
        <-41.647572, 31.402456, -46.434601>,
        < -41.647572, 31.402456, -25.738503>
      }
      triangle {
        <-41.302502, 32.839720, 30.500000>,
        <-41.475101, 32.337179, -45.076508>,
        < -41.647572, 31.402456, -46.434601>
      }
      triangle {
        <-41.443539, 32.221266, -46.716095>,
        <-41.647572, 31.402456, -46.434601>,
        < -41.475101, 32.337179, -45.076508>
      }
      triangle {
        <-41.647572, 31.402456, 30.500000>,
        <-41.302502, 32.839720, 30.500000>,
        < -41.647572, 31.402456, -25.738503>
      }
      triangle {
        <-41.302502, 32.839720, 30.500000>,
        <-41.322731, 32.788885, -44.300797>,
        < -41.475101, 32.337179, -45.076508>
      }
      triangle {
        <-41.012669, 33.312857, -45.061401>,
        <-41.475101, 32.337179, -45.076508>,
        < -41.322731, 32.788885, -44.300797>
      }
      triangle {
        <-41.318890, 32.624586, -46.170807>,
        <-41.443539, 32.221266, -46.716095>,
        < -41.475101, 32.337179, -45.076508>
      }
      triangle {
        <-41.175789, 32.981444, -45.617096>,
        <-41.318890, 32.624586, -46.170807>,
        < -41.475101, 32.337179, -45.076508>
      }
      triangle {
        <-41.012669, 33.312857, -45.061401>,
        <-41.175789, 32.981444, -45.617096>,
        < -41.475101, 32.337179, -45.076508>
      }
      triangle {
        <-41.302502, 32.839720, 30.500000>,
        <-41.134800, 33.210585, -43.599701>,
        < -41.322731, 32.788885, -44.300797>
      }
      triangle {
        <-40.822971, 33.634840, -44.509903>,
        <-41.322731, 32.788885, -44.300797>,
        < -41.134800, 33.210585, -43.599701>
      }
      triangle {
        <-40.822971, 33.634840, -44.509903>,
        <-41.012669, 33.312857, -45.061401>,
        < -41.322731, 32.788885, -44.300797>
      }
      triangle {
        <-40.552349, 34.113241, 30.500000>,
        <-40.677471, 33.952124, -42.563797>,
        < -41.134800, 33.210585, -43.599701>
      }
      triangle {
        <-40.309608, 34.302153, -43.443100>,
        <-41.134800, 33.210585, -43.599701>,
        < -40.677471, 33.952124, -42.563797>
      }
      triangle {
        <-41.302502, 32.839720, 30.500000>,
        <-40.552349, 34.113241, 30.500000>,
        < -41.134800, 33.210585, -43.599701>
      }
      triangle {
        <-40.594681, 33.961111, -43.967896>,
        <-40.822971, 33.634840, -44.509903>,
        < -41.134800, 33.210585, -43.599701>
      }
      triangle {
        <-40.309608, 34.302153, -43.443100>,
        <-40.594681, 33.961111, -43.967896>,
        < -41.134800, 33.210585, -43.599701>
      }
      triangle {
        <-40.552349, 34.113241, 30.500000>,
        <-40.093811, 34.607306, -41.867203>,
        < -40.677471, 33.952124, -42.563797>
      }
      triangle {
        <-39.942490, 34.662596, -42.947205>,
        <-40.677471, 33.952124, -42.563797>,
        < -40.093811, 34.607306, -41.867203>
      }
      triangle {
        <-39.942490, 34.662596, -42.947205>,
        <-40.309608, 34.302153, -43.443100>,
        < -40.677471, 33.952124, -42.563797>
      }
      triangle {
        <-39.462521, 35.111883, 30.500000>,
        <-39.344749, 35.188933, -41.376007>,
        < -40.093811, 34.607306, -41.867203>
      }
      triangle {
        <-38.835499, 35.394903, -42.130005>,
        <-40.093811, 34.607306, -41.867203>,
        < -39.344749, 35.188933, -41.376007>
      }
      triangle {
        <-40.552349, 34.113241, 30.500000>,
        <-39.462521, 35.111883, 30.500000>,
        < -40.093811, 34.607306, -41.867203>
      }
      triangle {
        <-39.461849, 35.035704, -42.499207>,
        <-39.942490, 34.662596, -42.947205>,
        < -40.093811, 34.607306, -41.867203>
      }
      triangle {
        <-38.835499, 35.394903, -42.130005>,
        <-39.461849, 35.035704, -42.499207>,
        < -40.093811, 34.607306, -41.867203>
      }
      triangle {
        <-38.128471, 35.748182, 30.500000>,
        <-38.438511, 35.642172, -41.052597>,
        < -39.344749, 35.188933, -41.376007>
      }
      triangle {
        <-38.051960, 35.683149, -41.893204>,
        <-39.344749, 35.188933, -41.376007>,
        < -38.438511, 35.642172, -41.052597>
      }
      triangle {
        <-39.462521, 35.111883, 30.500000>,
        <-38.128471, 35.748182, 30.500000>,
        < -39.344749, 35.188933, -41.376007>
      }
      triangle {
        <-38.051960, 35.683149, -41.893204>,
        <-38.835499, 35.394903, -42.130005>,
        < -39.344749, 35.188933, -41.376007>
      }
      triangle {
        <-38.128471, 35.748182, 30.500000>,
        <-37.487888, 35.898764, -40.887100>,
        < -38.438511, 35.642172, -41.052597>
      }
      triangle {
        <-37.206459, 35.812254, -41.880203>,
        <-38.438511, 35.642172, -41.052597>,
        < -37.487888, 35.898764, -40.887100>
      }
      triangle {
        <-37.206459, 35.812254, -41.880203>,
        <-38.051960, 35.683149, -41.893204>,
        < -38.438511, 35.642172, -41.052597>
      }
      triangle {
        <-36.666599, 35.966673, 30.500000>,
        <-36.666599, 35.966673, -40.845093>,
        < -37.487888, 35.898764, -40.887100>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <-37.487888, 35.898764, -40.887100>,
        < -36.666599, 35.966673, -40.845093>
      }
      triangle {
        <-38.128471, 35.748182, 30.500000>,
        <-36.666599, 35.966673, 30.500000>,
        < -37.487888, 35.898764, -40.887100>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <-37.206459, 35.812254, -41.880203>,
        < -37.487888, 35.898764, -40.887100>
      }
      triangle {
        <36.666599, 35.966673, 30.500000>,
        <-36.666599, 35.966673, -40.845093>,
        < -36.666599, 35.966673, 30.500000>
      }
      triangle {
        <36.666599, 35.966673, 30.500000>,
        <36.666599, 35.966673, -40.845093>,
        < -36.666599, 35.966673, -40.845093>
      }
      triangle {
        <36.666599, 35.914114, -41.491394>,
        <-36.666599, 35.966673, -40.845093>,
        < 36.666599, 35.966673, -40.845093>
      }
      triangle {
        <-36.666599, 35.914114, -41.491394>,
        <-36.666599, 35.790823, -42.018097>,
        < -36.666599, 35.966673, -40.845093>
      }
      triangle {
        <36.666599, 35.914114, -41.491394>,
        <-36.666599, 35.914114, -41.491394>,
        < -36.666599, 35.966673, -40.845093>
      }
      triangle {
        <38.128471, 35.748182, 30.500000>,
        <36.666599, 35.966673, -40.845093>,
        < 36.666599, 35.966673, 30.500000>
      }
      triangle {
        <38.128471, 35.748182, 30.500000>,
        <37.489040, 35.898565, -40.887299>,
        < 36.666599, 35.966673, -40.845093>
      }
      triangle {
        <36.666599, 35.914114, -41.491394>,
        <36.666599, 35.966673, -40.845093>,
        < 37.489040, 35.898565, -40.887299>
      }
      triangle {
        <38.128471, 35.748182, 30.500000>,
        <38.440910, 35.641264, -41.053207>,
        < 37.489040, 35.898565, -40.887299>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <37.489040, 35.898565, -40.887299>,
        < 38.440910, 35.641264, -41.053207>
      }
      triangle {
        <36.666599, 35.914114, -41.491394>,
        <37.489040, 35.898565, -40.887299>,
        < 36.666599, 35.790823, -42.018097>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <36.666599, 35.790823, -42.018097>,
        < 37.489040, 35.898565, -40.887299>
      }
      triangle {
        <39.462521, 35.111883, 30.500000>,
        <39.347881, 35.186941, -41.377502>,
        < 38.440910, 35.641264, -41.053207>
      }
      triangle {
        <37.920448, 35.715712, -41.873901>,
        <38.440910, 35.641264, -41.053207>,
        < 39.347881, 35.186941, -41.377502>
      }
      triangle {
        <38.128471, 35.748182, 30.500000>,
        <39.462521, 35.111883, 30.500000>,
        < 38.440910, 35.641264, -41.053207>
      }
      triangle {
        <37.920448, 35.715712, -41.873901>,
        <37.148140, 35.813643, -41.890503>,
        < 38.440910, 35.641264, -41.053207>
      }
      triangle {
        <39.462521, 35.111883, 30.500000>,
        <40.097160, 34.604139, -41.870102>,
        < 39.347881, 35.186941, -41.377502>
      }
      triangle {
        <38.667992, 35.470564, -42.060898>,
        <39.347881, 35.186941, -41.377502>,
        < 40.097160, 34.604139, -41.870102>
      }
      triangle {
        <38.667992, 35.470564, -42.060898>,
        <37.920448, 35.715712, -41.873901>,
        < 39.347881, 35.186941, -41.377502>
      }
      triangle {
        <40.552349, 34.113241, 30.500000>,
        <40.680580, 33.947943, -42.568802>,
        < 40.097160, 34.604139, -41.870102>
      }
      triangle {
        <39.285938, 35.149656, -42.375305>,
        <40.097160, 34.604139, -41.870102>,
        < 40.680580, 33.947943, -42.568802>
      }
      triangle {
        <39.462521, 35.111883, 30.500000>,
        <40.552349, 34.113241, 30.500000>,
        < 40.097160, 34.604139, -41.870102>
      }
      triangle {
        <39.285938, 35.149656, -42.375305>,
        <38.667992, 35.470564, -42.060898>,
        < 40.097160, 34.604139, -41.870102>
      }
      triangle {
        <41.302502, 32.839720, 30.500000>,
        <41.137970, 33.204260, -43.609695>,
        < 40.680580, 33.947943, -42.568802>
      }
      triangle {
        <40.152149, 34.466154, -43.209702>,
        <40.680580, 33.947943, -42.568802>,
        < 41.137970, 33.204260, -43.609695>
      }
      triangle {
        <40.552349, 34.113241, 30.500000>,
        <41.302502, 32.839720, 30.500000>,
        < 40.680580, 33.947943, -42.568802>
      }
      triangle {
        <39.772911, 34.805502, -42.767899>,
        <39.285938, 35.149656, -42.375305>,
        < 40.680580, 33.947943, -42.568802>
      }
      triangle {
        <40.152149, 34.466154, -43.209702>,
        <39.772911, 34.805502, -42.767899>,
        < 40.680580, 33.947943, -42.568802>
      }
      triangle {
        <41.302502, 32.839720, 30.500000>,
        <41.324989, 32.783095, -44.310699>,
        < 41.137970, 33.204260, -43.609695>
      }
      triangle {
        <40.688068, 33.834364, -44.174805>,
        <41.137970, 33.204260, -43.609695>,
        < 41.324989, 32.783095, -44.310699>
      }
      triangle {
        <40.449680, 34.142431, -43.682602>,
        <40.152149, 34.466154, -43.209702>,
        < 41.137970, 33.204260, -43.609695>
      }
      triangle {
        <40.688068, 33.834364, -44.174805>,
        <40.449680, 34.142431, -43.682602>,
        < 41.137970, 33.204260, -43.609695>
      }
      triangle {
        <41.647572, 31.402456, 30.500000>,
        <41.476151, 32.333502, -45.082596>,
        < 41.324989, 32.783095, -44.310699>
      }
      triangle {
        <40.884789, 33.535894, -44.678802>,
        <41.324989, 32.783095, -44.310699>,
        < 41.476151, 32.333502, -45.082596>
      }
      triangle {
        <41.302502, 32.839720, 30.500000>,
        <41.647572, 31.402456, 30.500000>,
        < 41.324989, 32.783095, -44.310699>
      }
      triangle {
        <40.884789, 33.535894, -44.678802>,
        <40.688068, 33.834364, -44.174805>,
        < 41.324989, 32.783095, -44.310699>
      }
      triangle {
        <41.647572, 31.402456, 30.500000>,
        <41.585331, 31.864454, -45.822098>,
        < 41.476151, 32.333502, -45.082596>
      }
      triangle {
        <41.199020, 32.928610, -45.702606>,
        <41.476151, 32.333502, -45.082596>,
        < 41.585331, 31.864454, -45.822098>
      }
      triangle {
        <41.052341, 33.237776, -45.189499>,
        <40.884789, 33.535894, -44.678802>,
        < 41.476151, 32.333502, -45.082596>
      }
      triangle {
        <41.199020, 32.928610, -45.702606>,
        <41.052341, 33.237776, -45.189499>,
        < 41.476151, 32.333502, -45.082596>
      }
      triangle {
        <41.647572, 31.402456, -25.738503>,
        <41.647572, 31.402456, -46.434601>,
        < 41.585331, 31.864454, -45.822098>
      }
      triangle {
        <41.329159, 32.595495, -46.213196>,
        <41.585331, 31.864454, -45.822098>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.647572, 31.402456, 30.500000>,
        <41.647572, 31.402456, -25.738503>,
        < 41.585331, 31.864454, -45.822098>
      }
      triangle {
        <41.329159, 32.595495, -46.213196>,
        <41.199020, 32.928610, -45.702606>,
        < 41.585331, 31.864454, -45.822098>
      }
      triangle {
        <41.662430, 31.232596, -27.030701>,
        <41.647572, 31.402456, -46.434601>,
        < 41.647572, 31.402456, -25.738503>
      }
      triangle {
        <42.836369, 17.814371, -85.084198>,
        <42.726780, 19.067064, -83.094604>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <42.522751, 19.885874, -83.376099>,
        <41.647572, 31.402456, -46.434601>,
        < 42.726780, 19.067064, -83.094604>
      }
      triangle {
        <42.836369, 17.814371, -36.470299>,
        <42.836369, 17.814371, -85.084198>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.866291, 28.902456, -30.068604>,
        <42.836369, 17.814371, -36.470299>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.775581, 29.939253, -29.272797>,
        <41.866291, 28.902456, -30.068604>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.706059, 30.733870, -28.236298>,
        <41.775581, 29.939253, -29.272797>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.662430, 31.232596, -27.030701>,
        <41.706059, 30.733870, -28.236298>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <41.443539, 32.221266, -46.716095>,
        <41.329159, 32.595495, -46.213196>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <42.522751, 19.885874, -83.376099>,
        <41.443539, 32.221266, -46.716095>,
        < 41.647572, 31.402456, -46.434601>
      }
      triangle {
        <42.836369, 17.814371, -85.084198>,
        <42.771210, 18.559141, -84.164307>,
        < 42.726780, 19.067064, -83.094604>
      }
      triangle {
        <42.573078, 19.292593, -84.637100>,
        <42.726780, 19.067064, -83.094604>,
        < 42.771210, 18.559141, -84.164307>
      }
      triangle {
        <42.573078, 19.292593, -84.637100>,
        <42.522751, 19.885874, -83.376099>,
        < 42.726780, 19.067064, -83.094604>
      }
      triangle {
        <42.646999, 18.421091, -85.725006>,
        <42.771210, 18.559141, -84.164307>,
        < 42.836369, 17.814371, -85.084198>
      }
      triangle {
        <42.646999, 18.421091, -85.725006>,
        <42.573078, 19.292593, -84.637100>,
        < 42.771210, 18.559141, -84.164307>
      }
      triangle {
        <42.959049, 15.942862, -37.550903>,
        <42.836369, 17.814371, -85.084198>,
        < 42.836369, 17.814371, -36.470299>
      }
      triangle {
        <42.959049, 15.942862, -37.550903>,
        <42.924881, 16.607233, -86.184097>,
        < 42.836369, 17.814371, -85.084198>
      }
      triangle {
        <42.789532, 16.765223, -87.087006>,
        <42.836369, 17.814371, -85.084198>,
        < 42.924881, 16.607233, -86.184097>
      }
      triangle {
        <42.789532, 16.765223, -87.087006>,
        <42.646999, 18.421091, -85.725006>,
        < 42.836369, 17.814371, -85.084198>
      }
      triangle {
        <42.959049, 15.942862, -37.550903>,
        <42.934750, 16.434702, -86.348099>,
        < 42.924881, 16.607233, -86.184097>
      }
      triangle {
        <42.789532, 16.765223, -87.087006>,
        <42.924881, 16.607233, -86.184097>,
        < 42.934750, 16.434702, -86.348099>
      }
      triangle {
        <42.959049, 15.942862, -37.550903>,
        <42.976501, 15.488024, -87.360901>,
        < 42.934750, 16.434702, -86.348099>
      }
      triangle {
        <42.901871, 15.278334, -88.246201>,
        <42.934750, 16.434702, -86.348099>,
        < 42.976501, 15.488024, -87.360901>
      }
      triangle {
        <42.789532, 16.765223, -87.087006>,
        <42.934750, 16.434702, -86.348099>,
        < 42.901871, 15.278334, -88.246201>
      }
      triangle {
        <43.000000, 14.066671, -38.634094>,
        <42.985249, 15.192732, -87.740097>,
        < 42.976501, 15.488024, -87.360901>
      }
      triangle {
        <42.901871, 15.278334, -88.246201>,
        <42.976501, 15.488024, -87.360901>,
        < 42.985249, 15.192732, -87.740097>
      }
      triangle {
        <42.959049, 15.942862, -37.550903>,
        <43.000000, 14.066671, -38.634094>,
        < 42.976501, 15.488024, -87.360901>
      }
      triangle {
        <43.000000, 14.066671, -38.634094>,
        <43.000000, 14.066671, -89.500000>,
        < 42.985249, 15.192732, -87.740097>
      }
      triangle {
        <42.901871, 15.278334, -88.246201>,
        <42.985249, 15.192732, -87.740097>,
        < 43.000000, 14.066671, -89.500000>
      }
      triangle {
        <43.000000, 10.566671, -89.500000>,
        <43.000000, 14.066671, -89.500000>,
        < 43.000000, 14.066671, -38.634094>
      }
      triangle {
        <-43.000000, 10.566671, -89.500000>,
        <43.000000, 14.066671, -89.500000>,
        < 43.000000, 10.566671, -89.500000>
      }
      triangle {
        <-43.000000, 14.066671, -89.500000>,
        <43.000000, 14.066671, -89.500000>,
        < -43.000000, 10.566671, -89.500000>
      }
      triangle {
        <-41.737598, 14.991274, -89.446396>,
        <43.000000, 14.066671, -89.500000>,
        < -43.000000, 14.066671, -89.500000>
      }
      triangle {
        <41.319130, 15.433943, -89.382294>,
        <43.000000, 14.066671, -89.500000>,
        < 41.737591, 14.991293, -89.446396>
      }
      triangle {
        <-41.737598, 14.991274, -89.446396>,
        <41.737591, 14.991293, -89.446396>,
        < 43.000000, 14.066671, -89.500000>
      }
      triangle {
        <41.832581, 15.433134, -89.300095>,
        <43.000000, 14.066671, -89.500000>,
        < 41.319130, 15.433943, -89.382294>
      }
      triangle {
        <42.664429, 15.351355, -88.703003>,
        <42.901871, 15.278334, -88.246201>,
        < 43.000000, 14.066671, -89.500000>
      }
      triangle {
        <42.296051, 15.404684, -89.066101>,
        <42.664429, 15.351355, -88.703003>,
        < 43.000000, 14.066671, -89.500000>
      }
      triangle {
        <41.832581, 15.433134, -89.300095>,
        <42.296051, 15.404684, -89.066101>,
        < 43.000000, 14.066671, -89.500000>
      }
      triangle {
        <43.000000, 10.566671, -40.654800>,
        <43.000000, 10.566671, -89.500000>,
        < 43.000000, 14.066671, -38.634094>
      }
      triangle {
        <-42.901970, 15.277033, -88.247299>,
        <-43.000000, 14.066671, -89.500000>,
        < -42.985279, 15.191603, -87.741699>
      }
      triangle {
        <-41.737598, 14.991274, -89.446396>,
        <-43.000000, 14.066671, -89.500000>,
        < -41.320492, 15.432322, -89.382599>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-41.320492, 15.432322, -89.382599>,
        < -43.000000, 14.066671, -89.500000>
      }
      triangle {
        <-42.664719, 15.349901, -88.703796>,
        <-43.000000, 14.066671, -89.500000>,
        < -42.901970, 15.277033, -88.247299>
      }
      triangle {
        <-42.296631, 15.403124, -89.066605>,
        <-43.000000, 14.066671, -89.500000>,
        < -42.664719, 15.349901, -88.703796>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-43.000000, 14.066671, -89.500000>,
        < -42.296631, 15.403124, -89.066605>
      }
      triangle {
        <-42.789661, 16.763582, -87.088303>,
        <-42.985279, 15.191603, -87.741699>,
        < -42.976501, 15.488012, -87.360901>
      }
      triangle {
        <-42.901970, 15.277033, -88.247299>,
        <-42.985279, 15.191603, -87.741699>,
        < -42.789661, 16.763582, -87.088303>
      }
      triangle {
        <-42.789661, 16.763582, -87.088303>,
        <-42.976501, 15.488012, -87.360901>,
        < -42.934818, 16.433352, -86.349396>
      }
      triangle {
        <-42.646999, 18.421091, -85.725006>,
        <-42.934818, 16.433352, -86.349396>,
        < -42.924881, 16.607233, -86.184097>
      }
      triangle {
        <-42.646999, 18.421091, -85.725006>,
        <-42.789661, 16.763582, -87.088303>,
        < -42.934818, 16.433352, -86.349396>
      }
      triangle {
        <-41.320492, 15.432322, -89.382599>,
        <41.319130, 15.433943, -89.382294>,
        < 41.737591, 14.991293, -89.446396>
      }
      triangle {
        <-41.737598, 14.991274, -89.446396>,
        <-41.320492, 15.432322, -89.382599>,
        < 41.737591, 14.991293, -89.446396>
      }
      triangle {
        <40.514950, 16.754004, -89.035095>,
        <41.319130, 15.433943, -89.382294>,
        < 40.993229, 15.869562, -89.294205>
      }
      triangle {
        <-40.993240, 15.869543, -89.294205>,
        <40.993229, 15.869562, -89.294205>,
        < 41.319130, 15.433943, -89.382294>
      }
      triangle {
        <40.271439, 17.398813, -88.772995>,
        <41.319130, 15.433943, -89.382294>,
        < 40.514950, 16.754004, -89.035095>
      }
      triangle {
        <41.832581, 15.433134, -89.300095>,
        <41.319130, 15.433943, -89.382294>,
        < 40.271439, 17.398813, -88.772995>
      }
      triangle {
        <-41.320492, 15.432322, -89.382599>,
        <-40.993240, 15.869543, -89.294205>,
        < 41.319130, 15.433943, -89.382294>
      }
      triangle {
        <-40.514950, 16.753992, -89.035095>,
        <40.514950, 16.754004, -89.035095>,
        < 40.993229, 15.869562, -89.294205>
      }
      triangle {
        <-40.993240, 15.869543, -89.294205>,
        <-40.514950, 16.753992, -89.035095>,
        < 40.993229, 15.869562, -89.294205>
      }
      triangle {
        <-40.272179, 17.396563, -88.774094>,
        <40.271439, 17.398813, -88.772995>,
        < 40.514950, 16.754004, -89.035095>
      }
      triangle {
        <-40.514950, 16.753992, -89.035095>,
        <-40.272179, 17.396563, -88.774094>,
        < 40.514950, 16.754004, -89.035095>
      }
      triangle {
        <39.959690, 18.672644, -88.041000>,
        <40.271439, 17.398813, -88.772995>,
        < 40.182961, 17.688452, -88.633194>
      }
      triangle {
        <-40.182968, 17.688444, -88.633194>,
        <40.182961, 17.688452, -88.633194>,
        < 40.271439, 17.398813, -88.772995>
      }
      triangle {
        <39.847790, 19.644644, -87.234695>,
        <40.271439, 17.398813, -88.772995>,
        < 39.959690, 18.672644, -88.041000>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <40.271439, 17.398813, -88.772995>,
        < 39.847790, 19.644644, -87.234695>
      }
      triangle {
        <-40.272179, 17.396563, -88.774094>,
        <-40.182968, 17.688444, -88.633194>,
        < 40.271439, 17.398813, -88.772995>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <41.832581, 15.433134, -89.300095>,
        < 40.271439, 17.398813, -88.772995>
      }
      triangle {
        <-39.959690, 18.672632, -88.041000>,
        <39.959690, 18.672644, -88.041000>,
        < 40.182961, 17.688452, -88.633194>
      }
      triangle {
        <-40.182968, 17.688444, -88.633194>,
        <-39.959690, 18.672632, -88.041000>,
        < 40.182961, 17.688452, -88.633194>
      }
      triangle {
        <-39.847790, 19.644644, -87.234695>,
        <39.847790, 19.644644, -87.234695>,
        < 39.959690, 18.672644, -88.041000>
      }
      triangle {
        <-39.959690, 18.672632, -88.041000>,
        <-39.847790, 19.644644, -87.234695>,
        < 39.959690, 18.672644, -88.041000>
      }
      triangle {
        <-39.782631, 20.836283, -85.762894>,
        <39.782631, 20.836283, -85.762894>,
        < 39.847790, 19.644644, -87.234695>
      }
      triangle {
        <40.666500, 20.745302, -85.656906>,
        <39.847790, 19.644644, -87.234695>,
        < 39.782631, 20.836283, -85.762894>
      }
      triangle {
        <-39.847790, 19.644644, -87.234695>,
        <-39.782631, 20.836283, -85.762894>,
        < 39.847790, 19.644644, -87.234695>
      }
      triangle {
        <40.738319, 19.590014, -87.098404>,
        <39.847790, 19.644644, -87.234695>,
        < 40.666500, 20.745302, -85.656906>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <39.847790, 19.644644, -87.234695>,
        < 40.738319, 19.590014, -87.098404>
      }
      triangle {
        <-39.738190, 21.648943, -84.051300>,
        <39.738190, 21.648943, -84.051300>,
        < 39.782631, 20.836283, -85.762894>
      }
      triangle {
        <40.617580, 21.531775, -83.985992>,
        <39.782631, 20.836283, -85.762894>,
        < 39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-39.782631, 20.836283, -85.762894>,
        <-39.738190, 21.648943, -84.051300>,
        < 39.782631, 20.836283, -85.762894>
      }
      triangle {
        <40.666500, 20.745302, -85.656906>,
        <39.782631, 20.836283, -85.762894>,
        < 40.617580, 21.531775, -83.985992>
      }
      triangle {
        <38.658981, 33.984335, -47.391403>,
        <39.738190, 21.648943, -84.051300>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <39.535820, 33.867880, -47.326401>,
        <39.738190, 21.648943, -84.051300>,
        < 38.658981, 33.984335, -47.391403>
      }
      triangle {
        <40.617580, 21.531775, -83.985992>,
        <39.738190, 21.648943, -84.051300>,
        < 39.535820, 33.867880, -47.326401>
      }
      triangle {
        <-40.666500, 20.745302, -85.656906>,
        <-39.738190, 21.648943, -84.051300>,
        < -39.782631, 20.836283, -85.762894>
      }
      triangle {
        <38.588581, 34.241163, -46.628098>,
        <38.658981, 33.984335, -47.391403>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <38.411591, 34.542776, -45.731705>,
        <38.588581, 34.241163, -46.628098>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <38.249241, 34.748053, -45.121597>,
        <38.411591, 34.542776, -45.731705>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <38.175900, 34.830687, -44.876099>,
        <38.249241, 34.748053, -45.121597>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.950352, 35.061483, -44.190201>,
        <38.175900, 34.830687, -44.876099>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.754990, 35.238730, -43.663406>,
        <37.950352, 35.061483, -44.190201>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.640251, 35.333670, -43.381195>,
        <37.754990, 35.238730, -43.663406>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.584049, 35.377562, -43.250793>,
        <37.640251, 35.333670, -43.381195>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.427441, 35.489851, -42.917099>,
        <37.584049, 35.377562, -43.250793>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.279770, 35.580542, -42.647598>,
        <37.427441, 35.489851, -42.917099>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.195240, 35.624952, -42.515594>,
        <37.279770, 35.580542, -42.647598>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.138351, 35.651510, -42.436600>,
        <37.195240, 35.624952, -42.515594>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <37.002918, 35.703352, -42.282593>,
        <37.138351, 35.651510, -42.436600>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <36.876629, 35.736494, -42.184097>,
        <37.002918, 35.703352, -42.282593>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <36.763390, 35.753286, -42.134201>,
        <36.876629, 35.736494, -42.184097>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <36.666599, 35.757811, -42.120697>,
        <36.763390, 35.753286, -42.134201>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-36.666599, 35.757811, -42.120697>,
        <36.666599, 35.757811, -42.120697>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-36.763260, 35.753294, -42.134201>,
        <-36.666599, 35.757811, -42.120697>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-36.876331, 35.736555, -42.183899>,
        <-36.763260, 35.753294, -42.134201>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.002430, 35.703512, -42.282104>,
        <-36.876331, 35.736555, -42.183899>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.137661, 35.651823, -42.435699>,
        <-37.002430, 35.703512, -42.282104>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.195240, 35.624952, -42.515594>,
        <-37.137661, 35.651823, -42.435699>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.278870, 35.581045, -42.646103>,
        <-37.195240, 35.624952, -42.515594>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.426300, 35.490614, -42.914795>,
        <-37.278870, 35.581045, -42.646103>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.582619, 35.378653, -43.247498>,
        <-37.426300, 35.490614, -42.914795>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.640251, 35.333670, -43.381195>,
        <-37.582619, 35.378653, -43.247498>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.753231, 35.240233, -43.658905>,
        <-37.640251, 35.333670, -43.381195>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-37.947922, 35.063803, -44.183304>,
        <-37.753231, 35.240233, -43.658905>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-38.172909, 34.833952, -44.866394>,
        <-37.947922, 35.063803, -44.183304>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-38.249241, 34.748060, -45.121597>,
        <-38.172909, 34.833952, -44.866394>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-38.409710, 34.545385, -45.723999>,
        <-38.249241, 34.748060, -45.121597>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-38.588188, 34.242064, -46.625397>,
        <-38.409710, 34.545385, -45.723999>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-38.658981, 33.984335, -47.391403>,
        <-38.588188, 34.242064, -46.625397>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-40.617580, 21.531775, -83.985992>,
        <-38.658981, 33.984335, -47.391403>,
        < -39.738190, 21.648943, -84.051300>
      }
      triangle {
        <-40.617580, 21.531775, -83.985992>,
        <-39.738190, 21.648943, -84.051300>,
        < -40.666500, 20.745302, -85.656906>
      }
      triangle {
        <-40.738319, 19.590014, -87.098404>,
        <-39.782631, 20.836283, -85.762894>,
        < -39.847790, 19.644644, -87.234695>
      }
      triangle {
        <-40.666500, 20.745302, -85.656906>,
        <-39.782631, 20.836283, -85.762894>,
        < -40.738319, 19.590014, -87.098404>
      }
      triangle {
        <-41.083580, 17.380743, -88.641907>,
        <-39.847790, 19.644644, -87.234695>,
        < -39.959690, 18.672632, -88.041000>
      }
      triangle {
        <-40.738319, 19.590014, -87.098404>,
        <-39.847790, 19.644644, -87.234695>,
        < -41.083580, 17.380743, -88.641907>
      }
      triangle {
        <-41.083580, 17.380743, -88.641907>,
        <-39.959690, 18.672632, -88.041000>,
        < -40.182968, 17.688444, -88.633194>
      }
      triangle {
        <-41.083580, 17.380743, -88.641907>,
        <-40.182968, 17.688444, -88.633194>,
        < -40.272179, 17.396563, -88.774094>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-40.272179, 17.396563, -88.774094>,
        < -40.514950, 16.753992, -89.035095>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-41.083580, 17.380743, -88.641907>,
        < -40.272179, 17.396563, -88.774094>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-40.514950, 16.753992, -89.035095>,
        < -40.993240, 15.869543, -89.294205>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-40.993240, 15.869543, -89.294205>,
        < -41.320492, 15.432322, -89.382599>
      }
      triangle {
        <39.535820, 33.867880, -47.326401>,
        <38.658981, 33.984335, -47.391403>,
        < 38.588581, 34.241163, -46.628098>
      }
      triangle {
        <39.074261, 34.262526, -46.429901>,
        <38.588581, 34.241163, -46.628098>,
        < 38.411591, 34.542776, -45.731705>
      }
      triangle {
        <39.310539, 34.074133, -46.878098>,
        <39.535820, 33.867880, -47.326401>,
        < 38.588581, 34.241163, -46.628098>
      }
      triangle {
        <39.074261, 34.262526, -46.429901>,
        <39.310539, 34.074133, -46.878098>,
        < 38.588581, 34.241163, -46.628098>
      }
      triangle {
        <38.548512, 34.599173, -45.548492>,
        <38.411591, 34.542776, -45.731705>,
        < 38.249241, 34.748053, -45.121597>
      }
      triangle {
        <38.821800, 34.437086, -45.985596>,
        <39.074261, 34.262526, -46.429901>,
        < 38.411591, 34.542776, -45.731705>
      }
      triangle {
        <38.548512, 34.599173, -45.548492>,
        <38.821800, 34.437086, -45.985596>,
        < 38.411591, 34.542776, -45.731705>
      }
      triangle {
        <39.321548, 34.566252, -45.139008>,
        <38.249241, 34.748053, -45.121597>,
        < 38.175900, 34.830687, -44.876099>
      }
      triangle {
        <39.321548, 34.566252, -45.139008>,
        <38.548512, 34.599173, -45.548492>,
        < 38.249241, 34.748053, -45.121597>
      }
      triangle {
        <38.993771, 34.791052, -44.651199>,
        <38.175900, 34.830687, -44.876099>,
        < 37.950352, 35.061483, -44.190201>
      }
      triangle {
        <38.993771, 34.791052, -44.651199>,
        <39.321548, 34.566252, -45.139008>,
        < 38.175900, 34.830687, -44.876099>
      }
      triangle {
        <38.167622, 35.189291, -43.755005>,
        <37.950352, 35.061483, -44.190201>,
        < 37.754990, 35.238730, -43.663406>
      }
      triangle {
        <38.614170, 35.001806, -44.185593>,
        <38.993771, 34.791052, -44.651199>,
        < 37.950352, 35.061483, -44.190201>
      }
      triangle {
        <38.167622, 35.189291, -43.755005>,
        <38.614170, 35.001806, -44.185593>,
        < 37.950352, 35.061483, -44.190201>
      }
      triangle {
        <38.167622, 35.189291, -43.755005>,
        <37.754990, 35.238730, -43.663406>,
        < 37.640251, 35.333670, -43.381195>
      }
      triangle {
        <38.566841, 35.324835, -42.971497>,
        <37.640251, 35.333670, -43.381195>,
        < 37.584049, 35.377562, -43.250793>
      }
      triangle {
        <39.089729, 35.064474, -43.375305>,
        <38.167622, 35.189291, -43.755005>,
        < 37.640251, 35.333670, -43.381195>
      }
      triangle {
        <38.566841, 35.324835, -42.971497>,
        <39.089729, 35.064474, -43.375305>,
        < 37.640251, 35.333670, -43.381195>
      }
      triangle {
        <38.566841, 35.324835, -42.971497>,
        <37.584049, 35.377562, -43.250793>,
        < 37.427441, 35.489851, -42.917099>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <37.427441, 35.489851, -42.917099>,
        < 37.279770, 35.580542, -42.647598>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <38.566841, 35.324835, -42.971497>,
        < 37.427441, 35.489851, -42.917099>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <37.279770, 35.580542, -42.647598>,
        < 37.195240, 35.624952, -42.515594>
      }
      triangle {
        <38.667992, 35.470564, -42.060898>,
        <37.195240, 35.624952, -42.515594>,
        < 37.138351, 35.651510, -42.436600>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <37.195240, 35.624952, -42.515594>,
        < 38.667992, 35.470564, -42.060898>
      }
      triangle {
        <37.920448, 35.715712, -41.873901>,
        <37.138351, 35.651510, -42.436600>,
        < 37.002918, 35.703352, -42.282593>
      }
      triangle {
        <38.667992, 35.470564, -42.060898>,
        <37.138351, 35.651510, -42.436600>,
        < 37.920448, 35.715712, -41.873901>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <37.002918, 35.703352, -42.282593>,
        < 36.876629, 35.736494, -42.184097>
      }
      triangle {
        <37.920448, 35.715712, -41.873901>,
        <37.002918, 35.703352, -42.282593>,
        < 37.148140, 35.813643, -41.890503>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <36.876629, 35.736494, -42.184097>,
        < 36.763390, 35.753286, -42.134201>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <36.763390, 35.753286, -42.134201>,
        < 36.666599, 35.757811, -42.120697>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <36.666599, 35.757811, -42.120697>,
        < -36.666599, 35.757811, -42.120697>
      }
      triangle {
        <36.666599, 35.790823, -42.018097>,
        <36.666599, 35.757811, -42.120697>,
        < -36.666599, 35.790823, -42.018097>
      }
      triangle {
        <37.148140, 35.813643, -41.890503>,
        <36.666599, 35.757811, -42.120697>,
        < 36.666599, 35.790823, -42.018097>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <-36.666599, 35.757811, -42.120697>,
        < -36.763260, 35.753294, -42.134201>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <-36.763260, 35.753294, -42.134201>,
        < -36.876331, 35.736555, -42.183899>
      }
      triangle {
        <-37.206459, 35.812254, -41.880203>,
        <-36.876331, 35.736555, -42.183899>,
        < -37.002430, 35.703512, -42.282104>
      }
      triangle {
        <-36.666599, 35.790823, -42.018097>,
        <-36.876331, 35.736555, -42.183899>,
        < -37.206459, 35.812254, -41.880203>
      }
      triangle {
        <-37.206459, 35.812254, -41.880203>,
        <-37.002430, 35.703512, -42.282104>,
        < -37.137661, 35.651823, -42.435699>
      }
      triangle {
        <-38.051960, 35.683149, -41.893204>,
        <-37.137661, 35.651823, -42.435699>,
        < -37.195240, 35.624952, -42.515594>
      }
      triangle {
        <-37.206459, 35.812254, -41.880203>,
        <-37.137661, 35.651823, -42.435699>,
        < -38.051960, 35.683149, -41.893204>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-37.195240, 35.624952, -42.515594>,
        < -37.278870, 35.581045, -42.646103>
      }
      triangle {
        <-38.051960, 35.683149, -41.893204>,
        <-37.195240, 35.624952, -42.515594>,
        < -38.835499, 35.394903, -42.130005>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-38.835499, 35.394903, -42.130005>,
        < -37.195240, 35.624952, -42.515594>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-37.278870, 35.581045, -42.646103>,
        < -37.426300, 35.490614, -42.914795>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-37.426300, 35.490614, -42.914795>,
        < -37.582619, 35.378653, -43.247498>
      }
      triangle {
        <-38.566830, 35.324835, -42.971497>,
        <-37.582619, 35.378653, -43.247498>,
        < -37.640251, 35.333670, -43.381195>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-37.582619, 35.378653, -43.247498>,
        < -38.566830, 35.324835, -42.971497>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-37.640251, 35.333670, -43.381195>,
        < -37.753231, 35.240233, -43.658905>
      }
      triangle {
        <-38.566830, 35.324835, -42.971497>,
        <-37.640251, 35.333670, -43.381195>,
        < -39.089722, 35.064474, -43.375305>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-39.089722, 35.064474, -43.375305>,
        < -37.640251, 35.333670, -43.381195>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-37.753231, 35.240233, -43.658905>,
        < -37.947922, 35.063803, -44.183304>
      }
      triangle {
        <-38.614182, 35.001806, -44.185593>,
        <-37.947922, 35.063803, -44.183304>,
        < -38.172909, 34.833952, -44.866394>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-37.947922, 35.063803, -44.183304>,
        < -38.614182, 35.001806, -44.185593>
      }
      triangle {
        <-38.993771, 34.791044, -44.651199>,
        <-38.172909, 34.833952, -44.866394>,
        < -38.249241, 34.748060, -45.121597>
      }
      triangle {
        <-38.614182, 35.001806, -44.185593>,
        <-38.172909, 34.833952, -44.866394>,
        < -38.993771, 34.791044, -44.651199>
      }
      triangle {
        <-38.548500, 34.599173, -45.548492>,
        <-38.249241, 34.748060, -45.121597>,
        < -38.409710, 34.545385, -45.723999>
      }
      triangle {
        <-38.993771, 34.791044, -44.651199>,
        <-38.249241, 34.748060, -45.121597>,
        < -39.321560, 34.566252, -45.139008>
      }
      triangle {
        <-38.548500, 34.599173, -45.548492>,
        <-39.321560, 34.566252, -45.139008>,
        < -38.249241, 34.748060, -45.121597>
      }
      triangle {
        <-38.821800, 34.437094, -45.985596>,
        <-38.409710, 34.545385, -45.723999>,
        < -38.588188, 34.242064, -46.625397>
      }
      triangle {
        <-38.548500, 34.599173, -45.548492>,
        <-38.409710, 34.545385, -45.723999>,
        < -38.821800, 34.437094, -45.985596>
      }
      triangle {
        <-39.310532, 34.074133, -46.878098>,
        <-38.588188, 34.242064, -46.625397>,
        < -38.658981, 33.984335, -47.391403>
      }
      triangle {
        <-39.074261, 34.262526, -46.429901>,
        <-38.588188, 34.242064, -46.625397>,
        < -39.310532, 34.074133, -46.878098>
      }
      triangle {
        <-38.821800, 34.437094, -45.985596>,
        <-38.588188, 34.242064, -46.625397>,
        < -39.074261, 34.262526, -46.429901>
      }
      triangle {
        <-39.535820, 33.867880, -47.326401>,
        <-38.658981, 33.984335, -47.391403>,
        < -40.617580, 21.531775, -83.985992>
      }
      triangle {
        <-39.310532, 34.074133, -46.878098>,
        <-38.658981, 33.984335, -47.391403>,
        < -39.535820, 33.867880, -47.326401>
      }
      triangle {
        <-42.204269, 18.949244, -86.307800>,
        <-42.405151, 17.048472, -87.756897>,
        < -42.789661, 16.763582, -87.088303>
      }
      triangle {
        <-42.901970, 15.277033, -88.247299>,
        <-42.789661, 16.763582, -87.088303>,
        < -42.405151, 17.048472, -87.756897>
      }
      triangle {
        <-42.646999, 18.421091, -85.725006>,
        <-42.204269, 18.949244, -86.307800>,
        < -42.789661, 16.763582, -87.088303>
      }
      triangle {
        <-41.548248, 19.351004, -86.779800>,
        <-41.817841, 17.260923, -88.291702>,
        < -42.405151, 17.048472, -87.756897>
      }
      triangle {
        <-42.664719, 15.349901, -88.703796>,
        <-42.405151, 17.048472, -87.756897>,
        < -41.817841, 17.260923, -88.291702>
      }
      triangle {
        <-42.204269, 18.949244, -86.307800>,
        <-41.548248, 19.351004, -86.779800>,
        < -42.405151, 17.048472, -87.756897>
      }
      triangle {
        <-42.664719, 15.349901, -88.703796>,
        <-42.901970, 15.277033, -88.247299>,
        < -42.405151, 17.048472, -87.756897>
      }
      triangle {
        <-40.738319, 19.590014, -87.098404>,
        <-41.083580, 17.380743, -88.641907>,
        < -41.817841, 17.260923, -88.291702>
      }
      triangle {
        <-42.296631, 15.403124, -89.066605>,
        <-41.817841, 17.260923, -88.291702>,
        < -41.083580, 17.380743, -88.641907>
      }
      triangle {
        <-41.548248, 19.351004, -86.779800>,
        <-40.738319, 19.590014, -87.098404>,
        < -41.817841, 17.260923, -88.291702>
      }
      triangle {
        <-42.296631, 15.403124, -89.066605>,
        <-42.664719, 15.349901, -88.703796>,
        < -41.817841, 17.260923, -88.291702>
      }
      triangle {
        <-41.833530, 15.431524, -89.300507>,
        <-42.296631, 15.403124, -89.066605>,
        < -41.083580, 17.380743, -88.641907>
      }
      triangle {
        <-40.666500, 20.745302, -85.656906>,
        <-40.738319, 19.590014, -87.098404>,
        < -41.548248, 19.351004, -86.779800>
      }
      triangle {
        <-41.471729, 20.436564, -85.418198>,
        <-41.548248, 19.351004, -86.779800>,
        < -42.204269, 18.949244, -86.307800>
      }
      triangle {
        <-40.666500, 20.745302, -85.656906>,
        <-41.548248, 19.351004, -86.779800>,
        < -41.471729, 20.436564, -85.418198>
      }
      triangle {
        <-42.126678, 19.937533, -85.067795>,
        <-42.204269, 18.949244, -86.307800>,
        < -42.646999, 18.421091, -85.725006>
      }
      triangle {
        <-41.471729, 20.436564, -85.418198>,
        <-42.204269, 18.949244, -86.307800>,
        < -42.126678, 19.937533, -85.067795>
      }
      triangle {
        <-42.126678, 19.937533, -85.067795>,
        <-42.646999, 18.421091, -85.725006>,
        < -42.573078, 19.292593, -84.637100>
      }
      triangle {
        <-42.073891, 20.609694, -83.632797>,
        <-42.126678, 19.937533, -85.067795>,
        < -42.573078, 19.292593, -84.637100>
      }
      triangle {
        <-42.522751, 19.885874, -83.376099>,
        <-42.073891, 20.609694, -83.632797>,
        < -42.573078, 19.292593, -84.637100>
      }
      triangle {
        <-41.419659, 21.174894, -83.842300>,
        <-41.471729, 20.436564, -85.418198>,
        < -42.126678, 19.937533, -85.067795>
      }
      triangle {
        <-42.073891, 20.609694, -83.632797>,
        <-41.419659, 21.174894, -83.842300>,
        < -42.126678, 19.937533, -85.067795>
      }
      triangle {
        <-40.617580, 21.531775, -83.985992>,
        <-40.666500, 20.745302, -85.656906>,
        < -41.471729, 20.436564, -85.418198>
      }
      triangle {
        <-41.419659, 21.174894, -83.842300>,
        <-40.617580, 21.531775, -83.985992>,
        < -41.471729, 20.436564, -85.418198>
      }
      triangle {
        <-40.338970, 33.511221, -47.182693>,
        <-40.617580, 21.531775, -83.985992>,
        < -41.419659, 21.174894, -83.842300>
      }
      triangle {
        <-40.338970, 33.511221, -47.182693>,
        <-39.535820, 33.867880, -47.326401>,
        < -40.617580, 21.531775, -83.985992>
      }
      triangle {
        <-40.994122, 32.945746, -46.973206>,
        <-41.419659, 21.174894, -83.842300>,
        < -42.073891, 20.609694, -83.632797>
      }
      triangle {
        <-40.994122, 32.945746, -46.973206>,
        <-40.338970, 33.511221, -47.182693>,
        < -41.419659, 21.174894, -83.842300>
      }
      triangle {
        <-40.994122, 32.945746, -46.973206>,
        <-42.073891, 20.609694, -83.632797>,
        < -42.522751, 19.885874, -83.376099>
      }
      triangle {
        <-41.443539, 32.221266, -46.716095>,
        <-40.994122, 32.945746, -46.973206>,
        < -42.522751, 19.885874, -83.376099>
      }
      triangle {
        <-40.112019, 33.810331, -46.668198>,
        <-39.535820, 33.867880, -47.326401>,
        < -40.338970, 33.511221, -47.182693>
      }
      triangle {
        <-39.310532, 34.074133, -46.878098>,
        <-39.535820, 33.867880, -47.326401>,
        < -40.112019, 33.810331, -46.668198>
      }
      triangle {
        <-40.809929, 33.306402, -46.441193>,
        <-40.338970, 33.511221, -47.182693>,
        < -40.994122, 32.945746, -46.973206>
      }
      triangle {
        <-40.112019, 33.810331, -46.668198>,
        <-40.338970, 33.511221, -47.182693>,
        < -40.809929, 33.306402, -46.441193>
      }
      triangle {
        <-41.318890, 32.624586, -46.170807>,
        <-40.994122, 32.945746, -46.973206>,
        < -41.443539, 32.221266, -46.716095>
      }
      triangle {
        <-40.809929, 33.306402, -46.441193>,
        <-40.994122, 32.945746, -46.973206>,
        < -41.318890, 32.624586, -46.170807>
      }
      triangle {
        <-40.610729, 33.628576, -45.904999>,
        <-41.318890, 32.624586, -46.170807>,
        < -41.175789, 32.981444, -45.617096>
      }
      triangle {
        <-40.610729, 33.628576, -45.904999>,
        <-40.809929, 33.306402, -46.441193>,
        < -41.318890, 32.624586, -46.170807>
      }
      triangle {
        <-40.391491, 33.928404, -45.370499>,
        <-41.175789, 32.981444, -45.617096>,
        < -41.012669, 33.312857, -45.061401>
      }
      triangle {
        <-40.391491, 33.928404, -45.370499>,
        <-40.610729, 33.628576, -45.904999>,
        < -41.175789, 32.981444, -45.617096>
      }
      triangle {
        <-40.144150, 34.216665, -44.843307>,
        <-41.012669, 33.312857, -45.061401>,
        < -40.822971, 33.634840, -44.509903>
      }
      triangle {
        <-40.144150, 34.216665, -44.843307>,
        <-40.391491, 33.928404, -45.370499>,
        < -41.012669, 33.312857, -45.061401>
      }
      triangle {
        <-39.856548, 34.500990, -44.328796>,
        <-40.822971, 33.634840, -44.509903>,
        < -40.594681, 33.961111, -43.967896>
      }
      triangle {
        <-39.856548, 34.500990, -44.328796>,
        <-40.144150, 34.216665, -44.843307>,
        < -40.822971, 33.634840, -44.509903>
      }
      triangle {
        <-39.512070, 34.784773, -43.835098>,
        <-40.594681, 33.961111, -43.967896>,
        < -40.309608, 34.302153, -43.443100>
      }
      triangle {
        <-39.512070, 34.784773, -43.835098>,
        <-39.856548, 34.500990, -44.328796>,
        < -40.594681, 33.961111, -43.967896>
      }
      triangle {
        <-39.089722, 35.064474, -43.375305>,
        <-40.309608, 34.302153, -43.443100>,
        < -39.942490, 34.662596, -42.947205>
      }
      triangle {
        <-39.089722, 35.064474, -43.375305>,
        <-39.512070, 34.784773, -43.835098>,
        < -40.309608, 34.302153, -43.443100>
      }
      triangle {
        <-38.566830, 35.324835, -42.971497>,
        <-39.942490, 34.662596, -42.947205>,
        < -39.461849, 35.035704, -42.499207>
      }
      triangle {
        <-38.566830, 35.324835, -42.971497>,
        <-39.089722, 35.064474, -43.375305>,
        < -39.942490, 34.662596, -42.947205>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-39.461849, 35.035704, -42.499207>,
        < -38.835499, 35.394903, -42.130005>
      }
      triangle {
        <-37.928169, 35.531775, -42.661697>,
        <-38.566830, 35.324835, -42.971497>,
        < -39.461849, 35.035704, -42.499207>
      }
      triangle {
        <36.666599, 35.790823, -42.018097>,
        <-36.666599, 35.790823, -42.018097>,
        < -36.666599, 35.914114, -41.491394>
      }
      triangle {
        <36.666599, 35.914114, -41.491394>,
        <36.666599, 35.790823, -42.018097>,
        < -36.666599, 35.914114, -41.491394>
      }
      triangle {
        <-39.871490, 34.079725, -46.152603>,
        <-40.809929, 33.306402, -46.441193>,
        < -40.610729, 33.628576, -45.904999>
      }
      triangle {
        <-39.871490, 34.079725, -46.152603>,
        <-40.112019, 33.810331, -46.668198>,
        < -40.809929, 33.306402, -46.441193>
      }
      triangle {
        <-39.610641, 34.329863, -45.641205>,
        <-40.610729, 33.628576, -45.904999>,
        < -40.391491, 33.928404, -45.370499>
      }
      triangle {
        <-39.610641, 34.329863, -45.641205>,
        <-39.871490, 34.079725, -46.152603>,
        < -40.610729, 33.628576, -45.904999>
      }
      triangle {
        <-39.321560, 34.566252, -45.139008>,
        <-40.391491, 33.928404, -45.370499>,
        < -40.144150, 34.216665, -44.843307>
      }
      triangle {
        <-39.321560, 34.566252, -45.139008>,
        <-39.610641, 34.329863, -45.641205>,
        < -40.391491, 33.928404, -45.370499>
      }
      triangle {
        <-38.993771, 34.791044, -44.651199>,
        <-40.144150, 34.216665, -44.843307>,
        < -39.856548, 34.500990, -44.328796>
      }
      triangle {
        <-38.993771, 34.791044, -44.651199>,
        <-39.321560, 34.566252, -45.139008>,
        < -40.144150, 34.216665, -44.843307>
      }
      triangle {
        <-38.614182, 35.001806, -44.185593>,
        <-39.856548, 34.500990, -44.328796>,
        < -39.512070, 34.784773, -43.835098>
      }
      triangle {
        <-38.614182, 35.001806, -44.185593>,
        <-38.993771, 34.791044, -44.651199>,
        < -39.856548, 34.500990, -44.328796>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-39.512070, 34.784773, -43.835098>,
        < -39.089722, 35.064474, -43.375305>
      }
      triangle {
        <-38.167641, 35.189291, -43.755005>,
        <-38.614182, 35.001806, -44.185593>,
        < -39.512070, 34.784773, -43.835098>
      }
      triangle {
        <-39.074261, 34.262526, -46.429901>,
        <-40.112019, 33.810331, -46.668198>,
        < -39.871490, 34.079725, -46.152603>
      }
      triangle {
        <-39.074261, 34.262526, -46.429901>,
        <-39.310532, 34.074133, -46.878098>,
        < -40.112019, 33.810331, -46.668198>
      }
      triangle {
        <-38.821800, 34.437094, -45.985596>,
        <-39.871490, 34.079725, -46.152603>,
        < -39.610641, 34.329863, -45.641205>
      }
      triangle {
        <-38.821800, 34.437094, -45.985596>,
        <-39.074261, 34.262526, -46.429901>,
        < -39.871490, 34.079725, -46.152603>
      }
      triangle {
        <-38.548500, 34.599173, -45.548492>,
        <-39.610641, 34.329863, -45.641205>,
        < -39.321560, 34.566252, -45.139008>
      }
      triangle {
        <-38.548500, 34.599173, -45.548492>,
        <-38.821800, 34.437094, -45.985596>,
        < -39.610641, 34.329863, -45.641205>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <38.667992, 35.470564, -42.060898>,
        < 39.285938, 35.149656, -42.375305>
      }
      triangle {
        <38.566841, 35.324835, -42.971497>,
        <39.285938, 35.149656, -42.375305>,
        < 39.772911, 34.805502, -42.767899>
      }
      triangle {
        <37.928169, 35.531775, -42.661697>,
        <39.285938, 35.149656, -42.375305>,
        < 38.566841, 35.324835, -42.971497>
      }
      triangle {
        <39.089729, 35.064474, -43.375305>,
        <39.772911, 34.805502, -42.767899>,
        < 40.152149, 34.466154, -43.209702>
      }
      triangle {
        <38.566841, 35.324835, -42.971497>,
        <39.772911, 34.805502, -42.767899>,
        < 39.089729, 35.064474, -43.375305>
      }
      triangle {
        <39.512081, 34.784773, -43.835098>,
        <40.152149, 34.466154, -43.209702>,
        < 40.449680, 34.142431, -43.682602>
      }
      triangle {
        <39.089729, 35.064474, -43.375305>,
        <40.152149, 34.466154, -43.209702>,
        < 39.512081, 34.784773, -43.835098>
      }
      triangle {
        <39.856548, 34.500990, -44.328796>,
        <40.449680, 34.142431, -43.682602>,
        < 40.688068, 33.834364, -44.174805>
      }
      triangle {
        <39.512081, 34.784773, -43.835098>,
        <40.449680, 34.142431, -43.682602>,
        < 39.856548, 34.500990, -44.328796>
      }
      triangle {
        <40.144150, 34.216650, -44.843307>,
        <40.688068, 33.834364, -44.174805>,
        < 40.884789, 33.535894, -44.678802>
      }
      triangle {
        <39.856548, 34.500990, -44.328796>,
        <40.688068, 33.834364, -44.174805>,
        < 40.144150, 34.216650, -44.843307>
      }
      triangle {
        <40.391491, 33.928404, -45.370499>,
        <40.884789, 33.535894, -44.678802>,
        < 41.052341, 33.237776, -45.189499>
      }
      triangle {
        <40.144150, 34.216650, -44.843307>,
        <40.884789, 33.535894, -44.678802>,
        < 40.391491, 33.928404, -45.370499>
      }
      triangle {
        <40.610729, 33.628576, -45.904999>,
        <41.052341, 33.237776, -45.189499>,
        < 41.199020, 32.928610, -45.702606>
      }
      triangle {
        <40.391491, 33.928404, -45.370499>,
        <41.052341, 33.237776, -45.189499>,
        < 40.610729, 33.628576, -45.904999>
      }
      triangle {
        <40.809929, 33.306402, -46.441193>,
        <41.199020, 32.928610, -45.702606>,
        < 41.329159, 32.595495, -46.213196>
      }
      triangle {
        <40.610729, 33.628576, -45.904999>,
        <41.199020, 32.928610, -45.702606>,
        < 40.809929, 33.306402, -46.441193>
      }
      triangle {
        <40.809929, 33.306402, -46.441193>,
        <41.329159, 32.595495, -46.213196>,
        < 41.443539, 32.221266, -46.716095>
      }
      triangle {
        <40.809929, 33.306402, -46.441193>,
        <41.443539, 32.221266, -46.716095>,
        < 40.994122, 32.945746, -46.973206>
      }
      triangle {
        <42.073891, 20.609694, -83.632797>,
        <40.994122, 32.945746, -46.973206>,
        < 41.443539, 32.221266, -46.716095>
      }
      triangle {
        <42.522751, 19.885874, -83.376099>,
        <42.073891, 20.609694, -83.632797>,
        < 41.443539, 32.221266, -46.716095>
      }
      triangle {
        <40.338970, 33.511221, -47.182693>,
        <39.535820, 33.867880, -47.326401>,
        < 39.310539, 34.074133, -46.878098>
      }
      triangle {
        <40.617580, 21.531775, -83.985992>,
        <39.535820, 33.867880, -47.326401>,
        < 40.338970, 33.511221, -47.182693>
      }
      triangle {
        <40.112019, 33.810331, -46.668198>,
        <39.310539, 34.074133, -46.878098>,
        < 39.074261, 34.262526, -46.429901>
      }
      triangle {
        <40.112019, 33.810331, -46.668198>,
        <40.338970, 33.511221, -47.182693>,
        < 39.310539, 34.074133, -46.878098>
      }
      triangle {
        <39.871490, 34.079733, -46.152603>,
        <39.074261, 34.262526, -46.429901>,
        < 38.821800, 34.437086, -45.985596>
      }
      triangle {
        <39.871490, 34.079733, -46.152603>,
        <40.112019, 33.810331, -46.668198>,
        < 39.074261, 34.262526, -46.429901>
      }
      triangle {
        <39.610641, 34.329863, -45.641205>,
        <38.821800, 34.437086, -45.985596>,
        < 38.548512, 34.599173, -45.548492>
      }
      triangle {
        <39.610641, 34.329863, -45.641205>,
        <39.871490, 34.079733, -46.152603>,
        < 38.821800, 34.437086, -45.985596>
      }
      triangle {
        <39.321548, 34.566252, -45.139008>,
        <39.610641, 34.329863, -45.641205>,
        < 38.548512, 34.599173, -45.548492>
      }
      triangle {
        <40.994122, 32.945746, -46.973206>,
        <40.338970, 33.511221, -47.182693>,
        < 40.112019, 33.810331, -46.668198>
      }
      triangle {
        <41.419659, 21.174894, -83.842300>,
        <40.338970, 33.511221, -47.182693>,
        < 40.994122, 32.945746, -46.973206>
      }
      triangle {
        <41.419659, 21.174894, -83.842300>,
        <40.617580, 21.531775, -83.985992>,
        < 40.338970, 33.511221, -47.182693>
      }
      triangle {
        <40.809929, 33.306402, -46.441193>,
        <40.112019, 33.810331, -46.668198>,
        < 39.871490, 34.079733, -46.152603>
      }
      triangle {
        <40.809929, 33.306402, -46.441193>,
        <40.994122, 32.945746, -46.973206>,
        < 40.112019, 33.810331, -46.668198>
      }
      triangle {
        <40.610729, 33.628576, -45.904999>,
        <39.871490, 34.079733, -46.152603>,
        < 39.610641, 34.329863, -45.641205>
      }
      triangle {
        <40.610729, 33.628576, -45.904999>,
        <40.809929, 33.306402, -46.441193>,
        < 39.871490, 34.079733, -46.152603>
      }
      triangle {
        <40.391491, 33.928404, -45.370499>,
        <39.610641, 34.329863, -45.641205>,
        < 39.321548, 34.566252, -45.139008>
      }
      triangle {
        <40.391491, 33.928404, -45.370499>,
        <40.610729, 33.628576, -45.904999>,
        < 39.610641, 34.329863, -45.641205>
      }
      triangle {
        <40.144150, 34.216650, -44.843307>,
        <39.321548, 34.566252, -45.139008>,
        < 38.993771, 34.791052, -44.651199>
      }
      triangle {
        <40.144150, 34.216650, -44.843307>,
        <40.391491, 33.928404, -45.370499>,
        < 39.321548, 34.566252, -45.139008>
      }
      triangle {
        <39.856548, 34.500990, -44.328796>,
        <38.993771, 34.791052, -44.651199>,
        < 38.614170, 35.001806, -44.185593>
      }
      triangle {
        <39.856548, 34.500990, -44.328796>,
        <40.144150, 34.216650, -44.843307>,
        < 38.993771, 34.791052, -44.651199>
      }
      triangle {
        <39.512081, 34.784773, -43.835098>,
        <38.614170, 35.001806, -44.185593>,
        < 38.167622, 35.189291, -43.755005>
      }
      triangle {
        <39.512081, 34.784773, -43.835098>,
        <39.856548, 34.500990, -44.328796>,
        < 38.614170, 35.001806, -44.185593>
      }
      triangle {
        <39.089729, 35.064474, -43.375305>,
        <39.512081, 34.784773, -43.835098>,
        < 38.167622, 35.189291, -43.755005>
      }
      triangle {
        <42.073891, 20.609694, -83.632797>,
        <41.419659, 21.174894, -83.842300>,
        < 40.994122, 32.945746, -46.973206>
      }
      triangle {
        <40.666500, 20.745302, -85.656906>,
        <40.617580, 21.531775, -83.985992>,
        < 41.419659, 21.174894, -83.842300>
      }
      triangle {
        <41.471729, 20.436564, -85.418198>,
        <41.419659, 21.174894, -83.842300>,
        < 42.073891, 20.609694, -83.632797>
      }
      triangle {
        <41.471729, 20.436564, -85.418198>,
        <40.666500, 20.745302, -85.656906>,
        < 41.419659, 21.174894, -83.842300>
      }
      triangle {
        <42.126678, 19.937533, -85.067795>,
        <42.073891, 20.609694, -83.632797>,
        < 42.522751, 19.885874, -83.376099>
      }
      triangle {
        <42.126678, 19.937533, -85.067795>,
        <41.471729, 20.436564, -85.418198>,
        < 42.073891, 20.609694, -83.632797>
      }
      triangle {
        <42.573078, 19.292593, -84.637100>,
        <42.126678, 19.937533, -85.067795>,
        < 42.522751, 19.885874, -83.376099>
      }
      triangle {
        <40.738319, 19.590014, -87.098404>,
        <40.666500, 20.745302, -85.656906>,
        < 41.471729, 20.436564, -85.418198>
      }
      triangle {
        <41.548248, 19.351004, -86.779800>,
        <41.471729, 20.436564, -85.418198>,
        < 42.126678, 19.937533, -85.067795>
      }
      triangle {
        <41.548248, 19.351004, -86.779800>,
        <40.738319, 19.590014, -87.098404>,
        < 41.471729, 20.436564, -85.418198>
      }
      triangle {
        <42.204269, 18.949244, -86.307800>,
        <42.126678, 19.937533, -85.067795>,
        < 42.573078, 19.292593, -84.637100>
      }
      triangle {
        <42.204269, 18.949244, -86.307800>,
        <41.548248, 19.351004, -86.779800>,
        < 42.126678, 19.937533, -85.067795>
      }
      triangle {
        <42.646999, 18.421091, -85.725006>,
        <42.204269, 18.949244, -86.307800>,
        < 42.573078, 19.292593, -84.637100>
      }
      triangle {
        <41.817471, 17.263033, -88.290604>,
        <40.738319, 19.590014, -87.098404>,
        < 41.548248, 19.351004, -86.779800>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <40.738319, 19.590014, -87.098404>,
        < 41.817471, 17.263033, -88.290604>
      }
      triangle {
        <42.404911, 17.050383, -87.755707>,
        <41.548248, 19.351004, -86.779800>,
        < 42.204269, 18.949244, -86.307800>
      }
      triangle {
        <41.817471, 17.263033, -88.290604>,
        <41.548248, 19.351004, -86.779800>,
        < 42.404911, 17.050383, -87.755707>
      }
      triangle {
        <42.789532, 16.765223, -87.087006>,
        <42.204269, 18.949244, -86.307800>,
        < 42.646999, 18.421091, -85.725006>
      }
      triangle {
        <42.404911, 17.050383, -87.755707>,
        <42.204269, 18.949244, -86.307800>,
        < 42.789532, 16.765223, -87.087006>
      }
      triangle {
        <42.404911, 17.050383, -87.755707>,
        <42.901871, 15.278334, -88.246201>,
        < 42.664429, 15.351355, -88.703003>
      }
      triangle {
        <42.404911, 17.050383, -87.755707>,
        <42.789532, 16.765223, -87.087006>,
        < 42.901871, 15.278334, -88.246201>
      }
      triangle {
        <41.817471, 17.263033, -88.290604>,
        <42.664429, 15.351355, -88.703003>,
        < 42.296051, 15.404684, -89.066101>
      }
      triangle {
        <41.817471, 17.263033, -88.290604>,
        <42.404911, 17.050383, -87.755707>,
        < 42.664429, 15.351355, -88.703003>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <42.296051, 15.404684, -89.066101>,
        < 41.832581, 15.433134, -89.300095>
      }
      triangle {
        <41.083038, 17.382963, -88.640793>,
        <41.817471, 17.263033, -88.290604>,
        < 42.296051, 15.404684, -89.066101>
      }
      texture{_all}
    }
    // _all_headlgts
    mesh {
      triangle {
        <-20.372931, 4.345305, 88.500000>,
        <-20.372931, -2.411959, 88.500000>,
        < -22.000000, -2.783327, 88.500000>
      }
      triangle {
        <-22.000000, -2.783327, 89.727259>,
        <-22.000000, -2.783327, 88.500000>,
        < -20.372931, -2.411959, 88.500000>
      }
      triangle {
        <-22.000000, 4.716673, 88.500000>,
        <-20.372931, 4.345305, 88.500000>,
        < -22.000000, -2.783327, 88.500000>
      }
      triangle {
        <-23.627069, -2.411959, 88.500000>,
        <-22.000000, 4.716673, 88.500000>,
        < -22.000000, -2.783327, 88.500000>
      }
      triangle {
        <-23.627060, -2.411959, 89.727259>,
        <-23.627069, -2.411959, 88.500000>,
        < -22.000000, -2.783327, 88.500000>
      }
      triangle {
        <-22.000000, -2.783327, 89.727259>,
        <-23.627060, -2.411959, 89.727259>,
        < -22.000000, -2.783327, 88.500000>
      }
      triangle {
        <-20.372931, 4.345305, 88.500000>,
        <-19.068130, -1.371416, 88.500000>,
        < -20.372931, -2.411959, 88.500000>
      }
      triangle {
        <-20.372940, -2.411959, 89.727259>,
        <-20.372931, -2.411959, 88.500000>,
        < -19.068130, -1.371416, 88.500000>
      }
      triangle {
        <-20.372940, -2.411959, 89.727259>,
        <-22.000000, -2.783327, 89.727259>,
        < -20.372931, -2.411959, 88.500000>
      }
      triangle {
        <-19.068130, 3.304762, 88.500000>,
        <-18.344021, 0.132212, 88.500000>,
        < -19.068130, -1.371416, 88.500000>
      }
      triangle {
        <-19.068130, -1.371416, 89.727259>,
        <-19.068130, -1.371416, 88.500000>,
        < -18.344021, 0.132212, 88.500000>
      }
      triangle {
        <-20.372931, 4.345305, 88.500000>,
        <-19.068130, 3.304762, 88.500000>,
        < -19.068130, -1.371416, 88.500000>
      }
      triangle {
        <-19.068130, -1.371416, 89.727259>,
        <-20.372940, -2.411959, 89.727259>,
        < -19.068130, -1.371416, 88.500000>
      }
      triangle {
        <-19.068130, 3.304762, 88.500000>,
        <-18.344021, 1.801134, 88.500000>,
        < -18.344021, 0.132212, 88.500000>
      }
      triangle {
        <-18.344021, 0.132223, 89.727259>,
        <-18.344021, 0.132212, 88.500000>,
        < -18.344021, 1.801134, 88.500000>
      }
      triangle {
        <-18.344021, 0.132223, 89.727259>,
        <-19.068130, -1.371416, 89.727259>,
        < -18.344021, 0.132212, 88.500000>
      }
      triangle {
        <-19.068130, 3.304762, 89.727259>,
        <-18.344021, 1.801134, 88.500000>,
        < -19.068130, 3.304762, 88.500000>
      }
      triangle {
        <-18.344021, 1.801123, 89.727259>,
        <-18.344021, 0.132223, 89.727259>,
        < -18.344021, 1.801134, 88.500000>
      }
      triangle {
        <-19.068130, 3.304762, 89.727259>,
        <-18.344021, 1.801123, 89.727259>,
        < -18.344021, 1.801134, 88.500000>
      }
      triangle {
        <-19.068130, 3.304762, 89.727259>,
        <-19.068130, 3.304762, 88.500000>,
        < -20.372931, 4.345305, 88.500000>
      }
      triangle {
        <-20.372940, 4.345305, 89.727259>,
        <-20.372931, 4.345305, 88.500000>,
        < -22.000000, 4.716673, 88.500000>
      }
      triangle {
        <-20.372940, 4.345305, 89.727259>,
        <-19.068130, 3.304762, 89.727259>,
        < -20.372931, 4.345305, 88.500000>
      }
      triangle {
        <-23.627069, -2.411959, 88.500000>,
        <-23.627069, 4.345305, 88.500000>,
        < -22.000000, 4.716673, 88.500000>
      }
      triangle {
        <-22.000000, 4.716673, 89.727259>,
        <-22.000000, 4.716673, 88.500000>,
        < -23.627069, 4.345305, 88.500000>
      }
      triangle {
        <-20.372940, 4.345305, 89.727259>,
        <-22.000000, 4.716673, 88.500000>,
        < -22.000000, 4.716673, 89.727259>
      }
      triangle {
        <-24.931870, -1.371416, 88.500000>,
        <-24.931870, 3.304762, 88.500000>,
        < -23.627069, 4.345305, 88.500000>
      }
      triangle {
        <-23.627060, 4.345305, 89.727259>,
        <-23.627069, 4.345305, 88.500000>,
        < -24.931870, 3.304762, 88.500000>
      }
      triangle {
        <-23.627069, -2.411959, 88.500000>,
        <-24.931870, -1.371416, 88.500000>,
        < -23.627069, 4.345305, 88.500000>
      }
      triangle {
        <-23.627060, 4.345305, 89.727259>,
        <-22.000000, 4.716673, 89.727259>,
        < -23.627069, 4.345305, 88.500000>
      }
      triangle {
        <-25.655979, 0.132212, 88.500000>,
        <-25.655979, 1.801134, 88.500000>,
        < -24.931870, 3.304762, 88.500000>
      }
      triangle {
        <-24.931870, 3.304762, 89.727259>,
        <-24.931870, 3.304762, 88.500000>,
        < -25.655979, 1.801134, 88.500000>
      }
      triangle {
        <-24.931870, -1.371416, 88.500000>,
        <-25.655979, 0.132212, 88.500000>,
        < -24.931870, 3.304762, 88.500000>
      }
      triangle {
        <-24.931870, 3.304762, 89.727259>,
        <-23.627060, 4.345305, 89.727259>,
        < -24.931870, 3.304762, 88.500000>
      }
      triangle {
        <-25.655979, 0.132223, 89.727259>,
        <-25.655979, 1.801134, 88.500000>,
        < -25.655979, 0.132212, 88.500000>
      }
      triangle {
        <-25.655979, 1.801123, 89.727259>,
        <-24.931870, 3.304762, 89.727259>,
        < -25.655979, 1.801134, 88.500000>
      }
      triangle {
        <-25.655979, 0.132223, 89.727259>,
        <-25.655979, 1.801123, 89.727259>,
        < -25.655979, 1.801134, 88.500000>
      }
      triangle {
        <-24.931870, -1.371416, 89.727259>,
        <-25.655979, 0.132212, 88.500000>,
        < -24.931870, -1.371416, 88.500000>
      }
      triangle {
        <-24.931870, -1.371416, 89.727259>,
        <-25.655979, 0.132223, 89.727259>,
        < -25.655979, 0.132212, 88.500000>
      }
      triangle {
        <-24.931870, -1.371416, 89.727259>,
        <-24.931870, -1.371416, 88.500000>,
        < -23.627069, -2.411959, 88.500000>
      }
      triangle {
        <-23.627060, -2.411959, 89.727259>,
        <-24.931870, -1.371416, 89.727259>,
        < -23.627069, -2.411959, 88.500000>
      }
      triangle {
        <-22.000000, 4.598555, 90.050008>,
        <-22.000000, 4.716673, 89.727259>,
        < -23.627060, 4.345305, 89.727259>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-20.372940, 4.345305, 89.727259>,
        < -22.000000, 4.716673, 89.727259>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-22.000000, 4.716673, 89.727259>,
        < -22.000000, 4.598555, 90.050008>
      }
      triangle {
        <-23.575809, 4.238882, 90.050008>,
        <-23.627060, 4.345305, 89.727259>,
        < -24.931870, 3.304762, 89.727259>
      }
      triangle {
        <-23.575809, 4.238882, 90.050008>,
        <-22.000000, 4.598555, 90.050008>,
        < -23.627060, 4.345305, 89.727259>
      }
      triangle {
        <-24.839520, 3.231112, 90.050008>,
        <-24.931870, 3.304762, 89.727259>,
        < -25.655979, 1.801123, 89.727259>
      }
      triangle {
        <-24.839520, 3.231112, 90.050008>,
        <-23.575809, 4.238882, 90.050008>,
        < -24.931870, 3.304762, 89.727259>
      }
      triangle {
        <-25.540819, 1.774843, 90.050008>,
        <-25.655979, 1.801123, 89.727259>,
        < -25.655979, 0.132223, 89.727259>
      }
      triangle {
        <-25.540819, 1.774843, 90.050008>,
        <-24.839520, 3.231112, 90.050008>,
        < -25.655979, 1.801123, 89.727259>
      }
      triangle {
        <-25.540819, 0.158503, 90.050008>,
        <-25.655979, 0.132223, 89.727259>,
        < -24.931870, -1.371416, 89.727259>
      }
      triangle {
        <-25.540819, 0.158503, 90.050008>,
        <-25.540819, 1.774843, 90.050008>,
        < -25.655979, 0.132223, 89.727259>
      }
      triangle {
        <-24.839520, -1.297766, 90.050008>,
        <-24.931870, -1.371416, 89.727259>,
        < -23.627060, -2.411959, 89.727259>
      }
      triangle {
        <-24.839520, -1.297766, 90.050008>,
        <-25.540819, 0.158503, 90.050008>,
        < -24.931870, -1.371416, 89.727259>
      }
      triangle {
        <-23.575809, -2.305536, 90.050008>,
        <-23.627060, -2.411959, 89.727259>,
        < -22.000000, -2.783327, 89.727259>
      }
      triangle {
        <-23.575809, -2.305536, 90.050008>,
        <-24.839520, -1.297766, 90.050008>,
        < -23.627060, -2.411959, 89.727259>
      }
      triangle {
        <-22.000000, -2.665209, 90.050008>,
        <-22.000000, -2.783327, 89.727259>,
        < -20.372940, -2.411959, 89.727259>
      }
      triangle {
        <-22.000000, -2.665209, 90.050008>,
        <-23.575809, -2.305536, 90.050008>,
        < -22.000000, -2.783327, 89.727259>
      }
      triangle {
        <-22.000000, -2.366655, 90.220266>,
        <-22.000000, -0.705858, 90.429944>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-20.553720, -2.036558, 90.220266>,
        <-22.000000, 0.966673, 90.500000>,
        < -22.000000, -0.705858, 90.429944>
      }
      triangle {
        <-23.446280, -2.036558, 90.220266>,
        <-22.000000, -2.366655, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-24.606100, -1.111627, 90.220266>,
        <-23.446280, -2.036558, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-25.249760, 0.224932, 90.220266>,
        <-24.606100, -1.111627, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-25.249760, 1.708414, 90.220266>,
        <-25.249760, 0.224932, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-24.606100, 3.044973, 90.220266>,
        <-25.249760, 1.708414, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-23.446280, 3.969904, 90.220266>,
        <-24.606100, 3.044973, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-22.000000, 2.639204, 90.429944>,
        <-23.446280, 3.969904, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-22.000000, 2.639204, 90.429944>,
        <-22.000000, 0.966673, 90.500000>,
        < -22.000000, 4.300001, 90.220266>
      }
      triangle {
        <-20.553720, 3.969904, 90.220266>,
        <-22.000000, 4.300001, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-19.393900, 3.044973, 90.220266>,
        <-20.553720, 3.969904, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-18.750240, 1.708414, 90.220266>,
        <-19.393900, 3.044973, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-18.750240, 0.224932, 90.220266>,
        <-18.750240, 1.708414, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-19.393900, -1.111627, 90.220266>,
        <-18.750240, 0.224932, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-20.553720, -2.036558, 90.220266>,
        <-19.393900, -1.111627, 90.220266>,
        < -22.000000, 0.966673, 90.500000>
      }
      triangle {
        <-20.553720, -2.036558, 90.220266>,
        <-22.000000, -0.705858, 90.429944>,
        < -22.000000, -2.366655, 90.220266>
      }
      triangle {
        <-22.000000, -2.665209, 90.050008>,
        <-22.000000, -2.366655, 90.220266>,
        < -23.446280, -2.036558, 90.220266>
      }
      triangle {
        <-20.424191, -2.305536, 90.050008>,
        <-20.553720, -2.036558, 90.220266>,
        < -22.000000, -2.366655, 90.220266>
      }
      triangle {
        <-20.424191, -2.305536, 90.050008>,
        <-22.000000, -2.366655, 90.220266>,
        < -22.000000, -2.665209, 90.050008>
      }
      triangle {
        <-23.575809, -2.305536, 90.050008>,
        <-23.446280, -2.036558, 90.220266>,
        < -24.606100, -1.111627, 90.220266>
      }
      triangle {
        <-22.000000, -2.665209, 90.050008>,
        <-23.446280, -2.036558, 90.220266>,
        < -23.575809, -2.305536, 90.050008>
      }
      triangle {
        <-24.839520, -1.297766, 90.050008>,
        <-24.606100, -1.111627, 90.220266>,
        < -25.249760, 0.224932, 90.220266>
      }
      triangle {
        <-23.575809, -2.305536, 90.050008>,
        <-24.606100, -1.111627, 90.220266>,
        < -24.839520, -1.297766, 90.050008>
      }
      triangle {
        <-25.540819, 0.158503, 90.050008>,
        <-25.249760, 0.224932, 90.220266>,
        < -25.249760, 1.708414, 90.220266>
      }
      triangle {
        <-24.839520, -1.297766, 90.050008>,
        <-25.249760, 0.224932, 90.220266>,
        < -25.540819, 0.158503, 90.050008>
      }
      triangle {
        <-25.540819, 1.774843, 90.050008>,
        <-25.249760, 1.708414, 90.220266>,
        < -24.606100, 3.044973, 90.220266>
      }
      triangle {
        <-25.540819, 0.158503, 90.050008>,
        <-25.249760, 1.708414, 90.220266>,
        < -25.540819, 1.774843, 90.050008>
      }
      triangle {
        <-24.839520, 3.231112, 90.050008>,
        <-24.606100, 3.044973, 90.220266>,
        < -23.446280, 3.969904, 90.220266>
      }
      triangle {
        <-25.540819, 1.774843, 90.050008>,
        <-24.606100, 3.044973, 90.220266>,
        < -24.839520, 3.231112, 90.050008>
      }
      triangle {
        <-22.000000, 2.639204, 90.429944>,
        <-22.000000, 4.300001, 90.220266>,
        < -23.446280, 3.969904, 90.220266>
      }
      triangle {
        <-23.575809, 4.238882, 90.050008>,
        <-23.446280, 3.969904, 90.220266>,
        < -22.000000, 4.300001, 90.220266>
      }
      triangle {
        <-24.839520, 3.231112, 90.050008>,
        <-23.446280, 3.969904, 90.220266>,
        < -23.575809, 4.238882, 90.050008>
      }
      triangle {
        <-22.000000, 4.598555, 90.050008>,
        <-22.000000, 4.300001, 90.220266>,
        < -20.553720, 3.969904, 90.220266>
      }
      triangle {
        <-23.575809, 4.238882, 90.050008>,
        <-22.000000, 4.300001, 90.220266>,
        < -22.000000, 4.598555, 90.050008>
      }
      triangle {
        <-20.424191, -2.305536, 90.050008>,
        <-20.372940, -2.411959, 89.727259>,
        < -19.068130, -1.371416, 89.727259>
      }
      triangle {
        <-20.424191, -2.305536, 90.050008>,
        <-22.000000, -2.665209, 90.050008>,
        < -20.372940, -2.411959, 89.727259>
      }
      triangle {
        <-19.160480, -1.297766, 90.050008>,
        <-19.068130, -1.371416, 89.727259>,
        < -18.344021, 0.132223, 89.727259>
      }
      triangle {
        <-19.160480, -1.297766, 90.050008>,
        <-20.424191, -2.305536, 90.050008>,
        < -19.068130, -1.371416, 89.727259>
      }
      triangle {
        <-18.459181, 0.158503, 90.050008>,
        <-18.344021, 0.132223, 89.727259>,
        < -18.344021, 1.801123, 89.727259>
      }
      triangle {
        <-18.459181, 0.158503, 90.050008>,
        <-19.160480, -1.297766, 90.050008>,
        < -18.344021, 0.132223, 89.727259>
      }
      triangle {
        <-18.459181, 1.774843, 90.050008>,
        <-18.344021, 1.801123, 89.727259>,
        < -19.068130, 3.304762, 89.727259>
      }
      triangle {
        <-18.459181, 1.774843, 90.050008>,
        <-18.459181, 0.158503, 90.050008>,
        < -18.344021, 1.801123, 89.727259>
      }
      triangle {
        <-19.160480, 3.231112, 90.050008>,
        <-19.068130, 3.304762, 89.727259>,
        < -20.372940, 4.345305, 89.727259>
      }
      triangle {
        <-19.160480, 3.231112, 90.050008>,
        <-18.459181, 1.774843, 90.050008>,
        < -19.068130, 3.304762, 89.727259>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-19.160480, 3.231112, 90.050008>,
        < -20.372940, 4.345305, 89.727259>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-20.553720, 3.969904, 90.220266>,
        < -19.393900, 3.044973, 90.220266>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-22.000000, 4.598555, 90.050008>,
        < -20.553720, 3.969904, 90.220266>
      }
      triangle {
        <-19.160480, 3.231112, 90.050008>,
        <-19.393900, 3.044973, 90.220266>,
        < -18.750240, 1.708414, 90.220266>
      }
      triangle {
        <-20.424191, 4.238882, 90.050008>,
        <-19.393900, 3.044973, 90.220266>,
        < -19.160480, 3.231112, 90.050008>
      }
      triangle {
        <-18.459181, 1.774843, 90.050008>,
        <-18.750240, 1.708414, 90.220266>,
        < -18.750240, 0.224932, 90.220266>
      }
      triangle {
        <-19.160480, 3.231112, 90.050008>,
        <-18.750240, 1.708414, 90.220266>,
        < -18.459181, 1.774843, 90.050008>
      }
      triangle {
        <-18.459181, 0.158503, 90.050008>,
        <-18.750240, 0.224932, 90.220266>,
        < -19.393900, -1.111627, 90.220266>
      }
      triangle {
        <-18.459181, 1.774843, 90.050008>,
        <-18.750240, 0.224932, 90.220266>,
        < -18.459181, 0.158503, 90.050008>
      }
      triangle {
        <-19.160480, -1.297766, 90.050008>,
        <-19.393900, -1.111627, 90.220266>,
        < -20.553720, -2.036558, 90.220266>
      }
      triangle {
        <-18.459181, 0.158503, 90.050008>,
        <-19.393900, -1.111627, 90.220266>,
        < -19.160480, -1.297766, 90.050008>
      }
      triangle {
        <-19.160480, -1.297766, 90.050008>,
        <-20.553720, -2.036558, 90.220266>,
        < -20.424191, -2.305536, 90.050008>
      }
      triangle {
        <23.627069, 4.345305, 88.500000>,
        <23.627069, -2.411959, 88.500000>,
        < 22.000000, -2.783327, 88.500000>
      }
      triangle {
        <22.000000, -2.783327, 89.727259>,
        <22.000000, -2.783327, 88.500000>,
        < 23.627069, -2.411959, 88.500000>
      }
      triangle {
        <22.000000, 4.716673, 88.500000>,
        <23.627069, 4.345305, 88.500000>,
        < 22.000000, -2.783327, 88.500000>
      }
      triangle {
        <20.372931, -2.411959, 88.500000>,
        <22.000000, 4.716673, 88.500000>,
        < 22.000000, -2.783327, 88.500000>
      }
      triangle {
        <20.372940, -2.411959, 89.727259>,
        <20.372931, -2.411959, 88.500000>,
        < 22.000000, -2.783327, 88.500000>
      }
      triangle {
        <22.000000, -2.783327, 89.727259>,
        <20.372940, -2.411959, 89.727259>,
        < 22.000000, -2.783327, 88.500000>
      }
      triangle {
        <23.627069, 4.345305, 88.500000>,
        <24.931870, -1.371416, 88.500000>,
        < 23.627069, -2.411959, 88.500000>
      }
      triangle {
        <23.627060, -2.411959, 89.727259>,
        <23.627069, -2.411959, 88.500000>,
        < 24.931870, -1.371416, 88.500000>
      }
      triangle {
        <23.627060, -2.411959, 89.727259>,
        <22.000000, -2.783327, 89.727259>,
        < 23.627069, -2.411959, 88.500000>
      }
      triangle {
        <24.931870, 3.304762, 88.500000>,
        <25.655979, 0.132212, 88.500000>,
        < 24.931870, -1.371416, 88.500000>
      }
      triangle {
        <24.931870, -1.371416, 89.727259>,
        <24.931870, -1.371416, 88.500000>,
        < 25.655979, 0.132212, 88.500000>
      }
      triangle {
        <23.627069, 4.345305, 88.500000>,
        <24.931870, 3.304762, 88.500000>,
        < 24.931870, -1.371416, 88.500000>
      }
      triangle {
        <24.931870, -1.371416, 89.727259>,
        <23.627060, -2.411959, 89.727259>,
        < 24.931870, -1.371416, 88.500000>
      }
      triangle {
        <24.931870, 3.304762, 88.500000>,
        <25.655979, 1.801134, 88.500000>,
        < 25.655979, 0.132212, 88.500000>
      }
      triangle {
        <25.655979, 0.132223, 89.727259>,
        <25.655979, 0.132212, 88.500000>,
        < 25.655979, 1.801134, 88.500000>
      }
      triangle {
        <25.655979, 0.132223, 89.727259>,
        <24.931870, -1.371416, 89.727259>,
        < 25.655979, 0.132212, 88.500000>
      }
      triangle {
        <24.931870, 3.304762, 89.727259>,
        <25.655979, 1.801134, 88.500000>,
        < 24.931870, 3.304762, 88.500000>
      }
      triangle {
        <25.655979, 1.801123, 89.727259>,
        <25.655979, 0.132223, 89.727259>,
        < 25.655979, 1.801134, 88.500000>
      }
      triangle {
        <24.931870, 3.304762, 89.727259>,
        <25.655979, 1.801123, 89.727259>,
        < 25.655979, 1.801134, 88.500000>
      }
      triangle {
        <24.931870, 3.304762, 89.727259>,
        <24.931870, 3.304762, 88.500000>,
        < 23.627069, 4.345305, 88.500000>
      }
      triangle {
        <23.627060, 4.345305, 89.727259>,
        <23.627069, 4.345305, 88.500000>,
        < 22.000000, 4.716673, 88.500000>
      }
      triangle {
        <23.627060, 4.345305, 89.727259>,
        <24.931870, 3.304762, 89.727259>,
        < 23.627069, 4.345305, 88.500000>
      }
      triangle {
        <20.372931, -2.411959, 88.500000>,
        <20.372931, 4.345305, 88.500000>,
        < 22.000000, 4.716673, 88.500000>
      }
      triangle {
        <22.000000, 4.716673, 89.727259>,
        <22.000000, 4.716673, 88.500000>,
        < 20.372931, 4.345305, 88.500000>
      }
      triangle {
        <23.627060, 4.345305, 89.727259>,
        <22.000000, 4.716673, 88.500000>,
        < 22.000000, 4.716673, 89.727259>
      }
      triangle {
        <19.068130, -1.371416, 88.500000>,
        <19.068130, 3.304762, 88.500000>,
        < 20.372931, 4.345305, 88.500000>
      }
      triangle {
        <20.372940, 4.345305, 89.727259>,
        <20.372931, 4.345305, 88.500000>,
        < 19.068130, 3.304762, 88.500000>
      }
      triangle {
        <20.372931, -2.411959, 88.500000>,
        <19.068130, -1.371416, 88.500000>,
        < 20.372931, 4.345305, 88.500000>
      }
      triangle {
        <20.372940, 4.345305, 89.727259>,
        <22.000000, 4.716673, 89.727259>,
        < 20.372931, 4.345305, 88.500000>
      }
      triangle {
        <18.344021, 0.132212, 88.500000>,
        <18.344021, 1.801134, 88.500000>,
        < 19.068130, 3.304762, 88.500000>
      }
      triangle {
        <19.068130, 3.304762, 89.727259>,
        <19.068130, 3.304762, 88.500000>,
        < 18.344021, 1.801134, 88.500000>
      }
      triangle {
        <19.068130, -1.371416, 88.500000>,
        <18.344021, 0.132212, 88.500000>,
        < 19.068130, 3.304762, 88.500000>
      }
      triangle {
        <19.068130, 3.304762, 89.727259>,
        <20.372940, 4.345305, 89.727259>,
        < 19.068130, 3.304762, 88.500000>
      }
      triangle {
        <18.344021, 0.132223, 89.727259>,
        <18.344021, 1.801134, 88.500000>,
        < 18.344021, 0.132212, 88.500000>
      }
      triangle {
        <18.344021, 1.801123, 89.727259>,
        <19.068130, 3.304762, 89.727259>,
        < 18.344021, 1.801134, 88.500000>
      }
      triangle {
        <18.344021, 0.132223, 89.727259>,
        <18.344021, 1.801123, 89.727259>,
        < 18.344021, 1.801134, 88.500000>
      }
      triangle {
        <19.068130, -1.371416, 89.727259>,
        <18.344021, 0.132212, 88.500000>,
        < 19.068130, -1.371416, 88.500000>
      }
      triangle {
        <19.068130, -1.371416, 89.727259>,
        <18.344021, 0.132223, 89.727259>,
        < 18.344021, 0.132212, 88.500000>
      }
      triangle {
        <19.068130, -1.371416, 89.727259>,
        <19.068130, -1.371416, 88.500000>,
        < 20.372931, -2.411959, 88.500000>
      }
      triangle {
        <20.372940, -2.411959, 89.727259>,
        <19.068130, -1.371416, 89.727259>,
        < 20.372931, -2.411959, 88.500000>
      }
      triangle {
        <22.000000, 4.598555, 90.050008>,
        <22.000000, 4.716673, 89.727259>,
        < 20.372940, 4.345305, 89.727259>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <23.627060, 4.345305, 89.727259>,
        < 22.000000, 4.716673, 89.727259>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <22.000000, 4.716673, 89.727259>,
        < 22.000000, 4.598555, 90.050008>
      }
      triangle {
        <20.424191, 4.238882, 90.050008>,
        <20.372940, 4.345305, 89.727259>,
        < 19.068130, 3.304762, 89.727259>
      }
      triangle {
        <20.424191, 4.238882, 90.050008>,
        <22.000000, 4.598555, 90.050008>,
        < 20.372940, 4.345305, 89.727259>
      }
      triangle {
        <19.160480, 3.231112, 90.050008>,
        <19.068130, 3.304762, 89.727259>,
        < 18.344021, 1.801123, 89.727259>
      }
      triangle {
        <19.160480, 3.231112, 90.050008>,
        <20.424191, 4.238882, 90.050008>,
        < 19.068130, 3.304762, 89.727259>
      }
      triangle {
        <18.459181, 1.774843, 90.050008>,
        <18.344021, 1.801123, 89.727259>,
        < 18.344021, 0.132223, 89.727259>
      }
      triangle {
        <18.459181, 1.774843, 90.050008>,
        <19.160480, 3.231112, 90.050008>,
        < 18.344021, 1.801123, 89.727259>
      }
      triangle {
        <18.459181, 0.158503, 90.050008>,
        <18.344021, 0.132223, 89.727259>,
        < 19.068130, -1.371416, 89.727259>
      }
      triangle {
        <18.459181, 0.158503, 90.050008>,
        <18.459181, 1.774843, 90.050008>,
        < 18.344021, 0.132223, 89.727259>
      }
      triangle {
        <19.160480, -1.297766, 90.050008>,
        <19.068130, -1.371416, 89.727259>,
        < 20.372940, -2.411959, 89.727259>
      }
      triangle {
        <19.160480, -1.297766, 90.050008>,
        <18.459181, 0.158503, 90.050008>,
        < 19.068130, -1.371416, 89.727259>
      }
      triangle {
        <20.424191, -2.305536, 90.050008>,
        <20.372940, -2.411959, 89.727259>,
        < 22.000000, -2.783327, 89.727259>
      }
      triangle {
        <20.424191, -2.305536, 90.050008>,
        <19.160480, -1.297766, 90.050008>,
        < 20.372940, -2.411959, 89.727259>
      }
      triangle {
        <22.000000, -2.665209, 90.050008>,
        <22.000000, -2.783327, 89.727259>,
        < 23.627060, -2.411959, 89.727259>
      }
      triangle {
        <22.000000, -2.665209, 90.050008>,
        <20.424191, -2.305536, 90.050008>,
        < 22.000000, -2.783327, 89.727259>
      }
      triangle {
        <22.000000, -2.366655, 90.220266>,
        <22.000000, -0.705858, 90.429944>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <23.446280, -2.036558, 90.220266>,
        <22.000000, 0.966673, 90.500000>,
        < 22.000000, -0.705858, 90.429944>
      }
      triangle {
        <20.553720, -2.036558, 90.220266>,
        <22.000000, -2.366655, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <19.393900, -1.111627, 90.220266>,
        <20.553720, -2.036558, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <18.750240, 0.224932, 90.220266>,
        <19.393900, -1.111627, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <18.750240, 1.708414, 90.220266>,
        <18.750240, 0.224932, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <19.393900, 3.044973, 90.220266>,
        <18.750240, 1.708414, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <20.553720, 3.969904, 90.220266>,
        <19.393900, 3.044973, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <22.000000, 2.639204, 90.429944>,
        <20.553720, 3.969904, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <22.000000, 2.639204, 90.429944>,
        <22.000000, 0.966673, 90.500000>,
        < 22.000000, 4.300001, 90.220266>
      }
      triangle {
        <23.446280, 3.969904, 90.220266>,
        <22.000000, 4.300001, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <24.606100, 3.044973, 90.220266>,
        <23.446280, 3.969904, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <25.249760, 1.708414, 90.220266>,
        <24.606100, 3.044973, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <25.249760, 0.224932, 90.220266>,
        <25.249760, 1.708414, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <24.606100, -1.111627, 90.220266>,
        <25.249760, 0.224932, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <23.446280, -2.036558, 90.220266>,
        <24.606100, -1.111627, 90.220266>,
        < 22.000000, 0.966673, 90.500000>
      }
      triangle {
        <23.446280, -2.036558, 90.220266>,
        <22.000000, -0.705858, 90.429944>,
        < 22.000000, -2.366655, 90.220266>
      }
      triangle {
        <22.000000, -2.665209, 90.050008>,
        <22.000000, -2.366655, 90.220266>,
        < 20.553720, -2.036558, 90.220266>
      }
      triangle {
        <23.575809, -2.305536, 90.050008>,
        <23.446280, -2.036558, 90.220266>,
        < 22.000000, -2.366655, 90.220266>
      }
      triangle {
        <23.575809, -2.305536, 90.050008>,
        <22.000000, -2.366655, 90.220266>,
        < 22.000000, -2.665209, 90.050008>
      }
      triangle {
        <20.424191, -2.305536, 90.050008>,
        <20.553720, -2.036558, 90.220266>,
        < 19.393900, -1.111627, 90.220266>
      }
      triangle {
        <22.000000, -2.665209, 90.050008>,
        <20.553720, -2.036558, 90.220266>,
        < 20.424191, -2.305536, 90.050008>
      }
      triangle {
        <19.160480, -1.297766, 90.050008>,
        <19.393900, -1.111627, 90.220266>,
        < 18.750240, 0.224932, 90.220266>
      }
      triangle {
        <20.424191, -2.305536, 90.050008>,
        <19.393900, -1.111627, 90.220266>,
        < 19.160480, -1.297766, 90.050008>
      }
      triangle {
        <18.459181, 0.158503, 90.050008>,
        <18.750240, 0.224932, 90.220266>,
        < 18.750240, 1.708414, 90.220266>
      }
      triangle {
        <19.160480, -1.297766, 90.050008>,
        <18.750240, 0.224932, 90.220266>,
        < 18.459181, 0.158503, 90.050008>
      }
      triangle {
        <18.459181, 1.774843, 90.050008>,
        <18.750240, 1.708414, 90.220266>,
        < 19.393900, 3.044973, 90.220266>
      }
      triangle {
        <18.459181, 0.158503, 90.050008>,
        <18.750240, 1.708414, 90.220266>,
        < 18.459181, 1.774843, 90.050008>
      }
      triangle {
        <19.160480, 3.231112, 90.050008>,
        <19.393900, 3.044973, 90.220266>,
        < 20.553720, 3.969904, 90.220266>
      }
      triangle {
        <18.459181, 1.774843, 90.050008>,
        <19.393900, 3.044973, 90.220266>,
        < 19.160480, 3.231112, 90.050008>
      }
      triangle {
        <22.000000, 2.639204, 90.429944>,
        <22.000000, 4.300001, 90.220266>,
        < 20.553720, 3.969904, 90.220266>
      }
      triangle {
        <20.424191, 4.238882, 90.050008>,
        <20.553720, 3.969904, 90.220266>,
        < 22.000000, 4.300001, 90.220266>
      }
      triangle {
        <19.160480, 3.231112, 90.050008>,
        <20.553720, 3.969904, 90.220266>,
        < 20.424191, 4.238882, 90.050008>
      }
      triangle {
        <22.000000, 4.598555, 90.050008>,
        <22.000000, 4.300001, 90.220266>,
        < 23.446280, 3.969904, 90.220266>
      }
      triangle {
        <20.424191, 4.238882, 90.050008>,
        <22.000000, 4.300001, 90.220266>,
        < 22.000000, 4.598555, 90.050008>
      }
      triangle {
        <23.575809, -2.305536, 90.050008>,
        <23.627060, -2.411959, 89.727259>,
        < 24.931870, -1.371416, 89.727259>
      }
      triangle {
        <23.575809, -2.305536, 90.050008>,
        <22.000000, -2.665209, 90.050008>,
        < 23.627060, -2.411959, 89.727259>
      }
      triangle {
        <24.839520, -1.297766, 90.050008>,
        <24.931870, -1.371416, 89.727259>,
        < 25.655979, 0.132223, 89.727259>
      }
      triangle {
        <24.839520, -1.297766, 90.050008>,
        <23.575809, -2.305536, 90.050008>,
        < 24.931870, -1.371416, 89.727259>
      }
      triangle {
        <25.540819, 0.158503, 90.050008>,
        <25.655979, 0.132223, 89.727259>,
        < 25.655979, 1.801123, 89.727259>
      }
      triangle {
        <25.540819, 0.158503, 90.050008>,
        <24.839520, -1.297766, 90.050008>,
        < 25.655979, 0.132223, 89.727259>
      }
      triangle {
        <25.540819, 1.774843, 90.050008>,
        <25.655979, 1.801123, 89.727259>,
        < 24.931870, 3.304762, 89.727259>
      }
      triangle {
        <25.540819, 1.774843, 90.050008>,
        <25.540819, 0.158503, 90.050008>,
        < 25.655979, 1.801123, 89.727259>
      }
      triangle {
        <24.839520, 3.231112, 90.050008>,
        <24.931870, 3.304762, 89.727259>,
        < 23.627060, 4.345305, 89.727259>
      }
      triangle {
        <24.839520, 3.231112, 90.050008>,
        <25.540819, 1.774843, 90.050008>,
        < 24.931870, 3.304762, 89.727259>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <24.839520, 3.231112, 90.050008>,
        < 23.627060, 4.345305, 89.727259>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <23.446280, 3.969904, 90.220266>,
        < 24.606100, 3.044973, 90.220266>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <22.000000, 4.598555, 90.050008>,
        < 23.446280, 3.969904, 90.220266>
      }
      triangle {
        <24.839520, 3.231112, 90.050008>,
        <24.606100, 3.044973, 90.220266>,
        < 25.249760, 1.708414, 90.220266>
      }
      triangle {
        <23.575809, 4.238882, 90.050008>,
        <24.606100, 3.044973, 90.220266>,
        < 24.839520, 3.231112, 90.050008>
      }
      triangle {
        <25.540819, 1.774843, 90.050008>,
        <25.249760, 1.708414, 90.220266>,
        < 25.249760, 0.224932, 90.220266>
      }
      triangle {
        <24.839520, 3.231112, 90.050008>,
        <25.249760, 1.708414, 90.220266>,
        < 25.540819, 1.774843, 90.050008>
      }
      triangle {
        <25.540819, 0.158503, 90.050008>,
        <25.249760, 0.224932, 90.220266>,
        < 24.606100, -1.111627, 90.220266>
      }
      triangle {
        <25.540819, 1.774843, 90.050008>,
        <25.249760, 0.224932, 90.220266>,
        < 25.540819, 0.158503, 90.050008>
      }
      triangle {
        <24.839520, -1.297766, 90.050008>,
        <24.606100, -1.111627, 90.220266>,
        < 23.446280, -2.036558, 90.220266>
      }
      triangle {
        <25.540819, 0.158503, 90.050008>,
        <24.606100, -1.111627, 90.220266>,
        < 24.839520, -1.297766, 90.050008>
      }
      triangle {
        <24.839520, -1.297766, 90.050008>,
        <23.446280, -2.036558, 90.220266>,
        < 23.575809, -2.305536, 90.050008>
      }
      texture{_all_headlgts}
    }
    // _all_windows
    mesh {
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <1.500000, 33.966673, 33.000000>,
        < 1.500000, 16.066671, 33.000000>
      }
      triangle {
        <1.500000, 16.066671, 32.000000>,
        <1.500000, 16.066671, 33.000000>,
        < 1.500000, 33.966673, 33.000000>
      }
      triangle {
        <40.951191, 16.066671, 32.000000>,
        <40.951191, 16.066671, 33.000000>,
        < 1.500000, 16.066671, 33.000000>
      }
      triangle {
        <40.951191, 16.066671, 32.000000>,
        <1.500000, 16.066671, 33.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <36.666599, 33.966673, 33.000000>,
        < 1.500000, 33.966673, 33.000000>
      }
      triangle {
        <1.500000, 33.966673, 32.000000>,
        <1.500000, 33.966673, 33.000000>,
        < 36.666599, 33.966673, 33.000000>
      }
      triangle {
        <1.500000, 33.966673, 32.000000>,
        <1.500000, 16.066671, 32.000000>,
        < 1.500000, 33.966673, 33.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <37.754299, 33.762465, 33.000000>,
        < 36.666599, 33.966673, 33.000000>
      }
      triangle {
        <36.666599, 33.966673, 32.000000>,
        <36.666599, 33.966673, 33.000000>,
        < 37.754299, 33.762465, 33.000000>
      }
      triangle {
        <1.500000, 33.966673, 32.000000>,
        <36.666599, 33.966673, 33.000000>,
        < 36.666599, 33.966673, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <38.693272, 33.178404, 33.000000>,
        < 37.754299, 33.762465, 33.000000>
      }
      triangle {
        <37.754299, 33.762465, 32.000000>,
        <37.754299, 33.762465, 33.000000>,
        < 38.693272, 33.178404, 33.000000>
      }
      triangle {
        <36.666599, 33.966673, 32.000000>,
        <37.754299, 33.762465, 33.000000>,
        < 37.754299, 33.762465, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <39.356941, 32.293905, 33.000000>,
        < 38.693272, 33.178404, 33.000000>
      }
      triangle {
        <38.693272, 33.178404, 32.000000>,
        <38.693272, 33.178404, 33.000000>,
        < 39.356941, 32.293905, 33.000000>
      }
      triangle {
        <37.754299, 33.762465, 32.000000>,
        <38.693272, 33.178404, 33.000000>,
        < 38.693272, 33.178404, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <39.655182, 31.228140, 33.000000>,
        < 39.356941, 32.293905, 33.000000>
      }
      triangle {
        <39.356941, 32.293905, 32.000000>,
        <39.356941, 32.293905, 33.000000>,
        < 39.655182, 31.228140, 33.000000>
      }
      triangle {
        <38.693272, 33.178404, 32.000000>,
        <39.356941, 32.293905, 33.000000>,
        < 39.356941, 32.293905, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <40.843979, 17.640062, 33.000000>,
        < 39.655182, 31.228140, 33.000000>
      }
      triangle {
        <39.655182, 31.228140, 32.000000>,
        <39.655182, 31.228140, 33.000000>,
        < 40.843979, 17.640062, 33.000000>
      }
      triangle {
        <39.356941, 32.293905, 32.000000>,
        <39.655182, 31.228140, 33.000000>,
        < 39.655182, 31.228140, 32.000000>
      }
      triangle {
        <40.951191, 16.066671, 33.000000>,
        <40.905151, 16.853884, 33.000000>,
        < 40.843979, 17.640062, 33.000000>
      }
      triangle {
        <40.843979, 17.640062, 32.000000>,
        <40.843979, 17.640062, 33.000000>,
        < 40.905151, 16.853884, 33.000000>
      }
      triangle {
        <39.655182, 31.228140, 32.000000>,
        <40.843979, 17.640062, 33.000000>,
        < 40.843979, 17.640062, 32.000000>
      }
      triangle {
        <40.905151, 16.853884, 32.000000>,
        <40.905151, 16.853884, 33.000000>,
        < 40.951191, 16.066671, 33.000000>
      }
      triangle {
        <40.843979, 17.640062, 32.000000>,
        <40.905151, 16.853884, 33.000000>,
        < 40.905151, 16.853884, 32.000000>
      }
      triangle {
        <40.905151, 16.853884, 32.000000>,
        <40.951191, 16.066671, 33.000000>,
        < 40.951191, 16.066671, 32.000000>
      }
      triangle {
        <40.905151, 16.853884, 32.000000>,
        <40.951191, 16.066671, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <40.843979, 17.640062, 32.000000>,
        <40.905151, 16.853884, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <39.655182, 31.228140, 32.000000>,
        <40.843979, 17.640062, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <39.356941, 32.293905, 32.000000>,
        <39.655182, 31.228140, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <38.693272, 33.178404, 32.000000>,
        <39.356941, 32.293905, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <37.754299, 33.762465, 32.000000>,
        <38.693272, 33.178404, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <36.666599, 33.966673, 32.000000>,
        <37.754299, 33.762465, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <1.500000, 33.966673, 32.000000>,
        <36.666599, 33.966673, 32.000000>,
        < 1.500000, 16.066671, 32.000000>
      }
      triangle {
        <-40.905151, 16.853884, 33.000000>,
        <-40.951191, 16.066671, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-1.500000, 16.066671, 32.000000>,
        <-1.500000, 16.066671, 33.000000>,
        < -40.951191, 16.066671, 33.000000>
      }
      triangle {
        <-40.843979, 17.640062, 33.000000>,
        <-40.905151, 16.853884, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-39.655182, 31.228140, 33.000000>,
        <-40.843979, 17.640062, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-39.356941, 32.293905, 33.000000>,
        <-39.655182, 31.228140, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-38.693272, 33.178404, 33.000000>,
        <-39.356941, 32.293905, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-37.754299, 33.762465, 33.000000>,
        <-38.693272, 33.178404, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-36.666599, 33.966673, 33.000000>,
        <-37.754299, 33.762465, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-1.500000, 33.966673, 33.000000>,
        <-36.666599, 33.966673, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-1.500000, 33.966673, 32.000000>,
        <-1.500000, 33.966673, 33.000000>,
        < -1.500000, 16.066671, 33.000000>
      }
      triangle {
        <-1.500000, 33.966673, 32.000000>,
        <-1.500000, 16.066671, 33.000000>,
        < -1.500000, 16.066671, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-40.951191, 16.066671, 33.000000>,
        < -40.905151, 16.853884, 33.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-1.500000, 16.066671, 32.000000>,
        < -40.951191, 16.066671, 33.000000>
      }
      triangle {
        <-40.905151, 16.853884, 32.000000>,
        <-40.905151, 16.853884, 33.000000>,
        < -40.843979, 17.640062, 33.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-40.905151, 16.853884, 33.000000>,
        < -40.905151, 16.853884, 32.000000>
      }
      triangle {
        <-40.843979, 17.640062, 32.000000>,
        <-40.843979, 17.640062, 33.000000>,
        < -39.655182, 31.228140, 33.000000>
      }
      triangle {
        <-40.905151, 16.853884, 32.000000>,
        <-40.843979, 17.640062, 33.000000>,
        < -40.843979, 17.640062, 32.000000>
      }
      triangle {
        <-39.655182, 31.228140, 32.000000>,
        <-39.655182, 31.228140, 33.000000>,
        < -39.356941, 32.293905, 33.000000>
      }
      triangle {
        <-40.843979, 17.640062, 32.000000>,
        <-39.655182, 31.228140, 33.000000>,
        < -39.655182, 31.228140, 32.000000>
      }
      triangle {
        <-39.356941, 32.293905, 32.000000>,
        <-39.356941, 32.293905, 33.000000>,
        < -38.693272, 33.178404, 33.000000>
      }
      triangle {
        <-39.655182, 31.228140, 32.000000>,
        <-39.356941, 32.293905, 33.000000>,
        < -39.356941, 32.293905, 32.000000>
      }
      triangle {
        <-38.693272, 33.178404, 32.000000>,
        <-38.693272, 33.178404, 33.000000>,
        < -37.754299, 33.762465, 33.000000>
      }
      triangle {
        <-39.356941, 32.293905, 32.000000>,
        <-38.693272, 33.178404, 33.000000>,
        < -38.693272, 33.178404, 32.000000>
      }
      triangle {
        <-37.754299, 33.762465, 32.000000>,
        <-37.754299, 33.762465, 33.000000>,
        < -36.666599, 33.966673, 33.000000>
      }
      triangle {
        <-38.693272, 33.178404, 32.000000>,
        <-37.754299, 33.762465, 33.000000>,
        < -37.754299, 33.762465, 32.000000>
      }
      triangle {
        <-36.666599, 33.966673, 32.000000>,
        <-36.666599, 33.966673, 33.000000>,
        < -1.500000, 33.966673, 33.000000>
      }
      triangle {
        <-37.754299, 33.762465, 32.000000>,
        <-36.666599, 33.966673, 33.000000>,
        < -36.666599, 33.966673, 32.000000>
      }
      triangle {
        <-36.666599, 33.966673, 32.000000>,
        <-1.500000, 33.966673, 33.000000>,
        < -1.500000, 33.966673, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-1.500000, 33.966673, 32.000000>,
        < -1.500000, 16.066671, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-36.666599, 33.966673, 32.000000>,
        < -1.500000, 33.966673, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-37.754299, 33.762465, 32.000000>,
        < -36.666599, 33.966673, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-38.693272, 33.178404, 32.000000>,
        < -37.754299, 33.762465, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-39.356941, 32.293905, 32.000000>,
        < -38.693272, 33.178404, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-39.655182, 31.228140, 32.000000>,
        < -39.356941, 32.293905, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-40.843979, 17.640062, 32.000000>,
        < -39.655182, 31.228140, 32.000000>
      }
      triangle {
        <-40.951191, 16.066671, 32.000000>,
        <-40.905151, 16.853884, 32.000000>,
        < -40.843979, 17.640062, 32.000000>
      }
      triangle {
        <-43.625000, 25.966673, 4.625000>,
        <-43.625000, 11.966673, 24.625000>,
        < -43.625000, 25.966673, 24.625000>
      }
      triangle {
        <-43.250000, 25.966673, 24.625000>,
        <-43.625000, 25.966673, 24.625000>,
        < -43.625000, 11.966673, 24.625000>
      }
      triangle {
        <-43.250000, 25.966673, 4.625000>,
        <-43.625000, 25.966673, 4.625000>,
        < -43.625000, 25.966673, 24.625000>
      }
      triangle {
        <-43.250000, 25.966673, 4.625000>,
        <-43.625000, 25.966673, 24.625000>,
        < -43.250000, 25.966673, 24.625000>
      }
      triangle {
        <-43.625000, 25.966673, 4.625000>,
        <-43.625000, 11.966673, 4.625000>,
        < -43.625000, 11.966673, 24.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.625000, 11.966673, 24.625000>,
        < -43.625000, 11.966673, 4.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.250000, 25.966673, 24.625000>,
        < -43.625000, 11.966673, 24.625000>
      }
      triangle {
        <-43.250000, 11.966673, 4.625000>,
        <-43.625000, 11.966673, 4.625000>,
        < -43.625000, 25.966673, 4.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.625000, 11.966673, 4.625000>,
        < -43.250000, 11.966673, 4.625000>
      }
      triangle {
        <-43.250000, 11.966673, 4.625000>,
        <-43.625000, 25.966673, 4.625000>,
        < -43.250000, 25.966673, 4.625000>
      }
      triangle {
        <-43.250000, 11.966673, 4.625000>,
        <-43.250000, 25.966673, 4.625000>,
        < -43.250000, 25.966673, 24.625000>
      }
      triangle {
        <-43.250000, 11.966673, 24.625000>,
        <-43.250000, 11.966673, 4.625000>,
        < -43.250000, 25.966673, 24.625000>
      }
      triangle {
        <-43.625000, 11.966673, -9.875000>,
        <-43.625000, 25.966673, -9.875000>,
        < -43.625000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 25.966673, -25.875000>,
        <-43.625000, 25.966673, -25.875000>,
        < -43.625000, 25.966673, -9.875000>
      }
      triangle {
        <-43.625000, 11.966673, -25.875000>,
        <-43.625000, 11.966673, -9.875000>,
        < -43.625000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 11.966673, -25.875000>,
        <-43.625000, 11.966673, -25.875000>,
        < -43.625000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 11.966673, -25.875000>,
        <-43.625000, 25.966673, -25.875000>,
        < -43.250000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.625000, 25.966673, -9.875000>,
        < -43.625000, 11.966673, -9.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.250000, 25.966673, -25.875000>,
        < -43.625000, 25.966673, -9.875000>
      }
      triangle {
        <-43.250000, 11.966673, -9.875000>,
        <-43.625000, 11.966673, -9.875000>,
        < -43.625000, 11.966673, -25.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.625000, 11.966673, -9.875000>,
        < -43.250000, 11.966673, -9.875000>
      }
      triangle {
        <-43.250000, 11.966673, -9.875000>,
        <-43.625000, 11.966673, -25.875000>,
        < -43.250000, 11.966673, -25.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.250000, 11.966673, -25.875000>,
        < -43.250000, 25.966673, -25.875000>
      }
      triangle {
        <-43.250000, 25.966673, -9.875000>,
        <-43.250000, 11.966673, -9.875000>,
        < -43.250000, 11.966673, -25.875000>
      }
      triangle {
        <43.625000, 11.966673, 4.625000>,
        <43.625000, 25.966673, 4.625000>,
        < 43.625000, 25.966673, 24.625000>
      }
      triangle {
        <43.250000, 25.966673, 24.625000>,
        <43.625000, 25.966673, 24.625000>,
        < 43.625000, 25.966673, 4.625000>
      }
      triangle {
        <43.625000, 11.966673, 24.625000>,
        <43.625000, 11.966673, 4.625000>,
        < 43.625000, 25.966673, 24.625000>
      }
      triangle {
        <43.250000, 11.966673, 24.625000>,
        <43.625000, 11.966673, 24.625000>,
        < 43.625000, 25.966673, 24.625000>
      }
      triangle {
        <43.250000, 11.966673, 24.625000>,
        <43.625000, 25.966673, 24.625000>,
        < 43.250000, 25.966673, 24.625000>
      }
      triangle {
        <43.250000, 25.966673, 4.625000>,
        <43.625000, 25.966673, 4.625000>,
        < 43.625000, 11.966673, 4.625000>
      }
      triangle {
        <43.250000, 25.966673, 4.625000>,
        <43.250000, 25.966673, 24.625000>,
        < 43.625000, 25.966673, 4.625000>
      }
      triangle {
        <43.250000, 11.966673, 4.625000>,
        <43.625000, 11.966673, 4.625000>,
        < 43.625000, 11.966673, 24.625000>
      }
      triangle {
        <43.250000, 25.966673, 4.625000>,
        <43.625000, 11.966673, 4.625000>,
        < 43.250000, 11.966673, 4.625000>
      }
      triangle {
        <43.250000, 11.966673, 4.625000>,
        <43.625000, 11.966673, 24.625000>,
        < 43.250000, 11.966673, 24.625000>
      }
      triangle {
        <43.250000, 25.966673, 4.625000>,
        <43.250000, 11.966673, 24.625000>,
        < 43.250000, 25.966673, 24.625000>
      }
      triangle {
        <43.250000, 25.966673, 4.625000>,
        <43.250000, 11.966673, 4.625000>,
        < 43.250000, 11.966673, 24.625000>
      }
      triangle {
        <43.625000, 25.966673, -9.875000>,
        <43.625000, 11.966673, -25.875000>,
        < 43.625000, 25.966673, -25.875000>
      }
      triangle {
        <43.250000, 25.966673, -25.875000>,
        <43.625000, 25.966673, -25.875000>,
        < 43.625000, 11.966673, -25.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.625000, 25.966673, -9.875000>,
        < 43.625000, 25.966673, -25.875000>
      }
      triangle {
        <43.250000, 25.966673, -9.875000>,
        <43.625000, 25.966673, -25.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      triangle {
        <43.625000, 25.966673, -9.875000>,
        <43.625000, 11.966673, -9.875000>,
        < 43.625000, 11.966673, -25.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.625000, 11.966673, -25.875000>,
        < 43.625000, 11.966673, -9.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.250000, 25.966673, -25.875000>,
        < 43.625000, 11.966673, -25.875000>
      }
      triangle {
        <43.250000, 11.966673, -9.875000>,
        <43.625000, 11.966673, -9.875000>,
        < 43.625000, 25.966673, -9.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.625000, 11.966673, -9.875000>,
        < 43.250000, 11.966673, -9.875000>
      }
      triangle {
        <43.250000, 11.966673, -9.875000>,
        <43.625000, 25.966673, -9.875000>,
        < 43.250000, 25.966673, -9.875000>
      }
      triangle {
        <43.250000, 11.966673, -9.875000>,
        <43.250000, 25.966673, -9.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      triangle {
        <43.250000, 11.966673, -25.875000>,
        <43.250000, 11.966673, -9.875000>,
        < 43.250000, 25.966673, -25.875000>
      }
      texture{_all_windows}
    }
    // _all_hubs
    mesh {
      triangle {
        <-43.047112, -20.533707, 61.984501>,
        <-42.598888, -18.033327, 61.625000>,
        < -43.047112, -18.033327, 61.625000>
      }
      triangle {
        <-42.598888, -15.532947, 61.984501>,
        <-43.047112, -18.033327, 61.625000>,
        < -42.598888, -18.033327, 61.625000>
      }
      triangle {
        <-43.047112, -20.568927, 61.864571>,
        <-43.047112, -20.533707, 61.984501>,
        < -43.047112, -18.033327, 61.625000>
      }
      triangle {
        <-43.047112, -20.568927, 61.864571>,
        <-43.047112, -18.033327, 61.625000>,
        < -43.047112, -18.033327, 61.500000>
      }
      triangle {
        <-43.047112, -15.532947, 61.984501>,
        <-43.047112, -18.033327, 61.500000>,
        < -43.047112, -18.033327, 61.625000>
      }
      triangle {
        <-42.598888, -15.532947, 61.984501>,
        <-43.047112, -15.532947, 61.984501>,
        < -43.047112, -18.033327, 61.625000>
      }
      triangle {
        <-43.047112, -20.533707, 61.984501>,
        <-42.598888, -20.533707, 61.984501>,
        < -42.598888, -18.033327, 61.625000>
      }
      triangle {
        <-42.111019, -18.033327, 62.112869>,
        <-42.598888, -18.033327, 61.625000>,
        < -42.598888, -20.533707, 61.984501>
      }
      triangle {
        <-42.111019, -15.670397, 62.452610>,
        <-42.598888, -18.033327, 61.625000>,
        < -42.111019, -18.033327, 62.112869>
      }
      triangle {
        <-42.111019, -15.670397, 62.452610>,
        <-42.598888, -15.532947, 61.984501>,
        < -42.598888, -18.033327, 61.625000>
      }
      triangle {
        <-43.047112, -22.831517, 63.033871>,
        <-42.598888, -22.831517, 63.033871>,
        < -42.598888, -20.533707, 61.984501>
      }
      triangle {
        <-42.111019, -20.396257, 62.452610>,
        <-42.598888, -20.533707, 61.984501>,
        < -42.598888, -22.831517, 63.033871>
      }
      triangle {
        <-43.047112, -20.533707, 61.984501>,
        <-43.047112, -22.831517, 63.033871>,
        < -42.598888, -20.533707, 61.984501>
      }
      triangle {
        <-42.111019, -20.396257, 62.452610>,
        <-42.111019, -18.033327, 62.112869>,
        < -42.598888, -20.533707, 61.984501>
      }
      triangle {
        <-43.047112, -24.740597, 64.688110>,
        <-42.598888, -24.740607, 64.688110>,
        < -42.598888, -22.831517, 63.033871>
      }
      triangle {
        <-42.111019, -22.567747, 63.444300>,
        <-42.598888, -22.831517, 63.033871>,
        < -42.598888, -24.740607, 64.688110>
      }
      triangle {
        <-43.047112, -22.831517, 63.033871>,
        <-43.047112, -24.740597, 64.688110>,
        < -42.598888, -22.831517, 63.033871>
      }
      triangle {
        <-42.111019, -22.567747, 63.444300>,
        <-42.111019, -20.396257, 62.452610>,
        < -42.598888, -22.831517, 63.033871>
      }
      triangle {
        <-43.047112, -26.106313, 66.813200>,
        <-42.598888, -26.106311, 66.813190>,
        < -42.598888, -24.740607, 64.688110>
      }
      triangle {
        <-42.111019, -24.371897, 65.007601>,
        <-42.598888, -24.740607, 64.688110>,
        < -42.598888, -26.106311, 66.813190>
      }
      triangle {
        <-43.047112, -24.740597, 64.688110>,
        <-43.047112, -26.106313, 66.813200>,
        < -42.598888, -24.740607, 64.688110>
      }
      triangle {
        <-42.111019, -24.371897, 65.007601>,
        <-42.111019, -22.567747, 63.444300>,
        < -42.598888, -24.740607, 64.688110>
      }
      triangle {
        <-43.047112, -26.817993, 69.236959>,
        <-42.598888, -26.817992, 69.236959>,
        < -42.598888, -26.106311, 66.813190>
      }
      triangle {
        <-42.111019, -25.662527, 67.015860>,
        <-42.598888, -26.106311, 66.813190>,
        < -42.598888, -26.817992, 69.236959>
      }
      triangle {
        <-43.047112, -26.106313, 66.813200>,
        <-43.047112, -26.817993, 69.236959>,
        < -42.598888, -26.106311, 66.813190>
      }
      triangle {
        <-42.111019, -25.662527, 67.015860>,
        <-42.111019, -24.371897, 65.007601>,
        < -42.598888, -26.106311, 66.813190>
      }
      triangle {
        <-43.047112, -26.817993, 71.763041>,
        <-42.598888, -26.817992, 71.763041>,
        < -42.598888, -26.817992, 69.236959>
      }
      triangle {
        <-42.111019, -26.335088, 69.306391>,
        <-42.598888, -26.817992, 69.236959>,
        < -42.598888, -26.817992, 71.763041>
      }
      triangle {
        <-43.047112, -26.817993, 69.236959>,
        <-43.047112, -26.817993, 71.763041>,
        < -42.598888, -26.817992, 69.236959>
      }
      triangle {
        <-42.111019, -26.335088, 69.306391>,
        <-42.111019, -25.662527, 67.015860>,
        < -42.598888, -26.817992, 69.236959>
      }
      triangle {
        <-43.047112, -26.106313, 74.186800>,
        <-42.598888, -26.106311, 74.186810>,
        < -42.598888, -26.817992, 71.763041>
      }
      triangle {
        <-42.111019, -26.335088, 71.693609>,
        <-42.598888, -26.817992, 71.763041>,
        < -42.598888, -26.106311, 74.186810>
      }
      triangle {
        <-43.047112, -26.817993, 71.763041>,
        <-43.047112, -26.106313, 74.186800>,
        < -42.598888, -26.817992, 71.763041>
      }
      triangle {
        <-42.111019, -26.335088, 71.693609>,
        <-42.111019, -26.335088, 69.306391>,
        < -42.598888, -26.817992, 71.763041>
      }
      triangle {
        <-43.047112, -24.740597, 76.311890>,
        <-42.598888, -24.740607, 76.311890>,
        < -42.598888, -26.106311, 74.186810>
      }
      triangle {
        <-42.111019, -25.662527, 73.984140>,
        <-42.598888, -26.106311, 74.186810>,
        < -42.598888, -24.740607, 76.311890>
      }
      triangle {
        <-43.047112, -26.106313, 74.186800>,
        <-43.047112, -24.740597, 76.311890>,
        < -42.598888, -26.106311, 74.186810>
      }
      triangle {
        <-42.111019, -25.662527, 73.984140>,
        <-42.111019, -26.335088, 71.693609>,
        < -42.598888, -26.106311, 74.186810>
      }
      triangle {
        <-43.047112, -22.831517, 77.966130>,
        <-42.598888, -22.831517, 77.966130>,
        < -42.598888, -24.740607, 76.311890>
      }
      triangle {
        <-42.111019, -24.371897, 75.992400>,
        <-42.598888, -24.740607, 76.311890>,
        < -42.598888, -22.831517, 77.966130>
      }
      triangle {
        <-43.047112, -24.740597, 76.311890>,
        <-43.047112, -22.831517, 77.966130>,
        < -42.598888, -24.740607, 76.311890>
      }
      triangle {
        <-42.111019, -24.371897, 75.992400>,
        <-42.111019, -25.662527, 73.984140>,
        < -42.598888, -24.740607, 76.311890>
      }
      triangle {
        <-43.047112, -20.533707, 79.015500>,
        <-42.598888, -20.533707, 79.015500>,
        < -42.598888, -22.831517, 77.966130>
      }
      triangle {
        <-42.111019, -22.567747, 77.555700>,
        <-42.598888, -22.831517, 77.966130>,
        < -42.598888, -20.533707, 79.015500>
      }
      triangle {
        <-43.047112, -22.831517, 77.966130>,
        <-43.047112, -20.533707, 79.015500>,
        < -42.598888, -22.831517, 77.966130>
      }
      triangle {
        <-42.111019, -22.567747, 77.555700>,
        <-42.111019, -24.371897, 75.992400>,
        < -42.598888, -22.831517, 77.966130>
      }
      triangle {
        <-43.047112, -18.033327, 79.375000>,
        <-42.598888, -18.033327, 79.375000>,
        < -42.598888, -20.533707, 79.015500>
      }
      triangle {
        <-42.111019, -20.396257, 78.547390>,
        <-42.598888, -20.533707, 79.015500>,
        < -42.598888, -18.033327, 79.375000>
      }
      triangle {
        <-43.047112, -20.533707, 79.015500>,
        <-43.047112, -18.033327, 79.375000>,
        < -42.598888, -20.533707, 79.015500>
      }
      triangle {
        <-42.111019, -20.396257, 78.547390>,
        <-42.111019, -22.567747, 77.555700>,
        < -42.598888, -20.533707, 79.015500>
      }
      triangle {
        <-43.047112, -15.532947, 79.015500>,
        <-42.598888, -18.033327, 79.375000>,
        < -43.047112, -18.033327, 79.375000>
      }
      triangle {
        <-42.111019, -18.033327, 78.887130>,
        <-42.111019, -20.396257, 78.547390>,
        < -42.598888, -18.033327, 79.375000>
      }
      triangle {
        <-42.598888, -15.532947, 79.015500>,
        <-42.111019, -18.033327, 78.887130>,
        < -42.598888, -18.033327, 79.375000>
      }
      triangle {
        <-42.598888, -15.532947, 79.015500>,
        <-42.598888, -18.033327, 79.375000>,
        < -43.047112, -15.532947, 79.015500>
      }
      triangle {
        <-43.047112, -18.033327, 79.500000>,
        <-43.047112, -18.033327, 79.375000>,
        < -43.047112, -20.533707, 79.015500>
      }
      triangle {
        <-43.047112, -15.497726, 79.135430>,
        <-43.047112, -18.033327, 79.375000>,
        < -43.047112, -18.033327, 79.500000>
      }
      triangle {
        <-43.047112, -15.497726, 79.135430>,
        <-43.047112, -15.532947, 79.015500>,
        < -43.047112, -18.033327, 79.375000>
      }
      triangle {
        <-43.047112, -20.568927, 79.135430>,
        <-43.047112, -20.533707, 79.015500>,
        < -43.047112, -22.831517, 77.966130>
      }
      triangle {
        <-43.047112, -18.033327, 79.500000>,
        <-43.047112, -20.533707, 79.015500>,
        < -43.047112, -20.568927, 79.135430>
      }
      triangle {
        <-43.047112, -22.899097, 78.071280>,
        <-43.047112, -22.831517, 77.966130>,
        < -43.047112, -24.740597, 76.311890>
      }
      triangle {
        <-43.047112, -20.568927, 79.135430>,
        <-43.047112, -22.831517, 77.966130>,
        < -43.047112, -22.899097, 78.071280>
      }
      triangle {
        <-43.047112, -24.835067, 76.393750>,
        <-43.047112, -24.740597, 76.311890>,
        < -43.047112, -26.106313, 74.186800>
      }
      triangle {
        <-43.047112, -22.899097, 78.071280>,
        <-43.047112, -24.740597, 76.311890>,
        < -43.047112, -24.835067, 76.393750>
      }
      triangle {
        <-43.047112, -26.220017, 74.238729>,
        <-43.047112, -26.106313, 74.186800>,
        < -43.047112, -26.817993, 71.763041>
      }
      triangle {
        <-43.047112, -24.835067, 76.393750>,
        <-43.047112, -26.106313, 74.186800>,
        < -43.047112, -26.220017, 74.238729>
      }
      triangle {
        <-43.047112, -26.941720, 69.219170>,
        <-43.047112, -26.817993, 71.763041>,
        < -43.047112, -26.817993, 69.236959>
      }
      triangle {
        <-43.047112, -26.941720, 71.780830>,
        <-43.047112, -26.817993, 71.763041>,
        < -43.047112, -26.941720, 69.219170>
      }
      triangle {
        <-43.047112, -26.220017, 74.238729>,
        <-43.047112, -26.817993, 71.763041>,
        < -43.047112, -26.941720, 71.780830>
      }
      triangle {
        <-43.047112, -26.220017, 66.761271>,
        <-43.047112, -26.817993, 69.236959>,
        < -43.047112, -26.106313, 66.813200>
      }
      triangle {
        <-43.047112, -26.941720, 69.219170>,
        <-43.047112, -26.817993, 69.236959>,
        < -43.047112, -26.220017, 66.761271>
      }
      triangle {
        <-43.047112, -24.835067, 64.606251>,
        <-43.047112, -26.106313, 66.813200>,
        < -43.047112, -24.740597, 64.688110>
      }
      triangle {
        <-43.047112, -26.220017, 66.761271>,
        <-43.047112, -26.106313, 66.813200>,
        < -43.047112, -24.835067, 64.606251>
      }
      triangle {
        <-43.047112, -22.899097, 62.928720>,
        <-43.047112, -24.740597, 64.688110>,
        < -43.047112, -22.831517, 63.033871>
      }
      triangle {
        <-43.047112, -24.835067, 64.606251>,
        <-43.047112, -24.740597, 64.688110>,
        < -43.047112, -22.899097, 62.928720>
      }
      triangle {
        <-43.047112, -20.568927, 61.864571>,
        <-43.047112, -22.831517, 63.033871>,
        < -43.047112, -20.533707, 61.984501>
      }
      triangle {
        <-43.047112, -22.899097, 62.928720>,
        <-43.047112, -22.831517, 63.033871>,
        < -43.047112, -20.568927, 61.864571>
      }
      triangle {
        <-40.125000, -18.033327, 62.609381>,
        <-42.111019, -18.033327, 62.112869>,
        < -42.111019, -20.396257, 62.452610>
      }
      triangle {
        <-40.125000, -15.594976, 62.995569>,
        <-42.111019, -18.033327, 62.112869>,
        < -40.125000, -18.033327, 62.609381>
      }
      triangle {
        <-40.125000, -15.594976, 62.995569>,
        <-42.111019, -15.670397, 62.452610>,
        < -42.111019, -18.033327, 62.112869>
      }
      triangle {
        <-40.125000, -20.471677, 62.995569>,
        <-42.111019, -20.396257, 62.452610>,
        < -42.111019, -22.567747, 63.444300>
      }
      triangle {
        <-40.125000, -20.471677, 62.995569>,
        <-40.125000, -18.033327, 62.609381>,
        < -42.111019, -20.396257, 62.452610>
      }
      triangle {
        <-40.125000, -22.671327, 64.116360>,
        <-42.111019, -22.567747, 63.444300>,
        < -42.111019, -24.371897, 65.007601>
      }
      triangle {
        <-40.125000, -22.671327, 64.116360>,
        <-40.125000, -20.471677, 62.995569>,
        < -42.111019, -22.567747, 63.444300>
      }
      triangle {
        <-40.125000, -24.416987, 65.862020>,
        <-42.111019, -24.371897, 65.007601>,
        < -42.111019, -25.662527, 67.015860>
      }
      triangle {
        <-40.125000, -24.416987, 65.862020>,
        <-40.125000, -22.671327, 64.116360>,
        < -42.111019, -24.371897, 65.007601>
      }
      triangle {
        <-40.125000, -25.537757, 68.061670>,
        <-42.111019, -25.662527, 67.015860>,
        < -42.111019, -26.335088, 69.306391>
      }
      triangle {
        <-40.125000, -25.537757, 68.061670>,
        <-40.125000, -24.416987, 65.862020>,
        < -42.111019, -25.662527, 67.015860>
      }
      triangle {
        <-40.125000, -25.923947, 70.500000>,
        <-42.111019, -26.335088, 69.306391>,
        < -42.111019, -26.335088, 71.693609>
      }
      triangle {
        <-40.125000, -25.923947, 70.500000>,
        <-40.125000, -25.537757, 68.061670>,
        < -42.111019, -26.335088, 69.306391>
      }
      triangle {
        <-40.125000, -25.537757, 72.938330>,
        <-42.111019, -26.335088, 71.693609>,
        < -42.111019, -25.662527, 73.984140>
      }
      triangle {
        <-40.125000, -25.537757, 72.938330>,
        <-40.125000, -25.923947, 70.500000>,
        < -42.111019, -26.335088, 71.693609>
      }
      triangle {
        <-40.125000, -24.416987, 75.137980>,
        <-42.111019, -25.662527, 73.984140>,
        < -42.111019, -24.371897, 75.992400>
      }
      triangle {
        <-40.125000, -24.416987, 75.137980>,
        <-40.125000, -25.537757, 72.938330>,
        < -42.111019, -25.662527, 73.984140>
      }
      triangle {
        <-40.125000, -22.671327, 76.883640>,
        <-42.111019, -24.371897, 75.992400>,
        < -42.111019, -22.567747, 77.555700>
      }
      triangle {
        <-40.125000, -22.671327, 76.883640>,
        <-40.125000, -24.416987, 75.137980>,
        < -42.111019, -24.371897, 75.992400>
      }
      triangle {
        <-40.125000, -20.471677, 78.004430>,
        <-42.111019, -22.567747, 77.555700>,
        < -42.111019, -20.396257, 78.547390>
      }
      triangle {
        <-40.125000, -20.471677, 78.004430>,
        <-40.125000, -22.671327, 76.883640>,
        < -42.111019, -22.567747, 77.555700>
      }
      triangle {
        <-40.125000, -20.471677, 78.004430>,
        <-42.111019, -20.396257, 78.547390>,
        < -42.111019, -18.033327, 78.887130>
      }
      triangle {
        <-40.125000, -18.033327, 78.390620>,
        <-40.125000, -20.471677, 78.004430>,
        < -42.111019, -18.033327, 78.887130>
      }
      triangle {
        <-42.111019, -15.670397, 78.547390>,
        <-40.125000, -18.033327, 78.390620>,
        < -42.111019, -18.033327, 78.887130>
      }
      triangle {
        <-42.111019, -15.670397, 78.547390>,
        <-42.111019, -18.033327, 78.887130>,
        < -42.598888, -15.532947, 79.015500>
      }
      triangle {
        <-40.125000, -18.033327, 63.750000>,
        <-40.125000, -18.033327, 62.609381>,
        < -40.125000, -20.471677, 62.995569>
      }
      triangle {
        <-40.125000, -16.132027, 65.276239>,
        <-40.125000, -15.594976, 62.995569>,
        < -40.125000, -18.033327, 62.609381>
      }
      triangle {
        <-40.125000, -17.658327, 64.125000>,
        <-40.125000, -16.132027, 65.276239>,
        < -40.125000, -18.033327, 62.609381>
      }
      triangle {
        <-40.125000, -17.768158, 63.859831>,
        <-40.125000, -17.658327, 64.125000>,
        < -40.125000, -18.033327, 62.609381>
      }
      triangle {
        <-40.125000, -18.033327, 63.750000>,
        <-40.125000, -17.768158, 63.859831>,
        < -40.125000, -18.033327, 62.609381>
      }
      triangle {
        <-40.125000, -21.606607, 66.241550>,
        <-40.125000, -20.471677, 62.995569>,
        < -40.125000, -22.671327, 64.116360>
      }
      triangle {
        <-40.125000, -21.606607, 66.241550>,
        <-40.125000, -19.934627, 65.276239>,
        < -40.125000, -20.471677, 62.995569>
      }
      triangle {
        <-40.125000, -18.408327, 64.125000>,
        <-40.125000, -20.471677, 62.995569>,
        < -40.125000, -19.934627, 65.276239>
      }
      triangle {
        <-40.125000, -18.298496, 63.859831>,
        <-40.125000, -18.033327, 63.750000>,
        < -40.125000, -20.471677, 62.995569>
      }
      triangle {
        <-40.125000, -18.408327, 64.125000>,
        <-40.125000, -18.298496, 63.859831>,
        < -40.125000, -20.471677, 62.995569>
      }
      triangle {
        <-40.125000, -22.806297, 65.727030>,
        <-40.125000, -22.671327, 64.116360>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -22.166137, 65.992189>,
        <-40.125000, -21.606607, 66.241550>,
        < -40.125000, -22.671327, 64.116360>
      }
      triangle {
        <-40.125000, -22.275967, 65.727030>,
        <-40.125000, -22.166137, 65.992189>,
        < -40.125000, -22.671327, 64.116360>
      }
      triangle {
        <-40.125000, -22.541137, 65.617189>,
        <-40.125000, -22.275967, 65.727030>,
        < -40.125000, -22.671327, 64.116360>
      }
      triangle {
        <-40.125000, -22.806297, 65.727030>,
        <-40.125000, -22.541137, 65.617189>,
        < -40.125000, -22.671327, 64.116360>
      }
      triangle {
        <-40.125000, -24.673497, 70.234831>,
        <-40.125000, -24.416987, 65.862020>,
        < -40.125000, -25.537757, 68.061670>
      }
      triangle {
        <-40.125000, -23.507887, 71.465309>,
        <-40.125000, -23.507887, 69.534691>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -22.916137, 65.992189>,
        <-40.125000, -24.416987, 65.862020>,
        < -40.125000, -23.507887, 69.534691>
      }
      triangle {
        <-40.125000, -24.033327, 70.500000>,
        <-40.125000, -23.507887, 71.465309>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -24.143157, 70.234831>,
        <-40.125000, -24.033327, 70.500000>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -24.408327, 70.125000>,
        <-40.125000, -24.143157, 70.234831>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -24.673497, 70.234831>,
        <-40.125000, -24.408327, 70.125000>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -22.916137, 65.992189>,
        <-40.125000, -22.806297, 65.727030>,
        < -40.125000, -24.416987, 65.862020>
      }
      triangle {
        <-40.125000, -25.537757, 72.938330>,
        <-40.125000, -25.537757, 68.061670>,
        < -40.125000, -25.923947, 70.500000>
      }
      triangle {
        <-40.125000, -24.416987, 75.137980>,
        <-40.125000, -25.537757, 68.061670>,
        < -40.125000, -25.537757, 72.938330>
      }
      triangle {
        <-40.125000, -24.783327, 70.500000>,
        <-40.125000, -25.537757, 68.061670>,
        < -40.125000, -24.416987, 75.137980>
      }
      triangle {
        <-40.125000, -24.783327, 70.500000>,
        <-40.125000, -24.673497, 70.234831>,
        < -40.125000, -25.537757, 68.061670>
      }
      triangle {
        <-40.125000, -24.408327, 70.875000>,
        <-40.125000, -24.416987, 75.137980>,
        < -40.125000, -22.671327, 76.883640>
      }
      triangle {
        <-40.125000, -24.673497, 70.765169>,
        <-40.125000, -24.783327, 70.500000>,
        < -40.125000, -24.416987, 75.137980>
      }
      triangle {
        <-40.125000, -24.408327, 70.875000>,
        <-40.125000, -24.673497, 70.765169>,
        < -40.125000, -24.416987, 75.137980>
      }
      triangle {
        <-40.125000, -22.541137, 75.382810>,
        <-40.125000, -22.671327, 76.883640>,
        < -40.125000, -20.471677, 78.004430>
      }
      triangle {
        <-40.125000, -22.916137, 75.007810>,
        <-40.125000, -23.507887, 71.465309>,
        < -40.125000, -22.671327, 76.883640>
      }
      triangle {
        <-40.125000, -24.033327, 70.500000>,
        <-40.125000, -22.671327, 76.883640>,
        < -40.125000, -23.507887, 71.465309>
      }
      triangle {
        <-40.125000, -22.806297, 75.272970>,
        <-40.125000, -22.916137, 75.007810>,
        < -40.125000, -22.671327, 76.883640>
      }
      triangle {
        <-40.125000, -22.541137, 75.382810>,
        <-40.125000, -22.806297, 75.272970>,
        < -40.125000, -22.671327, 76.883640>
      }
      triangle {
        <-40.125000, -24.143157, 70.765169>,
        <-40.125000, -22.671327, 76.883640>,
        < -40.125000, -24.033327, 70.500000>
      }
      triangle {
        <-40.125000, -24.143157, 70.765169>,
        <-40.125000, -24.408327, 70.875000>,
        < -40.125000, -22.671327, 76.883640>
      }
      triangle {
        <-40.125000, -19.934627, 75.723760>,
        <-40.125000, -20.471677, 78.004430>,
        < -40.125000, -18.033327, 78.390620>
      }
      triangle {
        <-40.125000, -19.934627, 75.723760>,
        <-40.125000, -21.606607, 74.758450>,
        < -40.125000, -20.471677, 78.004430>
      }
      triangle {
        <-40.125000, -22.166137, 75.007810>,
        <-40.125000, -20.471677, 78.004430>,
        < -40.125000, -21.606607, 74.758450>
      }
      triangle {
        <-40.125000, -22.275967, 75.272970>,
        <-40.125000, -22.541137, 75.382810>,
        < -40.125000, -20.471677, 78.004430>
      }
      triangle {
        <-40.125000, -22.166137, 75.007810>,
        <-40.125000, -22.275967, 75.272970>,
        < -40.125000, -20.471677, 78.004430>
      }
      triangle {
        <-40.125000, -15.594976, 78.004430>,
        <-40.125000, -18.033327, 78.390620>,
        < -42.111019, -15.670397, 78.547390>
      }
      triangle {
        <-40.125000, -18.033327, 77.250000>,
        <-40.125000, -18.033327, 78.390620>,
        < -40.125000, -15.594976, 78.004430>
      }
      triangle {
        <-40.125000, -18.408327, 76.875000>,
        <-40.125000, -19.934627, 75.723760>,
        < -40.125000, -18.033327, 78.390620>
      }
      triangle {
        <-40.125000, -18.298496, 77.140170>,
        <-40.125000, -18.408327, 76.875000>,
        < -40.125000, -18.033327, 78.390620>
      }
      triangle {
        <-40.125000, -18.033327, 77.250000>,
        <-40.125000, -18.298496, 77.140170>,
        < -40.125000, -18.033327, 78.390620>
      }
      triangle {
        <-40.000000, -20.466847, 63.010429>,
        <-35.031719, -18.033327, 62.625000>,
        < -40.000000, -18.033327, 62.625000>
      }
      triangle {
        <-35.031719, -15.599817, 63.010429>,
        <-40.000000, -18.033327, 62.625000>,
        < -35.031719, -18.033327, 62.625000>
      }
      triangle {
        <-40.000000, -19.891537, 65.394640>,
        <-40.000000, -20.466847, 63.010429>,
        < -40.000000, -18.033327, 62.625000>
      }
      triangle {
        <-35.031719, -15.599817, 63.010429>,
        <-40.000000, -15.599808, 63.010429>,
        < -40.000000, -18.033327, 62.625000>
      }
      triangle {
        <-40.000000, -18.033327, 65.066990>,
        <-40.000000, -18.033327, 62.625000>,
        < -40.000000, -15.599808, 63.010429>
      }
      triangle {
        <-40.000000, -19.891537, 65.394640>,
        <-40.000000, -18.033327, 62.625000>,
        < -40.000000, -18.033327, 65.066990>
      }
      triangle {
        <-40.000000, -20.466847, 63.010429>,
        <-35.031719, -20.466837, 63.010429>,
        < -35.031719, -18.033327, 62.625000>
      }
      triangle {
        <-32.983212, -18.033327, 62.112869>,
        <-35.031719, -18.033327, 62.625000>,
        < -35.031719, -20.466837, 63.010429>
      }
      triangle {
        <-32.983212, -15.670397, 62.452610>,
        <-35.031719, -18.033327, 62.625000>,
        < -32.983212, -18.033327, 62.112869>
      }
      triangle {
        <-32.983212, -15.670397, 62.452610>,
        <-35.031719, -15.599817, 63.010429>,
        < -35.031719, -18.033327, 62.625000>
      }
      triangle {
        <-40.000000, -22.662147, 64.129000>,
        <-35.031719, -22.662137, 64.128990>,
        < -35.031719, -20.466837, 63.010429>
      }
      triangle {
        <-32.983212, -22.567747, 63.444300>,
        <-35.031719, -20.466837, 63.010429>,
        < -35.031719, -22.662137, 64.128990>
      }
      triangle {
        <-40.000000, -20.466847, 63.010429>,
        <-40.000000, -22.662147, 64.129000>,
        < -35.031719, -20.466837, 63.010429>
      }
      triangle {
        <-32.983212, -20.396257, 62.452610>,
        <-32.983212, -18.033327, 62.112869>,
        < -35.031719, -20.466837, 63.010429>
      }
      triangle {
        <-32.983212, -22.567747, 63.444300>,
        <-32.983212, -20.396257, 62.452610>,
        < -35.031719, -20.466837, 63.010429>
      }
      triangle {
        <-40.000000, -22.662147, 64.129000>,
        <-35.031719, -24.404337, 65.871189>,
        < -35.031719, -22.662137, 64.128990>
      }
      triangle {
        <-32.983212, -24.371897, 65.007601>,
        <-35.031719, -22.662137, 64.128990>,
        < -35.031719, -24.404337, 65.871189>
      }
      triangle {
        <-32.983212, -24.371897, 65.007601>,
        <-32.983212, -22.567747, 63.444300>,
        < -35.031719, -22.662137, 64.128990>
      }
      triangle {
        <-40.000000, -25.522897, 68.066500>,
        <-35.031719, -25.522897, 68.066490>,
        < -35.031719, -24.404337, 65.871189>
      }
      triangle {
        <-32.983212, -25.662527, 67.015860>,
        <-35.031719, -24.404337, 65.871189>,
        < -35.031719, -25.522897, 68.066490>
      }
      triangle {
        <-40.000000, -24.404337, 65.871201>,
        <-40.000000, -25.522897, 68.066500>,
        < -35.031719, -24.404337, 65.871189>
      }
      triangle {
        <-40.000000, -22.662147, 64.129000>,
        <-40.000000, -24.404337, 65.871201>,
        < -35.031719, -24.404337, 65.871189>
      }
      triangle {
        <-32.983212, -25.662527, 67.015860>,
        <-32.983212, -24.371897, 65.007601>,
        < -35.031719, -24.404337, 65.871189>
      }
      triangle {
        <-40.000000, -25.908327, 70.500000>,
        <-35.031719, -25.908327, 70.500000>,
        < -35.031719, -25.522897, 68.066490>
      }
      triangle {
        <-32.983212, -26.335088, 69.306391>,
        <-35.031719, -25.522897, 68.066490>,
        < -35.031719, -25.908327, 70.500000>
      }
      triangle {
        <-40.000000, -25.522897, 68.066500>,
        <-40.000000, -25.908327, 70.500000>,
        < -35.031719, -25.522897, 68.066490>
      }
      triangle {
        <-32.983212, -26.335088, 69.306391>,
        <-32.983212, -25.662527, 67.015860>,
        < -35.031719, -25.522897, 68.066490>
      }
      triangle {
        <-40.000000, -25.522897, 72.933500>,
        <-35.031719, -25.522897, 72.933510>,
        < -35.031719, -25.908327, 70.500000>
      }
      triangle {
        <-32.983212, -26.335088, 71.693609>,
        <-35.031719, -25.908327, 70.500000>,
        < -35.031719, -25.522897, 72.933510>
      }
      triangle {
        <-40.000000, -25.908327, 70.500000>,
        <-40.000000, -25.522897, 72.933500>,
        < -35.031719, -25.908327, 70.500000>
      }
      triangle {
        <-32.983212, -26.335088, 71.693609>,
        <-32.983212, -26.335088, 69.306391>,
        < -35.031719, -25.908327, 70.500000>
      }
      triangle {
        <-40.000000, -24.404337, 75.128800>,
        <-35.031719, -24.404337, 75.128810>,
        < -35.031719, -25.522897, 72.933510>
      }
      triangle {
        <-32.983212, -25.662527, 73.984140>,
        <-35.031719, -25.522897, 72.933510>,
        < -35.031719, -24.404337, 75.128810>
      }
      triangle {
        <-40.000000, -25.522897, 72.933500>,
        <-40.000000, -24.404337, 75.128800>,
        < -35.031719, -25.522897, 72.933510>
      }
      triangle {
        <-32.983212, -25.662527, 73.984140>,
        <-32.983212, -26.335088, 71.693609>,
        < -35.031719, -25.522897, 72.933510>
      }
      triangle {
        <-40.000000, -22.662147, 76.871000>,
        <-35.031719, -22.662137, 76.871010>,
        < -35.031719, -24.404337, 75.128810>
      }
      triangle {
        <-32.983212, -24.371897, 75.992400>,
        <-35.031719, -24.404337, 75.128810>,
        < -35.031719, -22.662137, 76.871010>
      }
      triangle {
        <-40.000000, -24.404337, 75.128800>,
        <-40.000000, -22.662147, 76.871000>,
        < -35.031719, -24.404337, 75.128810>
      }
      triangle {
        <-32.983212, -24.371897, 75.992400>,
        <-32.983212, -25.662527, 73.984140>,
        < -35.031719, -24.404337, 75.128810>
      }
      triangle {
        <-40.000000, -20.466847, 77.989570>,
        <-35.031719, -20.466837, 77.989570>,
        < -35.031719, -22.662137, 76.871010>
      }
      triangle {
        <-32.983212, -22.567747, 77.555700>,
        <-35.031719, -22.662137, 76.871010>,
        < -35.031719, -20.466837, 77.989570>
      }
      triangle {
        <-40.000000, -22.662147, 76.871000>,
        <-40.000000, -20.466847, 77.989570>,
        < -35.031719, -22.662137, 76.871010>
      }
      triangle {
        <-32.983212, -22.567747, 77.555700>,
        <-32.983212, -24.371897, 75.992400>,
        < -35.031719, -22.662137, 76.871010>
      }
      triangle {
        <-40.000000, -18.033327, 78.375000>,
        <-35.031719, -18.033327, 78.375000>,
        < -35.031719, -20.466837, 77.989570>
      }
      triangle {
        <-32.983212, -20.396257, 78.547390>,
        <-35.031719, -20.466837, 77.989570>,
        < -35.031719, -18.033327, 78.375000>
      }
      triangle {
        <-40.000000, -20.466847, 77.989570>,
        <-40.000000, -18.033327, 78.375000>,
        < -35.031719, -20.466837, 77.989570>
      }
      triangle {
        <-32.983212, -20.396257, 78.547390>,
        <-32.983212, -22.567747, 77.555700>,
        < -35.031719, -20.466837, 77.989570>
      }
      triangle {
        <-40.000000, -15.599808, 77.989570>,
        <-35.031719, -18.033327, 78.375000>,
        < -40.000000, -18.033327, 78.375000>
      }
      triangle {
        <-32.983212, -18.033327, 78.887130>,
        <-32.983212, -20.396257, 78.547390>,
        < -35.031719, -18.033327, 78.375000>
      }
      triangle {
        <-35.031719, -15.599817, 77.989570>,
        <-32.983212, -18.033327, 78.887130>,
        < -35.031719, -18.033327, 78.375000>
      }
      triangle {
        <-35.031719, -15.599817, 77.989570>,
        <-35.031719, -18.033327, 78.375000>,
        < -40.000000, -15.599808, 77.989570>
      }
      triangle {
        <-40.000000, -18.033327, 75.933010>,
        <-40.000000, -18.033327, 78.375000>,
        < -40.000000, -20.466847, 77.989570>
      }
      triangle {
        <-40.000000, -16.175117, 75.605360>,
        <-40.000000, -15.599808, 77.989570>,
        < -40.000000, -18.033327, 78.375000>
      }
      triangle {
        <-40.000000, -16.175117, 75.605360>,
        <-40.000000, -18.033327, 78.375000>,
        < -40.000000, -18.033327, 75.933010>
      }
      triangle {
        <-40.000000, -21.525607, 74.661920>,
        <-40.000000, -20.466847, 77.989570>,
        < -40.000000, -22.662147, 76.871000>
      }
      triangle {
        <-40.000000, -19.891537, 75.605360>,
        <-40.000000, -18.033327, 75.933010>,
        < -40.000000, -20.466847, 77.989570>
      }
      triangle {
        <-40.000000, -21.525607, 74.661920>,
        <-40.000000, -19.891537, 75.605360>,
        < -40.000000, -20.466847, 77.989570>
      }
      triangle {
        <-40.000000, -22.738457, 73.216499>,
        <-40.000000, -22.662147, 76.871000>,
        < -40.000000, -24.404337, 75.128800>
      }
      triangle {
        <-40.000000, -22.738457, 73.216499>,
        <-40.000000, -21.525607, 74.661920>,
        < -40.000000, -22.662147, 76.871000>
      }
      triangle {
        <-40.000000, -24.404337, 65.871201>,
        <-40.000000, -24.404337, 75.128800>,
        < -40.000000, -25.522897, 72.933500>
      }
      triangle {
        <-40.000000, -23.383797, 71.443430>,
        <-40.000000, -24.404337, 75.128800>,
        < -40.000000, -24.404337, 65.871201>
      }
      triangle {
        <-40.000000, -23.383797, 71.443430>,
        <-40.000000, -22.738457, 73.216499>,
        < -40.000000, -24.404337, 75.128800>
      }
      triangle {
        <-40.000000, -25.522897, 68.066500>,
        <-40.000000, -25.522897, 72.933500>,
        < -40.000000, -25.908327, 70.500000>
      }
      triangle {
        <-40.000000, -24.404337, 65.871201>,
        <-40.000000, -25.522897, 72.933500>,
        < -40.000000, -25.522897, 68.066500>
      }
      triangle {
        <-40.000000, -23.383797, 69.556570>,
        <-40.000000, -24.404337, 65.871201>,
        < -40.000000, -22.662147, 64.129000>
      }
      triangle {
        <-40.000000, -23.383797, 69.556570>,
        <-40.000000, -23.383797, 71.443430>,
        < -40.000000, -24.404337, 65.871201>
      }
      triangle {
        <-40.000000, -21.525607, 66.338079>,
        <-40.000000, -22.662147, 64.129000>,
        < -40.000000, -20.466847, 63.010429>
      }
      triangle {
        <-40.000000, -22.738457, 67.783501>,
        <-40.000000, -23.383797, 69.556570>,
        < -40.000000, -22.662147, 64.129000>
      }
      triangle {
        <-40.000000, -21.525607, 66.338079>,
        <-40.000000, -22.738457, 67.783501>,
        < -40.000000, -22.662147, 64.129000>
      }
      triangle {
        <-40.000000, -19.891537, 65.394640>,
        <-40.000000, -21.525607, 66.338079>,
        < -40.000000, -20.466847, 63.010429>
      }
      triangle {
        <-32.495338, -18.033327, 61.625000>,
        <-32.983212, -18.033327, 62.112869>,
        < -32.983212, -20.396257, 62.452610>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.983212, -18.033327, 62.112869>,
        < -32.495338, -18.033327, 61.625000>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.983212, -15.670397, 62.452610>,
        < -32.983212, -18.033327, 62.112869>
      }
      triangle {
        <-32.495338, -20.533707, 61.984501>,
        <-32.983212, -20.396257, 62.452610>,
        < -32.983212, -22.567747, 63.444300>
      }
      triangle {
        <-32.495338, -20.533707, 61.984501>,
        <-32.495338, -18.033327, 61.625000>,
        < -32.983212, -20.396257, 62.452610>
      }
      triangle {
        <-32.495338, -22.831517, 63.033871>,
        <-32.983212, -22.567747, 63.444300>,
        < -32.983212, -24.371897, 65.007601>
      }
      triangle {
        <-32.495338, -22.831517, 63.033871>,
        <-32.495338, -20.533707, 61.984501>,
        < -32.983212, -22.567747, 63.444300>
      }
      triangle {
        <-32.495338, -26.106311, 66.813190>,
        <-32.983212, -24.371897, 65.007601>,
        < -32.983212, -25.662527, 67.015860>
      }
      triangle {
        <-32.495338, -24.740607, 64.688110>,
        <-32.495338, -22.831517, 63.033871>,
        < -32.983212, -24.371897, 65.007601>
      }
      triangle {
        <-32.495338, -26.106311, 66.813190>,
        <-32.495338, -24.740607, 64.688110>,
        < -32.983212, -24.371897, 65.007601>
      }
      triangle {
        <-32.495338, -26.106311, 66.813190>,
        <-32.983212, -25.662527, 67.015860>,
        < -32.983212, -26.335088, 69.306391>
      }
      triangle {
        <-32.495338, -26.817992, 69.236959>,
        <-32.983212, -26.335088, 69.306391>,
        < -32.983212, -26.335088, 71.693609>
      }
      triangle {
        <-32.495338, -26.817992, 69.236959>,
        <-32.495338, -26.106311, 66.813190>,
        < -32.983212, -26.335088, 69.306391>
      }
      triangle {
        <-32.495338, -26.817992, 71.763041>,
        <-32.983212, -26.335088, 71.693609>,
        < -32.983212, -25.662527, 73.984140>
      }
      triangle {
        <-32.495338, -26.817992, 71.763041>,
        <-32.495338, -26.817992, 69.236959>,
        < -32.983212, -26.335088, 71.693609>
      }
      triangle {
        <-32.495338, -26.106311, 74.186810>,
        <-32.983212, -25.662527, 73.984140>,
        < -32.983212, -24.371897, 75.992400>
      }
      triangle {
        <-32.495338, -26.106311, 74.186810>,
        <-32.495338, -26.817992, 71.763041>,
        < -32.983212, -25.662527, 73.984140>
      }
      triangle {
        <-32.495338, -22.831517, 77.966130>,
        <-32.983212, -24.371897, 75.992400>,
        < -32.983212, -22.567747, 77.555700>
      }
      triangle {
        <-32.495338, -24.740607, 76.311890>,
        <-32.495338, -26.106311, 74.186810>,
        < -32.983212, -24.371897, 75.992400>
      }
      triangle {
        <-32.495338, -22.831517, 77.966130>,
        <-32.495338, -24.740607, 76.311890>,
        < -32.983212, -24.371897, 75.992400>
      }
      triangle {
        <-32.495338, -20.533707, 79.015500>,
        <-32.983212, -22.567747, 77.555700>,
        < -32.983212, -20.396257, 78.547390>
      }
      triangle {
        <-32.495338, -20.533707, 79.015500>,
        <-32.495338, -22.831517, 77.966130>,
        < -32.983212, -22.567747, 77.555700>
      }
      triangle {
        <-32.495338, -20.533707, 79.015500>,
        <-32.983212, -20.396257, 78.547390>,
        < -32.983212, -18.033327, 78.887130>
      }
      triangle {
        <-32.495338, -18.033327, 79.375000>,
        <-32.495338, -20.533707, 79.015500>,
        < -32.983212, -18.033327, 78.887130>
      }
      triangle {
        <-32.983212, -15.670397, 78.547390>,
        <-32.495338, -18.033327, 79.375000>,
        < -32.983212, -18.033327, 78.887130>
      }
      triangle {
        <-32.983212, -15.670397, 78.547390>,
        <-32.983212, -18.033327, 78.887130>,
        < -35.031719, -15.599817, 77.989570>
      }
      triangle {
        <-32.047112, -18.033327, 61.625000>,
        <-32.495338, -18.033327, 61.625000>,
        < -32.495338, -20.533707, 61.984501>
      }
      triangle {
        <-32.047112, -15.532947, 61.984501>,
        <-32.495338, -18.033327, 61.625000>,
        < -32.047112, -18.033327, 61.625000>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.495338, -18.033327, 61.625000>,
        < -32.047112, -15.532947, 61.984501>
      }
      triangle {
        <-32.047112, -20.533707, 61.984501>,
        <-32.495338, -20.533707, 61.984501>,
        < -32.495338, -22.831517, 63.033871>
      }
      triangle {
        <-32.047112, -20.533707, 61.984501>,
        <-32.047112, -18.033327, 61.625000>,
        < -32.495338, -20.533707, 61.984501>
      }
      triangle {
        <-32.047112, -22.831517, 63.033871>,
        <-32.495338, -22.831517, 63.033871>,
        < -32.495338, -24.740607, 64.688110>
      }
      triangle {
        <-32.047112, -22.831517, 63.033871>,
        <-32.047112, -20.533707, 61.984501>,
        < -32.495338, -22.831517, 63.033871>
      }
      triangle {
        <-32.047112, -24.740597, 64.688110>,
        <-32.495338, -24.740607, 64.688110>,
        < -32.495338, -26.106311, 66.813190>
      }
      triangle {
        <-32.047112, -24.740597, 64.688110>,
        <-32.047112, -22.831517, 63.033871>,
        < -32.495338, -24.740607, 64.688110>
      }
      triangle {
        <-32.047112, -26.106313, 66.813200>,
        <-32.495338, -26.106311, 66.813190>,
        < -32.495338, -26.817992, 69.236959>
      }
      triangle {
        <-32.047112, -26.106313, 66.813200>,
        <-32.047112, -24.740597, 64.688110>,
        < -32.495338, -26.106311, 66.813190>
      }
      triangle {
        <-32.047112, -26.817993, 69.236959>,
        <-32.495338, -26.817992, 69.236959>,
        < -32.495338, -26.817992, 71.763041>
      }
      triangle {
        <-32.047112, -26.817993, 69.236959>,
        <-32.047112, -26.106313, 66.813200>,
        < -32.495338, -26.817992, 69.236959>
      }
      triangle {
        <-32.047112, -26.817993, 71.763041>,
        <-32.495338, -26.817992, 71.763041>,
        < -32.495338, -26.106311, 74.186810>
      }
      triangle {
        <-32.047112, -26.817993, 71.763041>,
        <-32.047112, -26.817993, 69.236959>,
        < -32.495338, -26.817992, 71.763041>
      }
      triangle {
        <-32.047112, -26.106313, 74.186800>,
        <-32.495338, -26.106311, 74.186810>,
        < -32.495338, -24.740607, 76.311890>
      }
      triangle {
        <-32.047112, -26.106313, 74.186800>,
        <-32.047112, -26.817993, 71.763041>,
        < -32.495338, -26.106311, 74.186810>
      }
      triangle {
        <-32.047112, -24.740597, 76.311890>,
        <-32.495338, -24.740607, 76.311890>,
        < -32.495338, -22.831517, 77.966130>
      }
      triangle {
        <-32.047112, -24.740597, 76.311890>,
        <-32.047112, -26.106313, 74.186800>,
        < -32.495338, -24.740607, 76.311890>
      }
      triangle {
        <-32.047112, -22.831517, 77.966130>,
        <-32.495338, -22.831517, 77.966130>,
        < -32.495338, -20.533707, 79.015500>
      }
      triangle {
        <-32.047112, -22.831517, 77.966130>,
        <-32.047112, -24.740597, 76.311890>,
        < -32.495338, -22.831517, 77.966130>
      }
      triangle {
        <-32.047112, -20.533707, 79.015500>,
        <-32.495338, -20.533707, 79.015500>,
        < -32.495338, -18.033327, 79.375000>
      }
      triangle {
        <-32.047112, -20.533707, 79.015500>,
        <-32.047112, -22.831517, 77.966130>,
        < -32.495338, -20.533707, 79.015500>
      }
      triangle {
        <-32.047112, -18.033327, 79.375000>,
        <-32.047112, -20.533707, 79.015500>,
        < -32.495338, -18.033327, 79.375000>
      }
      triangle {
        <-32.495338, -15.532947, 79.015500>,
        <-32.047112, -18.033327, 79.375000>,
        < -32.495338, -18.033327, 79.375000>
      }
      triangle {
        <-32.495338, -15.532947, 79.015500>,
        <-32.495338, -18.033327, 79.375000>,
        < -32.983212, -15.670397, 78.547390>
      }
      triangle {
        <-32.047112, -18.033327, 61.500000>,
        <-32.047112, -18.033327, 61.625000>,
        < -32.047112, -20.533707, 61.984501>
      }
      triangle {
        <-32.047112, -15.497726, 61.864571>,
        <-32.047112, -15.532947, 61.984501>,
        < -32.047112, -18.033327, 61.625000>
      }
      triangle {
        <-32.047112, -15.497726, 61.864571>,
        <-32.047112, -18.033327, 61.625000>,
        < -32.047112, -18.033327, 61.500000>
      }
      triangle {
        <-32.047112, -20.568927, 61.864571>,
        <-32.047112, -20.533707, 61.984501>,
        < -32.047112, -22.831517, 63.033871>
      }
      triangle {
        <-32.047112, -20.568927, 61.864571>,
        <-32.047112, -18.033327, 61.500000>,
        < -32.047112, -20.533707, 61.984501>
      }
      triangle {
        <-32.047112, -22.899097, 62.928720>,
        <-32.047112, -22.831517, 63.033871>,
        < -32.047112, -24.740597, 64.688110>
      }
      triangle {
        <-32.047112, -22.899097, 62.928720>,
        <-32.047112, -20.568927, 61.864571>,
        < -32.047112, -22.831517, 63.033871>
      }
      triangle {
        <-32.047112, -24.835067, 64.606251>,
        <-32.047112, -24.740597, 64.688110>,
        < -32.047112, -26.106313, 66.813200>
      }
      triangle {
        <-32.047112, -24.835067, 64.606251>,
        <-32.047112, -22.899097, 62.928720>,
        < -32.047112, -24.740597, 64.688110>
      }
      triangle {
        <-32.047112, -26.220017, 66.761271>,
        <-32.047112, -26.106313, 66.813200>,
        < -32.047112, -26.817993, 69.236959>
      }
      triangle {
        <-32.047112, -26.220017, 66.761271>,
        <-32.047112, -24.835067, 64.606251>,
        < -32.047112, -26.106313, 66.813200>
      }
      triangle {
        <-32.047112, -26.941720, 71.780830>,
        <-32.047112, -26.817993, 69.236959>,
        < -32.047112, -26.817993, 71.763041>
      }
      triangle {
        <-32.047112, -26.941720, 69.219170>,
        <-32.047112, -26.220017, 66.761271>,
        < -32.047112, -26.817993, 69.236959>
      }
      triangle {
        <-32.047112, -26.941720, 71.780830>,
        <-32.047112, -26.941720, 69.219170>,
        < -32.047112, -26.817993, 69.236959>
      }
      triangle {
        <-32.047112, -26.220017, 74.238729>,
        <-32.047112, -26.817993, 71.763041>,
        < -32.047112, -26.106313, 74.186800>
      }
      triangle {
        <-32.047112, -26.220017, 74.238729>,
        <-32.047112, -26.941720, 71.780830>,
        < -32.047112, -26.817993, 71.763041>
      }
      triangle {
        <-32.047112, -24.835067, 76.393750>,
        <-32.047112, -26.106313, 74.186800>,
        < -32.047112, -24.740597, 76.311890>
      }
      triangle {
        <-32.047112, -24.835067, 76.393750>,
        <-32.047112, -26.220017, 74.238729>,
        < -32.047112, -26.106313, 74.186800>
      }
      triangle {
        <-32.047112, -22.899097, 78.071280>,
        <-32.047112, -24.740597, 76.311890>,
        < -32.047112, -22.831517, 77.966130>
      }
      triangle {
        <-32.047112, -22.899097, 78.071280>,
        <-32.047112, -24.835067, 76.393750>,
        < -32.047112, -24.740597, 76.311890>
      }
      triangle {
        <-32.047112, -20.568927, 79.135430>,
        <-32.047112, -22.831517, 77.966130>,
        < -32.047112, -20.533707, 79.015500>
      }
      triangle {
        <-32.047112, -20.568927, 79.135430>,
        <-32.047112, -22.899097, 78.071280>,
        < -32.047112, -22.831517, 77.966130>
      }
      triangle {
        <-32.047112, -20.568927, 79.135430>,
        <-32.047112, -20.533707, 79.015500>,
        < -32.047112, -18.033327, 79.375000>
      }
      triangle {
        <-32.047112, -18.033327, 79.500000>,
        <-32.047112, -18.033327, 79.375000>,
        < -32.047112, -15.532947, 79.015500>
      }
      triangle {
        <-32.495338, -15.532947, 79.015500>,
        <-32.047112, -15.532947, 79.015500>,
        < -32.047112, -18.033327, 79.375000>
      }
      triangle {
        <-32.047112, -18.033327, 79.500000>,
        <-32.047112, -20.568927, 79.135430>,
        < -32.047112, -18.033327, 79.375000>
      }
      triangle {
        <-32.047112, -15.497726, 61.864571>,
        <-32.047112, -13.235138, 63.033871>,
        < -32.047112, -15.532947, 61.984501>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.047112, -15.532947, 61.984501>,
        < -32.047112, -13.235138, 63.033871>
      }
      triangle {
        <-32.047112, -13.167557, 62.928720>,
        <-32.047112, -11.326057, 64.688110>,
        < -32.047112, -13.235138, 63.033871>
      }
      triangle {
        <-32.495338, -13.235138, 63.033871>,
        <-32.047112, -13.235138, 63.033871>,
        < -32.047112, -11.326057, 64.688110>
      }
      triangle {
        <-32.047112, -15.497726, 61.864571>,
        <-32.047112, -13.167557, 62.928720>,
        < -32.047112, -13.235138, 63.033871>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.047112, -13.235138, 63.033871>,
        < -32.495338, -13.235138, 63.033871>
      }
      triangle {
        <-32.047112, -11.231586, 64.606251>,
        <-32.047112, -9.960337, 66.813200>,
        < -32.047112, -11.326057, 64.688110>
      }
      triangle {
        <-32.495338, -11.326048, 64.688110>,
        <-32.047112, -11.326057, 64.688110>,
        < -32.047112, -9.960337, 66.813200>
      }
      triangle {
        <-32.047112, -13.167557, 62.928720>,
        <-32.047112, -11.231586, 64.606251>,
        < -32.047112, -11.326057, 64.688110>
      }
      triangle {
        <-32.495338, -13.235138, 63.033871>,
        <-32.047112, -11.326057, 64.688110>,
        < -32.495338, -11.326048, 64.688110>
      }
      triangle {
        <-32.047112, -9.846638, 66.761271>,
        <-32.047112, -9.248657, 69.236959>,
        < -32.047112, -9.960337, 66.813200>
      }
      triangle {
        <-32.495338, -9.960346, 66.813190>,
        <-32.047112, -9.960337, 66.813200>,
        < -32.047112, -9.248657, 69.236959>
      }
      triangle {
        <-32.047112, -11.231586, 64.606251>,
        <-32.047112, -9.846638, 66.761271>,
        < -32.047112, -9.960337, 66.813200>
      }
      triangle {
        <-32.495338, -11.326048, 64.688110>,
        <-32.047112, -9.960337, 66.813200>,
        < -32.495338, -9.960346, 66.813190>
      }
      triangle {
        <-32.047112, -9.124937, 69.219170>,
        <-32.047112, -9.248657, 71.763041>,
        < -32.047112, -9.248657, 69.236959>
      }
      triangle {
        <-32.495338, -9.248657, 69.236959>,
        <-32.047112, -9.248657, 69.236959>,
        < -32.047112, -9.248657, 71.763041>
      }
      triangle {
        <-32.047112, -9.846638, 66.761271>,
        <-32.047112, -9.124937, 69.219170>,
        < -32.047112, -9.248657, 69.236959>
      }
      triangle {
        <-32.495338, -9.960346, 66.813190>,
        <-32.047112, -9.248657, 69.236959>,
        < -32.495338, -9.248657, 69.236959>
      }
      triangle {
        <-32.047112, -9.846638, 74.238729>,
        <-32.047112, -9.960337, 74.186800>,
        < -32.047112, -9.248657, 71.763041>
      }
      triangle {
        <-32.495338, -9.248657, 71.763041>,
        <-32.047112, -9.248657, 71.763041>,
        < -32.047112, -9.960337, 74.186800>
      }
      triangle {
        <-32.047112, -9.124937, 71.780830>,
        <-32.047112, -9.846638, 74.238729>,
        < -32.047112, -9.248657, 71.763041>
      }
      triangle {
        <-32.047112, -9.124937, 69.219170>,
        <-32.047112, -9.124937, 71.780830>,
        < -32.047112, -9.248657, 71.763041>
      }
      triangle {
        <-32.495338, -9.248657, 69.236959>,
        <-32.047112, -9.248657, 71.763041>,
        < -32.495338, -9.248657, 71.763041>
      }
      triangle {
        <-32.047112, -11.231586, 76.393750>,
        <-32.047112, -11.326057, 76.311890>,
        < -32.047112, -9.960337, 74.186800>
      }
      triangle {
        <-32.495338, -9.960346, 74.186810>,
        <-32.047112, -9.960337, 74.186800>,
        < -32.047112, -11.326057, 76.311890>
      }
      triangle {
        <-32.047112, -9.846638, 74.238729>,
        <-32.047112, -11.231586, 76.393750>,
        < -32.047112, -9.960337, 74.186800>
      }
      triangle {
        <-32.495338, -9.248657, 71.763041>,
        <-32.047112, -9.960337, 74.186800>,
        < -32.495338, -9.960346, 74.186810>
      }
      triangle {
        <-32.047112, -13.167557, 78.071280>,
        <-32.047112, -13.235138, 77.966130>,
        < -32.047112, -11.326057, 76.311890>
      }
      triangle {
        <-32.495338, -11.326048, 76.311890>,
        <-32.047112, -11.326057, 76.311890>,
        < -32.047112, -13.235138, 77.966130>
      }
      triangle {
        <-32.047112, -11.231586, 76.393750>,
        <-32.047112, -13.167557, 78.071280>,
        < -32.047112, -11.326057, 76.311890>
      }
      triangle {
        <-32.495338, -9.960346, 74.186810>,
        <-32.047112, -11.326057, 76.311890>,
        < -32.495338, -11.326048, 76.311890>
      }
      triangle {
        <-32.047112, -15.497726, 79.135430>,
        <-32.047112, -15.532947, 79.015500>,
        < -32.047112, -13.235138, 77.966130>
      }
      triangle {
        <-32.495338, -13.235138, 77.966130>,
        <-32.047112, -13.235138, 77.966130>,
        < -32.047112, -15.532947, 79.015500>
      }
      triangle {
        <-32.047112, -13.167557, 78.071280>,
        <-32.047112, -15.497726, 79.135430>,
        < -32.047112, -13.235138, 77.966130>
      }
      triangle {
        <-32.495338, -11.326048, 76.311890>,
        <-32.047112, -13.235138, 77.966130>,
        < -32.495338, -13.235138, 77.966130>
      }
      triangle {
        <-32.047112, -15.497726, 79.135430>,
        <-32.047112, -18.033327, 79.500000>,
        < -32.047112, -15.532947, 79.015500>
      }
      triangle {
        <-32.495338, -13.235138, 77.966130>,
        <-32.047112, -15.532947, 79.015500>,
        < -32.495338, -15.532947, 79.015500>
      }
      triangle {
        <-32.547112, -18.033327, 61.500000>,
        <-32.047112, -18.033327, 61.500000>,
        < -32.047112, -20.568927, 61.864571>
      }
      triangle {
        <-32.547112, -15.497738, 61.864559>,
        <-32.047112, -15.497726, 61.864571>,
        < -32.047112, -18.033327, 61.500000>
      }
      triangle {
        <-32.547112, -15.497738, 61.864559>,
        <-32.047112, -18.033327, 61.500000>,
        < -32.547112, -18.033327, 61.500000>
      }
      triangle {
        <-32.547112, -20.568917, 61.864559>,
        <-32.047112, -20.568927, 61.864571>,
        < -32.047112, -22.899097, 62.928720>
      }
      triangle {
        <-32.547112, -20.568917, 61.864559>,
        <-32.547112, -18.033327, 61.500000>,
        < -32.047112, -20.568927, 61.864571>
      }
      triangle {
        <-32.547112, -22.899097, 62.928720>,
        <-32.047112, -22.899097, 62.928720>,
        < -32.047112, -24.835067, 64.606251>
      }
      triangle {
        <-32.547112, -22.899097, 62.928720>,
        <-32.547112, -20.568917, 61.864559>,
        < -32.047112, -22.899097, 62.928720>
      }
      triangle {
        <-32.547112, -24.835077, 64.606251>,
        <-32.047112, -24.835067, 64.606251>,
        < -32.047112, -26.220017, 66.761271>
      }
      triangle {
        <-32.547112, -24.835077, 64.606251>,
        <-32.547112, -22.899097, 62.928720>,
        < -32.047112, -24.835067, 64.606251>
      }
      triangle {
        <-32.547112, -26.220015, 66.761259>,
        <-32.047112, -26.220017, 66.761271>,
        < -32.047112, -26.941720, 69.219170>
      }
      triangle {
        <-32.547112, -26.220015, 66.761259>,
        <-32.547112, -24.835077, 64.606251>,
        < -32.047112, -26.220017, 66.761271>
      }
      triangle {
        <-32.547112, -26.941720, 69.219170>,
        <-32.047112, -26.941720, 69.219170>,
        < -32.047112, -26.941720, 71.780830>
      }
      triangle {
        <-32.547112, -26.941720, 69.219170>,
        <-32.547112, -26.220015, 66.761259>,
        < -32.047112, -26.941720, 69.219170>
      }
      triangle {
        <-32.547112, -26.941720, 71.780830>,
        <-32.047112, -26.941720, 71.780830>,
        < -32.047112, -26.220017, 74.238729>
      }
      triangle {
        <-32.547112, -26.941720, 71.780830>,
        <-32.547112, -26.941720, 69.219170>,
        < -32.047112, -26.941720, 71.780830>
      }
      triangle {
        <-32.547112, -26.220015, 74.238741>,
        <-32.047112, -26.220017, 74.238729>,
        < -32.047112, -24.835067, 76.393750>
      }
      triangle {
        <-32.547112, -26.220015, 74.238741>,
        <-32.547112, -26.941720, 71.780830>,
        < -32.047112, -26.220017, 74.238729>
      }
      triangle {
        <-32.547112, -24.835077, 76.393750>,
        <-32.047112, -24.835067, 76.393750>,
        < -32.047112, -22.899097, 78.071280>
      }
      triangle {
        <-32.547112, -24.835077, 76.393750>,
        <-32.547112, -26.220015, 74.238741>,
        < -32.047112, -24.835067, 76.393750>
      }
      triangle {
        <-32.547112, -22.899097, 78.071280>,
        <-32.047112, -22.899097, 78.071280>,
        < -32.047112, -20.568927, 79.135430>
      }
      triangle {
        <-32.547112, -22.899097, 78.071280>,
        <-32.547112, -24.835077, 76.393750>,
        < -32.047112, -22.899097, 78.071280>
      }
      triangle {
        <-32.547112, -20.568917, 79.135440>,
        <-32.047112, -20.568927, 79.135430>,
        < -32.047112, -18.033327, 79.500000>
      }
      triangle {
        <-32.547112, -20.568917, 79.135440>,
        <-32.547112, -22.899097, 78.071280>,
        < -32.047112, -20.568927, 79.135430>
      }
      triangle {
        <-32.547112, -18.033327, 79.500000>,
        <-32.047112, -18.033327, 79.500000>,
        < -32.047112, -15.497726, 79.135430>
      }
      triangle {
        <-32.547112, -18.033327, 79.500000>,
        <-32.547112, -20.568917, 79.135440>,
        < -32.047112, -18.033327, 79.500000>
      }
      triangle {
        <-32.547112, -15.497738, 79.135440>,
        <-32.047112, -15.497726, 79.135430>,
        < -32.047112, -13.167557, 78.071280>
      }
      triangle {
        <-32.547112, -15.497738, 79.135440>,
        <-32.547112, -18.033327, 79.500000>,
        < -32.047112, -15.497726, 79.135430>
      }
      triangle {
        <-32.547112, -13.167557, 78.071280>,
        <-32.047112, -13.167557, 78.071280>,
        < -32.047112, -11.231586, 76.393750>
      }
      triangle {
        <-32.547112, -13.167557, 78.071280>,
        <-32.547112, -15.497738, 79.135440>,
        < -32.047112, -13.167557, 78.071280>
      }
      triangle {
        <-32.547112, -11.231577, 76.393750>,
        <-32.047112, -11.231586, 76.393750>,
        < -32.047112, -9.846638, 74.238729>
      }
      triangle {
        <-32.547112, -11.231577, 76.393750>,
        <-32.547112, -13.167557, 78.071280>,
        < -32.047112, -11.231586, 76.393750>
      }
      triangle {
        <-32.547112, -9.846638, 74.238741>,
        <-32.047112, -9.846638, 74.238729>,
        < -32.047112, -9.124937, 71.780830>
      }
      triangle {
        <-32.547112, -9.846638, 74.238741>,
        <-32.547112, -11.231577, 76.393750>,
        < -32.047112, -9.846638, 74.238729>
      }
      triangle {
        <-32.547112, -9.124937, 71.780830>,
        <-32.047112, -9.124937, 71.780830>,
        < -32.047112, -9.124937, 69.219170>
      }
      triangle {
        <-32.547112, -9.124937, 71.780830>,
        <-32.547112, -9.846638, 74.238741>,
        < -32.047112, -9.124937, 71.780830>
      }
      triangle {
        <-32.547112, -9.124937, 69.219170>,
        <-32.047112, -9.124937, 69.219170>,
        < -32.047112, -9.846638, 66.761271>
      }
      triangle {
        <-32.547112, -9.124937, 69.219170>,
        <-32.547112, -9.124937, 71.780830>,
        < -32.047112, -9.124937, 69.219170>
      }
      triangle {
        <-32.547112, -9.846638, 66.761259>,
        <-32.047112, -9.846638, 66.761271>,
        < -32.047112, -11.231586, 64.606251>
      }
      triangle {
        <-32.547112, -9.846638, 66.761259>,
        <-32.547112, -9.124937, 69.219170>,
        < -32.047112, -9.846638, 66.761271>
      }
      triangle {
        <-32.547112, -11.231577, 64.606251>,
        <-32.047112, -11.231586, 64.606251>,
        < -32.047112, -13.167557, 62.928720>
      }
      triangle {
        <-32.547112, -11.231577, 64.606251>,
        <-32.547112, -9.846638, 66.761259>,
        < -32.047112, -11.231586, 64.606251>
      }
      triangle {
        <-32.547112, -13.167557, 62.928720>,
        <-32.047112, -13.167557, 62.928720>,
        < -32.047112, -15.497726, 61.864571>
      }
      triangle {
        <-32.547112, -13.167557, 62.928720>,
        <-32.547112, -11.231577, 64.606251>,
        < -32.047112, -13.167557, 62.928720>
      }
      triangle {
        <-32.547112, -15.497738, 61.864559>,
        <-32.547112, -13.167557, 62.928720>,
        < -32.047112, -15.497726, 61.864571>
      }
      triangle {
        <-33.047112, -18.033327, 62.000000>,
        <-32.547112, -18.033327, 61.500000>,
        < -32.547112, -20.568917, 61.864559>
      }
      triangle {
        <-33.047112, -15.638597, 62.344311>,
        <-32.547112, -18.033327, 61.500000>,
        < -33.047112, -18.033327, 62.000000>
      }
      triangle {
        <-33.047112, -15.638597, 62.344311>,
        <-32.547112, -15.497738, 61.864559>,
        < -32.547112, -18.033327, 61.500000>
      }
      triangle {
        <-33.047112, -20.428057, 62.344311>,
        <-32.547112, -20.568917, 61.864559>,
        < -32.547112, -22.899097, 62.928720>
      }
      triangle {
        <-33.047112, -20.428057, 62.344311>,
        <-33.047112, -18.033327, 62.000000>,
        < -32.547112, -20.568917, 61.864559>
      }
      triangle {
        <-33.047112, -22.628777, 63.349340>,
        <-32.547112, -22.899097, 62.928720>,
        < -32.547112, -24.835077, 64.606251>
      }
      triangle {
        <-33.047112, -22.628777, 63.349340>,
        <-33.047112, -20.428057, 62.344311>,
        < -32.547112, -22.899097, 62.928720>
      }
      triangle {
        <-33.047112, -24.457197, 64.933680>,
        <-32.547112, -24.835077, 64.606251>,
        < -32.547112, -26.220015, 66.761259>
      }
      triangle {
        <-33.047112, -24.457197, 64.933680>,
        <-33.047112, -22.628777, 63.349340>,
        < -32.547112, -24.835077, 64.606251>
      }
      triangle {
        <-33.047112, -25.765197, 66.968969>,
        <-32.547112, -26.220015, 66.761259>,
        < -32.547112, -26.941720, 69.219170>
      }
      triangle {
        <-33.047112, -25.765197, 66.968969>,
        <-33.047112, -24.457197, 64.933680>,
        < -32.547112, -26.220015, 66.761259>
      }
      triangle {
        <-33.047112, -26.446809, 69.290319>,
        <-32.547112, -26.941720, 69.219170>,
        < -32.547112, -26.941720, 71.780830>
      }
      triangle {
        <-33.047112, -26.446809, 69.290319>,
        <-33.047112, -25.765197, 66.968969>,
        < -32.547112, -26.941720, 69.219170>
      }
      triangle {
        <-33.047112, -26.446809, 71.709681>,
        <-32.547112, -26.941720, 71.780830>,
        < -32.547112, -26.220015, 74.238741>
      }
      triangle {
        <-33.047112, -26.446809, 71.709681>,
        <-33.047112, -26.446809, 69.290319>,
        < -32.547112, -26.941720, 71.780830>
      }
      triangle {
        <-33.047112, -25.765197, 74.031031>,
        <-32.547112, -26.220015, 74.238741>,
        < -32.547112, -24.835077, 76.393750>
      }
      triangle {
        <-33.047112, -25.765197, 74.031031>,
        <-33.047112, -26.446809, 71.709681>,
        < -32.547112, -26.220015, 74.238741>
      }
      triangle {
        <-33.047112, -24.457197, 76.066320>,
        <-32.547112, -24.835077, 76.393750>,
        < -32.547112, -22.899097, 78.071280>
      }
      triangle {
        <-33.047112, -24.457197, 76.066320>,
        <-33.047112, -25.765197, 74.031031>,
        < -32.547112, -24.835077, 76.393750>
      }
      triangle {
        <-33.047112, -22.628777, 77.650660>,
        <-32.547112, -22.899097, 78.071280>,
        < -32.547112, -20.568917, 79.135440>
      }
      triangle {
        <-33.047112, -22.628777, 77.650660>,
        <-33.047112, -24.457197, 76.066320>,
        < -32.547112, -22.899097, 78.071280>
      }
      triangle {
        <-33.047112, -20.428057, 78.655690>,
        <-32.547112, -20.568917, 79.135440>,
        < -32.547112, -18.033327, 79.500000>
      }
      triangle {
        <-33.047112, -20.428057, 78.655690>,
        <-33.047112, -22.628777, 77.650660>,
        < -32.547112, -20.568917, 79.135440>
      }
      triangle {
        <-33.047112, -18.033327, 79.000000>,
        <-33.047112, -20.428057, 78.655690>,
        < -32.547112, -18.033327, 79.500000>
      }
      triangle {
        <-32.547112, -15.497738, 79.135440>,
        <-33.047112, -18.033327, 79.000000>,
        < -32.547112, -18.033327, 79.500000>
      }
      triangle {
        <-35.047112, -18.033327, 62.500000>,
        <-33.047112, -18.033327, 62.000000>,
        < -33.047112, -20.428057, 62.344311>
      }
      triangle {
        <-35.047112, -15.561188, 62.891550>,
        <-33.047112, -18.033327, 62.000000>,
        < -35.047112, -18.033327, 62.500000>
      }
      triangle {
        <-35.047112, -15.561188, 62.891550>,
        <-33.047112, -15.638597, 62.344311>,
        < -33.047112, -18.033327, 62.000000>
      }
      triangle {
        <-35.047112, -20.505467, 62.891550>,
        <-33.047112, -20.428057, 62.344311>,
        < -33.047112, -22.628777, 63.349340>
      }
      triangle {
        <-35.047112, -20.505467, 62.891550>,
        <-35.047112, -18.033327, 62.500000>,
        < -33.047112, -20.428057, 62.344311>
      }
      triangle {
        <-35.047112, -22.735607, 64.027861>,
        <-33.047112, -22.628777, 63.349340>,
        < -33.047112, -24.457197, 64.933680>
      }
      triangle {
        <-35.047112, -22.735607, 64.027861>,
        <-35.047112, -20.505467, 62.891550>,
        < -33.047112, -22.628777, 63.349340>
      }
      triangle {
        <-35.047112, -24.505467, 65.797720>,
        <-33.047112, -24.457197, 64.933680>,
        < -33.047112, -25.765197, 66.968969>
      }
      triangle {
        <-35.047112, -24.505467, 65.797720>,
        <-35.047112, -22.735607, 64.027861>,
        < -33.047112, -24.457197, 64.933680>
      }
      triangle {
        <-35.047112, -25.641777, 68.027861>,
        <-33.047112, -25.765197, 66.968969>,
        < -33.047112, -26.446809, 69.290319>
      }
      triangle {
        <-35.047112, -25.641777, 68.027861>,
        <-35.047112, -24.505467, 65.797720>,
        < -33.047112, -25.765197, 66.968969>
      }
      triangle {
        <-35.047112, -26.033327, 70.500000>,
        <-33.047112, -26.446809, 69.290319>,
        < -33.047112, -26.446809, 71.709681>
      }
      triangle {
        <-35.047112, -26.033327, 70.500000>,
        <-35.047112, -25.641777, 68.027861>,
        < -33.047112, -26.446809, 69.290319>
      }
      triangle {
        <-35.047112, -25.641777, 72.972139>,
        <-33.047112, -26.446809, 71.709681>,
        < -33.047112, -25.765197, 74.031031>
      }
      triangle {
        <-35.047112, -25.641777, 72.972139>,
        <-35.047112, -26.033327, 70.500000>,
        < -33.047112, -26.446809, 71.709681>
      }
      triangle {
        <-35.047112, -24.505467, 75.202280>,
        <-33.047112, -25.765197, 74.031031>,
        < -33.047112, -24.457197, 76.066320>
      }
      triangle {
        <-35.047112, -24.505467, 75.202280>,
        <-35.047112, -25.641777, 72.972139>,
        < -33.047112, -25.765197, 74.031031>
      }
      triangle {
        <-35.047112, -22.735607, 76.972140>,
        <-33.047112, -24.457197, 76.066320>,
        < -33.047112, -22.628777, 77.650660>
      }
      triangle {
        <-35.047112, -22.735607, 76.972140>,
        <-35.047112, -24.505467, 75.202280>,
        < -33.047112, -24.457197, 76.066320>
      }
      triangle {
        <-35.047112, -20.505467, 78.108450>,
        <-33.047112, -22.628777, 77.650660>,
        < -33.047112, -20.428057, 78.655690>
      }
      triangle {
        <-35.047112, -20.505467, 78.108450>,
        <-35.047112, -22.735607, 76.972140>,
        < -33.047112, -22.628777, 77.650660>
      }
      triangle {
        <-35.047112, -20.505467, 78.108450>,
        <-33.047112, -20.428057, 78.655690>,
        < -33.047112, -18.033327, 79.000000>
      }
      triangle {
        <-35.047112, -18.033327, 78.500000>,
        <-35.047112, -20.505467, 78.108450>,
        < -33.047112, -18.033327, 79.000000>
      }
      triangle {
        <-33.047112, -15.638597, 78.655690>,
        <-35.047112, -18.033327, 78.500000>,
        < -33.047112, -18.033327, 79.000000>
      }
      triangle {
        <-33.047112, -15.638597, 78.655690>,
        <-33.047112, -18.033327, 79.000000>,
        < -32.547112, -15.497738, 79.135440>
      }
      triangle {
        <-40.047112, -18.033327, 62.500000>,
        <-35.047112, -18.033327, 62.500000>,
        < -35.047112, -20.505467, 62.891550>
      }
      triangle {
        <-40.047112, -15.561188, 62.891550>,
        <-35.047112, -18.033327, 62.500000>,
        < -40.047112, -18.033327, 62.500000>
      }
      triangle {
        <-40.047112, -15.561188, 62.891550>,
        <-35.047112, -15.561188, 62.891550>,
        < -35.047112, -18.033327, 62.500000>
      }
      triangle {
        <-40.047112, -20.505467, 62.891550>,
        <-35.047112, -20.505467, 62.891550>,
        < -35.047112, -22.735607, 64.027861>
      }
      triangle {
        <-40.047112, -20.505467, 62.891550>,
        <-40.047112, -18.033327, 62.500000>,
        < -35.047112, -20.505467, 62.891550>
      }
      triangle {
        <-40.047112, -22.735607, 64.027861>,
        <-35.047112, -22.735607, 64.027861>,
        < -35.047112, -24.505467, 65.797720>
      }
      triangle {
        <-40.047112, -22.735607, 64.027861>,
        <-40.047112, -20.505467, 62.891550>,
        < -35.047112, -22.735607, 64.027861>
      }
      triangle {
        <-40.047112, -24.505467, 65.797720>,
        <-35.047112, -24.505467, 65.797720>,
        < -35.047112, -25.641777, 68.027861>
      }
      triangle {
        <-40.047112, -24.505467, 65.797720>,
        <-40.047112, -22.735607, 64.027861>,
        < -35.047112, -24.505467, 65.797720>
      }
      triangle {
        <-40.047112, -25.641777, 68.027861>,
        <-35.047112, -25.641777, 68.027861>,
        < -35.047112, -26.033327, 70.500000>
      }
      triangle {
        <-40.047112, -25.641777, 68.027861>,
        <-40.047112, -24.505467, 65.797720>,
        < -35.047112, -25.641777, 68.027861>
      }
      triangle {
        <-40.047112, -26.033327, 70.500000>,
        <-35.047112, -26.033327, 70.500000>,
        < -35.047112, -25.641777, 72.972139>
      }
      triangle {
        <-40.047112, -26.033327, 70.500000>,
        <-40.047112, -25.641777, 68.027861>,
        < -35.047112, -26.033327, 70.500000>
      }
      triangle {
        <-40.047112, -25.641777, 72.972139>,
        <-35.047112, -25.641777, 72.972139>,
        < -35.047112, -24.505467, 75.202280>
      }
      triangle {
        <-40.047112, -25.641777, 72.972139>,
        <-40.047112, -26.033327, 70.500000>,
        < -35.047112, -25.641777, 72.972139>
      }
      triangle {
        <-40.047112, -24.505467, 75.202280>,
        <-35.047112, -24.505467, 75.202280>,
        < -35.047112, -22.735607, 76.972140>
      }
      triangle {
        <-40.047112, -24.505467, 75.202280>,
        <-40.047112, -25.641777, 72.972139>,
        < -35.047112, -24.505467, 75.202280>
      }
      triangle {
        <-40.047112, -22.735607, 76.972140>,
        <-35.047112, -22.735607, 76.972140>,
        < -35.047112, -20.505467, 78.108450>
      }
      triangle {
        <-40.047112, -22.735607, 76.972140>,
        <-40.047112, -24.505467, 75.202280>,
        < -35.047112, -22.735607, 76.972140>
      }
      triangle {
        <-40.047112, -20.505467, 78.108450>,
        <-35.047112, -20.505467, 78.108450>,
        < -35.047112, -18.033327, 78.500000>
      }
      triangle {
        <-40.047112, -20.505467, 78.108450>,
        <-40.047112, -22.735607, 76.972140>,
        < -35.047112, -20.505467, 78.108450>
      }
      triangle {
        <-40.047112, -18.033327, 78.500000>,
        <-40.047112, -20.505467, 78.108450>,
        < -35.047112, -18.033327, 78.500000>
      }
      triangle {
        <-35.047112, -15.561188, 78.108450>,
        <-40.047112, -18.033327, 78.500000>,
        < -35.047112, -18.033327, 78.500000>
      }
      triangle {
        <-35.047112, -15.561188, 78.108450>,
        <-35.047112, -18.033327, 78.500000>,
        < -33.047112, -15.638597, 78.655690>
      }
      triangle {
        <-42.047112, -18.033327, 62.000000>,
        <-40.047112, -18.033327, 62.500000>,
        < -40.047112, -20.505467, 62.891550>
      }
      triangle {
        <-42.047112, -15.638597, 62.344311>,
        <-40.047112, -18.033327, 62.500000>,
        < -42.047112, -18.033327, 62.000000>
      }
      triangle {
        <-42.047112, -15.638597, 62.344311>,
        <-40.047112, -15.561188, 62.891550>,
        < -40.047112, -18.033327, 62.500000>
      }
      triangle {
        <-42.047112, -22.628777, 63.349340>,
        <-40.047112, -20.505467, 62.891550>,
        < -40.047112, -22.735607, 64.027861>
      }
      triangle {
        <-42.047112, -20.428057, 62.344311>,
        <-42.047112, -18.033327, 62.000000>,
        < -40.047112, -20.505467, 62.891550>
      }
      triangle {
        <-42.047112, -22.628777, 63.349340>,
        <-42.047112, -20.428057, 62.344311>,
        < -40.047112, -20.505467, 62.891550>
      }
      triangle {
        <-42.047112, -24.457197, 64.933680>,
        <-40.047112, -22.735607, 64.027861>,
        < -40.047112, -24.505467, 65.797720>
      }
      triangle {
        <-42.047112, -24.457197, 64.933680>,
        <-42.047112, -22.628777, 63.349340>,
        < -40.047112, -22.735607, 64.027861>
      }
      triangle {
        <-42.047112, -25.765197, 66.968969>,
        <-40.047112, -24.505467, 65.797720>,
        < -40.047112, -25.641777, 68.027861>
      }
      triangle {
        <-42.047112, -25.765197, 66.968969>,
        <-42.047112, -24.457197, 64.933680>,
        < -40.047112, -24.505467, 65.797720>
      }
      triangle {
        <-42.047112, -26.446809, 69.290319>,
        <-40.047112, -25.641777, 68.027861>,
        < -40.047112, -26.033327, 70.500000>
      }
      triangle {
        <-42.047112, -26.446809, 69.290319>,
        <-42.047112, -25.765197, 66.968969>,
        < -40.047112, -25.641777, 68.027861>
      }
      triangle {
        <-42.047112, -26.446809, 71.709681>,
        <-40.047112, -26.033327, 70.500000>,
        < -40.047112, -25.641777, 72.972139>
      }
      triangle {
        <-42.047112, -26.446809, 71.709681>,
        <-42.047112, -26.446809, 69.290319>,
        < -40.047112, -26.033327, 70.500000>
      }
      triangle {
        <-42.047112, -25.765197, 74.031031>,
        <-40.047112, -25.641777, 72.972139>,
        < -40.047112, -24.505467, 75.202280>
      }
      triangle {
        <-42.047112, -25.765197, 74.031031>,
        <-42.047112, -26.446809, 71.709681>,
        < -40.047112, -25.641777, 72.972139>
      }
      triangle {
        <-42.047112, -24.457197, 76.066320>,
        <-40.047112, -24.505467, 75.202280>,
        < -40.047112, -22.735607, 76.972140>
      }
      triangle {
        <-42.047112, -24.457197, 76.066320>,
        <-42.047112, -25.765197, 74.031031>,
        < -40.047112, -24.505467, 75.202280>
      }
      triangle {
        <-42.047112, -22.628777, 77.650660>,
        <-40.047112, -22.735607, 76.972140>,
        < -40.047112, -20.505467, 78.108450>
      }
      triangle {
        <-42.047112, -22.628777, 77.650660>,
        <-42.047112, -24.457197, 76.066320>,
        < -40.047112, -22.735607, 76.972140>
      }
      triangle {
        <-42.047112, -20.428057, 78.655690>,
        <-40.047112, -20.505467, 78.108450>,
        < -40.047112, -18.033327, 78.500000>
      }
      triangle {
        <-42.047112, -20.428057, 78.655690>,
        <-42.047112, -22.628777, 77.650660>,
        < -40.047112, -20.505467, 78.108450>
      }
      triangle {
        <-42.047112, -18.033327, 79.000000>,
        <-42.047112, -20.428057, 78.655690>,
        < -40.047112, -18.033327, 78.500000>
      }
      triangle {
        <-40.047112, -15.561188, 78.108450>,
        <-42.047112, -18.033327, 79.000000>,
        < -40.047112, -18.033327, 78.500000>
      }
      triangle {
        <-40.047112, -15.561188, 78.108450>,
        <-40.047112, -18.033327, 78.500000>,
        < -35.047112, -15.561188, 78.108450>
      }
      triangle {
        <-42.547112, -18.033327, 61.500000>,
        <-42.047112, -18.033327, 62.000000>,
        < -42.047112, -20.428057, 62.344311>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-42.047112, -18.033327, 62.000000>,
        < -42.547112, -18.033327, 61.500000>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-42.047112, -15.638597, 62.344311>,
        < -42.047112, -18.033327, 62.000000>
      }
      triangle {
        <-42.547112, -20.568917, 61.864559>,
        <-42.047112, -20.428057, 62.344311>,
        < -42.047112, -22.628777, 63.349340>
      }
      triangle {
        <-42.547112, -20.568917, 61.864559>,
        <-42.547112, -18.033327, 61.500000>,
        < -42.047112, -20.428057, 62.344311>
      }
      triangle {
        <-42.547112, -22.899097, 62.928720>,
        <-42.047112, -22.628777, 63.349340>,
        < -42.047112, -24.457197, 64.933680>
      }
      triangle {
        <-42.547112, -22.899097, 62.928720>,
        <-42.547112, -20.568917, 61.864559>,
        < -42.047112, -22.628777, 63.349340>
      }
      triangle {
        <-42.547112, -24.835077, 64.606251>,
        <-42.047112, -24.457197, 64.933680>,
        < -42.047112, -25.765197, 66.968969>
      }
      triangle {
        <-42.547112, -24.835077, 64.606251>,
        <-42.547112, -22.899097, 62.928720>,
        < -42.047112, -24.457197, 64.933680>
      }
      triangle {
        <-42.547112, -26.220015, 66.761259>,
        <-42.047112, -25.765197, 66.968969>,
        < -42.047112, -26.446809, 69.290319>
      }
      triangle {
        <-42.547112, -26.220015, 66.761259>,
        <-42.547112, -24.835077, 64.606251>,
        < -42.047112, -25.765197, 66.968969>
      }
      triangle {
        <-42.547112, -26.941720, 69.219170>,
        <-42.047112, -26.446809, 69.290319>,
        < -42.047112, -26.446809, 71.709681>
      }
      triangle {
        <-42.547112, -26.941720, 69.219170>,
        <-42.547112, -26.220015, 66.761259>,
        < -42.047112, -26.446809, 69.290319>
      }
      triangle {
        <-42.547112, -26.941720, 71.780830>,
        <-42.047112, -26.446809, 71.709681>,
        < -42.047112, -25.765197, 74.031031>
      }
      triangle {
        <-42.547112, -26.941720, 71.780830>,
        <-42.547112, -26.941720, 69.219170>,
        < -42.047112, -26.446809, 71.709681>
      }
      triangle {
        <-42.547112, -24.835077, 76.393750>,
        <-42.047112, -25.765197, 74.031031>,
        < -42.047112, -24.457197, 76.066320>
      }
      triangle {
        <-42.547112, -26.220015, 74.238741>,
        <-42.547112, -26.941720, 71.780830>,
        < -42.047112, -25.765197, 74.031031>
      }
      triangle {
        <-42.547112, -24.835077, 76.393750>,
        <-42.547112, -26.220015, 74.238741>,
        < -42.047112, -25.765197, 74.031031>
      }
      triangle {
        <-42.547112, -24.835077, 76.393750>,
        <-42.047112, -24.457197, 76.066320>,
        < -42.047112, -22.628777, 77.650660>
      }
      triangle {
        <-42.547112, -22.899097, 78.071280>,
        <-42.047112, -22.628777, 77.650660>,
        < -42.047112, -20.428057, 78.655690>
      }
      triangle {
        <-42.547112, -22.899097, 78.071280>,
        <-42.547112, -24.835077, 76.393750>,
        < -42.047112, -22.628777, 77.650660>
      }
      triangle {
        <-42.547112, -20.568917, 79.135440>,
        <-42.047112, -20.428057, 78.655690>,
        < -42.047112, -18.033327, 79.000000>
      }
      triangle {
        <-42.547112, -20.568917, 79.135440>,
        <-42.547112, -22.899097, 78.071280>,
        < -42.047112, -20.428057, 78.655690>
      }
      triangle {
        <-42.547112, -18.033327, 79.500000>,
        <-42.547112, -20.568917, 79.135440>,
        < -42.047112, -18.033327, 79.000000>
      }
      triangle {
        <-42.047112, -15.638597, 78.655690>,
        <-42.547112, -18.033327, 79.500000>,
        < -42.047112, -18.033327, 79.000000>
      }
      triangle {
        <-42.047112, -15.638597, 78.655690>,
        <-42.047112, -18.033327, 79.000000>,
        < -40.047112, -15.561188, 78.108450>
      }
      triangle {
        <-43.047112, -18.033327, 61.500000>,
        <-42.547112, -18.033327, 61.500000>,
        < -42.547112, -20.568917, 61.864559>
      }
      triangle {
        <-43.047112, -15.497726, 61.864571>,
        <-42.547112, -18.033327, 61.500000>,
        < -43.047112, -18.033327, 61.500000>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-42.547112, -18.033327, 61.500000>,
        < -43.047112, -15.497726, 61.864571>
      }
      triangle {
        <-43.047112, -20.568927, 61.864571>,
        <-42.547112, -20.568917, 61.864559>,
        < -42.547112, -22.899097, 62.928720>
      }
      triangle {
        <-43.047112, -20.568927, 61.864571>,
        <-43.047112, -18.033327, 61.500000>,
        < -42.547112, -20.568917, 61.864559>
      }
      triangle {
        <-43.047112, -22.899097, 62.928720>,
        <-42.547112, -22.899097, 62.928720>,
        < -42.547112, -24.835077, 64.606251>
      }
      triangle {
        <-43.047112, -22.899097, 62.928720>,
        <-43.047112, -20.568927, 61.864571>,
        < -42.547112, -22.899097, 62.928720>
      }
      triangle {
        <-43.047112, -24.835067, 64.606251>,
        <-42.547112, -24.835077, 64.606251>,
        < -42.547112, -26.220015, 66.761259>
      }
      triangle {
        <-43.047112, -24.835067, 64.606251>,
        <-43.047112, -22.899097, 62.928720>,
        < -42.547112, -24.835077, 64.606251>
      }
      triangle {
        <-43.047112, -26.220017, 66.761271>,
        <-42.547112, -26.220015, 66.761259>,
        < -42.547112, -26.941720, 69.219170>
      }
      triangle {
        <-43.047112, -26.220017, 66.761271>,
        <-43.047112, -24.835067, 64.606251>,
        < -42.547112, -26.220015, 66.761259>
      }
      triangle {
        <-43.047112, -26.941720, 69.219170>,
        <-42.547112, -26.941720, 69.219170>,
        < -42.547112, -26.941720, 71.780830>
      }
      triangle {
        <-43.047112, -26.941720, 69.219170>,
        <-43.047112, -26.220017, 66.761271>,
        < -42.547112, -26.941720, 69.219170>
      }
      triangle {
        <-43.047112, -26.941720, 71.780830>,
        <-42.547112, -26.941720, 71.780830>,
        < -42.547112, -26.220015, 74.238741>
      }
      triangle {
        <-43.047112, -26.941720, 71.780830>,
        <-43.047112, -26.941720, 69.219170>,
        < -42.547112, -26.941720, 71.780830>
      }
      triangle {
        <-43.047112, -26.220017, 74.238729>,
        <-42.547112, -26.220015, 74.238741>,
        < -42.547112, -24.835077, 76.393750>
      }
      triangle {
        <-43.047112, -26.220017, 74.238729>,
        <-43.047112, -26.941720, 71.780830>,
        < -42.547112, -26.220015, 74.238741>
      }
      triangle {
        <-43.047112, -24.835067, 76.393750>,
        <-42.547112, -24.835077, 76.393750>,
        < -42.547112, -22.899097, 78.071280>
      }
      triangle {
        <-43.047112, -24.835067, 76.393750>,
        <-43.047112, -26.220017, 74.238729>,
        < -42.547112, -24.835077, 76.393750>
      }
      triangle {
        <-43.047112, -22.899097, 78.071280>,
        <-42.547112, -22.899097, 78.071280>,
        < -42.547112, -20.568917, 79.135440>
      }
      triangle {
        <-43.047112, -22.899097, 78.071280>,
        <-43.047112, -24.835067, 76.393750>,
        < -42.547112, -22.899097, 78.071280>
      }
      triangle {
        <-43.047112, -20.568927, 79.135430>,
        <-42.547112, -20.568917, 79.135440>,
        < -42.547112, -18.033327, 79.500000>
      }
      triangle {
        <-43.047112, -20.568927, 79.135430>,
        <-43.047112, -22.899097, 78.071280>,
        < -42.547112, -20.568917, 79.135440>
      }
      triangle {
        <-43.047112, -18.033327, 79.500000>,
        <-43.047112, -20.568927, 79.135430>,
        < -42.547112, -18.033327, 79.500000>
      }
      triangle {
        <-42.547112, -15.497738, 79.135440>,
        <-43.047112, -18.033327, 79.500000>,
        < -42.547112, -18.033327, 79.500000>
      }
      triangle {
        <-42.547112, -15.497738, 79.135440>,
        <-42.547112, -18.033327, 79.500000>,
        < -42.047112, -15.638597, 78.655690>
      }
      triangle {
        <-43.047112, -15.497726, 61.864571>,
        <-43.047112, -18.033327, 61.500000>,
        < -43.047112, -15.532947, 61.984501>
      }
      triangle {
        <-42.547112, -15.497738, 79.135440>,
        <-43.047112, -15.497726, 79.135430>,
        < -43.047112, -18.033327, 79.500000>
      }
      triangle {
        <-43.047112, -15.497726, 79.135430>,
        <-43.047112, -13.235138, 77.966130>,
        < -43.047112, -15.532947, 79.015500>
      }
      triangle {
        <-42.598888, -15.532947, 79.015500>,
        <-43.047112, -15.532947, 79.015500>,
        < -43.047112, -13.235138, 77.966130>
      }
      triangle {
        <-43.047112, -13.167557, 78.071280>,
        <-43.047112, -11.326057, 76.311890>,
        < -43.047112, -13.235138, 77.966130>
      }
      triangle {
        <-42.598888, -13.235138, 77.966130>,
        <-43.047112, -13.235138, 77.966130>,
        < -43.047112, -11.326057, 76.311890>
      }
      triangle {
        <-43.047112, -15.497726, 79.135430>,
        <-43.047112, -13.167557, 78.071280>,
        < -43.047112, -13.235138, 77.966130>
      }
      triangle {
        <-42.598888, -13.235138, 77.966130>,
        <-42.598888, -15.532947, 79.015500>,
        < -43.047112, -13.235138, 77.966130>
      }
      triangle {
        <-43.047112, -11.231586, 76.393750>,
        <-43.047112, -9.960337, 74.186800>,
        < -43.047112, -11.326057, 76.311890>
      }
      triangle {
        <-42.598888, -11.326048, 76.311890>,
        <-43.047112, -11.326057, 76.311890>,
        < -43.047112, -9.960337, 74.186800>
      }
      triangle {
        <-43.047112, -13.167557, 78.071280>,
        <-43.047112, -11.231586, 76.393750>,
        < -43.047112, -11.326057, 76.311890>
      }
      triangle {
        <-42.598888, -11.326048, 76.311890>,
        <-42.598888, -13.235138, 77.966130>,
        < -43.047112, -11.326057, 76.311890>
      }
      triangle {
        <-43.047112, -9.846638, 74.238729>,
        <-43.047112, -9.248657, 71.763041>,
        < -43.047112, -9.960337, 74.186800>
      }
      triangle {
        <-42.598888, -9.960346, 74.186810>,
        <-43.047112, -9.960337, 74.186800>,
        < -43.047112, -9.248657, 71.763041>
      }
      triangle {
        <-43.047112, -11.231586, 76.393750>,
        <-43.047112, -9.846638, 74.238729>,
        < -43.047112, -9.960337, 74.186800>
      }
      triangle {
        <-42.598888, -9.960346, 74.186810>,
        <-42.598888, -11.326048, 76.311890>,
        < -43.047112, -9.960337, 74.186800>
      }
      triangle {
        <-43.047112, -9.124937, 71.780830>,
        <-43.047112, -9.248657, 69.236959>,
        < -43.047112, -9.248657, 71.763041>
      }
      triangle {
        <-42.598888, -9.248657, 71.763041>,
        <-43.047112, -9.248657, 71.763041>,
        < -43.047112, -9.248657, 69.236959>
      }
      triangle {
        <-43.047112, -9.846638, 74.238729>,
        <-43.047112, -9.124937, 71.780830>,
        < -43.047112, -9.248657, 71.763041>
      }
      triangle {
        <-42.598888, -9.248657, 71.763041>,
        <-42.598888, -9.960346, 74.186810>,
        < -43.047112, -9.248657, 71.763041>
      }
      triangle {
        <-43.047112, -9.846638, 66.761271>,
        <-43.047112, -9.960337, 66.813200>,
        < -43.047112, -9.248657, 69.236959>
      }
      triangle {
        <-42.598888, -9.248657, 69.236959>,
        <-43.047112, -9.248657, 69.236959>,
        < -43.047112, -9.960337, 66.813200>
      }
      triangle {
        <-43.047112, -9.124937, 69.219170>,
        <-43.047112, -9.846638, 66.761271>,
        < -43.047112, -9.248657, 69.236959>
      }
      triangle {
        <-43.047112, -9.124937, 71.780830>,
        <-43.047112, -9.124937, 69.219170>,
        < -43.047112, -9.248657, 69.236959>
      }
      triangle {
        <-42.598888, -9.248657, 69.236959>,
        <-42.598888, -9.248657, 71.763041>,
        < -43.047112, -9.248657, 69.236959>
      }
      triangle {
        <-43.047112, -11.231586, 64.606251>,
        <-43.047112, -11.326057, 64.688110>,
        < -43.047112, -9.960337, 66.813200>
      }
      triangle {
        <-42.598888, -9.960346, 66.813190>,
        <-43.047112, -9.960337, 66.813200>,
        < -43.047112, -11.326057, 64.688110>
      }
      triangle {
        <-43.047112, -9.846638, 66.761271>,
        <-43.047112, -11.231586, 64.606251>,
        < -43.047112, -9.960337, 66.813200>
      }
      triangle {
        <-42.598888, -9.960346, 66.813190>,
        <-42.598888, -9.248657, 69.236959>,
        < -43.047112, -9.960337, 66.813200>
      }
      triangle {
        <-43.047112, -13.167557, 62.928720>,
        <-43.047112, -13.235138, 63.033871>,
        < -43.047112, -11.326057, 64.688110>
      }
      triangle {
        <-42.598888, -11.326048, 64.688110>,
        <-43.047112, -11.326057, 64.688110>,
        < -43.047112, -13.235138, 63.033871>
      }
      triangle {
        <-43.047112, -11.231586, 64.606251>,
        <-43.047112, -13.167557, 62.928720>,
        < -43.047112, -11.326057, 64.688110>
      }
      triangle {
        <-42.598888, -11.326048, 64.688110>,
        <-42.598888, -9.960346, 66.813190>,
        < -43.047112, -11.326057, 64.688110>
      }
      triangle {
        <-43.047112, -15.497726, 61.864571>,
        <-43.047112, -15.532947, 61.984501>,
        < -43.047112, -13.235138, 63.033871>
      }
      triangle {
        <-42.598888, -13.235138, 63.033871>,
        <-43.047112, -13.235138, 63.033871>,
        < -43.047112, -15.532947, 61.984501>
      }
      triangle {
        <-43.047112, -13.167557, 62.928720>,
        <-43.047112, -15.497726, 61.864571>,
        < -43.047112, -13.235138, 63.033871>
      }
      triangle {
        <-42.598888, -13.235138, 63.033871>,
        <-42.598888, -11.326048, 64.688110>,
        < -43.047112, -13.235138, 63.033871>
      }
      triangle {
        <-42.598888, -15.532947, 61.984501>,
        <-42.598888, -13.235138, 63.033871>,
        < -43.047112, -15.532947, 61.984501>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-43.047112, -15.497726, 61.864571>,
        < -43.047112, -13.167557, 62.928720>
      }
      triangle {
        <-42.547112, -13.167557, 62.928720>,
        <-43.047112, -13.167557, 62.928720>,
        < -43.047112, -11.231586, 64.606251>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-43.047112, -13.167557, 62.928720>,
        < -42.547112, -13.167557, 62.928720>
      }
      triangle {
        <-42.547112, -11.231577, 64.606251>,
        <-43.047112, -11.231586, 64.606251>,
        < -43.047112, -9.846638, 66.761271>
      }
      triangle {
        <-42.547112, -13.167557, 62.928720>,
        <-43.047112, -11.231586, 64.606251>,
        < -42.547112, -11.231577, 64.606251>
      }
      triangle {
        <-42.547112, -9.846638, 66.761259>,
        <-43.047112, -9.846638, 66.761271>,
        < -43.047112, -9.124937, 69.219170>
      }
      triangle {
        <-42.547112, -11.231577, 64.606251>,
        <-43.047112, -9.846638, 66.761271>,
        < -42.547112, -9.846638, 66.761259>
      }
      triangle {
        <-42.547112, -9.124937, 69.219170>,
        <-43.047112, -9.124937, 69.219170>,
        < -43.047112, -9.124937, 71.780830>
      }
      triangle {
        <-42.547112, -9.846638, 66.761259>,
        <-43.047112, -9.124937, 69.219170>,
        < -42.547112, -9.124937, 69.219170>
      }
      triangle {
        <-42.547112, -9.124937, 71.780830>,
        <-43.047112, -9.124937, 71.780830>,
        < -43.047112, -9.846638, 74.238729>
      }
      triangle {
        <-42.547112, -9.124937, 69.219170>,
        <-43.047112, -9.124937, 71.780830>,
        < -42.547112, -9.124937, 71.780830>
      }
      triangle {
        <-42.547112, -9.846638, 74.238741>,
        <-43.047112, -9.846638, 74.238729>,
        < -43.047112, -11.231586, 76.393750>
      }
      triangle {
        <-42.547112, -9.124937, 71.780830>,
        <-43.047112, -9.846638, 74.238729>,
        < -42.547112, -9.846638, 74.238741>
      }
      triangle {
        <-42.547112, -11.231577, 76.393750>,
        <-43.047112, -11.231586, 76.393750>,
        < -43.047112, -13.167557, 78.071280>
      }
      triangle {
        <-42.547112, -9.846638, 74.238741>,
        <-43.047112, -11.231586, 76.393750>,
        < -42.547112, -11.231577, 76.393750>
      }
      triangle {
        <-42.547112, -13.167557, 78.071280>,
        <-43.047112, -13.167557, 78.071280>,
        < -43.047112, -15.497726, 79.135430>
      }
      triangle {
        <-42.547112, -11.231577, 76.393750>,
        <-43.047112, -13.167557, 78.071280>,
        < -42.547112, -13.167557, 78.071280>
      }
      triangle {
        <-42.547112, -13.167557, 78.071280>,
        <-43.047112, -15.497726, 79.135430>,
        < -42.547112, -15.497738, 79.135440>
      }
      triangle {
        <-42.111019, -13.498907, 77.555700>,
        <-42.598888, -15.532947, 79.015500>,
        < -42.598888, -13.235138, 77.966130>
      }
      triangle {
        <-42.111019, -13.498907, 77.555700>,
        <-42.111019, -15.670397, 78.547390>,
        < -42.598888, -15.532947, 79.015500>
      }
      triangle {
        <-42.111019, -11.694757, 75.992400>,
        <-42.598888, -13.235138, 77.966130>,
        < -42.598888, -11.326048, 76.311890>
      }
      triangle {
        <-42.111019, -11.694757, 75.992400>,
        <-42.111019, -13.498907, 77.555700>,
        < -42.598888, -13.235138, 77.966130>
      }
      triangle {
        <-42.111019, -11.694757, 75.992400>,
        <-42.598888, -11.326048, 76.311890>,
        < -42.598888, -9.960346, 74.186810>
      }
      triangle {
        <-42.111019, -10.404127, 73.984140>,
        <-42.598888, -9.960346, 74.186810>,
        < -42.598888, -9.248657, 71.763041>
      }
      triangle {
        <-42.111019, -10.404127, 73.984140>,
        <-42.111019, -11.694757, 75.992400>,
        < -42.598888, -9.960346, 74.186810>
      }
      triangle {
        <-42.111019, -9.731567, 71.693609>,
        <-42.598888, -9.248657, 71.763041>,
        < -42.598888, -9.248657, 69.236959>
      }
      triangle {
        <-42.111019, -9.731567, 71.693609>,
        <-42.111019, -10.404127, 73.984140>,
        < -42.598888, -9.248657, 71.763041>
      }
      triangle {
        <-42.111019, -9.731567, 69.306391>,
        <-42.598888, -9.248657, 69.236959>,
        < -42.598888, -9.960346, 66.813190>
      }
      triangle {
        <-42.111019, -9.731567, 69.306391>,
        <-42.111019, -9.731567, 71.693609>,
        < -42.598888, -9.248657, 69.236959>
      }
      triangle {
        <-42.111019, -11.694757, 65.007601>,
        <-42.598888, -9.960346, 66.813190>,
        < -42.598888, -11.326048, 64.688110>
      }
      triangle {
        <-42.111019, -10.404127, 67.015860>,
        <-42.111019, -9.731567, 69.306391>,
        < -42.598888, -9.960346, 66.813190>
      }
      triangle {
        <-42.111019, -11.694757, 65.007601>,
        <-42.111019, -10.404127, 67.015860>,
        < -42.598888, -9.960346, 66.813190>
      }
      triangle {
        <-42.111019, -11.694757, 65.007601>,
        <-42.598888, -11.326048, 64.688110>,
        < -42.598888, -13.235138, 63.033871>
      }
      triangle {
        <-42.111019, -13.498907, 63.444300>,
        <-42.598888, -13.235138, 63.033871>,
        < -42.598888, -15.532947, 61.984501>
      }
      triangle {
        <-42.111019, -13.498907, 63.444300>,
        <-42.111019, -11.694757, 65.007601>,
        < -42.598888, -13.235138, 63.033871>
      }
      triangle {
        <-42.111019, -15.670397, 62.452610>,
        <-42.111019, -13.498907, 63.444300>,
        < -42.598888, -15.532947, 61.984501>
      }
      triangle {
        <-40.125000, -15.594976, 78.004430>,
        <-42.111019, -15.670397, 78.547390>,
        < -42.111019, -13.498907, 77.555700>
      }
      triangle {
        <-40.125000, -13.395327, 76.883640>,
        <-42.111019, -13.498907, 77.555700>,
        < -42.111019, -11.694757, 75.992400>
      }
      triangle {
        <-40.125000, -13.395327, 76.883640>,
        <-40.125000, -15.594976, 78.004430>,
        < -42.111019, -13.498907, 77.555700>
      }
      triangle {
        <-40.125000, -11.649668, 75.137980>,
        <-42.111019, -11.694757, 75.992400>,
        < -42.111019, -10.404127, 73.984140>
      }
      triangle {
        <-40.125000, -11.649668, 75.137980>,
        <-40.125000, -13.395327, 76.883640>,
        < -42.111019, -11.694757, 75.992400>
      }
      triangle {
        <-40.125000, -10.528896, 72.938330>,
        <-42.111019, -10.404127, 73.984140>,
        < -42.111019, -9.731567, 71.693609>
      }
      triangle {
        <-40.125000, -10.528896, 72.938330>,
        <-40.125000, -11.649668, 75.137980>,
        < -42.111019, -10.404127, 73.984140>
      }
      triangle {
        <-40.125000, -10.142708, 70.500000>,
        <-42.111019, -9.731567, 71.693609>,
        < -42.111019, -9.731567, 69.306391>
      }
      triangle {
        <-40.125000, -10.142708, 70.500000>,
        <-40.125000, -10.528896, 72.938330>,
        < -42.111019, -9.731567, 71.693609>
      }
      triangle {
        <-40.125000, -10.528896, 68.061670>,
        <-42.111019, -9.731567, 69.306391>,
        < -42.111019, -10.404127, 67.015860>
      }
      triangle {
        <-40.125000, -10.528896, 68.061670>,
        <-40.125000, -10.142708, 70.500000>,
        < -42.111019, -9.731567, 69.306391>
      }
      triangle {
        <-40.125000, -11.649668, 65.862020>,
        <-42.111019, -10.404127, 67.015860>,
        < -42.111019, -11.694757, 65.007601>
      }
      triangle {
        <-40.125000, -11.649668, 65.862020>,
        <-40.125000, -10.528896, 68.061670>,
        < -42.111019, -10.404127, 67.015860>
      }
      triangle {
        <-40.125000, -13.395327, 64.116360>,
        <-42.111019, -11.694757, 65.007601>,
        < -42.111019, -13.498907, 63.444300>
      }
      triangle {
        <-40.125000, -13.395327, 64.116360>,
        <-40.125000, -11.649668, 65.862020>,
        < -42.111019, -11.694757, 65.007601>
      }
      triangle {
        <-40.125000, -15.594976, 62.995569>,
        <-42.111019, -13.498907, 63.444300>,
        < -42.111019, -15.670397, 62.452610>
      }
      triangle {
        <-40.125000, -15.594976, 62.995569>,
        <-40.125000, -13.395327, 64.116360>,
        < -42.111019, -13.498907, 63.444300>
      }
      triangle {
        <-40.125000, -14.460047, 74.758450>,
        <-40.125000, -15.594976, 78.004430>,
        < -40.125000, -13.395327, 76.883640>
      }
      triangle {
        <-40.125000, -14.460047, 74.758450>,
        <-40.125000, -16.132027, 75.723760>,
        < -40.125000, -15.594976, 78.004430>
      }
      triangle {
        <-40.125000, -17.658327, 76.875000>,
        <-40.125000, -15.594976, 78.004430>,
        < -40.125000, -16.132027, 75.723760>
      }
      triangle {
        <-40.125000, -17.768158, 77.140170>,
        <-40.125000, -18.033327, 77.250000>,
        < -40.125000, -15.594976, 78.004430>
      }
      triangle {
        <-40.125000, -17.658327, 76.875000>,
        <-40.125000, -17.768158, 77.140170>,
        < -40.125000, -15.594976, 78.004430>
      }
      triangle {
        <-40.125000, -13.260357, 75.272970>,
        <-40.125000, -13.395327, 76.883640>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -13.900516, 75.007810>,
        <-40.125000, -14.460047, 74.758450>,
        < -40.125000, -13.395327, 76.883640>
      }
      triangle {
        <-40.125000, -13.790687, 75.272970>,
        <-40.125000, -13.900516, 75.007810>,
        < -40.125000, -13.395327, 76.883640>
      }
      triangle {
        <-40.125000, -13.525516, 75.382810>,
        <-40.125000, -13.790687, 75.272970>,
        < -40.125000, -13.395327, 76.883640>
      }
      triangle {
        <-40.125000, -13.260357, 75.272970>,
        <-40.125000, -13.525516, 75.382810>,
        < -40.125000, -13.395327, 76.883640>
      }
      triangle {
        <-40.125000, -11.393158, 70.765169>,
        <-40.125000, -11.649668, 75.137980>,
        < -40.125000, -10.528896, 72.938330>
      }
      triangle {
        <-40.125000, -12.558767, 69.534691>,
        <-40.125000, -12.558767, 71.465309>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -13.150516, 75.007810>,
        <-40.125000, -11.649668, 75.137980>,
        < -40.125000, -12.558767, 71.465309>
      }
      triangle {
        <-40.125000, -12.033327, 70.500000>,
        <-40.125000, -12.558767, 69.534691>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -11.923496, 70.765169>,
        <-40.125000, -12.033327, 70.500000>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -11.658327, 70.875000>,
        <-40.125000, -11.923496, 70.765169>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -11.393158, 70.765169>,
        <-40.125000, -11.658327, 70.875000>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -13.150516, 75.007810>,
        <-40.125000, -13.260357, 75.272970>,
        < -40.125000, -11.649668, 75.137980>
      }
      triangle {
        <-40.125000, -10.528896, 68.061670>,
        <-40.125000, -10.528896, 72.938330>,
        < -40.125000, -10.142708, 70.500000>
      }
      triangle {
        <-40.125000, -11.649668, 65.862020>,
        <-40.125000, -10.528896, 72.938330>,
        < -40.125000, -10.528896, 68.061670>
      }
      triangle {
        <-40.125000, -11.283327, 70.500000>,
        <-40.125000, -10.528896, 72.938330>,
        < -40.125000, -11.649668, 65.862020>
      }
      triangle {
        <-40.125000, -11.283327, 70.500000>,
        <-40.125000, -11.393158, 70.765169>,
        < -40.125000, -10.528896, 72.938330>
      }
      triangle {
        <-40.125000, -11.658327, 70.125000>,
        <-40.125000, -11.649668, 65.862020>,
        < -40.125000, -13.395327, 64.116360>
      }
      triangle {
        <-40.125000, -11.393158, 70.234831>,
        <-40.125000, -11.283327, 70.500000>,
        < -40.125000, -11.649668, 65.862020>
      }
      triangle {
        <-40.125000, -11.658327, 70.125000>,
        <-40.125000, -11.393158, 70.234831>,
        < -40.125000, -11.649668, 65.862020>
      }
      triangle {
        <-40.125000, -13.525516, 65.617189>,
        <-40.125000, -13.395327, 64.116360>,
        < -40.125000, -15.594976, 62.995569>
      }
      triangle {
        <-40.125000, -13.150516, 65.992189>,
        <-40.125000, -12.558767, 69.534691>,
        < -40.125000, -13.395327, 64.116360>
      }
      triangle {
        <-40.125000, -12.033327, 70.500000>,
        <-40.125000, -13.395327, 64.116360>,
        < -40.125000, -12.558767, 69.534691>
      }
      triangle {
        <-40.125000, -13.260357, 65.727030>,
        <-40.125000, -13.150516, 65.992189>,
        < -40.125000, -13.395327, 64.116360>
      }
      triangle {
        <-40.125000, -13.525516, 65.617189>,
        <-40.125000, -13.260357, 65.727030>,
        < -40.125000, -13.395327, 64.116360>
      }
      triangle {
        <-40.125000, -11.923496, 70.234831>,
        <-40.125000, -13.395327, 64.116360>,
        < -40.125000, -12.033327, 70.500000>
      }
      triangle {
        <-40.125000, -11.923496, 70.234831>,
        <-40.125000, -11.658327, 70.125000>,
        < -40.125000, -13.395327, 64.116360>
      }
      triangle {
        <-40.125000, -16.132027, 65.276239>,
        <-40.125000, -14.460047, 66.241550>,
        < -40.125000, -15.594976, 62.995569>
      }
      triangle {
        <-40.125000, -13.900516, 65.992189>,
        <-40.125000, -15.594976, 62.995569>,
        < -40.125000, -14.460047, 66.241550>
      }
      triangle {
        <-40.125000, -13.790687, 65.727030>,
        <-40.125000, -13.525516, 65.617189>,
        < -40.125000, -15.594976, 62.995569>
      }
      triangle {
        <-40.125000, -13.900516, 65.992189>,
        <-40.125000, -13.790687, 65.727030>,
        < -40.125000, -15.594976, 62.995569>
      }
      triangle {
        <-35.031719, -13.404516, 64.128990>,
        <-40.000000, -13.404507, 64.129000>,
        < -40.000000, -15.599808, 63.010429>
      }
      triangle {
        <-40.000000, -14.541048, 66.338079>,
        <-40.000000, -15.599808, 63.010429>,
        < -40.000000, -13.404507, 64.129000>
      }
      triangle {
        <-35.031719, -15.599817, 63.010429>,
        <-35.031719, -13.404516, 64.128990>,
        < -40.000000, -15.599808, 63.010429>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.000000, -18.033327, 65.066990>,
        < -40.000000, -15.599808, 63.010429>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.000000, -15.599808, 63.010429>,
        < -40.000000, -14.541048, 66.338079>
      }
      triangle {
        <-35.031719, -11.662317, 65.871189>,
        <-40.000000, -11.662317, 65.871201>,
        < -40.000000, -13.404507, 64.129000>
      }
      triangle {
        <-40.000000, -13.328197, 67.783501>,
        <-40.000000, -13.404507, 64.129000>,
        < -40.000000, -11.662317, 65.871201>
      }
      triangle {
        <-35.031719, -13.404516, 64.128990>,
        <-35.031719, -11.662317, 65.871189>,
        < -40.000000, -13.404507, 64.129000>
      }
      triangle {
        <-40.000000, -14.541048, 66.338079>,
        <-40.000000, -13.404507, 64.129000>,
        < -40.000000, -13.328197, 67.783501>
      }
      triangle {
        <-40.000000, -11.662317, 75.128800>,
        <-40.000000, -11.662317, 65.871201>,
        < -40.000000, -10.543756, 68.066500>
      }
      triangle {
        <-35.031719, -10.543756, 68.066490>,
        <-40.000000, -10.543756, 68.066500>,
        < -40.000000, -11.662317, 65.871201>
      }
      triangle {
        <-40.000000, -12.682857, 71.443430>,
        <-40.000000, -11.662317, 65.871201>,
        < -40.000000, -11.662317, 75.128800>
      }
      triangle {
        <-35.031719, -11.662317, 65.871189>,
        <-35.031719, -10.543756, 68.066490>,
        < -40.000000, -11.662317, 65.871201>
      }
      triangle {
        <-40.000000, -12.682857, 69.556570>,
        <-40.000000, -11.662317, 65.871201>,
        < -40.000000, -12.682857, 71.443430>
      }
      triangle {
        <-40.000000, -13.328197, 67.783501>,
        <-40.000000, -11.662317, 65.871201>,
        < -40.000000, -12.682857, 69.556570>
      }
      triangle {
        <-40.000000, -10.543756, 72.933500>,
        <-40.000000, -10.543756, 68.066500>,
        < -40.000000, -10.158327, 70.500000>
      }
      triangle {
        <-35.031719, -10.158327, 70.500000>,
        <-40.000000, -10.158327, 70.500000>,
        < -40.000000, -10.543756, 68.066500>
      }
      triangle {
        <-40.000000, -11.662317, 75.128800>,
        <-40.000000, -10.543756, 68.066500>,
        < -40.000000, -10.543756, 72.933500>
      }
      triangle {
        <-35.031719, -10.543756, 68.066490>,
        <-35.031719, -10.158327, 70.500000>,
        < -40.000000, -10.543756, 68.066500>
      }
      triangle {
        <-35.031719, -10.543756, 72.933510>,
        <-40.000000, -10.543756, 72.933500>,
        < -40.000000, -10.158327, 70.500000>
      }
      triangle {
        <-35.031719, -10.158327, 70.500000>,
        <-35.031719, -10.543756, 72.933510>,
        < -40.000000, -10.158327, 70.500000>
      }
      triangle {
        <-35.031719, -11.662317, 75.128810>,
        <-40.000000, -11.662317, 75.128800>,
        < -40.000000, -10.543756, 72.933500>
      }
      triangle {
        <-35.031719, -10.543756, 72.933510>,
        <-35.031719, -11.662317, 75.128810>,
        < -40.000000, -10.543756, 72.933500>
      }
      triangle {
        <-35.031719, -13.404516, 76.871010>,
        <-40.000000, -13.404507, 76.871000>,
        < -40.000000, -11.662317, 75.128800>
      }
      triangle {
        <-40.000000, -12.682857, 71.443430>,
        <-40.000000, -11.662317, 75.128800>,
        < -40.000000, -13.404507, 76.871000>
      }
      triangle {
        <-35.031719, -11.662317, 75.128810>,
        <-35.031719, -13.404516, 76.871010>,
        < -40.000000, -11.662317, 75.128800>
      }
      triangle {
        <-35.031719, -15.599817, 77.989570>,
        <-40.000000, -15.599808, 77.989570>,
        < -40.000000, -13.404507, 76.871000>
      }
      triangle {
        <-40.000000, -14.541048, 74.661920>,
        <-40.000000, -13.404507, 76.871000>,
        < -40.000000, -15.599808, 77.989570>
      }
      triangle {
        <-35.031719, -13.404516, 76.871010>,
        <-35.031719, -15.599817, 77.989570>,
        < -40.000000, -13.404507, 76.871000>
      }
      triangle {
        <-40.000000, -13.328197, 73.216499>,
        <-40.000000, -13.404507, 76.871000>,
        < -40.000000, -14.541048, 74.661920>
      }
      triangle {
        <-40.000000, -12.682857, 71.443430>,
        <-40.000000, -13.404507, 76.871000>,
        < -40.000000, -13.328197, 73.216499>
      }
      triangle {
        <-40.000000, -14.541048, 74.661920>,
        <-40.000000, -15.599808, 77.989570>,
        < -40.000000, -16.175117, 75.605360>
      }
      triangle {
        <-32.983212, -13.498907, 77.555700>,
        <-35.031719, -15.599817, 77.989570>,
        < -35.031719, -13.404516, 76.871010>
      }
      triangle {
        <-32.983212, -13.498907, 77.555700>,
        <-32.983212, -15.670397, 78.547390>,
        < -35.031719, -15.599817, 77.989570>
      }
      triangle {
        <-32.983212, -11.694757, 75.992400>,
        <-35.031719, -13.404516, 76.871010>,
        < -35.031719, -11.662317, 75.128810>
      }
      triangle {
        <-32.983212, -11.694757, 75.992400>,
        <-32.983212, -13.498907, 77.555700>,
        < -35.031719, -13.404516, 76.871010>
      }
      triangle {
        <-32.983212, -10.404127, 73.984140>,
        <-35.031719, -11.662317, 75.128810>,
        < -35.031719, -10.543756, 72.933510>
      }
      triangle {
        <-32.983212, -10.404127, 73.984140>,
        <-32.983212, -11.694757, 75.992400>,
        < -35.031719, -11.662317, 75.128810>
      }
      triangle {
        <-32.983212, -9.731567, 71.693609>,
        <-35.031719, -10.543756, 72.933510>,
        < -35.031719, -10.158327, 70.500000>
      }
      triangle {
        <-32.983212, -9.731567, 71.693609>,
        <-32.983212, -10.404127, 73.984140>,
        < -35.031719, -10.543756, 72.933510>
      }
      triangle {
        <-32.983212, -9.731567, 69.306391>,
        <-35.031719, -10.158327, 70.500000>,
        < -35.031719, -10.543756, 68.066490>
      }
      triangle {
        <-32.983212, -9.731567, 69.306391>,
        <-32.983212, -9.731567, 71.693609>,
        < -35.031719, -10.158327, 70.500000>
      }
      triangle {
        <-32.983212, -10.404127, 67.015860>,
        <-35.031719, -10.543756, 68.066490>,
        < -35.031719, -11.662317, 65.871189>
      }
      triangle {
        <-32.983212, -10.404127, 67.015860>,
        <-32.983212, -9.731567, 69.306391>,
        < -35.031719, -10.543756, 68.066490>
      }
      triangle {
        <-32.983212, -11.694757, 65.007601>,
        <-35.031719, -11.662317, 65.871189>,
        < -35.031719, -13.404516, 64.128990>
      }
      triangle {
        <-32.983212, -11.694757, 65.007601>,
        <-32.983212, -10.404127, 67.015860>,
        < -35.031719, -11.662317, 65.871189>
      }
      triangle {
        <-32.983212, -13.498907, 63.444300>,
        <-35.031719, -13.404516, 64.128990>,
        < -35.031719, -15.599817, 63.010429>
      }
      triangle {
        <-32.983212, -13.498907, 63.444300>,
        <-32.983212, -11.694757, 65.007601>,
        < -35.031719, -13.404516, 64.128990>
      }
      triangle {
        <-32.983212, -15.670397, 62.452610>,
        <-32.983212, -13.498907, 63.444300>,
        < -35.031719, -15.599817, 63.010429>
      }
      triangle {
        <-32.495338, -15.532947, 79.015500>,
        <-32.983212, -15.670397, 78.547390>,
        < -32.983212, -13.498907, 77.555700>
      }
      triangle {
        <-32.495338, -13.235138, 77.966130>,
        <-32.983212, -13.498907, 77.555700>,
        < -32.983212, -11.694757, 75.992400>
      }
      triangle {
        <-32.495338, -13.235138, 77.966130>,
        <-32.495338, -15.532947, 79.015500>,
        < -32.983212, -13.498907, 77.555700>
      }
      triangle {
        <-32.495338, -11.326048, 76.311890>,
        <-32.983212, -11.694757, 75.992400>,
        < -32.983212, -10.404127, 73.984140>
      }
      triangle {
        <-32.495338, -11.326048, 76.311890>,
        <-32.495338, -13.235138, 77.966130>,
        < -32.983212, -11.694757, 75.992400>
      }
      triangle {
        <-32.495338, -9.960346, 74.186810>,
        <-32.983212, -10.404127, 73.984140>,
        < -32.983212, -9.731567, 71.693609>
      }
      triangle {
        <-32.495338, -9.960346, 74.186810>,
        <-32.495338, -11.326048, 76.311890>,
        < -32.983212, -10.404127, 73.984140>
      }
      triangle {
        <-32.495338, -9.248657, 71.763041>,
        <-32.983212, -9.731567, 71.693609>,
        < -32.983212, -9.731567, 69.306391>
      }
      triangle {
        <-32.495338, -9.248657, 71.763041>,
        <-32.495338, -9.960346, 74.186810>,
        < -32.983212, -9.731567, 71.693609>
      }
      triangle {
        <-32.495338, -9.248657, 69.236959>,
        <-32.983212, -9.731567, 69.306391>,
        < -32.983212, -10.404127, 67.015860>
      }
      triangle {
        <-32.495338, -9.248657, 69.236959>,
        <-32.495338, -9.248657, 71.763041>,
        < -32.983212, -9.731567, 69.306391>
      }
      triangle {
        <-32.495338, -9.960346, 66.813190>,
        <-32.983212, -10.404127, 67.015860>,
        < -32.983212, -11.694757, 65.007601>
      }
      triangle {
        <-32.495338, -9.960346, 66.813190>,
        <-32.495338, -9.248657, 69.236959>,
        < -32.983212, -10.404127, 67.015860>
      }
      triangle {
        <-32.495338, -11.326048, 64.688110>,
        <-32.983212, -11.694757, 65.007601>,
        < -32.983212, -13.498907, 63.444300>
      }
      triangle {
        <-32.495338, -11.326048, 64.688110>,
        <-32.495338, -9.960346, 66.813190>,
        < -32.983212, -11.694757, 65.007601>
      }
      triangle {
        <-32.495338, -13.235138, 63.033871>,
        <-32.983212, -13.498907, 63.444300>,
        < -32.983212, -15.670397, 62.452610>
      }
      triangle {
        <-32.495338, -13.235138, 63.033871>,
        <-32.495338, -11.326048, 64.688110>,
        < -32.983212, -13.498907, 63.444300>
      }
      triangle {
        <-32.495338, -15.532947, 61.984501>,
        <-32.495338, -13.235138, 63.033871>,
        < -32.983212, -15.670397, 62.452610>
      }
      triangle {
        <-33.047112, -15.638597, 78.655690>,
        <-32.547112, -15.497738, 79.135440>,
        < -32.547112, -13.167557, 78.071280>
      }
      triangle {
        <-33.047112, -13.437878, 77.650660>,
        <-32.547112, -13.167557, 78.071280>,
        < -32.547112, -11.231577, 76.393750>
      }
      triangle {
        <-33.047112, -13.437878, 77.650660>,
        <-33.047112, -15.638597, 78.655690>,
        < -32.547112, -13.167557, 78.071280>
      }
      triangle {
        <-33.047112, -10.301456, 74.031031>,
        <-32.547112, -11.231577, 76.393750>,
        < -32.547112, -9.846638, 74.238741>
      }
      triangle {
        <-33.047112, -11.609457, 76.066320>,
        <-33.047112, -13.437878, 77.650660>,
        < -32.547112, -11.231577, 76.393750>
      }
      triangle {
        <-33.047112, -10.301456, 74.031031>,
        <-33.047112, -11.609457, 76.066320>,
        < -32.547112, -11.231577, 76.393750>
      }
      triangle {
        <-33.047112, -10.301456, 74.031031>,
        <-32.547112, -9.846638, 74.238741>,
        < -32.547112, -9.124937, 71.780830>
      }
      triangle {
        <-33.047112, -9.619846, 71.709681>,
        <-32.547112, -9.124937, 71.780830>,
        < -32.547112, -9.124937, 69.219170>
      }
      triangle {
        <-33.047112, -9.619846, 71.709681>,
        <-33.047112, -10.301456, 74.031031>,
        < -32.547112, -9.124937, 71.780830>
      }
      triangle {
        <-33.047112, -9.619846, 69.290319>,
        <-32.547112, -9.124937, 69.219170>,
        < -32.547112, -9.846638, 66.761259>
      }
      triangle {
        <-33.047112, -9.619846, 69.290319>,
        <-33.047112, -9.619846, 71.709681>,
        < -32.547112, -9.124937, 69.219170>
      }
      triangle {
        <-33.047112, -10.301456, 66.968969>,
        <-32.547112, -9.846638, 66.761259>,
        < -32.547112, -11.231577, 64.606251>
      }
      triangle {
        <-33.047112, -10.301456, 66.968969>,
        <-33.047112, -9.619846, 69.290319>,
        < -32.547112, -9.846638, 66.761259>
      }
      triangle {
        <-33.047112, -11.609457, 64.933680>,
        <-32.547112, -11.231577, 64.606251>,
        < -32.547112, -13.167557, 62.928720>
      }
      triangle {
        <-33.047112, -11.609457, 64.933680>,
        <-33.047112, -10.301456, 66.968969>,
        < -32.547112, -11.231577, 64.606251>
      }
      triangle {
        <-33.047112, -13.437878, 63.349340>,
        <-32.547112, -13.167557, 62.928720>,
        < -32.547112, -15.497738, 61.864559>
      }
      triangle {
        <-33.047112, -13.437878, 63.349340>,
        <-33.047112, -11.609457, 64.933680>,
        < -32.547112, -13.167557, 62.928720>
      }
      triangle {
        <-33.047112, -15.638597, 62.344311>,
        <-33.047112, -13.437878, 63.349340>,
        < -32.547112, -15.497738, 61.864559>
      }
      triangle {
        <-35.047112, -15.561188, 78.108450>,
        <-33.047112, -15.638597, 78.655690>,
        < -33.047112, -13.437878, 77.650660>
      }
      triangle {
        <-35.047112, -13.331047, 76.972140>,
        <-33.047112, -13.437878, 77.650660>,
        < -33.047112, -11.609457, 76.066320>
      }
      triangle {
        <-35.047112, -13.331047, 76.972140>,
        <-35.047112, -15.561188, 78.108450>,
        < -33.047112, -13.437878, 77.650660>
      }
      triangle {
        <-35.047112, -11.561188, 75.202280>,
        <-33.047112, -11.609457, 76.066320>,
        < -33.047112, -10.301456, 74.031031>
      }
      triangle {
        <-35.047112, -11.561188, 75.202280>,
        <-35.047112, -13.331047, 76.972140>,
        < -33.047112, -11.609457, 76.066320>
      }
      triangle {
        <-35.047112, -10.424877, 72.972139>,
        <-33.047112, -10.301456, 74.031031>,
        < -33.047112, -9.619846, 71.709681>
      }
      triangle {
        <-35.047112, -10.424877, 72.972139>,
        <-35.047112, -11.561188, 75.202280>,
        < -33.047112, -10.301456, 74.031031>
      }
      triangle {
        <-35.047112, -10.033327, 70.500000>,
        <-33.047112, -9.619846, 71.709681>,
        < -33.047112, -9.619846, 69.290319>
      }
      triangle {
        <-35.047112, -10.033327, 70.500000>,
        <-35.047112, -10.424877, 72.972139>,
        < -33.047112, -9.619846, 71.709681>
      }
      triangle {
        <-35.047112, -10.424877, 68.027861>,
        <-33.047112, -9.619846, 69.290319>,
        < -33.047112, -10.301456, 66.968969>
      }
      triangle {
        <-35.047112, -10.424877, 68.027861>,
        <-35.047112, -10.033327, 70.500000>,
        < -33.047112, -9.619846, 69.290319>
      }
      triangle {
        <-35.047112, -11.561188, 65.797720>,
        <-33.047112, -10.301456, 66.968969>,
        < -33.047112, -11.609457, 64.933680>
      }
      triangle {
        <-35.047112, -11.561188, 65.797720>,
        <-35.047112, -10.424877, 68.027861>,
        < -33.047112, -10.301456, 66.968969>
      }
      triangle {
        <-35.047112, -13.331047, 64.027861>,
        <-33.047112, -11.609457, 64.933680>,
        < -33.047112, -13.437878, 63.349340>
      }
      triangle {
        <-35.047112, -13.331047, 64.027861>,
        <-35.047112, -11.561188, 65.797720>,
        < -33.047112, -11.609457, 64.933680>
      }
      triangle {
        <-35.047112, -15.561188, 62.891550>,
        <-33.047112, -13.437878, 63.349340>,
        < -33.047112, -15.638597, 62.344311>
      }
      triangle {
        <-35.047112, -15.561188, 62.891550>,
        <-35.047112, -13.331047, 64.027861>,
        < -33.047112, -13.437878, 63.349340>
      }
      triangle {
        <-40.047112, -15.561188, 78.108450>,
        <-35.047112, -15.561188, 78.108450>,
        < -35.047112, -13.331047, 76.972140>
      }
      triangle {
        <-40.047112, -13.331047, 76.972140>,
        <-35.047112, -13.331047, 76.972140>,
        < -35.047112, -11.561188, 75.202280>
      }
      triangle {
        <-40.047112, -13.331047, 76.972140>,
        <-40.047112, -15.561188, 78.108450>,
        < -35.047112, -13.331047, 76.972140>
      }
      triangle {
        <-40.047112, -11.561188, 75.202280>,
        <-35.047112, -11.561188, 75.202280>,
        < -35.047112, -10.424877, 72.972139>
      }
      triangle {
        <-40.047112, -11.561188, 75.202280>,
        <-40.047112, -13.331047, 76.972140>,
        < -35.047112, -11.561188, 75.202280>
      }
      triangle {
        <-40.047112, -10.424877, 72.972139>,
        <-35.047112, -10.424877, 72.972139>,
        < -35.047112, -10.033327, 70.500000>
      }
      triangle {
        <-40.047112, -10.424877, 72.972139>,
        <-40.047112, -11.561188, 75.202280>,
        < -35.047112, -10.424877, 72.972139>
      }
      triangle {
        <-40.047112, -10.033327, 70.500000>,
        <-35.047112, -10.033327, 70.500000>,
        < -35.047112, -10.424877, 68.027861>
      }
      triangle {
        <-40.047112, -10.033327, 70.500000>,
        <-40.047112, -10.424877, 72.972139>,
        < -35.047112, -10.033327, 70.500000>
      }
      triangle {
        <-40.047112, -10.424877, 68.027861>,
        <-35.047112, -10.424877, 68.027861>,
        < -35.047112, -11.561188, 65.797720>
      }
      triangle {
        <-40.047112, -10.424877, 68.027861>,
        <-40.047112, -10.033327, 70.500000>,
        < -35.047112, -10.424877, 68.027861>
      }
      triangle {
        <-40.047112, -11.561188, 65.797720>,
        <-35.047112, -11.561188, 65.797720>,
        < -35.047112, -13.331047, 64.027861>
      }
      triangle {
        <-40.047112, -11.561188, 65.797720>,
        <-40.047112, -10.424877, 68.027861>,
        < -35.047112, -11.561188, 65.797720>
      }
      triangle {
        <-40.047112, -13.331047, 64.027861>,
        <-35.047112, -13.331047, 64.027861>,
        < -35.047112, -15.561188, 62.891550>
      }
      triangle {
        <-40.047112, -13.331047, 64.027861>,
        <-40.047112, -11.561188, 65.797720>,
        < -35.047112, -13.331047, 64.027861>
      }
      triangle {
        <-40.047112, -15.561188, 62.891550>,
        <-40.047112, -13.331047, 64.027861>,
        < -35.047112, -15.561188, 62.891550>
      }
      triangle {
        <-42.047112, -13.437878, 77.650660>,
        <-40.047112, -15.561188, 78.108450>,
        < -40.047112, -13.331047, 76.972140>
      }
      triangle {
        <-42.047112, -13.437878, 77.650660>,
        <-42.047112, -15.638597, 78.655690>,
        < -40.047112, -15.561188, 78.108450>
      }
      triangle {
        <-42.047112, -11.609457, 76.066320>,
        <-40.047112, -13.331047, 76.972140>,
        < -40.047112, -11.561188, 75.202280>
      }
      triangle {
        <-42.047112, -11.609457, 76.066320>,
        <-42.047112, -13.437878, 77.650660>,
        < -40.047112, -13.331047, 76.972140>
      }
      triangle {
        <-42.047112, -10.301456, 74.031031>,
        <-40.047112, -11.561188, 75.202280>,
        < -40.047112, -10.424877, 72.972139>
      }
      triangle {
        <-42.047112, -10.301456, 74.031031>,
        <-42.047112, -11.609457, 76.066320>,
        < -40.047112, -11.561188, 75.202280>
      }
      triangle {
        <-42.047112, -9.619846, 71.709681>,
        <-40.047112, -10.424877, 72.972139>,
        < -40.047112, -10.033327, 70.500000>
      }
      triangle {
        <-42.047112, -9.619846, 71.709681>,
        <-42.047112, -10.301456, 74.031031>,
        < -40.047112, -10.424877, 72.972139>
      }
      triangle {
        <-42.047112, -9.619846, 69.290319>,
        <-40.047112, -10.033327, 70.500000>,
        < -40.047112, -10.424877, 68.027861>
      }
      triangle {
        <-42.047112, -9.619846, 69.290319>,
        <-42.047112, -9.619846, 71.709681>,
        < -40.047112, -10.033327, 70.500000>
      }
      triangle {
        <-42.047112, -10.301456, 66.968969>,
        <-40.047112, -10.424877, 68.027861>,
        < -40.047112, -11.561188, 65.797720>
      }
      triangle {
        <-42.047112, -10.301456, 66.968969>,
        <-42.047112, -9.619846, 69.290319>,
        < -40.047112, -10.424877, 68.027861>
      }
      triangle {
        <-42.047112, -11.609457, 64.933680>,
        <-40.047112, -11.561188, 65.797720>,
        < -40.047112, -13.331047, 64.027861>
      }
      triangle {
        <-42.047112, -11.609457, 64.933680>,
        <-42.047112, -10.301456, 66.968969>,
        < -40.047112, -11.561188, 65.797720>
      }
      triangle {
        <-42.047112, -13.437878, 63.349340>,
        <-40.047112, -13.331047, 64.027861>,
        < -40.047112, -15.561188, 62.891550>
      }
      triangle {
        <-42.047112, -13.437878, 63.349340>,
        <-42.047112, -11.609457, 64.933680>,
        < -40.047112, -13.331047, 64.027861>
      }
      triangle {
        <-42.047112, -15.638597, 62.344311>,
        <-42.047112, -13.437878, 63.349340>,
        < -40.047112, -15.561188, 62.891550>
      }
      triangle {
        <-42.547112, -15.497738, 79.135440>,
        <-42.047112, -15.638597, 78.655690>,
        < -42.047112, -13.437878, 77.650660>
      }
      triangle {
        <-42.547112, -13.167557, 78.071280>,
        <-42.047112, -13.437878, 77.650660>,
        < -42.047112, -11.609457, 76.066320>
      }
      triangle {
        <-42.547112, -13.167557, 78.071280>,
        <-42.547112, -15.497738, 79.135440>,
        < -42.047112, -13.437878, 77.650660>
      }
      triangle {
        <-42.547112, -11.231577, 76.393750>,
        <-42.047112, -11.609457, 76.066320>,
        < -42.047112, -10.301456, 74.031031>
      }
      triangle {
        <-42.547112, -11.231577, 76.393750>,
        <-42.547112, -13.167557, 78.071280>,
        < -42.047112, -11.609457, 76.066320>
      }
      triangle {
        <-42.547112, -9.846638, 74.238741>,
        <-42.047112, -10.301456, 74.031031>,
        < -42.047112, -9.619846, 71.709681>
      }
      triangle {
        <-42.547112, -9.846638, 74.238741>,
        <-42.547112, -11.231577, 76.393750>,
        < -42.047112, -10.301456, 74.031031>
      }
      triangle {
        <-42.547112, -9.124937, 71.780830>,
        <-42.047112, -9.619846, 71.709681>,
        < -42.047112, -9.619846, 69.290319>
      }
      triangle {
        <-42.547112, -9.124937, 71.780830>,
        <-42.547112, -9.846638, 74.238741>,
        < -42.047112, -9.619846, 71.709681>
      }
      triangle {
        <-42.547112, -9.124937, 69.219170>,
        <-42.047112, -9.619846, 69.290319>,
        < -42.047112, -10.301456, 66.968969>
      }
      triangle {
        <-42.547112, -9.124937, 69.219170>,
        <-42.547112, -9.124937, 71.780830>,
        < -42.047112, -9.619846, 69.290319>
      }
      triangle {
        <-42.547112, -9.846638, 66.761259>,
        <-42.047112, -10.301456, 66.968969>,
        < -42.047112, -11.609457, 64.933680>
      }
      triangle {
        <-42.547112, -9.846638, 66.761259>,
        <-42.547112, -9.124937, 69.219170>,
        < -42.047112, -10.301456, 66.968969>
      }
      triangle {
        <-42.547112, -11.231577, 64.606251>,
        <-42.047112, -11.609457, 64.933680>,
        < -42.047112, -13.437878, 63.349340>
      }
      triangle {
        <-42.547112, -11.231577, 64.606251>,
        <-42.547112, -9.846638, 66.761259>,
        < -42.047112, -11.609457, 64.933680>
      }
      triangle {
        <-42.547112, -13.167557, 62.928720>,
        <-42.047112, -13.437878, 63.349340>,
        < -42.047112, -15.638597, 62.344311>
      }
      triangle {
        <-42.547112, -13.167557, 62.928720>,
        <-42.547112, -11.231577, 64.606251>,
        < -42.047112, -13.437878, 63.349340>
      }
      triangle {
        <-42.547112, -15.497738, 61.864559>,
        <-42.547112, -13.167557, 62.928720>,
        < -42.047112, -15.638597, 62.344311>
      }
      triangle {
        <-40.125000, -18.298496, 64.390169>,
        <-40.125000, -19.934627, 65.276239>,
        < -40.125000, -18.033327, 64.940981>
      }
      triangle {
        <-40.481220, -18.033327, 65.124390>,
        <-40.125000, -18.033327, 64.940981>,
        < -40.125000, -19.934627, 65.276239>
      }
      triangle {
        <-40.125000, -18.033327, 64.500000>,
        <-40.125000, -18.033327, 64.940981>,
        < -40.125000, -16.132027, 65.276239>
      }
      triangle {
        <-40.481220, -16.372167, 65.387489>,
        <-40.125000, -16.132027, 65.276239>,
        < -40.125000, -18.033327, 64.940981>
      }
      triangle {
        <-40.125000, -18.298496, 64.390169>,
        <-40.125000, -18.033327, 64.940981>,
        < -40.125000, -18.033327, 64.500000>
      }
      triangle {
        <-40.481220, -18.033327, 65.124390>,
        <-40.481220, -16.372167, 65.387489>,
        < -40.125000, -18.033327, 64.940981>
      }
      triangle {
        <-40.481220, -21.193037, 66.151039>,
        <-40.125000, -19.934627, 65.276239>,
        < -40.125000, -21.606607, 66.241550>
      }
      triangle {
        <-40.125000, -18.298496, 64.390169>,
        <-40.125000, -18.408327, 64.125000>,
        < -40.125000, -19.934627, 65.276239>
      }
      triangle {
        <-40.481220, -19.694487, 65.387489>,
        <-40.481220, -18.033327, 65.124390>,
        < -40.125000, -19.934627, 65.276239>
      }
      triangle {
        <-40.481220, -21.193037, 66.151039>,
        <-40.481220, -19.694487, 65.387489>,
        < -40.125000, -19.934627, 65.276239>
      }
      triangle {
        <-40.125000, -22.541137, 66.367189>,
        <-40.125000, -22.847577, 67.720501>,
        < -40.125000, -21.606607, 66.241550>
      }
      triangle {
        <-40.481220, -22.382287, 67.340290>,
        <-40.125000, -21.606607, 66.241550>,
        < -40.125000, -22.847577, 67.720501>
      }
      triangle {
        <-40.125000, -22.166137, 65.992189>,
        <-40.125000, -22.275967, 66.257360>,
        < -40.125000, -21.606607, 66.241550>
      }
      triangle {
        <-40.125000, -22.541137, 66.367189>,
        <-40.125000, -21.606607, 66.241550>,
        < -40.125000, -22.275967, 66.257360>
      }
      triangle {
        <-40.481220, -22.382287, 67.340290>,
        <-40.481220, -21.193037, 66.151039>,
        < -40.125000, -21.606607, 66.241550>
      }
      triangle {
        <-40.125000, -22.916137, 65.992189>,
        <-40.125000, -23.507887, 69.534691>,
        < -40.125000, -22.847577, 67.720501>
      }
      triangle {
        <-40.481220, -23.145837, 68.838840>,
        <-40.125000, -22.847577, 67.720501>,
        < -40.125000, -23.507887, 69.534691>
      }
      triangle {
        <-40.125000, -22.806297, 66.257360>,
        <-40.125000, -22.916137, 65.992189>,
        < -40.125000, -22.847577, 67.720501>
      }
      triangle {
        <-40.125000, -22.541137, 66.367189>,
        <-40.125000, -22.806297, 66.257360>,
        < -40.125000, -22.847577, 67.720501>
      }
      triangle {
        <-40.481220, -23.145837, 68.838840>,
        <-40.481220, -22.382287, 67.340290>,
        < -40.125000, -22.847577, 67.720501>
      }
      triangle {
        <-40.481220, -23.408937, 70.500000>,
        <-40.125000, -23.507887, 69.534691>,
        < -40.125000, -23.507887, 71.465309>
      }
      triangle {
        <-40.481220, -23.408937, 70.500000>,
        <-40.481220, -23.145837, 68.838840>,
        < -40.125000, -23.507887, 69.534691>
      }
      triangle {
        <-40.125000, -22.916137, 75.007810>,
        <-40.125000, -22.847577, 73.279499>,
        < -40.125000, -23.507887, 71.465309>
      }
      triangle {
        <-40.481220, -23.145837, 72.161160>,
        <-40.125000, -23.507887, 71.465309>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.481220, -23.145837, 72.161160>,
        <-40.481220, -23.408937, 70.500000>,
        < -40.125000, -23.507887, 71.465309>
      }
      triangle {
        <-40.125000, -22.166137, 75.007810>,
        <-40.125000, -21.606607, 74.758450>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.481220, -22.382287, 73.659710>,
        <-40.125000, -22.847577, 73.279499>,
        < -40.125000, -21.606607, 74.758450>
      }
      triangle {
        <-40.125000, -22.541137, 74.632810>,
        <-40.125000, -22.275967, 74.742640>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.125000, -22.166137, 75.007810>,
        <-40.125000, -22.847577, 73.279499>,
        < -40.125000, -22.275967, 74.742640>
      }
      triangle {
        <-40.125000, -22.806297, 74.742640>,
        <-40.125000, -22.541137, 74.632810>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.125000, -22.916137, 75.007810>,
        <-40.125000, -22.806297, 74.742640>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.481220, -22.382287, 73.659710>,
        <-40.481220, -23.145837, 72.161160>,
        < -40.125000, -22.847577, 73.279499>
      }
      triangle {
        <-40.481220, -21.193037, 74.848960>,
        <-40.125000, -21.606607, 74.758450>,
        < -40.125000, -19.934627, 75.723760>
      }
      triangle {
        <-40.481220, -21.193037, 74.848960>,
        <-40.481220, -22.382287, 73.659710>,
        < -40.125000, -21.606607, 74.758450>
      }
      triangle {
        <-40.125000, -18.033327, 76.500000>,
        <-40.125000, -18.033327, 76.059020>,
        < -40.125000, -19.934627, 75.723760>
      }
      triangle {
        <-40.481220, -19.694487, 75.612510>,
        <-40.125000, -19.934627, 75.723760>,
        < -40.125000, -18.033327, 76.059020>
      }
      triangle {
        <-40.125000, -18.298496, 76.609830>,
        <-40.125000, -18.033327, 76.500000>,
        < -40.125000, -19.934627, 75.723760>
      }
      triangle {
        <-40.125000, -18.408327, 76.875000>,
        <-40.125000, -18.298496, 76.609830>,
        < -40.125000, -19.934627, 75.723760>
      }
      triangle {
        <-40.481220, -19.694487, 75.612510>,
        <-40.481220, -21.193037, 74.848960>,
        < -40.125000, -19.934627, 75.723760>
      }
      triangle {
        <-40.125000, -17.768158, 76.609830>,
        <-40.125000, -16.132027, 75.723760>,
        < -40.125000, -18.033327, 76.059020>
      }
      triangle {
        <-40.481220, -18.033327, 75.875610>,
        <-40.125000, -18.033327, 76.059020>,
        < -40.125000, -16.132027, 75.723760>
      }
      triangle {
        <-40.125000, -17.768158, 76.609830>,
        <-40.125000, -18.033327, 76.059020>,
        < -40.125000, -18.033327, 76.500000>
      }
      triangle {
        <-40.481220, -19.694487, 75.612510>,
        <-40.125000, -18.033327, 76.059020>,
        < -40.481220, -18.033327, 75.875610>
      }
      triangle {
        <-40.481220, -14.873617, 74.848960>,
        <-40.125000, -16.132027, 75.723760>,
        < -40.125000, -14.460047, 74.758450>
      }
      triangle {
        <-40.125000, -17.768158, 76.609830>,
        <-40.125000, -17.658327, 76.875000>,
        < -40.125000, -16.132027, 75.723760>
      }
      triangle {
        <-40.481220, -16.372167, 75.612510>,
        <-40.481220, -18.033327, 75.875610>,
        < -40.125000, -16.132027, 75.723760>
      }
      triangle {
        <-40.481220, -14.873617, 74.848960>,
        <-40.481220, -16.372167, 75.612510>,
        < -40.125000, -16.132027, 75.723760>
      }
      triangle {
        <-40.125000, -13.525516, 74.632810>,
        <-40.125000, -13.219076, 73.279499>,
        < -40.125000, -14.460047, 74.758450>
      }
      triangle {
        <-40.481220, -13.684366, 73.659710>,
        <-40.125000, -14.460047, 74.758450>,
        < -40.125000, -13.219076, 73.279499>
      }
      triangle {
        <-40.125000, -13.900516, 75.007810>,
        <-40.125000, -13.790687, 74.742640>,
        < -40.125000, -14.460047, 74.758450>
      }
      triangle {
        <-40.125000, -13.525516, 74.632810>,
        <-40.125000, -14.460047, 74.758450>,
        < -40.125000, -13.790687, 74.742640>
      }
      triangle {
        <-40.481220, -13.684366, 73.659710>,
        <-40.481220, -14.873617, 74.848960>,
        < -40.125000, -14.460047, 74.758450>
      }
      triangle {
        <-40.125000, -13.150516, 75.007810>,
        <-40.125000, -12.558767, 71.465309>,
        < -40.125000, -13.219076, 73.279499>
      }
      triangle {
        <-40.481220, -12.920816, 72.161160>,
        <-40.125000, -13.219076, 73.279499>,
        < -40.125000, -12.558767, 71.465309>
      }
      triangle {
        <-40.125000, -13.260357, 74.742640>,
        <-40.125000, -13.150516, 75.007810>,
        < -40.125000, -13.219076, 73.279499>
      }
      triangle {
        <-40.125000, -13.525516, 74.632810>,
        <-40.125000, -13.260357, 74.742640>,
        < -40.125000, -13.219076, 73.279499>
      }
      triangle {
        <-40.481220, -12.920816, 72.161160>,
        <-40.481220, -13.684366, 73.659710>,
        < -40.125000, -13.219076, 73.279499>
      }
      triangle {
        <-40.481220, -12.657717, 70.500000>,
        <-40.125000, -12.558767, 71.465309>,
        < -40.125000, -12.558767, 69.534691>
      }
      triangle {
        <-40.481220, -12.657717, 70.500000>,
        <-40.481220, -12.920816, 72.161160>,
        < -40.125000, -12.558767, 71.465309>
      }
      triangle {
        <-40.125000, -13.150516, 65.992189>,
        <-40.125000, -13.219076, 67.720501>,
        < -40.125000, -12.558767, 69.534691>
      }
      triangle {
        <-40.481220, -12.920816, 68.838840>,
        <-40.125000, -12.558767, 69.534691>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.481220, -12.920816, 68.838840>,
        <-40.481220, -12.657717, 70.500000>,
        < -40.125000, -12.558767, 69.534691>
      }
      triangle {
        <-40.125000, -13.900516, 65.992189>,
        <-40.125000, -14.460047, 66.241550>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.481220, -13.684366, 67.340290>,
        <-40.125000, -13.219076, 67.720501>,
        < -40.125000, -14.460047, 66.241550>
      }
      triangle {
        <-40.125000, -13.525516, 66.367189>,
        <-40.125000, -13.790687, 66.257360>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.125000, -13.900516, 65.992189>,
        <-40.125000, -13.219076, 67.720501>,
        < -40.125000, -13.790687, 66.257360>
      }
      triangle {
        <-40.125000, -13.260357, 66.257360>,
        <-40.125000, -13.525516, 66.367189>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.125000, -13.150516, 65.992189>,
        <-40.125000, -13.260357, 66.257360>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.481220, -13.684366, 67.340290>,
        <-40.481220, -12.920816, 68.838840>,
        < -40.125000, -13.219076, 67.720501>
      }
      triangle {
        <-40.481220, -14.873617, 66.151039>,
        <-40.125000, -14.460047, 66.241550>,
        < -40.125000, -16.132027, 65.276239>
      }
      triangle {
        <-40.481220, -14.873617, 66.151039>,
        <-40.481220, -13.684366, 67.340290>,
        < -40.125000, -14.460047, 66.241550>
      }
      triangle {
        <-40.125000, -17.768158, 64.390169>,
        <-40.125000, -18.033327, 64.500000>,
        < -40.125000, -16.132027, 65.276239>
      }
      triangle {
        <-40.125000, -17.658327, 64.125000>,
        <-40.125000, -17.768158, 64.390169>,
        < -40.125000, -16.132027, 65.276239>
      }
      triangle {
        <-40.481220, -16.372167, 65.387489>,
        <-40.481220, -14.873617, 66.151039>,
        < -40.125000, -16.132027, 65.276239>
      }
      triangle {
        <-41.125000, -18.033327, 64.500000>,
        <-40.125000, -18.033327, 64.500000>,
        < -40.125000, -17.768158, 64.390169>
      }
      triangle {
        <-41.125000, -18.298496, 64.390160>,
        <-40.125000, -18.298496, 64.390169>,
        < -40.125000, -18.033327, 64.500000>
      }
      triangle {
        <-41.125000, -18.298496, 64.390160>,
        <-40.125000, -18.033327, 64.500000>,
        < -41.125000, -18.033327, 64.500000>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-40.125000, -17.768158, 64.390169>,
        < -40.125000, -17.658327, 64.125000>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-41.125000, -18.033327, 64.500000>,
        < -40.125000, -17.768158, 64.390169>
      }
      triangle {
        <-41.125000, -17.658327, 64.125000>,
        <-40.125000, -17.658327, 64.125000>,
        < -40.125000, -17.768158, 63.859831>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-40.125000, -17.658327, 64.125000>,
        < -41.125000, -17.658327, 64.125000>
      }
      triangle {
        <-41.125000, -17.768158, 63.859840>,
        <-40.125000, -17.768158, 63.859831>,
        < -40.125000, -18.033327, 63.750000>
      }
      triangle {
        <-41.125000, -17.658327, 64.125000>,
        <-40.125000, -17.768158, 63.859831>,
        < -41.125000, -17.768158, 63.859840>
      }
      triangle {
        <-41.125000, -18.033327, 63.750000>,
        <-40.125000, -18.033327, 63.750000>,
        < -40.125000, -18.298496, 63.859831>
      }
      triangle {
        <-41.125000, -17.768158, 63.859840>,
        <-40.125000, -18.033327, 63.750000>,
        < -41.125000, -18.033327, 63.750000>
      }
      triangle {
        <-41.125000, -18.298496, 63.859840>,
        <-40.125000, -18.298496, 63.859831>,
        < -40.125000, -18.408327, 64.125000>
      }
      triangle {
        <-41.125000, -18.033327, 63.750000>,
        <-40.125000, -18.298496, 63.859831>,
        < -41.125000, -18.298496, 63.859840>
      }
      triangle {
        <-41.125000, -18.408327, 64.125000>,
        <-40.125000, -18.408327, 64.125000>,
        < -40.125000, -18.298496, 64.390169>
      }
      triangle {
        <-41.125000, -18.298496, 63.859840>,
        <-40.125000, -18.408327, 64.125000>,
        < -41.125000, -18.408327, 64.125000>
      }
      triangle {
        <-41.125000, -18.408327, 64.125000>,
        <-40.125000, -18.298496, 64.390169>,
        < -41.125000, -18.298496, 64.390160>
      }
      triangle {
        <-41.125000, -13.790687, 66.257360>,
        <-40.125000, -13.790687, 66.257360>,
        < -40.125000, -13.525516, 66.367189>
      }
      triangle {
        <-41.125000, -13.900516, 65.992189>,
        <-40.125000, -13.900516, 65.992189>,
        < -40.125000, -13.790687, 66.257360>
      }
      triangle {
        <-41.125000, -13.900516, 65.992189>,
        <-40.125000, -13.790687, 66.257360>,
        < -41.125000, -13.790687, 66.257360>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-40.125000, -13.525516, 66.367189>,
        < -40.125000, -13.260357, 66.257360>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-41.125000, -13.790687, 66.257360>,
        < -40.125000, -13.525516, 66.367189>
      }
      triangle {
        <-41.125000, -13.260357, 66.257360>,
        <-40.125000, -13.260357, 66.257360>,
        < -40.125000, -13.150516, 65.992189>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-40.125000, -13.260357, 66.257360>,
        < -41.125000, -13.260357, 66.257360>
      }
      triangle {
        <-41.125000, -13.150516, 65.992201>,
        <-40.125000, -13.150516, 65.992189>,
        < -40.125000, -13.260357, 65.727030>
      }
      triangle {
        <-41.125000, -13.260357, 66.257360>,
        <-40.125000, -13.150516, 65.992189>,
        < -41.125000, -13.150516, 65.992201>
      }
      triangle {
        <-41.125000, -13.260357, 65.727030>,
        <-40.125000, -13.260357, 65.727030>,
        < -40.125000, -13.525516, 65.617189>
      }
      triangle {
        <-41.125000, -13.150516, 65.992201>,
        <-40.125000, -13.260357, 65.727030>,
        < -41.125000, -13.260357, 65.727030>
      }
      triangle {
        <-41.125000, -13.525528, 65.617189>,
        <-40.125000, -13.525516, 65.617189>,
        < -40.125000, -13.790687, 65.727030>
      }
      triangle {
        <-41.125000, -13.260357, 65.727030>,
        <-40.125000, -13.525516, 65.617189>,
        < -41.125000, -13.525528, 65.617189>
      }
      triangle {
        <-41.125000, -13.790687, 65.727030>,
        <-40.125000, -13.790687, 65.727030>,
        < -40.125000, -13.900516, 65.992189>
      }
      triangle {
        <-41.125000, -13.525528, 65.617189>,
        <-40.125000, -13.790687, 65.727030>,
        < -41.125000, -13.790687, 65.727030>
      }
      triangle {
        <-41.125000, -13.790687, 65.727030>,
        <-40.125000, -13.900516, 65.992189>,
        < -41.125000, -13.900516, 65.992189>
      }
      triangle {
        <-41.125000, -12.033327, 70.500000>,
        <-40.125000, -12.033327, 70.500000>,
        < -40.125000, -11.923496, 70.765169>
      }
      triangle {
        <-41.125000, -11.923487, 70.234831>,
        <-40.125000, -11.923496, 70.234831>,
        < -40.125000, -12.033327, 70.500000>
      }
      triangle {
        <-41.125000, -11.923487, 70.234831>,
        <-40.125000, -12.033327, 70.500000>,
        < -41.125000, -12.033327, 70.500000>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-40.125000, -11.923496, 70.765169>,
        < -40.125000, -11.658327, 70.875000>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-41.125000, -12.033327, 70.500000>,
        < -40.125000, -11.923496, 70.765169>
      }
      triangle {
        <-41.125000, -11.658327, 70.875000>,
        <-40.125000, -11.658327, 70.875000>,
        < -40.125000, -11.393158, 70.765169>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-40.125000, -11.658327, 70.875000>,
        < -41.125000, -11.658327, 70.875000>
      }
      triangle {
        <-41.125000, -11.393167, 70.765169>,
        <-40.125000, -11.393158, 70.765169>,
        < -40.125000, -11.283327, 70.500000>
      }
      triangle {
        <-41.125000, -11.658327, 70.875000>,
        <-40.125000, -11.393158, 70.765169>,
        < -41.125000, -11.393167, 70.765169>
      }
      triangle {
        <-41.125000, -11.283327, 70.500000>,
        <-40.125000, -11.283327, 70.500000>,
        < -40.125000, -11.393158, 70.234831>
      }
      triangle {
        <-41.125000, -11.393167, 70.765169>,
        <-40.125000, -11.283327, 70.500000>,
        < -41.125000, -11.283327, 70.500000>
      }
      triangle {
        <-41.125000, -11.393167, 70.234831>,
        <-40.125000, -11.393158, 70.234831>,
        < -40.125000, -11.658327, 70.125000>
      }
      triangle {
        <-41.125000, -11.283327, 70.500000>,
        <-40.125000, -11.393158, 70.234831>,
        < -41.125000, -11.393167, 70.234831>
      }
      triangle {
        <-41.125000, -11.658327, 70.125000>,
        <-40.125000, -11.658327, 70.125000>,
        < -40.125000, -11.923496, 70.234831>
      }
      triangle {
        <-41.125000, -11.393167, 70.234831>,
        <-40.125000, -11.658327, 70.125000>,
        < -41.125000, -11.658327, 70.125000>
      }
      triangle {
        <-41.125000, -11.658327, 70.125000>,
        <-40.125000, -11.923496, 70.234831>,
        < -41.125000, -11.923487, 70.234831>
      }
      triangle {
        <-41.125000, -13.790687, 74.742640>,
        <-40.125000, -13.790687, 74.742640>,
        < -40.125000, -13.900516, 75.007810>
      }
      triangle {
        <-41.125000, -13.525516, 74.632810>,
        <-40.125000, -13.525516, 74.632810>,
        < -40.125000, -13.790687, 74.742640>
      }
      triangle {
        <-41.125000, -13.525516, 74.632810>,
        <-40.125000, -13.790687, 74.742640>,
        < -41.125000, -13.790687, 74.742640>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-40.125000, -13.900516, 75.007810>,
        < -40.125000, -13.790687, 75.272970>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-41.125000, -13.790687, 74.742640>,
        < -40.125000, -13.900516, 75.007810>
      }
      triangle {
        <-41.125000, -13.790687, 75.272970>,
        <-40.125000, -13.790687, 75.272970>,
        < -40.125000, -13.525516, 75.382810>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-40.125000, -13.790687, 75.272970>,
        < -41.125000, -13.790687, 75.272970>
      }
      triangle {
        <-41.125000, -13.525528, 75.382810>,
        <-40.125000, -13.525516, 75.382810>,
        < -40.125000, -13.260357, 75.272970>
      }
      triangle {
        <-41.125000, -13.790687, 75.272970>,
        <-40.125000, -13.525516, 75.382810>,
        < -41.125000, -13.525528, 75.382810>
      }
      triangle {
        <-41.125000, -13.260357, 75.272970>,
        <-40.125000, -13.260357, 75.272970>,
        < -40.125000, -13.150516, 75.007810>
      }
      triangle {
        <-41.125000, -13.525528, 75.382810>,
        <-40.125000, -13.260357, 75.272970>,
        < -41.125000, -13.260357, 75.272970>
      }
      triangle {
        <-41.125000, -13.150516, 75.007800>,
        <-40.125000, -13.150516, 75.007810>,
        < -40.125000, -13.260357, 74.742640>
      }
      triangle {
        <-41.125000, -13.260357, 75.272970>,
        <-40.125000, -13.150516, 75.007810>,
        < -41.125000, -13.150516, 75.007800>
      }
      triangle {
        <-41.125000, -13.260357, 74.742640>,
        <-40.125000, -13.260357, 74.742640>,
        < -40.125000, -13.525516, 74.632810>
      }
      triangle {
        <-41.125000, -13.150516, 75.007800>,
        <-40.125000, -13.260357, 74.742640>,
        < -41.125000, -13.260357, 74.742640>
      }
      triangle {
        <-41.125000, -13.260357, 74.742640>,
        <-40.125000, -13.525516, 74.632810>,
        < -41.125000, -13.525516, 74.632810>
      }
      triangle {
        <-41.125000, -18.033327, 76.500000>,
        <-40.125000, -18.033327, 76.500000>,
        < -40.125000, -18.298496, 76.609830>
      }
      triangle {
        <-41.125000, -17.768158, 76.609840>,
        <-40.125000, -17.768158, 76.609830>,
        < -40.125000, -18.033327, 76.500000>
      }
      triangle {
        <-41.125000, -17.768158, 76.609840>,
        <-40.125000, -18.033327, 76.500000>,
        < -41.125000, -18.033327, 76.500000>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-40.125000, -18.298496, 76.609830>,
        < -40.125000, -18.408327, 76.875000>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-41.125000, -18.033327, 76.500000>,
        < -40.125000, -18.298496, 76.609830>
      }
      triangle {
        <-41.125000, -18.408327, 76.875000>,
        <-40.125000, -18.408327, 76.875000>,
        < -40.125000, -18.298496, 77.140170>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-40.125000, -18.408327, 76.875000>,
        < -41.125000, -18.408327, 76.875000>
      }
      triangle {
        <-41.125000, -18.298496, 77.140160>,
        <-40.125000, -18.298496, 77.140170>,
        < -40.125000, -18.033327, 77.250000>
      }
      triangle {
        <-41.125000, -18.408327, 76.875000>,
        <-40.125000, -18.298496, 77.140170>,
        < -41.125000, -18.298496, 77.140160>
      }
      triangle {
        <-41.125000, -18.033327, 77.250000>,
        <-40.125000, -18.033327, 77.250000>,
        < -40.125000, -17.768158, 77.140170>
      }
      triangle {
        <-41.125000, -18.298496, 77.140160>,
        <-40.125000, -18.033327, 77.250000>,
        < -41.125000, -18.033327, 77.250000>
      }
      triangle {
        <-41.125000, -17.768158, 77.140160>,
        <-40.125000, -17.768158, 77.140170>,
        < -40.125000, -17.658327, 76.875000>
      }
      triangle {
        <-41.125000, -18.033327, 77.250000>,
        <-40.125000, -17.768158, 77.140170>,
        < -41.125000, -17.768158, 77.140160>
      }
      triangle {
        <-41.125000, -17.658327, 76.875000>,
        <-40.125000, -17.658327, 76.875000>,
        < -40.125000, -17.768158, 76.609830>
      }
      triangle {
        <-41.125000, -17.768158, 77.140160>,
        <-40.125000, -17.658327, 76.875000>,
        < -41.125000, -17.658327, 76.875000>
      }
      triangle {
        <-41.125000, -17.658327, 76.875000>,
        <-40.125000, -17.768158, 76.609830>,
        < -41.125000, -17.768158, 76.609840>
      }
      triangle {
        <-41.125000, -22.275967, 74.742640>,
        <-40.125000, -22.275967, 74.742640>,
        < -40.125000, -22.541137, 74.632810>
      }
      triangle {
        <-41.125000, -22.166137, 75.007810>,
        <-40.125000, -22.166137, 75.007810>,
        < -40.125000, -22.275967, 74.742640>
      }
      triangle {
        <-41.125000, -22.166137, 75.007810>,
        <-40.125000, -22.275967, 74.742640>,
        < -41.125000, -22.275967, 74.742640>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-40.125000, -22.541137, 74.632810>,
        < -40.125000, -22.806297, 74.742640>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-41.125000, -22.275967, 74.742640>,
        < -40.125000, -22.541137, 74.632810>
      }
      triangle {
        <-41.125000, -22.806297, 74.742640>,
        <-40.125000, -22.806297, 74.742640>,
        < -40.125000, -22.916137, 75.007810>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-40.125000, -22.806297, 74.742640>,
        < -41.125000, -22.806297, 74.742640>
      }
      triangle {
        <-41.125000, -22.916137, 75.007800>,
        <-40.125000, -22.916137, 75.007810>,
        < -40.125000, -22.806297, 75.272970>
      }
      triangle {
        <-41.125000, -22.806297, 74.742640>,
        <-40.125000, -22.916137, 75.007810>,
        < -41.125000, -22.916137, 75.007800>
      }
      triangle {
        <-41.125000, -22.806297, 75.272970>,
        <-40.125000, -22.806297, 75.272970>,
        < -40.125000, -22.541137, 75.382810>
      }
      triangle {
        <-41.125000, -22.916137, 75.007800>,
        <-40.125000, -22.806297, 75.272970>,
        < -41.125000, -22.806297, 75.272970>
      }
      triangle {
        <-41.125000, -22.541127, 75.382810>,
        <-40.125000, -22.541137, 75.382810>,
        < -40.125000, -22.275967, 75.272970>
      }
      triangle {
        <-41.125000, -22.806297, 75.272970>,
        <-40.125000, -22.541137, 75.382810>,
        < -41.125000, -22.541127, 75.382810>
      }
      triangle {
        <-41.125000, -22.275967, 75.272970>,
        <-40.125000, -22.275967, 75.272970>,
        < -40.125000, -22.166137, 75.007810>
      }
      triangle {
        <-41.125000, -22.541127, 75.382810>,
        <-40.125000, -22.275967, 75.272970>,
        < -41.125000, -22.275967, 75.272970>
      }
      triangle {
        <-41.125000, -22.275967, 75.272970>,
        <-40.125000, -22.166137, 75.007810>,
        < -41.125000, -22.166137, 75.007810>
      }
      triangle {
        <-41.125000, -24.033327, 70.500000>,
        <-40.125000, -24.033327, 70.500000>,
        < -40.125000, -24.143157, 70.234831>
      }
      triangle {
        <-41.125000, -24.143167, 70.765169>,
        <-40.125000, -24.143157, 70.765169>,
        < -40.125000, -24.033327, 70.500000>
      }
      triangle {
        <-41.125000, -24.143167, 70.765169>,
        <-40.125000, -24.033327, 70.500000>,
        < -41.125000, -24.033327, 70.500000>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-40.125000, -24.143157, 70.234831>,
        < -40.125000, -24.408327, 70.125000>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-41.125000, -24.033327, 70.500000>,
        < -40.125000, -24.143157, 70.234831>
      }
      triangle {
        <-41.125000, -24.408327, 70.125000>,
        <-40.125000, -24.408327, 70.125000>,
        < -40.125000, -24.673497, 70.234831>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-40.125000, -24.408327, 70.125000>,
        < -41.125000, -24.408327, 70.125000>
      }
      triangle {
        <-41.125000, -24.673487, 70.234831>,
        <-40.125000, -24.673497, 70.234831>,
        < -40.125000, -24.783327, 70.500000>
      }
      triangle {
        <-41.125000, -24.408327, 70.125000>,
        <-40.125000, -24.673497, 70.234831>,
        < -41.125000, -24.673487, 70.234831>
      }
      triangle {
        <-41.125000, -24.783327, 70.500000>,
        <-40.125000, -24.783327, 70.500000>,
        < -40.125000, -24.673497, 70.765169>
      }
      triangle {
        <-41.125000, -24.673487, 70.234831>,
        <-40.125000, -24.783327, 70.500000>,
        < -41.125000, -24.783327, 70.500000>
      }
      triangle {
        <-41.125000, -24.673487, 70.765169>,
        <-40.125000, -24.673497, 70.765169>,
        < -40.125000, -24.408327, 70.875000>
      }
      triangle {
        <-41.125000, -24.783327, 70.500000>,
        <-40.125000, -24.673497, 70.765169>,
        < -41.125000, -24.673487, 70.765169>
      }
      triangle {
        <-41.125000, -24.408327, 70.875000>,
        <-40.125000, -24.408327, 70.875000>,
        < -40.125000, -24.143157, 70.765169>
      }
      triangle {
        <-41.125000, -24.673487, 70.765169>,
        <-40.125000, -24.408327, 70.875000>,
        < -41.125000, -24.408327, 70.875000>
      }
      triangle {
        <-41.125000, -24.408327, 70.875000>,
        <-40.125000, -24.143157, 70.765169>,
        < -41.125000, -24.143167, 70.765169>
      }
      triangle {
        <-41.125000, -22.275967, 66.257360>,
        <-40.125000, -22.275967, 66.257360>,
        < -40.125000, -22.166137, 65.992189>
      }
      triangle {
        <-41.125000, -22.541137, 66.367189>,
        <-40.125000, -22.541137, 66.367189>,
        < -40.125000, -22.275967, 66.257360>
      }
      triangle {
        <-41.125000, -22.541137, 66.367189>,
        <-40.125000, -22.275967, 66.257360>,
        < -41.125000, -22.275967, 66.257360>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-40.125000, -22.166137, 65.992189>,
        < -40.125000, -22.275967, 65.727030>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-41.125000, -22.275967, 66.257360>,
        < -40.125000, -22.166137, 65.992189>
      }
      triangle {
        <-41.125000, -22.275967, 65.727030>,
        <-40.125000, -22.275967, 65.727030>,
        < -40.125000, -22.541137, 65.617189>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-40.125000, -22.275967, 65.727030>,
        < -41.125000, -22.275967, 65.727030>
      }
      triangle {
        <-41.125000, -22.541127, 65.617189>,
        <-40.125000, -22.541137, 65.617189>,
        < -40.125000, -22.806297, 65.727030>
      }
      triangle {
        <-41.125000, -22.275967, 65.727030>,
        <-40.125000, -22.541137, 65.617189>,
        < -41.125000, -22.541127, 65.617189>
      }
      triangle {
        <-41.125000, -22.806297, 65.727030>,
        <-40.125000, -22.806297, 65.727030>,
        < -40.125000, -22.916137, 65.992189>
      }
      triangle {
        <-41.125000, -22.541127, 65.617189>,
        <-40.125000, -22.806297, 65.727030>,
        < -41.125000, -22.806297, 65.727030>
      }
      triangle {
        <-41.125000, -22.916137, 65.992201>,
        <-40.125000, -22.916137, 65.992189>,
        < -40.125000, -22.806297, 66.257360>
      }
      triangle {
        <-41.125000, -22.806297, 65.727030>,
        <-40.125000, -22.916137, 65.992189>,
        < -41.125000, -22.916137, 65.992201>
      }
      triangle {
        <-41.125000, -22.806297, 66.257360>,
        <-40.125000, -22.806297, 66.257360>,
        < -40.125000, -22.541137, 66.367189>
      }
      triangle {
        <-41.125000, -22.916137, 65.992201>,
        <-40.125000, -22.806297, 66.257360>,
        < -41.125000, -22.806297, 66.257360>
      }
      triangle {
        <-41.125000, -22.806297, 66.257360>,
        <-40.125000, -22.541137, 66.367189>,
        < -41.125000, -22.541137, 66.367189>
      }
      triangle {
        <-40.625000, -18.033327, 75.500410>,
        <-40.481220, -18.033327, 75.875610>,
        < -40.481220, -16.372167, 75.612510>
      }
      triangle {
        <-40.625000, -19.578537, 75.255670>,
        <-40.481220, -18.033327, 75.875610>,
        < -40.625000, -18.033327, 75.500410>
      }
      triangle {
        <-40.625000, -19.578537, 75.255670>,
        <-40.481220, -19.694487, 75.612510>,
        < -40.481220, -18.033327, 75.875610>
      }
      triangle {
        <-40.625000, -16.488117, 75.255670>,
        <-40.481220, -16.372167, 75.612510>,
        < -40.481220, -14.873617, 74.848960>
      }
      triangle {
        <-40.625000, -16.488117, 75.255670>,
        <-40.625000, -18.033327, 75.500410>,
        < -40.481220, -16.372167, 75.612510>
      }
      triangle {
        <-40.625000, -15.094156, 74.545420>,
        <-40.481220, -14.873617, 74.848960>,
        < -40.481220, -13.684366, 73.659710>
      }
      triangle {
        <-40.625000, -15.094156, 74.545420>,
        <-40.625000, -16.488117, 75.255670>,
        < -40.481220, -14.873617, 74.848960>
      }
      triangle {
        <-40.625000, -13.987907, 73.439171>,
        <-40.481220, -13.684366, 73.659710>,
        < -40.481220, -12.920816, 72.161160>
      }
      triangle {
        <-40.625000, -13.987907, 73.439171>,
        <-40.625000, -15.094156, 74.545420>,
        < -40.481220, -13.684366, 73.659710>
      }
      triangle {
        <-40.625000, -13.277656, 72.045210>,
        <-40.481220, -12.920816, 72.161160>,
        < -40.481220, -12.657717, 70.500000>
      }
      triangle {
        <-40.625000, -13.277656, 72.045210>,
        <-40.625000, -13.987907, 73.439171>,
        < -40.481220, -12.920816, 72.161160>
      }
      triangle {
        <-40.625000, -13.032917, 70.500000>,
        <-40.481220, -12.657717, 70.500000>,
        < -40.481220, -12.920816, 68.838840>
      }
      triangle {
        <-40.625000, -13.032917, 70.500000>,
        <-40.625000, -13.277656, 72.045210>,
        < -40.481220, -12.657717, 70.500000>
      }
      triangle {
        <-40.625000, -13.277656, 68.954790>,
        <-40.481220, -12.920816, 68.838840>,
        < -40.481220, -13.684366, 67.340290>
      }
      triangle {
        <-40.625000, -13.277656, 68.954790>,
        <-40.625000, -13.032917, 70.500000>,
        < -40.481220, -12.920816, 68.838840>
      }
      triangle {
        <-40.625000, -13.987907, 67.560829>,
        <-40.481220, -13.684366, 67.340290>,
        < -40.481220, -14.873617, 66.151039>
      }
      triangle {
        <-40.625000, -13.987907, 67.560829>,
        <-40.625000, -13.277656, 68.954790>,
        < -40.481220, -13.684366, 67.340290>
      }
      triangle {
        <-40.625000, -15.094156, 66.454580>,
        <-40.481220, -14.873617, 66.151039>,
        < -40.481220, -16.372167, 65.387489>
      }
      triangle {
        <-40.625000, -15.094156, 66.454580>,
        <-40.625000, -13.987907, 67.560829>,
        < -40.481220, -14.873617, 66.151039>
      }
      triangle {
        <-40.625000, -16.488117, 65.744329>,
        <-40.481220, -16.372167, 65.387489>,
        < -40.481220, -18.033327, 65.124390>
      }
      triangle {
        <-40.625000, -16.488117, 65.744329>,
        <-40.625000, -15.094156, 66.454580>,
        < -40.481220, -16.372167, 65.387489>
      }
      triangle {
        <-40.625000, -16.488117, 65.744329>,
        <-40.481220, -18.033327, 65.124390>,
        < -40.625000, -18.033327, 65.499590>
      }
      triangle {
        <-40.481220, -19.694487, 65.387489>,
        <-40.625000, -18.033327, 65.499590>,
        < -40.481220, -18.033327, 65.124390>
      }
      triangle {
        <-40.481758, -16.604128, 66.101360>,
        <-40.625000, -16.488117, 65.744329>,
        < -40.625000, -18.033327, 65.499590>
      }
      triangle {
        <-40.481758, -16.604128, 66.101360>,
        <-40.625000, -18.033327, 65.499590>,
        < -40.481758, -18.033327, 65.875000>
      }
      triangle {
        <-40.625000, -19.578537, 65.744329>,
        <-40.481758, -18.033327, 65.875000>,
        < -40.625000, -18.033327, 65.499590>
      }
      triangle {
        <-40.625000, -19.578537, 65.744329>,
        <-40.625000, -18.033327, 65.499590>,
        < -40.481220, -19.694487, 65.387489>
      }
      triangle {
        <-40.481758, -18.033327, 75.125000>,
        <-40.625000, -18.033327, 75.500410>,
        < -40.625000, -16.488117, 75.255670>
      }
      triangle {
        <-40.481758, -19.462526, 74.898640>,
        <-40.625000, -18.033327, 75.500410>,
        < -40.481758, -18.033327, 75.125000>
      }
      triangle {
        <-40.481758, -19.462526, 74.898640>,
        <-40.625000, -19.578537, 75.255670>,
        < -40.625000, -18.033327, 75.500410>
      }
      triangle {
        <-40.481758, -16.604128, 74.898640>,
        <-40.625000, -16.488117, 75.255670>,
        < -40.625000, -15.094156, 74.545420>
      }
      triangle {
        <-40.481758, -16.604128, 74.898640>,
        <-40.481758, -18.033327, 75.125000>,
        < -40.625000, -16.488117, 75.255670>
      }
      triangle {
        <-40.481758, -15.314817, 74.241699>,
        <-40.625000, -15.094156, 74.545420>,
        < -40.625000, -13.987907, 73.439171>
      }
      triangle {
        <-40.481758, -15.314817, 74.241699>,
        <-40.481758, -16.604128, 74.898640>,
        < -40.625000, -15.094156, 74.545420>
      }
      triangle {
        <-40.481758, -14.291628, 73.218510>,
        <-40.625000, -13.987907, 73.439171>,
        < -40.625000, -13.277656, 72.045210>
      }
      triangle {
        <-40.481758, -14.291628, 73.218510>,
        <-40.481758, -15.314817, 74.241699>,
        < -40.625000, -13.987907, 73.439171>
      }
      triangle {
        <-40.481758, -13.634687, 71.929199>,
        <-40.625000, -13.277656, 72.045210>,
        < -40.625000, -13.032917, 70.500000>
      }
      triangle {
        <-40.481758, -13.634687, 71.929199>,
        <-40.481758, -14.291628, 73.218510>,
        < -40.625000, -13.277656, 72.045210>
      }
      triangle {
        <-40.481758, -13.408327, 70.500000>,
        <-40.625000, -13.032917, 70.500000>,
        < -40.625000, -13.277656, 68.954790>
      }
      triangle {
        <-40.481758, -13.408327, 70.500000>,
        <-40.481758, -13.634687, 71.929199>,
        < -40.625000, -13.032917, 70.500000>
      }
      triangle {
        <-40.481758, -13.634687, 69.070801>,
        <-40.625000, -13.277656, 68.954790>,
        < -40.625000, -13.987907, 67.560829>
      }
      triangle {
        <-40.481758, -13.634687, 69.070801>,
        <-40.481758, -13.408327, 70.500000>,
        < -40.625000, -13.277656, 68.954790>
      }
      triangle {
        <-40.481758, -14.291628, 67.781490>,
        <-40.625000, -13.987907, 67.560829>,
        < -40.625000, -15.094156, 66.454580>
      }
      triangle {
        <-40.481758, -14.291628, 67.781490>,
        <-40.481758, -13.634687, 69.070801>,
        < -40.625000, -13.987907, 67.560829>
      }
      triangle {
        <-40.481758, -15.314817, 66.758301>,
        <-40.625000, -15.094156, 66.454580>,
        < -40.625000, -16.488117, 65.744329>
      }
      triangle {
        <-40.481758, -15.314817, 66.758301>,
        <-40.481758, -14.291628, 67.781490>,
        < -40.625000, -15.094156, 66.454580>
      }
      triangle {
        <-40.481758, -16.604128, 66.101360>,
        <-40.481758, -15.314817, 66.758301>,
        < -40.625000, -16.488117, 65.744329>
      }
      triangle {
        <-40.125000, -16.333847, 66.397060>,
        <-40.481758, -16.604128, 66.101360>,
        < -40.481758, -18.033327, 65.875000>
      }
      triangle {
        <-40.125000, -16.333847, 66.397060>,
        <-40.481758, -18.033327, 65.875000>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.481758, -19.462526, 66.101360>,
        <-40.125000, -18.033327, 66.059019>,
        < -40.481758, -18.033327, 65.875000>
      }
      triangle {
        <-40.481758, -19.462526, 66.101360>,
        <-40.481758, -18.033327, 65.875000>,
        < -40.625000, -19.578537, 65.744329>
      }
      triangle {
        <-40.125000, -18.033327, 74.940980>,
        <-40.481758, -18.033327, 75.125000>,
        < -40.481758, -16.604128, 74.898640>
      }
      triangle {
        <-40.125000, -19.732807, 74.602940>,
        <-40.481758, -18.033327, 75.125000>,
        < -40.125000, -18.033327, 74.940980>
      }
      triangle {
        <-40.481758, -19.462526, 74.898640>,
        <-40.481758, -18.033327, 75.125000>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.125000, -16.333847, 74.602940>,
        <-40.481758, -16.604128, 74.898640>,
        < -40.481758, -15.314817, 74.241699>
      }
      triangle {
        <-40.125000, -16.333847, 74.602940>,
        <-40.125000, -18.033327, 74.940980>,
        < -40.481758, -16.604128, 74.898640>
      }
      triangle {
        <-40.125000, -14.893066, 73.640240>,
        <-40.481758, -15.314817, 74.241699>,
        < -40.481758, -14.291628, 73.218510>
      }
      triangle {
        <-40.125000, -14.893066, 73.640240>,
        <-40.125000, -16.333847, 74.602940>,
        < -40.481758, -15.314817, 74.241699>
      }
      triangle {
        <-40.125000, -13.930397, 72.199499>,
        <-40.481758, -14.291628, 73.218510>,
        < -40.481758, -13.634687, 71.929199>
      }
      triangle {
        <-40.125000, -13.930397, 72.199499>,
        <-40.125000, -14.893066, 73.640240>,
        < -40.481758, -14.291628, 73.218510>
      }
      triangle {
        <-40.125000, -13.930397, 72.199499>,
        <-40.481758, -13.634687, 71.929199>,
        < -40.481758, -13.408327, 70.500000>
      }
      triangle {
        <-40.125000, -13.592346, 70.500000>,
        <-40.481758, -13.408327, 70.500000>,
        < -40.481758, -13.634687, 69.070801>
      }
      triangle {
        <-40.125000, -13.592346, 70.500000>,
        <-40.125000, -13.930397, 72.199499>,
        < -40.481758, -13.408327, 70.500000>
      }
      triangle {
        <-40.125000, -13.930397, 68.800501>,
        <-40.481758, -13.634687, 69.070801>,
        < -40.481758, -14.291628, 67.781490>
      }
      triangle {
        <-40.125000, -13.930397, 68.800501>,
        <-40.125000, -13.592346, 70.500000>,
        < -40.481758, -13.634687, 69.070801>
      }
      triangle {
        <-40.125000, -14.893066, 67.359760>,
        <-40.481758, -14.291628, 67.781490>,
        < -40.481758, -15.314817, 66.758301>
      }
      triangle {
        <-40.125000, -14.893066, 67.359760>,
        <-40.125000, -13.930397, 68.800501>,
        < -40.481758, -14.291628, 67.781490>
      }
      triangle {
        <-40.125000, -16.333847, 66.397060>,
        <-40.481758, -15.314817, 66.758301>,
        < -40.481758, -16.604128, 66.101360>
      }
      triangle {
        <-40.125000, -16.333847, 66.397060>,
        <-40.125000, -14.893066, 67.359760>,
        < -40.481758, -15.314817, 66.758301>
      }
      triangle {
        <-40.125000, -16.783327, 68.334940>,
        <-40.125000, -16.333847, 66.397060>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.125000, -18.033327, 66.750000>,
        <-40.125000, -18.033327, 66.059019>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.481758, -19.462526, 66.101360>,
        <-40.125000, -19.732807, 66.397060>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.125000, -17.658327, 67.125000>,
        <-40.125000, -16.783327, 68.334940>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.125000, -17.768158, 66.859831>,
        <-40.125000, -17.658327, 67.125000>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.125000, -18.033327, 66.750000>,
        <-40.125000, -17.768158, 66.859831>,
        < -40.125000, -18.033327, 66.059019>
      }
      triangle {
        <-40.125000, -18.033327, 74.250000>,
        <-40.125000, -18.033327, 74.940980>,
        < -40.125000, -16.333847, 74.602940>
      }
      triangle {
        <-40.125000, -19.283327, 72.665060>,
        <-40.125000, -19.732807, 74.602940>,
        < -40.125000, -18.033327, 74.940980>
      }
      triangle {
        <-40.125000, -18.408327, 73.875000>,
        <-40.125000, -19.283327, 72.665060>,
        < -40.125000, -18.033327, 74.940980>
      }
      triangle {
        <-40.125000, -18.298496, 74.140169>,
        <-40.125000, -18.408327, 73.875000>,
        < -40.125000, -18.033327, 74.940980>
      }
      triangle {
        <-40.125000, -18.033327, 74.250000>,
        <-40.125000, -18.298496, 74.140169>,
        < -40.125000, -18.033327, 74.940980>
      }
      triangle {
        <-40.125000, -15.912006, 73.151649>,
        <-40.125000, -16.333847, 74.602940>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -16.021837, 72.886490>,
        <-40.125000, -16.783327, 72.665060>,
        < -40.125000, -16.333847, 74.602940>
      }
      triangle {
        <-40.125000, -17.658327, 73.875000>,
        <-40.125000, -16.333847, 74.602940>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.125000, -15.912006, 73.151649>,
        <-40.125000, -16.021837, 72.886490>,
        < -40.125000, -16.333847, 74.602940>
      }
      triangle {
        <-40.125000, -17.768158, 74.140169>,
        <-40.125000, -18.033327, 74.250000>,
        < -40.125000, -16.333847, 74.602940>
      }
      triangle {
        <-40.125000, -17.658327, 73.875000>,
        <-40.125000, -17.768158, 74.140169>,
        < -40.125000, -16.333847, 74.602940>
      }
      triangle {
        <-40.125000, -14.658327, 70.875000>,
        <-40.125000, -14.893066, 73.640240>,
        < -40.125000, -13.930397, 72.199499>
      }
      triangle {
        <-40.125000, -14.923496, 70.765169>,
        <-40.125000, -15.033327, 70.500000>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -15.271837, 72.886490>,
        <-40.125000, -14.893066, 73.640240>,
        < -40.125000, -15.033327, 70.500000>
      }
      triangle {
        <-40.125000, -14.658327, 70.875000>,
        <-40.125000, -14.923496, 70.765169>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -15.646837, 73.261490>,
        <-40.125000, -15.912006, 73.151649>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -15.381678, 73.151649>,
        <-40.125000, -15.646837, 73.261490>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -15.271837, 72.886490>,
        <-40.125000, -15.381678, 73.151649>,
        < -40.125000, -14.893066, 73.640240>
      }
      triangle {
        <-40.125000, -13.930397, 68.800501>,
        <-40.125000, -13.930397, 72.199499>,
        < -40.125000, -13.592346, 70.500000>
      }
      triangle {
        <-40.125000, -14.893066, 67.359760>,
        <-40.125000, -13.930397, 72.199499>,
        < -40.125000, -13.930397, 68.800501>
      }
      triangle {
        <-40.125000, -14.283327, 70.500000>,
        <-40.125000, -13.930397, 72.199499>,
        < -40.125000, -14.893066, 67.359760>
      }
      triangle {
        <-40.125000, -14.393158, 70.765169>,
        <-40.125000, -14.658327, 70.875000>,
        < -40.125000, -13.930397, 72.199499>
      }
      triangle {
        <-40.125000, -14.283327, 70.500000>,
        <-40.125000, -14.393158, 70.765169>,
        < -40.125000, -13.930397, 72.199499>
      }
      triangle {
        <-40.125000, -15.381678, 67.848351>,
        <-40.125000, -14.893066, 67.359760>,
        < -40.125000, -16.333847, 66.397060>
      }
      triangle {
        <-40.125000, -15.381678, 67.848351>,
        <-40.125000, -15.271837, 68.113510>,
        < -40.125000, -14.893066, 67.359760>
      }
      triangle {
        <-40.125000, -14.923496, 70.234831>,
        <-40.125000, -14.893066, 67.359760>,
        < -40.125000, -15.271837, 68.113510>
      }
      triangle {
        <-40.125000, -14.393158, 70.234831>,
        <-40.125000, -14.283327, 70.500000>,
        < -40.125000, -14.893066, 67.359760>
      }
      triangle {
        <-40.125000, -14.658327, 70.125000>,
        <-40.125000, -14.393158, 70.234831>,
        < -40.125000, -14.893066, 67.359760>
      }
      triangle {
        <-40.125000, -14.923496, 70.234831>,
        <-40.125000, -14.658327, 70.125000>,
        < -40.125000, -14.893066, 67.359760>
      }
      triangle {
        <-40.125000, -16.783327, 68.334940>,
        <-40.125000, -15.868267, 69.250000>,
        < -40.125000, -16.333847, 66.397060>
      }
      triangle {
        <-40.125000, -16.021837, 68.113510>,
        <-40.125000, -16.333847, 66.397060>,
        < -40.125000, -15.868267, 69.250000>
      }
      triangle {
        <-40.125000, -15.646837, 67.738510>,
        <-40.125000, -15.381678, 67.848351>,
        < -40.125000, -16.333847, 66.397060>
      }
      triangle {
        <-40.125000, -15.912006, 67.848351>,
        <-40.125000, -15.646837, 67.738510>,
        < -40.125000, -16.333847, 66.397060>
      }
      triangle {
        <-40.125000, -16.021837, 68.113510>,
        <-40.125000, -15.912006, 67.848351>,
        < -40.125000, -16.333847, 66.397060>
      }
      triangle {
        <-40.125000, -20.684977, 73.151649>,
        <-40.125000, -21.173587, 73.640240>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.481758, -20.751837, 74.241699>,
        <-40.125000, -19.732807, 74.602940>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.125000, -19.283327, 72.665060>,
        <-40.125000, -20.198387, 71.750000>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.125000, -20.044817, 72.886490>,
        <-40.125000, -19.732807, 74.602940>,
        < -40.125000, -20.198387, 71.750000>
      }
      triangle {
        <-40.125000, -20.419817, 73.261490>,
        <-40.125000, -20.684977, 73.151649>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.125000, -20.154647, 73.151649>,
        <-40.125000, -20.419817, 73.261490>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.125000, -20.044817, 72.886490>,
        <-40.125000, -20.154647, 73.151649>,
        < -40.125000, -19.732807, 74.602940>
      }
      triangle {
        <-40.481758, -19.462526, 74.898640>,
        <-40.125000, -19.732807, 74.602940>,
        < -40.481758, -20.751837, 74.241699>
      }
      triangle {
        <-40.125000, -22.136257, 68.800501>,
        <-40.125000, -22.136257, 72.199499>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.481758, -21.775027, 73.218510>,
        <-40.125000, -21.173587, 73.640240>,
        < -40.125000, -22.136257, 72.199499>
      }
      triangle {
        <-40.125000, -21.783327, 70.500000>,
        <-40.125000, -22.136257, 68.800501>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.125000, -20.684977, 73.151649>,
        <-40.125000, -20.794817, 72.886490>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.125000, -21.143157, 70.765169>,
        <-40.125000, -21.173587, 73.640240>,
        < -40.125000, -20.794817, 72.886490>
      }
      triangle {
        <-40.125000, -21.673497, 70.765169>,
        <-40.125000, -21.783327, 70.500000>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.125000, -21.408327, 70.875000>,
        <-40.125000, -21.673497, 70.765169>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.125000, -21.143157, 70.765169>,
        <-40.125000, -21.408327, 70.875000>,
        < -40.125000, -21.173587, 73.640240>
      }
      triangle {
        <-40.481758, -20.751837, 74.241699>,
        <-40.125000, -21.173587, 73.640240>,
        < -40.481758, -21.775027, 73.218510>
      }
      triangle {
        <-40.125000, -22.136257, 68.800501>,
        <-40.125000, -22.474307, 70.500000>,
        < -40.125000, -22.136257, 72.199499>
      }
      triangle {
        <-40.481758, -22.431967, 71.929199>,
        <-40.125000, -22.136257, 72.199499>,
        < -40.125000, -22.474307, 70.500000>
      }
      triangle {
        <-40.481758, -21.775027, 73.218510>,
        <-40.125000, -22.136257, 72.199499>,
        < -40.481758, -22.431967, 71.929199>
      }
      triangle {
        <-40.481758, -22.658327, 70.500000>,
        <-40.125000, -22.474307, 70.500000>,
        < -40.125000, -22.136257, 68.800501>
      }
      triangle {
        <-40.481758, -22.431967, 71.929199>,
        <-40.125000, -22.474307, 70.500000>,
        < -40.481758, -22.658327, 70.500000>
      }
      triangle {
        <-40.125000, -21.408327, 70.125000>,
        <-40.125000, -21.173587, 67.359760>,
        < -40.125000, -22.136257, 68.800501>
      }
      triangle {
        <-40.481758, -21.775027, 67.781490>,
        <-40.125000, -22.136257, 68.800501>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.125000, -21.673497, 70.234831>,
        <-40.125000, -21.408327, 70.125000>,
        < -40.125000, -22.136257, 68.800501>
      }
      triangle {
        <-40.125000, -21.783327, 70.500000>,
        <-40.125000, -21.673497, 70.234831>,
        < -40.125000, -22.136257, 68.800501>
      }
      triangle {
        <-40.481758, -22.431967, 69.070801>,
        <-40.125000, -22.136257, 68.800501>,
        < -40.481758, -21.775027, 67.781490>
      }
      triangle {
        <-40.481758, -22.658327, 70.500000>,
        <-40.125000, -22.136257, 68.800501>,
        < -40.481758, -22.431967, 69.070801>
      }
      triangle {
        <-40.125000, -20.154647, 67.848351>,
        <-40.125000, -19.732807, 66.397060>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.481758, -20.751837, 66.758301>,
        <-40.125000, -21.173587, 67.359760>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.125000, -21.143157, 70.234831>,
        <-40.125000, -21.033327, 70.500000>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.125000, -20.794817, 68.113510>,
        <-40.125000, -21.173587, 67.359760>,
        < -40.125000, -21.033327, 70.500000>
      }
      triangle {
        <-40.125000, -21.408327, 70.125000>,
        <-40.125000, -21.143157, 70.234831>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.125000, -20.419817, 67.738510>,
        <-40.125000, -20.154647, 67.848351>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.125000, -20.684977, 67.848351>,
        <-40.125000, -20.419817, 67.738510>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.125000, -20.794817, 68.113510>,
        <-40.125000, -20.684977, 67.848351>,
        < -40.125000, -21.173587, 67.359760>
      }
      triangle {
        <-40.481758, -21.775027, 67.781490>,
        <-40.125000, -21.173587, 67.359760>,
        < -40.481758, -20.751837, 66.758301>
      }
      triangle {
        <-40.125000, -18.408327, 67.125000>,
        <-40.125000, -19.732807, 66.397060>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.125000, -20.044817, 68.113510>,
        <-40.125000, -19.283327, 68.334940>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.125000, -18.298496, 66.859831>,
        <-40.125000, -18.033327, 66.750000>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.125000, -18.408327, 67.125000>,
        <-40.125000, -18.298496, 66.859831>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.125000, -20.154647, 67.848351>,
        <-40.125000, -20.044817, 68.113510>,
        < -40.125000, -19.732807, 66.397060>
      }
      triangle {
        <-40.481758, -20.751837, 66.758301>,
        <-40.125000, -19.732807, 66.397060>,
        < -40.481758, -19.462526, 66.101360>
      }
      triangle {
        <-40.125000, -18.298496, 67.390169>,
        <-40.125000, -19.283327, 68.334940>,
        < -40.125000, -18.033327, 68.000000>
      }
      triangle {
        <-40.000000, -18.033327, 68.000000>,
        <-40.125000, -18.033327, 68.000000>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.125000, -18.033327, 67.500000>,
        <-40.125000, -18.033327, 68.000000>,
        < -40.125000, -16.783327, 68.334940>
      }
      triangle {
        <-40.000000, -16.783327, 68.334940>,
        <-40.125000, -16.783327, 68.334940>,
        < -40.125000, -18.033327, 68.000000>
      }
      triangle {
        <-40.125000, -18.298496, 67.390169>,
        <-40.125000, -18.033327, 68.000000>,
        < -40.125000, -18.033327, 67.500000>
      }
      triangle {
        <-40.000000, -18.033327, 68.000000>,
        <-40.000000, -16.783327, 68.334940>,
        < -40.125000, -18.033327, 68.000000>
      }
      triangle {
        <-40.125000, -20.154647, 68.378679>,
        <-40.125000, -20.198387, 69.250000>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.000000, -19.283327, 68.334940>,
        <-40.125000, -19.283327, 68.334940>,
        < -40.125000, -20.198387, 69.250000>
      }
      triangle {
        <-40.125000, -18.298496, 67.390169>,
        <-40.125000, -18.408327, 67.125000>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.125000, -20.044817, 68.113510>,
        <-40.125000, -20.154647, 68.378679>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.000000, -19.283327, 68.334940>,
        <-40.000000, -18.033327, 68.000000>,
        < -40.125000, -19.283327, 68.334940>
      }
      triangle {
        <-40.125000, -20.419817, 68.488510>,
        <-40.125000, -20.533327, 70.500000>,
        < -40.125000, -20.198387, 69.250000>
      }
      triangle {
        <-40.000000, -20.198387, 69.250000>,
        <-40.125000, -20.198387, 69.250000>,
        < -40.125000, -20.533327, 70.500000>
      }
      triangle {
        <-40.125000, -20.419817, 68.488510>,
        <-40.125000, -20.198387, 69.250000>,
        < -40.125000, -20.154647, 68.378679>
      }
      triangle {
        <-40.000000, -19.283327, 68.334940>,
        <-40.125000, -20.198387, 69.250000>,
        < -40.000000, -20.198387, 69.250000>
      }
      triangle {
        <-40.125000, -20.419817, 72.511490>,
        <-40.125000, -20.198387, 71.750000>,
        < -40.125000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -20.533327, 70.500000>,
        <-40.125000, -20.533327, 70.500000>,
        < -40.125000, -20.198387, 71.750000>
      }
      triangle {
        <-40.125000, -20.684977, 72.621321>,
        <-40.125000, -20.419817, 72.511490>,
        < -40.125000, -20.533327, 70.500000>
      }
      triangle {
        <-40.125000, -20.684977, 68.378679>,
        <-40.125000, -20.684977, 72.621321>,
        < -40.125000, -20.533327, 70.500000>
      }
      triangle {
        <-40.125000, -20.419817, 68.488510>,
        <-40.125000, -20.684977, 68.378679>,
        < -40.125000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -20.198387, 69.250000>,
        <-40.125000, -20.533327, 70.500000>,
        < -40.000000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -20.198387, 71.750000>,
        <-40.125000, -20.198387, 71.750000>,
        < -40.125000, -19.283327, 72.665060>
      }
      triangle {
        <-40.125000, -20.419817, 72.511490>,
        <-40.125000, -20.154647, 72.621321>,
        < -40.125000, -20.198387, 71.750000>
      }
      triangle {
        <-40.125000, -20.044817, 72.886490>,
        <-40.125000, -20.198387, 71.750000>,
        < -40.125000, -20.154647, 72.621321>
      }
      triangle {
        <-40.000000, -20.533327, 70.500000>,
        <-40.125000, -20.198387, 71.750000>,
        < -40.000000, -20.198387, 71.750000>
      }
      triangle {
        <-40.125000, -18.033327, 73.500000>,
        <-40.125000, -18.033327, 73.000000>,
        < -40.125000, -19.283327, 72.665060>
      }
      triangle {
        <-40.000000, -19.283327, 72.665060>,
        <-40.125000, -19.283327, 72.665060>,
        < -40.125000, -18.033327, 73.000000>
      }
      triangle {
        <-40.125000, -18.298496, 73.609831>,
        <-40.125000, -18.033327, 73.500000>,
        < -40.125000, -19.283327, 72.665060>
      }
      triangle {
        <-40.125000, -18.408327, 73.875000>,
        <-40.125000, -18.298496, 73.609831>,
        < -40.125000, -19.283327, 72.665060>
      }
      triangle {
        <-40.000000, -20.198387, 71.750000>,
        <-40.125000, -19.283327, 72.665060>,
        < -40.000000, -19.283327, 72.665060>
      }
      triangle {
        <-40.125000, -17.768158, 73.609831>,
        <-40.125000, -16.783327, 72.665060>,
        < -40.125000, -18.033327, 73.000000>
      }
      triangle {
        <-40.000000, -18.033327, 73.000000>,
        <-40.125000, -18.033327, 73.000000>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.125000, -17.768158, 73.609831>,
        <-40.125000, -18.033327, 73.000000>,
        < -40.125000, -18.033327, 73.500000>
      }
      triangle {
        <-40.000000, -19.283327, 72.665060>,
        <-40.125000, -18.033327, 73.000000>,
        < -40.000000, -18.033327, 73.000000>
      }
      triangle {
        <-40.125000, -15.912006, 72.621321>,
        <-40.125000, -15.868267, 71.750000>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.000000, -16.783327, 72.665060>,
        <-40.125000, -16.783327, 72.665060>,
        < -40.125000, -15.868267, 71.750000>
      }
      triangle {
        <-40.125000, -16.021837, 72.886490>,
        <-40.125000, -15.912006, 72.621321>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.125000, -17.768158, 73.609831>,
        <-40.125000, -17.658327, 73.875000>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.000000, -16.783327, 72.665060>,
        <-40.000000, -18.033327, 73.000000>,
        < -40.125000, -16.783327, 72.665060>
      }
      triangle {
        <-40.125000, -15.646837, 72.511490>,
        <-40.125000, -15.533327, 70.500000>,
        < -40.125000, -15.868267, 71.750000>
      }
      triangle {
        <-40.000000, -15.868267, 71.750000>,
        <-40.125000, -15.868267, 71.750000>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.125000, -15.646837, 72.511490>,
        <-40.125000, -15.868267, 71.750000>,
        < -40.125000, -15.912006, 72.621321>
      }
      triangle {
        <-40.000000, -15.868267, 71.750000>,
        <-40.000000, -16.783327, 72.665060>,
        < -40.125000, -15.868267, 71.750000>
      }
      triangle {
        <-40.125000, -15.646837, 68.488510>,
        <-40.125000, -15.868267, 69.250000>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.000000, -15.533327, 70.500000>,
        <-40.125000, -15.533327, 70.500000>,
        < -40.125000, -15.868267, 69.250000>
      }
      triangle {
        <-40.125000, -15.381678, 68.378679>,
        <-40.125000, -15.646837, 68.488510>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.125000, -15.381678, 72.621321>,
        <-40.125000, -15.381678, 68.378679>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.125000, -15.646837, 72.511490>,
        <-40.125000, -15.381678, 72.621321>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.000000, -15.533327, 70.500000>,
        <-40.000000, -15.868267, 71.750000>,
        < -40.125000, -15.533327, 70.500000>
      }
      triangle {
        <-40.000000, -15.868267, 69.250000>,
        <-40.125000, -15.868267, 69.250000>,
        < -40.125000, -16.783327, 68.334940>
      }
      triangle {
        <-40.125000, -15.646837, 68.488510>,
        <-40.125000, -15.912006, 68.378679>,
        < -40.125000, -15.868267, 69.250000>
      }
      triangle {
        <-40.125000, -16.021837, 68.113510>,
        <-40.125000, -15.868267, 69.250000>,
        < -40.125000, -15.912006, 68.378679>
      }
      triangle {
        <-40.000000, -15.868267, 69.250000>,
        <-40.000000, -15.533327, 70.500000>,
        < -40.125000, -15.868267, 69.250000>
      }
      triangle {
        <-40.125000, -17.768158, 67.390169>,
        <-40.125000, -18.033327, 67.500000>,
        < -40.125000, -16.783327, 68.334940>
      }
      triangle {
        <-40.125000, -17.658327, 67.125000>,
        <-40.125000, -17.768158, 67.390169>,
        < -40.125000, -16.783327, 68.334940>
      }
      triangle {
        <-40.000000, -16.783327, 68.334940>,
        <-40.000000, -15.868267, 69.250000>,
        < -40.125000, -16.783327, 68.334940>
      }
      triangle {
        <-41.125000, -18.033327, 67.500000>,
        <-40.125000, -18.033327, 67.500000>,
        < -40.125000, -17.768158, 67.390169>
      }
      triangle {
        <-41.125000, -18.298496, 67.390160>,
        <-40.125000, -18.298496, 67.390169>,
        < -40.125000, -18.033327, 67.500000>
      }
      triangle {
        <-41.125000, -18.298496, 67.390160>,
        <-40.125000, -18.033327, 67.500000>,
        < -41.125000, -18.033327, 67.500000>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-40.125000, -17.768158, 67.390169>,
        < -40.125000, -17.658327, 67.125000>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-41.125000, -18.033327, 67.500000>,
        < -40.125000, -17.768158, 67.390169>
      }
      triangle {
        <-41.125000, -17.658327, 67.125000>,
        <-40.125000, -17.658327, 67.125000>,
        < -40.125000, -17.768158, 66.859831>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-40.125000, -17.658327, 67.125000>,
        < -41.125000, -17.658327, 67.125000>
      }
      triangle {
        <-41.125000, -17.768158, 66.859840>,
        <-40.125000, -17.768158, 66.859831>,
        < -40.125000, -18.033327, 66.750000>
      }
      triangle {
        <-41.125000, -17.658327, 67.125000>,
        <-40.125000, -17.768158, 66.859831>,
        < -41.125000, -17.768158, 66.859840>
      }
      triangle {
        <-41.125000, -18.033327, 66.750000>,
        <-40.125000, -18.033327, 66.750000>,
        < -40.125000, -18.298496, 66.859831>
      }
      triangle {
        <-41.125000, -17.768158, 66.859840>,
        <-40.125000, -18.033327, 66.750000>,
        < -41.125000, -18.033327, 66.750000>
      }
      triangle {
        <-41.125000, -18.298496, 66.859840>,
        <-40.125000, -18.298496, 66.859831>,
        < -40.125000, -18.408327, 67.125000>
      }
      triangle {
        <-41.125000, -18.033327, 66.750000>,
        <-40.125000, -18.298496, 66.859831>,
        < -41.125000, -18.298496, 66.859840>
      }
      triangle {
        <-41.125000, -18.408327, 67.125000>,
        <-40.125000, -18.408327, 67.125000>,
        < -40.125000, -18.298496, 67.390169>
      }
      triangle {
        <-41.125000, -18.298496, 66.859840>,
        <-40.125000, -18.408327, 67.125000>,
        < -41.125000, -18.408327, 67.125000>
      }
      triangle {
        <-41.125000, -18.408327, 67.125000>,
        <-40.125000, -18.298496, 67.390169>,
        < -41.125000, -18.298496, 67.390160>
      }
      triangle {
        <-41.125000, -15.912006, 68.378679>,
        <-40.125000, -15.912006, 68.378679>,
        < -40.125000, -15.646837, 68.488510>
      }
      triangle {
        <-41.125000, -16.021837, 68.113510>,
        <-40.125000, -16.021837, 68.113510>,
        < -40.125000, -15.912006, 68.378679>
      }
      triangle {
        <-41.125000, -16.021837, 68.113510>,
        <-40.125000, -15.912006, 68.378679>,
        < -41.125000, -15.912006, 68.378679>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-40.125000, -15.646837, 68.488510>,
        < -40.125000, -15.381678, 68.378679>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-41.125000, -15.912006, 68.378679>,
        < -40.125000, -15.646837, 68.488510>
      }
      triangle {
        <-40.125000, -15.381678, 72.621321>,
        <-40.125000, -15.271837, 68.113510>,
        < -40.125000, -15.381678, 68.378679>
      }
      triangle {
        <-41.125000, -15.381678, 68.378679>,
        <-40.125000, -15.381678, 68.378679>,
        < -40.125000, -15.271837, 68.113510>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-40.125000, -15.381678, 68.378679>,
        < -41.125000, -15.381678, 68.378679>
      }
      triangle {
        <-41.125000, -15.271847, 68.113520>,
        <-40.125000, -15.271837, 68.113510>,
        < -40.125000, -15.381678, 67.848351>
      }
      triangle {
        <-40.125000, -14.923496, 70.234831>,
        <-40.125000, -15.271837, 68.113510>,
        < -40.125000, -15.033327, 70.500000>
      }
      triangle {
        <-40.125000, -15.271837, 72.886490>,
        <-40.125000, -15.033327, 70.500000>,
        < -40.125000, -15.271837, 68.113510>
      }
      triangle {
        <-40.125000, -15.381678, 72.621321>,
        <-40.125000, -15.271837, 72.886490>,
        < -40.125000, -15.271837, 68.113510>
      }
      triangle {
        <-41.125000, -15.381678, 68.378679>,
        <-40.125000, -15.271837, 68.113510>,
        < -41.125000, -15.271847, 68.113520>
      }
      triangle {
        <-41.125000, -15.381678, 67.848351>,
        <-40.125000, -15.381678, 67.848351>,
        < -40.125000, -15.646837, 67.738510>
      }
      triangle {
        <-41.125000, -15.271847, 68.113520>,
        <-40.125000, -15.381678, 67.848351>,
        < -41.125000, -15.381678, 67.848351>
      }
      triangle {
        <-41.125000, -15.646847, 67.738520>,
        <-40.125000, -15.646837, 67.738510>,
        < -40.125000, -15.912006, 67.848351>
      }
      triangle {
        <-41.125000, -15.381678, 67.848351>,
        <-40.125000, -15.646837, 67.738510>,
        < -41.125000, -15.646847, 67.738520>
      }
      triangle {
        <-41.125000, -15.912006, 67.848351>,
        <-40.125000, -15.912006, 67.848351>,
        < -40.125000, -16.021837, 68.113510>
      }
      triangle {
        <-41.125000, -15.646847, 67.738520>,
        <-40.125000, -15.912006, 67.848351>,
        < -41.125000, -15.912006, 67.848351>
      }
      triangle {
        <-41.125000, -15.912006, 67.848351>,
        <-40.125000, -16.021837, 68.113510>,
        < -41.125000, -16.021837, 68.113510>
      }
      triangle {
        <-41.125000, -15.033327, 70.500000>,
        <-40.125000, -15.033327, 70.500000>,
        < -40.125000, -14.923496, 70.765169>
      }
      triangle {
        <-41.125000, -14.923487, 70.234831>,
        <-40.125000, -14.923496, 70.234831>,
        < -40.125000, -15.033327, 70.500000>
      }
      triangle {
        <-41.125000, -14.923487, 70.234831>,
        <-40.125000, -15.033327, 70.500000>,
        < -41.125000, -15.033327, 70.500000>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-40.125000, -14.923496, 70.765169>,
        < -40.125000, -14.658327, 70.875000>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-41.125000, -15.033327, 70.500000>,
        < -40.125000, -14.923496, 70.765169>
      }
      triangle {
        <-41.125000, -14.658327, 70.875000>,
        <-40.125000, -14.658327, 70.875000>,
        < -40.125000, -14.393158, 70.765169>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-40.125000, -14.658327, 70.875000>,
        < -41.125000, -14.658327, 70.875000>
      }
      triangle {
        <-41.125000, -14.393167, 70.765169>,
        <-40.125000, -14.393158, 70.765169>,
        < -40.125000, -14.283327, 70.500000>
      }
      triangle {
        <-41.125000, -14.658327, 70.875000>,
        <-40.125000, -14.393158, 70.765169>,
        < -41.125000, -14.393167, 70.765169>
      }
      triangle {
        <-41.125000, -14.283327, 70.500000>,
        <-40.125000, -14.283327, 70.500000>,
        < -40.125000, -14.393158, 70.234831>
      }
      triangle {
        <-41.125000, -14.393167, 70.765169>,
        <-40.125000, -14.283327, 70.500000>,
        < -41.125000, -14.283327, 70.500000>
      }
      triangle {
        <-41.125000, -14.393167, 70.234831>,
        <-40.125000, -14.393158, 70.234831>,
        < -40.125000, -14.658327, 70.125000>
      }
      triangle {
        <-41.125000, -14.283327, 70.500000>,
        <-40.125000, -14.393158, 70.234831>,
        < -41.125000, -14.393167, 70.234831>
      }
      triangle {
        <-41.125000, -14.658327, 70.125000>,
        <-40.125000, -14.658327, 70.125000>,
        < -40.125000, -14.923496, 70.234831>
      }
      triangle {
        <-41.125000, -14.393167, 70.234831>,
        <-40.125000, -14.658327, 70.125000>,
        < -41.125000, -14.658327, 70.125000>
      }
      triangle {
        <-41.125000, -14.658327, 70.125000>,
        <-40.125000, -14.923496, 70.234831>,
        < -41.125000, -14.923487, 70.234831>
      }
      triangle {
        <-41.125000, -15.912006, 72.621321>,
        <-40.125000, -15.912006, 72.621321>,
        < -40.125000, -16.021837, 72.886490>
      }
      triangle {
        <-41.125000, -15.646837, 72.511490>,
        <-40.125000, -15.646837, 72.511490>,
        < -40.125000, -15.912006, 72.621321>
      }
      triangle {
        <-41.125000, -15.646837, 72.511490>,
        <-40.125000, -15.912006, 72.621321>,
        < -41.125000, -15.912006, 72.621321>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-40.125000, -16.021837, 72.886490>,
        < -40.125000, -15.912006, 73.151649>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-41.125000, -15.912006, 72.621321>,
        < -40.125000, -16.021837, 72.886490>
      }
      triangle {
        <-41.125000, -15.912006, 73.151649>,
        <-40.125000, -15.912006, 73.151649>,
        < -40.125000, -15.646837, 73.261490>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-40.125000, -15.912006, 73.151649>,
        < -41.125000, -15.912006, 73.151649>
      }
      triangle {
        <-41.125000, -15.646847, 73.261480>,
        <-40.125000, -15.646837, 73.261490>,
        < -40.125000, -15.381678, 73.151649>
      }
      triangle {
        <-41.125000, -15.912006, 73.151649>,
        <-40.125000, -15.646837, 73.261490>,
        < -41.125000, -15.646847, 73.261480>
      }
      triangle {
        <-41.125000, -15.381678, 73.151649>,
        <-40.125000, -15.381678, 73.151649>,
        < -40.125000, -15.271837, 72.886490>
      }
      triangle {
        <-41.125000, -15.646847, 73.261480>,
        <-40.125000, -15.381678, 73.151649>,
        < -41.125000, -15.381678, 73.151649>
      }
      triangle {
        <-41.125000, -15.271847, 72.886480>,
        <-40.125000, -15.271837, 72.886490>,
        < -40.125000, -15.381678, 72.621321>
      }
      triangle {
        <-41.125000, -15.381678, 73.151649>,
        <-40.125000, -15.271837, 72.886490>,
        < -41.125000, -15.271847, 72.886480>
      }
      triangle {
        <-41.125000, -15.381678, 72.621321>,
        <-40.125000, -15.381678, 72.621321>,
        < -40.125000, -15.646837, 72.511490>
      }
      triangle {
        <-41.125000, -15.271847, 72.886480>,
        <-40.125000, -15.381678, 72.621321>,
        < -41.125000, -15.381678, 72.621321>
      }
      triangle {
        <-41.125000, -15.381678, 72.621321>,
        <-40.125000, -15.646837, 72.511490>,
        < -41.125000, -15.646837, 72.511490>
      }
      triangle {
        <-41.125000, -18.033327, 73.500000>,
        <-40.125000, -18.033327, 73.500000>,
        < -40.125000, -18.298496, 73.609831>
      }
      triangle {
        <-41.125000, -17.768158, 73.609840>,
        <-40.125000, -17.768158, 73.609831>,
        < -40.125000, -18.033327, 73.500000>
      }
      triangle {
        <-41.125000, -17.768158, 73.609840>,
        <-40.125000, -18.033327, 73.500000>,
        < -41.125000, -18.033327, 73.500000>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-40.125000, -18.298496, 73.609831>,
        < -40.125000, -18.408327, 73.875000>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-41.125000, -18.033327, 73.500000>,
        < -40.125000, -18.298496, 73.609831>
      }
      triangle {
        <-41.125000, -18.408327, 73.875000>,
        <-40.125000, -18.408327, 73.875000>,
        < -40.125000, -18.298496, 74.140169>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-40.125000, -18.408327, 73.875000>,
        < -41.125000, -18.408327, 73.875000>
      }
      triangle {
        <-41.125000, -18.298496, 74.140160>,
        <-40.125000, -18.298496, 74.140169>,
        < -40.125000, -18.033327, 74.250000>
      }
      triangle {
        <-41.125000, -18.408327, 73.875000>,
        <-40.125000, -18.298496, 74.140169>,
        < -41.125000, -18.298496, 74.140160>
      }
      triangle {
        <-41.125000, -18.033327, 74.250000>,
        <-40.125000, -18.033327, 74.250000>,
        < -40.125000, -17.768158, 74.140169>
      }
      triangle {
        <-41.125000, -18.298496, 74.140160>,
        <-40.125000, -18.033327, 74.250000>,
        < -41.125000, -18.033327, 74.250000>
      }
      triangle {
        <-41.125000, -17.768158, 74.140160>,
        <-40.125000, -17.768158, 74.140169>,
        < -40.125000, -17.658327, 73.875000>
      }
      triangle {
        <-41.125000, -18.033327, 74.250000>,
        <-40.125000, -17.768158, 74.140169>,
        < -41.125000, -17.768158, 74.140160>
      }
      triangle {
        <-41.125000, -17.658327, 73.875000>,
        <-40.125000, -17.658327, 73.875000>,
        < -40.125000, -17.768158, 73.609831>
      }
      triangle {
        <-41.125000, -17.768158, 74.140160>,
        <-40.125000, -17.658327, 73.875000>,
        < -41.125000, -17.658327, 73.875000>
      }
      triangle {
        <-41.125000, -17.658327, 73.875000>,
        <-40.125000, -17.768158, 73.609831>,
        < -41.125000, -17.768158, 73.609840>
      }
      triangle {
        <-41.125000, -20.154647, 72.621321>,
        <-40.125000, -20.154647, 72.621321>,
        < -40.125000, -20.419817, 72.511490>
      }
      triangle {
        <-41.125000, -20.044817, 72.886490>,
        <-40.125000, -20.044817, 72.886490>,
        < -40.125000, -20.154647, 72.621321>
      }
      triangle {
        <-41.125000, -20.044817, 72.886490>,
        <-40.125000, -20.154647, 72.621321>,
        < -41.125000, -20.154647, 72.621321>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-40.125000, -20.419817, 72.511490>,
        < -40.125000, -20.684977, 72.621321>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-41.125000, -20.154647, 72.621321>,
        < -40.125000, -20.419817, 72.511490>
      }
      triangle {
        <-40.125000, -20.684977, 68.378679>,
        <-40.125000, -20.794817, 72.886490>,
        < -40.125000, -20.684977, 72.621321>
      }
      triangle {
        <-41.125000, -20.684977, 72.621321>,
        <-40.125000, -20.684977, 72.621321>,
        < -40.125000, -20.794817, 72.886490>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-40.125000, -20.684977, 72.621321>,
        < -41.125000, -20.684977, 72.621321>
      }
      triangle {
        <-41.125000, -20.794807, 72.886480>,
        <-40.125000, -20.794817, 72.886490>,
        < -40.125000, -20.684977, 73.151649>
      }
      triangle {
        <-40.125000, -21.143157, 70.765169>,
        <-40.125000, -20.794817, 72.886490>,
        < -40.125000, -21.033327, 70.500000>
      }
      triangle {
        <-40.125000, -20.794817, 68.113510>,
        <-40.125000, -21.033327, 70.500000>,
        < -40.125000, -20.794817, 72.886490>
      }
      triangle {
        <-40.125000, -20.684977, 68.378679>,
        <-40.125000, -20.794817, 68.113510>,
        < -40.125000, -20.794817, 72.886490>
      }
      triangle {
        <-41.125000, -20.684977, 72.621321>,
        <-40.125000, -20.794817, 72.886490>,
        < -41.125000, -20.794807, 72.886480>
      }
      triangle {
        <-41.125000, -20.684977, 73.151649>,
        <-40.125000, -20.684977, 73.151649>,
        < -40.125000, -20.419817, 73.261490>
      }
      triangle {
        <-41.125000, -20.794807, 72.886480>,
        <-40.125000, -20.684977, 73.151649>,
        < -41.125000, -20.684977, 73.151649>
      }
      triangle {
        <-41.125000, -20.419807, 73.261480>,
        <-40.125000, -20.419817, 73.261490>,
        < -40.125000, -20.154647, 73.151649>
      }
      triangle {
        <-41.125000, -20.684977, 73.151649>,
        <-40.125000, -20.419817, 73.261490>,
        < -41.125000, -20.419807, 73.261480>
      }
      triangle {
        <-41.125000, -20.154647, 73.151649>,
        <-40.125000, -20.154647, 73.151649>,
        < -40.125000, -20.044817, 72.886490>
      }
      triangle {
        <-41.125000, -20.419807, 73.261480>,
        <-40.125000, -20.154647, 73.151649>,
        < -41.125000, -20.154647, 73.151649>
      }
      triangle {
        <-41.125000, -20.154647, 73.151649>,
        <-40.125000, -20.044817, 72.886490>,
        < -41.125000, -20.044817, 72.886490>
      }
      triangle {
        <-41.125000, -21.033327, 70.500000>,
        <-40.125000, -21.033327, 70.500000>,
        < -40.125000, -21.143157, 70.234831>
      }
      triangle {
        <-41.125000, -21.143167, 70.765169>,
        <-40.125000, -21.143157, 70.765169>,
        < -40.125000, -21.033327, 70.500000>
      }
      triangle {
        <-41.125000, -21.143167, 70.765169>,
        <-40.125000, -21.033327, 70.500000>,
        < -41.125000, -21.033327, 70.500000>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-40.125000, -21.143157, 70.234831>,
        < -40.125000, -21.408327, 70.125000>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-41.125000, -21.033327, 70.500000>,
        < -40.125000, -21.143157, 70.234831>
      }
      triangle {
        <-41.125000, -21.408327, 70.125000>,
        <-40.125000, -21.408327, 70.125000>,
        < -40.125000, -21.673497, 70.234831>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-40.125000, -21.408327, 70.125000>,
        < -41.125000, -21.408327, 70.125000>
      }
      triangle {
        <-41.125000, -21.673487, 70.234831>,
        <-40.125000, -21.673497, 70.234831>,
        < -40.125000, -21.783327, 70.500000>
      }
      triangle {
        <-41.125000, -21.408327, 70.125000>,
        <-40.125000, -21.673497, 70.234831>,
        < -41.125000, -21.673487, 70.234831>
      }
      triangle {
        <-41.125000, -21.783327, 70.500000>,
        <-40.125000, -21.783327, 70.500000>,
        < -40.125000, -21.673497, 70.765169>
      }
      triangle {
        <-41.125000, -21.673487, 70.234831>,
        <-40.125000, -21.783327, 70.500000>,
        < -41.125000, -21.783327, 70.500000>
      }
      triangle {
        <-41.125000, -21.673487, 70.765169>,
        <-40.125000, -21.673497, 70.765169>,
        < -40.125000, -21.408327, 70.875000>
      }
      triangle {
        <-41.125000, -21.783327, 70.500000>,
        <-40.125000, -21.673497, 70.765169>,
        < -41.125000, -21.673487, 70.765169>
      }
      triangle {
        <-41.125000, -21.408327, 70.875000>,
        <-40.125000, -21.408327, 70.875000>,
        < -40.125000, -21.143157, 70.765169>
      }
      triangle {
        <-41.125000, -21.673487, 70.765169>,
        <-40.125000, -21.408327, 70.875000>,
        < -41.125000, -21.408327, 70.875000>
      }
      triangle {
        <-41.125000, -21.408327, 70.875000>,
        <-40.125000, -21.143157, 70.765169>,
        < -41.125000, -21.143167, 70.765169>
      }
      triangle {
        <-41.125000, -20.154647, 68.378679>,
        <-40.125000, -20.154647, 68.378679>,
        < -40.125000, -20.044817, 68.113510>
      }
      triangle {
        <-41.125000, -20.419817, 68.488510>,
        <-40.125000, -20.419817, 68.488510>,
        < -40.125000, -20.154647, 68.378679>
      }
      triangle {
        <-41.125000, -20.419817, 68.488510>,
        <-40.125000, -20.154647, 68.378679>,
        < -41.125000, -20.154647, 68.378679>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-40.125000, -20.044817, 68.113510>,
        < -40.125000, -20.154647, 67.848351>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-41.125000, -20.154647, 68.378679>,
        < -40.125000, -20.044817, 68.113510>
      }
      triangle {
        <-41.125000, -20.154647, 67.848351>,
        <-40.125000, -20.154647, 67.848351>,
        < -40.125000, -20.419817, 67.738510>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-40.125000, -20.154647, 67.848351>,
        < -41.125000, -20.154647, 67.848351>
      }
      triangle {
        <-41.125000, -20.419807, 67.738520>,
        <-40.125000, -20.419817, 67.738510>,
        < -40.125000, -20.684977, 67.848351>
      }
      triangle {
        <-41.125000, -20.154647, 67.848351>,
        <-40.125000, -20.419817, 67.738510>,
        < -41.125000, -20.419807, 67.738520>
      }
      triangle {
        <-41.125000, -20.684977, 67.848351>,
        <-40.125000, -20.684977, 67.848351>,
        < -40.125000, -20.794817, 68.113510>
      }
      triangle {
        <-41.125000, -20.419807, 67.738520>,
        <-40.125000, -20.684977, 67.848351>,
        < -41.125000, -20.684977, 67.848351>
      }
      triangle {
        <-41.125000, -20.794807, 68.113520>,
        <-40.125000, -20.794817, 68.113510>,
        < -40.125000, -20.684977, 68.378679>
      }
      triangle {
        <-41.125000, -20.684977, 67.848351>,
        <-40.125000, -20.794817, 68.113510>,
        < -41.125000, -20.794807, 68.113520>
      }
      triangle {
        <-41.125000, -20.684977, 68.378679>,
        <-40.125000, -20.684977, 68.378679>,
        < -40.125000, -20.419817, 68.488510>
      }
      triangle {
        <-41.125000, -20.794807, 68.113520>,
        <-40.125000, -20.684977, 68.378679>,
        < -41.125000, -20.684977, 68.378679>
      }
      triangle {
        <-41.125000, -20.684977, 68.378679>,
        <-40.125000, -20.419817, 68.488510>,
        < -41.125000, -20.419817, 68.488510>
      }
      triangle {
        <-40.000000, -18.033327, 75.066990>,
        <-40.000000, -18.033327, 73.000000>,
        < -40.000000, -16.783327, 72.665060>
      }
      triangle {
        <-40.000000, -19.781027, 74.719350>,
        <-40.000000, -19.283327, 72.665060>,
        < -40.000000, -18.033327, 73.000000>
      }
      triangle {
        <-40.000000, -18.033327, 75.066990>,
        <-40.000000, -19.781027, 74.719350>,
        < -40.000000, -18.033327, 73.000000>
      }
      triangle {
        <-40.000000, -16.285627, 74.719350>,
        <-40.000000, -16.783327, 72.665060>,
        < -40.000000, -15.868267, 71.750000>
      }
      triangle {
        <-40.000000, -16.285627, 74.719350>,
        <-40.000000, -18.033327, 75.066990>,
        < -40.000000, -16.783327, 72.665060>
      }
      triangle {
        <-40.000000, -16.285627, 74.719350>,
        <-40.000000, -15.868267, 71.750000>,
        < -40.000000, -15.533327, 70.500000>
      }
      triangle {
        <-40.000000, -14.803978, 67.270660>,
        <-40.000000, -15.533327, 70.500000>,
        < -40.000000, -15.868267, 69.250000>
      }
      triangle {
        <-40.000000, -14.803978, 67.270660>,
        <-40.000000, -16.285627, 74.719350>,
        < -40.000000, -15.533327, 70.500000>
      }
      triangle {
        <-40.000000, -16.285627, 66.280649>,
        <-40.000000, -15.868267, 69.250000>,
        < -40.000000, -16.783327, 68.334940>
      }
      triangle {
        <-40.000000, -16.285627, 66.280649>,
        <-40.000000, -14.803978, 67.270660>,
        < -40.000000, -15.868267, 69.250000>
      }
      triangle {
        <-40.000000, -16.285627, 66.280649>,
        <-40.000000, -16.783327, 68.334940>,
        < -40.000000, -18.033327, 68.000000>
      }
      triangle {
        <-40.000000, -18.033327, 65.933010>,
        <-40.000000, -18.033327, 68.000000>,
        < -40.000000, -19.283327, 68.334940>
      }
      triangle {
        <-40.000000, -16.285627, 66.280649>,
        <-40.000000, -18.033327, 68.000000>,
        < -40.000000, -18.033327, 65.933010>
      }
      triangle {
        <-40.000000, -19.781027, 74.719350>,
        <-40.000000, -20.198387, 71.750000>,
        < -40.000000, -19.283327, 72.665060>
      }
      triangle {
        <-40.000000, -21.262677, 73.729340>,
        <-40.000000, -20.533327, 70.500000>,
        < -40.000000, -20.198387, 71.750000>
      }
      triangle {
        <-40.000000, -19.781027, 74.719350>,
        <-40.000000, -21.262677, 73.729340>,
        < -40.000000, -20.198387, 71.750000>
      }
      triangle {
        <-40.000000, -19.781027, 66.280649>,
        <-40.000000, -20.198387, 69.250000>,
        < -40.000000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -21.262677, 67.270660>,
        <-40.000000, -19.781027, 66.280649>,
        < -40.000000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -21.262677, 73.729340>,
        <-40.000000, -21.262677, 67.270660>,
        < -40.000000, -20.533327, 70.500000>
      }
      triangle {
        <-40.000000, -19.781027, 66.280649>,
        <-40.000000, -19.283327, 68.334940>,
        < -40.000000, -20.198387, 69.250000>
      }
      triangle {
        <-40.000000, -19.781027, 66.280649>,
        <-40.000000, -18.033327, 65.933010>,
        < -40.000000, -19.283327, 68.334940>
      }
      triangle {
        <-40.288300, -18.033327, 65.874729>,
        <-40.000000, -18.033327, 65.933010>,
        < -40.000000, -19.781027, 66.280649>
      }
      triangle {
        <-40.288300, -16.604036, 66.101101>,
        <-40.000000, -16.285627, 66.280649>,
        < -40.000000, -18.033327, 65.933010>
      }
      triangle {
        <-40.288300, -18.033327, 65.874729>,
        <-40.288300, -16.604036, 66.101101>,
        < -40.000000, -18.033327, 65.933010>
      }
      triangle {
        <-40.288300, -20.751997, 66.758080>,
        <-40.000000, -19.781027, 66.280649>,
        < -40.000000, -21.262677, 67.270660>
      }
      triangle {
        <-40.288300, -19.462618, 66.101101>,
        <-40.288300, -18.033327, 65.874729>,
        < -40.000000, -19.781027, 66.280649>
      }
      triangle {
        <-40.288300, -20.751997, 66.758080>,
        <-40.288300, -19.462618, 66.101101>,
        < -40.000000, -19.781027, 66.280649>
      }
      triangle {
        <-40.000000, -22.252667, 72.247721>,
        <-40.000000, -22.252667, 68.752279>,
        < -40.000000, -21.262677, 67.270660>
      }
      triangle {
        <-40.288300, -21.775247, 67.781330>,
        <-40.000000, -21.262677, 67.270660>,
        < -40.000000, -22.252667, 68.752279>
      }
      triangle {
        <-40.000000, -21.262677, 73.729340>,
        <-40.000000, -22.252667, 72.247721>,
        < -40.000000, -21.262677, 67.270660>
      }
      triangle {
        <-40.288300, -21.775247, 67.781330>,
        <-40.288300, -20.751997, 66.758080>,
        < -40.000000, -21.262677, 67.270660>
      }
      triangle {
        <-40.000000, -22.252667, 72.247721>,
        <-40.000000, -22.600317, 70.500000>,
        < -40.000000, -22.252667, 68.752279>
      }
      triangle {
        <-40.288300, -22.432227, 69.070709>,
        <-40.000000, -22.252667, 68.752279>,
        < -40.000000, -22.600317, 70.500000>
      }
      triangle {
        <-40.288300, -22.432227, 69.070709>,
        <-40.288300, -21.775247, 67.781330>,
        < -40.000000, -22.252667, 68.752279>
      }
      triangle {
        <-40.288300, -22.658597, 70.500000>,
        <-40.000000, -22.600317, 70.500000>,
        < -40.000000, -22.252667, 72.247721>
      }
      triangle {
        <-40.288300, -22.658597, 70.500000>,
        <-40.288300, -22.432227, 69.070709>,
        < -40.000000, -22.600317, 70.500000>
      }
      triangle {
        <-40.288300, -21.775247, 73.218670>,
        <-40.000000, -22.252667, 72.247721>,
        < -40.000000, -21.262677, 73.729340>
      }
      triangle {
        <-40.288300, -22.432227, 71.929291>,
        <-40.288300, -22.658597, 70.500000>,
        < -40.000000, -22.252667, 72.247721>
      }
      triangle {
        <-40.288300, -21.775247, 73.218670>,
        <-40.288300, -22.432227, 71.929291>,
        < -40.000000, -22.252667, 72.247721>
      }
      triangle {
        <-40.288300, -20.751997, 74.241920>,
        <-40.000000, -21.262677, 73.729340>,
        < -40.000000, -19.781027, 74.719350>
      }
      triangle {
        <-40.288300, -20.751997, 74.241920>,
        <-40.288300, -21.775247, 73.218670>,
        < -40.000000, -21.262677, 73.729340>
      }
      triangle {
        <-40.288300, -19.462618, 74.898900>,
        <-40.000000, -19.781027, 74.719350>,
        < -40.000000, -18.033327, 75.066990>
      }
      triangle {
        <-40.288300, -19.462618, 74.898900>,
        <-40.288300, -20.751997, 74.241920>,
        < -40.000000, -19.781027, 74.719350>
      }
      triangle {
        <-40.288300, -18.033327, 75.125270>,
        <-40.000000, -18.033327, 75.066990>,
        < -40.000000, -16.285627, 74.719350>
      }
      triangle {
        <-40.288300, -19.462618, 74.898900>,
        <-40.000000, -18.033327, 75.066990>,
        < -40.288300, -18.033327, 75.125270>
      }
      triangle {
        <-40.000000, -14.803978, 67.270660>,
        <-40.000000, -14.803978, 73.729340>,
        < -40.000000, -16.285627, 74.719350>
      }
      triangle {
        <-40.288300, -15.314657, 74.241920>,
        <-40.000000, -16.285627, 74.719350>,
        < -40.000000, -14.803978, 73.729340>
      }
      triangle {
        <-40.288300, -16.604036, 74.898900>,
        <-40.288300, -18.033327, 75.125270>,
        < -40.000000, -16.285627, 74.719350>
      }
      triangle {
        <-40.288300, -15.314657, 74.241920>,
        <-40.288300, -16.604036, 74.898900>,
        < -40.000000, -16.285627, 74.719350>
      }
      triangle {
        <-40.000000, -13.813988, 68.752279>,
        <-40.000000, -13.813988, 72.247721>,
        < -40.000000, -14.803978, 73.729340>
      }
      triangle {
        <-40.288300, -14.291407, 73.218670>,
        <-40.000000, -14.803978, 73.729340>,
        < -40.000000, -13.813988, 72.247721>
      }
      triangle {
        <-40.000000, -14.803978, 67.270660>,
        <-40.000000, -13.813988, 68.752279>,
        < -40.000000, -14.803978, 73.729340>
      }
      triangle {
        <-40.288300, -14.291407, 73.218670>,
        <-40.288300, -15.314657, 74.241920>,
        < -40.000000, -14.803978, 73.729340>
      }
      triangle {
        <-40.000000, -13.813988, 68.752279>,
        <-40.000000, -13.466337, 70.500000>,
        < -40.000000, -13.813988, 72.247721>
      }
      triangle {
        <-40.288300, -13.634428, 71.929291>,
        <-40.000000, -13.813988, 72.247721>,
        < -40.000000, -13.466337, 70.500000>
      }
      triangle {
        <-40.288300, -13.634428, 71.929291>,
        <-40.288300, -14.291407, 73.218670>,
        < -40.000000, -13.813988, 72.247721>
      }
      triangle {
        <-40.288300, -13.408056, 70.500000>,
        <-40.000000, -13.466337, 70.500000>,
        < -40.000000, -13.813988, 68.752279>
      }
      triangle {
        <-40.288300, -13.408056, 70.500000>,
        <-40.288300, -13.634428, 71.929291>,
        < -40.000000, -13.466337, 70.500000>
      }
      triangle {
        <-40.288300, -14.291407, 67.781330>,
        <-40.000000, -13.813988, 68.752279>,
        < -40.000000, -14.803978, 67.270660>
      }
      triangle {
        <-40.288300, -13.634428, 69.070709>,
        <-40.288300, -13.408056, 70.500000>,
        < -40.000000, -13.813988, 68.752279>
      }
      triangle {
        <-40.288300, -14.291407, 67.781330>,
        <-40.288300, -13.634428, 69.070709>,
        < -40.000000, -13.813988, 68.752279>
      }
      triangle {
        <-40.288300, -15.314657, 66.758080>,
        <-40.000000, -14.803978, 67.270660>,
        < -40.000000, -16.285627, 66.280649>
      }
      triangle {
        <-40.288300, -15.314657, 66.758080>,
        <-40.288300, -14.291407, 67.781330>,
        < -40.000000, -14.803978, 67.270660>
      }
      triangle {
        <-40.288300, -16.604036, 66.101101>,
        <-40.288300, -15.314657, 66.758080>,
        < -40.000000, -16.285627, 66.280649>
      }
      triangle {
        <-40.474640, -18.033327, 75.353220>,
        <-40.288300, -18.033327, 75.125270>,
        < -40.288300, -16.604036, 74.898900>
      }
      triangle {
        <-40.474640, -19.533056, 75.115680>,
        <-40.288300, -18.033327, 75.125270>,
        < -40.474640, -18.033327, 75.353220>
      }
      triangle {
        <-40.474640, -19.533056, 75.115680>,
        <-40.288300, -19.462618, 74.898900>,
        < -40.288300, -18.033327, 75.125270>
      }
      triangle {
        <-40.474640, -16.533598, 75.115680>,
        <-40.288300, -16.604036, 74.898900>,
        < -40.288300, -15.314657, 74.241920>
      }
      triangle {
        <-40.474640, -16.533598, 75.115680>,
        <-40.474640, -18.033327, 75.353220>,
        < -40.288300, -16.604036, 74.898900>
      }
      triangle {
        <-40.474640, -15.180677, 74.426331>,
        <-40.288300, -15.314657, 74.241920>,
        < -40.288300, -14.291407, 73.218670>
      }
      triangle {
        <-40.474640, -15.180677, 74.426331>,
        <-40.474640, -16.533598, 75.115680>,
        < -40.288300, -15.314657, 74.241920>
      }
      triangle {
        <-40.474640, -14.106996, 73.352650>,
        <-40.288300, -14.291407, 73.218670>,
        < -40.288300, -13.634428, 71.929291>
      }
      triangle {
        <-40.474640, -14.106996, 73.352650>,
        <-40.474640, -15.180677, 74.426331>,
        < -40.288300, -14.291407, 73.218670>
      }
      triangle {
        <-40.474640, -13.417646, 71.999729>,
        <-40.288300, -13.634428, 71.929291>,
        < -40.288300, -13.408056, 70.500000>
      }
      triangle {
        <-40.474640, -13.417646, 71.999729>,
        <-40.474640, -14.106996, 73.352650>,
        < -40.288300, -13.634428, 71.929291>
      }
      triangle {
        <-40.474640, -13.180107, 70.500000>,
        <-40.288300, -13.408056, 70.500000>,
        < -40.288300, -13.634428, 69.070709>
      }
      triangle {
        <-40.474640, -13.180107, 70.500000>,
        <-40.474640, -13.417646, 71.999729>,
        < -40.288300, -13.408056, 70.500000>
      }
      triangle {
        <-40.474640, -13.417646, 69.000271>,
        <-40.288300, -13.634428, 69.070709>,
        < -40.288300, -14.291407, 67.781330>
      }
      triangle {
        <-40.474640, -13.417646, 69.000271>,
        <-40.474640, -13.180107, 70.500000>,
        < -40.288300, -13.634428, 69.070709>
      }
      triangle {
        <-40.474640, -14.106996, 67.647350>,
        <-40.288300, -14.291407, 67.781330>,
        < -40.288300, -15.314657, 66.758080>
      }
      triangle {
        <-40.474640, -14.106996, 67.647350>,
        <-40.474640, -13.417646, 69.000271>,
        < -40.288300, -14.291407, 67.781330>
      }
      triangle {
        <-40.474640, -15.180677, 66.573669>,
        <-40.288300, -15.314657, 66.758080>,
        < -40.288300, -16.604036, 66.101101>
      }
      triangle {
        <-40.474640, -15.180677, 66.573669>,
        <-40.474640, -14.106996, 67.647350>,
        < -40.288300, -15.314657, 66.758080>
      }
      triangle {
        <-40.474640, -16.533598, 65.884319>,
        <-40.288300, -16.604036, 66.101101>,
        < -40.288300, -18.033327, 65.874729>
      }
      triangle {
        <-40.474640, -16.533598, 65.884319>,
        <-40.474640, -15.180677, 66.573669>,
        < -40.288300, -16.604036, 66.101101>
      }
      triangle {
        <-40.474640, -16.533598, 65.884319>,
        <-40.288300, -18.033327, 65.874729>,
        < -40.474640, -18.033327, 65.646780>
      }
      triangle {
        <-40.288300, -19.462618, 66.101101>,
        <-40.474640, -18.033327, 65.646780>,
        < -40.288300, -18.033327, 65.874729>
      }
      triangle {
        <-40.474339, -16.442617, 65.604309>,
        <-40.474640, -16.533598, 65.884319>,
        < -40.474640, -18.033327, 65.646780>
      }
      triangle {
        <-40.474339, -16.442617, 65.604309>,
        <-40.474640, -18.033327, 65.646780>,
        < -40.474339, -18.033327, 65.352369>
      }
      triangle {
        <-40.474640, -19.533056, 65.884319>,
        <-40.474339, -18.033327, 65.352369>,
        < -40.474640, -18.033327, 65.646780>
      }
      triangle {
        <-40.474640, -19.533056, 65.884319>,
        <-40.474640, -18.033327, 65.646780>,
        < -40.288300, -19.462618, 66.101101>
      }
      triangle {
        <-40.474339, -18.033327, 75.647630>,
        <-40.474640, -18.033327, 75.353220>,
        < -40.474640, -16.533598, 75.115680>
      }
      triangle {
        <-40.474339, -19.624037, 75.395690>,
        <-40.474640, -18.033327, 75.353220>,
        < -40.474339, -18.033327, 75.647630>
      }
      triangle {
        <-40.474339, -19.624037, 75.395690>,
        <-40.474640, -19.533056, 75.115680>,
        < -40.474640, -18.033327, 75.353220>
      }
      triangle {
        <-40.474339, -16.442617, 75.395690>,
        <-40.474640, -16.533598, 75.115680>,
        < -40.474640, -15.180677, 74.426331>
      }
      triangle {
        <-40.474339, -16.442617, 75.395690>,
        <-40.474339, -18.033327, 75.647630>,
        < -40.474640, -16.533598, 75.115680>
      }
      triangle {
        <-40.474339, -15.007627, 74.664520>,
        <-40.474640, -15.180677, 74.426331>,
        < -40.474640, -14.106996, 73.352650>
      }
      triangle {
        <-40.474339, -15.007627, 74.664520>,
        <-40.474339, -16.442617, 75.395690>,
        < -40.474640, -15.180677, 74.426331>
      }
      triangle {
        <-40.474339, -13.868807, 73.525700>,
        <-40.474640, -14.106996, 73.352650>,
        < -40.474640, -13.417646, 71.999729>
      }
      triangle {
        <-40.474339, -13.868807, 73.525700>,
        <-40.474339, -15.007627, 74.664520>,
        < -40.474640, -14.106996, 73.352650>
      }
      triangle {
        <-40.474339, -13.137636, 72.090710>,
        <-40.474640, -13.417646, 71.999729>,
        < -40.474640, -13.180107, 70.500000>
      }
      triangle {
        <-40.474339, -13.137636, 72.090710>,
        <-40.474339, -13.868807, 73.525700>,
        < -40.474640, -13.417646, 71.999729>
      }
      triangle {
        <-40.474339, -12.885696, 70.500000>,
        <-40.474640, -13.180107, 70.500000>,
        < -40.474640, -13.417646, 69.000271>
      }
      triangle {
        <-40.474339, -12.885696, 70.500000>,
        <-40.474339, -13.137636, 72.090710>,
        < -40.474640, -13.180107, 70.500000>
      }
      triangle {
        <-40.474339, -13.137636, 68.909290>,
        <-40.474640, -13.417646, 69.000271>,
        < -40.474640, -14.106996, 67.647350>
      }
      triangle {
        <-40.474339, -13.137636, 68.909290>,
        <-40.474339, -12.885696, 70.500000>,
        < -40.474640, -13.417646, 69.000271>
      }
      triangle {
        <-40.474339, -13.868807, 67.474300>,
        <-40.474640, -14.106996, 67.647350>,
        < -40.474640, -15.180677, 66.573669>
      }
      triangle {
        <-40.474339, -13.868807, 67.474300>,
        <-40.474339, -13.137636, 68.909290>,
        < -40.474640, -14.106996, 67.647350>
      }
      triangle {
        <-40.474339, -15.007627, 66.335480>,
        <-40.474640, -15.180677, 66.573669>,
        < -40.474640, -16.533598, 65.884319>
      }
      triangle {
        <-40.474339, -15.007627, 66.335480>,
        <-40.474339, -13.868807, 67.474300>,
        < -40.474640, -15.180677, 66.573669>
      }
      triangle {
        <-40.474339, -16.442617, 65.604309>,
        <-40.474339, -15.007627, 66.335480>,
        < -40.474640, -16.533598, 65.884319>
      }
      triangle {
        <-40.287529, -16.372297, 65.387890>,
        <-40.474339, -16.442617, 65.604309>,
        < -40.474339, -18.033327, 65.352369>
      }
      triangle {
        <-40.287529, -16.372297, 65.387890>,
        <-40.474339, -18.033327, 65.352369>,
        < -40.287529, -18.033327, 65.124809>
      }
      triangle {
        <-40.474339, -19.624037, 65.604309>,
        <-40.287529, -18.033327, 65.124809>,
        < -40.474339, -18.033327, 65.352369>
      }
      triangle {
        <-40.474339, -19.624037, 65.604309>,
        <-40.474339, -18.033327, 65.352369>,
        < -40.474640, -19.533056, 65.884319>
      }
      triangle {
        <-40.287529, -18.033327, 75.875190>,
        <-40.474339, -18.033327, 75.647630>,
        < -40.474339, -16.442617, 75.395690>
      }
      triangle {
        <-40.287529, -19.694357, 75.612110>,
        <-40.474339, -18.033327, 75.647630>,
        < -40.287529, -18.033327, 75.875190>
      }
      triangle {
        <-40.287529, -19.694357, 75.612110>,
        <-40.474339, -19.624037, 75.395690>,
        < -40.474339, -18.033327, 75.647630>
      }
      triangle {
        <-40.287529, -16.372297, 75.612110>,
        <-40.474339, -16.442617, 75.395690>,
        < -40.474339, -15.007627, 74.664520>
      }
      triangle {
        <-40.287529, -16.372297, 75.612110>,
        <-40.287529, -18.033327, 75.875190>,
        < -40.474339, -16.442617, 75.395690>
      }
      triangle {
        <-40.287529, -14.873867, 74.848620>,
        <-40.474339, -15.007627, 74.664520>,
        < -40.474339, -13.868807, 73.525700>
      }
      triangle {
        <-40.287529, -14.873867, 74.848620>,
        <-40.287529, -16.372297, 75.612110>,
        < -40.474339, -15.007627, 74.664520>
      }
      triangle {
        <-40.287529, -13.684708, 73.659460>,
        <-40.474339, -13.868807, 73.525700>,
        < -40.474339, -13.137636, 72.090710>
      }
      triangle {
        <-40.287529, -13.684708, 73.659460>,
        <-40.287529, -14.873867, 74.848620>,
        < -40.474339, -13.868807, 73.525700>
      }
      triangle {
        <-40.287529, -12.921217, 72.161030>,
        <-40.474339, -13.137636, 72.090710>,
        < -40.474339, -12.885696, 70.500000>
      }
      triangle {
        <-40.287529, -12.921217, 72.161030>,
        <-40.287529, -13.684708, 73.659460>,
        < -40.474339, -13.137636, 72.090710>
      }
      triangle {
        <-40.287529, -12.658136, 70.500000>,
        <-40.474339, -12.885696, 70.500000>,
        < -40.474339, -13.137636, 68.909290>
      }
      triangle {
        <-40.287529, -12.658136, 70.500000>,
        <-40.287529, -12.921217, 72.161030>,
        < -40.474339, -12.885696, 70.500000>
      }
      triangle {
        <-40.287529, -12.921217, 68.838970>,
        <-40.474339, -13.137636, 68.909290>,
        < -40.474339, -13.868807, 67.474300>
      }
      triangle {
        <-40.287529, -12.921217, 68.838970>,
        <-40.287529, -12.658136, 70.500000>,
        < -40.474339, -13.137636, 68.909290>
      }
      triangle {
        <-40.287529, -13.684708, 67.340540>,
        <-40.474339, -13.868807, 67.474300>,
        < -40.474339, -15.007627, 66.335480>
      }
      triangle {
        <-40.287529, -13.684708, 67.340540>,
        <-40.287529, -12.921217, 68.838970>,
        < -40.474339, -13.868807, 67.474300>
      }
      triangle {
        <-40.287529, -14.873867, 66.151381>,
        <-40.474339, -15.007627, 66.335480>,
        < -40.474339, -16.442617, 65.604309>
      }
      triangle {
        <-40.287529, -14.873867, 66.151381>,
        <-40.287529, -13.684708, 67.340540>,
        < -40.474339, -15.007627, 66.335480>
      }
      triangle {
        <-40.287529, -16.372297, 65.387890>,
        <-40.287529, -14.873867, 66.151381>,
        < -40.474339, -16.442617, 65.604309>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.287529, -16.372297, 65.387890>,
        < -40.287529, -18.033327, 65.124809>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.287529, -18.033327, 65.124809>,
        < -40.000000, -18.033327, 65.066990>
      }
      triangle {
        <-40.287529, -19.694357, 65.387890>,
        <-40.000000, -18.033327, 65.066990>,
        < -40.287529, -18.033327, 65.124809>
      }
      triangle {
        <-40.287529, -19.694357, 65.387890>,
        <-40.287529, -18.033327, 65.124809>,
        < -40.474339, -19.624037, 65.604309>
      }
      triangle {
        <-40.000000, -18.033327, 75.933010>,
        <-40.287529, -18.033327, 75.875190>,
        < -40.287529, -16.372297, 75.612110>
      }
      triangle {
        <-40.000000, -19.891537, 75.605360>,
        <-40.287529, -18.033327, 75.875190>,
        < -40.000000, -18.033327, 75.933010>
      }
      triangle {
        <-40.287529, -19.694357, 75.612110>,
        <-40.287529, -18.033327, 75.875190>,
        < -40.000000, -19.891537, 75.605360>
      }
      triangle {
        <-40.000000, -16.175117, 75.605360>,
        <-40.287529, -16.372297, 75.612110>,
        < -40.287529, -14.873867, 74.848620>
      }
      triangle {
        <-40.000000, -16.175117, 75.605360>,
        <-40.000000, -18.033327, 75.933010>,
        < -40.287529, -16.372297, 75.612110>
      }
      triangle {
        <-40.000000, -14.541048, 74.661920>,
        <-40.287529, -14.873867, 74.848620>,
        < -40.287529, -13.684708, 73.659460>
      }
      triangle {
        <-40.000000, -14.541048, 74.661920>,
        <-40.000000, -16.175117, 75.605360>,
        < -40.287529, -14.873867, 74.848620>
      }
      triangle {
        <-40.000000, -13.328197, 73.216499>,
        <-40.287529, -13.684708, 73.659460>,
        < -40.287529, -12.921217, 72.161030>
      }
      triangle {
        <-40.000000, -13.328197, 73.216499>,
        <-40.000000, -14.541048, 74.661920>,
        < -40.287529, -13.684708, 73.659460>
      }
      triangle {
        <-40.000000, -12.682857, 71.443430>,
        <-40.287529, -12.921217, 72.161030>,
        < -40.287529, -12.658136, 70.500000>
      }
      triangle {
        <-40.000000, -12.682857, 71.443430>,
        <-40.000000, -13.328197, 73.216499>,
        < -40.287529, -12.921217, 72.161030>
      }
      triangle {
        <-40.000000, -12.682857, 69.556570>,
        <-40.287529, -12.658136, 70.500000>,
        < -40.287529, -12.921217, 68.838970>
      }
      triangle {
        <-40.000000, -12.682857, 69.556570>,
        <-40.000000, -12.682857, 71.443430>,
        < -40.287529, -12.658136, 70.500000>
      }
      triangle {
        <-40.000000, -13.328197, 67.783501>,
        <-40.287529, -12.921217, 68.838970>,
        < -40.287529, -13.684708, 67.340540>
      }
      triangle {
        <-40.000000, -13.328197, 67.783501>,
        <-40.000000, -12.682857, 69.556570>,
        < -40.287529, -12.921217, 68.838970>
      }
      triangle {
        <-40.000000, -14.541048, 66.338079>,
        <-40.287529, -13.684708, 67.340540>,
        < -40.287529, -14.873867, 66.151381>
      }
      triangle {
        <-40.000000, -14.541048, 66.338079>,
        <-40.000000, -13.328197, 67.783501>,
        < -40.287529, -13.684708, 67.340540>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.287529, -14.873867, 66.151381>,
        < -40.287529, -16.372297, 65.387890>
      }
      triangle {
        <-40.000000, -16.175117, 65.394640>,
        <-40.000000, -14.541048, 66.338079>,
        < -40.287529, -14.873867, 66.151381>
      }
      triangle {
        <-40.287529, -19.694357, 65.387890>,
        <-40.000000, -19.891537, 65.394640>,
        < -40.000000, -18.033327, 65.066990>
      }
      triangle {
        <-40.287529, -21.192787, 74.848620>,
        <-40.000000, -19.891537, 75.605360>,
        < -40.000000, -21.525607, 74.661920>
      }
      triangle {
        <-40.287529, -19.694357, 75.612110>,
        <-40.000000, -19.891537, 75.605360>,
        < -40.287529, -21.192787, 74.848620>
      }
      triangle {
        <-40.287529, -22.381947, 73.659460>,
        <-40.000000, -21.525607, 74.661920>,
        < -40.000000, -22.738457, 73.216499>
      }
      triangle {
        <-40.287529, -21.192787, 74.848620>,
        <-40.000000, -21.525607, 74.661920>,
        < -40.287529, -22.381947, 73.659460>
      }
      triangle {
        <-40.287529, -23.145437, 72.161030>,
        <-40.000000, -22.738457, 73.216499>,
        < -40.000000, -23.383797, 71.443430>
      }
      triangle {
        <-40.287529, -22.381947, 73.659460>,
        <-40.000000, -22.738457, 73.216499>,
        < -40.287529, -23.145437, 72.161030>
      }
      triangle {
        <-40.287529, -23.408517, 70.500000>,
        <-40.000000, -23.383797, 71.443430>,
        < -40.000000, -23.383797, 69.556570>
      }
      triangle {
        <-40.287529, -23.145437, 72.161030>,
        <-40.000000, -23.383797, 71.443430>,
        < -40.287529, -23.408517, 70.500000>
      }
      triangle {
        <-40.287529, -23.145437, 68.838970>,
        <-40.000000, -23.383797, 69.556570>,
        < -40.000000, -22.738457, 67.783501>
      }
      triangle {
        <-40.287529, -23.408517, 70.500000>,
        <-40.000000, -23.383797, 69.556570>,
        < -40.287529, -23.145437, 68.838970>
      }
      triangle {
        <-40.287529, -22.381947, 67.340540>,
        <-40.000000, -22.738457, 67.783501>,
        < -40.000000, -21.525607, 66.338079>
      }
      triangle {
        <-40.287529, -23.145437, 68.838970>,
        <-40.000000, -22.738457, 67.783501>,
        < -40.287529, -22.381947, 67.340540>
      }
      triangle {
        <-40.287529, -21.192787, 66.151381>,
        <-40.000000, -21.525607, 66.338079>,
        < -40.000000, -19.891537, 65.394640>
      }
      triangle {
        <-40.287529, -22.381947, 67.340540>,
        <-40.000000, -21.525607, 66.338079>,
        < -40.287529, -21.192787, 66.151381>
      }
      triangle {
        <-40.287529, -21.192787, 66.151381>,
        <-40.000000, -19.891537, 65.394640>,
        < -40.287529, -19.694357, 65.387890>
      }
      triangle {
        <-40.625000, -19.578537, 65.744329>,
        <-40.481220, -19.694487, 65.387489>,
        < -40.481220, -21.193037, 66.151039>
      }
      triangle {
        <-40.625000, -20.972497, 66.454580>,
        <-40.481220, -21.193037, 66.151039>,
        < -40.481220, -22.382287, 67.340290>
      }
      triangle {
        <-40.625000, -20.972497, 66.454580>,
        <-40.625000, -19.578537, 65.744329>,
        < -40.481220, -21.193037, 66.151039>
      }
      triangle {
        <-40.625000, -22.078747, 67.560829>,
        <-40.481220, -22.382287, 67.340290>,
        < -40.481220, -23.145837, 68.838840>
      }
      triangle {
        <-40.625000, -22.078747, 67.560829>,
        <-40.625000, -20.972497, 66.454580>,
        < -40.481220, -22.382287, 67.340290>
      }
      triangle {
        <-40.625000, -22.788997, 68.954790>,
        <-40.481220, -23.145837, 68.838840>,
        < -40.481220, -23.408937, 70.500000>
      }
      triangle {
        <-40.625000, -22.788997, 68.954790>,
        <-40.625000, -22.078747, 67.560829>,
        < -40.481220, -23.145837, 68.838840>
      }
      triangle {
        <-40.625000, -23.033737, 70.500000>,
        <-40.481220, -23.408937, 70.500000>,
        < -40.481220, -23.145837, 72.161160>
      }
      triangle {
        <-40.625000, -23.033737, 70.500000>,
        <-40.625000, -22.788997, 68.954790>,
        < -40.481220, -23.408937, 70.500000>
      }
      triangle {
        <-40.625000, -22.788997, 72.045210>,
        <-40.481220, -23.145837, 72.161160>,
        < -40.481220, -22.382287, 73.659710>
      }
      triangle {
        <-40.625000, -22.788997, 72.045210>,
        <-40.625000, -23.033737, 70.500000>,
        < -40.481220, -23.145837, 72.161160>
      }
      triangle {
        <-40.625000, -22.078747, 73.439171>,
        <-40.481220, -22.382287, 73.659710>,
        < -40.481220, -21.193037, 74.848960>
      }
      triangle {
        <-40.625000, -22.078747, 73.439171>,
        <-40.625000, -22.788997, 72.045210>,
        < -40.481220, -22.382287, 73.659710>
      }
      triangle {
        <-40.625000, -20.972497, 74.545420>,
        <-40.481220, -21.193037, 74.848960>,
        < -40.481220, -19.694487, 75.612510>
      }
      triangle {
        <-40.625000, -20.972497, 74.545420>,
        <-40.625000, -22.078747, 73.439171>,
        < -40.481220, -21.193037, 74.848960>
      }
      triangle {
        <-40.625000, -19.578537, 75.255670>,
        <-40.625000, -20.972497, 74.545420>,
        < -40.481220, -19.694487, 75.612510>
      }
      triangle {
        <-40.481758, -19.462526, 66.101360>,
        <-40.625000, -19.578537, 65.744329>,
        < -40.625000, -20.972497, 66.454580>
      }
      triangle {
        <-40.481758, -20.751837, 66.758301>,
        <-40.625000, -20.972497, 66.454580>,
        < -40.625000, -22.078747, 67.560829>
      }
      triangle {
        <-40.481758, -20.751837, 66.758301>,
        <-40.481758, -19.462526, 66.101360>,
        < -40.625000, -20.972497, 66.454580>
      }
      triangle {
        <-40.481758, -21.775027, 67.781490>,
        <-40.625000, -22.078747, 67.560829>,
        < -40.625000, -22.788997, 68.954790>
      }
      triangle {
        <-40.481758, -21.775027, 67.781490>,
        <-40.481758, -20.751837, 66.758301>,
        < -40.625000, -22.078747, 67.560829>
      }
      triangle {
        <-40.481758, -22.431967, 69.070801>,
        <-40.625000, -22.788997, 68.954790>,
        < -40.625000, -23.033737, 70.500000>
      }
      triangle {
        <-40.481758, -22.431967, 69.070801>,
        <-40.481758, -21.775027, 67.781490>,
        < -40.625000, -22.788997, 68.954790>
      }
      triangle {
        <-40.481758, -22.658327, 70.500000>,
        <-40.625000, -23.033737, 70.500000>,
        < -40.625000, -22.788997, 72.045210>
      }
      triangle {
        <-40.481758, -22.658327, 70.500000>,
        <-40.481758, -22.431967, 69.070801>,
        < -40.625000, -23.033737, 70.500000>
      }
      triangle {
        <-40.481758, -22.431967, 71.929199>,
        <-40.625000, -22.788997, 72.045210>,
        < -40.625000, -22.078747, 73.439171>
      }
      triangle {
        <-40.481758, -22.431967, 71.929199>,
        <-40.481758, -22.658327, 70.500000>,
        < -40.625000, -22.788997, 72.045210>
      }
      triangle {
        <-40.481758, -21.775027, 73.218510>,
        <-40.625000, -22.078747, 73.439171>,
        < -40.625000, -20.972497, 74.545420>
      }
      triangle {
        <-40.481758, -21.775027, 73.218510>,
        <-40.481758, -22.431967, 71.929199>,
        < -40.625000, -22.078747, 73.439171>
      }
      triangle {
        <-40.481758, -20.751837, 74.241699>,
        <-40.625000, -20.972497, 74.545420>,
        < -40.625000, -19.578537, 75.255670>
      }
      triangle {
        <-40.481758, -20.751837, 74.241699>,
        <-40.481758, -21.775027, 73.218510>,
        < -40.625000, -20.972497, 74.545420>
      }
      triangle {
        <-40.481758, -19.462526, 74.898640>,
        <-40.481758, -20.751837, 74.241699>,
        < -40.625000, -19.578537, 75.255670>
      }
      triangle {
        <-40.474640, -19.533056, 65.884319>,
        <-40.288300, -19.462618, 66.101101>,
        < -40.288300, -20.751997, 66.758080>
      }
      triangle {
        <-40.474640, -20.885977, 66.573669>,
        <-40.288300, -20.751997, 66.758080>,
        < -40.288300, -21.775247, 67.781330>
      }
      triangle {
        <-40.474640, -20.885977, 66.573669>,
        <-40.474640, -19.533056, 65.884319>,
        < -40.288300, -20.751997, 66.758080>
      }
      triangle {
        <-40.474640, -21.959657, 67.647350>,
        <-40.288300, -21.775247, 67.781330>,
        < -40.288300, -22.432227, 69.070709>
      }
      triangle {
        <-40.474640, -21.959657, 67.647350>,
        <-40.474640, -20.885977, 66.573669>,
        < -40.288300, -21.775247, 67.781330>
      }
      triangle {
        <-40.474640, -22.649007, 69.000271>,
        <-40.288300, -22.432227, 69.070709>,
        < -40.288300, -22.658597, 70.500000>
      }
      triangle {
        <-40.474640, -22.649007, 69.000271>,
        <-40.474640, -21.959657, 67.647350>,
        < -40.288300, -22.432227, 69.070709>
      }
      triangle {
        <-40.474640, -22.886547, 70.500000>,
        <-40.288300, -22.658597, 70.500000>,
        < -40.288300, -22.432227, 71.929291>
      }
      triangle {
        <-40.474640, -22.886547, 70.500000>,
        <-40.474640, -22.649007, 69.000271>,
        < -40.288300, -22.658597, 70.500000>
      }
      triangle {
        <-40.474640, -22.649007, 71.999729>,
        <-40.288300, -22.432227, 71.929291>,
        < -40.288300, -21.775247, 73.218670>
      }
      triangle {
        <-40.474640, -22.649007, 71.999729>,
        <-40.474640, -22.886547, 70.500000>,
        < -40.288300, -22.432227, 71.929291>
      }
      triangle {
        <-40.474640, -21.959657, 73.352650>,
        <-40.288300, -21.775247, 73.218670>,
        < -40.288300, -20.751997, 74.241920>
      }
      triangle {
        <-40.474640, -21.959657, 73.352650>,
        <-40.474640, -22.649007, 71.999729>,
        < -40.288300, -21.775247, 73.218670>
      }
      triangle {
        <-40.474640, -20.885977, 74.426331>,
        <-40.288300, -20.751997, 74.241920>,
        < -40.288300, -19.462618, 74.898900>
      }
      triangle {
        <-40.474640, -20.885977, 74.426331>,
        <-40.474640, -21.959657, 73.352650>,
        < -40.288300, -20.751997, 74.241920>
      }
      triangle {
        <-40.474640, -19.533056, 75.115680>,
        <-40.474640, -20.885977, 74.426331>,
        < -40.288300, -19.462618, 74.898900>
      }
      triangle {
        <-40.474339, -19.624037, 65.604309>,
        <-40.474640, -19.533056, 65.884319>,
        < -40.474640, -20.885977, 66.573669>
      }
      triangle {
        <-40.474339, -21.059027, 66.335480>,
        <-40.474640, -20.885977, 66.573669>,
        < -40.474640, -21.959657, 67.647350>
      }
      triangle {
        <-40.474339, -21.059027, 66.335480>,
        <-40.474339, -19.624037, 65.604309>,
        < -40.474640, -20.885977, 66.573669>
      }
      triangle {
        <-40.474339, -22.197847, 67.474300>,
        <-40.474640, -21.959657, 67.647350>,
        < -40.474640, -22.649007, 69.000271>
      }
      triangle {
        <-40.474339, -22.197847, 67.474300>,
        <-40.474339, -21.059027, 66.335480>,
        < -40.474640, -21.959657, 67.647350>
      }
      triangle {
        <-40.474339, -22.929017, 68.909290>,
        <-40.474640, -22.649007, 69.000271>,
        < -40.474640, -22.886547, 70.500000>
      }
      triangle {
        <-40.474339, -22.929017, 68.909290>,
        <-40.474339, -22.197847, 67.474300>,
        < -40.474640, -22.649007, 69.000271>
      }
      triangle {
        <-40.474339, -23.180957, 70.500000>,
        <-40.474640, -22.886547, 70.500000>,
        < -40.474640, -22.649007, 71.999729>
      }
      triangle {
        <-40.474339, -23.180957, 70.500000>,
        <-40.474339, -22.929017, 68.909290>,
        < -40.474640, -22.886547, 70.500000>
      }
      triangle {
        <-40.474339, -22.929017, 72.090710>,
        <-40.474640, -22.649007, 71.999729>,
        < -40.474640, -21.959657, 73.352650>
      }
      triangle {
        <-40.474339, -22.929017, 72.090710>,
        <-40.474339, -23.180957, 70.500000>,
        < -40.474640, -22.649007, 71.999729>
      }
      triangle {
        <-40.474339, -22.197847, 73.525700>,
        <-40.474640, -21.959657, 73.352650>,
        < -40.474640, -20.885977, 74.426331>
      }
      triangle {
        <-40.474339, -22.197847, 73.525700>,
        <-40.474339, -22.929017, 72.090710>,
        < -40.474640, -21.959657, 73.352650>
      }
      triangle {
        <-40.474339, -21.059027, 74.664520>,
        <-40.474640, -20.885977, 74.426331>,
        < -40.474640, -19.533056, 75.115680>
      }
      triangle {
        <-40.474339, -21.059027, 74.664520>,
        <-40.474339, -22.197847, 73.525700>,
        < -40.474640, -20.885977, 74.426331>
      }
      triangle {
        <-40.474339, -19.624037, 75.395690>,
        <-40.474339, -21.059027, 74.664520>,
        < -40.474640, -19.533056, 75.115680>
      }
      triangle {
        <-40.287529, -19.694357, 65.387890>,
        <-40.474339, -19.624037, 65.604309>,
        < -40.474339, -21.059027, 66.335480>
      }
      triangle {
        <-40.287529, -21.192787, 66.151381>,
        <-40.474339, -21.059027, 66.335480>,
        < -40.474339, -22.197847, 67.474300>
      }
      triangle {
        <-40.287529, -21.192787, 66.151381>,
        <-40.287529, -19.694357, 65.387890>,
        < -40.474339, -21.059027, 66.335480>
      }
      triangle {
        <-40.287529, -22.381947, 67.340540>,
        <-40.474339, -22.197847, 67.474300>,
        < -40.474339, -22.929017, 68.909290>
      }
      triangle {
        <-40.287529, -22.381947, 67.340540>,
        <-40.287529, -21.192787, 66.151381>,
        < -40.474339, -22.197847, 67.474300>
      }
      triangle {
        <-40.287529, -23.145437, 68.838970>,
        <-40.474339, -22.929017, 68.909290>,
        < -40.474339, -23.180957, 70.500000>
      }
      triangle {
        <-40.287529, -23.145437, 68.838970>,
        <-40.287529, -22.381947, 67.340540>,
        < -40.474339, -22.929017, 68.909290>
      }
      triangle {
        <-40.287529, -23.408517, 70.500000>,
        <-40.474339, -23.180957, 70.500000>,
        < -40.474339, -22.929017, 72.090710>
      }
      triangle {
        <-40.287529, -23.408517, 70.500000>,
        <-40.287529, -23.145437, 68.838970>,
        < -40.474339, -23.180957, 70.500000>
      }
      triangle {
        <-40.287529, -23.145437, 72.161030>,
        <-40.474339, -22.929017, 72.090710>,
        < -40.474339, -22.197847, 73.525700>
      }
      triangle {
        <-40.287529, -23.145437, 72.161030>,
        <-40.287529, -23.408517, 70.500000>,
        < -40.474339, -22.929017, 72.090710>
      }
      triangle {
        <-40.287529, -22.381947, 73.659460>,
        <-40.474339, -22.197847, 73.525700>,
        < -40.474339, -21.059027, 74.664520>
      }
      triangle {
        <-40.287529, -22.381947, 73.659460>,
        <-40.287529, -23.145437, 72.161030>,
        < -40.474339, -22.197847, 73.525700>
      }
      triangle {
        <-40.287529, -21.192787, 74.848620>,
        <-40.474339, -21.059027, 74.664520>,
        < -40.474339, -19.624037, 75.395690>
      }
      triangle {
        <-40.287529, -21.192787, 74.848620>,
        <-40.287529, -22.381947, 73.659460>,
        < -40.474339, -21.059027, 74.664520>
      }
      triangle {
        <-40.287529, -19.694357, 75.612110>,
        <-40.287529, -21.192787, 74.848620>,
        < -40.474339, -19.624037, 75.395690>
      }
      triangle {
        <-41.125000, -18.298496, 66.859840>,
        <-41.125000, -18.298496, 67.390160>,
        < -41.125000, -18.033327, 67.500000>
      }
      triangle {
        <-41.125000, -18.033327, 66.750000>,
        <-41.125000, -18.298496, 66.859840>,
        < -41.125000, -18.033327, 67.500000>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-41.125000, -18.033327, 66.750000>,
        < -41.125000, -18.033327, 67.500000>
      }
      triangle {
        <-41.125000, -18.298496, 66.859840>,
        <-41.125000, -18.408327, 67.125000>,
        < -41.125000, -18.298496, 67.390160>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-41.125000, -17.768158, 66.859840>,
        < -41.125000, -18.033327, 66.750000>
      }
      triangle {
        <-41.125000, -17.768158, 67.390160>,
        <-41.125000, -17.658327, 67.125000>,
        < -41.125000, -17.768158, 66.859840>
      }
      triangle {
        <-41.125000, -18.298496, 63.859840>,
        <-41.125000, -18.298496, 64.390160>,
        < -41.125000, -18.033327, 64.500000>
      }
      triangle {
        <-41.125000, -18.033327, 63.750000>,
        <-41.125000, -18.298496, 63.859840>,
        < -41.125000, -18.033327, 64.500000>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-41.125000, -18.033327, 63.750000>,
        < -41.125000, -18.033327, 64.500000>
      }
      triangle {
        <-41.125000, -18.298496, 63.859840>,
        <-41.125000, -18.408327, 64.125000>,
        < -41.125000, -18.298496, 64.390160>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-41.125000, -17.768158, 63.859840>,
        < -41.125000, -18.033327, 63.750000>
      }
      triangle {
        <-41.125000, -17.768158, 64.390160>,
        <-41.125000, -17.658327, 64.125000>,
        < -41.125000, -17.768158, 63.859840>
      }
      triangle {
        <-41.125000, -15.646847, 67.738520>,
        <-41.125000, -16.021837, 68.113510>,
        < -41.125000, -15.912006, 68.378679>
      }
      triangle {
        <-41.125000, -15.381678, 67.848351>,
        <-41.125000, -15.646847, 67.738520>,
        < -41.125000, -15.912006, 68.378679>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-41.125000, -15.381678, 67.848351>,
        < -41.125000, -15.912006, 68.378679>
      }
      triangle {
        <-41.125000, -15.646847, 67.738520>,
        <-41.125000, -15.912006, 67.848351>,
        < -41.125000, -16.021837, 68.113510>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-41.125000, -15.271847, 68.113520>,
        < -41.125000, -15.381678, 67.848351>
      }
      triangle {
        <-41.125000, -15.646837, 68.488510>,
        <-41.125000, -15.381678, 68.378679>,
        < -41.125000, -15.271847, 68.113520>
      }
      triangle {
        <-41.125000, -13.525528, 65.617189>,
        <-41.125000, -13.900516, 65.992189>,
        < -41.125000, -13.790687, 66.257360>
      }
      triangle {
        <-41.125000, -13.260357, 65.727030>,
        <-41.125000, -13.525528, 65.617189>,
        < -41.125000, -13.790687, 66.257360>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-41.125000, -13.260357, 65.727030>,
        < -41.125000, -13.790687, 66.257360>
      }
      triangle {
        <-41.125000, -13.525528, 65.617189>,
        <-41.125000, -13.790687, 65.727030>,
        < -41.125000, -13.900516, 65.992189>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-41.125000, -13.150516, 65.992201>,
        < -41.125000, -13.260357, 65.727030>
      }
      triangle {
        <-41.125000, -13.525516, 66.367189>,
        <-41.125000, -13.260357, 66.257360>,
        < -41.125000, -13.150516, 65.992201>
      }
      triangle {
        <-41.125000, -14.393167, 70.234831>,
        <-41.125000, -14.923487, 70.234831>,
        < -41.125000, -15.033327, 70.500000>
      }
      triangle {
        <-41.125000, -14.283327, 70.500000>,
        <-41.125000, -14.393167, 70.234831>,
        < -41.125000, -15.033327, 70.500000>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-41.125000, -14.283327, 70.500000>,
        < -41.125000, -15.033327, 70.500000>
      }
      triangle {
        <-41.125000, -14.393167, 70.234831>,
        <-41.125000, -14.658327, 70.125000>,
        < -41.125000, -14.923487, 70.234831>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-41.125000, -14.393167, 70.765169>,
        < -41.125000, -14.283327, 70.500000>
      }
      triangle {
        <-41.125000, -14.923487, 70.765169>,
        <-41.125000, -14.658327, 70.875000>,
        < -41.125000, -14.393167, 70.765169>
      }
      triangle {
        <-41.125000, -11.393167, 70.234831>,
        <-41.125000, -11.923487, 70.234831>,
        < -41.125000, -12.033327, 70.500000>
      }
      triangle {
        <-41.125000, -11.283327, 70.500000>,
        <-41.125000, -11.393167, 70.234831>,
        < -41.125000, -12.033327, 70.500000>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-41.125000, -11.283327, 70.500000>,
        < -41.125000, -12.033327, 70.500000>
      }
      triangle {
        <-41.125000, -11.393167, 70.234831>,
        <-41.125000, -11.658327, 70.125000>,
        < -41.125000, -11.923487, 70.234831>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-41.125000, -11.393167, 70.765169>,
        < -41.125000, -11.283327, 70.500000>
      }
      triangle {
        <-41.125000, -11.923487, 70.765169>,
        <-41.125000, -11.658327, 70.875000>,
        < -41.125000, -11.393167, 70.765169>
      }
      triangle {
        <-41.125000, -15.271847, 72.886480>,
        <-41.125000, -15.646837, 72.511490>,
        < -41.125000, -15.912006, 72.621321>
      }
      triangle {
        <-41.125000, -15.381678, 73.151649>,
        <-41.125000, -15.271847, 72.886480>,
        < -41.125000, -15.912006, 72.621321>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-41.125000, -15.381678, 73.151649>,
        < -41.125000, -15.912006, 72.621321>
      }
      triangle {
        <-41.125000, -15.271847, 72.886480>,
        <-41.125000, -15.381678, 72.621321>,
        < -41.125000, -15.646837, 72.511490>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-41.125000, -15.646847, 73.261480>,
        < -41.125000, -15.381678, 73.151649>
      }
      triangle {
        <-41.125000, -16.021837, 72.886490>,
        <-41.125000, -15.912006, 73.151649>,
        < -41.125000, -15.646847, 73.261480>
      }
      triangle {
        <-41.125000, -13.150516, 75.007800>,
        <-41.125000, -13.525516, 74.632810>,
        < -41.125000, -13.790687, 74.742640>
      }
      triangle {
        <-41.125000, -13.260357, 75.272970>,
        <-41.125000, -13.150516, 75.007800>,
        < -41.125000, -13.790687, 74.742640>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-41.125000, -13.260357, 75.272970>,
        < -41.125000, -13.790687, 74.742640>
      }
      triangle {
        <-41.125000, -13.150516, 75.007800>,
        <-41.125000, -13.260357, 74.742640>,
        < -41.125000, -13.525516, 74.632810>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-41.125000, -13.525528, 75.382810>,
        < -41.125000, -13.260357, 75.272970>
      }
      triangle {
        <-41.125000, -13.900516, 75.007810>,
        <-41.125000, -13.790687, 75.272970>,
        < -41.125000, -13.525528, 75.382810>
      }
      triangle {
        <-41.125000, -17.768158, 74.140160>,
        <-41.125000, -17.768158, 73.609840>,
        < -41.125000, -18.033327, 73.500000>
      }
      triangle {
        <-41.125000, -18.033327, 74.250000>,
        <-41.125000, -17.768158, 74.140160>,
        < -41.125000, -18.033327, 73.500000>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-41.125000, -18.033327, 74.250000>,
        < -41.125000, -18.033327, 73.500000>
      }
      triangle {
        <-41.125000, -17.768158, 74.140160>,
        <-41.125000, -17.658327, 73.875000>,
        < -41.125000, -17.768158, 73.609840>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-41.125000, -18.298496, 74.140160>,
        < -41.125000, -18.033327, 74.250000>
      }
      triangle {
        <-41.125000, -18.298496, 73.609840>,
        <-41.125000, -18.408327, 73.875000>,
        < -41.125000, -18.298496, 74.140160>
      }
      triangle {
        <-41.125000, -17.768158, 77.140160>,
        <-41.125000, -17.768158, 76.609840>,
        < -41.125000, -18.033327, 76.500000>
      }
      triangle {
        <-41.125000, -18.033327, 77.250000>,
        <-41.125000, -17.768158, 77.140160>,
        < -41.125000, -18.033327, 76.500000>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-41.125000, -18.033327, 77.250000>,
        < -41.125000, -18.033327, 76.500000>
      }
      triangle {
        <-41.125000, -17.768158, 77.140160>,
        <-41.125000, -17.658327, 76.875000>,
        < -41.125000, -17.768158, 76.609840>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-41.125000, -18.298496, 77.140160>,
        < -41.125000, -18.033327, 77.250000>
      }
      triangle {
        <-41.125000, -18.298496, 76.609840>,
        <-41.125000, -18.408327, 76.875000>,
        < -41.125000, -18.298496, 77.140160>
      }
      triangle {
        <-41.125000, -20.419807, 73.261480>,
        <-41.125000, -20.044817, 72.886490>,
        < -41.125000, -20.154647, 72.621321>
      }
      triangle {
        <-41.125000, -20.684977, 73.151649>,
        <-41.125000, -20.419807, 73.261480>,
        < -41.125000, -20.154647, 72.621321>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-41.125000, -20.684977, 73.151649>,
        < -41.125000, -20.154647, 72.621321>
      }
      triangle {
        <-41.125000, -20.419807, 73.261480>,
        <-41.125000, -20.154647, 73.151649>,
        < -41.125000, -20.044817, 72.886490>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-41.125000, -20.794807, 72.886480>,
        < -41.125000, -20.684977, 73.151649>
      }
      triangle {
        <-41.125000, -20.419817, 72.511490>,
        <-41.125000, -20.684977, 72.621321>,
        < -41.125000, -20.794807, 72.886480>
      }
      triangle {
        <-41.125000, -22.541127, 75.382810>,
        <-41.125000, -22.166137, 75.007810>,
        < -41.125000, -22.275967, 74.742640>
      }
      triangle {
        <-41.125000, -22.806297, 75.272970>,
        <-41.125000, -22.541127, 75.382810>,
        < -41.125000, -22.275967, 74.742640>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-41.125000, -22.806297, 75.272970>,
        < -41.125000, -22.275967, 74.742640>
      }
      triangle {
        <-41.125000, -22.541127, 75.382810>,
        <-41.125000, -22.275967, 75.272970>,
        < -41.125000, -22.166137, 75.007810>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-41.125000, -22.916137, 75.007800>,
        < -41.125000, -22.806297, 75.272970>
      }
      triangle {
        <-41.125000, -22.541137, 74.632810>,
        <-41.125000, -22.806297, 74.742640>,
        < -41.125000, -22.916137, 75.007800>
      }
      triangle {
        <-41.125000, -21.673487, 70.765169>,
        <-41.125000, -21.143167, 70.765169>,
        < -41.125000, -21.033327, 70.500000>
      }
      triangle {
        <-41.125000, -21.783327, 70.500000>,
        <-41.125000, -21.673487, 70.765169>,
        < -41.125000, -21.033327, 70.500000>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-41.125000, -21.783327, 70.500000>,
        < -41.125000, -21.033327, 70.500000>
      }
      triangle {
        <-41.125000, -21.673487, 70.765169>,
        <-41.125000, -21.408327, 70.875000>,
        < -41.125000, -21.143167, 70.765169>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-41.125000, -21.673487, 70.234831>,
        < -41.125000, -21.783327, 70.500000>
      }
      triangle {
        <-41.125000, -21.143167, 70.234831>,
        <-41.125000, -21.408327, 70.125000>,
        < -41.125000, -21.673487, 70.234831>
      }
      triangle {
        <-41.125000, -24.673487, 70.765169>,
        <-41.125000, -24.143167, 70.765169>,
        < -41.125000, -24.033327, 70.500000>
      }
      triangle {
        <-41.125000, -24.783327, 70.500000>,
        <-41.125000, -24.673487, 70.765169>,
        < -41.125000, -24.033327, 70.500000>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-41.125000, -24.783327, 70.500000>,
        < -41.125000, -24.033327, 70.500000>
      }
      triangle {
        <-41.125000, -24.673487, 70.765169>,
        <-41.125000, -24.408327, 70.875000>,
        < -41.125000, -24.143167, 70.765169>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-41.125000, -24.673487, 70.234831>,
        < -41.125000, -24.783327, 70.500000>
      }
      triangle {
        <-41.125000, -24.143167, 70.234831>,
        <-41.125000, -24.408327, 70.125000>,
        < -41.125000, -24.673487, 70.234831>
      }
      triangle {
        <-41.125000, -20.794807, 68.113520>,
        <-41.125000, -20.419817, 68.488510>,
        < -41.125000, -20.154647, 68.378679>
      }
      triangle {
        <-41.125000, -20.684977, 67.848351>,
        <-41.125000, -20.794807, 68.113520>,
        < -41.125000, -20.154647, 68.378679>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-41.125000, -20.684977, 67.848351>,
        < -41.125000, -20.154647, 68.378679>
      }
      triangle {
        <-41.125000, -20.794807, 68.113520>,
        <-41.125000, -20.684977, 68.378679>,
        < -41.125000, -20.419817, 68.488510>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-41.125000, -20.419807, 67.738520>,
        < -41.125000, -20.684977, 67.848351>
      }
      triangle {
        <-41.125000, -20.044817, 68.113510>,
        <-41.125000, -20.154647, 67.848351>,
        < -41.125000, -20.419807, 67.738520>
      }
      triangle {
        <-41.125000, -22.916137, 65.992201>,
        <-41.125000, -22.541137, 66.367189>,
        < -41.125000, -22.275967, 66.257360>
      }
      triangle {
        <-41.125000, -22.806297, 65.727030>,
        <-41.125000, -22.916137, 65.992201>,
        < -41.125000, -22.275967, 66.257360>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-41.125000, -22.806297, 65.727030>,
        < -41.125000, -22.275967, 66.257360>
      }
      triangle {
        <-41.125000, -22.916137, 65.992201>,
        <-41.125000, -22.806297, 66.257360>,
        < -41.125000, -22.541137, 66.367189>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-41.125000, -22.541127, 65.617189>,
        < -41.125000, -22.806297, 65.727030>
      }
      triangle {
        <-41.125000, -22.166137, 65.992189>,
        <-41.125000, -22.275967, 65.727030>,
        < -41.125000, -22.541127, 65.617189>
      }
      triangle {
        <43.047112, -20.533707, 79.015500>,
        <42.598888, -18.033327, 79.375000>,
        < 43.047112, -18.033327, 79.375000>
      }
      triangle {
        <42.598888, -15.532947, 79.015500>,
        <43.047112, -18.033327, 79.375000>,
        < 42.598888, -18.033327, 79.375000>
      }
      triangle {
        <43.047112, -20.568927, 79.135430>,
        <43.047112, -20.533707, 79.015500>,
        < 43.047112, -18.033327, 79.375000>
      }
      triangle {
        <43.047112, -20.568927, 79.135430>,
        <43.047112, -18.033327, 79.375000>,
        < 43.047112, -18.033327, 79.500000>
      }
      triangle {
        <43.047112, -15.532947, 79.015500>,
        <43.047112, -18.033327, 79.500000>,
        < 43.047112, -18.033327, 79.375000>
      }
      triangle {
        <42.598888, -15.532947, 79.015500>,
        <43.047112, -15.532947, 79.015500>,
        < 43.047112, -18.033327, 79.375000>
      }
      triangle {
        <43.047112, -20.533707, 79.015500>,
        <42.598888, -20.533707, 79.015500>,
        < 42.598888, -18.033327, 79.375000>
      }
      triangle {
        <42.111019, -18.033327, 78.887130>,
        <42.598888, -18.033327, 79.375000>,
        < 42.598888, -20.533707, 79.015500>
      }
      triangle {
        <42.111019, -15.670397, 78.547390>,
        <42.598888, -18.033327, 79.375000>,
        < 42.111019, -18.033327, 78.887130>
      }
      triangle {
        <42.111019, -15.670397, 78.547390>,
        <42.598888, -15.532947, 79.015500>,
        < 42.598888, -18.033327, 79.375000>
      }
      triangle {
        <43.047112, -22.831517, 77.966130>,
        <42.598888, -22.831517, 77.966130>,
        < 42.598888, -20.533707, 79.015500>
      }
      triangle {
        <42.111019, -20.396257, 78.547390>,
        <42.598888, -20.533707, 79.015500>,
        < 42.598888, -22.831517, 77.966130>
      }
      triangle {
        <43.047112, -20.533707, 79.015500>,
        <43.047112, -22.831517, 77.966130>,
        < 42.598888, -20.533707, 79.015500>
      }
      triangle {
        <42.111019, -20.396257, 78.547390>,
        <42.111019, -18.033327, 78.887130>,
        < 42.598888, -20.533707, 79.015500>
      }
      triangle {
        <43.047112, -24.740597, 76.311890>,
        <42.598888, -24.740607, 76.311890>,
        < 42.598888, -22.831517, 77.966130>
      }
      triangle {
        <42.111019, -22.567747, 77.555700>,
        <42.598888, -22.831517, 77.966130>,
        < 42.598888, -24.740607, 76.311890>
      }
      triangle {
        <43.047112, -22.831517, 77.966130>,
        <43.047112, -24.740597, 76.311890>,
        < 42.598888, -22.831517, 77.966130>
      }
      triangle {
        <42.111019, -22.567747, 77.555700>,
        <42.111019, -20.396257, 78.547390>,
        < 42.598888, -22.831517, 77.966130>
      }
      triangle {
        <43.047112, -26.106313, 74.186800>,
        <42.598888, -26.106311, 74.186810>,
        < 42.598888, -24.740607, 76.311890>
      }
      triangle {
        <42.111019, -24.371897, 75.992400>,
        <42.598888, -24.740607, 76.311890>,
        < 42.598888, -26.106311, 74.186810>
      }
      triangle {
        <43.047112, -24.740597, 76.311890>,
        <43.047112, -26.106313, 74.186800>,
        < 42.598888, -24.740607, 76.311890>
      }
      triangle {
        <42.111019, -24.371897, 75.992400>,
        <42.111019, -22.567747, 77.555700>,
        < 42.598888, -24.740607, 76.311890>
      }
      triangle {
        <43.047112, -26.817993, 71.763041>,
        <42.598888, -26.817992, 71.763041>,
        < 42.598888, -26.106311, 74.186810>
      }
      triangle {
        <42.111019, -25.662527, 73.984140>,
        <42.598888, -26.106311, 74.186810>,
        < 42.598888, -26.817992, 71.763041>
      }
      triangle {
        <43.047112, -26.106313, 74.186800>,
        <43.047112, -26.817993, 71.763041>,
        < 42.598888, -26.106311, 74.186810>
      }
      triangle {
        <42.111019, -25.662527, 73.984140>,
        <42.111019, -24.371897, 75.992400>,
        < 42.598888, -26.106311, 74.186810>
      }
      triangle {
        <43.047112, -26.817993, 69.236959>,
        <42.598888, -26.817992, 69.236959>,
        < 42.598888, -26.817992, 71.763041>
      }
      triangle {
        <42.111019, -26.335088, 71.693609>,
        <42.598888, -26.817992, 71.763041>,
        < 42.598888, -26.817992, 69.236959>
      }
      triangle {
        <43.047112, -26.817993, 71.763041>,
        <43.047112, -26.817993, 69.236959>,
        < 42.598888, -26.817992, 71.763041>
      }
      triangle {
        <42.111019, -26.335088, 71.693609>,
        <42.111019, -25.662527, 73.984140>,
        < 42.598888, -26.817992, 71.763041>
      }
      triangle {
        <43.047112, -26.106313, 66.813200>,
        <42.598888, -26.106311, 66.813190>,
        < 42.598888, -26.817992, 69.236959>
      }
      triangle {
        <42.111019, -26.335088, 69.306391>,
        <42.598888, -26.817992, 69.236959>,
        < 42.598888, -26.106311, 66.813190>
      }
      triangle {
        <43.047112, -26.817993, 69.236959>,
        <43.047112, -26.106313, 66.813200>,
        < 42.598888, -26.817992, 69.236959>
      }
      triangle {
        <42.111019, -26.335088, 69.306391>,
        <42.111019, -26.335088, 71.693609>,
        < 42.598888, -26.817992, 69.236959>
      }
      triangle {
        <43.047112, -24.740597, 64.688110>,
        <42.598888, -24.740607, 64.688110>,
        < 42.598888, -26.106311, 66.813190>
      }
      triangle {
        <42.111019, -25.662527, 67.015860>,
        <42.598888, -26.106311, 66.813190>,
        < 42.598888, -24.740607, 64.688110>
      }
      triangle {
        <43.047112, -26.106313, 66.813200>,
        <43.047112, -24.740597, 64.688110>,
        < 42.598888, -26.106311, 66.813190>
      }
      triangle {
        <42.111019, -25.662527, 67.015860>,
        <42.111019, -26.335088, 69.306391>,
        < 42.598888, -26.106311, 66.813190>
      }
      triangle {
        <43.047112, -22.831517, 63.033871>,
        <42.598888, -22.831517, 63.033871>,
        < 42.598888, -24.740607, 64.688110>
      }
      triangle {
        <42.111019, -24.371897, 65.007601>,
        <42.598888, -24.740607, 64.688110>,
        < 42.598888, -22.831517, 63.033871>
      }
      triangle {
        <43.047112, -24.740597, 64.688110>,
        <43.047112, -22.831517, 63.033871>,
        < 42.598888, -24.740607, 64.688110>
      }
      triangle {
        <42.111019, -24.371897, 65.007601>,
        <42.111019, -25.662527, 67.015860>,
        < 42.598888, -24.740607, 64.688110>
      }
      triangle {
        <43.047112, -20.533707, 61.984501>,
        <42.598888, -20.533707, 61.984501>,
        < 42.598888, -22.831517, 63.033871>
      }
      triangle {
        <42.111019, -22.567747, 63.444300>,
        <42.598888, -22.831517, 63.033871>,
        < 42.598888, -20.533707, 61.984501>
      }
      triangle {
        <43.047112, -22.831517, 63.033871>,
        <43.047112, -20.533707, 61.984501>,
        < 42.598888, -22.831517, 63.033871>
      }
      triangle {
        <42.111019, -22.567747, 63.444300>,
        <42.111019, -24.371897, 65.007601>,
        < 42.598888, -22.831517, 63.033871>
      }
      triangle {
        <43.047112, -18.033327, 61.625000>,
        <42.598888, -18.033327, 61.625000>,
        < 42.598888, -20.533707, 61.984501>
      }
      triangle {
        <42.111019, -20.396257, 62.452610>,
        <42.598888, -20.533707, 61.984501>,
        < 42.598888, -18.033327, 61.625000>
      }
      triangle {
        <43.047112, -20.533707, 61.984501>,
        <43.047112, -18.033327, 61.625000>,
        < 42.598888, -20.533707, 61.984501>
      }
      triangle {
        <42.111019, -20.396257, 62.452610>,
        <42.111019, -22.567747, 63.444300>,
        < 42.598888, -20.533707, 61.984501>
      }
      triangle {
        <43.047112, -15.532947, 61.984501>,
        <42.598888, -18.033327, 61.625000>,
        < 43.047112, -18.033327, 61.625000>
      }
      triangle {
        <42.111019, -18.033327, 62.112869>,
        <42.111019, -20.396257, 62.452610>,
        < 42.598888, -18.033327, 61.625000>
      }
      triangle {
        <42.598888, -15.532947, 61.984501>,
        <42.111019, -18.033327, 62.112869>,
        < 42.598888, -18.033327, 61.625000>
      }
      triangle {
        <42.598888, -15.532947, 61.984501>,
        <42.598888, -18.033327, 61.625000>,
        < 43.047112, -15.532947, 61.984501>
      }
      triangle {
        <43.047112, -18.033327, 61.500000>,
        <43.047112, -18.033327, 61.625000>,
        < 43.047112, -20.533707, 61.984501>
      }
      triangle {
        <43.047112, -15.497726, 61.864571>,
        <43.047112, -18.033327, 61.625000>,
        < 43.047112, -18.033327, 61.500000>
      }
      triangle {
        <43.047112, -15.497726, 61.864571>,
        <43.047112, -15.532947, 61.984501>,
        < 43.047112, -18.033327, 61.625000>
      }
      triangle {
        <43.047112, -20.568927, 61.864571>,
        <43.047112, -20.533707, 61.984501>,
        < 43.047112, -22.831517, 63.033871>
      }
      triangle {
        <43.047112, -18.033327, 61.500000>,
        <43.047112, -20.533707, 61.984501>,
        < 43.047112, -20.568927, 61.864571>
      }
      triangle {
        <43.047112, -22.899097, 62.928720>,
        <43.047112, -22.831517, 63.033871>,
        < 43.047112, -24.740597, 64.688110>
      }
      triangle {
        <43.047112, -20.568927, 61.864571>,
        <43.047112, -22.831517, 63.033871>,
        < 43.047112, -22.899097, 62.928720>
      }
      triangle {
        <43.047112, -24.835067, 64.606251>,
        <43.047112, -24.740597, 64.688110>,
        < 43.047112, -26.106313, 66.813200>
      }
      triangle {
        <43.047112, -22.899097, 62.928720>,
        <43.047112, -24.740597, 64.688110>,
        < 43.047112, -24.835067, 64.606251>
      }
      triangle {
        <43.047112, -26.220017, 66.761271>,
        <43.047112, -26.106313, 66.813200>,
        < 43.047112, -26.817993, 69.236959>
      }
      triangle {
        <43.047112, -24.835067, 64.606251>,
        <43.047112, -26.106313, 66.813200>,
        < 43.047112, -26.220017, 66.761271>
      }
      triangle {
        <43.047112, -26.941720, 71.780830>,
        <43.047112, -26.817993, 69.236959>,
        < 43.047112, -26.817993, 71.763041>
      }
      triangle {
        <43.047112, -26.941720, 69.219170>,
        <43.047112, -26.817993, 69.236959>,
        < 43.047112, -26.941720, 71.780830>
      }
      triangle {
        <43.047112, -26.220017, 66.761271>,
        <43.047112, -26.817993, 69.236959>,
        < 43.047112, -26.941720, 69.219170>
      }
      triangle {
        <43.047112, -26.220017, 74.238729>,
        <43.047112, -26.817993, 71.763041>,
        < 43.047112, -26.106313, 74.186800>
      }
      triangle {
        <43.047112, -26.941720, 71.780830>,
        <43.047112, -26.817993, 71.763041>,
        < 43.047112, -26.220017, 74.238729>
      }
      triangle {
        <43.047112, -24.835067, 76.393750>,
        <43.047112, -26.106313, 74.186800>,
        < 43.047112, -24.740597, 76.311890>
      }
      triangle {
        <43.047112, -26.220017, 74.238729>,
        <43.047112, -26.106313, 74.186800>,
        < 43.047112, -24.835067, 76.393750>
      }
      triangle {
        <43.047112, -22.899097, 78.071280>,
        <43.047112, -24.740597, 76.311890>,
        < 43.047112, -22.831517, 77.966130>
      }
      triangle {
        <43.047112, -24.835067, 76.393750>,
        <43.047112, -24.740597, 76.311890>,
        < 43.047112, -22.899097, 78.071280>
      }
      triangle {
        <43.047112, -20.568927, 79.135430>,
        <43.047112, -22.831517, 77.966130>,
        < 43.047112, -20.533707, 79.015500>
      }
      triangle {
        <43.047112, -22.899097, 78.071280>,
        <43.047112, -22.831517, 77.966130>,
        < 43.047112, -20.568927, 79.135430>
      }
      triangle {
        <40.125000, -18.033327, 78.390620>,
        <42.111019, -18.033327, 78.887130>,
        < 42.111019, -20.396257, 78.547390>
      }
      triangle {
        <40.125000, -15.594976, 78.004430>,
        <42.111019, -18.033327, 78.887130>,
        < 40.125000, -18.033327, 78.390620>
      }
      triangle {
        <40.125000, -15.594976, 78.004430>,
        <42.111019, -15.670397, 78.547390>,
        < 42.111019, -18.033327, 78.887130>
      }
      triangle {
        <40.125000, -20.471677, 78.004430>,
        <42.111019, -20.396257, 78.547390>,
        < 42.111019, -22.567747, 77.555700>
      }
      triangle {
        <40.125000, -20.471677, 78.004430>,
        <40.125000, -18.033327, 78.390620>,
        < 42.111019, -20.396257, 78.547390>
      }
      triangle {
        <40.125000, -22.671327, 76.883640>,
        <42.111019, -22.567747, 77.555700>,
        < 42.111019, -24.371897, 75.992400>
      }
      triangle {
        <40.125000, -22.671327, 76.883640>,
        <40.125000, -20.471677, 78.004430>,
        < 42.111019, -22.567747, 77.555700>
      }
      triangle {
        <40.125000, -24.416987, 75.137980>,
        <42.111019, -24.371897, 75.992400>,
        < 42.111019, -25.662527, 73.984140>
      }
      triangle {
        <40.125000, -24.416987, 75.137980>,
        <40.125000, -22.671327, 76.883640>,
        < 42.111019, -24.371897, 75.992400>
      }
      triangle {
        <40.125000, -25.537757, 72.938330>,
        <42.111019, -25.662527, 73.984140>,
        < 42.111019, -26.335088, 71.693609>
      }
      triangle {
        <40.125000, -25.537757, 72.938330>,
        <40.125000, -24.416987, 75.137980>,
        < 42.111019, -25.662527, 73.984140>
      }
      triangle {
        <40.125000, -25.923947, 70.500000>,
        <42.111019, -26.335088, 71.693609>,
        < 42.111019, -26.335088, 69.306391>
      }
      triangle {
        <40.125000, -25.923947, 70.500000>,
        <40.125000, -25.537757, 72.938330>,
        < 42.111019, -26.335088, 71.693609>
      }
      triangle {
        <40.125000, -25.537757, 68.061670>,
        <42.111019, -26.335088, 69.306391>,
        < 42.111019, -25.662527, 67.015860>
      }
      triangle {
        <40.125000, -25.537757, 68.061670>,
        <40.125000, -25.923947, 70.500000>,
        < 42.111019, -26.335088, 69.306391>
      }
      triangle {
        <40.125000, -24.416987, 65.862020>,
        <42.111019, -25.662527, 67.015860>,
        < 42.111019, -24.371897, 65.007601>
      }
      triangle {
        <40.125000, -24.416987, 65.862020>,
        <40.125000, -25.537757, 68.061670>,
        < 42.111019, -25.662527, 67.015860>
      }
      triangle {
        <40.125000, -22.671327, 64.116360>,
        <42.111019, -24.371897, 65.007601>,
        < 42.111019, -22.567747, 63.444300>
      }
      triangle {
        <40.125000, -22.671327, 64.116360>,
        <40.125000, -24.416987, 65.862020>,
        < 42.111019, -24.371897, 65.007601>
      }
      triangle {
        <40.125000, -20.471677, 62.995569>,
        <42.111019, -22.567747, 63.444300>,
        < 42.111019, -20.396257, 62.452610>
      }
      triangle {
        <40.125000, -20.471677, 62.995569>,
        <40.125000, -22.671327, 64.116360>,
        < 42.111019, -22.567747, 63.444300>
      }
      triangle {
        <40.125000, -20.471677, 62.995569>,
        <42.111019, -20.396257, 62.452610>,
        < 42.111019, -18.033327, 62.112869>
      }
      triangle {
        <40.125000, -18.033327, 62.609381>,
        <40.125000, -20.471677, 62.995569>,
        < 42.111019, -18.033327, 62.112869>
      }
      triangle {
        <42.111019, -15.670397, 62.452610>,
        <40.125000, -18.033327, 62.609381>,
        < 42.111019, -18.033327, 62.112869>
      }
      triangle {
        <42.111019, -15.670397, 62.452610>,
        <42.111019, -18.033327, 62.112869>,
        < 42.598888, -15.532947, 61.984501>
      }
      triangle {
        <40.125000, -18.033327, 77.250000>,
        <40.125000, -18.033327, 78.390620>,
        < 40.125000, -20.471677, 78.004430>
      }
      triangle {
        <40.125000, -16.132027, 75.723760>,
        <40.125000, -15.594976, 78.004430>,
        < 40.125000, -18.033327, 78.390620>
      }
      triangle {
        <40.125000, -17.658327, 76.875000>,
        <40.125000, -16.132027, 75.723760>,
        < 40.125000, -18.033327, 78.390620>
      }
      triangle {
        <40.125000, -17.768158, 77.140170>,
        <40.125000, -17.658327, 76.875000>,
        < 40.125000, -18.033327, 78.390620>
      }
      triangle {
        <40.125000, -18.033327, 77.250000>,
        <40.125000, -17.768158, 77.140170>,
        < 40.125000, -18.033327, 78.390620>
      }
      triangle {
        <40.125000, -21.606607, 74.758450>,
        <40.125000, -20.471677, 78.004430>,
        < 40.125000, -22.671327, 76.883640>
      }
      triangle {
        <40.125000, -21.606607, 74.758450>,
        <40.125000, -19.934627, 75.723760>,
        < 40.125000, -20.471677, 78.004430>
      }
      triangle {
        <40.125000, -18.408327, 76.875000>,
        <40.125000, -20.471677, 78.004430>,
        < 40.125000, -19.934627, 75.723760>
      }
      triangle {
        <40.125000, -18.298496, 77.140170>,
        <40.125000, -18.033327, 77.250000>,
        < 40.125000, -20.471677, 78.004430>
      }
      triangle {
        <40.125000, -18.408327, 76.875000>,
        <40.125000, -18.298496, 77.140170>,
        < 40.125000, -20.471677, 78.004430>
      }
      triangle {
        <40.125000, -22.806297, 75.272970>,
        <40.125000, -22.671327, 76.883640>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -22.166137, 75.007810>,
        <40.125000, -21.606607, 74.758450>,
        < 40.125000, -22.671327, 76.883640>
      }
      triangle {
        <40.125000, -22.275967, 75.272970>,
        <40.125000, -22.166137, 75.007810>,
        < 40.125000, -22.671327, 76.883640>
      }
      triangle {
        <40.125000, -22.541137, 75.382810>,
        <40.125000, -22.275967, 75.272970>,
        < 40.125000, -22.671327, 76.883640>
      }
      triangle {
        <40.125000, -22.806297, 75.272970>,
        <40.125000, -22.541137, 75.382810>,
        < 40.125000, -22.671327, 76.883640>
      }
      triangle {
        <40.125000, -24.673497, 70.765169>,
        <40.125000, -24.416987, 75.137980>,
        < 40.125000, -25.537757, 72.938330>
      }
      triangle {
        <40.125000, -23.507887, 69.534691>,
        <40.125000, -23.507887, 71.465309>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -22.916137, 75.007810>,
        <40.125000, -24.416987, 75.137980>,
        < 40.125000, -23.507887, 71.465309>
      }
      triangle {
        <40.125000, -24.033327, 70.500000>,
        <40.125000, -23.507887, 69.534691>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -24.143157, 70.765169>,
        <40.125000, -24.033327, 70.500000>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -24.408327, 70.875000>,
        <40.125000, -24.143157, 70.765169>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -24.673497, 70.765169>,
        <40.125000, -24.408327, 70.875000>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -22.916137, 75.007810>,
        <40.125000, -22.806297, 75.272970>,
        < 40.125000, -24.416987, 75.137980>
      }
      triangle {
        <40.125000, -25.537757, 68.061670>,
        <40.125000, -25.537757, 72.938330>,
        < 40.125000, -25.923947, 70.500000>
      }
      triangle {
        <40.125000, -24.416987, 65.862020>,
        <40.125000, -25.537757, 72.938330>,
        < 40.125000, -25.537757, 68.061670>
      }
      triangle {
        <40.125000, -24.783327, 70.500000>,
        <40.125000, -25.537757, 72.938330>,
        < 40.125000, -24.416987, 65.862020>
      }
      triangle {
        <40.125000, -24.783327, 70.500000>,
        <40.125000, -24.673497, 70.765169>,
        < 40.125000, -25.537757, 72.938330>
      }
      triangle {
        <40.125000, -24.408327, 70.125000>,
        <40.125000, -24.416987, 65.862020>,
        < 40.125000, -22.671327, 64.116360>
      }
      triangle {
        <40.125000, -24.673497, 70.234831>,
        <40.125000, -24.783327, 70.500000>,
        < 40.125000, -24.416987, 65.862020>
      }
      triangle {
        <40.125000, -24.408327, 70.125000>,
        <40.125000, -24.673497, 70.234831>,
        < 40.125000, -24.416987, 65.862020>
      }
      triangle {
        <40.125000, -22.541137, 65.617189>,
        <40.125000, -22.671327, 64.116360>,
        < 40.125000, -20.471677, 62.995569>
      }
      triangle {
        <40.125000, -22.916137, 65.992189>,
        <40.125000, -23.507887, 69.534691>,
        < 40.125000, -22.671327, 64.116360>
      }
      triangle {
        <40.125000, -24.033327, 70.500000>,
        <40.125000, -22.671327, 64.116360>,
        < 40.125000, -23.507887, 69.534691>
      }
      triangle {
        <40.125000, -22.806297, 65.727030>,
        <40.125000, -22.916137, 65.992189>,
        < 40.125000, -22.671327, 64.116360>
      }
      triangle {
        <40.125000, -22.541137, 65.617189>,
        <40.125000, -22.806297, 65.727030>,
        < 40.125000, -22.671327, 64.116360>
      }
      triangle {
        <40.125000, -24.143157, 70.234831>,
        <40.125000, -22.671327, 64.116360>,
        < 40.125000, -24.033327, 70.500000>
      }
      triangle {
        <40.125000, -24.143157, 70.234831>,
        <40.125000, -24.408327, 70.125000>,
        < 40.125000, -22.671327, 64.116360>
      }
      triangle {
        <40.125000, -19.934627, 65.276239>,
        <40.125000, -20.471677, 62.995569>,
        < 40.125000, -18.033327, 62.609381>
      }
      triangle {
        <40.125000, -19.934627, 65.276239>,
        <40.125000, -21.606607, 66.241550>,
        < 40.125000, -20.471677, 62.995569>
      }
      triangle {
        <40.125000, -22.166137, 65.992189>,
        <40.125000, -20.471677, 62.995569>,
        < 40.125000, -21.606607, 66.241550>
      }
      triangle {
        <40.125000, -22.275967, 65.727030>,
        <40.125000, -22.541137, 65.617189>,
        < 40.125000, -20.471677, 62.995569>
      }
      triangle {
        <40.125000, -22.166137, 65.992189>,
        <40.125000, -22.275967, 65.727030>,
        < 40.125000, -20.471677, 62.995569>
      }
      triangle {
        <40.125000, -15.594976, 62.995569>,
        <40.125000, -18.033327, 62.609381>,
        < 42.111019, -15.670397, 62.452610>
      }
      triangle {
        <40.125000, -18.033327, 63.750000>,
        <40.125000, -18.033327, 62.609381>,
        < 40.125000, -15.594976, 62.995569>
      }
      triangle {
        <40.125000, -18.408327, 64.125000>,
        <40.125000, -19.934627, 65.276239>,
        < 40.125000, -18.033327, 62.609381>
      }
      triangle {
        <40.125000, -18.298496, 63.859831>,
        <40.125000, -18.408327, 64.125000>,
        < 40.125000, -18.033327, 62.609381>
      }
      triangle {
        <40.125000, -18.033327, 63.750000>,
        <40.125000, -18.298496, 63.859831>,
        < 40.125000, -18.033327, 62.609381>
      }
      triangle {
        <40.000000, -20.466847, 77.989570>,
        <35.031719, -18.033327, 78.375000>,
        < 40.000000, -18.033327, 78.375000>
      }
      triangle {
        <35.031719, -15.599817, 77.989570>,
        <40.000000, -18.033327, 78.375000>,
        < 35.031719, -18.033327, 78.375000>
      }
      triangle {
        <40.000000, -19.891537, 75.605360>,
        <40.000000, -20.466847, 77.989570>,
        < 40.000000, -18.033327, 78.375000>
      }
      triangle {
        <35.031719, -15.599817, 77.989570>,
        <40.000000, -15.599808, 77.989570>,
        < 40.000000, -18.033327, 78.375000>
      }
      triangle {
        <40.000000, -18.033327, 75.933010>,
        <40.000000, -18.033327, 7