/* 
 *  "WarUnits.inc"
 *  Game pieces representing military units for use in "War Games"
 *	
 *	Copyright 2001 Mark Wagner
 */

#version 3.5;

#ifndef(included)
    global_settings{assumed_gamma 1}
    #declare included = true;
    #include "colors.inc"
    #include "textures.inc"

    #declare cm = 1/2.54;    /* 1 POV unit = 1 inch */
    #include "units.inc"     /* www.geocities.com/Rengaw03/Pov-Ray.html */

    #undef included
#end

/* Units:
 Basic infantry: person holding rifle
 Antitank infantry: person holding bazooka
 Mortar infantry: person with light mortar
 Machine gun team: person with bipod machine gun
 
 All infantry is available in both standing and firing postures, and in both red and blue team colors
 
 Blue team: 
 M1A2 tank
 M2 Bradley APC
 Self-propelled howitzer
 Humvee
 Truck
 Flag
 
 Red Team:
 BTR80 APC
 T80 tank
 Truck
 Flag
*/

/* Scale: 1 inch = 10 feet */
/* Units face in the +z direction */

#declare RedFlag = union{
    cylinder{0, y*3*inch, .1*inch pigment{Brown}}
    sphere{y*3.1*inch, .2*inch pigment{Brown}}
    box{<-.01,2,0>*inch, <.01,2.9,1>*inch pigment{Red}}
}

#declare BlueFlag = union{
    cylinder{0, y*3*inch, .1*inch pigment{Brown}}
    sphere{y*3.1*inch, .2*inch pigment{Brown}}
    box{<-.01,2,0>*inch, <.01,2.9,1>*inch pigment{Blue}}
}

#declare M1A2 = union{
    #local included = true;
    #local PathBase = "M1A1\\";
    #include "M1A1\\Ma1asw.pov"
    #undef included
    object{M1A1_Object translate x*-206+z*55 rotate x*-90 rotate y*180 scale (2/324) * 2.6*inch}
    object{BlueFlag scale .6 rotate y*180 translate <-.625,0.2,-1.55>*inch }
};

#declare Humvee = union{
    #local included = true;
    #include "humvee1.pov"
    #undef included
    object{HumveeModel translate y*36 scale (2/187)*1.5*inch}
    object{BlueFlag scale .5 rotate y*180 translate <-.35,0,-.73>*inch }
};

#declare T80 = union{
    #local included = true;
    #local PathBase = "T80\\";
    #include "T80\\T80.pov"
    #undef included
    object{T80_Object translate x*360+z*160+y*-700 rotate x*-90 scale (2/1570) * 2.6*inch}
    object{RedFlag scale .6 rotate y*180 translate <.47,0,-1.21>*inch }
};


#include "bmpeople.inc"
#include "infantry.inc"
#declare BM_Gender = Male;
#declare MIL_Officer = false;
#declare MIL_Rifle = true;
#declare MIL_Sidearm = false;
#include "military.cdf"

#declare RedInfantry = union{
    Blob_Man(Male, 2*inch)
    object{BlobMan transform BMO_Foot_R rotate y*180 translate x*.25*inch+y*.1*inch}
    object{RedFlag scale <.6,.8,.6> rotate y*180 translate z*-.6*inch }
    union{
        cylinder{<0,0,0>,<0,.1,0>*inch, .5*inch}
        torus{.5*inch,.05*inch translate y*.05*inch}
        translate z*-.2*inch
        pigment{rgb <0,.3,0>}
    }
}

#declare BlueInfantry = union{
    Blob_Man(Male, 2*inch)
    object{BlobMan transform BMO_Foot_R rotate y*180 translate x*.25*inch+y*.1*inch}
    object{BlueFlag scale <.6,.8,.6> rotate y*180 translate z*-.6*inch }
    union{
        cylinder{<0,0,0>,<0,.1,0>*inch, .5*inch}
        torus{.5*inch,.05*inch translate y*.05*inch}
        translate z*-.2*inch
        pigment{rgb <0,.3,0>}
    }
}

#ifndef(included)

    #debug vstr(3,max_extent(RedInfantry),",",6,6) #debug "\n"
    #debug vstr(3,min_extent(RedInfantry) ,",",6,6) #debug "\n"

    object{RedFlag translate x*1*inch}
    object{BlueFlag translate x*-1*inch}

    object{Humvee translate z*5*inch}
    object{M1A2 translate z*5*inch+x*4*inch}
    object{T80 translate z*5*inch+x*-4*inch}
    
    object{RedInfantry translate z*8*inch+x*-2*inch}
    object{BlueInfantry translate z*8*inch+x*2*inch}
    
    camera{location <10,10,20>*inch look_at 0}
    light_source{10*feet, 1}
    plane{y, 0 pigment{checker rgb .8 rgb .6} scale 1*inch}
#end    
 

