#include "orchidee.inc"	
#include "petale.inc" 
#include "ruban.inc" 

#macro fleur (couleur)  // fleur + tige (couleur de la fleur)
union {
object {orchidee 
        pigment {
                cylindrical
                color_map {
                        [0 color couleur]
                        [0.3 color couleur]
                        [0.6 color couleur*2]
                        [0.8 color <1,1,1>]
                        [1 color <1,1,0>]} 
                translate -0.1*z}
        scale 4 rotate 90*y rotate 60*z}
intersection {
        torus { 1 , 0.01 pigment { color < 0 , 0.7 , 0 > } rotate 90*x } 
        prism {   linear_sweep  linear_spline  -0.5,  0.5,   4, < 2, -1>, <2, 2>, < 0, 0>, < 2,  -1> rotate -90*x  }
scale 15 translate <-9.5,-11.2,0>}
translate y 
}
# end

// **********************************************************************
// *********    texture des seau en fer rouills          ***************
// **********************************************************************

#if (vitesse = 1)   
#declare seau_en_fer = texture  {  pigment {color <1,1,1>}}
#else 
#declare seau_en_fer =  texture  {  bumps   texture_map   {
            [0.0  pigment   {  granite   color_map
                  {  [ 0.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]
                     [ 0.4     rgbft <0.7, 0.13, 0.0, 0.0, 0.0> ]
                     [ 0.5     rgbft <0.69, 0.41, 0.08, 0.0, 0.0> ]
                     [ 0.6     rgbft <0.49, 0.31, 0.28, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.89, 0.51, 0.28, 0.0, 0.0> ]  }   }               
               finish  {  ambient 0.2   diffuse 0.4   crand 0.2   }
            ]
            [0.3   
               pigment  {   color rgb <0.658824, 0.658824, 0.658824>  }               
               normal {   bumps , 0.16  scale  2.0   }               
               finish  {  ambient 0.3
                  diffuse 0.7
                  brilliance 8.0
                  specular 0.8
                  roughness 0.1
                  reflection 0.15   }
            ]
            [1.0   
               pigment   {  color rgb <0.658824, 0.658824, 0.658824>   }               
               normal  {  bumps , 0.16   scale  2.0 }               
               finish  {  ambient 0.3
                  diffuse 0.7
                  brilliance 8.0
                  specular 0.8
                  roughness 0.1
                  reflection 0.15  }
            ] } } 
#end


// **********************************************************************
// *********                 fleurs en seau               ***************
// ********************************************************************** 

// ****************** pot  dominante rouge
#declare potdefleur = union {    
object {fleur (<246,75,80>/255) translate -10*x translate 1*y}  
object {fleur (<200,70,90>/255) translate -10*x rotate 25*y translate 1*y}
object {fleur (<216,80,80>/255) translate -10*x rotate 60*y translate 1.5*y}  
object {fleur (<210,60,90>/255) translate -10*x rotate 85*y translate 0*y}
object {fleur (<255,80,75>/255) translate -10*x rotate 120*y translate 2*y}
object {fleur (<220,100,80>/255) translate -10*x rotate 180*y translate 1*y}
object {fleur (<186,90,100>/255) translate -10*x rotate 205*y translate 0.5*y}
object {fleur (<200,80,100>/255) translate -10*x rotate 245*y translate 1*y} 
object {fleur (<186,95,80>/255) translate -10*x rotate 280*y translate 0.5*y}
object {fleur (<186,70,70>/255) translate -10*x rotate 320*y translate 1.5*y} 

object {fleur (<180,70,80>/255) translate <-6,3,0> rotate 10*y translate 1.5*y} 
object {fleur (<200,85,70>/255) translate <-6,3,0> rotate 75*y translate 0*y}
object {fleur (<195,90,100>/255) translate <-6,3,0> rotate 130*y translate 1.5*y}
object {fleur (<240,105,95>/255) translate <-6,3,0> rotate 180*y translate 2*y}
object {fleur (<180,80,60>/255) translate <-6,3,0> rotate 230*y translate 1.5*y}  
object {fleur (<210,95,80>/255) translate <-6,3,0> rotate 290*y translate 1*y}
object {fleur (<190,70,80>/255) translate <-6,3,0> rotate 330*y translate 0.5*y}    

object {fleur (<195,75,75>/255) translate <-0,6,0> rotate 156*y translate 0.5*y}    

union {
        torus { 10 , 0.2  }
        torus { 9+10/16 , 0.2  translate -6*y} 
        torus { 9 , 0.2  translate -16*y}
        cone { < 0 , 0 , 0 > , 10 , < 0 , -16, 0 > , 9  open } 
texture {seau_en_fer} }
}  

  
// ****************** pot  dominante violette

#declare potdefleur2 = union {    
object {fleur (<186,95,150>/255) translate -10*x translate 0*y}  
object {fleur (<200,90,140>/255) translate -10*x rotate 25*y translate 0.5*y}
object {fleur (<186,80,160>/255) translate -10*x rotate 60*y translate 1.5*y}  
object {fleur (<210,130,160>/255) translate -10*x rotate 85*y translate 0.5*y}
object {fleur (<255,80,145>/255) translate -10*x rotate 120*y translate 1*y}
object {fleur (<220,100,200>/255) translate -10*x rotate 180*y translate 0.5*y}
object {fleur (<186,90,170>/255) translate -10*x rotate 205*y translate 0*y}
object {fleur (<200,120,150>/255) translate -10*x rotate 245*y translate 1.5*y} 
object {fleur (<186,95,170>/255) translate -10*x rotate 280*y translate 0*y}
object {fleur (<186,70,160>/255) translate -10*x rotate 320*y translate -0.5*y} 

object {fleur (<180,70,150>/255) translate <-6,3,0> rotate 10*y translate 0*y} 
object {fleur (<200,105,160>/255) translate <-6,3,0> rotate 75*y translate 0.5*y}
object {fleur (<195,90,150>/255) translate <-6,3,0> rotate 130*y translate 1*y}
object {fleur (<240,155,145>/255) translate <-6,3,0> rotate 180*y translate -0.5*y}
object {fleur (<180,120,150>/255) translate <-6,3,0> rotate 230*y translate 1.5*y}  
object {fleur (<210,95,190>/255) translate <-6,3,0> rotate 290*y translate -0*y}
object {fleur (<190,120,200>/255) translate <-6,3,0> rotate 330*y translate 1*y}    

object {fleur (<200,120,220>/255) translate <-0,6,0> rotate 230*y translate 1*y}

union {
        torus { 10 , 0.2  }
        torus { 9+10/16 , 0.2  translate -6*y} 
        torus { 9 , 0.2  translate -16*y}
        cone { < 0 , 0 , 0 > , 10 , < 0 , -16, 0 > , 9  open } 
texture {seau_en_fer} }
}
                                              
// ****************** pot  dominante blanche                                              
                                              
#declare potdefleur3 = union {    
object {fleur (<186,205,190>/255) translate -10*x translate 0*y}  
object {fleur (<200,210,180>/255) translate -10*x rotate 25*y translate 0.5*y}
object {fleur (<220,195,170>/255) translate -10*x rotate 60*y translate 1.5*y}  
object {fleur (<210,185,160>/255) translate -10*x rotate 85*y translate 0.5*y}
object {fleur (<255,230,175>/255) translate -10*x rotate 120*y translate 1*y}
object {fleur (<220,190,200>/255) translate -10*x rotate 180*y translate 0.5*y}
object {fleur (<186,195,170>/255) translate -10*x rotate 205*y translate 0*y}
object {fleur (<200,200,150>/255) translate -10*x rotate 245*y translate 1.5*y} 
object {fleur (<186,190,190>/255) translate -10*x rotate 280*y translate 0*y}
object {fleur (<236,220,160>/255) translate -10*x rotate 320*y translate 0.5*y} 

object {fleur (<180,169,180>/255) translate <-6,3,0> rotate 10*y translate 0*y} 
object {fleur (<200,175,170>/255) translate <-6,3,0> rotate 75*y translate 0.5*y}
object {fleur (<195,185,180>/255) translate <-6,3,0> rotate 130*y translate 1.5*y}
object {fleur (<240,195,185>/255) translate <-6,3,0> rotate 180*y translate 2*y}
object {fleur (<230,180,210>/255) translate <-6,3,0> rotate 230*y translate 1.5*y}  
object {fleur (<210,195,200>/255) translate <-6,3,0> rotate 290*y translate 0.5*y}
object {fleur (<240,180,160>/255) translate <-6,3,0> rotate 330*y translate 1*y}    

object {fleur (<240,200,190>/255) translate <-0,6,0> rotate 78*y translate 1*y}

union {
torus { 10 , 0.2  }
torus { 9+10/16 , 0.2  translate -6*y} 
torus { 9 , 0.2  translate -16*y}                             
cone { < 0 , 0 , 0 > , 10 , < 0 , -16, 0 > , 9  open }texture  {seau_en_fer}}
}


// **********************************************************************
// *********               colliers de fleurs             ***************
// **********************************************************************    
#declare tier = intersection{
union{
sphere {  <0, 0, 0>   1  scale <1,1,0.3> } 
sphere {  <0, 0, 0>   1  scale <1.2,0.3,0.3>  translate -0.8*y}}
box { < 0 , -2 , -2 >  < -1 , 2 , 2 >  }
 }

#declare blanc = union{
object {tier } 
object {tier rotate 120*y} 
object {tier rotate -120*y} pigment {color <1,1,1>}  } 

#macro demi_collier (v1 , v2 , v3 , v4 , couleur)
union{

object {blanc translate 17.5*y rotate rand(seed(v1))*120*y}
object {blanc translate 15.5*y rotate rand(seed(v2))*120*y}            
object {blanc translate 13.5*y rotate rand(seed(v3))*120*y}
object {blanc translate 11.5*y rotate rand(seed(v4))*120*y}  

object {blanc translate 9.5*y rotate -15*y pigment { color <0.8,0,0.3>}} 

object {fleur1 scale 4 rotate -90*z translate 8*y rotate rand(seed(v1*v2))*90*y}

object {blanc translate 4*y rotate rand(seed(v3*v4))*120*y}
object {blanc translate 2*y rotate rand(seed(v1*v3))*120*y}
object {blanc} 

object {orchidee 
pigment {
  cylindrical
  color_map {
    [0 color couleur]
    [0.3 color couleur]
    [0.6 color couleur*2]
    [0.8 color <1,1,1>]
    [1 color <1,1,0>]
    
  } translate -0.1*z
}scale 4 rotate 90*z rotate (rand(seed(v2*v3))*90+45)*y}

object {blanc translate -2*y rotate rand(seed(v1*v2*v3))*120*y}
object {blanc translate -4*y rotate rand(seed(v2*v3*v4))*120*y}
object {blanc translate -6*y rotate rand(seed(v1*v3*v4))*120*y}    

sphere {  <0, -8, 0>   1   pigment { gradient y 
pigment_map { [0 color <0,0.3,0>]
              [0.3 color <0,0.3,0>]
              [0.3 color <0.8,0,0.3>]
              [1 color <0.8,0,0.3>]
} scale 2 translate 1*y turbulence 0.5} }   


}
#end        

// **********************************************************************
// *********    macro creatrice de colliers d'orchides   ***************
// ********************************************************************** 
#macro collier  (v1 , v2 , v3 , v4, couleur)

union {object { demi_collier (v1 , v2 , v3 , v4, couleur) translate -1*x }
object { demi_collier (v1*v1 , v2*v2 , v3*v3 , v4*v4, couleur)  translate 1*x }
object {ruban pigment { color <1.5,0.5,0.5> } scale 3*<0.7,1,1> rotate -90*x rotate 45*y translate <0,18,0>}   
rotate rand(seed(v1*v1-v2*v2))*45*y}        

#end 


// **********************************************************************
// *********       etallage de colliers d'orchides       ***************
// **********************************************************************
#declare etal = union {
object { collier (1,2,3,58,     <186,75,100>/255)}
object { collier (48,38,7,8,    <190,53,100>/255) translate <4,0,0>}  
object { collier (9,74,7,78,    <150,53,136>/255) translate <8,-1,0>}
object { collier (78,9,55,8,    <180,100,136>/255) translate <12,-0.5,0>}
object { collier (10,1,9,587,   <186,53,200>/255) translate <16,1,0>}
object { collier (5,74,7,14,    <156,110,150>/255) translate <-4,1,0>}  
object { collier (85,74,7,87,   <150,83,136>/255) translate <-8,0,0>}
object { collier (78,9,55,81,   <206,100,146>/255) translate <-12,-2,0>}
object { collier (10,1,9,587,   <210,53,200>/255) translate <-16,1,0>}  
} 


#declare feuillemorte = intersection { 
union { 
difference {
        sphere {  <0, 0, 0>   2  scale <1,1,1> } 
        sphere {  <0, 0, 0>   2  scale 0.97 } } 
torus { 2 , 0.05 rotate 90*z} // rayon moyen , rayon de la section
 } 
sphere {  <0, 0, 0>   2  scale <1,1,1> translate <1,1,0> }  
sphere {  <0, 0, 0>   2  scale <1,1,1> translate <-1,1,0>}  
pigment {color <0,0.4,0>}
no_shadow  }



