#version unofficial MegaPov 0.7;
#include "colors.inc"
#include "textures.inc"

camera {
	location <0, 2, -15>
	up <0,4/3,0>
	right <1,0,0>
	look_at <0, 4, 0>
	angle 35
}
        
light_source { <-5, 25, -10> color  White}
background {color<0.3,0.6,0.8>}
sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0 rgb <0.8,0.8,0.9> ]
			[ 0.5 rgb <0.5,0.5,0.6> ]
		}
	}
}

box { <-24,-1,-24>, <6,0,6>
	pigment {
	        image_map {
	                   tga "weathered3.tga"
	                   map_type 0
	                   interpolate 2	                   	                   
	        }
	        rotate 90*x
	}
	finish {
	        diffuse 0.7
	        specular 0.65
	        roughness 0.001
	}
	normal {
                bump_map {
                          tga "weathered3bm.tga"
                          bump_size 0.001
                          map_type 0
                          interpolate 2                                                    
                }
                rotate 90*x
	}
}


////////////////////////////////////////////////////////
// Tree
////////////////////////////////////////////////////////

// Include the leaf definition and splinetree files
#include "leafdefs.inc"
#include "splinetree.inc"

#declare recursionmax = 6; // Defines the complexity of the tree
#declare divisions = array[6] {2,3,4,3,3,5}
init_rand (1079,936,127)     // Supply seeds to initialize the random variable

// Variables modeled exponentially
// Use: init_variable (start_size, end_size, base)
init_tdev (0.5, 0.8, 0.9)
init_rdev (60, 20, 1)
init_twigprob (0, 0.7, 0.5)
init_branchl (3.4, 0.2, 0.6)
init_branchw (0.65, 0.004, 0.4)

// Odd variables
init_roots (2)			// Use: init_roots (rootrecursionmax)
init_splinedev (0.15,0.5)	// Use: init_splinedev (min_dev, max_dev)
init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)

// Add some gravity
#declare tendancy = <-0.45,0.05,0.2>;

// Variables for leaves
#declare leafarray = array[3] {maple1,maple2,maple3}
#declare leafprob = array[3] {0.5,0.6,0.5}
#declare leafscale = array[3] {0.2,0.3,0.2}
#declare leafnoise = array[3] {1,1,1}

// Assign the branch texture
#declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc

// Define transformations assigned to the whole tree here.
#declare global_transform = transform {
	scale <1,1,1>
	rotate <0,0,0>
	translate <0.3,0.73,0>
}

// Provide feedback in the first 2 recursion levels
#declare feedback = 2;

// Call the macro
splinetree(0,75)

//Isosurface//

isosurface {function {"func_14" <1/1,2/1,1/2,0,1/1>}
                threshold 0.05
                accuracy 0.001       
                contained_by {box{-6,6}}
         pigment { color<0.8,0.6,0.2>}
         rotate <90,0,0>
         translate <-2,6,6>
         }
         
isosurface {function {"func_14" <1/1,2/1,1/2,0,1/1>}
                threshold 0.05
                accuracy 0.001       
                contained_by {box{-6,6}}
         pigment{color<0.8,0.6,0.2>}
         rotate <90,90,0>
         translate <4,6,0>
         }

isosurface {function {"lemniscate_of_gerono2d", <0.2,0.5,1,1,2,-45>}
                        sign -1
                        threshold 0
                        contained_by {sphere{0,3}}
                        texture {
                                pigment {color<0.2,0.2,0.5>}
                                finish {
                                        phong .03
                                        phong_size 98
                                        diffuse 0.6
                                        specular 0.7
                                }
                        }
                        translate <0,0.4,0>
}

//Screens///

box {
        <0,0,0>, <-24,12,-0.01> 
        pigment{color rgb <0.9,0.9,0.9>}
        translate <4,0,6>
}
box {
        <0,0,0>, <-.01,12,-24>
        pigment{color rgb <0.9,0.9,0.9>}
        translate <4,0,6>
}

box {
        <0,0,0>, <.25,12,.25>
        pigment { color<0.8,0.6,0.2>}
        translate <3.75,0,5.75>
}

sphere { <0,0,0>, 2.2
        pigment {
                image_map { tga "drock037.tga"
                                map_type 0
                                interpolate 2
                }
                rotate 90*x
                translate <0,.75,0>
        }
        normal {
                bump_map { tga "drock037.tga"
                           map_type 0
                           interpolate 2
                           bump_size 0.5
                           use_index
                }
        }
        scale <1,.5,1>
}

