// PsxController.inc

#declare IMPORT_SPATCH=on;
#declare test_psxcontroller_inc=off;

#include "cbasiatex.inc"
#include "shapes.inc"
#include "ManchePsxC.inc"

#declare RB=.5;
#declare CB=vlength(<0,0,2-RB>-<2-RB,0,0>);
#declare BoutonDir = union{
	box{<-3,-RB,-2+RB>,<0,-1,2-RB>}
	box{<-3+RB,0,-2+RB>,<0,-1,2-RB>}
	box{<-3+RB,-RB,-2>,<0,-1,2>}
	box{<0,-RB,-CB>,<CB,-1,RB> rotate y*45 translate <0,0,2-RB>}
	box{<0,0,-CB>,<CB,-1,0> rotate y*45 translate <0,0,2-RB>}
	box{<0,-RB, CB>,<CB,-1,-RB> rotate -y*45 translate <0,0,-2+RB>}
	box{<0,0, CB>,<CB,-1,0> rotate -y*45 translate <0,0,-2+RB>}
	cylinder{<-3+RB,-RB,2-RB>,<0,-RB,2-RB>,RB}
	cylinder{<-3+RB,-RB,-2+RB>,<0,-RB,-2+RB>,RB}
	cylinder{<-3+RB,-RB,2-RB>,<-3+RB,-RB,-2+RB>,RB}
	cylinder{<0,-RB,0>,<CB,-RB,0>,RB rotate y*45 translate <0,0,2-RB>}
	cylinder{<0,-RB,0>,<CB,-RB,0>,RB rotate -y*45 translate <0,0,-2+RB>}
	cylinder{<-3+RB,-RB,2-RB>,<-3+RB,-1,2-RB>,RB}
	cylinder{<-3+RB,-RB,-2+RB>,<-3+RB,-1,-2+RB>,RB}
	cylinder{<0,-RB,2-RB>,<0,-1,2-RB>,RB}
	cylinder{<0,-RB,-2+RB>,<0,-1,-2+RB>,RB}
	cylinder{<2-RB,-RB,0>,<2-RB,-1,0>,RB}
	sphere{<-3+RB,-RB,+2-RB>,RB}
	sphere{<-3+RB,-RB,-2+RB>,RB}
	sphere{<0,-RB,+2-RB>,RB}
	sphere{<0,-RB,-2+RB>,RB}
	sphere{<2-RB,-RB,0>,RB}
	scale <1/5,.8,.8/4>
	translate .25*y
}

#declare Stick=union{
	intersection{
		cylinder{<0,.1,0>,<0,-1.5,0>,1}
		sphere{0,3 scale<1,1/3,1> translate -y}
	}
	cylinder{<0,-.1,0>,<0,1,0>, .6/2}
	intersection{
		cylinder{<0,0,0>,<0,.51,0>,1}
		sphere{0,1 scale<1,.5,1>}
		translate y
	}
}

#declare PsxController=union{
	object{ ManchePsxC scale <1.1,1,1.1> translate 4.5*x}
	object{ ManchePsxC scale <-1.1,1,1.1> translate -4.5*x}
	// supports boutons
	difference{
		object{Round_Cylinder_Union(<0,.1,0>,<0,-.1,0>,4.4/2,.05)}
		union {
			box{<-3.8/2,.05,-1.4/2>,<3.8/2,.11,1.4/2>}
			box{<-1.4/2,.05,-3.8/2>,<1.4/2,.11,3.8/2>}
			texture{pigment {rgb .1}finish{phong 0.5 phong_size 70 reflection{.05}}}
		}
		translate 4.5*x
	}
	difference{
		object{Round_Cylinder_Union(<0,.1,0>,<0,-.1,0>,4.4/2,.05)}
		union {
			box{<-3.8/2,.05,-1.4/2>,<3.8/2,.11,1.4/2>}
			box{<-1.4/2,.05,-3.8/2>,<1.4/2,.11,3.8/2>}
			texture{pigment {rgb .1}finish{phong 0.5 phong_size 70 reflection{.05}}}
		}
		translate -4.5*x
	}
	// boutons
	object{Round_Cylinder_Union(<0,-.3,0>,<0,.2,0>,.5,.05)
		texture{
			pigment{image_pattern{png "carre"}translate -.5*x-.5*y rotate x*90 color_map{[.4 rgb .1][.6 color rgb <0.941,0.675,0.659>]}}
			finish{phong 0.5 phong_size 70}
		}
		translate <4.5-2.5/2,0,0>
	}
	object{Round_Cylinder_Union(<0,-.3,0>,<0,.2,0>,.5,.05)
		texture{
			pigment{image_pattern{png "rond"}translate -.5*x-.5*y rotate x*90 color_map{[.4 rgb .1][.6 color rgb <0.941,0.341,0.314>]}}
			finish{phong 0.5 phong_size 70}
		}
		translate <4.5+2.5/2,0,0>
	}
	object{Round_Cylinder_Union(<0,-.3,0>,<0,.2,0>,.5,.05)
		texture{
			pigment{image_pattern{png "triangle"}translate -.5*x-.5*y rotate x*90 color_map{[.4 rgb .1][.6 color rgb <0.000,0.698,0.482>]}}
			finish{phong 0.5 phong_size 70}
		}
		translate <4.5,0,2.5/2>
	}
	object{Round_Cylinder_Union(<0,-.3,0>,<0,.2,0>,.5,.05)
		texture{
			pigment{image_pattern{png "croix"}translate -.5*x-.5*y rotate x*90 color_map{[.4 rgb .1][.6 color rgb <0.502,0.702,0.729>]}}
			finish{phong 0.5 phong_size 70}
		}
		translate <4.5,0,-2.5/2>
	}
	// corps
	difference{
		object{Round_Box_Union(<-4.5,-.3,-2.5>,<4.5,0,2.5>,.1) scale <1,2/.3,1> translate -.1*y}
		box{<-.91/2,-1,-1.01>,<.91/2,.01,-.69>}
		box{<-1.4-.81/2,-1,-.21+.5>,<-1.4+.81/2,.01,.21+.5>}
		box{< 1.4-.81/2,-1,-.21+.5>,< 1.4+.81/2,.01,.21+.5>}
		texture{
			pigment {
				image_pattern{png "logo_control" once}
				rotate x*90 translate -.5*x-z
				scale <3*7/5,1,2.7>
				translate 2.2*z
				color_map{[0.4 rgb .1][.6 rgb .5]}
			}
			normal{N_blur(20, .2)}
			finish{phong 0.4 phong_size 70 reflection{.05}}
		}
	}
	// petits boutons
	union {
		object{Round_Box_Union(<-.9/2,-1,-1>,<.9/2,.15,-.7>,.05)}
		object{Round_Box_Union(<-1.4-.8/2,-1,-.2+.5>,<-1.4+.8/2,.15,.2+.5>,.05)}
		object{Round_Box_Union(< 1.4-.8/2,-1,-.2+.5>,< 1.4+.8/2,.15,.2+.5>,.05)}
		texture{pigment{rgb .2}normal{N_blur(20, .3)}finish{phong 0.1 phong_size 5}}
	}
	// boutons directionnels
	union{
		object{BoutonDir translate <-4.5-.7,0,0>}
		object{BoutonDir rotate y*90 translate <-4.5,0,.7>}
		object{BoutonDir scale <-1,1,1> translate <-4.5+.7,0,0>}
		object{BoutonDir rotate -y*90 translate <-4.5,0,-.7>}
		texture{pigment {rgb .2}normal{N_blur(20, .2)}finish{phong 0.2 phong_size 10 brilliance .9}}
	}
	// sticks analogiques
	difference{
		object{Round_Cylinder_Union(<2,.1,-2>,<2,-2.5,-2>,1.5,.1)}
		cylinder{<2,.11,-2>,<2,-0.5,-2>,1}
	}
	object{Stick translate <2,0,-2> texture{pigment {rgb .2}normal{N_blur(20, .3)}finish{phong 0.2 phong_size 5}}}
	difference{
		object{Round_Cylinder_Union(<-2,.1,-2>,<-2,-2.5,-2>,1.5,.1)}
		cylinder{<-2,.11,-2>,<-2,-0.5,-2>,1}
	}
	object{Stick translate <-2,0,-2> texture{pigment {rgb .2}normal{N_blur(20, .3)}finish{phong 0.2 phong_size 5}}}
	texture{pigment {rgb .1}normal{N_blur(20, .2)}finish{phong 0.4 phong_size 70 reflection{.05}}}
	rotate x*6 translate 3.2*y
}

#undef BoutonDir
#undef Stick
#undef ManchePsxC

//=============
// test scene
//=============
#if (test_psxcontroller_inc)

#declare Rad=off;

#declare Rad_count=200;
#declare Rad_error = 0.5;
#declare Rad_rec = 1;
#declare Rad_brigth = 2.0;
#declare Rad_bo = 0.05;
#declare Rad_max_sample = 5;

global_settings {
	max_trace_level 35
	adc_bailout 0.1
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.5
		minimum_reuse 0.02
		normal on

		max_sample Rad_max_sample
		adc_bailout Rad_bo
	}
#end
}



camera {
	location -0*z+2*y+30*x
	angle 40
	look_at 1*y
}

//light_source{<-.3, .01, -.1>*100, color rgb .7}
light_source{<3, 1.2, -1>*30, color rgb 1*<1,1,.95>
	area_light 5*x,5*y,2,2
	circular orient jitter adaptive 1
}

background{rgb<.6,.8,1>*.5}
plane{y,0 pigment{rgb 1}finish{diffuse .5}}

object{PsxController}

#end

