// cbasia.pov IRTC 12/2001

//===================================
//===================================
//      SETTINGS
//===================================
//===================================
#declare Camtest=off;

#declare Use_Sumo=off;
#declare Use_Karateka=off;
#declare Use_Geisha=off;

#declare Use_Tv=on;
#declare Use_PS2=on;
#declare Use_PS2control=on;

#declare Use_Bonsai=off;
#declare Use_Puzzle=on;
#declare Use_Tableaux=on;
#declare Use_Coussins=on;


#declare Rad=on;
#declare Area=on;
#declare AreaNb=4;

#declare Rad_count=400;
#declare Rad_error = .1;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.2;
#declare Rad_bo = 0.03;
#declare Rad_maxs = 2.0;

global_settings {
	max_trace_level 35
	adc_bailout 0.02
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
        error_bound Rad_error
        recursion_limit Rad_rec
        brightness Rad_brigth

        pretrace_start  1
        pretrace_end  1

        low_error_factor .5
        gray_threshold 0.2
        minimum_reuse 0.015
        normal on

        max_sample Rad_maxs
        adc_bailout Rad_bo
	}
#end
}

#if (Rad)
#default { texture { finish { ambient 0.0 diffuse 1.1 } } }
#else
#default { texture { finish { ambient .2 diffuse .8 } } }
light_source{<0,400, -600>, rgb <.8,.85,1>*.3 shadowless}
#end

#include "colors.inc"
#include "cbasiatex.inc"

//===================================
//===================================
//      ROOM DEFINITION
//===================================
//===================================

#declare X1min=-300;
#declare X1max= 200;
#declare X2max= 500;
#declare Y1min=   0;
#declare Y1max= 210;
#declare Y2max= 240;
#declare Z1min=-500;
#declare Z1max= 300;
#declare Z2max= 1000;

// left wall (concrete)
box{<X1min, Y1min-1, Z1min-1>,<X1min-10,Y2max+1, Z2max+1> texture{T_Concrete1}}
// right wall (concrete)
box{<X2max, Y1min-1, Z1min-1>,<X2max+10,Y2max+1, Z1max+1> texture{T_Concrete1}}
// background front wall (concrete)
box{<X1min-10, Y1min-1, Z2max>,<X1max+10,Y2max+1, Z2max+10> texture{T_Concrete1}}
// right foreground front wall (concrete)
box{<X1max, Y1min-1, Z1max>,<X2max+10,Y2max+1, Z2max+3> texture{T_Concrete1}}
box{<X1min-1, Y1max, Z1max>,<X2max+10,Y2max+1, Z2max+3> texture{T_Concrete1}}
// underlying floor (concrete)
box{<X1min-10, Y1min-1, Z1min-10>,<X2max+10,Y1min-2, Z2max+10> texture{T_Concrete1}}
// ceil (concrete)
box{<X1min-10, Y2max, Z1min-10>,<X2max+10,Y2max+1, Z2max+10> texture{T_Concrete1}}
// back wall (concrete)
box{<X1min-10, Y1min-1, Z1min>,<X2max+10,Y2max+1, Z1min-1> texture{T_Concrete1 finish{diffuse 2}}}


#include "cloisons.inc"
// left foreground front wall (concrete)
#declare St=seed(1342);
#declare TrPan=array[4];
#declare TrPan[0]=0;
#declare TrPan[1]=-.3;
#declare TrPan[2]=-3;
#declare TrPan[3]=-62.5;


//	PanCloison(Coin1, Coin2, Ep, R, Ec, Turb, St, Nbcx, Nbcy, Epc, EpRainure, HRainure)
//	PanCloison(<-3, 0, -.2>, <3,10,.2>, .4, .03, .005, .02, St, 1, 1, .15, .05, .06)

	Cloison(<X1min, Y1min, Z1max>, <X1max,Y1max,Z1max+2>, 6, .5, .02, .1, St, 3, 5, 3, .5, 1, 4, TrPan)


// plafond
#include "woods.inc"
#include "shapes.inc"
#declare PHt = 20;
/*
object{
	Round_Box_Union(<X1min-1, Y2max-PHt, Z1max-2>,<X2max+1, Y2max+1, Z1max+6>,.1)
	texture{T_Wood12 rotate y*89 translate y*Z1max/2}
}
*/
union{
#local i=1;
#while(i<12)
	Round_Box_Union(<X1min+i*(X2max-X1min)/13-5, Y2max-PHt+2, Z1min>,<X1min+i*(X2max-X1min)/13+5, Y2max+1, Z1max-1>,.1)
	#local i=i+1;
#end
	texture{T_Wood12 translate y*Z1max/2}
}


//===================================
//===================================
//      CHARACTERS
//===================================
//===================================
#if (Use_Sumo)
#include "sumo.inc"
object{Sumo scale<1,1,-1> translate <(X1min+X1max)/2-60, Y1min, Z1max+50>}
#end

#if (Use_Karateka)
#include "karateka.inc"
object{Karateka  translate <(X1min+X1max)/2-50, Y1min, Z1max+100>}
#end

#if (Use_Geisha)
#include "geisha.inc"
object {Geisha rotate y*88 translate <X1max-1,Y1min-.3,Z1max+4.5>}
#end

//===================================
//      TABLE
//===================================
#include "tables.inc"

#declare PosTable = <X1min+2+LgT2/2, Y1min, Z1max-190>;
object{TableBasse2 translate PosTable}

#if (Use_Bonsai)
#include "bonsai.inc"
union{
	#if (Bonsai_Tree)
	object{Bonsai scale .9 rotate -y*20 translate <1,(PotH-PotEp1/4),1>}
	#end
	object{PotBonsai}
	object{TerreBonsai translate (PotH-PotEp1*1.5)*y }
	#if (Bonsai_Mousse)
	object{MousseBonsai translate (PotH-PotEp1*1.5)*y }
	#end
	translate <X1min+35, Y1min+HtT2-DecT2, Z1max-190+LnT2*.15/2>
}

#if (Bonsai_Tree)
#undef Bonsai
#end
#undef PotBonsai
#undef TerreBonsai
#if (Bonsai_Mousse)
#undef MousseBonsai
#end

#end



//===========================
// table & tea
//===========================

object{TableBasse1 rotate y*89}

//========
// coussins
//========
#if (Use_Coussins)
#include "coussins.inc"
#include "functions.inc"
#declare Tex1=texture{
	pigment{image_map{jpeg "coussin1"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
#declare Tex2=texture{
	pigment{color rgb <38,116,152>/255}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(40, 40, 8, .5, 30, 30, function{f_noise3d(x*.1,y,z*.1)}, on, on, Tex1, Tex2, Tex2)
	rotate -y*100
	translate 62*x+4*z
}
#declare Tex1=texture{
	pigment{image_map{jpeg "coussin2"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
#declare Tex2=texture{
	pigment{color rgb <59,91,140>/255}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(40, 40, 8, .5, 30, 30, function{f_noise3d(x*.1+2,y,z*.1+5)}, on, on, Tex1, Tex2, Tex2)
	rotate y*4
	translate -65*x-2*z
}
#end

//========
// the
//========
#include "tea.inc"

object{TeaCup rotate y*10 translate <-26,HtT1-DecT1,-2>}
object{TeaCup rotate -y*70 translate <29,HtT1-DecT1, 2>}
object{TeaPot rotate y*15 translate <7, HtT1-DecT1, 22>}


//===================================
//      COIN TELE
//===================================
#if (Use_Tv)
#include "tele.inc"
object{Tele translate <X1max+120,Y1min,Z1max-50>}
#undef Tele

#if (Use_Puzzle)
#include "puzzle.inc"
object{Puzzle rotate -y*19 translate <X1max+110, Y1min+PuzHaut+TeleHaut, Z1max-40>}
#undef Puzzle
#end

#end

#if (Use_PS2)
#include "ps2.inc"

#declare PS2Trans = transform{rotate z*90 translate <PS2Ht/2, HtSup+.01,-PS2Lrg*.15>}

#if (Use_PS2control)
#include "PsxController.inc"

#declare PosConn = <PS2Lng*.1+ConLng/2,PS2Ht*(.45+2.2*.55/11),0>;

#declare Point0 = vtransform(PosConn, PS2Trans);
#declare Point1 = vtransform(PosConn-ConLrg*z, PS2Trans);
#declare Point2 = -(ConLrg+2)*z;#declare Point2 = vrotate(Point2,<0,5,0>);#declare Point2=Point2+PosConn;
#declare Point2 = vtransform(Point2, PS2Trans);
#declare Point3 = -(ConLrg+2+BlinLng)*z;#declare Point3 = vrotate(Point3,<0,5,0>);#declare Point3=Point3+PosConn;
#declare Point3 = vtransform(Point3, PS2Trans);
#declare Point4 = -(ConLrg+2+BlinLng*2)*z;#declare Point4 = vrotate(Point4,<0,15,0>);#declare Point4=Point4+PosConn;
#declare Point4 = vtransform(Point4, PS2Trans);
#declare Point5 = <-6, BlinR*.3+.2, -15>;
#declare Point6 = <0, BlinR*.3+.1, -20>;
#declare Point7 = <6, BlinR*.3, -25>;
#declare Point8 = <16, BlinR*.3+.1, -30>;
#declare Point9 = <26, BlinR*.3, -18>;
#declare Point10 = <22, BlinR*.3, -10>;
#declare Point11 = <30, BlinR*.3+.2, -1>;
#declare Point12 = <35, BlinR*.3, -10>;
#declare Point13 = <32, BlinR*.3+.1, -30>;
#declare Point14 = <26, BlinR*.3+.2, -20>;
#declare Point15 = <25, BlinR*.3+.4, -10>;
#declare Point16 = <18, BlinR*.3+.2, -1>;
#declare Point17 = <13.5, BlinR*.3+1, -10>;
#declare Point18 = <12, 2, -12>;

#end

union{
	object{SupportPS2}
	object{PS2 transform{PS2Trans}}
	#if (Use_PS2control)
	object{PsxController rotate y*35 translate <12,0,-12>}
	union{
		object{ConnecteurPsx}
		object{BlindageConnecteurPsx translate -(ConLrg+2)*z rotate y*5 }
		translate PosConn
		rotate z*90 translate <PS2Ht/2, HtSup+.01,-PS2Lrg*.15>
	}
	sphere_sweep{
		catmull_rom_spline
		19,
		Point0,BlinR*.3
		Point1,BlinR*.3
		Point2,BlinR*.3
		Point3,BlinR*.3
		Point4,BlinR*.3
		Point5,BlinR*.3
		Point6,BlinR*.3
		Point7,BlinR*.3
		Point8,BlinR*.3
		Point9,BlinR*.3
		Point10,BlinR*.3
		Point11,BlinR*.3
		Point12,BlinR*.3
		Point13,BlinR*.3
		Point14,BlinR*.3
		Point15,BlinR*.3
		Point16,BlinR*.3
		Point17,BlinR*.3
		Point18,BlinR*.3
	}
	texture{pigment{rgb .4}normal{N_blur(5, .2)}finish{phong 0.4 phong_size 40}}
	#end
	rotate -y*1.5
	translate <X1max+50,Y1min,Z1max-70>
}

#undef SupportPS2
#undef PsxController
#undef PS2
#undef ConnecteurPsx
#undef BlindageConnecteurPsx 

// cables
sphere_sweep{
	catmull_rom_spline
	8,
	<X1max+50, Y1min, Z1max-70>+<0,6,20>,.3
	<X1max+50, Y1min, Z1max-70>+<0,6,25>,.3
	<X1max+50, Y1min, Z1max-70>+<-2,4,30>,.3
	<X1max+50, Y1min, Z1max-70>+<5,2,29>,.3
	<X1max+50, Y1min, Z1max-70>+<10,1,31>,.3
	<X1max+50, Y1min, Z1max-70>+<20,.5,30>,.3
	<X1max+50, Y1min, Z1max-70>+<40,.6,32>,.3
	<X1max+50, Y1min, Z1max-70>+<60,.3,33>,.3
	texture{pigment{rgb .2}normal{N_blur(5, .2)}finish{phong 0.6 phong_size 20}}
}

sphere_sweep{
	catmull_rom_spline
	8,
	<X1max+50, Y1min, Z1max-70>+<0,10,20>,.4
	<X1max+50, Y1min, Z1max-70>+<0,10,25>,.4
	<X1max+50, Y1min, Z1max-70>+<-4,6,30>,.4
	<X1max+50, Y1min, Z1max-70>+<2,3,32>,.4
	<X1max+50, Y1min, Z1max-70>+<8,1,30>,.4
	<X1max+50, Y1min, Z1max-70>+<15,.5,31>,.4
	<X1max+50, Y1min, Z1max-70>+<30,.6,33>,.4
	<X1max+50, Y1min, Z1max-70>+<60,.3,32>,.4
	texture{pigment{rgb .2}normal{N_blur(5, .2)}finish{phong 0.6 phong_size 20}}
}

#end


//===================================
//      TATAMIS
//===================================
#include "tatamis.inc"
#declare Stt=seed(1342);
//	Tatami(Coin1, Coin2, Epbord, Epb, St)

#declare Taille1=(X2max-X1min)/5;
#declare Taille2=.99*Taille1;
#declare Coin1=<-Taille2/4, Y1min-1, -Taille2/2>;
#declare Coin2=< Taille2/4, Y1min,  Taille2/2>;


#local j=0;
#while (j<4)
	#local i=0;
	#while(i<(5-j))
		object{ Tatami(Coin1, Coin2, 3, 3, Stt)
			rotate y*(2*rand(Stt)-1)
			rotate y*90
			translate <(2*i+1+j)*Taille1/2+X1min, 0, Z1max-(2*j+1)*Taille1/4>
		}
		object{ Tatami(Coin1, Coin2, 3, 3, Stt)
			rotate y*(2*rand(Stt)-1)
			rotate y*90
			translate <(2*i+1+j)*Taille1/2+X1min, 0, Z1max-4*Taille1+(2*j+1)*Taille1/4>
		}
		#local i=i+1;
	#end
	#local j=j+1;
#end


#local j=0;
#while (j<3)
	#local i=0;
	#while(i<(3-j))
		object{ Tatami(Coin1, Coin2, 3, 3, Stt)
			rotate y*(2*rand(Stt)-1)
			translate <(2*j+1)*Taille1/4+X1min, 0, Z1max-(2*i+2+j)*Taille1/2>
		}
		object{ Tatami(Coin1, Coin2, 3, 3, Stt)
			rotate y*(2*rand(Stt)-1)
			translate <X2max-(2*j+1)*Taille1/4, 0, Z1max-(2*i+2+j)*Taille1/2>
		}
		#local i=i+1;
	#end
	#local j=j+1;
#end


#declare Taille1=(Z2max-Z1max-5)/5;
#declare Taille2=.99*Taille1;
#declare Coin1=<-Taille2/4, Y1min-1, -Taille2/2>;
#declare Coin2=< Taille2/4, Y1min,  Taille2/2>;


#local j=0;
#while (j<2)
	#local i=0;
	#while(i<(4-j))
		object{ Tatami(Coin1, Coin2, 3, 3, Stt)
			rotate y*(2*rand(Stt)-1)
			translate <-(2*j+1)*Taille1/4+X1max, 0, Z1max+5+(2*i+2+j)*Taille1/2>
		}
		#local i=i+1;
	#end
	#local j=j+1;
#end

object{ Tatami(Coin1, Coin2, 3, 3, Stt)
	rotate y*(90+2*rand(Stt)-1)
	translate <-Taille1/2+X1max, 0, Z1max+5+Taille1/4>
}
object{ Tatami(Coin1, Coin2, 3, 3, Stt)
	rotate y*(90+2*rand(Stt)-1)
	translate <-Taille1+X1max, 0, Z1max+5+Taille1*3/4>
}
object{ Tatami(Coin1, Coin2, 3, 3, Stt)
	rotate y*(90+2*rand(Stt)-1)
	translate <-Taille1/2+X1max, 0, Z2max-Taille1/4>
}
object{ Tatami(Coin1, Coin2, 3, 3, Stt)
	rotate y*(90+2*rand(Stt)-1)
	translate <-Taille1+X1max, 0, Z2max-Taille1*3/4>
}

//===================================
//      TABLEAUX
//===================================
#if (Use_Tableaux)
#include "icons.inc"
#include "woods.inc"

object {
	Icone(120, 120*300/450, 3, 1, "greatwave_450x300", T_Wood8)
	rotate -.5*x rotate z*.1
	translate <X1max+110, Y1max-100, Z1max>
}

object {
	Icone(50, 50*720/460, 3, 1, "paysage1_460x720", T_Wood25)
	rotate -.5*x rotate -z*.2
	translate <X1max+30, Y1max-140, Z1max>
}

object {
	Icone(30, 30*680/180, 3, 1, "geisha2_180x680", T_Wood22)
	rotate -.5*x rotate z*.1 rotate -90*y
	translate <X1min, Y1max-150, Z1max-75>
}

object {
	Icone(60, 60*650/450, 3, 1, "geisha_450x650", T_Wood25)
	rotate -.5*x rotate -z*.1 rotate -90*y
	translate <X1min, Y1max-110, Z1max-170>
}

object {
	Icone(80, 80*464/426, 3, 1, "sabre_426x464", T_Wood8)
	rotate -.5*x rotate -z*.1 rotate 90*y
	translate <X1max, Y2max-140, Z1max+270>
}

#end

//===================================
//===================================
//      LIGHT AND CAMERA
//===================================
//===================================
#if (Camtest)
camera {
	location <-20, 85, Z1min+.1>
	right x*2.5
	up y
	angle 50
	look_at <0, 86, Z1max>
}
#else
camera {
	location <-20, 85, Z1min+.1>
	right x*2.5
	up y
	angle 50
	look_at <0, 86, Z1max>
}
#end

/*
light_source {<X1min+10, Y1min+10, Z1max-10-1>, color rgb <1,1,.85>*1.5 fade_distance Y1max/1.5 fade_power 2}
light_source {<X2max-10, Y1min+10, Z1max-10-3>, color rgb <1,1,.85>*1.5 fade_distance Y1max/1.5 fade_power 2}
light_source {<(X1min+X1max)/2, Y1min+10, Z2max-10>, color rgb <1,1,.85>*1.5 fade_distance Y1max/1.5 fade_power 2}
*/
#include "cubes.inc"
//	LampeCube(Cote, Ep, Ec, Col, Area, Lga, Nba, Media, Nbs, Mepint, Mepext, Fdist, Fpow)
object{
	LampeCube(50, 3, .1, <1,1,.9>*1.5, Area, 30, AreaNb, on, 4, .2, .05, (Z1max-Z1min)*1.2, 1)
	translate <X1min+26,Y1min+25,Z1max-26>
}
/*
object{
	LampeCube(50, 3, .1, <1,1,.9>*1.5, Area, 30, AreaNb, on, 4, .4, .15, Y1max*1.5, 2)
	translate <X2max-26,Y1min+25,Z1max-30>
}
*/
/*
object{
	LampeCube(50, 3, .1, <1,1,.9>*1.8, Area, 30, AreaNb, off, 4, .4, .15, (Z2max-Z1max)*1.5, 1)
	translate <(X1min+X1max)/2,Y1min+25+30,Z2max-26>
}
*/
light_source{<(X1min+X1max)/2,Y1max-60,Z2max-5>, color rgb <1,1,.9>*1.0
	fade_distance (Z2max-Z1max)*1.5 fade_power 1
	#if (Area)
		area_light 30*x,30*y,AreaNb,AreaNb
		circular orient jitter adaptive 1
	#end
}

/*
object{
	LampeCube(30, 3, .1, <1,1,.9>*1.7, Area, 20, AreaNb, on, 4, .4, .15, (Z2max-Z1max), 1)
	translate <X1min+16,Y1min+15,Z2max-16>
}
object{
	LampeCube(30, 3, .1, <1,1,.9>*1.7, Area, 20, AreaNb, on, 4, .4, .15, (Z2max-Z1max), 1)
	translate <X1max-16,Y1min+15,Z2max-16>
}
*/
