// cloisons.inc


#declare test_cloisons_inc = off;


#declare T_RicePaper1 = texture {
	pigment{
		bozo scale .5
		color_map {
			[0 rgb <.99,.98,.97>]
			[1 rgb <.99,.98,.97>*.9]
		}
	}
	normal{bozo .6}
	finish{diffuse .6 brilliance .8}
}

#declare T_RicePaper2 = texture {
	pigment{
		bozo scale .5
		color_map {
			[0 rgb <.99,.98,.97>]
			[1 rgb <.99,.98,.97>*.9]
		}
	}
	normal{bozo .6}
	finish{diffuse 0.7 brilliance 1}
}

#declare T_MontantC = texture {
	pigment{
		wood rotate x*90 frequency 5 warp{turbulence .05}
		color_map{
			[.1 color rgb <0.361,0.243,0.055>]
			[.9 color rgb <0.620,0.467,0.318>]
		}
	}
	normal{
		pigment_pattern{wood rotate x*90 frequency 7 warp{turbulence .1} scale <1,5,1> color_map{[0 rgb 0][1 rgb 1]}}
		slope_map{[.9 <1,0>][.91 <1,-3>][.99 <0,-3>][.99 <1,0>]}
	}
	finish{brilliance .95 specular .3 roughness .01}
}

#include "shapes.inc"

#macro PanCloison(Coin1, Coin2, Ep, R, Ec, Turb, St, Nbcx, Nbcy, Epc, EpRainure, HRainure)

#local Minx=min(Coin1.x, Coin2.x);
#local Miny=min(Coin1.y, Coin2.y);
#local Minz=min(Coin1.z, Coin2.z);
#local Maxx=max(Coin1.x, Coin2.x);
#local Maxy=max(Coin1.y, Coin2.y);
#local Maxz=max(Coin1.z, Coin2.z);

union {
	intersection{
		Round_Box_Union(<Minx, Miny, Minz>,<Minx+Ep, Maxy, Maxz>,R)
		plane{ y,0 rotate -z*45 translate <Minx, Maxy,0>+<-Ec, -Ec,0>}
		plane{-y,0 rotate  z*45 translate <Minx, Miny,0>+<-Ec, +Ec,0>}
		texture{T_MontantC scale Ep translate (10+10*rand(St))*Ep*x }
		translate Turb*(2*rand(St)-1)*z
	}
	intersection{
		Round_Box_Union(<Maxx-Ep, Miny, Minz>,<Maxx, Maxy, Maxz>,R)
		plane{ y,0 rotate  z*45 translate <Maxx, Maxy,0>+<+Ec, -Ec,0>}
		plane{-y,0 rotate -z*45 translate <Maxx, Miny,0>+<+Ec, +Ec,0>}
		texture{T_MontantC scale Ep translate (10+10*rand(St))*Ep*x }
		translate Turb*(2*rand(St)-1)*z
	}
	difference {
		intersection{
			Round_Box_Union(<Minx, Miny, Minz>,<Maxx, Miny+Ep, Maxz>,R)
			plane{ y,0 rotate  z*45 translate <Minx, Miny,0>+<+Ec, -Ec,0>}
			plane{ y,0 rotate -z*45 translate <Maxx, Miny,0>+<-Ec, -Ec,0>}
			texture{T_MontantC scale Ep rotate z*90 translate (10+10*rand(St))*Ep*y }
			translate Turb*(2*rand(St)-1)*z
		}
		box{<Minx-.01, Miny-.01, -EpRainure/2+(Minz+Maxz)/2>, <Maxx+.01, Miny+HRainure, +EpRainure/2+(Minz+Maxz)/2>}
	}
	difference {
		intersection{
			Round_Box_Union(<Minx, Maxy-Ep, Minz>,<Maxx, Maxy, Maxz>,R)
			plane{-y,0 rotate -z*45 translate <Minx, Maxy,0>+<+Ec, +Ec,0>}
			plane{-y,0 rotate  z*45 translate <Maxx, Maxy,0>+<-Ec, +Ec,0>}
			texture{T_MontantC scale Ep rotate z*90 translate (10+10*rand(St))*Ep*y }
			translate Turb*(2*rand(St)-1)*z
		}
		box{<Minx-.01, Maxy+.01, -EpRainure/2+(Minz+Maxz)/2>, <Maxx+.01, Maxy-HRainure, +EpRainure/2+(Minz+Maxz)/2>}
	}
	#if (Nbcx>1)
		#local Lngx=(Maxx-Minx-2*Ep)/Nbcx;
		#local Startx=Minx+Ep+Lngx;
		#local i=1;
		#while(i<Nbcx)
			box{<Startx-Epc/2,Miny+Ep,-Epc/2+(Minz+Maxz)/2>,<Startx+Epc/2,Maxy-Ep,+Epc/2+(Minz+Maxz)/2> texture{T_MontantC}}
			#local Startx=Startx+Lngx;
			#local i=i+1;
		#end
	#end

	#if (Nbcy>1)
		#local Lngy=(Maxy-Miny-2*Ep)/Nbcy;
		#local Starty=Miny+Ep+Lngy;
		#local i=1;
		#while(i<Nbcy)
			box{<Minx+Ep,Starty-Epc/2,-Epc/2+(Minz+Maxz)/2>,<Maxx-Ep,Starty+Epc/2,+Epc/2+(Minz+Maxz)/2> texture{T_MontantC rotate z*90}}
			#local Starty=Starty+Lngy;
			#local i=i+1;
		#end
	#end
/*
	union {
		triangle{<Minx+Ep, Miny+Ep, (Minz+Maxz)/2>,<Maxx-Ep, Miny+Ep, (Minz+Maxz)/2>,<Maxx-Ep, Maxy-Ep, (Minz+Maxz)/2>}
		triangle{<Minx+Ep, Miny+Ep, (Minz+Maxz)/2>,<Minx+Ep, Maxy-Ep, (Minz+Maxz)/2>,<Maxx-Ep, Maxy-Ep, (Minz+Maxz)/2>}
		double_illuminate
	}
*/
	mesh{
		//box{<Minx+Ep, Miny+Ep, -.001+(Minz+Maxz)/2>, <Maxx-Ep, Maxy-Ep, +.001+(Minz+Maxz)/2>}
		triangle{<Minx+Ep, Miny+Ep, (Minz+Maxz)/2>, <Maxx-Ep, Maxy-Ep, (Minz+Maxz)/2>, <Maxx-Ep, Miny+Ep, (Minz+Maxz)/2>}
		triangle{<Minx+Ep, Miny+Ep, (Minz+Maxz)/2>, <Minx+Ep, Maxy-Ep, (Minz+Maxz)/2>, <Maxx-Ep, Maxy-Ep, (Minz+Maxz)/2>}
		double_illuminate
		texture{T_RicePaper1}
		interior_texture{T_RicePaper2}
	}
	texture{T_RicePaper1}
}

#end

#macro Cloison(Coin1, Coin2, Ep, R, Ec, Turb, St, Nbcx, Nbcy, Epc, EpRainure, HRainure, Nbp, TrPan)

#local Minx=min(Coin1.x, Coin2.x);
#local Miny=min(Coin1.y, Coin2.y);
#local Minz=min(Coin1.z, Coin2.z);
#local Maxx=max(Coin1.x, Coin2.x);
#local Maxy=max(Coin1.y, Coin2.y);
#local Maxz=max(Coin1.z, Coin2.z);

#local Lngx = 2*Ep+(Maxx-Minx-(Nbp+1)*Ep)/Nbp;
#local Lngz = Maxz-Minz+2*Turb;

#local Startx=Minx;
#local i=0;
#while(i<Nbp)
	object{
		PanCloison(<Startx,Miny,Minz+mod(i,2)*Lngz>, <Startx+Lngx,Maxy,Maxz+mod(i,2)*Lngz>, Ep, R, Ec, Turb, St, Nbcx, Nbcy, Epc, EpRainure, HRainure)
		translate TrPan[i]*x
	}
	#local Startx=Startx+Lngx-Ep;
	#local i=i+1;
#end

union{
	box{<Minx,Miny,-EpRainure*.95+(Maxz+Minz)/2>,<Maxx,Miny+HRainure*.95,+EpRainure*.95+(Maxz+Minz)/2>}
	box{<Minx,Miny,-EpRainure*.95+(Maxz+Minz)/2+Lngz>,<Maxx,Miny+HRainure*.95,+EpRainure*.95+(Maxz+Minz)/2+Lngz>}
	box{<Minx,Maxy,-EpRainure*.95+(Maxz+Minz)/2>,<Maxx,Maxy-HRainure*.95,+EpRainure*.95+(Maxz+Minz)/2>}
	box{<Minx,Maxy,-EpRainure*.95+(Maxz+Minz)/2+Lngz>,<Maxx,Maxy-HRainure*.95,+EpRainure*.95+(Maxz+Minz)/2+Lngz>}
	texture{T_MontantC rotate z*90}
}

#end


//=============
// test scene
//=============
#if (test_cloisons_inc)

#declare Rad=on;

#declare Rad_count=200;
#declare Rad_error = 0.5;
#declare Rad_rec = 1;
#declare Rad_brigth = 2.0;
#declare Rad_bo = 0.05;
#declare Rad_max_sample = 5;

global_settings {
	max_trace_level 35
	adc_bailout 0.1
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.5
		minimum_reuse 0.02
		normal on

		max_sample Rad_max_sample
		adc_bailout Rad_bo
	}
#end
}



camera {
	location -25*z+5*y
	angle 40
	look_at 5*y
}

//light_source{<-.3, .01, -.1>*100, color rgb .7}
light_source{<0, .1, 1>*20, color rgb 1.5*<1,1,.95>
	area_light x,y,3,3
	circular orient adaptive 1
}

plane{y,0 pigment{rgb 1}}
plane{-y,-10 pigment{rgb 1}}

box{<-7,0,-.25>,<-25,10,.7> pigment{rgb 1}}
box{<8,0,-.25>,<25,10,.7> pigment{rgb 1}}
box{<8,0, .7>,<9,10,20> pigment{rgb 1}}
box{<-25,0,-25.5>,<25,10,-26> pigment{rgb 1}}

sphere {0,.8 translate<-2.5, 3, 1.2>}

#declare St=seed(1342);
#declare TrPan=array[3];
#declare TrPan[0]=0;
#declare TrPan[1]=-.3;
#declare TrPan[2]=-3;


//	PanCloison(Coin1, Coin2, Ep, R, Ec, Turb, St, Nbcx, Nbcy, Epc, EpRainure, HRainure)
//	PanCloison(<-3, 0, -.2>, <3,10,.2>, .4, .03, .005, .02, St, 1, 1, .15, .05, .06)

	Cloison(<-7, 0, -.2>, <8,10,.2>, .4, .03, .005, .02, St, 3, 5, .1, .05, .06, 3, TrPan)

#end

