// coussins.inc - IRTC 12/2001

#declare test_coussins_inc = off;

// This array dictates the order in which to look when averaging normals: look clock-wise.                                                                
#declare La0 = array[4][2] {{0,-1}, {1,0}, {0,1}, {-1,0}}
#declare La1 = array[8][2] {{-1,-1}, {0,-1}, {1,-1}, {1,0}, {1,1}, {0,1}, {-1,1}, {-1,0}}

// NormSum(i, j, precision) takes the indices of a node as arguments and returns the normalized sum of the normals
// of the surrounding triangles.
#macro NormSum(i, j, n1, n2, _precision)

	#if (_precision) NormSum1(i,j, n1, n2)
	#else NormSum0(i,j, n1, n2) #end

#end

#macro NormSum0(i, j, n1, n2)
 #local _m = 0;
 #local _normsum = <0, 0, 0>;

	#while ( (_m < 4) )
		#if ( (i+La0[_m][0]<=(n1-1)) & (i+La0[_m][0]>=0) & (j+La0[_m][1]<=(n2-1)) & (j+La0[_m][1]>=0) &
			  (i+La0[mod(_m+1,4)][0]<=(n1-1)) & (i+La0[mod(_m+1,4)][0]>=0) & (j+La0[mod(_m+1,4)][1]<=(n2-1)) & (j+La0[mod(_m+1,4)][1]>=0) )
			#local _normsum = _normsum+vcross(points[i][j]-points[i+La0[_m][0]][j+La0[_m][1]], points[i][j]-points[i+La0[mod(_m+1,4)][0]][j+La0[mod(_m+1,4)][1]]);
		#end
		#local _m = _m + 1;
	#end
	(vnormalize(_normsum))
#end        

#macro NormSum1(i, j, n1, n2)
 #local _m = 0;
 #local _normsum = <0, 0, 0>;
  
	#while ( (_m < 8) )
		#if ( (i+La1[_m][0]<=(n1-1)) & (i+La1[_m][0]>=0) & (j+La1[_m][1]<=(n2-1)) & (j+La1[_m][1]>=0) &
			  (i+La1[mod(_m+1,8)][0]<=(n1-1)) & (i+La1[mod(_m+1,8)][0]>=0) & (j+La1[mod(_m+1,8)][1]<=(n2-1)) & (j+La1[mod(_m+1,8)][1]>=0) )
			#local _normsum = _normsum+vcross(points[i][j]-points[i+La1[_m][0]][j+La1[_m][1]], points[i][j]-points[i+La1[mod(_m+1,8)][0]][j+La1[mod(_m+1,8)][1]]);
		#end
		#local _m = _m + 1;
    #end
	(vnormalize(_normsum))
#end        
      


#macro GetNormals(points, nx, ny, tabnorm)

#debug "\nCalculating Normals\n"
#ifndef (Normal_Precision)
	#declare Normal_Precision = 0;
#end
#local i = 0;
#while (i < nx)
	#local j = 0;
	#while (j < ny)
		#if (Normal_Precision)
			#declare tabnorm[i][j] = NormSum1(i, j, nbx, nbz);
		#else
			#declare tabnorm[i][j] = NormSum0(i, j, nbx, nbz);
		#end
		#local j = j + 1;
	#end
	#local i = i + 1;
#end

#end


#macro Coussin(lng, lrg, haut, Rbord, nbx, nbz, f_perso, NORM, UV, Tex1, Tex2, Tex3)

#local Points1 = array[nbx][nbz]
#local Points2 = array[nbx][nbz]

#local incx=lng/(nbx-1);
#local incz=lrg/(nbz-1);
/*
#local f_bord = pigment{function{min(1,max(0,1-(((abs(x))^3)+((abs(z))^3))))} cubic_wave scale <lng/2, 1, lrg/2> color_map{[0 rgb 0][.8 rgb 1]}}
#local p_perso = pigment{function{f_perso(x,y,z)}color_map{[0 rgb 0][1 rgb 1]}}
*/
#declare f_bord=function{
	pigment{
		function{min(1,max(0,1-(((abs(x))^3)+((abs(z))^3))))}
		cubic_wave
		scale <1.1*lng/2, 1, 1.1*lrg/2>
		color_map{[0 rgb 0][.8 rgb 1]}
	}
}

#local i=0;
#local startx=-lng/2;
#while(i<nbx)
	#local j=0;
	#local startz=-lrg/2;
	#while(j<nbz)
		#local temp1=f_bord(startx,0,startz);
		#local temp2=f_perso(startx,0,startz);
		#local Points1[i][j]=<startx+incx*.5*(2*temp2-1), haut*(.3+.4*(temp1.y)+.3*(.5+.5*temp1.y)*(temp2)), startz+incz*.5*(2*temp2-1)>;
		#if ((i=0) | (i=(nbx-1)) | (j=0) | (j=(nbz-1)))
			#local Points2[i][j] = Points1[i][j];
		#else
			#local Points2[i][j]=<startx+incx*.5*(2*temp2-1), max(0,haut*(.3-.7*(temp1.y)+.3*(.5+.5*temp1.y)*(temp2))), startz+incz*.5*(2*temp2-1)>;
		#end
		#local j=j+1;
		#local startz=startz+incz;
	#end
	#local i=i+1;
	#local startx=startx+incx;
#end

#if (NORM)
#declare Normals1 = array[nbx][nbz]
#declare Normals2 = array[nbx][nbz]
GetNormals(Points1, nbx, nbz, Normals1)
GetNormals(Points2, nbx, nbz, Normals2)
#end

union {
mesh2{
vertex_vectors {
	nbx*nbz*2
	#local X=0;
	#while (X<nbx)
		#local Y=0;
		#while (Y<nbz)
			,Points1[X][Y]
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
	#local X=0;
	#while (X<nbx)
		#local Y=0;
		#while (Y<nbz)
			,Points2[X][Y]
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
}
#if (NORM)
normal_vectors {
	nbx*nbz*2
	#local X=0;
	#while (X<nbx)
		#local Y=0;
		#while (Y<nbz)
			,Normals1[X][Y]
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
	#local X=0;
	#while (X<nbx)
		#local Y=0;
		#while (Y<nbz)
			,Normals2[X][Y]
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
}
#end
#if (UV)
uv_vectors {
	nbx*nbz
	#local X=0;
	#while (X<nbx)
		#local Y=0;
		#while (Y<nbz)
			,<X/(nbx-1), Y/(nbz-1)>
			#local Y=Y+1;
		#end
		#local X=X+1;
	#end
}
#end
texture_list{
2, texture{Tex1},  texture{Tex2}
}
face_indices{
	(nbx-1)*(nbz-1)*2*2
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbz*I+J, nbz*I+J+1, nbz*(I+1)+J>,0
			,<nbz*(I+1)+J+1, nbz*I+J+1, nbz*(I+1)+J>,0
			#local J=J+1;
		#end
		#local I=I+1;
	#end
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbx*nbz + nbz*I+J, nbx*nbz + nbz*I+J+1, nbx*nbz + nbz*(I+1)+J>,1
			,<nbx*nbz + nbz*(I+1)+J+1, nbx*nbz + nbz*I+J+1, nbx*nbz + nbz*(I+1)+J>,1
			#local J=J+1;
		#end
		#local I=I+1;
	#end
}
#if (NORM)
normal_indices{
	(nbx-1)*(nbz-1)*2*2
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbz*I+J, nbz*I+J+1, nbz*(I+1)+J>
			,<nbz*(I+1)+J+1, nbz*I+J+1, nbz*(I+1)+J>
			#local J=J+1;
		#end
		#local I=I+1;
	#end
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbx*nbz + nbz*I+J, nbx*nbz + nbz*I+J+1, nbx*nbz + nbz*(I+1)+J>
			,<nbx*nbz + nbz*(I+1)+J+1, nbx*nbz + nbz*I+J+1, nbx*nbz + nbz*(I+1)+J>
			#local J=J+1;
		#end
		#local I=I+1;
	#end
}
#end
#if (UV)
uv_indices{
	(nbx-1)*(nbz-1)*2*2
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbz*I+J, nbz*I+J+1, nbz*(I+1)+J>
			,<nbz*(I+1)+J+1, nbz*I+J+1, nbz*(I+1)+J>
			#local J=J+1;
		#end
	#local I=I+1;
	#end
	#local I=0;
	#while(I<(nbx-1))
		#local J=0;
		#while (J<(nbz-1))
			,<nbz*I+J, nbz*I+J+1, nbz*(I+1)+J>
			,<nbz*(I+1)+J+1, nbz*I+J+1, nbz*(I+1)+J>
			#local J=J+1;
		#end
	#local I=I+1;
	#end
}
uv_mapping
#end
}

#local I=0;
#while(I<(nbx-1))
	cylinder{Points1[I][0], Points1[I+1][0], Rbord}
	sphere{Points1[I][0], Rbord}
	cylinder{Points1[I][nbz-1], Points1[I+1][nbz-1], Rbord}
	sphere{Points1[I+1][nbz-1], Rbord}
	#local I=I+1;
#end
#local J=0;
#while(J<(nbz-1))
	cylinder{Points1[0][J], Points1[0][J+1], Rbord}
	sphere{Points1[0][J+1], Rbord}
	cylinder{Points1[nbx-1][J], Points1[nbx-1][J+1], Rbord}
	sphere{Points1[nbx-1][J], Rbord}
	#local J=J+1;
#end

#undef Normals1
#undef Normals2
	texture{Tex3}

}
#end


//================
//	SAMPLE SCENE
//================

#if (test_coussins_inc)

#declare Rad=on;
#declare Area=on;
#declare NbArea=4;

#declare Rad_count=150;
#declare Rad_error = 0.5;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
	max_trace_level 35
	adc_bailout 0.02
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.2
		minimum_reuse 0.015
		normal on

		max_sample Rad_maxs
		adc_bailout Rad_bo
	}
#end
}


camera {
	location <5, 10, -25>*3
	angle 35
	look_at <0,3,0>
}

background{rgb <.5,.6,1>*.7}

light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.7
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

plane {y, 0
	texture{
		pigment{rgb 1}
		finish {diffuse 0.6}
	}
}

#include "functions.inc"

#declare Tex1=texture{
	pigment{image_map{jpeg "coussin1"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
#declare Tex2=texture{
	pigment{color rgb <0.008,0.424,0.753>}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}

object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(35, 35, 8, .5, 30, 30, function{f_noise3d(x*.1,y,z*.1)}, on, on, Tex1, Tex2, Tex2)
	rotate -y*135
	translate 15*x+20*z
}
#declare Tex1=texture{
	pigment{image_map{jpeg "coussin2"}}
	normal{function{f_mesh1(x,y,z,.01,.01,.4,.5,.4)}bump_size .5 rotate x*90}
}
object{
//	Coussin(lng, lrg, haut, Rbord, nbx, nbz, func, NORM, UV, Tex1, Tex2, Tex3)
	Coussin(35, 35, 8, .5, 30, 30, function{f_noise3d(x*.1,y,z*.1)}, on, on, Tex1, Tex2, Tex2)
	rotate y*25
	translate -20*x-5*z
}

#end
