#declare test_icons_inc = off;

#macro Icone(lrg, haut, ep1, ep2, imgfile, twood)

#local lg1 = lrg/2;
#local ht1 = haut/2;
#local decal = ep2*.05;
union {
	intersection {
		box { <-lg1-ep1, -ht1-ep1, -ep2>, <lg1+ep1, -ht1, 0> }
		plane { x, 0 rotate z*45 translate <lg1-decal, -ht1, 0> }
		plane { -x, 0 rotate -z*45 translate <-lg1+decal, -ht1, 0> }
		texture { twood rotate x*90 rotate z*90 translate 5 }
	}
	intersection {
		box { <-lg1-ep1, ht1+ep1, -ep2>, <lg1+ep1, ht1, 0> }
		plane { x, 0 rotate -z*45 translate <lg1-decal, ht1, 0> }
		plane { -x, 0 rotate z*45 translate <-lg1+decal, ht1, 0> }
		texture { twood rotate x*90 rotate z*90 translate -5 }
	}
	intersection {
		box { <-lg1-ep1, -ht1-ep1, -ep2>, <-lg1, ht1+ep1, 0> }
		plane { x, 0 rotate z*45 translate <-lg1, ht1-decal, 0> }
		plane { x, 0 rotate -z*45 translate <-lg1, -ht1+decal, 0> }
		texture { twood rotate x*90 translate 12 }
	}
	intersection {
		box { <lg1+ep1, -ht1-ep1, -ep2>, <lg1, ht1+ep1, 0> }
		plane { -x, 0 rotate -z*45 translate <lg1, ht1-decal, 0> }
		plane { -x, 0 rotate z*45 translate <lg1, -ht1+decal, 0> }
		texture { twood rotate x*90 translate -12 }
	}
	box { <-lg1, -ht1, -ep2/2>, <lg1, ht1, 0>
		texture {
			pigment { image_map { jpeg imgfile once interpolate 2 } translate -.5*x -.5*y scale <lrg, haut,1> }
		}
	}
	translate <lg1+ep1, ht1+ep1, 0>
}

#end



#if (test_icons_inc)

#include "colors.inc"
#include "woods.inc"

camera {
	location  <40, 50, -150>
	angle 30
	look_at <5, 15, 0>
}

light_source { <-20, 30, -40>*10 color rgb 1.2 }

plane { y, 0 pigment { rgb .95 } }

object {
	Icone(15, 15*341/256, 3, 1, "icon01_256x341", T_Wood10)
	translate <-35, 0, 0>
}

object {
	Icone(17, 17*235/185, 3, 1, "icon02_185x235", T_Wood8)
	translate <-13, 0, 3>
}

object {
	Icone(12, 12*276/100, 3, 1, "icon03_100x276", T_Wood32)
	translate <6, 0, -2>
}

object {
	Icone(14, 14*184/94, 3, 1, "icon04_94x184", T_Wood14)
	translate <25, 0, 1>
}

#end
