// IRTC 12/2001
// PS2.inc

#declare test_ps2_inc = off;

#declare PS2Lng=30;
#declare PS2Lrg=17.5;
#declare PS2Ht=7.5;

#declare ConLng=4;
#declare ConLrg=3;
#declare ConHt=.8;
#declare ConR=.5;
#declare BlinLng=4;
#declare BlinR=1;

#include "nblur.mcr"

#declare PS2 = union {
	// partie basse
	difference{
		box{<0,0,PS2Lrg*.1>, <PS2Lng*.9, PS2Ht*.5,PS2Lrg>}
		union{
			box{<PS2Lng*.02,PS2Ht*.05,PS2Lrg*.09>,<PS2Lng*.04,PS2Ht*.4,PS2Lrg*.11>}
			box{<PS2Lng*.10,PS2Ht*.05,PS2Lrg*.09>,<PS2Lng*.12,PS2Ht*.4,PS2Lrg*.11>}
			box{<PS2Lng*.16,PS2Ht*.05,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.4,PS2Lrg*.11>}
			box{<PS2Lng*.02,PS2Ht*.35,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.4,PS2Lrg*.11>}
			box{<PS2Lng*.02,PS2Ht*.05,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.1,PS2Lrg*.11>}
			box{<PS2Lng*.02,PS2Ht*.35,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.4,PS2Lrg*.11>}
			box{<PS2Lng*.02,PS2Ht*.20,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.25,PS2Lrg*.11>}
			box{<PS2Lng*.11,PS2Ht*.20,PS2Lrg*.09>,<PS2Lng*.18,PS2Ht*.36,PS2Lrg*.11>}
			texture{pigment{rgb<0.024,0.427,0.820>*0.9}}
		}
	}
	// partie haute
	box{<PS2Lng*.01,PS2Ht*.45,PS2Lrg*.05>, <PS2Lng*.99, PS2Ht-.001,PS2Lrg>}
	// rainure 1
	box{<0,PS2Ht*.45,0>, <PS2Lng, PS2Ht*(.45+.55/11),PS2Lrg>}

	// rainure 2
	box{<0,PS2Ht*(.45+2*.55/11),0>, <PS2Lng*.1, PS2Ht*(.45+3*.55/11),PS2Lrg>}
	box{<PS2Lng*.1+ConLng,PS2Ht*(.45+2*.55/11),0>, <PS2Lng*.13+ConLng, PS2Ht*(.45+3*.55/11),PS2Lrg>}
	box{<PS2Lng*.13+2*ConLng,PS2Ht*(.45+2*.55/11),0>, <PS2Lng*.94, PS2Ht*(.45+3*.55/11),PS2Lrg>}
	box{<PS2Lng,PS2Ht*(.45+2*.55/11),0>, <PS2Lng*.97, PS2Ht*(.45+3*.55/11),PS2Lrg>}

	// rainure 3
	box{<0,PS2Ht*(.45+4*.55/11),0>, <PS2Lng*1.0, PS2Ht*(.45+5*.55/11),PS2Lrg>}
	// rainure 4
	#local Ra = .2;
	box{<0,PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng, PS2Ht*(.45+7*.55/11),PS2Lrg>}
	box{<0,PS2Ht*(.45+6*.55/11),0>, <PS2Lng*.1, PS2Ht*(.45+7*.55/11),PS2Lrg>}
	cylinder{<PS2Lng*.1, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.1, PS2Ht*(.45+7*.55/11),Ra>, Ra}
	union {
		cylinder{<PS2Lng*.1+2*Ra, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.1+2*Ra, PS2Ht*(.45+7*.55/11),Ra>, Ra}
		box{<PS2Lng*.1+2*Ra,PS2Ht*(.45+6*.55/11),0>, <PS2Lng*.1+ConLng-2*Ra, PS2Ht*(.45+7*.55/11),PS2Lrg>}
		cylinder{<PS2Lng*.1+ConLng-2*Ra, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.1+ConLng-2*Ra, PS2Ht*(.45+7*.55/11),Ra>, Ra}
		texture{
			pigment{
				image_pattern{png"memorycard" once}
				scale <ConLng-2*Ra, PS2Ht*.55/11, 1>
				translate <PS2Lng*.1+Ra, PS2Ht*(.45+6*.55/11),0>
				color_map{[.5 rgb .1][.6 rgb 1]}
			}
			normal{N_blur(10, .1)}
			finish{phong 0.4 phong_size 70 reflection{.1}}
		}
	}
	cylinder{<PS2Lng*.1+ConLng, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.1+ConLng, PS2Ht*(.45+7*.55/11),Ra>, Ra}
	box{<PS2Lng*.1+ConLng,PS2Ht*(.45+6*.55/11),0>, <PS2Lng*.13+ConLng, PS2Ht*(.45+7*.55/11),PS2Lrg>}
	cylinder{<PS2Lng*.13+ConLng, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.13+ConLng, PS2Ht*(.45+7*.55/11),Ra>, Ra}
	union {
		cylinder{<PS2Lng*.13+ConLng+2*Ra, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.13+ConLng+2*Ra, PS2Ht*(.45+7*.55/11),Ra>, Ra}
		box{<PS2Lng*.13+ConLng+2*Ra,PS2Ht*(.45+6*.55/11),0>, <PS2Lng*.13+2*ConLng-2*Ra, PS2Ht*(.45+7*.55/11),PS2Lrg>}
		cylinder{<PS2Lng*.13+2*ConLng-2*Ra, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.13+2*ConLng-2*Ra, PS2Ht*(.45+7*.55/11),Ra>, Ra}
		texture{
			pigment{
				image_pattern{png"memorycard" once}
				scale <ConLng-2*Ra, PS2Ht*.55/11, 1>
				translate <PS2Lng*.13+ConLng+Ra, PS2Ht*(.45+6*.55/11),0>
				color_map{[.5 rgb .1][.6 rgb 1]}
			}
			normal{N_blur(10, .1)}
			finish{phong 0.4 phong_size 70 reflection{.1}}
		}
	}
	cylinder{<PS2Lng*.13+2*ConLng, PS2Ht*(.45+6*.55/11),Ra>, <PS2Lng*.13+2*ConLng, PS2Ht*(.45+7*.55/11),Ra>, Ra}
	box{<PS2Lng*.13+2*ConLng,PS2Ht*(.45+6*.55/11),0>, <PS2Lng*1.0, PS2Ht*(.45+7*.55/11),PS2Lrg>}

	// rainure 5
	union{
		box{<0,PS2Ht*(.45+8*.55/11),0>, <PS2Lng*.94, PS2Ht*(.45+9*.55/11),PS2Lrg>}
		box{<PS2Lng,PS2Ht*(.45+8*.55/11),0>, <PS2Lng*.97, PS2Ht*(.45+9*.55/11),PS2Lrg>}
		texture{
			pigment{
				image_pattern{png"magicgate" once}
				translate -.5*x
				scale <ConLng+PS2Lng*.04+4*Ra, PS2Ht*.55/11, 1>
				translate <PS2Lng*.115+ConLng, PS2Ht*(.45+8*.55/11),0>
				color_map{[.5 rgb .1][.6 rgb 1]}
			}
			normal{N_blur(10, .1)}
			finish{phong 0.4 phong_size 70 reflection{.1}}
		}
	}

	// rainure 6
	box{<0,PS2Ht*(.45+10*.55/11),0>, <PS2Lng, PS2Ht,PS2Lrg>}
	height_field{
		png "hfps2"
		texture{
			planar
			texture_map{
				[0.1 pigment{gradient z color_map{[0 rgb<0.769,0.859,0.949>][1 rgb<0.024,0.427,0.820>]}}finish{brilliance 1.1 specular .5 roughness .01}]
				[0.1 pigment{rgb .1}normal{N_blur(10, .2)}finish{phong 0.4 phong_size 70 reflection{.1}}]
			}
		}
		translate -.5*x-.5*z
		scale <PS2Lrg*.8,.1,PS2Lrg*.8*152/504>
		rotate y*90 translate <PS2Lng*.6,PS2Ht-.01,PS2Lrg*.5>
	}
	height_field{
		png "hfsony"
		water_level .1
		translate -.5*x
		scale <PS2Ht*(7*.55/11),PS2Lrg*.05,PS2Lng*.03*.5>
		rotate -x*90
		rotate -z*90
		translate <PS2Lng*.97+PS2Lng*.03*.03,PS2Ht*(.45+5.5*.55/11)+PS2Ht*(.55*9/11)*.05,PS2Lrg*.05-.05>
		texture{pigment{rgb .6}finish{reflection{.4} specular .5 roughness .01}}
	}
	height_field{
		png "hflogo-psx"
		water_level .1
		rotate -x*90
		texture{pigment{image_map{jpeg "logo-psx"}scale<.98,.98,1> translate .01*x+.01*y}finish{specular .6 roughness .01}}
		translate -.5*x+.1*z
		scale <PS2Ht*(3*.55/11)*17/13,PS2Ht*(3*.55/11),.1>
		translate <PS2Lng*.75,PS2Ht*(.45+4.5*.55/11),0>
	}
	// 2 boutons de droite
	box{<PS2Lng*.941,-PS2Ht*1.5*.55/11,-.2>,<PS2Lng*.969,PS2Ht*1.5*.55/11,+.2>
		texture{
			pigment{cylindrical rotate x*90 scale PS2Lng*.015 translate PS2Lng*.955*x color_map{[.25 rgb .1][.25 rgb<.35,.75,.45>][.45 rgb<.35,.75,.45>][.45 rgb .1]}}
			normal{N_blur(10, .2)}finish{phong 0.4 phong_size 40}
		}
		rotate -x*10 translate PS2Ht*(.45+8.5*.55/11)*y
	}
	box{<PS2Lng*.941,-PS2Ht*1.5*.55/11,-.2>,<PS2Lng*.969,PS2Ht*1.5*.55/11,+.2>
		texture{
			pigment{boxed scale PS2Lng*.015 translate PS2Lng*.955*x-.2*z color_map{[.25 rgb .1][.25 rgb<.35,.75,.45>][.45 rgb<.65,.45,.75>][.45 rgb .1]}}
			normal{N_blur(10, .2)}finish{phong 0.4 phong_size 40}
		}
		rotate  x*10 translate PS2Ht*(.45+2.5*.55/11)*y
	}
	texture{pigment {rgb .1}normal{N_blur(10, .1)}finish{phong 0.4 phong_size 70 reflection{.1}}}
}

#declare LngSup = PS2Ht*2;
#declare LrgSup = PS2Lrg*.7;
#declare HtSup = .5;

#declare SupportPS2 = union{
	box{<-LngSup/2, 0, 0>,<LngSup/2,HtSup,LrgSup>}
	intersection{
		box{<-LngSup/2,0,0>,<-PS2Ht/2-.2,LngSup/2,LrgSup>}
		plane{-x,0 rotate -z*45 translate <-LngSup/2,HtSup,0>}
	}
	intersection{
		box{< LngSup/2,0,0>,< PS2Ht/2+.2,LngSup/2,LrgSup>}
		plane{ x,0 rotate  z*45 translate <LngSup/2,HtSup,0>}
	}
	texture{
		pigment{planar scale (LngSup-PS2Ht)/2 color_map{[0 rgb<0.024,0.427,0.820>*0.7][1 rgb<0.024,0.427,0.820>*1.1]}}
		normal{N_blur(10, .4)}
		finish{phong 0.4 phong_size 40}
	}
}

#declare ConnecteurPsx = union{
	box{<-ConLng/2,-ConHt/2,0>,<ConLng/2,ConHt/2,-ConLrg+ConR>}
	box{<-ConLng/2+ConR,-ConHt/2,0>,<ConLng/2-ConR,ConHt/2,-ConLrg>}
	cylinder{<-ConLng/2+ConR,-ConHt/2,-ConLrg+ConR>,<-ConLng/2+ConR,ConHt/2,-ConLrg+ConR>,ConR}
	cylinder{< ConLng/2-ConR,-ConHt/2,-ConLrg+ConR>,< ConLng/2-ConR,ConHt/2,-ConLrg+ConR>,ConR}
	texture{pigment{rgb .6}normal{N_blur(10, .2)}finish{phong 0.4 phong_size 40}}
}

#declare BlindageConnecteurPsx=union{
	cylinder{0, -BlinLng*.8*z, BlinR}
	cone{-BlinLng*.8*z, BlinR, -BlinLng*z, BlinR*.5}
	texture{pigment{rgb .6}normal{N_blur(10, .2)}finish{phong 0.4 phong_size 40}}
}

//=============
// test scene
//=============
#if (test_ps2_inc)

#declare Rad=on;

#declare Rad_count=400;
#declare Rad_error = 0.2;
#declare Rad_rec = 1;
#declare Rad_brigth = 2.0;
#declare Rad_bo = 0.02;
#declare Rad_max_sample = 5;

global_settings {
	max_trace_level 35
	adc_bailout 0.02
#if (Rad)
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_brigth

		pretrace_start  .05
		pretrace_end  .02

		low_error_factor .5
		gray_threshold 0.5
		minimum_reuse 0.02
		normal on

		max_sample Rad_max_sample
		adc_bailout Rad_bo
	}
#end
}



camera {
	location -70*z+50*y-20*x
	up y*4/3
	right x
	angle 28
	look_at 12*y+8*x-6*z
}

//light_source{<-.3, .01, -.1>*100, color rgb .7}
light_source{<-1, 1.2, -1.3>*90, color rgb 1*<1,1,.95>
	area_light 5*x,5*y,4,4
	circular orient jitter adaptive 1
}

background{rgb<.6,.8,1>*.5}
plane{y,0 pigment{rgb 1}finish{diffuse .5}}

#declare PS2Trans = transform{rotate z*90 translate <PS2Ht/2, HtSup+.01,-PS2Lrg*.15>}

object{SupportPS2}
object{PS2 transform{PS2Trans}}

#include "PsxController.inc"
object{PsxController rotate y*35 translate <12,0,-12>}

#declare PosConn = <PS2Lng*.1+ConLng/2,PS2Ht*(.45+2.2*.55/11),0>;

#declare Point0 = vtransform(PosConn, PS2Trans);
#declare Point1 = vtransform(PosConn-ConLrg*z, PS2Trans);
#declare Point2 = -(ConLrg+2)*z;#declare Point2 = vrotate(Point2,<0,5,0>);#declare Point2=Point2+PosConn;
#declare Point2 = vtransform(Point2, PS2Trans);
#declare Point3 = -(ConLrg+2+BlinLng)*z;#declare Point3 = vrotate(Point3,<0,5,0>);#declare Point3=Point3+PosConn;
#declare Point3 = vtransform(Point3, PS2Trans);
#declare Point4 = -(ConLrg+2+BlinLng*2)*z;#declare Point4 = vrotate(Point4,<0,15,0>);#declare Point4=Point4+PosConn;
#declare Point4 = vtransform(Point4, PS2Trans);
#declare Point5 = <-6, BlinR*.3+.2, -15>;
#declare Point6 = <0, BlinR*.3+.1, -20>;
#declare Point7 = <6, BlinR*.3, -25>;
#declare Point8 = <16, BlinR*.3+.1, -30>;
#declare Point9 = <26, BlinR*.3, -18>;
#declare Point10 = <22, BlinR*.3, -10>;
#declare Point11 = <30, BlinR*.3+.2, -1>;
#declare Point12 = <35, BlinR*.3, -10>;
#declare Point13 = <32, BlinR*.3+.1, -30>;
#declare Point14 = <26, BlinR*.3+.2, -20>;
#declare Point15 = <25, BlinR*.3+.4, -10>;
#declare Point16 = <18, BlinR*.3+.2, -1>;
#declare Point17 = <13.5, BlinR*.3+1, -10>;
#declare Point18 = <12, 2, -12>;


union{
	union{
		object{ConnecteurPsx}
		object{BlindageConnecteurPsx translate -(ConLrg+2)*z rotate y*5 }
		translate PosConn
		rotate z*90 translate <PS2Ht/2, HtSup+.01,-PS2Lrg*.15>
	}
	sphere_sweep{
		catmull_rom_spline
		19,
		Point0,BlinR*.3
		Point1,BlinR*.3
		Point2,BlinR*.3
		Point3,BlinR*.3
		Point4,BlinR*.3
		Point5,BlinR*.3
		Point6,BlinR*.3
		Point7,BlinR*.3
		Point8,BlinR*.3
		Point9,BlinR*.3
		Point10,BlinR*.3
		Point11,BlinR*.3
		Point12,BlinR*.3
		Point13,BlinR*.3
		Point14,BlinR*.3
		Point15,BlinR*.3
		Point16,BlinR*.3
		Point17,BlinR*.3
		Point18,BlinR*.3
	}
	texture{pigment{rgb .4}normal{N_blur(10, .2)}finish{phong 0.4 phong_size 40}}
}


#end

