// tele.inc

#declare test_tele_inc = off;

#include "cbasiatex.inc"

#declare TeleLong = 90/2;
#declare TeleLarg = 50;
#declare TeleLarg1 = 20;
#declare TeleHaut = 60;
#declare TeleR1 = 2;
#declare TeleR2 = 1;
#declare CoefEcran = 0.8;
#declare CoefEcran2 = 0.15;
#declare CoefEcran3 = 0.9;
#declare TeleArea = on;
#declare TeleNbArea = 4;


#declare Tele1 = union{
	box {<-TeleLong,TeleR1,0>,<TeleLong,TeleHaut-TeleR1,TeleLarg1-TeleR1>}
	box {<-TeleLong+TeleR1,0,0>,<TeleLong-TeleR1,TeleHaut,TeleLarg1-TeleR1>}
	box {<-TeleLong+TeleR1,TeleR1,0>,<TeleLong-TeleR1,TeleHaut-TeleR1,TeleLarg1>}
	cylinder{<-TeleLong+TeleR1,TeleR1,0>, <-TeleLong+TeleR1,TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{< TeleLong-TeleR1,TeleR1,0>, < TeleLong-TeleR1,TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{<-TeleLong+TeleR1,TeleHaut-TeleR1,0>, <-TeleLong+TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{< TeleLong-TeleR1,TeleHaut-TeleR1,0>, < TeleLong-TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{<-TeleLong+TeleR1,TeleR1,TeleLarg1-TeleR1>, < TeleLong-TeleR1,TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{<-TeleLong+TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, < TeleLong-TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{<-TeleLong+TeleR1,TeleR1,TeleLarg1-TeleR1>, <-TeleLong+TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	cylinder{< TeleLong-TeleR1,TeleR1,TeleLarg1-TeleR1>, < TeleLong-TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	sphere{<-TeleLong+TeleR1,TeleR1,TeleLarg1-TeleR1>, TeleR1}
	sphere{< TeleLong-TeleR1,TeleR1,TeleLarg1-TeleR1>, TeleR1}
	sphere{<-TeleLong+TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
	sphere{< TeleLong-TeleR1,TeleHaut-TeleR1,TeleLarg1-TeleR1>, TeleR1}
}

#declare Tele2 = difference {
	object{Tele1}
	union{
		box{<-TeleLong*CoefEcran,TeleHaut*CoefEcran2+TeleR2,-.01>,< TeleLong*CoefEcran,TeleHaut*CoefEcran3-TeleR2,TeleLarg1/2>}
		box{<-TeleLong*CoefEcran+TeleR2,TeleHaut*CoefEcran2,-.01>,< TeleLong*CoefEcran-TeleR2,TeleHaut*CoefEcran3,TeleLarg1/2>}
		cylinder{<-TeleLong*CoefEcran+TeleR2,TeleHaut*CoefEcran2+TeleR2,-.01>,<-TeleLong*CoefEcran+TeleR2,TeleHaut*CoefEcran2+TeleR2,TeleLarg1/2>,TeleR2}
		cylinder{< TeleLong*CoefEcran-TeleR2,TeleHaut*CoefEcran2+TeleR2,-.01>,< TeleLong*CoefEcran-TeleR2,TeleHaut*CoefEcran2+TeleR2,TeleLarg1/2>,TeleR2}
		cylinder{<-TeleLong*CoefEcran+TeleR2,TeleHaut*CoefEcran3-TeleR2,-.01>,<-TeleLong*CoefEcran+TeleR2,TeleHaut*CoefEcran3-TeleR2,TeleLarg1/2>,TeleR2}
		cylinder{< TeleLong*CoefEcran-TeleR2,TeleHaut*CoefEcran3-TeleR2,-.01>,< TeleLong*CoefEcran-TeleR2,TeleHaut*CoefEcran3-TeleR2,TeleLarg1/2>,TeleR2}
	}
	texture{
		pigment{rgb .2}
		normal{N_blur(20, .2)}
		finish{phong .4 phong_size 10}
	}
}
#undef Tele1

#declare Ecran = union {
	box{<-TeleLong*CoefEcran,TeleHaut*.05,.1>,< TeleLong*CoefEcran,TeleHaut*.95,.2>
		texture{
			pigment{image_map{jpeg "screenshot"}translate -.5*x scale<TeleLong*CoefEcran*2,TeleHaut*(CoefEcran3-CoefEcran2),1> translate TeleHaut*CoefEcran2*y}
			finish{ambient 1 diffuse 0 specular .5 roughness .1}
		}
		no_shadow
	}
	box{<-TeleLong*CoefEcran,TeleHaut*.5,.21>,< TeleLong*CoefEcran,TeleHaut*.95,.22>
		texture{pigment{image_map{jpeg "screenshot" filter all 1} translate -.5*x scale <TeleLong*CoefEcran*2,TeleHaut*(CoefEcran3-CoefEcran2),1> translate TeleHaut*CoefEcran2*y}}
	}
	light_source{ <0,TeleHaut/2,TeleLarg1/2-.01>, rgb 1.5
		spotlight radius 80 falloff 89 tightness 1 point_at <0,TeleHaut/2,-1>
		#if (TeleArea)
			area_light TeleLong*CoefEcran*.9*x, TeleHaut*.9*.9*y, TeleNbArea, TeleNbArea
			jitter adaptive 1
		#end
	}
}

#declare Tele = union{
	object{Tele2}
	object{Ecran}
	height_field{
		png "hfsony"
		water_level .1
		translate -.5*x
		scale <8,.5,1.5>
		rotate -x*90
		translate <0,1,.2>
		texture{pigment{rgb .6}finish{reflection{.4} specular .5 roughness .01}}
	}

}

#undef Ecran

//==================
// SAMPLE SCENE
//==================

#if (test_tele_inc)

#declare Rad=on;
#declare Area=off;
#declare NbArea=6;

#declare Rad_count=150;
#declare Rad_error = 0.5;
#declare Rad_rec = 1;
#declare Rad_brigth = 1.0;
#declare Rad_bo = 0.02;
#declare Rad_maxs = 2.0;

global_settings {
        max_trace_level 35
        adc_bailout 0.02
#if (Rad)
        radiosity{
                count Rad_count
                nearest_count 4
                error_bound Rad_error
                recursion_limit Rad_rec
                brightness Rad_brigth

                pretrace_start  .05
                pretrace_end  .02

                low_error_factor .5
                gray_threshold 0.2
                minimum_reuse 0.015
                normal on

                max_sample Rad_maxs
                adc_bailout Rad_bo
        }
#end
}


camera {
	location <0, 100, -300>
	angle 30
	look_at 30*y
}

//background{rgb <.5,.6,1>*.7}

/*
light_source{<-1,1,-1>*100 color rgb <1,.98,.85>*1.0
#if (Area)
	area_light 20*x,20*y, NbArea,NbArea
	circular orient jitter adaptive 1
#end
}
*/
#if (Rad=off)
light_source{< 1,1,-1>*100 color rgb 0.3 shadowless}
#end

#local St=seed(1342);
plane {y, 0
	texture{
		pigment{rgb 1}
		finish {diffuse 1}
	}
}

object{Tele }


#end
