/*
   ----------------      Spirit of Asia IRTC Competition        ------------------------ 
   ----------------               contrast.jpg                  ------------------------
   ----------------             31.December 2001                ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 


Render of the image requires three successive steps:

first render  - RenderNr  = 1  stop parsing after photon sampling
second render - RenderNr  = 2
third render  - RenderNr  = 3  final render
*/

#version 3.5;

#declare RenderNr  = 3;  

#if (RenderNr = 1)
        #declare PHOT      = 1;  // photons 0=out; 1=save photons; 2=load photons
        #declare Quickrad  = 0;  // simple textures, box for tatami 1=save good rad; 0=final render and photon sampling
        #declare Final     = 1;  // special paper pigment 1=final render; 0=otherwise
        #declare RAD       = 16; // radiosity quality settings 0=out 
#end
#if (RenderNr = 2)
        #declare PHOT      = 2;  // photons 0=out; 1=save photons; 2=load photons
        #declare Quickrad  = 1;  // simple textures, box for tatami 1=save good rad; 0=final render and photon sampling
        #declare Final     = 0;  // special paper pigment 1=final render; 0=otherwise
        #declare RAD       = 16; // radiosity quality settings 0=out
#end
#if (RenderNr = 3)
        #declare PHOT      = 2;  // photons 0=out; 1=save photons; 2=load photons
        #declare Quickrad  = 0;  // simple textures 1=save good rad; 0=final render and photon sampling
        #declare Final     = 1;  // special paper pigment 1=final render; 0=otherwise 
        #declare RAD       = 5;  // radiosity quality settings 0=out
#end
                
global_settings{
        assumed_gamma 1
        #if (RenderNr > 1)
                max_trace_level 8
        #else
                max_trace_level 13
        #end
        #if (PHOT > 0)
                photons {
                        spacing 0.05
                        autostop 0
                        jitter 1
                        #if (PHOT = 1)
                                save_file "tradition5.ph"
                        #else
                                load_file "tradition5.ph"
                        #end                        
                }
        #end  
        #if(RAD > 0)
                radiosity{
                        pretrace_start 1
                        pretrace_end   1
                        count 30*RAD                
                        nearest_count 8      
                        error_bound 0.5/RAD      
                        recursion_limit 3    
                        low_error_factor 2/RAD  
                        gray_threshold 0  
                        minimum_reuse 0.015 
                        brightness 1      
                        adc_bailout 0.005
                        normal on
                        #if (Quickrad = 1)
                                save_file "tradition2.rad"
                        #else
                                load_file "tradition2.rad" 
                                always_sample off
                        #end                          
                }
        #end
}        

#default {finish {ambient 0}}
 
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

camera {location <125,150,-550> look_at <130,105,0> angle 50}

#if (PHOT < 2)
        light_source {<800000,1500000,-50000>,<1,0.836,0.567>*36} 

        sky_sphere {
                pigment {
                        gradient y 
                        color_map {
                                [0.0 color rgb <0.9375,0.9688,1.0000>]
                                [0.2 color rgb <0.6953,0.8711,0.9297>]
                                [0.4 color rgb <0.3906,0.5820,0.9297>]
                                [0.8 color rgb <0.2617,0.4297,0.9258>]
                                [1.0 color rgb <0.1800,0.2900,0.9000>]
                        }
                }
        }

        plane {<0,-270,0>,1 hollow pigment {color rgb 0.1}}
#end

//_____________________________________________________________________________________

//  room

#declare WallNormal1 = normal {granite -0.07*1.25 scale 2}
#declare WallNormal2 = normal {dents -0.2*1.25}

#declare WallTex1 =
texture {
	pigment {rgb <1.04,0.98,0.98>*0.9} 
	finish {phong 0.25 phong_size 10}  
	normal {average normal_map {
			[0 WallNormal1]
			[1 WallNormal2]
		}
	}
}

#declare WallTex2 =
texture {
	pigment {rgb <0.98,1.04,0.98>*0.9} 
	finish {phong 0.25 phong_size 10}  
	normal {average normal_map {
			[0 WallNormal1 scale 0.8]
			[1 WallNormal2 scale 0.8]
		}
	}
}

#declare WallTex3 =
texture {
	pigment {rgb <0.98,0.98,1.04>*0.9} 
	finish {phong 0.25 phong_size 10}  
	normal {average normal_map {
			[0 WallNormal1 scale 0.8]
			[1 WallNormal2 scale 0.8]
		}
	}
}

#declare WallTex4 =
texture {
	crackle
	texture_map {
		[0.0 WallTex1 scale 0.1]
		[1.0 WallTex2 scale 0.1]
	} 
	turbulence <0.4,0.7,0.4> scale 10
}

#declare WallTex5 =
texture {
	crackle
	texture_map {
		[0.0 WallTex4 scale 0.05]
		[1.0 WallTex3 scale 0.05]
	} 
	turbulence <0.7,1,0.7> scale 20
}  

#declare WallTex6 =
texture {
	bozo 
	texture_map {
		[0.0 WallTex4 scale 2] 
		[0.5 WallTex4 scale 2]  
		[0.7 WallTex5 scale <1,2,1>]
		[1.0 WallTex5 scale <1,2,1>]
	} 
	turbulence 0.5 scale 0.5
}

#if (Quickrad = 1)
        #declare WallTex6 =
        texture {
                pigment {color rgb 0.9}
                finish {ambient 0 diffuse 0.7}
        }
#end

#declare room =
difference {
        box {<-150,-15,-620>,<320,270,20>}
        box {<-130,0,-600>,<300,250,0>}
        box {<155,249.99,-130>,<265,270.01,-20>}
        box {<150,262,-135>,<270,270.01,-15>}
        box {<154.6,249.99,-130>,<155.01,250.4,-20>}
        box {0,1 scale <2.4,2.4,600.3> rotate <0,0,45>  translate <300,80,-600>}
        box {0,1 scale <2.4,2.4,600.3> rotate <0,0,45>  translate <300,180,-600>}
        box {0,1 scale <2.4,251,2.4>   rotate <0,-45,0> translate <300,-0.5,-134>}
        box {0,1 scale <2.4,251,2.4>   rotate <0,45,0>  translate <106,-0.5,0>}
        box {0,1 scale <2.4,251,2.4>   rotate <0,45,0>  translate <-88,-0.5,0>}
        box {0,1 scale <2.4,2.4,600.3> rotate <0,0,-45> translate <106,250,-600>}
        box {0,1 scale <2.4,2.4,600.3> rotate <0,0,-45> translate <-88,250,-600>}
        box {0,1 scale <430,2.4,2.4>   rotate <45,0,0>  translate <-130,250,-134>}
        cylinder {<301,105,-34>,<304,105,-34>,1.5}
        cylinder {<301,155,-34>,<304,155,-34>,1.5}
        cylinder {<301,205,-34>,<304,205,-34>,1.5}
        cylinder {<301,105,-98>,<304,105,-98>,1.5}
        cylinder {<301,155,-98>,<304,155,-98>,1.5}
        cylinder {<301,205,-98>,<304,205,-98>,1.5}        
        cylinder {<301,105,-166>,<304,105,-166>,1.5}
        cylinder {<301,155,-166>,<304,155,-166>,1.5}
        cylinder {<301,205,-166>,<304,205,-166>,1.5}
        cone {<299.99,105,-34>,2.0,<301.01,105,-34>,1.5}
        cone {<299.99,155,-34>,2.0,<301.01,155,-34>,1.5}
        cone {<299.99,205,-34>,2.0,<301.01,205,-34>,1.5}
        cone {<299.99,105,-98>,2.0,<301.01,105,-98>,1.5}
        cone {<299.99,155,-98>,2.0,<301.01,155,-98>,1.5}
        cone {<299.99,205,-98>,2.0,<301.01,205,-98>,1.5}              
        cone {<299.99,105,-166>,2.0,<301.01,105,-166>,1.5}
        cone {<299.99,155,-166>,2.0,<301.01,155,-166>,1.5}
        cone {<299.99,205,-166>,2.0,<301.01,205,-166>,1.5}                             
}
                                      
object {room texture {WallTex6 scale 2.8}}

#if (RenderNr = 1)
        #declare WallTex7 =
        texture {
                pigment {color rgb 1}
                finish {ambient 0 diffuse 0.7}
        }
        /*
        #declare store1 =
        difference {
                box {<300,270,-620>,<320,570,20>}
                cylinder {<299.99,410,-140>, <320.01,410,-140>, 140}
        }
        
        object {store1 texture {WallTex7}}
        */
        box {<-20,270,0>,<320,570,20> texture {WallTex7}}
        box {<-20,270,-620>,<0,570,20> texture {WallTex7}}
        box {<-20,270,-600>,<320,570,-620> texture {WallTex7}}
#end
       
//_________________________________________________________________________

// ceiling light

#declare woodTex = 
texture {
	pigment {
		wood turbulence 0.03725 omega 0.65725 lambda 2.425
		color_map {
			[0.250 color rgb <1.00000, 0.53373*0.8, 0.11665>]
			[0.350 color rgb <0.66275, 0.28607*0.8, 0.00000>]
			[0.525 color rgb <1.00000, 0.53363*0.8, 0.11715>]
			[0.600 color rgb <0.66475, 0.28647*0.8, 0.00000>]
			[0.750 color rgb <1.00000, 0.53353*0.8, 0.11565>]
			[0.850 color rgb <0.66275, 0.28667*0.8, 0.00000>]
			[1.000 color rgb <1.00000, 0.53143*0.8, 0.11795>]
		}
		scale <0.25,0.225,1>
	}
}
texture {
	pigment {
		wood scale 1.01275 turbulence 0.0435 omega 0.65 lambda 3.15
		color_map {
			[0.200 color rgbf <0.56695, 0.17347*0.8, 0.00000, 0.8250>]
			[0.350 color rgbf <0.96471, 0.54510*0.8, 0.22753, 0.7710>]
			[0.400 color rgbf <0.56341, 0.17547*0.8, 0.00000, 0.9150>]
			[0.615 color rgbf <0.96472, 0.54510*0.8, 0.22553, 0.7590>]
			[0.700 color rgbf <0.56671, 0.17687*0.8, 0.00000, 0.7920>]
			[0.850 color rgbf <0.96485, 0.54510*0.8, 0.22453, 0.8975>]
			[1.000 color rgbf <0.56478, 0.17247*0.8, 0.00000, 0.9750>]
		}
		scale <0.225,0.2725,1>
		translate <-0.35,0.095,1.25>
	}
}

#if (Quickrad = 1)
        #declare woodTex =
        texture {
                pigment {color rgb <0.76,0.23,0.10>}
        }
#end

#declare ceiling_light_frame_Tex = 
texture {
	woodTex
	finish { ambient 0 diffuse 0.89}
        rotate <0,90,0> rotate <10,0,0> scale 5
}

#declare ceiling_light_frame =
union { 
        #declare Count = 0;
        #while (Count < 7)
                box {<0,0,0+19*Count>,<116,12,2+19*Count>}
                #declare Count = Count+1;
        #end
}
 
object {ceiling_light_frame texture {ceiling_light_frame_Tex} translate <151,262,-133>}
object {ceiling_light_frame texture {ceiling_light_frame_Tex} rotate <0,-90,0> translate <267,262,-133>} 

#declare GlassNormal1 = normal{bozo 4 scale 1/1.5}
#declare GlassNormal2 = normal{bozo 4 scale 0.2/1.5}

#declare glassstone_Mat =
material {
        texture {
                pigment {color rgbf <1,1,1,0.58>}
                #if (Quickrad = 0)
                        normal{ 
		                average
		                normal_map {
			                [0 GlassNormal1]
			                [1 GlassNormal2]
		                }
	                }
                        normal {bozo 5 turbulence 0.2 scale 1.5}
                #end
                finish {ambient 0 diffuse 1}
        }
        interior {ior 1.45} //fade_distance 3 fade_power 10 fade_color rgb 0.9}
}

#declare glassstone =
difference {
        box {0,1}
        sphere {<0.5,1,0.5>, 0.72 scale <1,0.05,1>}
        sphere {<0.5,0,0.5>, 0.72 scale <1,0.05,1>}
}

#declare Rand = seed(1);
#declare glassstones =
union { 
        #declare Countx = 0;
        #while (Countx < 6)
                #declare Countz = 0;
                #while (Countz < 6)
                        object {glassstone 
                                hollow                                
                                material {glassstone_Mat translate <rand(Rand)*10,rand(Rand)*10,rand(Rand)*10>} 
                                scale <17,11,17> 
                                rotate <rand(Rand)*0.5,rand(Rand)*0.5,rand(Rand)*0.5> 
                                translate <19*Countx,0,19*Countz>
                        }
                        #declare Countz = Countz+1;
                #end
                #declare Countx = Countx+1;
        #end
}

#if (PHOT = 2)
        #declare glassstones = 
        box {<0,2,0>,<112,13,112> 
                texture {
                        #if (Final = 1)
                                pigment {color rgb 6} 
                                finish {ambient 0.2}
                        #else 
                                pigment {color rgb 1.5} 
                                finish {ambient 0.05}
                        #end 
                }        
        }
#end

object {glassstones  
        #if(PHOT > 0)
                photons {target collect off reflection on refraction on} 
        #end 
        translate <153,262,-131>
} 

//_________________________________________________________________________

// metal construction  

#declare constructionTex = 
texture {
        pigment {color rgb 0.2}
        #if (PHOT = 2)
                normal {wrinkles 0.5 scale <1,0.03,1>*10}
        #end
        finish {ambient 0 diffuse 0.7
                #if (PHOT = 2) 
                        specular 8 roughness 0.05 metallic reflection {0.1}
                #end
        }
}

#if (Quickrad = 1)
        #declare constructionTex =
        texture {
                pigment {color rgb 0.2}
                finish {ambient 0 diffuse 0.7}
        }
#end

#declare construction =
union {
        #declare Count = 0;
        #while (Count < 12)
                box {<-130,190+4*Count,-76>,<295,192+4*Count,-74>}                         
                #declare Count = Count+1;
        #end
        cylinder {<282.5,189.5,-75>,<282.5,251,-75>,0.6}
        cylinder {<137.5,189.5,-75>,<137.5,251,-75>,0.6}
        cylinder {<75,189.5,-75>,<75,251,-75>,0.6}
        cylinder {<-70,189.5,-75>,<-70,251,-75>,0.6}
}

object {construction texture {constructionTex}}        

//_________________________________________________________________________

// tatami  

#declare tatamiEdge2 =
union {
        box {<0.5,0,0.5>,<179.5,1,4.5>}
        cylinder {<0.5,0.5,0.5>,<179.5,0.5,0.5>,0.5} 
        cylinder {<0.5,0.5,4.5>,<179.5,0.5,4.5>,0.5}
        cylinder {<0.5,0.5,0.5>,<0.5,0.5,4.5>,0.5} 
        cylinder {<179.5,0.5,0.5>,<179.5,0.5,4.5>,0.5}
        sphere {<0.5,0.5,0.5>,0.5}
        sphere {<179.5,0.5,0.5>,0.5}
        sphere {<179.5,0.5,4.5>,0.5}
        sphere {<0.5,0.5,4.5>,0.5}
}

#declare tatamiEdge = 
object {
        tatamiEdge2
        texture {
                pigment {color rgb <0.7,0.53,0.25>*0.5}
        }
}  

#declare ta = seed (0);
#declare tb = seed (0);

#if (Quickrad = 0)
        #declare tatami1 =
        union {
                #declare Countx = 0;
                #while (Countx < 430)
                        #declare Countz = 0;
                        #while (Countz < 120)
                                cylinder {<0,0,0>,<0.85,0,0>,5 scale <1,0.075,1> 
                                        texture {
                                                pigment {color rgb <0.7+0.05*rand(ta),0.53+0.05*rand(ta),0.25+0.05*rand(ta)>}
                                        }
                                        rotate <rand(tb),rand(tb),rand(tb)>  
                                        translate <2*Countx,0.2*rand(ta)+0.075,5*Countz>
                                }
                                #declare Countz = Countz+1;
                        #end
                        #declare Countz = 0;
                        #while (Countz < 120)
                                cylinder {<0,0,0>,<0.85,0,0>,5 scale <1,0.075,1> 
                                        texture {
                                                pigment {color rgb <0.7+0.05*rand(ta),0.53+0.05*rand(ta),0.25+0.05*rand(ta)>} 
                                        }  
                                        rotate <rand(tb),rand(tb),rand(tb)>
                                        translate <2*Countx+1,0.2*rand(ta)+0.075,5*Countz+2.5>
                                }
                                #declare Countz = Countz+1;
                        #end
                        #declare Countx = Countx+1;
                #end
        }       
#else
        #declare tatami1 = box {<0,0,0>,<430,0.5,600> pigment {color rgb <0.725,0.555,0.275>*1.25}}  
#end

object {tatami1 translate <-130,0,-600>}

object {tatamiEdge translate <-242,-0.1,-7>}
object {tatamiEdge translate <-242,-0.1,-102>}
object {tatamiEdge translate <-62,-0.1,-7>}
object {tatamiEdge translate <-62,-0.1,-102>}
object {tatamiEdge translate <-242,-0.1,-107>}
object {tatamiEdge translate <-242,-0.1,-202>}
object {tatamiEdge translate <-62,-0.1,-107>}
object {tatamiEdge translate <-62,-0.1,-202>}
object {tatamiEdge translate <118,-0.1,-107>}
object {tatamiEdge translate <118,-0.1,-202>}                          
object {tatamiEdge translate <-242,-0.1,-207>}
object {tatamiEdge translate <-242,-0.1,-302>}
object {tatamiEdge translate <-62,-0.1,-207>}
object {tatamiEdge translate <-62,-0.1,-302>}
object {tatamiEdge translate <118,-0.1,-207>}
object {tatamiEdge translate <118,-0.1,-302>}                   

box {<-130,0,-600>,<300,0.01,0> pigment {color rgb <0.725,0.555,0.275>}}

//_________________________________________________________________________

// shoji


#declare shoji_Tex = 
texture {
        pigment {color rgb 0.09}
        normal {bozo scale 20}
        finish {ambient 0 diffuse 0.7 specular 1 roughness 0.003}
}

#declare paper_Tex =
texture {
        #if (Final = 1)
                pigment {color rgb <0.9,1,1.1>*1.3}
        #else
                pigment {color rgb <0.9,1,1.1>}
        #end
        //normal {granite 0.1 scale 90}
        normal{ 
	        average
	        normal_map {
			[0 granite 0.2 scale 10]
			[1 bozo 0.2 scale 1]
		}
	}
        finish {ambient 0 diffuse 2}
}

#if (Quickrad = 1)
        #declare shoji_Tex = 
        texture {
                pigment {color rgb 0.09}
                finish {ambient 0 diffuse 0.7}
        }

        #declare paper_Tex =
        texture {
                pigment {color rgb <0.9,1,1.1>}
                finish {ambient 0 diffuse 2}
        }
#end

#declare shoji_Frame =
union {
        box {<0,0,-5>,<206,4,0>}
        box {<202,0,-5>,<206,140,0>}
        box {<206,136,-5>,<0,140,0>}
        box {<0,140,-5>,<4,4,0>}
        cylinder {<4,37,-3>,<202,37,-3>,0.5}
        cylinder {<4,70,-3>,<202,70,-3>,0.5}
        cylinder {<4,103,-3>,<202,103,-3>,0.5}
        cylinder {<37,4,-3>,<37,136,-3>,0.5}
        cylinder {<70,4,-3>,<70,136,-3>,0.5}
        cylinder {<103,4,-3>,<103,136,-3>,0.5}
        cylinder {<136,4,-3>,<136,136,-3>,0.5}
        cylinder {<169,4,-3>,<169,136,-3>,0.5}
        texture {shoji_Tex}                
}

#declare paper =
box {<4,4,-2.5>,<202,136,-2.45> 
        //hollow
        //double_illuminate 
        texture {paper_Tex}
}

#declare shoji =
union {
        object {shoji_Frame}
        object {paper}
}

object {shoji rotate <0,0,0.2> translate <92,51,-0.5>}
object {shoji rotate <0,0,-0.3>translate <-115,51,-0.5>}

//_________________________________________________________________________  

// table 

#declare table_Tex = 
texture {
        pigment {color rgb 0.04}
        normal{ 
		average
		normal_map {
			[0 bozo 0.2]
			[1 wrinkles 0.2 scale <2,0.5,2>]
		}
	}
        finish {ambient 0 diffuse 0.5 reflection {0.12 metallic 0.5}}
}

#if (Quickrad = 1)
        #declare table_Tex = 
        texture {
                pigment {color rgb 0.04}
                finish {ambient 0 diffuse 0.5}
        }
#end  

#declare table =
union {
        box {<3,0,3>,<177,9,97>}
        box {<0,3,3>,<180,6,97>}
        box {<3,3,0>,<177,6,100>}
        cylinder {<3,3,3>,<3,6,3>,3}
        cylinder {<177,3,3>,<177,6,3>,3}
        cylinder {<177,3,97>,<177,6,97>,3}
        cylinder {<3,3,97>,<3,6,97>,3}
        cylinder {<3,3,3>,<177,3,3>,3}
        cylinder {<177,3,3>,<177,3,97>,3}
        cylinder {<177,3,97>,<3,3,97>,3}
        cylinder {<3,3,97>,<3,3,3>,3}
        cylinder {<3,6,3>,<177,6,3>,3}
        cylinder {<177,6,3>,<177,6,97>,3}
        cylinder {<177,6,97>,<3,6,97>,3}
        cylinder {<3,6,97>,<3,6,3>,3}
        sphere {<3,3,3>,3}
        sphere {<177,3,3>,3}
        sphere {<177,3,97>,3}
        sphere {<3,3,97>,3}
        sphere {<3,6,3>,3}
        sphere {<177,6,3>,3}
        sphere {<177,6,97>,3}
        sphere {<3,6,97>,3}
}

object {table texture {table_Tex} translate <117,0,-103>}

//_________________________________________________________________________

// tansu

#if (Quickrad = 1)
        #declare tansu_Tex = 
        texture {
                pigment {color rgb <0.5,0.05,0.05>*0.9}
                finish {ambient 0 diffuse 0.7}
        }
         
        box {<170,9,-80>,<250,41,-20> texture {tansu_Tex}}
#end  

#declare woodTex2 = 
texture {
	pigment {
		wood turbulence 0.03725 omega 0.65725 lambda 2.425
		color_map {
			[0.250 color rgb <1.00000*0.45, 0.53373*0.15, 0.11665*0.36>]
			[0.350 color rgb <0.66275*0.45, 0.28607*0.15, 0.00000*0.36>]
			[0.525 color rgb <1.00000*0.45, 0.53363*0.15, 0.11715*0.36>]
			[0.600 color rgb <0.66475*0.45, 0.28647*0.15, 0.00000*0.36>]
			[0.750 color rgb <1.00000*0.45, 0.53353*0.15, 0.11565*0.36>]
			[0.850 color rgb <0.66275*0.45, 0.28667*0.15, 0.00000*0.36>]
			[1.000 color rgb <1.00000*0.45, 0.53143*0.15, 0.11795*0.36>]
		}
		scale <0.25,0.225,1>*0.5
	}
}
texture {
	pigment {
		wood scale 1.01275 turbulence 0.0435 omega 0.65 lambda 3.15
		color_map {
			[0.200 color rgbf <0.56695*0.45, 0.17347*0.15, 0.00000*0.36, 0.8250>]
			[0.350 color rgbf <0.96471*0.45, 0.54510*0.15, 0.22753*0.36, 0.7710>]
			[0.400 color rgbf <0.56341*0.45, 0.17547*0.15, 0.00000*0.36, 0.9150>]
			[0.615 color rgbf <0.96472*0.45, 0.54510*0.15, 0.22553*0.36, 0.7590>]
			[0.700 color rgbf <0.56671*0.45, 0.17687*0.15, 0.00000*0.36, 0.7920>]
			[0.850 color rgbf <0.96485*0.45, 0.54510*0.15, 0.22453*0.36, 0.8975>]
			[1.000 color rgbf <0.56478*0.45, 0.17247*0.15, 0.00000*0.36, 0.9750>]
		}
		scale <0.225,0.2725,1>*0.5
		translate <-0.35,0.095,1.25>
	}
}

#declare tansu_Tex = 
texture {
        woodTex2 
        normal {bozo 0.12 scale 0.7} 
        finish {ambient 0 diffuse 0.7 specular 3 roughness 0.003 reflection {0.16 metallic 0.5}}
        rotate <0,90,0> rotate <10,5,5> scale 5
}

#declare tansu1 =
union {
        box {<-39.7,-16,-29.7>,<39.7,16,29.7>}
        box {<-40,-15.7,-29.7>,<40,15.7,29.7>}
        box {<-39.7,-15.7,-30>,<39.7,15.7,30>}
        cylinder {<-39.7,-15.7,-29.7>,<39.7,-15.7,-29.7>,0.3}
        cylinder {<39.7,-15.7,-29.7>,<39.7,15.7,-29.7>,0.3}
        cylinder {<39.7,15.7,-29.7>,<-39.7,15.7,-29.7>,0.3}
        cylinder {<-39.7,15.7,-29.7>,<-39.7,-15.7,-29.7>,0.3}
        cylinder {<-39.7,-15.7,29.7>,<39.7,-15.7,29.7>,0.3}
        cylinder {<39.7,-15.7,29.7>,<39.7,15.7,29.7>,0.3}
        cylinder {<39.7,15.7,29.7>,<-39.7,15.7,29.7>,0.3}
        cylinder {<-39.7,-15.7,-29.7>,<-39.7,-15.7,29.7>,0.3}
        cylinder {<39.7,-15.7,-29.7>,<39.7,-15.7,29.7>,0.3}
        cylinder {<39.7,15.7,-29.7>,<39.7,15.7,29.7>,0.3}
        cylinder {<-39.7,15.7,-29.7>,<-39.7,15.7,29.7>,0.3}
        cylinder {<-39.7,-15.7,-29.7>,<-39.7,-15.7,29.7>,0.3}
        sphere {<-39.7,-15.7,-29.7>,0.3}
        sphere {<39.7,-15.7,-29.7>,0.3}
        sphere {<39.7,15.7,-29.7>,0.3}
        sphere {<-39.7,15.7,-29.7>,0.3}
        sphere {<-39.7,-15.7,29.7>,0.3}
        sphere {<39.7,-15.7,29.7>,0.3}
        sphere {<39.7,15.7,29.7>,0.3}
        sphere {<-39.7,-15.7,-29.7>,0.3}
        box {<-40.5,-0.5,-8.5>,<-39.99,7.5,8.5>}
}

#declare tansu2 =
difference { 
        object {tansu1}
        box {<-37,-13,-30.01>,<-3,-1,-28>}
        box {<-37,13,-30.01>,<-3,1,-28>}
        box {<37,-13,-30.01>,<3,13,-28>}
        box {<-40.51,0,-8>,<-38,7,8>}       
}

#declare tansu3 =
union {
        box {<-16.5,-5.9,-0.7>,<16.5,5.9,0.7>}
        box {<-16.8,-5.6,-0.7>,<16.8,5.6,0.7>}
        box {<-16.5,-5.6,-1.0>,<16.5,5.6,1.0>}
        cylinder {<-16.5,-5.6,-0.7>,<16.5,-5.6,-0.7>,0.3}
        cylinder {<16.5,-5.6,-0.7>,<16.5,5.6,-0.7>,0.3}
        cylinder {<16.5,5.6,-0.7>,<-16.5,5.6,-0.7>,0.3}
        cylinder {<-16.5,5.6,-0.7>,<-16.5,-5.6,-0.7>,0.3}
        cylinder {<-16.5,-5.6,0.7>,<16.5,-5.6,0.7>,0.3}
        cylinder {<16.5,-5.6,0.7>,<16.5,5.6,0.7>,0.3}
        cylinder {<16.5,5.6,0.7>,<-16.5,5.6,0.7>,0.3}
        cylinder {<-16.5,-5.6,-0.7>,<-16.5,-5.6,0.7>,0.3}
        cylinder {<16.5,-5.6,-0.7>,<16.5,-5.6,0.7>,0.3}
        cylinder {<16.5,5.6,-0.7>,<16.5,5.6,0.7>,0.3}
        cylinder {<-16.5,5.6,-0.7>,<-16.5,5.6,0.7>,0.3}
        cylinder {<-16.5,-5.6,-0.7>,<-16.5,-5.6,0.7>,0.3}
        sphere {<-16.5,-5.6,-0.7>,0.3}
        sphere {<16.5,-5.6,-0.7>,0.3}
        sphere {<16.5,5.6,-0.7>,0.3}
        sphere {<-16.5,5.6,-0.7>,0.3}
        sphere {<-16.5,-5.6,0.7>,0.3}
        sphere {<16.5,-5.6,0.7>,0.3}
        sphere {<16.5,5.6,0.7>,0.3}
        sphere {<-16.5,-5.6,-0.7>,0.3}
}

#declare tansu4 =
union {
        box {<-16.5,-12.8,-0.7>,<16.5,12.8,0.7>}
        box {<-16.8,-12.5,-0.7>,<16.8,12.5,0.7>}
        box {<-16.5,-12.5,-1.0>,<16.5,12.5,1.0>}
        cylinder {<-16.5,-12.5,-0.7>,<16.5,-12.5,-0.7>,0.3}
        cylinder {<16.5,-12.5,-0.7>,<16.5,12.5,-0.7>,0.3}
        cylinder {<16.5,12.5,-0.7>,<-16.5,12.5,-0.7>,0.3}
        cylinder {<-16.5,12.5,-0.7>,<-16.5,-12.5,-0.7>,0.3}
        cylinder {<-16.5,-12.5,0.7>,<16.5,-12.5,0.7>,0.3}
        cylinder {<16.5,-12.5,0.7>,<16.5,12.5,0.7>,0.3}
        cylinder {<16.5,12.5,0.7>,<-16.5,12.5,0.7>,0.3}
        cylinder {<-16.5,-12.5,-0.7>,<-16.5,-12.5,0.7>,0.3}
        cylinder {<16.5,-12.5,-0.7>,<16.5,-12.5,0.7>,0.3}
        cylinder {<16.5,12.5,-0.7>,<16.5,12.5,0.7>,0.3}
        cylinder {<-16.5,12.5,-0.7>,<-16.5,12.5,0.7>,0.3}
        cylinder {<-16.5,-12.5,-0.7>,<-16.5,-12.5,0.7>,0.3}
        sphere {<-16.5,-12.5,-0.7>,0.3}
        sphere {<16.5,-12.5,-0.7>,0.3}
        sphere {<16.5,12.5,-0.7>,0.3}
        sphere {<-16.5,12.5,-0.7>,0.3}
        sphere {<-16.5,-12.5,0.7>,0.3}
        sphere {<16.5,-12.5,0.7>,0.3}
        sphere {<16.5,12.5,0.7>,0.3}
        sphere {<-16.5,-12.5,-0.7>,0.3}
}


#declare tansu_Tex2= 
texture {
        pigment {color rgb 0.5}
        normal {granite -0.3 cubic_wave scale 5}
        finish {diffuse 0.5 specular 1 roughness 0.02 brilliance 4 metallic}
}

#declare tansu3a =
union {
        cylinder {<0,0,-1>,<0,0,-1.2>,2 scale <1.8,1,1>}
        cylinder {<0,1.5,-1>,<0,1.5,-2>,0.45}
        sphere {<0,1.5,-2>,0.45}
        torus {1.5,0.3 rotate <90,0,0> translate <0,0,-1.8>}
        
}

#declare tansu4a =
union {
        cylinder {<0,0,-1>,<0,0,-1.4>,3 scale <1,1.8,1>}
        cylinder {<0,2.5,-1>,<0,2.5,-2.2>,0.5}
        sphere {<0,2.5,-2>,0.55}
        torus {2.2,0.35 rotate <90,0,0> translate <0,0.3,-2>}
        
}

#declare tansu =
union {
        object {tansu2 texture {tansu_Tex}}
        object {tansu3 texture {tansu_Tex translate -10} rotate <0.5,1.7,1> translate <-20,-7.2,-29>}
        object {tansu3a texture {tansu_Tex2} rotate <0.5,1.7,1> translate <-20,-4.7,-29>}
        object {tansu3 texture {tansu_Tex translate 10} rotate <0.5,-1.7,-1> translate <-20,6.8,-29>}
        object {tansu3a texture {tansu_Tex2} rotate <0.5,-1.7,-1> translate <-20,9.3,-29>}
        object {tansu4 texture {tansu_Tex translate 20} rotate <-0.5,-1.7,1> translate <20,0,-29>}
        object {tansu4a texture {tansu_Tex2} rotate <-0.5,-1.7,1> translate <8,0,-29>}
        
}        

#if (Quickrad = 0)        
        object {tansu translate <210,25,-50>}
#end

//_________________________________________________________________________

// boards 

#declare board_Tex =
texture {
        pigment {
                P_WoodGrain4A
                color_map {M_Wood8A}  
                scale 75
                translate <-1.5,0.3,1>
                warp {
                        black_hole <0.5,0,0.5>,1.25
                        falloff 2
                        strength 2
                        inverse
                        turbulence <0.15,0.15,0.15>
                }
                warp {
                        black_hole <-1.5,0,0.3>,1.5
                        falloff 2
                        strength 2
                        inverse
                        turbulence <0.75,0.75,0.75>
                }
                warp {
                        black_hole <1,0,-0.5>,1.95
                        falloff 1
                        strength 2
                        inverse
                        turbulence <0.05,0.05,0.05>
                }
        } 
        finish {ambient 0 diffuse 0.7 specular 0.5}
}
texture{
        pigment {
                gradient y
                turbulence 0.3 omega 1 lambda 3
                poly_wave 1.5
                color_map {
                        [0 rgbft <0.77*0.6,0.63*0.6,0.39*0.6,0.3,0.7>]
                        [0.65 rgbft <0.77*0.6,0.63*0.6,0.39*0.6,1,2>*0.2]
                        [1 rgbft <0.77*0.6,0.63*0.6,0.39*0.6,0.3,0.7>*0.4]
                }
        }    
        finish {ambient 0 diffuse 0.7 specular 0.5}
        scale 32
}

#if (Quickrad = 1)
        #declare board_Tex = 
        texture {
                pigment {color rgb <0.4,0.32,0.25>}
                finish {ambient 0 diffuse 0.57}
        }
#end           
                        
box {<-130,0,-2>,<300,50,0> texture {board_Tex rotate <0,90,0> scale <0.5,2,1>}}
box {<298,0,-600>,<300,50,0> texture {board_Tex scale <0.5,2,1> translate 0.065}} 

//_________________________________________________________________________

// vase with plant

box {<-30,46.7,-30>,<30,49.9,30> 
        texture {ceiling_light_frame_Tex 
                #if (Quickrad = 0)
                        finish {ambient 0 diffuse 0.5 specular 3 roughness 0.003}
                #else
                        finish {ambient 0 diffuse 0.5}
                #end
        }
        rotate y*45
        translate <300,0,0>
}

cylinder {<283,49.9,-17>,<283,80,-17>,4 
        texture {
                pigment {color rgb <0.15,0.05,0.15>}
                #if (Quickrad = 0)
                        finish {specular 1 reflection {0.15}}
                #end
        }
}

#if (Quickrad = 0)
        #declare Randb = seed(2); 
        #declare Count = 0;
        #while (Count < 200)
                cone {<1,0,0>,0,<0,0,0>,0.8 
                        texture {pigment {color rgb <0.1,0,0.1>}} finish {specular 1}
                        translate <4,0,0>
                        rotate <0,rand(Randb)*360,0>
                        translate <283,50.7+28*rand(Randb),-17>
                } 
                #declare Count = Count+1;
        #end
                
        #declare tex1 =  
        texture{ 
                pigment {color rgb <0.44,0.45,0.36>}  
                finish {ambient 0 diffuse 0.5}
        }

        #declare tex2 =   
        texture{ 
                pigment {color rgb <0.32,0.36,0.28>}  
                finish {ambient 0 diffuse 0.5}
        }

        #declare tex3 =  
        texture{ 
                pigment {color rgb <0.7,0.6,0.8>}  
                finish {ambient 0 diffuse 0.5}
        }

        #include "plant.inc"
#end