#version 3.5;

#include "origami.inc"

#macro Head(
  PaperSize
)

#local Work=Init_Origami;
#local Split_Sides=1.02*1/3;
#local Ear_Ratio=18.2/21;
#local Hairs_Ratio1=15.9/18.2;
#local Hairs_Ratio2=15.0/15.9;
#local Hairs_Ratio3=12.8/15.0;
#local Chin_Ratio=1/6;
#local Alfa=30;
#local Side_Angle=1;
// initial points

#local C=Add_Point(Work,PaperSize*(x-y)/2,1,0,"C");
#local R=Add_Point(Work,PaperSize*(x+y)/2,1,1,"R");
#local O=Add_Point(Work,PaperSize*(y-x)/2,0,1,"O");
#local L=Add_Point(Work,PaperSize*(-(x+y))/2,0,0,"L");

Add_Triangle(Work,R,C,O)
Add_Triangle(Work,O,C,L)

Split_Angle(Work,"C","O","L","L","C","L1",Split_Sides)
Split_Angle(Work,"C","O","R","R","C","R1",Split_Sides)

Split_Edge(Work,"O","L1","L2",Ear_Ratio)
Split_Edge(Work,"O","R1","R2",Ear_Ratio)

Split_Edge(Work,"O","L2","L3",Hairs_Ratio1)
Split_Edge(Work,"O","R2","R3",Hairs_Ratio1)

Split_Edge(Work,"O","L3","L4",Hairs_Ratio2)
Split_Edge(Work,"O","R3","R4",Hairs_Ratio2)

Split_Edge(Work,"O","L4","L5",Hairs_Ratio3)
Split_Edge(Work,"O","R4","R5",Hairs_Ratio3)

Mirror_Edge(Work,"L3","R3","O","L1","O","L","L6")
Mirror_Edge(Work,"L4","R4","O","L1","O","L6","L7")
Mirror_Edge(Work,"L5","R5","O","L1","O","L7","L8")

Mirror_Edge(Work,"R3","L3","O","R1","O","R","R6")
Mirror_Edge(Work,"R4","L4","O","R1","O","R6","R7")
Mirror_Edge(Work,"R5","L5","O","R1","O","R7","R8")

Mirror_Edge(Work,"L6","L3","O","L1","O","C","C2")
Mirror_Edge(Work,"L7","L4","O","L2","O","C2","C3")
Mirror_Edge(Work,"L8","L5","O","L3","O","C3","C4")

Split_Edge(Work,"C","L1","L9",Chin_Ratio)
Split_Edge(Work,"C","R1","R9",Chin_Ratio)

Mirror_Edge(Work,"L9","R9","O","C","C2","C","C1")

#local Beta=Get_Angle(Work,"L","L2","O");
#local Gamma=180-(Alfa+Beta);
Split_Angle(Work,"L1","L2","L","L","L1","L10",1-(Alfa/Get_Angle(Work,"L1","L2","L")))
Split_Angle(Work,"L10","L2","L9","L1","L9","L11",(Alfa+Gamma)/Get_Angle(Work,"L10","L2","L9"))

#local Beta=Get_Angle(Work,"R","R2","O");
#local Gamma=180-(Alfa+Beta);
Split_Angle(Work,"R1","R2","R","R","R1","R10",1-(Alfa/Get_Angle(Work,"R1","R2","R")))
Split_Angle(Work,"R10","R2","R9","R1","R9","R11",(Alfa+Gamma)/Get_Angle(Work,"R10","R2","R9"))

#local Origami=Init_Origami;

#local O=Copy_Point(Work,Origami,"O");
#local C=Copy_Point(Work,Origami,"C");
#local C1=Copy_Point(Work,Origami,"C1");
#local C2=Copy_Point(Work,Origami,"C2");
#local C3=Copy_Point(Work,Origami,"C3");
#local C4=Copy_Point(Work,Origami,"C4");
#local R=Copy_Point(Work,Origami,"R");
#local R2=Copy_Point(Work,Origami,"R2");
#local R3=Copy_Point(Work,Origami,"R3");
#local R4=Copy_Point(Work,Origami,"R4");
#local R5=Copy_Point(Work,Origami,"R5");
#local R6=Copy_Point(Work,Origami,"R6");
#local R7=Copy_Point(Work,Origami,"R7");
#local R8=Copy_Point(Work,Origami,"R8");
#local R9=Copy_Point(Work,Origami,"R9");
#local R10=Copy_Point(Work,Origami,"R10");
#local R11=Copy_Point(Work,Origami,"R11");
#local L=Copy_Point(Work,Origami,"L");
#local L2=Copy_Point(Work,Origami,"L2");
#local L3=Copy_Point(Work,Origami,"L3");
#local L4=Copy_Point(Work,Origami,"L4");
#local L5=Copy_Point(Work,Origami,"L5");
#local L6=Copy_Point(Work,Origami,"L6");
#local L7=Copy_Point(Work,Origami,"L7");
#local L8=Copy_Point(Work,Origami,"L8");
#local L9=Copy_Point(Work,Origami,"L9");
#local L10=Copy_Point(Work,Origami,"L10");
#local L11=Copy_Point(Work,Origami,"L11");

Add_Triangle(Origami,O,L5,L8)
Add_Triangle(Origami,O,C4,L5)
Add_Quad(Origami,L8,L5,L4,L7)
Add_Quad(Origami,L5,C4,C3,L4)
Add_Quad(Origami,L7,L4,L3,L6)
Add_Quad(Origami,L4,C3,C2,L3)
Add_Quad(Origami,L6,L3,L2,L)
Add_Poly(Origami,array[6]{C2,C1,L9,L11,L2,L3})
Add_Triangle(Origami,C,L9,C1)
Add_Triangle(Origami,L,L2,L10)
Add_Triangle(Origami,L10,L2,L11)

Add_RTriangle(Origami,O,R5,R8)
Add_RTriangle(Origami,O,C4,R5)
Add_RQuad(Origami,R8,R5,R4,R7)
Add_RQuad(Origami,R5,C4,C3,R4)
Add_RQuad(Origami,R7,R4,R3,R6)
Add_RQuad(Origami,R4,C3,C2,R3)
Add_RQuad(Origami,R6,R3,R2,R)
Add_RPoly(Origami,array[6]{C2,C1,R9,R11,R2,R3})
Add_RTriangle(Origami,C,R9,C1)
Add_RTriangle(Origami,R,R2,R10)
Add_RTriangle(Origami,R10,R2,R11)
/*
Around_Edge_List(Origami,"O","C",array[11]{R,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11},-Side_Angle)
Around_Edge_List(Origami,"O","C",array[11]{L,L2,L3,L4,L5,L6,L7,L8,L9,L10,L11},Side_Angle)
*/

#local R_Side_Angle=179.95;
#local L_Side_Angle=178;

Around_Edge_List(Origami,"O","R2",array[5]{R,R6,R7,R8,R10},-R_Side_Angle)
Around_Edge_List(Origami,"O","L2",array[5]{L,L6,L7,L8,L10},L_Side_Angle)

Around_Edge(Origami,"R","R2","R10",-(R_Side_Angle+(180-R_Side_Angle)/2))
Around_Edge(Origami,"L","L2","L10",(L_Side_Angle+(180-L_Side_Angle)/2))

Around_Edge(Origami,"L9","R9","C",-178)

#local Hair_Angle=175;

Around_Edge_List(Origami,"L3","R3",array[11]{R7,R4,C3,L4,L7,R8,R5,C4,L5,L8,O},Hair_Angle)
//Around_Edge_List(Origami,"L4","L5",array[6]{R8,R5,C4,L5,L8,O},-Hair_Angle)
Around_Edge_List(Origami,"L4","L7",array[9]{R7,R4,C3,L5,L8,C4,R5,R8,O},-Hair_Angle)
Around_Edge(Origami,"L5","R5","O",Hair_Angle)

//Around_Edge(Origami,"L3","R3","R6",Hair_Angle/3)

/*
Around_Edge(Origami,"L5","R5","O",Hair_Angle)

Around_Edge_List(Origami,"L4","R4",array[6]{R8,R5,C4,L5,L8,O},-Hair_Angle)


//Around_Edge_List(Origami,"L3","R3",array[2]{R6,L6},Hair_Angle/3)


//Around_Edge_List(Origami,"L4","R4",array[2]{R7,L7},-Hair_Angle)
*/

Transform_Origami(Origami,transform{rotate -z*45})
Transform_Origami(Origami,transform{translate -Get_Point(Origami,C)})

Origami

#end