#include "colors.inc"
#include "shapes.inc"
#include "stones.inc"
#include "woods.inc"
#include "skies.inc"
#include "jizo.inc"
#include "hut.inc"
#include "earth.inc"
#include "busstop.inc"
#include "flowers.inc"
#include "grass.inc"
#include "rock.inc"

camera {
	location <240,75,-240>
	look_at <10,40,0>
	angle 27
	focal_point <10,40,0>
	aperture 8
	blur_samples 100
}

light_source {<240,300,480> 
		color Coral
		area_light <5,-4,0>, <3.2,4,-4.1>, 3, 3
		}
light_source {<-10,10,-40> 
		color Feldspar 
		}

sky_sphere {
	pigment { 
		gradient y
		color_map {
			[0 color OrangeRed]
			[0.6 color Coral]
			[0.8 color Very_Light_Purple]
			[1 color Black]
			}
		}
	rotate<100,72,0>
}

object {
	difference{
		object{O_Cloud1} 
		object{Sphere 
			translate<240,75,-240>
			}
		}
	}

object {Jizo
	texture{T_Stone8}
	}

object{ Rock 
	translate <0,-15,-5>
	texture{T_Stone9}
	}
object{ Rock
	rotate<0,15,0>
	scale<0.75,1,0.66>
	translate<0,-7.5,-3>
	texture{T_Stone9}
	}

object {Hut}
object {Earth
	translate<0,-45,0>
	}

object {BusStop
	rotate<0,-90,0>
	translate<60,-45,45>
	}
object {Grass
	scale 35
	rotate<0,15,0>
	translate<25,-45,150>
	}
object {Grass
	scale 30
	rotate<-12,60,0>
	translate<10,-45,155>
	}
object {Flowers
	scale 2
	rotate<0,30,0>
	translate <-15,-5.5,-30>
	}

#declare GrassCount=1;
#while (GrassCount<=5)
	object {Grass
		scale 35
		rotate<0,18*GrassCount,GrassCount>
		translate <-107.5,-35,100-GrassCount*30>
		}
#declare GrassCount=GrassCount+1;
#end
