//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 23 materials and 273 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 12/23/2001    (23.12.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 100
  number_of_waves 10
    radiosity {
    pretrace_start 0.08
    pretrace_end 0.008
    brightness       1.0
    normal on
//    count            300
//    error_bound      0.5
//    gray_threshold   0.5
//    low_error_factor 0.5
//    minimum_reuse    0.015
//    nearest_count    4
//    recursion_limit  1
//    adc_bailout  0.01/2
  } 

}

background { color <0.839,0.839,0.906> }

camera {  //  Camera StdCam1
  location  <      7.337,      -7.048,       1.762>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.56928,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      36.267
  look_at   <      0.102,      -1.139,       2.525>
}


//
// *******  L I G H T S *******
//

/*light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  shadowless
  translate  <6.460054, -9.058949, 1.460454>
}*/

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.996, 0.957>
    area_light <30, 0, 0>, <0, 30, 0>, 3, 3
    adaptive 0
    jitter

  translate  <0.0, -600.0, 1000.0>
}


fog {
    distance 600
    color rgbt  <0.843137, 0.878431, 0.909804,-1> //<0.3, 0.5, 0.2, -1.0> <0.613593, 0.613593, 0.782207, -1>
    fog_type 2
    fog_offset 12
    fog_alt 20
    turbulence .01    
    up <0.0, 0.0, 1.0> // Where Z is up
    
  }



//
// ********  MATERIALS  *******
//

#include "pagoda.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\aqua11_p.inc"

#declare P_aquatic11_Ref = object {
  P_aquatic11  scale <0.01, 0.01, 0.006>
  translate  <1.189501, -2.505869, 0.105282>
}
#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\tree6_p.inc"

#declare P_PWL0001B_Ref = object {
  P_PWL0001B
}
#declare P_PWL0001F_Ref = object {
  P_PWL0001F
}
#declare P_PWL0002B_Ref = object {
  P_PWL0002B
}
#declare P_PWL0002F_Ref = object {
  P_PWL0002F
}
#declare P_PWL0003B_Ref = object {
  P_PWL0003B
}
#declare P_PWL0003F_Ref = object {
  P_PWL0003F
}
#declare P_PWL0004B_Ref = object {
  P_PWL0004B
}
#declare P_PWL0004F_Ref = object {
  P_PWL0004F
}
#declare P_PWL0005B_Ref = object {
  P_PWL0005B
}
#declare P_PWL0005F_Ref = object {
  P_PWL0005F
}
#declare P_PWL0006B_Ref = object {
  P_PWL0006B
}
#declare P_PWL0006F_Ref = object {
  P_PWL0006F
}
#declare P_PWL0007B_Ref = object {
  P_PWL0007B
}
#declare P_PWL0007F_Ref = object {
  P_PWL0007F
}
#declare P_PWL0008B_Ref = object {
  P_PWL0008B
}
#declare P_PWL0008F_Ref = object {
  P_PWL0008F
}
#declare P_PWL0009B_Ref = object {
  P_PWL0009B
}
#declare P_PWL0009F_Ref = object {
  P_PWL0009F
}
#declare P_PWL0010B_Ref = object {
  P_PWL0010B
}
#declare P_PWL0010F_Ref = object {
  P_PWL0010F
}
#declare P_PWL0011B_Ref = object {
  P_PWL0011B
}
#declare P_PWL0011F_Ref = object {
  P_PWL0011F
}
#declare P_PWL0012B_Ref = object {
  P_PWL0012B
}
#declare P_PWL0012F_Ref = object {
  P_PWL0012F
}
#declare P_PWL0013B_Ref = object {
  P_PWL0013B
}
#declare P_PWL0013F_Ref = object {
  P_PWL0013F
}
#declare P_PWL0014B_Ref = object {
  P_PWL0014B
}
#declare P_PWL0014F_Ref = object {
  P_PWL0014F
}
#declare P_PWL0015B_Ref = object {
  P_PWL0015B
}
#declare P_PWL0015F_Ref = object {
  P_PWL0015F
}
#declare P_PWL0016B_Ref = object {
  P_PWL0016B
}
#declare P_PWL0016F_Ref = object {
  P_PWL0016F
}
#declare P_PWL0017B_Ref = object {
  P_PWL0017B
}
#declare P_PWL0017F_Ref = object {
  P_PWL0017F
}
#declare P_PWL0018B_Ref = object {
  P_PWL0018B
}
#declare P_PWL0018F_Ref = object {
  P_PWL0018F
}
#declare P_PWL0019B_Ref = object {
  P_PWL0019B
}
#declare P_PWL0019F_Ref = object {
  P_PWL0019F
}
#declare P_PWL0020B_Ref = object {
  P_PWL0020B
}
#declare P_PWL0020F_Ref = object {
  P_PWL0020F
}
#declare P_PWL0021B_Ref = object {
  P_PWL0021B
}
#declare P_PWL0021F_Ref = object {
  P_PWL0021F
}
#declare P_PWL0022B_Ref = object {
  P_PWL0022B
}
#declare P_PWL0022F_Ref = object {
  P_PWL0022F
}
#declare P_PWL0023B_Ref = object {
  P_PWL0023B
}
#declare P_PWL0023F_Ref = object {
  P_PWL0023F
}
#declare P_PWL0024B_Ref = object {
  P_PWL0024B
}
#declare P_PWL0024F_Ref = object {
  P_PWL0024F
}
#declare P_PWL0025B_Ref = object {
  P_PWL0025B
}
#declare P_PWL0025F_Ref = object {
  P_PWL0025F
}
#declare P_PWL0026B_Ref = object {
  P_PWL0026B
}
#declare P_PWL0026F_Ref = object {
  P_PWL0026F
}
#declare P_PWL0027B_Ref = object {
  P_PWL0027B
}
#declare P_PWL0027F_Ref = object {
  P_PWL0027F
}
#declare P_PWL0028B_Ref = object {
  P_PWL0028B
}
#declare P_PWL0028F_Ref = object {
  P_PWL0028F
}
#declare P_PWL0029B_Ref = object {
  P_PWL0029B
}
#declare P_PWL0029F_Ref = object {
  P_PWL0029F
}
#declare P_PWL0030B_Ref = object {
  P_PWL0030B
}
#declare P_PWL0030F_Ref = object {
  P_PWL0030F
}
#declare P_PWL0032B_Ref = object {
  P_PWL0032B
}
#declare P_PWL0032F_Ref = object {
  P_PWL0032F
}
#declare P_PWL0033B_Ref = object {
  P_PWL0033B
}
#declare P_PWL0033F_Ref = object {
  P_PWL0033F
}
#declare P_PWL0034B_Ref = object {
  P_PWL0034B
}
#declare P_PWL0034F_Ref = object {
  P_PWL0034F
}
#declare P_PWL0035B_Ref = object {
  P_PWL0035B
}
#declare P_PWL0035F_Ref = object {
  P_PWL0035F
}
#declare P_PWL0037B_Ref = object {
  P_PWL0037B
}
#declare P_PWL0037F_Ref = object {
  P_PWL0037F
}
#declare P_PWL0038B_Ref = object {
  P_PWL0038B
}
#declare P_PWL0038F_Ref = object {
  P_PWL0038F
}
#declare P_PWL0039B_Ref = object {
  P_PWL0039B
}
#declare P_PWL0039F_Ref = object {
  P_PWL0039F
}
#declare P_PWL0040B_Ref = object {
  P_PWL0040B
}
#declare P_PWL0040F_Ref = object {
  P_PWL0040F
}
#declare P_PWL0041B_Ref = object {
  P_PWL0041B
}
#declare P_PWL0041F_Ref = object {
  P_PWL0041F
}
#declare P_PWL0042B_Ref = object {
  P_PWL0042B
}
#declare P_PWL0042F_Ref = object {
  P_PWL0042F
}
#declare P_PWL0043B_Ref = object {
  P_PWL0043B
}
#declare P_PWL0043F_Ref = object {
  P_PWL0043F
}
#declare P_PWL0044B_Ref = object {
  P_PWL0044B
}
#declare P_PWL0044F_Ref = object {
  P_PWL0044F
}
#declare P_PWL0045B_Ref = object {
  P_PWL0045B
}
#declare P_PWL0045F_Ref = object {
  P_PWL0045F
}
#declare P_PWL0046B_Ref = object {
  P_PWL0046B
}
#declare P_PWL0046F_Ref = object {
  P_PWL0046F
}
#declare P_PWL0047B_Ref = object {
  P_PWL0047B
}
#declare P_PWL0047F_Ref = object {
  P_PWL0047F
}
#declare P_PWL0048B_Ref = object {
  P_PWL0048B
}
#declare P_PWL0048F_Ref = object {
  P_PWL0048F
}
#declare tree6_group = union { // tree6_group
  object { P_PWL0001B_Ref }
  object { P_PWL0001F_Ref }
  object { P_PWL0002B_Ref }
  object { P_PWL0002F_Ref }
  object { P_PWL0003B_Ref }
  object { P_PWL0003F_Ref }
  object { P_PWL0004B_Ref }
  object { P_PWL0004F_Ref }
  object { P_PWL0005B_Ref }
  object { P_PWL0005F_Ref }
  object { P_PWL0006B_Ref }
  object { P_PWL0006F_Ref }
  object { P_PWL0007B_Ref }
  object { P_PWL0007F_Ref }
  object { P_PWL0008B_Ref }
  object { P_PWL0008F_Ref }
  object { P_PWL0009B_Ref }
  object { P_PWL0009F_Ref }
  object { P_PWL0010B_Ref }
  object { P_PWL0010F_Ref }
  object { P_PWL0011B_Ref }
  object { P_PWL0011F_Ref }
  object { P_PWL0012B_Ref }
  object { P_PWL0012F_Ref }
  object { P_PWL0013B_Ref }
  object { P_PWL0013F_Ref }
  object { P_PWL0014B_Ref }
  object { P_PWL0014F_Ref }
  object { P_PWL0015B_Ref }
  object { P_PWL0015F_Ref }
  object { P_PWL0016B_Ref }
  object { P_PWL0016F_Ref }
  object { P_PWL0017B_Ref }
  object { P_PWL0017F_Ref }
  object { P_PWL0018B_Ref }
  object { P_PWL0018F_Ref }
  object { P_PWL0019B_Ref }
  object { P_PWL0019F_Ref }
  object { P_PWL0020B_Ref }
  object { P_PWL0020F_Ref }
  object { P_PWL0021B_Ref }
  object { P_PWL0021F_Ref }
  object { P_PWL0022B_Ref }
  object { P_PWL0022F_Ref }
  object { P_PWL0023B_Ref }
  object { P_PWL0023F_Ref }
  object { P_PWL0024B_Ref }
  object { P_PWL0024F_Ref }
  object { P_PWL0025B_Ref }
  object { P_PWL0025F_Ref }
  object { P_PWL0026B_Ref }
  object { P_PWL0026F_Ref }
  object { P_PWL0027B_Ref }
  object { P_PWL0027F_Ref }
  object { P_PWL0028B_Ref }
  object { P_PWL0028F_Ref }
  object { P_PWL0029B_Ref }
  object { P_PWL0029F_Ref }
  object { P_PWL0030B_Ref }
  object { P_PWL0030F_Ref }
  object { P_PWL0032B_Ref }
  object { P_PWL0032F_Ref }
  object { P_PWL0033B_Ref }
  object { P_PWL0033F_Ref }
  object { P_PWL0034B_Ref }
  object { P_PWL0034F_Ref }
  object { P_PWL0035B_Ref }
  object { P_PWL0035F_Ref }
  object { P_PWL0037B_Ref }
  object { P_PWL0037F_Ref }
  object { P_PWL0038B_Ref }
  object { P_PWL0038F_Ref }
  object { P_PWL0039B_Ref }
  object { P_PWL0039F_Ref }
  object { P_PWL0040B_Ref }
  object { P_PWL0040F_Ref }
  object { P_PWL0041B_Ref }
  object { P_PWL0041F_Ref }
  object { P_PWL0042B_Ref }
  object { P_PWL0042F_Ref }
  object { P_PWL0043B_Ref }
  object { P_PWL0043F_Ref }
  object { P_PWL0044B_Ref }
  object { P_PWL0044F_Ref }
  object { P_PWL0045B_Ref }
  object { P_PWL0045F_Ref }
  object { P_PWL0046B_Ref }
  object { P_PWL0046F_Ref }
  object { P_PWL0047B_Ref }
  object { P_PWL0047F_Ref }
  object { P_PWL0048B_Ref }
  object { P_PWL0048F_Ref }
  scale 0.15
  translate  <-7.864531, -2.725399, -0.024964>
}






//
// ********  OBJECTS  *******
//

cylinder { // tronco
  <0,0,1>, <0,0,0>, 1 
  material {
    T_Wood8_1_1_1
    rotate <0.0, -1.0, -180.0>
  }
  scale <0.1, 0.1, 1.0>
  translate  <1.751722, -1.710566, -0.145963>
}


object { // P_aquatic20 -> P_aquatic11
  P_aquatic11_Ref
  rotate 0.0*x
  translate  <2.007621, 3.173854, -0.007449>
}


object { // P_aquatic19 -> P_aquatic11
  P_aquatic11_Ref
  scale <1.2, -1.0, 1.0>
  translate  <-8.838095, -5.30442, 0.263289>
}


object { // P_aquatic18 -> P_aquatic11
  P_aquatic11_Ref
  scale <1.2, -1.2, 1.0>
  translate  <-15.167501, -1.357679, 0.258137>
}


object { // P_aquatic17 -> P_aquatic11
  P_aquatic11_Ref
  rotate 0.0*x
  translate  <-8.371319, 4.231456, 0.275959>
}


object { // tree6_group3 -> tree6_group
  tree6_group
  scale <1.2, -1.2, 1.2>
  translate  <-4.388776, -1.673418, 0.0>
}




object { // P_aquatic16 -> P_aquatic11
  P_aquatic11_Ref
  scale <1.0, 1.0, 0.5>
  translate  <-0.321423, -0.409595, 0.0>
}


object { // P_aquatic15 -> P_aquatic11
  P_aquatic11_Ref
  translate  <-5.099342, 0.936277, -0.0>
}


plane { // fond
  z,0
  material {
    fondo
  }
  no_shadow
  translate  -2.0*z
}


#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\tree4_p.inc"

#declare P_QAP0001B_Ref = object {
  P_QAP0001B
}
#declare P_QAP0001F_Ref = object {
  P_QAP0001F
}
#declare P_QAP0002B_Ref = object {
  P_QAP0002B
}
#declare P_QAP0002F_Ref = object {
  P_QAP0002F
}
#declare P_QAP0003B_Ref = object {
  P_QAP0003B
}
#declare P_QAP0003F_Ref = object {
  P_QAP0003F
}
#declare P_QAP0004B_Ref = object {
  P_QAP0004B
}
#declare P_QAP0004F_Ref = object {
  P_QAP0004F
}
#declare P_QAP0005B_Ref = object {
  P_QAP0005B
}
#declare P_QAP0005F_Ref = object {
  P_QAP0005F
}
#declare P_QAP0006B_Ref = object {
  P_QAP0006B
}
#declare P_QAP0006F_Ref = object {
  P_QAP0006F
}
#declare P_QAP0007B_Ref = object {
  P_QAP0007B
}
#declare P_QAP0007F_Ref = object {
  P_QAP0007F
}
#declare P_QAP0008B_Ref = object {
  P_QAP0008B
}
#declare P_QAP0008F_Ref = object {
  P_QAP0008F
}
#declare P_QAP0009B_Ref = object {
  P_QAP0009B
}
#declare P_QAP0009F_Ref = object {
  P_QAP0009F
}
#declare P_QAP0010B_Ref = object {
  P_QAP0010B
}
#declare P_QAP0010F_Ref = object {
  P_QAP0010F
}
#declare P_QAP0011B_Ref = object {
  P_QAP0011B
}
#declare P_QAP0011F_Ref = object {
  P_QAP0011F
}
#declare P_QAP0012B_Ref = object {
  P_QAP0012B
}
#declare P_QAP0012F_Ref = object {
  P_QAP0012F
}
#declare P_QAP0013B_Ref = object {
  P_QAP0013B
}
#declare P_QAP0013F_Ref = object {
  P_QAP0013F
}
#declare P_QAP0014B_Ref = object {
  P_QAP0014B
}
#declare P_QAP0014F_Ref = object {
  P_QAP0014F
}
#declare P_QAP0015B_Ref = object {
  P_QAP0015B
}
#declare P_QAP0015F_Ref = object {
  P_QAP0015F
}
#declare P_QAP0016B_Ref = object {
  P_QAP0016B
}
#declare P_QAP0016F_Ref = object {
  P_QAP0016F
}
#declare P_QAP0017B_Ref = object {
  P_QAP0017B
}
#declare P_QAP0017F_Ref = object {
  P_QAP0017F
}
#declare P_QAP0018B_Ref = object {
  P_QAP0018B
}
#declare P_QAP0018F_Ref = object {
  P_QAP0018F
}
#declare P_QAP0019B_Ref = object {
  P_QAP0019B
}
#declare P_QAP0019F_Ref = object {
  P_QAP0019F
}
#declare P_QAP0020B_Ref = object {
  P_QAP0020B
}
#declare P_QAP0020F_Ref = object {
  P_QAP0020F
}
#declare P_QAP0021B_Ref = object {
  P_QAP0021B
}
#declare P_QAP0021F_Ref = object {
  P_QAP0021F
}
#declare P_QAP0022B_Ref = object {
  P_QAP0022B
}
#declare P_QAP0022F_Ref = object {
  P_QAP0022F
}
#declare P_QAP0023B_Ref = object {
  P_QAP0023B
}
#declare P_QAP0023F_Ref = object {
  P_QAP0023F
}
#declare P_QAP0024B_Ref = object {
  P_QAP0024B
}
#declare P_QAP0024F_Ref = object {
  P_QAP0024F
}
#declare P_QAP0025B_Ref = object {
  P_QAP0025B
}
#declare P_QAP0025F_Ref = object {
  P_QAP0025F
}
#declare P_QAP0026B_Ref = object {
  P_QAP0026B
}
#declare P_QAP0026F_Ref = object {
  P_QAP0026F
}
#declare P_QAP0027B_Ref = object {
  P_QAP0027B
}
#declare P_QAP0027F_Ref = object {
  P_QAP0027F
}
#declare P_QAP0028B_Ref = object {
  P_QAP0028B
}
#declare P_QAP0028F_Ref = object {
  P_QAP0028F
}
#declare P_QAP0029B_Ref = object {
  P_QAP0029B
}
#declare P_QAP0029F_Ref = object {
  P_QAP0029F
}
#declare P_QAP0030B_Ref = object {
  P_QAP0030B
}
#declare P_QAP0030F_Ref = object {
  P_QAP0030F
}
#declare P_QAP0031B_Ref = object {
  P_QAP0031B
}
#declare P_QAP0031F_Ref = object {
  P_QAP0031F
}
#declare P_QAP0032B_Ref = object {
  P_QAP0032B
}
#declare P_QAP0032F_Ref = object {
  P_QAP0032F
}
#declare P_QAP0033B_Ref = object {
  P_QAP0033B
}
#declare P_QAP0033F_Ref = object {
  P_QAP0033F
}
#declare P_QAP0034B_Ref = object {
  P_QAP0034B
}
#declare P_QAP0034F_Ref = object {
  P_QAP0034F
}
#declare P_QAP0035B_Ref = object {
  P_QAP0035B
}
#declare P_QAP0035F_Ref = object {
  P_QAP0035F
}
#declare P_QAP0036B_Ref = object {
  P_QAP0036B
}
#declare P_QAP0036F_Ref = object {
  P_QAP0036F
}
#declare P_QAP0037B_Ref = object {
  P_QAP0037B
}
#declare P_QAP0037F_Ref = object {
  P_QAP0037F
}
#declare P_QAP0038B_Ref = object {
  P_QAP0038B
}
#declare P_QAP0038F_Ref = object {
  P_QAP0038F
}
#declare P_QAP0039B_Ref = object {
  P_QAP0039B
}
#declare P_QAP0039F_Ref = object {
  P_QAP0039F
}
#declare P_QAP0040B_Ref = object {
  P_QAP0040B
}
#declare P_QAP0040F_Ref = object {
  P_QAP0040F
}
#declare P_QAP0041B_Ref = object {
  P_QAP0041B
}
#declare P_QAP0041F_Ref = object {
  P_QAP0041F
}
#declare P_QAP0042B_Ref = object {
  P_QAP0042B
}
#declare P_QAP0042F_Ref = object {
  P_QAP0042F
}
#declare P_QAP0043B_Ref = object {
  P_QAP0043B
}
#declare P_QAP0043F_Ref = object {
  P_QAP0043F
}
#declare P_QAP0044B_Ref = object {
  P_QAP0044B
}
#declare P_QAP0044F_Ref = object {
  P_QAP0044F
}
#declare P_QAP0045B_Ref = object {
  P_QAP0045B
}
#declare P_QAP0045F_Ref = object {
  P_QAP0045F
}
union { // tree4_group
  object { P_QAP0001B_Ref }
  object { P_QAP0001F_Ref }
  object { P_QAP0002B_Ref }
  object { P_QAP0002F_Ref }
  object { P_QAP0003B_Ref }
  object { P_QAP0003F_Ref }
  object { P_QAP0004B_Ref }
  object { P_QAP0004F_Ref }
  object { P_QAP0005B_Ref }
  object { P_QAP0005F_Ref }
  object { P_QAP0006B_Ref }
  object { P_QAP0006F_Ref }
  object { P_QAP0007B_Ref }
  object { P_QAP0007F_Ref }
  object { P_QAP0008B_Ref }
  object { P_QAP0008F_Ref }
  object { P_QAP0009B_Ref }
  object { P_QAP0009F_Ref }
  object { P_QAP0010B_Ref }
  object { P_QAP0010F_Ref }
  object { P_QAP0011B_Ref }
  object { P_QAP0011F_Ref }
  object { P_QAP0012B_Ref }
  object { P_QAP0012F_Ref }
  object { P_QAP0013B_Ref }
  object { P_QAP0013F_Ref }
  object { P_QAP0014B_Ref }
  object { P_QAP0014F_Ref }
  object { P_QAP0015B_Ref }
  object { P_QAP0015F_Ref }
  object { P_QAP0016B_Ref }
  object { P_QAP0016F_Ref }
  object { P_QAP0017B_Ref }
  object { P_QAP0017F_Ref }
  object { P_QAP0018B_Ref }
  object { P_QAP0018F_Ref }
  object { P_QAP0019B_Ref }
  object { P_QAP0019F_Ref }
  object { P_QAP0020B_Ref }
  object { P_QAP0020F_Ref }
  object { P_QAP0021B_Ref }
  object { P_QAP0021F_Ref }
  object { P_QAP0022B_Ref }
  object { P_QAP0022F_Ref }
  object { P_QAP0023B_Ref }
  object { P_QAP0023F_Ref }
  object { P_QAP0024B_Ref }
  object { P_QAP0024F_Ref }
  object { P_QAP0025B_Ref }
  object { P_QAP0025F_Ref }
  object { P_QAP0026B_Ref }
  object { P_QAP0026F_Ref }
  object { P_QAP0027B_Ref }
  object { P_QAP0027F_Ref }
  object { P_QAP0028B_Ref }
  object { P_QAP0028F_Ref }
  object { P_QAP0029B_Ref }
  object { P_QAP0029F_Ref }
  object { P_QAP0030B_Ref }
  object { P_QAP0030F_Ref }
  object { P_QAP0031B_Ref }
  object { P_QAP0031F_Ref }
  object { P_QAP0032B_Ref }
  object { P_QAP0032F_Ref }
  object { P_QAP0033B_Ref }
  object { P_QAP0033F_Ref }
  object { P_QAP0034B_Ref }
  object { P_QAP0034F_Ref }
  object { P_QAP0035B_Ref }
  object { P_QAP0035F_Ref }
  object { P_QAP0036B_Ref }
  object { P_QAP0036F_Ref }
  object { P_QAP0037B_Ref }
  object { P_QAP0037F_Ref }
  object { P_QAP0038B_Ref }
  object { P_QAP0038F_Ref }
  object { P_QAP0039B_Ref }
  object { P_QAP0039F_Ref }
  object { P_QAP0040B_Ref }
  object { P_QAP0040F_Ref }
  object { P_QAP0041B_Ref }
  object { P_QAP0041F_Ref }
  object { P_QAP0042B_Ref }
  object { P_QAP0042F_Ref }
  object { P_QAP0043B_Ref }
  object { P_QAP0043F_Ref }
  object { P_QAP0044B_Ref }
  object { P_QAP0044F_Ref }
  object { P_QAP0045B_Ref }
  object { P_QAP0045F_Ref }
  scale 0.08
  rotate -30.0*z
  translate  <3.225349, 0.635887, -0.049262>
}


object { // P_aquatic14 -> P_aquatic11
  P_aquatic11_Ref
  translate  <-0.526437, -0.979873, -0.10319>
}


object { // P_aquatic13 -> P_aquatic11
  P_aquatic11_Ref
  translate  <-6.2612, 0.599318, -0.0>
}


object { // P_aquatic12 -> P_aquatic11
  P_aquatic11_Ref
  translate  <-5.057885, 1.491121, -0.0>
}


object { P_aquatic11_Ref }


#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\aqua02_p.inc"

#declare P_Obj_000001_Ref = object {
  P_Obj_000001
}
#declare P_Obj_000002_Ref = object {
  P_Obj_000002
}
#declare P_Obj_000003_Ref = object {
  P_Obj_000003
}
#declare P_Obj_000004_Ref = object {
  P_Obj_000004
}
#declare P_Obj_000005_Ref = object {
  P_Obj_000005
}
union { // aqua02_group
  object { P_Obj_000001_Ref }
  object { P_Obj_000002_Ref }
  object { P_Obj_000003_Ref }
  object { P_Obj_000004_Ref }
  object { P_Obj_000005_Ref }
  scale 0.01
  translate  <-2.370692, -3.426198, 0.08417>
}


#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\plmbroad_p.inc"

#declare P_PLMB_TRUNK_Ref = object {
  P_PLMB_TRUNK
}
#declare P_PLMB_BRANC_Ref = object {
  P_PLMB_BRANC
}
#declare P_PLMB_BLEAF_Ref = object {
  P_PLMB_BLEAF
}
#declare P_PLMB_MLEAF_Ref = object {
  P_PLMB_MLEAF
}
#declare P_PLMB_ELEAF_Ref = object {
  P_PLMB_ELEAF
}
union { // plmbroad_group
  object { P_PLMB_TRUNK_Ref }
  object { P_PLMB_BRANC_Ref }
  object { P_PLMB_BLEAF_Ref }
  object { P_PLMB_MLEAF_Ref }
  object { P_PLMB_ELEAF_Ref }
  scale 0.02
  translate  <2.980909, -1.152555, 0.481681>
}


object { // tree6_group2 -> tree6_group
  tree6_group
  scale 0.5
  rotate 53.838936*z
  translate  <-4.034242, 3.056244, 0.0>
}


object { // tree6_group1 -> tree6_group
  tree6_group
  scale 1.1
  rotate 30.912481*z
  translate  <-1.526893, 8.783698, 0.0>
}


object { tree6_group }


object {   // sassi
  height_field {
    tga "C:\PROGRAMMI\MORAY FOR WINDOWS\Maps\pagodap6.tga"
    water_level 0.4642
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    pietre
  }
  scale <6.0, 6.0, 0.2>
}


plane { // lago
  z,0
  material {
    acqua
  }
  no_shadow
}


#declare cornicesu = union {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood8_1
    }
    scale <0.8, 1.0, 1.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8_1
    }
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate  <0.0, 1.0, 1.0>
  }
  material {
    T_Wood8_1
    scale 0.2
  }
  scale <0.45, 0.05, 0.3375>
  translate  <0.0, -0.951922, -0.338173>
}
#declare fcosu = merge {
  sphere { <1.2750, 0.9750, 0.3750>, 0.0250 }
  sphere { <1.2750, -0.9750, 0.3750>, 0.0250 }
  sphere { <-1.2750, -0.9750, 0.3750>, 0.0250 }
  sphere { <-1.2750, 0.9750, 0.3750>, 0.0250 }
  sphere { <1.2750, 0.9750, -0.3750>, 0.0250 }
  sphere { <1.2750, -0.9750, -0.3750>, 0.0250 }
  sphere { <-1.2750, -0.9750, -0.3750>, 0.0250 }
  sphere { <-1.2750, 0.9750, -0.3750>, 0.0250 }
  cylinder { <1.2750, 0.9750, 0.3750>, <-1.2750, 0.9750, 0.3750>, 0.0250 }
  cylinder { <1.2750, -0.9750, 0.3750>, <-1.2750, -0.9750, 0.3750>, 0.0250 }
  cylinder { <1.2750, -0.9750, -0.3750>, <-1.2750, -0.9750, -0.3750>, 0.0250 }
  cylinder { <1.2750, 0.9750, -0.3750>, <-1.2750, 0.9750, -0.3750>, 0.0250 }
  cylinder { <1.2750, 0.9750, -0.3750>, <1.2750, 0.9750, 0.3750>, 0.0250 }
  cylinder { <1.2750, -0.9750, -0.3750>, <1.2750, -0.9750, 0.3750>, 0.0250 }
  cylinder { <-1.2750, -0.9750, -0.3750>, <-1.2750, -0.9750, 0.3750>, 0.0250 }
  cylinder { <-1.2750, 0.9750, -0.3750>, <-1.2750, 0.9750, 0.3750>, 0.0250 }
  cylinder { <1.2750, 0.9750, 0.3750>, <1.2750, -0.9750, 0.3750>, 0.0250 }
  cylinder { <1.2750, 0.9750, -0.3750>, <1.2750, -0.9750, -0.3750>, 0.0250 }
  cylinder { <-1.2750, 0.9750, -0.3750>, <-1.2750, -0.9750, -0.3750>, 0.0250 }
  cylinder { <-1.2750, 0.9750, 0.3750>, <-1.2750, -0.9750, 0.3750>, 0.0250 }
  box { <-1.2750, -0.9750, -0.4000> <1.2750, 0.9750, 0.4000> }
  box { <-1.2750, -1.0000, -0.3750> <1.2750, 1.0000, 0.3750> }
  box { <-1.3000, -0.9750, -0.3750> <1.3000, 0.9750, 0.3750> }
  material {
    T_Wood8_1
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  scale <0.75, 0.75, 1.0>
  translate  -0.058369*z
}
#declare absu = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      pareti
    }
    scale <0.95, 0.95, 0.75>
  }
  object { cornicesu }
  object { fcosu }
}
#declare portasu = union {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 1.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate  <0.0, 1.0, 1.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      legno1
    }
    scale <0.025641, 2.5, 1.4>
    translate  <0.0, -1.25, 0.368964>
  }
  material {
    portet
    scale 0.2
  }
  scale <0.39, 0.08, 0.2925>
  translate  <0.0, -1.001922, -0.338173>
}
#declare asu = difference {
  object { absu }
  object { portasu }
  box { // fsu
    <-1, -1, -1>, <1, 1, 1>
    material {
      finestre
    }
    scale <0.25, 0.65, 0.32>
    translate  <1.15, 0.0, -0.06>
  }
}
#declare cornicegiu = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 1.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate  <0.0, 1.0, 1.0>
  }
  material {
    T_Wood8_1
    scale 0.2
  }
  scale <0.6, 0.05, 0.45>
  translate  <0.0, -1.25, -2.6>
}
#declare pgiu = merge {
  sphere { <1.1750, 1.2500, 0.2250>, 0.0250 }
  sphere { <1.1750, -1.2500, 0.2250>, 0.0250 }
  sphere { <-1.1750, -1.2500, 0.2250>, 0.0250 }
  sphere { <-1.1750, 1.2500, 0.2250>, 0.0250 }
  sphere { <1.1750, 1.2500, -0.2250>, 0.0250 }
  sphere { <1.1750, -1.2500, -0.2250>, 0.0250 }
  sphere { <-1.1750, -1.2500, -0.2250>, 0.0250 }
  sphere { <-1.1750, 1.2500, -0.2250>, 0.0250 }
  cylinder { <1.1750, 1.2500, 0.2250>, <-1.1750, 1.2500, 0.2250>, 0.0250 }
  cylinder { <1.1750, -1.2500, 0.2250>, <-1.1750, -1.2500, 0.2250>, 0.0250 }
  cylinder { <1.1750, -1.2500, -0.2250>, <-1.1750, -1.2500, -0.2250>, 0.0250 }
  cylinder { <1.1750, 1.2500, -0.2250>, <-1.1750, 1.2500, -0.2250>, 0.0250 }
  cylinder { <1.1750, 1.2500, -0.2250>, <1.1750, 1.2500, 0.2250>, 0.0250 }
  cylinder { <1.1750, -1.2500, -0.2250>, <1.1750, -1.2500, 0.2250>, 0.0250 }
  cylinder { <-1.1750, -1.2500, -0.2250>, <-1.1750, -1.2500, 0.2250>, 0.0250 }
  cylinder { <-1.1750, 1.2500, -0.2250>, <-1.1750, 1.2500, 0.2250>, 0.0250 }
  cylinder { <1.1750, 1.2500, 0.2250>, <1.1750, -1.2500, 0.2250>, 0.0250 }
  cylinder { <1.1750, 1.2500, -0.2250>, <1.1750, -1.2500, -0.2250>, 0.0250 }
  cylinder { <-1.1750, 1.2500, -0.2250>, <-1.1750, -1.2500, -0.2250>, 0.0250 }
  cylinder { <-1.1750, 1.2500, 0.2250>, <-1.1750, -1.2500, 0.2250>, 0.0250 }
  box { <-1.1750, -1.2500, -0.2500> <1.1750, 1.2500, 0.2500> }
  box { <-1.1750, -1.2750, -0.2250> <1.1750, 1.2750, 0.2250> }
  box { <-1.2000, -1.2500, -0.2250> <1.2000, 1.2500, 0.2250> }
  material {
    legno2
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  translate  -2.9179*z
}
#declare fcogiu = merge {
  sphere { <1.2500, 1.1750, 0.3750>, 0.0250 }
  sphere { <1.2500, -1.1750, 0.3750>, 0.0250 }
  sphere { <-1.2500, -1.1750, 0.3750>, 0.0250 }
  sphere { <-1.2500, 1.1750, 0.3750>, 0.0250 }
  sphere { <1.2500, 1.1750, -0.3750>, 0.0250 }
  sphere { <1.2500, -1.1750, -0.3750>, 0.0250 }
  sphere { <-1.2500, -1.1750, -0.3750>, 0.0250 }
  sphere { <-1.2500, 1.1750, -0.3750>, 0.0250 }
  cylinder { <1.2500, 1.1750, 0.3750>, <-1.2500, 1.1750, 0.3750>, 0.0250 }
  cylinder { <1.2500, -1.1750, 0.3750>, <-1.2500, -1.1750, 0.3750>, 0.0250 }
  cylinder { <1.2500, -1.1750, -0.3750>, <-1.2500, -1.1750, -0.3750>, 0.0250 }
  cylinder { <1.2500, 1.1750, -0.3750>, <-1.2500, 1.1750, -0.3750>, 0.0250 }
  cylinder { <1.2500, 1.1750, -0.3750>, <1.2500, 1.1750, 0.3750>, 0.0250 }
  cylinder { <1.2500, -1.1750, -0.3750>, <1.2500, -1.1750, 0.3750>, 0.0250 }
  cylinder { <-1.2500, -1.1750, -0.3750>, <-1.2500, -1.1750, 0.3750>, 0.0250 }
  cylinder { <-1.2500, 1.1750, -0.3750>, <-1.2500, 1.1750, 0.3750>, 0.0250 }
  cylinder { <1.2500, 1.1750, 0.3750>, <1.2500, -1.1750, 0.3750>, 0.0250 }
  cylinder { <1.2500, 1.1750, -0.3750>, <1.2500, -1.1750, -0.3750>, 0.0250 }
  cylinder { <-1.2500, 1.1750, -0.3750>, <-1.2500, -1.1750, -0.3750>, 0.0250 }
  cylinder { <-1.2500, 1.1750, 0.3750>, <-1.2500, -1.1750, 0.3750>, 0.0250 }
  box { <-1.2500, -1.1750, -0.4000> <1.2500, 1.1750, 0.4000> }
  box { <-1.2500, -1.2000, -0.3750> <1.2500, 1.2000, 0.3750> }
  box { <-1.2750, -1.1750, -0.3750> <1.2750, 1.1750, 0.3750> }
  material {
    T_Wood8_1
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  translate  -2.200306*z
}
#declare abgiu = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      pareti
    }
    scale <1.25, 1.25, 1.0>
    translate  -2.212269*z
  }
  object { cornicegiu }
  object { pgiu }
  object { fcogiu }
}
#declare portagiu = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 1.0, 1.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate  <0.0, 1.0, 1.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      legno1
    }
    scale <0.04931, 1.903642, 1.5>
    rotate -0.0*x
    translate  <0.0, 0.625, 0.51442>
  }
  material {
    portet
    scale 0.2
  }
  scale <0.52, 0.08, 0.39>
  translate  <0.0, -1.3, -2.6>
}
#declare agiu = difference {
  object { abgiu }
  object { portagiu }
  box { // fgiu
    <-1, -1, -1>, <1, 1, 1>
    material {
      finestre
    }
    scale <0.25, 1.1, 0.3>
    translate  <1.45, 0.0, -2.200241>
  }
}
#declare Group010 = union {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
}
#declare Group011 = union {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
  rotate -90.0*z
  translate  0.03*z
}
#declare Group012 = union {
  object { Group010 }
  object { Group011 }
  translate  -0.264829*z
}
#declare Group007 = union {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
}
#declare Group008 = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
  rotate -90.0*z
  translate  0.03*z
}
#declare Group009 = union {
  object { Group007 }
  object { Group008 }
  translate  -0.180868*z
}
#declare Group001 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
}
#declare Group002 = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
  rotate -90.0*z
  translate  0.03*z
}
#declare Group003 = union {
  object { Group001 }
  object { Group002 }
}
#declare Group004 = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
}
#declare Group005 = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <1.3, 1.6, -0.5>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Wood8
    }
    scale <0.03, 0.03, 3.2>
    rotate 90.0*x
    translate  <-1.3, 1.6, -0.5>
  }
  rotate -90.0*z
  translate  0.03*z
}
#declare Group006 = union {
  object { Group004 }
  object { Group005 }
  translate  -0.090347*z
}
#declare staccion = union {
  object { Group012 }
  object { Group009 }
  object { Group003 }
  object { Group006 }
}
#declare Rcube = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <1.25, -1.25, -2.21>
}
#declare RndCube002 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <-1.25, -1.25, -2.21>
}
#declare RndCube003 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <1.25, 1.25, -2.21>
}
#declare RndCube004 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <-1.25, 1.25, -2.21>
}
#declare Vertgiu = union {
  object { Rcube }
  object { RndCube002 }
  object { RndCube003 }
  object { RndCube004 }
}
#declare Tgiu = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.005313, -0.005313, -1.250000>, <0.005087, -0.005538, -1.250000>, <0.004569, -0.005313, -1.250000>, <0.004250, -0.005313, -1.250000>, 
      <0.381203, -0.381203, -1.250000>, <0.380978, -0.381429, -1.250000>, <0.305281, -0.381203, -1.250000>, <0.304963, -0.381203, -1.250000>, 
      <0.883316, -0.883316, -1.212711>, <0.829932, -0.936701, -1.212711>, <0.783008, -0.884389, -1.200423>, <0.707511, -0.884389, -1.200423>, 
      <1.258281, -1.258281, -1.250000>, <1.204897, -1.311665, -1.250000>, <1.082122, -1.258281, -1.250000>, <1.006625, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.005313, -0.004250, -1.250000>, <0.005313, -0.004569, -1.250000>, <0.005538, -0.005087, -1.250000>, <0.005313, -0.005313, -1.250000>, 
      <0.381203, -0.304963, -1.250000>, <0.381203, -0.305281, -1.250000>, <0.381429, -0.380978, -1.250000>, <0.381203, -0.381203, -1.250000>, 
      <0.884389, -0.707512, -1.200423>, <0.884389, -0.783008, -1.200423>, <0.936701, -0.829932, -1.212711>, <0.883316, -0.883316, -1.212711>, 
      <1.258281, -1.006625, -1.250000>, <1.258281, -1.082122, -1.250000>, <1.311665, -1.204897, -1.250000>, <1.258281, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.005313, 0.004250, -1.250000>, <0.005313, 0.001700, -1.250000>, <0.005313, -0.001700, -1.250000>, <0.005313, -0.004250, -1.250000>, 
      <0.381203, 0.304963, -1.250000>, <0.381203, 0.302412, -1.250000>, <0.381203, -0.302412, -1.250000>, <0.381203, -0.304963, -1.250000>, 
      <0.884389, 0.707512, -1.200423>, <0.884389, 0.103537, -1.200423>, <0.884389, -0.103537, -1.200423>, <0.884389, -0.707512, -1.200423>, 
      <1.258281, 1.006625, -1.250000>, <1.258281, 0.402650, -1.250000>, <1.258281, -0.402650, -1.250000>, <1.258281, -1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.005313, 0.005313, -1.250000>, <0.005538, 0.005087, -1.250000>, <0.005313, 0.004569, -1.250000>, <0.005313, 0.004250, -1.250000>, 
      <0.381203, 0.381203, -1.250000>, <0.381429, 0.380978, -1.250000>, <0.381203, 0.305281, -1.250000>, <0.381203, 0.304963, -1.250000>, 
      <0.883316, 0.883316, -1.212711>, <0.936701, 0.829932, -1.212711>, <0.884389, 0.783008, -1.200423>, <0.884389, 0.707512, -1.200423>, 
      <1.258281, 1.258281, -1.250000>, <1.311665, 1.204897, -1.250000>, <1.258281, 1.082122, -1.250000>, <1.258281, 1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.004250, 0.005313, -1.250000>, <0.004569, 0.005313, -1.250000>, <0.005087, 0.005538, -1.250000>, <0.005313, 0.005313, -1.250000>, 
      <0.304963, 0.381203, -1.250000>, <0.305281, 0.381203, -1.250000>, <0.380978, 0.381429, -1.250000>, <0.381203, 0.381203, -1.250000>, 
      <0.707511, 0.884389, -1.200423>, <0.783008, 0.884389, -1.200423>, <0.829932, 0.936701, -1.212711>, <0.883316, 0.883316, -1.212711>, 
      <1.006625, 1.258281, -1.250000>, <1.082122, 1.258281, -1.250000>, <1.204897, 1.311665, -1.250000>, <1.258281, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.004250, 0.005313, -1.250000>, <-0.001700, 0.005313, -1.250000>, <0.001700, 0.005313, -1.250000>, <0.004250, 0.005313, -1.250000>, 
      <-0.304963, 0.381203, -1.250000>, <-0.302412, 0.381203, -1.250000>, <0.302412, 0.381203, -1.250000>, <0.304963, 0.381203, -1.250000>, 
      <-0.707512, 0.884389, -1.200423>, <-0.103537, 0.884389, -1.200423>, <0.103537, 0.884389, -1.200423>, <0.707511, 0.884389, -1.200423>, 
      <-1.006625, 1.258281, -1.250000>, <-0.402650, 1.258281, -1.250000>, <0.402650, 1.258281, -1.250000>, <1.006625, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.005313, 0.005313, -1.250000>, <-0.005087, 0.005538, -1.250000>, <-0.004569, 0.005313, -1.250000>, <-0.004250, 0.005313, -1.250000>, 
      <-0.381203, 0.381203, -1.250000>, <-0.380978, 0.381429, -1.250000>, <-0.305281, 0.381203, -1.250000>, <-0.304963, 0.381203, -1.250000>, 
      <-0.883316, 0.883316, -1.212711>, <-0.829932, 0.936701, -1.212711>, <-0.783008, 0.884389, -1.200423>, <-0.707512, 0.884389, -1.200423>, 
      <-1.258281, 1.258281, -1.250000>, <-1.204897, 1.311665, -1.250000>, <-1.082122, 1.258281, -1.250000>, <-1.006625, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.005313, 0.004250, -1.250000>, <-0.005313, 0.004569, -1.250000>, <-0.005538, 0.005087, -1.250000>, <-0.005313, 0.005313, -1.250000>, 
      <-0.381203, 0.304963, -1.250000>, <-0.381203, 0.305281, -1.250000>, <-0.381429, 0.380978, -1.250000>, <-0.381203, 0.381203, -1.250000>, 
      <-0.884389, 0.707512, -1.200423>, <-0.884389, 0.783008, -1.200423>, <-0.936701, 0.829932, -1.212711>, <-0.883316, 0.883316, -1.212711>, 
      <-1.258281, 1.006625, -1.250000>, <-1.258281, 1.082122, -1.250000>, <-1.311665, 1.204897, -1.250000>, <-1.258281, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.005313, -0.004250, -1.250000>, <-0.005313, -0.001700, -1.250000>, <-0.005313, 0.001700, -1.250000>, <-0.005313, 0.004250, -1.250000>, 
      <-0.381203, -0.304963, -1.250000>, <-0.381203, -0.302412, -1.250000>, <-0.381203, 0.302412, -1.250000>, <-0.381203, 0.304963, -1.250000>, 
      <-0.884389, -0.707512, -1.200423>, <-0.884389, -0.103537, -1.200423>, <-0.884389, 0.103537, -1.200423>, <-0.884389, 0.707512, -1.200423>, 
      <-1.258281, -1.006625, -1.250000>, <-1.258281, -0.402650, -1.250000>, <-1.258281, 0.402650, -1.250000>, <-1.258281, 1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.005313, -0.005313, -1.250000>, <-0.005538, -0.005087, -1.250000>, <-0.005313, -0.004569, -1.250000>, <-0.005313, -0.004250, -1.250000>, 
      <-0.381203, -0.381203, -1.250000>, <-0.381429, -0.380978, -1.250000>, <-0.381203, -0.305281, -1.250000>, <-0.381203, -0.304963, -1.250000>, 
      <-0.883316, -0.883316, -1.212711>, <-0.936701, -0.829932, -1.212711>, <-0.884389, -0.783008, -1.200423>, <-0.884389, -0.707512, -1.200423>, 
      <-1.258281, -1.258281, -1.250000>, <-1.311665, -1.204897, -1.250000>, <-1.258281, -1.082122, -1.250000>, <-1.258281, -1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.004250, -0.005313, -1.250000>, <-0.004569, -0.005313, -1.250000>, <-0.005087, -0.005538, -1.250000>, <-0.005313, -0.005313, -1.250000>, 
      <-0.304963, -0.381203, -1.250000>, <-0.305281, -0.381203, -1.250000>, <-0.380978, -0.381429, -1.250000>, <-0.381203, -0.381203, -1.250000>, 
      <-0.707512, -0.884389, -1.200423>, <-0.783008, -0.884389, -1.200423>, <-0.829932, -0.936701, -1.212711>, <-0.883316, -0.883316, -1.212711>, 
      <-1.006625, -1.258281, -1.250000>, <-1.082122, -1.258281, -1.250000>, <-1.204897, -1.311665, -1.250000>, <-1.258281, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.004250, -0.005313, -1.250000>, <-0.304963, -0.381203, -1.250000>, <-0.707512, -0.884389, -1.200423>, <-1.006625, -1.258281, -1.250000>, 
      <-0.001700, -0.005313, -1.250000>, <-0.302412, -0.381203, -1.250000>, <-0.103537, -0.884389, -1.200423>, <-0.402650, -1.258281, -1.250000>, 
      <0.001700, -0.005313, -1.250000>, <0.302412, -0.381203, -1.250000>, <0.103537, -0.884389, -1.200423>, <0.402650, -1.258281, -1.250000>, 
      <0.004250, -0.005313, -1.250000>, <0.304963, -0.381203, -1.250000>, <0.707511, -0.884389, -1.200423>, <1.006625, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.890728, -1.890728, -1.437500>, <1.715500, -1.715500, -1.320227>, <1.451662, -1.451662, -1.269231>, <1.258281, -1.258281, -1.250000>, 
      <1.809422, -1.972033, -1.437500>, <1.634195, -1.796806, -1.320227>, <1.398277, -1.505046, -1.269231>, <1.204897, -1.311665, -1.250000>, 
      <1.627545, -1.890728, -1.497889>, <1.486758, -1.714743, -1.380110>, <1.240130, -1.455792, -1.276189>, <1.082122, -1.258281, -1.250000>, 
      <1.512582, -1.890728, -1.500000>, <1.371795, -1.714743, -1.382221>, <1.164634, -1.455792, -1.276189>, <1.006625, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.890728, -1.512582, -1.500000>, <1.714743, -1.371795, -1.382221>, <1.455792, -1.164634, -1.276189>, <1.258281, -1.006625, -1.250000>, 
      <1.890728, -1.627545, -1.497889>, <1.714743, -1.486758, -1.380110>, <1.455792, -1.240130, -1.276189>, <1.258281, -1.082122, -1.250000>, 
      <1.972033, -1.809422, -1.437500>, <1.796806, -1.634195, -1.320227>, <1.505046, -1.398277, -1.269231>, <1.311665, -1.204897, -1.250000>, 
      <1.890728, -1.890728, -1.437500>, <1.715500, -1.715500, -1.320227>, <1.451662, -1.451662, -1.269231>, <1.258281, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.890728, 1.512582, -1.500000>, <1.714743, 1.371795, -1.382221>, <1.455792, 1.164634, -1.276189>, <1.258281, 1.006625, -1.250000>, 
      <1.890728, 0.605186, -1.516664>, <1.714743, 0.464399, -1.398885>, <1.455792, 0.560659, -1.276189>, <1.258281, 0.402650, -1.250000>, 
      <1.890728, -0.605186, -1.516664>, <1.714743, -0.464399, -1.398885>, <1.455792, -0.560659, -1.276189>, <1.258281, -0.402650, -1.250000>, 
      <1.890728, -1.512582, -1.500000>, <1.714743, -1.371795, -1.382221>, <1.455792, -1.164634, -1.276189>, <1.258281, -1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.890728, 1.890728, -1.437500>, <1.715500, 1.715500, -1.320227>, <1.451662, 1.451662, -1.269231>, <1.258281, 1.258281, -1.250000>, 
      <1.972033, 1.809422, -1.437500>, <1.796806, 1.634195, -1.320227>, <1.505046, 1.398277, -1.269231>, <1.311665, 1.204897, -1.250000>, 
      <1.890728, 1.627545, -1.497889>, <1.714743, 1.486758, -1.380110>, <1.455792, 1.240130, -1.276189>, <1.258281, 1.082122, -1.250000>, 
      <1.890728, 1.512582, -1.500000>, <1.714743, 1.371795, -1.382221>, <1.455792, 1.164634, -1.276189>, <1.258281, 1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.512582, 1.890728, -1.500000>, <1.371795, 1.714743, -1.382221>, <1.164634, 1.455792, -1.276189>, <1.006625, 1.258281, -1.250000>, 
      <1.627545, 1.890728, -1.497889>, <1.486758, 1.714743, -1.380110>, <1.240130, 1.455792, -1.276189>, <1.082122, 1.258281, -1.250000>, 
      <1.809422, 1.972033, -1.437500>, <1.634195, 1.796806, -1.320227>, <1.398277, 1.505046, -1.269231>, <1.204897, 1.311665, -1.250000>, 
      <1.890728, 1.890728, -1.437500>, <1.715500, 1.715500, -1.320227>, <1.451662, 1.451662, -1.269231>, <1.258281, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.512582, 1.890728, -1.500000>, <-1.371795, 1.714743, -1.382221>, <-1.164634, 1.455792, -1.276189>, <-1.006625, 1.258281, -1.250000>, 
      <-0.605186, 1.890728, -1.516664>, <-0.464399, 1.714743, -1.398885>, <-0.560659, 1.455792, -1.276189>, <-0.402650, 1.258281, -1.250000>, 
      <0.605186, 1.890728, -1.516664>, <0.464399, 1.714743, -1.398885>, <0.560659, 1.455792, -1.276189>, <0.402650, 1.258281, -1.250000>, 
      <1.512582, 1.890728, -1.500000>, <1.371795, 1.714743, -1.382221>, <1.164634, 1.455792, -1.276189>, <1.006625, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.890728, 1.890728, -1.437500>, <-1.715500, 1.715500, -1.320227>, <-1.451662, 1.451662, -1.269231>, <-1.258281, 1.258281, -1.250000>, 
      <-1.809422, 1.972033, -1.437500>, <-1.634195, 1.796806, -1.320227>, <-1.398277, 1.505046, -1.269231>, <-1.204897, 1.311665, -1.250000>, 
      <-1.627545, 1.890728, -1.497889>, <-1.486758, 1.714743, -1.380110>, <-1.240130, 1.455792, -1.276189>, <-1.082122, 1.258281, -1.250000>, 
      <-1.512582, 1.890728, -1.500000>, <-1.371795, 1.714743, -1.382221>, <-1.164634, 1.455792, -1.276189>, <-1.006625, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.890728, 1.512582, -1.500000>, <-1.714743, 1.371795, -1.382221>, <-1.455792, 1.164634, -1.276189>, <-1.258281, 1.006625, -1.250000>, 
      <-1.890728, 1.627545, -1.497889>, <-1.714743, 1.486758, -1.380110>, <-1.455792, 1.240130, -1.276189>, <-1.258281, 1.082122, -1.250000>, 
      <-1.972033, 1.809422, -1.437500>, <-1.796806, 1.634195, -1.320227>, <-1.505046, 1.398277, -1.269231>, <-1.311665, 1.204897, -1.250000>, 
      <-1.890728, 1.890728, -1.437500>, <-1.715500, 1.715500, -1.320227>, <-1.451662, 1.451662, -1.269231>, <-1.258281, 1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.890728, -1.512582, -1.500000>, <-1.714743, -1.371795, -1.382221>, <-1.455792, -1.164634, -1.276189>, <-1.258281, -1.006625, -1.250000>, 
      <-1.890728, -0.605186, -1.516664>, <-1.714743, -0.464399, -1.398885>, <-1.455792, -0.560659, -1.276189>, <-1.258281, -0.402650, -1.250000>, 
      <-1.890728, 0.605186, -1.516664>, <-1.714743, 0.464399, -1.398885>, <-1.455792, 0.560659, -1.276189>, <-1.258281, 0.402650, -1.250000>, 
      <-1.890728, 1.512582, -1.500000>, <-1.714743, 1.371795, -1.382221>, <-1.455792, 1.164634, -1.276189>, <-1.258281, 1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.890728, -1.890728, -1.437500>, <-1.715500, -1.715500, -1.320227>, <-1.451662, -1.451662, -1.269231>, <-1.258281, -1.258281, -1.250000>, 
      <-1.972033, -1.809422, -1.437500>, <-1.796806, -1.634195, -1.320227>, <-1.505046, -1.398277, -1.269231>, <-1.311665, -1.204897, -1.250000>, 
      <-1.890728, -1.627545, -1.497889>, <-1.714743, -1.486758, -1.380110>, <-1.455792, -1.240130, -1.276189>, <-1.258281, -1.082122, -1.250000>, 
      <-1.890728, -1.512582, -1.500000>, <-1.714743, -1.371795, -1.382221>, <-1.455792, -1.164634, -1.276189>, <-1.258281, -1.006625, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.512582, -1.890728, -1.500000>, <-1.371795, -1.714743, -1.382221>, <-1.164634, -1.455792, -1.276189>, <-1.006625, -1.258281, -1.250000>, 
      <-1.627545, -1.890728, -1.497889>, <-1.486758, -1.714743, -1.380110>, <-1.240130, -1.455792, -1.276189>, <-1.082122, -1.258281, -1.250000>, 
      <-1.809422, -1.972033, -1.437500>, <-1.634195, -1.796806, -1.320227>, <-1.398277, -1.505046, -1.269231>, <-1.204897, -1.311665, -1.250000>, 
      <-1.890728, -1.890728, -1.437500>, <-1.715500, -1.715500, -1.320227>, <-1.451662, -1.451662, -1.269231>, <-1.258281, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.512582, -1.890728, -1.500000>, <-0.605186, -1.890728, -1.516664>, <0.605186, -1.890728, -1.516664>, <1.512582, -1.890728, -1.500000>, 
      <-1.371795, -1.714743, -1.382221>, <-0.464399, -1.714743, -1.398885>, <0.464399, -1.714743, -1.398885>, <1.371795, -1.714743, -1.382221>, 
      <-1.164634, -1.455792, -1.276189>, <-0.560659, -1.455792, -1.276189>, <0.560659, -1.455792, -1.276189>, <1.164634, -1.455792, -1.276189>, 
      <-1.006625, -1.258281, -1.250000>, <-0.402650, -1.258281, -1.250000>, <0.402650, -1.258281, -1.250000>, <1.006625, -1.258281, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.725215, -1.725215, -1.562500>, <1.762545, -1.762545, -1.502917>, <1.941608, -1.941608, -1.471552>, <1.890728, -1.890728, -1.437500>, 
      <1.652020, -1.798410, -1.562500>, <1.689350, -1.835740, -1.502917>, <1.860303, -2.022913, -1.471552>, <1.809422, -1.972033, -1.437500>, 
      <1.483684, -1.725215, -1.562500>, <1.515537, -1.765031, -1.520132>, <1.664249, -1.936608, -1.528595>, <1.627545, -1.890728, -1.497889>, 
      <1.380170, -1.725215, -1.562500>, <1.412023, -1.765031, -1.520132>, <1.549286, -1.936608, -1.530706>, <1.512582, -1.890728, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.725215, -1.380170, -1.562500>, <1.765031, -1.412023, -1.520132>, <1.936608, -1.549286, -1.530706>, <1.890728, -1.512582, -1.500000>, 
      <1.725215, -1.483684, -1.562500>, <1.765031, -1.515537, -1.520132>, <1.936608, -1.664249, -1.528595>, <1.890728, -1.627545, -1.497889>, 
      <1.798410, -1.652020, -1.562500>, <1.835740, -1.689350, -1.502917>, <2.022913, -1.860303, -1.471552>, <1.972033, -1.809422, -1.437500>, 
      <1.725215, -1.725215, -1.562500>, <1.762545, -1.762545, -1.502917>, <1.941608, -1.941608, -1.471552>, <1.890728, -1.890728, -1.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.725215, 1.380170, -1.562500>, <1.765031, 1.412023, -1.520132>, <1.936608, 1.549286, -1.530706>, <1.890728, 1.512582, -1.500000>, 
      <1.725215, 0.552068, -1.562500>, <1.765031, 0.583921, -1.520132>, <1.936608, 0.641890, -1.547370>, <1.890728, 0.605186, -1.516664>, 
      <1.725215, -0.552068, -1.562500>, <1.765031, -0.583921, -1.520132>, <1.936608, -0.641890, -1.547370>, <1.890728, -0.605186, -1.516664>, 
      <1.725215, -1.380170, -1.562500>, <1.765031, -1.412023, -1.520132>, <1.936608, -1.549286, -1.530706>, <1.890728, -1.512582, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.725215, 1.725215, -1.562500>, <1.762545, 1.762545, -1.502917>, <1.941608, 1.941608, -1.471552>, <1.890728, 1.890728, -1.437500>, 
      <1.798410, 1.652020, -1.562500>, <1.835740, 1.689350, -1.502917>, <2.022913, 1.860303, -1.471552>, <1.972033, 1.809422, -1.437500>, 
      <1.725215, 1.483684, -1.562500>, <1.765031, 1.515537, -1.520132>, <1.936608, 1.664249, -1.528595>, <1.890728, 1.627545, -1.497889>, 
      <1.725215, 1.380170, -1.562500>, <1.765031, 1.412023, -1.520132>, <1.936608, 1.549286, -1.530706>, <1.890728, 1.512582, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.380170, 1.725215, -1.562500>, <1.412023, 1.765031, -1.520132>, <1.549286, 1.936608, -1.530706>, <1.512582, 1.890728, -1.500000>, 
      <1.483684, 1.725215, -1.562500>, <1.515537, 1.765031, -1.520132>, <1.664249, 1.936608, -1.528595>, <1.627545, 1.890728, -1.497889>, 
      <1.652020, 1.798410, -1.562500>, <1.689350, 1.835740, -1.502917>, <1.860303, 2.022913, -1.471552>, <1.809422, 1.972033, -1.437500>, 
      <1.725215, 1.725215, -1.562500>, <1.762545, 1.762545, -1.502917>, <1.941608, 1.941608, -1.471552>, <1.890728, 1.890728, -1.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.380170, 1.725215, -1.562500>, <-1.412023, 1.765031, -1.520132>, <-1.549286, 1.936608, -1.530706>, <-1.512582, 1.890728, -1.500000>, 
      <-0.552068, 1.725215, -1.562500>, <-0.583921, 1.765031, -1.520132>, <-0.641890, 1.936608, -1.547370>, <-0.605186, 1.890728, -1.516664>, 
      <0.552068, 1.725215, -1.562500>, <0.583921, 1.765031, -1.520132>, <0.641890, 1.936608, -1.547370>, <0.605186, 1.890728, -1.516664>, 
      <1.380170, 1.725215, -1.562500>, <1.412023, 1.765031, -1.520132>, <1.549286, 1.936608, -1.530706>, <1.512582, 1.890728, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.725215, 1.725215, -1.562500>, <-1.762545, 1.762545, -1.502917>, <-1.941608, 1.941608, -1.471552>, <-1.890728, 1.890728, -1.437500>, 
      <-1.652020, 1.798410, -1.562500>, <-1.689350, 1.835740, -1.502917>, <-1.860303, 2.022913, -1.471552>, <-1.809422, 1.972033, -1.437500>, 
      <-1.483684, 1.725215, -1.562500>, <-1.515537, 1.765031, -1.520132>, <-1.664249, 1.936608, -1.528595>, <-1.627545, 1.890728, -1.497889>, 
      <-1.380170, 1.725215, -1.562500>, <-1.412023, 1.765031, -1.520132>, <-1.549286, 1.936608, -1.530706>, <-1.512582, 1.890728, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.725215, 1.380170, -1.562500>, <-1.765031, 1.412023, -1.520132>, <-1.936608, 1.549286, -1.530706>, <-1.890728, 1.512582, -1.500000>, 
      <-1.725215, 1.483684, -1.562500>, <-1.765031, 1.515537, -1.520132>, <-1.936608, 1.664249, -1.528595>, <-1.890728, 1.627545, -1.497889>, 
      <-1.798410, 1.652020, -1.562500>, <-1.835740, 1.689350, -1.502917>, <-2.022913, 1.860303, -1.471552>, <-1.972033, 1.809422, -1.437500>, 
      <-1.725215, 1.725215, -1.562500>, <-1.762545, 1.762545, -1.502917>, <-1.941608, 1.941608, -1.471552>, <-1.890728, 1.890728, -1.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.725215, -1.380170, -1.562500>, <-1.765031, -1.412023, -1.520132>, <-1.936608, -1.549286, -1.530706>, <-1.890728, -1.512582, -1.500000>, 
      <-1.725215, -0.552068, -1.562500>, <-1.765031, -0.583921, -1.520132>, <-1.936608, -0.641890, -1.547370>, <-1.890728, -0.605186, -1.516664>, 
      <-1.725215, 0.552068, -1.562500>, <-1.765031, 0.583921, -1.520132>, <-1.936608, 0.641890, -1.547370>, <-1.890728, 0.605186, -1.516664>, 
      <-1.725215, 1.380170, -1.562500>, <-1.765031, 1.412023, -1.520132>, <-1.936608, 1.549286, -1.530706>, <-1.890728, 1.512582, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.725215, -1.725215, -1.562500>, <-1.762545, -1.762545, -1.502917>, <-1.941608, -1.941608, -1.471552>, <-1.890728, -1.890728, -1.437500>, 
      <-1.798410, -1.652020, -1.562500>, <-1.835740, -1.689350, -1.502917>, <-2.022913, -1.860303, -1.471552>, <-1.972033, -1.809422, -1.437500>, 
      <-1.725215, -1.483684, -1.562500>, <-1.765031, -1.515537, -1.520132>, <-1.936608, -1.664249, -1.528595>, <-1.890728, -1.627545, -1.497889>, 
      <-1.725215, -1.380170, -1.562500>, <-1.765031, -1.412023, -1.520132>, <-1.936608, -1.549286, -1.530706>, <-1.890728, -1.512582, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.380170, -1.725215, -1.562500>, <-1.412023, -1.765031, -1.520132>, <-1.549286, -1.936608, -1.530706>, <-1.512582, -1.890728, -1.500000>, 
      <-1.483684, -1.725215, -1.562500>, <-1.515537, -1.765031, -1.520132>, <-1.664249, -1.936608, -1.528595>, <-1.627545, -1.890728, -1.497889>, 
      <-1.652020, -1.798410, -1.562500>, <-1.689350, -1.835740, -1.502917>, <-1.860303, -2.022913, -1.471552>, <-1.809422, -1.972033, -1.437500>, 
      <-1.725215, -1.725215, -1.562500>, <-1.762545, -1.762545, -1.502917>, <-1.941608, -1.941608, -1.471552>, <-1.890728, -1.890728, -1.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.380170, -1.725215, -1.562500>, <-0.552068, -1.725215, -1.562500>, <0.552068, -1.725215, -1.562500>, <1.380170, -1.725215, -1.562500>, 
      <-1.412023, -1.765031, -1.520132>, <-0.583921, -1.765031, -1.520132>, <0.583921, -1.765031, -1.520132>, <1.412023, -1.765031, -1.520132>, 
      <-1.549286, -1.936608, -1.530706>, <-0.641890, -1.936608, -1.547370>, <0.641890, -1.936608, -1.547370>, <1.549286, -1.936608, -1.530706>, 
      <-1.512582, -1.890728, -1.500000>, <-0.605186, -1.890728, -1.516664>, <0.605186, -1.890728, -1.516664>, <1.512582, -1.890728, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, -1.773256, -1.625000>, <1.758844, -1.758844, -1.606250>, <1.712228, -1.712228, -1.583229>, <1.725215, -1.725215, -1.562500>, 
      <1.698023, -1.848489, -1.625000>, <1.683611, -1.834076, -1.606250>, <1.639033, -1.785423, -1.583229>, <1.652020, -1.798410, -1.562500>, 
      <1.525000, -1.773256, -1.625000>, <1.513470, -1.758844, -1.606250>, <1.471042, -1.709413, -1.579315>, <1.483684, -1.725215, -1.562500>, 
      <1.418605, -1.773256, -1.625000>, <1.407074, -1.758844, -1.606250>, <1.367529, -1.709413, -1.579315>, <1.380170, -1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, -1.418605, -1.625000>, <1.758844, -1.407074, -1.606250>, <1.709413, -1.367529, -1.579315>, <1.725215, -1.380170, -1.562500>, 
      <1.773256, -1.525000, -1.625000>, <1.758844, -1.513470, -1.606250>, <1.709413, -1.471042, -1.579315>, <1.725215, -1.483684, -1.562500>, 
      <1.848489, -1.698023, -1.625000>, <1.834076, -1.683611, -1.606250>, <1.785423, -1.639033, -1.583229>, <1.798410, -1.652020, -1.562500>, 
      <1.773256, -1.773256, -1.625000>, <1.758844, -1.758844, -1.606250>, <1.712228, -1.712228, -1.583229>, <1.725215, -1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, 1.418605, -1.625000>, <1.758844, 1.407074, -1.606250>, <1.709413, 1.367529, -1.579315>, <1.725215, 1.380170, -1.562500>, 
      <1.773256, 0.567442, -1.625000>, <1.758844, 0.555912, -1.606250>, <1.709413, 0.539427, -1.579315>, <1.725215, 0.552068, -1.562500>, 
      <1.773256, -0.567442, -1.625000>, <1.758844, -0.555912, -1.606250>, <1.709413, -0.539427, -1.579315>, <1.725215, -0.552068, -1.562500>, 
      <1.773256, -1.418605, -1.625000>, <1.758844, -1.407074, -1.606250>, <1.709413, -1.367529, -1.579315>, <1.725215, -1.380170, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, 1.773256, -1.625000>, <1.758844, 1.758844, -1.606250>, <1.712228, 1.712228, -1.583229>, <1.725215, 1.725215, -1.562500>, 
      <1.848489, 1.698023, -1.625000>, <1.834076, 1.683611, -1.606250>, <1.785423, 1.639033, -1.583229>, <1.798410, 1.652020, -1.562500>, 
      <1.773256, 1.525000, -1.625000>, <1.758844, 1.513470, -1.606250>, <1.709413, 1.471042, -1.579315>, <1.725215, 1.483684, -1.562500>, 
      <1.773256, 1.418605, -1.625000>, <1.758844, 1.407074, -1.606250>, <1.709413, 1.367529, -1.579315>, <1.725215, 1.380170, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.418605, 1.773256, -1.625000>, <1.407074, 1.758844, -1.606250>, <1.367529, 1.709413, -1.579315>, <1.380170, 1.725215, -1.562500>, 
      <1.525000, 1.773256, -1.625000>, <1.513470, 1.758844, -1.606250>, <1.471042, 1.709413, -1.579315>, <1.483684, 1.725215, -1.562500>, 
      <1.698023, 1.848489, -1.625000>, <1.683611, 1.834076, -1.606250>, <1.639033, 1.785423, -1.583229>, <1.652020, 1.798410, -1.562500>, 
      <1.773256, 1.773256, -1.625000>, <1.758844, 1.758844, -1.606250>, <1.712228, 1.712228, -1.583229>, <1.725215, 1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, 1.773256, -1.625000>, <-1.407074, 1.758844, -1.606250>, <-1.367529, 1.709413, -1.579315>, <-1.380170, 1.725215, -1.562500>, 
      <-0.567442, 1.773256, -1.625000>, <-0.555912, 1.758844, -1.606250>, <-0.539427, 1.709413, -1.579315>, <-0.552068, 1.725215, -1.562500>, 
      <0.567442, 1.773256, -1.625000>, <0.555912, 1.758844, -1.606250>, <0.539427, 1.709413, -1.579315>, <0.552068, 1.725215, -1.562500>, 
      <1.418605, 1.773256, -1.625000>, <1.407074, 1.758844, -1.606250>, <1.367529, 1.709413, -1.579315>, <1.380170, 1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, 1.773256, -1.625000>, <-1.758844, 1.758844, -1.606250>, <-1.712228, 1.712228, -1.583229>, <-1.725215, 1.725215, -1.562500>, 
      <-1.698023, 1.848489, -1.625000>, <-1.683611, 1.834076, -1.606250>, <-1.639033, 1.785423, -1.583229>, <-1.652020, 1.798410, -1.562500>, 
      <-1.525000, 1.773256, -1.625000>, <-1.513470, 1.758844, -1.606250>, <-1.471042, 1.709413, -1.579315>, <-1.483684, 1.725215, -1.562500>, 
      <-1.418605, 1.773256, -1.625000>, <-1.407074, 1.758844, -1.606250>, <-1.367529, 1.709413, -1.579315>, <-1.380170, 1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, 1.418605, -1.625000>, <-1.758844, 1.407074, -1.606250>, <-1.709413, 1.367529, -1.579315>, <-1.725215, 1.380170, -1.562500>, 
      <-1.773256, 1.525000, -1.625000>, <-1.758844, 1.513470, -1.606250>, <-1.709413, 1.471042, -1.579315>, <-1.725215, 1.483684, -1.562500>, 
      <-1.848489, 1.698023, -1.625000>, <-1.834076, 1.683611, -1.606250>, <-1.785423, 1.639033, -1.583229>, <-1.798410, 1.652020, -1.562500>, 
      <-1.773256, 1.773256, -1.625000>, <-1.758844, 1.758844, -1.606250>, <-1.712228, 1.712228, -1.583229>, <-1.725215, 1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, -1.418605, -1.625000>, <-1.758844, -1.407074, -1.606250>, <-1.709413, -1.367529, -1.579315>, <-1.725215, -1.380170, -1.562500>, 
      <-1.773256, -0.567442, -1.625000>, <-1.758844, -0.555912, -1.606250>, <-1.709413, -0.539427, -1.579315>, <-1.725215, -0.552068, -1.562500>, 
      <-1.773256, 0.567442, -1.625000>, <-1.758844, 0.555912, -1.606250>, <-1.709413, 0.539427, -1.579315>, <-1.725215, 0.552068, -1.562500>, 
      <-1.773256, 1.418605, -1.625000>, <-1.758844, 1.407074, -1.606250>, <-1.709413, 1.367529, -1.579315>, <-1.725215, 1.380170, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, -1.773256, -1.625000>, <-1.758844, -1.758844, -1.606250>, <-1.712228, -1.712228, -1.583229>, <-1.725215, -1.725215, -1.562500>, 
      <-1.848489, -1.698023, -1.625000>, <-1.834076, -1.683611, -1.606250>, <-1.785423, -1.639033, -1.583229>, <-1.798410, -1.652020, -1.562500>, 
      <-1.773256, -1.525000, -1.625000>, <-1.758844, -1.513470, -1.606250>, <-1.709413, -1.471042, -1.579315>, <-1.725215, -1.483684, -1.562500>, 
      <-1.773256, -1.418605, -1.625000>, <-1.758844, -1.407074, -1.606250>, <-1.709413, -1.367529, -1.579315>, <-1.725215, -1.380170, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, -1.773256, -1.625000>, <-1.407074, -1.758844, -1.606250>, <-1.367529, -1.709413, -1.579315>, <-1.380170, -1.725215, -1.562500>, 
      <-1.525000, -1.773256, -1.625000>, <-1.513470, -1.758844, -1.606250>, <-1.471042, -1.709413, -1.579315>, <-1.483684, -1.725215, -1.562500>, 
      <-1.698023, -1.848489, -1.625000>, <-1.683611, -1.834076, -1.606250>, <-1.639033, -1.785423, -1.583229>, <-1.652020, -1.798410, -1.562500>, 
      <-1.773256, -1.773256, -1.625000>, <-1.758844, -1.758844, -1.606250>, <-1.712228, -1.712228, -1.583229>, <-1.725215, -1.725215, -1.562500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, -1.773256, -1.625000>, <-0.567442, -1.773256, -1.625000>, <0.567442, -1.773256, -1.625000>, <1.418605, -1.773256, -1.625000>, 
      <-1.407074, -1.758844, -1.606250>, <-0.555912, -1.758844, -1.606250>, <0.555912, -1.758844, -1.606250>, <1.407074, -1.758844, -1.606250>, 
      <-1.367529, -1.709413, -1.579315>, <-0.539427, -1.709413, -1.579315>, <0.539427, -1.709413, -1.579315>, <1.367529, -1.709413, -1.579315>, 
      <-1.380170, -1.725215, -1.562500>, <-0.552068, -1.725215, -1.562500>, <0.552068, -1.725215, -1.562500>, <1.380170, -1.725215, -1.562500>
    }
  }
  material {
    tegole
    scale 0.75
  }
}
#declare Sgiu = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.030157, -1.030157, -1.687500>, <0.986451, -1.073863, -1.687500>, <0.885935, -1.030157, -1.687500>, <0.824126, -1.030157, -1.687500>, 
      <1.183594, -1.183594, -1.687500>, <1.139889, -1.227300, -1.687500>, <1.008685, -1.183594, -1.687500>, <0.946876, -1.183594, -1.687500>, 
      <1.388448, -1.388448, -1.700382>, <1.323043, -1.453853, -1.700382>, <1.203303, -1.388508, -1.700377>, <1.110806, -1.388508, -1.700377>, 
      <1.541615, -1.541615, -1.687500>, <1.476210, -1.607020, -1.687500>, <1.325789, -1.541615, -1.687500>, <1.233292, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.030157, -0.824126, -1.687500>, <1.030157, -0.885935, -1.687500>, <1.073863, -0.986451, -1.687500>, <1.030157, -1.030157, -1.687500>, 
      <1.183594, -0.946876, -1.687500>, <1.183594, -1.008685, -1.687500>, <1.227300, -1.139889, -1.687500>, <1.183594, -1.183594, -1.687500>, 
      <1.388508, -1.110806, -1.700377>, <1.388508, -1.203303, -1.700377>, <1.453853, -1.323043, -1.700382>, <1.388448, -1.388448, -1.700382>, 
      <1.541615, -1.233292, -1.687500>, <1.541615, -1.325789, -1.687500>, <1.607020, -1.476210, -1.687500>, <1.541615, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.030157, 0.824126, -1.687500>, <1.030157, 0.329650, -1.687500>, <1.030157, -0.329650, -1.687500>, <1.030157, -0.824126, -1.687500>, 
      <1.183594, 0.946876, -1.687500>, <1.183594, 0.452400, -1.687500>, <1.183594, -0.452400, -1.687500>, <1.183594, -0.946876, -1.687500>, 
      <1.388508, 1.110806, -1.700377>, <1.388508, 0.370831, -1.700377>, <1.388508, -0.370831, -1.700377>, <1.388508, -1.110806, -1.700377>, 
      <1.541615, 1.233292, -1.687500>, <1.541615, 0.493317, -1.687500>, <1.541615, -0.493317, -1.687500>, <1.541615, -1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.030157, 1.030157, -1.687500>, <1.073863, 0.986451, -1.687500>, <1.030157, 0.885935, -1.687500>, <1.030157, 0.824126, -1.687500>, 
      <1.183594, 1.183594, -1.687500>, <1.227300, 1.139889, -1.687500>, <1.183594, 1.008685, -1.687500>, <1.183594, 0.946876, -1.687500>, 
      <1.388448, 1.388448, -1.700382>, <1.453853, 1.323043, -1.700382>, <1.388508, 1.203303, -1.700377>, <1.388508, 1.110806, -1.700377>, 
      <1.541615, 1.541615, -1.687500>, <1.607020, 1.476210, -1.687500>, <1.541615, 1.325789, -1.687500>, <1.541615, 1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.824126, 1.030157, -1.687500>, <0.885935, 1.030157, -1.687500>, <0.986451, 1.073863, -1.687500>, <1.030157, 1.030157, -1.687500>, 
      <0.946876, 1.183594, -1.687500>, <1.008685, 1.183594, -1.687500>, <1.139889, 1.227300, -1.687500>, <1.183594, 1.183594, -1.687500>, 
      <1.110806, 1.388508, -1.700377>, <1.203303, 1.388508, -1.700377>, <1.323043, 1.453853, -1.700382>, <1.388448, 1.388448, -1.700382>, 
      <1.233292, 1.541615, -1.687500>, <1.325789, 1.541615, -1.687500>, <1.476210, 1.607020, -1.687500>, <1.541615, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.824126, 1.030157, -1.687500>, <-0.329650, 1.030157, -1.687500>, <0.329650, 1.030157, -1.687500>, <0.824126, 1.030157, -1.687500>, 
      <-0.946876, 1.183594, -1.687500>, <-0.452400, 1.183594, -1.687500>, <0.452400, 1.183594, -1.687500>, <0.946876, 1.183594, -1.687500>, 
      <-1.110806, 1.388508, -1.700377>, <-0.370831, 1.388508, -1.700377>, <0.370831, 1.388508, -1.700377>, <1.110806, 1.388508, -1.700377>, 
      <-1.233292, 1.541615, -1.687500>, <-0.493317, 1.541615, -1.687500>, <0.493317, 1.541615, -1.687500>, <1.233292, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.030157, 1.030157, -1.687500>, <-0.986451, 1.073863, -1.687500>, <-0.885935, 1.030157, -1.687500>, <-0.824126, 1.030157, -1.687500>, 
      <-1.183594, 1.183594, -1.687500>, <-1.139889, 1.227300, -1.687500>, <-1.008685, 1.183594, -1.687500>, <-0.946876, 1.183594, -1.687500>, 
      <-1.388448, 1.388448, -1.700382>, <-1.323043, 1.453853, -1.700382>, <-1.203303, 1.388508, -1.700377>, <-1.110806, 1.388508, -1.700377>, 
      <-1.541615, 1.541615, -1.687500>, <-1.476210, 1.607020, -1.687500>, <-1.325789, 1.541615, -1.687500>, <-1.233292, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.030157, 0.824126, -1.687500>, <-1.030157, 0.885935, -1.687500>, <-1.073863, 0.986451, -1.687500>, <-1.030157, 1.030157, -1.687500>, 
      <-1.183594, 0.946876, -1.687500>, <-1.183594, 1.008685, -1.687500>, <-1.227300, 1.139889, -1.687500>, <-1.183594, 1.183594, -1.687500>, 
      <-1.388508, 1.110806, -1.700377>, <-1.388508, 1.203303, -1.700377>, <-1.453853, 1.323043, -1.700382>, <-1.388448, 1.388448, -1.700382>, 
      <-1.541615, 1.233292, -1.687500>, <-1.541615, 1.325789, -1.687500>, <-1.607020, 1.476210, -1.687500>, <-1.541615, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.030157, -0.824126, -1.687500>, <-1.030157, -0.329650, -1.687500>, <-1.030157, 0.329650, -1.687500>, <-1.030157, 0.824126, -1.687500>, 
      <-1.183594, -0.946876, -1.687500>, <-1.183594, -0.452400, -1.687500>, <-1.183594, 0.452400, -1.687500>, <-1.183594, 0.946876, -1.687500>, 
      <-1.388508, -1.110806, -1.700377>, <-1.388508, -0.370831, -1.700377>, <-1.388508, 0.370831, -1.700377>, <-1.388508, 1.110806, -1.700377>, 
      <-1.541615, -1.233292, -1.687500>, <-1.541615, -0.493317, -1.687500>, <-1.541615, 0.493317, -1.687500>, <-1.541615, 1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.030157, -1.030157, -1.687500>, <-1.073863, -0.986451, -1.687500>, <-1.030157, -0.885935, -1.687500>, <-1.030157, -0.824126, -1.687500>, 
      <-1.183594, -1.183594, -1.687500>, <-1.227300, -1.139889, -1.687500>, <-1.183594, -1.008685, -1.687500>, <-1.183594, -0.946876, -1.687500>, 
      <-1.388448, -1.388448, -1.700382>, <-1.453853, -1.323043, -1.700382>, <-1.388508, -1.203303, -1.700377>, <-1.388508, -1.110806, -1.700377>, 
      <-1.541615, -1.541615, -1.687500>, <-1.607020, -1.476210, -1.687500>, <-1.541615, -1.325789, -1.687500>, <-1.541615, -1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.824126, -1.030157, -1.687500>, <-0.885935, -1.030157, -1.687500>, <-0.986451, -1.073863, -1.687500>, <-1.030157, -1.030157, -1.687500>, 
      <-0.946876, -1.183594, -1.687500>, <-1.008685, -1.183594, -1.687500>, <-1.139889, -1.227300, -1.687500>, <-1.183594, -1.183594, -1.687500>, 
      <-1.110806, -1.388508, -1.700377>, <-1.203303, -1.388508, -1.700377>, <-1.323043, -1.453853, -1.700382>, <-1.388448, -1.388448, -1.700382>, 
      <-1.233292, -1.541615, -1.687500>, <-1.325789, -1.541615, -1.687500>, <-1.476210, -1.607020, -1.687500>, <-1.541615, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.824126, -1.030157, -1.687500>, <-0.946876, -1.183594, -1.687500>, <-1.110806, -1.388508, -1.700377>, <-1.233292, -1.541615, -1.687500>, 
      <-0.329650, -1.030157, -1.687500>, <-0.452400, -1.183594, -1.687500>, <-0.370831, -1.388508, -1.700377>, <-0.493317, -1.541615, -1.687500>, 
      <0.329650, -1.030157, -1.687500>, <0.452400, -1.183594, -1.687500>, <0.370831, -1.388508, -1.700377>, <0.493317, -1.541615, -1.687500>, 
      <0.824126, -1.030157, -1.687500>, <0.946876, -1.183594, -1.687500>, <1.110806, -1.388508, -1.700377>, <1.233292, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, -1.773256, -1.625000>, <1.703764, -1.703764, -1.643750>, <1.612236, -1.612236, -1.681560>, <1.541615, -1.541615, -1.687500>, 
      <1.698023, -1.848489, -1.625000>, <1.628531, -1.778996, -1.643750>, <1.546831, -1.677641, -1.681560>, <1.476210, -1.607020, -1.687500>, 
      <1.525000, -1.773256, -1.625000>, <1.469406, -1.703764, -1.643750>, <1.382481, -1.612480, -1.681540>, <1.325789, -1.541615, -1.687500>, 
      <1.418605, -1.773256, -1.625000>, <1.363011, -1.703764, -1.643750>, <1.289984, -1.612480, -1.681540>, <1.233292, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, -1.418605, -1.625000>, <1.703764, -1.363011, -1.643750>, <1.612480, -1.289984, -1.681540>, <1.541615, -1.233292, -1.687500>, 
      <1.773256, -1.525000, -1.625000>, <1.703764, -1.469406, -1.643750>, <1.612480, -1.382481, -1.681540>, <1.541615, -1.325789, -1.687500>, 
      <1.848489, -1.698023, -1.625000>, <1.778996, -1.628531, -1.643750>, <1.677641, -1.546831, -1.681560>, <1.607020, -1.476210, -1.687500>, 
      <1.773256, -1.773256, -1.625000>, <1.703764, -1.703764, -1.643750>, <1.612236, -1.612236, -1.681560>, <1.541615, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, 1.418605, -1.625000>, <1.703764, 1.363011, -1.643750>, <1.612480, 1.289984, -1.681540>, <1.541615, 1.233292, -1.687500>, 
      <1.773256, 0.567442, -1.625000>, <1.703764, 0.511848, -1.643750>, <1.612480, 0.550009, -1.681540>, <1.541615, 0.493317, -1.687500>, 
      <1.773256, -0.567442, -1.625000>, <1.703764, -0.511848, -1.643750>, <1.612480, -0.550009, -1.681540>, <1.541615, -0.493317, -1.687500>, 
      <1.773256, -1.418605, -1.625000>, <1.703764, -1.363011, -1.643750>, <1.612480, -1.289984, -1.681540>, <1.541615, -1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.773256, 1.773256, -1.625000>, <1.703764, 1.703764, -1.643750>, <1.612236, 1.612236, -1.681560>, <1.541615, 1.541615, -1.687500>, 
      <1.848489, 1.698023, -1.625000>, <1.778996, 1.628531, -1.643750>, <1.677641, 1.546831, -1.681560>, <1.607020, 1.476210, -1.687500>, 
      <1.773256, 1.525000, -1.625000>, <1.703764, 1.469406, -1.643750>, <1.612480, 1.382481, -1.681540>, <1.541615, 1.325789, -1.687500>, 
      <1.773256, 1.418605, -1.625000>, <1.703764, 1.363011, -1.643750>, <1.612480, 1.289984, -1.681540>, <1.541615, 1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.418605, 1.773256, -1.625000>, <1.363011, 1.703764, -1.643750>, <1.289984, 1.612480, -1.681540>, <1.233292, 1.541615, -1.687500>, 
      <1.525000, 1.773256, -1.625000>, <1.469406, 1.703764, -1.643750>, <1.382481, 1.612480, -1.681540>, <1.325789, 1.541615, -1.687500>, 
      <1.698023, 1.848489, -1.625000>, <1.628531, 1.778996, -1.643750>, <1.546831, 1.677641, -1.681560>, <1.476210, 1.607020, -1.687500>, 
      <1.773256, 1.773256, -1.625000>, <1.703764, 1.703764, -1.643750>, <1.612236, 1.612236, -1.681560>, <1.541615, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, 1.773256, -1.625000>, <-1.363011, 1.703764, -1.643750>, <-1.289984, 1.612480, -1.681540>, <-1.233292, 1.541615, -1.687500>, 
      <-0.567442, 1.773256, -1.625000>, <-0.511848, 1.703764, -1.643750>, <-0.550009, 1.612480, -1.681540>, <-0.493317, 1.541615, -1.687500>, 
      <0.567442, 1.773256, -1.625000>, <0.511848, 1.703764, -1.643750>, <0.550009, 1.612480, -1.681540>, <0.493317, 1.541615, -1.687500>, 
      <1.418605, 1.773256, -1.625000>, <1.363011, 1.703764, -1.643750>, <1.289984, 1.612480, -1.681540>, <1.233292, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, 1.773256, -1.625000>, <-1.703764, 1.703764, -1.643750>, <-1.612236, 1.612236, -1.681560>, <-1.541615, 1.541615, -1.687500>, 
      <-1.698023, 1.848489, -1.625000>, <-1.628531, 1.778996, -1.643750>, <-1.546831, 1.677641, -1.681560>, <-1.476210, 1.607020, -1.687500>, 
      <-1.525000, 1.773256, -1.625000>, <-1.469406, 1.703764, -1.643750>, <-1.382481, 1.612480, -1.681540>, <-1.325789, 1.541615, -1.687500>, 
      <-1.418605, 1.773256, -1.625000>, <-1.363011, 1.703764, -1.643750>, <-1.289984, 1.612480, -1.681540>, <-1.233292, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, 1.418605, -1.625000>, <-1.703764, 1.363011, -1.643750>, <-1.612480, 1.289984, -1.681540>, <-1.541615, 1.233292, -1.687500>, 
      <-1.773256, 1.525000, -1.625000>, <-1.703764, 1.469406, -1.643750>, <-1.612480, 1.382481, -1.681540>, <-1.541615, 1.325789, -1.687500>, 
      <-1.848489, 1.698023, -1.625000>, <-1.778996, 1.628531, -1.643750>, <-1.677641, 1.546831, -1.681560>, <-1.607020, 1.476210, -1.687500>, 
      <-1.773256, 1.773256, -1.625000>, <-1.703764, 1.703764, -1.643750>, <-1.612236, 1.612236, -1.681560>, <-1.541615, 1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, -1.418605, -1.625000>, <-1.703764, -1.363011, -1.643750>, <-1.612480, -1.289984, -1.681540>, <-1.541615, -1.233292, -1.687500>, 
      <-1.773256, -0.567442, -1.625000>, <-1.703764, -0.511848, -1.643750>, <-1.612480, -0.550009, -1.681540>, <-1.541615, -0.493317, -1.687500>, 
      <-1.773256, 0.567442, -1.625000>, <-1.703764, 0.511848, -1.643750>, <-1.612480, 0.550009, -1.681540>, <-1.541615, 0.493317, -1.687500>, 
      <-1.773256, 1.418605, -1.625000>, <-1.703764, 1.363011, -1.643750>, <-1.612480, 1.289984, -1.681540>, <-1.541615, 1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.773256, -1.773256, -1.625000>, <-1.703764, -1.703764, -1.643750>, <-1.612236, -1.612236, -1.681560>, <-1.541615, -1.541615, -1.687500>, 
      <-1.848489, -1.698023, -1.625000>, <-1.778996, -1.628531, -1.643750>, <-1.677641, -1.546831, -1.681560>, <-1.607020, -1.476210, -1.687500>, 
      <-1.773256, -1.525000, -1.625000>, <-1.703764, -1.469406, -1.643750>, <-1.612480, -1.382481, -1.681540>, <-1.541615, -1.325789, -1.687500>, 
      <-1.773256, -1.418605, -1.625000>, <-1.703764, -1.363011, -1.643750>, <-1.612480, -1.289984, -1.681540>, <-1.541615, -1.233292, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, -1.773256, -1.625000>, <-1.363011, -1.703764, -1.643750>, <-1.289984, -1.612480, -1.681540>, <-1.233292, -1.541615, -1.687500>, 
      <-1.525000, -1.773256, -1.625000>, <-1.469406, -1.703764, -1.643750>, <-1.382481, -1.612480, -1.681540>, <-1.325789, -1.541615, -1.687500>, 
      <-1.698023, -1.848489, -1.625000>, <-1.628531, -1.778996, -1.643750>, <-1.546831, -1.677641, -1.681560>, <-1.476210, -1.607020, -1.687500>, 
      <-1.773256, -1.773256, -1.625000>, <-1.703764, -1.703764, -1.643750>, <-1.612236, -1.612236, -1.681560>, <-1.541615, -1.541615, -1.687500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.418605, -1.773256, -1.625000>, <-0.567442, -1.773256, -1.625000>, <0.567442, -1.773256, -1.625000>, <1.418605, -1.773256, -1.625000>, 
      <-1.363011, -1.703764, -1.643750>, <-0.511848, -1.703764, -1.643750>, <0.511848, -1.703764, -1.643750>, <1.363011, -1.703764, -1.643750>, 
      <-1.289984, -1.612480, -1.681540>, <-0.550009, -1.612480, -1.681540>, <0.550009, -1.612480, -1.681540>, <1.289984, -1.612480, -1.681540>, 
      <-1.233292, -1.541615, -1.687500>, <-0.493317, -1.541615, -1.687500>, <0.493317, -1.541615, -1.687500>, <1.233292, -1.541615, -1.687500>
    }
  }
  material {
    sotto
  }
}
#declare Tsotto = union {
  object { Tgiu }
  object { Sgiu }
  translate  0.480706*z
}
#declare punta = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.007940, 0.007940, 1.568204>, <0.008869, 0.007011, 1.568204>, <0.009871, 0.005511, 1.568204>, <0.010374, 0.004297, 1.568204>, 
      <0.007940, 0.007940, 1.568204>, <0.008687, 0.006828, 1.572626>, <0.009593, 0.005396, 1.572623>, <0.010096, 0.004182, 1.572623>, 
      <0.007940, 0.007940, 1.568204>, <0.008687, 0.006828, 1.572626>, <0.003683, 0.006890, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <0.007940, 0.007940, 1.568204>, <0.007757, 0.007757, 1.572626>, <0.003683, 0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.007940, -0.007940, 1.568204>, <-0.008869, -0.007011, 1.568204>, <-0.009871, -0.005511, 1.568204>, <-0.010374, -0.004297, 1.568204>, 
      <-0.007940, -0.007940, 1.568204>, <-0.008687, -0.006828, 1.572626>, <-0.009593, -0.005396, 1.572623>, <-0.010096, -0.004182, 1.572623>, 
      <-0.007940, -0.007940, 1.568204>, <-0.008687, -0.006828, 1.572626>, <-0.006144, -0.006144, 1.577791>, <-0.003683, -0.002461, 1.577791>, 
      <-0.007940, -0.007940, 1.568204>, <-0.007757, -0.007757, 1.572626>, <-0.002461, -0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.004297, 0.010374, 1.568204>, <0.004182, 0.010096, 1.572623>, <0.002461, 0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.004297, 0.010374, 1.568204>, <0.005396, 0.009593, 1.572623>, <0.006144, 0.006144, 1.577791>, <0.003683, 0.002461, 1.577791>, 
      <0.004297, 0.010374, 1.568204>, <0.005396, 0.009593, 1.572623>, <0.006828, 0.008687, 1.572626>, <0.007757, 0.007757, 1.572626>, 
      <0.004297, 0.010374, 1.568204>, <0.005511, 0.009871, 1.568204>, <0.007011, 0.008869, 1.568204>, <0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.004297, 0.010374, 1.568204>, <0.004182, 0.010096, 1.572623>, <0.002461, 0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.005511, 0.009871, 1.568204>, <0.005396, 0.009593, 1.572623>, <0.002461, 0.008112, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <0.007011, 0.008869, 1.568204>, <0.007940, 0.007940, 1.568204>, <0.009593, 0.005396, 1.572623>, <0.010096, 0.004182, 1.572623>, 
      <0.007940, 0.007940, 1.568204>, <0.008869, 0.007011, 1.568204>, <0.009871, 0.005511, 1.568204>, <0.010374, 0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.004297, -0.010374, 1.568204>, <-0.004182, -0.010096, 1.572623>, <0.000000, -0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.004297, -0.010374, 1.568204>, <-0.005396, -0.009593, 1.572623>, <-0.002461, -0.008112, 1.577791>, <-0.002461, -0.003683, 1.577791>, 
      <-0.004297, -0.010374, 1.568204>, <-0.005396, -0.009593, 1.572623>, <-0.006828, -0.008687, 1.572626>, <-0.007757, -0.007757, 1.572626>, 
      <-0.004297, -0.010374, 1.568204>, <-0.005511, -0.009871, 1.568204>, <-0.007011, -0.008869, 1.568204>, <-0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.004297, -0.010374, 1.568204>, <-0.004182, -0.010096, 1.572623>, <0.000000, -0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.005511, -0.009871, 1.568204>, <-0.005396, -0.009593, 1.572623>, <-0.003683, -0.006890, 1.577791>, <-0.003683, -0.002461, 1.577791>, 
      <-0.007011, -0.008869, 1.568204>, <-0.007940, -0.007940, 1.568204>, <-0.009593, -0.005396, 1.572623>, <-0.010096, -0.004182, 1.572623>, 
      <-0.007940, -0.007940, 1.568204>, <-0.008869, -0.007011, 1.568204>, <-0.009871, -0.005511, 1.568204>, <-0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.007940, 0.007940, 1.568204>, <-0.007757, 0.007757, 1.572626>, <-0.002461, 0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.007940, 0.007940, 1.568204>, <-0.006828, 0.008687, 1.572626>, <-0.002461, 0.008112, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <-0.007940, 0.007940, 1.568204>, <-0.006828, 0.008687, 1.572626>, <-0.005396, 0.009593, 1.572623>, <-0.004182, 0.010096, 1.572623>, 
      <-0.007940, 0.007940, 1.568204>, <-0.007011, 0.008869, 1.568204>, <-0.005511, 0.009871, 1.568204>, <-0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.007940, -0.007940, 1.568204>, <0.007757, -0.007757, 1.572626>, <0.003683, -0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.007940, -0.007940, 1.568204>, <0.008687, -0.006828, 1.572626>, <0.003683, -0.006890, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.007940, -0.007940, 1.568204>, <0.008687, -0.006828, 1.572626>, <0.009593, -0.005396, 1.572623>, <0.010096, -0.004182, 1.572623>, 
      <0.007940, -0.007940, 1.568204>, <0.008869, -0.007011, 1.568204>, <0.009871, -0.005511, 1.568204>, <0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.007940, -0.007940, 1.568204>, <0.008869, -0.007011, 1.568204>, <0.009871, -0.005511, 1.568204>, <0.010374, -0.004297, 1.568204>, 
      <0.007011, -0.008869, 1.568204>, <0.007940, -0.007940, 1.568204>, <0.009593, -0.005396, 1.572623>, <0.010096, -0.004182, 1.572623>, 
      <0.005511, -0.009871, 1.568204>, <0.005396, -0.009593, 1.572623>, <0.002461, -0.008112, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.004297, -0.010374, 1.568204>, <0.004182, -0.010096, 1.572623>, <0.002461, -0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.007940, -0.007940, 1.568204>, <0.007757, -0.007757, 1.572626>, <0.003683, -0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.007940, -0.007940, 1.568204>, <0.006828, -0.008687, 1.572626>, <0.006144, -0.006144, 1.577791>, <0.002461, -0.003683, 1.577791>, 
      <0.007940, -0.007940, 1.568204>, <0.006828, -0.008687, 1.572626>, <0.005396, -0.009593, 1.572623>, <0.004182, -0.010096, 1.572623>, 
      <0.007940, -0.007940, 1.568204>, <0.007011, -0.008869, 1.568204>, <0.005511, -0.009871, 1.568204>, <0.004297, -0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.010374, 0.004297, 1.568204>, <-0.010096, 0.004182, 1.572623>, <-0.003683, 0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.010374, 0.004297, 1.568204>, <-0.009593, 0.005396, 1.572623>, <-0.006144, 0.006144, 1.577791>, <-0.002461, 0.003683, 1.577791>, 
      <-0.010374, 0.004297, 1.568204>, <-0.009593, 0.005396, 1.572623>, <-0.008687, 0.006828, 1.572626>, <-0.007757, 0.007757, 1.572626>, 
      <-0.010374, 0.004297, 1.568204>, <-0.009871, 0.005511, 1.568204>, <-0.008869, 0.007011, 1.568204>, <-0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.010374, 0.004297, 1.568204>, <-0.010096, 0.004182, 1.572623>, <-0.003683, 0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.009871, 0.005511, 1.568204>, <-0.009593, 0.005396, 1.572623>, <-0.003683, 0.006890, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <-0.008869, 0.007011, 1.568204>, <-0.007940, 0.007940, 1.568204>, <-0.005396, 0.009593, 1.572623>, <-0.004182, 0.010096, 1.572623>, 
      <-0.007940, 0.007940, 1.568204>, <-0.007011, 0.008869, 1.568204>, <-0.005511, 0.009871, 1.568204>, <-0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.011229, 0.000000, 1.568204>, <-0.010971, 0.000000, 1.572626>, <-0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.011229, 0.000000, 1.568204>, <-0.010971, -0.001314, 1.572626>, <-0.008112, -0.002461, 1.577791>, <-0.003683, -0.002461, 1.577791>, 
      <-0.011229, 0.000000, 1.568204>, <-0.010971, -0.001314, 1.572626>, <-0.010599, -0.002968, 1.572623>, <-0.010096, -0.004182, 1.572623>, 
      <-0.011229, 0.000000, 1.568204>, <-0.011229, -0.001314, 1.568204>, <-0.010877, -0.003083, 1.568204>, <-0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.011229, 0.000000, 1.568204>, <-0.010971, 0.000000, 1.572626>, <-0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.011229, -0.001314, 1.568204>, <-0.010971, -0.001314, 1.572626>, <-0.006890, -0.003683, 1.577791>, <-0.002461, -0.003683, 1.577791>, 
      <-0.010877, -0.003083, 1.568204>, <-0.010374, -0.004297, 1.568204>, <-0.008687, -0.006828, 1.572626>, <-0.007757, -0.007757, 1.572626>, 
      <-0.010374, -0.004297, 1.568204>, <-0.009871, -0.005511, 1.568204>, <-0.008869, -0.007011, 1.568204>, <-0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.011229, 0.000000, 1.568204>, <-0.011229, 0.001314, 1.568204>, <-0.010877, 0.003083, 1.568204>, <-0.010374, 0.004297, 1.568204>, 
      <-0.011229, -0.001314, 1.568204>, <-0.011229, 0.000000, 1.568204>, <-0.010599, 0.002968, 1.572623>, <-0.010096, 0.004182, 1.572623>, 
      <-0.010877, -0.003083, 1.568204>, <-0.010599, -0.002968, 1.572623>, <-0.007366, 0.000000, 1.577791>, <-0.003683, 0.002461, 1.577791>, 
      <-0.010374, -0.004297, 1.568204>, <-0.010096, -0.004182, 1.572623>, <-0.003683, -0.002461, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.011229, 0.000000, 1.568204>, <-0.010971, 0.000000, 1.572626>, <-0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.011229, 0.000000, 1.568204>, <-0.010971, 0.001314, 1.572626>, <-0.008112, 0.002461, 1.577791>, <-0.003683, 0.002461, 1.577791>, 
      <-0.011229, 0.000000, 1.568204>, <-0.010971, 0.001314, 1.572626>, <-0.010599, 0.002968, 1.572623>, <-0.010096, 0.004182, 1.572623>, 
      <-0.011229, 0.000000, 1.568204>, <-0.011229, 0.001314, 1.568204>, <-0.010877, 0.003083, 1.568204>, <-0.010374, 0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.011229, 0.000000, 1.568204>, <-0.011229, 0.001314, 1.568204>, <-0.010877, 0.003083, 1.568204>, <-0.010374, 0.004297, 1.568204>, 
      <-0.010971, 0.000000, 1.572626>, <-0.010971, 0.001314, 1.572626>, <-0.010374, 0.004297, 1.568204>, <-0.009871, 0.005511, 1.568204>, 
      <-0.004429, 0.000000, 1.577791>, <-0.006890, 0.003683, 1.577791>, <-0.008687, 0.006828, 1.572626>, <-0.008869, 0.007011, 1.568204>, 
      <0.000000, 0.000000, 1.577791>, <-0.002461, 0.003683, 1.577791>, <-0.007757, 0.007757, 1.572626>, <-0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.011229, 0.000000, 1.568204>, <0.010971, 0.000000, 1.572626>, <0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.011229, 0.000000, 1.568204>, <0.010971, 0.001314, 1.572626>, <0.004429, 0.004429, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <0.011229, 0.000000, 1.568204>, <0.010971, 0.001314, 1.572626>, <0.010599, 0.002968, 1.572623>, <0.010096, 0.004182, 1.572623>, 
      <0.011229, 0.000000, 1.568204>, <0.011229, 0.001314, 1.568204>, <0.010877, 0.003083, 1.568204>, <0.010374, 0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.011229, 0.000000, 1.568204>, <0.010971, 0.000000, 1.572626>, <0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.011229, 0.001314, 1.568204>, <0.010971, 0.001314, 1.572626>, <0.008112, 0.002461, 1.577791>, <0.003683, 0.002461, 1.577791>, 
      <0.010877, 0.003083, 1.568204>, <0.010374, 0.004297, 1.568204>, <0.008687, 0.006828, 1.572626>, <0.007757, 0.007757, 1.572626>, 
      <0.010374, 0.004297, 1.568204>, <0.009871, 0.005511, 1.568204>, <0.008869, 0.007011, 1.568204>, <0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.011229, 0.000000, 1.568204>, <0.011229, -0.001314, 1.568204>, <0.010877, -0.003083, 1.568204>, <0.010374, -0.004297, 1.568204>, 
      <0.011229, 0.001314, 1.568204>, <0.011229, 0.000000, 1.568204>, <0.010599, -0.002968, 1.572623>, <0.010096, -0.004182, 1.572623>, 
      <0.010877, 0.003083, 1.568204>, <0.010599, 0.002968, 1.572623>, <0.000000, 0.000000, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.010374, 0.004297, 1.568204>, <0.010096, 0.004182, 1.572623>, <0.000000, 0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.011229, 0.000000, 1.568204>, <0.010971, 0.000000, 1.572626>, <0.004429, 0.000000, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.011229, 0.000000, 1.568204>, <0.010971, -0.001314, 1.572626>, <0.004429, -0.004429, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.011229, 0.000000, 1.568204>, <0.010971, -0.001314, 1.572626>, <0.010599, -0.002968, 1.572623>, <0.010096, -0.004182, 1.572623>, 
      <0.011229, 0.000000, 1.568204>, <0.011229, -0.001314, 1.568204>, <0.010877, -0.003083, 1.568204>, <0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.011229, 0.000000, 1.568204>, <0.011229, -0.001314, 1.568204>, <0.010877, -0.003083, 1.568204>, <0.010374, -0.004297, 1.568204>, 
      <0.010971, 0.000000, 1.572626>, <0.010971, -0.001314, 1.572626>, <0.010374, -0.004297, 1.568204>, <0.009871, -0.005511, 1.568204>, 
      <0.004429, 0.000000, 1.577791>, <0.008112, -0.002461, 1.577791>, <0.008687, -0.006828, 1.572626>, <0.008869, -0.007011, 1.568204>, 
      <0.000000, 0.000000, 1.577791>, <0.003683, -0.002461, 1.577791>, <0.007757, -0.007757, 1.572626>, <0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.011229, 1.568204>, <0.000000, -0.010971, 1.572626>, <0.000000, -0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.000000, -0.011229, 1.568204>, <0.001314, -0.010971, 1.572626>, <0.002461, -0.008112, 1.577791>, <0.002461, -0.003683, 1.577791>, 
      <0.000000, -0.011229, 1.568204>, <0.001314, -0.010971, 1.572626>, <0.002968, -0.010599, 1.572623>, <0.004182, -0.010096, 1.572623>, 
      <0.000000, -0.011229, 1.568204>, <0.001314, -0.011229, 1.568204>, <0.003083, -0.010877, 1.568204>, <0.004297, -0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.011229, 1.568204>, <0.000000, -0.010971, 1.572626>, <0.000000, -0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.001314, -0.011229, 1.568204>, <0.001314, -0.010971, 1.572626>, <0.003683, -0.006890, 1.577791>, <0.003683, -0.002461, 1.577791>, 
      <0.003083, -0.010877, 1.568204>, <0.004297, -0.010374, 1.568204>, <0.006828, -0.008687, 1.572626>, <0.007757, -0.007757, 1.572626>, 
      <0.004297, -0.010374, 1.568204>, <0.005511, -0.009871, 1.568204>, <0.007011, -0.008869, 1.568204>, <0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.011229, 1.568204>, <-0.001314, -0.011229, 1.568204>, <-0.003083, -0.010877, 1.568204>, <-0.004297, -0.010374, 1.568204>, 
      <0.001314, -0.011229, 1.568204>, <0.000000, -0.011229, 1.568204>, <-0.002968, -0.010599, 1.572623>, <-0.004182, -0.010096, 1.572623>, 
      <0.003083, -0.010877, 1.568204>, <0.002968, -0.010599, 1.572623>, <0.002461, -0.008112, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.004297, -0.010374, 1.568204>, <0.004182, -0.010096, 1.572623>, <0.002461, -0.003683, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.011229, 1.568204>, <0.000000, -0.010971, 1.572626>, <0.000000, -0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.000000, -0.011229, 1.568204>, <-0.001314, -0.010971, 1.572626>, <0.000000, -0.008859, 1.577791>, <0.000000, -0.004429, 1.577791>, 
      <0.000000, -0.011229, 1.568204>, <-0.001314, -0.010971, 1.572626>, <-0.002968, -0.010599, 1.572623>, <-0.004182, -0.010096, 1.572623>, 
      <0.000000, -0.011229, 1.568204>, <-0.001314, -0.011229, 1.568204>, <-0.003083, -0.010877, 1.568204>, <-0.004297, -0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.011229, 1.568204>, <-0.001314, -0.011229, 1.568204>, <-0.003083, -0.010877, 1.568204>, <-0.004297, -0.010374, 1.568204>, 
      <0.000000, -0.010971, 1.572626>, <-0.001314, -0.010971, 1.572626>, <-0.004297, -0.010374, 1.568204>, <-0.005511, -0.009871, 1.568204>, 
      <0.000000, -0.004429, 1.577791>, <-0.002461, -0.008112, 1.577791>, <-0.006828, -0.008687, 1.572626>, <-0.007011, -0.008869, 1.568204>, 
      <0.000000, 0.000000, 1.577791>, <-0.002461, -0.003683, 1.577791>, <-0.007757, -0.007757, 1.572626>, <-0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.011229, 1.568204>, <0.000000, 0.010971, 1.572626>, <0.000000, 0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.000000, 0.011229, 1.568204>, <-0.001314, 0.010971, 1.572626>, <0.000000, 0.008859, 1.577791>, <0.000000, 0.004429, 1.577791>, 
      <0.000000, 0.011229, 1.568204>, <-0.001314, 0.010971, 1.572626>, <-0.002968, 0.010599, 1.572623>, <-0.004182, 0.010096, 1.572623>, 
      <0.000000, 0.011229, 1.568204>, <-0.001314, 0.011229, 1.568204>, <-0.003083, 0.010877, 1.568204>, <-0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.011229, 1.568204>, <0.000000, 0.010971, 1.572626>, <0.000000, 0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <-0.001314, 0.011229, 1.568204>, <-0.001314, 0.010971, 1.572626>, <-0.002461, 0.008112, 1.577791>, <-0.002461, 0.003683, 1.577791>, 
      <-0.003083, 0.010877, 1.568204>, <-0.004297, 0.010374, 1.568204>, <-0.006828, 0.008687, 1.572626>, <-0.007757, 0.007757, 1.572626>, 
      <-0.004297, 0.010374, 1.568204>, <-0.005511, 0.009871, 1.568204>, <-0.007011, 0.008869, 1.568204>, <-0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.011229, 1.568204>, <0.001314, 0.011229, 1.568204>, <0.003083, 0.010877, 1.568204>, <0.004297, 0.010374, 1.568204>, 
      <-0.001314, 0.011229, 1.568204>, <0.000000, 0.011229, 1.568204>, <0.002968, 0.010599, 1.572623>, <0.004182, 0.010096, 1.572623>, 
      <-0.003083, 0.010877, 1.568204>, <-0.002968, 0.010599, 1.572623>, <0.002461, 0.008112, 1.577791>, <0.002461, 0.003683, 1.577791>, 
      <-0.004297, 0.010374, 1.568204>, <-0.004182, 0.010096, 1.572623>, <0.000000, 0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.011229, 1.568204>, <0.000000, 0.010971, 1.572626>, <0.000000, 0.004429, 1.577791>, <0.000000, 0.000000, 1.577791>, 
      <0.000000, 0.011229, 1.568204>, <0.001314, 0.010971, 1.572626>, <0.002461, 0.008112, 1.577791>, <0.002461, 0.003683, 1.577791>, 
      <0.000000, 0.011229, 1.568204>, <0.001314, 0.010971, 1.572626>, <0.002968, 0.010599, 1.572623>, <0.004182, 0.010096, 1.572623>, 
      <0.000000, 0.011229, 1.568204>, <0.001314, 0.011229, 1.568204>, <0.003083, 0.010877, 1.568204>, <0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.011229, 1.568204>, <0.001314, 0.011229, 1.568204>, <0.003083, 0.010877, 1.568204>, <0.004297, 0.010374, 1.568204>, 
      <0.000000, 0.010971, 1.572626>, <0.001314, 0.010971, 1.572626>, <0.004297, 0.010374, 1.568204>, <0.005511, 0.009871, 1.568204>, 
      <0.000000, 0.004429, 1.577791>, <0.003683, 0.006890, 1.577791>, <0.006828, 0.008687, 1.572626>, <0.007011, 0.008869, 1.568204>, 
      <0.000000, 0.000000, 1.577791>, <0.003683, 0.002461, 1.577791>, <0.007757, 0.007757, 1.572626>, <0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.015917, -0.015917, 1.192078>, <0.006916, -0.006916, 1.304247>, <0.012591, -0.012591, 1.455507>, <0.007940, -0.007940, 1.568204>, 
      <0.018078, -0.013756, 1.192078>, <0.009076, -0.004755, 1.304247>, <0.013520, -0.011661, 1.455507>, <0.008869, -0.007011, 1.568204>, 
      <0.023066, -0.012862, 1.192078>, <0.011302, -0.007989, 1.304285>, <0.016950, -0.008444, 1.455537>, <0.009871, -0.005511, 1.568204>, 
      <0.024236, -0.010039, 1.192078>, <0.012471, -0.005166, 1.304285>, <0.017453, -0.007229, 1.455537>, <0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.010039, -0.024236, 1.192078>, <0.005166, -0.012471, 1.304285>, <0.007229, -0.017453, 1.455537>, <0.004297, -0.010374, 1.568204>, 
      <0.012862, -0.023066, 1.192078>, <0.007989, -0.011302, 1.304285>, <0.008444, -0.016950, 1.455537>, <0.005511, -0.009871, 1.568204>, 
      <0.013756, -0.018078, 1.192078>, <0.004755, -0.009076, 1.304247>, <0.011661, -0.013520, 1.455507>, <0.007011, -0.008869, 1.568204>, 
      <0.015917, -0.015917, 1.192078>, <0.006916, -0.006916, 1.304247>, <0.012591, -0.012591, 1.455507>, <0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.022511, 1.192078>, <0.000000, -0.009781, 1.304247>, <0.000000, -0.017806, 1.455507>, <0.000000, -0.011229, 1.568204>, 
      <0.003056, -0.022511, 1.192078>, <0.003056, -0.009781, 1.304247>, <0.001314, -0.017806, 1.455507>, <0.001314, -0.011229, 1.568204>, 
      <0.007216, -0.025406, 1.192078>, <0.002343, -0.013641, 1.304285>, <0.006015, -0.017956, 1.455537>, <0.003083, -0.010877, 1.568204>, 
      <0.010039, -0.024236, 1.192078>, <0.005166, -0.012471, 1.304285>, <0.007229, -0.017453, 1.455537>, <0.004297, -0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.010039, -0.024236, 1.192078>, <-0.005166, -0.012471, 1.304285>, <-0.007229, -0.017453, 1.455537>, <-0.004297, -0.010374, 1.568204>, 
      <-0.007216, -0.025406, 1.192078>, <-0.002343, -0.013641, 1.304285>, <-0.006015, -0.017956, 1.455537>, <-0.003083, -0.010877, 1.568204>, 
      <-0.003056, -0.022511, 1.192078>, <-0.003056, -0.009781, 1.304247>, <-0.001314, -0.017806, 1.455507>, <-0.001314, -0.011229, 1.568204>, 
      <0.000000, -0.022511, 1.192078>, <0.000000, -0.009781, 1.304247>, <0.000000, -0.017806, 1.455507>, <0.000000, -0.011229, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.015917, -0.015917, 1.192078>, <-0.006916, -0.006916, 1.304247>, <-0.012591, -0.012591, 1.455507>, <-0.007940, -0.007940, 1.568204>, 
      <-0.013756, -0.018078, 1.192078>, <-0.004755, -0.009076, 1.304247>, <-0.011661, -0.013520, 1.455507>, <-0.007011, -0.008869, 1.568204>, 
      <-0.012862, -0.023066, 1.192078>, <-0.007989, -0.011302, 1.304285>, <-0.008444, -0.016950, 1.455537>, <-0.005511, -0.009871, 1.568204>, 
      <-0.010039, -0.024236, 1.192078>, <-0.005166, -0.012471, 1.304285>, <-0.007229, -0.017453, 1.455537>, <-0.004297, -0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.024236, -0.010039, 1.192078>, <-0.012471, -0.005166, 1.304285>, <-0.017453, -0.007229, 1.455537>, <-0.010374, -0.004297, 1.568204>, 
      <-0.023066, -0.012862, 1.192078>, <-0.011302, -0.007989, 1.304285>, <-0.016950, -0.008444, 1.455537>, <-0.009871, -0.005511, 1.568204>, 
      <-0.018078, -0.013756, 1.192078>, <-0.009076, -0.004755, 1.304247>, <-0.013520, -0.011661, 1.455507>, <-0.008869, -0.007011, 1.568204>, 
      <-0.015917, -0.015917, 1.192078>, <-0.006916, -0.006916, 1.304247>, <-0.012591, -0.012591, 1.455507>, <-0.007940, -0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.022511, 0.000000, 1.192078>, <-0.009781, 0.000000, 1.304247>, <-0.017806, 0.000000, 1.455507>, <-0.011229, 0.000000, 1.568204>, 
      <-0.022511, -0.003056, 1.192078>, <-0.009781, -0.003056, 1.304247>, <-0.017806, -0.001314, 1.455507>, <-0.011229, -0.001314, 1.568204>, 
      <-0.025406, -0.007216, 1.192078>, <-0.013641, -0.002343, 1.304285>, <-0.017956, -0.006015, 1.455537>, <-0.010877, -0.003083, 1.568204>, 
      <-0.024236, -0.010039, 1.192078>, <-0.012471, -0.005166, 1.304285>, <-0.017453, -0.007229, 1.455537>, <-0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.024236, 0.010039, 1.192078>, <-0.012471, 0.005166, 1.304285>, <-0.017453, 0.007229, 1.455537>, <-0.010374, 0.004297, 1.568204>, 
      <-0.025406, 0.007216, 1.192078>, <-0.013641, 0.002343, 1.304285>, <-0.017956, 0.006015, 1.455537>, <-0.010877, 0.003083, 1.568204>, 
      <-0.022511, 0.003056, 1.192078>, <-0.009781, 0.003056, 1.304247>, <-0.017806, 0.001314, 1.455507>, <-0.011229, 0.001314, 1.568204>, 
      <-0.022511, 0.000000, 1.192078>, <-0.009781, 0.000000, 1.304247>, <-0.017806, 0.000000, 1.455507>, <-0.011229, 0.000000, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.015917, 0.015917, 1.192078>, <-0.006916, 0.006916, 1.304247>, <-0.012591, 0.012591, 1.455507>, <-0.007940, 0.007940, 1.568204>, 
      <-0.018078, 0.013756, 1.192078>, <-0.009076, 0.004755, 1.304247>, <-0.013520, 0.011661, 1.455507>, <-0.008869, 0.007011, 1.568204>, 
      <-0.023066, 0.012862, 1.192078>, <-0.011302, 0.007989, 1.304285>, <-0.016950, 0.008444, 1.455537>, <-0.009871, 0.005511, 1.568204>, 
      <-0.024236, 0.010039, 1.192078>, <-0.012471, 0.005166, 1.304285>, <-0.017453, 0.007229, 1.455537>, <-0.010374, 0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.010039, 0.024236, 1.192078>, <-0.005166, 0.012471, 1.304285>, <-0.007229, 0.017453, 1.455537>, <-0.004297, 0.010374, 1.568204>, 
      <-0.012862, 0.023066, 1.192078>, <-0.007989, 0.011302, 1.304285>, <-0.008444, 0.016950, 1.455537>, <-0.005511, 0.009871, 1.568204>, 
      <-0.013756, 0.018078, 1.192078>, <-0.004755, 0.009076, 1.304247>, <-0.011661, 0.013520, 1.455507>, <-0.007011, 0.008869, 1.568204>, 
      <-0.015917, 0.015917, 1.192078>, <-0.006916, 0.006916, 1.304247>, <-0.012591, 0.012591, 1.455507>, <-0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.022511, 1.192078>, <0.000000, 0.009781, 1.304247>, <0.000000, 0.017806, 1.455507>, <0.000000, 0.011229, 1.568204>, 
      <-0.003056, 0.022511, 1.192078>, <-0.003056, 0.009781, 1.304247>, <-0.001314, 0.017806, 1.455507>, <-0.001314, 0.011229, 1.568204>, 
      <-0.007216, 0.025406, 1.192078>, <-0.002343, 0.013641, 1.304285>, <-0.006015, 0.017956, 1.455537>, <-0.003083, 0.010877, 1.568204>, 
      <-0.010039, 0.024236, 1.192078>, <-0.005166, 0.012471, 1.304285>, <-0.007229, 0.017453, 1.455537>, <-0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.010039, 0.024236, 1.192078>, <0.005166, 0.012471, 1.304285>, <0.007229, 0.017453, 1.455537>, <0.004297, 0.010374, 1.568204>, 
      <0.007216, 0.025406, 1.192078>, <0.002343, 0.013641, 1.304285>, <0.006015, 0.017956, 1.455537>, <0.003083, 0.010877, 1.568204>, 
      <0.003056, 0.022511, 1.192078>, <0.003056, 0.009781, 1.304247>, <0.001314, 0.017806, 1.455507>, <0.001314, 0.011229, 1.568204>, 
      <0.000000, 0.022511, 1.192078>, <0.000000, 0.009781, 1.304247>, <0.000000, 0.017806, 1.455507>, <0.000000, 0.011229, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.015917, 0.015917, 1.192078>, <0.006916, 0.006916, 1.304247>, <0.012591, 0.012591, 1.455507>, <0.007940, 0.007940, 1.568204>, 
      <0.013756, 0.018078, 1.192078>, <0.004755, 0.009076, 1.304247>, <0.011661, 0.013520, 1.455507>, <0.007011, 0.008869, 1.568204>, 
      <0.012862, 0.023066, 1.192078>, <0.007989, 0.011302, 1.304285>, <0.008444, 0.016950, 1.455537>, <0.005511, 0.009871, 1.568204>, 
      <0.010039, 0.024236, 1.192078>, <0.005166, 0.012471, 1.304285>, <0.007229, 0.017453, 1.455537>, <0.004297, 0.010374, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.024236, 0.010039, 1.192078>, <0.012471, 0.005166, 1.304285>, <0.017453, 0.007229, 1.455537>, <0.010374, 0.004297, 1.568204>, 
      <0.023066, 0.012862, 1.192078>, <0.011302, 0.007989, 1.304285>, <0.016950, 0.008444, 1.455537>, <0.009871, 0.005511, 1.568204>, 
      <0.018078, 0.013756, 1.192078>, <0.009076, 0.004755, 1.304247>, <0.013520, 0.011661, 1.455507>, <0.008869, 0.007011, 1.568204>, 
      <0.015917, 0.015917, 1.192078>, <0.006916, 0.006916, 1.304247>, <0.012591, 0.012591, 1.455507>, <0.007940, 0.007940, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.043626, -0.043626, 1.123511>, <0.041077, -0.041077, 1.146928>, <0.017806, -0.017806, 1.168537>, <0.015917, -0.015917, 1.192078>, 
      <0.048733, -0.038519, 1.123511>, <0.046184, -0.035970, 1.146928>, <0.019967, -0.015645, 1.168537>, <0.018078, -0.013756, 1.192078>, 
      <0.054236, -0.030282, 1.123511>, <0.050344, -0.028670, 1.146283>, <0.025479, -0.013862, 1.169067>, <0.023066, -0.012862, 1.192078>, 
      <0.057000, -0.023610, 1.123511>, <0.053108, -0.021998, 1.146283>, <0.026649, -0.011038, 1.169067>, <0.024236, -0.010039, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.023610, -0.057000, 1.123511>, <0.021998, -0.053108, 1.146283>, <0.011038, -0.026649, 1.169067>, <0.010039, -0.024236, 1.192078>, 
      <0.030282, -0.054236, 1.123511>, <0.028670, -0.050344, 1.146283>, <0.013862, -0.025479, 1.169067>, <0.012862, -0.023066, 1.192078>, 
      <0.038519, -0.048733, 1.123511>, <0.035970, -0.046184, 1.146928>, <0.015645, -0.019967, 1.168537>, <0.013756, -0.018078, 1.192078>, 
      <0.043626, -0.043626, 1.123511>, <0.041077, -0.041077, 1.146928>, <0.017806, -0.017806, 1.168537>, <0.015917, -0.015917, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.061696, 1.123511>, <0.000000, -0.058091, 1.146927>, <0.000000, -0.025183, 1.168537>, <0.000000, -0.022511, 1.192078>, 
      <0.007222, -0.061696, 1.123511>, <0.007222, -0.058091, 1.146927>, <0.003056, -0.025183, 1.168537>, <0.003056, -0.022511, 1.192078>, 
      <0.016938, -0.059764, 1.123511>, <0.015326, -0.055871, 1.146283>, <0.008215, -0.027818, 1.169067>, <0.007216, -0.025406, 1.192078>, 
      <0.023610, -0.057000, 1.123511>, <0.021998, -0.053108, 1.146283>, <0.011038, -0.026649, 1.169067>, <0.010039, -0.024236, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.023610, -0.057000, 1.123511>, <-0.021998, -0.053108, 1.146283>, <-0.011038, -0.026649, 1.169067>, <-0.010039, -0.024236, 1.192078>, 
      <-0.016938, -0.059764, 1.123511>, <-0.015326, -0.055871, 1.146283>, <-0.008215, -0.027818, 1.169067>, <-0.007216, -0.025406, 1.192078>, 
      <-0.007222, -0.061696, 1.123511>, <-0.007222, -0.058091, 1.146927>, <-0.003056, -0.025183, 1.168537>, <-0.003056, -0.022511, 1.192078>, 
      <0.000000, -0.061696, 1.123511>, <0.000000, -0.058091, 1.146927>, <0.000000, -0.025183, 1.168537>, <0.000000, -0.022511, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.043626, -0.043626, 1.123511>, <-0.041077, -0.041077, 1.146928>, <-0.017806, -0.017806, 1.168537>, <-0.015917, -0.015917, 1.192078>, 
      <-0.038519, -0.048733, 1.123511>, <-0.035970, -0.046184, 1.146928>, <-0.015645, -0.019967, 1.168537>, <-0.013756, -0.018078, 1.192078>, 
      <-0.030282, -0.054236, 1.123511>, <-0.028670, -0.050344, 1.146283>, <-0.013862, -0.025479, 1.169067>, <-0.012862, -0.023066, 1.192078>, 
      <-0.023610, -0.057000, 1.123511>, <-0.021998, -0.053108, 1.146283>, <-0.011038, -0.026649, 1.169067>, <-0.010039, -0.024236, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.057000, -0.023610, 1.123511>, <-0.053108, -0.021998, 1.146283>, <-0.026649, -0.011038, 1.169067>, <-0.024236, -0.010039, 1.192078>, 
      <-0.054236, -0.030282, 1.123511>, <-0.050344, -0.028670, 1.146283>, <-0.025479, -0.013862, 1.169067>, <-0.023066, -0.012862, 1.192078>, 
      <-0.048733, -0.038519, 1.123511>, <-0.046184, -0.035970, 1.146928>, <-0.019967, -0.015645, 1.168537>, <-0.018078, -0.013756, 1.192078>, 
      <-0.043626, -0.043626, 1.123511>, <-0.041077, -0.041077, 1.146928>, <-0.017806, -0.017806, 1.168537>, <-0.015917, -0.015917, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.061696, 0.000000, 1.123511>, <-0.058091, 0.000000, 1.146927>, <-0.025183, 0.000000, 1.168537>, <-0.022511, 0.000000, 1.192078>, 
      <-0.061696, -0.007222, 1.123511>, <-0.058091, -0.007222, 1.146927>, <-0.025183, -0.003056, 1.168537>, <-0.022511, -0.003056, 1.192078>, 
      <-0.059764, -0.016938, 1.123511>, <-0.055871, -0.015326, 1.146283>, <-0.027818, -0.008215, 1.169067>, <-0.025406, -0.007216, 1.192078>, 
      <-0.057000, -0.023610, 1.123511>, <-0.053108, -0.021998, 1.146283>, <-0.026649, -0.011038, 1.169067>, <-0.024236, -0.010039, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.057000, 0.023610, 1.123511>, <-0.053108, 0.021998, 1.146283>, <-0.026649, 0.011038, 1.169067>, <-0.024236, 0.010039, 1.192078>, 
      <-0.059764, 0.016938, 1.123511>, <-0.055871, 0.015326, 1.146283>, <-0.027818, 0.008215, 1.169067>, <-0.025406, 0.007216, 1.192078>, 
      <-0.061696, 0.007222, 1.123511>, <-0.058091, 0.007222, 1.146927>, <-0.025183, 0.003056, 1.168537>, <-0.022511, 0.003056, 1.192078>, 
      <-0.061696, 0.000000, 1.123511>, <-0.058091, 0.000000, 1.146927>, <-0.025183, 0.000000, 1.168537>, <-0.022511, 0.000000, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.043626, 0.043626, 1.123511>, <-0.041077, 0.041077, 1.146928>, <-0.017806, 0.017806, 1.168537>, <-0.015917, 0.015917, 1.192078>, 
      <-0.048733, 0.038519, 1.123511>, <-0.046184, 0.035970, 1.146928>, <-0.019967, 0.015645, 1.168537>, <-0.018078, 0.013756, 1.192078>, 
      <-0.054236, 0.030282, 1.123511>, <-0.050344, 0.028670, 1.146283>, <-0.025479, 0.013862, 1.169067>, <-0.023066, 0.012862, 1.192078>, 
      <-0.057000, 0.023610, 1.123511>, <-0.053108, 0.021998, 1.146283>, <-0.026649, 0.011038, 1.169067>, <-0.024236, 0.010039, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.023610, 0.057000, 1.123511>, <-0.021998, 0.053108, 1.146283>, <-0.011038, 0.026649, 1.169067>, <-0.010039, 0.024236, 1.192078>, 
      <-0.030282, 0.054236, 1.123511>, <-0.028670, 0.050344, 1.146283>, <-0.013862, 0.025479, 1.169067>, <-0.012862, 0.023066, 1.192078>, 
      <-0.038519, 0.048733, 1.123511>, <-0.035970, 0.046184, 1.146928>, <-0.015645, 0.019967, 1.168537>, <-0.013756, 0.018078, 1.192078>, 
      <-0.043626, 0.043626, 1.123511>, <-0.041077, 0.041077, 1.146928>, <-0.017806, 0.017806, 1.168537>, <-0.015917, 0.015917, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.061696, 1.123511>, <0.000000, 0.058091, 1.146927>, <0.000000, 0.025183, 1.168537>, <0.000000, 0.022511, 1.192078>, 
      <-0.007222, 0.061696, 1.123511>, <-0.007222, 0.058091, 1.146927>, <-0.003056, 0.025183, 1.168537>, <-0.003056, 0.022511, 1.192078>, 
      <-0.016938, 0.059764, 1.123511>, <-0.015326, 0.055871, 1.146283>, <-0.008215, 0.027818, 1.169067>, <-0.007216, 0.025406, 1.192078>, 
      <-0.023610, 0.057000, 1.123511>, <-0.021998, 0.053108, 1.146283>, <-0.011038, 0.026649, 1.169067>, <-0.010039, 0.024236, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.023610, 0.057000, 1.123511>, <0.021998, 0.053108, 1.146283>, <0.011038, 0.026649, 1.169067>, <0.010039, 0.024236, 1.192078>, 
      <0.016938, 0.059764, 1.123511>, <0.015326, 0.055871, 1.146283>, <0.008215, 0.027818, 1.169067>, <0.007216, 0.025406, 1.192078>, 
      <0.007222, 0.061696, 1.123511>, <0.007222, 0.058091, 1.146927>, <0.003056, 0.025183, 1.168537>, <0.003056, 0.022511, 1.192078>, 
      <0.000000, 0.061696, 1.123511>, <0.000000, 0.058091, 1.146927>, <0.000000, 0.025183, 1.168537>, <0.000000, 0.022511, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.043626, 0.043626, 1.123511>, <0.041077, 0.041077, 1.146928>, <0.017806, 0.017806, 1.168537>, <0.015917, 0.015917, 1.192078>, 
      <0.038519, 0.048733, 1.123511>, <0.035970, 0.046184, 1.146928>, <0.015645, 0.019967, 1.168537>, <0.013756, 0.018078, 1.192078>, 
      <0.030282, 0.054236, 1.123511>, <0.028670, 0.050344, 1.146283>, <0.013862, 0.025479, 1.169067>, <0.012862, 0.023066, 1.192078>, 
      <0.023610, 0.057000, 1.123511>, <0.021998, 0.053108, 1.146283>, <0.011038, 0.026649, 1.169067>, <0.010039, 0.024236, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.057000, 0.023610, 1.123511>, <0.053108, 0.021998, 1.146283>, <0.026649, 0.011038, 1.169067>, <0.024236, 0.010039, 1.192078>, 
      <0.054236, 0.030282, 1.123511>, <0.050344, 0.028670, 1.146283>, <0.025479, 0.013862, 1.169067>, <0.023066, 0.012862, 1.192078>, 
      <0.048733, 0.038519, 1.123511>, <0.046184, 0.035970, 1.146928>, <0.019967, 0.015645, 1.168537>, <0.018078, 0.013756, 1.192078>, 
      <0.043626, 0.043626, 1.123511>, <0.041077, 0.041077, 1.146928>, <0.017806, 0.017806, 1.168537>, <0.015917, 0.015917, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.027052, -0.027052, 1.089785>, <0.024145, -0.024145, 1.101400>, <0.044952, -0.044952, 1.111333>, <0.043626, -0.043626, 1.123511>, 
      <0.030907, -0.023197, 1.089785>, <0.028000, -0.020290, 1.101400>, <0.050058, -0.039845, 1.111333>, <0.048733, -0.038519, 1.123511>, 
      <0.038532, -0.021861, 1.096232>, <0.034232, -0.020080, 1.104812>, <0.055877, -0.030962, 1.113913>, <0.054236, -0.030282, 1.123511>, 
      <0.040618, -0.016824, 1.096232>, <0.036319, -0.015043, 1.104812>, <0.058640, -0.024289, 1.113913>, <0.057000, -0.023610, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.016824, -0.040618, 1.096232>, <0.015043, -0.036319, 1.104812>, <0.024289, -0.058640, 1.113913>, <0.023610, -0.057000, 1.123511>, 
      <0.021861, -0.038532, 1.096232>, <0.020080, -0.034232, 1.104812>, <0.030962, -0.055877, 1.113913>, <0.030282, -0.054236, 1.123511>, 
      <0.023197, -0.030907, 1.089785>, <0.020290, -0.028000, 1.101400>, <0.039845, -0.050058, 1.111333>, <0.038519, -0.048733, 1.123511>, 
      <0.027052, -0.027052, 1.089785>, <0.024145, -0.024145, 1.101400>, <0.044952, -0.044952, 1.111333>, <0.043626, -0.043626, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.038257, 1.089785>, <0.000000, -0.034146, 1.101400>, <0.000000, -0.063571, 1.111333>, <0.000000, -0.061696, 1.123511>, 
      <0.005451, -0.038257, 1.089785>, <0.005451, -0.034146, 1.101400>, <0.007222, -0.063571, 1.111333>, <0.007222, -0.061696, 1.123511>, 
      <0.011788, -0.042704, 1.096232>, <0.010007, -0.038405, 1.104812>, <0.017617, -0.061404, 1.113913>, <0.016938, -0.059764, 1.123511>, 
      <0.016824, -0.040618, 1.096232>, <0.015043, -0.036319, 1.104812>, <0.024289, -0.058640, 1.113913>, <0.023610, -0.057000, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.016824, -0.040618, 1.096232>, <-0.015043, -0.036319, 1.104812>, <-0.024289, -0.058640, 1.113913>, <-0.023610, -0.057000, 1.123511>, 
      <-0.011788, -0.042704, 1.096232>, <-0.010007, -0.038405, 1.104812>, <-0.017617, -0.061404, 1.113913>, <-0.016938, -0.059764, 1.123511>, 
      <-0.005451, -0.038257, 1.089785>, <-0.005451, -0.034146, 1.101400>, <-0.007222, -0.063571, 1.111333>, <-0.007222, -0.061696, 1.123511>, 
      <0.000000, -0.038257, 1.089785>, <0.000000, -0.034146, 1.101400>, <0.000000, -0.063571, 1.111333>, <0.000000, -0.061696, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.027052, -0.027052, 1.089785>, <-0.024145, -0.024145, 1.101400>, <-0.044952, -0.044952, 1.111333>, <-0.043626, -0.043626, 1.123511>, 
      <-0.023197, -0.030907, 1.089785>, <-0.020290, -0.028000, 1.101400>, <-0.039845, -0.050058, 1.111333>, <-0.038519, -0.048733, 1.123511>, 
      <-0.021861, -0.038532, 1.096232>, <-0.020080, -0.034232, 1.104812>, <-0.030962, -0.055877, 1.113913>, <-0.030282, -0.054236, 1.123511>, 
      <-0.016824, -0.040618, 1.096232>, <-0.015043, -0.036319, 1.104812>, <-0.024289, -0.058640, 1.113913>, <-0.023610, -0.057000, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.040618, -0.016824, 1.096232>, <-0.036319, -0.015043, 1.104812>, <-0.058640, -0.024289, 1.113913>, <-0.057000, -0.023610, 1.123511>, 
      <-0.038532, -0.021861, 1.096232>, <-0.034232, -0.020080, 1.104812>, <-0.055877, -0.030962, 1.113913>, <-0.054236, -0.030282, 1.123511>, 
      <-0.030907, -0.023197, 1.089785>, <-0.028000, -0.020290, 1.101400>, <-0.050058, -0.039845, 1.111333>, <-0.048733, -0.038519, 1.123511>, 
      <-0.027052, -0.027052, 1.089785>, <-0.024145, -0.024145, 1.101400>, <-0.044952, -0.044952, 1.111333>, <-0.043626, -0.043626, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.038257, 0.000000, 1.089785>, <-0.034146, 0.000000, 1.101400>, <-0.063571, 0.000000, 1.111333>, <-0.061696, 0.000000, 1.123511>, 
      <-0.038257, -0.005451, 1.089785>, <-0.034146, -0.005451, 1.101400>, <-0.063571, -0.007222, 1.111333>, <-0.061696, -0.007222, 1.123511>, 
      <-0.042704, -0.011788, 1.096232>, <-0.038405, -0.010007, 1.104812>, <-0.061404, -0.017617, 1.113913>, <-0.059764, -0.016938, 1.123511>, 
      <-0.040618, -0.016824, 1.096232>, <-0.036319, -0.015043, 1.104812>, <-0.058640, -0.024289, 1.113913>, <-0.057000, -0.023610, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.040618, 0.016824, 1.096232>, <-0.036319, 0.015043, 1.104812>, <-0.058640, 0.024289, 1.113913>, <-0.057000, 0.023610, 1.123511>, 
      <-0.042704, 0.011788, 1.096232>, <-0.038405, 0.010007, 1.104812>, <-0.061404, 0.017617, 1.113913>, <-0.059764, 0.016938, 1.123511>, 
      <-0.038257, 0.005451, 1.089785>, <-0.034146, 0.005451, 1.101400>, <-0.063571, 0.007222, 1.111333>, <-0.061696, 0.007222, 1.123511>, 
      <-0.038257, 0.000000, 1.089785>, <-0.034146, 0.000000, 1.101400>, <-0.063571, 0.000000, 1.111333>, <-0.061696, 0.000000, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.027052, 0.027052, 1.089785>, <-0.024145, 0.024145, 1.101400>, <-0.044952, 0.044952, 1.111333>, <-0.043626, 0.043626, 1.123511>, 
      <-0.030907, 0.023197, 1.089785>, <-0.028000, 0.020290, 1.101400>, <-0.050058, 0.039845, 1.111333>, <-0.048733, 0.038519, 1.123511>, 
      <-0.038532, 0.021861, 1.096232>, <-0.034232, 0.020080, 1.104812>, <-0.055877, 0.030962, 1.113913>, <-0.054236, 0.030282, 1.123511>, 
      <-0.040618, 0.016824, 1.096232>, <-0.036319, 0.015043, 1.104812>, <-0.058640, 0.024289, 1.113913>, <-0.057000, 0.023610, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.016824, 0.040618, 1.096232>, <-0.015043, 0.036319, 1.104812>, <-0.024289, 0.058640, 1.113913>, <-0.023610, 0.057000, 1.123511>, 
      <-0.021861, 0.038532, 1.096232>, <-0.020080, 0.034232, 1.104812>, <-0.030962, 0.055877, 1.113913>, <-0.030282, 0.054236, 1.123511>, 
      <-0.023197, 0.030907, 1.089785>, <-0.020290, 0.028000, 1.101400>, <-0.039845, 0.050058, 1.111333>, <-0.038519, 0.048733, 1.123511>, 
      <-0.027052, 0.027052, 1.089785>, <-0.024145, 0.024145, 1.101400>, <-0.044952, 0.044952, 1.111333>, <-0.043626, 0.043626, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.038257, 1.089785>, <0.000000, 0.034146, 1.101400>, <0.000000, 0.063571, 1.111333>, <0.000000, 0.061696, 1.123511>, 
      <-0.005451, 0.038257, 1.089785>, <-0.005451, 0.034146, 1.101400>, <-0.007222, 0.063571, 1.111333>, <-0.007222, 0.061696, 1.123511>, 
      <-0.011788, 0.042704, 1.096232>, <-0.010007, 0.038405, 1.104812>, <-0.017617, 0.061404, 1.113913>, <-0.016938, 0.059764, 1.123511>, 
      <-0.016824, 0.040618, 1.096232>, <-0.015043, 0.036319, 1.104812>, <-0.024289, 0.058640, 1.113913>, <-0.023610, 0.057000, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.016824, 0.040618, 1.096232>, <0.015043, 0.036319, 1.104812>, <0.024289, 0.058640, 1.113913>, <0.023610, 0.057000, 1.123511>, 
      <0.011788, 0.042704, 1.096232>, <0.010007, 0.038405, 1.104812>, <0.017617, 0.061404, 1.113913>, <0.016938, 0.059764, 1.123511>, 
      <0.005451, 0.038257, 1.089785>, <0.005451, 0.034146, 1.101400>, <0.007222, 0.063571, 1.111333>, <0.007222, 0.061696, 1.123511>, 
      <0.000000, 0.038257, 1.089785>, <0.000000, 0.034146, 1.101400>, <0.000000, 0.063571, 1.111333>, <0.000000, 0.061696, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.027052, 0.027052, 1.089785>, <0.024145, 0.024145, 1.101400>, <0.044952, 0.044952, 1.111333>, <0.043626, 0.043626, 1.123511>, 
      <0.023197, 0.030907, 1.089785>, <0.020290, 0.028000, 1.101400>, <0.039845, 0.050058, 1.111333>, <0.038519, 0.048733, 1.123511>, 
      <0.021861, 0.038532, 1.096232>, <0.020080, 0.034232, 1.104812>, <0.030962, 0.055877, 1.113913>, <0.030282, 0.054236, 1.123511>, 
      <0.016824, 0.040618, 1.096232>, <0.015043, 0.036319, 1.104812>, <0.024289, 0.058640, 1.113913>, <0.023610, 0.057000, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.040618, 0.016824, 1.096232>, <0.036319, 0.015043, 1.104812>, <0.058640, 0.024289, 1.113913>, <0.057000, 0.023610, 1.123511>, 
      <0.038532, 0.021861, 1.096232>, <0.034232, 0.020080, 1.104812>, <0.055877, 0.030962, 1.113913>, <0.054236, 0.030282, 1.123511>, 
      <0.030907, 0.023197, 1.089785>, <0.028000, 0.020290, 1.101400>, <0.050058, 0.039845, 1.111333>, <0.048733, 0.038519, 1.123511>, 
      <0.027052, 0.027052, 1.089785>, <0.024145, 0.024145, 1.101400>, <0.044952, 0.044952, 1.111333>, <0.043626, 0.043626, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.061462, -0.061462, 1.052253>, <0.058611, -0.058611, 1.070243>, <0.031402, -0.031402, 1.072405>, <0.027052, -0.027052, 1.089785>, 
      <0.069652, -0.053272, 1.052253>, <0.066800, -0.050421, 1.070243>, <0.035257, -0.027547, 1.072405>, <0.030907, -0.023197, 1.089785>, 
      <0.087850, -0.048926, 1.053101>, <0.083353, -0.047063, 1.073721>, <0.047864, -0.025726, 1.077609>, <0.038532, -0.021861, 1.096232>, 
      <0.092282, -0.038225, 1.053101>, <0.087786, -0.036362, 1.073721>, <0.049950, -0.020690, 1.077609>, <0.040618, -0.016824, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.038225, -0.092282, 1.053101>, <0.036362, -0.087786, 1.073721>, <0.020690, -0.049950, 1.077609>, <0.016824, -0.040618, 1.096232>, 
      <0.048926, -0.087850, 1.053101>, <0.047063, -0.083353, 1.073721>, <0.025726, -0.047864, 1.077609>, <0.021861, -0.038532, 1.096232>, 
      <0.053272, -0.069652, 1.052253>, <0.050421, -0.066800, 1.070243>, <0.027547, -0.035257, 1.072405>, <0.023197, -0.030907, 1.089785>, 
      <0.061462, -0.061462, 1.052253>, <0.058611, -0.058611, 1.070243>, <0.031402, -0.031402, 1.072405>, <0.027052, -0.027052, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.086920, 1.052253>, <0.000000, -0.082888, 1.070243>, <0.000000, -0.044409, 1.072405>, <0.000000, -0.038257, 1.089785>, 
      <0.011583, -0.086920, 1.052253>, <0.011583, -0.082888, 1.070243>, <0.005451, -0.044409, 1.072405>, <0.005451, -0.038257, 1.089785>, 
      <0.027524, -0.096714, 1.053101>, <0.025662, -0.092218, 1.073721>, <0.015653, -0.052036, 1.077609>, <0.011788, -0.042704, 1.096232>, 
      <0.038225, -0.092282, 1.053101>, <0.036362, -0.087786, 1.073721>, <0.020690, -0.049950, 1.077609>, <0.016824, -0.040618, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.038225, -0.092282, 1.053101>, <-0.036362, -0.087786, 1.073721>, <-0.020690, -0.049950, 1.077609>, <-0.016824, -0.040618, 1.096232>, 
      <-0.027524, -0.096714, 1.053101>, <-0.025662, -0.092218, 1.073721>, <-0.015653, -0.052036, 1.077609>, <-0.011788, -0.042704, 1.096232>, 
      <-0.011583, -0.086920, 1.052253>, <-0.011583, -0.082888, 1.070243>, <-0.005451, -0.044409, 1.072405>, <-0.005451, -0.038257, 1.089785>, 
      <0.000000, -0.086920, 1.052253>, <0.000000, -0.082888, 1.070243>, <0.000000, -0.044409, 1.072405>, <0.000000, -0.038257, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.061462, -0.061462, 1.052253>, <-0.058611, -0.058611, 1.070243>, <-0.031402, -0.031402, 1.072405>, <-0.027052, -0.027052, 1.089785>, 
      <-0.053272, -0.069652, 1.052253>, <-0.050421, -0.066800, 1.070243>, <-0.027547, -0.035257, 1.072405>, <-0.023197, -0.030907, 1.089785>, 
      <-0.048926, -0.087850, 1.053101>, <-0.047063, -0.083353, 1.073721>, <-0.025726, -0.047864, 1.077609>, <-0.021861, -0.038532, 1.096232>, 
      <-0.038225, -0.092282, 1.053101>, <-0.036362, -0.087786, 1.073721>, <-0.020690, -0.049950, 1.077609>, <-0.016824, -0.040618, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.092282, -0.038225, 1.053101>, <-0.087786, -0.036362, 1.073721>, <-0.049950, -0.020690, 1.077609>, <-0.040618, -0.016824, 1.096232>, 
      <-0.087850, -0.048926, 1.053101>, <-0.083353, -0.047063, 1.073721>, <-0.047864, -0.025726, 1.077609>, <-0.038532, -0.021861, 1.096232>, 
      <-0.069652, -0.053272, 1.052253>, <-0.066800, -0.050421, 1.070243>, <-0.035257, -0.027547, 1.072405>, <-0.030907, -0.023197, 1.089785>, 
      <-0.061462, -0.061462, 1.052253>, <-0.058611, -0.058611, 1.070243>, <-0.031402, -0.031402, 1.072405>, <-0.027052, -0.027052, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.086920, 0.000000, 1.052253>, <-0.082888, 0.000000, 1.070243>, <-0.044409, 0.000000, 1.072405>, <-0.038257, 0.000000, 1.089785>, 
      <-0.086920, -0.011583, 1.052253>, <-0.082888, -0.011583, 1.070243>, <-0.044409, -0.005451, 1.072405>, <-0.038257, -0.005451, 1.089785>, 
      <-0.096714, -0.027524, 1.053101>, <-0.092218, -0.025662, 1.073721>, <-0.052036, -0.015653, 1.077609>, <-0.042704, -0.011788, 1.096232>, 
      <-0.092282, -0.038225, 1.053101>, <-0.087786, -0.036362, 1.073721>, <-0.049950, -0.020690, 1.077609>, <-0.040618, -0.016824, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.092282, 0.038225, 1.053101>, <-0.087786, 0.036362, 1.073721>, <-0.049950, 0.020690, 1.077609>, <-0.040618, 0.016824, 1.096232>, 
      <-0.096714, 0.027524, 1.053101>, <-0.092218, 0.025662, 1.073721>, <-0.052036, 0.015653, 1.077609>, <-0.042704, 0.011788, 1.096232>, 
      <-0.086920, 0.011583, 1.052253>, <-0.082888, 0.011583, 1.070243>, <-0.044409, 0.005451, 1.072405>, <-0.038257, 0.005451, 1.089785>, 
      <-0.086920, 0.000000, 1.052253>, <-0.082888, 0.000000, 1.070243>, <-0.044409, 0.000000, 1.072405>, <-0.038257, 0.000000, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.061462, 0.061462, 1.052253>, <-0.058611, 0.058611, 1.070243>, <-0.031402, 0.031402, 1.072405>, <-0.027052, 0.027052, 1.089785>, 
      <-0.069652, 0.053272, 1.052253>, <-0.066800, 0.050421, 1.070243>, <-0.035257, 0.027547, 1.072405>, <-0.030907, 0.023197, 1.089785>, 
      <-0.087850, 0.048926, 1.053101>, <-0.083353, 0.047063, 1.073721>, <-0.047864, 0.025726, 1.077609>, <-0.038532, 0.021861, 1.096232>, 
      <-0.092282, 0.038225, 1.053101>, <-0.087786, 0.036362, 1.073721>, <-0.049950, 0.020690, 1.077609>, <-0.040618, 0.016824, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.038225, 0.092282, 1.053101>, <-0.036362, 0.087786, 1.073721>, <-0.020690, 0.049950, 1.077609>, <-0.016824, 0.040618, 1.096232>, 
      <-0.048926, 0.087850, 1.053101>, <-0.047063, 0.083353, 1.073721>, <-0.025726, 0.047864, 1.077609>, <-0.021861, 0.038532, 1.096232>, 
      <-0.053272, 0.069652, 1.052253>, <-0.050421, 0.066800, 1.070243>, <-0.027547, 0.035257, 1.072405>, <-0.023197, 0.030907, 1.089785>, 
      <-0.061462, 0.061462, 1.052253>, <-0.058611, 0.058611, 1.070243>, <-0.031402, 0.031402, 1.072405>, <-0.027052, 0.027052, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.086920, 1.052253>, <0.000000, 0.082888, 1.070243>, <0.000000, 0.044409, 1.072405>, <0.000000, 0.038257, 1.089785>, 
      <-0.011583, 0.086920, 1.052253>, <-0.011583, 0.082888, 1.070243>, <-0.005451, 0.044409, 1.072405>, <-0.005451, 0.038257, 1.089785>, 
      <-0.027524, 0.096714, 1.053101>, <-0.025662, 0.092218, 1.073721>, <-0.015653, 0.052036, 1.077609>, <-0.011788, 0.042704, 1.096232>, 
      <-0.038225, 0.092282, 1.053101>, <-0.036362, 0.087786, 1.073721>, <-0.020690, 0.049950, 1.077609>, <-0.016824, 0.040618, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.038225, 0.092282, 1.053101>, <0.036362, 0.087786, 1.073721>, <0.020690, 0.049950, 1.077609>, <0.016824, 0.040618, 1.096232>, 
      <0.027524, 0.096714, 1.053101>, <0.025662, 0.092218, 1.073721>, <0.015653, 0.052036, 1.077609>, <0.011788, 0.042704, 1.096232>, 
      <0.011583, 0.086920, 1.052253>, <0.011583, 0.082888, 1.070243>, <0.005451, 0.044409, 1.072405>, <0.005451, 0.038257, 1.089785>, 
      <0.000000, 0.086920, 1.052253>, <0.000000, 0.082888, 1.070243>, <0.000000, 0.044409, 1.072405>, <0.000000, 0.038257, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.061462, 0.061462, 1.052253>, <0.058611, 0.058611, 1.070243>, <0.031402, 0.031402, 1.072405>, <0.027052, 0.027052, 1.089785>, 
      <0.053272, 0.069652, 1.052253>, <0.050421, 0.066800, 1.070243>, <0.027547, 0.035257, 1.072405>, <0.023197, 0.030907, 1.089785>, 
      <0.048926, 0.087850, 1.053101>, <0.047063, 0.083353, 1.073721>, <0.025726, 0.047864, 1.077609>, <0.021861, 0.038532, 1.096232>, 
      <0.038225, 0.092282, 1.053101>, <0.036362, 0.087786, 1.073721>, <0.020690, 0.049950, 1.077609>, <0.016824, 0.040618, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.092282, 0.038225, 1.053101>, <0.087786, 0.036362, 1.073721>, <0.049950, 0.020690, 1.077609>, <0.040618, 0.016824, 1.096232>, 
      <0.087850, 0.048926, 1.053101>, <0.083353, 0.047063, 1.073721>, <0.047864, 0.025726, 1.077609>, <0.038532, 0.021861, 1.096232>, 
      <0.069652, 0.053272, 1.052253>, <0.066800, 0.050421, 1.070243>, <0.035257, 0.027547, 1.072405>, <0.030907, 0.023197, 1.089785>, 
      <0.061462, 0.061462, 1.052253>, <0.058611, 0.058611, 1.070243>, <0.031402, 0.031402, 1.072405>, <0.027052, 0.027052, 1.089785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.050897, -0.050897, 0.939340>, <0.050893, -0.050893, 0.939375>, <0.066747, -0.066747, 1.018911>, <0.061462, -0.061462, 1.052253>, 
      <0.057852, -0.043942, 0.939340>, <0.057848, -0.043938, 0.939375>, <0.074937, -0.058557, 1.018911>, <0.069652, -0.053272, 1.052253>, 
      <0.072656, -0.040741, 0.932044>, <0.072653, -0.040740, 0.932082>, <0.095634, -0.052150, 1.017401>, <0.087850, -0.048926, 1.053101>, 
      <0.076420, -0.031654, 0.932044>, <0.076417, -0.031653, 0.932082>, <0.100067, -0.041450, 1.017401>, <0.092282, -0.038225, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.031654, -0.076420, 0.932044>, <0.031653, -0.076417, 0.932082>, <0.041450, -0.100067, 1.017401>, <0.038225, -0.092282, 1.053101>, 
      <0.040741, -0.072656, 0.932044>, <0.040740, -0.072653, 0.932082>, <0.052150, -0.095634, 1.017401>, <0.048926, -0.087850, 1.053101>, 
      <0.043942, -0.057852, 0.939340>, <0.043938, -0.057848, 0.939375>, <0.058557, -0.074937, 1.018911>, <0.053272, -0.069652, 1.052253>, 
      <0.050897, -0.050897, 0.939340>, <0.050893, -0.050893, 0.939375>, <0.066747, -0.066747, 1.018911>, <0.061462, -0.061462, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.071979, 0.939340>, <0.000000, -0.071973, 0.939375>, <0.000000, -0.094394, 1.018911>, <0.000000, -0.086920, 1.052253>, 
      <0.009836, -0.071979, 0.939340>, <0.009836, -0.071973, 0.939375>, <0.011583, -0.094394, 1.018911>, <0.011583, -0.086920, 1.052253>, 
      <0.022567, -0.080184, 0.932044>, <0.022565, -0.080181, 0.932082>, <0.030749, -0.104499, 1.017401>, <0.027524, -0.096714, 1.053101>, 
      <0.031654, -0.076420, 0.932044>, <0.031653, -0.076417, 0.932082>, <0.041450, -0.100067, 1.017401>, <0.038225, -0.092282, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.031654, -0.076420, 0.932044>, <-0.031653, -0.076417, 0.932082>, <-0.041450, -0.100067, 1.017401>, <-0.038225, -0.092282, 1.053101>, 
      <-0.022567, -0.080184, 0.932044>, <-0.022565, -0.080181, 0.932082>, <-0.030749, -0.104499, 1.017401>, <-0.027524, -0.096714, 1.053101>, 
      <-0.009836, -0.071979, 0.939340>, <-0.009836, -0.071973, 0.939375>, <-0.011583, -0.094394, 1.018911>, <-0.011583, -0.086920, 1.052253>, 
      <0.000000, -0.071979, 0.939340>, <0.000000, -0.071973, 0.939375>, <0.000000, -0.094394, 1.018911>, <0.000000, -0.086920, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.050897, -0.050897, 0.939340>, <-0.050893, -0.050893, 0.939375>, <-0.066747, -0.066747, 1.018911>, <-0.061462, -0.061462, 1.052253>, 
      <-0.043942, -0.057852, 0.939340>, <-0.043938, -0.057848, 0.939375>, <-0.058557, -0.074937, 1.018911>, <-0.053272, -0.069652, 1.052253>, 
      <-0.040741, -0.072656, 0.932044>, <-0.040740, -0.072653, 0.932082>, <-0.052150, -0.095634, 1.017401>, <-0.048926, -0.087850, 1.053101>, 
      <-0.031654, -0.076420, 0.932044>, <-0.031653, -0.076417, 0.932082>, <-0.041450, -0.100067, 1.017401>, <-0.038225, -0.092282, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.076420, -0.031654, 0.932044>, <-0.076417, -0.031653, 0.932082>, <-0.100067, -0.041450, 1.017401>, <-0.092282, -0.038225, 1.053101>, 
      <-0.072656, -0.040741, 0.932044>, <-0.072653, -0.040740, 0.932082>, <-0.095634, -0.052150, 1.017401>, <-0.087850, -0.048926, 1.053101>, 
      <-0.057852, -0.043942, 0.939340>, <-0.057848, -0.043938, 0.939375>, <-0.074937, -0.058557, 1.018911>, <-0.069652, -0.053272, 1.052253>, 
      <-0.050897, -0.050897, 0.939340>, <-0.050893, -0.050893, 0.939375>, <-0.066747, -0.066747, 1.018911>, <-0.061462, -0.061462, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.071979, 0.000000, 0.939340>, <-0.071973, 0.000000, 0.939375>, <-0.094394, 0.000000, 1.018911>, <-0.086920, 0.000000, 1.052253>, 
      <-0.071979, -0.009836, 0.939340>, <-0.071973, -0.009836, 0.939375>, <-0.094394, -0.011583, 1.018911>, <-0.086920, -0.011583, 1.052253>, 
      <-0.080184, -0.022567, 0.932044>, <-0.080181, -0.022565, 0.932082>, <-0.104499, -0.030749, 1.017401>, <-0.096714, -0.027524, 1.053101>, 
      <-0.076420, -0.031654, 0.932044>, <-0.076417, -0.031653, 0.932082>, <-0.100067, -0.041450, 1.017401>, <-0.092282, -0.038225, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.076420, 0.031654, 0.932044>, <-0.076417, 0.031653, 0.932082>, <-0.100067, 0.041450, 1.017401>, <-0.092282, 0.038225, 1.053101>, 
      <-0.080184, 0.022567, 0.932044>, <-0.080181, 0.022565, 0.932082>, <-0.104499, 0.030749, 1.017401>, <-0.096714, 0.027524, 1.053101>, 
      <-0.071979, 0.009836, 0.939340>, <-0.071973, 0.009836, 0.939375>, <-0.094394, 0.011583, 1.018911>, <-0.086920, 0.011583, 1.052253>, 
      <-0.071979, 0.000000, 0.939340>, <-0.071973, 0.000000, 0.939375>, <-0.094394, 0.000000, 1.018911>, <-0.086920, 0.000000, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.050897, 0.050897, 0.939340>, <-0.050893, 0.050893, 0.939375>, <-0.066747, 0.066747, 1.018911>, <-0.061462, 0.061462, 1.052253>, 
      <-0.057852, 0.043942, 0.939340>, <-0.057848, 0.043938, 0.939375>, <-0.074937, 0.058557, 1.018911>, <-0.069652, 0.053272, 1.052253>, 
      <-0.072656, 0.040741, 0.932044>, <-0.072653, 0.040740, 0.932082>, <-0.095634, 0.052150, 1.017401>, <-0.087850, 0.048926, 1.053101>, 
      <-0.076420, 0.031654, 0.932044>, <-0.076417, 0.031653, 0.932082>, <-0.100067, 0.041450, 1.017401>, <-0.092282, 0.038225, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.031654, 0.076420, 0.932044>, <-0.031653, 0.076417, 0.932082>, <-0.041450, 0.100067, 1.017401>, <-0.038225, 0.092282, 1.053101>, 
      <-0.040741, 0.072656, 0.932044>, <-0.040740, 0.072653, 0.932082>, <-0.052150, 0.095634, 1.017401>, <-0.048926, 0.087850, 1.053101>, 
      <-0.043942, 0.057852, 0.939340>, <-0.043938, 0.057848, 0.939375>, <-0.058557, 0.074937, 1.018911>, <-0.053272, 0.069652, 1.052253>, 
      <-0.050897, 0.050897, 0.939340>, <-0.050893, 0.050893, 0.939375>, <-0.066747, 0.066747, 1.018911>, <-0.061462, 0.061462, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.071979, 0.939340>, <0.000000, 0.071973, 0.939375>, <0.000000, 0.094394, 1.018911>, <0.000000, 0.086920, 1.052253>, 
      <-0.009836, 0.071979, 0.939340>, <-0.009836, 0.071973, 0.939375>, <-0.011583, 0.094394, 1.018911>, <-0.011583, 0.086920, 1.052253>, 
      <-0.022567, 0.080184, 0.932044>, <-0.022565, 0.080181, 0.932082>, <-0.030749, 0.104499, 1.017401>, <-0.027524, 0.096714, 1.053101>, 
      <-0.031654, 0.076420, 0.932044>, <-0.031653, 0.076417, 0.932082>, <-0.041450, 0.100067, 1.017401>, <-0.038225, 0.092282, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.031654, 0.076420, 0.932044>, <0.031653, 0.076417, 0.932082>, <0.041450, 0.100067, 1.017401>, <0.038225, 0.092282, 1.053101>, 
      <0.022567, 0.080184, 0.932044>, <0.022565, 0.080181, 0.932082>, <0.030749, 0.104499, 1.017401>, <0.027524, 0.096714, 1.053101>, 
      <0.009836, 0.071979, 0.939340>, <0.009836, 0.071973, 0.939375>, <0.011583, 0.094394, 1.018911>, <0.011583, 0.086920, 1.052253>, 
      <0.000000, 0.071979, 0.939340>, <0.000000, 0.071973, 0.939375>, <0.000000, 0.094394, 1.018911>, <0.000000, 0.086920, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.050897, 0.050897, 0.939340>, <0.050893, 0.050893, 0.939375>, <0.066747, 0.066747, 1.018911>, <0.061462, 0.061462, 1.052253>, 
      <0.043942, 0.057852, 0.939340>, <0.043938, 0.057848, 0.939375>, <0.058557, 0.074937, 1.018911>, <0.053272, 0.069652, 1.052253>, 
      <0.040741, 0.072656, 0.932044>, <0.040740, 0.072653, 0.932082>, <0.052150, 0.095634, 1.017401>, <0.048926, 0.087850, 1.053101>, 
      <0.031654, 0.076420, 0.932044>, <0.031653, 0.076417, 0.932082>, <0.041450, 0.100067, 1.017401>, <0.038225, 0.092282, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.076420, 0.031654, 0.932044>, <0.076417, 0.031653, 0.932082>, <0.100067, 0.041450, 1.017401>, <0.092282, 0.038225, 1.053101>, 
      <0.072656, 0.040741, 0.932044>, <0.072653, 0.040740, 0.932082>, <0.095634, 0.052150, 1.017401>, <0.087850, 0.048926, 1.053101>, 
      <0.057852, 0.043942, 0.939340>, <0.057848, 0.043938, 0.939375>, <0.074937, 0.058557, 1.018911>, <0.069652, 0.053272, 1.052253>, 
      <0.050897, 0.050897, 0.939340>, <0.050893, 0.050893, 0.939375>, <0.066747, 0.066747, 1.018911>, <0.061462, 0.061462, 1.052253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.081637, -0.081637, 0.880456>, <0.083006, -0.083006, 0.893593>, <0.050900, -0.050900, 0.939317>, <0.050897, -0.050897, 0.939340>, 
      <0.091193, -0.072081, 0.880456>, <0.092562, -0.073450, 0.893593>, <0.057855, -0.043945, 0.939317>, <0.057852, -0.043942, 0.939340>, 
      <0.101492, -0.056667, 0.880456>, <0.104913, -0.058084, 0.890904>, <0.072658, -0.040742, 0.932025>, <0.072656, -0.040741, 0.932044>, 
      <0.106664, -0.044182, 0.880456>, <0.110085, -0.045599, 0.890904>, <0.076422, -0.031655, 0.932025>, <0.076420, -0.031654, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.044182, -0.106664, 0.880456>, <0.045599, -0.110085, 0.890904>, <0.031655, -0.076422, 0.932025>, <0.031654, -0.076420, 0.932044>, 
      <0.056667, -0.101492, 0.880456>, <0.058084, -0.104913, 0.890904>, <0.040742, -0.072658, 0.932025>, <0.040741, -0.072656, 0.932044>, 
      <0.072081, -0.091193, 0.880456>, <0.073450, -0.092562, 0.893593>, <0.043945, -0.057855, 0.939317>, <0.043942, -0.057852, 0.939340>, 
      <0.081637, -0.081637, 0.880456>, <0.083006, -0.083006, 0.893593>, <0.050900, -0.050900, 0.939317>, <0.050897, -0.050897, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.115452, 0.880456>, <0.000000, -0.117388, 0.893593>, <0.000000, -0.071983, 0.939317>, <0.000000, -0.071979, 0.939340>, 
      <0.013514, -0.115452, 0.880456>, <0.013514, -0.117388, 0.893593>, <0.009836, -0.071983, 0.939317>, <0.009836, -0.071979, 0.939340>, 
      <0.031697, -0.111836, 0.880456>, <0.033113, -0.115257, 0.890904>, <0.022568, -0.080186, 0.932025>, <0.022567, -0.080184, 0.932044>, 
      <0.044182, -0.106664, 0.880456>, <0.045599, -0.110085, 0.890904>, <0.031655, -0.076422, 0.932025>, <0.031654, -0.076420, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.044182, -0.106664, 0.880456>, <-0.045599, -0.110085, 0.890904>, <-0.031655, -0.076422, 0.932025>, <-0.031654, -0.076420, 0.932044>, 
      <-0.031697, -0.111836, 0.880456>, <-0.033113, -0.115257, 0.890904>, <-0.022568, -0.080186, 0.932025>, <-0.022567, -0.080184, 0.932044>, 
      <-0.013514, -0.115452, 0.880456>, <-0.013514, -0.117388, 0.893593>, <-0.009836, -0.071983, 0.939317>, <-0.009836, -0.071979, 0.939340>, 
      <0.000000, -0.115452, 0.880456>, <0.000000, -0.117388, 0.893593>, <0.000000, -0.071983, 0.939317>, <0.000000, -0.071979, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.081637, -0.081637, 0.880456>, <-0.083006, -0.083006, 0.893593>, <-0.050900, -0.050900, 0.939317>, <-0.050897, -0.050897, 0.939340>, 
      <-0.072081, -0.091193, 0.880456>, <-0.073450, -0.092562, 0.893593>, <-0.043945, -0.057855, 0.939317>, <-0.043942, -0.057852, 0.939340>, 
      <-0.056667, -0.101492, 0.880456>, <-0.058084, -0.104913, 0.890904>, <-0.040742, -0.072658, 0.932025>, <-0.040741, -0.072656, 0.932044>, 
      <-0.044182, -0.106664, 0.880456>, <-0.045599, -0.110085, 0.890904>, <-0.031655, -0.076422, 0.932025>, <-0.031654, -0.076420, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.106664, -0.044182, 0.880456>, <-0.110085, -0.045599, 0.890904>, <-0.076422, -0.031655, 0.932025>, <-0.076420, -0.031654, 0.932044>, 
      <-0.101492, -0.056667, 0.880456>, <-0.104913, -0.058084, 0.890904>, <-0.072658, -0.040742, 0.932025>, <-0.072656, -0.040741, 0.932044>, 
      <-0.091193, -0.072081, 0.880456>, <-0.092562, -0.073450, 0.893593>, <-0.057855, -0.043945, 0.939317>, <-0.057852, -0.043942, 0.939340>, 
      <-0.081637, -0.081637, 0.880456>, <-0.083006, -0.083006, 0.893593>, <-0.050900, -0.050900, 0.939317>, <-0.050897, -0.050897, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.115452, 0.000000, 0.880456>, <-0.117388, 0.000000, 0.893593>, <-0.071983, 0.000000, 0.939317>, <-0.071979, 0.000000, 0.939340>, 
      <-0.115452, -0.013514, 0.880456>, <-0.117388, -0.013514, 0.893593>, <-0.071983, -0.009836, 0.939317>, <-0.071979, -0.009836, 0.939340>, 
      <-0.111836, -0.031697, 0.880456>, <-0.115257, -0.033113, 0.890904>, <-0.080186, -0.022568, 0.932025>, <-0.080184, -0.022567, 0.932044>, 
      <-0.106664, -0.044182, 0.880456>, <-0.110085, -0.045599, 0.890904>, <-0.076422, -0.031655, 0.932025>, <-0.076420, -0.031654, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.106664, 0.044182, 0.880456>, <-0.110085, 0.045599, 0.890904>, <-0.076422, 0.031655, 0.932025>, <-0.076420, 0.031654, 0.932044>, 
      <-0.111836, 0.031697, 0.880456>, <-0.115257, 0.033113, 0.890904>, <-0.080186, 0.022568, 0.932025>, <-0.080184, 0.022567, 0.932044>, 
      <-0.115452, 0.013514, 0.880456>, <-0.117388, 0.013514, 0.893593>, <-0.071983, 0.009836, 0.939317>, <-0.071979, 0.009836, 0.939340>, 
      <-0.115452, 0.000000, 0.880456>, <-0.117388, 0.000000, 0.893593>, <-0.071983, 0.000000, 0.939317>, <-0.071979, 0.000000, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.081637, 0.081637, 0.880456>, <-0.083006, 0.083006, 0.893593>, <-0.050900, 0.050900, 0.939317>, <-0.050897, 0.050897, 0.939340>, 
      <-0.091193, 0.072081, 0.880456>, <-0.092562, 0.073450, 0.893593>, <-0.057855, 0.043945, 0.939317>, <-0.057852, 0.043942, 0.939340>, 
      <-0.101492, 0.056667, 0.880456>, <-0.104913, 0.058084, 0.890904>, <-0.072658, 0.040742, 0.932025>, <-0.072656, 0.040741, 0.932044>, 
      <-0.106664, 0.044182, 0.880456>, <-0.110085, 0.045599, 0.890904>, <-0.076422, 0.031655, 0.932025>, <-0.076420, 0.031654, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.044182, 0.106664, 0.880456>, <-0.045599, 0.110085, 0.890904>, <-0.031655, 0.076422, 0.932025>, <-0.031654, 0.076420, 0.932044>, 
      <-0.056667, 0.101492, 0.880456>, <-0.058084, 0.104913, 0.890904>, <-0.040742, 0.072658, 0.932025>, <-0.040741, 0.072656, 0.932044>, 
      <-0.072081, 0.091193, 0.880456>, <-0.073450, 0.092562, 0.893593>, <-0.043945, 0.057855, 0.939317>, <-0.043942, 0.057852, 0.939340>, 
      <-0.081637, 0.081637, 0.880456>, <-0.083006, 0.083006, 0.893593>, <-0.050900, 0.050900, 0.939317>, <-0.050897, 0.050897, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.115452, 0.880456>, <0.000000, 0.117388, 0.893593>, <0.000000, 0.071983, 0.939317>, <0.000000, 0.071979, 0.939340>, 
      <-0.013514, 0.115452, 0.880456>, <-0.013514, 0.117388, 0.893593>, <-0.009836, 0.071983, 0.939317>, <-0.009836, 0.071979, 0.939340>, 
      <-0.031697, 0.111836, 0.880456>, <-0.033113, 0.115257, 0.890904>, <-0.022568, 0.080186, 0.932025>, <-0.022567, 0.080184, 0.932044>, 
      <-0.044182, 0.106664, 0.880456>, <-0.045599, 0.110085, 0.890904>, <-0.031655, 0.076422, 0.932025>, <-0.031654, 0.076420, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.044182, 0.106664, 0.880456>, <0.045599, 0.110085, 0.890904>, <0.031655, 0.076422, 0.932025>, <0.031654, 0.076420, 0.932044>, 
      <0.031697, 0.111836, 0.880456>, <0.033113, 0.115257, 0.890904>, <0.022568, 0.080186, 0.932025>, <0.022567, 0.080184, 0.932044>, 
      <0.013514, 0.115452, 0.880456>, <0.013514, 0.117388, 0.893593>, <0.009836, 0.071983, 0.939317>, <0.009836, 0.071979, 0.939340>, 
      <0.000000, 0.115452, 0.880456>, <0.000000, 0.117388, 0.893593>, <0.000000, 0.071983, 0.939317>, <0.000000, 0.071979, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.081637, 0.081637, 0.880456>, <0.083006, 0.083006, 0.893593>, <0.050900, 0.050900, 0.939317>, <0.050897, 0.050897, 0.939340>, 
      <0.072081, 0.091193, 0.880456>, <0.073450, 0.092562, 0.893593>, <0.043945, 0.057855, 0.939317>, <0.043942, 0.057852, 0.939340>, 
      <0.056667, 0.101492, 0.880456>, <0.058084, 0.104913, 0.890904>, <0.040742, 0.072658, 0.932025>, <0.040741, 0.072656, 0.932044>, 
      <0.044182, 0.106664, 0.880456>, <0.045599, 0.110085, 0.890904>, <0.031655, 0.076422, 0.932025>, <0.031654, 0.076420, 0.932044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.106664, 0.044182, 0.880456>, <0.110085, 0.045599, 0.890904>, <0.076422, 0.031655, 0.932025>, <0.076420, 0.031654, 0.932044>, 
      <0.101492, 0.056667, 0.880456>, <0.104913, 0.058084, 0.890904>, <0.072658, 0.040742, 0.932025>, <0.072656, 0.040741, 0.932044>, 
      <0.091193, 0.072081, 0.880456>, <0.092562, 0.073450, 0.893593>, <0.057855, 0.043945, 0.939317>, <0.057852, 0.043942, 0.939340>, 
      <0.081637, 0.081637, 0.880456>, <0.083006, 0.083006, 0.893593>, <0.050900, 0.050900, 0.939317>, <0.050897, 0.050897, 0.939340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.044194, -0.044194, 0.875000>, <0.055427, -0.055427, 0.876637>, <0.080642, -0.080642, 0.870901>, <0.081637, -0.081637, 0.880456>, 
      <0.049367, -0.039021, 0.875000>, <0.060600, -0.050254, 0.876637>, <0.090198, -0.071086, 0.870901>, <0.091193, -0.072081, 0.880456>, 
      <0.054942, -0.030677, 0.875000>, <0.069619, -0.036756, 0.876637>, <0.098512, -0.055433, 0.871353>, <0.101492, -0.056667, 0.880456>, 
      <0.057742, -0.023918, 0.875000>, <0.072419, -0.029997, 0.876637>, <0.103683, -0.042948, 0.871353>, <0.106664, -0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.023918, -0.057742, 0.875000>, <0.029997, -0.072419, 0.876637>, <0.042948, -0.103683, 0.871353>, <0.044182, -0.106664, 0.880456>, 
      <0.030677, -0.054942, 0.875000>, <0.036756, -0.069619, 0.876637>, <0.055433, -0.098512, 0.871353>, <0.056667, -0.101492, 0.880456>, 
      <0.039021, -0.049367, 0.875000>, <0.050254, -0.060600, 0.876637>, <0.071086, -0.090198, 0.870901>, <0.072081, -0.091193, 0.880456>, 
      <0.044194, -0.044194, 0.875000>, <0.055427, -0.055427, 0.876637>, <0.080642, -0.080642, 0.870901>, <0.081637, -0.081637, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, -0.062500, 0.875000>, <0.000000, -0.078386, 0.876637>, <0.000000, -0.114044, 0.870901>, <0.000000, -0.115452, 0.880456>, 
      <0.007316, -0.062500, 0.875000>, <0.007316, -0.078386, 0.876637>, <0.013514, -0.114044, 0.870901>, <0.013514, -0.115452, 0.880456>, 
      <0.017159, -0.060542, 0.875000>, <0.023238, -0.075218, 0.876637>, <0.030462, -0.108855, 0.871353>, <0.031697, -0.111836, 0.880456>, 
      <0.023918, -0.057742, 0.875000>, <0.029997, -0.072419, 0.876637>, <0.042948, -0.103683, 0.871353>, <0.044182, -0.106664, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.023918, -0.057742, 0.875000>, <-0.029997, -0.072419, 0.876637>, <-0.042948, -0.103683, 0.871353>, <-0.044182, -0.106664, 0.880456>, 
      <-0.017159, -0.060542, 0.875000>, <-0.023238, -0.075218, 0.876637>, <-0.030462, -0.108855, 0.871353>, <-0.031697, -0.111836, 0.880456>, 
      <-0.007316, -0.062500, 0.875000>, <-0.007316, -0.078386, 0.876637>, <-0.013514, -0.114044, 0.870901>, <-0.013514, -0.115452, 0.880456>, 
      <0.000000, -0.062500, 0.875000>, <0.000000, -0.078386, 0.876637>, <0.000000, -0.114044, 0.870901>, <0.000000, -0.115452, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.044194, -0.044194, 0.875000>, <-0.055427, -0.055427, 0.876637>, <-0.080642, -0.080642, 0.870901>, <-0.081637, -0.081637, 0.880456>, 
      <-0.039021, -0.049367, 0.875000>, <-0.050254, -0.060600, 0.876637>, <-0.071086, -0.090198, 0.870901>, <-0.072081, -0.091193, 0.880456>, 
      <-0.030677, -0.054942, 0.875000>, <-0.036756, -0.069619, 0.876637>, <-0.055433, -0.098512, 0.871353>, <-0.056667, -0.101492, 0.880456>, 
      <-0.023918, -0.057742, 0.875000>, <-0.029997, -0.072419, 0.876637>, <-0.042948, -0.103683, 0.871353>, <-0.044182, -0.106664, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.057742, -0.023918, 0.875000>, <-0.072419, -0.029997, 0.876637>, <-0.103683, -0.042948, 0.871353>, <-0.106664, -0.044182, 0.880456>, 
      <-0.054942, -0.030677, 0.875000>, <-0.069619, -0.036756, 0.876637>, <-0.098512, -0.055433, 0.871353>, <-0.101492, -0.056667, 0.880456>, 
      <-0.049367, -0.039021, 0.875000>, <-0.060600, -0.050254, 0.876637>, <-0.090198, -0.071086, 0.870901>, <-0.091193, -0.072081, 0.880456>, 
      <-0.044194, -0.044194, 0.875000>, <-0.055427, -0.055427, 0.876637>, <-0.080642, -0.080642, 0.870901>, <-0.081637, -0.081637, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.062500, 0.000000, 0.875000>, <-0.078386, 0.000000, 0.876637>, <-0.114044, 0.000000, 0.870901>, <-0.115452, 0.000000, 0.880456>, 
      <-0.062500, -0.007316, 0.875000>, <-0.078386, -0.007316, 0.876637>, <-0.114044, -0.013514, 0.870901>, <-0.115452, -0.013514, 0.880456>, 
      <-0.060542, -0.017159, 0.875000>, <-0.075218, -0.023238, 0.876637>, <-0.108855, -0.030462, 0.871353>, <-0.111836, -0.031697, 0.880456>, 
      <-0.057742, -0.023918, 0.875000>, <-0.072419, -0.029997, 0.876637>, <-0.103683, -0.042948, 0.871353>, <-0.106664, -0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.057742, 0.023918, 0.875000>, <-0.072419, 0.029997, 0.876637>, <-0.103683, 0.042948, 0.871353>, <-0.106664, 0.044182, 0.880456>, 
      <-0.060542, 0.017159, 0.875000>, <-0.075218, 0.023238, 0.876637>, <-0.108855, 0.030462, 0.871353>, <-0.111836, 0.031697, 0.880456>, 
      <-0.062500, 0.007316, 0.875000>, <-0.078386, 0.007316, 0.876637>, <-0.114044, 0.013514, 0.870901>, <-0.115452, 0.013514, 0.880456>, 
      <-0.062500, 0.000000, 0.875000>, <-0.078386, 0.000000, 0.876637>, <-0.114044, 0.000000, 0.870901>, <-0.115452, 0.000000, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.044194, 0.044194, 0.875000>, <-0.055427, 0.055427, 0.876637>, <-0.080642, 0.080642, 0.870901>, <-0.081637, 0.081637, 0.880456>, 
      <-0.049367, 0.039021, 0.875000>, <-0.060600, 0.050254, 0.876637>, <-0.090198, 0.071086, 0.870901>, <-0.091193, 0.072081, 0.880456>, 
      <-0.054942, 0.030677, 0.875000>, <-0.069619, 0.036756, 0.876637>, <-0.098512, 0.055433, 0.871353>, <-0.101492, 0.056667, 0.880456>, 
      <-0.057742, 0.023918, 0.875000>, <-0.072419, 0.029997, 0.876637>, <-0.103683, 0.042948, 0.871353>, <-0.106664, 0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.023918, 0.057742, 0.875000>, <-0.029997, 0.072419, 0.876637>, <-0.042948, 0.103683, 0.871353>, <-0.044182, 0.106664, 0.880456>, 
      <-0.030677, 0.054942, 0.875000>, <-0.036756, 0.069619, 0.876637>, <-0.055433, 0.098512, 0.871353>, <-0.056667, 0.101492, 0.880456>, 
      <-0.039021, 0.049367, 0.875000>, <-0.050254, 0.060600, 0.876637>, <-0.071086, 0.090198, 0.870901>, <-0.072081, 0.091193, 0.880456>, 
      <-0.044194, 0.044194, 0.875000>, <-0.055427, 0.055427, 0.876637>, <-0.080642, 0.080642, 0.870901>, <-0.081637, 0.081637, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.000000, 0.062500, 0.875000>, <0.000000, 0.078386, 0.876637>, <0.000000, 0.114044, 0.870901>, <0.000000, 0.115452, 0.880456>, 
      <-0.007316, 0.062500, 0.875000>, <-0.007316, 0.078386, 0.876637>, <-0.013514, 0.114044, 0.870901>, <-0.013514, 0.115452, 0.880456>, 
      <-0.017159, 0.060542, 0.875000>, <-0.023238, 0.075218, 0.876637>, <-0.030462, 0.108855, 0.871353>, <-0.031697, 0.111836, 0.880456>, 
      <-0.023918, 0.057742, 0.875000>, <-0.029997, 0.072419, 0.876637>, <-0.042948, 0.103683, 0.871353>, <-0.044182, 0.106664, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.023918, 0.057742, 0.875000>, <0.029997, 0.072419, 0.876637>, <0.042948, 0.103683, 0.871353>, <0.044182, 0.106664, 0.880456>, 
      <0.017159, 0.060542, 0.875000>, <0.023238, 0.075218, 0.876637>, <0.030462, 0.108855, 0.871353>, <0.031697, 0.111836, 0.880456>, 
      <0.007316, 0.062500, 0.875000>, <0.007316, 0.078386, 0.876637>, <0.013514, 0.114044, 0.870901>, <0.013514, 0.115452, 0.880456>, 
      <0.000000, 0.062500, 0.875000>, <0.000000, 0.078386, 0.876637>, <0.000000, 0.114044, 0.870901>, <0.000000, 0.115452, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.044194, 0.044194, 0.875000>, <0.055427, 0.055427, 0.876637>, <0.080642, 0.080642, 0.870901>, <0.081637, 0.081637, 0.880456>, 
      <0.039021, 0.049367, 0.875000>, <0.050254, 0.060600, 0.876637>, <0.071086, 0.090198, 0.870901>, <0.072081, 0.091193, 0.880456>, 
      <0.030677, 0.054942, 0.875000>, <0.036756, 0.069619, 0.876637>, <0.055433, 0.098512, 0.871353>, <0.056667, 0.101492, 0.880456>, 
      <0.023918, 0.057742, 0.875000>, <0.029997, 0.072419, 0.876637>, <0.042948, 0.103683, 0.871353>, <0.044182, 0.106664, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.057742, 0.023918, 0.875000>, <0.072419, 0.029997, 0.876637>, <0.103683, 0.042948, 0.871353>, <0.106664, 0.044182, 0.880456>, 
      <0.054942, 0.030677, 0.875000>, <0.069619, 0.036756, 0.876637>, <0.098512, 0.055433, 0.871353>, <0.101492, 0.056667, 0.880456>, 
      <0.049367, 0.039021, 0.875000>, <0.060600, 0.050254, 0.876637>, <0.090198, 0.071086, 0.870901>, <0.091193, 0.072081, 0.880456>, 
      <0.044194, 0.044194, 0.875000>, <0.055427, 0.055427, 0.876637>, <0.080642, 0.080642, 0.870901>, <0.081637, 0.081637, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.022511, 0.000000, 1.192078>, <0.009781, 0.000000, 1.304247>, <0.017806, 0.000000, 1.455507>, <0.011229, 0.000000, 1.568204>, 
      <0.022511, 0.003056, 1.192078>, <0.009781, 0.003056, 1.304247>, <0.017806, 0.001314, 1.455507>, <0.011229, 0.001314, 1.568204>, 
      <0.025406, 0.007216, 1.192078>, <0.013641, 0.002343, 1.304285>, <0.017956, 0.006015, 1.455537>, <0.010877, 0.003083, 1.568204>, 
      <0.024236, 0.010039, 1.192078>, <0.012471, 0.005166, 1.304285>, <0.017453, 0.007229, 1.455537>, <0.010374, 0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.022511, 0.000000, 1.192078>, <0.022511, -0.003056, 1.192078>, <0.025406, -0.007216, 1.192078>, <0.024236, -0.010039, 1.192078>, 
      <0.009781, 0.000000, 1.304247>, <0.009781, -0.003056, 1.304247>, <0.013641, -0.002343, 1.304285>, <0.012471, -0.005166, 1.304285>, 
      <0.017806, 0.000000, 1.455507>, <0.017806, -0.001314, 1.455507>, <0.017956, -0.006015, 1.455537>, <0.017453, -0.007229, 1.455537>, 
      <0.011229, 0.000000, 1.568204>, <0.011229, -0.001314, 1.568204>, <0.010877, -0.003083, 1.568204>, <0.010374, -0.004297, 1.568204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.061696, 0.000000, 1.123511>, <0.058091, 0.000000, 1.146927>, <0.025183, 0.000000, 1.168537>, <0.022511, 0.000000, 1.192078>, 
      <0.061696, 0.007222, 1.123511>, <0.058091, 0.007222, 1.146927>, <0.025183, 0.003056, 1.168537>, <0.022511, 0.003056, 1.192078>, 
      <0.059764, 0.016938, 1.123511>, <0.055871, 0.015326, 1.146283>, <0.027818, 0.008215, 1.169067>, <0.025406, 0.007216, 1.192078>, 
      <0.057000, 0.023610, 1.123511>, <0.053108, 0.021998, 1.146283>, <0.026649, 0.011038, 1.169067>, <0.024236, 0.010039, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.061696, 0.000000, 1.123511>, <0.061696, -0.007222, 1.123511>, <0.059764, -0.016938, 1.123511>, <0.057000, -0.023610, 1.123511>, 
      <0.058091, 0.000000, 1.146927>, <0.058091, -0.007222, 1.146927>, <0.055871, -0.015326, 1.146283>, <0.053108, -0.021998, 1.146283>, 
      <0.025183, 0.000000, 1.168537>, <0.025183, -0.003056, 1.168537>, <0.027818, -0.008215, 1.169067>, <0.026649, -0.011038, 1.169067>, 
      <0.022511, 0.000000, 1.192078>, <0.022511, -0.003056, 1.192078>, <0.025406, -0.007216, 1.192078>, <0.024236, -0.010039, 1.192078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.038257, 0.000000, 1.089785>, <0.034146, 0.000000, 1.101400>, <0.063571, 0.000000, 1.111333>, <0.061696, 0.000000, 1.123511>, 
      <0.038257, 0.005451, 1.089785>, <0.034146, 0.005451, 1.101400>, <0.063571, 0.007222, 1.111333>, <0.061696, 0.007222, 1.123511>, 
      <0.042704, 0.011788, 1.096232>, <0.038405, 0.010007, 1.104812>, <0.061404, 0.017617, 1.113913>, <0.059764, 0.016938, 1.123511>, 
      <0.040618, 0.016824, 1.096232>, <0.036319, 0.015043, 1.104812>, <0.058640, 0.024289, 1.113913>, <0.057000, 0.023610, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.038257, 0.000000, 1.089785>, <0.038257, -0.005451, 1.089785>, <0.042704, -0.011788, 1.096232>, <0.040618, -0.016824, 1.096232>, 
      <0.034146, 0.000000, 1.101400>, <0.034146, -0.005451, 1.101400>, <0.038405, -0.010007, 1.104812>, <0.036319, -0.015043, 1.104812>, 
      <0.063571, 0.000000, 1.111333>, <0.063571, -0.007222, 1.111333>, <0.061404, -0.017617, 1.113913>, <0.058640, -0.024289, 1.113913>, 
      <0.061696, 0.000000, 1.123511>, <0.061696, -0.007222, 1.123511>, <0.059764, -0.016938, 1.123511>, <0.057000, -0.023610, 1.123511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.086920, 0.000000, 1.052253>, <0.082888, 0.000000, 1.070243>, <0.044409, 0.000000, 1.072405>, <0.038257, 0.000000, 1.089785>, 
      <0.086920, 0.011583, 1.052253>, <0.082888, 0.011583, 1.070243>, <0.044409, 0.005451, 1.072405>, <0.038257, 0.005451, 1.089785>, 
      <0.096714, 0.027524, 1.053101>, <0.092218, 0.025662, 1.073721>, <0.052036, 0.015653, 1.077609>, <0.042704, 0.011788, 1.096232>, 
      <0.092282, 0.038225, 1.053101>, <0.087786, 0.036362, 1.073721>, <0.049950, 0.020690, 1.077609>, <0.040618, 0.016824, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.086920, 0.000000, 1.052253>, <0.086920, -0.011583, 1.052253>, <0.096714, -0.027524, 1.053101>, <0.092282, -0.038225, 1.053101>, 
      <0.082888, 0.000000, 1.070243>, <0.082888, -0.011583, 1.070243>, <0.092218, -0.025662, 1.073721>, <0.087786, -0.036362, 1.073721>, 
      <0.044409, 0.000000, 1.072405>, <0.044409, -0.005451, 1.072405>, <0.052036, -0.015653, 1.077609>, <0.049950, -0.020690, 1.077609>, 
      <0.038257, 0.000000, 1.089785>, <0.038257, -0.005451, 1.089785>, <0.042704, -0.011788, 1.096232>, <0.040618, -0.016824, 1.096232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.071979, 0.000000, 0.939340>, <0.071979, 0.009836, 0.939340>, <0.080184, 0.022567, 0.932044>, <0.076420, 0.031654, 0.932044>, 
      <0.071983, 0.000000, 0.939317>, <0.071983, 0.009836, 0.939317>, <0.080186, 0.022568, 0.932025>, <0.076422, 0.031655, 0.932025>, 
      <0.117388, 0.000000, 0.893593>, <0.117388, 0.013514, 0.893593>, <0.115257, 0.033113, 0.890904>, <0.110085, 0.045599, 0.890904>, 
      <0.115452, 0.000000, 0.880456>, <0.115452, 0.013514, 0.880456>, <0.111836, 0.031697, 0.880456>, <0.106664, 0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.071979, 0.000000, 0.939340>, <0.071973, 0.000000, 0.939375>, <0.094394, 0.000000, 1.018911>, <0.086920, 0.000000, 1.052253>, 
      <0.071979, 0.009836, 0.939340>, <0.071973, 0.009836, 0.939375>, <0.094394, 0.011583, 1.018911>, <0.086920, 0.011583, 1.052253>, 
      <0.080184, 0.022567, 0.932044>, <0.080181, 0.022565, 0.932082>, <0.104499, 0.030749, 1.017401>, <0.096714, 0.027524, 1.053101>, 
      <0.076420, 0.031654, 0.932044>, <0.076417, 0.031653, 0.932082>, <0.100067, 0.041450, 1.017401>, <0.092282, 0.038225, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.071979, 0.000000, 0.939340>, <0.071979, -0.009836, 0.939340>, <0.080184, -0.022567, 0.932044>, <0.076420, -0.031654, 0.932044>, 
      <0.071973, 0.000000, 0.939375>, <0.071973, -0.009836, 0.939375>, <0.080181, -0.022565, 0.932082>, <0.076417, -0.031653, 0.932082>, 
      <0.094394, 0.000000, 1.018911>, <0.094394, -0.011583, 1.018911>, <0.104499, -0.030749, 1.017401>, <0.100067, -0.041450, 1.017401>, 
      <0.086920, 0.000000, 1.052253>, <0.086920, -0.011583, 1.052253>, <0.096714, -0.027524, 1.053101>, <0.092282, -0.038225, 1.053101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.071979, 0.000000, 0.939340>, <0.071983, 0.000000, 0.939317>, <0.117388, 0.000000, 0.893593>, <0.115452, 0.000000, 0.880456>, 
      <0.071979, -0.009836, 0.939340>, <0.071983, -0.009836, 0.939317>, <0.117388, -0.013514, 0.893593>, <0.115452, -0.013514, 0.880456>, 
      <0.080184, -0.022567, 0.932044>, <0.080186, -0.022568, 0.932025>, <0.115257, -0.033113, 0.890904>, <0.111836, -0.031697, 0.880456>, 
      <0.076420, -0.031654, 0.932044>, <0.076422, -0.031655, 0.932025>, <0.110085, -0.045599, 0.890904>, <0.106664, -0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.062500, 0.000000, 0.875000>, <0.078386, 0.000000, 0.876637>, <0.114044, 0.000000, 0.870901>, <0.115452, 0.000000, 0.880456>, 
      <0.062500, 0.007316, 0.875000>, <0.078386, 0.007316, 0.876637>, <0.114044, 0.013514, 0.870901>, <0.115452, 0.013514, 0.880456>, 
      <0.060542, 0.017159, 0.875000>, <0.075218, 0.023238, 0.876637>, <0.108855, 0.030462, 0.871353>, <0.111836, 0.031697, 0.880456>, 
      <0.057742, 0.023918, 0.875000>, <0.072419, 0.029997, 0.876637>, <0.103683, 0.042948, 0.871353>, <0.106664, 0.044182, 0.880456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.062500, 0.000000, 0.875000>, <0.062500, -0.007316, 0.875000>, <0.060542, -0.017159, 0.875000>, <0.057742, -0.023918, 0.875000>, 
      <0.078386, 0.000000, 0.876637>, <0.078386, -0.007316, 0.876637>, <0.075218, -0.023238, 0.876637>, <0.072419, -0.029997, 0.876637>, 
      <0.114044, 0.000000, 0.870901>, <0.114044, -0.013514, 0.870901>, <0.108855, -0.030462, 0.871353>, <0.103683, -0.042948, 0.871353>, 
      <0.115452, 0.000000, 0.880456>, <0.115452, -0.013514, 0.880456>, <0.111836, -0.031697, 0.880456>, <0.106664, -0.044182, 0.880456>
    }
  }
  material {
    New_Brass
  }
}
#declare Tsu = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.017039, -0.017039, 0.875000>, <0.016316, -0.017762, 0.875000>, <0.014653, -0.017039, 0.875000>, <0.013631, -0.017039, 0.875000>, 
      <0.041557, -0.041557, 0.875000>, <0.040834, -0.042280, 0.875000>, <0.034268, -0.041557, 0.875000>, <0.033246, -0.041557, 0.875000>, 
      <0.075313, -0.075313, 0.885110>, <0.071123, -0.079503, 0.885110>, <0.066349, -0.075529, 0.885017>, <0.060423, -0.075529, 0.885017>, 
      <0.098766, -0.098766, 0.875000>, <0.094576, -0.102956, 0.875000>, <0.084939, -0.098766, 0.875000>, <0.079013, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.017039, -0.013631, 0.875000>, <0.017039, -0.014653, 0.875000>, <0.017762, -0.016316, 0.875000>, <0.017039, -0.017039, 0.875000>, 
      <0.041557, -0.033246, 0.875000>, <0.041557, -0.034268, 0.875000>, <0.042280, -0.040834, 0.875000>, <0.041557, -0.041557, 0.875000>, 
      <0.075529, -0.060423, 0.885017>, <0.075529, -0.066349, 0.885017>, <0.079503, -0.071123, 0.885110>, <0.075313, -0.075313, 0.885110>, 
      <0.098766, -0.079013, 0.875000>, <0.098766, -0.084939, 0.875000>, <0.102956, -0.094576, 0.875000>, <0.098766, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.017039, 0.013631, 0.875000>, <0.017039, 0.005452, 0.875000>, <0.017039, -0.005452, 0.875000>, <0.017039, -0.013631, 0.875000>, 
      <0.041557, 0.033246, 0.875000>, <0.041557, 0.025067, 0.875000>, <0.041557, -0.025067, 0.875000>, <0.041557, -0.033246, 0.875000>, 
      <0.075529, 0.060423, 0.885017>, <0.075529, 0.013015, 0.885017>, <0.075529, -0.013015, 0.885017>, <0.075529, -0.060423, 0.885017>, 
      <0.098766, 0.079013, 0.875000>, <0.098766, 0.031605, 0.875000>, <0.098766, -0.031605, 0.875000>, <0.098766, -0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.017039, 0.017039, 0.875000>, <0.017762, 0.016316, 0.875000>, <0.017039, 0.014653, 0.875000>, <0.017039, 0.013631, 0.875000>, 
      <0.041557, 0.041557, 0.875000>, <0.042280, 0.040834, 0.875000>, <0.041557, 0.034268, 0.875000>, <0.041557, 0.033246, 0.875000>, 
      <0.075313, 0.075313, 0.885110>, <0.079503, 0.071123, 0.885110>, <0.075529, 0.066349, 0.885017>, <0.075529, 0.060423, 0.885017>, 
      <0.098766, 0.098766, 0.875000>, <0.102956, 0.094576, 0.875000>, <0.098766, 0.084939, 0.875000>, <0.098766, 0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.013631, 0.017039, 0.875000>, <0.014653, 0.017039, 0.875000>, <0.016316, 0.017762, 0.875000>, <0.017039, 0.017039, 0.875000>, 
      <0.033246, 0.041557, 0.875000>, <0.034268, 0.041557, 0.875000>, <0.040834, 0.042280, 0.875000>, <0.041557, 0.041557, 0.875000>, 
      <0.060423, 0.075529, 0.885017>, <0.066349, 0.075529, 0.885017>, <0.071123, 0.079503, 0.885110>, <0.075313, 0.075313, 0.885110>, 
      <0.079013, 0.098766, 0.875000>, <0.084939, 0.098766, 0.875000>, <0.094576, 0.102956, 0.875000>, <0.098766, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.013631, 0.017039, 0.875000>, <-0.005452, 0.017039, 0.875000>, <0.005452, 0.017039, 0.875000>, <0.013631, 0.017039, 0.875000>, 
      <-0.033246, 0.041557, 0.875000>, <-0.025067, 0.041557, 0.875000>, <0.025067, 0.041557, 0.875000>, <0.033246, 0.041557, 0.875000>, 
      <-0.060423, 0.075529, 0.885017>, <-0.013015, 0.075529, 0.885017>, <0.013015, 0.075529, 0.885017>, <0.060423, 0.075529, 0.885017>, 
      <-0.079013, 0.098766, 0.875000>, <-0.031605, 0.098766, 0.875000>, <0.031605, 0.098766, 0.875000>, <0.079013, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.017039, 0.017039, 0.875000>, <-0.016316, 0.017762, 0.875000>, <-0.014653, 0.017039, 0.875000>, <-0.013631, 0.017039, 0.875000>, 
      <-0.041557, 0.041557, 0.875000>, <-0.040834, 0.042280, 0.875000>, <-0.034268, 0.041557, 0.875000>, <-0.033246, 0.041557, 0.875000>, 
      <-0.075313, 0.075313, 0.885110>, <-0.071123, 0.079503, 0.885110>, <-0.066349, 0.075529, 0.885017>, <-0.060423, 0.075529, 0.885017>, 
      <-0.098766, 0.098766, 0.875000>, <-0.094576, 0.102956, 0.875000>, <-0.084939, 0.098766, 0.875000>, <-0.079013, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.017039, 0.013631, 0.875000>, <-0.017039, 0.014653, 0.875000>, <-0.017762, 0.016316, 0.875000>, <-0.017039, 0.017039, 0.875000>, 
      <-0.041557, 0.033246, 0.875000>, <-0.041557, 0.034268, 0.875000>, <-0.042280, 0.040834, 0.875000>, <-0.041557, 0.041557, 0.875000>, 
      <-0.075529, 0.060423, 0.885017>, <-0.075529, 0.066349, 0.885017>, <-0.079503, 0.071123, 0.885110>, <-0.075313, 0.075313, 0.885110>, 
      <-0.098766, 0.079013, 0.875000>, <-0.098766, 0.084939, 0.875000>, <-0.102956, 0.094576, 0.875000>, <-0.098766, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.017039, -0.013631, 0.875000>, <-0.017039, -0.005452, 0.875000>, <-0.017039, 0.005452, 0.875000>, <-0.017039, 0.013631, 0.875000>, 
      <-0.041557, -0.033246, 0.875000>, <-0.041557, -0.025067, 0.875000>, <-0.041557, 0.025067, 0.875000>, <-0.041557, 0.033246, 0.875000>, 
      <-0.075529, -0.060423, 0.885017>, <-0.075529, -0.013015, 0.885017>, <-0.075529, 0.013015, 0.885017>, <-0.075529, 0.060423, 0.885017>, 
      <-0.098766, -0.079013, 0.875000>, <-0.098766, -0.031605, 0.875000>, <-0.098766, 0.031605, 0.875000>, <-0.098766, 0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.017039, -0.017039, 0.875000>, <-0.017762, -0.016316, 0.875000>, <-0.017039, -0.014653, 0.875000>, <-0.017039, -0.013631, 0.875000>, 
      <-0.041557, -0.041557, 0.875000>, <-0.042280, -0.040834, 0.875000>, <-0.041557, -0.034268, 0.875000>, <-0.041557, -0.033246, 0.875000>, 
      <-0.075313, -0.075313, 0.885110>, <-0.079503, -0.071123, 0.885110>, <-0.075529, -0.066349, 0.885017>, <-0.075529, -0.060423, 0.885017>, 
      <-0.098766, -0.098766, 0.875000>, <-0.102956, -0.094576, 0.875000>, <-0.098766, -0.084939, 0.875000>, <-0.098766, -0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.013631, -0.017039, 0.875000>, <-0.014653, -0.017039, 0.875000>, <-0.016316, -0.017762, 0.875000>, <-0.017039, -0.017039, 0.875000>, 
      <-0.033246, -0.041557, 0.875000>, <-0.034268, -0.041557, 0.875000>, <-0.040834, -0.042280, 0.875000>, <-0.041557, -0.041557, 0.875000>, 
      <-0.060423, -0.075529, 0.885017>, <-0.066349, -0.075529, 0.885017>, <-0.071123, -0.079503, 0.885110>, <-0.075313, -0.075313, 0.885110>, 
      <-0.079013, -0.098766, 0.875000>, <-0.084939, -0.098766, 0.875000>, <-0.094576, -0.102956, 0.875000>, <-0.098766, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.013631, -0.017039, 0.875000>, <-0.033246, -0.041557, 0.875000>, <-0.060423, -0.075529, 0.885017>, <-0.079013, -0.098766, 0.875000>, 
      <-0.005452, -0.017039, 0.875000>, <-0.025067, -0.041557, 0.875000>, <-0.013015, -0.075529, 0.885017>, <-0.031605, -0.098766, 0.875000>, 
      <0.005452, -0.017039, 0.875000>, <0.025067, -0.041557, 0.875000>, <0.013015, -0.075529, 0.885017>, <0.031605, -0.098766, 0.875000>, 
      <0.013631, -0.017039, 0.875000>, <0.033246, -0.041557, 0.875000>, <0.060423, -0.075529, 0.885017>, <0.079013, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.886985, -0.886985, 0.500000>, <0.649527, -0.649527, 0.608238>, <0.337414, -0.337414, 0.772128>, <0.098766, -0.098766, 0.875000>, 
      <0.849353, -0.924617, 0.500000>, <0.611895, -0.687158, 0.608238>, <0.333224, -0.341604, 0.772128>, <0.094576, -0.102956, 0.875000>, 
      <0.762807, -0.886985, 0.500000>, <0.575145, -0.652407, 0.618806>, <0.276200, -0.337842, 0.771944>, <0.084939, -0.098766, 0.875000>, 
      <0.709588, -0.886985, 0.500000>, <0.521926, -0.652407, 0.618806>, <0.270274, -0.337842, 0.771944>, <0.079013, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.886985, -0.709588, 0.500000>, <0.652407, -0.521926, 0.618806>, <0.337842, -0.270274, 0.771944>, <0.098766, -0.079013, 0.875000>, 
      <0.886985, -0.762807, 0.500000>, <0.652407, -0.575145, 0.618806>, <0.337842, -0.276200, 0.771944>, <0.098766, -0.084939, 0.875000>, 
      <0.924617, -0.849353, 0.500000>, <0.687158, -0.611895, 0.608238>, <0.341604, -0.333224, 0.772128>, <0.102956, -0.094576, 0.875000>, 
      <0.886985, -0.886985, 0.500000>, <0.649527, -0.649527, 0.608238>, <0.337414, -0.337414, 0.772128>, <0.098766, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.886985, 0.709588, 0.500000>, <0.652407, 0.521926, 0.618806>, <0.337842, 0.270274, 0.771944>, <0.098766, 0.079013, 0.875000>, 
      <0.886985, 0.283835, 0.500000>, <0.652407, 0.096173, 0.618806>, <0.337842, 0.222866, 0.771944>, <0.098766, 0.031605, 0.875000>, 
      <0.886985, -0.283835, 0.500000>, <0.652407, -0.096173, 0.618806>, <0.337842, -0.222866, 0.771944>, <0.098766, -0.031605, 0.875000>, 
      <0.886985, -0.709588, 0.500000>, <0.652407, -0.521926, 0.618806>, <0.337842, -0.270274, 0.771944>, <0.098766, -0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.886985, 0.886985, 0.500000>, <0.649527, 0.649527, 0.608238>, <0.337414, 0.337414, 0.772128>, <0.098766, 0.098766, 0.875000>, 
      <0.924617, 0.849353, 0.500000>, <0.687158, 0.611895, 0.608238>, <0.341604, 0.333224, 0.772128>, <0.102956, 0.094576, 0.875000>, 
      <0.886985, 0.762807, 0.500000>, <0.652407, 0.575145, 0.618806>, <0.337842, 0.276200, 0.771944>, <0.098766, 0.084939, 0.875000>, 
      <0.886985, 0.709588, 0.500000>, <0.652407, 0.521926, 0.618806>, <0.337842, 0.270274, 0.771944>, <0.098766, 0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.709588, 0.886985, 0.500000>, <0.521926, 0.652407, 0.618806>, <0.270274, 0.337842, 0.771944>, <0.079013, 0.098766, 0.875000>, 
      <0.762807, 0.886985, 0.500000>, <0.575145, 0.652407, 0.618806>, <0.276200, 0.337842, 0.771944>, <0.084939, 0.098766, 0.875000>, 
      <0.849353, 0.924617, 0.500000>, <0.611895, 0.687158, 0.608238>, <0.333224, 0.341604, 0.772128>, <0.094576, 0.102956, 0.875000>, 
      <0.886985, 0.886985, 0.500000>, <0.649527, 0.649527, 0.608238>, <0.337414, 0.337414, 0.772128>, <0.098766, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.709588, 0.886985, 0.500000>, <-0.521926, 0.652407, 0.618806>, <-0.270274, 0.337842, 0.771944>, <-0.079013, 0.098766, 0.875000>, 
      <-0.283835, 0.886985, 0.500000>, <-0.096173, 0.652407, 0.618806>, <-0.222866, 0.337842, 0.771944>, <-0.031605, 0.098766, 0.875000>, 
      <0.283835, 0.886985, 0.500000>, <0.096173, 0.652407, 0.618806>, <0.222866, 0.337842, 0.771944>, <0.031605, 0.098766, 0.875000>, 
      <0.709588, 0.886985, 0.500000>, <0.521926, 0.652407, 0.618806>, <0.270274, 0.337842, 0.771944>, <0.079013, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.886985, 0.886985, 0.500000>, <-0.649527, 0.649527, 0.608238>, <-0.337414, 0.337414, 0.772128>, <-0.098766, 0.098766, 0.875000>, 
      <-0.849353, 0.924617, 0.500000>, <-0.611895, 0.687158, 0.608238>, <-0.333224, 0.341604, 0.772128>, <-0.094576, 0.102956, 0.875000>, 
      <-0.762807, 0.886985, 0.500000>, <-0.575145, 0.652407, 0.618806>, <-0.276200, 0.337842, 0.771944>, <-0.084939, 0.098766, 0.875000>, 
      <-0.709588, 0.886985, 0.500000>, <-0.521926, 0.652407, 0.618806>, <-0.270274, 0.337842, 0.771944>, <-0.079013, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.886985, 0.709588, 0.500000>, <-0.652407, 0.521926, 0.618806>, <-0.337842, 0.270274, 0.771944>, <-0.098766, 0.079013, 0.875000>, 
      <-0.886985, 0.762807, 0.500000>, <-0.652407, 0.575145, 0.618806>, <-0.337842, 0.276200, 0.771944>, <-0.098766, 0.084939, 0.875000>, 
      <-0.924617, 0.849353, 0.500000>, <-0.687158, 0.611895, 0.608238>, <-0.341604, 0.333224, 0.772128>, <-0.102956, 0.094576, 0.875000>, 
      <-0.886985, 0.886985, 0.500000>, <-0.649527, 0.649527, 0.608238>, <-0.337414, 0.337414, 0.772128>, <-0.098766, 0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.886985, -0.709588, 0.500000>, <-0.652407, -0.521926, 0.618806>, <-0.337842, -0.270274, 0.771944>, <-0.098766, -0.079013, 0.875000>, 
      <-0.886985, -0.283835, 0.500000>, <-0.652407, -0.096173, 0.618806>, <-0.337842, -0.222866, 0.771944>, <-0.098766, -0.031605, 0.875000>, 
      <-0.886985, 0.283835, 0.500000>, <-0.652407, 0.096173, 0.618806>, <-0.337842, 0.222866, 0.771944>, <-0.098766, 0.031605, 0.875000>, 
      <-0.886985, 0.709588, 0.500000>, <-0.652407, 0.521926, 0.618806>, <-0.337842, 0.270274, 0.771944>, <-0.098766, 0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.886985, -0.886985, 0.500000>, <-0.649527, -0.649527, 0.608238>, <-0.337414, -0.337414, 0.772128>, <-0.098766, -0.098766, 0.875000>, 
      <-0.924617, -0.849353, 0.500000>, <-0.687158, -0.611895, 0.608238>, <-0.341604, -0.333224, 0.772128>, <-0.102956, -0.094576, 0.875000>, 
      <-0.886985, -0.762807, 0.500000>, <-0.652407, -0.575145, 0.618806>, <-0.337842, -0.276200, 0.771944>, <-0.098766, -0.084939, 0.875000>, 
      <-0.886985, -0.709588, 0.500000>, <-0.652407, -0.521926, 0.618806>, <-0.337842, -0.270274, 0.771944>, <-0.098766, -0.079013, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.709588, -0.886985, 0.500000>, <-0.521926, -0.652407, 0.618806>, <-0.270274, -0.337842, 0.771944>, <-0.079013, -0.098766, 0.875000>, 
      <-0.762807, -0.886985, 0.500000>, <-0.575145, -0.652407, 0.618806>, <-0.276200, -0.337842, 0.771944>, <-0.084939, -0.098766, 0.875000>, 
      <-0.849353, -0.924617, 0.500000>, <-0.611895, -0.687158, 0.608238>, <-0.333224, -0.341604, 0.772128>, <-0.094576, -0.102956, 0.875000>, 
      <-0.886985, -0.886985, 0.500000>, <-0.649527, -0.649527, 0.608238>, <-0.337414, -0.337414, 0.772128>, <-0.098766, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.709588, -0.886985, 0.500000>, <-0.283835, -0.886985, 0.500000>, <0.283835, -0.886985, 0.500000>, <0.709588, -0.886985, 0.500000>, 
      <-0.521926, -0.652407, 0.618806>, <-0.096173, -0.652407, 0.618806>, <0.096173, -0.652407, 0.618806>, <0.521926, -0.652407, 0.618806>, 
      <-0.270274, -0.337842, 0.771944>, <-0.222866, -0.337842, 0.771944>, <0.222866, -0.337842, 0.771944>, <0.270274, -0.337842, 0.771944>, 
      <-0.079013, -0.098766, 0.875000>, <-0.031605, -0.098766, 0.875000>, <0.031605, -0.098766, 0.875000>, <0.079013, -0.098766, 0.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.332808, -1.332808, 0.312500>, <1.216957, -1.216957, 0.422490>, <1.019793, -1.019793, 0.439464>, <0.886985, -0.886985, 0.500000>, 
      <1.274728, -1.390888, 0.312500>, <1.158878, -1.275037, 0.422490>, <0.982161, -1.057425, 0.439464>, <0.849353, -0.924617, 0.500000>, 
      <1.148356, -1.332808, 0.252139>, <1.054524, -1.215518, 0.363496>, <0.871427, -1.022760, 0.431235>, <0.762807, -0.886985, 0.500000>, 
      <1.066246, -1.332808, 0.250000>, <0.972414, -1.215518, 0.361357>, <0.818208, -1.022760, 0.431235>, <0.709588, -0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.332808, -1.066246, 0.250000>, <1.215518, -0.972414, 0.361357>, <1.022760, -0.818208, 0.431235>, <0.886985, -0.709588, 0.500000>, 
      <1.332808, -1.148356, 0.252139>, <1.215518, -1.054524, 0.363496>, <1.022760, -0.871427, 0.431235>, <0.886985, -0.762807, 0.500000>, 
      <1.390888, -1.274728, 0.312500>, <1.275037, -1.158878, 0.422490>, <1.057425, -0.982161, 0.439464>, <0.924617, -0.849353, 0.500000>, 
      <1.332808, -1.332808, 0.312500>, <1.216957, -1.216957, 0.422490>, <1.019793, -1.019793, 0.439464>, <0.886985, -0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.332808, 1.066246, 0.250000>, <1.215518, 0.972414, 0.361357>, <1.022760, 0.818208, 0.431235>, <0.886985, 0.709588, 0.500000>, 
      <1.332808, 0.426715, 0.233339>, <1.215518, 0.332884, 0.344696>, <1.022760, 0.392455, 0.431235>, <0.886985, 0.283835, 0.500000>, 
      <1.332808, -0.426715, 0.233339>, <1.215518, -0.332884, 0.344696>, <1.022760, -0.392455, 0.431235>, <0.886985, -0.283835, 0.500000>, 
      <1.332808, -1.066246, 0.250000>, <1.215518, -0.972414, 0.361357>, <1.022760, -0.818208, 0.431235>, <0.886985, -0.709588, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.332808, 1.332808, 0.312500>, <1.216957, 1.216957, 0.422490>, <1.019793, 1.019793, 0.439464>, <0.886985, 0.886985, 0.500000>, 
      <1.390888, 1.274728, 0.312500>, <1.275037, 1.158878, 0.422490>, <1.057425, 0.982161, 0.439464>, <0.924617, 0.849353, 0.500000>, 
      <1.332808, 1.148356, 0.252139>, <1.215518, 1.054524, 0.363496>, <1.022760, 0.871427, 0.431235>, <0.886985, 0.762807, 0.500000>, 
      <1.332808, 1.066246, 0.250000>, <1.215518, 0.972414, 0.361357>, <1.022760, 0.818208, 0.431235>, <0.886985, 0.709588, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.066246, 1.332808, 0.250000>, <0.972414, 1.215518, 0.361357>, <0.818208, 1.022760, 0.431235>, <0.709588, 0.886985, 0.500000>, 
      <1.148356, 1.332808, 0.252139>, <1.054524, 1.215518, 0.363496>, <0.871427, 1.022760, 0.431235>, <0.762807, 0.886985, 0.500000>, 
      <1.274728, 1.390888, 0.312500>, <1.158878, 1.275037, 0.422490>, <0.982161, 1.057425, 0.439464>, <0.849353, 0.924617, 0.500000>, 
      <1.332808, 1.332808, 0.312500>, <1.216957, 1.216957, 0.422490>, <1.019793, 1.019793, 0.439464>, <0.886985, 0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.066246, 1.332808, 0.250000>, <-0.972414, 1.215518, 0.361357>, <-0.818208, 1.022760, 0.431235>, <-0.709588, 0.886985, 0.500000>, 
      <-0.426715, 1.332808, 0.233339>, <-0.332884, 1.215518, 0.344696>, <-0.392455, 1.022760, 0.431235>, <-0.283835, 0.886985, 0.500000>, 
      <0.426715, 1.332808, 0.233339>, <0.332884, 1.215518, 0.344696>, <0.392455, 1.022760, 0.431235>, <0.283835, 0.886985, 0.500000>, 
      <1.066246, 1.332808, 0.250000>, <0.972414, 1.215518, 0.361357>, <0.818208, 1.022760, 0.431235>, <0.709588, 0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.332808, 1.332808, 0.312500>, <-1.216957, 1.216957, 0.422490>, <-1.019793, 1.019793, 0.439464>, <-0.886985, 0.886985, 0.500000>, 
      <-1.274728, 1.390888, 0.312500>, <-1.158878, 1.275037, 0.422490>, <-0.982161, 1.057425, 0.439464>, <-0.849353, 0.924617, 0.500000>, 
      <-1.148356, 1.332808, 0.252139>, <-1.054524, 1.215518, 0.363496>, <-0.871427, 1.022760, 0.431235>, <-0.762807, 0.886985, 0.500000>, 
      <-1.066246, 1.332808, 0.250000>, <-0.972414, 1.215518, 0.361357>, <-0.818208, 1.022760, 0.431235>, <-0.709588, 0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.332808, 1.066246, 0.250000>, <-1.215518, 0.972414, 0.361357>, <-1.022760, 0.818208, 0.431235>, <-0.886985, 0.709588, 0.500000>, 
      <-1.332808, 1.148356, 0.252139>, <-1.215518, 1.054524, 0.363496>, <-1.022760, 0.871427, 0.431235>, <-0.886985, 0.762807, 0.500000>, 
      <-1.390888, 1.274728, 0.312500>, <-1.275037, 1.158878, 0.422490>, <-1.057425, 0.982161, 0.439464>, <-0.924617, 0.849353, 0.500000>, 
      <-1.332808, 1.332808, 0.312500>, <-1.216957, 1.216957, 0.422490>, <-1.019793, 1.019793, 0.439464>, <-0.886985, 0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.332808, -1.066246, 0.250000>, <-1.215518, -0.972414, 0.361357>, <-1.022760, -0.818208, 0.431235>, <-0.886985, -0.709588, 0.500000>, 
      <-1.332808, -0.426715, 0.233339>, <-1.215518, -0.332884, 0.344696>, <-1.022760, -0.392455, 0.431235>, <-0.886985, -0.283835, 0.500000>, 
      <-1.332808, 0.426715, 0.233339>, <-1.215518, 0.332884, 0.344696>, <-1.022760, 0.392455, 0.431235>, <-0.886985, 0.283835, 0.500000>, 
      <-1.332808, 1.066246, 0.250000>, <-1.215518, 0.972414, 0.361357>, <-1.022760, 0.818208, 0.431235>, <-0.886985, 0.709588, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.332808, -1.332808, 0.312500>, <-1.216957, -1.216957, 0.422490>, <-1.019793, -1.019793, 0.439464>, <-0.886985, -0.886985, 0.500000>, 
      <-1.390888, -1.274728, 0.312500>, <-1.275037, -1.158878, 0.422490>, <-1.057425, -0.982161, 0.439464>, <-0.924617, -0.849353, 0.500000>, 
      <-1.332808, -1.148356, 0.252139>, <-1.215518, -1.054524, 0.363496>, <-1.022760, -0.871427, 0.431235>, <-0.886985, -0.762807, 0.500000>, 
      <-1.332808, -1.066246, 0.250000>, <-1.215518, -0.972414, 0.361357>, <-1.022760, -0.818208, 0.431235>, <-0.886985, -0.709588, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.066246, -1.332808, 0.250000>, <-0.972414, -1.215518, 0.361357>, <-0.818208, -1.022760, 0.431235>, <-0.709588, -0.886985, 0.500000>, 
      <-1.148356, -1.332808, 0.252139>, <-1.054524, -1.215518, 0.363496>, <-0.871427, -1.022760, 0.431235>, <-0.762807, -0.886985, 0.500000>, 
      <-1.274728, -1.390888, 0.312500>, <-1.158878, -1.275037, 0.422490>, <-0.982161, -1.057425, 0.439464>, <-0.849353, -0.924617, 0.500000>, 
      <-1.332808, -1.332808, 0.312500>, <-1.216957, -1.216957, 0.422490>, <-1.019793, -1.019793, 0.439464>, <-0.886985, -0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.066246, -1.332808, 0.250000>, <-0.426715, -1.332808, 0.233339>, <0.426715, -1.332808, 0.233339>, <1.066246, -1.332808, 0.250000>, 
      <-0.972414, -1.215518, 0.361357>, <-0.332884, -1.215518, 0.344696>, <0.332884, -1.215518, 0.344696>, <0.972414, -1.215518, 0.361357>, 
      <-0.818208, -1.022760, 0.431235>, <-0.392455, -1.022760, 0.431235>, <0.392455, -1.022760, 0.431235>, <0.818208, -1.022760, 0.431235>, 
      <-0.709588, -0.886985, 0.500000>, <-0.283835, -0.886985, 0.500000>, <0.283835, -0.886985, 0.500000>, <0.709588, -0.886985, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.216135, -1.216135, 0.187500>, <1.239397, -1.239397, 0.240171>, <1.369266, -1.369266, 0.277886>, <1.332808, -1.332808, 0.312500>, 
      <1.164538, -1.267731, 0.187500>, <1.187800, -1.290993, 0.240171>, <1.311186, -1.427346, 0.277886>, <1.274728, -1.390888, 0.312500>, 
      <1.045875, -1.216135, 0.187500>, <1.065511, -1.240680, 0.224551>, <1.172738, -1.363287, 0.223202>, <1.148356, -1.332808, 0.252139>, 
      <0.972907, -1.216135, 0.187500>, <0.992543, -1.240680, 0.224551>, <1.090629, -1.363287, 0.221063>, <1.066246, -1.332808, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.216135, -0.972907, 0.187500>, <1.240680, -0.992543, 0.224551>, <1.363287, -1.090629, 0.221063>, <1.332808, -1.066246, 0.250000>, 
      <1.216135, -1.045875, 0.187500>, <1.240680, -1.065511, 0.224551>, <1.363287, -1.172738, 0.223202>, <1.332808, -1.148356, 0.252139>, 
      <1.267731, -1.164538, 0.187500>, <1.290993, -1.187800, 0.240171>, <1.427346, -1.311186, 0.277886>, <1.390888, -1.274728, 0.312500>, 
      <1.216135, -1.216135, 0.187500>, <1.239397, -1.239397, 0.240171>, <1.369266, -1.369266, 0.277886>, <1.332808, -1.332808, 0.312500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.216135, 0.972907, 0.187500>, <1.240680, 0.992543, 0.224551>, <1.363287, 1.090629, 0.221063>, <1.332808, 1.066246, 0.250000>, 
      <1.216135, 0.389163, 0.187500>, <1.240680, 0.408799, 0.224551>, <1.363287, 0.451098, 0.204402>, <1.332808, 0.426715, 0.233339>, 
      <1.216135, -0.389163, 0.187500>, <1.240680, -0.408799, 0.224551>, <1.363287, -0.451098, 0.204402>, <1.332808, -0.426715, 0.233339>, 
      <1.216135, -0.972907, 0.187500>, <1.240680, -0.992543, 0.224551>, <1.363287, -1.090629, 0.221063>, <1.332808, -1.066246, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.216135, 1.216135, 0.187500>, <1.239397, 1.239397, 0.240171>, <1.369266, 1.369266, 0.277886>, <1.332808, 1.332808, 0.312500>, 
      <1.267731, 1.164538, 0.187500>, <1.290993, 1.187800, 0.240171>, <1.427346, 1.311186, 0.277886>, <1.390888, 1.274728, 0.312500>, 
      <1.216135, 1.045875, 0.187500>, <1.240680, 1.065511, 0.224551>, <1.363287, 1.172738, 0.223202>, <1.332808, 1.148356, 0.252139>, 
      <1.216135, 0.972907, 0.187500>, <1.240680, 0.992543, 0.224551>, <1.363287, 1.090629, 0.221063>, <1.332808, 1.066246, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.972907, 1.216135, 0.187500>, <0.992543, 1.240680, 0.224551>, <1.090629, 1.363287, 0.221063>, <1.066246, 1.332808, 0.250000>, 
      <1.045875, 1.216135, 0.187500>, <1.065511, 1.240680, 0.224551>, <1.172738, 1.363287, 0.223202>, <1.148356, 1.332808, 0.252139>, 
      <1.164538, 1.267731, 0.187500>, <1.187800, 1.290993, 0.240171>, <1.311186, 1.427346, 0.277886>, <1.274728, 1.390888, 0.312500>, 
      <1.216135, 1.216135, 0.187500>, <1.239397, 1.239397, 0.240171>, <1.369266, 1.369266, 0.277886>, <1.332808, 1.332808, 0.312500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.972907, 1.216135, 0.187500>, <-0.992543, 1.240680, 0.224551>, <-1.090629, 1.363287, 0.221063>, <-1.066246, 1.332808, 0.250000>, 
      <-0.389163, 1.216135, 0.187500>, <-0.408799, 1.240680, 0.224551>, <-0.451098, 1.363287, 0.204402>, <-0.426715, 1.332808, 0.233339>, 
      <0.389163, 1.216135, 0.187500>, <0.408799, 1.240680, 0.224551>, <0.451098, 1.363287, 0.204402>, <0.426715, 1.332808, 0.233339>, 
      <0.972907, 1.216135, 0.187500>, <0.992543, 1.240680, 0.224551>, <1.090629, 1.363287, 0.221063>, <1.066246, 1.332808, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.216135, 1.216135, 0.187500>, <-1.239397, 1.239397, 0.240171>, <-1.369266, 1.369266, 0.277886>, <-1.332808, 1.332808, 0.312500>, 
      <-1.164538, 1.267731, 0.187500>, <-1.187800, 1.290993, 0.240171>, <-1.311186, 1.427346, 0.277886>, <-1.274728, 1.390888, 0.312500>, 
      <-1.045875, 1.216135, 0.187500>, <-1.065511, 1.240680, 0.224551>, <-1.172738, 1.363287, 0.223202>, <-1.148356, 1.332808, 0.252139>, 
      <-0.972907, 1.216135, 0.187500>, <-0.992543, 1.240680, 0.224551>, <-1.090629, 1.363287, 0.221063>, <-1.066246, 1.332808, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.216135, 0.972907, 0.187500>, <-1.240680, 0.992543, 0.224551>, <-1.363287, 1.090629, 0.221063>, <-1.332808, 1.066246, 0.250000>, 
      <-1.216135, 1.045875, 0.187500>, <-1.240680, 1.065511, 0.224551>, <-1.363287, 1.172738, 0.223202>, <-1.332808, 1.148356, 0.252139>, 
      <-1.267731, 1.164538, 0.187500>, <-1.290993, 1.187800, 0.240171>, <-1.427346, 1.311186, 0.277886>, <-1.390888, 1.274728, 0.312500>, 
      <-1.216135, 1.216135, 0.187500>, <-1.239397, 1.239397, 0.240171>, <-1.369266, 1.369266, 0.277886>, <-1.332808, 1.332808, 0.312500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.216135, -0.972907, 0.187500>, <-1.240680, -0.992543, 0.224551>, <-1.363287, -1.090629, 0.221063>, <-1.332808, -1.066246, 0.250000>, 
      <-1.216135, -0.389163, 0.187500>, <-1.240680, -0.408799, 0.224551>, <-1.363287, -0.451098, 0.204402>, <-1.332808, -0.426715, 0.233339>, 
      <-1.216135, 0.389163, 0.187500>, <-1.240680, 0.408799, 0.224551>, <-1.363287, 0.451098, 0.204402>, <-1.332808, 0.426715, 0.233339>, 
      <-1.216135, 0.972907, 0.187500>, <-1.240680, 0.992543, 0.224551>, <-1.363287, 1.090629, 0.221063>, <-1.332808, 1.066246, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.216135, -1.216135, 0.187500>, <-1.239397, -1.239397, 0.240171>, <-1.369266, -1.369266, 0.277886>, <-1.332808, -1.332808, 0.312500>, 
      <-1.267731, -1.164538, 0.187500>, <-1.290993, -1.187800, 0.240171>, <-1.427346, -1.311186, 0.277886>, <-1.390888, -1.274728, 0.312500>, 
      <-1.216135, -1.045875, 0.187500>, <-1.240680, -1.065511, 0.224551>, <-1.363287, -1.172738, 0.223202>, <-1.332808, -1.148356, 0.252139>, 
      <-1.216135, -0.972907, 0.187500>, <-1.240680, -0.992543, 0.224551>, <-1.363287, -1.090629, 0.221063>, <-1.332808, -1.066246, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.972907, -1.216135, 0.187500>, <-0.992543, -1.240680, 0.224551>, <-1.090629, -1.363287, 0.221063>, <-1.066246, -1.332808, 0.250000>, 
      <-1.045875, -1.216135, 0.187500>, <-1.065511, -1.240680, 0.224551>, <-1.172738, -1.363287, 0.223202>, <-1.148356, -1.332808, 0.252139>, 
      <-1.164538, -1.267731, 0.187500>, <-1.187800, -1.290993, 0.240171>, <-1.311186, -1.427346, 0.277886>, <-1.274728, -1.390888, 0.312500>, 
      <-1.216135, -1.216135, 0.187500>, <-1.239397, -1.239397, 0.240171>, <-1.369266, -1.369266, 0.277886>, <-1.332808, -1.332808, 0.312500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.972907, -1.216135, 0.187500>, <-0.389163, -1.216135, 0.187500>, <0.389163, -1.216135, 0.187500>, <0.972907, -1.216135, 0.187500>, 
      <-0.992543, -1.240680, 0.224551>, <-0.408799, -1.240680, 0.224551>, <0.408799, -1.240680, 0.224551>, <0.992543, -1.240680, 0.224551>, 
      <-1.090629, -1.363287, 0.221063>, <-0.451098, -1.363287, 0.204402>, <0.451098, -1.363287, 0.204402>, <1.090629, -1.363287, 0.221063>, 
      <-1.066246, -1.332808, 0.250000>, <-0.426715, -1.332808, 0.233339>, <0.426715, -1.332808, 0.233339>, <1.066246, -1.332808, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, -1.250000, 0.125000>, <1.239840, -1.239840, 0.143750>, <1.207287, -1.207287, 0.167465>, <1.216135, -1.216135, 0.187500>, 
      <1.196967, -1.303033, 0.125000>, <1.186808, -1.292874, 0.143750>, <1.155690, -1.258883, 0.167465>, <1.164538, -1.267731, 0.187500>, 
      <1.075000, -1.250000, 0.125000>, <1.066872, -1.239840, 0.143750>, <1.036652, -1.204606, 0.170097>, <1.045875, -1.216135, 0.187500>, 
      <1.000000, -1.250000, 0.125000>, <0.991872, -1.239840, 0.143750>, <0.963684, -1.204606, 0.170097>, <0.972907, -1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, -1.000000, 0.125000>, <1.239840, -0.991872, 0.143750>, <1.204606, -0.963684, 0.170097>, <1.216135, -0.972907, 0.187500>, 
      <1.250000, -1.075000, 0.125000>, <1.239840, -1.066872, 0.143750>, <1.204606, -1.036652, 0.170097>, <1.216135, -1.045875, 0.187500>, 
      <1.303033, -1.196967, 0.125000>, <1.292874, -1.186808, 0.143750>, <1.258883, -1.155690, 0.167465>, <1.267731, -1.164538, 0.187500>, 
      <1.250000, -1.250000, 0.125000>, <1.239840, -1.239840, 0.143750>, <1.207287, -1.207287, 0.167465>, <1.216135, -1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, 1.000000, 0.125000>, <1.239840, 0.991872, 0.143750>, <1.204606, 0.963684, 0.170097>, <1.216135, 0.972907, 0.187500>, 
      <1.250000, 0.400000, 0.125000>, <1.239840, 0.391872, 0.143750>, <1.204606, 0.379940, 0.170097>, <1.216135, 0.389163, 0.187500>, 
      <1.250000, -0.400000, 0.125000>, <1.239840, -0.391872, 0.143750>, <1.204606, -0.379940, 0.170097>, <1.216135, -0.389163, 0.187500>, 
      <1.250000, -1.000000, 0.125000>, <1.239840, -0.991872, 0.143750>, <1.204606, -0.963684, 0.170097>, <1.216135, -0.972907, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, 1.250000, 0.125000>, <1.239840, 1.239840, 0.143750>, <1.207287, 1.207287, 0.167465>, <1.216135, 1.216135, 0.187500>, 
      <1.303033, 1.196967, 0.125000>, <1.292874, 1.186808, 0.143750>, <1.258883, 1.155690, 0.167465>, <1.267731, 1.164538, 0.187500>, 
      <1.250000, 1.075000, 0.125000>, <1.239840, 1.066872, 0.143750>, <1.204606, 1.036652, 0.170097>, <1.216135, 1.045875, 0.187500>, 
      <1.250000, 1.000000, 0.125000>, <1.239840, 0.991872, 0.143750>, <1.204606, 0.963684, 0.170097>, <1.216135, 0.972907, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.000000, 1.250000, 0.125000>, <0.991872, 1.239840, 0.143750>, <0.963684, 1.204606, 0.170097>, <0.972907, 1.216135, 0.187500>, 
      <1.075000, 1.250000, 0.125000>, <1.066872, 1.239840, 0.143750>, <1.036652, 1.204606, 0.170097>, <1.045875, 1.216135, 0.187500>, 
      <1.196967, 1.303033, 0.125000>, <1.186808, 1.292874, 0.143750>, <1.155690, 1.258883, 0.167465>, <1.164538, 1.267731, 0.187500>, 
      <1.250000, 1.250000, 0.125000>, <1.239840, 1.239840, 0.143750>, <1.207287, 1.207287, 0.167465>, <1.216135, 1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, 1.250000, 0.125000>, <-0.991872, 1.239840, 0.143750>, <-0.963684, 1.204606, 0.170097>, <-0.972907, 1.216135, 0.187500>, 
      <-0.400000, 1.250000, 0.125000>, <-0.391872, 1.239840, 0.143750>, <-0.379940, 1.204606, 0.170097>, <-0.389163, 1.216135, 0.187500>, 
      <0.400000, 1.250000, 0.125000>, <0.391872, 1.239840, 0.143750>, <0.379940, 1.204606, 0.170097>, <0.389163, 1.216135, 0.187500>, 
      <1.000000, 1.250000, 0.125000>, <0.991872, 1.239840, 0.143750>, <0.963684, 1.204606, 0.170097>, <0.972907, 1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, 1.250000, 0.125000>, <-1.239840, 1.239840, 0.143750>, <-1.207287, 1.207287, 0.167465>, <-1.216135, 1.216135, 0.187500>, 
      <-1.196967, 1.303033, 0.125000>, <-1.186808, 1.292874, 0.143750>, <-1.155690, 1.258883, 0.167465>, <-1.164538, 1.267731, 0.187500>, 
      <-1.075000, 1.250000, 0.125000>, <-1.066872, 1.239840, 0.143750>, <-1.036652, 1.204606, 0.170097>, <-1.045875, 1.216135, 0.187500>, 
      <-1.000000, 1.250000, 0.125000>, <-0.991872, 1.239840, 0.143750>, <-0.963684, 1.204606, 0.170097>, <-0.972907, 1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, 1.000000, 0.125000>, <-1.239840, 0.991872, 0.143750>, <-1.204606, 0.963684, 0.170097>, <-1.216135, 0.972907, 0.187500>, 
      <-1.250000, 1.075000, 0.125000>, <-1.239840, 1.066872, 0.143750>, <-1.204606, 1.036652, 0.170097>, <-1.216135, 1.045875, 0.187500>, 
      <-1.303033, 1.196967, 0.125000>, <-1.292874, 1.186808, 0.143750>, <-1.258883, 1.155690, 0.167465>, <-1.267731, 1.164538, 0.187500>, 
      <-1.250000, 1.250000, 0.125000>, <-1.239840, 1.239840, 0.143750>, <-1.207287, 1.207287, 0.167465>, <-1.216135, 1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, -1.000000, 0.125000>, <-1.239840, -0.991872, 0.143750>, <-1.204606, -0.963684, 0.170097>, <-1.216135, -0.972907, 0.187500>, 
      <-1.250000, -0.400000, 0.125000>, <-1.239840, -0.391872, 0.143750>, <-1.204606, -0.379940, 0.170097>, <-1.216135, -0.389163, 0.187500>, 
      <-1.250000, 0.400000, 0.125000>, <-1.239840, 0.391872, 0.143750>, <-1.204606, 0.379940, 0.170097>, <-1.216135, 0.389163, 0.187500>, 
      <-1.250000, 1.000000, 0.125000>, <-1.239840, 0.991872, 0.143750>, <-1.204606, 0.963684, 0.170097>, <-1.216135, 0.972907, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, -1.250000, 0.125000>, <-1.239840, -1.239840, 0.143750>, <-1.207287, -1.207287, 0.167465>, <-1.216135, -1.216135, 0.187500>, 
      <-1.303033, -1.196967, 0.125000>, <-1.292874, -1.186808, 0.143750>, <-1.258883, -1.155690, 0.167465>, <-1.267731, -1.164538, 0.187500>, 
      <-1.250000, -1.075000, 0.125000>, <-1.239840, -1.066872, 0.143750>, <-1.204606, -1.036652, 0.170097>, <-1.216135, -1.045875, 0.187500>, 
      <-1.250000, -1.000000, 0.125000>, <-1.239840, -0.991872, 0.143750>, <-1.204606, -0.963684, 0.170097>, <-1.216135, -0.972907, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, -1.250000, 0.125000>, <-0.991872, -1.239840, 0.143750>, <-0.963684, -1.204606, 0.170097>, <-0.972907, -1.216135, 0.187500>, 
      <-1.075000, -1.250000, 0.125000>, <-1.066872, -1.239840, 0.143750>, <-1.036652, -1.204606, 0.170097>, <-1.045875, -1.216135, 0.187500>, 
      <-1.196967, -1.303033, 0.125000>, <-1.186808, -1.292874, 0.143750>, <-1.155690, -1.258883, 0.167465>, <-1.164538, -1.267731, 0.187500>, 
      <-1.250000, -1.250000, 0.125000>, <-1.239840, -1.239840, 0.143750>, <-1.207287, -1.207287, 0.167465>, <-1.216135, -1.216135, 0.187500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, -1.250000, 0.125000>, <-0.400000, -1.250000, 0.125000>, <0.400000, -1.250000, 0.125000>, <1.000000, -1.250000, 0.125000>, 
      <-0.991872, -1.239840, 0.143750>, <-0.391872, -1.239840, 0.143750>, <0.391872, -1.239840, 0.143750>, <0.991872, -1.239840, 0.143750>, 
      <-0.963684, -1.204606, 0.170097>, <-0.379940, -1.204606, 0.170097>, <0.379940, -1.204606, 0.170097>, <0.963684, -1.204606, 0.170097>, 
      <-0.972907, -1.216135, 0.187500>, <-0.389163, -1.216135, 0.187500>, <0.389163, -1.216135, 0.187500>, <0.972907, -1.216135, 0.187500>
    }
  }
  material {
    tegole
  }
}
#declare Ssu = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.726176, -0.726176, 0.062500>, <0.695367, -0.756985, 0.062500>, <0.624512, -0.726176, 0.062500>, <0.580941, -0.726176, 0.062500>, 
      <0.834337, -0.834337, 0.062500>, <0.803528, -0.865146, 0.062500>, <0.711040, -0.834337, 0.062500>, <0.667470, -0.834337, 0.062500>, 
      <0.978934, -0.978934, 0.049640>, <0.932829, -1.025039, 0.049640>, <0.848417, -0.979018, 0.049651>, <0.783215, -0.979018, 0.049651>, 
      <1.086712, -1.086712, 0.062500>, <1.040607, -1.132817, 0.062500>, <0.934573, -1.086712, 0.062500>, <0.869370, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.726176, -0.580941, 0.062500>, <0.726176, -0.624512, 0.062500>, <0.756985, -0.695367, 0.062500>, <0.726176, -0.726176, 0.062500>, 
      <0.834337, -0.667470, 0.062500>, <0.834337, -0.711040, 0.062500>, <0.865146, -0.803528, 0.062500>, <0.834337, -0.834337, 0.062500>, 
      <0.979018, -0.783215, 0.049651>, <0.979018, -0.848417, 0.049651>, <1.025039, -0.932829, 0.049640>, <0.978934, -0.978934, 0.049640>, 
      <1.086712, -0.869370, 0.062500>, <1.086712, -0.934573, 0.062500>, <1.132817, -1.040607, 0.062500>, <1.086712, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.726176, 0.580941, 0.062500>, <0.726176, 0.232376, 0.062500>, <0.726176, -0.232376, 0.062500>, <0.726176, -0.580941, 0.062500>, 
      <0.834337, 0.667470, 0.062500>, <0.834337, 0.318905, 0.062500>, <0.834337, -0.318905, 0.062500>, <0.834337, -0.667470, 0.062500>, 
      <0.979018, 0.783215, 0.049651>, <0.979018, 0.261593, 0.049651>, <0.979018, -0.261593, 0.049651>, <0.979018, -0.783215, 0.049651>, 
      <1.086712, 0.869370, 0.062500>, <1.086712, 0.347748, 0.062500>, <1.086712, -0.347748, 0.062500>, <1.086712, -0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.726176, 0.726176, 0.062500>, <0.756985, 0.695367, 0.062500>, <0.726176, 0.624512, 0.062500>, <0.726176, 0.580941, 0.062500>, 
      <0.834337, 0.834337, 0.062500>, <0.865146, 0.803528, 0.062500>, <0.834337, 0.711040, 0.062500>, <0.834337, 0.667470, 0.062500>, 
      <0.978934, 0.978934, 0.049640>, <1.025039, 0.932829, 0.049640>, <0.979018, 0.848417, 0.049651>, <0.979018, 0.783215, 0.049651>, 
      <1.086712, 1.086712, 0.062500>, <1.132817, 1.040607, 0.062500>, <1.086712, 0.934573, 0.062500>, <1.086712, 0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <0.580941, 0.726176, 0.062500>, <0.624512, 0.726176, 0.062500>, <0.695367, 0.756985, 0.062500>, <0.726176, 0.726176, 0.062500>, 
      <0.667470, 0.834337, 0.062500>, <0.711040, 0.834337, 0.062500>, <0.803528, 0.865146, 0.062500>, <0.834337, 0.834337, 0.062500>, 
      <0.783215, 0.979018, 0.049651>, <0.848417, 0.979018, 0.049651>, <0.932829, 1.025039, 0.049640>, <0.978934, 0.978934, 0.049640>, 
      <0.869370, 1.086712, 0.062500>, <0.934573, 1.086712, 0.062500>, <1.040607, 1.132817, 0.062500>, <1.086712, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.580941, 0.726176, 0.062500>, <-0.232376, 0.726176, 0.062500>, <0.232376, 0.726176, 0.062500>, <0.580941, 0.726176, 0.062500>, 
      <-0.667470, 0.834337, 0.062500>, <-0.318905, 0.834337, 0.062500>, <0.318905, 0.834337, 0.062500>, <0.667470, 0.834337, 0.062500>, 
      <-0.783215, 0.979018, 0.049651>, <-0.261593, 0.979018, 0.049651>, <0.261593, 0.979018, 0.049651>, <0.783215, 0.979018, 0.049651>, 
      <-0.869370, 1.086712, 0.062500>, <-0.347748, 1.086712, 0.062500>, <0.347748, 1.086712, 0.062500>, <0.869370, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.726176, 0.726176, 0.062500>, <-0.695367, 0.756985, 0.062500>, <-0.624512, 0.726176, 0.062500>, <-0.580941, 0.726176, 0.062500>, 
      <-0.834337, 0.834337, 0.062500>, <-0.803528, 0.865146, 0.062500>, <-0.711040, 0.834337, 0.062500>, <-0.667470, 0.834337, 0.062500>, 
      <-0.978934, 0.978934, 0.049640>, <-0.932829, 1.025039, 0.049640>, <-0.848417, 0.979018, 0.049651>, <-0.783215, 0.979018, 0.049651>, 
      <-1.086712, 1.086712, 0.062500>, <-1.040607, 1.132817, 0.062500>, <-0.934573, 1.086712, 0.062500>, <-0.869370, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.726176, 0.580941, 0.062500>, <-0.726176, 0.624512, 0.062500>, <-0.756985, 0.695367, 0.062500>, <-0.726176, 0.726176, 0.062500>, 
      <-0.834337, 0.667470, 0.062500>, <-0.834337, 0.711040, 0.062500>, <-0.865146, 0.803528, 0.062500>, <-0.834337, 0.834337, 0.062500>, 
      <-0.979018, 0.783215, 0.049651>, <-0.979018, 0.848417, 0.049651>, <-1.025039, 0.932829, 0.049640>, <-0.978934, 0.978934, 0.049640>, 
      <-1.086712, 0.869370, 0.062500>, <-1.086712, 0.934573, 0.062500>, <-1.132817, 1.040607, 0.062500>, <-1.086712, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.726176, -0.580941, 0.062500>, <-0.726176, -0.232376, 0.062500>, <-0.726176, 0.232376, 0.062500>, <-0.726176, 0.580941, 0.062500>, 
      <-0.834337, -0.667470, 0.062500>, <-0.834337, -0.318905, 0.062500>, <-0.834337, 0.318905, 0.062500>, <-0.834337, 0.667470, 0.062500>, 
      <-0.979018, -0.783215, 0.049651>, <-0.979018, -0.261593, 0.049651>, <-0.979018, 0.261593, 0.049651>, <-0.979018, 0.783215, 0.049651>, 
      <-1.086712, -0.869370, 0.062500>, <-1.086712, -0.347748, 0.062500>, <-1.086712, 0.347748, 0.062500>, <-1.086712, 0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.726176, -0.726176, 0.062500>, <-0.756985, -0.695367, 0.062500>, <-0.726176, -0.624512, 0.062500>, <-0.726176, -0.580941, 0.062500>, 
      <-0.834337, -0.834337, 0.062500>, <-0.865146, -0.803528, 0.062500>, <-0.834337, -0.711040, 0.062500>, <-0.834337, -0.667470, 0.062500>, 
      <-0.978934, -0.978934, 0.049640>, <-1.025039, -0.932829, 0.049640>, <-0.979018, -0.848417, 0.049651>, <-0.979018, -0.783215, 0.049651>, 
      <-1.086712, -1.086712, 0.062500>, <-1.132817, -1.040607, 0.062500>, <-1.086712, -0.934573, 0.062500>, <-1.086712, -0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.580941, -0.726176, 0.062500>, <-0.624512, -0.726176, 0.062500>, <-0.695367, -0.756985, 0.062500>, <-0.726176, -0.726176, 0.062500>, 
      <-0.667470, -0.834337, 0.062500>, <-0.711040, -0.834337, 0.062500>, <-0.803528, -0.865146, 0.062500>, <-0.834337, -0.834337, 0.062500>, 
      <-0.783215, -0.979018, 0.049651>, <-0.848417, -0.979018, 0.049651>, <-0.932829, -1.025039, 0.049640>, <-0.978934, -0.978934, 0.049640>, 
      <-0.869370, -1.086712, 0.062500>, <-0.934573, -1.086712, 0.062500>, <-1.040607, -1.132817, 0.062500>, <-1.086712, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-0.580941, -0.726176, 0.062500>, <-0.667470, -0.834337, 0.062500>, <-0.783215, -0.979018, 0.049651>, <-0.869370, -1.086712, 0.062500>, 
      <-0.232376, -0.726176, 0.062500>, <-0.318905, -0.834337, 0.062500>, <-0.261593, -0.979018, 0.049651>, <-0.347748, -1.086712, 0.062500>, 
      <0.232376, -0.726176, 0.062500>, <0.318905, -0.834337, 0.062500>, <0.261593, -0.979018, 0.049651>, <0.347748, -1.086712, 0.062500>, 
      <0.580941, -0.726176, 0.062500>, <0.667470, -0.834337, 0.062500>, <0.783215, -0.979018, 0.049651>, <0.869370, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, -1.250000, 0.125000>, <1.201014, -1.201014, 0.106250>, <1.137281, -1.137281, 0.068534>, <1.086712, -1.086712, 0.062500>, 
      <1.196967, -1.303033, 0.125000>, <1.147981, -1.254047, 0.106250>, <1.091176, -1.183386, 0.068534>, <1.040607, -1.132817, 0.062500>, 
      <1.075000, -1.250000, 0.125000>, <1.035811, -1.201014, 0.106250>, <0.975298, -1.137619, 0.068574>, <0.934573, -1.086712, 0.062500>, 
      <1.000000, -1.250000, 0.125000>, <0.960811, -1.201014, 0.106250>, <0.910096, -1.137619, 0.068574>, <0.869370, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, -1.000000, 0.125000>, <1.201014, -0.960811, 0.106250>, <1.137619, -0.910096, 0.068574>, <1.086712, -0.869370, 0.062500>, 
      <1.250000, -1.075000, 0.125000>, <1.201014, -1.035811, 0.106250>, <1.137619, -0.975298, 0.068574>, <1.086712, -0.934573, 0.062500>, 
      <1.303033, -1.196967, 0.125000>, <1.254047, -1.147981, 0.106250>, <1.183386, -1.091176, 0.068534>, <1.132817, -1.040607, 0.062500>, 
      <1.250000, -1.250000, 0.125000>, <1.201014, -1.201014, 0.106250>, <1.137281, -1.137281, 0.068534>, <1.086712, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, 1.000000, 0.125000>, <1.201014, 0.960811, 0.106250>, <1.137619, 0.910096, 0.068574>, <1.086712, 0.869370, 0.062500>, 
      <1.250000, 0.400000, 0.125000>, <1.201014, 0.360811, 0.106250>, <1.137619, 0.388474, 0.068574>, <1.086712, 0.347748, 0.062500>, 
      <1.250000, -0.400000, 0.125000>, <1.201014, -0.360811, 0.106250>, <1.137619, -0.388474, 0.068574>, <1.086712, -0.347748, 0.062500>, 
      <1.250000, -1.000000, 0.125000>, <1.201014, -0.960811, 0.106250>, <1.137619, -0.910096, 0.068574>, <1.086712, -0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.250000, 1.250000, 0.125000>, <1.201014, 1.201014, 0.106250>, <1.137281, 1.137281, 0.068534>, <1.086712, 1.086712, 0.062500>, 
      <1.303033, 1.196967, 0.125000>, <1.254047, 1.147981, 0.106250>, <1.183386, 1.091176, 0.068534>, <1.132817, 1.040607, 0.062500>, 
      <1.250000, 1.075000, 0.125000>, <1.201014, 1.035811, 0.106250>, <1.137619, 0.975298, 0.068574>, <1.086712, 0.934573, 0.062500>, 
      <1.250000, 1.000000, 0.125000>, <1.201014, 0.960811, 0.106250>, <1.137619, 0.910096, 0.068574>, <1.086712, 0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <1.000000, 1.250000, 0.125000>, <0.960811, 1.201014, 0.106250>, <0.910096, 1.137619, 0.068574>, <0.869370, 1.086712, 0.062500>, 
      <1.075000, 1.250000, 0.125000>, <1.035811, 1.201014, 0.106250>, <0.975298, 1.137619, 0.068574>, <0.934573, 1.086712, 0.062500>, 
      <1.196967, 1.303033, 0.125000>, <1.147981, 1.254047, 0.106250>, <1.091176, 1.183386, 0.068534>, <1.040607, 1.132817, 0.062500>, 
      <1.250000, 1.250000, 0.125000>, <1.201014, 1.201014, 0.106250>, <1.137281, 1.137281, 0.068534>, <1.086712, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, 1.250000, 0.125000>, <-0.960811, 1.201014, 0.106250>, <-0.910096, 1.137619, 0.068574>, <-0.869370, 1.086712, 0.062500>, 
      <-0.400000, 1.250000, 0.125000>, <-0.360811, 1.201014, 0.106250>, <-0.388474, 1.137619, 0.068574>, <-0.347748, 1.086712, 0.062500>, 
      <0.400000, 1.250000, 0.125000>, <0.360811, 1.201014, 0.106250>, <0.388474, 1.137619, 0.068574>, <0.347748, 1.086712, 0.062500>, 
      <1.000000, 1.250000, 0.125000>, <0.960811, 1.201014, 0.106250>, <0.910096, 1.137619, 0.068574>, <0.869370, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, 1.250000, 0.125000>, <-1.201014, 1.201014, 0.106250>, <-1.137281, 1.137281, 0.068534>, <-1.086712, 1.086712, 0.062500>, 
      <-1.196967, 1.303033, 0.125000>, <-1.147981, 1.254047, 0.106250>, <-1.091176, 1.183386, 0.068534>, <-1.040607, 1.132817, 0.062500>, 
      <-1.075000, 1.250000, 0.125000>, <-1.035811, 1.201014, 0.106250>, <-0.975298, 1.137619, 0.068574>, <-0.934573, 1.086712, 0.062500>, 
      <-1.000000, 1.250000, 0.125000>, <-0.960811, 1.201014, 0.106250>, <-0.910096, 1.137619, 0.068574>, <-0.869370, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, 1.000000, 0.125000>, <-1.201014, 0.960811, 0.106250>, <-1.137619, 0.910096, 0.068574>, <-1.086712, 0.869370, 0.062500>, 
      <-1.250000, 1.075000, 0.125000>, <-1.201014, 1.035811, 0.106250>, <-1.137619, 0.975298, 0.068574>, <-1.086712, 0.934573, 0.062500>, 
      <-1.303033, 1.196967, 0.125000>, <-1.254047, 1.147981, 0.106250>, <-1.183386, 1.091176, 0.068534>, <-1.132817, 1.040607, 0.062500>, 
      <-1.250000, 1.250000, 0.125000>, <-1.201014, 1.201014, 0.106250>, <-1.137281, 1.137281, 0.068534>, <-1.086712, 1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, -1.000000, 0.125000>, <-1.201014, -0.960811, 0.106250>, <-1.137619, -0.910096, 0.068574>, <-1.086712, -0.869370, 0.062500>, 
      <-1.250000, -0.400000, 0.125000>, <-1.201014, -0.360811, 0.106250>, <-1.137619, -0.388474, 0.068574>, <-1.086712, -0.347748, 0.062500>, 
      <-1.250000, 0.400000, 0.125000>, <-1.201014, 0.360811, 0.106250>, <-1.137619, 0.388474, 0.068574>, <-1.086712, 0.347748, 0.062500>, 
      <-1.250000, 1.000000, 0.125000>, <-1.201014, 0.960811, 0.106250>, <-1.137619, 0.910096, 0.068574>, <-1.086712, 0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.250000, -1.250000, 0.125000>, <-1.201014, -1.201014, 0.106250>, <-1.137281, -1.137281, 0.068534>, <-1.086712, -1.086712, 0.062500>, 
      <-1.303033, -1.196967, 0.125000>, <-1.254047, -1.147981, 0.106250>, <-1.183386, -1.091176, 0.068534>, <-1.132817, -1.040607, 0.062500>, 
      <-1.250000, -1.075000, 0.125000>, <-1.201014, -1.035811, 0.106250>, <-1.137619, -0.975298, 0.068574>, <-1.086712, -0.934573, 0.062500>, 
      <-1.250000, -1.000000, 0.125000>, <-1.201014, -0.960811, 0.106250>, <-1.137619, -0.910096, 0.068574>, <-1.086712, -0.869370, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, -1.250000, 0.125000>, <-0.960811, -1.201014, 0.106250>, <-0.910096, -1.137619, 0.068574>, <-0.869370, -1.086712, 0.062500>, 
      <-1.075000, -1.250000, 0.125000>, <-1.035811, -1.201014, 0.106250>, <-0.975298, -1.137619, 0.068574>, <-0.934573, -1.086712, 0.062500>, 
      <-1.196967, -1.303033, 0.125000>, <-1.147981, -1.254047, 0.106250>, <-1.091176, -1.183386, 0.068534>, <-1.040607, -1.132817, 0.062500>, 
      <-1.250000, -1.250000, 0.125000>, <-1.201014, -1.201014, 0.106250>, <-1.137281, -1.137281, 0.068534>, <-1.086712, -1.086712, 0.062500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 2 v_steps 2,
      <-1.000000, -1.250000, 0.125000>, <-0.400000, -1.250000, 0.125000>, <0.400000, -1.250000, 0.125000>, <1.000000, -1.250000, 0.125000>, 
      <-0.960811, -1.201014, 0.106250>, <-0.360811, -1.201014, 0.106250>, <0.360811, -1.201014, 0.106250>, <0.960811, -1.201014, 0.106250>, 
      <-0.910096, -1.137619, 0.068574>, <-0.388474, -1.137619, 0.068574>, <0.388474, -1.137619, 0.068574>, <0.910096, -1.137619, 0.068574>, 
      <-0.869370, -1.086712, 0.062500>, <-0.347748, -1.086712, 0.062500>, <0.347748, -1.086712, 0.062500>, <0.869370, -1.086712, 0.062500>
    }
  }
  material {
    sotto
  }
}
#declare Tsopra = union {
  object { punta }
  object { Tsu }
  object { Ssu }
  translate  0.693066*z
}
#declare Rncube = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <1.25, -1.25, -2.21>
}
#declare RndCube005 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <-1.25, -1.25, -2.21>
}
#declare RndCube006 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <1.25, 1.25, -2.21>
}
#declare RndCube007 = merge {
  sphere { <0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, 0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, 0.9875>, 0.0125 }
  sphere { <0.0125, 0.0125, -0.9875>, 0.0125 }
  sphere { <0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, -0.0125, -0.9875>, 0.0125 }
  sphere { <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, -0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, -0.0125, -0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, -0.0125, -0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, 0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, 0.9875>, <0.0125, -0.0125, 0.9875>, 0.0125 }
  cylinder { <0.0125, 0.0125, -0.9875>, <0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, -0.9875>, <-0.0125, -0.0125, -0.9875>, 0.0125 }
  cylinder { <-0.0125, 0.0125, 0.9875>, <-0.0125, -0.0125, 0.9875>, 0.0125 }
  box { <-0.0125, -0.0125, -1.0000> <0.0125, 0.0125, 1.0000> }
  box { <-0.0125, -0.0250, -0.9875> <0.0125, 0.0250, 0.9875> }
  box { <-0.0250, -0.0125, -0.9875> <0.0250, 0.0125, 0.9875> }
  material {
    T_Wood8_1
  }
  translate  <-1.25, 1.25, -2.21>
}
#declare Vertsu = union {
  object { Rncube }
  object { RndCube005 }
  object { RndCube006 }
  object { RndCube007 }
  scale 0.75
  translate  1.662302*z
}
#declare solsu1 = merge {
  sphere { <1.2750, 1.2750, 0.0250>, 0.0250 }
  sphere { <1.2750, -1.2750, 0.0250>, 0.0250 }
  sphere { <-1.2750, -1.2750, 0.0250>, 0.0250 }
  sphere { <-1.2750, 1.2750, 0.0250>, 0.0250 }
  sphere { <1.2750, 1.2750, -0.0250>, 0.0250 }
  sphere { <1.2750, -1.2750, -0.0250>, 0.0250 }
  sphere { <-1.2750, -1.2750, -0.0250>, 0.0250 }
  sphere { <-1.2750, 1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0250>, <-1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, 0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0250>, <-1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <-1.2750, 1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0250>, <1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <-1.2750, -1.2750, -0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0250>, <-1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0250>, <1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0250>, <-1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, 0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  box { <-1.2750, -1.2750, -0.0500> <1.2750, 1.2750, 0.0500> }
  box { <-1.2750, -1.3000, -0.0250> <1.2750, 1.3000, 0.0250> }
  box { <-1.3000, -1.2750, -0.0250> <1.3000, 1.2750, 0.0250> }
  material {
    legno1
    scale <0.25, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  scale <0.75, 0.75, 1.0>
  translate  0.700235*z
}
#declare solgiu1 = merge {
  sphere { <1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, 1.2750, -0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  box { <-1.2750, -1.2750, -0.0750> <1.2750, 1.2750, 0.0750> }
  box { <-1.2750, -1.3000, -0.0500> <1.2750, 1.3000, 0.0500> }
  box { <-1.3000, -1.2750, -0.0500> <1.3000, 1.2750, 0.0500> }
  material {
    legno1
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  translate  -1.287308*z
}
#declare solsu = merge {
  sphere { <1.2750, 1.2750, 0.0250>, 0.0250 }
  sphere { <1.2750, -1.2750, 0.0250>, 0.0250 }
  sphere { <-1.2750, -1.2750, 0.0250>, 0.0250 }
  sphere { <-1.2750, 1.2750, 0.0250>, 0.0250 }
  sphere { <1.2750, 1.2750, -0.0250>, 0.0250 }
  sphere { <1.2750, -1.2750, -0.0250>, 0.0250 }
  sphere { <-1.2750, -1.2750, -0.0250>, 0.0250 }
  sphere { <-1.2750, 1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0250>, <-1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, 0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0250>, <-1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <-1.2750, 1.2750, -0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0250>, <1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <-1.2750, -1.2750, -0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0250>, <-1.2750, 1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0250>, <1.2750, -1.2750, 0.0250>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0250>, <1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0250>, <-1.2750, -1.2750, -0.0250>, 0.0250 }
  cylinder { <-1.2750, 1.2750, 0.0250>, <-1.2750, -1.2750, 0.0250>, 0.0250 }
  box { <-1.2750, -1.2750, -0.0500> <1.2750, 1.2750, 0.0500> }
  box { <-1.2750, -1.3000, -0.0250> <1.2750, 1.3000, 0.0250> }
  box { <-1.3000, -1.2750, -0.0250> <1.3000, 1.2750, 0.0250> }
  material {
    legno1
    scale <0.25, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  scale <0.75, 0.75, 1.0>
  translate  0.515706*z
}
#declare solgiu = merge {
  sphere { <1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, 1.2750, -0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  box { <-1.2750, -1.2750, -0.0750> <1.2750, 1.2750, 0.0750> }
  box { <-1.2750, -1.3000, -0.0500> <1.2750, 1.3000, 0.0500> }
  box { <-1.3000, -1.2750, -0.0500> <1.3000, 1.2750, 0.0500> }
  material {
    legno1
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  translate  -1.504791*z
}
#declare solgiu2 = merge {
  sphere { <1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, 0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, 0.0500>, 0.0250 }
  sphere { <1.2750, 1.2750, -0.0500>, 0.0250 }
  sphere { <1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, -1.2750, -0.0500>, 0.0250 }
  sphere { <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, -0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, -1.2750, -0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, -1.2750, -0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, 1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, 0.0500>, <1.2750, -1.2750, 0.0500>, 0.0250 }
  cylinder { <1.2750, 1.2750, -0.0500>, <1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, -0.0500>, <-1.2750, -1.2750, -0.0500>, 0.0250 }
  cylinder { <-1.2750, 1.2750, 0.0500>, <-1.2750, -1.2750, 0.0500>, 0.0250 }
  box { <-1.2750, -1.2750, -0.0750> <1.2750, 1.2750, 0.0750> }
  box { <-1.2750, -1.3000, -0.0500> <1.2750, 1.3000, 0.0500> }
  box { <-1.3000, -1.2750, -0.0500> <1.3000, 1.2750, 0.0500> }
  material {
    legno1
    scale <0.1, 1.0, 1.0>
    rotate <-45.0, -80.0, -10.0>
  }
  translate  -3.221891*z
}
#declare sal = merge {
  sphere { <1.1750, 0.3750, 0.0000>, 0.0250 }
  sphere { <1.1750, -0.3750, 0.0000>, 0.0250 }
  sphere { <-1.1750, -0.3750, 0.0000>, 0.0250 }
  sphere { <-1.1750, 0.3750, 0.0000>, 0.0250 }
  cylinder { <1.1750, 0.3750, 0.0000>, <-1.1750, 0.3750, 0.0000>, 0.0250 }
  cylinder { <1.1750, -0.3750, 0.0000>, <-1.1750, -0.3750, 0.0000>, 0.0250 }
  cylinder { <1.1750, 0.3750, 0.0000>, <1.1750, -0.3750, 0.0000>, 0.0250 }
  cylinder { <-1.1750, 0.3750, 0.0000>, <-1.1750, -0.3750, 0.0000>, 0.0250 }
  box { <-1.1750, -0.3750, -0.0250> <1.1750, 0.3750, 0.0250> }
  material {
    T_Wood8_1_1
    scale <0.2, 1.0, 1.0>
    rotate -90.0*y
  }
  translate  <0.0, -1.7, 0.34>
}
#declare scal = union {
  object { sal }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      legno2
    }
    scale <0.05, 0.05, 0.2>
    translate  <-1.128548, -2.0, 0.119337>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      legno2
    }
    scale <0.05, 0.05, 0.2>
    translate  <1.11856, -2.0, 0.119337>
  }
  translate  <0.0, 0.038688, -3.427417>
}
#declare lanterna = union {
  superellipsoid { // SuperQ001
    <0.1, 1.2>
    material {
      lanternat
    }
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      legno3
    }
    scale <0.05, 0.05, 8.0>
    translate  1.418496*z
  }
  scale 0.1
  translate  <-0.8, -1.6, -2.100241>
}
#declare lanterna1 = union {
  superellipsoid { // SuperQ002
    <0.1, 1.2>
    material {
      lanternat
    }
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      legno3
    }
    scale <0.05, 0.05, 8.0>
    translate  1.418496*z
  }
  scale 0.1
  translate  <0.8, -1.6, -2.100241>
}
union { // Pagoda
  object { asu }
  object { agiu }
  object { staccion }
  object { Vertgiu }
  object { Tsotto }
  object { Tsopra }
  object { Vertsu }
  object { solsu1 }
  object { solgiu1 }
  object { solsu }
  object { solgiu }
  object { solgiu2 }
  object { scal }
  object { lanterna }
  object { lanterna1 }
  translate  <0.0, 0.309602, 3.450962>
  rotate 5*z
}




#include "C:\PROGRAMMI\MORAY FOR WINDOWS\Udo\isoground.inc"

object {
  isoground
  material {
    prato
  }
  no_shadow
}


#include "C:\PROGRAMMI\MORAY FOR WINDOWS\POVScn\birdn_p.inc"

object {
  P_bird2
  scale 0.002
  rotate <-6.981325, -26.101364, -138.150543>
  translate  <1.656836, -1.757302, 0.846986>
}


