// Persistence Of Vision Ray Tracer Scene Description File
// File: candles.pov
// Vers: 3.5
// Desc: Three candles on a wooden table
// Date: 14 October 2001
// Auth: Jonathan Rafael Ghiglia
// Feel free to use this code. 

// Please notice that these macros are not so *customizable* (sp?). They just helped me to model the candles.
// If you change some params you can get unexpected results.
// I modelled the candles using a technique I saw first in a scene by Jaime Vives Piqueres  

//----SWITCHES

#declare AREA_LIGHT = 1;
#declare TEST_TEXTURE = 0; //-----for testing candles' shape
    
#macro goccia (num,lung,r1,r2,Rad,Ang,Alt,Seed)
#local A=seed(Seed);  
#local i=0;
#while (i<num)
sphere {-y*lung/num*i, ((r2-r1)/lung*(lung/num*i)+r1)*(0.95+0.1*rand(A)),1
        translate <Rad,Alt,0> rotate Ang*y}
#local i=i+1;
#end
#end


#macro cand (alt,_r,num_goc,num_goccini,Seed)
#local I=seed(Seed);
union {
difference {
        blob {
        threshold 0.5
        cylinder {0, alt*y,_r*2,1}
        #local j=0;
        #while (j<num_goc)
        goccia (num_goccini,alt/3+alt/3*rand(I),_r/6+_r/6*rand(I),_r/3+_r/4*rand(I),_r,360/num_goc*j+rand(I)*25,alt,Seed)
        #local j=j+1;
        #end
        sturm}
        sphere {(alt+_r)*y+_r/2*rand(I)*x,_r*3/2 rotate rand(I)*360*y}
}
cylinder {(alt-_r)*y,(alt+2+rand(I))*y,0.07
        pigment {rgb 0.4}} 
//--fiamma    The flames only use emission media in this scene.
// If you want to use these candles with brighter backgrounds you have to play with absorption media as well.
blob {
threshold 0.5
#local f=0;
#while (f<15)
 sphere {<sin((0.5*f/14)*2)*0.5,0.3+0.5*f/14,sin((0.5*f/14)*2)*0.5>,(0.4-0.2*f/15) strength 1                
 }
 #local f=f+1;
 #end
hollow   
pigment {rgbt 1}
interior {
    media {
        method 3
        emission 1//rgb <1,.7,.25> 
        density {
            gradient y
            color_map {
                [0 rgb <.2,.3,.8>*0.8]
                [.3 rgb <1,.7,.25>]
            }
            scale 2}
        
        density {
            spherical color_map {
                [0.45 rgb 1]
                [.5 rgb 0]}
            scale 1.5/4
            translate 0.3*y}
        
    }
}
rotate rand(I)*360*y                                        
scale <_r,2.5*_r,_r>*2
translate (alt+1)*y
no_shadow}
  

light_source {
        <0,alt+1+2*_r,0>
        rgb <.333,.25,.166>
        //rgb <1,.75,.5>
        fade_distance 50
        fade_power 2//3  
#if (AREA_LIGHT) area_light 1.5*x,1.5*y,3,3 adaptive 0 jitter orient circular #end
        media_attenuation on
}

//-------glow
box {-1,1
    hollow
    no_shadow
    pigment {rgbt 1}
    interior {
        media {
            method 3
            emission 0.035
            density {
                spherical
                color_map {
                    [0 rgb 0]
                    [1 rgb <1,.7,.35>]
                }
                turbulence 0.1
                poly_wave 2
            }
        }
    } 
    translate y/2
    scale <_r,_r,_r>*9
    translate alt*y}
  
}

#end   


#declare pa=array[14]
#declare pa[0]=<-10,0>;
#declare pa[1]=<0,0>;
#declare pa[2]=<4,1>;
#declare pa[3]=<6,7>;
#declare pa[4]=<2,10>;
#declare pa[5]=<2,15>;
#declare pa[6]=<2,16.5>; 
#declare pa[7]=<1.5,17>;
#declare pa[8]=<1.5,15>;
#declare pa[9]=<1.5,10>;
#declare pa[10]=<5.5,7>;
#declare pa[11]=<3.5,1>;
#declare pa[12]=<0,0.7>;
#declare pa[13]=<-5,1>;
            
#declare porta_candela=
lathe {
        cubic_spline 
        14,
        #local sp=0;
        #while (sp<14)
        pa[sp]
        #local sp=sp+1;
        #end
        sturm
        photons {target reflection on refraction off collect off}
} 

#declare holder_metal= 
texture {
            pigment {rgb <1,.95,.9>}// rgb <1,.9,.8>
        finish {diffuse .4 specular 1.2 roughness 0.02 reflection {.5 metallic} brilliance 4 metallic}
        normal {granite -0.3 cubic_wave scale 5}
}

#macro wax (Color)
material {
    texture {
        pigment {
            Color transmit 0.6}
        finish {diffuse 0.65 specular 0.35 roughness 0.02}
    }
    interior {ior 1.1 
        media {
            method 3 intervals 1 samples 20
            scattering {1, Color*0.8 extinction 1}
        }
    }
}
#end   

#macro tex()
texture {pigment {Wheat} finish {diffuse 0.65 specular 0.35 roughness 0.02}}
#end

       
