// revised texture definitions  


// normals   

#declare Crackly_Normal = normal {crackle .2 poly_wave .5 scale .035 turbulence .2}

#declare Spotty_Normal = normal {leopard .4 poly_wave 1.5 scale .025 turbulence .2}  

#declare Spot_Crac_Normal =
normal {
	average
	normal_map {
		[1 Crackly_Normal]
		[2 Spotty_Normal]
	}
}


// textures

// primary textures set 1

#declare Glossy_Green1 =
texture {
	pigment { rgb <.3,.6,.35>}
	finish {phong .85 phong_size 7}
	normal {Crackly_Normal}
} 

#declare Spotty_Red1 = 
texture {
	pigment {
	leopard
	color_map {
		[0.0 rgb <.3,.6,.35>]
		[0.5 rgb <.6,.6,.25>]
		[0.75 rgb <.6,.4,.2>]
		[0.9 rgb <.7,.3,.1>]
	} 
	scale .025
	turbulence .2
	}
	finish {phong .5 phong_size 10}
	normal {Spot_Crac_Normal}
}   

#declare Spotty_Gold1 = 
texture {
	pigment {
	leopard
	color_map {
		[0.0 rgb <.9,.9,.15>]
		[0.5 rgb <.8,.6,.05>]
		[0.75 rgb <.8,.4,.1>]
		[0.9 rgb <.9,.3,.05>]
	} 
	scale .025  
	turbulence .2
	}
	finish {phong .5 phong_size 15}
	normal {Spotty_Normal}
}

// primary textures set 2

#declare Golden_Veins1 =
texture {
	pigment {
	crackle
	poly_wave
	color_map {
		[0.0 rgb <.8,1,.8>] 
		[0.1 rgb <.6,.9,.55>] 
		[0.15 rgb <.5,.7,.23>] 
		[1.0 rgb <.3,.6,.25>]
	}
	turbulence .25 
	scale .025
	}
	finish {phong .2}
	normal {crackle .4 poly_wave turbulence .25 scale .002}
}   
           

#declare Golden_Veins2 =
texture {
	pigment {
	crackle
	poly_wave
	color_map {
		[0.0 rgb <1,1,.8>] 
		[0.1 rgb <1,.8,.55>] 
		[0.15 rgb <.7,.5,.23>] 
		[1.0 rgb <.6,.3,.25>]
	}
	turbulence .25 
	scale .025
	}
	finish {phong .2}
	normal {crackle .4 poly_wave turbulence .25 scale .002}
}              
           
// averaged textures

#declare Pattern1 =
texture {
	average
	texture_map {
		[1 Glossy_Green1]
		[1 Golden_Veins1]
	}
}    

#declare Pattern2 =
texture {
	average
	texture_map {
		[2 Spotty_Red1]
		[1 Golden_Veins1]
	}
}      

#declare Pattern3 =
texture {
	average
	texture_map {
		[2 Spotty_Gold1]
		[1 Golden_Veins2]
	}
}    

// the spherical patterns

#declare Pod_Tex1 =
texture {
	spherical
	texture_map {
		[0.0 Pattern2]
		[1.0 Pattern1]
	} 
	scale 3
	translate <0,-1.75,0>
}          

#declare Pod_Tex2 =
texture {
	spherical
	texture_map {
		[0.0 Pattern3]  
		[0.5 Pattern2]
		[1.0 Pattern1]
	} 
	scale 3
	translate <0,-1.75,0>
}  

#declare Pod_Tex3 =
texture {
	spherical
	texture_map {
		[0.0 Pattern3]
		[1.0 Pattern2]
	} 
	scale 2
	translate <0,-1.75,0>
}    

