// Persistence of Vision Ray Tracer Scene Description File
// File: house1.inc
// Vers: 3.1
// Desc: Ancient House 
// Date: 2.10.2002 
// Auth: Dominique Rossi 

  union {
    // GLASSES
    box { <-7.12, 0, 6.1> , <-12, 4.8, 9> 
      no_shadow
      texture {                              
        pigment { rgbt <1,1,1,0.6> }
        normal {bumps 0.2 scale 0.1 }
        finish {reflection 0.5}
        }                   
      }  
    
    difference {                
      // MAIN BODY
      box { <-7, 0, 6> , <-12, 4.8, 12> 
        texture {                              
          pigment { brick color rgb 1/2 color rgb <1,0.5,0.5>/2 brick_size <0.2, 0.1, 0.1> mortar 0.01}
          }                   
        }        
      // HOLES FOR THE WINDOW  
      box { <-7.2, 1, 7>, <-9, 2.9, 8.5> pigment { rgb <0.4, 0.3, 0.1> } }                                                
      box { <-6.9, 1, 7>, <-9, 2.2, 8.5> pigment { rgb <0.4, 0.3, 0.1> } }
      
      // HOLE FOR THE DOOR
      box { <-6.9 , 0.2, 10>, < -7.3, 2.2, 11>}
      cylinder { <-6.9, 2.2, 10.5>, <-7.3, 2.2, 10.5>, 0.50 }
    }                             
    // LIGHT IN THE LEFT HOUSE  
    light_source { <-8.5, 2.8, 7.5>, 
      color rgb <2, 2, 1> 
      #if ( AREA_LIGHTS = yes )
        area_light 0.1*x,0.1*z, 4 ,4  
      #end  
      }
      
    // WOOD AROUND THE FIRST FLOOR WINDOW
    union {
      box { <-6.99, 0, 6.85>, <-7.2, 2.35, 7.01> }
      box { <-6.99, 0, 8.49>, <-7.2, 2.35, 8.65> }
      box { <-6.99, 1.01, 7>, <-7.2, 0.85, 8.5> }
      box { <-6.99, 2.19, 7>, <-7.2, 2.35, 8.5> }
      pigment { rgb 0.1 }
      }
    
    // STONES NEXT TO THE DOOR
    blob {     
      threshold 1
      cylinder {0, 0.9*y, 0.3, 5 scale <1,1,0.5> rotate 13*z translate <-6.8, 0, 9.7>}
      cylinder {0, 0.9*y, 0.3, 5 scale <1,1,0.5> rotate 13*z translate <-6.8, 0, 11.3>}
      texture { pigment { granite scale 0.2} }
      }

    // FIRST FLOOR WINDOW
    box {
      <-7.1, 1.0, 7.0>, <-7.11, 2.2, 8.5>
      texture { 
        pigment {
          gradient y
          color_map {
            [0.2 rgb 0]
            [0.2 rgbt 0.5] }      
          scale 0.2  
          }
        finish { ambient 4}  
        }
      texture {
        pigment {
          gradient z
          color_map {
            [0.2 rgb 0 ]
            [0.2 rgbt 1] }
          scale 0.2  
          }
        }  
      }           
      
    //------------------------------------------------------    
    // SECOND FLOOR

      // WOODS
      union {
        box { 0, <0.5,0.1,0.1> rotate 45*z translate <-7.0, 2.4, 6.3> }
        box { 0, <0.5,0.1,0.1> rotate 45*z translate <-7.0, 2.4, 7>}
        box { 0, <0.5,0.1,0.1> rotate 45*z translate <-7.0, 2.4, 7.7>}
        box { 0, <0.5,0.1,0.1> rotate 45*z translate <-7.0, 2.4, 8.4>}
        box { 0, <0.5,0.1,0.1> rotate 45*z translate <-7.0, 2.4, 9.1> }
        // WOOD BORDER 
        box { <-6.65,2.75,6.3>, <-6.80,2.90,9.2> }
        box { <-6.65,2.75,6.3>, <-6.80,4.50,6.5> }
        box { <-6.65,2.75,9.0>, <-6.80,4.50,9.2> }
        box { <-6.65,4.35,6.3>, <-6.80,4.50,9.2> }
        // ROOF
        box { 0, <0.3,0.1,0.1> rotate 45*z translate <-6.65, 4.10, 7.5> }
        box { 0, <0.3,0.1,0.1> rotate 45*z translate <-6.65, 4.10, 7.9>}
        box { 0, <0.3,0.1,0.1> rotate 45*z translate <-6.65, 4.10, 8.3>}
        box { 0, <0.3,0.1,0.1> rotate 45*z translate <-6.65, 4.10, 8.7>}
        box { 0, <0.3,0.1,0.1> rotate 45*z translate <-6.65, 4.10, 9.1> }
        box { <-6.4, 4.35, 6>, <-8, 4.41, 9.3> }
        pigment { rgb <0.4, 0.3, 0.1> }
        } 
      
      // WALL  
      difference {
        box { <-6.66 , 2.88, 6.31 >, <-10.2, 4.5, 9.2>}
        // HOLES FOR 2 WINDOWS
        box { <-6.65, 3.5, 6.7>, <-7.5, 4.1, 7.6> pigment { rgb <0.4, 0.3, 0.1> }}
        box { <-6.65, 3.5, 7.9>, <-7.5, 4.1, 8.8> pigment { rgb <0.4, 0.3, 0.1> }}
        pigment { 
          granite 
          color_map {
            [0 color rgb 0.3]
            [1 color rgb 0.6]}
          scale <0.2,1,0.2>
          }
        }
      // SECOND FLOOR LIGHT
      light_source { <-7, 3.52, 7>, 1  fade_distance 2 fade_power 50}
      light_source { <-7, 3.52, 8.3>, 1 fade_distance 2 fade_power 50}
        
      // WINDOW
      box {
        <-6.75, 3.5, 6.7>, <-6.76, 4.1, 8.8>
        texture { 
          pigment {
            gradient y
            color_map {
              [0.2 rgb 0]
              [0.2 rgbt 0.5]
              }      
            scale 0.2  
            }
          finish { ambient 4}  
          }
        texture {
          pigment {
            gradient z
            color_map {
              [0.2 rgb 0 ]
              [0.2 rgbt 1]
              }           
            scale 0.2  
            }
          }  
        }           
        
    //bounded_by { box { <-6, 0, 6>, <-20, 5, 12>} }      
    }
    
  