//#version unofficial MegaPov 0.5
#include "colors.inc"

#ifndef (Included_File)
	#declare Included_File=false;
#end

#if (!Included_File)
	#declare Final=true;
	
	#if (Final)
	  global_settings {
	    radiosity {
	      pretrace_start 0.08
	      pretrace_end   0.01
	      count 500
	
	      nearest_count 10
	      error_bound 0.02
	      recursion_limit 1
	
	      low_error_factor 0.2
	      gray_threshold 0.0
	      minimum_reuse 0.015
	      brightness 1
	
	      adc_bailout 0.01/2 
	      
	      normal on
	    }
	  }
	#end
#end

#declare FencePanel_t = 
	texture { 
		pigment { rgb (Brown*4+Yellow+White)/6 }
		normal { gradient y ramp_wave 
			scale 0.2
			bump_size 0.8
			slope_map {
				[0 <0,3>]
				[0.05 <1,3>]
				[0.05 <1,-0.1>]
				[1.00 <0,-0.1>]
			}
			turbulence 0.3
		} 
	}

#declare FencePanelBattons_t = texture { pigment { rgb (Brown*3+Yellow+White)/5 } }
#declare FencePost_t = texture { pigment { rgb (Brown*3+Yellow+Gray60*2)/6 } }

#declare FencePost =
	union {
		box {
			<-0.05,0,-0.05> <0.05,1.83,0.05>
			texture { FencePost_t }
		}
		box {
			<-0.06,1.83,-0.06> <0.06,1.85,0.06>
			texture { FencePost_t }
		}
	}

#declare FencePanel =
	union {
		box { <-0.03,0,0> <0.03,0.025,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,1.75,0> <0.03,1.775,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,0> <0.03,1.75,-0.025> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,-1.805> <0.03,1.75,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,-0.91> <-0.01,1.75,-0.92> texture { FencePanelBattons_t } }
		box { <-0.005,0.025,-0.025> <0.005,1.75,-1.805> texture { FencePanel_t } }
	}

#declare HH_FencePanel =
	union {
		box { <-0.03,0,0> <0.03,0.025,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,0.90,0> <0.03,0.925,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,0> <0.03,0.90,-0.025> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,-1.805> <0.03,0.90,-1.83> texture { FencePanelBattons_t } }
		box { <-0.03,0.025,-0.91> <-0.01,0.90,-0.92> texture { FencePanelBattons_t } }
		box { <-0.005,0.025,-0.025> <0.005,0.90,-1.805> texture { FencePanel_t } }
	}

#declare HH_LaticePanel =
	union {
		// Vertical Battons
		#declare n=0;
		#while (n<9)
			box { 
				<0,0.925,0> 
				<0.01,1.75,-0.02> 
				texture { FencePanelBattons_t }
				translate n*-0.22625*z 
			}			
			#declare n=n+1;
		#end
		
		// Horizontal Battons
		#declare n=0;
		#while (n<5)
			box { 
				<0,0.925,0> 
				<-0.01,0.945,-1.83> 
				texture { FencePanelBattons_t }
				translate n*0.2075*y 
			}			
			#declare n=n+1;
		#end
	}
	
// Make Hedge Object
#include "pcmhair.mcr"
//#include "pcm.mcr"
#declare mesh_texture = texture {pigment {rgb <0.1,0.5,0.2> }}
#declare hair_length = 0.1;
#declare hair_objects_per_unit = 800;
#declare Hedge = object { read_mesh ("Hedge.pcm")  }
			        
#macro MakeFence( Type )
	#switch (Type)
		#case (1) // simple box
			box {
				<-0.02,-0.01,-3.99> <0.02,1.5,-35>
				pigment { White }
			}
		#break

		#case (2) // simple box (shorter to allow for gates between houses)
			box {
				<-0.02,-0.01,-5.5> <0.02,1.5,-35>
				pigment { White }
			}
		#break
		
		#case (3) // larch lap fence
			union {
				#local n=0;
				#while (n<16)
					object { FencePost translate <0,0,-4.06-(1.93*n)> }
					object { FencePanel translate <0,0,-4.11-(1.93*n)> }
				
					#declare n = n+1;
				#end
				object { FencePost translate <0,0,-4.06-(1.93*n)> }
			}
		#break
		
		#case (4) // shorter larch lap fence
			union {
				#local n=0;
				#while (n<15)
					object { FencePost translate <0,0,-5.50-(1.93*n)> }
					object { FencePanel translate <0,0,-5.55-(1.93*n)> }
				
					#declare n = n+1;
				#end
				object { FencePost translate <0,0,-5.50-(1.93*n)> }
				intersection {
					object { FencePanel translate <0,0,-5.55-(1.93*n)> }
					box { <-0.1,-0.1,-5.55-(1.93*n)> <0.1,2,-4.06-(1.93*16)>  }
				}
				
				object { FencePost translate <0,0,-4.06-(1.93*16)> }
			}
		#break


		#case (5) // Half height larch lap fence
			union {
				#local n=0;
				#while (n<16)
					object { FencePost translate <0,-0.85,-4.06-(1.93*n)> }
					object { HH_FencePanel translate <0,0,-4.11-(1.93*n)> }
				
					#declare n = n+1;
				#end
				object { FencePost translate <0,0,-4.06-(1.93*n)> }
			}
		#break
		
		#case (6) // Half height larch lap fence with lattice on top
			union {
				#local n=0;
				#while (n<16)
					object { FencePost translate <0,0,-4.06-(1.93*n)> }
					object { HH_FencePanel translate <0,0,-4.11-(1.93*n)> }
					object { HH_LaticePanel translate <0,0,-4.11-(1.93*n)> }
				
					#declare n = n+1;
				#end
				object { FencePost translate <0,0,-4.06-(1.93*n)> }
			}
		#break
		
		#case (7) // Hedge
			object { Hedge  }
		#break

		// #else
	#end

#end

#if (!Included_File)

	#declare Grass1  =          
		material {
			texture {
				pigment { 
					granite
					colour_map
					{
						[ 0 rgb <0.1,0.3,0.05> ]
						[ 1 rgb <0.2,0.4,0.1> ]
					}
				}
				normal {
					bumps
					scale 0.1
					bump_size 0.05
				}
				finish {
					diffuse 0.7
					ambient 0.3
					specular 0
				}
			}
		}

	plane { y, 0 material {Grass1} }
	
	sky_sphere {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .7]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.1 rgb <.6,.6,.7> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
	      scale 2
	      translate -1
		}
	}
	
	camera {
		location <-20,3,-40>
		sky y
		up 3*y
		right 4*x
		look_at 10*x-6*y 
		angle 60
		translate 10*x
	}
	
	//
	// Lightting
	//
	#declare c = color rgb <.8, .85, 1>; 
	#declare s1 = color rgb <1, .8, .6>; 
	#declare n = 6;
	
	#if (Final)
	
		light_source {
		  <10000, 10000, -15000>
		  color s1*.6
		  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <0, 10000, 0>
		  color c
		  area_light x*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <-10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, 10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, -10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
	#else
		light_source {
		  <10000, 10000, -5000>
		  color rgb 1
		  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <-100, 100, 0>
		  color rgb .5
		  shadowless
		}
	#end
	
	light_source {
		<-60,30,-40> White
	}

	object { MakeFence(7) }
	
#end