//#version unofficial MegaPov 0.5
#include "colors.inc"

// various glass finishes, colors and interiors
//
#include "glass.inc"

#ifndef (Included_File)
	#declare Included_File=false;
#end

#if (!Included_File)
	#declare Final=false;
	#include "textures.inc"
	#include "stoneold.inc"
	#include "consts.inc"
	#include "metals.inc"
	#include "woods.inc"
	#include "stones.inc"
	#include "skies.inc"
	
	#if (Final)
	  global_settings {
	    radiosity {
	      pretrace_start 0.08
	      pretrace_end   0.01
	      count 500
	
	      nearest_count 10
	      error_bound 0.02
	      recursion_limit 1
	
	      low_error_factor 0.2
	      gray_threshold 0.0
	      minimum_reuse 0.015
	      brightness 1
	
	      adc_bailout 0.01/2 
	      
	      normal on
	    }
	  }
	#end
#end

#declare rooft =
	texture {
		pigment { 
			cells scale <0.2,0.3,10>
			pigment_map {
				[ 0 rgb <0.5,0.1,0> ]
				[ 0.2 rgb <0.6,0.1,0.1> ]
				[ 1 rgb <0.7,0.1,0.1> ]
			}
		}
		normal { gradient y ramp_wave 
			scale 0.3
			bump_size 0.4
			slope_map {
				[0 <0,3>]
				[0.05 <1,3>]
				[0.05 <1,-0.1>]
				[1.00 <0,-0.1>]
			}
			turbulence 0.01
		} 
 
	}
	
#macro MakeGarage( n )
	union
	{
		// garage body
		difference {
	        box { <-1.5,-0.1,2.5> <1.5,2,-2.5> }
	        box { <-1.2,-0.1,-2.6> <1.2,1.85,-2.4> } // space for door
		}
		// door 
		difference {
			box { 
				<-1.19,0.01,-2.43> <1.19,1.84,-2.4>
			}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*0.3}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*0.4}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*0.5}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*0.9}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.0}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.1}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.2}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.3}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.7}
			cylinder { <-1,0,-2.445> <1,0,-2.43> 0.02 translate y*1.8}
			texture {
				/*Brushed_*/Aluminum  scale 0.01
			}
		}
		// handle
		union {
			cylinder { <0,0.7,-2.42> <0,0.7,-2.45> 0.008 }
			cylinder { <-0.05,0.7,-2.45> <0.05,0.7,-2.45> 0.008 }
			texture { T_Chrome_3D }
		}
		// roof
		height_field {
			function 10,5000 {
				pigment {
					gradient y sine_wave
					scale 0.1/3
					pigment_map {
						[0 rgb 0.50 ]
						[1 rgb 0.53 ]
					}
				}
			}
			smooth
			translate -0.5
			scale <3.05,1,5>
			rotate z*5
			translate y*2.15
			texture {
				pigment {
					spotted
					scale 0.15
					translate n
					turbulence 0.01 
					pigment_map {
						[ 0.7 granite scale 0.015
							pigment_map {
								[ 0 rgb <0.3,0.35,0.3> ]
								[ 1 rgb <0.3,0.3,0.2> ]
							}
						] 
						[ 0.85 rgb <0.3,0.4,0.2> ]  // spots of moss
					}
				}
				normal { 
					brick 0.02
					brick_size <1,10,2>
					mortar 0.02
				}
				finish {
					ambient 0
					diffuse 0.7
					specular 0
				}
			}
		}


		// colour any of the above that aren't coloured.
		pigment { White }
	}
#end

#if (!Included_File)

	#declare Grass1  =          
		material {
			texture {
				pigment { 
					granite
					colour_map
					{
						[ 0 rgb <0.1,0.3,0.05> ]
						[ 1 rgb <0.2,0.4,0.1> ]
					}
				}
				normal {
					bumps
					scale 0.1
					bump_size 0.05
				}
				finish {
					diffuse 0.7
					ambient 0.3
					specular 0
				}
			}
		}

	plane { y, 0 material {Grass1} }
	
	sky_sphere {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .7]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.1 rgb <.6,.6,.7> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
	      scale 2
	      translate -1
		}
	}
	
	camera {
		location 0
		sky y
		up 3*y
		right 4*x
		look_at 200*x-16*y - <-40,4,-20>
		angle 60
		translate <-40,4,-20>
	}
	
	//
	// Lightting
	//
	#declare c = color rgb <.8, .85, 1>; 
	#declare s1 = color rgb <1, .8, .6>; 
	#declare n = 6;
	
	#if (Final)
	
		light_source {
		  <10000, 10000, -15000>
		  color s1*.6
		  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <0, 10000, 0>
		  color c
		  area_light x*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <-10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, 10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, -10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
	#else
		light_source {
		  <10000, 10000, -5000>
		  color rgb 1
		  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <-100, 100, 0>
		  color rgb .5
		  shadowless
		}
	#end
	
	light_source {
		<-60,30,-40> White
	}

	object { MakeGarage(0) rotate y*60 translate <-30,0,-18> }
	
#end