
#include "colors.inc"

#declare Final=true;

#if (Final)
  global_settings {
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 500

      nearest_count 10
      error_bound 0.02
      recursion_limit 1

      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2 
      
      normal on
    }
  }
#end


#declare rooft =
	texture {
		pigment { rgb <0.7,0.2,0.2> }
		normal {
			gradient x scale 0.3
			sine_wave
			bump_size 0.25
		} 
	}
	texture {
		pigment { Clear }
		normal {
			gradient y scale 0.3
			ramp_wave
			bump_size 10
			slope_map {
				[ 0   <1,-0.1> ]
				[ 0.7 <0,-0.1> ]
				[ 0.7 <0,8>    ]
				[ 1.0 <1,8>    ]
				[ 1.0 <1,-0.1> ]
			}
		}
	}

#declare Brickwork =
	texture { pigment { rgb <0.8,0.2,0.1> } }

#declare Grass1  =          
	material {
		texture {
			pigment { 
				granite
				colour_map
				{
					[ 0 rgb <0.1,0.3,0.05> ]
					[ 1 rgb <0.2,0.4,0.1> ]
				}
			}
			normal {
				bumps
				scale 0.1
				bump_size 0.05
			}
			finish {
				diffuse 0.7
				ambient 0.3
				specular 0
			}
		}
	}
	
#macro MakeSemi( n )
	union
	{
		box { <-5,0,-4> <5,5,4> 
			texture { 
				gradient y scale 5
				texture_map
				{
					[ 0.5 Brickwork ]
					[ 0.5 pigment
						{
							cells translate y*n scale 6.1
							pigment_map 
							{
								[ 0 rgb <0.8,0.6,0.6> ]
								[ 0.2 rgb <0.3,0.6,0.9> ]
								[ 0.5 rgb 0.9 ]
								[ 0.75 rgb <0.5,0.9,0.6> ]
								[ 1.0 rgb <0.9,1.0,0.8> ]
							}
						}
					]
				}
			}
		}
		box {
			<-0.2,5,-0.75> <0.2,8.75,0.75>
			texture { Brickwork }
		}
		box { 
			<-0.15,-3.0,-3.0> <0.15,3.0,3.0> rotate x*45 scale <1,0.8,1> translate 5.2*y
			pigment { rgb <0.6,0.6,0.5> } 
		}

		difference {
			intersection {
				box { 
					<-5.2,-3.0,-3.0> <5.2,3.0,3.0> rotate x*45 scale <1,0.8,1> translate 5*y
					texture {rooft} 
				}
				box { 
					<-3.7,-3.7,-6.01> <3.7,3.7,6.01> rotate z*45 scale <1,1,1> translate 5*y 
					texture {rooft rotate y*90 } 
				}

			}
			plane { y,4.99 }
			texture {
				pigment { rgb <0.7,0.2,0.2> }
			}
		}
		pigment { White }
	}
#end


plane { y, 0 material {Grass1} }

sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[0.5 color rgb .7]
			[0.6 granite scale <1,0.25,1>
				colour_map {
					[ 0.1 rgb <.6,.6,.7> ]
					[ 0.9 rgb <.3,.4,.6> ]
				} 
			]
		}
      scale 2
      translate -1
	}
}

camera {
	location <-50,6,-20>
	sky y
	up 3*y
	right 4*z
	look_at 200*x-16*y
	angle 60
}

//
// Lightting
//
#declare c = color rgb <.8, .85, 1>; 
#declare s1 = color rgb <1, .8, .6>; 
#declare n = 6;

#if (Final)

	light_source {
	  <10000, 10000, -15000>
	  color s1*.6
	  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
	  adaptive 1
	  jitter
	  media_interaction on
	  media_attenuation on
	}
	
	light_source {
	  <0, 10000, 0>
	  color c
	  area_light x*20000, z*20000, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <10000, 0, 0>
	  color c
	  area_light y*20000, z*20000, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <-10000, 0, 0>
	  color c
	  area_light y*20000, z*20000, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <0, 0, 10000>
	  color c
	  area_light y*20000, x*20000, n, n
	  adaptive 1
	  jitter
	}
	light_source {
	  <0, 0, -10000>
	  color c
	  area_light y*20000, x*20000, n, n
	  adaptive 1
	  jitter
	}
#else
	light_source {
	  <10000, 10000, -5000>
	  color rgb 1
	  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
	  adaptive 1
	  jitter
	  media_interaction on
	  media_attenuation on
	}
	
	light_source {
	  <-100, 100, 0>
	  color rgb .5
	  shadowless
	}
#end

#declare n=-2;
#while (n<20)
	object { MakeSemi(n) translate 11*x*n }
	#declare n=n+1;
#end