//#version unofficial MegaPov 0.5
#include "colors.inc"

#ifndef (Included_File)
	#declare Included_File=false;
#end

#if (!Included_File)
	#declare Final=false;
	
	#if (Final)
	  global_settings {
	    radiosity {
	      pretrace_start 0.08
	      pretrace_end   0.01
	      count 500
	
	      nearest_count 10
	      error_bound 0.02
	      recursion_limit 1
	
	      low_error_factor 0.2
	      gray_threshold 0.0
	      minimum_reuse 0.015
	      brightness 1
	
	      adc_bailout 0.01/2 
	      
	      normal on
	    }
	  }
	#end
#end

// Make Hedge Object
#include "pcmhair.mcr"
//#macro create_mesh () cylinder_mesh (0.02, false, true, false) #end 
//#macro create_mesh () wire_mesh (0.01) #end//#include "pcmhair.mcr"
#declare mesh_texture = 
	texture {
		normal { 
			bumps scale 0.01 
			bump_size 0.001  
		}
		pigment {
			spotted 
			pigment_map {		
				[ 0 rgb <0.1,0.5,0.2> ]
				[ 1 rgb <0.2,0.5,0.1> ]
			}
			scale 0.01 
		}
		finish {
			ambient 0
			diffuse 1
			specular 0
		}
	}
	
#declare hair_length = 0.05;
#declare hair_objects_per_unit = 2000;
#declare hair_rotate_to_surface = true;
#declare hair_object = sphere {<0, 0.01, 0>, 0.01 } 

#declare Topiary_T_Rex = object { read_mesh ("T-Rex.pcm") scale 5 }

#if (!Included_File)

	#declare Grass1  =          
		material {
			texture {
				pigment { 
					granite
					colour_map
					{
						[ 0 rgb <0.1,0.3,0.05> ]
						[ 1 rgb <0.2,0.4,0.1> ]
					}
				}
				normal {
					bumps
					scale 0.1
					bump_size 0.05
				}
				finish {
					diffuse 0.7
					ambient 0.3
					specular 0
				}
			}
		}

	plane { y, 0 material {Grass1} }
	
	sky_sphere {
		pigment {
			gradient y
			pigment_map {
				[0.5 color rgb .7]
				[0.6 granite scale <1,0.25,1>
					colour_map {
						[ 0.1 rgb <.6,.6,.7> ]
						[ 0.9 rgb <.3,.4,.6> ]
					} 
				]
			}
	      scale 2
	      translate -1
		}
	}
	
	camera {
		location <-30,2,0>
		sky y
		up 3*y
		right 4*x
		look_at 200*x-16*y
		angle 60
	}
	
	//
	// Lightting
	//
	#declare c = color rgb <.8, .85, 1>; 
	#declare s1 = color rgb <1, .8, .6>; 
	#declare n = 6;
	
	#if (Final)
	
		light_source {
		  <10000, 10000, -15000>
		  color s1*.6
		  area_light <1, 0, 2>, <-2, 2, 1>, 6, 6
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <0, 10000, 0>
		  color c
		  area_light x*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <-10000, 0, 0>
		  color c
		  area_light y*20000, z*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, 10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
		light_source {
		  <0, 0, -10000>
		  color c
		  area_light y*20000, x*20000, n, n
		  adaptive 1
		  jitter
		}
	#else
		light_source {
		  <10000, 10000, -5000>
		  color rgb 1
		  area_light <100, 0, 200>, <-200, 200, 100>, 3, 3
		  adaptive 1
		  jitter
		  media_interaction on
		  media_attenuation on
		}
		
		light_source {
		  <-100, 100, 0>
		  color rgb .5
		  shadowless
		}
	#end
	
	light_source {
		<-60,30,-40> White
	}

	object { 
		Topiary_T_Rex
		rotate y*90
	}
	
#end