/*******************************************************
    POV-Ray - BlobMan People Costume Definition File
 File Name : croft.cdf
 BM_Version: 4.0
 Desciption: Costume Definition File - Lara ?
 Date      : April 2000
 Author    : Peter Houston 
 Email     : houston.graphics@iname.com 
 WWW       : http://welcome.to/HoustoGraphics 

Notes :
    This CDF only works for Female Figures.
    
    This CDF includes a hair setting.  To test render
    scenes without hair enter the following code
    after the CDF is included
    
        #decalre BM_HairStyle=0;
    
    Then just remove it when you want the hair.
    
    The Boots do not sit on y0 so if you transform
    the figure using the Foot or Toe Origins you will need 
    to add the following translation after the 
    transformation
    
        translate <0,1.0>*BM_Scale 
    
    The Toes of the Boot will bend to match the Toe Angle
    however you need to specify the Toe Angle before the 
    CDF is called, even if you are using arrays.
    
        #declare BM_Toe_Angle=<0,0,0>;
    
********************************************************/
#include "bm_hair.inc"

/********************************************************
  Image Maps & Textures
********************************************************/
#declare BM_Skin_Tex=
    texture {
        pigment{rgb <0.96,0.80,0.69>}
    }                         
#declare BM_Lip_Tex   = texture {pigment {rgb x*.75}}
//#declare BM_Nail_Tex  = texture {pigment {rgb <.2,.5,.5>} finish {phong 1}}                         
//#declare BM_Eye_Shadow= texture {pigment {rgb <.2,.5,.5>}}
//#declare BM_Map_Normal = normal {wrinkles 0.15 scale <.5,10,.5>}

#include "glass.inc" 

#declare SockTex=
    texture {
        pigment {rgb 1}
        normal {quilted .5 scale .1}
    }

#declare BootTex= texture {
    pigment {rgb .8 }
    finish {phong .5 reflection .1}
}
 
#declare SoleTex= texture {
    pigment {rgb <0.7,0.7,0.5> }
    normal {ripples 1 scale .5}
    
} 

#declare LaceTex=texture {pigment {rgb <0.556863, 0.137255, 0.137255>}
                          normal {quilted 1 scale .1 rotate z*45}
                 }

#declare Jeans_Tex=texture { 
	pigment { spotted scale <4,8,4>
		pigment_map {
			[ 0 rgb <0.3,0.8,0.9>/3 ]
			[ 1 rgb <0.4,0.6,0.7>  ]
		}
	}
	finish { specular 0 diffuse 0.6 ambient 0.2 brilliance 0.5}
	normal { wrinkles scale <4,8,4> } 
}

#declare Child1_T_Shirt_Tex=texture { 
	pigment {
		
		spiral2 3         // double spiral that winds around the y-axis
		rotate x*90
		turbulence 0.3
		scale 5
			
		colour_map {
			[ 0.0 rgb (<0.5,0,0.5>+Gray60)/2 ]
			[ 0.2 rgb (<1,0,0>+Gray60)/2 ]
			[ 0.4 rgb (<1,1,0>+Gray60)/2 ]
			[ 0.5 rgb (<0.5,1,0>+Gray60)/2 ]
			[ 0.6 rgb (<0,1,0>+Gray60)/2 ]
			[ 0.9 rgb (<0,1,1>+Gray60)/2 ]
			[ 1.0 rgb (<0,0.5,1>+Gray60)/2 ]
       }
    }
    finish { specular 0 diffuse 0.5 ambient 0.1 brilliance 0.7}
	normal { wrinkles scale <2,4,2> }
}
	
//#declare Torso_IMap      = "child1_torso.png"
//#declare Abdomen_IMap    = "child1_abdo.png"
//#declare Hand_R_IMap     = 
//#declare Hand_L_IMap     = 
//#declare Thigh_R_IMap    = "child1_thigh.png"
//#declare Thigh_L_IMap    = "child1_thigh.png"
//#declare Calf_R_IMap     = "child1_calf.png"
//#declare Calf_L_IMap     = "child1_calf.png"
//#declare Foot_R_IMap     = 
//#declare Foot_L_IMap     = 

#declare BM_Foot_L_Tex = texture {SoleTex}
#declare BM_Foot_R_Tex = texture {SoleTex}
#declare BM_Thigh_L_Tex = texture { Jeans_Tex }
#declare BM_Thigh_R_Tex = texture { Jeans_Tex }
#declare BM_Torso_Tex = texture {  Child1_T_Shirt_Tex }
#declare BM_Abdomen_Tex = texture { 
	gradient y ramp_wave
	translate -0.5*y
	scale 100
	translate -23*y
	texture_map {
		[ 0.5 Jeans_Tex translate 23*y scale 0.01 translate 0.5*y ]
		[ 0.5 Child1_T_Shirt_Tex translate 23*y scale 0.01 translate 0.5*y]
	}
}	      
	
/********************************************************
  Body Part Options
********************************************************/

#declare BM_EyeCol=<.25,.25,0>;
#declare BM_Hair_Col=<0.35, 0.20, 0.1>;
#declare BM_HairStyle=1;
#declare BM_Map_R_Finger=0;
#declare BM_Map_L_Finger=0;
#declare BM_Build=0.35;
	
#declare BM_Prop_PipeSword =	
	union {
		cylinder { <0,0,6> <0,0,-30> 0.5 open pigment { rgb <0.5,0.5,0.6> } }
		cylinder { <1,-4,0> <1,4,0> 0.5 open pigment { rgb <0.5,0.5,0.6> } }
		torus { 
			0.8, 0.5 
			texture { 
				normal{ gradient y scallop_wave scale 0.05 bump_size 1 } 
				pigment { rgb <0.8,0.8,0.6> }
			}
			rotate x*45 translate <0.5,0,0> 
		}
		torus { 
			0.8, 0.5 
			texture { 
				normal{ gradient y scallop_wave scale 0.05 bump_size 1 } 
				pigment { rgb <0.8,0.8,0.6> }
			}
			rotate x*-45 translate <0.5,0,0> 
		}
		translate <1,-2.5,-3>
	}
                        
/********************************************************
  Body Part Objects
********************************************************/

#declare BM_Head_Object= object{BM_Head_Object}
//#declare BM_Neck_Object=object {BM_Neck_Object}
                                                 
//#declare BM_Torso_Object=
//#declare BM_Abdomen_Object=
//#declare BM_Upperarm_R_Object=object {BM_Upperarm_R_Object}
//#declare BM_Upperarm_L_Object=object {BM_Upperarm_L_Object}
//#declare BM_Forearm_R_Object=object {BM_Forearm_R_Object}
//#declare BM_Forearm_L_Object=object {BM_Forearm_L_Object}
#declare BM_Hand_R_Object= object{ BM_Prop_PipeSword }

//#declare BM_Hand_L_Object=object {BM_Hand_L_Object}
//#declare BM_Thigh_R_Object=
//#declare BM_Thigh_L_Object= 
	
#declare BM_Calf_R_Object= union {
	// 3D curved FINITE (no CSG) surface created from a mesh of triangles
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.01 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 5 // # of triangles to subdivide (1-5)
		v_steps 5 // # of triangles to subdivide (1-5)
		<1, 1, 0> <1, 1, 2> <2, 1, 1> <0, 1, 1>
		<7.5, -1, 0> <7.5, -1, 3> <3, -1, 9> <0, -1, 9>
		<4.0, -10, 0> <4, -10, 2> <2, -10, 5> <0, -10, 5>
		<4.0, -17, 0> <4, -17, 2> <2, -17, 5> <0, -17, 5>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.01 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 5 // # of triangles to subdivide (1-5)
		v_steps 5 // # of triangles to subdivide (1-5)
		<-1, 1, 0> <-1, 1, 2> <-2, 1, 1> <0, 1, 1>
		<-9, -1, 0> <-9, -1, 3> <-3, -1, 9> <0, -1, 9>
		<-4.0, -10, 0> <-4, -10, 2> <-2, -10, 5> <0, -10, 5>
		<-4.0, -17, 0> <-4, -17, 2> <-2, -17, 5> <0, -17, 5>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.01 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 5 // # of triangles to subdivide (1-5)
		v_steps 5 // # of triangles to subdivide (1-5)
		<1, 1, 0> <1, 1, -2> <2, 1, -1> <0, 1, -1>
		<7.5, -1, 0> <7.5, -1, -3> <3, -1, -6> <0, -1, -6>
		<4.0, -10, 0> <4, -10, -2> <2, -10, -3> <0, -10, -3>
		<4.0, -17, 0> <4, -17, -2> <2, -17, -3> <0, -17, -3>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.01 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 5 // # of triangles to subdivide (1-5)
		v_steps 5 // # of triangles to subdivide (1-5)
		<-1, 1, 0> <-1, 1, -2> <-2, 1, -1> <0, 1, -1>
		<-6, -1, 0> <-6, -1, -2> <-2, -1, -4> <0, -1, -4>
		<-4.0, -10, 0> <-4, -10, -2> <-2, -10, -3> <0, -10, -3>
		<-4.0, -17, 0> <-4, -17, -2> <-2, -17, -3> <0, -17, -3>
	}

	texture { Jeans_Tex }
}

#declare BM_Calf_L_Object=union {
	object { BM_Calf_R_Object scale <-1,1,1> } 
}
/****
	// 3D curved FINITE (no CSG) surface created from a mesh of triangles
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.1 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 3 // # of triangles to subdivide (1-5)
		v_steps 3 // # of triangles to subdivide (1-5)
		<1, 1, 0> <1, 1, 2> <2, 1, 1> <0, 1, 1>
		<5, -1, 0> <5, -1, 2> <2, -1, 6> <0, -1, 6>
		<4.0, -13, 0> <4, -13, 2> <2, -13, 5> <0, -13, 5>
		<4.0, -17, 0> <4, -17, 2> <2, -17, 5> <0, -17, 5>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.1 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 3 // # of triangles to subdivide (1-5)
		v_steps 3 // # of triangles to subdivide (1-5)
		<-1, 1, 0> <-1, 1, 2> <-2, 1, 1> <0, 1, 1>
		<-6, -1, 0> <-6, -1, 2> <-2, -1, 6> <0, -1, 6>
		<-4.0, -13, 0> <-4, -13, 2> <-2, -13, 5> <0, -13, 5>
		<-4.0, -17, 0> <-4, -17, 2> <-2, -17, 5> <0, -17, 5>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.1 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 3 // # of triangles to subdivide (1-5)
		v_steps 3 // # of triangles to subdivide (1-5)
		<1, 1, 0> <1, 1, -2> <2, 1, -1> <0, 1, -1>
		<5, -1, 0> <5, -1, -2> <2, -1, -4> <0, -1, -4>
		<4.0, -13, 0> <4, -13, -2> <2, -13, -3> <0, -13, -3>
		<4.0, -17, 0> <4, -17, -2> <2, -17, -3> <0, -17, -3>
	}
	bicubic_patch {
		type 1 // patch_type (0..1)
		// 0 = Bezier patch, just store the triangular vertices
		// 1 = Bezier patch, store all plane equations defined by
		//       the triangulation of the patch into sub patches
		//       (faster, uses more memory)
		flatness 0.1 // flatness value
		//       flatness_value = 0.0 to 1.0, with higher values
		//        giving flatter, less smooth results
		u_steps 3 // # of triangles to subdivide (1-5)
		v_steps 3 // # of triangles to subdivide (1-5)
		<-1, 1, 0> <-1, 1, -2> <-2, 1, -1> <0, 1, -1>
		<-6, -1, 0> <-6, -1, -2> <-2, -1, -4> <0, -1, -4>
		<-4.0, -13, 0> <-4, -13, -2> <-2, -13, -3> <0, -13, -3>
		<-4.0, -17, 0> <-4, -17, -2> <-2, -17, -3> <0, -17, -3>
	}
    scale <-1,1,1>
	texture { Jeans_Tex }
}
****/
                            
#declare BM_Foot_R_Object=union {
                                //object {BM_Foot_R_Object}
                                difference {    
                                    union { // Sole
                                        cylinder {<0,0,0><0,-.75,0> 2.2 
                                                   translate <0,-2.5,0>
                                        }
                                        cylinder {<0,0,0><0,-.75,0> 2.9 
                                                   rotate x*BM_Toe_Angle.z
                                                   translate <-.3,-2.5,-5.7> 
                                                    
                                                    clipped_by {plane {z,-5.7}}
                                        }                              
                                        prism {   linear_sweep   linear_spline 
                                            0,-0.75,5,        
                                          <-2,0>,<2,0>,<2.5,-5.7>,<-3.4,-5.7>,<-2,0>
                                          translate <0,-2.5,0>
                                        }
                                   }        
                                   box {<-4,-8,0><4,0,-8>
                                        rotate x*-14
                                        rotate y*8
                                        translate <0,-2.6,-2>
                                   }
                                   texture {SoleTex}
                               }      
                               union { //Uppers
                                    union {sphere {<0,.5,0>,2.6}
                                           cylinder {<0,.5,0><0,0,0>2.6}
                                        
                                            clipped_by {plane{y,0 inverse}}
                                            clipped_by {plane {z,0 rotate x*45}}                                            
                                            rotate x*BM_Toe_Angle.z 
                                            translate <-.3,-2.5,-5.7>
                                            
                                    }
                                    
                                    cone {<0,0,0>1.75,<0,-2.5,0>1.9}
                                    sphere {0,1.75}
                                    cone {<0,-.5,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    cone {<0,-2,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    texture {BootTex}
                               }

                                 #local Laces=0;
                                 #while (Laces<4)
                                    torus {1,.2 
                                        texture {LaceTex}
                                        rotate z*30
                                        translate <0,-1-Laces,-.2>
                                        rotate x*80
                                    }  
                                    torus {1,.2 
                                        texture {LaceTex}
                                        rotate z*-30
                                        translate <0,-1-Laces,-.3>
                                        rotate x*80
                                    }  
                                    #declare Laces=Laces+1;
                                #end
                            }
    
                                            
                          
#declare BM_Foot_L_Object=union {
                                object {BM_Foot_R_Object}
                                difference {    
                                    union { // Sole
                                        cylinder {<0,0,0><0,-.75,0> 2.2 
                                                   translate <0,-2.5,0>
                                        }
                                        cylinder {<0,0,0><0,-.75,0> 2.9 
                                                   rotate x*BM_Toe_Angle.z
                                                   translate <-.3,-2.5,-5.7> 
                                                    
                                                    clipped_by {plane {z,-5.7}}
                                        }                              
                                        prism {   linear_sweep   linear_spline 
                                            0,-0.75,5,        
                                          <-2,0>,<2,0>,<2.5,-5.7>,<-3.4,-5.7>,<-2,0>
                                          translate <0,-2.5,0>
                                        }
                                   }        
                                   box {<-4,-8,0><4,0,-8>
                                        rotate x*-14
                                        rotate y*8
                                        translate <0,-2.6,-2>
                                   }
                                   texture {SoleTex}
                               }      
                               union { //Uppers
                                    union {sphere {<0,.5,0>,2.6}
                                           cylinder {<0,.5,0><0,0,0>2.6}
                                        
                                            clipped_by {plane{y,0 inverse}}
                                            clipped_by {plane {z,0 rotate x*45}}                                            
                                            rotate x*BM_Toe_Angle.z 
                                            translate <-.3,-2.5,-5.7>
                                            
                                    }
                                    
                                    cone {<0,0,0>1.75,<0,-2.5,0>1.9}
                                    sphere {0,1.75}
                                    cone {<0,-.5,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    cone {<0,-2,0>1.75,<-.3,-2.5,-5.7>2.6
                                          clipped_by {plane {y,-2.5 inverse}}
                                    }
                                    texture {BootTex}
                               }

                                 #local Laces=0;
                                 #while (Laces<4)
                                    torus {1,.2 
                                        texture {LaceTex}
                                        rotate z*30
                                        translate <0,-1-Laces,-.2>
                                        rotate x*80
                                    }  
                                    torus {1,.2 
                                        texture {LaceTex}
                                        rotate z*-30
                                        translate <0,-1-Laces,-.3>
                                        rotate x*80
                                    }  
                                    #declare Laces=Laces+1;
                                #end
                                scale <-1,1,1>
                            }    
    
// End of Costume Definition File