// Persistence of Vision Ray Tracer Scene Description File
// File: AhSunlight.pov
// Vers: 3.5
// Desc: Aaaahh, Sunlight
// Date: 12/13/2001
// Auth: Jeff M. Thomas
//

#version 3.5;

#include "functions.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "skies.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones.inc"
#include "woods.inc"

#include "StoneWall.inc"
#include "Candelabra.inc"
#include "Fence.inc"

#declare use_rad = false;
#declare load_rad = false;
#declare refl = true;
#declare use_photons = false;
#declare load_photons = false;
#declare use_media = false;
#declare use_atmosphere = false;
#declare use_ghost = false;
#declare use_floor = true;
#declare use_window_wall = true;
#declare use_window = false;
#declare use_window_frame_only = false;
#declare use_simple_window = false;
#declare use_stand_in_walls = false;
#declare use_stand_in_floor = false;
#declare use_skysphere = true;
#declare use_columns = true;
#declare use_tombs = false;
#declare use_background_image = false;
#declare use_candelabras = true;
#declare use_shrine = true;
#declare use_KneelingBench = true;
#declare use_the_boy = false;

#declare work_light = false;
#declare inclose = false;

#declare iNumberOfPanes = 7;

#declare asMasks=array[iNumberOfPanes] {
 "LeadMask.png", "GlassYellowMask.png", "GlassBlueMask.png", "GlassRedMask.png", "GlassPurpleMask.png", 
 "GlassTerquoisMask.png", "GlassGreenMask.png"
}
#declare argbfNoFadeColors=array[iNumberOfPanes] {
 rgbf<0.8, 0.8, 0.2, 1>, rgbf<0.8, 0.8, 0.2, 1>, color rgbf<0.90, 0.94, 1.0, 1>, rgbf<0.9, 0.1, 0.2, 1>, 
 rgbf<0.1, 0.15, 0.5, 1>, rgbf<0.7255, 0.8510, 0.9176, 1>, rgbf<0.4392, 0.7725, 0.5804, 1>
}
#declare argbFadeColors=array[iNumberOfPanes] {
 Col_Glass_Yellow, Col_Glass_Yellow, Col_Glass_Bluish, Col_Glass_Ruby, Col_Glass_Vicksbottle, 
 Col_Aquamarine_06, Col_Emerald_07
}

global_settings {
#if (use_rad = false)
  ambient_light .1
#end
  assumed_gamma 1.0
  adc_bailout 0.003922
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10  
#if (use_rad=true)
  radiosity {
    #if (load_rad)
      load_file "StainedGlass.ra"
    #else
      brightness       3.3
      count            100
      distance_maximum 0.0
      error_bound      0.4
      gray_threshold   0.5
      low_error_factor 0.8
      minimum_reuse    0.015
      nearest_count    6
      recursion_limit  1
      #if (use_media)
        media on
      #end
      save_file "StainedGlass.ra"
    #end
  }
#end
#if (use_rad=false & load_rad)
  radiosity {
    load_file "StainedGlass.ra"
  }
#end
#if ( use_photons=true )
  photons {
  #if(load_photons)
	  //spacing 0.05
    //gather 20, 100
    //autostop 0
    //jitter 0.9
    load_file "StainedGlass.ph" 
  #else
    // use non-adaptive search radius
	  spacing 0.01
    gather 20, 100
    autostop 0
    media 100
    jitter 0.9
    save_file "StainedGlass.ph"
  #end 
  }
#end
#if (load_photons = true & use_photons = false )
  photons 
  {
    load_file "StainedGlass.ph" 
  }
// load the photons, but turn the object use off, hee hee hee
#end
}
    
    
#if ( use_atmosphere & use_media )
media 
{
  scattering { 2, rgb 0.053}
  intervals 10
  samples 5
  method 1
  density
  {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
//    agate  
//    agate_turb 1
//    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
    scale .5
  }
}
#end

// ----------------------------------------

////////////////////////////////////////////////////////
//
// --------------------------------------- Cameras
//
////////////////////////////////////////////////////////

camera { // main
  location  <3.0, 2, -8.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, -2.0, -1.0>
}
/*camera { // over left tomb
  location  < -4, 2, -2.35 >
  direction 1.5*z
  right     x*image_width/image_height
  look_at   < -4, -2.4, -2.35 >
}*/
/*camera { // look at window
  location  <0.0, 0, -8.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0, 1.0>
}*/
/*
camera {  // 
  location  <3.0, -1, -2.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, -1.0, -2.0>
}
*/

////////////////////////////////////////////////////////
//
// --------------------------------------- Skysphere
//
////////////////////////////////////////////////////////

#if (use_skysphere)
  sky_sphere
  {
    pigment{ planar colour_map{[0,rgb <0.9,0.9,1>][1, rgb <0.1,0.2,1>]}}
    pigment{P_Cloud4}
  }  
#end
#if (false & use_floor = false)
   plane
   {
     y,-3
     pigment{ rgb<1,1,1> }//rgb <0.1,0.6,0.1> }
//      texture
//      {
//        T_Stone1
//        normal{
//          agate 0.6
//          scale 0.24 
//          scale <1,.1,0>
//        }
//        translate<4,4,4> 
        //scale .5
//      }

   }  
#end

////////////////////////////////////////////////////////
//
// --------------------------------------- Lights
//
////////////////////////////////////////////////////////

#if (work_light & use_rad = false)
// a 'fill' lite to bring things not lit by media or radiosity out
light_source { <100, 100, -100> color rgb 0.6
  media_interaction off
  shadowless
}
#end

// the sun
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1.5, 1.5, 1.5>  // light's color
  translate <0.0, 53.5, 54.0>
  parallel
  translate <0.0, 0.0, 4.0>
  spotlight
  cylinder
  point_at <0, 0, 0>
  falloff 30
  radius 9
#if ( use_media )
  media_interaction on
#end
#if (use_photons )
  photons {
    reflection on
    refraction on
  }
#end
}

////////////////////////////////////////////////////////
//
// --------------------------------------- Textures
//
////////////////////////////////////////////////////////

#declare TestMarble =
texture
{
  pigment{ White_Marble }                    
  scale .8
  finish{phong 1.0 phong_size 90 ambient 0.2}
}
#declare DecrotaveMetal=
  texture
  {
    pigment{ P_Brass3 }
    finish{ F_MetalA }
  }
#declare IronRustTexture=
    texture // a rusty iron
    { 
      pigment
      {   
        granite
        color_map 
        {
          [0.0 rgb <.0,.0,.0>]
          [0.45 rgb <.0,.0,.0>]
          [0.6 rgb <.1,.051,.051>]
          [0.6 rgb <.0,.0,.0>]
        }
      } 
      scale .3
      finish{ ambient 0.2 diffuse 0.6 } 
      normal { wrinkles 1 scale 0.5 }
    }
#declare LightIronTexture=
    texture // a rusty iron
    { 
      pigment
      {   
        granite
        color_map 
        {
          [0.0 rgb <.0,.0,.0>]
          [0.45 rgb <.05,.05,.05>]
          [0.6 rgb <.1,.051,.051>]
          [0.6 rgb <.0,.0,.0>]
        }
      } 
      scale .3
      finish{ ambient 0.2 diffuse 0.6 } 
      normal { wrinkles 1 scale 0.5 }
    }

#declare TestStoneWallTexture=
  texture{ pigment{ Gray } }
  texture{ T_Grnt8a }  

#declare StoneTexture=
  texture{ pigment{ DimGray } }//finish{ ambient .3} }
  texture{ T_Grnt11a }//finish{ ambient .3} }  

#declare StoneWallTexture=
  texture{ pigment{ DimGray } }//finish{ ambient .3} }
  texture{ T_Grnt8a }//finish{ ambient .3} }
    
#declare StoneTombTexture=
  texture{ pigment{ Gray } }//finish{ ambient .3} }
  texture{ T_Grnt22a }//finish{ ambient .3} }  
   
#declare StoneWallInterior=
  interior {}

#declare CCrossTexture=
  texture
  {
    T_Grnt5
    normal
    {
      wrinkles
      scale .1
    }
    scale .70
  }          

////////////////////////////////////////////////////////
//
// --------------------------------------- Inclosure
//
//////////////////////////////////////////////////////// 

#if ( inclose )
  // back wall
  object
  {
    box { <20,20,1>, <-20,-20,1> }
    pigment{ Gray }
    translate< 0,0,-10 >
  }
  //left side
  object
  {
    box { <20,20,1>, <-20,-20,1> }
    pigment{ Gray }
    rotate< 0,90,0 >
    translate< -15,0,0 >
  }          
  // right side
  object
  {
    box { <20,20,1>, <-20,-20,1> }
    pigment{ Gray }
    rotate< 0,90,0 >
    translate< 10,0,0 >
  }            
  // roof
  object
  {
    box { <20,20,1>, <-20,-20,1> }
    pigment{ Gray }
    rotate< 90,0,0 >
    translate< 0,15,-6 >
  }
#end
   
////////////////////////////////////////////////////////
//
// --------------------------------------- Media
//
////////////////////////////////////////////////////////

#declare Dust=
    interior 
    {
      media 
      {           
        #if (0)
        intervals 1
        samples 3,3
        absorption 1
        emission 1
        #else  // 4,1,5,3 5,.2,-,-,1
        // 1,10,(5,5),3
#if (frame_number = 0)
        scattering { 5, <0.002,0.002,0.002>*55 eccentricity 0}//extinction 0}
        intervals 10
        samples 2
        method 3
        aa_level 1
        aa_threshold .1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 1)
        scattering { 5, <0.002,0.002,0.002>*35 eccentricity .2}//extinction 0}
        intervals 5
        samples 2
        method 3
        aa_level 1
        aa_threshold .1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 2)
        scattering { 5, <0.002,0.002,0.002>*35 eccentricity -.2}//extinction 0}
        intervals 5
        samples 2
        method 3
        aa_level 1
        aa_threshold .1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 3)
        scattering { 5, <0.002,0.002,0.002>*35 eccentricity -.4}//extinction 0}
        intervals 5
        samples 2
        method 3
        aa_level 1
        aa_threshold .1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
/*#if (frame_number = 1)
        scattering { 3, <0.002,0.002,0.002>*35 }//extinction 0}
        intervals 1
        samples 5
        method 3
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 2)
        scattering { 5, <0.002,0.002,0.002>*35 eccentricity .2}//extinction 0}
        //intervals 1
        //samples 5
        method 1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 3)
        scattering { 1, <0.002,0.002,0.002>*35 }//extinction 0}
        intervals 5
        samples 2
        method 1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 4)
        scattering { 1, <0.002,0.002,0.002>*35 }//extinction 0}
        intervals 5
        samples 2
        method 2
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 5)
        scattering { 1, <0.002,0.002,0.002>*35 }//extinction 0}
        intervals 5
        samples 2
        method 1
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
#if (frame_number = 6)
        scattering { 1, <0.002,0.002,0.002>*35 }//extinction 0}
        intervals 10
        samples 5,5
        method 3
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }
#end
*/        //intervals 1
        //samples 1
/*        method 2
        density
        {
          wrinkles
          turbulence 0.65
          octaves 6
          omega 0.7
          lambda 2
      //    agate  
      //    agate_turb 1
      //    warp{ turbulence <1,1,1> octaves 6 lambda .8 omega .2 }
          scale .5
        }*/
        #end

      }
    }

#if ( (use_atmosphere = false) & use_media )
union
{
  object
  {
    box { < -4, -3.5, -3>, < 4, 1.6, 1> }
  	texture {pigment {color rgbf 1}}
  	//pigment{ Gray }
    hollow on
    interior{ Dust }
  }
  #if (use_ghost = false)
    sphere
    {      
      <0,0,0> .1
    	texture {pigment {color rgbf <1,1,1,0>} }
      hollow on
      interior 
      {
        media 
        {
          scattering { 1, rgb <.0,.0,.02>}
          intervals 1
          samples 5
          method 1
          density
          {
            spherical  
          }
        }
      }
    }
  #else
  // this is to quiet the 'should have at least 2 objects in csg' warning
/*    sphere
    {      
      <0,0,0> .0001
    	texture {pigment {color rgbf 1} }
    	translate <-100,-100,-100>
    }
*/  #end
  translate < 0, .1, -.9 >
}
#end // media box


#if (use_window)
////////////////////////////////////////////////////////
//
// --------------------------------------- Stained Glass Window
//
////////////////////////////////////////////////////////

#declare i = 0;

#declare Stained_Glass_Window =
union {
  #while (i < iNumberOfPanes)

    #declare fn_Dents=function {
        pigment {
          dents  
          warp{ turbulence <0.1,0.1,0> }
          translate <2*i,4*i,0>
          scale <0.3,0.3,.01>
        }
      }
    #declare fn_Picmap=function {
        pigment {
          #if (i=0)
            image_map {png asMasks[i] interpolate 4}     
          #else
            image_map {png asMasks[i] }     
          #end
          translate<0.5,0.5,0>
        }
      }
    #if ( (use_window_frame_only = false) | (i = 0) )  
      object
      {
        isosurface 
        {
          #if (i=0) // first
            function { y +(fn_Picmap(x/2,z/2,0).gray*.0065)}
          #else
            #if (use_simple_window)
              function { y +(fn_Picmap(x/2,z/2,0).gray*.008) }
            #else
              function { y +(fn_Picmap(x/2,z/2,0).gray*.0080)-(fn_Dents(x,z,0).gray*.003) }
            #end
          #end
          contained_by { box { <-1,-.005,-1>, <1,.005,1> } }  
          rotate<-90,0,0>
          #if (use_photons)
          photons 
          {
            target
            refraction on
            reflection off
            //collect off
          }                
          #end
        }  
        //pigment{ Gray }
        //finish{ IsoFinish }
        #if (i=0) // first
          //texture{ pigment{ Black } }
          texture { 
             pigment { DimGray }
            scale .6   
            translate .5
            //finish { phong 0 }
          }      
        #else
          texture { pigment{ color argbfNoFadeColors[i] } }
          interior {
            ior 1.5
            //fade_distance 5//1.0
            //fade_power .1//2
            fade_color argbFadeColors[i]
          }
          finish
          {
            specular 0.7
            roughness 0.001
            diffuse 0
            reflection
            {
              0.2, 1.0
              fresnel on
            }
            conserve_energy
            #if (use_rad)
              ambient 1
            #else
              ambient 1
            #end
          }
          #if (use_photons = true)
          photons {
          	target 1.0
            #if(refl)
            reflection on
            #end
            refraction on
            //ignore_photons
          }
          #end // use photons
        #end // not first
      }
    #end // use_window_frame_only
    #declare i = i + 1;
  #end // while
  scale <2,2,1.5>     
  // I changed the images I use for this late in the game
  // and unfortunatly they couldn't be lined up with the originals,
  // (which were rather odd too) so I have to compensate.
  scale <.83,.83,1>
} // union


  object{ Stained_Glass_Window }
#end // use_window


////////////////////////////////////////////////////////
//
// --------------------------------------- Walls & Floor
//
////////////////////////////////////////////////////////

//box{ <-4,-.1,-.4>,<4,.1,.4> pigment{Grey} }
#if (use_window_wall)
  
  // the window wall
  MakeStoneWall( <.5,.25,.2>, <.005,.005,.005>, <.04,.04,.04>, <15,10,1>, StoneWallTexture, StoneWallInterior, .08, .05, true, true )
  difference
  {
    #if (use_stand_in_walls)
      box{ <-7.5,-7.5,-.1> <7.5,7.5,.1> pigment{Gray} }
    #else
      object
      { 
        StoneWall 
        scale <2.5,2.5,1>
        translate<0,-.46,0>
      }
    #end // use_stand_in_walls     
  #if (use_stand_in_walls = false)
    isosurface
    {
      function { (sqrt(x^2 + y^2) - 1)+(f_wrinkles((x)*20,(y)*20,(z)*20)*0.02)-(fn_Dents((x),(y),(z)).gray*.005) }
      contained_by { box { <-1.5,-1,-.6>, <1.5,1,.6> } }
      all_intersections  
      //texture {pigment{color rgbf <1,1,1,1>}}
      texture {StoneWallTexture}
      scale< 1.59, 1.59, 1 >
    } 
    // trim the mortor
    cylinder
    {
      <0,0,-.6>, <0,0,.6>, 1.64
      pigment {color rgbf <1,1,1,1>}
    }
  #else
    cylinder
    {
      <0,0,-.6>, <0,0,.6>, 1.68
      pigment {color rgbf <1,1,1,1>}
    }
  #end
  }
  #if (use_stand_in_walls = false)
    // left corner wall
    MakeStoneWall( <.2,.5,1>, <.09,.09,.09>, <.02,.02,.02>, <1,8,2>, StoneWallTexture, StoneWallInterior, .1, .1, true, true )
    difference
    {
      #if (false & use_stand_in_walls)
        box{ <-7.5,-7.5,-.1> <7.5,7.5,.1> pigment{DimGrey} }
      #else
        object
        { 
          StoneWall 
          scale <1,1.5,1.5>
          translate < -6.20, -.33, -.35 >
        }
      #end
    }
  #end
#end // use_window_wall

#if( use_floor)
  #if (use_stand_in_floor)
    box 
    { 
      <-7.5,-7.5,-.1> 
      <7.5,7.5,.1> 
      pigment{DimGray}
      rotate< 90,0,0>
      translate<0,-3.25,-4.2>
    }
  #else
    //#declare StoneWallTexture2= 
    //  texture{ pigment{ Black } }
    //  texture{ T_Crack4 }
      
    // the floor
    MakeStoneWall( <.8,.8,.5>, <.05,.05,.05>, <.2,.2,.2>, <13,10,1>, StoneTexture, StoneWallInterior, 0, .2, true, true )
    //MakeStoneWall( <.8,.8,.5>, <.02,.02,.02>, <.2,.2,.2>, <10,10,1>, texture{ pigment{ DimGrey } }, StoneWallInterior, 0, 6, false )
    object
    { 
      StoneWall 
      scale <1.5,1.5,1>
      rotate< 90,0,0>
      translate<0,-3.28,-3.91>
    }
  #end
#end // use_Floor


////////////////////////////////////////////////////////
//
// --------------------------------------- The Ghost
//
////////////////////////////////////////////////////////

#if (use_ghost)
#include "ghost.inc"

object
{ 
  Ghost 
  hollow off
  scale .004 
  texture 
  {
    pigment { color rgbf <1,1,1,.8>}
/*    finish
    {
      ambient 0
      diffuse 0
      brilliance 0
    }*/ 
  }
/*  interior 
  { 
    //ior 0
    media 
    {
      emission rgb <.3,.3,.3>
      //scattering { 1, rgb <.3,.3,.3>}
      intervals 10
      samples 5
      method 2
      density
      {
        agate
        scale .5  
      }
    }
  }
  */
  rotate< 90, 0, 180> 
  rotate< 0, 45, 0> 
  //rotate< 0, -90, 0> 
  translate < 0, -2.25, -2.0 >
}
#end // ghost

// the tombs
#if (use_tombs)
//  #declare Tomb_Texture =
//  texture
//  {
//    Blue_Agate
//    scale .5
//  }

////////////////////////////////////////////////////////
//
// --------------------------------------- Tombs
//
////////////////////////////////////////////////////////

#declare Lids = array[3]{ "TombTopper1.png", "TombTopper2.png", "TombTopper2.png" }
#declare Sides = array[3]{ "TombSide1a.png", "TombSide2.png", "TombSide3.png" }
#declare Caps = array[2]{ "TombEndCap1.png", "TombEndCap2.png" }

#macro TombLid( LidNumber, Texture )
  #declare fn_TombPicmap=function {
      pigment {
        image_map {png Lids[LidNumber] interpolate 4}     
        translate<0.5,0.5,0>
        scale <.75,.25,1>
      }
    }  
  object
  {
    isosurface {
      function { y +(fn_TombPicmap(x/2,z/2,0).gray*.01)}
      contained_by { box { <-0.775,-.005,-.25>, <(1.55/2),.005,.25> } }
      all_intersections    
      //rotate<180,0,0>
      //scale <1,10,1>
      //translate<0,.058,0>
      translate<0,.063,0>
    }  
    texture { Texture }      
  }
#end
  
#macro TombSide( SideNumber, Texture )
  #declare fn_TombPicmap=function {
      pigment {
        image_map {png Sides[SideNumber] interpolate 4}     
        translate <0.5,0.5,0>
        scale <.775,.26,1>
      }
    }  
  object
  {
    isosurface {
      // a rather more complicated series of objects and transitions
      // boiled down to this. It can probably be reduced further
      // but I'm not going to touch it anymore.
      function { y +(fn_TombPicmap(x/2,z/2,0).gray*.01)}
      contained_by { box { <-0.775,-.005,-.25>, <(1.55/2),.005,.25> } }  
      all_intersections  
      scale<1,8,1>
      rotate<180,0,0>
      rotate <90,0,0>
      translate <0,.02,-.278>
    }  
    texture { Texture }      
  }
#end

#macro TombEndCap( CapNumber, Texture )
  #declare fn_TombPicmap=function {
      pigment {
        image_map {png Caps[CapNumber] interpolate 4}     
        translate <0.5,0.5,0>
        scale <.23,.23,1>
      }
    }  
  object
  {
    isosurface {
      function { y +(fn_TombPicmap(x/2,z/2,0).gray*.01)}
      contained_by { box { <-.25,-.005,-.25>, <.25,.005,.25> } }
      all_intersections  
      scale<1,8,1>
      rotate<0,0,90>
      translate <0.76,.02,0>
    }  
    texture { Texture }      
  }
#end

#declare Finial=
  isosurface
  {
    function { f_quartic_cylinder(x,y,z, -.1, 0.8, 0.4) }
    contained_by { box { <-0.85, -2.5, -0.85>, <0.85, 2.5, 0.85> } }
    max_gradient 8.8
    scale .05
    texture { T_Silver_1E }
  }

#macro Lid( Number, LidTexture, DecorationTexture, Finials )
  union
  {
    MakeStoneWall( <1.55,.07,.5>, <.05,.05,.05>, <0,0,0>, <1,1,1>, LidTexture, StoneWallInterior, 0, .025, true, true )
    object{ StoneWall }
    object
    {     
      TombLid( Number, DecorationTexture )
    }
    #if (Finials)
      object{ Finial translate <.750,.11,.255> }
      object{ Finial translate <.750,.11,-.245> }
      object{ Finial translate <-.750,.11,.255> }
      object{ Finial translate <-.750,.11,-.245> }
    #end

    //object{ Finial translate <0,.1,0> }
       
    translate<0,.37,0> 
  }
#end

  // center
  MakeStoneWall( <1.55,.55,.5>, <.05,.05,.05>, <.2,.2,.2>, <1,1,1>, T_Stone7, StoneWallInterior, 0, .02, true, true )
  union
  {
    difference
    {
      object{ StoneWall }
      object
      {    
        TombSide( 2, T_Gold_1A )//T_Gold_1A )
      }
      object
      {    
        TombEndCap( 0, T_Gold_1A )
      }
    }
    object
    {
      Lid( 2, T_Stone7, T_Silver_1E, true )
    }
    translate < 0, -2.3, -2.36 >
    translate <0,-.44,0>
  }
    
  // left side
  //MakeStoneWall( <1.55,.55,.5>, <.05,.05,.05>, <.2,.2,.2>, <1,1,1>, StoneTexture, StoneWallInterior, 0, .02, true, true )
  union
  {
    object
    {
      Lid( 1, TestMarble, DecrotaveMetal, false )
    }
    MakeBoxFence( 1.8, .9, .15, <.02,.75,.02>, 2, texture{ LightIronTexture scale<0,2,0> }, 0 )
    object{ BoxFence translate<0,0.35,0> }
    translate < -4, -2.4, -2.35 >
    //translate <0,-.44,0>
    translate <0,-.97,0>
  }

  // right side
  MakeStoneWall( <1.55,.55,.5>, <.05,.05,.05>, <.2,.2,.2>, <1,1,1>, StoneTexture, StoneWallInterior, 0, .02, true, true )
  union
  {
    difference
    {
      object{ StoneWall }
      object
      {    
        TombSide( 1, StoneTombTexture )//T_Gold_1A )
      }
      object
      {
        TombEndCap( 0, StoneTombTexture )
        // this is on the right side, we need it on the left    
        translate <-1.585,0,0>
      }
      object
      {     
        object{ TombLid( 0, StoneTombTexture ) }
        scale<0,6,0>
        translate <0,-.065,0>
      }
    }
    translate < 4, -2.3, -2.35 >
    translate <0,-.44,0>
  }

#end

////////////////////////////////////////////////////////
//
// --------------------------------------- Kneeling Bench
//
////////////////////////////////////////////////////////
#if (use_KneelingBench)

#include "KneelingBench.inc"

  object
  { 
    KneelingBench
    scale <1,.75,1>
    rotate<0,5,0>
    translate<0.1,-3.0,-2.9>
  }
  
#end // Kneeling Bench

////////////////////////////////////////////////////////
//
// --------------------------------------- Columns
//
////////////////////////////////////////////////////////
// the columns
#if (use_columns)
  MakeStoneWall( <.7,1.5,.5>, <.09,.09,.09>, <.01,.01,.01>, <1,5,1>, StoneTexture, StoneWallInterior, 0, .4, true, true )
  object
  { 
    StoneWall
    translate < -2.85, .95, -.39 >
  }
  MakeStoneWall( <.7,1.5,.5>, <.09,.09,.09>, <.01,.01,.01>, <1,5,1>, StoneTexture, StoneWallInterior, 0, .4, true, true )
  object
  { 
    StoneWall
    rotate <0,90,0>
    translate < -5.70, .95, -.39 >
  }
  MakeStoneWall( <.7,1.5,.5>, <.09,.09,.09>, <.01,.01,.01>, <1,5,1>, StoneTexture, StoneWallInterior, 0, .4, true, true )
  object
  { 
    StoneWall
    rotate <0,180,0>
    translate < 2.85, .95, -.39 >
  }
  //not seen
//  MakeStoneWall( <.7,1.5,.7>, <.09,.09,.09>, <.02,.02,.02>, <1,5,1>, StoneWallTexture, StoneWallInterior, 0, .4, true, true )
//  object
//  { 
//    StoneWall
//    translate < 5.70, .95, -.35 >
//  }
#include "Bench.inc"
  // a bench
  object
  {
    Bench( BenchTexture )
    translate<-4.4,-3,-.35>
  }
  // another bench
  object
  {
    Bench( BenchTexture )
    translate<4.2,-3,-.35>
  }
#end //use_columns

////////////////////////////////////////////////////////
//
// --------------------------------------- Candelabras
//
////////////////////////////////////////////////////////

#if (use_candelabras)
  object
  { 
    ACandleRack( 1.2, 1.3, 1, 1.4, .8, false, false, false, false, true )
    scale .65
    translate< 2.85, -2.33, -1 >
  }
  object
  { 
    ACandleRack( 1.1, .75, 1.2, .6, 1.4, false, true, false, true, false )
    scale .65
    translate< -2.85, -2.33, -1 >
  }
#end

////////////////////////////////////////////////////////
//
// --------------------------------------- Shrine
//
////////////////////////////////////////////////////////
#if (use_shrine)
  #include "CelticCross.inc"

  MakeStraightFence( 5.21, .2, <.02,.5,.02>, 1, LightIronTexture, 2 )
  object{ Fence translate<0,-3,-.7> }
  object{ CCross translate<0,-2,-.3> }

#end // use_shrine

////////////////////////////////////////////////////////
//
// --------------------------------------- Background Image Map
//
////////////////////////////////////////////////////////
#if (use_background_image)   
  box
  {
    <-.5,-.5,-.1>,<.5,.5,.1>
    texture
    {
      pigment
      {
        image_map 
        {
          png "background.png"
        }
        translate <.5,.5,0>
      }
      finish{ ambient 8.2 }
    }
    scale <10,10,0>
    translate <-2,-3,8>
  }
#end // use_background_image

#if (use_the_boy)

#include "Boy3.inc"

object
{
  Boy
  rotate< -90,105,0 >
  scale 2.3
  translate <-3.25,-3,-1.5>
}


#end