/ Persistence of Vision Ray Tracer Scene Description File
// File: Fence.inc
// Vers: 3.5
// Desc: Makes a wrought iron fence.
// Date: 12/13/2001
// Auth: Jeff M. Thomas
//          

#macro MakeStraightFence( FenceLength, FencePostSpace, FencePostSize, FenceBars, FenceTexture, Top )
  #declare Fence=
  union
  {
    #local xStart = -FenceLength/2;
    #local xOffset = (FencePostSize.x/2);
    #local zOffset = (FencePostSize.z/2);              
    #local PostCount = 0;
    #local xLoc = xStart;
    #while( xLoc < (FenceLength/2) )
      box
      { 
        #if ( Top = 2 )
          <xLoc-xOffset, 0, -zOffset>, 
          <(xLoc-xOffset)+FencePostSize.x, FencePostSize.y-(FencePostSpace+FencePostSize.x)/2, zOffset>
        #else
          <xLoc-xOffset, 0, -zOffset>, 
          <(xLoc-xOffset)+FencePostSize.x, FencePostSize.y, zOffset>
        #end        
        texture{ FenceTexture }
      }
      #local xLoc = xLoc + FencePostSpace;
      #local PostCount = PostCount + 1;
    #end
    // horizantal bars
    #local BarCount = 0;
    #local BarSeperation = FencePostSize.y / (FenceBars+1);
    #while( BarCount < FenceBars )
      // front
      box
      {
        <(xStart - xOffset) - .01, (BarSeperation*(BarCount+1))-.005, (-zOffset)-.01>,
        <(-xStart) + xOffset + .01, (BarSeperation*(BarCount+1))+.005, zOffset+.01> 
        
        texture{ FenceTexture }
      }
      #local BarCount = BarCount + 1;
    #end
    #if ( Top = 1 )
      // add a bar to the top
      box
      {
        <(xStart - xOffset) - .01, FencePostSize.y-.005, (-zOffset)-.01>,
        <(-xStart) + xOffset + .01, FencePostSize.y+.005, zOffset+.01> 
        
        texture{ FenceTexture }
      }
    #end
    #if ( Top = 2 )
      // add half circles to the top
      #local TopCount = 0;
      #local xLoc = xStart + (FencePostSpace/2);
      #while ( TopCount < PostCount-1 )
        difference
        {
          cylinder
          {
            <0,0,-zOffset> , <0,0,zOffset>, (FencePostSpace+FencePostSize.x)/2
            texture{ FenceTexture }
            translate < xLoc, FencePostSize.y-(FencePostSpace+FencePostSize.x)/2, 0 >
          }
          cylinder
          {
            <0,0,-(zOffset+.01)> , <0,0,zOffset+.01>, (FencePostSpace-FencePostSize.x)/2
            texture{ FenceTexture }
            translate < xLoc, FencePostSize.y-(FencePostSpace+FencePostSize.x)/2, 0 >
          }
          box
          {                       
            <-((FencePostSpace/2)+(FencePostSize.x/2)+.01),0,(-zOffset)-.01>,
            <((FencePostSpace/2)+(FencePostSize.x/2)+.01),-((FencePostSpace/2)+(FencePostSize.x/2)+.01),zOffset+.01>
            texture{ FenceTexture }
            translate < xLoc, FencePostSize.y-(FencePostSpace+FencePostSize.x)/2, 0 >
          }
        }
        #local xLoc = xLoc + FencePostSpace; 
        #local TopCount = TopCount + 1;
      #end
    #end
    #if ( Top = 3 )
      // add circles to the top
      #local TopCount = 0;
      #local xLoc = xStart + (FencePostSpace/2);
      #while ( TopCount < PostCount-1 )
        difference
        {
          cylinder
          {
              <0,0,-zOffset> , <0,0,zOffset>, (FencePostSpace+FencePostSize.x)/2
              texture{ FenceTexture }
              translate < xLoc, FencePostSize.y, 0 >
          }
          cylinder
          {
              <0,0,-(zOffset+.01)> , <0,0,zOffset+.01>, (FencePostSpace-FencePostSize.x)/2
              texture{ FenceTexture }
              translate < xLoc, FencePostSize.y, 0 >
          }
        }
        #local xLoc = xLoc + FencePostSpace; 
        #local TopCount = TopCount + 1;
      #end
    #end
  }
#end // MakeFence

#macro MakeBoxFence( FenceWidth, FenceDepth, FencePostSpace, FencePostSize, FenceBars, FenceTexture, Top )
  #declare BoxFence=
  union
  {
    #local xPosts = int(FenceWidth / FencePostSpace) + 1;
    #local zPosts = int(FenceDepth / FencePostSpace) + 1;
    MakeStraightFence( FenceWidth, FencePostSpace, FencePostSize, FenceBars, FenceTexture, Top )
    object{ Fence translate < 0, 0, -(FenceDepth/2) > }
    object{ Fence translate < 0, 0, (FenceDepth/2) > }
    MakeStraightFence( FenceDepth, FencePostSpace, FencePostSize, FenceBars, FenceTexture, Top )
    object{ Fence rotate<0,90,0> translate < -(FenceWidth/2), 0, 0 > }
    object{ Fence rotate<0,-90,0> translate < (FenceWidth/2), 0, 0 > }
  }
/*  union
  {
    #local xPosts = int(FenceWidth / FencePostSpace) + 1;
    #local zPosts = int(FenceDepth / FencePostSpace) + 1;
    #local xStart = -(((xPosts-1)*FencePostSpace)/2);
    #local zStart = -(((zPosts-1)*FencePostSpace)/2);
    #local ix = 0;
    #local iz = 0;
    #local xLoc = xStart - (FencePostSize.x/2);
    #local zLoc = zStart - (FencePostSize.z/2);
    // front and back fence
    #while( ix < xPosts )
      box
      { 
        <xLoc, 0, zLoc>, 
        <xLoc+FencePostSize.x, FencePostSize.y, zLoc+FencePostSize.z>
        
        texture{ FenceTexture }
      }
      box
      { 
        <xLoc, 0, -zLoc>, 
        <xLoc+FencePostSize.x, FencePostSize.y, -(zLoc+FencePostSize.z)>
        
        texture{ FenceTexture }
      }
      #local ix = ix + 1;
      #local xLoc = xLoc + FencePostSpace;
    #end
    // side fences
    #local iz = 0;
    #local xLoc = xStart - (FencePostSize.x/2);
    #local zLoc = zStart - (FencePostSize.z/2);
    #while( iz < zPosts )
      box
      { 
        <xLoc, 0, zLoc>, 
        <xLoc+FencePostSize.x, FencePostSize.y, zLoc+FencePostSize.z>
        
        texture{ FenceTexture }
      }
      box
      { 
        <-xLoc, 0, zLoc>, 
        <-(xLoc+FencePostSize.x), FencePostSize.y, zLoc+FencePostSize.z>
        
        texture{ FenceTexture }
      }
      #local iz = iz + 1;
      #local zLoc = zLoc + FencePostSpace;
    #end
    // horizantal bars
    #local BarCount = 0;
    #local BarSeperation = FencePostSize.y / (FenceBars+1);
    #while( BarCount < FenceBars )
      // front
      box
      {
        <xStart - (FencePostSize.x/2)-.01, (BarSeperation*(BarCount+1))-.005, zStart - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, (BarSeperation*(BarCount+1))+.005, zStart + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // back
      box
      {
        <xStart - (FencePostSize.x/2)-.01, (BarSeperation*(BarCount+1))-.005, (-zStart) - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, (BarSeperation*(BarCount+1))+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // LSide
      box
      {
        <xStart - (FencePostSize.x/2)-.01, (BarSeperation*(BarCount+1))-.005, zStart - (FencePostSize.z/2)-.01>,
        <xStart + (FencePostSize.x/2)+.01, (BarSeperation*(BarCount+1))+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // RSide
      box
      {
        <(-xStart) - (FencePostSize.x/2)-.01, (BarSeperation*(BarCount+1))-.005, zStart - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, (BarSeperation*(BarCount+1))+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      #local BarCount = BarCount + 1;
    #end
    #if ( Top = 1 )
      // add a bar to the top
      box
      {
        <xStart - (FencePostSize.x/2)-.01, FencePostSize.y-.005, zStart - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, FencePostSize.y+.005, zStart + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // back
      box
      {
        <xStart - (FencePostSize.x/2)-.01, FencePostSize.y-.005, (-zStart) - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, (BarSeperation*(BarCount+1))+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // LSide
      box
      {
        <xStart - (FencePostSize.x/2)-.01, FencePostSize.y-.005, zStart - (FencePostSize.z/2)-.01>,
        <xStart + (FencePostSize.x/2)+.01, FencePostSize.y+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
      // RSide
      box
      {
        <(-xStart) - (FencePostSize.x/2)-.01, FencePostSize.y-.005, zStart - (FencePostSize.z/2)-.01>,
        <(-xStart) + (FencePostSize.x/2)+.01, FencePostSize.y+.005, (-zStart) + (FencePostSize.z/2)+.01> 
        
        texture{ FenceTexture }
      }
    #end
  } // Fence union
*/
#end // MakeFence

/*
#declare FenceTexture=
    texture
    { 
      pigment
      {   
        granite
        color_map 
        {
          [0.0 rgb <.0,.0,.0>]
          [0.45 rgb <.0,.0,.0>]
          [0.6 rgb <.1,.051,.051>]
          [0.6 rgb <.0,.0,.0>]
        }
      } 
      scale .3
      finish{ ambient 0.2 diffuse 0.6 } 
      normal { wrinkles 1 scale 0.5 }
    }

MakeFence( 1.6, .7, .1, <.02,.5,.02>, 2, FenceTexture, 1 )

object{ Fence translate<0,-1,0>}
*/
