global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"  
#include "woods.inc"
#include "fish.inc"

camera {
  location <9.8, 3.5, 5.5>
  up <0, 1, 0>
  sky <0, 1, 0>
  look_at <-4, 4, 13.5>
}

background { color MidnightBlue }

plane { y, 0
   pigment {
      checker colour White colour Gray75
      scale 1
   }
   finish {
      ambient 0.2
      diffuse 0.8
   }
}

// START of ROOM //

#declare Walls = Tan

plane { z, 10
   pigment { colour Walls }
   finish { 
     ambient 0.2 
     diffuse 0.8 
   }
}

plane { z, -5
   pigment { colour Walls }
   finish { 
     ambient 0.2 
     diffuse 0.8 
   }
}

plane { x, 10
   pigment { colour Walls }
   finish {
     ambient 0.2
     diffuse 0.8
   }
}

plane { x, -5
   pigment { colour Walls }
   finish {
     ambient 0.2
     diffuse 0.8
   }
}     

plane { y, 10
   pigment { colour White }
   finish {
      ambient 0.2
      diffuse 0.8
   }
}

// END of ROOM //

// START of PICTURE //

#declare PicFrame = difference
{
  box {<0, 0, 0> <2.3, 2, 0.15>}
  box {<0.2, 0.2, -0.1> <2.1, 1.8, 0.16>}
  cylinder {<0,0,0>, <0, 2, 0>, 0.05}         
  cylinder {<0,2,0>, <2.3, 2, 0>, 0.05}         
  cylinder {<2.3,2,0>, <2.3, 0, 0>, 0.05}         
  cylinder {<2.3,0,0>, <0, 0, 0>, 0.05}         
}      

#declare PicGlass = box {<0.2, 0.2, 0.1> <2.1, 1.8, 0.15>}
#declare Picture = box {<0.2, 0.2, 0> <2.1, 1.8, 0.1>}

#declare PicX = -1;
#declare PicY = 4;
#declare PicZ = 9.9;

object {
  PicFrame

  texture { Tan_Wood scale 0.2}
  
  scale 2
  translate <PicX, PicY, PicZ>
}

object {
  PicGlass
  
  texture { T_Glass4 }
  interior {I_Glass caustics 1}
  
  scale 2
  translate <PicX, PicY, PicZ>
}  

object {
  Picture
  
  texture {
    pigment {
      image_map
      {
        tga "forgotten.tga" 
        map_type 0 
        interpolate 2 
      }
      scale 2         
      translate <0.2, -0.1, 0>
    }
  }
  scale 2
  translate <PicX, PicY, PicZ>
}

light_source 
{
  <PicX+2.6, 9.9, PicZ-2>
  color White
  spotlight             
  radius 20
  falloff 22
  tightness 14
  point_at <PicX+2.1, PicY+2, PicZ>
}

#declare Pic2X = -4.9;
#declare Pic2Y = 4;
#declare Pic2Z = 2.5;

object {
  PicFrame

  texture { Tan_Wood scale 0.2}
  
  scale 2
  rotate <0, -90, 0>
  translate <Pic2X, Pic2Y, Pic2Z>
}

object {
  PicGlass
  
  texture { T_Glass4 }
  interior {I_Glass caustics 1}
  
  scale 2
  rotate <0, -90, 0>
  translate <Pic2X, Pic2Y, Pic2Z>
}  

object {
  Picture
  
  texture {
    pigment {
      image_map
      {
        sys "shadowmesas.bmp" 
        map_type 0 
        interpolate 2 
      } 
      scale 2         
      translate <0.2, -0.1, 0>
    }
  }
  scale 2
  rotate <0, -90, 0>
  translate <Pic2X, Pic2Y, Pic2Z>
}

light_source 
{
  <-1.5, 9.9, 7>
  color White
  spotlight             
  radius 20
  falloff 22
  tightness 14
  point_at <-4.9, 3.5, 3.8>
}

// END of PICTURE //

// START of TABLE //

#declare Table = union
{
  box {<0.2, 0, 0.2> <0.4, 2.4, 0.4>}
  box {<3.8, 0, 2.3> <3.6, 2.4, 2.1>}
  box {<0.2, 0, 2.3> <0.4, 2.4, 2.1>}
  box {<3.8, 0, 0.2> <3.6, 2.4, 0.4>}
  box {<0, 2.4, 0> <4, 2.6, 2.5>}
}      

object {
  Table

  texture {
    Tan_Wood scale 0.2
    rotate <0, pi/4, 0>
  }
  
  translate <6, 0, 7.4>
}

// END of TABLE //

// START of LAMP //

#declare LampShade = difference
{
  cone {<0, 4, 0>, 1, <0, 4.8, 0>, 0.5}
  cone {<0, 3.99, 0>, 0.9, <0, 4.81, 0>, 0.4}
}

#declare LampPost = difference
{
  cylinder {<0, 0, 0>, <0, 4, 0>, 0.15}
}

#declare LampBase = difference
{
  cylinder {<0, 0, 0>, <0, 0.2, 0>, 0.45}
}

#declare LampX = -4;
#declare LampY = 0;
#declare LampZ = 9;

light_source 
{
  <LampX, LampY+4.6, LampZ>
  color rgb <0.5, 0.5, 0.5>         
  fade_distance 2.5
  fade_power 0.6
}

object {
  LampShade

  texture {Brushed_Aluminum}
  
  translate <LampX, LampY, LampZ>
}

object {
  LampPost

  texture {Bronze_Metal}
  
  translate <LampX, LampY, LampZ>
}

object {
  LampBase

  texture {Bronze_Metal}
  
  translate <LampX, LampY, LampZ>
}

// END of LAMP //

// START of COUCH //

#declare CouchTex = texture {
  pigment { color red 1 green 0 blue 0 }
  normal { bumps 0.4 scale 0.05 }
  finish { ambient 0.2 diffuse 0.4 phong 0.5 phong_size 5 }
}

#declare cushion = superellipsoid { 
  <0.4, 0.4>
  scale <2, 0.75, 2>
  texture {CouchTex}
}

#declare side = superellipsoid {
  <0.6, 0.6>
  scale <0.5, 1.75, 2.1>
  texture {CouchTex}
}

#declare back = superellipsoid {
  <0.6, 0.6>
  scale <2, 2.25, 0.75>
  texture {CouchTex}
}

#declare couchX = -2
#declare couchY = 0
#declare couchZ = 7

object {
  cushion
  
  translate <couchX+2, couchY+0.75, couchZ+0.5>
}

object {
  cushion
  
  translate <couchX+5, couchY+0.75, couchZ+0.5>
}

object {
  side
  
  translate <couchX, couchY+1, couchZ+0.8>
}

object {
  side
  
  translate <couchX+7, couchY+1, couchZ+0.8>
}

object {
  back
  
  translate <couchX+2, couchY+1.4, couchZ+2.3>
}

object {
  back
  
  translate <couchX+5, couchY+1.4, couchZ+2.3>
}

// END of COUCH //

// START of FISHTANK //

#declare tankframe = difference {
  box { <-1.85, 0, -1.15> <1.85, 2.5, 1.15> } 
  box { <-1.8, 0.1, -1.1> <1.8, 2.51, 1.1> }
  box { <-1.75, 0.1, -1.2> <1.75, 2.51, 1.2> }
  box { <-1.86, 0.1, -1.05> <1.86, 2.51, 1.05> }
}                                               

#declare tankglass = difference {
  box { <-1.8, 0.1, -1.1> <1.8, 2.5, 1.1> }
  box { <-1.78, 0.12, -1.08> <1.78, 2.51, 1.08> }
}         

#declare tanktop = prism {
  linear_sweep 
  linear_spline 
  0,        
  3.9,        
  8,          
  < -1.15, 0>, < -1.1,  0.3>, < -0.9, 0.3>, < -0.6,  0.4>, < 0.6,  0.4>, 
  < 0.9,  0.3>, < 1.1,  0.3>, < 1.15, -0>
}         

#declare tankfloor = height_field {
  gif "tankfloor.gif"
  smooth
  water_level 0.1
  scale <3.5, 0.4, 2.1>
}

#declare watertop = intersection {
  plane { y, 2.2 }
  box { <-1.78, 0.12, -1.08> <1.78, 2.51, 1.08> }
}

#declare h2ofilter = union {
  cylinder { < -1.74, 2.49, 1.04 > < -1.74, 2.46, 1.04 > 0.3 }
  cylinder { < -1.76, 2.46, 1.06 > < -1.76, 0.12, 1.06 > 0.1 }
}

#declare tower = difference {
  cylinder { < 0, 0, 0 > < 0, 0.8, 0 > 0.45 }
  box { < -0.1, 0.75, -0.6 > < 0.1, 0.81, 0.6 > }
  box { < -0.6, 0.75, -0.1 > < 0.6, 0.81, 0.1 > }
}

#declare gate = difference {
  box { < 0.4, 0, -0.2 > < 0.9, 0.6, 0.2 > }
  cylinder { < 0.65, 0.4, -0.21 > <0.65, 0.4, 0.21 > 0.15 }
  box { < 0.5, 0.4, -0.21 > < 0.8, 0.05, 0.21> }
}

#declare tankX = 8;  
#declare tankY = 2.6;
#declare tankZ = 8.8;

#declare tankRX = 0;
#declare tankRY = 1;
#declare tankRZ = 0;

object {
  tankframe
  
  texture { Cherry_Wood scale 0.05}

  rotate <tankRX, tankRY, tankRZ>
  translate <tankX, tankY, tankZ>
}        

object {
  tankglass
  
  texture { T_Glass4 }
  interior {I_Glass caustics 1}

  rotate <tankRX, tankRY, tankRZ>
  translate <tankX, tankY, tankZ>
}          

#declare Plastic_Finish = finish {
  ambient 0.1
  diffuse 0.65
  specular 0.85
  roughness 0.4
  reflection 0.2
  brilliance 1.5
}

object {
  tanktop
  
  normal { bumps 0.01 scale 0.05 }
  texture {
    pigment { rgb <0.2, 0.1, 0.6> }
    finish { Plastic_Finish }
  }
  
  rotate <tankRX-90, tankRY+90, tankRZ>
  translate <tankX+1.95, tankY+2.5, tankZ>
}   

object {
  tankfloor

  rotate <tankRX, tankRY, tankRZ>
  translate <tankX-1.8, tankY, tankZ-1>
}   

object {
  watertop
  
  texture { Water scale 1 }

  rotate <tankRX, tankRY, tankRZ>
  translate <tankX, tankY, tankZ>
}        

object {
  h2ofilter
  
  texture {
    pigment { rgb <0.2, 0.2, 0.2> }
    finish { Plastic_Finish }
  }

  rotate <tankRX, tankRY, tankRZ>
  translate <tankX, tankY, tankZ>
}        

light_source
{
  0*x 
  color rgb < 0.6, 0, 0.6 >  
  area_light
  <3.7, 0, 0> <0, 0, 2.3> 
  3, 3                
  adaptive 0          
  jitter              
  rotate <tankRX, tankRY, tankRZ>
  translate <tankX, tankY+2.49, tankZ>   
}

object {
  tower
  
  texture { White_Marble scale 1 }
  
  translate <tankX-0.8, tankY+0.12, tankZ+0.5>
}

object {
  gate
  
  texture { White_Marble scale 1 }
  
  translate <tankX-0.8, tankY+0.12, tankZ+0.5>
}

object {
  tower
  
  texture { White_Marble scale 1 }
  
  translate <tankX+0.5, tankY+0.12, tankZ+0.5> 
}

// END of FISHTANK //

// START of REMOTE //

#declare body =
  box { <0, 0, 0> <0.2, 0.05, 0.7> }

#declare button =
  box { <0.09, 0.05, 0.09> <0.11, 0.06, 0.11> }

#declare RemX = 4.9
#declare RemY = 2.75
#declare RemZ = 7
#declare RemRX = 0
#declare RemRY = 12
#declare RemRZ = 0
#declare boff = 0.04

object {
  body
  
  texture {
    pigment { rgb <0.2, 0.2, 0.2> }
    finish { Plastic_Finish }
  }
  
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}  

object {
  button
  
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button
  
  translate <boff, 0, 0>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button
  
  translate <-boff, 0, 0>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button
  
  translate <0, 0, boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <boff, 0, boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <-boff, 0, boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <0, 0, 2*boff>  
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <boff, 0, 2*boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <-boff, 0, 2*boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <0,0, 3*boff>  
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

object {
  button

  translate <boff, 0, 3*boff>
  rotate <RemRX, RemRY, RemRZ>
  translate <RemX, RemY, RemZ>
}

// END of REMOTE //

// START of TV //

#declare cabinet =
  box { <0, 0, 0> <3.5, 3, 2> }

#declare knob =
  cylinder { <3.3, 2.7, 2> <3.3, 2.7, 2.05> 0.1 }

#declare screen =
  box { <0.2, 0.4, 2> <2.8, 2.7, 2.1> }

#declare TVX = -2;
#declare TVY = 0;
#declare TVZ = -5;
#declare TVS = 1.5;

object {
  cabinet
  
  texture { Tan_Wood scale 0.2 }
  
  scale <TVS, TVS, 1>
  translate < TVX, TVY, TVZ >
}

object {
  knob
  
  texture { Chrome_Metal }
  
  scale <TVS, TVS, 1>
  translate < TVX, TVY, TVZ >
}

object {
  knob
  
  texture { Chrome_Metal }
  
  scale <TVS, TVS, 1>
  translate < TVX, TVY-0.4, TVZ >
}

object {
  screen
  
  texture {
    pigment {
      image_map
      {
        sys "simpsons.bmp" 
        map_type 0 
        interpolate 2 
      } 
      scale <2.6, 2.4, 0> 
      rotate <0, 180, 0>        
      translate <0.2, 0.4, 0>
    }   
    finish { ambient 1 }
  }

  scale <TVS, TVS, 1>
  translate < TVX, TVY, TVZ >
}

light_source
{
  0*x 
  color rgb <0.2, 0, 0.4>  
  area_light
  <2.6, 0, 0> <0, 2.3, 0> 
  3, 3                
  adaptive 0          
  jitter              
  translate <TVX+0.2, TVY+0.4, TVZ+2.11>   
}

// END of TV //

// START of FISH //

object {
  fish
  
  scale 0.1
  rotate <-90,90,0>
  translate <7.5,4,9>
}

object {
  fish
  
  scale 0.1
  rotate <-90,30,0>
  translate <6.8,3.2,8.3>
}

// END of FISH //

// START of BUBBLES //

#declare bubbles1 = union {
  sphere
  {
    <0.03, 0.05, 0.03> 
    0.02       
  }
  sphere
  {
    <0.02, 0.08, -0.01>
    0.02
  }
  sphere
  {
    <-0.01, 0.11, 0.02>
    0.02
  }
  sphere
  {
    <0.03, 0.14, -0.03>
    0.03
  }
  sphere
  {
    <0.02, 0.16, 0.02>
    0.03
  }
  sphere
  {
    <-0.03, 0.19, 0.01>
    0.03
  }
  sphere
  {
    <0.02, 0.21, 0.03>
    0.03
  }
  sphere
  {
    <0.01, 0.23, -0.01>
    0.03
  }
}

#declare bubbles2 = union {
  sphere
  {
    <0.03, 0.1, 0.03> 
    0.02       
  }
  sphere
  {
    <0.02, 0.16, -0.01>
    0.02
  }
  sphere
  {
    <-0.01, 0.22, 0.02>
    0.02
  }
  sphere
  {
    <0.03, 0.28, -0.03>
    0.03
  }
  sphere
  {
    <0.02, 0.32, 0.02>
    0.03
  }
  sphere
  {
    <-0.03, 0.38, 0.01>
    0.03
  }
  sphere
  {
    <0.02, 0.42, 0.03>
    0.03
  }
  sphere
  {
    <0.01, 0.46, -0.01>
    0.03
  }
}

object {
  bubbles1
  
  texture { T_Glass4 }
  interior {I_Glass caustics 1}
  
  scale 1.7
  translate <7.5,4,8.1>
}

object {
  bubbles1
  
  texture { T_Glass4 }
  interior {I_Glass caustics 1}
  
  scale 1.7
  rotate <0,135,0>
  translate <7.4,3.4,8> 
}

// END of BUBBLES //