//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Glass definition type 0.1a010616a include file
// By S.Nishimura
//**********************************************************************************


//**********************************************************************************
// General glass
#local Glass_base =
merge {
 torus{ 28, 2 translate 90*y }
 cone { 0,25, 90*y,30 }
 torus{ 23, 2 }
}
// CSG difference
#local Glass_org =
difference {
 object { Glass_base }
 object { Glass_base scale 0.98 translate 10*y }
 pigment { rgb 1 filter 1 }
 finish { ambient.1
          diffuse.1
          reflection.2
          specular 1
          roughness.001
          irid { 0.3 thickness 0.3 turbulence 0.8 } }
 interior { ior 1.25 fade_distance 50 fade_power 1 caustics 0.8 }
}
//
#local Glass_water =
difference {
 object { Glass_base scale 0.98 translate 10*y }
 cylinder { 70*y,(90+1/2+20+0.1)*y,30+0.1 }
 pigment { color rgbt < 0,1,0,1 > }
 interior { ior 1.02 }
}
//
#local Glass_strow =
cylinder { 0, 140*y, 2 hollow
 pigment { color rgbt < 1,1,1,0.3 > }
 finish { ambient 0.54 }
 rotate -14*z translate (10+0.5)*y
}
//
coordinate_color( 120, 0.8, 0.5, 1, 1 )
#declare General_glass =
union {
 object { Glass_org }
 object { Glass_water }
 object { Glass_strow }
 translate (1+1e-12)*y
}
//----------------------------------------------------------------------------------
//object { General_glass translate < 40,-60,30 > }
//**********************************************************************************
#macro Ellipse( Lw,Rr,Sy,Mr,Vy) //Vy=<Sy0,Ey0,Ay0>
#local Sp=Vy.x; #local Ep=Vy.y; #local Ap=Vy.z;
#while(Sp<Ep)
 #local Mt=tan(radians(Mr));
 #local A2=pow(Mt,2)+pow(Sy,2); #local B1=2*Mt*Sp; #local C0=pow(Sp,2)-pow(Rr*Sy,2);
 #local Px1=(-B1+sqrt(pow(B1,2)-4*A2*C0))/(2*A2); #local Py1=Mt*Px1+Sp;
 #local Px2=(-B1-sqrt(pow(B1,2)-4*A2*C0))/(2*A2); #local Py2=Mt*Px2+Sp;
 #local Pxc=(Px1+Px2)/2; #local Pyc=(Py1+Py2)/2;
 #local Rm=sqrt(pow(Px2-Px1,2)+pow(Py2-Py1,2))/2;
 #local Rx=sqrt(pow(Rr,2)-pow(Pyc/Sy,2)); #local Rz=sqrt(pow(Rx,2)-pow(Pxc,2));
 torus { 1,Lw scale <Rm,Rr,Rz> rotate Mr*z translate <Pxc,Pyc,0> }
#local Sp=Sp+Ap; #end
#end
//----------------------------------------------------------------------------------
// Tea glass
#local Rr=50; #local Sy=1.5;
#local Torus_seg = union { Ellipse( 0.02,Rr,Sy,30,<-50,30,10>) }
#local Ellip_seg =
difference {
 sphere { 0,Rr scale <1,Sy,1> }
 object { Torus_seg }
 object { Torus_seg rotate 180*y }
}
//
#local Pyt=0; #local Pyh=-10; #local Pyl=-60;
#local Pxh=sqrt(pow(Rr,2)-pow(Pyh/Sy,2)); #local Pxt=(1/Pxh)*(1/pow(Sy,2))*(pow(Rr*Sy,2)-Pyh*Pyt);
#local Pxl=sqrt(pow(Rr,2)-pow(Pyl/Sy,2)); #local Ml=-(Pxl/Pyl)*pow(Sy,2);
#local Syd=0.3; #local Pyd=-(Pxl/Ml)*pow(Syd,2); #local Rd=sqrt(pow(Pxl,2)+pow(Pyd/Syd,2));
//
#local Teaglass_base =
merge {
 cone { (Pyt+1)*y,Pxt,Pyh*1.01*y,Pxh }
 difference {
  sphere { 0,Rr scale <1,Sy,1> }
  cylinder { Pyh*y, Rr*Sy*1.01*y, Rr*1.01 }
  cylinder { Pyl*y,-Rr*Sy*1.01*y,Pxl*1.01 }
 }
 sphere { 0,Rd scale <1,Syd,1> translate (Pyl-Pyd)*y }
}
#local Tea_water =
difference {
 object { Teaglass_base }
 cylinder { -20*y, (Pyt+1.1)*y, Pxt*1.01 }
 scale 0.968
}
//
#local Teaglass_seg =
difference {
 merge {
 cone { Pyt*y,Pxt,Pyh*y,Pxh }
  difference {
  object { Ellip_seg }
  cylinder { Pyh*y, Rr*Sy*1.01*y, Rr*1.01 }
  cylinder { Pyl*y,-Rr*Sy*1.01*y,Pxl*1.01 }
  }
 sphere { 0,Rd scale <1,Syd,1> translate (Pyl-Pyd)*y }
  difference {
  cylinder { Pyl*y,(Pyl-5)*y,Pxl*0.9 }
  cylinder { Pyl*1.01*y,(Pyl-5)*1.01*y,Pxl*0.8 }
  }
 }
 object { Teaglass_base scale 0.97 }
}
//
#local Glass_saucer =
union {
 torus { 35+10, 2 translate 12*y }
 #local Ei=24; #local Si=0; #while(Si<Ei)
 cylinder { 0, sqrt(pow(10,2)+pow(12,2))*y, 1 rotate -degrees(atan2(10,12))*z translate 35*x rotate 360*Si/Ei*y }
 #local Si=Si+1; #end
 cylinder { 0,2*y, 35 }
}
//
coordinate_color( 150, 0.4, 0.9, 3, 1 )
#local T_glass =
 texture {
  pigment { color rgbf < R1, G1, B1, 0.75 > }
  finish { ambient 0.1 diffuse 0.1 reflection 0.25 specular 1.0 roughness 0.001 }
}
coordinate_color( 60, 1, 0.5, 1, 2 )
#local T_water =
texture {
 pigment { color rgbf <R2,G2,B2,0.7> }
 normal { ripples 0.75 frequency 10 }
}
coordinate_color( 0, 0.8, 0.8, 1, 3 )
#local T_saucer =
texture {
 pigment { color rgbt <R3,G3,B3,0.6> }
 finish { ambient 0.3 }
}
//
#declare Tea_glass =
union {
 object { Teaglass_seg texture { T_glass } interior { ior 1.45 } }
 object { Tea_water texture { T_water scale 80 } interior { ior 1.02 caustics 0.04 } }
 object { Glass_saucer texture { T_saucer } translate (Pyl-5-2)*y }
 translate -(Pyl-5-2+1e-12)*y
}
//----------------------------------------------------------------------------------
//object { Tea_glass scale 0.7 translate < -40,-60,30 > }
//**********************************************************************************