//**********************************************************************************
// Persistence Of Vision raytracer version 3.5 beta
// Grass generate type 0.2r000307a include file 
// By S.Nishimura 
//**********************************************************************************


//**********************************************************************************
#macro Grass_gen(Grass_length,Grass_width,Grass_slop,Grass_count)
//#local Grass_length=  4;  // radius
#local Grass_scale = 3;     // Grass height = Grass_length*Grass_scale/2
//#local Grass_width = 10;  // degrees 
//#local Grass_slop  = 30;  // degrees
//#local Grass_count = 8;   // Grass volume
// texture grass
#ifndef(T_grass) 
 #local T_grass = 
  texture {
   pigment { gradient z
             color_map { [ 0.0 rgb < 0, 1.2, 0 > ]
                         [ 0.5 rgb < 0, 0.8, 0 > ]
                         [ 1.0 rgb < 0, 0.4, 0 > ] }
             scale Grass_length/10 }  // 0.4
  }
#end
// definition
#local Grass_seg =
object { 
 sphere { 0, Grass_length texture { T_grass } scale < Grass_scale, Grass_scale/2 , 1 > }
 clipped_by { plane { z, 0 } rotate (Grass_width)*x}
 clipped_by { plane { z, 0 } rotate (180-Grass_width)*x }
 translate < Grass_length*Grass_scale, 0, 0 >
 rotate < 0, 15, Grass_slop >
}
// generate
#local Ei=Grass_count;
#local Si=0; #while(Si<Ei) object { Grass_seg rotate 360*Si/Ei*y } #local Si=Si+1; #end
//
#end // macro end
//----------------------------------------------------------------------------------
//union { Grass_gen(4,10,60,6) rotate 40*y scale 15 translate < 0, -180, 0 > }
//**********************************************************************************
#macro Arrange_y(Pv,Dis,Qua,Area,Gap)
//
#local R_dis=Dis;        // start distans
#local Qua_end=Qua;      // quantity
#local Area_end=Area;    // area level
#local Gap_direc=Gap;    // gap
#local Off_x=Pv.x;       // Trans_x offset
#local Off_y=Pv.y;       // Trans_y offset (Ground_level)
#local Off_z=Pv.z;       // Trans_z offset
//
#local Area_cnt = 0;
#while ( Area_cnt < Area_end )
#local Qua_cnt = 0;
#while ( Qua_cnt < Qua_end )
 #local Trans_x = R_dis*cos(radians(Gap_direc))+ Off_x;
 #local Trans_y = Off_y;
 #local Trans_z = R_dis*sin(radians(Gap_direc)) + Off_z;
 object { Arrange_seg rotate 40*y translate < Trans_x, Trans_y, Trans_z > }
 #local Qua_cnt = Qua_cnt + 1;
 #local Gap_direc = Gap_direc + 360/Qua_end;
#end
#local Area_cnt = Area_cnt + 1;
#local R_dis = R_dis + R_dis*sqrt(Area_cnt);
#local Gap_direc = Gap_direc + 360/Qua_end/Area_end;
#end
//
#end // macro end
//----------------------------------------------------------------------------------
//#local Arrange_seg = union { Grass_gen(6,10,30,8) rotate 10*y }
//union { Arrange_y(<0,-15,0>,16,6,2,10) scale 8 }
//**********************************************************************************